/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.InFixToPostFix;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.rule.RuleFactory;
import org.apache.log4j.spi.LoggingEvent;

public class ExpressionRule
extends AbstractRule {
    static final long serialVersionUID = 5809121703146893729L;
    private static final InFixToPostFix convertor = new InFixToPostFix();
    private static final PostFixExpressionCompiler compiler = new PostFixExpressionCompiler();
    private final Rule rule;

    private ExpressionRule(Rule rule) {
        this.rule = rule;
    }

    public static Rule getRule(String expression) {
        return ExpressionRule.getRule(expression, false);
    }

    public static Rule getRule(String expression, boolean isPostFix) {
        if (!isPostFix) {
            expression = convertor.convert(expression);
        }
        return new ExpressionRule(compiler.compileExpression(expression));
    }

    public boolean evaluate(LoggingEvent event) {
        return this.rule.evaluate(event);
    }

    public String toString() {
        return this.rule.toString();
    }

    static class PostFixExpressionCompiler {
        PostFixExpressionCompiler() {
        }

        Rule compileExpression(String expression) {
            RuleFactory factory = RuleFactory.getInstance();
            Stack<Object> stack = new Stack<Object>();
            StringTokenizer tokenizer = new StringTokenizer(expression);
            while (tokenizer.hasMoreTokens()) {
                boolean inText;
                String token = tokenizer.nextToken();
                if (token.startsWith("'") && token.endsWith("'") && token.length() > 2) {
                    token = token.substring(1, token.length() - 1);
                }
                if (token.startsWith("'") && token.endsWith("'") && token.length() == 2) {
                    token = "";
                }
                if (inText = token.startsWith("'")) {
                    token = token.substring(1);
                    while (inText && tokenizer.hasMoreTokens()) {
                        boolean bl = inText = !(token = token + " " + tokenizer.nextToken()).endsWith("'");
                    }
                    if (token.length() > 0) {
                        token = token.substring(0, token.length() - 1);
                    }
                }
                if (factory.isRule(token)) {
                    Rule r = factory.getRule(token, stack);
                    stack.push(r);
                    continue;
                }
                if (token.length() <= 0) continue;
                stack.push(token);
            }
            if (stack.size() == 1 && !(stack.peek() instanceof Rule)) {
                Object o = stack.pop();
                stack.push("MSG");
                stack.push(o);
                return factory.getRule("~=", stack);
            }
            if (stack.size() != 1 || !(stack.peek() instanceof Rule)) {
                throw new IllegalArgumentException("invalid expression: " + expression);
            }
            return (Rule)stack.pop();
        }
    }
}

