/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.ULogger;
import org.apache.log4j.pattern.CachedDateFormat;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public final class DatePatternConverter
extends LoggingEventPatternConverter {
    private final CachedDateFormat df;

    private DatePatternConverter(String[] options, ULogger logger) {
        super("Date", "date");
        String patternOption = options == null || options.length == 0 ? null : options[0];
        String pattern = patternOption == null || patternOption.equalsIgnoreCase("ISO8601") ? "yyyy-MM-dd HH:mm:ss,SSS" : (patternOption.equalsIgnoreCase("ABSOLUTE") ? "HH:mm:ss,SSS" : (patternOption.equalsIgnoreCase("DATE") ? "dd MMM yyyy HH:mm:ss,SSS" : patternOption));
        int maximumCacheValidity = 1000;
        SimpleDateFormat simpleFormat = null;
        try {
            simpleFormat = new SimpleDateFormat(pattern);
            maximumCacheValidity = CachedDateFormat.getMaximumCacheValidity(pattern);
        }
        catch (IllegalArgumentException e) {
            if (logger != null) {
                logger.warn((Object)("Could not instantiate SimpleDateFormat with pattern " + patternOption), e);
            }
            simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        }
        if (options != null && options.length > 1) {
            TimeZone tz = TimeZone.getTimeZone(options[1]);
            simpleFormat.setTimeZone(tz);
        }
        this.df = new CachedDateFormat(simpleFormat, maximumCacheValidity);
    }

    public static DatePatternConverter newInstance(String[] options, ULogger logger) {
        return new DatePatternConverter(options, logger);
    }

    public void format(LoggingEvent event, StringBuffer output) {
        this.df.format(event.getTimeStamp(), output);
    }

    public void format(Object obj, StringBuffer output) {
        if (obj instanceof Date) {
            this.format((Date)obj, output);
        }
        super.format(obj, output);
    }

    public void format(Date date, StringBuffer toAppendTo) {
        this.df.format(date.getTime(), toAppendTo);
    }
}

