/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableInformation;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreGlobal;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThrowableInformationConverter
extends ThrowableHandlingConverter {
    int lengthOption;
    List<EventEvaluator> evaluatorList = null;
    final int MAX_ERROR_COUNT = 4;
    int errorCount = 0;

    public void start() {
        String lengthStr = this.getFirstOption();
        if (lengthStr == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(lengthStr = lengthStr.toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(lengthStr)) {
            this.lengthOption = 2;
        } else {
            try {
                this.lengthOption = Integer.parseInt(lengthStr) + 1;
            }
            catch (NumberFormatException nfe) {
                this.addError("Could not parser [" + lengthStr + " as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            int optionListSize = optionList.size();
            int i = 1;
            while (i < optionListSize) {
                String evaluatorStr = (String)optionList.get(i);
                Context context = this.getContext();
                Map evaluatorMap = (Map)context.getObject("EVALUATOR_MAP");
                EventEvaluator ee = (EventEvaluator)evaluatorMap.get(evaluatorStr);
                this.addEvaluator(ee);
                ++i;
            }
        }
        super.start();
    }

    private void addEvaluator(EventEvaluator ee) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator>();
        }
        this.evaluatorList.add(ee);
    }

    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    public String convert(LoggingEvent event) {
        int length;
        StringBuffer buf = new StringBuffer(32);
        ThrowableInformation information = event.getThrowableInformation();
        if (information == null) {
            return "";
        }
        String[] stringRep = information.getThrowableStrRep();
        int n = length = this.lengthOption > stringRep.length ? stringRep.length : this.lengthOption;
        if (this.evaluatorList != null) {
            boolean printStack = true;
            int i = 0;
            while (i < this.evaluatorList.size()) {
                block12: {
                    EventEvaluator ee = this.evaluatorList.get(i);
                    try {
                        if (ee.evaluate((Object)event)) {
                            printStack = false;
                            break;
                        }
                    }
                    catch (EvaluationException eex) {
                        ++this.errorCount;
                        if (this.errorCount < 4) {
                            this.addError("Exception thrown for evaluator named [" + ee.getName() + "]", eex);
                        }
                        if (this.errorCount != 4) break block12;
                        ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + ee.getName() + "].", (Object)this, (Throwable)eex);
                        errorStatus.add((Status)new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", (Object)this));
                        this.addStatus((Status)errorStatus);
                    }
                }
                ++i;
            }
            if (!printStack) {
                return "";
            }
        }
        buf.append(stringRep[0]).append(CoreGlobal.LINE_SEPARATOR);
        int i = 1;
        while (i < length) {
            String string = stringRep[i];
            if (!string.startsWith("Caused by: ")) {
                if (Character.isDigit(string.charAt(0))) {
                    buf.append("\t... ");
                } else {
                    buf.append("\tat ");
                }
            }
            buf.append(string).append(CoreGlobal.LINE_SEPARATOR);
            ++i;
        }
        return buf.toString();
    }
}

