/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Header;
import net.sourceforge.cobertura.util.IOUtil;

public class SummaryXMLReport {
    private final PrintWriter pw;
    private int indent = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SummaryXMLReport(ProjectData projectData, File destinationDir, FileFinder finder, ComplexityCalculator complexity) throws IOException {
        File file = new File(destinationDir, "coverage-summary.xml");
        this.pw = IOUtil.getPrintWriter(file);
        try {
            this.println("<?xml version=\"1.0\"?>");
            this.println("<!DOCTYPE coverage SYSTEM \"http://cobertura.sourceforge.net/xml/coverage-04.dtd\">");
            this.println("");
            double ccn = complexity.getCCNForProject(projectData);
            int numLinesCovered = projectData.getNumberOfCoveredLines();
            int numLinesValid = projectData.getNumberOfValidLines();
            int numBranchesCovered = projectData.getNumberOfCoveredBranches();
            int numBranchesValid = projectData.getNumberOfValidBranches();
            this.println("<coverage line-rate=\"" + projectData.getLineCoverageRate() + "\" branch-rate=\"" + projectData.getBranchCoverageRate() + "\" lines-covered=\"" + numLinesCovered + "\" lines-valid=\"" + numLinesValid + "\" branches-covered=\"" + numBranchesCovered + "\" branches-valid=\"" + numBranchesValid + "\" complexity=\"" + ccn + "\" version=\"" + Header.version() + "\" timestamp=\"" + new Date().getTime() + "\">");
            this.increaseIndentation();
            this.println("<packages />");
            this.decreaseIndentation();
            this.println("</coverage>");
        }
        finally {
            this.pw.close();
        }
    }

    void increaseIndentation() {
        ++this.indent;
    }

    void decreaseIndentation() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    private void println(String ln) {
        this.indent();
        this.pw.println(ln);
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.pw.print("\t");
        }
    }
}

