/*
Copyright 2018 Google, Inc. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package cmd

import (
	"testing"
)

var analyzeArgNumTests = []testpair{
	{[]string{}, false},
	{[]string{"one"}, true},
	{[]string{"one", "two"}, false},
}

func TestAnalyzeArgNum(t *testing.T) {
	for _, test := range analyzeArgNumTests {
		err := checkAnalyzeArgNum(test.input)
		if (err == nil) != test.shouldError {
			if test.shouldError {
				t.Errorf("Expected error but got none")
			} else {
				t.Errorf("Got unexpected error: %s", err)
			}
		}
	}
}
