# secvarctl with Guest backend

It is supporting nine predinfed variables

1. PK
2. KEK
3. db
4. dbx
5. grubdb
6. grubdbx
7. moduledb
8. trustedcadb
9. sbat

Updating of guest secure variables requires a specific format for success. If updating the PK, KEK, an x509 public key must be contained in an EFI Signature List (ESL). If updating the db, grubdb, an x509 public key or the binary hash that is to be allowed must be contained in an ESL. If updating the dbx and grubdbx, an x509 public key or the binary hash or an x509 public key hash that is to be banned must be contained in an ESL. If updating the moduledb and trustedcadb, an x509 public key must be contained in an ESL. If updating the sbat, secure boot advanced targeting (SBAT) generation number must be contained in an ESL. Then, an append header and a PKCS7 structure must be generated by signing the new ESL with the private key of a secure variable that has authority over the variable being updated (Example: if updating the db, the new ESL must be signed by either the KEK or PK). Finally, the new ESL must be appended to the generated PKCS7 and the whole structure is then placed into what is called an Auth file (this adds extra header information, timestamp and content size). When the Auth file is generated, the resulting file is ready to be submited. Once submitted, the update is only applied when the POWER machine is rebooted. 

ESL file format is:


            |-----------------------------------|
            |                                   |
            |          ESL Info                 |
            |                                   |
            |   |-------------------------------|
            |   |     ESL Header                |
            |   |      (44 byte)                |
            |   |-------------------------------|
            |   |      ESL Data                 |
            |-----------------------------------|


auth file data format is:


            |-----------------------------------|
            |                                   |
            |          Append Header            |
            |           (8 bytes)               |
            |-----------------------------------|
            |                                   |
            |          Auth Info                |
            |                                   |
            |   |-------------------------------|
            |   |      Auth Header              |
            |   |       (40 byte)               |
            |   |-------------------------------|
            |   |      PKCS7 data               |
            |---|-------------------------------|
            |                                   |
            |          ESL Info                 |
            |                                   |
            |   |-------------------------------|
            |   |     ESL Header                |
            |   |      (44 byte)                |
            |   |-------------------------------|
            |   |      ESL Data                 |
            |-----------------------------------|


## USAGE:    
  It has 5 main commands   
    `./secvarctl -m guest read [options] [variable]`    
    `./secvarctl -m guest write [options] <variable> <file>`    
    `./secvarctl -m guest validate [options] [fileType] <file>`  
    `./secvarctl -m guest verify [options] -u {update Variables}`  
    `./secvarctl -m guest generate <inputFormat>:<outputFormat> [OPTIONS] -i <inputFile> -o <outputFile` 

## SUB COMMAND USAGE:
    
    READ:
                  ./secvarctl -m guest read [options] <file>
	OPTIONS:
		--usage 
		--help
		-r , raw output
		-a <input.auth> , read from auth file
		-c <input.cert> , read from x509 cert file
		-e <input.esl> , read from ESL file
		-p </path/to/vars/> , read from path (guest secure boot variable subdirectories each with files {"data", "size"} expected)
		-n <varName> , name of secure boot variable, used when read specific variable from path
		
       The read command will read from the guest secure boot variable directory and print out information on their current contents.
       By default, the program assumes the data is an EFI Signature List and prints the contents in human readable form.  
       To print the raw data, use "-r".
       The default guest secure boot variable directiory is "/sys/firmware/secvar/vars/"
       To specify a path to the variables, use "-p <variable path>".Expected guest secure boot variable subdirectorys with contained data file "<variable name>/data"
       If no variable name is given, the program will try to print the data for any variable named one of the nine predefined guest secure boot variables	
       
    WRITE:
                  ./secvarctl -m guest write [options] <variable> <file>
	REQUIRED:
		<variable> , one of the guest secure boot variable
		<file> , an auth file
	OPTIONS:
		--usage 
		--help
		-v , verbose output
		-f , force update, no validation
		-p </path/to/vars/> , write to file in path (guest secure boot variable subdirectories each with files "update" file expected)
		
       The write command will update the given variable's key value. 
       The new key value is expected to be contained in a Signed Authenticated file signed with a variable with authority over the update variable.
       By default, the write function will validate the format of the auth file. If it is a success the file will be written to the variables "update" file. 
       NOTE: This command does not guarantee that the update will be successful upon reboot (since no signature checks were performed), use the verify command to validate both format and content. 
       The "update" file is expected to be in "<pathToVars>/<variable>/update".
       The "-p <pathToVars>" option is the location of the guest secure boot variable subdirectories which contain an "update" file, the default path is "/sys/firmware/secvar/vars/" 
       The "-v" option prints process info 
       The "-f" option skips the validation step and immediadetly writes content of "<file>" to "<variable>/update"
       The <variable> requirement is expected to be one of the guest secure boot variable
       
    VALIDATE:
                 ./secvarctl -m guest validate [options] <file type> <file> 
	REQUIRED:
		<file> , the input file, assumed to be auth file if not specified
		-e <file> , ESL
		-p <file> , PKCS7/Signed Data
		-c <file> , DER or PEM certificate
		-a <file> , DEFAULT,  a signed authenticated file containg a PKCS7 and appended ESL 
	OPTIONS:
		--usage
		--help
		-v , verbose output
	
         The validate command will print "SUCCESS" or "FAILURE" depending if the format and basic content requirements are met for the given file
        The default type of "<file>" is an auth file containing a PKCS7/Signed Data and attatched esl.
        ALL KEYS ARE EXPECTED TO BE SHA-256 and RSA 2048 or SHA-256 and RSA 4096
	THIS FUNCTION DOES NOT DO ANY COMPARISON AGAINST CURRENT KEYS (use verify for that)
        For extra process and file content information use "-v" for verbose
        To validate a PKCS7 (expected DER), use "-p <file>"
        To validate an Efi Signature List (ESL), use "-e <file>"
        To validate a certificate (x509 in DER or PEM format), use "-c <file>"
	
    VERIFY:
    		./secvarctl -m guest verify [options] -u {Update Variables}
	REQUIRED:
		-u {Update Variables} , the updates to be run
	OPTIONAL:
		--usage 
		--help
		-v , verbose output
		-p </path/to/vars/> , read from path (guest secure boot variable subdirectories each with files {"data", "size"} expected)
		-w , write updates if verified
		-c {Current Variables}	
	{Update Variables}:
		Format: <var_name 1> <var_auth_file 1>...<var_name N> <var_auth_file N>
		Where <varname> is one of the guest secure boot variable name and <file> is an auth file
		Updates are verified in the order they are submitted
	{Current Variables}:
		Format:<var_name 1> <var_ESL_file 1>...<var_name N> <var_ESL_file N>
		Where <varname> is one of the guest secure boot variable name and <file> is an esl file
	
	The verify command will print "SUCCESS" or "FAILURE" if the update files are correctly signed by the current variables or not.
	The "-v" command will give extra information on process information.
	All given update files are expected to be a signed PKCS7/Signed Data authenticated file containing an attatched new ESL. 
	The updates should be signed according to the correct hierarchy rules:
			PK can sign all other keys, (including itself),
			KEK can sign db and dbx, grubdb, grubdbx, sbat, moduledb, trustedcadb cannot sign PK
			db and dbx, grubdb, grubdbx, sbat, moduledb, trustedcadb cannot sign KEK or PK
	All updates have their format validated before any verification is done.
	The "-p <pathToVars>" option is the location of current variables in the guest secure boot variable subdirectories which contain the {"update, "data", "size"} files, the default path is "/sys/firmware/secvar/vars/"
	The "-c {Current Variables}" option is used to specify the current variables manually. See above for correct format of {Current variables}.
	If the "-w" option is given then, if the verification passes, the updates will be commited to the "update" file of the given variable
      

    GENERATE:
    		./secvarctl -m guest generate <inputFormat>:<outputFormat> [OPTIONS] -i <inputFile> -o <outputFile>
    REQUIRED:
       <inputFormat>:<outputFormat> , the type of input file and type of output file seperated by a colon
       -i <input> , input file formatted according to <inputFormat>
	   -o <output> , output file formatted according to <ouputFormat>
	OPTIONAL:
		--usage
		--help
		-v , verbose, gives process info
		-a , use when generating and auth file to set the append flag
		-n <varName> , name of secure boot variable, used when generating an auth file, PKCS7, or hash file
		-f force generation, skips validation of input file, assumes format to be correct
		-t <time> , where <time> is of the format described below. creates a custom timestamp used when generating an auth or PKCS7 file, if not given then current time is used, all times are in UTC
                    format of <time> = 'YYYY-MM-DDThh:mm:ss' where:
                        - 'YYYY' four-digit year
                        - 'MM' two-digit month (01=January, etc.)
                        - 'DD' two-digit day of month (01 through 31)
                        - 'T' appears literally
                        - 'hh' two digits of hour (00 through 23) (am/pm NOT allowed)
                        - 'mm' two digits of minute (00 through 59)
                        - 'ss' two digits of second (00 through 59)
		-h <hashAlg> hash function, used when output or input format is [h]ash, current <hashAlg> are : {'SHA256', 'SHA224', 'SHA1', 'SHA384', 'SHA512'}
		-k <privKey> , private key, used when generating [p]kcs7 or [a]uth file
		-c <certFile> , x509 certificate (PEM), used when generating [p]kcs7 or [a]uth file
		reset , generates a valid variable reset file, replaces <inputFormat>:<outputFormat>. 
			This file is just an auth file with an empty ESL. Required arguments are output file, signer crt/key pair and variable name. 
			No input file required.
        -s <sigFile> raw signature file, replaces -k <privKey> argument when user does not 
            have direct access to private key. User can use their signing framework to generate the signature externally. The file to be signed should be the output of 'secvarctl -m guest generate c:x ...' both commands should use the same -n <varName> and -t <timestamp> arguments


	<inputFormat>:
		[h]ash , A file containing only hashed data, use -h <hashAlg> to specifify the hash function used (default SHA256) 
		[c]ert , An x509 certificate, RSA2048 or RSA4096 and SHA256 ONLY
		[e]sl , An EFI Signature List
		[p]kcs7 , A PKCS7 file containing signed data
		[a]uth , A signed authensticated file containing a PKCS7 and the new data 
		[f]ile , Generic file, depending on outputFormat follows steps: file->hash->ESL->PKCS7->Auth,  Warning: no format validation will be done
	<outputFormat>:
		[h]ash , A file containing only hashed data, use -h <hashAlg> to specifify the hash function used (default SHA256) 
		[e]sl , An EFI Signature List
		[p]kcs7 , a PKCS7 file containing signed data, must specify secure variable name, public and private keys
		[a]uth , A signed authenticated file containing a PKCS7 and the new data, must specify public and private keys secure variable name
        [x] , A presigned digest file containing only the hash of the new data in ESL format with extra metadata. This format need only be used when the user does not have access to private keys for signing and must send the digest to be signed through an external framework.  

		The generate command is used to generate all the types of files that will be used in the secure variable management process.
		The file formats that can be generated from a certificate is a hash, ESL, PKCS7 and auth file with commands 'c:h', "c:e", "c:p" and "c:a" respectively. 
		All input files are prevalidated to be correctly formatted according to the specified input format, to skip prevalidation use "-f".
		A hash function can be specified with -h <hashAlg>, this is useful when generating a hash or when the input file contains a hash. 
		The "-h <hashAlg>" will not effect the digest algorithm used when generating signed data for a PKCS7 (always SHA256). 
		When generating a signed file (PKCS7 or auth), a public and private key will be needed for signing. 
		A PKCS7 and Auth file can be signed with several signers by adding more ' -k <privKey> -c <cert>' pairs. 
		Additionaly, when generating an Auth file the secure variable name must be given as -n <varName> because it is included in the  message digest. 
		When using the input type '[f]ile' it will be assumed to be a text file and if output file is '[e]sl', '[p]kcs7' or '[a]uth' it will be hashed according to <hashAlg> (default SHA256). 
		To create a variable reset file (one that will remove the current contents of a variable), replace '<inputFormat>:<outputFormat>' with 'reset' and
		supply a variable name, public and private signer files and an output file with '-n <varName> -k <privKey> -c <crtFile> -o <outFile>'
		GENERATION OF PKCS7 AND AUTH FILES ARE IN EXPERIMENTAL DEVELEPOMENT PHASE. THEY HAVE NOT BEEN THOROUGHLY TESTED YET.
      
