# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdksas.endpoint import endpoint_data

class UpdateHoneypotProbeRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Sas', '2018-12-03', 'UpdateHoneypotProbe','sas')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_Ping(self): # Boolean
		return self.get_query_params().get('Ping')

	def set_Ping(self, Ping):  # Boolean
		self.add_query_param('Ping', Ping)
	def get_ProbeId(self): # String
		return self.get_query_params().get('ProbeId')

	def set_ProbeId(self, ProbeId):  # String
		self.add_query_param('ProbeId', ProbeId)
	def get_ServiceIpLists(self): # RepeatList
		return self.get_query_params().get('ServiceIpList')

	def set_ServiceIpLists(self, ServiceIpList):  # RepeatList
		for depth1 in range(len(ServiceIpList)):
			self.add_query_param('ServiceIpList.' + str(depth1 + 1), ServiceIpList[depth1])
	def get_Lang(self): # String
		return self.get_query_params().get('Lang')

	def set_Lang(self, Lang):  # String
		self.add_query_param('Lang', Lang)
	def get_Arp(self): # Boolean
		return self.get_query_params().get('Arp')

	def set_Arp(self, Arp):  # Boolean
		self.add_query_param('Arp', Arp)
	def get_DisplayName(self): # String
		return self.get_query_params().get('DisplayName')

	def set_DisplayName(self, DisplayName):  # String
		self.add_query_param('DisplayName', DisplayName)
