# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkconfig.endpoint import endpoint_data

class CopyCompliancePacksRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Config', '2020-09-07', 'CopyCompliancePacks')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_DesAggregatorIds(self): # String
		return self.get_query_params().get('DesAggregatorIds')

	def set_DesAggregatorIds(self, DesAggregatorIds):  # String
		self.add_query_param('DesAggregatorIds', DesAggregatorIds)
	def get_SrcAggregatorId(self): # String
		return self.get_query_params().get('SrcAggregatorId')

	def set_SrcAggregatorId(self, SrcAggregatorId):  # String
		self.add_query_param('SrcAggregatorId', SrcAggregatorId)
	def get_SrcCompliancePackIds(self): # String
		return self.get_query_params().get('SrcCompliancePackIds')

	def set_SrcCompliancePackIds(self, SrcCompliancePackIds):  # String
		self.add_query_param('SrcCompliancePackIds', SrcCompliancePackIds)
