searchData={"items":[{"type":"module","title":"EEx","doc":"EEx stands for Embedded Elixir.\n\nEmbedded Elixir allows you to embed Elixir code inside a string\nin a robust way.\n\n    iex> EEx.eval_string(\"foo  \", bar: \"baz\")\n    \"foo baz\"\n\nThis module provides three main APIs for you to use:\n\n  1. Evaluate a string (`eval_string/3`) or a file (`eval_file/3`)\n     directly. This is the simplest API to use but also the\n     slowest, since the code is evaluated at runtime and not precompiled.\n\n  2. Define a function from a string (`function_from_string/5`)\n     or a file (`function_from_file/5`). This allows you to embed\n     the template as a function inside a module which will then\n     be compiled. This is the preferred API if you have access\n     to the template at compilation time.\n\n  3. Compile a string (`compile_string/2`) or a file (`compile_file/2`)\n     into Elixir syntax tree. This is the API used by both functions\n     above and is available to you if you want to provide your own\n     ways of handling the compiled template.\n\nThe APIs above support several options, documented below. You may\nalso pass an engine which customizes how the EEx code is compiled.","ref":"EEx.html"},{"type":"module","title":"Options - EEx","doc":"All functions in this module, unless otherwise noted, accept EEx-related\noptions. They are:\n\n  * `:file` - the file to be used in the template. Defaults to the given\n    file the template is read from or to `\"nofile\"` when compiling from a string.\n\n  * `:line` - the line to be used as the template start. Defaults to `1`.\n\n  * `:indentation` - (since v1.11.0) an integer added to the column after every\n    new line. Defaults to `0`.\n\n  * `:engine` - the EEx engine to be used for compilation. Defaults to `EEx.SmartEngine`.\n\n  * `:trim` - if `true`, trims whitespace left and right of quotation as\n    long as at least one newline is present. All subsequent newlines and\n    spaces are removed but one newline is retained. Defaults to `false`.\n\n  * `:parser_options` - (since: 1.13.0) allow customizing the parsed code\n    that is generated. See `Code.string_to_quoted/2` for available options.\n    Note that the options `:file`, `:line` and `:column` are ignored if\n    passed in. Defaults to `Code.get_compiler_option(:parser_options)`\n    (which defaults to `[]` if not set).","ref":"EEx.html#module-options"},{"type":"module","title":"Tags - EEx","doc":"EEx supports multiple tags, declared below:\n\n     \n     \n     \n     \n\nEEx supports additional tags, that may be used by some engines,\nbut they do not have a meaning by default:","ref":"EEx.html#module-tags"},{"type":"module","title":"Engine - EEx","doc":"EEx has the concept of engines which allows you to modify or\ntransform the code extracted from the given string or file.\n\nBy default, `EEx` uses the `EEx.SmartEngine` that provides some\nconveniences on top of the simple `EEx.Engine`.\n\n### `EEx.SmartEngine`\n\nThe smart engine uses EEx default rules and adds the `@` construct\nfor reading template assigns:\n\n    iex> EEx.eval_string(\" \", assigns: [foo: 1])\n    \"1\"\n\nIn other words, ` ` translates to:\n\n     \n\nThe `assigns` extension is useful when the number of variables\nrequired by the template is not specified at compilation time.","ref":"EEx.html#module-engine"},{"type":"function","title":"EEx.compile_file/2","doc":"Gets a `filename` and generates a quoted expression\nthat can be evaluated by Elixir or compiled to a function.\n\nThis is useful if you want to compile a EEx template into code and inject\nthat code somewhere or evaluate it at runtime.\n\nThe generated quoted code will use variables defined in the template that\nwill be taken from the context where the code is evaluated. If you\nhave a template such as ` `, then the returned quoted code\nwill use the `a` and `b` variables in the context where it's evaluated. See\nexamples below.\n\nThe supported `options` are described [in the module docs](#module-options).","ref":"EEx.html#compile_file/2"},{"type":"function","title":"Examples - EEx.compile_file/2","doc":"# sample.eex\n     \n\n    # In code:\n    quoted = EEx.compile_file(\"sample.eex\")\n    {result, _bindings} = Code.eval_quoted(quoted, a: 1, b: 2)\n    result\n    #=> \"3\"","ref":"EEx.html#compile_file/2-examples"},{"type":"function","title":"EEx.compile_string/2","doc":"Gets a string `source` and generates a quoted expression\nthat can be evaluated by Elixir or compiled to a function.\n\nThis is useful if you want to compile a EEx template into code and inject\nthat code somewhere or evaluate it at runtime.\n\nThe generated quoted code will use variables defined in the template that\nwill be taken from the context where the code is evaluated. If you\nhave a template such as ` `, then the returned quoted code\nwill use the `a` and `b` variables in the context where it's evaluated. See\nexamples below.\n\nThe supported `options` are described [in the module docs](#module-options).","ref":"EEx.html#compile_string/2"},{"type":"function","title":"Examples - EEx.compile_string/2","doc":"iex> quoted = EEx.compile_string(\" \")\n    iex> {result, _bindings} = Code.eval_quoted(quoted, a: 1, b: 2)\n    iex> result\n    \"3\"","ref":"EEx.html#compile_string/2-examples"},{"type":"function","title":"EEx.eval_file/3","doc":"Gets a `filename` and evaluate the values using the `bindings`.\n\nThe supported `options` are described [in the module docs](#module-options).","ref":"EEx.html#eval_file/3"},{"type":"function","title":"Examples - EEx.eval_file/3","doc":"# sample.eex\n    foo  \n\n    # IEx\n    EEx.eval_file(\"sample.eex\", bar: \"baz\")\n    #=> \"foo baz\"","ref":"EEx.html#eval_file/3-examples"},{"type":"function","title":"EEx.eval_string/3","doc":"Gets a string `source` and evaluate the values using the `bindings`.\n\nThe supported `options` are described [in the module docs](#module-options).","ref":"EEx.html#eval_string/3"},{"type":"function","title":"Examples - EEx.eval_string/3","doc":"iex> EEx.eval_string(\"foo  \", bar: \"baz\")\n    \"foo baz\"","ref":"EEx.html#eval_string/3-examples"},{"type":"macro","title":"EEx.function_from_file/5","doc":"Generates a function definition from the file contents.\n\nThe first argument is the kind of the generated function (`:def` or `:defp`).\nThe `name` argument is the name that the generated function will have.\n`file` is the path to the EEx template file. `args` is a list of arguments\nthat the generated function will accept. They will be available inside the EEx\ntemplate.\n\nThis function is useful in case you have templates but\nyou want to precompile inside a module for speed.\n\nThe supported `options` are described [in the module docs](#module-options).","ref":"EEx.html#function_from_file/5"},{"type":"macro","title":"Examples - EEx.function_from_file/5","doc":"# sample.eex\n     \n\n    # sample.ex\n    defmodule Sample do\n      require EEx\n      EEx.function_from_file(:def, :sample, \"sample.eex\", [:a, :b])\n    end\n\n    # iex\n    Sample.sample(1, 2)\n    #=> \"3\"","ref":"EEx.html#function_from_file/5-examples"},{"type":"macro","title":"EEx.function_from_string/5","doc":"Generates a function definition from the given string.\n\nThe first argument is the kind of the generated function (`:def` or `:defp`).\nThe `name` argument is the name that the generated function will have.\n`template` is the string containing the EEx template. `args` is a list of arguments\nthat the generated function will accept. They will be available inside the EEx\ntemplate.\n\nThe supported `options` are described [in the module docs](#module-options).","ref":"EEx.html#function_from_string/5"},{"type":"macro","title":"Examples - EEx.function_from_string/5","doc":"iex> defmodule Sample do\n    ...>   require EEx\n    ...>   EEx.function_from_string(:def, :sample, \" \", [:a, :b])\n    ...> end\n    iex> Sample.sample(1, 2)\n    \"3\"","ref":"EEx.html#function_from_string/5-examples"},{"type":"function","title":"EEx.tokenize/2","doc":"Tokenize the given contents according to the given options.","ref":"EEx.html#tokenize/2"},{"type":"function","title":"Options - EEx.tokenize/2","doc":"* `:line` - An integer to start as line. Default is 1.\n  * `:column` - An integer to start as column. Default is 1.\n  * `:indentation` - An integer that indicates the indentation. Default is 0.\n  * `:trim` - Tells the tokenizer to either trim the content or not. Default is false.\n  * `:file` - Can be either a file or a string \"nofile\".","ref":"EEx.html#tokenize/2-options"},{"type":"function","title":"Examples - EEx.tokenize/2","doc":"iex> EEx.tokenize('foo', line: 1, column: 1)\n    {:ok, [{:text, 'foo', %{column: 1, line: 1}}, {:eof, %{column: 4, line: 1}}]}","ref":"EEx.html#tokenize/2-examples"},{"type":"function","title":"Result - EEx.tokenize/2","doc":"It returns `{:ok, [token]}` where a token is one of:\n\n  * `{:text, content, %{column: column, line: line}}`\n  * `{:expr, marker, content, %{column: column, line: line}}`\n  * `{:start_expr, marker, content, %{column: column, line: line}}`\n  * `{:middle_expr, marker, content, %{column: column, line: line}}`\n  * `{:end_expr, marker, content, %{column: column, line: line}}`\n  * `{:eof, %{column: column, line: line}}`\n\nOr `{:error, message, %{column: column, line: line}}` in case of errors.\nNote new tokens may be added in the future.","ref":"EEx.html#tokenize/2-result"},{"type":"type","title":"EEx.column/0","doc":"","ref":"EEx.html#t:column/0"},{"type":"type","title":"EEx.line/0","doc":"","ref":"EEx.html#t:line/0"},{"type":"type","title":"EEx.marker/0","doc":"","ref":"EEx.html#t:marker/0"},{"type":"type","title":"EEx.metadata/0","doc":"","ref":"EEx.html#t:metadata/0"},{"type":"type","title":"EEx.token/0","doc":"","ref":"EEx.html#t:token/0"},{"type":"behaviour","title":"EEx.Engine","doc":"Basic EEx engine that ships with Elixir.\n\nAn engine needs to implement all callbacks below.\n\nThis module also ships with a default engine implementation\nyou can delegate to. See `EEx.SmartEngine` as an example.","ref":"EEx.Engine.html"},{"type":"function","title":"EEx.Engine.handle_assign/1","doc":"Handles assigns in quoted expressions.\n\nA warning will be printed on missing assigns.\nFuture versions will raise.\n\nThis can be added to any custom engine by invoking\n`handle_assign/1` with `Macro.prewalk/2`:\n\n    def handle_expr(state, token, expr) do\n      expr = Macro.prewalk(expr, &EEx.Engine.handle_assign/1)\n      super(state, token, expr)\n    end","ref":"EEx.Engine.html#handle_assign/1"},{"type":"function","title":"EEx.Engine.handle_begin/1","doc":"Default implementation for `c:handle_begin/1`.","ref":"EEx.Engine.html#handle_begin/1"},{"type":"callback","title":"EEx.Engine.handle_begin/1","doc":"Invoked at the beginning of every nesting.\n\nIt must return a new state that is used only inside the nesting.\nOnce the nesting terminates, the current `state` is resumed.","ref":"EEx.Engine.html#c:handle_begin/1"},{"type":"function","title":"EEx.Engine.handle_body/1","doc":"Default implementation for `c:handle_body/1`.","ref":"EEx.Engine.html#handle_body/1"},{"type":"callback","title":"EEx.Engine.handle_body/1","doc":"Called at the end of every template.\n\nIt must return Elixir's quoted expressions for the template.","ref":"EEx.Engine.html#c:handle_body/1"},{"type":"function","title":"EEx.Engine.handle_end/1","doc":"Default implementation for `c:handle_end/1`.","ref":"EEx.Engine.html#handle_end/1"},{"type":"callback","title":"EEx.Engine.handle_end/1","doc":"Invokes at the end of a nesting.\n\nIt must return Elixir's quoted expressions for the nesting.","ref":"EEx.Engine.html#c:handle_end/1"},{"type":"function","title":"EEx.Engine.handle_expr/3","doc":"Default implementation for `c:handle_expr/3`.","ref":"EEx.Engine.html#handle_expr/3"},{"type":"callback","title":"EEx.Engine.handle_expr/3","doc":"Called for the dynamic/code parts of a template.\n\nThe marker is what follows exactly after ` ` has an empty marker, but ` ` has `\"=\"`\nas marker. The allowed markers so far are:\n\n  * `\"\"`\n  * `\"=\"`\n  * `\"/\"`\n  * `\"|\"`\n\nMarkers `\"/\"` and `\"|\"` are only for use in custom EEx engines\nand are not implemented by default. Using them without an\nappropriate implementation raises `EEx.SyntaxError`.\n\nIt must return the updated state.","ref":"EEx.Engine.html#c:handle_expr/3"},{"type":"function","title":"EEx.Engine.handle_text/3","doc":"Default implementation for `c:handle_text/3`.","ref":"EEx.Engine.html#handle_text/3"},{"type":"callback","title":"EEx.Engine.handle_text/3","doc":"Called for the text/static parts of a template.\n\nIt must return the updated state.","ref":"EEx.Engine.html#c:handle_text/3"},{"type":"function","title":"EEx.Engine.init/1","doc":"Default implementation for `c:init/1`.","ref":"EEx.Engine.html#init/1"},{"type":"callback","title":"EEx.Engine.init/1","doc":"Called at the beginning of every template.\n\nIt must return the initial state.","ref":"EEx.Engine.html#c:init/1"},{"type":"type","title":"EEx.Engine.state/0","doc":"","ref":"EEx.Engine.html#t:state/0"},{"type":"module","title":"EEx.SmartEngine","doc":"The default engine used by EEx.\n\nIt includes assigns (like `@foo`) and possibly other\nconveniences in the future.","ref":"EEx.SmartEngine.html"},{"type":"module","title":"Examples - EEx.SmartEngine","doc":"iex> EEx.eval_string(\" \", assigns: [foo: 1])\n    \"1\"\n\nIn the example above, we can access the value `foo` under\nthe binding `assigns` using `@foo`. This is useful because\na template, after being compiled, can receive different\nassigns and would not require recompilation for each\nvariable set.\n\nAssigns can also be used when compiled to a function:\n\n    # sample.eex\n     \n\n    # sample.ex\n    defmodule Sample do\n      require EEx\n      EEx.function_from_file(:def, :sample, \"sample.eex\", [:assigns])\n    end\n\n    # iex\n    Sample.sample(a: 1, b: 2)\n    #=> \"3\"","ref":"EEx.SmartEngine.html#module-examples"},{"type":"exception","title":"EEx.SyntaxError","doc":"","ref":"EEx.SyntaxError.html"}],"content_type":"text/markdown"}