/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texosquery;

import com.dickimawbooks.texosquery.QueryActionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class QueryAction
implements Serializable {
    private String longName = null;
    private String shortName = null;
    private String invokedName = null;
    private String syntax = "";
    private int optional = 0;
    private int optionalProvided = 0;
    private int required = 0;
    private String[] requiredArgs = null;
    private String[] optionalArgs = null;
    private QueryActionType type;
    private String description;
    private int minCompatibility = 0;
    private static final int MAX_CHARS_PER_LINE = 80;

    public QueryAction() {
    }

    public QueryAction(String string, QueryActionType queryActionType, String string2) {
        this(string, null, 0, 0, "", queryActionType, string2);
    }

    public QueryAction(String string, QueryActionType queryActionType, String string2, int n) {
        this(string, null, 0, 0, "", queryActionType, string2, n);
    }

    public QueryAction(String string, String string2, QueryActionType queryActionType, String string3) {
        this(string, string2, 0, 0, "", queryActionType, string3);
    }

    public QueryAction(String string, String string2, QueryActionType queryActionType, String string3, int n) {
        this(string, string2, 0, 0, "", queryActionType, string3, n);
    }

    public QueryAction(String string, String string2, String string3, QueryActionType queryActionType, String string4) {
        this(string, string2, 0, 0, string3, queryActionType, string4);
    }

    public QueryAction(String string, String string2, int n, int n2, String string3, QueryActionType queryActionType, String string4) {
        this(string, string2, n, n2, string3, queryActionType, string4, 0);
    }

    public QueryAction(String string, String string2, int n, int n2, String string3, QueryActionType queryActionType, String string4, int n3) {
        if (string != null) {
            this.longName = "--" + string;
        }
        if (string2 != null) {
            this.shortName = "-" + string2;
        }
        this.optional = n;
        this.required = n2;
        this.syntax = string3;
        this.type = queryActionType;
        this.description = string4;
        this.minCompatibility = n3;
    }

    public boolean isAction(String string) {
        return string.equals(this.shortName) || string.equals(this.longName) || this.longName != null && string.startsWith(this.longName + "=");
    }

    public int parseArgs(String[] stringArray, int n) throws IllegalArgumentException {
        int n2;
        if (this.required > 0) {
            this.requiredArgs = new String[this.required];
        }
        if (stringArray[n].startsWith(this.longName + "=")) {
            int n3;
            int n4 = stringArray[n].indexOf("=") + 1;
            this.invokedName = this.longName;
            if (n4 == stringArray[n].length()) {
                if (this.required != 1) {
                    throw new IllegalArgumentException(String.format("Invalid syntax for action '%s'.%nExpected: %s", this.invokedName, this.getUsage(this.invokedName)));
                }
                this.requiredArgs[0] = "";
                return n + 1;
            }
            String[] stringArray2 = this.required + this.optional > 1 ? stringArray[n].substring(n4).split(" ") : new String[]{stringArray[n].substring(n4)};
            n4 = 0;
            for (n3 = 0; n3 < this.required; ++n3) {
                if (n3 >= stringArray2.length) {
                    throw new IllegalArgumentException(String.format("Invalid syntax for action '%s'.%nExpected: %s", this.invokedName, this.getUsage(this.invokedName)));
                }
                this.requiredArgs[n3] = stringArray2[n4++];
            }
            this.optionalProvided = 0;
            if (this.optional > 0) {
                this.optionalArgs = new String[this.optional];
            }
            for (n3 = 0; n3 < this.optional && n4 < stringArray2.length; ++n3) {
                this.optionalArgs[this.optionalProvided++] = stringArray2[n4++];
            }
            return n + 1;
        }
        this.invokedName = stringArray[n++];
        for (n2 = 0; n2 < this.required; ++n2) {
            if (n >= stringArray.length) {
                throw new IllegalArgumentException(String.format("Invalid syntax for action '%s'.%nExpected: %s", this.invokedName, this.getUsage(this.invokedName)));
            }
            this.requiredArgs[n2] = stringArray[n++];
        }
        this.optionalProvided = 0;
        if (this.optional > 0) {
            this.optionalArgs = new String[this.optional];
        }
        for (n2 = 0; n2 < this.optional && n < stringArray.length && !stringArray[n].startsWith("-"); ++n2) {
            this.optionalArgs[this.optionalProvided++] = stringArray[n++];
        }
        return n;
    }

    public int providedOptionCount() {
        return this.optionalProvided;
    }

    public String getOptionalArgument(int n) {
        return n < this.optionalArgs.length ? this.optionalArgs[n] : null;
    }

    public String getRequiredArgument(int n) {
        return this.requiredArgs[n];
    }

    public String getInvocation() {
        StringBuilder stringBuilder = new StringBuilder(this.getInvokedName());
        if (this.requiredArgs != null) {
            for (String string : this.requiredArgs) {
                if (string.contains(" ")) {
                    stringBuilder.append(String.format(" '%s'", string.replaceAll("'", "\\\\'")));
                    continue;
                }
                stringBuilder.append(String.format(" %s", string));
            }
        }
        if (this.optionalArgs != null) {
            for (String string : this.optionalArgs) {
                if (string == null) continue;
                if (string.contains(" ")) {
                    stringBuilder.append(String.format(" '%s'", string.replaceAll("'", "\\\\'")));
                    continue;
                }
                stringBuilder.append(String.format(" %s", string));
            }
        }
        return stringBuilder.toString();
    }

    public String getInvokedName() {
        return this.invokedName;
    }

    public QueryActionType getType() {
        return this.type;
    }

    public String getUsage(String string) {
        return String.format("%s%s", string, this.syntax == null || "".equals(this.syntax) ? "" : " " + this.syntax);
    }

    private String formatDescription() {
        int n;
        int n2 = this.description.length();
        if (n2 < (n = 72)) {
            return this.description;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        int n3 = 1;
        for (int i = 0; i < n2; i += n3) {
            int n4 = this.description.codePointAt(i);
            n3 = Character.charCount(n4);
            if (n4 == 32) {
                if (stringBuilder2.length() + stringBuilder3.length() + 1 >= n) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder.append(String.format("%n", new Object[0]));
                    stringBuilder2 = new StringBuilder();
                    stringBuilder2.append('\t');
                }
                stringBuilder2.append((CharSequence)stringBuilder3);
                stringBuilder2.append(' ');
                stringBuilder3 = new StringBuilder();
                continue;
            }
            stringBuilder3.appendCodePoint(n4);
        }
        if (stringBuilder2.length() + stringBuilder3.length() + 1 >= n) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(String.format("%n", new Object[0]));
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append('\t');
        }
        stringBuilder2.append((CharSequence)stringBuilder3);
        stringBuilder.append((CharSequence)stringBuilder2);
        return stringBuilder.toString();
    }

    public String help() {
        String string = this.shortName == null ? this.getUsage(this.longName) : String.format("%s or %s", this.getUsage(this.shortName), this.getUsage(this.longName));
        int n = string.length();
        return String.format("%s%n\t%s.%n", string, this.formatDescription());
    }

    public String doAction(int n) throws IllegalArgumentException {
        if (n < this.minCompatibility) {
            throw new IllegalArgumentException(String.format("'%s' option not available in compatibility mode %d", this.invokedName, n));
        }
        return this.action();
    }

    protected abstract String action();

    public final QueryAction copy() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream).writeObject(this);
            QueryAction queryAction = (QueryAction)new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).readObject();
            queryAction.same(this);
            return queryAction;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private void same(QueryAction queryAction) {
        int n;
        this.longName = queryAction.longName;
        this.shortName = queryAction.shortName;
        this.invokedName = queryAction.invokedName;
        this.syntax = queryAction.syntax;
        this.optional = queryAction.optional;
        this.optionalProvided = queryAction.optionalProvided;
        this.required = queryAction.required;
        this.type = queryAction.type;
        this.description = queryAction.description;
        this.minCompatibility = queryAction.minCompatibility;
        if (queryAction.optionalArgs != null) {
            this.optionalArgs = new String[queryAction.optionalArgs.length];
            for (n = 0; n < queryAction.optionalArgs.length; ++n) {
                this.optionalArgs[n] = queryAction.optionalArgs[n];
            }
        }
        if (queryAction.requiredArgs != null) {
            this.requiredArgs = new String[queryAction.requiredArgs.length];
            for (n = 0; n < queryAction.requiredArgs.length; ++n) {
                this.requiredArgs[n] = queryAction.requiredArgs[n];
            }
        }
    }

    public String getLongName() {
        return this.longName;
    }
}

