# OpenAPI v3 Protocol Buffer Models

This directory contains a Protocol Buffer-language model and related code for
supporting OpenAPI v3.

Gnostic applications and plugins can use OpenAPIv3.proto to generate Protocol
Buffer support code for their preferred languages.

OpenAPIv3.go is used by Gnostic to read JSON and YAML OpenAPI descriptions into
the Protocol Buffer-based datastructures generated from OpenAPIv3.proto.

OpenAPIv3.proto and OpenAPIv3.go are generated by the Gnostic compiler
generator, and OpenAPIv3.pb.go is generated by protoc, the Protocol Buffer
compiler, and protoc-gen-go, the Protocol Buffer Go code generation plugin.

openapi-3.1.json is a JSON schema for OpenAPI 3.1 that is automatically
generated from the OpenAPI 3.1 specification. It is not an official JSON Schema
for OpenAPI.

The schema-generator directory contains support code which generates
openapi-3.1.json from the OpenAPI 3.1 specification document (Markdown).
