/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RGBKt;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 92\u00020\u0001:\u00019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tB)\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0007\u001a\u00020\n\u0012\u0006\u0010\b\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fB)\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\r\u0012\u0006\u0010\b\u001a\u00020\r\u0012\b\b\u0002\u0010\u000b\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB'\u0012\u0006\u0010\u0005\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u000f\u0012\u0006\u0010\b\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0019\u001a\u00020\u000fH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000fH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000fH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u000f2\b\b\u0002\u0010\u0007\u001a\u00020\u000f2\b\b\u0002\u0010\b\u001a\u00020\u000f2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\u000fH\u00d6\u0001J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000fH\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\u0006\u00104\u001a\u00020\u000fJ\b\u00105\u001a\u00020\u0000H\u0016J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\b\u00107\u001a\u000208H\u0016R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006:"}, d2={"Lcom/github/ajalt/colormath/RGB;", "Lcom/github/ajalt/colormath/Color;", "hex", "", "(Ljava/lang/String;)V", "r", "", "g", "b", "(BBB)V", "", "a", "(FFFF)V", "", "(DDDD)V", "", "(IIIF)V", "getA", "()F", "alpha", "getAlpha", "getB", "()I", "getG", "getR", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toAnsi16", "Lcom/github/ajalt/colormath/Ansi16;", "value", "toAnsi256", "Lcom/github/ajalt/colormath/Ansi256;", "toCMYK", "Lcom/github/ajalt/colormath/CMYK;", "toHSL", "Lcom/github/ajalt/colormath/HSL;", "toHSV", "Lcom/github/ajalt/colormath/HSV;", "toHex", "withNumberSign", "renderAlpha", "Lcom/github/ajalt/colormath/RenderCondition;", "toLAB", "Lcom/github/ajalt/colormath/LAB;", "toPackedInt", "toRGB", "toString", "toXYZ", "Lcom/github/ajalt/colormath/XYZ;", "Companion", "colormath"})
public final class RGB
implements Color {
    private final int r;
    private final int g;
    private final int b;
    private final float a;
    public static final Companion Companion = new Companion(null);

    @Override
    public float getAlpha() {
        return this.a;
    }

    public final int toPackedInt() {
        return MathKt.roundToInt(this.a * (float)255) << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        int n = 9;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        if (withNumberSign) {
            $this$buildString.append('#');
        }
        $this$buildString.append(RGBKt.access$renderHex(this.r)).append(RGBKt.access$renderHex(this.g)).append(RGBKt.access$renderHex(this.b));
        if (renderAlpha == RenderCondition.ALWAYS || renderAlpha == RenderCondition.AUTO && this.a < 1.0f) {
            $this$buildString.append(RGBKt.access$renderHex(MathKt.roundToInt(this.a * (float)255)));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        double r = (double)this.r / 255.0;
        double g = (double)this.g / 255.0;
        double b = (double)this.b / 255.0;
        boolean bl = false;
        boolean bl2 = false;
        double d = Math.min(g, b);
        boolean bl3 = false;
        double min = Math.min(r, d);
        boolean bl4 = false;
        boolean bl5 = false;
        double d2 = Math.max(g, b);
        boolean bl6 = false;
        double max = Math.max(r, d2);
        double delta = max - min;
        double h = max == min ? 0.0 : (r == max ? (g - b) / delta : (g == max ? (double)2 + (b - r) / delta : (b == max ? (double)4 + (r - g) / delta : 0.0)));
        double d3 = h * (double)60;
        double d4 = 360.0;
        boolean bl7 = false;
        h = Math.min(d3, d4);
        if (h < 0.0) {
            h += (double)360;
        }
        double l = (min + max) / 2.0;
        double s = max == min ? 0.0 : (l <= 0.5 ? delta / (max + min) : delta / ((double)2 - max - min));
        return new HSL(MathKt.roundToInt(h), MathKt.roundToInt(s * (double)100), MathKt.roundToInt(l * (double)100), this.getAlpha());
    }

    @Override
    @NotNull
    public HSV toHSV() {
        double r = this.r;
        double g = this.g;
        double b = this.b;
        boolean bl = false;
        boolean bl2 = false;
        double d = Math.min(g, b);
        boolean bl3 = false;
        double min = Math.min(r, d);
        boolean bl4 = false;
        boolean bl5 = false;
        double d2 = Math.max(g, b);
        boolean bl6 = false;
        double max = Math.max(r, d2);
        double delta = max - min;
        double d3 = max;
        double s = d3 == 0.0 ? 0.0 : delta / max * (double)1000 / (double)10;
        double h = max == min ? 0.0 : (r == max ? (g - b) / delta : (g == max ? (double)2 + (b - r) / delta : (b == max ? (double)4 + (r - g) / delta : 0.0)));
        double d4 = h * (double)60;
        double d5 = 360.0;
        boolean bl7 = false;
        h = Math.min(d4, d5);
        if (h < 0.0) {
            h += (double)360;
        }
        double v = max / (double)255 * (double)1000 / (double)10;
        return new HSV(MathKt.roundToInt(h), MathKt.roundToInt(s), MathKt.roundToInt(v), this.getAlpha());
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        toXYZ.1 $fun$adj$1 = toXYZ.1.INSTANCE;
        double rL = $fun$adj$1.invoke(this.r);
        double gL = $fun$adj$1.invoke(this.g);
        double bL = $fun$adj$1.invoke(this.b);
        double x = 0.4124564 * rL + 0.3575761 * gL + 0.1804375 * bL;
        double y = 0.2126729 * rL + 0.7151522 * gL + 0.072175 * bL;
        double z = 0.0193339 * rL + 0.119192 * gL + 0.9503041 * bL;
        return new XYZ(x * (double)100, y * (double)100, z * (double)100, this.getAlpha());
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return this.toXYZ().toLAB();
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        double r = (double)this.r / 255.0;
        double b = (double)this.b / 255.0;
        double g = (double)this.g / 255.0;
        boolean bl = false;
        boolean bl2 = false;
        double d = Math.max(b, g);
        boolean bl3 = false;
        double k = 1.0 - Math.max(r, d);
        double c = k == 1.0 ? 0.0 : (1.0 - r - k) / (1.0 - k);
        double m = k == 1.0 ? 0.0 : (1.0 - g - k) / (1.0 - k);
        double y = k == 1.0 ? 0.0 : (1.0 - b - k) / (1.0 - k);
        return new CMYK(MathKt.roundToInt(c * (double)100), MathKt.roundToInt(m * (double)100), MathKt.roundToInt(y * (double)100), MathKt.roundToInt(k * (double)100), this.getAlpha());
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return this.toAnsi16(this.toHSV().getV());
    }

    private final Ansi16 toAnsi16(int value) {
        if (value == 30) {
            return new Ansi16(30);
        }
        int v = MathKt.roundToInt((double)value / 50.0);
        int ansi = 30 + (MathKt.roundToInt((double)this.b / 255.0) * 4 | MathKt.roundToInt((double)this.g / 255.0) * 2 | MathKt.roundToInt((double)this.r / 255.0));
        return new Ansi16(v == 2 ? ansi + 60 : ansi);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        int code = this.r == this.g && this.g == this.b ? (this.r < 8 ? 16 : (this.r > 248 ? 231 : MathKt.roundToInt((double)(this.r - 8) / 247.0 * 24.0) + 232)) : 16 + 36 * MathKt.roundToInt((double)this.r / 255.0 * (double)5) + 6 * MathKt.roundToInt((double)this.g / 255.0 * (double)5) + MathKt.roundToInt((double)this.b / 255.0 * (double)5);
        return new Ansi256(code);
    }

    @Override
    @NotNull
    public RGB toRGB() {
        return this;
    }

    public final int getR() {
        return this.r;
    }

    public final int getG() {
        return this.g;
    }

    public final int getB() {
        return this.b;
    }

    public final float getA() {
        return this.a;
    }

    public RGB(int r, int g, int b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        int n = this.r;
        n = 0 <= n && 255 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "r must be in range [0, 255] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.g;
        n = 0 <= n && 255 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "g must be in range [0, 255] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.b;
        n = 0 <= n && 255 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "b must be in range [0, 255] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = this.a;
        boolean bl6 = f >= 0.0f && f <= 1.0f;
        bl = false;
        bl2 = false;
        if (!bl6) {
            boolean bl7 = false;
            String string = "a must be in range [0, 1] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RGB(int n, int n2, int n3, float f, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            f = 1.0f;
        }
        this(n, n2, n3, f);
    }

    public RGB(@NotNull String hex) {
        Intrinsics.checkNotNullParameter(hex, "hex");
        this(RGBKt.access$parseHex(RGBKt.access$validateHex(hex), 0), RGBKt.access$parseHex(hex, 2), RGBKt.access$parseHex(hex, 4), hex.length() < 8 ? 1.0f : (float)RGBKt.access$parseHex(hex, 6) / 255.0f);
    }

    public RGB(byte r, byte g, byte b) {
        this(r + 128, g + 128, b + 128, 0.0f, 8, (DefaultConstructorMarker)null);
    }

    public RGB(float r, float g, float b, float a) {
        this(MathKt.roundToInt(r * (float)255), MathKt.roundToInt(g * (float)255), MathKt.roundToInt(b * (float)255), a);
    }

    public /* synthetic */ RGB(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public RGB(double r, double g, double b, double a) {
        this((float)r, (float)g, (float)b, (float)a);
    }

    public /* synthetic */ RGB(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final int component1() {
        return this.r;
    }

    public final int component2() {
        return this.g;
    }

    public final int component3() {
        return this.b;
    }

    public final float component4() {
        return this.a;
    }

    @NotNull
    public final RGB copy(int r, int g, int b, float a) {
        return new RGB(r, g, b, a);
    }

    public static /* synthetic */ RGB copy$default(RGB rGB, int n, int n2, int n3, float f, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = rGB.r;
        }
        if ((n4 & 2) != 0) {
            n2 = rGB.g;
        }
        if ((n4 & 4) != 0) {
            n3 = rGB.b;
        }
        if ((n4 & 8) != 0) {
            f = rGB.a;
        }
        return rGB.copy(n, n2, n3, f);
    }

    @NotNull
    public String toString() {
        return "RGB(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ")";
    }

    public int hashCode() {
        return ((Integer.hashCode(this.r) * 31 + Integer.hashCode(this.g)) * 31 + Integer.hashCode(this.b)) * 31 + Float.hashCode(this.a);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RGB)) break block3;
                RGB rGB = (RGB)object;
                if (this.r != rGB.r || this.g != rGB.g || this.b != rGB.b || Float.compare(this.a, rGB.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/ajalt/colormath/RGB$Companion;", "", "()V", "fromInt", "Lcom/github/ajalt/colormath/RGB;", "argb", "", "colormath"})
    public static final class Companion {
        @NotNull
        public final RGB fromInt(int argb) {
            return new RGB(argb >>> 16 & 0xFF, argb >>> 8 & 0xFF, argb & 0xFF, (float)(argb >>> 24 & 0xFF) / 255.0f);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

