#
# spec file for package openwsman
#
# Copyright (c) 2015 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%if 0%{?suse_version} > 1140 || 0%{?fedora_version} > 14
%define has_systemd 1
%else
%define has_systemd 0
%endif

Name:           openwsman
BuildRequires:  cmake
BuildRequires:  gcc-c++
BuildRequires:  libxml2-devel
BuildRequires:  pam-devel
BuildRequires:  sblim-sfcc-devel
BuildRequires:  swig >= 2.0.5

BuildRequires:  perl
BuildRequires:  python-devel

%if 0%{?rhel_version} > 0
BuildRequires:  -vim
%endif

%if 0%{?fedora_version} || 0%{?centos_version} || 0%{?rhel_version} || 0%{?fedora} || 0%{?rhel}
BuildRequires:  curl-devel

%if 0%{?fedora} == 16 || (0%{?centos_version}>=500 && 0%{?centos_version}<700) || (0%{?rhel_version}>=500 && 0%{?rhel_version}<700)
BuildRequires:  java-1.6.0-openjdk-devel
%else
%if 0%{?fedora} >= 17 || 0%{?centos_version} >= 700 || 0%{?rhel_version} >= 700
BuildRequires:  java-1.7.0-openjdk-devel
%else
BuildRequires:  java-devel
%endif
%endif

BuildRequires:  openssl-devel
BuildRequires:  pkgconfig
BuildRequires:  ruby

%if 0%{?fedora} + 0%{?rhel_version} + 0%{?centos_version}  > 0

%if 0%{?rhel_version} < 700
BuildRequires:  ruby-devel
%endif

BuildRequires:  ruby-libs

%endif

%if 0%{?rhel_version} >= 700 || 0%{?centos_version} >= 700 || 0%{?fedora} > 16
BuildRequires:  rubygem-rdoc
%else
BuildRequires:  ruby-rdoc
%endif

%if 0%{?fedora} > 18
BuildRequires:  rubypick
%endif

%if 0%{?fedora} > 0 || 0%{?rhel_version} >= 600  || 0%{?centos_version} >= 600
BuildRequires:  perl-devel
%endif
%endif

%if 0%{?suse_version} > 0
BuildRequires:  java-devel
# No jni_md.h on SLE10 :-/
#%%if 0%{?suse_version} < 1100
#BuildRequires:  java-1_5_0-ibm-devel
#BuildRequires:  libgcj-devel
#BuildRequires:  update-alternatives
#%%endif

%if 0%{?suse_version} > 1010
BuildRequires:  fdupes
BuildRequires:  libcurl-devel
BuildRequires:  libopenssl-devel
%else
# SLE10
BuildRequires:  curl-devel
BuildRequires:  libidn-devel
BuildRequires:  openssl-devel
%endif

%if 0%{?suse_version} > 910
%if 0%{?suse_version} < 1110
# SLE 10 has Ruby 1.8.6 and runs into http://help.rubygems.org/discussions/problems/859-trying-to-install-rubygems
BuildRequires:  rubygems <= 1.3.7
%else
BuildRequires:  rubygems
%endif
BuildRequires:  pkg-config
BuildRequires:  ruby-devel
%else
# SLE9
BuildRequires:  pkgconfig
BuildRequires:  ruby
%endif

%endif

%if 0%{?has_systemd}
BuildRequires:  systemd
%{?systemd_requires}
%endif

Requires(pre):  sed coreutils grep /bin/hostname
Version:        2.4.4
Release:        0
# Mandriva:
# Release %%mkrel 1
Url:            http://www.openwsman.org/
Summary:        Opensource Implementation of WS-Management
License:        BSD-3-Clause
Group:          System/Management
Source:         %{name}-%{version}.tar.bz2
Source1:        %{name}.rpmlintrc
%if 0%{?fedora_version} || 0%{?centos_version} || 0%{?rhel_version} || 0%{?fedora} || 0%{?rhel}
Source2:        %{name}.pam.rh
Patch1:         openwsman-initscript.patch
%else
Source2:        %{name}.pam
%endif
Source3:        %{name}.SuSEfirewall2
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Source4:        %{name}.service

%description
Opensource Implementation of WS-Management protocol stack


%package -n libwsman3
Summary:        Opensource Implementation of WS-Management
Group:          System/Management
Provides:       openwsman = %{version}
Obsoletes:      openwsman < %{version}

%description -n libwsman3
Opensource Implementation of WS-Management protocol stack
(Common libraries)

%package -n libwsman-devel
Summary:        Opensource Implementation of WS-Management
Group:          Development/Libraries/C and C++
Provides:       openwsman-devel = %{version}
Obsoletes:      openwsman-devel < %{version}
Requires:       %{name}-server = %{version}
Requires:       libwsman3 = %{version}
Requires:       libxml2-devel
Requires:       pam-devel
Requires:       sblim-sfcc-devel

%description -n libwsman-devel
Opensource Implementation of WS-Management stack
(Development files)

%package -n libwsman_clientpp1
Summary:        C++ bindings to Openwsman Client libraries
Group:          System/Management
Provides:       openwsman-client = %{version}
Obsoletes:      openwsman-client < %{version}

%description -n libwsman_clientpp1
An implementation of the WsmanClient interface using C++


%package -n libwsman_clientpp-devel
Summary:        C++ bindings to Openwsman Client libraries
Group:          Development/Libraries/C and C++
Requires:       libwsman-devel = %{version}
Requires:       libwsman_clientpp1 = %{version}

%description -n libwsman_clientpp-devel
Development files for C++ interface to OpenWSMAN client library.


%package server
Requires(pre):  sed coreutils grep diffutils /bin/hostname
%if 0%{?suse_version}
Requires(pre):  fillup
# for pam_unix2 and pam_pwcheck
Requires:       pam-modules
%endif
Summary:        Openwsman Server and service libraries
Group:          System/Management

%description server
Openwsman Server and service libraries


%package server-plugin-ruby
Requires:       openwsman-server
Summary:        Openwsman Server Plugin for Ruby extensions
Group:          System/Management

%description server-plugin-ruby
This package provides a Openwsman server plugin to write a
WS-Management resource handler in Ruby


%package python
Summary:        Python bindings for openwsman client API
Group:          Development/Libraries/Python
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%{!?py_requires: %define py_requires Requires: python}
%{py_requires}

%description python
This package provides Python bindings to access the openwsman client
API.


%package ruby
Requires:       ruby

# RbConfig::CONFIG["ruby_version"] is empty in Fedora > 18 !?
%if 0%{?fedora} > 18 || 0%{?rhel_version} >= 700 || 0%{?centos_version} >= 700
%{!?ruby_version: %global ruby_version %(ruby -r rbconfig -e 'print(RbConfig::CONFIG["RUBY_PROGRAM_VERSION"])')}
%else
%{!?ruby_version: %global ruby_version %(ruby -r rbconfig -e 'print(RbConfig::CONFIG["ruby_version"])')}
%endif

%if 0%{?fedora_version} || 0%{?centos_version} || 0%{?rhel_version} || 0%{?fedora} || 0%{?rhel}
Requires:       ruby(abi) = %{ruby_version}
%endif

%if 0%{?suse_version} > 1120
Requires:       ruby(abi) = %{ruby_version}
%endif

%if 0%{?suse_version} == 1010
%{!?ruby_sitelib: %global ruby_sitelib %(ruby -r rbconfig -e 'vd = RbConfig::CONFIG["vendorlibdir"]; print(vd ? vd : RbConfig::CONFIG["sitelibdir"])')}
%{!?ruby_sitearch: %global ruby_sitearch %(ruby -r rbconfig -e 'vad = RbConfig::CONFIG["vendorarchdir"]; print(vad ? vad : RbConfig::CONFIG["sitearchdir"])')}
%else
# SLES 10 can't parse this :-/
%if 0%{?ruby_sitelib} == 0
%if (0%{?fedora} && 0%{?fedora} < 16) || (0%{?centos_version} && 0%{?centos_version}<600) || (0%{?rhel_version} && 0%{?rhel_version}<500)
# Fedora15, RHEL-5 and CentOS-5 don't have vendor lib
# CMAKE checks for "ruby -r vendor-specific" and fails
%{!?ruby_sitelib: %global ruby_sitelib %(ruby -r rbconfig -e 'print(RbConfig::CONFIG["sitelibdir"])')}
%{!?ruby_sitearch: %global ruby_sitearch %(ruby -r rbconfig -e 'print(RbConfig::CONFIG["sitearchdir"])')}
%else
%{!?ruby_sitelib: %global ruby_sitelib %(ruby -r rbconfig -e 'vd = RbConfig::CONFIG["vendorlibdir"]; print(vd ? vd : RbConfig::CONFIG["sitelibdir"])')}
%{!?ruby_sitearch: %global ruby_sitearch %(ruby -r rbconfig -e 'vad = RbConfig::CONFIG["vendorarchdir"]; print(vad ? vad : RbConfig::CONFIG["sitearchdir"])')}
%endif
%endif
%endif

Summary:        Ruby bindings for openwsman client API
Group:          System/Management

%description ruby
This package provides Ruby bindings to access the openwsman client API.

%package ruby-docs
Summary:        HTML documentation for Opendwsman Ruby bindings
Group:          Documentation/HTML

%description ruby-docs
This package provides HTML documentation for the Openwsman Ruby
bindings.


%package perl
%if 0%{?fedora}
%define perl_version %(eval "`%{__perl} -V:version`"; echo $version)
%define perl_requires perl(:MODULE_COMPAT_%{perl_version})
Requires:       %{perl_requires}
%else
Requires:       perl = %{perl_version}
%endif
Summary:        Perl bindings for openwsman client API
Group:          System/Management

%description perl
This package provides Perl bindings to access the openwsman client API.


%if 0%{?suse_version} == 0 || 0%{?suse_version} >= 1100

%package java
Requires:       java
Requires:       libwsman3 = %{version}
Summary:        Java bindings for openwsman client API
Group:          System/Management

%description java
This package provides Java bindings to access the openwsman client API.


%endif

%prep
%setup -q
%if 0%{?fedora_version} || 0%{?centos_version} || 0%{?rhel_version} || 0%{?fedora} || 0%{?rhel}
%patch1 -p1
%endif

%build
rm -rf build
mkdir build
%if 0%{?fedora}
# [ curl-Bugs-1924441 ] SSL callback option with NSS-linked libcurl
# CURLOPT_SSL_CTX_FUNCTION is defined, but does not work on e.g. Fedora
export RPM_OPT_FLAGS="$RPM_OPT_FLAGS -DNO_SSL_CALLBACK"
%endif
# SLES 10 needs explicit java bytecode target
%if 0%{?suse_version} == 1010 || 0%{?suse_version} == 1110 
export EXPLICIT_SOURCE=1.5
export EXPLICIT_TARGET=1.5
%endif

cd build
cmake \
  -DCMAKE_INSTALL_PREFIX=/usr \
%if 0%{?suse_version} == 1010 # SLE 10 Java doesn't like EXPLICIT_TARGET any more, disable
  -DBUILD_JAVA=FALSE \
%endif
  -DCMAKE_VERBOSE_MAKEFILE=TRUE \
  -DCMAKE_BUILD_TYPE=Release \
  -DCMAKE_C_FLAGS_RELEASE:STRING="$RPM_OPT_FLAGS -fno-strict-aliasing" \
  -DCMAKE_CXX_FLAGS_RELEASE:STRING="$RPM_OPT_FLAGS" \
  -DCMAKE_SKIP_RPATH=1 \
  -DPACKAGE_ARCHITECTURE=`uname -m` \
  -DEXPLICIT_SOURCE="$EXPLICIT_SOURCE" \
  -DEXPLICIT_TARGET="$EXPLICIT_TARGET" \
  -DLIB=%{_lib} \
  -DBUILD_RUBY_GEM=no \
  ..

make

%install
cd build
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT%{_docdir}
cp -a bindings/ruby/html $RPM_BUILD_ROOT%{_docdir}/openwsman-ruby-docs
cd ..
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/openwsman/plugins/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/openwsman/authenticators/*.la
[ -d $RPM_BUILD_ROOT%{ruby_sitelib} ] && rm -f $RPM_BUILD_ROOT%{ruby_sitelib}/openwsmanplugin.rb
[ -d $RPM_BUILD_ROOT%{ruby_vendorlib} ] && rm -f $RPM_BUILD_ROOT%{ruby_vendorlib}/openwsmanplugin.rb
%if 0%{?has_systemd}
install -D -m 644 %{S:4} $RPM_BUILD_ROOT%{_unitdir}/%{name}.service
# rcopenwsman
ln -sf %{_sbindir}/service $RPM_BUILD_ROOT%{_sbindir}/rc%{name}
%else
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d
install -m 755 build/etc/init/openwsmand.sh $RPM_BUILD_ROOT%{_sysconfdir}/init.d/openwsmand
ln -sf %{_sysconfdir}/init.d/openwsmand $RPM_BUILD_ROOT%{_sbindir}/rcopenwsmand
%endif
install -m 644 etc/openwsman.conf $RPM_BUILD_ROOT%{_sysconfdir}/openwsman
install -m 644 etc/openwsman_client.conf $RPM_BUILD_ROOT%{_sysconfdir}/openwsman
install -m 644 etc/ssleay.cnf $RPM_BUILD_ROOT%{_sysconfdir}/openwsman
install -m 644 %{S:2} $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/openwsman
%if 0%{?suse_version} > 1010
install -D -m 644 %{S:3} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/SuSEfirewall2.d/services/openwsman
%endif

%post -n libwsman3 -p /sbin/ldconfig

%postun -n libwsman3
/sbin/ldconfig
exit 0

# follow http://en.opensuse.org/openSUSE:Systemd_packaging_guidelines
%if 0%{?has_systemd}
%pre server
if [ -f /var/lib/systemd/migrated/%{name} ]; then
%service_add_pre %{name}.service
fi
%endif

%post server
/sbin/ldconfig
%if 0%{?has_systemd}
%service_add_post %{name}.service
%else
%if 0%{?suse_version}
%{fillup_and_insserv openwsmand}
%else
# FIXME: chkconfig?!
%endif
%endif

%preun server
%if 0%{?has_systemd}
%service_del_preun %{name}.service
%else
%if 0%{?suse_version}
%{stop_on_removal openwsmand}
%else
# FIXME: chkconfig?!
%endif
%endif

%postun server
rm -f /var/log/wsmand.log
/sbin/ldconfig
%if 0%{?has_systemd}
%service_del_postun %{name}.service
%else
%if 0%{?suse_version}
%{restart_on_update openwsmand}
%{insserv_cleanup openwsmand}
%else
# FIXME: chkconfig?!
%endif
%endif

%post -n libwsman_clientpp1 -p /sbin/ldconfig

%postun -n libwsman_clientpp1 -p /sbin/ldconfig

%files -n libwsman3
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog README.md TODO src/plugins/redirect/redirect-README
%{_libdir}/libwsman.so.*
%{_libdir}/libwsman_client.so.*
%{_libdir}/libwsman_curl_client_transport.so.*
%config(noreplace) %{_sysconfdir}/openwsman/openwsman_client.conf

%files -n libwsman-devel
%defattr(-,root,root)
%{_includedir}/*
%{_libdir}/pkgconfig/*
%{_libdir}/*.so
%exclude %{_includedir}/openwsman/cpp/*.h
%exclude %{_libdir}/libwsman_clientpp.so

%files python
%defattr(-,root,root)
%{python_sitearch}/*.so
%{python_sitearch}/*.py*

%files ruby
%defattr(-,root,root)
%if 0%{?mandriva_version}
%{ruby_sitearchdir}/_openwsman.so
%dir %{ruby_sitelibdir}/openwsman
%{ruby_sitelibdir}/openwsman.rb
%{ruby_sitelibdir}/openwsman/*.rb
%else
%{ruby_sitearch}/_openwsman.so
%dir %{ruby_sitelib}/openwsman
%{ruby_sitelib}/openwsman.rb
%{ruby_sitelib}/openwsman/*.rb
%endif

%files ruby-docs
%defattr(-,root,root)
%dir %{_docdir}/openwsman-ruby-docs
%{_docdir}/openwsman-ruby-docs

%files perl
%defattr(-,root,root)
%{perl_vendorarch}/openwsman.so
%{perl_vendorlib}/openwsman.pm

%if 0%{?suse_version} == 0 || 0%{?suse_version} >= 1100

%files java
%defattr(-,root,root)
%{_javadir}/*jar
%endif

%files server
%defattr(-,root,root)
%dir %{_sysconfdir}/openwsman
%config(noreplace) %{_sysconfdir}/openwsman/openwsman.conf
%config(noreplace) %{_sysconfdir}/openwsman/ssleay.cnf
%attr(0755,root,root) %{_sysconfdir}/openwsman/owsmangencert.sh
%config %{_sysconfdir}/pam.d/openwsman
%if 0%{?suse_version} > 1010
%config %{_sysconfdir}/sysconfig/SuSEfirewall2.d/services/openwsman
%endif
%if 0%{?has_systemd}
%{_unitdir}/%{name}.service
%{_sbindir}/rc%{name}
%else
%attr(0755,root,root) %{_sysconfdir}/init.d/openwsmand
%endif
%dir %{_libdir}/openwsman
%dir %{_libdir}/openwsman/authenticators
%{_libdir}/openwsman/authenticators/*.so
%{_libdir}/openwsman/authenticators/*.so.*
%dir %{_libdir}/openwsman/plugins
%{_libdir}/openwsman/plugins/*.so
%{_libdir}/openwsman/plugins/*.so.*
%exclude %{_libdir}/openwsman/plugins/*ruby*.so*
%{_sbindir}/openwsmand
%{_libdir}/libwsman_server.so.*

%files server-plugin-ruby
%defattr(-,root,root)
%{_libdir}/openwsman/plugins/*ruby*.so

%files -n libwsman_clientpp1
%defattr(-,root,root)
%{_libdir}/libwsman_clientpp.so.*

%files -n libwsman_clientpp-devel
%defattr(-,root,root)
%{_libdir}/libwsman_clientpp.so
%dir %{_includedir}/openwsman/cpp
%{_includedir}/openwsman/cpp/*.h

%changelog
