// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2020
 * Author(s): Giulio Benetti <giulio.benetti@benettiengineering.com>
 */

#include <linux/err.h>
#include <linux/init.h>
#include <linux/of_device.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/platform_device.h>

#include "pinctrl-imx.h"

enum imxrt1050_pads {
	IMXRT1050_PAD_RESERVE0,
	IMXRT1050_PAD_RESERVE1,
	IMXRT1050_PAD_RESERVE2,
	IMXRT1050_PAD_RESERVE3,
	IMXRT1050_PAD_RESERVE4,
	IMXRT1050_PAD_EMC_00,
	IMXRT1050_PAD_EMC_01,
	IMXRT1050_PAD_EMC_02,
	IMXRT1050_PAD_EMC_03,
	IMXRT1050_PAD_EMC_04,
	IMXRT1050_PAD_EMC_05,
	IMXRT1050_PAD_EMC_06,
	IMXRT1050_PAD_EMC_07,
	IMXRT1050_PAD_EMC_08,
	IMXRT1050_PAD_EMC_09,
	IMXRT1050_PAD_EMC_10,
	IMXRT1050_PAD_EMC_11,
	IMXRT1050_PAD_EMC_12,
	IMXRT1050_PAD_EMC_13,
	IMXRT1050_PAD_EMC_14,
	IMXRT1050_PAD_EMC_15,
	IMXRT1050_PAD_EMC_16,
	IMXRT1050_PAD_EMC_17,
	IMXRT1050_PAD_EMC_18,
	IMXRT1050_PAD_EMC_19,
	IMXRT1050_PAD_EMC_20,
	IMXRT1050_PAD_EMC_21,
	IMXRT1050_PAD_EMC_22,
	IMXRT1050_PAD_EMC_23,
	IMXRT1050_PAD_EMC_24,
	IMXRT1050_PAD_EMC_25,
	IMXRT1050_PAD_EMC_26,
	IMXRT1050_PAD_EMC_27,
	IMXRT1050_PAD_EMC_28,
	IMXRT1050_PAD_EMC_29,
	IMXRT1050_PAD_EMC_30,
	IMXRT1050_PAD_EMC_31,
	IMXRT1050_PAD_EMC_32,
	IMXRT1050_PAD_EMC_33,
	IMXRT1050_PAD_EMC_34,
	IMXRT1050_PAD_EMC_35,
	IMXRT1050_PAD_EMC_36,
	IMXRT1050_PAD_EMC_37,
	IMXRT1050_PAD_EMC_38,
	IMXRT1050_PAD_EMC_39,
	IMXRT1050_PAD_EMC_40,
	IMXRT1050_PAD_EMC_41,
	IMXRT1050_PAD_AD_B0_00,
	IMXRT1050_PAD_AD_B0_01,
	IMXRT1050_PAD_AD_B0_02,
	IMXRT1050_PAD_AD_B0_03,
	IMXRT1050_PAD_AD_B0_04,
	IMXRT1050_PAD_AD_B0_05,
	IMXRT1050_PAD_AD_B0_06,
	IMXRT1050_PAD_AD_B0_07,
	IMXRT1050_PAD_AD_B0_08,
	IMXRT1050_PAD_AD_B0_09,
	IMXRT1050_PAD_AD_B0_10,
	IMXRT1050_PAD_AD_B0_11,
	IMXRT1050_PAD_AD_B0_12,
	IMXRT1050_PAD_AD_B0_13,
	IMXRT1050_PAD_AD_B0_14,
	IMXRT1050_PAD_AD_B0_15,
	IMXRT1050_PAD_AD_B1_00,
	IMXRT1050_PAD_AD_B1_01,
	IMXRT1050_PAD_AD_B1_02,
	IMXRT1050_PAD_AD_B1_03,
	IMXRT1050_PAD_AD_B1_04,
	IMXRT1050_PAD_AD_B1_05,
	IMXRT1050_PAD_AD_B1_06,
	IMXRT1050_PAD_AD_B1_07,
	IMXRT1050_PAD_AD_B1_08,
	IMXRT1050_PAD_AD_B1_09,
	IMXRT1050_PAD_AD_B1_10,
	IMXRT1050_PAD_AD_B1_11,
	IMXRT1050_PAD_AD_B1_12,
	IMXRT1050_PAD_AD_B1_13,
	IMXRT1050_PAD_AD_B1_14,
	IMXRT1050_PAD_AD_B1_15,
	IMXRT1050_PAD_B0_00,
	IMXRT1050_PAD_B0_01,
	IMXRT1050_PAD_B0_02,
	IMXRT1050_PAD_B0_03,
	IMXRT1050_PAD_B0_04,
	IMXRT1050_PAD_B0_05,
	IMXRT1050_PAD_B0_06,
	IMXRT1050_PAD_B0_07,
	IMXRT1050_PAD_B0_08,
	IMXRT1050_PAD_B0_09,
	IMXRT1050_PAD_B0_10,
	IMXRT1050_PAD_B0_11,
	IMXRT1050_PAD_B0_12,
	IMXRT1050_PAD_B0_13,
	IMXRT1050_PAD_B0_14,
	IMXRT1050_PAD_B0_15,
	IMXRT1050_PAD_B1_00,
	IMXRT1050_PAD_B1_01,
	IMXRT1050_PAD_B1_02,
	IMXRT1050_PAD_B1_03,
	IMXRT1050_PAD_B1_04,
	IMXRT1050_PAD_B1_05,
	IMXRT1050_PAD_B1_06,
	IMXRT1050_PAD_B1_07,
	IMXRT1050_PAD_B1_08,
	IMXRT1050_PAD_B1_09,
	IMXRT1050_PAD_B1_10,
	IMXRT1050_PAD_B1_11,
	IMXRT1050_PAD_B1_12,
	IMXRT1050_PAD_B1_13,
	IMXRT1050_PAD_B1_14,
	IMXRT1050_PAD_B1_15,
	IMXRT1050_PAD_SD_B0_00,
	IMXRT1050_PAD_SD_B0_01,
	IMXRT1050_PAD_SD_B0_02,
	IMXRT1050_PAD_SD_B0_03,
	IMXRT1050_PAD_SD_B0_04,
	IMXRT1050_PAD_SD_B0_05,
	IMXRT1050_PAD_SD_B1_00,
	IMXRT1050_PAD_SD_B1_01,
	IMXRT1050_PAD_SD_B1_02,
	IMXRT1050_PAD_SD_B1_03,
	IMXRT1050_PAD_SD_B1_04,
	IMXRT1050_PAD_SD_B1_05,
	IMXRT1050_PAD_SD_B1_06,
	IMXRT1050_PAD_SD_B1_07,
	IMXRT1050_PAD_SD_B1_08,
	IMXRT1050_PAD_SD_B1_09,
	IMXRT1050_PAD_SD_B1_10,
	IMXRT1050_PAD_SD_B1_11,
};

/* Pad names for the pinmux subsystem */
static const struct pinctrl_pin_desc imxrt1050_pinctrl_pads[] = {
	IMX_PINCTRL_PIN(IMXRT1050_PAD_RESERVE0),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_RESERVE1),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_RESERVE2),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_RESERVE3),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_RESERVE4),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_00),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_01),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_02),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_03),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_04),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_05),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_06),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_07),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_08),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_09),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_10),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_11),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_12),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_13),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_14),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_15),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_16),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_17),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_18),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_19),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_20),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_21),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_22),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_23),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_24),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_25),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_26),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_27),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_28),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_29),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_30),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_31),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_32),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_33),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_34),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_35),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_36),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_37),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_38),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_39),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_40),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_EMC_41),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_00),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_01),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_02),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_03),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_04),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_05),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_06),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_07),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_08),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_09),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_10),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_11),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_12),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_13),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_14),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B0_15),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_00),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_01),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_02),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_03),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_04),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_05),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_06),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_07),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_08),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_09),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_10),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_11),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_12),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_13),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_14),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_AD_B1_15),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_00),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_01),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_02),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_03),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_04),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_05),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_06),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_07),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_08),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_09),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_10),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_11),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_12),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_13),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_14),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B0_15),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_00),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_01),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_02),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_03),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_04),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_05),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_06),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_07),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_08),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_09),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_10),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_11),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_12),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_13),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_14),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_B1_15),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B0_00),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B0_01),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B0_02),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B0_03),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B0_04),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B0_05),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_00),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_01),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_02),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_03),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_04),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_05),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_06),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_07),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_08),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_09),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_10),
	IMX_PINCTRL_PIN(IMXRT1050_PAD_SD_B1_11),
};

static const struct imx_pinctrl_soc_info imxrt1050_pinctrl_info = {
	.pins = imxrt1050_pinctrl_pads,
	.npins = ARRAY_SIZE(imxrt1050_pinctrl_pads),
	.gpr_compatible = "fsl,imxrt1050-iomuxc-gpr",
};

static const struct of_device_id imxrt1050_pinctrl_of_match[] = {
	{ .compatible = "fsl,imxrt1050-iomuxc", .data = &imxrt1050_pinctrl_info, },
	{ /* sentinel */ }
};

static int imxrt1050_pinctrl_probe(struct platform_device *pdev)
{
	return imx_pinctrl_probe(pdev, &imxrt1050_pinctrl_info);
}

static struct platform_driver imxrt1050_pinctrl_driver = {
	.driver = {
		.name = "imxrt1050-pinctrl",
		.of_match_table = of_match_ptr(imxrt1050_pinctrl_of_match),
		.suppress_bind_attrs = true,
	},
	.probe = imxrt1050_pinctrl_probe,
};

static int __init imxrt1050_pinctrl_init(void)
{
	return platform_driver_register(&imxrt1050_pinctrl_driver);
}
arch_initcall(imxrt1050_pinctrl_init);
