; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --no_x86_scrub_sp --version 2
; RUN: llc -mtriple=i686-unknown-unknown < %s | FileCheck %s
; RUN: llc -mtriple=i686-unknown-unknown -O0 < %s | FileCheck %s -check-prefix=CHECK0

%struct.interrupt_frame = type { i32, i32, i32, i32, i32 }

@sink_address = global ptr null
@sink_i32 = global i32 0


; Spills eax, putting original esp at +4.
; Stack is dyamically realigned to 16 bytes, and then reloaded to ebp - 4
; With no error code, the stack is not incremented by 4 bytes before returning
define x86_intrcc void @test_isr_no_ecode(ptr byval(%struct.interrupt_frame) %frame) nounwind {
; CHECK-LABEL: test_isr_no_ecode:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    cld
; CHECK-NEXT:    movl 12(%ebp), %eax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    leal -4(%ebp), %esp
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_isr_no_ecode:
; CHECK0:       # %bb.0:
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    andl $-16, %esp
; CHECK0-NEXT:    cld
; CHECK0-NEXT:    leal 4(%ebp), %eax
; CHECK0-NEXT:    movl 8(%eax), %eax
; CHECK0-NEXT:    #APP
; CHECK0-NEXT:    #NO_APP
; CHECK0-NEXT:    leal -4(%ebp), %esp
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    iretl
; CHECK-NEXT;    movl %esp, %ebp
  %pflags = getelementptr inbounds %struct.interrupt_frame, ptr %frame, i32 0, i32 2
  %flags = load i32, ptr %pflags, align 4
  call void asm sideeffect "", "r"(i32 %flags)
  ret void
}

; Spills eax and ecx, putting original esp at +8.
; Stack is dynamically realigned to 16 bytes, and then reloaded to ebp - 8
; Error code is popped from the stack with an increment of 4 before returning
define x86_intrcc void @test_isr_ecode(ptr byval(%struct.interrupt_frame) %frame, i32 %ecode) nounwind {
; CHECK-LABEL: test_isr_ecode:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %ecx
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    cld
; CHECK-NEXT:    movl 4(%ebp), %eax
; CHECK-NEXT:    movl 16(%ebp), %ecx
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    leal -8(%ebp), %esp
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    popl %ecx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_isr_ecode:
; CHECK0:       # %bb.0:
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    pushl %ecx
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    andl $-16, %esp
; CHECK0-NEXT:    cld
; CHECK0-NEXT:    movl 4(%ebp), %ecx
; CHECK0-NEXT:    leal 8(%ebp), %eax
; CHECK0-NEXT:    movl 8(%eax), %eax
; CHECK0-NEXT:    #APP
; CHECK0-NEXT:    #NO_APP
; CHECK0-NEXT:    leal -8(%ebp), %esp
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    popl %ecx
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    addl $4, %esp
; CHECK0-NEXT:    iretl
  %pflags = getelementptr inbounds %struct.interrupt_frame, ptr %frame, i32 0, i32 2
  %flags = load i32, ptr %pflags, align 4
  call x86_fastcallcc void asm sideeffect "", "r,r"(i32 %flags, i32 %ecode)
  ret void
}

; All clobbered registers must be saved
define x86_intrcc void @test_isr_clobbers(ptr byval(%struct.interrupt_frame) %frame, i32 %ecode) nounwind {
; CHECK-LABEL: test_isr_clobbers:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %ecx
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    cld
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    leal -12(%ebp), %esp
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    popl %ecx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_isr_clobbers:
; CHECK0:       # %bb.0:
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    pushl %ecx
; CHECK0-NEXT:    pushl %ebx
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    andl $-16, %esp
; CHECK0-NEXT:    cld
; CHECK0-NEXT:    #APP
; CHECK0-NEXT:    #NO_APP
; CHECK0-NEXT:    leal -12(%ebp), %esp
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    popl %ebx
; CHECK0-NEXT:    popl %ecx
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    addl $4, %esp
; CHECK0-NEXT:    iretl
  call void asm sideeffect "", "~{eax},~{ebx},~{ecx},~{ebp}"()
  ret void
}

@f80 = common global x86_fp80 0xK00000000000000000000, align 4

; Test that the presence of x87 does not crash the FP stackifier
define x86_intrcc void @test_isr_x87(ptr byval(%struct.interrupt_frame) %frame) nounwind {
; CHECK-LABEL: test_isr_x87:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    fldt f80
; CHECK-NEXT:    fld1
; CHECK-NEXT:    faddp %st, %st(1)
; CHECK-NEXT:    fstpt f80
; CHECK-NEXT:    movl %ebp, %esp
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_isr_x87:
; CHECK0:       # %bb.0: # %entry
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    andl $-16, %esp
; CHECK0-NEXT:    fldt f80
; CHECK0-NEXT:    fld1
; CHECK0-NEXT:    faddp %st, %st(1)
; CHECK0-NEXT:    fstpt f80
; CHECK0-NEXT:    movl %ebp, %esp
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    iretl
entry:
  %ld = load x86_fp80, ptr @f80, align 4
  %add = fadd x86_fp80 %ld, 0xK3FFF8000000000000000
  store x86_fp80 %add, ptr @f80, align 4
  ret void
}

; Use the interrupt_frame pointer to check the offsets.
; No return address, arguments start at EBP+4.
define dso_local x86_intrcc void @test_fp_1(ptr byval(%struct.interrupt_frame) %p) #0 {
; CHECK-LABEL: test_fp_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %ecx
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    leal 20(%ebp), %eax
; CHECK-NEXT:    leal 4(%ebp), %ecx
; CHECK-NEXT:    movl %ecx, sink_address
; CHECK-NEXT:    movl %eax, sink_address
; CHECK-NEXT:    leal -8(%ebp), %esp
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    popl %ecx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_fp_1:
; CHECK0:       # %bb.0: # %entry
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    pushl %ecx
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    andl $-16, %esp
; CHECK0-NEXT:    leal 4(%ebp), %ecx
; CHECK0-NEXT:    movl %ecx, %eax
; CHECK0-NEXT:    addl $16, %eax
; CHECK0-NEXT:    movl %ecx, sink_address
; CHECK0-NEXT:    movl %eax, sink_address
; CHECK0-NEXT:    leal -8(%ebp), %esp
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    popl %ecx
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    iretl
entry:
  %arrayidx2 = getelementptr inbounds %struct.interrupt_frame, ptr %p, i32 0, i32 4
  store volatile ptr %p, ptr @sink_address
  store volatile ptr %arrayidx2, ptr @sink_address
  ret void
}

; The error code is between EBP and the interrupt_frame.
define dso_local x86_intrcc void @test_fp_2(ptr byval(%struct.interrupt_frame) %p, i32 %err) #0 {
; CHECK-LABEL: test_fp_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %edx
; CHECK-NEXT:    pushl %ecx
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    movl 4(%ebp), %eax
; CHECK-NEXT:    leal 24(%ebp), %ecx
; CHECK-NEXT:    leal 8(%ebp), %edx
; CHECK-NEXT:    movl %edx, sink_address
; CHECK-NEXT:    movl %ecx, sink_address
; CHECK-NEXT:    movl %eax, sink_i32
; CHECK-NEXT:    leal -12(%ebp), %esp
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    popl %ecx
; CHECK-NEXT:    popl %edx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_fp_2:
; CHECK0:       # %bb.0: # %entry
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    pushl %edx
; CHECK0-NEXT:    pushl %ecx
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    andl $-16, %esp
; CHECK0-NEXT:    movl 4(%ebp), %eax
; CHECK0-NEXT:    leal 8(%ebp), %edx
; CHECK0-NEXT:    movl %edx, %ecx
; CHECK0-NEXT:    addl $16, %ecx
; CHECK0-NEXT:    movl %edx, sink_address
; CHECK0-NEXT:    movl %ecx, sink_address
; CHECK0-NEXT:    movl %eax, sink_i32
; CHECK0-NEXT:    leal -12(%ebp), %esp
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    popl %ecx
; CHECK0-NEXT:    popl %edx
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    addl $4, %esp
; CHECK0-NEXT:    iretl
entry:
  %arrayidx2 = getelementptr inbounds %struct.interrupt_frame, ptr %p, i32 0, i32 4
  store volatile ptr %p, ptr @sink_address
  store volatile ptr %arrayidx2, ptr @sink_address
  store volatile i32 %err, ptr @sink_i32
  ret void
}

; Test argument copy elision when copied to a local alloca.
define x86_intrcc void @test_copy_elide(ptr byval(%struct.interrupt_frame) %frame, i32 %err) #0 {
; CHECK-LABEL: test_copy_elide:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    andl $-16, %esp
; CHECK-NEXT:    leal 4(%ebp), %eax
; CHECK-NEXT:    movl %eax, sink_address
; CHECK-NEXT:    leal -4(%ebp), %esp
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_copy_elide:
; CHECK0:       # %bb.0: # %entry
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    andl $-16, %esp
; CHECK0-NEXT:    movl 4(%ebp), %eax
; CHECK0-NEXT:    leal 4(%ebp), %eax
; CHECK0-NEXT:    movl %eax, sink_address
; CHECK0-NEXT:    leal -4(%ebp), %esp
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    addl $4, %esp
; CHECK0-NEXT:    iretl
entry:
  %err.addr = alloca i32, align 4
  store i32 %err, ptr %err.addr, align 4
  store volatile ptr %err.addr, ptr @sink_address
  ret void
}

; Disabling dynamic realignment with attributes should work
define x86_intrcc void @test_isr_no_realign(ptr byval(%struct.interrupt_frame) %frame) #1 {
; CHECK-LABEL: test_isr_no_realign:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    cld
; CHECK-NEXT:    movl 12(%esp), %eax
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_isr_no_realign:
; CHECK0:       # %bb.0:
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    cld
; CHECK0-NEXT:    leal 4(%esp), %eax
; CHECK0-NEXT:    movl 8(%eax), %eax
; CHECK0-NEXT:    #APP
; CHECK0-NEXT:    #NO_APP
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    iretl
  %pflags = getelementptr inbounds %struct.interrupt_frame, ptr %frame, i32 0, i32 2
  %flags = load i32, ptr %pflags, align 4
  call void asm sideeffect "", "r"(i32 %flags)
  ret void
}

; The stackrealign attribute should work, and the function's alignment
; should be respected over the default 16-byte alignment required by the calling
; convention.
define x86_intrcc void @test_isr_realign(ptr byval(%struct.interrupt_frame) %frame, i32 %ecode) #2 {
; CHECK-LABEL: test_isr_realign:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    pushl %eax
; CHECK-NEXT:    andl $-32, %esp
; CHECK-NEXT:    subl $32, %esp
; CHECK-NEXT:    movl 4(%ebp), %eax
; CHECK-NEXT:    movl %eax, (%esp)
; CHECK-NEXT:    leal -4(%ebp), %esp
; CHECK-NEXT:    popl %eax
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    iretl
;
; CHECK0-LABEL: test_isr_realign:
; CHECK0:       # %bb.0:
; CHECK0-NEXT:    pushl %ebp
; CHECK0-NEXT:    movl %esp, %ebp
; CHECK0-NEXT:    pushl %eax
; CHECK0-NEXT:    andl $-32, %esp
; CHECK0-NEXT:    subl $32, %esp
; CHECK0-NEXT:    movl 4(%ebp), %eax
; CHECK0-NEXT:    movl %eax, (%esp)
; CHECK0-NEXT:    leal -4(%ebp), %esp
; CHECK0-NEXT:    popl %eax
; CHECK0-NEXT:    popl %ebp
; CHECK0-NEXT:    addl $4, %esp
; CHECK0-NEXT:    iretl
  %ecode.stack = alloca i32, align 32
  store i32 %ecode, ptr %ecode.stack
  ret void
}


attributes #0 = { nounwind "frame-pointer"="all" }
attributes #1 = { nounwind "no-realign-stack" }
attributes #2 = { nounwind "stackrealign" }
