/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "kubevirt.io/api/snapshot/v1alpha1"
)

// FakeVirtualMachineSnapshots implements VirtualMachineSnapshotInterface
type FakeVirtualMachineSnapshots struct {
	Fake *FakeSnapshotV1alpha1
	ns   string
}

var virtualmachinesnapshotsResource = v1alpha1.SchemeGroupVersion.WithResource("virtualmachinesnapshots")

var virtualmachinesnapshotsKind = v1alpha1.SchemeGroupVersion.WithKind("VirtualMachineSnapshot")

// Get takes name of the virtualMachineSnapshot, and returns the corresponding virtualMachineSnapshot object, and an error if there is any.
func (c *FakeVirtualMachineSnapshots) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.VirtualMachineSnapshot, err error) {
	emptyResult := &v1alpha1.VirtualMachineSnapshot{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(virtualmachinesnapshotsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineSnapshot), err
}

// List takes label and field selectors, and returns the list of VirtualMachineSnapshots that match those selectors.
func (c *FakeVirtualMachineSnapshots) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VirtualMachineSnapshotList, err error) {
	emptyResult := &v1alpha1.VirtualMachineSnapshotList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(virtualmachinesnapshotsResource, virtualmachinesnapshotsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.VirtualMachineSnapshotList{ListMeta: obj.(*v1alpha1.VirtualMachineSnapshotList).ListMeta}
	for _, item := range obj.(*v1alpha1.VirtualMachineSnapshotList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested virtualMachineSnapshots.
func (c *FakeVirtualMachineSnapshots) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(virtualmachinesnapshotsResource, c.ns, opts))

}

// Create takes the representation of a virtualMachineSnapshot and creates it.  Returns the server's representation of the virtualMachineSnapshot, and an error, if there is any.
func (c *FakeVirtualMachineSnapshots) Create(ctx context.Context, virtualMachineSnapshot *v1alpha1.VirtualMachineSnapshot, opts v1.CreateOptions) (result *v1alpha1.VirtualMachineSnapshot, err error) {
	emptyResult := &v1alpha1.VirtualMachineSnapshot{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(virtualmachinesnapshotsResource, c.ns, virtualMachineSnapshot, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineSnapshot), err
}

// Update takes the representation of a virtualMachineSnapshot and updates it. Returns the server's representation of the virtualMachineSnapshot, and an error, if there is any.
func (c *FakeVirtualMachineSnapshots) Update(ctx context.Context, virtualMachineSnapshot *v1alpha1.VirtualMachineSnapshot, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachineSnapshot, err error) {
	emptyResult := &v1alpha1.VirtualMachineSnapshot{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(virtualmachinesnapshotsResource, c.ns, virtualMachineSnapshot, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineSnapshot), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeVirtualMachineSnapshots) UpdateStatus(ctx context.Context, virtualMachineSnapshot *v1alpha1.VirtualMachineSnapshot, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachineSnapshot, err error) {
	emptyResult := &v1alpha1.VirtualMachineSnapshot{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(virtualmachinesnapshotsResource, "status", c.ns, virtualMachineSnapshot, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineSnapshot), err
}

// Delete takes name of the virtualMachineSnapshot and deletes it. Returns an error if one occurs.
func (c *FakeVirtualMachineSnapshots) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(virtualmachinesnapshotsResource, c.ns, name, opts), &v1alpha1.VirtualMachineSnapshot{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVirtualMachineSnapshots) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(virtualmachinesnapshotsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.VirtualMachineSnapshotList{})
	return err
}

// Patch applies the patch and returns the patched virtualMachineSnapshot.
func (c *FakeVirtualMachineSnapshots) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineSnapshot, err error) {
	emptyResult := &v1alpha1.VirtualMachineSnapshot{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(virtualmachinesnapshotsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.VirtualMachineSnapshot), err
}
