// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A key-value pair. A tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty (null) strings.</p><important>
/// <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p>
/// </important>
/// <p>For information about the rules that apply to tag keys and tag values, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub tag_key: ::std::string::String,
    /// <p>The value of the tag.</p>
    pub tag_value: ::std::string::String,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn tag_key(&self) -> &str {
        use std::ops::Deref;
        self.tag_key.deref()
    }
    /// <p>The value of the tag.</p>
    pub fn tag_value(&self) -> &str {
        use std::ops::Deref;
        self.tag_value.deref()
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::types::Tag).
    pub fn builder() -> crate::types::builders::TagBuilder {
        crate::types::builders::TagBuilder::default()
    }
}

/// A builder for [`Tag`](crate::types::Tag).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct TagBuilder {
    pub(crate) tag_key: ::std::option::Option<::std::string::String>,
    pub(crate) tag_value: ::std::option::Option<::std::string::String>,
}
impl TagBuilder {
    /// <p>The key of the tag.</p>
    /// This field is required.
    pub fn tag_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tag_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The key of the tag.</p>
    pub fn set_tag_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tag_key = input;
        self
    }
    /// <p>The key of the tag.</p>
    pub fn get_tag_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.tag_key
    }
    /// <p>The value of the tag.</p>
    /// This field is required.
    pub fn tag_value(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tag_value = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The value of the tag.</p>
    pub fn set_tag_value(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tag_value = input;
        self
    }
    /// <p>The value of the tag.</p>
    pub fn get_tag_value(&self) -> &::std::option::Option<::std::string::String> {
        &self.tag_value
    }
    /// Consumes the builder and constructs a [`Tag`](crate::types::Tag).
    /// This method will fail if any of the following fields are not set:
    /// - [`tag_key`](crate::types::builders::TagBuilder::tag_key)
    /// - [`tag_value`](crate::types::builders::TagBuilder::tag_value)
    pub fn build(self) -> ::std::result::Result<crate::types::Tag, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::Tag {
            tag_key: self.tag_key.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "tag_key",
                    "tag_key was not specified but it is required when building Tag",
                )
            })?,
            tag_value: self.tag_value.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "tag_value",
                    "tag_value was not specified but it is required when building Tag",
                )
            })?,
        })
    }
}
