// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! error code definitions for the background file copier
use shared::minwindef::DWORD;
pub const BG_E_NOT_FOUND: DWORD = 0x80200001;
pub const BG_E_INVALID_STATE: DWORD = 0x80200002;
pub const BG_E_EMPTY: DWORD = 0x80200003;
pub const BG_E_FILE_NOT_AVAILABLE: DWORD = 0x80200004;
pub const BG_E_PROTOCOL_NOT_AVAILABLE: DWORD = 0x80200005;
pub const BG_S_ERROR_CONTEXT_NONE: DWORD = 0x00200006;
pub const BG_E_ERROR_CONTEXT_UNKNOWN: DWORD = 0x80200007;
pub const BG_E_ERROR_CONTEXT_GENERAL_QUEUE_MANAGER: DWORD = 0x80200008;
pub const BG_E_ERROR_CONTEXT_LOCAL_FILE: DWORD = 0x80200009;
pub const BG_E_ERROR_CONTEXT_REMOTE_FILE: DWORD = 0x8020000A;
pub const BG_E_ERROR_CONTEXT_GENERAL_TRANSPORT: DWORD = 0x8020000B;
pub const BG_E_ERROR_CONTEXT_QUEUE_MANAGER_NOTIFICATION: DWORD = 0x8020000C;
pub const BG_E_DESTINATION_LOCKED: DWORD = 0x8020000D;
pub const BG_E_VOLUME_CHANGED: DWORD = 0x8020000E;
pub const BG_E_ERROR_INFORMATION_UNAVAILABLE: DWORD = 0x8020000F;
pub const BG_E_NETWORK_DISCONNECTED: DWORD = 0x80200010;
pub const BG_E_MISSING_FILE_SIZE: DWORD = 0x80200011;
pub const BG_E_INSUFFICIENT_HTTP_SUPPORT: DWORD = 0x80200012;
pub const BG_E_INSUFFICIENT_RANGE_SUPPORT: DWORD = 0x80200013;
pub const BG_E_REMOTE_NOT_SUPPORTED: DWORD = 0x80200014;
pub const BG_E_NEW_OWNER_DIFF_MAPPING: DWORD = 0x80200015;
pub const BG_E_NEW_OWNER_NO_FILE_ACCESS: DWORD = 0x80200016;
pub const BG_S_PARTIAL_COMPLETE: DWORD = 0x00200017;
pub const BG_E_PROXY_LIST_TOO_LARGE: DWORD = 0x80200018;
pub const BG_E_PROXY_BYPASS_LIST_TOO_LARGE: DWORD = 0x80200019;
pub const BG_S_UNABLE_TO_DELETE_FILES: DWORD = 0x0020001A;
pub const BG_E_INVALID_SERVER_RESPONSE: DWORD = 0x8020001B;
pub const BG_E_TOO_MANY_FILES: DWORD = 0x8020001C;
pub const BG_E_LOCAL_FILE_CHANGED: DWORD = 0x8020001D;
pub const BG_E_ERROR_CONTEXT_REMOTE_APPLICATION: DWORD = 0x8020001E;
pub const BG_E_SESSION_NOT_FOUND: DWORD = 0x8020001F;
pub const BG_E_TOO_LARGE: DWORD = 0x80200020;
pub const BG_E_STRING_TOO_LONG: DWORD = 0x80200021;
pub const BG_E_CLIENT_SERVER_PROTOCOL_MISMATCH: DWORD = 0x80200022;
pub const BG_E_SERVER_EXECUTE_ENABLE: DWORD = 0x80200023;
pub const BG_E_NO_PROGRESS: DWORD = 0x80200024;
pub const BG_E_USERNAME_TOO_LARGE: DWORD = 0x80200025;
pub const BG_E_PASSWORD_TOO_LARGE: DWORD = 0x80200026;
pub const BG_E_INVALID_AUTH_TARGET: DWORD = 0x80200027;
pub const BG_E_INVALID_AUTH_SCHEME: DWORD = 0x80200028;
pub const BG_E_FILE_NOT_FOUND: DWORD = 0x80200029;
pub const BG_S_PROXY_CHANGED: DWORD = 0x0020002A;
pub const BG_E_INVALID_RANGE: DWORD = 0x8020002B;
pub const BG_E_OVERLAPPING_RANGES: DWORD = 0x8020002C;
pub const BG_E_CONNECT_FAILURE: DWORD = 0x8020002D;
pub const BG_E_CONNECTION_CLOSED: DWORD = 0x8020002E;
pub const BG_E_BLOCKED_BY_POLICY: DWORD = 0x8020003E;
pub const BG_E_INVALID_PROXY_INFO: DWORD = 0x8020003F;
pub const BG_E_INVALID_CREDENTIALS: DWORD = 0x80200040;
pub const BG_E_INVALID_HASH_ALGORITHM: DWORD = 0x80200041;
pub const BG_E_RECORD_DELETED: DWORD = 0x80200042;
pub const BG_E_COMMIT_IN_PROGRESS: DWORD = 0x80200043;
pub const BG_E_DISCOVERY_IN_PROGRESS: DWORD = 0x80200044;
pub const BG_E_UPNP_ERROR: DWORD = 0x80200045;
pub const BG_E_TEST_OPTION_BLOCKED_DOWNLOAD: DWORD = 0x80200046;
pub const BG_E_PEERCACHING_DISABLED: DWORD = 0x80200047;
pub const BG_E_BUSYCACHERECORD: DWORD = 0x80200048;
pub const BG_E_TOO_MANY_JOBS_PER_USER: DWORD = 0x80200049;
pub const BG_E_TOO_MANY_JOBS_PER_MACHINE: DWORD = 0x80200050;
pub const BG_E_TOO_MANY_FILES_IN_JOB: DWORD = 0x80200051;
pub const BG_E_TOO_MANY_RANGES_IN_FILE: DWORD = 0x80200052;
pub const BG_E_VALIDATION_FAILED: DWORD = 0x80200053;
pub const BG_E_MAXDOWNLOAD_TIMEOUT: DWORD = 0x80200054;
pub const BG_S_OVERRIDDEN_BY_POLICY: DWORD = 0x00200055;
pub const BG_E_TOKEN_REQUIRED: DWORD = 0x80200056;
pub const BG_E_UNKNOWN_PROPERTY_ID: DWORD = 0x80200057;
pub const BG_E_READ_ONLY_PROPERTY: DWORD = 0x80200058;
pub const BG_E_BLOCKED_BY_COST_TRANSFER_POLICY: DWORD = 0x80200059;
pub const BG_E_PROPERTY_SUPPORTED_FOR_DOWNLOAD_JOBS_ONLY: DWORD = 0x80200060;
pub const BG_E_READ_ONLY_PROPERTY_AFTER_ADDFILE: DWORD = 0x80200061;
pub const BG_E_READ_ONLY_PROPERTY_AFTER_RESUME: DWORD = 0x80200062;
pub const BG_E_MAX_DOWNLOAD_SIZE_INVALID_VALUE: DWORD = 0x80200063;
pub const BG_E_MAX_DOWNLOAD_SIZE_LIMIT_REACHED: DWORD = 0x80200064;
pub const BG_E_STANDBY_MODE: DWORD = 0x80200065;
pub const BG_E_USE_STORED_CREDENTIALS_NOT_SUPPORTED: DWORD = 0x80200066;
pub const BG_E_BLOCKED_BY_BATTERY_POLICY: DWORD = 0x80200067;
pub const BG_E_BLOCKED_BY_BATTERY_SAVER: DWORD = 0x80200068;
pub const BG_E_WATCHDOG_TIMEOUT: DWORD = 0x80200069;
pub const BG_E_APP_PACKAGE_NOT_FOUND: DWORD = 0x8020006A;
pub const BG_E_APP_PACKAGE_SCENARIO_NOT_SUPPORTED: DWORD = 0x8020006B;
pub const BG_E_DATABASE_CORRUPT: DWORD = 0x8020006C;
pub const BG_E_RANDOM_ACCESS_NOT_SUPPORTED: DWORD = 0x8020006D;
pub const BG_E_HTTP_ERROR_100: DWORD = 0x80190064;
pub const BG_E_HTTP_ERROR_101: DWORD = 0x80190065;
pub const BG_E_HTTP_ERROR_200: DWORD = 0x801900C8;
pub const BG_E_HTTP_ERROR_201: DWORD = 0x801900C9;
pub const BG_E_HTTP_ERROR_202: DWORD = 0x801900CA;
pub const BG_E_HTTP_ERROR_203: DWORD = 0x801900CB;
pub const BG_E_HTTP_ERROR_204: DWORD = 0x801900CC;
pub const BG_E_HTTP_ERROR_205: DWORD = 0x801900CD;
pub const BG_E_HTTP_ERROR_206: DWORD = 0x801900CE;
pub const BG_E_HTTP_ERROR_300: DWORD = 0x8019012C;
pub const BG_E_HTTP_ERROR_301: DWORD = 0x8019012D;
pub const BG_E_HTTP_ERROR_302: DWORD = 0x8019012E;
pub const BG_E_HTTP_ERROR_303: DWORD = 0x8019012F;
pub const BG_E_HTTP_ERROR_304: DWORD = 0x80190130;
pub const BG_E_HTTP_ERROR_305: DWORD = 0x80190131;
pub const BG_E_HTTP_ERROR_307: DWORD = 0x80190133;
pub const BG_E_HTTP_ERROR_400: DWORD = 0x80190190;
pub const BG_E_HTTP_ERROR_401: DWORD = 0x80190191;
pub const BG_E_HTTP_ERROR_402: DWORD = 0x80190192;
pub const BG_E_HTTP_ERROR_403: DWORD = 0x80190193;
pub const BG_E_HTTP_ERROR_404: DWORD = 0x80190194;
pub const BG_E_HTTP_ERROR_405: DWORD = 0x80190195;
pub const BG_E_HTTP_ERROR_406: DWORD = 0x80190196;
pub const BG_E_HTTP_ERROR_407: DWORD = 0x80190197;
pub const BG_E_HTTP_ERROR_408: DWORD = 0x80190198;
pub const BG_E_HTTP_ERROR_409: DWORD = 0x80190199;
pub const BG_E_HTTP_ERROR_410: DWORD = 0x8019019A;
pub const BG_E_HTTP_ERROR_411: DWORD = 0x8019019B;
pub const BG_E_HTTP_ERROR_412: DWORD = 0x8019019C;
pub const BG_E_HTTP_ERROR_413: DWORD = 0x8019019D;
pub const BG_E_HTTP_ERROR_414: DWORD = 0x8019019E;
pub const BG_E_HTTP_ERROR_415: DWORD = 0x8019019F;
pub const BG_E_HTTP_ERROR_416: DWORD = 0x801901A0;
pub const BG_E_HTTP_ERROR_417: DWORD = 0x801901A1;
pub const BG_E_HTTP_ERROR_449: DWORD = 0x801901C1;
pub const BG_E_HTTP_ERROR_500: DWORD = 0x801901F4;
pub const BG_E_HTTP_ERROR_501: DWORD = 0x801901F5;
pub const BG_E_HTTP_ERROR_502: DWORD = 0x801901F6;
pub const BG_E_HTTP_ERROR_503: DWORD = 0x801901F7;
pub const BG_E_HTTP_ERROR_504: DWORD = 0x801901F8;
pub const BG_E_HTTP_ERROR_505: DWORD = 0x801901F9;
pub const BITS_MC_JOB_CANCELLED: DWORD = 0x80194000;
pub const BITS_MC_FILE_DELETION_FAILED: DWORD = 0x80194001;
pub const BITS_MC_FILE_DELETION_FAILED_MORE: DWORD = 0x80194002;
pub const BITS_MC_JOB_PROPERTY_CHANGE: DWORD = 0x80194003;
pub const BITS_MC_JOB_TAKE_OWNERSHIP: DWORD = 0x80194004;
pub const BITS_MC_JOB_SCAVENGED: DWORD = 0x80194005;
pub const BITS_MC_JOB_NOTIFICATION_FAILURE: DWORD = 0x80194006;
pub const BITS_MC_STATE_FILE_CORRUPT: DWORD = 0x80194007;
pub const BITS_MC_FAILED_TO_START: DWORD = 0x80194008;
pub const BITS_MC_FATAL_IGD_ERROR: DWORD = 0x80194009;
pub const BITS_MC_PEERCACHING_PORT: DWORD = 0x8019400A;
pub const BITS_MC_WSD_PORT: DWORD = 0x8019400B;
