# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Optional, TYPE_CHECKING

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Copyright(_serialization.Model):
    """This object is returned from a successful copyright request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format_version: Format Version property.
    :vartype format_version: str
    :ivar general_copyrights: General Copyrights array.
    :vartype general_copyrights: list[str]
    :ivar regions: Regions array.
    :vartype regions: list[~azure.maps.render.models.RegionCopyrights]
    """

    _validation = {
        "format_version": {"readonly": True},
        "general_copyrights": {"readonly": True},
        "regions": {"readonly": True},
    }

    _attribute_map = {
        "format_version": {"key": "formatVersion", "type": "str"},
        "general_copyrights": {"key": "generalCopyrights", "type": "[str]"},
        "regions": {"key": "regions", "type": "[RegionCopyrights]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.format_version = None
        self.general_copyrights = None
        self.regions = None


class CopyrightCaption(_serialization.Model):
    """This object is returned from a successful copyright call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format_version: Format Version property.
    :vartype format_version: str
    :ivar copyrights_caption: Copyrights Caption property.
    :vartype copyrights_caption: str
    """

    _validation = {
        "format_version": {"readonly": True},
        "copyrights_caption": {"readonly": True},
    }

    _attribute_map = {
        "format_version": {"key": "formatVersion", "type": "str"},
        "copyrights_caption": {"key": "copyrightsCaption", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.format_version = None
        self.copyrights_caption = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.maps.render.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.maps.render.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.maps.render.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.maps.render.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class MapAttribution(_serialization.Model):
    """Copyright attribution for the requested section of a tileset.

    :ivar copyrights: A list of copyright strings.
    :vartype copyrights: list[str]
    """

    _attribute_map = {
        "copyrights": {"key": "copyrights", "type": "[str]"},
    }

    def __init__(self, *, copyrights: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword copyrights: A list of copyright strings.
        :paramtype copyrights: list[str]
        """
        super().__init__(**kwargs)
        self.copyrights = copyrights


class MapTileset(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metadata for a tileset in the TileJSON format.

    :ivar tilejson: Describes the version of the TileJSON spec that is implemented by this JSON
     object.
    :vartype tilejson: str
    :ivar name: A name describing the tileset. The name can contain any legal character.
     Implementations SHOULD NOT interpret the name as HTML.
    :vartype name: str
    :ivar description: Text description of the tileset. The description can contain any legal
     character. Implementations SHOULD NOT interpret the description as HTML.
    :vartype description: str
    :ivar version: A semver.org style version number for the tiles contained within the tileset.
     When changes across tiles are introduced, the minor version MUST change.
    :vartype version: str
    :ivar attribution: Copyright attribution to be displayed on the map. Implementations MAY decide
     to treat this as HTML or literal text. For security reasons, make absolutely sure that this
     field can't be abused as a vector for XSS or beacon tracking.
    :vartype attribution: str
    :ivar template: A mustache template to be used to format data from grids for interaction.
    :vartype template: str
    :ivar legend: A legend to be displayed with the map. Implementations MAY decide to treat this
     as HTML or literal text. For security reasons, make absolutely sure that this field can't be
     abused as a vector for XSS or beacon tracking.
    :vartype legend: str
    :ivar scheme: Default: "xyz". Either "xyz" or "tms". Influences the y direction of the tile
     coordinates. The global-mercator (aka Spherical Mercator) profile is assumed.
    :vartype scheme: str
    :ivar tiles: An array of tile endpoints. If multiple endpoints are specified, clients may use
     any combination of endpoints. All endpoints MUST return the same content for the same URL. The
     array MUST contain at least one endpoint.
    :vartype tiles: list[str]
    :ivar grids: An array of interactivity endpoints.
    :vartype grids: list[str]
    :ivar data: An array of data files in GeoJSON format.
    :vartype data: list[str]
    :ivar min_zoom: The minimum zoom level.
    :vartype min_zoom: int
    :ivar max_zoom: The maximum zoom level.
    :vartype max_zoom: int
    :ivar bounds: The maximum extent of available map tiles. Bounds MUST define an area covered by
     all zoom levels. The bounds are represented in WGS:84 latitude and longitude values, in the
     order left, bottom, right, top. Values may be integers or floating point numbers.
    :vartype bounds: list[float]
    :ivar center: The default location of the tileset in the form [longitude, latitude, zoom]. The
     zoom level MUST be between minzoom and maxzoom. Implementations can use this value to set the
     default location.
    :vartype center: list[float]
    """

    _validation = {
        "tilejson": {"pattern": r"\d+\.\d+\.\d+\w?[\w\d]*"},
        "version": {"pattern": r"\d+\.\d+\.\d+\w?[\w\d]*"},
        "min_zoom": {"maximum": 30, "minimum": 0},
        "max_zoom": {"maximum": 30, "minimum": 0},
    }

    _attribute_map = {
        "tilejson": {"key": "tilejson", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "attribution": {"key": "attribution", "type": "str"},
        "template": {"key": "template", "type": "str"},
        "legend": {"key": "legend", "type": "str"},
        "scheme": {"key": "scheme", "type": "str"},
        "tiles": {"key": "tiles", "type": "[str]"},
        "grids": {"key": "grids", "type": "[str]"},
        "data": {"key": "data", "type": "[str]"},
        "min_zoom": {"key": "minzoom", "type": "int"},
        "max_zoom": {"key": "maxzoom", "type": "int"},
        "bounds": {"key": "bounds", "type": "[float]"},
        "center": {"key": "center", "type": "[float]"},
    }

    def __init__(
        self,
        *,
        tilejson: Optional[str] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        version: Optional[str] = None,
        attribution: Optional[str] = None,
        template: Optional[str] = None,
        legend: Optional[str] = None,
        scheme: Optional[str] = None,
        tiles: Optional[List[str]] = None,
        grids: Optional[List[str]] = None,
        data: Optional[List[str]] = None,
        min_zoom: Optional[int] = None,
        max_zoom: Optional[int] = None,
        bounds: Optional[List[float]] = None,
        center: Optional[List[float]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tilejson: Describes the version of the TileJSON spec that is implemented by this JSON
         object.
        :paramtype tilejson: str
        :keyword name: A name describing the tileset. The name can contain any legal character.
         Implementations SHOULD NOT interpret the name as HTML.
        :paramtype name: str
        :keyword description: Text description of the tileset. The description can contain any legal
         character. Implementations SHOULD NOT interpret the description as HTML.
        :paramtype description: str
        :keyword version: A semver.org style version number for the tiles contained within the tileset.
         When changes across tiles are introduced, the minor version MUST change.
        :paramtype version: str
        :keyword attribution: Copyright attribution to be displayed on the map. Implementations MAY
         decide to treat this as HTML or literal text. For security reasons, make absolutely sure that
         this field can't be abused as a vector for XSS or beacon tracking.
        :paramtype attribution: str
        :keyword template: A mustache template to be used to format data from grids for interaction.
        :paramtype template: str
        :keyword legend: A legend to be displayed with the map. Implementations MAY decide to treat
         this as HTML or literal text. For security reasons, make absolutely sure that this field can't
         be abused as a vector for XSS or beacon tracking.
        :paramtype legend: str
        :keyword scheme: Default: "xyz". Either "xyz" or "tms". Influences the y direction of the tile
         coordinates. The global-mercator (aka Spherical Mercator) profile is assumed.
        :paramtype scheme: str
        :keyword tiles: An array of tile endpoints. If multiple endpoints are specified, clients may
         use any combination of endpoints. All endpoints MUST return the same content for the same URL.
         The array MUST contain at least one endpoint.
        :paramtype tiles: list[str]
        :keyword grids: An array of interactivity endpoints.
        :paramtype grids: list[str]
        :keyword data: An array of data files in GeoJSON format.
        :paramtype data: list[str]
        :keyword min_zoom: The minimum zoom level.
        :paramtype min_zoom: int
        :keyword max_zoom: The maximum zoom level.
        :paramtype max_zoom: int
        :keyword bounds: The maximum extent of available map tiles. Bounds MUST define an area covered
         by all zoom levels. The bounds are represented in WGS:84 latitude and longitude values, in the
         order left, bottom, right, top. Values may be integers or floating point numbers.
        :paramtype bounds: list[float]
        :keyword center: The default location of the tileset in the form [longitude, latitude, zoom].
         The zoom level MUST be between minzoom and maxzoom. Implementations can use this value to set
         the default location.
        :paramtype center: list[float]
        """
        super().__init__(**kwargs)
        self.tilejson = tilejson
        self.name = name
        self.description = description
        self.version = version
        self.attribution = attribution
        self.template = template
        self.legend = legend
        self.scheme = scheme
        self.tiles = tiles
        self.grids = grids
        self.data = data
        self.min_zoom = min_zoom
        self.max_zoom = max_zoom
        self.bounds = bounds
        self.center = center


class RegionCopyrights(_serialization.Model):
    """RegionCopyrights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar copyrights: Copyrights array.
    :vartype copyrights: list[str]
    :ivar country: Country property.
    :vartype country: ~azure.maps.render.models.RegionCopyrightsCountry
    """

    _validation = {
        "copyrights": {"readonly": True},
        "country": {"readonly": True},
    }

    _attribute_map = {
        "copyrights": {"key": "copyrights", "type": "[str]"},
        "country": {"key": "country", "type": "RegionCopyrightsCountry"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copyrights = None
        self.country = None


class RegionCopyrightsCountry(_serialization.Model):
    """Country property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar iso3: ISO3 property.
    :vartype iso3: str
    :ivar label: Label property.
    :vartype label: str
    """

    _validation = {
        "iso3": {"readonly": True},
        "label": {"readonly": True},
    }

    _attribute_map = {
        "iso3": {"key": "ISO3", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.iso3 = None
        self.label = None
