# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import AzureBotServiceConfiguration
from .operations import BotsOperations
from .operations import ChannelsOperations
from .operations import DirectLineOperations
from .operations import Operations
from .operations import BotConnectionOperations
from . import models


class AzureBotService(SDKClient):
    """Azure Bot Service is a platform for creating smart conversational agents.

    :ivar config: Configuration for client.
    :vartype config: AzureBotServiceConfiguration

    :ivar bots: Bots operations
    :vartype bots: azure.mgmt.botservice.operations.BotsOperations
    :ivar channels: Channels operations
    :vartype channels: azure.mgmt.botservice.operations.ChannelsOperations
    :ivar direct_line: DirectLine operations
    :vartype direct_line: azure.mgmt.botservice.operations.DirectLineOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.botservice.operations.Operations
    :ivar bot_connection: BotConnection operations
    :vartype bot_connection: azure.mgmt.botservice.operations.BotConnectionOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Azure Subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AzureBotServiceConfiguration(credentials, subscription_id, base_url)
        super(AzureBotService, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-06-02'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.bots = BotsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.channels = ChannelsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.direct_line = DirectLineOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.bot_connection = BotConnectionOperations(
            self._client, self.config, self._serialize, self._deserialize)
