/* This file was automatically generated, do not edit */
#include "common.h"
static const unsigned p521_n_tables = 131;
static const unsigned p521_window_size = 4;
static const unsigned p521_points_per_table = 16;
/* Affine coordinates in plain form (not Montgomery) */
/* Table size: 301824 kbytes */
static const uint64_t p521_tables[131][16][2][9] = {
 { /* Table #0 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xF97E7E31C2E5BD66,0x3348B3C1856A429B,0xFE1DC127A2FFA8DE,0xA14B5E77EFE75928,0xF828AF606B4D3DBA,0x9C648139053FB521,0x9E3ECB662395B442,0x858E06B70404E9CD,0x00000000000000C6 },
    { 0x88BE94769FD16650,0x353C7086A272C240,0xC550B9013FAD0761,0x97EE72995EF42640,0x17AFBD17273E662C,0x98F54449579B4468,0x5C8A5FB42C7D1BD9,0x39296A789A3BC004,0x0000000000000118 }
  },
  { /* Point #2 */
    { 0xF43E3933BA6D783D,0xCF2FA364D60FD967,0xAA104A3A35C5AF41,0xB3B204DA6EF55507,0x2C6E5505D769BE97,0x7403279B1CCC0635,0x2FCB288148C28274,0x3C219024277E7E68,0x0000000000000043 },
    { 0x1BE356D661F41B02,0xEAFCBE95EDC0F4F7,0x93937FA99A3248F4,0xB3E377DE9F251F6B,0xAB21A29906C42DBB,0xC6B5107C4DA97740,0xA7F3ECEEEED3F0B5,0xBB8CC7F86DB26700,0x00000000000000F4 }
  },
  { /* Point #3 */
    { 0xA5919D2EDE37AD7D,0xAEB490862C32EA05,0x1DA6BD16B59FE21B,0xAD3F164A3A483205,0xE5AD7A112D7A8DD1,0xB52A6E5B123D9AB9,0xD91D6A64B5959479,0x3D352443DE29195D,0x00000000000001A7 },
    { 0x5F588CA1EE86C0E5,0xF105C9BC93A59042,0x2D5ACED1DEC3C70C,0x2E2DD4CF8DC575B0,0xD2F8AB1FA355CEEC,0xF1557FA82A9D0317,0x979F86C6CAB814F2,0x9B03B97DFA62DDD9,0x000000000000013E }
  },
  { /* Point #4 */
    { 0xFBC87412871902F3,0xA1D5025B08E5A5E2,0xE8B88E9F078AF066,0x8659E24AFE3D0750,0x06C5D55541D3CEAC,0xC61C891C5FF39AFC,0x54B483487C9070CD,0xB5DF64AE2AC204C3,0x0000000000000035 },
    { 0xE21F47FC346E4D0D,0xBB7FAEF04699D1D9,0x5224F750A95B85EE,0x79F283E54BA38540,0x5AE63FE2F19907F2,0x5521AEF6E6E32E1B,0x73E0178EB0B4ABB6,0x096F84261279D2B6,0x0000000000000082 }
  },
  { /* Point #5 */
    { 0xD5AB5096EC8F3078,0x29D7E1E6D8931738,0x7112FEAF137E79A3,0x383C0C6D5E301423,0xCF03DAB8F177ACE4,0x7A596EFDB53F0D24,0x3DBC3391C04EB0BF,0x2BF3C52927A432C7,0x0000000000000065 },
    { 0x173CC3E8DEB090CB,0xD1F007257354F7F8,0x311540211CF5FF79,0xBB6897C9072CF374,0xEDD817C9A0347087,0x1CD8FE8E872E0051,0x8A2B73114A811291,0xE6EF1BDD6601D6EC,0x000000000000015B }
  },
  { /* Point #6 */
    { 0x23731BEDF79206B9,0x2F66E95657F380AE,0xE0727A239531BE8C,0x5FBCCA16153F7394,0x981506ADE4AB0152,0x623D30977FD71CF3,0x2EFF34F94480D195,0x4569D6CDB5921953,0x00000000000001EE },
    { 0x1EACCD7858D44F17,0x3DC7B8B55CA0DADE,0xF96C984DE274F220,0xCAB72D0E56648C9D,0x7240A926201A8A96,0x2AABBB73DA5A808E,0xE2DD270546E3B111,0x0255AD0CC64F586A,0x00000000000001DE }
  },
  { /* Point #7 */
    { 0x01CEAD882816ECD4,0x6F953F50FDC2619A,0xC9A6DF30DCE3BBC4,0x8C308D0ABFC698D8,0xF018D2C2F7114C5D,0x5F22E0E8F5483228,0xEEB65FDA0B073A0C,0xD5D1D99D5B7F6346,0x0000000000000056 },
    { 0x5C6B8BC90525251B,0x9E76712A5DDEFC7B,0x9523A34591CE1A5F,0x6BD0F293CDEC9E2B,0x71DBD98A26CBDE55,0xB5C582D02824F0DD,0xD1D8317A39D68478,0x2D1B7D9BAAA2A110,0x000000000000003D }
  },
  { /* Point #8 */
    { 0x86F9EA54AA78CE68,0xB56289B5A6F40405,0x8B598C1BC8D79E1A,0x5BFEA5B8579F49F0,0x8B8A3B05F826298F,0xD4E29D8A9B003E0A,0xA8348396B010E25B,0x22C40FB6301F7262,0x0000000000000008 },
    { 0x8AD642F11F17801C,0x9F3BA94009471353,0xF0BA0DF065C57869,0x89E9C0AA5911B4BF,0x5083DE610677A8F1,0x44F8EDE9E2C0715B,0x48FDAB6E78853B9A,0x31911D5542FC4820,0x0000000000000163 }
  },
  { /* Point #9 */
    { 0x1F45627967CBE207,0x4F50BABD85CD2866,0xF3C556DF725A318F,0x7429E1396134DA35,0x2C4AB145B8C6B665,0xED34541B98874699,0xA2F5BF157156D488,0x5389E359E1E21826,0x0000000000000158 },
    { 0x3AA0EA86B9AD2A4E,0x736C2AE928880F34,0x0FF56ECF4ABFD87D,0x0D69E5756057AC84,0xC825BA263DDB446E,0x3088A654EE1CEBB6,0x0B55557A27AE938E,0x2E618C9A8AEDF39F,0x000000000000002A }
  },
  { /* Point #10 */
    { 0x87FF09A04F2F3320,0x7C2E411F1A8E819A,0x9DAA4DA9842093F3,0xA2C7C178FCC26329,0x4A9246B11ADA8910,0x901D879AC09AC7C3,0xFCFE7BB6721EC4CD,0xEB8F22BDA61F281D,0x0000000000000190 },
    { 0x2954BC98135EC759,0xF3689639739FAA17,0x536F6163DC57EBEF,0xBF5349D44D9864BB,0xA97FD78A62EF62D2,0xC2EEB2144251B20B,0xBAEAB3B0CA2BA760,0x5D96B8491614BA9D,0x00000000000001EB }
  },
  { /* Point #11 */
    { 0xECC0E02DDA0CDB9A,0x015C024FA4C9A902,0xD19B1AEBE3191085,0xF3DBC5332663DA1B,0x43EF2C54F2991652,0xED5DC7ED7C178495,0x6F1A39573B4315CF,0x75841259FDEDFF54,0x000000000000008A },
    { 0x58874F92CE48C808,0xDCAC80E3F4819B5D,0x3892331914A95336,0x1BC8A90E8B42A4AB,0xED2E95D4E0B9B82B,0x3ADD566210BD0493,0x9D0CA877054FB229,0xFB303FCBBA212984,0x0000000000000096 }
  },
  { /* Point #12 */
    { 0x7BE69571BF842D8C,0x3774C75C530928B1,0x477FEE9A60E93801,0x44E90B7C3FB81B31,0x107CF7A5967713A6,0x81874157958457B6,0xE4FAE9749C7FDE1E,0xD9DCEC93F8221C5D,0x00000000000001C0 },
    { 0x79E7B1A3281B17F0,0x884BA72224F5AE6C,0xCC10A6F951B9B630,0xD6D18843D86FCDB6,0x5E404ABF6A17C097,0x63FE65AB71494DA4,0x3CE1D103A682CA47,0x48B5946A4927C0FE,0x0000000000000140 }
  },
  { /* Point #13 */
    { 0x1887848D32FBCDA7,0x4BEC3B00AB38EFF8,0x3550A5E79AB88EE9,0x32C45908E03C996A,0x4EEDD2BEAF5B8661,0x93F736CDE1B4C238,0xD7865D2B4924861A,0x3E98F984C396AD9C,0x000000000000007E },
    { 0x291A01FB022A71C9,0x6199EAAF9117E9F7,0x26DFDD351CBFBBC3,0xC1BD5D5838BC763F,0x9C7A67AE5C1E212A,0xCED50A386D5421C6,0x1A1926DAA3ED5A08,0xEE58EB6D781FEDA9,0x0000000000000108 }
  },
  { /* Point #14 */
    { 0x2C9E682DD3432D74,0x6767F6B812EFBF5D,0x79DF3E4B7BC744AA,0x74FC06C8B897222D,0xD4FB0BABE0B31999,0x958B401494116A2F,0xE1B8CCFAAF84DED1,0x5BC7DC551B1B65A9,0x0000000000000187 },
    { 0x41669F852700D54A,0x5B690F53A87C84BE,0x11E89BF1D133DC0D,0xD07781B1B4F3584C,0x0847CE9B86D7ED62,0x8470122B8E51826A,0xD66290BBABB4BDFB,0xA4923575DACB5BD2,0x000000000000005C }
  },
  { /* Point #15 */
    { 0xE9AFE337BCB8DB55,0x9B8D96981E3F92BD,0x7875BD1C8FC0331D,0xB91CCE27DBD00FFE,0xD697B532DF128E11,0xB8FBCC30B40A0852,0x41558FC546D4300F,0x6AD89ABCB92465F0,0x000000000000006B },
    { 0x56343480A1475465,0x46FD90CC446ABDD9,0x2148E2232C96C992,0x7E9062C899470A80,0x4B62106997485ED5,0xDF0496A9BAD20CBA,0x7CE64D2333EDBF63,0x68DA271571391D6A,0x00000000000001B4 }
  }
 },
 { /* Table #1 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x3A6C508F81A8402F,0x0DBF5C8007DCDC53,0xE5965DA7985630DF,0x943FF18861CA00A0,0xD632F8D20B188A52,0x2A87F66192FD3F3D,0xDA97DA26AC743B0B,0x7D10D8A89C8AD05D,0x00000000000001D1 },
    { 0x52E272F89BC73ABE,0x9E3004D28D186333,0x0B3075AC9D998852,0xC182E1398DB547AA,0xC7CA30C94B6B82C1,0x1335E4C3B800D50E,0xC714B18D3D3E6972,0x37343C582D77001F,0x000000000000007A }
  },
  { /* Point #2 */
    { 0x47915AB876E56A9E,0x9CF7475CD6C5C782,0x67D69BD6BA5D1F94,0xEA04A35DC73596EC,0xDBA7ECEFB9E5EBD6,0x3E3E16654E068038,0x43707AF94BA15B34,0xBA3596D20A3A4694,0x0000000000000166 },
    { 0x95CA9A9914A156AA,0xCD98C965AB961636,0xB74DE1C7EA0F36DF,0xE204CDB818CDD6B9,0xC1DF01C65C2DD77D,0xFF7BD8BF5FF01967,0x1635E75FF3E08268,0x7B0FF4D1940AB811,0x0000000000000047 }
  },
  { /* Point #3 */
    { 0x87027D612AD879AD,0x641752BD214AEA2C,0xDEDC21B10FF08EE6,0x2DA0980F3F6FBFAC,0x4B3CC8A5803E72F4,0xAE7D6D6672102C33,0x8158E5CAEC62C8CC,0x35DE3B21557462AC,0x00000000000001FB },
    { 0xB1958193D256D46B,0x596F24804841CAE7,0xB7C142E0FB0E3C28,0xE6214D64A1D97E37,0x871294F66CC2E1BA,0x76F27FC94D09E2CC,0xA855B9EC4BB3F5C1,0x34A5AC1587992DED,0x000000000000018D }
  },
  { /* Point #4 */
    { 0xB53DC38CE320F742,0xF5AAB8029A04FD41,0xA7C02C1603E7001D,0x1BEBD3C5EFDA3773,0xB614B9CCF8872D27,0x7EBDBBA81860BBAC,0x4F3D7C0392FEC2A6,0x9AA17DCE1112ECD1,0x00000000000001AB },
    { 0x5AF17058A5F8DF5B,0xC1C1A5DBA0653DD4,0xF4A7B9E3AF958043,0xAC165BA1508D4B10,0x0C63BA369E87AB8B,0x9BB1CC8B2FB1DC1D,0xAA10217C57B9586D,0x8D70EB848E920573,0x0000000000000074 }
  },
  { /* Point #5 */
    { 0xE19A15BD437E2BC8,0x7FC53AE24007851E,0xE8C0B16E93597630,0xCDF7D2A0B83FC6BF,0x31293A9DAF8B0DE1,0x54ECED792DB6458A,0x47749B5DD3F4D699,0xC57327BEF68D676E,0x00000000000000BF },
    { 0x7D44E666E7A2B137,0x88F136D2B737AF35,0xCD66D0FEA49882E8,0x1D9971D0FDB747C6,0x8AFF486AB293A9E3,0x23D4E7636A44B0AB,0x2444864E81AC01C2,0x876EC0738C059532,0x0000000000000152 }
  },
  { /* Point #6 */
    { 0x363301988A0CDCAE,0xAEC73C0BEDE0567F,0x06EEB9D09E703ECE,0xE186A6BDE691A29C,0x6A18AE708BFEFE8E,0x2D462FDB7AA06CBF,0x514395C15D2C26B6,0x2A9DE556C4D6397B,0x0000000000000073 },
    { 0x4BB9959C933C845D,0x8EDF1BF0BF3469BD,0xC5EC420F133FFD1F,0x14415F7B7296E01E,0xD86A7FFD33D9EAC9,0x959253AA8424A686,0x82666FC7AA7FFA7F,0x6BE2B1B7AF012552,0x00000000000001ED }
  },
  { /* Point #7 */
    { 0x2B05A8D8AF1479F7,0x65B390E9BA3231E4,0xD388A2233041C9DC,0xA5B816F119B3DC8E,0xEDD4115A3B9C4734,0x2C8DFCD8A39C61F7,0x551DB00F8D0116E7,0x9CE6F0880D028C25,0x0000000000000131 },
    { 0x77E037B1BA67433B,0x63FA7EDAD9EEC2D6,0x9AFA419E7541D914,0x18F69214F5C81E67,0x4875FA4A30E731FB,0x933EC3A9705AA418,0x05F26F5E1178C743,0xD5F38E18259B440E,0x0000000000000013 }
  },
  { /* Point #8 */
    { 0x76B026E5736FA9E0,0x2E27E720E23413B5,0x51DF70816A5F814F,0x4E49496876271D7D,0xD3124AF75CE07D97,0x3C9698BBC2D6DD2C,0x631C070153023FA8,0xD41259F27E381F83,0x000000000000017C },
    { 0xBC309412C9DFB131,0x0E3434093472A8E4,0x4E69C32464ACE613,0xA49FF4B0DC99AC8C,0x1B4FABC3B1AF9CA9,0xDCE01ED3E7DF7966,0x5330FFDEFBC7A682,0x6E5DF506A8283DCE,0x000000000000006F }
  },
  { /* Point #9 */
    { 0xB6C6114B496390AE,0x2B862ECE4DADA7CB,0xDF38640528F68CED,0xF12E8D4DB5D540B2,0x59AD57343168C958,0x6088C74862AFD5E4,0xB5D90DDF4EDB1906,0x530F0ED17D88DD30,0x00000000000001DA },
    { 0x1F253ED79D45CD21,0x44D19CF461981026,0x1B5711C73470E11D,0x22E833756AF8BAA9,0x32AB7C83202F7CD7,0x6BAEC7CFD4636178,0xEE2BAFA01682BA2A,0x05B831E4FB779983,0x0000000000000062 }
  },
  { /* Point #10 */
    { 0xD80E4665FFC13411,0xAC4EA1ADF90A5E8A,0xD6C3C85FF4FEE481,0x56249FCF6EF58695,0xAD5215FC8FBF6CA0,0xC010C40D9A35889B,0xFE90028FD17BE54C,0x2F5D3E7A53C7E33E,0x0000000000000095 },
    { 0xFEC1958E90F8641F,0x67CC88472E197B29,0x5F08ECD3095DB6E5,0x511F9487C7635598,0x0E1461AD708A0E9C,0xD113919BCE185EB8,0xE2AB3F272FC53700,0x186C166B4963C098,0x000000000000017A }
  },
  { /* Point #11 */
    { 0x6387421863653202,0xD416C7EF4A51311A,0x90941EC8B79EF786,0x619CA79FE9F3995E,0xBF5AD3546F6DD49B,0x787539ACA3F42981,0xF79F47EA42E0D4D5,0x4819E25997E476DB,0x00000000000000C5 },
    { 0x6761EDD85127F218,0x79DEDACD70614BE6,0xE8822CB57B7DE98A,0x11DED9FB57D34D72,0x82E37858F561E31E,0x2BE0F0754AF1D33E,0xE2C6E22825D18A2A,0xC565143C7ADB8AAA,0x00000000000000D9 }
  },
  { /* Point #12 */
    { 0x1BF1F9F54428C10A,0xD9BE38C92D6C6BBE,0x441CA2E5470E394C,0xA33F7EAA2E3EAF3C,0xCCF812578FFE3CEC,0xDA04809F17A70C3F,0xEE503B8AECBC52AB,0xED12C04F787BEA38,0x00000000000001C1 },
    { 0x2970AE71AAEB0D3C,0xD4819B4499CEFAD4,0x96012EDDD643E12A,0x337E5261A9FB2470,0x2C57CB9D355BC07F,0xCE61E182D0887816,0xCF49031675E79A0A,0xD70E14087D3A550D,0x00000000000001E3 }
  },
  { /* Point #13 */
    { 0x7878F47688870BCE,0x7A6E6C8F3CC55CB9,0x2C266D75E49B2DBE,0xB8B64B634053EA24,0x46334EA460932B83,0xB4126A8B7AC39BAE,0x33A6EE2A7B51D11C,0x5A2FACA98AB7FD69,0x00000000000001B9 },
    { 0x900220D2ECFC45F0,0x329FF0EA52317BAC,0x013480365D77381E,0xB927D66DCC88FFCE,0x3B62BB50842F8D7D,0xFDF0C8E6A08FB889,0xB4307F0F9719E502,0x3D157C2C9A023C02,0x00000000000000FE }
  },
  { /* Point #14 */
    { 0x35314DA4524329B3,0xC6F68816C9024B82,0x5D4D5F5EC6B610B3,0xA508EA32073E164B,0x701E11A6090A77AE,0x95A71011F0D7A82F,0xE3C50A974876A42D,0x96B9721095A8BDA1,0x00000000000000DF },
    { 0x18CB5A1C833A18EE,0x812916BDA846A701,0xBFBF7D90638F365C,0x021F8C3F0C2B852B,0x789BA7AA10631033,0xDC981F3BF3F8218E,0x0E1EF161299ACB73,0xDAB93898AB9548EB,0x0000000000000067 }
  },
  { /* Point #15 */
    { 0x18FC53966C3FBB5D,0x5E8FD2DF217CDE8F,0x073FD658280F3EE4,0xCF876DC752343E59,0xCB56F97187866F75,0x72D0FA6495D297F8,0xD789B84E9C4B4D8B,0x960AC63E5F186B50,0x000000000000016E },
    { 0x6363F9268EBC68F6,0x7A7E35DA56CAE561,0x3166DE4582E68425,0xE417D73826F732C9,0xD1D2C014E8596CE8,0x7F4C055F97053020,0x4D0662E88926276C,0x673349FF3E93EDEB,0x0000000000000113 }
  }
 },
 { /* Table #2 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xB38E8B9069BE00AC,0xE46B33CB95E50B81,0x9C9152C41F5D4723,0x7B8F4F6E8C2A465A,0xB85FA9E8F269CB33,0x03C7389ECB5B47A9,0x458AFC780F312E99,0xF40A0F02B5AC20C9,0x00000000000001D5 },
    { 0x8FAC1245486BDE7F,0x1430CD504D4A7784,0x58D2B99DBD29A67B,0x965CF65738E3BCEB,0x062DC3AA57354F17,0x40ED2A81E5B45635,0x981BBA93103B69C5,0x3503AA73413C42FC,0x000000000000008E }
  },
  { /* Point #2 */
    { 0xA48E3C3A9BD47F93,0x4E1485E3636C0850,0xD8264F7FF0EA4F3C,0x0B9047FC044463C8,0xB03311C98360FDF8,0x007C068DD0DB7F48,0x5E82C7E7D429AF87,0x5A81286A6D64D318,0x000000000000000E },
    { 0xE1D75C7EEF97408E,0x7C54B93F58A5E905,0x0D8EEE9A08C607D5,0x2AEAC3B0E2DEC0B5,0x96DB5CED9FC99E2C,0x27764DE20A51C0AC,0x7999170F1B15AD22,0xDCFC7192CED85F26,0x0000000000000137 }
  },
  { /* Point #3 */
    { 0x49EB72C3F62A4087,0xEC8734325B00B2BF,0xBB040159643C12A4,0x2EF972F4EAC95679,0xC7E358BD2BBEA697,0x924A6105DB23F1B4,0xD587C6BEBDD61FE2,0xF348D2F7AAFC22CE,0x0000000000000058 },
    { 0x7BF1DEEC930F49AA,0xFD3224C43CEC939A,0xAC7ECED36D94E0BF,0x5EF5A81CB2C7B10F,0xA6E9C773F85C84D4,0xE139B7AB2F547B59,0x436BFFD61FD522DB,0x32EE281E0B189B69,0x0000000000000073 }
  },
  { /* Point #4 */
    { 0x8A4D6B672986DAF8,0xFF67C35D3F0247B1,0x3E45F2E50F48C2D6,0xBA941FA43663525B,0xFE5A47AF97FBDB12,0x617A16B820AE9103,0xFD6EEE9FC57A09D0,0x4BFFFDBEAD5FAD3B,0x000000000000018C },
    { 0x7C2CD6FCE8839B07,0xEE10CAB923601344,0xCEED18245F0B8F0B,0x6EA30ADB68064245,0x66306DADBF29705F,0x4F9D0131BE7DB901,0x1D972C0A531D35DD,0x0FF3DA3C08EDCC09,0x00000000000000C9 }
  },
  { /* Point #5 */
    { 0xB491062B1C6CAC89,0xF20C58359ADECC2E,0x488D7B916F1D7401,0xFF98B90E94761E60,0xE63993CA857557A9,0xC4FF9951ACDEADFC,0xED5A53C7FD8DCCAD,0x42E02C14F101C24A,0x000000000000012B },
    { 0xBB9FE6F6BD3FE0EF,0x72F26FFCC1393D0B,0x2E831B196C25ED19,0xDB50A0D7EBCC6B99,0x202AC3C8245C479C,0x97B284D7436117A0,0x13BD5E82FD694E11,0x452B5A94022193A6,0x00000000000001C8 }
  },
  { /* Point #6 */
    { 0x65C7757B84367FEC,0x7FF69A4B6AA22FB7,0x197F4C3659B0A103,0x897241B712350397,0xEFB60DD033BF2644,0x3ED30A65944AF798,0xD67A5CBD5BD2D770,0xE9D97EA6F3CAA508,0x000000000000006E },
    { 0x94633F8662FC83A9,0x6D68A34729A5137E,0x88F2B4777BF9924D,0x7BD70FCC00B533FB,0x4DD3B695B7B8167F,0x85DFCA1CD0162981,0x2F96A81F43E5022C,0x2596B2EF14872DDF,0x0000000000000131 }
  },
  { /* Point #7 */
    { 0xD59595D1D131F694,0xCE8A83752A7FDC21,0x9E62E8B175869627,0x336D78456E01B014,0xB53ACB366EA5A8ED,0x4451F2E57DD8AC89,0x4C8CF19C2BC29533,0xFBC29EF47C10E63F,0x000000000000017C },
    { 0x9BC2EC347A9357FA,0xDE489A133B8A04AF,0xB3521CDA230520B7,0xD7699690AF6DEB0D,0xACE1AF3A14655A0F,0xF628697FCD89B94B,0x40A71EA33C079AB6,0xE7B89297FD251809,0x00000000000001DB }
  },
  { /* Point #8 */
    { 0xD00804524043C91D,0xE3362D2A01D9A152,0x3D143282404673DA,0x1D1C9B70A881D770,0x4254627ED4A785A8,0xF801104F2D8B8D09,0x306F6F22C6CECA92,0xF0529D16130418EA,0x000000000000011B },
    { 0xFA1E73FD6D8F9FA8,0xB402CACCEAA0860B,0xCB08D922AE11AE49,0x79908F8F76387F9B,0x126B0EBAB8B14819,0x156A5EA63BB333A0,0x0BA63111FE7F302F,0x225EE26A4CD4F889,0x00000000000001D0 }
  },
  { /* Point #9 */
    { 0x4300169A60B57216,0x0143C544441BC961,0xA682548D7FEF586C,0xF064F99EE993FE8D,0x169A43DBDEBA875B,0x935CE8BF6D3CD064,0xE986A7CB7C9700DD,0x1447FBEA51C0F10F,0x0000000000000117 },
    { 0xF10CF577E3ADF2D8,0xFD750660BF433D46,0x4944B8842395CE48,0x63C24A4DC1725875,0xB12376D0F3392F50,0x9FB12A1A97588187,0x3C03CC124BB92450,0x26F27FE0B4E9C733,0x00000000000000C8 }
  },
  { /* Point #10 */
    { 0xDCF42B383B9E35B6,0x5B92CC18D2A99F54,0x55D1C68C30E7C057,0x3A66CBA43A7BD12B,0xBD21276482B879E6,0xD0154D7D0BCA108E,0x1E0C926FB273E3A1,0xF063B1FD5E005F6E,0x0000000000000169 },
    { 0x7EEA86AA702DD8E1,0x4ED21F67FB054211,0xFC634D80C3B592F6,0x36066F725AFADB07,0x11244608875383F9,0x57A100127C01DD73,0xFA53012F4EEA7D92,0x32FC27C706E46A11,0x0000000000000151 }
  },
  { /* Point #11 */
    { 0xFE87DDE0D9E02E98,0x416547E5C932A7D3,0xBAC5A7827D904335,0x7077AB520FA3993D,0xBE4EACB39EA4D3E5,0xCDDB4006F56DF114,0x0C4FCCA5A34C7B12,0xA1450A3A05DC8144,0x0000000000000178 },
    { 0xB5D6B79945594505,0xC1E8F726DD0AC080,0x6269B2A1E2D97D82,0xE9C9E6E320004746,0xAB497CFAA7F067F5,0x55FDF3A16DFBD572,0xFB825D8470231374,0xBE464555E606857A,0x00000000000000DA }
  },
  { /* Point #12 */
    { 0xA0242D2359B58CFE,0xDD86E8CADF33A5CA,0xF5108BC2B08CBF3A,0x4EB5D82BDA1733EC,0x01EB740244DFAC1D,0x66F1CA152A30CD80,0xDE973C30BFD63E5D,0xEDA12FAF640918E8,0x0000000000000148 },
    { 0x250A8D93BD70515D,0xB2D0389B15F9705B,0x4845788F4EE84CEE,0x88926B3283F6FE3E,0xD487DE769E834D93,0x3E4A88E11B7DFAA1,0x10B6759DE684BEB9,0xEFC2282FFC887B1A,0x0000000000000021 }
  },
  { /* Point #13 */
    { 0x34CDF57179FBA304,0x2DA4C0B855CBA8EA,0xFA08EDB0E3AB7E7C,0x89BB570A1176D554,0x13F14AECF620989D,0x070496CF73AB04D1,0x0FD6E1E4E776B1A0,0x6BE78274E938CBF6,0x00000000000000D9 },
    { 0x8C93BC922CEA82B4,0x841A245A8F61CC83,0xF6D7371707B43460,0x17789F54496E9107,0xD79A87DABF60AB90,0xCCB42770F04F3232,0xDA9DC1DEAAEB6908,0x0389467E83B7BD43,0x0000000000000081 }
  },
  { /* Point #14 */
    { 0x536183888CC1B1D8,0xC4CAA4F436009A81,0xBE295BA7DB665AA6,0x4CA4E46FBC0A3DF2,0xFA5D29B60BEEA0F1,0xEB13931E86C30CBB,0xC3FBE7B253EC9EE4,0x95A931572B98E62D,0x0000000000000003 },
    { 0xF8EF16326477DDD7,0x87AD8C3B79FE61F1,0x5D00661FB635ECEC,0x181527820F321C67,0x4819373F635BBA1E,0xDE36D5089A09EB68,0x48D4A31BB4C9AA92,0x28C3F527BB549DB3,0x0000000000000182 }
  },
  { /* Point #15 */
    { 0x16A72EB79E6DBB64,0x0E4A2F79DDD1A126,0xA231A534482B6A66,0xD1506E255F4424B5,0x72869485B848CBB7,0x8110E25977260252,0x4F3776FA6132F329,0x71CE95F6F911712C,0x00000000000000C9 },
    { 0x85E3DE361C4417D8,0x26E85989703B3B41,0xCB1F8AB41D0DA946,0xE042EA5196C2E272,0xE2255E1F662C470C,0xA1BD3D5672C1F8B9,0x38698FD77FD14593,0x4B9EDA73F820EE6D,0x00000000000000ED }
  }
 },
 { /* Table #3 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xE070A145E4FFAC9B,0xF8295455AA280FFF,0xA2D6CF897010805F,0x04E130893220FF7C,0x5935E6E2AD11681E,0xD91EFB7BB9CEF2BC,0x3C260B9914BB8C4D,0x24BF88D53A265599,0x00000000000000F0 },
    { 0x1FF2439CCC9C279A,0xDFCD0B6E90BAB4CF,0xFA08A7BAC3ACBFDA,0xC91B8F40CDB22A56,0x9624AC18672BE103,0x1E59BAC0A7CB0F83,0xAE0AA78EED5F94C6,0x9655B8C3B43029E1,0x0000000000000052 }
  },
  { /* Point #2 */
    { 0x2172A8AA81A7B4C3,0x97CA8DFDABF93BBD,0x2525D8CAF37D1211,0x16442A63917E5726,0xC67B9EC8E12467BC,0x53240D523C5227E1,0x6F6049267101B132,0x70DA1AC7DE1A0F56,0x0000000000000086 },
    { 0x8D0C56BE53E7DCDD,0xCA55C626EABC48DE,0xD4CBC52A585CA3C4,0xA36F240277288D74,0x42922EBCF7FF687F,0x482022CD5EFBB12D,0xE539F2AA7A1ABED1,0x561C207037C7469F,0x00000000000000C7 }
  },
  { /* Point #3 */
    { 0x662D7D3C98AAFDD1,0x4C72AB8A21107B4C,0x74CD96B0C2DDDBF7,0x27BA0E3F20376ABD,0xA41A23C9867E8CFB,0x36E5053845117BAE,0xF399D347E45A9E79,0x97CB97789E482DF2,0x00000000000000E7 },
    { 0x5672082F015672D3,0x11445C3C2FF3D33E,0x296735E20504B408,0xF8E18280EFB627D0,0x85FB2222DD1A08E2,0x4EC184A2AF77422C,0x2D0C1A447AA7FA0E,0x7E99ACD0232261EB,0x00000000000001E4 }
  },
  { /* Point #4 */
    { 0x6DB672C63A46CAEF,0x999560BF8BD02589,0x53E343871D900FA3,0x33C80C2C53D2590E,0x3B11EAD69801A393,0xC6701879591E52F0,0xC1C1982D60428399,0x77D747971932418F,0x0000000000000177 },
    { 0xA4F615A05B4FA0EC,0xB5AFE599059EB5C5,0x1260BA581142B875,0x3CC654ABF4F69AE0,0x0422AC16AB6D27BD,0x119F316ACAE65C55,0x3EC0A913E15B6C6F,0x1603620E0AE71C5A,0x000000000000008D }
  },
  { /* Point #5 */
    { 0xF6AC59C2C7904DCC,0xF34A643830E7A7C0,0x4D7D7ECBBBEF0274,0x13E0295787E2E8A3,0x0B9855402A250A6F,0x26A87784BCF9DC53,0x34AF454BBA65EC34,0x8CD8460C721F360C,0x000000000000001F },
    { 0x1A082A89FC08A52A,0xB8823064365F3B53,0xB1A9A67189580CDE,0x5D46AEF87E949F3D,0x194EEBDDD2E6F058,0xF047FDF47462EC31,0xDD84132D541D8A7E,0xD39482B8F113644F,0x00000000000000DC }
  },
  { /* Point #6 */
    { 0x7019C040506F1FE1,0x778F80BCC4BEFA38,0x6DC34B4CFB8F9D92,0xB40677552B59A187,0x33C1624D7478D103,0x956D0B7201EE3CD2,0x0B39D9E79F6D3A97,0xD218496EDAF21B3F,0x000000000000012A },
    { 0xF86D7E3E295F5C04,0x2D528A03A191CE1A,0x5BC2A444263F9BA7,0x2938B354D9386B2E,0xC9CE878A7E64A3C2,0xEC2F0E542E30D794,0x565A6BFD75CA4503,0xC1F1FE241B393130,0x00000000000000C0 }
  },
  { /* Point #7 */
    { 0x0F666997D28EA0E9,0x0B94AAA07243DF5F,0x23328026C3462336,0x17B1E2B1E78749F5,0x785D0AAB0F956995,0xD5693FA266006613,0xE86B26BF48D1E0AB,0xAB68CEFD7AF1BCCB,0x00000000000000AE },
    { 0x5468DF6D8046E012,0xC0D6DD8CAB17D13B,0x84DE5691FD0D9B38,0xE897F4E05FB3B96A,0x23D39D56E6E4AE24,0x9EBA39B17DE8ED15,0xF6BF29ABA6C3D45A,0x1E7B58B28DE19508,0x0000000000000169 }
  },
  { /* Point #8 */
    { 0x7D5F8E474538E761,0x37C788724C878738,0xE69F4711816427F0,0x4DA6F4677315C7D8,0xF4665C460E84D136,0x6B6C9C506A9D82D0,0xAB5D9FEC1A96FCD2,0x9ED96C86F7974F3A,0x000000000000011A },
    { 0xBECFF7179A66D7AC,0x67D08B6D8F4F08B6,0x0F7CE5BEC02E60AC,0xCAE69A50294AED52,0xB1E2278E10970DFC,0x618459AF75B3E40E,0xE395787DED5E54A0,0xCD8A442BE862C8FF,0x000000000000001C }
  },
  { /* Point #9 */
    { 0x4F724FF71133985C,0x3E3618BA3F161965,0x1DCFE4B72C6B9E64,0x9FCCE3A3A12B7534,0x4B71FDD824E1798B,0xD78BC5552C0C4CE6,0x4DEF17AACD0CAEDF,0x52E97071841B7AD1,0x000000000000000A },
    { 0xCEC7D692DD09461A,0xF09CDDDC28FCE58E,0x6EA8820BBB89A006,0xE46FDC6F35F4A19A,0x80F9DF514EEE996A,0x5567A8401FEC8614,0x1EA4EE6A50EB5B5B,0xD9D1F547766ACE17,0x000000000000013A }
  },
  { /* Point #10 */
    { 0x876924241824475A,0x39D1A041BC45DAC4,0xB72C4B7F729C82A3,0xFB120F1B2438B751,0x994B8B183AF493B3,0x6518212CC3143275,0xC3BB533B19E429F2,0x1A9114CAC1ACEA22,0x00000000000001B0 },
    { 0x3DB5D0930FE7035E,0xCF413874F05A5A64,0x7B8B3A5F8D20FAC0,0x5538938C7334F425,0x3FF2276F9917919F,0xBAE34F1A27E3AA24,0x4D4C327286F38F05,0xD5597867FDBE97AB,0x0000000000000016 }
  },
  { /* Point #11 */
    { 0x3E0D676B96E17CE4,0xEDDE67B9F93547AC,0x5C7F91CA6D2ABB26,0x50B68857F015C080,0x190B5C6792E0541B,0x9FFDF76A41A1BC70,0xCBBC0581907EE4AA,0xA3CBDF3ABA86B55C,0x00000000000000F9 },
    { 0xDCD74CAEBF7C2D0B,0xA3014C48E6C980EB,0x9EA5B9425BCE8B7F,0x30E21DF1B6DEFBD6,0xDF4616DB12C9E0C9,0xDEA9B40825638D31,0xBE99E13A2122619F,0xB0B232C03F9D74DA,0x000000000000016D }
  },
  { /* Point #12 */
    { 0x501C5422910040B2,0x3D8FADEF6FD18A7D,0x1CA9754CC159F2E8,0x3E337074F3570CC6,0x8D2E0B274F64C1B0,0xB458964157D8E707,0xDB9C20FF3B377E8C,0xE202CB7E3C7A95BB,0x000000000000014C },
    { 0x443B521528898156,0xC803D7D24D94AE93,0x768497C3AA70513B,0x48E7031ADB916475,0x7668DEE27654C9A3,0x9D9403B272EB0122,0x28EAEFD23999B060,0x663B8A7974C55442,0x000000000000017B }
  },
  { /* Point #13 */
    { 0xB2BCC0203DACAF48,0x1FCD5C80142FCDBF,0xDDBEA09734CFEA61,0x59118968880F06DB,0xE379BC2641FD5C20,0x8520D72F29E7776A,0x6D147F35F686797B,0x9CC62B1F2F098D55,0x0000000000000117 },
    { 0x5CD20F47384E730F,0x61D5C9EE14763178,0xBB7BAA73FA537B73,0x868AC657DBB155DC,0xBDD0D24A23664C04,0x9EA2754103303148,0xED31A9B6E5D7E643,0x4C401780E8C44767,0x00000000000001D0 }
  },
  { /* Point #14 */
    { 0x6A4D0775C14112C0,0x580C55353ED0A7DC,0x370CF6BD60D5357D,0xB3CB84DEB876925B,0x88D1CC95459A4CD7,0x71E86B49596B6AB7,0xC347DBAF9202EAAF,0x4D503F0CBC8723FB,0x000000000000014A },
    { 0xB2A44B8D31E9A01A,0xD7440433DEDFDD7C,0x88F4DC0BF014DD5D,0xF9BDDFF34C05A58E,0xEAF6C10266C5906F,0x125E3FFF951CB04F,0x6E83C2FE471481E7,0x2A0FB22634FC585A,0x00000000000000BB }
  },
  { /* Point #15 */
    { 0x7E7193FFBA2E2480,0x9EB55534D64C043E,0x4CF71A2B94850DB1,0x5CB892790726A9CE,0x34AC7422D1C18F14,0xD7ADB5FE9F2D685E,0xB1DD2251C8498977,0x5A313AD5E32B83BC,0x000000000000011F },
    { 0x4F55F07346DAA5CD,0x8112526A6CA24109,0xC968813975EB0DEF,0x6081FD1DB29C8C81,0x492941ECA06DD84E,0x49A785D5F48713A1,0x1D98268DE82293D3,0xD56430DFFF0B6231,0x00000000000001B7 }
  }
 },
 { /* Table #4 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xA3480D58CAA4BEC3,0x389489935989E4A0,0x3F4D7B6C6F7BA4CA,0xE2913A55D39CB2AE,0x615043EAD7BE6499,0x9D4C41CBF504FEC3,0x4F93DA968D44893B,0x33A7ACDC9A7928E0,0x0000000000000013 },
    { 0xC865844F48219A09,0xA6D0B17937426BDC,0x7386A0A6284AE0E6,0xDDD6CBA0C2DC16FC,0x77D2934D2940D262,0x3AF6ED35741B88AB,0x96F43A65A6DAE43F,0xC71435351414083B,0x0000000000000057 }
  },
  { /* Point #2 */
    { 0x394D510624891F36,0xB4265C4F825FA293,0x65A54B87F6ECBD5E,0x6A2F900F2A351A03,0xFB26D52F8D1DAD9C,0xBD651F19BA2C39CC,0x2D5894F2BB30ED5A,0x4CC3F05794732EC9,0x00000000000000C3 },
    { 0x8C03CCDC9BFEC4FF,0x4CE76352D52329C8,0x0A92CDF03995D109,0x44D28A5D7518BA0C,0xBD74ECEFCE16A6A6,0xCAB52531123CB82F,0x72065B99F34E1C5F,0x4949379F03A9A916,0x0000000000000164 }
  },
  { /* Point #3 */
    { 0xD49BEA9D0D67EE97,0x3B54996FF8CE59AA,0x609F5808F5862792,0x8FFF6EE3BF16A7B1,0x2D515A919EF889A0,0x9FDAD17ECC6A85C3,0xA93C168B54D161D4,0x269CBD3FD42907B7,0x0000000000000077 },
    { 0xEFBDC466CC9BC5AE,0x562163329F2D0ABD,0x567A46BC78B7F191,0xFE6F5FFE55CB85EB,0xB6A1BD3A1FA1E9B7,0x92A1F94DB23AA4A1,0x8706DF4E85B417C5,0x80F8E27972C38E1D,0x00000000000001F5 }
  },
  { /* Point #4 */
    { 0xB3EE676376229445,0xF39BDB10FED827FE,0xBBD917775ABBF64C,0x260EE1D529A83FA6,0xA0FB51A9E14C0321,0xE285DA4285203855,0x5C8AB2D255550C91,0x88A94F055E3E844A,0x000000000000006C },
    { 0xE2C20AF1885E1B36,0x93632BFB5132EB84,0x8EC0A26AEEC26E58,0xA189AA9BC1A0B075,0x3786BE8FFF4A93F9,0xAF4ACE63E4302FC2,0xC19AE28D5856207E,0xCD791D4E5425099B,0x000000000000013C }
  },
  { /* Point #5 */
    { 0x782A46B3A45742D3,0x7FB395DC9AE4F831,0xAA0A249906715575,0x336DD153987995C6,0x5678C82A70D00FCB,0xDC87A87233B45F8B,0xD5B269003498DFA5,0xA8EF2E81410F7C71,0x00000000000000EC },
    { 0x00E42EF069A89D17,0xDFD638D21DE60EE9,0x5E3E68A98E2A3B24,0x19D1CC8AD7A07F7C,0xD84E18094D2C9B89,0x7674BFD1FD778F5F,0x962735A61E2B3490,0x9AD592A5F535952D,0x0000000000000031 }
  },
  { /* Point #6 */
    { 0x80D754CBAF63A6FF,0xA4F718C114970F91,0x33767545B184B25C,0xCB615B6126115598,0xDDC1E848B0EC3A99,0x238885AE7A9EE0F4,0x4F434C1A70CFF1AF,0xA5D8F62804F92877,0x0000000000000103 },
    { 0x889A468CF5E7B21C,0x42C6B1284F73F4C1,0xC825355FEA99C1C9,0xDFABD44EB8502CAB,0x2C19C4F8078FF997,0x766BE192F948436E,0xC086DDD4D3DCDF09,0xF28F946C1D8FD86B,0x00000000000001FF }
  },
  { /* Point #7 */
    { 0x9DDC754CAE4622FA,0xAC04C42905C5947F,0x0B53D6DB2DBFB6A4,0x1FB16F7B883C6D42,0xE38B1745E5DBAB18,0xA320F80A0087B164,0x4A5C274F32CD4694,0xE32650C10855DC1F,0x00000000000000CE },
    { 0xF1C1A8C55997C5B5,0x3A20FF072E051A16,0xBAACCCE236A4BC59,0x72AE4A192C407BFD,0x0ADA1E57C128C710,0xF4CE04DBB2D91FF3,0x8616DA8731FD0538,0x5C19B57F245B59F8,0x000000000000010B }
  },
  { /* Point #8 */
    { 0x44EDF8BE84357B3F,0xE5DF9129588059D0,0x83E65CFAAB7D5B23,0x79C2E1982121A504,0xE6A19633EB3BE7D1,0xD9F8869586B85BC4,0x78508FA279F2187C,0xA2EB8FC012254F09,0x00000000000000AE },
    { 0xB1A6704E2797D3FA,0x95B4C2682C78669F,0x5294A8E42997C68D,0x7246B0614085BAD5,0x7CA017C24159E5EF,0xB8FE1A6187D1A013,0xDBA0DCDE44BC4EA3,0x1FDD53C6A8CE296F,0x00000000000000FE }
  },
  { /* Point #9 */
    { 0x7DBC777CC8EDA3E4,0xF93443A53D138B69,0xF88673FABE32F323,0xC53F686EAF91501E,0x2C583A94A9E8DF0F,0xDBB476A579A360BF,0xD6D61DEBED573377,0x8BF9489DD85E7CE8,0x0000000000000186 },
    { 0x4EA12CF58C06659E,0x3A5DF265FBC275D3,0x434F440BA5EA596B,0xA386793E82EC727B,0x4F4D4575B4AF3144,0x465AAE52B64CD799,0x4C7C443401DD7DF8,0xC7D3008E40EC3273,0x00000000000001E3 }
  },
  { /* Point #10 */
    { 0xD06FCBB8CBDD8953,0x5A7495784A83DA15,0x9A509298FBDBF149,0xE87856427B745CC2,0xF473E129B6B6EA45,0x325E846F5982DF34,0x2761BCBF39C922DB,0xD598487A4C8A1843,0x0000000000000141 },
    { 0x4D4CE00E255DBEE0,0xB990DF3E75A0E0FA,0x947755B894297A3B,0x4797193FBF7A683B,0xE3BE49554C1F5E73,0x0EBABF7CE3832A6E,0x55AA92BB16574DF2,0xD05F35E66ACE50F8,0x0000000000000032 }
  },
  { /* Point #11 */
    { 0x28E8D7CDAB4F88E3,0x898BAEC98EC7FD82,0x13328D8EC459C3FB,0xA635E9B13B0493EF,0x039493381DDFF9B3,0x93F2886CFF82A4FD,0x9CB165730C609C2C,0xAB282B67AE8E6E06,0x000000000000018D },
    { 0xC16FBD160792DCFB,0xC42BBE74ADF64DB7,0xC85534C4315F21D9,0x66CD4CD3747B8361,0xCD26CBE3F33752B1,0x185ADD8554D2BFA6,0xAC366F9F3364F9B0,0xDB6B5E544188B82E,0x00000000000000F0 }
  },
  { /* Point #12 */
    { 0x5E597D089B0A6B1C,0x3ED100FAB66AD53D,0x9852718497C12A70,0x295556E631779D59,0x9733135A0D5A0720,0x4CF945E66F937863,0x8289D86B87679E05,0x1979CF02F3B45D70,0x00000000000001B1 },
    { 0xECA4684BE1874574,0x4CDE87B963EC3EBB,0x74486FF281B929CA,0xCF9C54DD5113E211,0x95BBC0E1B8237581,0xA92320F70FE355E7,0x945A1A0345B9DBD3,0xEBBC1D0D4C99791A,0x0000000000000143 }
  },
  { /* Point #13 */
    { 0x74FF5C5188E250D1,0x46E6A1DEDC911CEC,0xC28BA25B48C5291A,0x0F571B2AA9FDE68C,0x1C7D3FE989952038,0x40B66DAB6A4850F9,0xF2A3DB3956AF4D75,0x9861204F03123BA0,0x000000000000016E },
    { 0x1ECDBBD45AC22CD7,0xE7349A910000BE6F,0xFF94C6A2327586B9,0xE78C257F7E123652,0x18E795C5AAEBCAF2,0x7DFFC5B363C70794,0x6C3B3D2067E76A08,0x820B7E33AFBA9F7E,0x00000000000001CF }
  },
  { /* Point #14 */
    { 0x932645E87ADA2A97,0x21C7EBA2E8300B13,0x948EE3BEC714208A,0x7D4C3D65D66C4B41,0x8373248E8530BDEA,0xB053676048B836E1,0x9DB23D3975656DCA,0x37DA5FA90E294EBD,0x00000000000001FC },
    { 0x8715DF66BB355CA4,0x9F0EB8F4CA81AE22,0x477877BE167325C2,0xDE6D697564174912,0xFD9770AEBB0B5CD2,0xD83513421999F713,0x14FBDC847FECF8EC,0x1700B51341521EA8,0x000000000000006B }
  },
  { /* Point #15 */
    { 0x330F31B6C916E988,0x601FCA7FA6E737C0,0x99E063DCDF9C7B04,0x49E97A9627CD93B0,0x576FE3429A7C06DE,0xA6D8C4796EAC19AE,0x4C5CC139FC72DC81,0xF34B69073533FE76,0x00000000000000F0 },
    { 0x8D444D34983C41E6,0x650AF8BBE2E49BD6,0x1794D4C0C1BCB88A,0x798CB3D8B2FE435A,0x8544A707E7433605,0x82DFC6359FD393E0,0x572BD64292981C51,0xB451731FE001273D,0x000000000000010C }
  }
 },
 { /* Table #5 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x4F0E025FA2302041,0x4D50D98948D262B5,0x01720A0AD622C7D4,0xE3B5A94158D1C97C,0xFBC5B18338AED2A5,0x27F02177823B5D8D,0xADF74074775F38C5,0x95BF91F44F1A6EA0,0x0000000000000104 },
    { 0xF9CD82998E2D6AB2,0xA75B296B6C27631D,0x077000491E00BAC9,0xDC99E546EBD66975,0x44FA528275E54993,0x25FBCA4BD50E44D1,0x4663139381057B1A,0xC22EFF26BDCDF45A,0x00000000000001CF }
  },
  { /* Point #2 */
    { 0x3519394E7F6B9B0B,0x76E8C23501AED422,0xCB70FE5C64BF111A,0xC6C025915B3C7EEE,0xB53B8858F9ED8925,0x51503AFABB66CD7E,0xA2479B22A6B3F2C4,0xFBCB06C48EEEE4E4,0x00000000000001C6 },
    { 0x29F2FF47198BB516,0x1895FB6877671DDC,0x10A1E7541E2B80EE,0xB19EFC72A7732627,0x88F9176E1E0EF24C,0x22EF41AF1FA7183A,0x994EA31C47D7C8D0,0xE838B3F2E9793AE0,0x00000000000001B1 }
  },
  { /* Point #3 */
    { 0x9289B69D3FB4E975,0x402EA68090ABE866,0x5308DA63BE261ECA,0xCA3572CC3973AE33,0x856CA78098532B78,0xCBF66636587F6B23,0x676C49921723A436,0x9F9149EA74F83F24,0x000000000000003E },
    { 0xBA145D0DB398B5F9,0x36FA701C5D91F299,0x4447EDE5880CEA61,0x7C901B83C69C641A,0xA4F6E566C9EC5747,0xC73E0C6B2AEA7BD8,0xDA186A9C507B21EC,0x0420187E7AE3AACF,0x00000000000001AB }
  },
  { /* Point #4 */
    { 0x39F73A5667D26EAC,0xE15B72B9938FA0E2,0x16E09F8B554F85DB,0x0E6D1CEE02A16CC2,0xCD989DF35E548E22,0x9BA195FC3CACDA0D,0xCFECC6F94CE28D02,0x8B8F51E0C91FA6D8,0x000000000000019F },
    { 0x79F455B2C1A33BD9,0x76514D33FE83B781,0x3F5EC772F2EF9526,0x2D1E47946EA54F2A,0x472FB203C1E2D62A,0x6E94A20BEABF2C9D,0x11DA7502781A8076,0x12CCF29A91BA87C8,0x00000000000000DD }
  },
  { /* Point #5 */
    { 0x0C44CB078461A126,0x833ECF391E3D5EC2,0xCFB75A58D30ED220,0x78309A880F06DD1A,0x46EA7133FA5F0298,0x4E43C6F04BFDF4A5,0x7047ABFFE0EB0A8B,0x1B142957E1893149,0x00000000000001D6 },
    { 0xECA09AD447F7C92D,0xB5F84D6D3D86A0BE,0xDA40E7F651FCD6A8,0x28A08F5F2BE41D0F,0x98A7F09A4F9A374C,0xD2D6FF46BB0CBB89,0x15DFBD60F6E2353D,0xDBAF53B49611D886,0x000000000000018D }
  },
  { /* Point #6 */
    { 0xC9518F3FB711958E,0x74D3A13F0BC5DFB8,0x7DA464AC62025AFE,0xBFB139FA9A3E2FA5,0xB30511CC9A8D7C09,0x4D3A313F17E41FAA,0x7C53FF823A10C83E,0x2E85A451ABF3F866,0x00000000000000D5 },
    { 0xE2844777DF1D2939,0xC3A4CCFE21FDAEB8,0x47B7E6138C8F6176,0x038B43EB1B6571D0,0x9F380474E3F47C8C,0x623E3416B97BAC68,0x625B6BF1BED4CAEF,0x6AC6E0C81664FCDD,0x000000000000011F }
  },
  { /* Point #7 */
    { 0xD73BFF3899868C1B,0xC4DE30673C0780C8,0x42E25EC9B94ED8F5,0x2A1CBE590080C257,0xA2AD3D6B7E1F5C2D,0x6B750C30B0B16C27,0x26E80CD1016248B6,0x3A7CB1930A9B3479,0x00000000000000E5 },
    { 0x248C212DF06089DC,0xF64C29CD22EDFC21,0xAA2D506494F10EB9,0xCBAD39F75B200F04,0xC43F0E7AE2E4F780,0x30ADE30B9038A60C,0xB05C9C75828E35C4,0x7113872591A8FCD0,0x000000000000017C }
  },
  { /* Point #8 */
    { 0xE7BBF4A8D2249935,0xBAA56999ADB64049,0x5E0ECAE945F8DF55,0x20B22A2F64E2A249,0x480102231420D76A,0x24BD8F9FFB45ACFC,0x66E9C51167673F8D,0x719EDA3C1F02406F,0x0000000000000138 },
    { 0x56F88274D07C2FDF,0x2B82612A54C1DB4E,0x0D4AE93896C3B009,0xF97A730E5897ED7E,0x3E3505C0396F9C18,0x20D682E4DAEA8F31,0x05FE6EA4E85BD289,0x6E05507B14613E5C,0x0000000000000164 }
  },
  { /* Point #9 */
    { 0xC73762E6481F611B,0xA8D18C26076EE36D,0x7A9A12F7AF71C832,0x9F202F50D09CDB38,0xAD23C663937D8CE4,0x7A9B6EE4FFE8945F,0x9FF511120C1248BE,0xD9B7BB75B68F6130,0x0000000000000152 },
    { 0x1978B2DB0BEFD018,0xF5E39D99998C6496,0xD2B8318F40C417C3,0x4A1538154E3475ED,0xE7CC969340E4931F,0x7AC6EF5DA6DED519,0x00E7AF499E67DB29,0xF7AF3E663A227FD6,0x000000000000006F }
  },
  { /* Point #10 */
    { 0xF0307EA7A3ABDF0F,0x25BC4D1D49DE2354,0x2B8EBD094B8160B8,0xF437B69E3A63C866,0x59C64B2FDF07DA1A,0x817D2723BA53A71A,0x1EC10E309715B466,0x852EB71D4B5F821F,0x000000000000010D },
    { 0x3A53ED2DAB617319,0x0279FB691E3ACCC8,0xE2746511030858A1,0xD5411A7F4FD0ACFF,0x8F31DEF309C66CF1,0xF8B414CF85C0C9F7,0x15222A47D2565B67,0x732E7EB6471411C7,0x00000000000001A7 }
  },
  { /* Point #11 */
    { 0xE7E4133642B5DC6D,0x1EC73D43AC39FEB9,0x9BBAB64F0774D294,0x916F842920D05AC5,0x18F5200E9FFA78AC,0xEA36FC1D37BB7BD7,0x7F43AB79D0F38FE6,0xCAD2D96FF745B347,0x0000000000000046 },
    { 0x3140D9C852456C41,0x98F3CB4253628A69,0x2ADEC93A60FDA64D,0xE90364575EC42A38,0x67180536F3958029,0x19EAB58AC9CC525D,0xB41EFA4942B055BC,0x2BAE3414434FAB5A,0x000000000000008C }
  },
  { /* Point #12 */
    { 0xBC36EED32F7BF34D,0xFCDEDAAA7CCE180B,0x3B719B5B5CB22FDC,0x6AE5BDD9E4111433,0x865A0148381F4186,0x170A523B9245C6F6,0xE3BE816AC2B1118B,0x30E7AA62174EFD73,0x0000000000000033 },
    { 0x1ABFE12C4CA2F7C2,0x60485268733B1F6A,0x82690E31A1D38BD6,0x3A55F831D862DC8F,0xFB3E4436E03E590A,0xF265ED1075222C2C,0x41CF2D8753B1FB51,0x12922D525A82041B,0x0000000000000060 }
  },
  { /* Point #13 */
    { 0x4F14F6BB1320E005,0xBC1151CFD980656A,0xA580333F4F287157,0x5C8E4B006C608FA7,0x6A858828378420CD,0x80C141BE3B0D2DD5,0xF10C4E721183E1A3,0x42AF4669A6B7A7F4,0x0000000000000073 },
    { 0xEF81B0EDF6A8ECCE,0x2FB88C745304060B,0x17AF73CA233EEA41,0x30564AB32D541C3F,0x3526E3258EFBEEC3,0x360CEB5916011C23,0x480FA468D77D3AFF,0xE1F4C7FFBF846F1E,0x00000000000001F4 }
  },
  { /* Point #14 */
    { 0x5B6A6CA5EF7DC356,0xC47B9C0F55C1A178,0x89EB8747C07B52B0,0x097775CF736EBBE8,0xCB84611F506FBDB6,0x2135B7DA68C82D60,0x1084122DAC4454A3,0x115DA2F59C93E278,0x000000000000016E },
    { 0x743591776721FBBE,0xD051798061337A71,0x78B344DE3AA24943,0xF41A1BFB0C600B70,0x25F8D92F0AF82B82,0x1CA931AA74D2845B,0x0A49F46DA9ADC76E,0x78678A328A130E6D,0x00000000000000BD }
  },
  { /* Point #15 */
    { 0x7A8F819B4A18638A,0xDD0F6EBE1DAE3869,0x777FF6491059923B,0x806653A38FA3F6FC,0xA9DC83248E9F983C,0x4A4AF7795BC5F6A7,0xE95FA29006A6137A,0xFCF6C742BB89E63F,0x0000000000000050 },
    { 0x62EDE8A9ECEC69EE,0x754540ED2E06D0D8,0x105B05C7D7E610F7,0x0976BECB99F67F8A,0x324E7DE76AF2B5D9,0xEC99D94A3BA47093,0x9A3825CC62ECB0F4,0x9194D78EE281ABA1,0x00000000000001AD }
  }
 },
 { /* Table #6 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xB5F5385146D39A88,0x58A99A0F9CC76DEB,0xCFDD909EF3825B82,0x8F49DBDCF4694014,0xEFD505FE9CFEC7B7,0x66A7F2A156925281,0x6F478D9B2A604FB8,0xCBC72E9E60F7C436,0x0000000000000021 },
    { 0x5BF75682D9C31E98,0x74D5CD73C8BCE143,0x778BD5F1C700E94A,0xB01480C73A66B233,0xC667F078688DF0CC,0x780C73E416BBCF57,0xB77F5BA9485890E0,0xD62ADDF5B9DDACB3,0x000000000000017D }
  },
  { /* Point #2 */
    { 0x173AB94CD4820FA0,0x6AC5AE1344F0E094,0xF67C3F7164FC4C70,0x2648A59A2AD78517,0xA7B344939505580C,0x8CAB6B445A741D25,0xFE41BD4563355FA6,0xD2731F41D1091A6D,0x0000000000000096 },
    { 0x2550A62286E4F90D,0x65FA978B80070B03,0xF3AC57B5E3B526A5,0x8E9207BCF84FA4BC,0x675A8E31F88E6047,0xF648CC7C9050DDAD,0x1FD62DBCBC5B7DC3,0xCC0960D696F0AEAB,0x00000000000001DA }
  },
  { /* Point #3 */
    { 0xF7BA638D767335CF,0xB6FB9463733C2346,0xA0E475A1ED81C85F,0x5D2FC9F1CB58E955,0x941FBDC675A1DFD5,0x732D6CEA0F14F1C2,0x4C13E55921367160,0x5BA5A950EF0E8D39,0x000000000000007D },
    { 0x355DBBB2BBEB43F6,0x0ADAF151B3505972,0x01976A0482F0D0BA,0x080824B6FD4BE88B,0x8392B272F4424F37,0xDC69D67872F6EFD8,0x0A4B8BA4A06B0CA3,0xB731404CAD3FD7C9,0x0000000000000119 }
  },
  { /* Point #4 */
    { 0xDDD7A0733F0741E6,0x6D74B1E2A4689D58,0x6F6037646798BA3C,0xDC038772B996B179,0x6E7E797AE1668E1C,0x551F4A8E3E285251,0x705484E5E67FD032,0xA65FDFCDEBCCEEA3,0x00000000000000EA },
    { 0x33A1C053ACFC4123,0x25030E6ABBE1FD24,0xD9D6AF7100D3D90C,0x063F818BADE7D232,0x99630AC3521CE597,0xBB594D0EB9EA28ED,0x3F61ACBD3A1FB8EE,0x7E00686F88CAADE2,0x00000000000001A8 }
  },
  { /* Point #5 */
    { 0x1730B2A5C9B816E5,0xF2C2A1BB5531EE33,0x1DA21329659E0B2F,0xBEC25192C88BCE0C,0xDDD4B9E6AC6F52AB,0xF15BD68F9E4B9F7D,0xEA9E12E67D249B4F,0x56A65055451ABAB2,0x000000000000015D },
    { 0xC4D7DC72C4B6910E,0x5FD335922DDFF22E,0x43E429E2B8287AF6,0x258A4647A1585685,0x31F72F413B62CE95,0xF63172FA57933B4F,0x54749D3A0C5CB4D8,0x514DA5D28CC931C6,0x00000000000001DE }
  },
  { /* Point #6 */
    { 0x0FEBEF06CB4A809E,0xA8AF434C261B4FAC,0xE3B7185059D1E70B,0xB62F01E45D1C24F4,0x8ABE4E3DB303A2CE,0x91A5A10F36E2C2A8,0x710BD5CA7E472BA9,0x14A31AA677A05FF7,0x00000000000001BC },
    { 0xBADEC183453E07BA,0x54C92EC41E3087A2,0xB87B0B724A6E06A3,0xE26C6162B5507E77,0xEB64A07175FAEDAA,0xDE1C75464988A08D,0xE99B34851FF0A98F,0x29A660C2053F0E60,0x000000000000013A }
  },
  { /* Point #7 */
    { 0xD495B0EC16EBA181,0x834A505A76F4FB91,0xD1950CF8DB3B0C92,0x5108E0CDBF6BD68F,0xD8492E459F777AC3,0x2CAA1A4E184F5A9B,0xFBB91EA5CE860F91,0x05957C32597025F9,0x0000000000000097 },
    { 0x1774A862B07D29FF,0xCB4EDA89CBCC928E,0xA19276A102AD819B,0x3D0CACF6F5AF5B3E,0x8DCEC31F3BDBC653,0xAAD437092F1ADE3E,0x544E97C3574E10B1,0xD4364902C62C4DEB,0x0000000000000077 }
  },
  { /* Point #8 */
    { 0x87DAA931DBBC43B6,0x882A2421D1895005,0x6013F2BA7AAE1124,0x01D2A8F0BAD34DF3,0xDB1B7F432F0B3D59,0x59039F352A95AC2C,0x555077AAA6C0A8B9,0x543B69A862685A03,0x00000000000000E0 },
    { 0xBB104059EC48D2AF,0x691C1F18930FA171,0x8C434C7637D9FD85,0xD1E56D52068741AB,0x1117A9FC130E01EC,0x126D517B1F510538,0x25CE40CEF290A27E,0x0D0B0D8AE90E675D,0x0000000000000028 }
  },
  { /* Point #9 */
    { 0xAB52651D8CC61218,0xA1C9DE0C44480B5F,0x1F16FB4B1E50B446,0x6F243EC4CE904254,0x36840614DD99EA21,0xCD03B67D0A32C8E8,0xFEF4282A80ECEF0D,0xED947DFF446B4A9D,0x000000000000011B },
    { 0xF6A412972DCB7B3C,0xD343EB08D7F5283F,0x48BA42BE2F9BBF7B,0x7146C6A0D4303C71,0xBFF735EACFAB9F39,0x2895CF346F28A222,0xDDE25C5B71ECB96C,0x45C4A4DCBCC657D6,0x0000000000000089 }
  },
  { /* Point #10 */
    { 0xA782A879A1E0D48B,0x1FD7D3F2836DC473,0xAC16A45A0EDDBA6A,0x30960AAB251C169A,0x64AF293E232DB856,0x5D5ED2D69E0AE10B,0x810B13CF83C17D28,0xFCBE5AC7E3E42FAF,0x000000000000017E },
    { 0x2A02547B7BD184F7,0x651A91DFE7A80F1B,0x1BEEE61155CC194F,0x9B2713CFB089D036,0x450307D20F4959EB,0x3BAC76DC8126161F,0x2CC54041F9DF0070,0x92CB8EA624307551,0x0000000000000115 }
  },
  { /* Point #11 */
    { 0x993099FA1E762027,0x9799C62D1EA3F1AF,0x7E0BAE2C314377B5,0x53814A3FA34FD53C,0x237A23B4724E8552,0x2F03DCC36CCB057E,0xE8162A49F9C50353,0xC9EEABEA8D7FA87B,0x000000000000012B },
    { 0xEF0D51489AA51CB2,0x74016AA93B43119D,0x157B118E552037E4,0x1E14B65824F0D289,0x654E7BC4CEDDA762,0x1E09E8B49BB08F1C,0x5B14973836CB9AED,0x97913A396708ADC1,0x00000000000001F9 }
  },
  { /* Point #12 */
    { 0x272193EE004CB467,0xF4F31D05BCA5CBE0,0x292A7DA1BB299CDF,0x40DB425480E03DB3,0x83B1ADF326EC49B8,0x11A754D1613FBD2C,0x4B8D0AA2AC137BF6,0xEB26F522D6420F8F,0x00000000000000F9 },
    { 0x26397200FF338C69,0x4D04E5F72368647D,0xEA3F9562D4BF3F2E,0x064B9C45FBE6F229,0x5185254BDE822C89,0x9DA9DB6DFCD97C6D,0x78B96BA60025A1DC,0x7ABE06A163FCC2BD,0x0000000000000104 }
  },
  { /* Point #13 */
    { 0x6E93A3E402B6BAA3,0x001F843D1C891464,0x8EE3F13E24D1E58D,0xD75616E46061074E,0x0B5109A709F9F2F0,0xF09EE5B227F3DCD6,0x9AF52BEE85EA384E,0xDADA8B9A4D6ADB23,0x000000000000015D },
    { 0xB19CB8C3573476A6,0x8F91AC51F0E6097E,0x157DD6CA8B76E3FE,0x9CDA8FBA4F5818DA,0xB512A26902D6965D,0xE33A98C082C51A22,0x33E01B501C76952B,0x9E6FDCBECD5A0722,0x00000000000000F4 }
  },
  { /* Point #14 */
    { 0x40068D8D1D644CDD,0x63E0531015D49A00,0x0AEEBC00D12B911A,0xB9E1A113F9F8BDE1,0x1145D7654323DDA4,0x949D2192850AA48A,0xBC3D5845575BD321,0xFCA9251D8D6F5130,0x000000000000017C },
    { 0x23A4A12CE0A46A63,0xA3C705DD309BC3B6,0x905B9E0D46354FF4,0x00919D72B0FCE88E,0x30FE24A2B2793331,0xB2F1ECDFC61BE395,0xD24BBFF4C09EB3FF,0x39BE437D7DB0651C,0x0000000000000197 }
  },
  { /* Point #15 */
    { 0x8981F0975D5B4047,0x93E437D5FBD8F49B,0x083BE97EBC068B71,0x5C6B1ABC005319CB,0x1EEE6CDC045FA694,0x298F97A9F70CD426,0x4025549A14B9FB67,0xECEE05641F05A634,0x000000000000006B },
    { 0x2FBEA3E1E70C5E4F,0xDD1962EB8BBD71BC,0x821464A97BD27064,0x2D523C4D7C8A2ADC,0xA15C8D7D4EE5AED7,0xAE04B8B7FEEADC53,0xA51EE590144FC44F,0x2882F4BA731919C4,0x000000000000016F }
  }
 },
 { /* Table #7 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x93D61C073CA98249,0x04C4F43D907AA44A,0xEE3D2C3151D5B1D6,0xE74D6892F859DF2A,0x16AB4838922F8FA9,0xB0B6F7D1757B0010,0x7CA940D8A918F320,0x45E9325B97B8C9B5,0x00000000000001E1 },
    { 0xDB18D7BF37316056,0xC34532048FC0EB89,0x3929DB79060E2DB1,0x2CCBF668B1E67403,0xC7CE019A9B05F538,0x9377F4464DCA0FFE,0x42947EB68A570683,0x6EB25E34E0A1BF92,0x000000000000009A }
  },
  { /* Point #2 */
    { 0x8B60DC2DF6130E66,0x8ED41BE47B6448FB,0x0862C67E5EA7DEC5,0x97CD528272E431ED,0x944A76DA0BFF84C7,0xC168A8FDA2075162,0x21AF8DE713AD271D,0x27EBCD24437E9E66,0x0000000000000044 },
    { 0x399007D74C7B3DC7,0x5128A9FEBAFA8850,0xB7E7CFF44DB4A4B4,0x923571173410D116,0x47320EACB450EFED,0x47AD42E6F8042421,0xE4EF55C263B6AA24,0x7A97987C3F882833,0x00000000000000B9 }
  },
  { /* Point #3 */
    { 0xC76E5F4D022667CD,0x2C78870A3E07FB1F,0x9E001396D1C68926,0x707A9C2EED2A502E,0xAA9A37F8E68933FB,0x1AE458AC4E4C8F98,0x8047ED5DA71656EE,0x06826324A9DF9D4B,0x00000000000000AD },
    { 0x2C4CBD9319C176EF,0x8DAC64428092BE6E,0x0C349EE87A074BFF,0xEC35B47C0129E1A0,0x4096E01235253255,0xB3E6E7FD06B23B09,0x8B36EAC316FD165C,0xB7D5F97294AD125C,0x0000000000000154 }
  },
  { /* Point #4 */
    { 0x58241D2F43416440,0xAD00DACCF36BB0CC,0xEF105AADE1B517A4,0xA88FB367418524A2,0x960EFC2BD69F903F,0x58B761E2BB316FA8,0x634A724E43593289,0xA341DD2178B2C871,0x0000000000000178 },
    { 0x29DE72F83261324C,0x53767DBC0EE348C0,0x7F5A005B2EBC04F2,0x8C6987A70F7B3B9A,0x0F387E9D7E48F271,0x644134585B456A10,0x015A5DA5D0A2A3C5,0xB236CC58708BE977,0x0000000000000057 }
  },
  { /* Point #5 */
    { 0x13C413632BB30EBF,0x1C51E2FB84A62B56,0x0FFAEFE0883CB2CA,0x23A651151997F036,0xF030712C9C64E7E3,0x06320295457AAF0D,0x945BD82FB2498539,0x2995DF47623A481D,0x0000000000000161 },
    { 0xF962F403FEB7F8B3,0x244D8A3A872DFF16,0x59FDAABC89F6DDCD,0x41661BC87DB8ACBF,0x1B641D50C256C87F,0xD7F8AADB27CCDB57,0x4DAF613731F353C8,0x33D401882A2A6F9E,0x0000000000000125 }
  },
  { /* Point #6 */
    { 0xBD4062286EED0F95,0x8693A9D97C6C1C3F,0x0392E931C066DCC8,0x2E1EEDC6CC819D2E,0xC7A315D6069E2217,0xA7495B1808E6F72D,0x364F38117051FF13,0xEEEB3CC4BB59D612,0x00000000000000AC },
    { 0xFD9E0C1078616D6C,0x585DE5ADA8D4AF09,0xD08D9021C3143504,0xB38FE6557F67FFA2,0x5682040CD0FCB4D0,0xD56C8348E6329179,0x76229A732621C84B,0x0C98CB02DE4CC81D,0x000000000000000A }
  },
  { /* Point #7 */
    { 0xBFB85A9BA8F70EB0,0x9FA45D83E59B107C,0x90207916CFF39E25,0xDF20520F61816661,0x250A81B64D88EDDF,0x3583BCE4D4C88E4F,0xFCAFBA316121DEEC,0x40E71EA745FF2C20,0x00000000000001D6 },
    { 0xF91F204550452ED6,0x4C7BE74A00FCA85D,0x6AC750DC0FCC66DA,0x829CCEF87BB3A7CD,0xF232419E97039A3F,0x1647039DB5F00AD5,0xC72EBF12DD7F9785,0x42BBFD03C675E619,0x0000000000000119 }
  },
  { /* Point #8 */
    { 0xB2308971ED0D691F,0x31C3C54E8CEF282F,0x5CC3D26A97A5ED69,0xB611A35D43DA55BE,0x97492FE68FE11B61,0xC10A18F0E26F0805,0xB6E0F2A2EA78E6BB,0x2570F42E71C3F3DA,0x0000000000000043 },
    { 0x30048B23D0630DA9,0x3756D05E0F635BA8,0x1E6E383A8CE0E80B,0xCBE43361C723D456,0xB1F089E45CD18501,0x53132CF36FF2C160,0xC759B7A24A0406D9,0x17917E066DC5143E,0x0000000000000141 }
  },
  { /* Point #9 */
    { 0xF8C5B2EB11628DFC,0xC66D10FC0A42E49B,0x44C184B4E26FE77F,0x22EF369DA4D3DAF3,0x6662870A2CBE0115,0x80846B9736CA9E6D,0xBBAFD1317ED388A8,0x4DA614274029082F,0x000000000000011C },
    { 0x68DB20A0C06F365D,0x46005F812FFB8BB6,0xA0A17CE3BEC18577,0xB7627D8DC3CF8B54,0x441830CDFF30D00D,0xA53ED5CD8F7A941D,0xFD1147C999071DE9,0x619DB4EB77DD8AD3,0x000000000000010C }
  },
  { /* Point #10 */
    { 0x7FC5BA6013564F62,0xE82397841238D231,0x8249F141E7B6CFBC,0x37E1B845668154D8,0xA99523BC5095C5EA,0x1196969C76FB9D42,0x6428AA7C92185A3A,0x428E78D88246676A,0x0000000000000095 },
    { 0xE44CEF632B1E5685,0xD9665E7E0D228CA1,0x066367719DFACF7E,0x42B09D00FD5605AC,0x0B101EDCE65B8E60,0xCA4D0290E2210994,0x50ED6BC6CF9CC92C,0x2CA63C9EBDEBC35B,0x00000000000001FD }
  },
  { /* Point #11 */
    { 0xA32A9D65FD85284B,0xB08333A5A4FAE26C,0x8ACA0A12EF75E239,0x9035B7385A77BB33,0x466F97979AA71A08,0x375DD05662F91BC6,0xD93EA401F5CB1C8C,0x7ED00CA316D691C4,0x00000000000000D1 },
    { 0x8CCBD8FAE0A3542D,0x948625D070B071D9,0x8654DF26586A94D4,0xD6FBFC0F80290BE1,0x2E103EAA260729E8,0x342394E5F5F52AA6,0xFAA21F70FB684270,0x1348FABD7C862797,0x000000000000002E }
  },
  { /* Point #12 */
    { 0xF5E5237B52FECADE,0xE0A50E6E4DB2795E,0x7481845F2A4C1493,0xFEA36AEFAA8FBA83,0xE7A2E20BEE8EAB2A,0x3F4CEB5766A0AD1D,0x9BE294E7C15AFC26,0x7952338D711C1DE5,0x000000000000016A },
    { 0x8A9806BBA64D25CE,0x6E72057D8EB8E0AC,0x46EB31F2D3F7E99E,0x4A408B8D7C3F1998,0x5DF31A262F59604B,0xD12DC298137D937A,0x60C9A1480678810F,0x3011046B48418A2D,0x0000000000000139 }
  },
  { /* Point #13 */
    { 0x317B098C5CA5F978,0x18FD83202C21B6E9,0xC147AB01F1193ACC,0x7EF3414DEAFF0D9F,0xEF1A3D6FE28E9173,0x2603CCBEB25FCEAC,0xF825502D5AFFA9FF,0x539A125E066A68E2,0x00000000000001DB },
    { 0xAF4B16BFA90A3B2D,0xE0D81048FF63D1FA,0xB203E68707286721,0xEC631A327BF45B93,0x4D38CB033B10B512,0xE08EB57ACA57F26B,0x737D9CD0D7D6DDD0,0xB00845A86C572D39,0x00000000000001E1 }
  },
  { /* Point #14 */
    { 0x6F24AF3EEC231C64,0xA4EDAD38E7C7BEE4,0xC6BA273ED1EEAD3F,0xF68B581F08C4D123,0x1DB45C2364B13567,0xCD3D42CB5772318E,0x5CD6E6CB007BF13D,0xF02D313B071BFDC9,0x00000000000001AE },
    { 0x09083EDA4ED3782A,0xBCDF9CE75B29280E,0x014232BC63B04675,0xBD4BDAECEEFEC679,0x8712C19ED47C5385,0x4BB00B447AE76A01,0x1F847EBD2FB2CF2C,0x9F2B12B9A7A56439,0x0000000000000050 }
  },
  { /* Point #15 */
    { 0x6EE9325ABF53583D,0x3B7EF054921DD595,0x95C35CE8C0ABC07E,0x08A3A510646FE810,0x77FE478185EC11BA,0xE382A5134E870F3E,0x4EEB7787A9F1B8BD,0x8521F39D9D8F6459,0x0000000000000068 },
    { 0x10AAE6D8428A37FB,0xF0578F9FD66092F9,0xB90F50EE1AB36081,0xBB41BCF30AE841EE,0xF73FA600CF79EB81,0xEB88461B991AFD1B,0x1B9FEFF62CE5C0F2,0x80183105CAB1B304,0x0000000000000029 }
  }
 },
 { /* Table #8 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xABF17FEB008C7A44,0xADE7917A7B12DEF4,0xBFBA65B83786B033,0x8EF4AF44F0D9F9F1,0x8F47615CAB136CAE,0xE42F100DBCBD5D3E,0x8F3DC658F05F9B27,0xD95A6B2DD6F2DBB2,0x000000000000008E },
    { 0x23BB06A546BBC412,0x15718699D0135EB6,0x8F1639C4B4ED9E10,0x767FEE42D7F644A0,0x668267B0FE8EC420,0xEC4F548264E90133,0x679E614E536D132B,0x0D72FBAF174DF6C5,0x00000000000000A5 }
  },
  { /* Point #2 */
    { 0xD256B6072DE9B28F,0x286FC763CBEFE110,0x736FF52A138783FB,0x6F6D822B4EBCD973,0x78C5A0B685ECA174,0xBFCC5AB679EA21B7,0x9CCB278D4937E0DA,0x9F50F4422D009304,0x0000000000000049 },
    { 0x566947D729F8A798,0x9793A90581CC1ED4,0x73DA631E851115D4,0xA0B5C181FC7DA6F5,0xA70593D29F5A7634,0xC9F71DF41E6250A8,0x2DFD10897A97CD35,0xC3CDAC7ED4E0074A,0x00000000000001FD }
  },
  { /* Point #3 */
    { 0x8FD8DC497694F566,0xB2AB052D1FA6E13C,0x7E4A708E9AABC7CF,0x68A9C33A6B81F0F0,0x96E4988AF1F7CB07,0xDCA8D731EA264C22,0x245371E321B3372F,0x02216476308D2300,0x000000000000017A },
    { 0xEBF5411633696CFD,0xA10C5784419623A9,0x4C6A119C38FA84D5,0x5C8EEE646D4E5BAF,0x7F99D26D9B4959D5,0x58708101174F417C,0x48CAB8F38294B72E,0x828AAA19D9710F9B,0x0000000000000192 }
  },
  { /* Point #4 */
    { 0xAED480E002F799D8,0x021A2F24D635C04C,0xE49A60D8004D0ABD,0x58AB8FB04D8873BD,0xF36A43C81ECD98F1,0x555F15C4CD2F93F7,0x295D868D4EB95E03,0x1AA8E425B50553A1,0x00000000000001DE },
    { 0x2EFCE59878FCBF33,0xC499E9FDF4E93711,0x0F5220AD0C6E6FAD,0xED0D0A9B9FC9DA8C,0x84235958F7813802,0xED21398E62729B3D,0xDF6C25AB3C9BB158,0x87D306D9EDD78E48,0x0000000000000085 }
  },
  { /* Point #5 */
    { 0xC661D6FB7845697D,0x324380E1AA69C353,0x521E96D86961D564,0xB9D070FFAF58E367,0xABD851DF5AC3B5A2,0xEBC0BEF2530BAAEF,0x054BF32B358627A2,0x0AB65C3AA205B0CB,0x0000000000000157 },
    { 0x586C331EA74CEC0E,0x2808851D2ECC3900,0x0A6953928003E820,0xA667A7B081FC784E,0x64EDDA2DF33BBD74,0x13EE043729FF01CA,0x9192138C4EC28C03,0x3DE5FC2BD4E0F79C,0x0000000000000096 }
  },
  { /* Point #6 */
    { 0x8EBA86B822E41E28,0xC26F7CAF9D7A7103,0x5D0F792FE462090E,0xA5F8C81ED18BB44B,0x2E4E6E573E291040,0xE347369D0A9F9660,0x63BED10D3A680D61,0x8590210EB03CCA7B,0x0000000000000063 },
    { 0xF8D8536F5322914B,0x26E2D5ACC179FC5C,0xC7181A3FCC606124,0x7770DA72474896C7,0x2AAC427CB25FB526,0xB3FCF0166C1F1086,0x14F06DD7B67643B9,0x5BF942879E8C2F78,0x0000000000000110 }
  },
  { /* Point #7 */
    { 0xA09523FF95051804,0xC4B33367C6EF7FBA,0x388C5AA3292CD05C,0xAE1B2CCEDD93715E,0xED7F02BE70D39632,0xA9DB568ED5169F74,0x6EB4424EAEB2F9CC,0x358F1F2778FC446A,0x00000000000000D7 },
    { 0x3A4E0F6467694CA1,0xF50A6D562B1F54EE,0xCA01350C9BEF1F78,0x778A4C6BC6237D11,0x270ED37AA79F4C15,0x4E38060BC6D4ACDF,0x5D39BA1C1CEB1CCC,0x94AB7FBAE6D621C2,0x00000000000001A4 }
  },
  { /* Point #8 */
    { 0xA0BEDE1BAA9A08AB,0xA32364531FC48289,0x27F83D5A8C4E95C5,0xD4E05998A98B2122,0xE4118AEC7D51821B,0x18AE6C6A883CE4E9,0x686D2A6E0D65E4AF,0xCE00C72768D87702,0x000000000000004B },
    { 0x8C8C0C984C0B4B11,0x09C31A00977E63AA,0x1999F20642100B94,0x7314DF12C4F0CF33,0x0BB59F1A5F5DA290,0xF08E85BC03D4FD95,0xCB0B361FD6FB0524,0x9192A173F35D713F,0x00000000000000B6 }
  },
  { /* Point #9 */
    { 0xC7883273451EBC0F,0x7491E2396CAF9F40,0x935EA01583906503,0x126143BB5DCD244D,0xC5708E206B4A931E,0x9E74058CA6CB75B8,0x211A6F9736868DF8,0x79EDB44D98B8563D,0x00000000000001A4 },
    { 0x1EF7EEF4A769E019,0x9A1FEEF01A174E8B,0xF7B6324126764010,0xE1423C696F59B94E,0x9AFFC03EDBE73EF3,0x9E4D8FC92814A67F,0xE6A4F82A333E01EB,0xF80CD1A0E5A37809,0x000000000000007A }
  },
  { /* Point #10 */
    { 0x3C68234F72595A5A,0x6921FBB0E705039B,0x4C10CD34B181E07F,0xC0C255BBD3302AE4,0x8EDAEA1B292DBFEC,0xDE4489BBD5A709D0,0xE5D6D8FC91299A52,0xC156C2B183B9AE61,0x00000000000000A5 },
    { 0xC13EC4CA524EFD00,0xB875AF3169249E58,0x3D80707CC31D1CFE,0x8B307CC13D3EFCE2,0x6618C6B0D2FDDF33,0x12AF05BBC00774A9,0x95553E9CF9D0F3F0,0x890D1A78624B5601,0x000000000000016A }
  },
  { /* Point #11 */
    { 0xBC9D6530B0E600B0,0x89CC224B18A80D81,0xA234CA6AE06D3439,0xB55644C40CEAB1F5,0x4504A6CCFC9D1896,0x40B6F890BBE1F193,0x2661474DABAF5EB0,0x09BD458D052D3D88,0x0000000000000009 },
    { 0x3054A4E5AACC4C5E,0x69E5A9EFECD13A35,0x0865593DD95AF038,0x7860FEDE708D9A25,0x5DABBA8EEC49F16E,0xF239C804EA0AFA83,0x1E7EE902AA972AEC,0xC8EE63DBE85034D9,0x000000000000014B }
  },
  { /* Point #12 */
    { 0xBF880A38721C263C,0x3CE081C64DBC07AF,0x23E59C528F145228,0xED43046B81F5B657,0x02C8B3DADDC51957,0xE42404951C679B16,0x961E8810C506E392,0xEC39A8C6F8E2E56D,0x0000000000000159 },
    { 0x0AD9E8DFA0EADC38,0xCDE3AB97111FBBE7,0x11E2BAE6C1A7A983,0xCDA1626DA9A358D9,0xA2717CD58F923A2F,0x72FD45E5475331F6,0x4E0700BF3333AED1,0x92AAB4E6887EA34C,0x000000000000015D }
  },
  { /* Point #13 */
    { 0xEB126E3CDE1400D3,0x4D851C8777114739,0x5563746425A86A1F,0x00B2F8CB5395809E,0xEAD5D56BECF5803F,0x182AA08FEE6351A3,0xFE2FEC4DC92106D2,0x7BA669D9672EC1EE,0x0000000000000179 },
    { 0x52217A7B6FE471EB,0xA20DA1FD0755E7DA,0x1E479F6B47F5B8D3,0x74DA2C2105D5ECDB,0x1BDE308173290BF1,0x73493286CD954594,0xD16651793F7B4D50,0xCDE113DF63FA3B24,0x0000000000000169 }
  },
  { /* Point #14 */
    { 0x167689768FF5A42F,0xA318E940976EB263,0x46F72D5FF8DD7739,0x6DBCDD56B67FA209,0x0D444B230AEC1489,0x1E509584CD734964,0xE5CAC4E40AB3A9B5,0x4F3F5018313677D8,0x0000000000000168 },
    { 0x3BE026B02E9FA42E,0x3954CB6D39E5D690,0xE05ADE4CF9CE1A17,0x67B11FBBDE56332B,0x8ADB8CA10642A691,0xD92B44DAE8D6946B,0x34590552C6603076,0xB033FC76C55AA02C,0x000000000000019C }
  },
  { /* Point #15 */
    { 0xDB2C322C23B48C92,0xFAA004B49E73C187,0x735D8472AE7E6963,0xBADC451F11B01C26,0x900B269A123595BB,0xD4F26E26F3F280EC,0x5C896CCA22E4C213,0x71BAF2CFB4FD6865,0x0000000000000189 },
    { 0xF7C8C83274214C43,0x20CBC871A2148A5B,0xE84890C19BD1A895,0x1DA06071A9650846,0x9737192486219B0A,0x6D0E4AFDE30148D1,0xB1C1ECBB1074A3C9,0x8351F81D2D97256B,0x00000000000000FC }
  }
 },
 { /* Table #9 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xD23357CBC11B2A0B,0x70DE0D3FB179A631,0xB57A0FAD122B12B6,0x3203600F78489416,0x99FE0B86D26D2267,0x36F3262F3B9DEED0,0xB6E6116024A32DCD,0xEABD7C06AA745047,0x000000000000009C },
    { 0x3F277E18CDC4CFF1,0xCAD81ADA6EB7045F,0x3F82D6DABB804212,0x7ECA837503B6A618,0xDA88796995F2970D,0x21FC350FEB3A7834,0xFC332B6E55F9AC1C,0x0D85B43418D4111A,0x000000000000003A }
  },
  { /* Point #2 */
    { 0x9B7B7DA8CCEC2C14,0x1EBD382DCF4FCF1B,0x72A07D22F1C3F836,0xEF166DE452992679,0x5ADD8684088555CD,0x61FBB803C2F8FFF6,0x7DA8E738E52770FA,0x36A94145F9F2506D,0x000000000000016E },
    { 0x50AF6F099E6F7092,0x541ACAC8BD540556,0xF927547A616159C2,0x4D2A84617C7DFE4C,0xB603C320754FDADF,0x0ADA986235C19059,0xAA95304EBE17A78A,0x50F8BAFF41244129,0x00000000000001D6 }
  },
  { /* Point #3 */
    { 0xA8187A5FC0C3E8AA,0x89107B456DBAE123,0x023BB57A57EE86F9,0x7B574F5DD0A5E4B0,0xF832B673E8C79CE3,0xC10BFDF66771037A,0xF448E37EFAD2B5DB,0x198293CAEF6701F1,0x0000000000000070 },
    { 0xEE3E2714DEB4DB92,0x5AF53D653E2A9E0F,0x8FE35F6E0FA38E48,0xE512D6895DD085E7,0x8B6AAC03EAD33215,0x44CF0C3C6DDA0F8B,0x1D642848A861F599,0xAAE60D552D02DD4F,0x00000000000001BB }
  },
  { /* Point #4 */
    { 0x6A7316DD5DC62EFB,0x377777EB824CF4DC,0xE349E9457255C5A0,0x64111CB9BF497E75,0x1D91DCC714B1EAAA,0x87EA1779CBCF5454,0x070F848D42C890F3,0xAAAF9A3881E4BC6F,0x00000000000000BA },
    { 0xFD521F1D853096CE,0xA44CCA3F3C8F7AC5,0xD960927B3F30CFCE,0x0D30FEB7C5999722,0x5B0D38E22ADC3822,0xA00F4A022AED7AF7,0x1BC83E716ED4DD28,0xBA2213A238615D83,0x00000000000001A7 }
  },
  { /* Point #5 */
    { 0x4A7912F4453A46D0,0x1D2E76231C7CF115,0x2208DE2B8F29C610,0x809DAA6181E502B5,0xA8F149FC6BD724B5,0x38AF43FC31CE0E18,0xA2FDBA97E8139CFB,0x665271BD9EB155F9,0x00000000000001F1 },
    { 0x8B86FC468D28EA7A,0x8CF2558A51D8FA58,0x2C97C546D7BA83E6,0xDE7CF223ACF26595,0x7802038E4CE7407F,0x95574CA7AC6B1DE1,0x98631057F0E9C573,0x43FA05D155E8BD77,0x00000000000000A1 }
  },
  { /* Point #6 */
    { 0x6F3326291AFB08A9,0x9F159DB2908C995C,0xA36F91BB5E8DFD58,0xA8EE1CD8736CE4D1,0x45832AB2CF58AE21,0x08EE6A41316E9061,0x0E39DB0B1A2FFC32,0xEA9414E1380323CA,0x0000000000000042 },
    { 0xFF010E54FC832689,0xEE1F4824C59214EC,0x8AC0DC4A62B52F22,0xCCA082D2DBA63497,0x03B4DAFD826E8CD4,0xBC3C59580F8AC57A,0xFA53329789525CB3,0xC00ED59547CE0D1E,0x00000000000000D3 }
  },
  { /* Point #7 */
    { 0x50C0AE1BBC78973A,0xDA11769B5AFC5571,0x72DCA0E13989FC6E,0x270E2D671F23BE5A,0x0C9D34D48BB2AEF0,0x37F07FDB48EF02F4,0xFF1C0206E0C549EF,0x9A62C16A6FD94255,0x000000000000005C },
    { 0x368D1944785A3C92,0xBAB00EF3F92D17B7,0xE8F15F69E6B2113A,0xD58342FFF6B46F5C,0xA0EDF615ADA12ADE,0x12D90798E7B4926B,0x284CA9E1671BBA9D,0x15DEF43A8ED23F9B,0x00000000000001D2 }
  },
  { /* Point #8 */
    { 0xD714194E2F415999,0xA4B29D685128D8D9,0xD1046CB83324CA57,0xE5E6A47504828300,0x9C5C4F6C694C18E9,0x84D00DE8D01E5707,0x8ED94290BC2B3E66,0xAFE23A51EC6A6E31,0x0000000000000141 },
    { 0x2B996FAE976E9C3E,0xBA0CC494BE1288DF,0xCEB07FA6DE8AAB8E,0x7F460647985651AD,0xEE200258189376F0,0x21F13320F9A7AC9E,0x66A57BC58F3CD359,0x7B13832775ED8259,0x000000000000018F }
  },
  { /* Point #9 */
    { 0x68D62207BABD7E5D,0x7618829B2368AAD8,0xD8BC9D594CB2E88B,0x8F4545F76FB516EF,0x0A5769F13078FFDC,0xA7DDBD1AA5FBF510,0xC4C70BA312BA6FD0,0xEF602078F8E0DAFC,0x0000000000000016 },
    { 0x6035217344F95785,0x945017D70D3BE590,0xC12442D3EC7355CD,0x57FD71D8B71B36EE,0x65AEB2D8CED7C563,0xCF050F810155581F,0x6CF9C035B2F83A15,0x302A86FC4CB4DDF5,0x00000000000001FB }
  },
  { /* Point #10 */
    { 0x0E5EB14161F457E7,0x92A3BACFEEA01EBB,0x564AD7678FC26D40,0x4F48057B446B177A,0xF1255B23788FCC70,0x1AC8AEFF459F99EE,0x24731F8FC8AF6C59,0xC44122DACB32A633,0x0000000000000114 },
    { 0xCE32416D6FAD3DB7,0x59D803BD73AD309D,0x211E641D0CC0C9AA,0xE385BCE0BCC90BBC,0xD24B7461C6690793,0x31D7BC5E4908516D,0x268C54C4ACBF7371,0x95C7374121B9407A,0x000000000000016B }
  },
  { /* Point #11 */
    { 0x5EE4BCBF9AA0A8C1,0x3F701E41A37CDDBF,0x57790D50253A2DEC,0x594F2C7FF30EC59C,0xD104AC878A383D81,0x28C238510097BACB,0x961C3DC36DE5B94B,0x21B3DBC6DD673666,0x000000000000004B },
    { 0x223F6E40BDE60673,0x8109ED96D88C2017,0x3CE877773B960BF7,0x36B20625E3DFDD86,0xC959FC6A737DC9E9,0x9F3ACC42635E8D98,0x4C171A9B4E87CF60,0xEC218D66033B148C,0x00000000000000EC }
  },
  { /* Point #12 */
    { 0x4B52F6FC34AFD3FF,0x246423C4E0C6879C,0xD21DB87BAE1F9E19,0xDB92EDD51B56152C,0x4A4ABA09D420E95A,0x21E9B73D912BBAAF,0xC22A8B330F004632,0xA90E4438F3B78C5A,0x00000000000001AB },
    { 0x7BB69D03A21AB7CD,0xB0658B924A91742B,0xD7386C4D4ADC7123,0x981E8258EE6C6852,0xB2AE71400EFE8332,0x5B91D439245B9F6F,0x8F2118290FDA3B1F,0x54BEFF28842E2AE7,0x000000000000006F }
  },
  { /* Point #13 */
    { 0xB7715CEAF14E77A5,0x30B15CBF85D3EAE0,0x99AADA434B1D66A7,0x11E13473F303A321,0xE075D04CA3C2FA64,0xB02855205F4D07AA,0x3D838D13E5D0DBD5,0xD65785326ADCA13D,0x0000000000000082 },
    { 0x3785F4D05FA73D0C,0xFABA0633C4098F4D,0x9D0A4E294F749D9C,0x5966C3DEBE4319FB,0x97E059AE1A5367DB,0x0333CFC26FA3DEBC,0x38E9675B283BE3D5,0xD800FDC824D7367A,0x000000000000017D }
  },
  { /* Point #14 */
    { 0x7532AD64B77714EA,0xAA8B0D323E2CE07E,0xAEAA4744B51E888C,0xFD08F7188E7B5816,0x57016828E993B6A7,0x69A9D410EBC5408D,0x2C0A373DA91C70A1,0x5B583311992D9800,0x0000000000000197 },
    { 0x93F02D300402323A,0xEEFA9C5481B765F8,0x99557A399C28C31C,0xB410E5842D8A08A0,0x70568FA7FE1A202A,0x4AC9EAEC07BCF04C,0xE4F69DC4367C9A04,0xB483BDDB581E3BC5,0x0000000000000178 }
  },
  { /* Point #15 */
    { 0x1A52836470B32E66,0x5B76DABB0E9B3086,0x48B57C94382FA85D,0x49DE76759CD9F361,0x6C744071B5F63C2B,0xB7067EBBE741CFA6,0xA95EFC93702D19C9,0xFD647A47CB409C01,0x00000000000001C6 },
    { 0x4C31F670F9F06368,0x775B1698A075C748,0xFB6CBB0FE7656E7D,0x69C0F805DA1881A5,0x1267496CC2FE6B31,0x0612FB94D8926EE1,0x561807476CEFC9DC,0x5518665CF90F2AA2,0x00000000000000E4 }
  }
 },
 { /* Table #10 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x1683448DE93EF527,0x158FD9220E5B6F98,0xCD0BCEA6E23F2FA6,0x455D35DE15982D3B,0x2FC788D7BDA98D71,0x65D44C08F139B889,0x219749FD4105FD65,0xA9FF816AE02F1FD1,0x00000000000000F0 },
    { 0xA2A53148E55948CD,0x2D952F500CC0A0B5,0x26F77E7161839836,0xA8BF589AAD87BB45,0xAF21E0FC6A9296E4,0x917881207D394E96,0x47F3D38968622361,0xF17141DA090A8CB2,0x00000000000001B6 }
  },
  { /* Point #2 */
    { 0xA6149AC821A91383,0xFAE0515C63176A50,0x436D0D6A696E3E7E,0x3D44EA3EB32B2E16,0x142644CC66F3BBE0,0x697D5CEF82322B00,0x384543C64C388EDB,0x4AFEDCFFD395D1D1,0x000000000000002D },
    { 0xA7B35FAC84CEC5F9,0x003DAAA65D827E5C,0xC7C5F3D3DFC8263D,0x8DCA1315D98790D2,0xB1F54568F00346BE,0x3E6F6876DE680D87,0xDE73E95B6AF2E269,0xA5969EC77E8FAE93,0x0000000000000185 }
  },
  { /* Point #3 */
    { 0x0F28D8B4E7BD87F3,0xCC50621C1FF661B1,0xE990770824D26BCF,0x6085222B14FBEBC0,0x41EE5411D55B4431,0x51895481A0A871F4,0xAB2509080BCD5935,0xB3AC49B29617256E,0x0000000000000172 },
    { 0x5659B7E3406F50F3,0x7A7B0D310FC52027,0x00752BFD9FFACB31,0x98A0E45FB0727679,0x789CE02536D3387C,0xE49B41F4E59BACBC,0x4AD05ED8199774CB,0xC9B1D3A436B12EA6,0x0000000000000004 }
  },
  { /* Point #4 */
    { 0x747E8DDDBC0FFEE5,0xA50F058AFB9178A5,0x14F41C93B2D52777,0xF7C95492AECAC13C,0x9698BEF3B7F715D3,0xBD7FABC2F132C199,0xBEC856136E9B47A4,0x08C7486E62F85CAD,0x0000000000000036 },
    { 0x3A44D74EB39C9BA2,0x22B4C6AEE89DE157,0xFE4985BBB93DC56E,0x85D435BFDD1201AE,0xA01E7F53AA68D442,0x2A4FCF509D9AFCDA,0xCC4C5B5C6B95D6F4,0x5E8AFA0E8C390221,0x00000000000001C1 }
  },
  { /* Point #5 */
    { 0x0B942D7AC32D4D9A,0xB08FD2DEED8597BB,0x400367544B081B9F,0x317C48889C4FD91D,0xC872FB1418A7BB51,0xD530C7F4BF314B67,0x58D77F7D1C32E6C9,0xE626BA9F0F977B24,0x0000000000000115 },
    { 0x0AD192A8E6B4320C,0x699204E6E3ACB532,0x992CD0C017B5E0A5,0xB58CD08D2E533D85,0x4E5EF9D692939F75,0x13F7C3DB42994066,0x2E2993B324E12473,0xDF6D42138DE5501E,0x0000000000000192 }
  },
  { /* Point #6 */
    { 0x737D7C73B380DC01,0xC2D548F0F16384D3,0xEFF66340A8B806A1,0x67B886BAAF49AC09,0xCA94B2C532EF8BA4,0x94AEF954E8FCA70F,0x448E6900D300D019,0x7EB74B4B8D58FE75,0x000000000000016A },
    { 0xBC7D410FB08731E8,0x37BE53F1C7B75AB6,0x95A94590CF276F85,0x9F3A4A66FC1BA916,0x057C0390B1D4E469,0x218F7FD214CED765,0xA0A788FA60DEA0EB,0x3DCBFC5DF0722A2A,0x00000000000001BB }
  },
  { /* Point #7 */
    { 0x3F8ADF411CCE4FF4,0x9C347CC50B65EEC1,0x83BEDBD2900F860F,0x172F2C33462FB193,0x1DFBBC0A5466F3AE,0xE80DB754FA41670E,0x37D5FD76DC887B1E,0x6D0AEE5C3346AAA2,0x00000000000000C4 },
    { 0x2B44493AA3C933AC,0x22C5B2C2B953B133,0x0680015712F58FB3,0x1953B249E6BD2AA2,0x236A4D0A77CFBF6E,0x7714CC71B91915FE,0xBCE8086663F6028C,0x0B2418D37589CF6A,0x00000000000000BA }
  },
  { /* Point #8 */
    { 0xAA498BBA799E30A1,0x7E193DB1562EEDE4,0x4DC49402F4A94BC1,0xCB63D972C4D7D024,0x98D59716F6778B61,0xE6C0A829B40261E4,0x5F1738FB65E3B28C,0x3C4E80D216A75CE7,0x0000000000000035 },
    { 0x376D19EF733DED62,0x9400E36E0A93203D,0x013EF7CAF98BA94B,0xB7556CA035756AAA,0xC6B8B05A2F643611,0x23891B32438F759B,0xECC9927E27F69733,0x2EBE0180969AE58D,0x0000000000000069 }
  },
  { /* Point #9 */
    { 0x6C6F6E7FFFB2E55F,0x20F4F74703DBCCA2,0x8A750FDE9AE70C75,0xE58B2BF5E75873BD,0xE84680E0EE82DAC0,0xE5F7571A9A8B304A,0xA7848D87B9CAA004,0x3EF58FC8A7927489,0x000000000000003C },
    { 0xBB8647EB313C0114,0x3CF3786396E25144,0x054D370FE16B97A3,0x778CC8C5C31CC5EF,0x43DF47598C5E1E94,0x8885B10AB5555714,0x99F3ED12B4FE74BB,0x5FDE57A77682FEFF,0x0000000000000117 }
  },
  { /* Point #10 */
    { 0x10359C42C7080FED,0xDA9E7FC8CB530B1A,0x1760B2B2D543BA3C,0xD9BA2FEC648F9F00,0x32D53DB01A00CD11,0x38169C6B350C0DAC,0x00780BE25581C0DA,0x529DB2148D2DD03E,0x0000000000000086 },
    { 0xF0752710712C93CB,0x5FAD58568269C013,0x11CC7075B4A1813A,0xCDABBB45EBCF8FA9,0xDDB363D9C837BAD5,0x92974D07F86FD6C4,0x2CA73A7214B8DE1D,0x8E4BF402DB5069A6,0x0000000000000047 }
  },
  { /* Point #11 */
    { 0xCF414BBA078E03F1,0xED6D1D2AEC6F939C,0xE2DD6E938E327495,0x4A1B0D53E220DC56,0xFC7D14B9B91CB009,0x2FC66E8082E76C53,0xF0B24F1A1FCF6844,0x07C90A09EBC5DC83,0x000000000000013E },
    { 0xA6DE36F3044479E0,0x4A571F80F14203DD,0x087824A96A4ED391,0x46288A18E360DBFB,0xD88AFFA272C0FBB5,0xD5784A66E7DBDB32,0x49F340C2D6AFB61A,0xCA61B25EAEF40A4F,0x000000000000000C }
  },
  { /* Point #12 */
    { 0x9417C585174BAC49,0xAC479ED35FE90109,0x40CB51DDC374556F,0x2767E7C46CF0FF89,0x0DF9E9546A284DB1,0xBF89AF89B317CA42,0x863018A69D05C5E5,0xB68C6F8129717E9E,0x0000000000000151 },
    { 0x69A97E79A12E3BD5,0xC85780BF4A057173,0xAB4D585F2BFAAEAD,0x039589DFAEA4C334,0x38823F8A9A840138,0xE4448B345B0D8117,0x9FC3060247E9D309,0xF9F42989A44F2124,0x000000000000004B }
  },
  { /* Point #13 */
    { 0xF0A611DA5FA23CB5,0x963027675A95A434,0x6502B233C1088AA6,0x50A13CAAF5E8CAEE,0x1559DE229CD0279A,0x61B059BADF3C1521,0xDFB294B5D86FC9D4,0x10C56755C13B08AD,0x000000000000017F },
    { 0xCCA4A3042BA32535,0xD13CF25C42D4C801,0x5CB0DB4436B15517,0xE95E8BBCDB886237,0x9EE813B3FFC4D2C0,0xE17DE8F2D1F39428,0x9BF8AA0AFDC16098,0x307E732CC8B2B08C,0x0000000000000002 }
  },
  { /* Point #14 */
    { 0x416D537879F8A7B5,0x43C779870A351BEF,0xC431D876CC63D3A4,0x726CE9B005AB52E7,0xD073CA6AF5AC1376,0x9FE67A4D4522342F,0x90A2F1522C6085FA,0x355509556F5D1081,0x000000000000003C },
    { 0x6271DAC51A2D0BD7,0x69CCB95AC0B17389,0x2BC70FAEFE6A0E35,0x8FF84403C4AEE746,0xA805B2BE66FEB383,0x8F509D89245E9B3B,0xDE48AEA5CEDADF12,0x373B49B94BC91707,0x00000000000000EC }
  },
  { /* Point #15 */
    { 0xF5266DDB2A7C68CF,0x9A74D29F8880841F,0xE8B8D41825116368,0xBF158418BE294CFE,0xDAA1D0ECBDC0CE68,0xE08876CB3630E99F,0x95FDDC4D57B4D4BD,0x14CF5E9551FEC712,0x0000000000000175 },
    { 0xC4E5C08DB9D5B157,0x51631CC80A622832,0x6D8F437961CE0627,0xFC48B55D95448DF3,0xCF0D6DA18B89AF62,0x92825003E90CD79C,0x2EA6B3D4E27C8A25,0xB539BCD15DB408EB,0x000000000000018B }
  }
 },
 { /* Table #11 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x6F7F2FE8B6813F72,0x95F979FE940210F0,0x42CBD8D71A409657,0x2E2D2F08474C141B,0x63E5EFF052A6A362,0xCD24503EB1C5A27D,0x30335D77DB08B256,0x827057CF9724BEBF,0x0000000000000003 },
    { 0x6B372CA7DC5FEEF6,0x7557C331D06696B6,0x4B10D90B4A42090F,0x2C93E9846F10352B,0x72AC24FF2B8DED01,0xFA53F5DAD8C833A6,0xC166ED4B7C9354CA,0x81DF59A09E3B4CF5,0x00000000000001FA }
  },
  { /* Point #2 */
    { 0x8CE9E114E43C6A8B,0x4EE9F8B0804168B8,0xF5FFFD5B5FA74509,0x4589D84CDC20088E,0x00CDB864D8CCA5AD,0xFAB8EE1674CB7285,0xD5E46FC6AB702098,0xCAEB2EF79CDB1896,0x00000000000001EC },
    { 0xF5886BBC26B04438,0x61613D0ED9567198,0x749EB5D8CA99B91E,0x5861944D53B41996,0xDC22071C54DF4765,0x1F6288A8B8414AEF,0x6B34DB2F7FF1C5EA,0x5EDF2873FF5262B0,0x000000000000002E }
  },
  { /* Point #3 */
    { 0xCB9E50B3CC6DCE31,0x0B656FDA60399388,0xD3104FA3600D4B62,0x7CFC68ACB660E0EA,0xD8C2218ADD9F415F,0xB3E0D7C626C649D9,0x37E6279F4D09F7FC,0xE9EF720E136AD787,0x00000000000000E3 },
    { 0x0BADA672D03870D7,0x553EF23F815592E0,0xC1132AD8B8DD5471,0xD8666E9FB80B521A,0x38F49D542C62908B,0x3095F1BEC9F15B3C,0x5AA771BAFE8866D7,0x0FA253A28590B3CF,0x0000000000000015 }
  },
  { /* Point #4 */
    { 0x49D0E9BBF1A37365,0x650F8E4E523FFAFE,0x37B691A0517B3AAC,0x73372E761824CBA0,0x0C0A1AC3063372E3,0x2387470841AA63ED,0x1D70995DAF840388,0xEA733E27491B2E8D,0x0000000000000122 },
    { 0xEB6E7C3B573B43ED,0xA645F29308F87584,0x19A56FE0AF100AA9,0xB767CE92B1D5FDBA,0xDBF9B1B20C349030,0x42F0CDF3586E1AB8,0x65876BEA99631140,0xBF016FD8268AF542,0x00000000000001AC }
  },
  { /* Point #5 */
    { 0x3133809747525F3B,0x49551E31C6CDF694,0xDFBE83625B9451F1,0xFED9C23BEE491931,0x5270A02F324D645C,0xE323781F4175D154,0x31511E52FF475990,0x0B60CDA369B0445E,0x0000000000000082 },
    { 0x822E418092FA5405,0xE78F939B6B4D67B8,0x6F09C296265E1B54,0xF6EF60DDB6BAA0BA,0x1D83F2968BE593BA,0x777E06327E71D499,0x5DB334162E0DED5E,0x6800DC32357E1BE4,0x0000000000000077 }
  },
  { /* Point #6 */
    { 0x7992DA26804ED5E3,0xAC4677B05FCC6497,0xB1A09585208EBD95,0x1C0CFAE7199D3419,0x7C862F540715A11D,0xD23E934F9CAB55B0,0xFD5D250AD4310FAB,0x0976782CAEF426BD,0x000000000000005E },
    { 0xF78B0A7A2A7D5B37,0xF31C5594FEDF69DE,0xB2B9E3F157F76616,0xE9CFA2F23040CCA6,0x8A91BF0C5A72502E,0x71F8A5B63C810D16,0xC9701CE42A7666DC,0x2DA80D6C216A59C5,0x00000000000001E8 }
  },
  { /* Point #7 */
    { 0x46FBCF70AAD63226,0xC023EB8AF2C43F64,0xAB1B684CA3F42111,0xC6262621D12CEA22,0xA2539D86AD523F98,0x76B98970B45F0B6F,0xF9874DF8D788809C,0xB24620C7AB358B89,0x00000000000000C1 },
    { 0xDD50316F92E3B976,0xB6A2FED9ECDF1DC5,0x746BB5D67F40B693,0xB76CE9E40572240E,0x5C65A823084F25BA,0x51BA6ED9B9890EC6,0x3930DEA2CAD192D9,0x2C78150416DD9BFC,0x0000000000000126 }
  },
  { /* Point #8 */
    { 0x2631B3C36EA5E7EA,0x0576E1EDC566C837,0x1E50E071AC9C1EB8,0x5E74360EA8482D3B,0x2E037E7718CEAB4C,0xF7D17456C8424FAB,0x202EFBF582FE1841,0x410F708C8CCA4C68,0x0000000000000165 },
    { 0x659DECE0D00EA056,0x495170F43D1301CA,0x749E3276CF2C6E53,0xC0F5D00087B6F996,0x46B7C068DFD50725,0x83E9D3DE67EF401B,0xEC1CEE4E3D4EF196,0x31583197BEF2DD76,0x0000000000000023 }
  },
  { /* Point #9 */
    { 0x1EB52D8C8961C678,0x9318B87F5188A0B6,0x449DA5F7998C4703,0x814E23EBBA1284A8,0xC4D98C41BCD03139,0xB1FE6BEF965A1803,0xA2B5B201889A0BC5,0xBC93A3519B13CCDC,0x0000000000000181 },
    { 0x17C9763FF4E51116,0x26C730852A842E35,0xDD6481A71296397E,0xD588B1B854F7416D,0x59F846CBC3D62325,0x8F0D9AD920321E09,0xD9C7BB569E1699DA,0x42A8B57F15DE9318,0x00000000000000E6 }
  },
  { /* Point #10 */
    { 0xB6F28395A29D2024,0x77AC682616726DA8,0x295C447073FD20F1,0x9B2EC3F65856531F,0xCA27A7659555237A,0xE497546F7A7BFFED,0x4F51B73BA508D541,0x6B23A204BEFD9C3A,0x0000000000000039 },
    { 0x264295052DDD93A9,0xDA92059C3CCF01DC,0xAECA4B1D851D4CDF,0xF7FCFB537E0CA450,0xE87D6E18CDDB9A15,0xB126C191D895153C,0xC8A744137E5A46C8,0x36AD8A91DE12F4F4,0x000000000000018B }
  },
  { /* Point #11 */
    { 0x32C6A931B227157C,0xD276F7D0D347B7D4,0xDA50395F0AB44F59,0x5D0C517699A52BE4,0x7B0F28E7B97054DC,0xDAE56AEFD8E7B1DE,0x05B0180087B4CCAE,0x21C81809274A0AB5,0x00000000000001ED },
    { 0xC1C7E06B9F9761C7,0x3BD3309FC2A78191,0x2C239FD7702A4F90,0x5686716434A9F65D,0xF8097255C1695583,0x9B59C0BDF8597CF8,0xE0C0EA8558996101,0x30AFB4DE2622F5ED,0x000000000000005B }
  },
  { /* Point #12 */
    { 0x882E70BCF935169A,0xBE4F1A7E9FAA4BF4,0xC00EE4B63F49BF19,0x7108876FCF2EF2C0,0x475D94D6EE33E82A,0x88381A2FBA2B1BAF,0xD6BA047A0E1D8204,0xF49A4704C9AD93AB,0x0000000000000112 },
    { 0x64A6CA0222FCC815,0x35C840DED006E9DC,0x44777FB5D7DC2178,0x3DFBE7FD91CA3731,0x026FFF77E116256B,0x6FFB7C2A648B3F43,0x6688F6C0470A3209,0x632E1094A98C1C6F,0x00000000000000E2 }
  },
  { /* Point #13 */
    { 0xC3120DF78EA50AC8,0x124A99BF819551E9,0x69DD9B95EDDF11E9,0xDE805C83ADCD1283,0x3CB8D5F8A354632D,0x1D9DCBAF4D718278,0xEBF2D04742C9AA97,0xAF43C4B6B9B68E10,0x00000000000001AD },
    { 0x21EDFCB3D2451B29,0xCC9ACF06A48336F3,0x8471E8C311E3E8B7,0x3FE0082E3E1E38E7,0xF9E09F1DF6A8AA86,0x3B445ADBE946EB4D,0x83D1B8D21579DB09,0x602DB173ECAA7CD2,0x00000000000001FE }
  },
  { /* Point #14 */
    { 0xB48FA75A590E92D6,0xAB1888EBEEDA06B4,0xFFB140DD9E71FEC0,0x8FB4C8ED2A623D2A,0x645C4442BDD3FD9A,0x34ADB68F2DE96E6B,0xBD7819EC59225D29,0xA0A8B0C5768B22E9,0x000000000000014E },
    { 0xFC0AB8407662F537,0xF75BDE0788B7FCC6,0x6DCF7E22656A1F21,0x6C1116415318B15E,0x731751BD77A8529E,0x23E7C2723C846197,0xC6AB7B666AD27061,0x7E315762AAD0E5B0,0x0000000000000163 }
  },
  { /* Point #15 */
    { 0x8B2C940F98C0AA63,0x6B8F11B6552F4B66,0x36D68942208BDBD8,0x1A27268D6D35A682,0xFFBABE3CE3C883C6,0xB2F48C34C7B51FA6,0xC307666ACFF5F20F,0x988421026823D193,0x0000000000000064 },
    { 0xA307127DA730707E,0x89C67AE8B63D595A,0x235A76D5075C1933,0x4E1488E6C680DA9C,0xBD34618DAC7D5A89,0x22131BC390FE0290,0xB6709CEFE5F6D0E4,0x6D74A464CB81BB60,0x00000000000000F8 }
  }
 },
 { /* Table #12 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x62B631691C3BE7EF,0xDAB254BF8074207D,0xF6F1466B235A4C77,0x66F8F60FD3B01424,0x9DA540693BAE9F80,0x1A840763500F8A6C,0x542E2DD9B25994B1,0x996307E5183B3CEE,0x000000000000006E },
    { 0x45E2AE85A4B301ED,0x0640D46DE1FB6112,0x7F102D1983FC8F4B,0x6EEECE3A4F30038E,0x74D062F5912F39C3,0xA802A55316906C7B,0xA8D8C58FE6D6E8C1,0x77CFD9BCA57B4387,0x00000000000001F0 }
  },
  { /* Point #2 */
    { 0x3B61C3204268E7AC,0xF9FEF1976DD3709F,0xABD3A2D551F7146D,0x4C03D266F40188F9,0x56E27DFD088BAE58,0x5BA4660D03FA2B77,0x56889642A39FF216,0xC11B9FEACA849201,0x000000000000007E },
    { 0x357C77971DBCA40D,0x23C449C26D3C6441,0x6AD3B6A626CA2D6E,0x32CADCB3B2CA4AA6,0xDDDC43E5AD004AA8,0x7994E3AB37600864,0xF09F263976E4580E,0x6A2032A0A270CD54,0x000000000000017A }
  },
  { /* Point #3 */
    { 0x2FA8A5118EAC672F,0xB58FE9A218B28A2F,0x0DB617AD69CB28AE,0xAC90B7D8ADCC6220,0x3113C468852A7529,0xAAC72C21DF7CF5CB,0x3C1DAFABE341E2CD,0x8AECF2A368E9CBF2,0x0000000000000149 },
    { 0x1461A475C3ACFC2F,0x53EE5E370CF6C4E7,0xBC89CD30D20FCD4A,0xABF7AB383CB0B266,0x6030727CCF12EEC3,0x9B3E7CB790F159A3,0x60DDDE88B364C651,0xA575474E0FDE7B06,0x00000000000000B2 }
  },
  { /* Point #4 */
    { 0x598766CE569614A3,0xFC1534F1D485CC29,0x1F5E87CE4F099A45,0x93E6071F387D4D84,0xA3F72298A130F8BC,0x51372018EDD37225,0x165340E9B856F72D,0x4D64EC749011BC47,0x000000000000004C },
    { 0x975D2C0D5B62D194,0x845D25CB1BBD10BD,0x1326F9D742EE849A,0x61F90228A333154C,0x4993F33D7500F71E,0x3824DC401B6DCF4E,0x1C71E193B65B8ECA,0xA8DDC0C7DCA1396B,0x00000000000001A3 }
  },
  { /* Point #5 */
    { 0x0DD159BF9D906490,0xF3167E2C9CF878DE,0xB2BCE4119FE4E683,0x1F7EDC9AE82D628A,0xCF4A33ADCD23E4DF,0xC0A4905821CBFAF7,0x192FB797635E858E,0x68DAD953325E6C47,0x00000000000000B7 },
    { 0x662DF57814E26CC9,0x601A649FC83FC419,0x1AFE2549C80CFB85,0xEF38EB320B949F46,0x5FDF36647B42E487,0x7073C6AFD509DF41,0x7CB9E459066A0911,0xE397A29C946811E0,0x000000000000008E }
  },
  { /* Point #6 */
    { 0x35A51EEBA9C350AF,0x22821A636097710D,0xF5A5C2C95F6EE6E1,0x8F9F201269599BA9,0xED36867F12918EA9,0xF1A5450D0EA832E9,0x58C5A7311E15E027,0x5A6460D600416B3D,0x0000000000000198 },
    { 0xA0AFB24FCF8C23F6,0xDD6966EB2D40BCA9,0x7C8D20AABF132AB2,0xC24EFB7D7D32B64D,0x26D793380C9547F5,0x7E7D62251FB47F5A,0xF1F5880D9A488725,0x8EC9740D38749037,0x0000000000000030 }
  },
  { /* Point #7 */
    { 0x40BC7A65B7C2CF3B,0x5043C6C723C30518,0xE7F93C6544DE8A14,0x5F8B4F4E89ED4019,0x52D6E1F596F258D4,0x23749D1DBF255616,0xE03FEB69AA7F5F1E,0xDB07A6A90C563D0F,0x0000000000000163 },
    { 0xD40290819DF56623,0x18B71B89C125A069,0xC4F119F0B7C6D7DD,0xE6588CF4E05C3E73,0x0CBC6A79876F22F1,0xBF99DE26E6EEAEDC,0x9AA4741C1B6ABA38,0xF7CC38A4CE3A2DD3,0x000000000000019B }
  },
  { /* Point #8 */
    { 0x7BAD211D4CA94CE3,0x7B7BED87D66CC144,0x7EBA714BBB5EE0CE,0xC26E3A3CF5EB8337,0xE5C617983DFEC21F,0x9C679E26117BA62A,0x6D67DB8C1B6E1641,0x1C2E077EE31C06D5,0x00000000000001A2 },
    { 0xC0D71279CDC2D75C,0x0B15B14709371B29,0xBA1F3359DC2CEB6C,0x9A701873BE25DAD5,0x03C466B8C8BFE287,0x9697F32941EC3009,0x4E21E900B4A54990,0xEE1B53C8A99D3093,0x00000000000000D5 }
  },
  { /* Point #9 */
    { 0x0A3A1D68DC95DB9D,0xA5C38305CF75DFB5,0x488C420C6E7E027C,0xCAB3BD50749040AA,0xA50B861EEE496851,0xE9EC1AA96C3FFFCF,0xEBE4D535B05F9EDB,0x041472E9CBCDEC8E,0x000000000000010F },
    { 0xB0E8FE769850831D,0xAD09D3EE0BC53C52,0x11C864C6224F7773,0x965A25175AA5E0CC,0x76EDD7BB9546B27E,0x6C41F158A5703E55,0xB857BE3B67ED0E1F,0x80B601AF815C2853,0x00000000000001AC }
  },
  { /* Point #10 */
    { 0xCACF7227489BA5D2,0x1A523C29F67D6ED6,0xEDFB4CA69923509B,0x571434694CA275C9,0x31B2E485340E8FB1,0x1839D1E3FA9CDB14,0x0F1F4AA874423836,0xA1F66938027614BC,0x000000000000012F },
    { 0xDDD453D05635BBD0,0xF078BBFBAC909F3B,0xDC827EB809CE7304,0xBEECD2DE0F10ECFF,0xEE375C35E43D5225,0xD47F1C6DC1CAF971,0x6D9B9DAF56133721,0xE2E43B93763D052B,0x00000000000000B9 }
  },
  { /* Point #11 */
    { 0xADE5960BE228E043,0x48C80804F42A814B,0x299F7124F55B80A6,0x84E266B7CC584AC4,0x0583D3979C5CD654,0x670F05C3F7F2325C,0x15E7C1D23D2C9C88,0xAB084DC699565917,0x0000000000000062 },
    { 0x37456DF063A823E6,0xA7A22F47F18D1728,0x1379A43316114C50,0x2019CB0E6287C78C,0x0B5619E60018FCE9,0x465896ECC50E946E,0xCE912C92524A795A,0xDE99A5C6F7B944C6,0x0000000000000065 }
  },
  { /* Point #12 */
    { 0x9A842CD1D7D39F33,0x45D1AD8C4BCA4AFF,0xE490B9CAF398D092,0xDB73AAB1DDE5BFC4,0x3B7984D7741C8E35,0xF0B828D5F5819FED,0xCE2FC89BFBAAD5B1,0xDA615DF411C9E58F,0x000000000000015C },
    { 0x4B01920AD96156FA,0x221381DCCEDF3B14,0x98DA481C5D9B1206,0x826399DBE4E4C2F0,0x51DC45B6D73DBBD5,0x68F639EB3F275528,0x7093A3AB2D235520,0x520F9416E8429996,0x000000000000013A }
  },
  { /* Point #13 */
    { 0x37E172F3E2C08623,0x882663C4B4A56F2A,0xD1F3145E8884C202,0x05A3BB5E473AF962,0x77842BF6EBBA4C7B,0xDD7D579C24086988,0xEF6A7B7DB6B2FBB1,0xAB0E5EAEBB8944E1,0x0000000000000120 },
    { 0x4D374271D14AA9BB,0x70A7FEF19BA34C85,0x078E4FD98760F6B9,0x7B7E23A15B53CB19,0x2967D06B9272D546,0x92E5112ACF09516A,0x416E5ED7BDB078A0,0x726C89EC9CE1BC10,0x000000000000007D }
  },
  { /* Point #14 */
    { 0xB3638DB98048A2D6,0x0526971177F15306,0xA09F7697DE04E4F2,0xC782F1073CFBD4A7,0x0232781E01ADB58D,0x2CAF85D422724EE7,0x952F12DDA5CA3245,0x658D58A74CC18585,0x0000000000000191 },
    { 0x35AD5DC0145A3B22,0xC6ACB7E2D56FC847,0xDCE25662DA9B5FAD,0x3C6D9C6620861F44,0x4C3680EA5C573776,0xF59066292AC95553,0x5E70EC1C5F814C5E,0x3EC45DB4DFCDE9C1,0x000000000000004A }
  },
  { /* Point #15 */
    { 0x874AF4D4126A0C8C,0x3328A9AF3E16A72F,0x2934AB97F021B43E,0x63E437E9561F00AA,0xB15E3F49F3A94E26,0x35CFDE7D3EFE25B9,0x4D647027AA8CA319,0x91E0124E6BD5FB33,0x00000000000000FE },
    { 0x6CFA73310B4DDCA6,0xD8479B773BD66215,0xCECBF081D0474238,0xE46E2B3B4355CB2F,0xB891F6958ABCA134,0x5D9B6DD917CF9FB6,0xAD177BE33195121E,0x2C29B9683E29B170,0x00000000000000E1 }
  }
 },
 { /* Table #13 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBB59F2675C346588,0xAC37B36876F373A1,0x4826E015A4C6D860,0x4EF341B061BDF224,0x70B01FB4BECAC30B,0x5F518CFCF0BB0C51,0xBBEC7A919D163117,0x8A65BEE8DE2DA58E,0x00000000000000BA },
    { 0x965CAF8E566098B5,0xE8BA0E81AFBD8436,0x77F4E27D7299FBC1,0xF5169F5C367E2155,0xC88FA56101A49A6F,0x8A6A0228557B66DE,0xC867F1FA8E1BEE40,0xBF4B5F806DE8FCED,0x0000000000000042 }
  },
  { /* Point #2 */
    { 0xB19A5828676A875A,0x40729F28C83A4911,0x511949B1C6DCE05B,0x25914C8C3FCF0490,0xC49490DE0C6C2742,0x3B21FEEFDF6CD770,0x012D2802DD1A82A2,0x72F5A0B76453439D,0x0000000000000020 },
    { 0x3E85D07D9B58E26D,0x56527BDD1C50AF24,0x564B56587DF377D0,0xF5B0335865E97A30,0x2B22D6E96B31BC52,0x8AD449ABCCCD4BBA,0x84B8B888F7C162A2,0x3B647F0E4D56F29B,0x00000000000001FB }
  },
  { /* Point #3 */
    { 0x59FA6794628233ED,0x1C30A04A25A1287D,0x8DD4FDCABF3FAD38,0x522AAD840D0B6F87,0x12A66E90D160F8CC,0x714213F3E673AF6B,0xD5E6FEEBAD0AB724,0x0DDF08F16A892358,0x000000000000001F },
    { 0xAA50ABCEC077FEDD,0x36E6411EE7610FEE,0xBEA885D1EB815B83,0x9710ED6D5D57A6AB,0x794E6F1B85645674,0x7608184DF124CBF1,0x356377F6CC8BE47B,0x56CBD2604B3E7161,0x00000000000000D7 }
  },
  { /* Point #4 */
    { 0x0B91D5244CFC2928,0xAADA5377F9855767,0x43014E69652CAD7F,0x8680000DEE500EBE,0x95EEA80462086EDB,0xEA6484375CE7CD0A,0xEE14680D51A5BB78,0x28363F309167AE22,0x0000000000000047 },
    { 0x5335DBD719692E28,0x30C79590C6495AD7,0xB9F87B1462C85189,0x5B87C196C5B0545C,0xBBDFEF3CBE7FB4F3,0x2B531D69F3216D95,0xE7298F7361C8215C,0x9652E358D96015DB,0x000000000000011D }
  },
  { /* Point #5 */
    { 0xF42C064A910FDA3A,0xFBAFA50FCEA6AA25,0xAFE5F5580DE9BBBC,0x24E9D4AE0E89FB39,0x5B71973925C76201,0xA87EA5295475AEEA,0x1E5495E03C4BE889,0x7866138B995AD46F,0x0000000000000087 },
    { 0x5F9F803E46AFB538,0xF8C0F078CA875A75,0x63F1050A89B71552,0x0858BAAB8D43BB0D,0x8DC61935FE38CF7D,0x50FBDAE220F815EA,0x6C6A84E52E070889,0xA524045E73FB1857,0x000000000000001C }
  },
  { /* Point #6 */
    { 0x0F9052C7B597EC4B,0xC6F41C80AD573AB6,0x347A20E1E3A60425,0x8B466CEFC852CBB5,0xF38734D5DC78E008,0xF347CD72D1AD9A04,0xB82D096F30EEC82B,0xE43CC8E9CA4F7AB3,0x000000000000001B },
    { 0x78D630CAF659615A,0xD686695EB1617E24,0xBE1C2194D5983CF9,0x4522D8F78329CAAE,0x672FEE6B101FB01A,0x1B1F4C0950D301AB,0x7DD87DAC5E431E1F,0xBF07EE0CEA0100DB,0x0000000000000172 }
  },
  { /* Point #7 */
    { 0x32966F76BD667641,0x7DE72BE5F0D579A6,0x0A6FFAFB81276712,0x0C76A2135E91A169,0xEB960ED85F953CED,0xAA5F7F8F0BE111CD,0x2CD0B477911F59FA,0x059A70C6E5220A86,0x00000000000000DB },
    { 0x16F99E8BA61C4277,0x011745B656710251,0x13CB7D19F1EF7FF2,0x2162EDB414F0C0E0,0xB0A459E867467A1C,0x2CEE2121248E6FC9,0x2BA236EB98142385,0xBD7465C91E63FA6E,0x00000000000000DA }
  },
  { /* Point #8 */
    { 0xDEED672DA38BE841,0xD62D42D762FEBDD5,0x002AA47E2D4AF6FF,0xDADCDA955BE24D99,0x91EC05C46727939B,0xE7535C591B7966D0,0x83D7F5F023C47893,0x470BCA4E2C4E6181,0x000000000000010E },
    { 0xFE45F9698440535E,0x240E6B2C49ADAB54,0x61089282DB726B76,0xCFF3E30BFA643350,0x3AAFB169A7C01F88,0x51923C30E0A5514D,0xC077936F3CCC700A,0x23375769586F4854,0x000000000000006E }
  },
  { /* Point #9 */
    { 0x2A46C0A786B50C9C,0x82C3D6AB0A057CE3,0x9383A37776C283D2,0x558CBC681C11C68D,0xA4F838D6A0C20CFE,0xA3C536E041372541,0x8186B8FB547A8C5E,0x35FC4083DFF536F9,0x00000000000001F7 },
    { 0x0050EC2A19563D8F,0xBB0280F79484F295,0x7DB337B17B134EB6,0x0342621ECAC07F11,0x02390009001EB285,0x4299F505176A7035,0x8EC094A280360ED2,0xE4655868859795CC,0x0000000000000181 }
  },
  { /* Point #10 */
    { 0x40E4767B3A33F4E5,0x8E855AA95E883D33,0xDD6F45F8F9612594,0x86FB810C172C2FF4,0xF291D500135C94EB,0x833C0394DF6BBA7B,0xAC3CB02414130295,0xCE0284232CB84C7A,0x00000000000000C0 },
    { 0xC9DF103571F01F41,0x7E3E1F80695182F4,0x7F8BE627D5E7BEBF,0x610C73332AD79463,0x0C2DA840A4C1280A,0x3A7836F6589A42F3,0xEEAADDC62600673A,0xC0FB7900BB4CDA8D,0x00000000000000EA }
  },
  { /* Point #11 */
    { 0x63C19EA5212101C1,0xF1A83D3F2A79E339,0xC32B350C45C6C251,0x403B7F19FE63047A,0x5CACE87183C8FC2D,0x8F682259F8B3BA77,0xC28F8686BBEB6E6F,0x5B6FF8878B53B422,0x000000000000011D },
    { 0xA2346206A7084BB3,0x4AF0A26CDF24EB15,0x4851547C15693983,0x6334F835959D138D,0x7A017A94813F9811,0x4690B7B95836E6C3,0x36DAC227314A8CA1,0xA208D1FCF47A571F,0x0000000000000023 }
  },
  { /* Point #12 */
    { 0x300AEA06CDC7F195,0xB17949A009DE468D,0xB7C96B415516C840,0x1338609B7D5C117D,0x1A0769311C14B301,0x98B0611B33D79A36,0x7D9F34F8F4821D55,0xE32FA3EC32341943,0x000000000000004B },
    { 0x4020DB19F59CDFE7,0x57A74903814C52E5,0x518262FBA6923E28,0xE24794B3350CB107,0x156BEF9A1B18682D,0x8DE1CE5F8B25DEC0,0x4236A8703EE3C6D3,0x15D391FA5DB7BADB,0x000000000000015F }
  },
  { /* Point #13 */
    { 0x4B302E0449BBDCC5,0x8AC1D4CED5DF9D23,0x16933E342D5ED03F,0x84C14BB7310C7EA8,0x8E175CB4F2775AAF,0xFC626088CC5C14FB,0xA976DFBBABC13577,0x1B65DE60DB34A758,0x00000000000001AE },
    { 0xB8EC8C8F404A16A6,0xFE2343A865C21075,0xE88C40AD281FAFF8,0xCB4247FE98A7765A,0x71BC7CB433F10D29,0xED29AAB9BD10D6B0,0x3D10065AB244B20D,0x421261E9F858E3A2,0x000000000000003C }
  },
  { /* Point #14 */
    { 0xFD4D1A9DC4F5CFC3,0x362BFABF6912EA9C,0xE605C3BCC052A9A4,0xF8B5B0ABEEBFDA9C,0xCD94783F8DE7208B,0x7C59E87377C8D3FC,0xD26411C2A04AEFE0,0xDC8BE520DF4FB819,0x00000000000000FD },
    { 0x70F230CF399ADBEE,0x899849E74A06009A,0x332D4DC5F4ACC90B,0x768BF06D2257C966,0x9ECB4F986293CC44,0x942AA5DBF68AFEC9,0xEBB5A4689FD7AB25,0xBC2233732190CBEB,0x00000000000001B0 }
  },
  { /* Point #15 */
    { 0x46D98F975BF61D77,0x3F07B422BB29A183,0x3F70393F4DD94AFE,0x7A92252DAC222E32,0xD7771A93C3DDF1AE,0x5AED637C44720E3B,0x0FC5D9175F92473F,0xF11CECE87A9B58C8,0x0000000000000197 },
    { 0x4BD350DA7C355BF5,0xB93B27EE3134AF3E,0xE84F3D372513BE74,0xF8C140A6A76034E4,0xD99AD646FFAAE759,0x7DF0E535E8EAB681,0x3DA2399716F4767B,0xCE44ACB9623A390B,0x000000000000018B }
  }
 },
 { /* Table #14 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x9AA53B475A714194,0x01163DD86957D5EB,0x5BD2C24F908F5929,0x87F519F4DBE42B0F,0xFF767379FB6B5AD4,0x4D0F8BBA9A193F28,0xF3C42BD0EE549D79,0xBF851D3F825244FA,0x000000000000009B },
    { 0x825FFB609F78B57F,0xD1913668E0F74B73,0xF42A5B035468F89D,0xA2347499AACAE46C,0xC771E34CC85272E8,0x295684C1D427D3A1,0xED749903433451DC,0xB872072C0CBABBD4,0x0000000000000049 }
  },
  { /* Point #2 */
    { 0xF98DB50E8435735F,0xEB51C34660BD7B77,0x200ADF1E996EF096,0xECAC256B57B8D488,0x889639B07E65EA9F,0x4F763F7313A4A243,0x401C22A42957DB01,0x86CFF8BC68EB751E,0x00000000000001C7 },
    { 0x1C0549EBE47805E9,0x57716280B223B355,0x69A29CF4DB5C068B,0x63FB8A8C432AF690,0xDCBB94F97F36EBD6,0x693983DD08609C4D,0x69875F98D458FA6E,0x149758E81FFF90B4,0x00000000000001EE }
  },
  { /* Point #3 */
    { 0x8452736310A0D011,0x299E1CB30BBADDD0,0xF5F3079B5294C956,0x9EDD5FA24F0A3584,0x764BB175641F1FE4,0x0217A94A93B38DB4,0x61C992B7E31E6FDB,0xEB231629764CABEC,0x000000000000013B },
    { 0xBD3B12A4D2E8C15C,0x8EEF9B5D8ACCC1F1,0xB931FBC752747252,0x8A7B86C7F9817BEF,0xB52330BA584E1181,0x9BC4926D25A0A0AB,0x002FEB9B89A625D7,0x653946B5DB41831A,0x0000000000000061 }
  },
  { /* Point #4 */
    { 0xF1EFE65BEFD91D43,0xDD872FB0AA3323E3,0xCB7C357901E9DD62,0x04677143CD97EBD7,0x906ECEB8806E055F,0x334B997F2FD96082,0x41A732B0CAAAD051,0xE1B97E125BC0500E,0x000000000000008F },
    { 0xFC4E9BAAA1BEE510,0x2B887E327D63C5F0,0xCFB9C52EEE6CAD4E,0x596BB714B0B8DD96,0x2DB254C665F9A215,0x000359BDD799749E,0xC4ECAF126D91B457,0x8153709EBE4F02F6,0x00000000000000C4 }
  },
  { /* Point #5 */
    { 0x2218489B09D9E2F2,0x563769927F4FE3C0,0x61E365211ED2B98E,0x166D671A178D242E,0xB65381C97E8D39B6,0xAEFE583A82851B43,0x6CAA4459A24A7AF4,0xB421380F5640D447,0x00000000000000B5 },
    { 0x706A413011D91549,0x4214BE92E3064F4A,0xA7C3B7B8B7649258,0xA782E2FC71C05DDE,0x0FA90EF683D30793,0x1C77425B15DBD474,0x917CDB42FC0B16D8,0x7EF5FAF8C7BFA045,0x00000000000000E9 }
  },
  { /* Point #6 */
    { 0x5B408946A60059EB,0x0D707CC2A1E69F42,0x9BE262D3CDDD4401,0x0C2D64BD01C14145,0xCF8B305A27C198A5,0xADCCC32E05C03494,0x22E5F02B6C1DE307,0x2AE62BAC48F43EDF,0x000000000000001C },
    { 0xB02341CD598A8EF6,0x0E6041748456480A,0x159E591932132353,0xE03D4F2C8B3A8A62,0xD1190722F861D8F0,0x59D3D3B6A37C89A2,0x07FB0E16A2987768,0x5DD98E191DA91A16,0x00000000000000AD }
  },
  { /* Point #7 */
    { 0x09238DE907AE5402,0x14FCE2B1444B8B61,0x37EE7AFFBD0D2EAD,0xECBC75DE97804504,0x343A5D1A3B5E5FD8,0xBF806EE5A90DCF6B,0xD07F1054B2BF2A3D,0x6F590326ED9FFFE2,0x00000000000001FB },
    { 0x9C42832DE6198AAB,0x3EACD0ED475EC98D,0x715B6AA8937FFE67,0x4B35D1E7891BFFC8,0xFAD8AF9CB36A8835,0xA3A21D6F7B8F6F81,0x4FAAF12E771C3B1C,0x4E05313304FAD4C8,0x00000000000001F1 }
  },
  { /* Point #8 */
    { 0x7EECDFE4E541183A,0x7B0DD2285AA8B868,0x8D38CD0C1DE22F71,0xA9CA796DBD2638C1,0x1819373249E5EA36,0x4FC5461729212B0F,0x4F3874D22DEBE3F7,0x46499322CD4B02FB,0x0000000000000015 },
    { 0x7977CDAAA3BC23C0,0x954AA6D88BA98676,0x6B8471C793C7BF98,0xF8025A0B43C70437,0x0ACA0D09B1A8C71B,0x9FB1D00B6FC48277,0x50BCCC4EE312939B,0x5AEAF55665E5DF83,0x00000000000001AB }
  },
  { /* Point #9 */
    { 0x296C4E5E4114124C,0x8F760836D47C56BD,0x9FDA0A36F6758211,0x2BC5E75B36CD51BB,0x32E6873F1BBA9F2A,0xED7A7C288E6C979A,0xBEC902BB47CCCD6C,0xACF4C76C48DCA66A,0x0000000000000080 },
    { 0x44A892F6355A975A,0xBBD44A35BD1B1666,0x6B49014CA612F865,0xCD50CBB36B81BD2E,0xB25E204FC26BEAB6,0xDDCF6123F93FE188,0xA3C651667A980260,0x87F09AF9E19AE815,0x00000000000000C5 }
  },
  { /* Point #10 */
    { 0x36FAFDE5FBBD4E98,0xAF44B924868FF31B,0x0281A7FA945AB6B9,0x2A4BC2C85323DF28,0x51959C042A3E0FB6,0x6ABA3103143C1A63,0x3A572DB88876E600,0x418CD1B4506EFCCF,0x00000000000000B6 },
    { 0xF121C2F9BEEEB151,0x69C65D11D76943AB,0x74063608ADDB71D4,0x072AF1C6702D26B0,0xE0FD470B473B6EF3,0x765B0F46BC36697E,0xA24B34BCC6ACD252,0x0401F4521C3311E8,0x00000000000001D2 }
  },
  { /* Point #11 */
    { 0x3F298D941C6A01EA,0xB6EE6874DEC1F22C,0x189023AC496D5522,0xCA543ECFC08A48C9,0x240CA6A0A2DB1EA9,0xA591EF2E54492401,0x22027038344BCD0B,0x34CB84596DC4CED7,0x00000000000001DC },
    { 0xB5A949080414ED02,0x8BDDF24BA14739F7,0xA788AB9679AC753B,0x754163A977FE2FF1,0x49803F05AF045BC3,0xF482041842D13F83,0x9F86243CD7528FA3,0x9B4C2ABE08588F48,0x0000000000000131 }
  },
  { /* Point #12 */
    { 0x34853C5D35DA05AA,0xEDF100F6B15B5D6C,0x1DC6E841D3DA67B0,0xAA5D83F0310FD872,0xA686FA787CFD885B,0x297A0E48B09F9C96,0x9E899C7DFBD40E05,0x2BFBAF44B9589B4B,0x000000000000013D },
    { 0x937376913784F654,0xABA39EE088F316F8,0x7FC611358A3C3666,0x5A09DA1F80A1FADE,0xFFD6018133651828,0xC400CF569A7AC400,0x64FC091F665C4152,0x8679F2D7C350F654,0x00000000000001EC }
  },
  { /* Point #13 */
    { 0x3AF9DCD14473F37C,0x7C31843080E36492,0x5115486AC8D049CE,0x594EE800B10D6316,0x3C9AEC97F913F656,0xC9B99AE4476865FD,0xF9A597F80FECFA86,0x59313AAFC2664276,0x0000000000000020 },
    { 0x431F1976E5A1239A,0xB406A1EB58838D43,0xC023F4698D681F4C,0x5F1DD612DCCCC654,0x9032C342434F82C6,0x99BC4322C7965DA3,0x8C2F2CE32745885E,0x415FF1A86CF68162,0x0000000000000009 }
  },
  { /* Point #14 */
    { 0xB10FF95E0E9132F1,0xF49E33B7045C8800,0xDF0314F4842D3BDC,0x55FB97A8F584E160,0x0B923612E71C4D35,0xDB8C2885EA2F1D23,0x514E37D7DFF21F90,0x0A0CBE3DFD2278EC,0x0000000000000081 },
    { 0x20DAF0C8E84E328A,0x9885850D6978F468,0x8FFFFEB098151489,0x5BB7FC177A0B4D73,0xFC401E51706E036A,0x7016943C64C94259,0xA8CDD03A570ABCAC,0xB94B40DF2520B74E,0x0000000000000167 }
  },
  { /* Point #15 */
    { 0x41EC06596DD7D8C6,0x8BAEAEFFB07D565D,0x55F5138C26C9B544,0x975E212788825EE5,0x90422CA7C1A092E0,0xA03DE4E8DBDE0554,0xDF408882734E71A8,0x80E01F63A10CC8E4,0x0000000000000157 },
    { 0x7B4E0E130A65CB93,0x1F3E7FAEC1E49A1A,0x1B12FDB3DD71B3F8,0x8D32D35F1253F42E,0x38E09D674312F8B0,0x9A727EBD4281B5CE,0x0002358ABF211BC2,0x46C3DBA13E61916C,0x000000000000003C }
  }
 },
 { /* Table #15 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBF2097B9414D9815,0xFA0673B3CDA66DFC,0x8C775677193B17B0,0x07C8DBF6C5387E9A,0x141DE69D4C5DA984,0xF0650AC806A8B133,0xADD766EED2B258C4,0xA6F4276396303678,0x00000000000001DA },
    { 0xCDBF1DAA39C8824B,0xF8F2CD8C5638CB0C,0xD966C8E9B6D33286,0xE4B63EF8C1331E1F,0xAC72D8E3FB5F843E,0x110D0D4A8FF6B4B6,0x0067FE1EACD5CF3B,0x5EAAE5B321C1E826,0x0000000000000068 }
  },
  { /* Point #2 */
    { 0x9917E8CC2C863225,0xE627D938DFF7A5FC,0x62017450D3C9FA85,0x30453775CE2573F1,0xCAAA02C343E3B41C,0xF541C0065901E5FF,0x78EC0E91E163AA77,0x1CFD0693F446BF70,0x000000000000009B },
    { 0x82AEB71678063F41,0xC442F8A7861C6782,0xCCFBC9F3F28B51F4,0x92A5F71127335516,0xDB6DC76E23578EF8,0x365972B3CFC25F57,0x0DC48630AFD7FCB4,0xCCD4F3DE87EA6884,0x00000000000001B4 }
  },
  { /* Point #3 */
    { 0xC1D7001B26E22B52,0xB4B208962825905D,0xA064FDCDE739E7BE,0x83BFA334F2D62D9A,0xA2BAF3892758B810,0x3A88F2E4EBD64633,0xD621BE3476DFD697,0x7168C0779F4A85C3,0x000000000000017E },
    { 0x5B8F06F520F8F0EA,0x95E44505CFACFC46,0xE20192BD787844B5,0x316468C44A04ADC2,0x30D71497D6774463,0x7C826A925A606A2D,0x22ABADF981BA512E,0xEB15B45FCE26365C,0x0000000000000146 }
  },
  { /* Point #4 */
    { 0x72F88BD2A3B42A3E,0x7CCA9272C8287E7A,0x527C4A5CAAD93849,0xFB481C75DA6615C2,0x27CE59BF042B3497,0x70B3FEA29EF62E76,0x025ECFC40D097F4B,0x5EF137DA607F9D21,0x0000000000000053 },
    { 0x3295047616741F79,0xEAAC9E23A4E120E4,0xE15F333776F4FE2F,0xAC402F2D8028F30F,0x87A6B88B99C4B4D3,0xFEDD124CB0866E18,0x07C5D4334AA80397,0xAFDFA6830961D56A,0x00000000000000A6 }
  },
  { /* Point #5 */
    { 0xFBE699BD99BCA15D,0x0D1C3672BA48093F,0xF73D4880AB23124A,0xC1752BA2835A7F27,0x94B303885EEDE054,0x188F6B28D7F00082,0x2828FC7086A04627,0xAF12D73544BE79E6,0x000000000000012A },
    { 0xCD758E79D7B22FC7,0x3187D186A66F1012,0x46D5D067DCDDBC4E,0xF2F7629EB711FA20,0x66252C90BCED7A88,0xA22574D032982565,0xE80016196EBB83C8,0x731A6B8678FBB10A,0x000000000000002F }
  },
  { /* Point #6 */
    { 0xE622C1EEF4CB671E,0x0D5CCBBC4F2C446E,0x67162B0FD7A668DE,0xB8D73E543A58F44B,0x9E5E6962D0E7294A,0xE7BCEA9E4F8CD419,0x41E955530CD909D9,0x4C57BA892F369B49,0x00000000000000DF },
    { 0x2822437FD5DFE006,0xFDA5F55016B877FD,0xBFBE8E314B6D4987,0x0F23A45DE00F8C47,0xF329399D8C38D7B6,0x07CD2DC651B398DA,0x66CE21542942A61A,0x762E37FFAE1A8BFB,0x000000000000019B }
  },
  { /* Point #7 */
    { 0xE93FF2EFC4C926E6,0x417AE2113DC958D5,0xA58BBE5E770DAC2E,0x1C0F5F798CD4F091,0xF4F9D63E46153DAF,0xF33CE1A5EC37EA0E,0xCBE10924EE187FF7,0x3E986A34F34290F5,0x00000000000001B7 },
    { 0x597B1F321E9E074D,0xE88F6C8A6EE84E95,0x5CCC3EAB6B90E61D,0xE27E2023CCB5CBC0,0x79E991FC2FA7DB33,0x4EE221B7D66BBA72,0x90059ACB4FA39A46,0x1311930A6587F688,0x00000000000001B9 }
  },
  { /* Point #8 */
    { 0x1F70B2980AF43BD4,0x9351C3C2D13901F9,0xF702C613845EA55B,0x892BE0152C193388,0x485C40141E6ADB21,0xF394D50E9296F310,0xDA5872DFB9AB0F6F,0xA10BD887F5D389AE,0x00000000000001C6 },
    { 0xE268935DC8F44C3C,0xAA7E595BFA72991B,0x78C2A8E39BF7D8CE,0x0CAADDE13B655948,0xD9444BE5C080228C,0x4990733BF651B425,0x7513085102578B0F,0x5C375BB3C5635719,0x00000000000000D6 }
  },
  { /* Point #9 */
    { 0x020508688D069D96,0xBF4B365566B34C43,0xB6CAFBE67F3DE1F2,0xFC512E1F1B28142D,0x74FE98736CD17E71,0xE39E338C8A44F1BD,0x5EEF8572DBA3C6E8,0x2AC5241068E236E6,0x0000000000000155 },
    { 0xABDE27794F05F2E8,0x22E67F89C4291117,0x6F01971ED836F104,0x34040C96C516A0A1,0x2EB86EF1C9BCD434,0xEFCC2DF3EA30CA89,0x05535B75BE065ADD,0xFC6FE9043ED10871,0x0000000000000170 }
  },
  { /* Point #10 */
    { 0x8B08F5E5EF9D57D0,0x996375F6095BDACA,0x9177610E107D99BA,0x636E648A44936FE9,0xD1C2BB0D0A6DDACA,0x50B5FE3A041394D2,0xA46E0BF5DF8329E0,0x5D5B9342A9697B7D,0x000000000000012B },
    { 0xDB0EAED26E986A7D,0xEED1D5B8C6EBDC54,0xF8E87D5D74B7578D,0x035C95B4CF21C064,0xCD970A353BC9F334,0x6542E9358B6F6675,0x7141E7E2696C2ADA,0xF3919226D49FD9BE,0x0000000000000091 }
  },
  { /* Point #11 */
    { 0xB3FE48F3B6D90AD1,0x003894EC9F2A94A6,0x1DBD05F4F1D1718F,0x9E07516A59A35613,0x9FC488CD5B65B5A6,0xCA4609F8D3A2619F,0xE7B6D1F10907796B,0x8C95F67067378F56,0x0000000000000034 },
    { 0x7E5AF4FD73F60E0E,0x49D97796C541AB15,0x6D06AC3451C68E6F,0x5580386B80B5C20D,0x5543E65E7B18DD5B,0xC0C46D3DCB20F8E2,0x5CD129937B7658D2,0x06BC8A3C4CE022F6,0x00000000000001F4 }
  },
  { /* Point #12 */
    { 0x5AFA559993277813,0x0D5829B167DD2F47,0xB8AEE8B3F53CECF3,0xD1D3AF28EF68572B,0x606E2513AF564DF7,0xF37BD402F6FF28F3,0x470C137B1B9DE2EF,0x82C831732E77FCF4,0x0000000000000150 },
    { 0xC81D8B9BF824F95D,0xB8B7AB5A55797846,0x8000C20B304C8D8D,0xC2D4EC7838D73E40,0x334EBB9287A3FADD,0xF0E2BDA2D50BEBAC,0xD90CD1B0E8F7CD44,0x0AD86E7FF3278069,0x0000000000000180 }
  },
  { /* Point #13 */
    { 0xC47018DEBC2DD99D,0x7B4DFA32444763FA,0xF14F11C3CEBAF84F,0xDA34D7A03799E81B,0x80486CCC2351DB7D,0x313FA62F071B8E02,0x17B0C4C2B4A0FEFE,0xF96F6BC9C2E6A4EC,0x0000000000000126 },
    { 0xAF70B2576B54CAF2,0x15E751D9C1EF3008,0x4BB6C7BCEB6D3E35,0xB4ABF99E0C80C0CC,0xA6C8601B1F18D3DD,0xB8B1624F8D48620A,0x343B56AD83587563,0xB1B4243C04D55C18,0x0000000000000076 }
  },
  { /* Point #14 */
    { 0xEFE6AA1F2E7837F6,0x2FC98F9481A09AD2,0x0B0096038113604F,0xEDF83A00C96E0236,0x68E20B2CEFB41EF6,0x736EB1A05753C561,0xAE0984D6486BD49F,0x879063A1052F4C5F,0x00000000000001CF },
    { 0xDED0B68E69D091B8,0x04FE60D73D26BE6C,0x9CF22103D23AEF67,0x06352A6D5B4D2099,0x8741E044FD6EC796,0xC15900A4FF81A6D5,0xC569E2809D61E6F6,0x50BC95E38C7D9258,0x0000000000000066 }
  },
  { /* Point #15 */
    { 0xDEE6D4D3FA9E3B2B,0xC89DC32089719D7B,0x584E18A8D4BA39AF,0x3C2A717C159CF1C7,0x3F89584F726431CB,0xF26517E4CF2DF7CA,0x4AA28F226F9582E3,0xAC1BE97B410CAE0F,0x000000000000013D },
    { 0x1CB73C6FAB393139,0x28DF0EC5EC65CC58,0x42A1BA53FA4492AA,0x842A7C25D41ED280,0xB9DFB3F472F671E8,0x5CA5298B5A2E9B36,0x1614C168D73E2D19,0x4CB3B6EE66874F9B,0x0000000000000185 }
  }
 },
 { /* Table #16 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x94A182E2689DBE3C,0x2D8EE16602610256,0x4D0CB259E6294291,0x244DB1200A7FCF2D,0xB50D34B08F58F3AF,0x2AD4B9EC13275075,0xA19BECCFC96BFCFA,0x1A5509DA86F5BAF0,0x0000000000000185 },
    { 0xEFE1469C5AC043E6,0xC86B77217D273130,0x2324AF0C2606809A,0x33A3324E21800FCB,0x8A38F30FA6B0D999,0x12DB51D0D038B182,0x53CA86CCB3490FF5,0x2ECD7ECF7A935163,0x000000000000016F }
  },
  { /* Point #2 */
    { 0xF192B0164B374FF4,0x3AADED48125FD529,0x57484AC45DFA717D,0x815B6549A4B4E41E,0xE230EA493153D4AF,0xBD883B1277769A23,0xAE58965EAD605E32,0x4CC9CFCF77179455,0x00000000000000A5 },
    { 0x5CFE2EA43F30741F,0x79C512A52565E3D7,0x9A4075ADAEA005BD,0x6B2593277FCA076D,0x1EA80148166A3678,0x25075D36D75FDA30,0xD9F2BBA9AD53E052,0x04FC6ADC182AC606,0x0000000000000090 }
  },
  { /* Point #3 */
    { 0xBB3CB4DAAA283027,0xB3284A114637A686,0x2F675F378D4D1678,0x4D2B46FE6BCE4A50,0x65E0D06D583AD60D,0xA897D633525EA4B7,0xE2AA9FCC42BB371C,0x8F91D296DD500E47,0x00000000000001BE },
    { 0xC43C6CFFAF7965F1,0x116C957CA63638DF,0x80C1361BE5A3F8A7,0xA1F87ABECC9582D3,0xD47BC0102BEF1FF9,0xDB660935F3FE712A,0x8CC56DCFCC584A15,0x27984274A035F2EF,0x000000000000019C }
  },
  { /* Point #4 */
    { 0x803986670F0CCB51,0xB87E1D013654974A,0x7F58CF21B2B29ED9,0x06C0E9AAA3ADD337,0xF13B35D0E9D08FFB,0xDD8BF44C96761627,0xA4A18C14758A3EF4,0x96A576DDA0043ADB,0x000000000000013E },
    { 0x2BDE24F8632D95A3,0x79F15EF14C524829,0xAADD863E9BDABA19,0xDDE053F4A962B707,0xC598A2DE14258D98,0x9FA5A19D061C235C,0x0ED46510E8FFD32C,0x2AEA9DD1EF78CEAC,0x0000000000000185 }
  },
  { /* Point #5 */
    { 0x2BB9D8B5B329F7D3,0x7E561B23569EBA9B,0x65FDAE9309B7BCA0,0xF4206737EF327916,0x2963CD698F7B2113,0x3B22A38A9CC9532F,0x455C3790B31DEF2F,0x9A6CCCD5931E5346,0x00000000000000E6 },
    { 0xE9860742981C49A8,0xC6BBFFEFDAC58CFB,0xF28CA98C7DCBBFA6,0x6A53C5D43E512F79,0x072D38F9FEE0577D,0x75FC677E0B2260D2,0xE1CE6A188E97C4B8,0x48308DFF3D3B1E4A,0x0000000000000109 }
  },
  { /* Point #6 */
    { 0xD389B38CD19F496E,0x9868052FDC520FB4,0x698B397EBF6E877E,0x7896E7AC15D39A80,0x3EECC9B5057CE533,0x00F6CFC7001509B4,0x8C2C3D6EE01E25F6,0xF64A3E270DD1056A,0x00000000000000F4 },
    { 0x192245F8BA1BDE97,0xB68AA03741E87ACC,0x849CB6E449D24C74,0x93C36F752569DE67,0x93542A5630AD91A4,0xA802F2BFCD021165,0xF3EB185FCECD5CDC,0x42EF43D9AE520746,0x0000000000000185 }
  },
  { /* Point #7 */
    { 0xCC39400A70A75215,0xD237B4077EBE4792,0xB2CF5C3BD20C2507,0xE7B00E11DAA4C46D,0xA576029D38CEC7A9,0x699005E7B05E1375,0xB88D5837F1B051BC,0x054F8ABB44630F00,0x0000000000000060 },
    { 0xE53A8D17DA2BB0C3,0xCFDD266CAE7BDB56,0xD9551CEBDB11C9B9,0x1A11AC221FC5B3D0,0x63056E13E161A118,0xDFD99567F76B5E73,0x7F5F7283836F2217,0x8323F67FAC0C57E8,0x000000000000001A }
  },
  { /* Point #8 */
    { 0x2838CDBFEB5A169A,0x25C826C4E1505D76,0x2D5B0FF8C512FAF2,0xCF831E691E5CD6D6,0x4540775CAF5EDA1F,0x4F4514DA5AD5605E,0x8472B1AE2F87CFDF,0x07C8CBCC9E338CE6,0x000000000000014D },
    { 0x096AB718D9243216,0xE966635FE37CFF51,0xCED8FB110586EBBC,0x3216D6AF86ABE6F4,0x37392A301B77F4E2,0xECC903AFB8EF62B3,0x0453DC44FD74231E,0x3CB3927B57895508,0x000000000000013C }
  },
  { /* Point #9 */
    { 0xA1B0BBC3E372D394,0x4EECAECA8044F021,0x97636D0124C350E7,0xF1F047EF209D0E2D,0x0F922E78D12B0758,0x8808519A01A2A08A,0x6570AF356B5DCC8B,0xEE31EDF8B59CEE8E,0x000000000000003E },
    { 0xD467FF1C9BCDFE17,0xA6FEFFA02D58B7E4,0x3B8F9B17271E5025,0xBE2D94786C151628,0x934CF55F75FA8B04,0xD6217D62ABF8E3EF,0x6F1625CC9841059A,0x8D4B7142ED8BF5FC,0x0000000000000148 }
  },
  { /* Point #10 */
    { 0x6BAB39543F106ABA,0x3D9C29E352DC57C5,0xBE339E28D50FF250,0x247C8A49F08B8B6C,0x79DD3128317BBE5E,0x735C5B6DD533B321,0x1374C3A28FD164C9,0xCE029BE81CD71FB5,0x00000000000001E7 },
    { 0x0657B663C6AAC6A7,0x0DFD84E22F233CFB,0x210FBD7BB2F9D0B2,0xD7E7CA02A90DEC0D,0xC37D11213FA3B10C,0x160276EE1AFF3C3A,0xD825F5CECA6D0545,0xE03CDAC46558C1BB,0x0000000000000124 }
  },
  { /* Point #11 */
    { 0xD238E451A7C101BF,0x0BAD1BD28A0E4552,0x15EB91427E77916B,0x9C8EF51649EBCC4A,0xF6425C28CA085959,0x498CE242C87D4707,0x14B8121EDFBF2093,0x338D5AACDC3B4580,0x00000000000000E9 },
    { 0x886A911F6177B4EC,0x6D305AB15A7D1548,0x6EC3BE3475E8BAEA,0xCF1CB5A7891BDF87,0x9AA5F7EC6088B030,0xE261EEDF83288F6B,0x2DB08F6444678F76,0x8D912DA6C1CC7F63,0x00000000000000E2 }
  },
  { /* Point #12 */
    { 0x0644BC15B320DE71,0x2ED296112AEFAD3F,0x67754C4C88519D1D,0x47DE1837E5F01818,0x8EA1DD7E63033410,0xC1ABBECD8F6B2C5C,0xB06BD510C8AB4DA2,0x4E0CDECC5964E0AE,0x0000000000000006 },
    { 0x7C3B12481FFDB678,0x28FF66790E9911A3,0xAF7DEB99A718A3DA,0x391B96215E272577,0x0F2789B0B4001E20,0x60B4541686A4C603,0x0C3941313A259848,0x3218BF48AA7E7D38,0x0000000000000109 }
  },
  { /* Point #13 */
    { 0xB03563923E5A6E61,0xB5E0E27873B8D05D,0x53F7D377B3078789,0xD56358E1C698706F,0xA2674710505A1BE5,0xBC1559F4CB650C44,0x93361F0867D11D3E,0xD5D124BA63826B8E,0x00000000000000D9 },
    { 0x943EB3571403F021,0x80D125B3CF992A03,0xB1365FF2D8BAB8CB,0x5EB0490498A1FAE7,0x4F728E6F8004BEAA,0xA4B1DC8074121D80,0xB8B782B3C6B52616,0x844CF275C3AB4B91,0x00000000000001C4 }
  },
  { /* Point #14 */
    { 0x255D6D1BF8682934,0x6167BE166FBE8832,0x3F2FB997C331343C,0x80C30A82BBC0455F,0x6B06E6039604EE9C,0x61433976A8A2C05D,0x9B693E3CA6C73E15,0x5643BC3AC7B6D3DD,0x000000000000001A },
    { 0xF362DB1D072FC054,0x95F7E68981452D4C,0x14382BDC7E8044FB,0xF0CCC6594E884ACD,0x9F4598920DB303D4,0x4494E0177763F7B4,0x8D4DE910B3422E42,0x949B363A2B03D91D,0x0000000000000174 }
  },
  { /* Point #15 */
    { 0xD5F2127B4413C3C8,0x53D19D1790C5EE5B,0xF46A12C4BD0B0607,0x23FF83B852F21415,0x345D3CC5564A2084,0xDD29DE25B8128778,0xF22C6930511855AF,0xD4A6AF3342541B83,0x0000000000000067 },
    { 0x3FF378ABC334139F,0x0D042FA8C59741E7,0xCC57395DF6333E80,0xD458B57146A21BF4,0x7B5378F61B92954C,0x0B6A333EA29D48CA,0x83EBFC9324BD0EFB,0x84A30CEC1062509A,0x00000000000000A4 }
  }
 },
 { /* Table #17 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xD8720C8AE96A67E2,0xA646ECEDD54E0F6A,0x3936CE2DCBD31552,0x6D44C225B35268C2,0x56DC0D086168F13D,0x2B9BBCA1FB2C207F,0xB4F0DA3AA136C5A4,0xED2CF79BF8216F89,0x0000000000000141 },
    { 0x1EB0707D7EC6BCEA,0x341B0F22EBE7EED0,0x99C3C50C37333B3E,0xDCD5FAEBDE463E09,0xE688ED5EE481CDD0,0x6FC12BD10FEAD808,0x7B8A498329746A50,0x2BE1B92F829E8D3C,0x00000000000000A8 }
  },
  { /* Point #2 */
    { 0x27B472FA3D0E9678,0xCEF22B18F18EAB4A,0xC49E75CC5FDE2724,0xD9EC427A39F3C3D3,0x240963EA07A9F9B2,0x2B0301E0FC73761C,0xF734C2F480D8C0E3,0xB9F52A609948DA76,0x00000000000001C9 },
    { 0x6EF525E6FE70AF9B,0x4FAF1315C936D7DA,0xFED0CB7AA1C67010,0xB1C8CDFB650FC5BD,0x643E77418AC141CE,0x8ECFFB683144C8A8,0xF6FF17F5544DEBA8,0xEA30D6B2721A6D98,0x00000000000000D0 }
  },
  { /* Point #3 */
    { 0xF306AD278AA3C1AE,0x5C833C94FE1271E7,0x5E33DC6B11A9B053,0xB28AC1CA9CC1B1C8,0x25BB641792D6A8C9,0x2FC86297F9EC9859,0x752B6170A31FD92A,0x3E1F16BACBB524EE,0x0000000000000008 },
    { 0x85AE18CA70A320C1,0xCD6BFBA06E589BA3,0x576F222B7FB13310,0xDDC3F6D124C19D99,0x697073F906F1E0A1,0x18C54CEFBDC674E2,0xCC0425357264D610,0x66D7986C94275C0F,0x0000000000000105 }
  },
  { /* Point #4 */
    { 0x476395029A2936B0,0x48A88079918B33D5,0x453BC7931B067A87,0x5FE40ADC63E55FB7,0x615677F03D2B9756,0xDC376C92833E336A,0xF7743DA0B0B6C914,0x780BC5A93EFFE23B,0x0000000000000037 },
    { 0xE9C333804A1A9456,0xDA9C55A8EB2EB173,0x022757865ED17864,0x491F250816039D4F,0xB1AC3D7B0EC8959A,0x4D3855D3465A7151,0x7285C2D418E0D6B1,0xD1A5AF1833EAC3E9,0x000000000000011C }
  },
  { /* Point #5 */
    { 0xDF54380D170F4332,0x71073E65468B3892,0x299D8E423D2D8723,0x2EAC2ED8B142FE92,0xCF54C688320BF387,0x450CB1D42C6EFF70,0x8E7BAD2E84AF19C5,0x9F881DA52239A281,0x00000000000000BF },
    { 0x86063C1EFA1EC6D4,0x42B40DFD4CFC2168,0x0AD0C42A6DDEAE23,0xA267039FA753EE2F,0x39517320C10D2E84,0x97219410A4375C0F,0x495A7346A5DED43A,0xBDEAC1668529EB5A,0x00000000000001D3 }
  },
  { /* Point #6 */
    { 0xFF52672938D280D3,0xB2FAB9A3E54BDAA4,0x256A00F31C56AAE7,0x588831E2833CD551,0xC4F7E5A3C44FE251,0x46807784287E9914,0xFE8C28795CDDF33B,0x4A28E8C39F2CF304,0x000000000000010B },
    { 0x4307199DCB19D3BD,0x4BE628C3BE158926,0x01A7D640CEBD6924,0x8BAF3CCBDBF40E60,0x0A0F63321574F982,0x9F747922C6A746ED,0x13C36A190A9481B2,0x2E9249A24D7965C2,0x00000000000000A3 }
  },
  { /* Point #7 */
    { 0x309A2B2AA87A6B1E,0x872CB5DE5C7B14AC,0x014EE9182B0CD791,0x368CA8349BBE4382,0x618B9693D4E89AC5,0xC37A4F4752D7163F,0x78673C50B54FD0A0,0x98DDC7DA7042C7D0,0x0000000000000030 },
    { 0x70882A787C37AB34,0x4D92B068E779B5F2,0xD63406235EB13B45,0x3EA175591A7675E1,0xA77A590E51B35F48,0x5A6FFF84969C2DD2,0xDF5551BC7CDA8AE1,0xAB1A48E99C9558AF,0x0000000000000040 }
  },
  { /* Point #8 */
    { 0x80877BFE331DD8A7,0xB708DE53DD15F09D,0x19F93DA02AE5D424,0xE7E4CA9750064A50,0x95FF7EAFC76F7C7E,0x5A6E49F06E0344D7,0x1F016633A4144A34,0xFF32C2A16FE7D882,0x0000000000000031 },
    { 0xC8C7B1826DF27677,0x33049C001751AD84,0x7685641C109F091B,0x0E2BEF03FDE67F9F,0xFB7BA091DA20F027,0xCD7200850D2E4994,0xF565899FBC584078,0x465F703946520913,0x0000000000000058 }
  },
  { /* Point #9 */
    { 0x0CB012CE7C632E11,0xD5D3BB8E01CA76F4,0x5638B2A7CF47BF22,0xE0AD407729A047EA,0xBFB0DB685D0CCEDB,0x5A6BA6035DFA96F0,0x7EBC6F182511B237,0x46CD756EB3E29B07,0x00000000000001C7 },
    { 0xC71D93C6D7D6F75D,0xB17A95B5A3D4A3BD,0x161EA7E8F2F0AF2F,0x905AFFF1715D8D75,0xD372686B722B95AB,0x8255990897445158,0xE27AE171134A3BCE,0xD662DB4291C2CDAF,0x00000000000001BD }
  },
  { /* Point #10 */
    { 0x4B8A962A19989359,0x4BABAA4DFC994CAF,0xCEF1CA1FB3931752,0x4EDDB3C31A7A3D44,0x3EE6D50E587F47C1,0xB45E0D0BFE9C8C5F,0x173B9E5148BC86E5,0x80FBBA3153387CEE,0x000000000000005A },
    { 0x0131A1C4B031978A,0xE097C938E65C1101,0x048DF3CAEAF7F954,0x82ADE6239CEB2AAF,0xBD94193E794C10A5,0x0D31931D414CEC87,0x331B1424B1367621,0xEC1973B20F26F232,0x0000000000000128 }
  },
  { /* Point #11 */
    { 0xBDD62240186CA485,0x44359C0B969FC79F,0x0C61C4BADF9143CB,0xEA2415F20030322D,0x15DC87DFAF55E444,0x8DC2E442F5A6C58C,0xF3C449385D72A89F,0x61CCFE567CC23DD5,0x00000000000001EA },
    { 0x86597A8DDC2A9048,0x48083469C0EED8B2,0x678F0740D1B714A1,0xCE456B1B1157CFFE,0xE583C03DA208AD24,0x55BDD6D850875FA8,0x84345986C2964233,0x58E2225C822AEB73,0x0000000000000188 }
  },
  { /* Point #12 */
    { 0xB439F594F839375E,0x273E0E12D6FABFA0,0x4811F186986B62BD,0x3460A7DF29A07E23,0xF7FB6F4C20AED738,0xF26B2B9C97D88113,0xA87F0ECC047EBD57,0x0403DF2B1A81558B,0x0000000000000130 },
    { 0xE8071597F66CE34B,0xD14095A79440F830,0xE7924B9994488565,0x972CC87937553260,0xD33DD2DB3C2F0EAA,0x57E6830E9BF34EE1,0xE2F328371D13BA62,0x4F84BCB955174FFB,0x0000000000000010 }
  },
  { /* Point #13 */
    { 0xCFE610FEA5FC15E2,0xA550EBEE33832C64,0xCAA4268F52311ECD,0x6FE68652A3279F48,0x0E873417D800A101,0x2160D5316DBF9236,0xC97D8A86F78DF67A,0xD8906ED73FF6F74A,0x00000000000000B0 },
    { 0xF9188F3D1FC70059,0x74272450579F2FB1,0x0FD83E66EEC87818,0xEC0C26FF07B13A40,0x0A4CC51565FF4490,0xD3E6C66582E04897,0xDB80F81EA72F5903,0x1D056E10162CC76D,0x0000000000000095 }
  },
  { /* Point #14 */
    { 0x02D2A5E43E7660FD,0x850080E86D564284,0x87A26E47ABD351DE,0xC0360956988D078E,0xE46F3889557915D2,0x770E4A0ADE1D7A72,0x129F8DFFCCECE91E,0x909F19F30AAC1ADD,0x000000000000003B },
    { 0x90916401E8D62BA5,0x2071AECF4DB39591,0x06E93C200CCDCEEB,0xE750F23E5087DD83,0x92D463EF26E491A2,0xF12A4276790AAA5D,0x967798CB55DAA761,0x39593CD917C3AEF2,0x00000000000000C5 }
  },
  { /* Point #15 */
    { 0x6A43422011BA52B7,0xA22752F603E43CAD,0x90C6070CE4EE9954,0x2C00C5D0D0848D3E,0x2AF5ED1F50EFE072,0x051FFA1045314F92,0x197320D1ECDA3C0E,0x4254FAE7E4A99B7C,0x0000000000000096 },
    { 0xC5C0A4A871B0EECC,0xCB74EECFDC0482B6,0x8AF87D21F6493DA8,0x85A96DD061D4EA02,0xC5A3B3BC73A6A665,0x8D43450F0D1CA607,0x864F8C488583DCFA,0xA29E868E07CDCE9B,0x00000000000001B2 }
  }
 },
 { /* Table #18 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x519A595A5C6F42B0,0xE39552A9A675ACB4,0xC993A489609641A9,0x1427EB18CB9D6301,0xEB102DD9FE02D86E,0x86DFC2D5A4C15DDC,0x0DBFD177B76F6B2B,0xEC31EA91B285289A,0x00000000000000E2 },
    { 0x46ED4B2AB85445EB,0xD272162CC8124AF3,0x1B7E446D675589F1,0x605B28069E56E455,0x39F9B1ABBD0D72EF,0x52D79F51793F00E5,0x28D3E23B7978077C,0x9759E0E64866C9D8,0x000000000000010C }
  },
  { /* Point #2 */
    { 0xBB292BF5F98C20BE,0x3A3411A680E7F858,0x4EE85C60884A2064,0x8BF2F700D1FFB068,0x28A61B4FF5514A5D,0xEF4280BA021CA558,0xAA64507DBEAE03E4,0x8BF2AA0FD601D59B,0x0000000000000123 },
    { 0x61CA18A2EE308BF1,0x9E9DCCCD55FDDD4F,0x858DD91FAA4B0103,0x21A4A04654338E37,0x88237DA980D564CF,0xFA544159A0DC17B8,0xF6E71432E684E7C1,0x9B2EC5CB6BCB8393,0x00000000000001D5 }
  },
  { /* Point #3 */
    { 0x23C4D719A31B8BB9,0x048ABCAC740F7882,0xBD895A1C5EE72269,0x95595E429077DB96,0xD01E2D4B49088381,0x48570B7FF7E50193,0xA8830D23E6F4ED20,0xBC8AAE5B9A45DDB2,0x00000000000000DB },
    { 0x527E8FF8970F294E,0xD3F0CF5026C1D870,0x255E637C69AEFA63,0xF332ED105BF085B7,0x6A0BBBA69520D99A,0x46F6172C3BBF6757,0x5F0B4E9F77664D47,0x5B8C50A11E6BA9EF,0x000000000000019B }
  },
  { /* Point #4 */
    { 0xEE02879BA3EA1A16,0x8E2314E439F3A110,0x931DCAB50671F5A4,0xB3010E67FE8A9DF4,0x5DF54E420F52A951,0x0B5EB472530C0C9D,0xFC19D87C18A07787,0x60ED2C6FF0F2B9F8,0x00000000000001B4 },
    { 0x6BED0B7E2C3D7F45,0xD6903D7610FD3891,0xCB4A9876F30F92B1,0x328688DD25C03D48,0x8F51283CCDB11750,0x195F5A81B8D8E361,0x4CF3580AFEB346D2,0x044CFA9425C261E0,0x00000000000001DB }
  },
  { /* Point #5 */
    { 0x4143662DBE2D233D,0xDAA51EA937B9C343,0xE4543A36E39801A0,0x8F043E35C1319E2E,0x7A0F8DF8504B47B3,0x0C081EF2D4D60DAB,0x710081A899486CD4,0xD2E4EC67A36E4207,0x0000000000000116 },
    { 0x55C7A9FE07D56E26,0xE01C071F037F6067,0x6C4B2BAD496B19BA,0xE511CB4EBFF6490D,0x0E086C9385868504,0xAC978ACA2DB3B875,0xC24E564E28A8E768,0xDBA8099B3B1F3412,0x00000000000000E2 }
  },
  { /* Point #6 */
    { 0x06845F761C46E0A4,0x304F1A22BF614354,0xF1EF1477999719C7,0x077CB0A94A2082F1,0x88D79BC1C5CE4148,0xC0DA1DBEBEC656FF,0x5B78DAEA71DDAE3A,0x6216BA84EA9A43F2,0x00000000000001AB },
    { 0xDEAD308EBEA49092,0x857AA6BD5F4F2D7A,0xA80D0EEEDF4F49DC,0x81F3FBD4612B71F0,0x8FEB7E2E009CB72A,0x149DF0698880B33A,0x49E5030AC70E9EF9,0x7FDF363DE32D7D93,0x000000000000018C }
  },
  { /* Point #7 */
    { 0xDC8418B0430AEE87,0xBD5F89C0FE56A51A,0x10DB29C4C631BEA3,0xA03FBCBC0C973806,0xACE383AB0AB83B29,0x19F1D9BA5AEC5994,0xF36D16C245CB06A0,0xA80A5EF4E427EA44,0x0000000000000104 },
    { 0x8C77115E67C4BD41,0xBC0D9D752EDCE105,0xB4D58D35E1A157DE,0x0564C86BE85AB91F,0xD0BDF26D3CC536FF,0x4B36E529237657CE,0xD108D7F75C27949B,0xCA0DC963AD81E019,0x00000000000000D5 }
  },
  { /* Point #8 */
    { 0xA8AECE33C6467674,0x89FF0D8F1843299A,0x59ADBAF13CA3A78E,0x196374F4B9A4A75F,0x789F72316AC10A73,0x448193FE379C704E,0x65C6E5794FDF5217,0xE6565A0B57174E77,0x0000000000000001 },
    { 0x509A5BE95B7A3AAC,0x5EC7DFD35B281D20,0xFD549CC3FF94FFC7,0xF29FE9740CD3BD2D,0xD8A4F3AF708E35B7,0x45222E3BB52EDCD2,0x896B102ACD710014,0x452CD4F4E63EBF74,0x00000000000000E8 }
  },
  { /* Point #9 */
    { 0xB89C242A654F4E39,0x3A242406AC7DF59E,0x351DB3BF11CC09B6,0x337CE2E5B5CD27DA,0xB911A8C8941F351A,0x1829610F4F4C663A,0x8C1E50449ABD904D,0xB2A4AECBBE384923,0x000000000000007B },
    { 0x20F4B1D2485A76B0,0x946F7C9F03D1B899,0x7EE2AE32C4080BE3,0xD8926FF9AE4C9F69,0x29DCB8A9752FFBD4,0xA19B5F862D627AA0,0xF21A0CF6DBAD059A,0xF209613AEAF6E53B,0x000000000000008E }
  },
  { /* Point #10 */
    { 0x3C4ABF3FD97E4127,0x4D660AA326A7685C,0xC97E6B3EF7A49E47,0x7B9D1BADF34336A0,0xF7DBF5AD2D068101,0xB0467EC242FECE7D,0x73D37B2B1E537F73,0x057949157AD06AC5,0x00000000000001DF },
    { 0xE8ECDCF643F6A0FF,0x972197753CF6CFDD,0xC01F32AA931A36EC,0xED5DA14457DB8AC9,0x94CC6CABBC5FFC23,0xFBE877FA7D5D27B3,0xE1C5975E5E6428EB,0xA2193C9C5A0DAA17,0x00000000000001A4 }
  },
  { /* Point #11 */
    { 0xDB55C6C2986F7001,0x67B6C09795CB3D1B,0x8C985426D2166C0C,0x59026D57E1C9BF0D,0x59A7419071C85698,0xFD2DC29C95831354,0x78A61F5C43D60779,0x09FBD320B2969EE8,0x00000000000001C2 },
    { 0xBA4292559295996C,0x76252A2B15DE5FD1,0xD2CC5546092DCFA6,0xE91692386E887EBF,0x4F4495125FC232C0,0xD0C857CD21B85119,0x2F36082F35FD0670,0x1BE3D45BA37CB8F5,0x00000000000001BB }
  },
  { /* Point #12 */
    { 0xCB0DBD8C81E4D356,0x292AFAFD4E0178CD,0x3A7D9941430ADF54,0xFB7DBE480C8F7A12,0x3191467EB36CC72E,0x77375B0AE1C3BB00,0x4F6D8307A22D64D9,0xDD46B8BBAF0BAA09,0x0000000000000131 },
    { 0x07B578C9007DCC0F,0xAB944686094E6E2A,0xC6BC5ECC762C8082,0xF113FD5E9044D50E,0xF84F6C1A3048CDAF,0xB3D315CFAF0B90F9,0x8CC36B9430FC0E21,0x5AF00BF1A2975344,0x000000000000013A }
  },
  { /* Point #13 */
    { 0x64900AB5E105FFC2,0xB3E0A69FD00C2920,0xFE3A57E0ACDC7D5B,0x50017DE528A32D2C,0xDBE2BA7E5BD24047,0x8F337130884E4863,0x79022D566B48A2EE,0xAC5C8A0B0C2F309A,0x0000000000000186 },
    { 0xAAB8B2CF84BFC6C8,0x50877D98C9FE9744,0xDE69BB18384D5471,0xE88EE61E438C52A3,0xA76F2AFCCCE637EB,0x75B5620AD56FD7BB,0x56F3F8F0D04FBC41,0x394174BF023BB654,0x000000000000014B }
  },
  { /* Point #14 */
    { 0x3A67B300E334C8AB,0xC08D0FF9984AA5B5,0x8D72ED49CD8E1509,0xAE856DF59B2A8535,0xA34EF023C0CD980F,0x29C83E84C243D7D2,0x8ECDC4D8411FAD2A,0x26AB853B89EDDC0B,0x00000000000001A4 },
    { 0x3A060B7BBB5B50A7,0x62ADCBE78DDEACD4,0x953850E464C7DC2F,0x4EC4A15C4E7BF3A3,0x1834B3EE7D5B2569,0x729A63CC470A84C0,0x9C80233FFA5E25D1,0x7DA5B6C70EC91AEB,0x00000000000001E8 }
  },
  { /* Point #15 */
    { 0x2EDC22F9503DC30C,0x8E15166BA819DE2A,0xDE92A1C90881FF55,0x5063C292425BC484,0x7265E0A25894FFDD,0x29A93E2BD01AFEAC,0xB10AAE1E4F850B16,0xD136E09E5BF5F95F,0x00000000000000F3 },
    { 0xB339031CB292040A,0xE3A653C6C8872FBE,0xBBA8B2A4E3B091D0,0xDE53DAA4755F2616,0xCBC9A13169FF06F9,0xD7D107B972B153A9,0xBF3D962EED2593A5,0xF9C71C781EB4063A,0x0000000000000119 }
  }
 },
 { /* Table #19 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xC6999604BDF87653,0x5383B379B3F0B8C1,0x98C6AC3D0BF0435C,0x2B04984E433C527B,0x5308793C02073E7F,0x4897091DE1EF3FA7,0x4FEA6F39BB6B4777,0x5AD4C5CC472023E1,0x00000000000000E2 },
    { 0x0DB5541AE6CD3BA8,0x5504D5218C0BAC0E,0x32F61C5CCFAC5E4C,0xB8E644B58538BD21,0x8517C72E51FC9949,0x8D47A70CAD6F4E8D,0xB158E06317AB479E,0x8C565F7B74F01418,0x000000000000002F }
  },
  { /* Point #2 */
    { 0x4DC47D473AD158A6,0xAAF743F315320816,0x4ECB999DE6C5537C,0x4DAF6B4EE63C7840,0x4BF5F19B02BC574E,0xF65D174CAF39B238,0x0093F58BD91F67B5,0x8AD3A5B346D5E8C9,0x00000000000001C3 },
    { 0xBB99652C22171340,0x4DA02AAA3F1193A3,0x7A73A7371776161E,0x831DEF3AA5FF856B,0x5F6A4F56DA00DC5B,0x2A23F5009EC3A028,0xCE2FD53B7CB32472,0x894514811BB02B47,0x000000000000012D }
  },
  { /* Point #3 */
    { 0x06642448D62D841E,0xF9E2A13B4634C737,0x454750932B4C7A52,0x9515EC4C0A8A6321,0xA6309219BF231A45,0x53BCCB4BDA96C8C4,0x66B59FF49FD870F9,0xAB77154CCCC216E5,0x00000000000000A7 },
    { 0xDE7496443C6C8DF2,0x11521F6D7F075E4A,0xFFE294F57AC5E188,0x839C1880D39BFB5D,0xFA3974530492A75C,0x68816F470556FD68,0x2916C12AFEC8B33D,0x4E6C8F5E3B2E9498,0x00000000000001B5 }
  },
  { /* Point #4 */
    { 0xC75E1CF3DBFED7CC,0x2AF884EE092E1835,0x1E303D715472BF17,0xB1EA537BE7AD90BE,0x7FA6A69CC4D8B1CF,0x5B5318EE1B57F5B0,0x60E617587CCBAFCB,0x5832172A9C4ACEC8,0x0000000000000168 },
    { 0x36BAE29B9F2F8613,0x9181194AD464A557,0xF74C13FE52FF8F2C,0x88D40DFF0860D712,0x405A03BB6C86E898,0x61F01F2FDC243178,0xEA9771E091B667F3,0x1DB5CFF3B26BD16B,0x0000000000000141 }
  },
  { /* Point #5 */
    { 0xC13056A38800EFD3,0xE543970F9AACBB7F,0xFEF69B99B2A97BA6,0x6F8A3A52966DED77,0x2807AC99C1F0F304,0x3C1CC0AD3ADC784C,0x7BA76BD74C449F6F,0x6FF3EEE03469AF86,0x0000000000000014 },
    { 0x1777DCBF27B59D55,0xE96E451544C1542C,0xFA3CCF636A04BB53,0x004F2F0261140902,0x19841095FA5E01FC,0x6FD9982A9ED1CCD0,0x2EC230998D61E3A9,0x52B56A73E85FC571,0x00000000000001C1 }
  },
  { /* Point #6 */
    { 0x2366B92A98D9DF56,0xA626F80C44EFACE5,0xAE61B15E9040C6EA,0x1A44A0E218D1D16E,0xC6F45F75C7CF836D,0xE0057ED6C87C35FE,0x568B05B9B88D323D,0xFBFCAE7A9A12DC71,0x00000000000001FE },
    { 0xEC63AD133DCC4D25,0xC75D539BA54F349A,0xEDDD4102C5EA1E5D,0x9028EB89A867F628,0x2D3B3FD042846E4F,0x23190EAD8ED269B9,0xA55122EA67D610DB,0x83603CDD637C60AD,0x00000000000000FA }
  },
  { /* Point #7 */
    { 0x4DEED00DF4EC58A1,0x9FED60EE1795EDE4,0x01DF19D8341A7C8F,0x9BF0E8930E549D6F,0x5312C7054A0B9086,0x6FE5A8D6AD529BF8,0x31FF282E438F4B80,0x37A525BED54CB3DF,0x00000000000001BC },
    { 0xE21E94453C80219C,0xF016D1637C04756E,0xBB8C226E6E7F689E,0x4135716C25205289,0xA37C007A9762AFD7,0x3097FEEAAEE61EA5,0xD51692F2A0D84EBA,0x724D4A241CB8AF57,0x0000000000000000 }
  },
  { /* Point #8 */
    { 0x73F3A17D4787129C,0x6CA94151E8C8B154,0xAE7257F060011616,0x5D72F548D4459499,0x11739701C3AF5F62,0xDC2F39EE9915B9B1,0x1D6448E76A3A0976,0x1263EB6A9216A12D,0x0000000000000001 },
    { 0xBC6E933BD3C200A3,0xE4EE3DD9BB9A9FF5,0x3772C8F553B7BFF8,0xBB6A11B8482AD6BC,0x59BBE81BCF1DD575,0x2C9AD563891128DF,0x4B190E9390470495,0xB40F60C5D58762DE,0x00000000000001E5 }
  },
  { /* Point #9 */
    { 0xF443FE2367F94F4B,0x3A71A562090D955F,0x7457755803E288F0,0x00D246449C9AEA0C,0xFDDC8383CE9831E4,0x6D8116F717EAB947,0x0C3CFED16BB8DD5C,0x130C5400CEC46675,0x00000000000000C9 },
    { 0x9342D0E03DD0AF80,0xCA058D9EFF83797A,0x97E61F4FCB09DD72,0x86AFCEF613229500,0x272257E3C0E979D2,0xD7C9DA685F9B206A,0xADB7D61ADDCD5B86,0x528FE73FD9587749,0x0000000000000120 }
  },
  { /* Point #10 */
    { 0x8C814A121EDC8A1C,0x7B6A7BF4E7395565,0xC868143978CA6525,0x57477D25FAE6014D,0x8D407FCFB71944FD,0x4BAB62EEE154D68E,0xE0DB4FE2DB1A8E36,0x8B5A0A9E51E7105D,0x00000000000001F8 },
    { 0x3C6BA57AEB49CEA8,0xD7100FDE6FA16F5C,0xBC73DCF2580249C3,0x8FA02F243F4BC342,0xB32061C81A285D16,0xB348535C499F8F5E,0x95CD0CBE63DC0BC7,0xD1A09B04920C26C1,0x000000000000008F }
  },
  { /* Point #11 */
    { 0x373562D90F164D7D,0xE609D01D1A033488,0x192695F9F3A0D906,0xFFEBC44762957195,0x34467C4E6A8C7A68,0x3AC9D6B500A3469E,0x071F716A612667AD,0x1B1562E5E03620BD,0x0000000000000120 },
    { 0x23913E9BC4F699A5,0x563CCA92B8835ADC,0x6F97A60352856821,0xEB01543A5254D362,0xE4174BA93CED8D89,0xD9C758F57823B99A,0x499FF35A1ED5D09A,0xA7571BA1508BEB29,0x00000000000001BD }
  },
  { /* Point #12 */
    { 0xAB913473C18C21FC,0x9A8D50E85A3C3B57,0xA3F98027AB4214BA,0xFF00EDA9ED6199DE,0x7E5255D83FF38CD6,0x200F60A17976E4E5,0x2145DC0F6604BCBC,0x26506027E30D5F5D,0x0000000000000075 },
    { 0x74C1C25830BF2169,0x0636D007D332125A,0x5FAE19411AB021B9,0xA2E53C56B7779050,0x0F15F2A1FC02474B,0xF32C52DAA91A9C2B,0x016B2C4E09AF347F,0x3B98D8D9C8B5752D,0x0000000000000195 }
  },
  { /* Point #13 */
    { 0x21F00686182D44A5,0x473E1A5FD0A69506,0x1DB395D967C37E71,0x6A9AA5C122DBE9FF,0x279181B28BDE2304,0x699ACD64D298E891,0xD2C495037FDDECF8,0x882307737EE29731,0x000000000000014D },
    { 0xE9A9D713E4594CA6,0x44FD195A08DF0779,0x27F6D5C275B3E30D,0x9D4A850726244360,0x375676BA3DC7658C,0x7F2792CFF8B43041,0x6B78529E166AC32D,0x68B9ACBE4F4B6027,0x00000000000001C6 }
  },
  { /* Point #14 */
    { 0xBFD693CE14DCA7E0,0xFCA53D1FDF7201D6,0x10EF9C293F39346C,0x2F007C8150335445,0x1CD56F642FEF4D80,0x727ADB3F179A01CB,0x043C868D1216B55B,0x1725267A8B7E4431,0x00000000000001EB },
    { 0x08F27860C03B7717,0x46184E5AD56540E6,0x9D4413DB0CD006C8,0xEC1262B6C613918D,0x6DD0EAA7719B6E5E,0x04A254658CEA469D,0x66575D7D57FE33B5,0xF2DF873DC1EBA9CC,0x0000000000000104 }
  },
  { /* Point #15 */
    { 0x2F122F94E9ABC410,0xC24A6C3ED6FF2B00,0x5B2066519311A567,0x7E78BECEA37782F7,0xCFD7CC54E973BE5E,0x8C3A88940B8552C9,0x10C9B54AFF85222C,0x9CDA9C5345B33ED3,0x0000000000000116 },
    { 0xF0E67BAFE7434083,0x935294A0380F2A0D,0x7FD8E40BBC68E72A,0xEC4D6238BB9C1479,0x47FBC77906D4D2D9,0xF8E411BB75FD7A91,0xBE868E647D9D537C,0xAFA164F37AF52E24,0x000000000000017E }
  }
 },
 { /* Table #20 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x620AFF9A81128A65,0xA463FFE7D6A9D2C1,0x2206277ADD4810EF,0x413EDD73DD0687CA,0xF4B12EC9249CEF0A,0x14DD6665C4B165CF,0x0CF86A23C5C070C3,0x42354FE984755F2C,0x0000000000000131 },
    { 0x6F4741DF2E9C881E,0x2656911D43F26343,0xEBAE8AE41C82E8E5,0xCEB1CA37F3900776,0x07F2F8FE16721332,0x59265673AAD4911B,0xE8799EABFC3BDA3F,0x55805723FD073355,0x0000000000000088 }
  },
  { /* Point #2 */
    { 0x2B14935A7CE70EDF,0x1D88D30EE3C6F5A6,0xAA6220DE207E5973,0x692B3FF064B5E637,0x04C9DDC8FF0EB748,0x9E5EC39E44978142,0x9CC06266FA674339,0xE0D13DCDDD3E430D,0x00000000000001ED },
    { 0x74604722F38BD4CE,0x473E4D3549DA70F3,0x1228875507D72EFC,0xDF89A5050A7521DE,0x674176564C1A6866,0xE2C330233F7A0EAD,0x5E100468A7474DC1,0xA47CA1A5DCC02D45,0x000000000000001B }
  },
  { /* Point #3 */
    { 0x79B40005D7C3E500,0x99957461A7CBE47D,0x1DBA911D53A81EEB,0x50049C2A54CAC621,0xC3052CE65C8458C0,0xD4E4CC285CD9822E,0xA64BD2BA9C89113B,0x616F47F324A9A360,0x0000000000000000 },
    { 0xB309B38536BB95E6,0xF7808DA5EEB3AF75,0xC9EB3A68FFEF855A,0x0D7C5382DA981F49,0x2176630E5A29FE14,0x7C59C56F4B6DD847,0x363FC08115C998CD,0x28B9018E1C0E00D7,0x000000000000009C }
  },
  { /* Point #4 */
    { 0xC9D22D532C51AB39,0x0BB42C882F02748E,0x576C89C847E18934,0xF34CDC49B9513257,0xAF97DF129ED107A2,0x860263DAEEAD8F82,0x6147D39BFE11C289,0x3B94B3EBF41158F1,0x0000000000000113 },
    { 0xC4C84D7CF747D887,0x9A54F1A2F71F1726,0xB4A79290DAF5817F,0x33DD5DF87893855D,0x567A1293F6953979,0xF0C76BB60EAC5025,0x863FC87ABB498D81,0xF5D4E58EE9B3C11D,0x000000000000016A }
  },
  { /* Point #5 */
    { 0xF02EBE9596F52213,0x2ABA2DFC62F9F1E9,0x7BBDDE57934EF9F0,0xD5C7882EA417AF58,0x55CDFE89DCDF7815,0xF79051B18470A435,0x364DA0AA7E8593E8,0x02C3D160975A5F81,0x0000000000000034 },
    { 0x59493183CCD37734,0x085A8CD2E645E991,0x2D54D2668C4B4A86,0x96CF84CF7B4079BE,0x4ABADE40BA683F56,0xFB29C00BB5457B07,0x6ED5FD3592AE7F9B,0xB1F1A25FB5A9D039,0x00000000000000CA }
  },
  { /* Point #6 */
    { 0x6503932F0C7723E0,0xD185AF25A8934788,0x5BC1660C792232F4,0xCFB04AABC2CCD476,0x59E84FEE16844FE7,0x736C2CD809C31AD5,0xDF44215499058585,0xF3B79464C3F2B46E,0x00000000000001D3 },
    { 0x282464C7089E2E4F,0xBE9D0BFA17D8EEE1,0x7934AED1FCF3E876,0x76465104D4E606B9,0xF114EFB4FA4412CB,0x8F9F32D2F1FC8480,0x2879C7855C340A29,0x3D28E8A7D570BCEF,0x0000000000000178 }
  },
  { /* Point #7 */
    { 0x8ACD524BD326FFB6,0x4A1091A39E731029,0xB056D998600D299A,0xFB695C26B78EBF7F,0x2B83E30C73CC7F48,0xF2364E614BCB6645,0x6A707650837638C3,0x6D1652BF21528A26,0x0000000000000034 },
    { 0x353DC81F6D2B8FC3,0xFD3003918627A2E4,0x5F7C25651179264C,0x69856301AF46D535,0xDFCD6CBD16F35CBC,0x5D2268FB4FE07645,0x2CA719DD29CAC6AA,0x9F8FCB728CBE9556,0x000000000000017C }
  },
  { /* Point #8 */
    { 0x20084293EEA8D666,0x01AFA6AE12780DED,0xDBCE851A5B79D11C,0x280A43A009B895B3,0x95C92E1A77C59C03,0xD99606376B9EC1B8,0x08C0BB007BEACE14,0xD0BA7943EB76C9BE,0x00000000000001B6 },
    { 0xA14D2A3F15A51540,0xFD25FFCB7211BA73,0x020EFE82CBEEDFAC,0xDC5B6591AA5301E5,0x25D3413FE1708393,0x9A3FFF34B0A1E5CF,0x1892F1B7D310F9AE,0x3EC31F629DF3548D,0x000000000000017C }
  },
  { /* Point #9 */
    { 0x8A5910C8B4A6D22F,0xEE6879FD01DB212C,0x04FF66A7A0E6A5AE,0x6737374D87C876AF,0xB47BC05506CB6101,0x3A866F58BD24735E,0xFCE48FD49B0FAC30,0xA16C6F238BD9C8A3,0x000000000000013F },
    { 0x850462F4FCEBF61B,0x8882CCB92974B82A,0xC738BB8A43A1FFBE,0x3C72FEE9BC5C6E1E,0xC7D2B3926ADD3DB8,0x40310C193C68C927,0x1E648CD4F15AE272,0x6833F30AF9682658,0x00000000000001ED }
  },
  { /* Point #10 */
    { 0xBD843386B1725F24,0xE9DE3410B8632998,0x4FC156E3C2AFE31B,0x903691BA14541B6A,0x6E2F6E1C1DFCA35C,0x53044AB0516AE64F,0x3C47FE7A581FE385,0xC7B906E4D282FC13,0x000000000000001F },
    { 0x78DED023B640B3F3,0x90F2502C44536CBF,0x76ABB98E001B4411,0xC4EEB27E6F656140,0x7C74CC557EAF7007,0x66A2E87B24AEC4DA,0xC99B41D886AD3B4A,0xD48DF1C8A4595173,0x00000000000000A5 }
  },
  { /* Point #11 */
    { 0x85F7EE8DB4C31532,0x7901AE504F57340C,0xFFC7374980549596,0xF63F2BBA3470B849,0xAF19609FC9122303,0x07132084A29C6CFD,0xC48B9250455BE025,0x7F90302FC32B5F9A,0x000000000000006F },
    { 0xE29725D5BD5630D0,0x6994050329A9B14C,0x5416C35E34B4D9D8,0xD96CF843E6C07431,0xBE80A73CCB8DDFAA,0x36ED3535F3FE2EC9,0x9877AC66757728DC,0x9BD30B6EC97EAFAE,0x000000000000008C }
  },
  { /* Point #12 */
    { 0x8648CF6B70F6A4D6,0x9D0B1CFDFB9B3690,0xA53B98F81912453A,0xC73959AF67402A61,0x51120005D64225C0,0xC57EAB339665BB45,0x647673D31711F4BD,0x702F8D3638956F46,0x00000000000000E5 },
    { 0x95101259E05149CB,0x587964C4413587F1,0xAB9165237FEB95F5,0x8957D45E5501BE59,0x03091BA5899F7244,0xB6F6C068B6394823,0xB418566127B80786,0x29254799BA1E6902,0x0000000000000102 }
  },
  { /* Point #13 */
    { 0x25D663928816F67E,0xB8AC3F18155F51F1,0xEE0A41D797186B84,0xB82D67CC7D29A424,0xBC854839051AA4DA,0xF57CA395FFF27537,0xF9A573890A372456,0x2811368244FC0153,0x0000000000000018 },
    { 0x2B7ED9D7B5034049,0x8862EDBDD0BA814D,0x0DC79FF3FE0CE2ED,0xC36542FD00C1E102,0xA3DB194FC466C099,0xEF6A357F4C5A7303,0x73486E8525953C8F,0x2BD15CC1CFFB7522,0x0000000000000191 }
  },
  { /* Point #14 */
    { 0x42A21569C8F0A14C,0x421B1AEA51BDEC84,0xC1F40A25FAEC4BD9,0xC9293EF107D8768A,0xE04E3E552C3CC6B8,0xE9A8B69D59ABCE9B,0x677654C5E4B9D735,0x4447EAFDE2CFCB35,0x0000000000000176 },
    { 0xA36B5AD0C1A8E925,0xB3FCB38D2005C55C,0x6099B1C2717A1199,0x3FD6B73D8C5F2A00,0x4F321C1251ABC865,0x1CCF24DB2CAD7914,0x390C596F3139341E,0x43A8663777861C7E,0x0000000000000137 }
  },
  { /* Point #15 */
    { 0x9F3783EC4583594B,0x0E4D8677D5E8CAF9,0x2072232019AF1B4D,0x64407857C38A2455,0x085B97508CCE0710,0x46A412260375237E,0x5DEA15F80DDB3D50,0x821A7009E7A9ABC3,0x0000000000000099 },
    { 0x4CC63AAB40071A8F,0xAA95B0DDE92C8D30,0x01FDFEA6C88AC5D1,0x881162EE706B4144,0x33558F6D8141C4B8,0x58B46C5A475C5E63,0x59652DBF7B02E29E,0xE1F3C54EA0B99199,0x0000000000000082 }
  }
 },
 { /* Table #21 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x541BDD795338E99E,0x2753B15C2656702D,0x360263F1A7F6AF6E,0x42C9778702ADC827,0xB4B4A66527ABFF88,0x1F9DFE514A9A1CE9,0xF1FA56AC48CEB12E,0xF0E55A366D0B967D,0x0000000000000116 },
    { 0x7ED35BC349642F41,0x69C8BC4622EE3354,0x528466231911836F,0xDB193BAFBF4B87E2,0x427FF5F44209F1E3,0x4152FD13DAE27044,0x3B73F059A1F0AE7D,0x621ACE506F1503E1,0x0000000000000196 }
  },
  { /* Point #2 */
    { 0xCEB3D6D8ECC914FA,0xAADDD75D326DF942,0x8475EE47391B67B2,0xAD4CC87BE0591E3F,0x1AA4C9FD9129C3B2,0x52172155525F0054,0xA32FFF27AEADE029,0x550AC763217C0EA7,0x00000000000001DF },
    { 0x3D4BBC04DF12E80D,0x82D0B17E8D5AD5BA,0x7B059D1E1E38BA38,0xB22B3BEB0F9C9AD6,0x75948E7725833548,0x15E78DB4B7D8216D,0x3C573681C1697CC0,0x02DFD8B537F9ED90,0x0000000000000172 }
  },
  { /* Point #3 */
    { 0x72C5CF1E83625A05,0xB04221EFD0B73C77,0x52DE6BDDDCD8527B,0x73E03488D491416E,0xCFEFB1B130E7B551,0x872C5B20813A17FA,0x75F43FB9685A3923,0xF057CAE66960BCD8,0x0000000000000119 },
    { 0x84E8D67954BECB7E,0x47D5E5DA3AFDB96C,0xF0B5D59B04476ED9,0xB2D7DAEE4C2984A8,0x07FC2E0E986271E7,0xA9895F88B3300786,0x8F8FCD5A53A88830,0xE9446200452D1A5E,0x0000000000000181 }
  },
  { /* Point #4 */
    { 0xEB05B269A9E110FA,0x3DC96E495694769F,0x22D5DCB190129A2A,0x15B02839DDCAB3BE,0x2784EFED9819A2D9,0xC19A373A83BA587A,0x0ECFE7E631AC78EB,0x6B7D9A50B6580D76,0x000000000000009F },
    { 0x20CF011E22E1F23E,0x2BCD70C671DEC689,0xA4956ECDB968B2E9,0xEE6224FD8C68507E,0x2AEB7D0C6E7C15FA,0xF857D1A55E1C74A9,0x4F5EB8C6298D033B,0xFCDA7BDADA7EF5FF,0x00000000000000FC }
  },
  { /* Point #5 */
    { 0xF21724305CE20879,0xD48233B602995C9B,0x5DA336E0D39D6149,0xC516D0131A37DF28,0xA7098D962B3FE1C0,0x65CEE9A96A3099B8,0xD1DF9D2E320323A0,0xB1C49334CFAD65D8,0x0000000000000024 },
    { 0x3BBC258E902DD9F8,0x13861A7C0E9CE909,0x0F0497F50F7C4AB6,0xEF96A255DDC4A4CA,0x4655FD6414A185DD,0xA983915491345882,0x96C039266695B74A,0xD88DB243481DA372,0x00000000000000D0 }
  },
  { /* Point #6 */
    { 0xABE2205B68E52960,0x773AFDDFA062A50E,0x8C58EA01F1CF4A46,0x3E88E23DC76BB8D3,0xBB3B294BC501E0AA,0x42CFD6220859B18F,0x8C6DC95F16286E18,0xD4BA253E0ECF00FE,0x0000000000000071 },
    { 0xC3970825EB3340EE,0x4F981608B3AD699E,0xFFB5EA24C80BC4DE,0xB774F894604DBB78,0xA164C4CB1C947619,0x92BD21E5CF2B764B,0x4B38A590ECCA13DD,0x1A47520A05CB48A4,0x0000000000000166 }
  },
  { /* Point #7 */
    { 0x85E007A105E31F06,0x8B43C7DEFDCAFFD8,0x53D13F277E4AB187,0xF7D22A394D4E71E1,0xF1DAECF88D0A8B1D,0xE51E2F3A90C409CD,0xB84B6E0B46D43496,0xB70B148EF5E87710,0x000000000000017D },
    { 0xFDCD92B7E45E1097,0x6C5FA06295DA5EF1,0xD2FA00BB7BAC30EE,0xAADA82E4F49D2088,0xF8C4FC0F56827BA3,0x04EF216B207C79AC,0x3A3A685138449D34,0xF0AD4B5191900CE7,0x00000000000001AA }
  },
  { /* Point #8 */
    { 0xB4C52F11F3D7286A,0xEC47CB5CBBF67A41,0x89D3382EAAFB10A4,0x4AFD876806222B90,0xFA16B295FEB5416D,0x0946F9D45D095B7C,0x18526B28FF975E3D,0x259CEC2FB2F1C609,0x0000000000000104 },
    { 0x545642A062E36127,0xC3E4C6F71C38E6F5,0x1D0E02C41BF9D6C4,0x8A7A6FB6483BA43D,0x7104AEE9CF390B9C,0x4ACDCCDF2578E2FB,0xC17AF6DF73B3FEB4,0x2FB789D77977FA95,0x00000000000001D6 }
  },
  { /* Point #9 */
    { 0xA14396D3E9CD61E9,0xE5B79EEC037DC92F,0x88217B170156582F,0xEDC457471F70551F,0x60BE827F32D048D9,0x2FE4C45EDB6B91B0,0x8BC71163BA4DC597,0xE3FC3791936E1F8A,0x000000000000002F },
    { 0x8DFC5EC30139F399,0xC93F22717334F267,0x9B8D510DA10066DC,0x8A9D400AB7C157A9,0x5E83D95D3AD20222,0x2E244DA8483DB80D,0xD434F50E97E427CC,0x0C98D8FE73195F8D,0x0000000000000014 }
  },
  { /* Point #10 */
    { 0xBF53D7CAFCC691DA,0x6B8FB94F57F9D8B0,0x8124062527343963,0x98CF3891D6D682ED,0xF0AE9654119FED89,0x61F5810A32803C8E,0xDA1C6F26CE561B4A,0xA23E3C857B478BC7,0x0000000000000048 },
    { 0x455E708F3530D96F,0x38D3928E003D010B,0x289F06C4764BFCB5,0xCCCF4FD96ECAAE0B,0x76496E196B09AA3E,0x13CDB1B5F2F24787,0x1040EA015837CAFE,0x869751F81DE1B6DA,0x0000000000000027 }
  },
  { /* Point #11 */
    { 0x573811F6AD9570B9,0xBAF2EC126CA614D7,0x6F4A9A0BB735CB79,0x850E4B736F9AFFB6,0xE399DFB43B760AC1,0xA7759B8E5CEE0611,0x58D84AE60722DE06,0x5AB2ED5483DBB9FE,0x0000000000000148 },
    { 0x98C24006DF14F9E9,0xBBD0130F0AD7BD90,0xEE55B08DC3C91B77,0x16A18D954F6934D7,0x5F191A312DEED126,0x776BCD3284897D4B,0x83B4D25B7B0CD708,0x6E6AA60CD9F50BEA,0x0000000000000181 }
  },
  { /* Point #12 */
    { 0x34383BB055BEF397,0xC14C123A43BE84DF,0xA0FAE432057EB68F,0x5C6C07B24903C2D8,0x3E78DE9D32BCFEE6,0x3D2D16AF93BCBA15,0xAFB2DB59C206822E,0xBBEA1116A332E64F,0x00000000000000FD },
    { 0x20075ED100C6EA12,0x2B1D0A044E4F3D33,0xF3BF3BA82C5370C4,0xE1675545A4B86668,0x609432C3BCC6DC6A,0xC09A32E36777D69D,0x9248E09861F37219,0x32650569F539662A,0x00000000000000EE }
  },
  { /* Point #13 */
    { 0xE82B6739D225D7C4,0xC69D44EC0E8B47DA,0xD842C960D69237A8,0x6ED0097AD24A796E,0xEF96B040030E4149,0x55C049AC212E51D1,0xCCE35F170C44BB8B,0xBFD67F2971C94884,0x0000000000000196 },
    { 0xF02B65DF4755C1C8,0x3330FF77A8144225,0xB4D9365AA39FB2B9,0xD5D31CF295C66174,0x7597FD7DECC0CA46,0xE7565E2CE11870A1,0xC709BC5DA36C5100,0x4D319121639F0A7C,0x0000000000000144 }
  },
  { /* Point #14 */
    { 0xAEB813E3C79E8798,0x01CEAFBA48E50C58,0x974BDB02569D8013,0x83C90F107C7C5033,0x2D6E1617702DCE8C,0x55EEC88C3E07EAD9,0x9F9BB723106B9A4D,0xBDBE0818E2B351C3,0x0000000000000084 },
    { 0xAA512A7EE5058362,0xB288F28904C001DA,0x0CEED00CA713504A,0xFF656D2DE24F8EE1,0x637AE9543EB57CA5,0x4A21412E7342F010,0x205CF0C2A9CE4DE1,0x4780B6A3D59AEE6D,0x000000000000005C }
  },
  { /* Point #15 */
    { 0x83994E557FCC0C7E,0x887856631C37F01E,0x88A9A5679F196624,0xCD828DF25B3FC857,0x470F8623581344F9,0x85CF12A6768E83A8,0x5D11327B9718A861,0x9A1045D76E713452,0x00000000000001C5 },
    { 0xD4C452E4711F46B1,0xDC41B91E12FD1E23,0x845897E431AA874F,0xCF51CD7E8CD6171B,0x1825BD254F183E74,0x361A0E53B5DA3216,0x16349308601E0405,0xE3A40682F094F144,0x0000000000000187 }
  }
 },
 { /* Table #22 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xF762EAF77B602085,0x3B6E62332D470147,0xE1028D76D3CCA3E7,0xF3616DD8CCF39BE7,0xA35C4CC108E8F10C,0xC413DB107CB4B321,0xEAB81774C3249F4B,0x3E7BDEA7BE83BC78,0x0000000000000134 },
    { 0x86999F159D38D508,0x0C9A990AFB204D42,0x27C4421DCB616F5B,0x2CB6590D46AE31EC,0x1A33F6AB309ACF22,0x13D99E2A80320210,0xA13731B3341D1667,0x7E0BAEBA4BFCC116,0x00000000000001F0 }
  },
  { /* Point #2 */
    { 0xB6675F53DA1EF419,0xDEA5203BAD0B5824,0xF882DC2FCFFF1EA2,0x8EF992E408EB5B24,0xD80E2ECFC3D2321F,0x4CA7BECCA5F96675,0xE2CE41B01E1A9196,0x9B3D81319890D917,0x0000000000000094 },
    { 0x85C66EFE87C9C810,0x66FC21BDF644E538,0x2B90CDB5E4835D87,0x9A60F2140F91258F,0xB60EB76484BEBF7E,0xEBE2C36F96B0614B,0x95ACC92792A11210,0x31101643F35CCB23,0x0000000000000101 }
  },
  { /* Point #3 */
    { 0x8F345BC8D78FD6F6,0x35446BE7BC603416,0x22A05FC392954E8F,0xCD51695BDE517CA3,0xD452C3C1C30B42E4,0x71F0BE42385847BB,0x3E5604DAFA66294B,0xA32470C791EFA7AB,0x00000000000000F7 },
    { 0xBE46E43F247C00DC,0xA464EE494FA716E2,0xF16522FA81328C41,0x495048B6187556CC,0x71224071C1682E5F,0x5E33DEDFB9F18963,0xFCE493C999A767D5,0xC7F53C566FFA81F2,0x00000000000000CA }
  },
  { /* Point #4 */
    { 0xBF73B24CDED2EB86,0x102900B33EA89845,0x1D88C5073857CDB6,0xA939A76B9BE255D7,0x28D517522FF653B3,0x6D8170467642DF2C,0x148B45E157E353B2,0xD565F776B34F0F19,0x00000000000001E5 },
    { 0xCA5185A2C4B5DE1E,0x527ACEBFEADF8E0A,0x652B994B86479736,0xE252209AD2F97A05,0xC9B07FC9D6960578,0x479BA949D264F983,0xC80D32B5E8D9B938,0x59280D580A6A7F28,0x0000000000000177 }
  },
  { /* Point #5 */
    { 0x6FAA299AB7CF116D,0x29A0B9E704FA5EAB,0x7301A2890147F1EB,0x5A3C9E3ED6B2D599,0x63CFBA602D003F89,0x720B2F886A13199E,0x57C483C78D785CC3,0x90E8785A8DAB1162,0x0000000000000147 },
    { 0x2C15DE82026BF788,0xF542838F45C46443,0xF8DEAD3C7FA94A27,0x9587D5BFE287406A,0xB3EC2E828DEC97FE,0x08BC1827F34AA0D8,0x8E43DDF0BDAF6B7D,0x38B995206CFA1BD6,0x000000000000002E }
  },
  { /* Point #6 */
    { 0xA822EC345AA41145,0xD775FC0B6DFEBD76,0x9D837CED36B1A137,0x672679C83B0753D9,0xBFC45C63C3434729,0xCDB8702861C2138B,0xAD0A9384B86DBFF8,0x7F78A3528B6D5275,0x00000000000001A3 },
    { 0x427697D690EBEAB0,0x162FC46E8E6FEC1E,0x99C7E05FB667222A,0x1E92432242FFFAA3,0x9D79975B89F15152,0x4384CBB13DDE48F3,0x34FB12A76E28AF03,0x756865FD853C9AF2,0x000000000000004D }
  },
  { /* Point #7 */
    { 0x9965FF978FF76030,0x3803BE9209623254,0xF9006BEDE736FEAE,0xEBE94E4B81EE80E2,0x866AEB63F084F95E,0x0B44F9DFAF245249,0x9AD6AD2987F238CE,0xF4E2E01AFBBE2900,0x00000000000001A8 },
    { 0xC22A67A3656E4935,0xF9AA8ED52D8C32A4,0x98BE32D0F3F515B6,0xB8714B6AAE72CC29,0x1B6874230BBD1D01,0x5567491361121BC7,0x156020CD9FC2DCD5,0xA230E1D88FD34058,0x0000000000000159 }
  },
  { /* Point #8 */
    { 0x2DB7055DB286BAC2,0x0FCE34C5FE2D537A,0x8ADDCEA5B95E9476,0xF1BACBD41A7C7FF2,0x28B7F0C9203FDE3A,0xDFA6CF793E844A62,0x0107E9039627DC6C,0x053F2778413FCC52,0x000000000000011D },
    { 0xF67E718BD10F90A4,0x7DBCF1E00BC29398,0xFD5E65D19130E9C3,0x6149B3969C518E5B,0xFB574BB4918E2279,0x6C67563FC513415E,0x60B90D7ABA1B801A,0x2239B9DFAF900381,0x00000000000000C8 }
  },
  { /* Point #9 */
    { 0xD39866913CD2D894,0xB3C1245EF4ACD257,0xE94F4FC8F2A6EB4D,0xE5314682A24AAC36,0x1A8B49539D6D19B3,0x92EE6C6D62B2E879,0xCBE03DB39D84DA63,0x5A937F671EEF03C6,0x000000000000008D },
    { 0x01476022A8AFCC43,0x39AFCC5B5BA321C7,0x2834640235555C22,0x7451D9D590447AFA,0xAD2A529BFA67FE12,0x115B2FC402959C1E,0x327C1F37CA31DA20,0x7BE14866B662ADF1,0x0000000000000024 }
  },
  { /* Point #10 */
    { 0x494F7F61E0CA4BF7,0x88D4D527901269E0,0x9FC78D3251C4D47C,0x8C45F6E49583201C,0xB5C4A270A9595F65,0x530A1CD1ADF84FA9,0x580C2F6DC1A68C65,0xB37067164EABBB7D,0x000000000000018A },
    { 0x1A2C207F4EB1B235,0x8CE31B82D7C4F9BF,0x66FEB4810EA3BA9A,0xC03B631635BFF148,0xC94FE1B4BD896B18,0xD7B1F41919E3B6BD,0xF2F6D165263D33BD,0x44ECD257EB83B0E7,0x00000000000000FB }
  },
  { /* Point #11 */
    { 0x990B6C5EF74A2534,0x3F11B39F80259B31,0xF30D217772031AA7,0xA312282566CD4A2F,0x67127FCEA2A0835E,0x285AC417CBAB8489,0x138CAF3BC8048752,0x3F8DDC6B168C129D,0x0000000000000005 },
    { 0xB3D9AC2837D70DDA,0xA8BD293AD9F20D9A,0x39A064AECBFC1540,0xCB1C84F5FF06B530,0x6A5E3BD77415FBD8,0x838452CBF235D2EE,0xE741A7B0FA569AEB,0xF5941AFDE11C94A6,0x00000000000000B7 }
  },
  { /* Point #12 */
    { 0xD6346AE90C2CA70B,0x6814DD5F3157C1C3,0x597817E107D86CA7,0x4CB60C16B5243AE9,0x11D6BCAEC9C61451,0xB4CE3CC44EFABCAB,0x77E9247395C8C591,0x68735793A71952A7,0x0000000000000012 },
    { 0xC47F97B31426994D,0x8F46A5B7C646D063,0x174F27DF05575551,0x0FC2C3976AB08953,0x23DC955E62D34E34,0x301BACB9F7C52093,0x0F9AFAAD442A4819,0x805018D6E1999A38,0x00000000000000EA }
  },
  { /* Point #13 */
    { 0xDCA9AD5D19C2C216,0xEE8659E4A30D703B,0xF816AE02793D76B3,0xD4271B4A90047E41,0x7BCEE1B894965AB2,0x44861F552EE477F9,0x6D14B1F799A6EFBC,0x2F70AA142EBEE7C7,0x0000000000000095 },
    { 0xB610B9EEF7A0CAB7,0x3FE828F21A61D626,0xDEB3355735FD2A05,0xBF798CDBFCB4EB86,0x568985E2567A78DF,0x0B59FE5E95AB33C4,0x84562B5ACCA04237,0x621951DB783A7813,0x00000000000001D2 }
  },
  { /* Point #14 */
    { 0xC51B8A260C318F49,0x993F6FA07AE8EE6A,0x332A7472587A83C4,0x3FABBEA47D62685A,0xB3092BB7E9715589,0xAEA8BAA7CDD281F1,0x33212BC8EF852E12,0x7BB30320894BE27D,0x00000000000001D8 },
    { 0x0D45F1F1792FF9AC,0x79C811BD0AEC4F84,0xD094119834B34385,0xE164703CACC7C44A,0x74BE4A0DD52DE443,0xED11222833F36B22,0xA4E8AC6F07A34C83,0x9E37238117D41B22,0x00000000000001BA }
  },
  { /* Point #15 */
    { 0x7B7CC207ED4564E4,0xC2D36366D39B26E7,0x69DF15E968C54252,0x85BAA82E5FB39A7D,0xB447933D3CD85DD4,0x7DF00AF7A5DC4F0B,0xDE98E4B9BDA97B12,0xD2EDC5E570F52989,0x000000000000005E },
    { 0xF9A3FDA55AFE72D8,0x6312B53D8A9DB145,0xE275B397BEAA04DB,0xF070C6A1B2C9399A,0x04D5846AF3F47A0C,0x15D8894E676AD519,0xE393377BC4CF2481,0x54A9A68011FC7C2B,0x0000000000000077 }
  }
 },
 { /* Table #23 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x2D2F9E08A2ABB00E,0x4C8C679D17648C6A,0x52E2E9BAB8520197,0x7470A3CFE0898E48,0xBFEB2A9190617E18,0x247EA702F44DE1A6,0x7BAF95B27B1604FB,0xE9E81B78020C5856,0x0000000000000159 },
    { 0xDEB81330DA533799,0xDC4DE9F13996B5BE,0x6A8B7630D33F04B5,0xA4554ACB2BCCAD83,0x7974BD472A7F5D61,0xC481A752B01696D5,0x6DFBEFDE8CA48DA9,0x2FDA492FE7DB0C27,0x0000000000000053 }
  },
  { /* Point #2 */
    { 0xA2DADBB4CD046713,0x63EAC83E81AFA390,0x0D85B1AB422BC0BF,0x9DFC0092D5895AF2,0x125B2E6C87EE0EDE,0x962988829EB070D9,0x1A1178F85B0785C6,0x9335C96BD4486F80,0x0000000000000029 },
    { 0xE747E4433C5CB794,0x50803223044FD597,0x4BF3BCC02FC59DE3,0xD9F4DC3244245AB1,0xBEDF6330D2DD61E3,0xDF8110A904D7C5A7,0x852F2205BD400D1F,0x4595AFAF9C6E9CEF,0x0000000000000111 }
  },
  { /* Point #3 */
    { 0x1F6FAD01E435A290,0x2233FB1CA1797BBC,0xE5C86B07ADEC0E98,0xA6C3E3B32C38F3F3,0x148C7CC4BE4D76EC,0x9A269E568F91B601,0xDD4FDE651872EF0F,0xAC81696C8AA5366D,0x0000000000000123 },
    { 0xDD10F5BFC06DF67A,0xE02F88CFB5E3D640,0x67533DEFB63366E5,0xB81B500DD4F7515A,0x258048297AC6FDEA,0x05E776B30C92E736,0xD366E4ABFDDA7BA5,0x1C88E25338A7D99C,0x0000000000000199 }
  },
  { /* Point #4 */
    { 0x9B40A31F03D3477B,0x57E0E72E400294FE,0xE8AA7D3FE3E8AF40,0x6A3D54748DD4D7C0,0x564564FC65E1BAC8,0xF8584769108C5FA4,0xEB211EACDBBBB595,0xE06B04DC24A6B7F6,0x0000000000000197 },
    { 0xC7689FFD29BFB3D1,0x7AEE57F372378C9E,0x007255D96EFE861B,0xB8D3F65F6CFBBFAB,0x44629A5FB6D3923B,0x49E47CEA97373F3D,0xCCEFC3E7E5D385CC,0xCCCAD6E68461478D,0x0000000000000061 }
  },
  { /* Point #5 */
    { 0x8980DF2D3699E35F,0x9116DDBE7FEE846F,0xE8E6E54EFA3D46B8,0xB6C3996EB65BC109,0xE549C8EAEFFAEE6C,0x9553BB7B31410DEB,0x3900D1CCA660056E,0xEA4C30EF15F7DBF7,0x000000000000018D },
    { 0x0BF375E11B976FC5,0xBFA9C68017E1CBE9,0xD9C860A1A7478FF3,0x3412562269E4E8E5,0x0E98341CE1FF1512,0xD320C6FE76EB4630,0xA06CEC281EA3E4A9,0xBB00B6A08EF84307,0x00000000000000DE }
  },
  { /* Point #6 */
    { 0x475427960F5BFA4B,0x30D431DC7949B183,0xF8988F286F450425,0xD6F6E60DD3778A2C,0x08719F9364D83E77,0xC77516D1CB7840CC,0xAFBCD88077B2CCB6,0x7037603DBFACC373,0x000000000000008E },
    { 0x7D1F72796E42CE5B,0xC9C7AA48535C241F,0x117DC1334FA7BC3E,0x85E9129B83AC9251,0xB0237B53DE78FBB3,0xE95C6512AB35C8EE,0x8BA19C451F97669B,0x9B9F0C8A7AAB8881,0x0000000000000127 }
  },
  { /* Point #7 */
    { 0xC184AF99246BC98D,0xAE516351E0904D25,0xDA6CC6C8A4FA486A,0xFC9EF8FE33DD0F0A,0x8981F399AFD708FB,0x655302032A22F104,0x5A8D2895890718A9,0x7F48DDF88C71713A,0x00000000000001F0 },
    { 0x2E16FAC769A4FBFF,0x1EF4FF56C3ABF535,0x8F332C083AEE6084,0x312A01982B2EF3E8,0xB53036685BA34302,0x728716190F62A886,0x9F6FF887FCB4C8BF,0xA86874A9C3743566,0x0000000000000180 }
  },
  { /* Point #8 */
    { 0xC8BE45A27FE18629,0xA5C577AAAF2DD971,0x6E3A67F061570E7B,0x2CFC162946C8F13D,0x6A05848CA2754906,0xFD319607D0DA74F2,0x0941D89D65B65761,0xE3D2C4005821AE08,0x00000000000001D0 },
    { 0x3664AE19A334B91E,0x21285E386768D183,0x0914545399758724,0xD3DEBFA9FF52FA6C,0xA1D9CB9AD614CE9E,0x9C371626452E7305,0xCB2D7E9229277A97,0x13171AD82F307A9A,0x000000000000010E }
  },
  { /* Point #9 */
    { 0xA810227E65DAD623,0x01FCDA5624662210,0xE8543511A9154721,0x2914E67CE47AEEC9,0x85243B1645A2AEC8,0x1055599C4DB1DCCC,0xD8C2E07A3D1EE37A,0xB240748691FF64F6,0x00000000000000E3 },
    { 0x89D53742C47AD646,0x887493ED21D95CC6,0x9EC6E14C252A6EFF,0xDEAA3EEDB7C7AF4D,0x0B5CEB7CDC2BE798,0x95F753C3E8559739,0x3CA3A7C8A188513C,0x4F9912CFDB1CCC8C,0x0000000000000085 }
  },
  { /* Point #10 */
    { 0x66B11DE35097807F,0xD97001688956C6D6,0xB44AB980F789112E,0x8D84C890D8065A6F,0x68BD1EB836556220,0x2D78A2F0600AB712,0x877475E699E8428E,0xBAF046B5BD40B22B,0x0000000000000054 },
    { 0x406CA5189164AF2B,0xCFDD3AD4600C8B76,0x8B443270CB90EC32,0x9F021A66E20D198D,0x507F551AD2177737,0xF1EDD1FF8E49231A,0x8F30CAB6007EBA51,0x7B91BE67D8676F16,0x000000000000001E }
  },
  { /* Point #11 */
    { 0x2BFA1554B203D524,0xC6D86D8C64DAFB80,0x26807C023EE93E42,0xA384B2F0DE86DC52,0xC5816A9F5725DF01,0x89BBAEC758FBAAE1,0x2F452EB60957C4AC,0x119F0291913C1A72,0x0000000000000121 },
    { 0xF173DF1D2EF523F1,0xF7491B475C934CD7,0x83698BA3965C47E2,0x7C88C285287406C3,0x241E36FFF3D293E3,0x43C728798F6A23AF,0x0F6571EAFB1ED946,0x5A627FEC5514FD3C,0x00000000000000F4 }
  },
  { /* Point #12 */
    { 0xEC04AE998E006E2D,0x923AC4FCDA7C9902,0xE91A96C89EC9A28A,0x28004A30377C556A,0xE82F82D4BE756BBA,0x4E9C4655155143B8,0x667C4ACFADD3ED92,0xDB590AA6C2D95A2B,0x000000000000014C },
    { 0xCB7F053132237847,0xA06FF9854E110073,0xBA69F4B935676E46,0xCADC7250F1A9B32E,0x10CC7F2281F0BBBD,0x5967C22300CB192A,0xC93FA9EB9B9C2E28,0xB1D3B84416699F51,0x00000000000000A3 }
  },
  { /* Point #13 */
    { 0xFBA33000F6B1AB74,0xA9E1F2F50C96EEBF,0xE84F0EDA5C33000F,0x33789A12153679C1,0xDA4629F589209EE2,0xCE3785B20E22FE7B,0x53183B466F0C0EC3,0x6FE1779E5285B4BC,0x0000000000000056 },
    { 0x1EAF8ECCA5D768D3,0x224EE37310C1561A,0x519298E8FC7AF9F7,0xCDCA25634AF7C25C,0xF4096CB4D862BFEF,0xD49B6F4FF5223CBC,0x678D2E9F1AC83C79,0xAADF01B78F1DDC04,0x00000000000001F6 }
  },
  { /* Point #14 */
    { 0x27690556B119EC98,0xA07FC4E8B33CDD83,0xDD70A4E6959D2560,0xC723B197A824DF32,0x387F408B6B104364,0xE36F86CBDA9C0A19,0xEE5DF4D2EF6744A9,0x8C583A3FF56CE630,0x000000000000000F },
    { 0xA32CFC657CB1662A,0xA698C83930E77387,0xC3EACB751453A17B,0x86E25CCA10CE2530,0xBC4EC77ED137A2D7,0x4C6746CA235DAFC3,0x8B168EC927D5122D,0x0C75DAEF3D1A30FA,0x00000000000001CA }
  },
  { /* Point #15 */
    { 0x3BB43BEB00EF2A72,0x0EA2EE348A65BED6,0x4A07C01A25CF2864,0x81F50428DEF2D374,0xB5B902F731D5CE65,0x740F1CE1478326B1,0xAF7A25606905C052,0x4E6E4F6E1FC70939,0x000000000000008B },
    { 0xC32EF5C1B1EDAA65,0xF0AB55AC28E6D983,0x954900D5708ACEB7,0xEFD9F5C13A326BAF,0x05FD87D8BE1C4709,0xA40702B17B6CAE96,0x9263A19265344D33,0x141DBC82576F073D,0x000000000000001B }
  }
 },
 { /* Table #24 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x336B06222FEDA8AC,0x4658AE220C0B391C,0xE12F058F1F2119D0,0xA1F96C94495525A1,0x32EFC7AECD7D9F17,0x34E4FE2ABEA7A5EB,0x0EFD24927135C5F5,0xD7A04EB2B83241FF,0x0000000000000036 },
    { 0xF11B8E769CA40933,0x1951CD54D06857C8,0x0E9124F629F13914,0xE6EBBBE33D67D0CD,0x5483A2BCBF16F9C2,0xD4E4EA52255EA8CA,0xEE0DB0B5734EEF50,0x54434B5116207775,0x0000000000000017 }
  },
  { /* Point #2 */
    { 0xE67AD2A7A597628A,0x424DFE8947DEB6B6,0x42669BDC0ECACA8E,0xAE7A2F64D86F6549,0x3858F56B652A2E24,0x8E5611A650291825,0x21C2061120FEB545,0x4E550A9ECD63163A,0x000000000000005F },
    { 0x4FABBB26B3B110BC,0xEBE74805036DE290,0xDE88D2D633789748,0x56A1B7B8DBF7865D,0x0646D53DE8707CF0,0xCFB67FAE64108A0B,0x04F1401BA32160EE,0x5998552D5F462A78,0x0000000000000056 }
  },
  { /* Point #3 */
    { 0x44D1DCB67B1A7381,0x88AF97D4541488C5,0x6D9DFF01E065E612,0x61FBE70F20E73756,0x493B908041379C43,0x7D969BE18391C070,0x04BC1AE18A3B0242,0x417D5158946C7856,0x00000000000000EA },
    { 0x45F996F317F7E492,0xB2904E510704EFEC,0x0F89BAB97CB6CF84,0x32A4D45898E07858,0x7202EFB9A1BE9838,0x98A4E8AF4E8743DA,0x605CF158657D4C74,0xCCB12E267E0EBA38,0x00000000000000EE }
  },
  { /* Point #4 */
    { 0x80E86D53083E8647,0x4C143F8DE6BF14C4,0x98965BEBD250DDF8,0x66AD16A097F5F7CE,0xF3B79E6A91CA08F9,0xC8478BB25555AE35,0xA3B1085A3048210B,0x400E0A3FC2E9F129,0x00000000000001F1 },
    { 0x73DD8AABEF069132,0x4AA4C72566348212,0x44B84C9436F78446,0xF835DA5068C9B6CB,0x66B8E1D9A3536E11,0x29FFBB214F4541D4,0xCDB5BAFFA43E5D3E,0xCA8FCA6DD75F692A,0x00000000000001D6 }
  },
  { /* Point #5 */
    { 0x3875C2C997FAABFF,0x7D2E0B150A8A8A3E,0x1E9892E4E5C00FA1,0xFDAE6C4A8271DA55,0xBEA2C42BD0C98F92,0x229FB76C49F83707,0xFE084798062755E8,0x5D5D514DDBD4F518,0x00000000000001E9 },
    { 0x7037FC7CE9EB3349,0x80D2AC4BA3F25B16,0x37BEBC0D4B46B33C,0x90DEC4B5F5ECE30D,0xA3AE497798259B5D,0xC60C07B4EA2D121B,0x2B43168136D24A42,0xDAAF2349DB64A83E,0x00000000000001B5 }
  },
  { /* Point #6 */
    { 0xE54530F5ACB36FAB,0xD60DE27EFE671BC5,0x1D09E4DB36AB4B55,0x20AC62618DF1734C,0x83CEC1A02FAB1D3A,0xE959E73C4172E7F4,0x38D56B081D55FB65,0x1398CB97584A03D9,0x0000000000000187 },
    { 0xA215316281712E45,0x2F77CC7C13244B84,0xE28F7A315E636322,0xEA81C6D176B88D74,0x35D59E53A66229E1,0x5A1CCFCB2B114039,0x6371A053DE1C4BD6,0x526E9698C0AB1C97,0x00000000000001D1 }
  },
  { /* Point #7 */
    { 0x19911D1347C3D608,0x267573DA258CE1C1,0xB378183F5D563B12,0x2A09AC7884A1EC2B,0x5AC59A10991D1F10,0x9F58D55EEDB7CA7D,0xFD41710B7E3B9893,0x4572D5102D7F8E00,0x000000000000015E },
    { 0xD25F4424706B8E8E,0xF38550CF75653D00,0xCB55F785D9940106,0xC0BA5C65B52EF320,0x864506843777F7B4,0x24D73B7B85C22A24,0xC7F1AC86F53B1338,0x8D4BF141454E8CF9,0x000000000000011C }
  },
  { /* Point #8 */
    { 0xBDA14ABF4D9B67C0,0x54478DFABF9AC0B2,0x08943AEDCA457B40,0xD82F3D75F18006C3,0x434D99A148F5E818,0x600C40E3C5422AD5,0x8A6294594361F89D,0x25FD287B9C176983,0x0000000000000003 },
    { 0x5465DEB69D02479B,0x61FD5B4FACF06848,0xBDA65F8547787599,0x1689CDCE23280FCC,0xB2EFD35D62E25557,0x19FD60739C9F12B4,0xAF9A39433A87DAE1,0x20DD9C0AC5A84A92,0x0000000000000101 }
  },
  { /* Point #9 */
    { 0x4BA7EECEF33078D3,0x6C19514EE4938E69,0x422C64287AAAC94F,0x5E405A9F77A45CA7,0x73387BB700149BC9,0x880C443DE0AD22F7,0x7A15A5D8C124E4A0,0x0920DFA310B468DA,0x0000000000000103 },
    { 0x0140A29D5960A977,0x69DBF269DF578F84,0x3D58EB2CD3E33800,0xD56A3CA355C6D2ED,0x326DE33AF9ECD035,0xC2480B6DF5E37117,0xDE82D31BA120B6C0,0x6F2546EE9A02AF7F,0x00000000000000C1 }
  },
  { /* Point #10 */
    { 0x7F0BFFFA897B85A3,0x44C1D0C7FABE1178,0x03C3907FB679F68C,0xD937C0875CB933BB,0xFEC34EE6364DD97B,0xFB34C59BFAD8981D,0x282BFE4A09706557,0x098961A4A03471EA,0x00000000000001DC },
    { 0x41759CCE8EB320D1,0xA3C7416BCE37FECA,0x28FED34B59FFDE79,0xA80FAE2FAEBD3BE7,0x14938E364D8367B0,0x13669F94382FBE8B,0x11F4E3C957BA92A9,0x32B320929E576955,0x00000000000000BF }
  },
  { /* Point #11 */
    { 0xFA8F50846FCA44EC,0x82B84B2E2DBD4DF1,0x47615AB1113F4102,0x79BB98C6F6953467,0x6893F29DFD265C98,0x9091A93D8272830F,0xB1C7314D68F8DEC8,0x2303534FDB629F3C,0x000000000000003B },
    { 0x5CAFC9F5E76E6FC7,0x84947B7F84C48EBE,0xD37D1697F89F075F,0xA7062CA005EA2481,0xD4BF3D681FDF1E3A,0x75540953434D4F8E,0xCC2F2E9A1274DC40,0x589A00D5F3392828,0x0000000000000152 }
  },
  { /* Point #12 */
    { 0xD8764ED5ADAB4CF4,0x6A3F2257BAF7618C,0x6607661BA03BB43A,0x16F0AD3D41029908,0xF8DADF979B47F97E,0xE690674D9DD13DDA,0x8F5F3C154180317E,0x9694476452C697A1,0x00000000000001B8 },
    { 0x9E9715E5F7894511,0x43C263B702F78D2D,0x31B78C2547AD4DE4,0xE2F6454CE10EF4BB,0xD0F816AD15787104,0x169F4E00BC5C632C,0x99C89FA79B77E99A,0x7C758A0EEA13B439,0x000000000000003A }
  },
  { /* Point #13 */
    { 0x777FC8AA25D36425,0x3160421089182FC4,0xE191069D974B40F1,0x97F4BD35D8F73D7A,0x95B9AAA10038A2A4,0x63FE962A891DD290,0xF305637F4DE72191,0x90C19709BE47E84C,0x0000000000000140 },
    { 0x0F5B6B27847F0EA6,0xD4BBBFB6D98337DD,0xD95BEF5372E7127F,0xB873153B7B3C4604,0x9B1E02EECFCD81E3,0x905E18F97CD9025F,0x34E22797F7C4AE62,0xFDB364EDE1C201A0,0x00000000000001C6 }
  },
  { /* Point #14 */
    { 0xC0C5D93BA445997B,0x643E94A8E6AF4865,0x52B239FF6210EC8D,0xCE606BD95A4B07FF,0x1CBDE33384D94D3C,0x9559632B4C0DC480,0x4C771BAAC9CD1646,0x74E501E69E744213,0x0000000000000090 },
    { 0x87BBE7EDE205AEBB,0x7FB47DCC91D9EFC5,0xF6EE3E6B641E0F4E,0x65211C2B5563945E,0x1E0E0DCD8A2FE0AB,0x9F06BA1A6FA25823,0x4E3F818433345FB9,0x545D4D47E03D47ED,0x0000000000000028 }
  },
  { /* Point #15 */
    { 0xE3ECC6294AC5D687,0x330D122F8094FF61,0x90F663256DFDD426,0x63312050666A6583,0x1288267BDAE067F7,0x5F1BBE73C98968BB,0xE97DA1C2AC22EF5B,0x650C77404B555B16,0x00000000000001AD },
    { 0x5BEE242B74CC55C5,0xAA4FDD8300B29CE1,0xD7AAEF3BA2BD841B,0x12A8782681E8601F,0x0CCFB765004ED2D2,0xA220BB04A27EAA02,0x4FDF3B5BEE67F4CE,0xB5436654EA5130D1,0x00000000000001A6 }
  }
 },
 { /* Table #25 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x067F879FC7734385,0x787C7F18B4A51794,0xA269C44672D9AF69,0xA4498E7387D71897,0x28E3D84AA91814AC,0x8CAF2F61F62FEDE0,0xAD36DA315DC202BF,0xFED8BC0FA4689189,0x0000000000000068 },
    { 0x84A0854296AA1400,0x871885F1CD72B4A4,0x00954202E9D3027E,0x19B350695C86A302,0xBE420B636CFC52A2,0x8B75228287175B19,0xD1811B8C9A22611D,0xF9C23D803E468601,0x00000000000001D2 }
  },
  { /* Point #2 */
    { 0xC52699B9E6A0BF64,0x3D1F9B860D0E9732,0xA14CA004E0882130,0xA69508493D669257,0x65C264D6D76816D4,0x594A5D7CBA522818,0x8E44A20532AD6596,0x74445203093718EF,0x0000000000000189 },
    { 0x63B108C628885DFC,0x7DDD44CCC31CF288,0x82B2CAD4B5267F9A,0x5B8A5F7B449E0CC8,0x24A85F05E8BBB4A4,0x694CDC1CA0EB93A8,0x58943B3455741FFE,0x381DF171377AD2A2,0x00000000000000AD }
  },
  { /* Point #3 */
    { 0x13996F30E402D747,0x2524A83BEBC31A51,0xA41699B795D7EBC0,0x602112C7AD867499,0xBF81B788D43B5A3E,0xF3CD28581C736CEA,0x01A6DF580FF424DD,0x6E527DAA95500BAA,0x0000000000000171 },
    { 0x1D966ECBD1B77FF2,0x2980D1C923985BD7,0x20A275A635732BA6,0xA1B81F99430369D0,0x6052B0183C0A4D36,0xB4FA4D6C8A790B12,0xF4EE3079353165BC,0x79EF46797ED670DE,0x000000000000002D }
  },
  { /* Point #4 */
    { 0x84B4E6F6783099AF,0xA94CA2294DC772B8,0xCB768AA65EA29D0B,0xD47361170FCB316C,0xC411B7B79775774C,0x410C974C96AC3F48,0x1663C40AAD24A12A,0x87F1508DA2A503BD,0x0000000000000161 },
    { 0xECD265CED518BBBA,0x8D77018DDCC67981,0x1E9C19223ED1A18A,0x5484ED8427440D05,0xD319640942D659D6,0x82CE3A7181354397,0xD097534DE7D7DD79,0xDA9D11CF084658F4,0x000000000000006E }
  },
  { /* Point #5 */
    { 0x9886A22962C16459,0x0E0236AFE5AA41C7,0x468D4C3A61FEF10E,0x8C3171AD3DB4D163,0xEA4180801022BF50,0x29C61BFDDD95500D,0x79073998FC1086D4,0x18E62735D880BED1,0x000000000000008D },
    { 0x3772A3A6BAB5ED67,0x59AEAA70C4A82BE5,0xDEFD15693FA10EAA,0x60CF6BBD3D7A410F,0x9C3CE822061382ED,0x4B45AF6448A0B43D,0x4C7B5A07752C5323,0x638F2663CFD710F2,0x00000000000000B9 }
  },
  { /* Point #6 */
    { 0xB6D0EEB7510BE54E,0xED352173060B7322,0x0F581A2183364EA6,0x78EF831EF59EC71B,0x09A472C9A055E4B0,0x0A529BCB7D2404DC,0x45F10074B461331F,0xF80627F369A5A576,0x000000000000006D },
    { 0x12CF73E37362082A,0x7CB89BC91D6278A0,0x2B0C5312B9F399D8,0x4403D4FB21E7EF6C,0x34DD11819B453F15,0xA38C5E981AE02A19,0xA1ED1AADDCE1792F,0xAB8261DBA4D71C9F,0x0000000000000036 }
  },
  { /* Point #7 */
    { 0xC9EED4F2599A7682,0xF1ADE4E4A4F4F82A,0x7479DC8B6AB6D04E,0x2DA874DC271E42CF,0xC700CA719265E2BB,0xAF88BA91255FDCC6,0xF68C29705705E0DD,0x6EE1135B229FDC50,0x00000000000000FB },
    { 0xF4BD32A2A1A31961,0x4E67ECCFC4785C20,0x8C0CD85D17F740E3,0xF6930E3AD8C21194,0x2C9D9C7376B4C919,0xD32DE819E69EA290,0xC1028DD33724A066,0xFD3F06EE7538D3AD,0x0000000000000054 }
  },
  { /* Point #8 */
    { 0xAD3570F4D827A280,0xDB625D88B2F60F8B,0x81BD93B7AE94D18C,0xC2FFFE8AF3AE3394,0x06B0EC262E4A72B4,0xF1285A13C7728DC7,0xD97DEE85A4190A48,0x945E4869D4B0F305,0x0000000000000023 },
    { 0x44587F935C577ABE,0x256B56424DDD2F17,0x36E73DFF0EAB2BC4,0x6B2B5F3ACE0F4471,0xCE1F2F0FA25BAE4C,0xCF10076029866124,0x0EC9B4D25EA0D400,0x621B68580ADECE0C,0x0000000000000162 }
  },
  { /* Point #9 */
    { 0x1FF09F33CAE6514F,0x191FE11B261FB47D,0x97E72C53BDF0B228,0xF81CDEDB8CAAD4A2,0xAA5F28367542E922,0x090DF178D68E225F,0x9ADFB6202C8431D8,0xB8F9BEA70F010FF8,0x000000000000016B },
    { 0x78FC8973F422E828,0x8496B0B5D149E76C,0xB1F0911A565C8F4A,0xE580F18CA79F3220,0x8D3B71356FE124BA,0x8911601D673928B4,0x193C9FA9E5209D66,0x988483F1BEA837FF,0x00000000000000F3 }
  },
  { /* Point #10 */
    { 0xF9BFE015460032B6,0x6410756336A6C19A,0xB0712A3510D65254,0x3C97AE7D2A9946DF,0x28E961EDBF77C7F9,0xF937F17CBC8537A9,0xED718F65057512D9,0x7EE133FF8BC561A9,0x000000000000003C },
    { 0x675476A99E3441E0,0xF8ABE77C9EEB9DF0,0x0CE788421A10B4CC,0xA6F28B21793079E4,0x01C63657267D9DCD,0x2DE2E74E702B40E8,0x28620C5A25617600,0x7505685E5D4D9809,0x000000000000008E }
  },
  { /* Point #11 */
    { 0x5CFC2F27690B6BF1,0xDC6E6043F33BA977,0x39DC991E82D11BA7,0xFB80C94E2922C70D,0x393DCC3BA5CDEAFF,0xD44D9C7CA687F07D,0xBD25EBAB33BC5437,0x9A389625D71C4392,0x00000000000001E3 },
    { 0x0AC41A2F228F0787,0xABB96A60CDE860B7,0x22CD3CE604C04D14,0x157669C6F65E7B0D,0x0EF03F6167ABCED9,0x9D2CD63A814717CC,0x3991C34977387F7A,0x3C1B38A58A80A7F4,0x0000000000000033 }
  },
  { /* Point #12 */
    { 0x95F7FB41DA8576C3,0x42901717D151BB68,0x7A0277D38777C80C,0x6827807B5A429477,0xB98E1DE8941EF5EC,0xADD50957575465FD,0xD436CDA505F5B417,0x6D30BF0BC232AAAA,0x000000000000012D },
    { 0xD4B799A488873A5D,0x2200C6D4D60DC1D3,0xB784A12B75C91D8F,0x6C8AA91F09FED40C,0x48DB563F5720CCE1,0xBB0DE5C0F50BDDC1,0x4AA1FB064C4BC117,0x905D18A31CB0DA02,0x00000000000000E6 }
  },
  { /* Point #13 */
    { 0x85A59A49B81F2D5F,0x5AB98B4CD12CAFC2,0x7BE9E55C9036F3D4,0xB6644D14AC17DDA1,0x0D6CAF4BA23F330B,0x960E78EF567899FB,0xB6EC1C3F4BEDF73D,0xBE7E5CABA971C6B3,0x00000000000001B4 },
    { 0x20CB3A6A66A01413,0x1FC8C49D71DD7853,0xC6EEA4C1D0F467CD,0x72ADC39AC442DC91,0x1349AC1B9FD5A2E0,0xA58D769226814C74,0xBE23DA1602685093,0x411491B34F2278A1,0x00000000000001C3 }
  },
  { /* Point #14 */
    { 0x414530555AB463B0,0x545B0B693248CAB2,0x25EC52D5DD9B920F,0x73BF68542DCDB1CE,0x8EFB2A6D02BF830C,0x794AB4165EA6B254,0xA4422D12DF2A60F8,0x78BD1B524E9D5A0A,0x0000000000000026 },
    { 0x3F341ACBB43F9E41,0x4A73E42A6991D638,0x596CFD672D29B6EE,0xC9184FE2940DD578,0x283A30954A2883ED,0x0626DD7AA58BC7CE,0xF2D6C6EF401334F3,0x55B107493C254BAF,0x000000000000002E }
  },
  { /* Point #15 */
    { 0xDCDFEDB147C91A15,0x89C1654DE8003763,0xEEF03C09E074525D,0x1A75460C0B7979D2,0x58881343FED5AE1F,0x3FCD3227DDB9340A,0x1E4DB699885BF042,0x2923F9382340AFAE,0x0000000000000067 },
    { 0x934EF610CCE2E800,0x8DB3F34BBFB68EFE,0xD78192D6C8DF9008,0x94929564D3FA0C49,0x2D0CDBABFB20D848,0xBE73F64FCD307B38,0xBDF434F3183096A8,0x009A7AB97BB336BF,0x0000000000000096 }
  }
 },
 { /* Table #26 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x5D3F00ECBECFF63C,0x280FC963671A2835,0x27CF9990849AD2F5,0xA1CFA523B27C7F2D,0x9D9A6870B8278B74,0xD6176CDF9EE793B2,0x9A98521AB31E9501,0x4422E43E7436E438,0x00000000000000D9 },
    { 0xDA4F7464DAA8DC76,0xA5B83150919E1298,0x00D3948D81C82C13,0x95DEF32463724CDE,0x9B57597B7D5A1038,0x42D9D64E57432B3A,0x9807D998936E411C,0xE68EEFACF1E57507,0x000000000000003E }
  },
  { /* Point #2 */
    { 0x45D90CF8876B33AC,0xE53E1A993ED58F0B,0xD5D181F549D916B3,0x1B1EF0402EC09BE2,0xE5787176B2113B57,0x11D02E708073044E,0x9D1C19E7A2AE38DD,0x2662D4943634F6FA,0x0000000000000130 },
    { 0x454C8A736BD6208E,0xD2447CEFAE37911A,0x56AC592E69B8C5AE,0xE7F564839B615BFC,0xFAC066E1BBE7FE62,0xB2AC3EE1B7777B32,0x55F8653315114ADA,0x15CBA83E46497CC9,0x00000000000001EF }
  },
  { /* Point #3 */
    { 0x7D6D77C412ABD32E,0x8B58DF9D5A1DC2C8,0x5DF661785F9C5B6F,0x3F78CCF5FF715A3A,0x2376DF67307A7DFB,0x5B5BDEE15068A701,0x21F460610709FA2E,0x4C2803609FC7E647,0x0000000000000117 },
    { 0x55195E04E7755B08,0xD9B69A94D50F18E2,0xD1B750B5A04C2B7D,0xC9A076B8CA6F61D0,0x65979F16DA1FB312,0xBB7D6D42D953EE94,0x1AD05E58AA5FF718,0xAB94F4800317E1E4,0x000000000000008A }
  },
  { /* Point #4 */
    { 0xC06A64CE981FD289,0xB8DC2603D11FCD02,0xEA27A922770D2EB2,0x83C64076DA8F19ED,0x9F6D1B650AE6A311,0x977277BF73FA8721,0x7115EF98CC0292D8,0x93237AE7D2E0C67E,0x0000000000000069 },
    { 0x83481B595C151734,0xBA00BD740AC1576E,0x48F33272F178D4F2,0xE09FDE3816492D95,0x876124DBB9DFCE3F,0x27E7B1E503FE728F,0x79347E4604F98F99,0x63EC8C5D48DCF0EE,0x0000000000000149 }
  },
  { /* Point #5 */
    { 0x83623F4A5E85EED0,0xFF73A65E701D91FC,0x3E93F7EF49127780,0x10047A368E0A688A,0x96F38840A7BD1727,0x2F6759F213809A85,0x6A04F887D94AFECF,0x8332179C95F9E69A,0x0000000000000071 },
    { 0x5D3F3C220660084F,0x3F769F322E0FB966,0x3AAB2F1B7DF64348,0x9C9AF67F4DA76AC9,0xE82432D2D1BDC740,0xCA8186AC38C13136,0x45DC1B6F39238A7D,0x020D45D8FFD73047,0x0000000000000018 }
  },
  { /* Point #6 */
    { 0x82A80D88B23B9243,0x1A102766D91555EF,0xDF3CEC50F069FA76,0xF6C125294319CA89,0x9A11B37A0330EEA5,0xA5A659A902C12564,0x3E01E4311612FA73,0x85580747E35674B7,0x00000000000001DA },
    { 0xFA500E83B5A20999,0xB539909DCC336EC6,0x76AA969E7AE2AC1E,0x2144206CE0A9712F,0x095FEC7E3EC387D1,0x5988797252C7840F,0xB61A7C61262F5F93,0x75BC25E7A76B83B5,0x000000000000016A }
  },
  { /* Point #7 */
    { 0x28C57F1784DCF978,0x5D15960E17A3887C,0x6A673E7682E3034C,0x5829936C8DDE388D,0x8ABBCAED73E99034,0x3EFC69F342ABD2EC,0xA9F2406279F77443,0xAF1EBE5425B3F63F,0x0000000000000137 },
    { 0xE87D4B598F9732DB,0x72D8BED7B6CA6427,0x660EB78507459F38,0xF568DF52FEA2EEFF,0x21B019AC01B83CB3,0x222EB174D4AF53A9,0xB04E0CB1932EB702,0xC45125DA764CF455,0x00000000000000F3 }
  },
  { /* Point #8 */
    { 0x327D64092CCBB0DA,0xC5750F6ADC39DA33,0x8B9EEBBF7383F8F4,0x9EBB5A8E256C4EDF,0x7513F7C0A917A2AA,0x31EB5A3DC4824BD9,0x2D6A4CFC2ED4A7F4,0x9EE354AAE0C9C30F,0x0000000000000179 },
    { 0x20EB09C9CBF2D15B,0x4574D31C2547C112,0x76543E3DD38E79AD,0x1D35B8874EDC05C4,0x3AC58DC7AEA4DE85,0x9AA6FA0AAF5715E1,0x8869704EB163A66F,0xC685EA7AD14001CA,0x0000000000000083 }
  },
  { /* Point #9 */
    { 0xA867BCED80AB8ED1,0xC2F3E32F7330A15D,0x73D2354136D988BD,0xC8C373A6603F8E56,0x757AF32AEA52C655,0x95761E3281EEBBE1,0x4AC5350FC2DA2F06,0x4842E43D66E20832,0x00000000000000DF },
    { 0xF78B92418F8D5435,0x39E3D11ACB19A542,0xC9404482DBB5F8F0,0x9A501D56E9290BF2,0xF20D78A2E7FF059E,0x89C0D42E9CC0C75D,0x9150E5837F12E08D,0x1C3595B36EA320F3,0x000000000000002B }
  },
  { /* Point #10 */
    { 0x5B6711A5052B505A,0x3B32EE5ADBB104DA,0x3A59883E14432CFA,0x57B6D6BC88B7C74A,0x363DC2628D5582A5,0xBE6D3BF58928103E,0xFFFBEB0963B06525,0x29ACBF58FAC9B5EC,0x0000000000000002 },
    { 0x78696DF41CE15975,0xA9732060C78337EA,0x288FE1958AAFA892,0x5DE9CD9132A7BE5A,0x2F1BACCDBEC8ED8F,0x88131F8DB1F0D997,0x8D15C4049D123BF3,0xF460D41630A1544A,0x0000000000000029 }
  },
  { /* Point #11 */
    { 0x92B2EEFDC678377D,0x6AED894E07232D1E,0x830CE0BCED0C288E,0x55F85C3B54DEEEC2,0x7458AD906592DA50,0xC4121F5815B63150,0x3EE325092B593642,0xF5AC75DA36FF6204,0x000000000000002E },
    { 0xD5DA2102080763F1,0x7E15E9C9B49BA347,0x488040A8120640CA,0xBC6682068599E896,0x22851E415C7B6656,0xF6E3A1F250E3B0ED,0x61E46FEC0192D3AE,0x8B2E579D4439F96B,0x00000000000000E5 }
  },
  { /* Point #12 */
    { 0x95524DCEA3342331,0x2DDF9B2F0E413B88,0x342E0CE86A03FBE1,0x8E2DEC3EEAA3999D,0x3CCF191B5CA80AD0,0xF93EBC99804B9C29,0x97D83573F2282B48,0x51F33E7359ECB135,0x000000000000004E },
    { 0x789B5CFC7D53F035,0x5FF3AE9A209B881C,0x09AF30BD80DCD35B,0x850CD0AA799B2059,0xB660D065E2642327,0x9D9424520F5134B0,0x1FD8897381AB299B,0xE126DBE9B6A2BA25,0x000000000000013C }
  },
  { /* Point #13 */
    { 0x01CA7BD3376F6FFB,0xE5C1B10F86F4BBA5,0x6241845D556EC106,0x3A2ACE8BA3D0C035,0xDD90A0F3B52B93A9,0x9EB510FC85BC19D0,0xED53322395261F9A,0x8C250328BFE90F90,0x0000000000000174 },
    { 0xD5BB6B8014AB9890,0x300F1FD1577E18AE,0x76CEA1ED7392AB52,0x12C3649929580A1B,0x3FFD342C8560D39C,0xE8C3F90C276D2C70,0xB137FD6B41C8AD4D,0xE237F5B506A09196,0x0000000000000125 }
  },
  { /* Point #14 */
    { 0xCC6292A08A547E2D,0x9A76A8E180565C69,0xDA4D2475FB616140,0xC9CD45238B5A04C3,0x8313B6C0554879AD,0x9A103A9522038226,0x4E5DB49DD06A57E5,0xFC49D649D1F333EF,0x0000000000000063 },
    { 0x529F97E82F30EA09,0x06692DC9416E0148,0x534C9F6EF6DCCA0B,0x26F9F8409D575D04,0x93F66C9743C153D2,0x776B12BD9D1B22CD,0xA44528E4B4000757,0x738ECFB9881F46C4,0x00000000000000E8 }
  },
  { /* Point #15 */
    { 0xC4EEC39761604E9B,0x52B875A46F0D43FD,0xF9E8BB746E8E42F8,0x47C5A743F2F4B25A,0x183170AE36EC3740,0x391A34FE2B0E23D7,0x9B4DF7D8BF15B3EF,0x1C1F163A4CE42FAD,0x00000000000000B3 },
    { 0x98BA447F9608641D,0x1442FA6567D316E6,0xD032BE7B70F6CA5D,0x17A8B262FAD15732,0xF6BBA8E66A37085B,0x08C86060A7B7CEBC,0x79D309C1CBEA56AE,0x51B40CD43B5405B2,0x00000000000000B6 }
  }
 },
 { /* Table #27 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBEE094232A7F01FC,0x75176A16998AF9A2,0x13273068FBE89A7A,0x3E74AA6F13C42B6A,0x7DA022BE579C61B0,0xAA759216FF23E10A,0xCF7F7D1AFD852641,0x0E9AAF1C1090B6C7,0x00000000000000DB },
    { 0x483B1F8C6D9EBCAD,0x25F3AADC987B2C42,0x83A7BD03F70950D0,0x67AEFD6A14F250EE,0x6E90C4F990070D75,0xB9D65432035FDD1E,0x190281BB2AB23F7E,0x36008CB1B69015DA,0x0000000000000137 }
  },
  { /* Point #2 */
    { 0x80D935B163B7A2CC,0x3315375ED6DC2ACD,0x400BB7948B895A51,0x35962FF9B28F625A,0xD75E5CD7EF66BEC1,0x3BEA41715157464B,0xF372E7C8605C7EB3,0x3741FBF0E3301A57,0x00000000000000BF },
    { 0xA5388110D0C6184B,0xCAF6355EF89ED74A,0x4E170981FA93C1EA,0xEA60089B0DD9B47F,0xA27EFD8B3B9CDA73,0x5852497B5EE68672,0x60F0DD9C45BAC304,0xF444A8F03048CD59,0x00000000000000BA }
  },
  { /* Point #3 */
    { 0xCACF976D657D30AF,0x8D99F439E599602E,0x89B7BA5142C60609,0xBE1FD86127695726,0xD1FE4929CF48052E,0x785C994775A3938A,0x89C0D82562F5496F,0xCF585A3F24237D10,0x00000000000000EA },
    { 0x3D2D602DF48C877E,0x56732DBCF094B87E,0x5603DD5C4C825B63,0x41A7454849D45408,0x573734F5DDFC690B,0x5FA016412C2993AA,0x1BD91FCAAADFE3CD,0x3CD67D47BE83C452,0x00000000000001D2 }
  },
  { /* Point #4 */
    { 0xD15EA6B41F8670AB,0x1957A0F1199B1007,0x113AFF43E3EFADC2,0x07C606090FDC6ABF,0x93E7BA310BB0014B,0x0F6B7E135D34945F,0x2303A74AA9F86051,0x6C9FC83A312CF1B2,0x000000000000017B },
    { 0x5588CCA5E501AAA7,0xEF0D3BC16E7AC7BF,0xBFFCD55147339A1A,0xF83B4CB8C36EAF74,0xA4E70EE39ED93D5F,0x0972AC415C249069,0x2E9968FECA09BDE3,0x1B5B37298C5AEC39,0x00000000000000C5 }
  },
  { /* Point #5 */
    { 0x8FF38AA4093EDCB7,0xC3C6B459E8F5564F,0x613E5157B8935FFC,0x1EBA7A2AE10E448E,0xCF8D70C9FC31845B,0xE1E4D5BB77F5A42D,0xE61BC59EDD07816D,0xA0928CB3E85FABBE,0x00000000000000C4 },
    { 0x12E7717EACC0393D,0xCA036B26540BE4CB,0x4F59050E36DCF32F,0xDD2E7FF9234B425D,0xBD17895136B8D833,0x132D27FEF989D479,0xC2049EA7BA09EF6D,0xB526A9B5C83A3B7C,0x0000000000000157 }
  },
  { /* Point #6 */
    { 0x68A3040E09EB3233,0x0A44434506FA4864,0x579EDEFF83AF8AF8,0xD619358709F49BAF,0x4597975C33F9EE19,0x5318A888CB85CB9A,0x6366031F423FF919,0x32FA03EEF3EF6E44,0x0000000000000072 },
    { 0xADC2B71B8FE0BDC4,0xA4B86022245354C6,0xBD96981BED7A1CA8,0xAAF0BF088D27B9F8,0xCB56E8F255EF3926,0xEE69EE6AF868426E,0x04146106114F6B0C,0x5BD940000B8D34DB,0x0000000000000154 }
  },
  { /* Point #7 */
    { 0xFE88213A38540B67,0x16613CADA30B9044,0xB06DCE427861D61F,0xFB5C9FFDE2B9CBE1,0xAE4AF79BA5AE6125,0x56E69B5A3FF351AE,0x68DE3B3F31DF9832,0x8D2C2960FA3FC1CB,0x00000000000000CE },
    { 0x979C3DD49FD40F91,0xCA979B58B5640389,0x855DD28E836EA10C,0xBF40EE0E17F1CC25,0xE02BBB2F5FD556CC,0x6AADB11005F32F3D,0x26BF5C119366213D,0xC15F02C49A1CA27A,0x00000000000001B0 }
  },
  { /* Point #8 */
    { 0x671757A6E2ADFECB,0x22EB6B422BA58FF0,0x845AD5524E6E393A,0x3DC6F7CB60FB46A7,0x9240526B0A84396F,0x13C8F57C56152715,0xAB02366C6C45E7A9,0x6D4F07BEAD159399,0x000000000000006E },
    { 0xF69FDD7F07F6E883,0x946B2EFB3F45AAA4,0xC3390FF156806EDA,0x22764FAB21D28BC8,0x363B41D10C20EB57,0x7D693BB1F6E0FE71,0x5BA2E46A2816DFC1,0x53C3D41AB0F7EE72,0x000000000000012D }
  },
  { /* Point #9 */
    { 0x81F4CC04A0326352,0xECFDD0FEF72EE377,0x8ABAD53749737D2F,0xAF80A43662673FB4,0x1C79FA0780108B8F,0x07D0C9AA09BA3ACD,0x74D0538A1DC6941F,0xD0A688D5B6966721,0x0000000000000137 },
    { 0x36BBD2E0353F803C,0x6107A9FA4F536244,0xCAA3DF336381104D,0xAD4C069476E300F4,0x5F26E9529230C20C,0xEBBED179C252524C,0x2CF2736E90C1B14A,0x653C730F4E5F39DA,0x0000000000000012 }
  },
  { /* Point #10 */
    { 0x2341F58B4FEFC586,0x3AD4B78B48AC32E6,0x5D7DF0EFFDAD63E5,0x365D5E4E760E56DE,0x1F9833510F3F56DF,0xF53646D95BDDB98A,0x95562953136918FE,0xAEB1CB903B907E11,0x00000000000001AA },
    { 0x33688314E1FA79E2,0x7DAB1D9A46942EBD,0x4A49C5BA90E0369F,0x1A53D1142664C208,0xD86F3C6F2882F2A2,0x6AEA18AD7A1F38F6,0x1274F0D396839DA3,0x3BF9E132BF315B91,0x000000000000011A }
  },
  { /* Point #11 */
    { 0xDE9E51CF9336FD14,0x9F4116D3537E7969,0x80780AA03CDC17BE,0xF1DAB123E6DC8CC8,0xB29CF88BAE8FD422,0x6A8A6375C89D013A,0x18806333A72B77E5,0x0C95C29E15AC040A,0x0000000000000051 },
    { 0x1799FA1F24528A1D,0xA01C9CA98862F446,0x495304345FE33357,0x705C9CE50D614E1D,0x46D3D820356159EB,0x5523FECEBB864432,0x2C23FF580153455D,0x95919951B321F9C3,0x00000000000000E5 }
  },
  { /* Point #12 */
    { 0x417E47FC2A0CFD7E,0x70428783A8A2E402,0xD000EDF7C59EB219,0x365955AD3FAAF961,0x047AE4F0A077957B,0x98F7C04E61C86B33,0xF1ADC69628B64863,0xDB439EFB71FD4421,0x0000000000000105 },
    { 0x9CB08CF4E592369F,0x6F26DEAA616978AC,0xC020BF3227A58630,0x3DE17CBE34B0A3BE,0x1214CA7ADAF71B07,0xD641F49108BFDC0B,0x6FC0B798251194AF,0xF6AEB57E347959EF,0x0000000000000111 }
  },
  { /* Point #13 */
    { 0xDFCD9B1C897A646D,0x82382DEB8B24C5A4,0x498750AC757AB75B,0x7A6C8430AF400556,0xB315883D8DB05291,0x3AFBFD2A77392D75,0xB3864B36C6F0FACB,0xC282A497ED5D335F,0x00000000000001C9 },
    { 0x726A53BBE68AE630,0xB3C4462D17BDE630,0x48F111EFE0CF2E38,0x47AC0B41CBF5E3B7,0xF592806D0C04F994,0x3230AD431B4EC838,0x2CF1140DCC0A3F21,0x45B7837E493432C0,0x0000000000000180 }
  },
  { /* Point #14 */
    { 0x46C2F25188D34538,0x7B70A379E466128D,0x070D2A9A70594029,0x36D155360C4CEE23,0x0D96AC4F7C3F6B9A,0xF5960EF1AD9CE1BC,0x3726E286D7658622,0xC8E1E145AF6A5517,0x00000000000000A7 },
    { 0x5D4E632797305A15,0xC7EC1D218F7303B3,0xEAFF8ADDB6B09BCE,0x39720C7F43D687EF,0xF21D6C62AC95187C,0x553C51898C3C729B,0xBAFBB841C326EDF5,0xF73F6266A0F40374,0x00000000000000AF }
  },
  { /* Point #15 */
    { 0xC54C480D6F4C3A2E,0x435A138A78DAB943,0x01247B789114AD8B,0x36F66362243444EF,0xCF660D89186991DD,0x555D9533C98ECD0B,0x0CFEC2F11765E5F3,0xBE497E2EB1C05B17,0x0000000000000183 },
    { 0x7A675DA528E30114,0x8384708CD3E1B478,0x8D050AC04ED0866C,0x6B5CD7FBD3F603AA,0xF6F415924DC04C2C,0x1D51AC3AB2C5281F,0xEEC53331FECA6930,0x163CC738EEE82216,0x0000000000000151 }
  }
 },
 { /* Table #28 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xC2D7EAA1C6884CE1,0xD7B35C4F9FAF6322,0x8D1A1D85337EA884,0xBCC6A8090F946EBE,0x45EAB172754FB8D2,0x1E0B251E91DBD926,0x4B61112AFDCE8503,0x80737C4915FA4759,0x000000000000000A },
    { 0x1973C88B40260E22,0x83078CB7E48DCA69,0x4815D67FB199E3EB,0xF57BDE1F7B4DE5D3,0x88A1EBB5E139DC10,0x7C20E7C66689DD21,0x40CBA34680884875,0x5C82140239171E05,0x0000000000000062 }
  },
  { /* Point #2 */
    { 0x922F12DD4E187FFF,0x5EDC9B962FAA9F8A,0xB7C218F8C854C83D,0x3DFCBF3265052D62,0xBD809261053D38C2,0xF871B4BE31D0C279,0x6DB21156F30B4A34,0xB50605148DB71E6A,0x00000000000000D9 },
    { 0xA08CE4A86BEDC91D,0xDF89CAC0A0BAE827,0xC035A514AA3F520F,0xD5E9631FDA672398,0x8A5C34867150A93D,0xE176D6C30D1A66E5,0x1AEBD73874A2379C,0x42D11FE6279C3EB9,0x0000000000000139 }
  },
  { /* Point #3 */
    { 0xF2937EDECB4C6645,0x1E8DDA6D1B68F3AE,0x25A8CBCA5C45EAE7,0x6F07C48EB1A328E4,0x473A67ACEF4B3917,0x5E4EEAC1208C0836,0xCA67351BEC92F538,0x34A8F9F8177CF537,0x000000000000015A },
    { 0x7D7F6D7AB9A3216B,0xA4AD0BAB0ED36D7F,0xD58507F3D4B646CD,0xBD275213A2950840,0x00F031C076C25F08,0x300E0A0C3F46258D,0x6CE16CD6A03DFBD7,0x35E0211D40C879F4,0x0000000000000001 }
  },
  { /* Point #4 */
    { 0xA033349762383E65,0x4F94F82B681092C0,0x583B450378A19CA7,0x81C69ED050E7EA14,0xBDE43E882042E0A5,0x752A9D3E6A9F7938,0x865464D9AF321417,0x5BCC326FB5794804,0x000000000000000A },
    { 0x7714AFCAB958F657,0x3B927DB46E725914,0x9EF1925C7FD9A9D8,0xED13FDFDBE7E139E,0x5B57AA066E80A43F,0xC9C221BE810F9412,0xE6536F3A04EC7D73,0x77765DB5DB4D13E7,0x000000000000019B }
  },
  { /* Point #5 */
    { 0x21FE770F84924113,0x2C5D06120AB300CB,0xE1699E81ED6C7197,0xDEC38F45F5948795,0x79DB54B83A48DA6C,0x95F9D633B3F3AF61,0x3E4E733DA772F809,0x48DBE53A605E477F,0x0000000000000142 },
    { 0x5AB3454E86F2714F,0x87D83DE7939B3218,0xB980FBC096D16FF0,0xBA3CFAADDD96A283,0xED41324416C3B69F,0x57968830968C773E,0xF315B38CED4D4DFA,0xA013ACC5A24CFB0F,0x00000000000000CA }
  },
  { /* Point #6 */
    { 0xD064803E24E3C650,0xA90109303B9AEC0E,0x407B393219F6F56C,0x045D7E95D143BE9B,0x2933B6BE47A9533B,0x01B01EC62BC7F731,0x723ABD9A043E4C5D,0xCD8A1BFD25C4E8AF,0x0000000000000095 },
    { 0xD719EDED6D8A2F90,0x08B7C6AF8B5C2378,0x027C6CB7C01DF5DF,0x1C020CE0155CBCE9,0xC3AEED933DEB94D9,0x2CAE43C7A6F7FEE3,0x54637A4A7512EF37,0x3B64366081582BD4,0x00000000000001E8 }
  },
  { /* Point #7 */
    { 0xC6D7698F7E59DDE8,0xB1AB83AC08AAB860,0xE1972059C7FCAC6B,0xDE4446AE656119BD,0x8DFBBEDEF9F8D976,0xE3B8E6D2009BE348,0xA8EAD6EE974CB79F,0x4A566503B7A415BF,0x0000000000000002 },
    { 0xD661701B24C0D839,0x6A3200D111C338CB,0x5016BA3237F3769B,0xF4396987A00F1D08,0x16ABF9062ADD49AE,0x17DC53E804F3DBD4,0x9EE15F5354A44690,0xAAA77F7EA27E4C96,0x00000000000000BF }
  },
  { /* Point #8 */
    { 0x86DD8F04DEF62F7A,0x42CD01B9CC9E5065,0xD50B855643275C45,0x404E04A59814155E,0xF7E62F98266B665E,0xD68E806E86EEDC55,0xB23E4BF34332001B,0xE0B405B2366D78C2,0x0000000000000150 },
    { 0x6E4C1160D49D6C3B,0x10C209647CE72D17,0x0C0BA5325475D05D,0x77D8DC831523A4F9,0xB053A8BE5693CDC6,0x5E0897A3E947E953,0xDE13F4517899D5D6,0xBAFCA001CA78C763,0x0000000000000013 }
  },
  { /* Point #9 */
    { 0x668D132F5602A1B0,0xBC4A769FEF7A02A1,0xE67A3B7A4126A867,0x6BCB37D5A775D18F,0x719B93EF11901E4B,0x3AAA34D531F7386A,0x7F81F95156335BB0,0x22CE53AA1D9A8FB5,0x00000000000001BF },
    { 0xB901F8B5580D76D3,0x9AE57D49A4D6E345,0xF7AF2DEE4E5B689D,0x5D79160110E321E9,0x43F66981301F6090,0x8835A85F23C4F0CC,0xDAB2DE3B083B5B68,0x7FC613F51E97C0FA,0x0000000000000051 }
  },
  { /* Point #10 */
    { 0x9655CAC34D110319,0xF55E56D996E35209,0x6F375EC27C15D50E,0x2D38334326E468FF,0x943096D75C103732,0x4B30C0D40B0E523A,0x4169DA7CED307FCC,0x5C1E47E9DA5DA806,0x0000000000000158 },
    { 0xAF9EA9B5700E6489,0x05D34FDBB2F6BFC8,0x3B2DC12594068BD4,0xB568253751B3F965,0xC1A3271E109FF65A,0x79FFAE0E4B377BA6,0x5E0149CEDBFB4A77,0xDFDB05A969F94A1E,0x0000000000000143 }
  },
  { /* Point #11 */
    { 0x98CFFE72A8E16494,0x990DCDEF990F6AE5,0x2FFE758F7718E6AC,0x08FFFE7F94B86A5A,0x29EC8E3824F249EC,0x1115CF1E702E2EFC,0x42D3B998AC7863BC,0x9DE49C4BA8469112,0x00000000000001B3 },
    { 0x23C141D47F0F461A,0xD622EBB51A75EA51,0x671DAC9B98084EF2,0x930FC09D8FBE7D8A,0xB8EF755E8FA1E70E,0xFE65E8A389920CF0,0xE79B849E876F0425,0x1C6BA4DF46C016E1,0x0000000000000130 }
  },
  { /* Point #12 */
    { 0xE8F06C2F869DB704,0x1225FE8E1BE3A442,0xE40E87FDF139548A,0xAFFF68201A7DFD4D,0x883CBB604489813B,0x21F07A4520C07C1F,0x037847DD761BFEB8,0x2879D201FE9D73F3,0x0000000000000098 },
    { 0xCC3E104798FD5063,0x9E3888796F0C1179,0x6F8E0CA8F2E65336,0x51D688EDAF342355,0xFEF444C177E831AE,0x34B47F9F18ABF899,0x4F7C42ECF9D15D64,0xFE977F078747BA4B,0x00000000000000B8 }
  },
  { /* Point #13 */
    { 0x1D7948E7E31A2875,0x305E549D55F21221,0xAF6D2FC5EBBF39FF,0xEABB12C80FFED2FE,0xAF421CD07B32D227,0xF8226502A9BEC07C,0x065359AC149EF0F7,0x9E5E784E4F1CBCE5,0x0000000000000027 },
    { 0xE64BDF95E8995641,0x4F00AC4C4E803ED5,0x04AC0DEC6B51176B,0x6DE249642C3FE476,0xF765F2240DFD1E8D,0xDAE016D744709CC0,0xDCAA2F3B8EE0B68C,0xAE531C980B6BDAA5,0x0000000000000192 }
  },
  { /* Point #14 */
    { 0x586D8BE345624DF6,0xC58CA225DE489AC4,0x2131279186184B44,0x1BACFFB7566E654F,0x795C06EE841818E5,0xEA81A1F7A64FC54E,0x4202BA3B7BED4199,0xE8E7EEB7FE735C4A,0x0000000000000195 },
    { 0x3C3260519C58B094,0xD321218C31DDA195,0x2BF7A3196E707D92,0xCDE93CDBD88F1AD2,0x80B6B9F4CEAFC8A2,0x8DDEF6D7EDD98905,0x999D8539CE356FBA,0x57048EDFFB834C3D,0x00000000000001D2 }
  },
  { /* Point #15 */
    { 0xB4C8A95F54F6C3C2,0x75CB6585B4BB79EE,0x42ACF9813AF10B62,0x390E90F9B1FBE61E,0x8B38992A73C905DB,0xEB8EEAA4B2772547,0x50F226739FB26D56,0xA7FD3621BC8FF539,0x00000000000001FD },
    { 0x9F5F71C047CB14E9,0x57EFDE78A4EEA6F5,0xFFDCCE979720279A,0xF2602F0C42407354,0xC32E952E4F8047B7,0x6BEF44FB120EA438,0x64D8E221D5EC1B83,0xD99027B78EF102A3,0x000000000000003B }
  }
 },
 { /* Table #29 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x8002B6D63DCA9409,0xD31714C1163B8124,0xCA655B42720A124A,0x88388DBE9596636B,0xA321822DC0B7DC61,0xCDD952C85824E60F,0x79FF44366CB4916A,0xA115847E5F88DAB8,0x0000000000000009 },
    { 0x1EAF3D400AED0C43,0x7A7196F7EA2A20A4,0x4312341497781948,0x856126D0E88D93FC,0x96DAC31FD5710224,0xC23548F5243E6395,0xF351DF8B9613A79E,0x0DAE5D50626FB1FD,0x00000000000000E2 }
  },
  { /* Point #2 */
    { 0x0FD02A81C0326CDA,0xB52279AC0E5CF6E9,0xD0E8F1CF682AD865,0x01EB99642E847BE3,0x30468F94689BAA91,0xA466FA2BB4584D20,0x99847F1B327C510F,0x206BD41D26E6F2C0,0x000000000000010B },
    { 0x8A04FD93BA3011F2,0x14C757B9AF6C7E86,0x4987100779ECBE33,0xEDF33E226185A74F,0x35AD7383D4A03368,0xEB5A269ECE6EFD32,0xC83C5FB3208FBF53,0x35030BB2702BB900,0x00000000000001DE }
  },
  { /* Point #3 */
    { 0xA59D74FD4AE20507,0x46D0ADBAA86A468C,0xC004C36B0DF04371,0xA0F3CAD9C6138633,0xFE2133C1EEB5863D,0x0EF5DC4884041AA3,0xBC3F0E491707F418,0x3677E9EBDD7CDF90,0x0000000000000178 },
    { 0x454656623A62115F,0x4985E0A08192FA59,0xABD64EEC2AE07A9F,0xE0E94A6D9182D301,0x5230272BB543C76B,0xB7A9F6CE5B5B137B,0x45903DEC3E7B2872,0xADE6111744296989,0x000000000000001C }
  },
  { /* Point #4 */
    { 0x809DC9EC3ECC9997,0x005BCAB58CF9605C,0xFC78790EAA1B4ED6,0x6D80A56D687F88A6,0xB7640965AB9C0398,0x61FBD11CFEDA1C18,0xDF0FB213831177F2,0x39E15BFE11A2D00A,0x0000000000000049 },
    { 0x05D1B9CEC407557A,0x0FA7F405FFE62203,0x0267252D7EFA3C26,0x445C8ADDA59468E2,0x205A0236CD1DDA49,0x3A2196F39F2BCBC8,0x9C1158D8CD2760D0,0x1AD9A2F4E806ABF2,0x0000000000000044 }
  },
  { /* Point #5 */
    { 0xF59B124B6AF9B798,0xBD11629A63CD2C15,0x0A7AB101D983900E,0x5A2F69C42672749B,0xED86B43A056680B8,0x7F28BEFE9D645453,0xB3D22D3236CAE0EC,0xC90AE504E9411471,0x00000000000000C8 },
    { 0x799B139B6E0FA123,0x35BD878506C5C4F6,0xA68161B2E151A5C6,0xDA895823E3FE9E5C,0x19BBDC857A71156E,0x60ABEA42CBCE30A5,0x395D0F51847094F9,0x98AA3EBDD2DC77B0,0x0000000000000078 }
  },
  { /* Point #6 */
    { 0x05B67DF62EB24D1D,0x25B4A127A67A4839,0x4FAAAF762BD78D72,0x2B8184A62652099D,0x06671A2E5179CA55,0xEC46447D268EE9AE,0x4A4CFD497B542F3F,0xBCA419FB16D380B4,0x0000000000000183 },
    { 0x181D80939E43A49B,0xB3A7222ACF8E6143,0x7EFD951EF187C1E6,0xA5A9B13F354C9D43,0xEEF45CB65FFADA84,0x1E3FBCE1AA32FA79,0x557FAD895808DC84,0xC6FD2432FDDF05F7,0x00000000000000CF }
  },
  { /* Point #7 */
    { 0x05A0C8F0F2C1A41E,0x3FA3563C47B45835,0x7D5464C65F941BE6,0xC8BA4C91EA901ACF,0x69AAC7762C5F3773,0x1DDE0221C04113A8,0xE6BA3AC8E105A742,0x60CEFE06CA196F6E,0x000000000000008F },
    { 0x69A777CC3A53B281,0x1BE97838FAB69CD1,0x6605957AC254B5AF,0x22816501304E8FB0,0xCE4234EA9EC4F2A2,0xBD92A83A86C21C2D,0x953E1E7333CCCBE1,0x6E25C079BB3DCD75,0x0000000000000165 }
  },
  { /* Point #8 */
    { 0x97F22A4110C355DC,0x550F2515BF8056BA,0x253C72A37EF07316,0x0F1F8CD585B059A3,0x8D432E48A7E4D4A3,0xCDF3981D7B2C78CF,0x15D98F56DFD71053,0xC95ECB64949930D5,0x0000000000000195 },
    { 0xD5E23BCD4B7D613E,0x8603F848F66ECEBE,0xE2CFAEF127A24540,0xD35BBA9B2E9E7EAE,0xB7F17D307F8C1BD4,0x901506C4E0AB51A6,0x3E0D62A390755F2B,0x8DB637DD3C553544,0x00000000000000C1 }
  },
  { /* Point #9 */
    { 0x05CD83FD20B99AF6,0xBDCD754B974681AE,0x5C4953477028F353,0xB1D1419BB2F2740A,0xC8792B3D8F237AC6,0x4DBEC931DE2C12D3,0x60D09F180434E145,0x1A8C3FF54538A2FB,0x0000000000000137 },
    { 0x8663671129BBEBCB,0xFB0F179EAD5876CC,0xB8937EFEC4065634,0x66EE1B1D47B0D99A,0x5EBC7465728C212C,0x4B3A10E2198B7103,0xE5FAD5FDE93AE584,0xABBD695A6618DB3C,0x0000000000000098 }
  },
  { /* Point #10 */
    { 0x625C34C2F07EB2A6,0xD34CE0CD04700CAB,0x5D914B138AB0BB84,0x890CD448426FF248,0x4F39E76D56F4B6E4,0xC37239019A908817,0xF00E818E1DA338AE,0xE5931B47F8B6DF89,0x0000000000000020 },
    { 0xB4DB6FBF1B058397,0x6404F173B88A04EE,0x0C634FB857E9517E,0xAE5249474088EDB9,0x640C98C3400DA096,0x08453524E2BA01AB,0x31FC033FDC6871CC,0x43B1F08650EACDE4,0x000000000000016A }
  },
  { /* Point #11 */
    { 0xC7BC11872C112FED,0x17B1A92AC3376170,0x87973E98535224A0,0x1FF01E0B6994F23C,0xD5D68D4ED4D607C4,0xE717DBF00A48261C,0x8A17DF7B3516EFE0,0x6E1AABB441F34E03,0x000000000000013F },
    { 0x0D4F0E076C8649B8,0x649F17D42266F551,0xF0FA5CFC084802EA,0x11AD2E576C781394,0xB2A516B705959BD0,0x674F8F5C20D6928A,0x9CE0C654D4A16C92,0xB6764697E61621D9,0x00000000000000C6 }
  },
  { /* Point #12 */
    { 0xAFF87698ADB6EF02,0xF18B0C623D21493E,0x79980140AEEDECCF,0xA40B3354218C2DE7,0x02EF70CFB59CB843,0x97D72937E02EABAF,0xFEAA6D577A83076A,0x9E3F9060BE269C47,0x000000000000017D },
    { 0x71025502DD27A0C6,0xDB1F4ABAD1268D8C,0x72EEF8831ED93044,0xEA3B9FCE507ADD0C,0xA6FF5F69A2F238CB,0xF525DCA3B3ADF0E0,0xF6A371DF0821AE0C,0xAD2EA6866CDAA453,0x000000000000010F }
  },
  { /* Point #13 */
    { 0x43BF37E7ECAD34CC,0x04C08D7AC81F0B30,0x9815FA20ED05109C,0x754EC53C6F0B3BF3,0x07C32325F98B5F37,0xCE1E98E0F9FDA3B6,0x695B93824BCB0A5A,0x900871DFE44EEE79,0x00000000000000BD },
    { 0x66E8ECAF96580E55,0x51520DAFE9BAF9C3,0xF615049E57B57C92,0x58C572D8A0424801,0x57A6484C3CE94AB7,0x97178C7460DFD054,0xC475D4D222870F6B,0xDC0D2DB302FC18EF,0x000000000000006F }
  },
  { /* Point #14 */
    { 0x771D2A80B55B6439,0xAFACA3EBBD37CE99,0x795574C04C2BC344,0x061975461FB581E6,0x332DD39176823CF9,0x0A90A8280E2A47AB,0xE955528E6479A81F,0x0A7EA6FA76432711,0x0000000000000078 },
    { 0x26BD504BEDEBBA00,0x493E1C37DF569008,0xD7620B599651BF88,0x4B9597442092209D,0xA119833547A5753E,0x988EBC2031CE62B8,0x85491D1550D40870,0x02B221BD84313D16,0x000000000000001C }
  },
  { /* Point #15 */
    { 0x793D5F809C3C1FB1,0x58B89EDAB68D257B,0xC5383EF921DC6BF0,0xC83AAC4D00435D2A,0xB35CFC1BB5AEA595,0x9D6C2C0070838563,0xADFF5AE51FE85CB4,0xC2CDA6938B06345C,0x0000000000000118 },
    { 0x1989E565B46AB052,0x8F4F82249E86BC51,0xE217463D3C4419F1,0xCFBE537160995040,0xDDD7BF98EA9A6346,0x1F0DC935CF58E474,0x4093262DF788B692,0x603D556E4CDCDEFB,0x0000000000000053 }
  }
 },
 { /* Table #30 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x9EBD0A79E09D583B,0x8890CEB33F312038,0x254FF069FE1C7D97,0xCD82A50A3825DCB4,0x065BF2F94C37CDE0,0x59B7C4E2A7B458E7,0xACE6716E7D105C29,0x84D999349F26170E,0x0000000000000107 },
    { 0xDCA7480BFAADA7A3,0x203303D30D4FB693,0x0EC1C4D2B9EF7822,0x2B97216D594552EA,0xB93E533EB59C5490,0x50D31AD60D6C3787,0x0F1014D65CB84476,0x0523796C02B816AD,0x00000000000001FA }
  },
  { /* Point #2 */
    { 0x186535555B9BBE35,0xE67D27E0E3D2342C,0x06C2F1F39775EEEF,0x1D98DAE9E778D2DD,0xD04AE2693D8C8E86,0xC49C1B77D8C7FF3C,0x33C474C9DFF1687E,0x4B0397567350001A,0x00000000000001D5 },
    { 0x3A01B07DFE70659C,0xE8BB7A25EC01B5D1,0x42F9B07D713A5BF0,0x9C1F15CF370D1490,0xD2804385895C898B,0x72905D530194561F,0xF467F9E0828CE8B5,0x54D2132D53E3859F,0x0000000000000183 }
  },
  { /* Point #3 */
    { 0x7E4FC745603F4F62,0x300E74342F0EB97D,0x0E64A63411BE4195,0x6C160B9D52B038E7,0x4D130D75A62D7FB8,0x83B6412B23B6BF71,0xE92B5B0719D0A2D2,0xF547F666FE79AA1B,0x00000000000001DB },
    { 0x609495E1A1364F6B,0xC196A1C69DE725E5,0x24E0C338051A1989,0x5B24ECC17132B77C,0xC38889537D5F2440,0x847186D0DDFFD474,0x0EA28F9C643C84F9,0xAC9296CA4CDFCC12,0x0000000000000151 }
  },
  { /* Point #4 */
    { 0x62E30F146B33442D,0xDE4D2E1042123A0A,0xA1E5E2DDA59B4649,0x2B6AA7D5DFA5D292,0x83F0033E00C25B90,0x2E6143261D598A8F,0xA5AA5A26DF8943FA,0x7459318AD4FB7104,0x00000000000001A7 },
    { 0x53ED625BD67084D6,0x47A2D5950D232F5D,0x593A7030F8863270,0x3E87B5AB993051E2,0x02E51486CA5387C6,0x7612F0C7A818DE0F,0x32D26729B42F317F,0x48A9B12FB9A3C2F4,0x00000000000001DD }
  },
  { /* Point #5 */
    { 0x60B11099CC0AE72B,0x51CF7973D3588531,0x62AEA2EE1F018F3E,0xCEAEC7A028E42557,0x695F7CCE52DF0599,0xF22825452A1B3F00,0x8C2DF32E6394DE22,0x18CE083E2DB1770F,0x0000000000000088 },
    { 0x7989F8BF4BA02F8F,0x22FC813FB69BD72B,0xF4EEFA600A383C73,0xD7AA3E7E6DBF9F7D,0x98113DB2D2D50A4D,0x47E078B14D81782D,0xEF4CEA6327DF6ACE,0xF720012F577EEFC9,0x00000000000001C9 }
  },
  { /* Point #6 */
    { 0x45FF6CFFE1A83401,0x7B9B4EED54A79E2A,0x979B1475933BB48A,0x135E2594634D7EC6,0xC08BA7B4D5DCCBBE,0x78FCE165C3826372,0xB1F172E431102CDE,0xB6FD8F343EBA4396,0x000000000000000B },
    { 0xF7D351A9B4F622A3,0x80215FC752AF1195,0x967F5F190E0E3C73,0x4E05F75F9F80960B,0x76C30E858EEB6E11,0x9F270D1556A7ACB6,0x9236E11764FFF770,0x80C87737E474EA10,0x00000000000001CF }
  },
  { /* Point #7 */
    { 0xD3C4E96B03D54C5E,0x962EF31F65450BA4,0x4A75AEB64DD512C0,0x4C4D23AA233D2675,0x42CFC07C0055293F,0xBBFF60C5242A0317,0x3F27D5C95C4F2C32,0xCA352C57746505B8,0x0000000000000080 },
    { 0x5751EECA92A1EF30,0xB83A993E1F9EEE84,0x5EEC2ED72E0AC56F,0x95AD825BCC0D1E16,0xD3AA7BA68AF2A112,0x3035C3F8C7EF1FCA,0x5B5BF3E55216A429,0xDF187DDD0FCB5720,0x0000000000000025 }
  },
  { /* Point #8 */
    { 0xA549238EB310BEA8,0xB542445A99BB8AB7,0xA930BD6A8C208B86,0x1B97C831168AF442,0x18D4FC46A291BFFE,0x1D202D44A6B461AE,0x433DD2D7C57C66FB,0xF21B5D1D2A79F133,0x000000000000001B },
    { 0x99343AA32EE37543,0x904B8DCD7EFF1BD4,0x4E1B01FA9711AB88,0xF8111AC33AF62C90,0x59CCFEA158910F9A,0xF4D713A358E5F398,0x6CBBD15FB9C12355,0x6181D1C0C3F59372,0x0000000000000170 }
  },
  { /* Point #9 */
    { 0x64F8EC4C94DBCEF0,0xC97A5FE1D006D598,0x7CC416B15FEE99BA,0x5E76561A698113AC,0xC81C6079FFA11AF2,0xC04B5048CDAEE971,0xA79EC707C46BB0B7,0x20AEDD0F45F1CFD3,0x0000000000000189 },
    { 0x678E01FDF1AA0926,0xF6794950809BE2EB,0x9420AA4B9F89E63E,0x80440A43F8BE307B,0x5F745612DABBB2E6,0xC68EA3C278A61DF1,0x37C8C2F6D67E5C46,0x32CAC5262B38ED94,0x0000000000000008 }
  },
  { /* Point #10 */
    { 0xC2AB59E873ADA2CC,0xBAE59C15CBEC8583,0x91B446ABCF3B6345,0xFF7A1AF20BECB4E3,0xA2BA8E42707DEC53,0x3AD25C5191EE1072,0x50624ACE261414E7,0x52C9513ADFAD31D0,0x0000000000000085 },
    { 0xE08F4EFE933887CD,0x88EF090AE39784AF,0xDF8D631E0D1E77C0,0xA5D3A5292F764F0B,0xD782F2BF2A993C96,0x66BD58533D305512,0xDAA06E5FCAAFA3FC,0xE5EE3AE28E21902B,0x0000000000000189 }
  },
  { /* Point #11 */
    { 0xB191BFC95379208A,0x2A1F2BA91AD2A396,0x8A482274CFF511F3,0x20FB75155B03819F,0xEDC652327FDDE9D5,0xA73B9708F88E8979,0xE0BFE37F5E93F0A2,0xBE3B0EF20F1F13C2,0x0000000000000008 },
    { 0x52CD7F260E0288FD,0x6DC435D7872F25E9,0xFA45BEA70164564D,0xDD4667EB9D109FCD,0x1E23BD77B282D30C,0xB3BB1A7478610E7C,0xF48EE3DFCCEDDA5F,0x2483A44A16942C44,0x0000000000000048 }
  },
  { /* Point #12 */
    { 0xEB1706FFE55D9DC3,0x128F942B47CF0BC8,0x6A5D94A8CC1CEEED,0x8736F0290CA71858,0xC100090DD1FD8B55,0x5970B8829CAA1F54,0xAFE5E74C9266C865,0xFF310A7A2889325F,0x0000000000000005 },
    { 0x4B0A8D9BAE5ED924,0x81E086F41A8D0A30,0x6C209D40190F4957,0xBF69CDA925FD95F5,0x5A7A31A215C6321D,0xC4F9D4E866200541,0xA675123925161F67,0x3134AD6FD5FF9687,0x00000000000001E1 }
  },
  { /* Point #13 */
    { 0x60CE32B9138490FE,0x3195CD4AD2685B04,0x0E36B35E239110A6,0x63129C87D4740967,0x994570FADC6D3F99,0x8EDAE6940031CAB0,0x504B1B8F7AF36802,0x5CFD2BDAC466FEC6,0x00000000000000C8 },
    { 0xD5DD304E703DE0C0,0xE7E0F651DF8244D0,0xC5BF943C240569CE,0xA100EDA82824E162,0xB7B7B3B63DDA41F9,0x48F90DD91E5455A9,0x8C821E2A7B1DE463,0xE653F0674EDE44E9,0x00000000000001EB }
  },
  { /* Point #14 */
    { 0xBC008F6F12853216,0x4BF12CE42B48C455,0x54FF9BD2FBAFA90A,0x5FE9E7E641840F1F,0x042DCB9C65E15455,0xCFD8E3CB4C57C3F3,0x4C57920AFCC0E297,0xB4CDC9ADEDD993D0,0x000000000000009C },
    { 0x6B6EE23C382E05C0,0x17F4B2C3B8821ACF,0x48517AA5B5DB9EA8,0xA86C1F52C23154E4,0x5C13F1540F4D1D9D,0x83E69E90E13257A3,0x4CFD01F2E6B1BD31,0x04610D106F53C1D4,0x00000000000000D2 }
  },
  { /* Point #15 */
    { 0xD498BB74E6CF516E,0x5142E4D31D808796,0xA5E120B141CF0189,0x50B0208B41823038,0x290DDA83ECA548F7,0x3617A82941BD5A4C,0x3EE40E94717CABCC,0x7801F6AA97F09B10,0x0000000000000175 },
    { 0x00BC1F19E1E5636C,0x3EE1B2A1790ABE39,0x423DCD56B6935099,0x951FB17EB8189D05,0x2086426183D235D9,0x1D060A7799ABD480,0x393B00F9871477E4,0x3D751BF09A968951,0x00000000000001E3 }
  }
 },
 { /* Table #31 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x0BC2FC66A6A08EDB,0x4F83DBE481D46942,0xDD379BC14E44B819,0x6F409F1AB5785CC1,0x3FAC6DDA40232DA3,0x83B4BFDC11B9BC84,0x4563149AC91E3874,0x210062C6F562966F,0x0000000000000126 },
    { 0x6A00191E9548D9C4,0x800F66BCD9716285,0x3A8C05A315DD9859,0xAF6DCDF5AC571627,0xEAE07417006A2A90,0x11B368FBFCB7C955,0x5E47618FC4ABE2B7,0x328F44C85AB9DD68,0x000000000000015D }
  },
  { /* Point #2 */
    { 0x7AC007AD8451AD30,0xADB09D590905B6A7,0x96B382333ED8D9DB,0x7BA1AB90144AAAAA,0x2D31FB344ABAE176,0xC0471119D1D9CB6C,0xE56B681221C9FE02,0xFD040D70EFBD1643,0x000000000000009E },
    { 0x91C517C02975AF75,0x7A77C8F2834DE3AD,0x7DFD1527C6E95530,0x982A2EEF0EA03560,0xC340FE70C7E0205D,0x302CA446735BC119,0xCC1072285C271F62,0x9BA4E55BC486FBDA,0x000000000000006F }
  },
  { /* Point #3 */
    { 0x1EA6A1B66C2569C9,0x0B13D3160B8D26FA,0x68C05F76723A1780,0x5131968D4877E102,0x6E187E84B306C24E,0xC81932552633A205,0x9B4C373E55B73112,0x14255743D25ED330,0x00000000000000F9 },
    { 0x2B48DB011AAA611D,0x4D70FE3D1D2BF0A9,0x81659E9143546512,0xF846864F68A7CDEF,0x4F7836B0988A5592,0x8E2DF580943B6365,0xD93315F8585BF2D4,0x6D04F86B8FB166BE,0x0000000000000049 }
  },
  { /* Point #4 */
    { 0x6A00D57DA5E6776F,0x8A138DA8DBD9BD8F,0xA059ED07D5FDDAA1,0x4F6122D91A42E212,0xE72E39C509D704DF,0x025696A8F15340DD,0xE75FA17DB760BAFD,0x1B7950B1017F537B,0x0000000000000109 },
    { 0x1E1AF3BD3F72EC2F,0x0B95F25A8DF112A2,0x6F3E98AEC4B96EA1,0x5B890EECF3DDF2C6,0xB4E902C3D1B40C40,0x331CEF2678E129B2,0xDF376CFCA4F572DE,0x9299466AAD414479,0x0000000000000103 }
  },
  { /* Point #5 */
    { 0x561F1FC0BD779498,0xE893E206DA32023B,0x09B1D8C0325E13F2,0xA3CB2AAB2349FD6F,0xA9118E964CC4096A,0xF38D1FDF4B1919A9,0x97F159F92A987A53,0x312FBD5E8C44C5E0,0x0000000000000095 },
    { 0xAB2BD7D1E5DCAB70,0xF40AF5E24FDDCD69,0x1CD24613EB621752,0x88FA2A350A878ED0,0xA32EB7987196530F,0xE65D4AD68006FCFD,0x21F3AECCD212B2A6,0x727667E41ADC0F2E,0x0000000000000179 }
  },
  { /* Point #6 */
    { 0xB6EE4B5B6962FCB0,0x108152446AA973CD,0x30FA7D1D481AD453,0xA886B2111E331373,0x0EE2493189CCF318,0x68EAF3A92AAAE84D,0xAD7B1884A632235D,0xD558610ED4184BDB,0x00000000000001FB },
    { 0xA0DDA2AF08A5DE2F,0x18A6164DD8FCC9E6,0x829796153B27FA80,0x888661DD8500C885,0x096F4643B12957B7,0x5FCCE7065099442F,0x7462977B557E597A,0xAF8E13BA42F41666,0x0000000000000168 }
  },
  { /* Point #7 */
    { 0x89E56BADE1B0FC29,0xA0A84C4488FEEEAF,0x3AADF31ABE076BC9,0x8DAAE2E8D6D07B9F,0x9EC902C9481832E3,0xFD27F0D4EEBA640A,0x6E18C2D97799BF38,0x32D3303F34D572B6,0x000000000000017B },
    { 0x53C93CD19D4EBC77,0x26F25E8D0648BB52,0x01B7C33CE62DC715,0x38B3F6C3DEC92CBC,0x79298A06DF7561BD,0x3677B3C98591EB32,0x85AA47AF8EDA9409,0x8BE6F81064D8F03B,0x00000000000000B4 }
  },
  { /* Point #8 */
    { 0x36252C7BD5A6EAC2,0xE218A649CAE5DC4C,0x690F3B49B249829E,0x4858D6576E5A7464,0x6E4B2CA633AE77E0,0x28CFD8BA871586AD,0xAADAABC9D63D4D38,0x2EA000E98ACDD480,0x0000000000000043 },
    { 0xBB0525EEAA905E22,0xD6AD676EA045363F,0xA0ABE10EADBB3A6D,0xBF7D435A49793FAC,0xD96B7452C4DD6260,0x4E64C9930AA813F9,0xAC364502001A15EC,0xC33EFEF71AF6493A,0x00000000000000EE }
  },
  { /* Point #9 */
    { 0xCF5C8731B7339C17,0xE0C3FFF77C0AA23C,0xE115BAEAC21C0008,0x50198CB73FF150B8,0xE7714E6FAC2399F9,0xE0865C310F553F1E,0x7241A2F1A40936C9,0x4BFAD58CB2ABF5B4,0x000000000000003E },
    { 0xA21F9AD2AACB8C68,0x96BA35E4CA96DC74,0xD2F0391305461B06,0xE9F0A8AE1C307DBF,0x71502C8C1500FF88,0xF65D5D6CE43D7F44,0xDBC273E138CCB8A2,0x8041B039E6FDDCBF,0x00000000000001DF }
  },
  { /* Point #10 */
    { 0x079B543E67FB89AA,0xFA2C1CA4FF1C7C3D,0x1D06DBE331C07D0C,0x929B4A633E25E43F,0x510FE4625BB5D7CA,0x222E0E1959EB8F15,0x118C8A1591BDF356,0xF42DC53D4FDD557D,0x00000000000000C6 },
    { 0x14525DD959D74B55,0xD59851764DD98894,0x0FA25C3C8B61E4D0,0xA43C3E74C4009655,0xD2EA4C228E723C18,0x1BB2549A7D9FF858,0x5BDB3C8BEF00C128,0x8D7597D6742F9874,0x00000000000001A6 }
  },
  { /* Point #11 */
    { 0x2159490461411AF9,0xFB00D8421B35BB28,0xEDA1CD04852730A8,0xDF83DC5AE968B102,0x27AA898DB1557986,0xF66AAEC7C095CA40,0x74784FA993AA006A,0x353E9FDF5C87DFD3,0x000000000000006A },
    { 0x0B61D1940E9AA922,0x5676C16B910BC3DD,0x71FC595008B3E89C,0x5D00DB3B652D58CB,0xCC21A43688648CE1,0xCCF48970F9727719,0x46C1C2B4582A7294,0x5950415CBA582061,0x00000000000000C6 }
  },
  { /* Point #12 */
    { 0x4AC52CC0248119EE,0x69C12FE2732CF0C4,0x4ED67C2A560E7AC4,0x82F29F7E79346BA1,0x47607B94F488C23B,0xB39BFF863DBB4817,0x91DE351665116670,0xAFD0CE8FA77373F0,0x00000000000000D3 },
    { 0x9D96404BC2A1911E,0xA43A089A21382683,0xF16276E883E13D93,0x581897D09FE988EE,0x3AD0DD8B998D0F46,0x078F1A9BB6143261,0x303D457410D18924,0x0BC45E0C82A9A0A6,0x0000000000000076 }
  },
  { /* Point #13 */
    { 0x160ED3D65AA10AD7,0xBE7FB7B97D43A5C2,0x9E392618B748CCFE,0xFF20673623DCAB0E,0x390A2C23DFD04809,0xAF5B3DABE090EBAC,0xF44B95F088CE39AB,0x7108B516F8A1C089,0x000000000000009A },
    { 0x97C63E023DE0EAFB,0x6A40DC29B24DC6A4,0xD6BBD487076CD3B6,0x57998BFC439A7138,0x9314D3033C901BD9,0xC7BA921187CF690E,0x153F41DF76ADFCB1,0x2C275B242C771CAD,0x00000000000001C6 }
  },
  { /* Point #14 */
    { 0x4D5A30632E7633C7,0x98D85ECF65B23454,0x6FAF2BC5B703C6BF,0xA9F958E8E857B00C,0x737F7E4CCB3D103D,0xA6B8224656DA7861,0xDDE8292F762F2D5C,0xA96197EDFD189E65,0x00000000000001FC },
    { 0xB17985934E6BC295,0xE40EAB455C947718,0xC53A5B974C4D7639,0xE150FD8A6FA93C61,0xD82DA059CF96DD42,0xBC2CE6BE074D62D4,0x1928A9CFE26D0B48,0x08C0D5B8CFAE90BB,0x0000000000000039 }
  },
  { /* Point #15 */
    { 0x98CA2B7BEFF99A56,0x32D91F1A12665587,0xCA37A76A2426C7E2,0x8A50202A2E04C569,0x0C9D77B7A62734E6,0xDD643EF152B78BB8,0xFA23CBE41451BFA8,0x40E426F80C38329A,0x0000000000000018 },
    { 0xE50AC47A0788ADB9,0x0A90975AC387D891,0x7DF37F246BEDC141,0x82929F04BEA4D8B0,0x2ECE090EECABABF6,0x220932EFB0C79A56,0xD6B08EF4962E9853,0x86BD48D72D3B87F3,0x00000000000001BD }
  }
 },
 { /* Table #32 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x9AECAE2D6A3CF15F,0xD9D0B49A9C959376,0x4AAD945457CC7E25,0x683618323876FE58,0xCCC6F2D82BD9DC24,0x3970525C605BAFBE,0xF17524EDA2C5499D,0xE30B69D5B0C7BF4F,0x000000000000005F },
    { 0xA71532ADB5D073B0,0x37159FB3B4FB97B3,0x15B655B27A1FFF6D,0x55AC89EE9E08A89C,0x13CFAB6BBC027776,0xA57A7F289DECE9A9,0x65A3D815C03A1D45,0xE5CD61EA95515DBA,0x0000000000000100 }
  },
  { /* Point #2 */
    { 0x64107659D44E9B1C,0xDFE2B3ED599694F3,0x348B163455939FEF,0xEB5FB1860B2F8B7A,0x19D2BECF5A1469B5,0x24C67FF96BEA8F5A,0x1A4037A85924FDE9,0xDD0E9ACEFE0231AE,0x00000000000000F0 },
    { 0x5B3F06A237CEE8E6,0x3CCC49C67E4A80A6,0xE8729CC405B38A1C,0xA51323391F4373F1,0x1DAC8246B3A773F0,0x9824B4980193D5B1,0xB63E677AC4DB540A,0x9C74537F5F10A7C1,0x0000000000000094 }
  },
  { /* Point #3 */
    { 0x21CBB2C74CE9ABD3,0x7F157A4845073C39,0xBC887F720DE2380E,0x295BAD1C6F96A397,0x9BB39BE48FF6DAFF,0x65B52767D80498E3,0x1B07529402B936A0,0x04C89F2FB90EC0FC,0x00000000000000B4 },
    { 0x47F62CE6F3BF4B3D,0xF79921250E3E0BD4,0xE1555BF8A14A6183,0x8169E02567F3936C,0x62DAE8AE846CE4B0,0xCEE40B04FE0B0558,0x520C3E208FE270E1,0xA1F2420EC44DE629,0x0000000000000150 }
  },
  { /* Point #4 */
    { 0xC773FAACBC875BAE,0x5AD3CC9408DC8719,0x23A9CF666FD3DBDE,0xF9C47B69A4C8D8FE,0xAEFDCD39FC6D9E13,0x3647F3A92EF2FFF0,0x7FBF9D741F53EE3C,0x9199963D85E5A502,0x00000000000000EF },
    { 0x191173743AD5B178,0xA5892671F086FDF5,0xA828F5BEAEABB8B1,0xA9C1A33E62711D4B,0xF8A2E9B101E1DE48,0xE5EB2DE9568801DA,0x3E0B7A845F2F8052,0x074D3C36DDB76FFA,0x0000000000000160 }
  },
  { /* Point #5 */
    { 0x3CA5AE614D0A48D1,0x39648CEC7F021444,0x3C92B2521E90C6DD,0x776994BC94A49837,0x53E54C207DDBF5B2,0xFAF593C7D4576141,0x17E000C226CC7AB2,0x9484DE380BF5318A,0x00000000000001C9 },
    { 0x7AA1D4D397546078,0x06B60EE9F1E5FD32,0xCE10BDF08447917D,0x40FD8D610E3DE8AB,0xA3C917AF34E29CC4,0xA7BB1B542C27DE76,0x6992979931E6C453,0xC668FBE42F185B22,0x0000000000000142 }
  },
  { /* Point #6 */
    { 0x953B8CA7AF0603F0,0x4B5ECED77E21E713,0x427652E12864DCA9,0x547F5FB516CBFBB1,0x6AD85C7EF75F17F1,0x469AF7948222107E,0x20D4C8E79BEF1085,0x867D4D0B152552E6,0x0000000000000142 },
    { 0xBB5FFB0CF3F26574,0x047C1BC015CD38C0,0x76C5DBF176F8E575,0xF7EB7B0E20D33C17,0x1E9CC21E6D879E9E,0xEB2EDC8340CA3223,0xB0AA90A8290D165F,0x7C17D3B223C1EF71,0x0000000000000055 }
  },
  { /* Point #7 */
    { 0x80FD3DD3C1E4A87C,0xF2230946E63E847B,0x9D51E3A3477178B7,0x06B089A460B2E4DE,0xF98E4CDC53CCD5F0,0xFABA504AE9E18AEC,0x22B799BE34DBA1CA,0x75409D50A4C9CA6E,0x00000000000000F9 },
    { 0xEC619962617902E1,0xED26BE734C58C299,0x083E94E46D1C30E8,0x2C8F71158BE269BD,0xF7C13EA9E0FED762,0xB6C9BEA0B517E55B,0x7D656933AEB4BEC0,0xF386FED9CA01BF37,0x000000000000007D }
  },
  { /* Point #8 */
    { 0x1036EB9B66FD07CA,0x6CA52CC16B7FB490,0x512E973ED3E0C270,0x889980BF73D92D11,0x38B4CFE4A4005EEA,0xB6F992CC8CEB4313,0xD0AC2F8D6DAF7C23,0x1CCFBF17E32A93CB,0x00000000000000C2 },
    { 0x7BD9D6F12F508CCA,0xE82D7171595A72AF,0x25D0297697512873,0xEFC1DE8B8CF39FBC,0x25E6B77F9A1237F4,0x9F3B73E7D4D98B5D,0xE1FDA62BECCB07FE,0xDB813B03625350CF,0x0000000000000014 }
  },
  { /* Point #9 */
    { 0x2B675AAD33C1333A,0x5B635D5DE3F70BC6,0xDC1B161FCC3993DF,0x3A966F3C07E1C9CB,0xBD684A329FCDEC80,0xD7B51C19F12C7088,0xADFDEFB4F549B4DC,0xE542877B58DB90BF,0x00000000000000C0 },
    { 0xD7A8F7CBF2B37E98,0x0898FEACB303EAA2,0xC40968038AB3EC65,0x178D3F6FD7D2F42F,0xCEB00CD5C31552EB,0x85D9D2B5D878396D,0xC6B51A1F2173B3B9,0x3DE5F48AC997717F,0x000000000000008D }
  },
  { /* Point #10 */
    { 0xFBEFB8C9644F809D,0x5013F5AD50B747FA,0xAB3C8DE1A054A0C4,0x687C5279C608EF1D,0xFD4C40096BDF1F8A,0x49CAA9AB72A4A4A9,0xBBF3951812790B7C,0xE0535999B6373459,0x000000000000007A },
    { 0xA2DCAB70FE2FB036,0xC2AA9AD018B31F0A,0xB5A76E592BE108EF,0x68FF6F12BA3EDE8B,0x6DA7AC98E860842E,0xDBA409B2969F77F7,0x490DD67BF92B2EF0,0xFA837CDE26207A6E,0x0000000000000143 }
  },
  { /* Point #11 */
    { 0xEA856CB6B878C367,0xA9C546214A4FE60C,0x1019FC69ABF32138,0x6C4B6CCD06730992,0x1A311A6D0E41375B,0xF0248235114992A3,0xF41B1B39764B38C8,0xCE60DA46DC105E9E,0x0000000000000114 },
    { 0x6AA1E85BB3994B60,0x71512EA2C86972BB,0x0741F2C4EE618490,0xCA37BB0DA39E9C5F,0xDE4D4610AC5D2A89,0x4F6C0DB09AB5D88C,0x81BC4E8876AC9892,0x69C37CC885406E8B,0x00000000000000D0 }
  },
  { /* Point #12 */
    { 0x2D8061AE51E200C8,0x2ED4BAEACBA53504,0x7A99581D1A816471,0x918011CD8E03B1BD,0xEBF02CE3403BB07B,0xE34FA50B55B600A9,0xC9B864CDBFD6E3CA,0xD321624427EFFE1A,0x00000000000001DD },
    { 0xCFADE4E193849908,0xC0F031BF48A0E903,0x7D2B8B8EBCE49719,0x42D55FF0B518922F,0x1F87D2E3D6FEDAAC,0xD2E6AC95FB5FFDEC,0xFCF0B4B31A3A896A,0x5A3B6CF15070E85B,0x00000000000001D9 }
  },
  { /* Point #13 */
    { 0x84B08FD1B927FAF4,0x236EAE2654FC3722,0x1A7CB9BFF4836CC0,0x251833480DB8508D,0x36A19E7C9D1B8764,0x8EB89180DE352F40,0xCCF372836E1A3EA0,0x3E550C0A0A72C4D4,0x0000000000000136 },
    { 0x8E83AF37F7B2EA82,0x03C78B22395BDBDC,0xC229423FEF042D8E,0xF9EB603D4ED515F9,0x2F56337627176DDC,0x8390B596112AF839,0x617BED410774A6AB,0x52903A20D5F44B62,0x0000000000000014 }
  },
  { /* Point #14 */
    { 0xA5DBA4E1352ECAB9,0x6B02E6822C778ABA,0x2540E2CBCD90027E,0xE9273E1028EF0DF3,0xF06AC93932993C75,0xFF0DD2DD17E95CCB,0x67647A2EDBA0D5A0,0x88AAC34883A00096,0x000000000000017F },
    { 0x5B0503A0A1EDD5C1,0xA3B6B42AD77E1A61,0xFBBC558FB0AC4790,0x6E091B612C98FEA0,0xE9DD74B179D85E44,0x01C6EB8996CB7B14,0x3F220ABA0A79BD88,0xB30988E26365AB82,0x000000000000002C }
  },
  { /* Point #15 */
    { 0xAA272AAAD19D50A1,0x3571D10BB1D206B7,0x13D9FD10C3B75AD4,0xD8DFB50B546DAF84,0xD2B77B3A3A1F736B,0x33725766683F310C,0x5C27D38B9FC3B081,0xD74611BAD1642FF7,0x0000000000000026 },
    { 0xDB5EEE71F30E1C09,0x819FDB72CA6DA656,0x312F0D734CDE6546,0xA45FFDBB7BF7C656,0x3FE1359AF71F5257,0x6EE0EA0AC34E9A29,0x969E2682B1E77C79,0x1E8323864A901CB8,0x00000000000000DA }
  }
 },
 { /* Table #33 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x904F2D4BDF9314E0,0xDAAE850DE7A00AAC,0x79231083582EFB03,0x80F1C283EC7FE6D2,0x2D5B3996199D74A8,0x5F120B9B395007E7,0x30D237734773F03E,0xF4C192733B78B686,0x0000000000000121 },
    { 0xF103FF6DFA8B51F0,0xAE7AFB5140E2BDF0,0x1130380E83254171,0xE83501B8CDA10D95,0x1057771E4F3A8C01,0x8F52196AAC807069,0x3609B0AAA5623821,0x8C25790694A0A7F1,0x00000000000001DB }
  },
  { /* Point #2 */
    { 0xE2445C75CB0284F6,0x7266ED21F0D3B65C,0xA6F7FB639C0CD13A,0x68D77E3537FEE05A,0x1D21EA95DD708C8E,0xC75F44E793BA8D14,0x8BB1876D90E34CA9,0x7A3621E4B70E8CB2,0x00000000000000B8 },
    { 0x0FB7C958E1D0F420,0x34B8BCF2FADB2239,0x1800038B6A67F72C,0xA8E3236AC19F70A9,0xA73DD94CB908C753,0xD7569D95A6FA426F,0x5AB784F60A295AE2,0xDC2BD296583F0F13,0x0000000000000039 }
  },
  { /* Point #3 */
    { 0x361DF1A496CECD8D,0x46A52D2B120E0DA6,0xDAEC319218A399C7,0xE7D7E2F9FE750171,0x2538D1A8E7638892,0x6D93E2130A4BC874,0xABD52586E8063EA0,0x160DA4EFCC23A672,0x000000000000016F },
    { 0x3FB480C9BBE499E8,0x458ABCE1B6A4AD3C,0x852F59F1280A60BD,0xDD52DC069EB3ABE2,0x88C4548511066348,0x0EE8342055A268FB,0x71D8F9FD114A29C0,0x70C5338E8DC08C3B,0x00000000000001BC }
  },
  { /* Point #4 */
    { 0x4624399658603A1E,0xF6BF54496310788D,0x178120864C799CC9,0x20A0D4E63F9C7982,0x13340A26930D81CA,0xB248675461520FA5,0x0E9480CCE3E2CBB0,0x11F633C1C61DD54A,0x000000000000008E },
    { 0x34510E9E07EF7A73,0x242EA6950E00A9DB,0x1A146EA20EAD5B7A,0x52C0A70BF54A3534,0x4B85DBBEB8113E6A,0x62DF74261446FC2B,0x3A79C26EE9FE597A,0x6327CECDA7AFDC59,0x00000000000000C7 }
  },
  { /* Point #5 */
    { 0xCE0CAFC12184BB7D,0x153358498C843303,0x18EC18BBE6F4B4BA,0x9A34A7C6F08A6FF9,0x7FFE87BBBFC0DEA8,0x77019C95689307B2,0x806787438122B505,0xF71A3CCA034C8D8E,0x0000000000000076 },
    { 0x07426E5726774BBC,0x046829D4C9A22D42,0xF437F0666DBE5A7B,0xD582CABA4068C336,0x9135DDBAA43F362D,0x68C6CDB31B30E4B2,0x42B97D48C21D15D2,0xD7571F38845DFAF6,0x0000000000000012 }
  },
  { /* Point #6 */
    { 0x8BF9E0791C403388,0x219A3154046F9ECA,0x3A8EE73BCEC86E4A,0x0A31124E281F2E27,0x6A6FB93716BC3255,0x0706364A8AE63821,0xCCE86C65323D4B3A,0x0C238449FD6CFBD4,0x0000000000000174 },
    { 0x031202DE7FAA8A49,0x97B770B2579D75FB,0x5CF4413EA5E0D986,0xE93B56FDCC936D96,0xE4EC80D2B1C5576A,0xBF8972A2DA093BF5,0x0C5A98BDBCBEFD15,0xA19B3E630E6F9D2E,0x0000000000000131 }
  },
  { /* Point #7 */
    { 0x5255A6B2F52BBD0E,0x25BC9A303A427AA5,0x0672CF27C05B4E39,0x0EC3E665E1C1BA70,0x4EB83C1B076E1D79,0xC639E919EE0A4FEB,0xE208FED59D705FC7,0x84877C1A672534AD,0x00000000000001F6 },
    { 0x7618E18F22D3E4CF,0x6A6747A68B6B1A53,0x2766D2CCAD83B5D8,0x304194B0BE7C22B2,0x3AC468E70C76BAF3,0xAF0247C572A552A9,0xB19FA90223E444F3,0xC854C7ADFCEFCD95,0x00000000000000B9 }
  },
  { /* Point #8 */
    { 0x0F73C85A8201C48B,0xEF502F8A4C9CAEE3,0x8DF7699641D84048,0x93F8A34BBA0F3B82,0x0FBA696CD6A81ED8,0x0BE6C83196622944,0x0DE9A8F2085495F9,0x12D843E6580B2551,0x000000000000010E },
    { 0x507820FBE51DE678,0xE404CD9317831A13,0x4818C9D1721196C2,0xEFA01A64CDDA697F,0xDCCD32F0BAB8B58B,0x51AC6E1FB4A19BDA,0xD402693F4E25340A,0xD6567590AFBBEC44,0x000000000000018A }
  },
  { /* Point #9 */
    { 0xA03774256DF2D004,0x9D00325B8B587CFF,0xB466B841F87CF976,0xEDAB374DF75F2EDB,0x8E9EEC5F12C197ED,0x50AAA5D989BC9389,0x4AF2C82A763BB194,0xBAB1ED0834C8C1F3,0x0000000000000086 },
    { 0x772C2059CC18E166,0xF1C02E0110EB9FDF,0xA447D3E65A84A9CA,0x6CE1C58DB12B3058,0x367FF98651D80E66,0xF4B45924F658852F,0xBD2E29E45DEE2588,0x1F3F06C8FFA9FFCE,0x000000000000017A }
  },
  { /* Point #10 */
    { 0x07CF170343EA64EF,0xD1DCAF5FE29AD51D,0x6BC714CBFE586BA6,0x95D455C4A564449A,0x786B09C6A3F8C7B9,0x6B2825349A9F9ACA,0xCCCEB672DF41C312,0x88DA8F633A5F10DA,0x00000000000001C5 },
    { 0xF41C956600A865DF,0x8EEAA9FB92362410,0x232C80AA699EA6C5,0x86AD242D2E4CE53A,0xF54D983FC51E3B6B,0x5FEF2FB86E2DCDCF,0x08B9A493E3F0B5DF,0x32594FCD676F65F9,0x00000000000001CF }
  },
  { /* Point #11 */
    { 0xB04F199FEB3B9F8B,0x80243FE9153FCFD9,0x11DA409876AA9864,0x3BB76B95EBAB3040,0xBD84C6666335B1F0,0xB83DA9AC945F565E,0xB1462685C210BED2,0x5A7ED2DE8172AA34,0x0000000000000188 },
    { 0xBB53DF9A4757115E,0x900587991C6D4096,0xD2E6A2DB3A228705,0x7B961C8D738B21FD,0xE93A3BE5B7CD3A6B,0x0608193246646D78,0xB23C7E41B5EC69EE,0x422E6B21814DFFAF,0x0000000000000006 }
  },
  { /* Point #12 */
    { 0x79541AD2F0258929,0xB69D65AFA7FFDA3C,0x7A83F701FB3FCCFE,0xB8C83005284111F3,0x7B48D4ACFF594C0E,0x4364F321B301DC8B,0xCCDB0184404F2B6C,0x52239A4B8F4E85EF,0x0000000000000144 },
    { 0x1DD594A2F650828D,0x98B50E840AAD2D93,0x491FB295FD90D0F7,0x511ABC0B7FC0144C,0xEB240AA88D0085CB,0x926F083C4F4E0A76,0xF5E8865DF32A6E48,0x8FAE6EC023E3413A,0x00000000000001A5 }
  },
  { /* Point #13 */
    { 0xA163994DC4103BA9,0xD12D5CFD634A761C,0x53FBE970CCE6E65E,0xDF9A86D4F3DE64AF,0xA2EB726FDB6AFB3D,0xDA0C5D883B6CED78,0x8E0C6FF9AD815592,0x763E3F3A31ABE3DE,0x00000000000001C1 },
    { 0xBA83EB37D486D571,0x7D06E7879C970E02,0xA6F869C9C94EDC44,0xB509477E6B339C7C,0x9515CA81ADD2AF63,0x98B2B3D86504A9AB,0x98178A7B5EE4580F,0x35BEB4A2C3F9784C,0x000000000000009B }
  },
  { /* Point #14 */
    { 0xE038336EAE697AA9,0x1545B82E6B122BC8,0x2ACFC7A2465CAB13,0x396D60549E0670BD,0x7099E416D4EF9B8A,0xA745F4A6F144B1B7,0xE859DAC381092B9F,0xF4BF2786CA8DBA24,0x000000000000016C },
    { 0xD43FA47A1D8E919D,0x7848E02298994D0C,0x88559FC88B5C1E94,0xD810594A0EE65987,0xC6B9837B9476A135,0x08B04D2778667D75,0x3D35806E815D0639,0xD703DA9B9CEA4585,0x00000000000000FE }
  },
  { /* Point #15 */
    { 0x4CA2DE78AA026E77,0x0C8A435C4DB749FA,0xD866FE868B0F97F2,0x5318BEF1721478E7,0xDDCD7C3378D574F9,0xF258516F0C653081,0x5E47AA9D2CBD3506,0x56C2988876EF6CB3,0x0000000000000115 },
    { 0x696B6A6AA2B162C3,0x26ED27B984791356,0x0CD62D0893B4394B,0xC58FE1DE836EFB61,0x3BD9249186C31AFD,0x0661A249FC5BD37F,0x6CEE7CA7FCA72EB3,0x0AB2850FDAB31634,0x00000000000001D6 }
  }
 },
 { /* Table #34 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x714C9D4D6E4A010A,0x9E8621EB98BBDD05,0xF3F33305EFC60F48,0x4E392A4C0706C352,0x5D0F7B3A94DCFC6C,0x28C343062434D058,0xDBA377BB41885900,0x0ED4082DAD73DF88,0x000000000000012A },
    { 0xC0899758FCDADFEB,0x1638C31454319374,0x1831028EC8AE469C,0x41093FFE3A0E36A7,0x75C6667B2860701A,0x38C843A264DE0A06,0xC6E2C8A0949389D1,0x754F22B73A1CC818,0x00000000000001FE }
  },
  { /* Point #2 */
    { 0x58821C974A0C0913,0xB7707006307795F2,0x44F5F5BCEA20C664,0xC23F5AC39C5EC494,0xE83E4FC380AFFD1A,0x7E92884D50102AC6,0x632405B8A3C31198,0x1995F831453CC03F,0x000000000000009F },
    { 0x8019071721E50847,0x794B63D991F3EFD5,0xE9D69357A95C778C,0xBD298EB0D04A14C3,0x40A105154C5CB3BC,0x296FD944F9C2FA5C,0xFEE5FE79EFB9A49B,0x12E8D7B35BA9DB09,0x00000000000001D7 }
  },
  { /* Point #3 */
    { 0x1711039279D6593D,0x7D88866ED6D1E388,0x27E0AA5FC9A20E92,0xC82EF455B781BC4C,0x36888AD0A1E9A984,0xA51D1804962EB333,0x3964BF4A6589216A,0x88904FFA7529C9FD,0x000000000000016B },
    { 0x9E0ACA53E59081D4,0x8B9066C009C4315C,0x51D18E8B44DAFB2E,0xA86CD85C3C757835,0x7534CBA2ED8B25E4,0xE1DB4AEBE59C5EBB,0x77AF93DE72024396,0x0779F6AF77F5A9BE,0x0000000000000090 }
  },
  { /* Point #4 */
    { 0x0D200089E0B8B7C6,0xFA7C2A74E0C3A66C,0x47465DB046E3E5CF,0x2BD1DD818537BB62,0x748D70127165A234,0x4D3737455C718337,0x40C0F48E189CE8CD,0xD018CE08A2F751CF,0x000000000000014B },
    { 0x5513201A7AC22C09,0xF559E050A1CD3533,0x6E1EBA1EBD4031D0,0xBFD8A1CC532B1D53,0x3FDEE4CF5A15B193,0x226693F7789BB143,0xA0D4DC89DEE75E9D,0x438D3544F09A0C6C,0x0000000000000189 }
  },
  { /* Point #5 */
    { 0xF9573F8D640E6A08,0xAE4874B31138E3E6,0x9DE063DCDA7C7652,0x3F4F25905C5E679A,0xBF26D5286355457C,0x071B6EB12FBDC5AB,0x66F75278B8344ED2,0xFCAE83AC52898292,0x000000000000014C },
    { 0x13B69D24C652CBB5,0x072F96E6120253A9,0xE8F88C7564985F28,0xC7EAFD4F089A1E10,0x6D4D0FBC9562B680,0x6E4E5AF7B91B73BF,0x253F58CE07278B89,0x1DF25657E8A56798,0x00000000000001FC }
  },
  { /* Point #6 */
    { 0x6DF6776BC353A269,0x0D232F2DDACE9809,0x7649E04403D5D78B,0x59710087FC283D82,0x86D65EEEE2EE05AB,0x3D1FC3F227851D69,0x3B86ED771781977B,0x4D4A61BE1AC0290E,0x0000000000000161 },
    { 0x2DEAC320C5400967,0x026949097381541B,0xD373BA709CD429A7,0x547F0E86928B72C5,0xB1C2F84C223AB61A,0x06C039941115F60A,0x6E5B0CBE82136CFD,0x08E4A467489D7DE6,0x00000000000000C6 }
  },
  { /* Point #7 */
    { 0x06FEC2DF700CD193,0xF077AFEE002863A6,0xB60894FD6CF0C0C2,0xC7D01CD0F8B7C551,0x7ADB74E4C33C337A,0xB4B5767EA8867AF3,0xBDB10AA62F3D57A7,0x80D5AC5EB1FF9D7D,0x0000000000000116 },
    { 0x0E0DF41C91867318,0xE3CBB1AE1912BED5,0x006DCEE9C15465BD,0xF4768566352746C5,0x567E2BCF767E554D,0xA4EDDFACCFC14923,0x5C661C2E5E096C3A,0x5B13488D8123FB58,0x0000000000000045 }
  },
  { /* Point #8 */
    { 0xAE917A54A084D91A,0x4A1095A88A3AE45F,0xB7A358FAA30EE909,0x807ACA835AEE3272,0x58D144A9681D54BB,0x36569B8D3352C5E8,0x75B7E2F1E5D9BA90,0x348C70DA08068BB3,0x00000000000001D8 },
    { 0xC2BCA2F5309376D1,0x87CA2CB0457D23D0,0x7DCCF53DACF94FC7,0x0646DEA871E898BD,0x8A053DF3C8BD817E,0xA9E9C6825A002253,0xB23C781375A16C9F,0x2500D5A13F81C2BE,0x0000000000000043 }
  },
  { /* Point #9 */
    { 0x9861603E036DCD2C,0x48AF47286320E41B,0x8138FB07DD2B96B1,0x2FB14E247B0038FF,0x7C9FD678CC76B62B,0x804D66C490BA8145,0x7744F891F648D6D2,0x0850A1BCF4DB35C7,0x0000000000000163 },
    { 0x8EA9969F03B00E31,0x4DABBA6CCAA48991,0xDCA513A22E664C76,0xB13743374D2B208C,0xE3C058CF187BC7FA,0x47210A32FA8126F2,0xCDDE35A36A9587E2,0x0503C0CFC7D17EE7,0x0000000000000177 }
  },
  { /* Point #10 */
    { 0xC453EB71508E90A3,0xA8C4FC23D37B4C47,0x4E8DAC2ED65640EE,0x44A47C81B73CA7FF,0x61C9A1F525D2E75C,0x77321C34705A5100,0xD1323F5567D841FB,0xAA0FEC6DD668F313,0x00000000000001FD },
    { 0x043FC9301CEAB0A4,0xC0F70E0D2D602722,0xCBF190F06E434887,0x639875A14B6D96D5,0x5174360333AD9D1E,0x538D6922FD836F0D,0xD893FC204D84636E,0x6E4A73FE1279C00E,0x000000000000010E }
  },
  { /* Point #11 */
    { 0x199B34EF3BBB2752,0xAF349BD214DA10B6,0xFCC357F6959CE9E5,0xC90BF5CD34A32D88,0xD8461D477C06D65C,0xD2D8C0F5FF0C374F,0x11329B15AF92178B,0xFA9CAEDA99258479,0x000000000000010B },
    { 0x72E9A0493134B0E2,0x5811B5645C0896E5,0x65BD9197EED4B0C2,0xA5E1DAA66C3C3AA0,0xF98ED72B8BC10FA2,0x3EDBDE6F5800741A,0x656CB7F8807E6853,0x130C5D150AA4DDB5,0x0000000000000015 }
  },
  { /* Point #12 */
    { 0x4E83E42A70E82B3D,0x9C781F0ED556C457,0x83B8A8DB4550D45F,0x1D7544975CCAEAEF,0xF7E43BDA26B8C2A4,0x202BC3C8381FAD9E,0xFC34B918D1F92821,0x965300C629EE5DBB,0x00000000000000F3 },
    { 0xF3B047EBFF634772,0x57C4D7DF5E2FDB5B,0x10A0A8B4A824A72F,0x186CAED87E42BCFA,0xFFE12ED4D7886162,0x2C502D802381B0F3,0xE0B6D4746660B8FF,0xECEBD250E6922E42,0x0000000000000153 }
  },
  { /* Point #13 */
    { 0x92BEDE9E42A75DA3,0x071164CA9F18E66D,0x84AB54EDF46EA354,0x10DE71A7BB19F925,0x7A42601180EC1173,0xF1D7880138903219,0x2A8876B276845761,0xE94D85963095533B,0x00000000000001E5 },
    { 0xE36D22A0F232ECF9,0x84A21E43338291A3,0x4A5522960C3B7B40,0xFE08898D710F5A7A,0x3B00A095579D7F19,0xF36FBBB9DF5933D3,0x33D4062A05DA2AEC,0x6C013A91D1C62E22,0x00000000000001EE }
  },
  { /* Point #14 */
    { 0xD824A2877C316389,0x3CCC24CAE9E68D1B,0x124BCBCF9E8A1D58,0x535A921D4FEAC680,0x2C9909D76A833BE2,0x756C6F968D0F38F0,0x38743AE58378EFF0,0x9767BC18E12FB1A4,0x000000000000002B },
    { 0xF7BF7DAB3AAF331B,0xC6586A588485B4AC,0x958C115029F86686,0x4CB48C2BB248435C,0xD65F8505FECF9885,0x464D7D2173324CA1,0x0B30D2BADB44EC2D,0x1F505CBE753F4A55,0x00000000000000D5 }
  },
  { /* Point #15 */
    { 0x3A546D510307136C,0x7C4486C965A1BCAC,0x4C7F0D4E3E137500,0x419A374E5F3DC270,0x2D3BC7FBFB68A787,0x133807B7CF5A6FBE,0x3157FD2D999D7DB5,0xBF430CF8FD7FA9BB,0x000000000000010A },
    { 0x640F385A138EF50B,0x67C224EA45CC0FDA,0x4584439FEF6F2E8F,0x25B857C8C3B81F6E,0x9F3249B7614BADB0,0xFDEC05FFFBE93DF7,0x998B74FC1DBB1FF5,0xA6B3A03634B19C2A,0x0000000000000038 }
  }
 },
 { /* Table #35 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x7FACF165D19906D0,0xD8E059AFAD92D455,0x7356696F6EBEC576,0x67044E551D6D311D,0xE2BC81DC3A2E50CF,0x860036DEC00EA37F,0x71DFBE61FF32D69D,0x298B766BF502BAFF,0x000000000000019F },
    { 0x5E5E123901BB03F8,0xD36C35835304BA94,0x5025F960B49F6A95,0x72DD554F75E5B6E3,0x85BFB398869C9D17,0xD71CF71F9CACE4A7,0x0F6FD3AD7291DD9D,0x5DA8A689D1B5758F,0x000000000000018B }
  },
  { /* Point #2 */
    { 0xABDF1B02DB567888,0xF47D5CD15A14BD4A,0xA3483F68B56EC127,0xF09422294E65795A,0x225B339B2DE6AE78,0xFBFE7EF011792AFD,0xF27B31A04548C2A8,0xB4821EA3DFBD3BA7,0x0000000000000159 },
    { 0xBA06333CA1C887B9,0xFC6EEF566B243E38,0x345900C3596EC79C,0x243B17AB43E33D8D,0xFFA7E30DA9370DA9,0x3DC587A50F09347D,0x0FD1B2463343A72D,0xE4ACEFB48372FCF3,0x00000000000001D5 }
  },
  { /* Point #3 */
    { 0x99D91691AF8C8CCD,0x2BE2648633764C92,0xB6E681492477AA78,0x90430FC6C52D4964,0x4CED96C54E1647A5,0x5B52A279C1489674,0xAB7F4127C26EC42B,0xCD5528FCF1097B9B,0x000000000000019A },
    { 0x7785ADD63A47E5C2,0x9C82FAE9635CB4AC,0xADCB0DE0CED83245,0xA42230C8CCB91B16,0x6AF43E953A3E11A7,0x36288135A3145D6B,0xB74A3E63E2DED224,0x15DF0D2948AAB5A7,0x00000000000001BC }
  },
  { /* Point #4 */
    { 0x25455C2AE3E97A29,0xD497AB4FD3028514,0xEADB13EA914AE0C9,0xF9F6A27533E0BD85,0x1103BD6053851649,0x445B182DD66C948D,0xF74F853BEDBECEA9,0x643DB0530D27351C,0x0000000000000082 },
    { 0xE5CCD1170FD56CDA,0x421562C371495DF1,0x865B3F9AB2D1A036,0xE0407F28D3E4F471,0xA64F74FCCB7E4C42,0xE87E464D1D1E7BBE,0xCDB9E777ABAD4A1A,0x6E1021D7E76DEED0,0x0000000000000161 }
  },
  { /* Point #5 */
    { 0x089FBB85B7F279FC,0xB3562A0B547A1EFA,0x40A3FA3C98080868,0x90CE47DD94597F7D,0xB3BB20850C6F4B4B,0x8C24EDA75953AB03,0xB8B110F04EEE13EC,0x3ACE7B901BDB3CBF,0x00000000000001D7 },
    { 0x33B6B36F335C7820,0x43EFEEBC6B2B5992,0x3B56649D36DED655,0x15419020A9DD98A3,0x08D081B563F405AE,0x5B1F59D02C588C8A,0x745C687EFF822E70,0x7AB7B9F169EF398C,0x000000000000017F }
  },
  { /* Point #6 */
    { 0x568E60BC840E5C81,0x12B35CD301788F64,0x70422FA0123E9018,0x6CEABFCED9CDBE2E,0x67032A107626E2DF,0x0888CA79D250EF1C,0xCA1FA245D5BA46AF,0x590F29972F6BE510,0x00000000000001D1 },
    { 0xBD6DD880F2A02370,0x3AE5F4AC20D42C5E,0xD2B300F46C08E487,0x662BE2EF896BDB34,0xE7632D9B07011F7A,0x9481B843E7E83B8E,0xEB7E2084A30C0FB9,0x53E59ADFA71241B2,0x00000000000000CB }
  },
  { /* Point #7 */
    { 0x49D93794C2911AEC,0x586554F1A810C993,0x867B77A3F2322411,0x6083B099C2E4CBC5,0x0445ED8E7CBD094D,0x417BA195E0FEAA26,0x432B645FC178ED78,0x429282DFC9948690,0x000000000000010F },
    { 0x3045657BADDC286F,0x10F36372863FA4C0,0xAB804FD7DCA96FE2,0x6B0A12A618C34D71,0xBAE3DC772A7C0EA4,0x241E63A0ABC48F80,0x34EFEAA3EF1843F8,0x321D171A8498816E,0x00000000000001C1 }
  },
  { /* Point #8 */
    { 0x26E479F9B9B07FB9,0xF8E49CDFC03B5ADE,0xA0D66A21D525E891,0x8A062D759A62E3D2,0x4B025CB738704C65,0x2B7A6B60D440836A,0x3E55FE53A3CA3AC1,0x59577407F1031F19,0x0000000000000128 },
    { 0xA5BB1EB02B4EDFEB,0xAEE5A2174DCFD68C,0x582146CFA19F4F45,0x4481152269F7C258,0x72D7CE9A7F9333C2,0xE6C88FE2B1DAE530,0x1367CE5C88B50DE2,0x10367DAC7150206B,0x00000000000001A1 }
  },
  { /* Point #9 */
    { 0xD210619A37F4B554,0xA2CC4BE40B01FA7E,0xBF3805805488768E,0xCB190C6F8A100AE5,0x6F82BCE1749BF03E,0x0914BCF0C75EFD73,0xBDAE235886E6B29E,0x6E286B36EC5DEB30,0x00000000000000E7 },
    { 0xF4EB4FEFFF080663,0x0702453DF93BA24E,0x1EE5C4E556EDFB3C,0xDC5BEF4B7AFD8870,0x74BEE7CDC025F4AB,0xAF63727B5597771B,0x2A51FEE0DC0CB4FA,0xD9EB893D309E2A54,0x000000000000017A }
  },
  { /* Point #10 */
    { 0x991EBFCA6CD7B62B,0xB8571F56009D1D74,0x14D27D7C441CB94A,0x4021306519E77736,0x9AAABB26CB20ADE1,0xA283EB52533F6F74,0x84AE1F5856DD48E0,0x275AB1AD91F11A89,0x0000000000000118 },
    { 0x61F3C5B415960882,0x036D46E444F0A7A1,0xF6C5A1F94BB28F39,0x610F8313F1CD4BC6,0x571BA872FCDE5B45,0x23C35A185F066EF3,0xF878375DA40C5FD0,0x9FC32CCC1158DC83,0x0000000000000167 }
  },
  { /* Point #11 */
    { 0x86D444CDD1D81EC5,0xE5F57D64C29B3744,0xE606ADA6F74F9589,0x5FA4DFAD28F6B922,0xF90993EC5B5D30E9,0x307D234BB0541C49,0xC010A0DAF75B0402,0x2F36EC8B2D0D3135,0x0000000000000168 },
    { 0x1EBDFAD4B51917F2,0x7F7F6C94411FAA6E,0xAEF4C9A7D74EC215,0x3F7FF15D4041EF68,0x21D6DDDC30B6B53B,0x1ECAC9BC6F918CEB,0x05CE1210FCB67A22,0x7AA44454C5C0E9E3,0x0000000000000139 }
  },
  { /* Point #12 */
    { 0xAC513C23102CC86B,0x34AEE96BBFD0BAAF,0x47047407EAAB0D63,0x3A1EFF07CCD57509,0x53F237CCA81C8D03,0x7742E3F1CC16C904,0x5325D4796E2E981D,0xD959B9F8289E6427,0x000000000000004C },
    { 0x3114735E26F5E6CD,0xD17E0D5337C5DE44,0x5ADF2F3F002A7993,0x7C1F1F6E176F2F70,0x01D7F210003758E2,0x8A2A198693BEB852,0xBDED219B40B61E5B,0x2450D9F2A7427CE0,0x00000000000000C4 }
  },
  { /* Point #13 */
    { 0xFEF846878597CA44,0xA1379684D227C76E,0x661764327517D749,0x1420872D295D8438,0xF296988CD91221F2,0xB6115A026241E88E,0x589DCE4EA0969D25,0x4318724EE35919FA,0x00000000000001D7 },
    { 0xF3EA462A41FA8073,0x8F577C2156900887,0xB4318C9929E43377,0x821A520CA7686967,0xB62B1149354C5868,0xFC76E87F6A9DFE8E,0x8AEB05C6BDC6443D,0xABCBB41C51A3FD6A,0x000000000000000F }
  },
  { /* Point #14 */
    { 0x06BC23AB58DD91BF,0xBFB489E37FCDCE7C,0x50A99333F0D69619,0x6F1A78A3D65751B0,0x10AC9BF8E1DBD9D2,0xE3D584F0133B5409,0xA52CBA20DB27D29B,0xBEE71F220DED25F9,0x00000000000000BE },
    { 0xCDBFA2CB8D49E1D6,0xEA7E04C2752B7A25,0xC6CD12C9915CDB88,0xF5D56504B292EADD,0x2D0AC7FF26DC8F0B,0xC6E0722D551BF7FB,0x17F9ACD4C0A3D7F5,0x0CBDEB4F3498EE12,0x00000000000001CF }
  },
  { /* Point #15 */
    { 0x8D2B73570149C225,0x6F048760B1294D56,0x4FEEBEFE53097A6E,0xDEB1ABBECA846C24,0xC920FE521BA7F7C5,0xA851D87174295FBE,0x8A977818717E5FE3,0x4E35D70C5320F185,0x000000000000000F },
    { 0xCC43DE63BFB2D00F,0xFC526E5170414BB4,0x45574B72696EF1CD,0xF29B91CC4F96A64C,0x17B2E3503D419BBF,0x13F2873916DC8AAC,0x3A8AFBB755B08A44,0xF1CECDF34E23F8DD,0x000000000000000D }
  }
 },
 { /* Table #36 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x69CAD3CCC4D6AB08,0x3ADB57773B8990B8,0xD0CAD8CE8D958801,0xCB572E666D728F9E,0xE3D9E7C4CD5131FC,0xAFCEB6B06145DC06,0x12ECD392E213043A,0xBD5992943A64C87C,0x000000000000000B },
    { 0x8623BDBBF6EA9CF1,0x3AAD9495547AA650,0xD3D853FCBEB27159,0x3D25A64830B40833,0x12D188E8DEC51BD1,0x836330D2B348C3FA,0x9DF50CFE73C2EA59,0xB5DFFB2061DED0B8,0x000000000000018A }
  },
  { /* Point #2 */
    { 0xE843D0350C62942A,0xEB792FC5D8920CD4,0x3FA4154E90BE6FD2,0x002631CBCE2557AB,0xB37B952A226742B6,0xA7658C0AFEAFDC24,0x62A7DE67B5A09597,0x25074F6A9BB3CFDE,0x000000000000015E },
    { 0xE6DB0F49D03CF65D,0x1187C8B40347DFF1,0xDEA411166E4CE605,0xAC0CA35322313708,0x395DDEE3B6A5CADE,0xF31ABCB1C6D80C86,0x013371B1A07F0747,0xF54231898F55B804,0x000000000000014D }
  },
  { /* Point #3 */
    { 0x6B8F830418A82CCD,0xC3C560011B132B2C,0xAFB9250D8DED65A4,0x921B4635945B6410,0x100306BD9F168610,0xDAE04ED366EDAB88,0x4EDAB84ED86B2664,0xDEDAA28CC815C6B2,0x0000000000000142 },
    { 0xDB8265F17B7161C2,0xF022683F8F11558C,0xB8859F1FCF5FE6EF,0x7419ABD8AD90BE7E,0x8289C33F24AA372C,0x3871CB407C9D3BE5,0x55402906B3034315,0xAE557332A7E70821,0x0000000000000014 }
  },
  { /* Point #4 */
    { 0x42458CFC40817AA5,0x96F15F13560CC12B,0xF96EA2034400B1E3,0x266C2A626EBC6B8E,0x98EBD5D42B374CBC,0x15C1F4FD97F946A4,0x759238AE33A07357,0x6DE75CFE2E3338C4,0x00000000000000AC },
    { 0xF73DFD08A1D6BAD6,0x32228F5F72566188,0xEA587FED0497DD53,0xAD4C4A562C1673C2,0x8C8DCEC4ADE968FF,0x77BF520EDEF7FEAE,0x856BB7987E6A19CB,0xC289274DB7FB508C,0x0000000000000050 }
  },
  { /* Point #5 */
    { 0xBAA18E98CA0544A7,0x1FA840A3ED60926D,0xC901285BF583BF44,0x1E6585542F2744DD,0x7D1F3FAB033574B7,0x29BF8B275D34D187,0x02018A3B013F2B8A,0x7C0D108F7D0B0654,0x00000000000001D6 },
    { 0x56E335F2DBB51651,0xB0FAA53C0CA2BFD0,0x519B0979A9CF1059,0x5073CBC982E7A7E9,0x59D59D169C56804B,0x8AA441386F1FDA98,0xB59516A771430784,0x7E4742E75EE4C065,0x0000000000000013 }
  },
  { /* Point #6 */
    { 0xFCB62E6EE32413F4,0x50F1640191774519,0x0663934C40A47E38,0xB076A14B0875802E,0x8E263A070226B719,0x56A9874C876EBD60,0xDA1C858BDE28C9A5,0x5D2DFC545D0FE6C5,0x0000000000000087 },
    { 0x0B8814F1F0C26523,0x50C49512BEFC1AF0,0xF350E279C96A9945,0x4DC5983619BC1CCA,0xA3278CC6EFBE83AC,0x7946939AC8A9BC08,0x8F61429213B63E38,0x83EEB455853B2360,0x00000000000000EC }
  },
  { /* Point #7 */
    { 0x956E5BAB8D439A2A,0x70731E9D45CDAA3E,0x3E13BF0957720254,0x87759C0C97E84B98,0x73E763435D558933,0x639811741C8E0B0D,0xBCFCB1C04D59454F,0x230D81F0C266E0C9,0x0000000000000185 },
    { 0x21F9D779BD01132F,0xF2FEC285B24D193A,0x248513EC23E6C8D7,0xCA611EBF50EF338C,0x8276397C21E42C9E,0x0A88DB639F6E2FED,0x5454799442F1FA0E,0x3DA19301C6CA6F09,0x00000000000001DC }
  },
  { /* Point #8 */
    { 0x2491A894DE6BAFE8,0x8AA13AC5EE9EB4C2,0x1623B9DF31B2D1FE,0x1FB69CA81A5B21EF,0x722F1BE3290D231C,0x8D2A56EEB93891F0,0xB534845B48A2DC2A,0xE4FADAFC3E2A9160,0x00000000000000CA },
    { 0x7F9D50B8810034B4,0xFEBDA319E8703F93,0xECAE100844CAA3D9,0x21767275BB5E0DC6,0x529817CDAC64FB7E,0x984CB5BD31B97B4F,0x33000D288BA3A593,0x950B9C149003A472,0x0000000000000039 }
  },
  { /* Point #9 */
    { 0xEE00454FCF158384,0xA5FD9A8E4F86C85B,0xB123EA8B67DE6BB5,0xD7188DA743891EA1,0x2623A8D5E2B2C93F,0x9F2703D48F75CAD2,0x177F4D20F759D03B,0xDDC14C9CC56499E3,0x0000000000000149 },
    { 0x8AB6448EA0FF38CA,0xD235918C0126A5AD,0x8D30B461AFCE87F5,0xEB9E25BB09D6B9FD,0xD600B21C46C20DBA,0x6C211926B4D2C9D3,0x352924849661D65B,0x23762115908DD76E,0x000000000000017B }
  },
  { /* Point #10 */
    { 0x424072237100E0DF,0xAE1B101FA8621712,0x3985B7F669A2C0F8,0x58C8331B16D83BC5,0x231ED6C674470F31,0xEBFFE06ECF51F691,0xE0119E3BCB7F158F,0xEF2E1E17C4A2CEA2,0x0000000000000154 },
    { 0x8BA3486353540B91,0x378B472ABB77547E,0x33CCBFF30FD8DE03,0x1692CD4A435636F0,0x831D7D3B625A66D5,0xE3B30CB84B84BC38,0x6E8BFC0AEB1B31A6,0x0B70692A6037A39B,0x00000000000000A0 }
  },
  { /* Point #11 */
    { 0x465266254CCEB5A9,0x0F1D0417E5EF8C80,0xC4FB08EA040DDB86,0xC048C66F05D7F4EB,0xAF3A8DB1DE712B34,0xF4F5A56418A4C4F5,0xC440931CF923A04B,0x3C24173A6A2A98D3,0x00000000000000A2 },
    { 0x64E32F8288BD9558,0x389C0B812C193599,0x0170849E857670B3,0x8AA93F11B7743283,0x51530A59DC9037FA,0x5F8C832696408A7F,0x91B0D6C93CC69BF9,0x12AA4C74C61E39F4,0x00000000000000BE }
  },
  { /* Point #12 */
    { 0xB4896B196E4E5F05,0x440571A1F4033850,0x4304FC4AD65B82EE,0xC3FA06E198AF1BEF,0x916DD5E026D371EA,0xD3B86D669DD56696,0xF7F493EAA8CDBDF0,0x9E8893A5885DAA21,0x0000000000000176 },
    { 0x2848B2E4487FAD4F,0x78F9FCDE9A96DE91,0x664DE6960A04AD7C,0xCCDF17995B24BA4E,0x61B02CC7FD61299F,0xD44F6BCE9BAAE9A8,0xE885B08BCDAD35EB,0xD72278C55A3CD5CA,0x000000000000006C }
  },
  { /* Point #13 */
    { 0x08B49A24B2FE8B27,0xB9EFD19CAAA2F43C,0xF804EE4BD0FA8BE4,0x591F9D425050D37A,0x769F7D895AEF03BA,0x7C478E0D237488E4,0xE94A570E590A2B75,0xA3D690D7629505E9,0x000000000000014D },
    { 0x9A12FB5AF168CB7B,0xE5D0239B4C36AECA,0xA3E086125A38A19D,0xB828E0D08816361D,0xC79C06477F12E1E5,0x9E421984AA7380D6,0xC5D1EF6ABBB2A1E9,0xD3B67B8BD73A3A66,0x0000000000000193 }
  },
  { /* Point #14 */
    { 0x992F28A5F62B5B23,0x6F696B113F90E4C9,0xF1E89CA2D4888EED,0x86B02FC1B926CEFE,0x2F2520D81DE28206,0x87F967B98702B67C,0xC7C99AAFA58BA344,0x372A219FDF837E67,0x0000000000000086 },
    { 0xDB9BA4ACEA65FC6E,0x7B4205C59BA55B49,0xC8EF6EFB8982E262,0xC29DB220C2060336,0x7D3A07CBB7627FAC,0xD259238F1B030212,0xB38949A3330AAA68,0xF6E22978ABDE7FF5,0x00000000000000F4 }
  },
  { /* Point #15 */
    { 0xDC9AB8D676EE601C,0xA9991AEF60B83FFA,0xB30DC5F608AFCC16,0x815DA575907DBE27,0x89234D4B4277E0CD,0x71FDF6AD03087465,0x6480186C227789EF,0xA26631E300DFA79F,0x0000000000000117 },
    { 0xDE0C4CB3DF8D677B,0x8BCC73856661D17A,0x681DEC04CB682C5C,0xE4F286C680ACDDF7,0x78DABB642AD93327,0x51630BF3E5E8591E,0xEE2964C198E1343C,0x0C9A681BF4B48F54,0x0000000000000053 }
  }
 },
 { /* Table #37 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x5E94C2A2A1DA3C44,0x90D950916C05A3E2,0xB29B791E74871EB1,0xE82A41FA50C2D855,0xD2D24DF91E689F42,0xE9E935450CF6ED2F,0x5FC9D992C6ED3E7E,0xB4EB7DF03606713D,0x000000000000004D },
    { 0x248FD9D72099171A,0x908D539E1D16D66C,0xAB47B9EB171BFD3B,0x70E5DE8CECDD8E37,0xEDD44AE051EED557,0x4983C6FAAD95AEB2,0xDEDBFEA1CDC8214F,0xC6AE2030131549B3,0x00000000000000C9 }
  },
  { /* Point #2 */
    { 0xFF25170724DB06FC,0x4421108C849EA0B1,0x3073C4CACA8162A1,0x6D768642E42AF7AD,0x031EBA68A6BC7790,0x9A8154C3D8D64E3F,0x7060550E297AAFE9,0x8681A2C6641391FB,0x00000000000000FC },
    { 0xE9E76B16E0675E14,0x3C4E3C42740F9BB7,0xD3E75FF52869A3AE,0x99A891ABA47C7580,0x42B47BCF0B321989,0x2D1212A00A6DD3BA,0x25B1C5C8B43E9086,0x8BC954E8E8D1A73F,0x00000000000001AC }
  },
  { /* Point #3 */
    { 0x5C9DA1422F134A93,0x898C25BA65DD482A,0xA8CE92FEF6EF3E64,0xE462FAEC5DA54ECB,0xDFF68F3FB81E3EC3,0x5278EB6C4B8EF144,0xF98A36D50DC84F3C,0x8EDD6EDBA94EF000,0x0000000000000191 },
    { 0x738606C4CE8F5403,0x102F1B3A1A20B349,0xE7F1BF3328F73251,0x0136F3EB1DCCBBDC,0x5B2B77633DF6D9A6,0x02B03DC6C9EE09FB,0xFF600116EA421742,0x432728E840D3C3EB,0x0000000000000034 }
  },
  { /* Point #4 */
    { 0x4BC6F28624374DEC,0x9DED182EDDBF9446,0xF58DDB470C3C51E1,0xA6BD194EFCFF08C2,0xDC47A3A63E931AAE,0x7F1020A8DAF165E6,0xD439739F8FAABC58,0x6EFC35AB5951222A,0x0000000000000187 },
    { 0xF15EE7129498152E,0x9E85AFC9ACBF1F82,0x7B5853EE397280BA,0x0283243A6B8D13EE,0x64ABBDC796CDE865,0x0284A75F3DFF94EA,0xC476E3A69C7B3D53,0x9DAFE302D1884045,0x0000000000000133 }
  },
  { /* Point #5 */
    { 0x1D7B9B778D4FEC63,0x47EB33FB690C571A,0x3D2BB2DE05A01CE5,0x16CDE99B78C47FFF,0x0359242C699656B3,0xDE0C7D81BDD416B9,0x60863068B6144F4E,0xDFA66D197583C05A,0x0000000000000142 },
    { 0x892F8B4E8CCAD1D1,0x085CF7F6CCEAAC0F,0xA07608425DF33B07,0xD4737BC3A8747EC7,0x7F8147A128F4CADD,0x49D9DB4C8480DE3C,0x5BAA01D5872DEA19,0x2A8726B1E84044C3,0x0000000000000126 }
  },
  { /* Point #6 */
    { 0x19A54EB6407386D7,0xDF16BAF601C2186E,0xFAD573E89BD9A894,0x343BBB0BCCBEAC47,0x44FEBE5E4F7F5443,0x87C81269C3AD9175,0xDD79411447319EB7,0x3302374938F26DCE,0x00000000000001EB },
    { 0xF94F891C1F1401DF,0x2AE0E96A1450357F,0x179A522785202255,0x10518E7F397D8D98,0xFA56E665828575B0,0x7622B705FAEBB982,0x63F9067AE3B3B8AC,0xB30F7BEC6FDF48DD,0x00000000000000DC }
  },
  { /* Point #7 */
    { 0xE5B551EA2DBFF4F0,0x438195568ED22F87,0x1A42769CD42F4897,0xE5A6F518A1A6EE3A,0x9B53A9E63AB29B90,0x6189A415C2FBF1E6,0x6EE4570E2599D956,0xEBC865B6DD1F4BCB,0x00000000000000A4 },
    { 0x66ABACD8843E4791,0x3BB5C48E7A8CDC84,0x3F4E2D197B5A2F8C,0xBB945D44CAFFDA4F,0xD09A8F34B7BFB4D5,0x1308F3D83501D709,0x0BFB71E4352B9435,0x92C77D2A403E594C,0x000000000000019B }
  },
  { /* Point #8 */
    { 0x9E4AB8C58B327354,0x89377C3C73F5D13A,0x1F93CC126E55DEE9,0x7B4255BCE490C030,0x5451BDF5047EA02C,0xC01D952CB461D14E,0x172D0F20B9E21078,0x694587A5A1295F3F,0x000000000000002F },
    { 0xD54076270219FA4D,0xBC0B846FA3BB7F30,0x5C17104E2BA06BDD,0x2490F12BDF3CE36F,0x0FE2E1CA08468C10,0x8126C060A9E2C73F,0x7685E59C5CCE9DD7,0x5F5F64DA9E8CA8B2,0x00000000000000BF }
  },
  { /* Point #9 */
    { 0x90276BD80EED122F,0x5FEB9A3A51AF464F,0x6723D65F591AFDA1,0x4612B5B20F6233C3,0x8427E3B7AA39D6E6,0xA6311DA25050A2A8,0xFCF3C90A384A189D,0x956C6FA5C0E2CB3A,0x000000000000010A },
    { 0x665BF31000B63FAC,0xCB8CFEE137C71EA8,0x8B3CDFEAC1BC2F1A,0x712F91A9956EB88F,0x3E7AB8C3B979486B,0x376B1F96E540D2B4,0x01EF726F8CB06E29,0x240B1DF4CC582BD2,0x00000000000000D2 }
  },
  { /* Point #10 */
    { 0xD145EB32B6F1416C,0x77BFE297670BD3E2,0x4FE924DFCE10F4D2,0x9651650629F3C127,0xCC669C51715B9E23,0xAFA90094B60A780B,0x35114C8AE1AEE1B5,0x3F793F136599DD0A,0x0000000000000176 },
    { 0xF098FA02BAB41133,0xC018FB4737635FB9,0x0BE935B6EB948D5C,0x453838BC27DB09C0,0xCF717312B29A531C,0xB001EB51446FF102,0xEB0A15C7275B0B94,0x32E88F1499A3FA93,0x0000000000000049 }
  },
  { /* Point #11 */
    { 0x5ADD1D5F23342E9D,0xDFC4C696230F2DDE,0xD925C3A6049C89BA,0x9E2E23D5074B981C,0xA11DB26CF8766D4E,0xC0A69D7FC37CE4CF,0xF6DE27C4B102E1D0,0x9921EC7010409988,0x00000000000000C1 },
    { 0xA66B32657B6F0DE2,0x2BD9A65778871BFB,0x29F760A353BB697D,0xBD91B082AD080BDE,0x8644A3328E96EA2F,0xB3E71CDB10D83CF8,0xD8611580758300C0,0x7EBB9FD48146381D,0x000000000000009F }
  },
  { /* Point #12 */
    { 0x8C9F5CC170B1BCCE,0xE2D68ECEF726D3D6,0x330E1C4C707F25AB,0x4397647F18DFD382,0x8F83B1EE249A6EBB,0x7D291BB65738EBED,0x11D6AF26E8DB7B2D,0x47B048EC173D8D33,0x00000000000000E0 },
    { 0x16819A7B1843C807,0x9BDDC58230CA2736,0x2BCCD7F2E1525168,0x0F9DCB4D5900125B,0x90E3017BB5ADEF07,0x09C2381A7BDA2FFD,0xA203C883D47CC848,0xD173669EEEC3C0E4,0x00000000000001A3 }
  },
  { /* Point #13 */
    { 0xF1321A601F9D09A9,0xF4D31EA30C863F7A,0x8A43A25AAD2CE3AD,0xE338837799BC8BD4,0x062857C2A8E816FC,0x56378AC296C41801,0xDC0F04DB0E66AF1D,0x8848081A56FFCEDB,0x000000000000011A },
    { 0xEA2A3E6060B59A1E,0x85720082F6FFB469,0xE10DC94CD3E820FE,0xBBEAD00B43243370,0x9C4F4AAF715983BC,0xB53C487337AAB294,0x527C167F49239950,0xFC0884FE9C1D2B15,0x00000000000000F1 }
  },
  { /* Point #14 */
    { 0x247F9F991415B5A5,0x8D40F1E22ED5E708,0xF1133CB0EFC81F52,0x278A9E9C2B0ED8B6,0xD0E4058B608882B8,0x0A74BB730C8107E2,0x13E8D54E5260F955,0x7A147D79D3AB9424,0x00000000000001C8 },
    { 0xDC0B55A16F9EBF4A,0xE7A018E054AE1FA0,0x542720CC8CEBFCEF,0xAD8FB8DD27D8BA5F,0x6E9D00DA68C5590B,0x4F1FA055014F5FC6,0x972A148006B1EFD5,0xBE9062432116830E,0x000000000000019C }
  },
  { /* Point #15 */
    { 0x12A5B6B9D51EA4ED,0x6EE257DC65396AF7,0xD921C77AECFE3419,0xDB9D587E463E4D69,0x0224CC9F03FE3388,0x062C03973EC5049F,0x705FDB3FB1E1D2BE,0xB9C77024ECD64766,0x0000000000000140 },
    { 0x9591F031CC7FC0FA,0x2EB3BC1CC0B49C59,0xBD54081797CE9A6B,0xD5285B3641B37630,0x85137B727A1313A2,0xCE410DB03BB3C320,0x2D3628D4193ACE4C,0xA39B6D8775B26D92,0x00000000000001AC }
  }
 },
 { /* Table #38 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x16BC33413FDD638D,0x8C37C58A8C518C30,0x9DDDB8EE79DF75D1,0x0BC82320C91A620A,0x6E924A6C9126A200,0x744594A9D20C8C89,0x0E9B59AC4CC73CAE,0xCE872F0A0B276B4C,0x000000000000008B },
    { 0x651F74222C35933C,0x95238355E025609E,0xE7891B5B6C14D96E,0x89C0FA370304D219,0xDF7DA33D61B597EF,0x43DF03574120905C,0xACF01355718DF73D,0x7CA32D0E631ADA96,0x00000000000000B8 }
  },
  { /* Point #2 */
    { 0x5249E953D6AE5716,0xBBF778CA1027F3CB,0x0A535C1F01020499,0x80F4CF1B7B847CEA,0x3CB8C87B66D8DBF8,0xA8D7B35BDD3562A9,0x0305B1595BA3F0AB,0x9D5EE3BA7775DBED,0x00000000000001B7 },
    { 0xBE2096494E5050CD,0x176602A16790EFCE,0x6AA6BA5F0B21F5C7,0x6A1D5DF0F8C4116F,0x1A188A83746ABBC3,0x2B2D3317FD2C047E,0x18067E79B9E5D5B8,0xED9BBBCFC4BE8357,0x000000000000018B }
  },
  { /* Point #3 */
    { 0x0B3B410E6CE8B232,0xE7B399A0018A42B1,0xDC46BCAC1B75FA86,0xD301F31A60747DFD,0x489E0254C1055A3F,0x0CE91CACFDA87D6A,0xA63C714FDBB94D06,0xEFA0D5D8EDDF2A9C,0x000000000000006F },
    { 0x63BF1E9D2B2AC620,0x319ADF796D8C0AF5,0xF6F612742A562804,0x4993393664CE1442,0x5E16710AA19FACF2,0xAAF7FDB472DF19F3,0x941B3E026A2A864E,0x06D197B9DE1319EE,0x0000000000000004 }
  },
  { /* Point #4 */
    { 0xF6A2BF97F0AB06D5,0x9F8DA4F011F2C6A5,0x776A1EB0CB8B966E,0xE74B7349A1903DD7,0x6978C653DAE05C8F,0x77D364C9E1F5B52F,0xF3E29BCCBC7779EE,0x4CD77A80641BA885,0x0000000000000136 },
    { 0xC79B648F9CB2168E,0x1B52D0B7D06DBBE6,0x7B7302BFA65C96D5,0x1EEA500EDC838093,0x83AA1612FB69971B,0x6398CFF0528E16FF,0xA64963A56D95DEEB,0x36F359053D7DA7AA,0x00000000000000A7 }
  },
  { /* Point #5 */
    { 0x7F45CD242DEE1954,0x8E6C1D433F810988,0x97DE2E4AB7E3F9A8,0x283CA85D258D1168,0xDB928C5560AD0F79,0x70A11E94ABDA4F60,0x2D9B7EB20D890F28,0x52C221BBF7B67EB4,0x00000000000000BB },
    { 0xEBA58C5EEAC0E2AD,0xB3D7DD5870F18409,0x31B1BA68A334E1C3,0x7A94F4D4B366CB9C,0xB557081AF4CC492A,0xEA62FD3F1DF87DBF,0x7C2241BAD465A045,0x68C23CCD6EEE5453,0x0000000000000043 }
  },
  { /* Point #6 */
    { 0xF5D6E8ED094FC6F9,0x6E2F20DFAC9C0656,0xDB2D54F646250F60,0x965B2D13BAA2648B,0x8B3D9D63B32319B7,0x444D8A7CDD1B7D68,0x1162327079B086B8,0xFF7B8F1DE4944251,0x00000000000000F6 },
    { 0x0133F7D01BB66AAA,0x3BC785C70BFEF41A,0xAC9A8F7BF042B096,0x58DA5E1B2F8BE6D9,0xD624DE0C2633EC9A,0x32316A1E231C9D35,0xC048FFF3BA1FACD4,0x8115F3A62F919376,0x0000000000000040 }
  },
  { /* Point #7 */
    { 0x3114B122C809B1A6,0x2E3D6E9126A3FCA8,0x0EA11E2BF06451F8,0x5A17B862FEC8821C,0xA6EAEAA3036190B6,0x116F789946B98135,0xC31D82197BD89C8D,0x14A9A6D03BDD85ED,0x0000000000000019 },
    { 0xFD626A66AE211B82,0x1DAA78DB672F6D82,0xA1ADEA20871A7E83,0xB12C7FD1545F434F,0x7EC53DAA5EE1A1EA,0x999DCE130FBBCC16,0xC2D16B2772B4E576,0x47FDC42710D55CC9,0x000000000000002E }
  },
  { /* Point #8 */
    { 0x708003F83C48ADED,0x936A8A382497CE05,0x66F8E450AFECE34D,0x6CC3A161513E1C0E,0xE2FB655E044610FA,0x8AF6A3B362E764C3,0x839A61F18CA809A0,0xD43F2D1EC330DDDF,0x000000000000007F },
    { 0xF4FB698B7ACEE1FF,0x5D19501BCB302BF8,0x393C9F0876AC0468,0x16F8B677FD22441C,0x85662743C504D916,0xDF3D33119C8CB9C8,0x1FEB20EE42F9CBE5,0xECD3EECE5CAD0542,0x00000000000001EB }
  },
  { /* Point #9 */
    { 0xDF70A7CF9DBF1EA7,0x9C5877F69CCEF8F0,0x59F7C3D8B59A29E7,0xD58B7469696BAA2E,0xF5DA4D3327EF408C,0xD3A7D5C612D2C16D,0x2446DC63E6A83CD1,0x9CC740DA43706D3C,0x00000000000000CA },
    { 0xFA86FD40F72E67DB,0x0E3D9678635D7EEB,0xC5AC06C624054CAE,0x9BF35F20CED20367,0xD5D961533EF62C50,0x961B64849D7FC502,0x2051FED46722AE42,0x85107C4D60CBCF28,0x0000000000000003 }
  },
  { /* Point #10 */
    { 0xEA3E826699B3F6F1,0x506904F7FC8AB7A7,0x505378DF30E9001B,0xE50ECC25E233ED98,0xC757BF75F65CA08A,0xB8C40E284BEE479A,0x238DB7DCC50F27D9,0x54B511AEDCDEA87A,0x000000000000007A },
    { 0x7B5E770F9747DEED,0xAE17D13B07CFF35D,0x8782A8E18E34FC8F,0xBCAB7E548A1018A5,0x33D817036477D84C,0xA18F05305EC37AFA,0x395C300AC9E6A55F,0xF3E400AD0ABC2A44,0x000000000000017F }
  },
  { /* Point #11 */
    { 0x7D918578C2FEFC5F,0xECB2FAA969AF2F78,0x64DD465D10069156,0x7973E3FBDAC43837,0xED77E998E829DB46,0x3FA25DA9D02098E3,0x3D1AD35E9FE214DF,0xD5429750EAECE293,0x0000000000000130 },
    { 0x4301E9AE8B7372A5,0x383ADE7F311085A2,0xBD2CE00577DB45A4,0x5F6FF22439FDC0F5,0xB9820B8A32932E4A,0xA9B39A3F46A22332,0x084BC24BA5550B52,0x5BC62269DC7BB3DB,0x0000000000000091 }
  },
  { /* Point #12 */
    { 0xA9C120098D6D74C4,0x862C2E5AC0E79387,0x30E24459EE38EFF9,0xD3637E69764F4B51,0x6440AFAD56E273A5,0xC95CA130E45ADB77,0x89CBD694C96EA2BA,0x9B9C1EDBF2099810,0x00000000000001D9 },
    { 0x48770298E474A5AC,0x5612463B7B903222,0x4D92C48F12DE8A11,0x360E5C32CA366BD5,0x8F16DD03E7E9928E,0x41CBDA9E88BF12F7,0xE7D794691AF3B3ED,0x34C52E7CAA4E82A8,0x00000000000000A2 }
  },
  { /* Point #13 */
    { 0x076F242B18475312,0xD6B988F5D9940374,0x74E80E36F1EFB9A6,0x9FFF616FBFF788BA,0xA25B53907FB404A0,0xA4AA674B8C93908B,0x56A19385BD347E8B,0x8B49A66D6BB58D80,0x00000000000001EA },
    { 0x959C25A42119189D,0x951072D762068A10,0x7CC07783A00F4BB4,0xBC0041A43CDAA6FA,0x6117C1C570674604,0xF4DE3A9587A8AF10,0x0CEF971397DDEEC4,0x8A7D7AB68318655E,0x00000000000001D0 }
  },
  { /* Point #14 */
    { 0xB60582377DC9BB04,0x4456DEF4D5ADD895,0x8F666C3E75BC2850,0xDDA8DDC96E093865,0xD25369290434A0ED,0xAB730D86CB80E1A3,0xB7B403F9DAF7C1B7,0xDE4292B573E41AF1,0x0000000000000029 },
    { 0xE44966F5E5AB887F,0x68F0BCF3EA51CABA,0x513F498A0847DC00,0xF4280FDDEA8E86DC,0x4CB39B4F23A9D203,0xDA1A25BC55BD1F9D,0xB5457407305659D8,0x978C8B6B2B0E8587,0x000000000000019C }
  },
  { /* Point #15 */
    { 0x17B965FEA5AFD6AA,0xECD2EBA43E4067B6,0x51E6D5525969AB23,0x93447AE4F4F7C1D5,0x771C8360A29C04BF,0x5370ABCA1DBD96C4,0xF61D1369D003412A,0x40DF84868D5C1B8A,0x0000000000000058 },
    { 0xE683CAABB7D66561,0xF7F4B520DE16B2A9,0x459795F0925F1650,0x330921CC31560BF1,0x2CFBF019C10CDF62,0x66D45C7C337E3189,0xDFEC76CB952B34A3,0xB094CE1254CE945F,0x00000000000001F7 }
  }
 },
 { /* Table #39 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x8756B00A9F004528,0x20374136E9C2B2E2,0x9E6C6A22CCA54915,0xC5DC6015F6629736,0x5EF3EFA8C4510C8B,0x1FE7836CDCC2CE9A,0xAC80124A0B55A453,0xE430CD86DBB7A64F,0x0000000000000104 },
    { 0x939B5896A385741D,0xA80C7D7E3A6C90E9,0x8DF754D6E4C02621,0xCCC73FF172958D91,0xA80CD923E911D8D9,0xEE0DCA498C0171E8,0x850D8439FECADDE6,0x37550FC24F714086,0x00000000000000C8 }
  },
  { /* Point #2 */
    { 0x8323B86FEC088BB0,0x18EEB2D3E169BF94,0x9EABC22555450A6B,0xFD49E8FEE35C62E5,0x1A8255F86A5D661F,0xB7EE978FFF87B2B7,0x6D59A24739975957,0x8A12C7F513E61BA9,0x00000000000001DF },
    { 0x61A3F3A2B30EA34D,0x21FA89924BE16D8D,0xBA41FC20D8613751,0x10B11B88CCE7E39D,0x82A797D7F79EDE48,0x9559DB4A5FDAA76A,0x445442CE577E7EF6,0x358C9BE06751A909,0x000000000000001C }
  },
  { /* Point #3 */
    { 0xA22790AE7D5E235D,0x6EC954BE4A9A5780,0x26AEEDDCE38FFA50,0xBEB75310EB3FEEE0,0x44CBB50840A31067,0x4A0FF701380E0BAA,0xB23528C820CFE922,0xCFF1AC948FDF6C51,0x0000000000000158 },
    { 0x80ACB80001D7F58B,0x2181A99DAF2D7B4D,0x30FF9020146506D9,0xF091D3057967A5DC,0xB37C10521CD6C51A,0x401010B56B0DB694,0x1B1BC5E960FC5F73,0x8AB0CF8EAB3AAC42,0x000000000000019B }
  },
  { /* Point #4 */
    { 0x686698E89CAFE97E,0x3F2A465DB6891510,0xA99BCD91C9AAD498,0x0C7AE217A47C770B,0x95067A8B6A5E6F06,0x0B55DA4025A11429,0x5372B805997CABFF,0x1E8BF414963D233F,0x000000000000002B },
    { 0x1343EBE6AB613409,0x7AAB5A01AC96CD26,0x243758AF112C0B65,0xD276E441B236CAD6,0x88A7D43F557111DA,0xC6DACE8BA0F46068,0x866C31EFCF4A5CEB,0x6DD991B89554F30C,0x0000000000000066 }
  },
  { /* Point #5 */
    { 0xB7C90BF85B923896,0x42F96BAFD3F08076,0xDDBD3B0B0BD90A84,0x8ADBBB43E00A7E7B,0xD3205108B2059C91,0xCCB379B76223FD65,0x2C1EB7E2A6F8571E,0x13F3BC56D80EBB13,0x0000000000000092 },
    { 0x5E23BC738D30DF11,0xAAB73A1F4AABDCD3,0x4CD660823E764E18,0x942328161D0C98C4,0xD8B64C225B5048F0,0xAF741F8AD2A17F6F,0xC1540070CDB03F14,0xA16E5E67A2476EE5,0x00000000000000A7 }
  },
  { /* Point #6 */
    { 0xECE31ECFFE1D1B82,0x368C5AC029036CFD,0x217420AFA13FF567,0x1B29E5F077776B5B,0xDD1A5DDA98F42D23,0xBA05233BB6C34257,0xAEA7D3BD2D56E9B5,0x3D5777E784E7205C,0x00000000000001C4 },
    { 0xF4DD56B5E7C6EB47,0xC479B9D64A1B9D04,0xFA1D38A48117A210,0xDC603246DFB5A934,0x9E8156ABDA0675EC,0x6937CCCE0EF78EAB,0x72DD487AD2E5CC67,0xB735F780D372A668,0x0000000000000049 }
  },
  { /* Point #7 */
    { 0xC3B2ADB729FFFDEE,0x154F4D7951FB8606,0x56E497FE9D7F4B0C,0xE5E69FAA0DF7FD94,0x1891FE5D114FA3CA,0x4162F0E9045C3286,0x98DE02C4780253D6,0x703080027947B60F,0x000000000000019C },
    { 0xE77F7B12A9510BD2,0xC663FBE72D32A857,0x6538A301B9274D4F,0xB2C191D0BB01302D,0x567474F26366BBF5,0x8446925CAE1E52E9,0x3EE00EA9209B55E8,0x3D76982D2419E4BC,0x0000000000000091 }
  },
  { /* Point #8 */
    { 0x08136CBF025189D4,0xA1C389CBC1B25A05,0xBECDADE76E9ED11D,0x6557006BA7F3F38A,0x96D6C877BC852DBD,0x3A0AFE4BC53EFD4F,0xC7F58410FEBE4737,0x86DEBA3B84E35E2F,0x000000000000015B },
    { 0x96256DB24DFA7DA8,0x379735573DCCF202,0x2E0B263E8FCC1274,0x14870FE89EE7B82E,0xCB8F9BA5425CA276,0x683C748E7D876E79,0x48E990D5DE2F2CFE,0x2ECC8F1F48547013,0x000000000000018F }
  },
  { /* Point #9 */
    { 0x15DBA0D81DBEEC0A,0x6A1671E23145554F,0x6F59000813588C31,0x404B6424783BB97D,0x30502B92CC7922FE,0xA1BD25CE1517A238,0xEB81E9DD5FBC51A5,0xEA919DF3BDC3B1F2,0x000000000000009D },
    { 0x70802002A4AA5953,0xB908E35D23FBDF34,0xB47DDC1AD971A142,0xE4F88A184C6EBD7D,0xB2F7177F3065ED39,0xD7B8CC98162B61AA,0x8472DBD5774C6AD4,0x8D1DFEA98F87D2D0,0x000000000000018A }
  },
  { /* Point #10 */
    { 0xADCD31054115D224,0x1FDACDEBB7FED1F1,0x878FCB459E5A2448,0xC3910EABF7E8596A,0x5FCA4F0E37F267F6,0xD10D0AA06E9FB79F,0x589F94624B12A182,0x2864C5ACFB879DB8,0x00000000000001FA },
    { 0x6C024C2C07E34963,0x49581CB82DE2A43D,0x4CDCC98E29C06B7F,0x338A9C59B976F565,0x38540BC223C8FF24,0x53F3C9B98BC61D4A,0x3EAA8166E3913CD4,0x4620FE57455E4018,0x00000000000000B9 }
  },
  { /* Point #11 */
    { 0x22D05A079995B39F,0x95D85F0E97572E8B,0xCD0262424CB31201,0x15C10195A9661CFF,0x7366E9943D4D42B5,0x3D89205FD08B2304,0x4F08BFE1C72F3319,0xF2BB6FEF51DA0362,0x000000000000000C },
    { 0x61689ED6DAA8789C,0x1342F413C80EBE32,0x10E3C8BC6CF15C5D,0xB59A6F209E380E00,0x6FAF882B16A0A01A,0x5B43FF2C96DEB592,0x61FFA81C22CDA20A,0x825E5E4545D1497C,0x0000000000000070 }
  },
  { /* Point #12 */
    { 0x0724E185FE85076B,0xBDA15C151E532717,0x6005728065E7C149,0x1A0CAFE8158E6817,0xEE796AD900BAA1DD,0x8FF14A074D3CA73A,0xF153C867A3604F8B,0xE07458B5C4CA1BE8,0x00000000000001C5 },
    { 0xB8C4F3AD8F7DC861,0x98FF4D7F6C38D10D,0xDA77B9018C10E7A5,0x448FBC787D69625B,0x91FF7124ED5DCB7B,0xAF0FB28BE310D65C,0xACF3CFC0C388141A,0x2D3D003454BBB99C,0x0000000000000097 }
  },
  { /* Point #13 */
    { 0x9429698B23371E14,0xD9D9270C3FDB1B92,0xA4A76289DD4BA2A1,0xD9DD43D69AD4DC60,0xBA76236063DC6801,0x210BE4E3B8A45231,0xAAA24379F764E727,0x7B1A75A82B1FED01,0x000000000000006D },
    { 0x89E40D215F621487,0x70C38498A2F303D5,0xA88CE1890FAFFEBD,0x0CC0EAE6735EBCEE,0x2B755A3D8518C06B,0xF3CD31DC62F92C33,0x6F7FE733C7562C48,0x749F7A1C83B00376,0x00000000000001E2 }
  },
  { /* Point #14 */
    { 0xCF04E87527A5499F,0xEA912DFB28F3FC97,0x4A9E4E41D59EFB52,0x9CCB0B83F8F373C7,0x684D2D75BA1B61EC,0x15449A0254D58701,0xEE02C9456A4E86AE,0x5887A0882069E1DC,0x000000000000006A },
    { 0xCF7BFC8C922649CE,0xB4FFF12E522A5024,0x262BF90DF6D0066E,0x97AE80928E0B0AFE,0x7191C6FE18507CBC,0x54E973E1B2AE3EE2,0x41B734BC7BEA70EC,0x38975BA3B3F6B89B,0x0000000000000138 }
  },
  { /* Point #15 */
    { 0x704D466059D5D8E0,0xA4A222B252D7CA1E,0xA45B5CE29C26A86E,0xC9668E73DFB9FB62,0x13EFDE0AD58183FF,0xDC752A59850DEDB0,0x0314CBC5EBF8C27D,0x279680F3D1AB5F41,0x0000000000000118 },
    { 0x3B8A1D583184E940,0x8CC52F17CD1FA6C1,0x5118B9093F701026,0xE04D31DAAC34A4AF,0xF3A66F73282FEBAC,0x05018340E8D029F8,0x1A8BD0002058C971,0x61198C7E7E962723,0x00000000000000D9 }
  }
 },
 { /* Table #40 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x11446EFE378CAB85,0x4C3C68CFBC48BF6D,0x5E51466164C19BAF,0xC0F00735D5CBB135,0x5D4844A7A693B1A9,0x517A48719579FDAF,0x5EAD064B532C1E6E,0x60207C2D4135ECB1,0x0000000000000172 },
    { 0x4B033A37843DC902,0xB2D3664CC27A9863,0xF4EBDC3518280E54,0xAC7789A6AE02B757,0x50084BA410DD96F8,0xCC3459371F5F6349,0x5F65ACA8FDEE6F84,0x4AAC5F5902D841CF,0x00000000000001B9 }
  },
  { /* Point #2 */
    { 0x7C44096F532856CA,0xF054AC944D701F46,0x1BF992E78DE81577,0x871D2DF2A90A4D2E,0x963357A5775CABE3,0x2E92D83DBAE3AC5D,0xC39E645C415BE4DB,0xBCCA60E29781B22F,0x00000000000001C9 },
    { 0x638CF76CFC5374ED,0xFFBFBC7A24278420,0xDE577D69E7668BC6,0x88444FDEBAB7B568,0x4CB8237B59D220A6,0x02186C1C25B582EB,0xE4A04CB19B639F32,0xD12B0E644590E20D,0x00000000000000AB }
  },
  { /* Point #3 */
    { 0xFEBD71BD638C39DC,0x599852C1016E39F1,0x678D544296EB6AF6,0x4A1CE1D01EA773FF,0x23FA5FFD62AD7D21,0x845CAB528C41D004,0x60A4CA10BB683C2A,0x62092692586ABA40,0x0000000000000110 },
    { 0xDD30D6A108262627,0x410CD76DAAB1312E,0xD781654887EF2A6D,0x9CA850C7740171C0,0x6881C9BAF4E746E6,0x20B5F165DF470442,0x09F109D2A625D961,0x64CF9864C1D1DF61,0x0000000000000078 }
  },
  { /* Point #4 */
    { 0xDD0F09B1BB55F47E,0xFACBDEF0BE55C9D6,0x8B8B1A9CBB62C5EE,0x617FF446EB8F0BBD,0x24176F925C1EFE94,0xF27AE452962F4019,0x3B812A15220FC04D,0xB17B1B9BCC92239D,0x000000000000005C },
    { 0x9200F2E48A465257,0xC8CA2A1CFBB69960,0x5410EF875A8FF2AA,0x87BC97B0E11B6896,0x1D3A496952263F49,0x2ED88B0BCCA15D27,0x90AB34C1765C9300,0x719D9BC7D2630404,0x0000000000000010 }
  },
  { /* Point #5 */
    { 0x22AF165C7C4C1251,0x0638EF62B49D08A6,0x80DFF98618ED98CC,0x8E3B7186A541C5E5,0x3C309734D0F729D4,0xC34393632F30C85C,0xD90474FA3B099E11,0xDC726A4A06C8C546,0x000000000000013B },
    { 0x067924361A531C8F,0xCB5C860E3C2633CF,0xFEF97B7EDCDE99CB,0x085E6288E4C02691,0x08C3E30C353255D8,0xE50A641CBF01A904,0xBE2980B1108D6EB6,0xD5547FB7ED2BDE9D,0x00000000000000DD }
  },
  { /* Point #6 */
    { 0x6366CC838D9E9C1E,0x6DA8B24C7CF6EA2B,0xCF34AC0834A0C6DD,0x957954DDE3A1BEA6,0x2EA0EF68F4060336,0xE61893A5A84FDF5D,0x03CACAB47BF522C5,0x823249DD0DBF1790,0x0000000000000145 },
    { 0x2EA0344DAB3E90D0,0x5C70CC712BCCCC9C,0x5EEC27550063E840,0x3983CB1BBE50D3A5,0x462B3DC27B09FF44,0xF779391EDD6B34BB,0x6C00D9B8BBF36F70,0x9E0EB0D1F82EE371,0x0000000000000080 }
  },
  { /* Point #7 */
    { 0x7881C53CF443807C,0x95060F3C861089DC,0x0B4066840B096123,0xBAFDECBB86A8D5F6,0x2F5961BF5C89A0A2,0x3034175A6AC1191D,0x7521B10B4F1CBA38,0x96EE1BA8A7CF95B1,0x00000000000001AA },
    { 0x51B2B27B13DFF296,0xA3597D7110683230,0x82C4A1CEF1026F39,0x9ACDB7EA363F89B3,0x14E0797F30BAD05E,0x4BCB9331C9F5C1CF,0x2DA2F33FC248CD02,0xE9409B9FCE32B8E1,0x0000000000000072 }
  },
  { /* Point #8 */
    { 0x41B4D05BD15E752D,0xCE20B1F846E78FAF,0xB529CC0108D808B5,0xD934F10F2210CF60,0x9F2E7E1BE41ECA93,0xC09DA7A94D82D15D,0x45A84216A1ED7860,0x9F6FA43DE6BE684E,0x0000000000000109 },
    { 0x592BD464ECF53A79,0x9DAC1BB8349754ED,0x79BBE62284339A7D,0x29C3D4AAF9F4FA5A,0x4788CDA816DC4698,0xF94EA4495C3060EF,0xC5F4191DCB3C2B37,0xEB720D23FF69861A,0x0000000000000026 }
  },
  { /* Point #9 */
    { 0xFC1863B7B7A1C131,0x3749D27E292BA627,0x702B739543E2E8C2,0xBD851DD886802DB2,0x07262573DBFF8E77,0x17297732BFF806FA,0x4C51E1E9A17B5A68,0x7A1B65A2E3C6ABAC,0x0000000000000105 },
    { 0x40339DA702489D0E,0x8DCFEE4E200AFB73,0xE7E598BE0978EF4E,0x6F9B982D7219DD92,0xC0907C77E482628B,0xE7408352EB31A7F0,0xDC07BEBB40FF8FB0,0xE4FB9626E060FA27,0x000000000000012E }
  },
  { /* Point #10 */
    { 0xD2285AD12CAA3808,0xB871463EFBC2278E,0x361FCADEC889C9B8,0xF261C688541E9CC3,0x2CDF861C7A27B983,0xC97AF02CACC87384,0x7A80F6087638D824,0x79852D0B79663AAB,0x00000000000001E1 },
    { 0x9A2B626F98893CA3,0x31A7D784D1E24597,0xD230ABA2129EEDBD,0x1D339471D270BE5E,0x826C3DD781950B28,0xFA1B74C66B0B44F4,0x5D2131E993FDBBCE,0x78176AD853EABDFF,0x0000000000000002 }
  },
  { /* Point #11 */
    { 0x8D703BE27D6E0745,0xEA52D39EC46BF190,0x6D139E517EE2ED74,0x407E6A9E9236B950,0x4338CD4B8E424F58,0xFDFB4F8A3016FA2F,0x0329A85512A8E5C7,0x9526AAF9A4259578,0x00000000000001C6 },
    { 0x587D6B0459BFC10A,0xB0047278FB7066F9,0xD27E120721324027,0xEBA345BD076DBDB1,0x543ABCA7D2CD9360,0xBAA528B722FBD86E,0x02942B0509B586C1,0xA91C8F581F0E7DFE,0x0000000000000132 }
  },
  { /* Point #12 */
    { 0x52DF1DE37F4C74E7,0xA1554957C7C2A420,0x2BB5B1A7A850B73B,0xD0B58ABF05174618,0x09C054687BB9DC77,0x50CCA4A64E6B8E44,0x53298C54A61636F7,0xF0325227718F824C,0x00000000000000DA },
    { 0x10F1DE0BBF549E72,0x7153F47CACCD5CD7,0x9C171B49425ABF63,0x9902C984EAC3D535,0x9853A7DF0A098AF6,0x7F88102CAE0627B1,0x318EC476F6BD8690,0xACA786DAE42B065E,0x0000000000000069 }
  },
  { /* Point #13 */
    { 0x1EBC2D022DC5F96D,0x13F5B2B3C4D032BD,0xB94C8F1F5F4C0EAC,0x50E8D4FF61863205,0x1B5F74C5A8B2AA3C,0x2D3B84A7CEC4B4DD,0xEDFBCFCC16208506,0xFD96A71D39324FD7,0x00000000000001B2 },
    { 0xD7A1E4AB254368F6,0xDD6DFB9BAA4E3C3C,0x416B02FEA06770AC,0x12DE3DB33561F699,0xCB4DE872A7F8B36C,0x418A843A5D89699E,0x6EF2BBA49C875832,0x2F7A007C32817F78,0x00000000000000B6 }
  },
  { /* Point #14 */
    { 0x75EB8D356BC9662A,0xFDD82D5F0D8BCB50,0xD8CAAF4B9D8AD82F,0xFFB9E309D0642731,0xB514EC984DA42A1E,0x9A765C8A7D4421FF,0x0AD7D2BE7E9AE93D,0xAB4D7910C97FD28B,0x0000000000000130 },
    { 0x4F08B836FB2B614D,0x259737DCA73051D0,0xEA3C3BC8C30AF31A,0x5CEE4C934A11E8FA,0x4BE3E8E3B1FED7EC,0x0B313E360052C235,0xD760058F5F082363,0xC6E58D205FCAE886,0x000000000000000D }
  },
  { /* Point #15 */
    { 0xB38962A90FC51D07,0x2570FFB7C07D92D8,0x3C8511001F351AB0,0x175E620084C21F4D,0x8F15954832295D53,0x1CD6495AA5A9BA09,0x0C3517CC9E1B6240,0x0E2631660393E7DE,0x00000000000000C4 },
    { 0x1C206BE0B76F7B20,0xA15FDB2B51AF63B6,0x64E4ECB543191F7D,0xACC8FB7DAB5D343B,0x722E390FFF230243,0xFA72E84BBB77EDA3,0x72967CB0CA3070D5,0x93524CCC81C795AA,0x0000000000000192 }
  }
 },
 { /* Table #41 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x7B9409BB42DF612F,0x32F47DD21BC66A3F,0x213F80E023F375FE,0xAA71C57F06AA6C21,0x5BF7B3A784298947,0x001C2C965B608FA3,0x417619C6173C7F4F,0xBCFF66ACD4A20677,0x00000000000000B3 },
    { 0x81B9B5640603BC79,0x8F39155EF875E591,0xF6A508FDDFD32C0D,0x7EACE6F96B0DAC71,0xE40163D89E4C1EB3,0x265226C5FF10FA6D,0x1E1AF5CBDA76D272,0x954BC056A10DC788,0x000000000000012C }
  },
  { /* Point #2 */
    { 0xDBA8E40547F7153B,0x73071FD967DBFEBF,0x35881EEC4441A2FF,0x50623C475B31B917,0x8F09DBF6C2BAD8B3,0xBF1F09CD90BB890D,0xAB770CD77F034FDC,0x45B959236B7D98B1,0x0000000000000029 },
    { 0xD2EF1E00F599C343,0x1289BDB17024D641,0xED8E7886F4E36687,0x4AD57B343696269C,0x69BD1B6E70BF3629,0x680F08622BAB0453,0x1865F02A68E4B123,0x7BC5DBF3E8D8AB75,0x0000000000000150 }
  },
  { /* Point #3 */
    { 0x02E206C37471A905,0xB6CE013934D0C122,0xCDA8A158CA1EC8AD,0x17BA844B6EB26374,0xF8DCA5A62AE7179C,0xDAB1DA42807AE8F2,0xDCC18AC94083D6A7,0x1464E68EDF65F291,0x0000000000000038 },
    { 0x6599FD7BD22A48C2,0xFD36F482477ABE8A,0x403663C930756F73,0x1B38F348805B2E09,0x213FEB71C142D148,0x9878091A8855D42F,0x317421962821AF05,0x9023473580457E5B,0x0000000000000053 }
  },
  { /* Point #4 */
    { 0x4F6BA84D09ED0733,0xDB3908D14BF2273A,0x33BCFF3F3A074347,0xBAFC83C622E849CD,0xFB13992CEED3B0DB,0xD24DD41D3C016BED,0x0D15167AF6C72694,0xE06346BE162238B6,0x0000000000000050 },
    { 0x28FEA53455D96852,0x46AEE84A3F0CEF9E,0xB8AF77E1775A77A5,0x63E3B7FCB66F217D,0x763CEB6796E84554,0x39B7EC8ED79B3203,0x62E24B184F17B166,0x873EA1AA905054DF,0x00000000000001F4 }
  },
  { /* Point #5 */
    { 0xE410D8F75FD30BBD,0x966E71D6031CFF85,0xFE51C6C9A6F4B6A7,0x6AA83CA8D5681412,0x28A61D2E57A5D801,0xB699F6CB52BC0413,0x1729F8D0443BB821,0x6E22F51204452A00,0x0000000000000076 },
    { 0x7B51FFAC0CC2608E,0x370F9A54495E770A,0xE32A66E2F574B07C,0xC3EAD5C57C808C30,0xF04BDEBD20D3D51A,0x82B07F2804FFD31C,0xD2D81AE3B6DF8FB3,0x3978BB58002EA4E2,0x00000000000001AB }
  },
  { /* Point #6 */
    { 0x35A5767A91F7DA33,0xB73136937BA4DFED,0x3843D6C37F7E4D30,0x6F461C6BE2595A8A,0xA34766D014105BE4,0x62D28311D7C9924E,0x7BFD28110F51F78E,0x9CD30FB24B760751,0x00000000000001C4 },
    { 0x739B01BC3391726A,0x82721AEF5FDE4FD5,0xF3EC542DEA71F1F2,0x520FDD3458345718,0xEF2A3D6F54BB2D09,0xF75FC3FCFAEB5530,0x6FB68582F73076B3,0x27D3835620E57568,0x00000000000001BE }
  },
  { /* Point #7 */
    { 0xF85C1B6A18DB2823,0xDA36FA1C2203EEA7,0x81F96771CDAC541B,0x52E33F39605C943D,0xADF4C06637C23121,0xE9E5AA4B8AD2C86C,0x3D4A61630354AD23,0x44B4D8EBAE152C75,0x00000000000000FD },
    { 0xD5D3D35DAB2D2652,0x55B6F8ED382B2FB7,0x3A1EEE79A7E69B83,0x98F430AAB5C6DA08,0xF4AF6CD956CCE57B,0xD67E787B7AF2EA27,0xC276F0A7D8841E4F,0x2E23F60FC0478C59,0x0000000000000026 }
  },
  { /* Point #8 */
    { 0x0DB2B099CAD6B074,0x4749379C2A6EFC26,0x31862F75AB64D63C,0xA465075D1623E85B,0x5F03BBEA00E7E1B8,0x24EF8956A2C133CF,0x6F9FBAD452533CA3,0xDFB15DF3ABF81B19,0x000000000000015F },
    { 0x0616FD242796855A,0x4A9A066C9CBC946E,0xAA0FD8EE347283F1,0x63BDE9ADF15AA16F,0xBDD5677A9277E9BB,0x5EC032E2D045538C,0x5F4EBA3ABA8C76FC,0xA17D2872088E500C,0x00000000000000A6 }
  },
  { /* Point #9 */
    { 0x7FCBDFED7D699A94,0xC7EEAD04B4EA860C,0x76A4654DA80BB133,0x9C5EE058335D67C0,0xCC9D8C864570D4A7,0x722DBF93506D2B29,0x67695F340018F3AF,0x6BE99994B4AB6DDC,0x0000000000000146 },
    { 0x9B73CBEB15233C45,0xA6B8CC37350BB94D,0x3882EACE4475BEA9,0x5BD1A8950FE6A2FD,0xFB7F6EC4F6A6AF41,0x5C0EE0F9F6C34E25,0x12FA72593077130B,0xEEE54FBDEBC3EDA5,0x000000000000013F }
  },
  { /* Point #10 */
    { 0x4D3F64EABEC21ADD,0xFCCE9178F4D15EFC,0xCA6A52AED923A534,0x784A171685C3D354,0x279A093D243591C0,0x6AE62AA0140E6DE6,0xA92DBBF7CB014691,0xABAD8D7C2064E1A2,0x00000000000000F1 },
    { 0xA7198484A6EE25C8,0xCA7892B751BA95F5,0x96403D2819EFB1D1,0x21B723C20B920D11,0xEB8EA429D6A26E06,0x7D332C0970F9557B,0xA707E8659C2EFAE7,0x1BCE8D44CF2652A8,0x00000000000000CA }
  },
  { /* Point #11 */
    { 0xFE16530A64991075,0xC1EE5B794C26BB58,0xBA74FCDB11F34D7A,0xC2249005DF9FB241,0x3208FB5F42CB9CB2,0x0D4BEAD8C54C1CFF,0xE81BB7B641EF4746,0x36C8B1DAFAC2BDEB,0x00000000000000AE },
    { 0x2CCCF150D9673E05,0x47D5B10696BD08CF,0xF9BB4D5D7287369D,0x8F4D1D0633986A37,0xEF03903DBD23B267,0xB5A94BB00DA9403B,0x3D1F2753661DED77,0x0F2AB312D5DEC6CD,0x000000000000010B }
  },
  { /* Point #12 */
    { 0x29A51DD23BF56830,0x3BEE0EA01C8EC71F,0xEDFB3C59BA509806,0x76C0656A65BF23F8,0x2D63192A2815E5B7,0xE15EB8341008B40F,0xB7038F7240D299F2,0x89BD0F66E797CE64,0x000000000000007E },
    { 0x75AF78D1101BC0C2,0x3D3CC1737BEE9E5C,0x6E06BE87584108ED,0x7F8F50E35436141D,0xDD6779373960C888,0x061BFD9B416F251A,0xFFF2C5986C599A6A,0x32D6F9B53F1C5253,0x00000000000000A3 }
  },
  { /* Point #13 */
    { 0xF5730CF9E291354B,0x9488B1DAC7144B0F,0x3DCF5AEF142AD7F6,0x953CEB6ED35F7489,0x1AF4DA31FF1FE56B,0xAC9330B29EDCB503,0xFFBA50F0ADCE304E,0xD462BC6C75A6E9D1,0x00000000000000BC },
    { 0xD47CD878AF5B261E,0x2FA533F06EAFBBC1,0xE62C6ECE49E987F2,0x0A95D69E3203EC87,0xDDBDA1EC84D10FAA,0xDDEFD8F61D24612D,0xD735FC4C5592D62C,0x6264A9F7BE6489AA,0x0000000000000045 }
  },
  { /* Point #14 */
    { 0x7F2896F19FADE403,0x2F68E40858DBCD32,0xEFEEC6F77F60A3C3,0xAA12994AA9BEB1D0,0xA0C3C4BB003DA505,0x09039F138307C5AE,0xE0C06FD14EA98C0C,0x18052D29A041DE86,0x00000000000001D0 },
    { 0x7852BC3D9D4F7390,0xA5F199AAD532B418,0x22E5545AA33FDA46,0xDE9F212BB17986F5,0xDC9766D719D462A8,0xB3FCC67E311BC55D,0x656AF2C7CC577167,0x39F57C3A80ED833E,0x000000000000010B }
  },
  { /* Point #15 */
    { 0xE57AE340F975B450,0x82646F87AADAA0B0,0xFFD783C246584D65,0xB2170481030A2563,0xC1D485AB0BFBF176,0xF85E5D93A4B5C714,0xC58F74D3284CA3F9,0x8F302EF2A8FA88E1,0x00000000000000FC },
    { 0xBCE7F7B0CAC239B7,0x512643CD325B5A89,0x8A17424CE2BFF3E8,0x32BAEF2CEFD1395A,0xC69F26443084BDF1,0xDB5A3BB8CB57E824,0x3391F528337074E1,0x57FCEC1844526B8C,0x00000000000001DC }
  }
 },
 { /* Table #42 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xD8FAA3BCD4CD8948,0xDDC437839D2888D8,0x1E951BD5581ABBA5,0xA52DFAB22947D11F,0x8FBB0ED8728A40EA,0xD4F4D06F31D769CC,0xD93B1D93FAC908D2,0x8852B438F5A3B0CD,0x00000000000000BB },
    { 0x84EA0E03C8C88DE9,0x621A808863CDB21F,0x332C292ECD6EC216,0xFD01EE09C4CD0DCA,0x5354EC9EFDFCE95C,0x05C307B2A6B8DB30,0xF7B254EAB44784AE,0xD38481257E61408A,0x0000000000000128 }
  },
  { /* Point #2 */
    { 0xF9B815FE2F1993F7,0xE1F5199A3ECCE0E2,0x8898D789AB10A910,0x49863DAC4E863533,0xB5F118AA5E465BAF,0x10D031280281E10B,0xC98361355042343B,0xC2140930BC68242D,0x0000000000000073 },
    { 0xF1417466E84F3896,0xD4167F1323DB4590,0xE5347265C7699F09,0xE4458198BE6204BC,0x9375296868D8B7A8,0x49757C532A065D8B,0xDC0856FBB6927E83,0xB1679B0C56449CF6,0x00000000000001B2 }
  },
  { /* Point #3 */
    { 0x1A80E022F6B5E497,0x210B6F4B8D73860A,0x16F2E7BD7B7F92C4,0xDED9E969D068DE98,0x68105E12546ACE60,0x56A0C5B0EFB6F66F,0xF0D5FDB985D590D0,0xF15E274FB69D5821,0x00000000000000BB },
    { 0xD8D0621DDE543268,0x9E0AB44C04B71011,0x25C135CBDB9FE3CC,0xF0A9044B024B4CE3,0xECFB54FA49D2589A,0xF57495388BCA2C50,0xD76BF119F8F8E5F6,0xBD946E2C292A452E,0x00000000000000B2 }
  },
  { /* Point #4 */
    { 0x1D43440F28EB6FFD,0xA97797D41FAA5C82,0x14A960425C895EEF,0xD35E5D8CD4FA3E4C,0x9E68F293277B5084,0xBF5B8A162BC6B1A0,0xA1D47A38CF49A617,0x703E609E62FD2244,0x0000000000000048 },
    { 0x5909FBF6C6AF3C4F,0x1428B8357C1975AB,0x30F8A30810400297,0xD753559F5B5750BB,0xBC5235EBF99FABB3,0x588AAF0BCAA35305,0x13085ABC579DC86E,0x793F9EFAFEA9393B,0x000000000000000F }
  },
  { /* Point #5 */
    { 0xD1E60E5F8256720C,0x171027F57C49FA90,0xF64E8839F6549F3C,0xFFA1490469B799B0,0xADD4E8FB34553FDC,0x7CF91923741A95BA,0xC9FA2FE993A1BA5A,0x5D9E34020980ACC1,0x0000000000000020 },
    { 0x2A5CB99C98D2C9FF,0x448896BF6C3294E9,0xF76232CB81E067A4,0xBDA3583A3757184D,0xFA41813B2E0C61AA,0x6BA2AEB6C106499D,0x93782286A19E4B30,0x13E2306F86E8C59A,0x00000000000000A4 }
  },
  { /* Point #6 */
    { 0x6F8275E50E37EDBF,0x64AD3B76DB3E6343,0x2EEF15036A5161EB,0x2C60875ECF10D729,0xD477F32A9424CE59,0xFBD5AB3FDDD91BE6,0xBE1F16DFAC18456B,0x88E755378DAC1A4C,0x00000000000000D1 },
    { 0x4F8E076E3C10F2F8,0x04F48BA57A6BC509,0x8B825C99420B54D1,0x35FB71DDD7412044,0x1D954ED2771B6D9E,0x24EAD049473E8A03,0x513FF05D28BA193A,0x42D94D2C7A8ABF0C,0x0000000000000143 }
  },
  { /* Point #7 */
    { 0x5169A5BA3792D0E1,0xA94F38AE866A52B1,0x52123A0860F5270D,0x3753C8F7A5B51694,0xC28F1BD14C0DC22B,0x39279193E55184F5,0xB9FE5BDA528C4498,0x1A04E978BCE7DE75,0x00000000000001C9 },
    { 0x95B584D1ED890690,0xD02B7FC965D82F4A,0xA630A8DC3F0B031A,0x79759D955BE69E84,0x8CDB211F45539242,0x523FBD101032DAD8,0x40C47F4D5B003E94,0x02DE551920D6FD97,0x0000000000000144 }
  },
  { /* Point #8 */
    { 0xF63486B5CE9C07A2,0x109221F7B9B5E762,0x0450B6C79210D1CA,0x8A9B11B1CC780322,0xF33C4701A30BFDAA,0x1A7D75F3C33BFCA1,0x4EE930E51C13AF9D,0x3CE4223BCE402AA2,0x00000000000001EC },
    { 0x2FFBFAE311FDD6EE,0xCA5F04D003C1EDEB,0xBD80684A5D3A2E52,0x98D1A18D54193AB1,0xC549CECEF366FC87,0xB194E11AA13EAD38,0x6ACAF7B21882660A,0x686C0C7BD2CAD2AD,0x00000000000001FF }
  },
  { /* Point #9 */
    { 0x1A90DEFED7B4FDED,0x195BEE8F6336C055,0xE843D42796A94272,0x86CAE8E64D7DD6E9,0x5403B7B7119151E0,0x3314AFC85037DA6B,0x6D7F8F8212CA9455,0x3937BC09B94463AA,0x0000000000000081 },
    { 0x306E5A03CB8E9B37,0x126473043C8B52F2,0xC869679EF93CAE12,0x20F33375AB4F3D13,0x90D9C5CF0501336C,0x35C85984849DF5EC,0x42F846286244C6C3,0x901D2A938B835C13,0x0000000000000113 }
  },
  { /* Point #10 */
    { 0xB584B65394932B53,0x68AAD973AF36CDD6,0x2AC829A60BB4CADA,0x403367F33F0E5D18,0x412B28AD7DDA08E1,0xE7841355E24B3863,0x5171C588093520B9,0x9DB8DB4C5EC5762B,0x00000000000001D1 },
    { 0x8D3B541EC6238D25,0x586350AEC23DC89A,0x8455DA87FA4D8C25,0x7ADFDCA316492352,0x8FDB5C08C81F1590,0xD5E01E0324773E80,0x4A3B7F13DCC95928,0xC08BABF4F80B2FAC,0x00000000000001E9 }
  },
  { /* Point #11 */
    { 0x37D8AD51452F6968,0x9ABF76030BE46391,0xC64BA0AA4F51F996,0xB71CF4B72BEF5FA2,0xDADCBF144AEA3ECC,0x86619A4A5CA7ABEA,0x17BBBD06AF54E743,0x70C9D3B76D5362EB,0x0000000000000057 },
    { 0xF2486BBDFBF53393,0xBF16873CB87C38AC,0xCA1694B587557348,0x95AD3CB860DD9D75,0x61177E70B097E1EE,0xB481729FC4D1FAAE,0xAA07352130F14CE4,0x8C3E81E6E534F9E6,0x0000000000000104 }
  },
  { /* Point #12 */
    { 0x22D3054C1AB5373D,0xBD4F796363ADADC0,0xFB4298FF2650904E,0x2801E275EBDBC2C0,0x1122EA0608190926,0x41EC28D8B2E79279,0xCE049E5276667FCF,0xC84223FA732778A4,0x0000000000000081 },
    { 0x56BE4933666FF503,0x0B396D37BCEE9583,0x1B469E0E153F80BE,0x3D42CD0932305DBB,0x8C0D230527134EFD,0xB90A2ABB08752F5E,0xCE873BE8B5B796DD,0x6A240D331B25403F,0x00000000000001D4 }
  },
  { /* Point #13 */
    { 0x86AAD63F60740F5C,0x32B7CC316EE3EE57,0x14340252A16DF7D9,0xC70632BD30867552,0xC34AB941E536C3EB,0xB8CEA58F1B8C9771,0x4F12848942876FC8,0x2B6009FCA2B9447C,0x00000000000001ED },
    { 0xC93452D882B5E6EB,0x29958D78AC7DEE6F,0x22DD8FD9BF6FA7E3,0xC59C69516A75F72C,0x1C6101E36123B596,0xF5907C48E3F2D479,0xE5D0B6A671BD58B7,0x840FF28C56D9185F,0x00000000000000A7 }
  },
  { /* Point #14 */
    { 0xD89E1FE8330465DE,0x73A9C39780EF0EFB,0xB8200EF38ED739F2,0xE0914B2F6EC1025D,0x7F277714866A3EC9,0x1C9B4CD05716D865,0x176D3095167F3A3E,0x85A16F0AFCCCAC3C,0x0000000000000177 },
    { 0x767E84814F1E3019,0x88B991B861F15FDC,0x26CBCB752A17701D,0x79F801348EED411E,0xDD053C40411302FD,0x35D3C2F030858F66,0x0B53DA7A9107A692,0x9452396F37F9CACB,0x00000000000000C3 }
  },
  { /* Point #15 */
    { 0x961404136BC539E8,0xE6EDFEE1E4524C6B,0x09749744D07CCCF5,0x1748B47EC03BDBA2,0x2690D0192BC9C91E,0xD3F34165BADE77F3,0x1903C781805EE388,0x56EDE14320EE5637,0x000000000000015F },
    { 0x4300285A7B5B9F4A,0xDD3A022F1B6AE86E,0xC54A8ABE376288F0,0xC1D8EC4F26E3394D,0xA3979D7B91CE3AD0,0x0AAF9CE7D1798CC8,0xE972A6D14649A9B3,0xB0D0E5B7F260DEFC,0x000000000000002B }
  }
 },
 { /* Table #43 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x327EEC483E206F1D,0x20BAE09CFD9E0124,0x90E15A5012FE91F1,0x0DD6DE71359590D6,0xB47FF7877346265F,0xF68C7538D72B31FC,0x1210AA5E853E2029,0x22955A4DF09C0C81,0x0000000000000040 },
    { 0xE194DBA07335F4A6,0x9D6532FB4BDE2F58,0xFAC563C59016930A,0x626EAEEFAF9E2095,0x7AF29B71B7D9FDE1,0x809B7FE436360BBF,0x57B5E52DE3CD1C8E,0x52B9040937B01251,0x0000000000000032 }
  },
  { /* Point #2 */
    { 0x7EFF6EB56037FF54,0x78CFC774963E7CB1,0x48D139D16B3956A1,0x3265461A619F159D,0x80DCB967A3B1DB5E,0xDB164BF4F293C925,0xB0A372DE83B65B62,0xDA262FD344760C21,0x0000000000000058 },
    { 0xA8F9432DA6DFC562,0x0C7B74ECDC54C213,0x56B4B751DF24C7E3,0x5B32314BB42C77D2,0xCF2312A419053195,0x60BF22144F2C75EB,0x0207884171877095,0x8ACD999DA44F75FA,0x0000000000000152 }
  },
  { /* Point #3 */
    { 0xFBDD71D76DA23955,0x58AED61E4E9DCA11,0xC8F75DDCC41906AC,0x37020B118AE30A21,0xF91295233FE85C4F,0x201400FDBE4B3724,0x9739962D3A2D4446,0x917E35CDA0F4B655,0x000000000000018F },
    { 0x99496B29AE9E0FFD,0x98A9369F6DC1CB95,0x5DB5CA11CF116E11,0x3DF10D8508FB818C,0xDDC80CC991DDCD37,0x8E8647DA496AF53B,0xE244C394573A894A,0x056A45E741B4DE2D,0x00000000000001A1 }
  },
  { /* Point #4 */
    { 0x0CFA67A640B0A066,0xE97C179E8057A710,0xB69D285227CCE600,0xF7DDE8C5419687D1,0xDBCB15185D5B039E,0x3E47772FD99ABBE0,0x71C9C23AB2A9C6A0,0x5AF10B9B94496951,0x0000000000000152 },
    { 0x0F96137F2C91F83A,0x1F743FA449F15B33,0xD43B3EC0CCB4C1B1,0x895A3BE3CFEEA9B0,0x27C3B4959EEFEE4D,0xF1B4212712E344EE,0x023AFA76FF929C1E,0x3078097686D07325,0x0000000000000166 }
  },
  { /* Point #5 */
    { 0x1EF0C5B017D2C887,0xA593F0118F4493FA,0xCAA027ED63D4A941,0x56EDD1A0055891B3,0x2597E88C5AE7958F,0x3CB83F5EB9B6B189,0x8A80C84B94645703,0x31B752964537080E,0x0000000000000127 },
    { 0x4A72FA41DC5510D8,0x0974F66B56098683,0xCEC5E8FF3EF53A52,0xFA5D5DDD6B7DB395,0xBEE1560F2085C160,0x51C86C14673DAC7C,0x0A932E8B8F72CB17,0xCE6852502D25A31B,0x000000000000017D }
  },
  { /* Point #6 */
    { 0x391FEC22319E0473,0x132AE72136CB975A,0x8E19553F9B4103FC,0x7F8620C5B6D2519F,0xFDD0B5E955939065,0xBF94F747A3A9CA34,0x2FD846E06C7BA280,0x078E04DCDFF222E1,0x00000000000000D0 },
    { 0x3DDE6C64368BB5DA,0x6B5410650610B78E,0x1E585E3023150BEB,0xC4692E425920AAEB,0xA2DD9BFDC029F242,0xA51A8149155B6F21,0x95450D43103C25E8,0x1E3B7D3CDD889055,0x0000000000000197 }
  },
  { /* Point #7 */
    { 0x859D6C561BD83A5C,0x239053EE28DBA1F4,0x999651C04A37DDF2,0xA0A6C58BD207328F,0xDCECFDE0DAAA8A32,0xAF7D07B9B45DCD62,0x22D90DA5646E6CA5,0xEFADE50289796B5E,0x0000000000000142 },
    { 0xAFA5AF772C783BDF,0xC24F65BD0C12453C,0x1B84276E06EBFA19,0x3B11B67905A96B12,0x12F6B07613D7B934,0x27DFB98D626F6201,0x0B942F479E534BF8,0xAE1D2D9127A320EC,0x000000000000014D }
  },
  { /* Point #8 */
    { 0x48A2FC84658B96B8,0x039AF24C465EBF34,0xA7A9B0144F404EB3,0x80176EF0763AB5C4,0xD4984B136B5617AD,0xA6A39ED89195EE81,0x1CE2974905C2EFF8,0x78AEFF6C1281FA56,0x0000000000000199 },
    { 0x40CF462310374F0A,0x89212E99958219F6,0xE7599B2027B97CBA,0x1AE1CB659E551710,0x62881658502E6670,0x8F78CCF876E23A8C,0x78E165AD732CC46E,0xD6B5AB1CF7670684,0x000000000000014A }
  },
  { /* Point #9 */
    { 0xEDAACD35AEBB5527,0x2BDB00A820A89E95,0x2E3D4AE1A3B9D046,0xFADA12468D03C4AA,0xC558B52D970B3870,0x2529829E9315F879,0xC798E1D566071940,0x64025D6A99DE1E14,0x00000000000000C6 },
    { 0xE9012D5EA868682D,0x03955E49DAA7EDE9,0xEFE1F39A25847CBC,0x4AA902CD603DC3CC,0xD61BA6D92470A473,0x6F2F37AD38B2D846,0x5F74E77099EF925F,0x3C88ADA4256AFFF7,0x00000000000001A3 }
  },
  { /* Point #10 */
    { 0x063B9C2951496D2B,0xA41821EA5393FE41,0xE79AF446BD60A797,0xA7DCD756923A07C1,0xAD1F8C0DA6CD752E,0x039DCF93BD6B8D1A,0xC60271384A00E2A4,0x144C8E73F63EB65D,0x0000000000000192 },
    { 0xADFA51D21967358B,0xC2BAB4DDDC3D38EC,0x6921095CE0C5A633,0x57741B931CF55A9E,0xB80CB292F3A1788F,0x7E7E1957FA866B34,0xCBC1BD43DF1BD5B0,0xCB16037F44CCC6D5,0x000000000000000D }
  },
  { /* Point #11 */
    { 0xFCBE80E2041391E9,0x85C88B0D2B839134,0x05FF5CD93E70FDB3,0xEDAEB5CC567F0EE8,0x864CD4A24866664B,0x1D17CEB9D9B8A354,0x2C69AFA308C4B1F3,0x00B48E38DD6E95B6,0x00000000000000D2 },
    { 0xE7D05859F24ED4AB,0x995E2841CD510E45,0xF2EF6EEED0481211,0x7895DA9A91F24031,0x0B6B2F70B6F4C95D,0xE933B195F5E76C25,0x721ED663803B2B1B,0x798FAF6D5E48F8E2,0x0000000000000098 }
  },
  { /* Point #12 */
    { 0x5C8C9C4F2FE85BA6,0x6261C2D7F245952E,0xA61675F6205E90F0,0x12BFF0C504BC20B0,0xA508F45DFB262657,0x74463F07099DC660,0xCC2FA435928AFFCC,0x9852938CB1DA86D2,0x0000000000000156 },
    { 0x9C85772AC5B6B703,0x18FB95A0CFB4552C,0x7C5FC895E8DBA4DF,0x13618E9D792AB39D,0xCD92C86539C8E6B9,0xED1FB606B47C1739,0xACD8ABD29A1FAE19,0xA9BD86A576BB9ED4,0x000000000000002A }
  },
  { /* Point #13 */
    { 0x977469FB11DCE4C9,0x1CE662A59FDF846A,0x7B1354CE61069D90,0xD881490746B01325,0xC3940A3F7A282A41,0x6C4FEBA18E76AECC,0xB5247B89BC7A9EBF,0x155AF61F5B705F9C,0x000000000000003E },
    { 0xF4B9494B371E3CF2,0x90172CB5AD1A6243,0xFD8E631A5F840891,0x0079EE0FDE6E7931,0x707481D70E341DE6,0xF9FC32D6682D9D44,0xDEFBEF022C5F135D,0xB700B22CD15D80D0,0x00000000000000E1 }
  },
  { /* Point #14 */
    { 0xFFEF9E0540FE4E4C,0xCE75916FE1AA26C7,0x275A46B39FF66398,0x7479BEDE35741FFC,0x8932812A5A437519,0x31E33D2829252840,0xAF02D92708BF90D5,0xB70DAF19B801D119,0x00000000000000FA },
    { 0x46D4212977BC7494,0xDB5967AF040CF16A,0xAB3773EA5307B3A1,0x02C4B40B0FBEDD93,0x7335965DA15DDF69,0xE110BD51947C368D,0xFC86CCAF6A85BFAF,0x8F6AED2B0E9A44D0,0x00000000000001F2 }
  },
  { /* Point #15 */
    { 0xA9F959760F9853EA,0x40452B144B21047F,0x5547B38444C48A97,0xCD1E71A9175F071C,0xDCF49F282BEC68A4,0x45A5B3B826A71DBF,0x0A718077A77F1ACD,0xE56ECED73064290E,0x000000000000011D },
    { 0xB75324C78C0F4F52,0xCD3255658077F9B9,0xF8E13A376E1B2DC5,0xBCFB551154AF6DE6,0x396F4CE90ED1B6EF,0x67C204D798972DCD,0x6AC0FB18CCB2F59D,0x3A802EB853A4B745,0x00000000000000AF }
  }
 },
 { /* Table #44 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xB342D85DDA44FF51,0x54BA0522D08596FF,0x3DA8E8CEB0AC99C2,0xCEBE6A9691F37DCB,0x8EBAD3D9C24D7D1C,0xF11A4319C75945EF,0xD4DFE534ED1AC001,0x745E27721A521E4D,0x00000000000000C4 },
    { 0x745E5B41DF65E0BB,0xF8887B533B84ED58,0x1A54BC479C0684EA,0xFD4F1D36CE9C7672,0x490BC265CE5730FC,0x2FA1AD6D8430ADB9,0x0F117BDCB7DB19B4,0xBD339A789C246E44,0x000000000000005B }
  },
  { /* Point #2 */
    { 0x5F8FD91AE19A881C,0x355105B08CF8A2C3,0x442B97782810E499,0x930D835ADA7972C5,0xD2266522555EF4D8,0x943D9ADB64E05B06,0x480BD27F42FC02FA,0x9265B289699E5B7E,0x000000000000008D },
    { 0xB60DF9C855C7CD14,0x62131E73270E2672,0xE6983794672942B7,0xBF8C55D1817DB72E,0xC3785F3608A5963D,0x4A6646098F39218C,0x95C868541B5B49CC,0x045A0243178DF85C,0x0000000000000019 }
  },
  { /* Point #3 */
    { 0xCCC1BB64B666FF60,0xE786F358BA04B5C3,0xBCD5E56D384C0AD4,0x5D22436FD0372BBD,0xFEEA9ED9A061A543,0x6F81F168FA3D34BE,0xF52059D24BA47193,0x5FF055894ADA65AD,0x000000000000006F },
    { 0x346ADED56D4CABF2,0x65E4B11F4F1A8EE1,0x1521718B07EBA73A,0x8A2F32BAD16D7D56,0x01D49595D3ACBB17,0x67625FAAD3F62095,0x7C3CBECF613B6059,0x3908F6506118C496,0x000000000000016B }
  },
  { /* Point #4 */
    { 0x06494428CAB2443D,0xC52AD2D86AFD7840,0x8EF6E0A6FCE7B5F7,0x6151D2B3A82AE7E3,0x08ABB38A14E3B825,0x9782E6F9366CADA3,0x9F0127B25076C2FF,0x2F29B7282D812ED5,0x000000000000004F },
    { 0x7142E7E004E049F5,0x9338A870D7F99E76,0xF7E4837B72A90177,0xA7BFF79911AACD17,0x5442D6F2D1D10B06,0x986E7BC45ECC3F54,0x02CF381831286FE1,0x5CDC56D1CD383EAC,0x000000000000002D }
  },
  { /* Point #5 */
    { 0x7303EC69C80291F9,0x0F2C64390C9FF7F4,0x96C08EA0F3ADA285,0x3CB50F3DDEAE887C,0xABA571FAFEFE26DC,0x4E4DBA336C6F1071,0xF5796982F02BDA38,0xA59C60B140485DE2,0x00000000000000A1 },
    { 0x28D7C281CAB044F7,0xA5EB04FE515D247A,0x5B42D919BA014B10,0xB150B4FBDE221CC1,0xB5CB8C3A22A5A502,0x62C0DA97CC37E34A,0x4B9BFB1F9E827814,0x96666256C97679AC,0x00000000000000E6 }
  },
  { /* Point #6 */
    { 0x415FAB9A8B894AC8,0xB189914D64822449,0x0ABFDBF50F4B9444,0xA333E872EB96CF1F,0x91D3473DB8C5318A,0xBB5740E624D09CB4,0xEBE6EF7F5B5D73EA,0xBE33338809F67393,0x00000000000000FC },
    { 0x9970D38E1FFA22B4,0x00D1FB74003E55F9,0x0D1EF824820F7BFD,0x4352125173FC040D,0x295F8A66E51B5870,0xCEACB67D3DBFE159,0x0EE77417A218D2FE,0x25A0E0A9F3B7D44A,0x00000000000000F8 }
  },
  { /* Point #7 */
    { 0xC1F7698483EF0448,0xC4D18389FB276974,0xFEF2C810E52836C2,0x3687104BC09E4020,0xEC3248EF0CC4BF06,0x38DAA51BC401078B,0x84BD9F6157BC72F2,0x68B23E45003676EB,0x000000000000009D },
    { 0x22526E98D78B9D6B,0xC4CCDC71C4F28366,0x7DD12D941C646B9D,0x0CC00136931BD51B,0xFEBF1E1E512EC8A6,0x6BC281F6BDC888B1,0x0BC271F3F6AB354F,0x27D1EE7630C4E559,0x0000000000000038 }
  },
  { /* Point #8 */
    { 0x12427D324ACCCF77,0x3194664FFB77F869,0x07E01CAC61A58E24,0xC506637B91BF22B5,0xCE7D0251DD2D701A,0xF9A662D4BEFC0D7F,0xA54117BA2C6C9454,0x31864E416978E919,0x000000000000007C },
    { 0xBBE419029D971044,0x68742001F8F24116,0x6D0065933E4A40EC,0x9FC1B8E282771429,0x59B2F9342E7968CA,0x4817F90B470DD353,0x3D32E10F7E2C1429,0x43E9474E00206509,0x0000000000000076 }
  },
  { /* Point #9 */
    { 0x2AC928FA4FFA68BF,0xAFB482236B647009,0xA7B54F134CFAE9CD,0x8A271E4BBB3F772C,0x78FAAF7EBF953D68,0xB5F12134519AA8E4,0xEF343445359AE969,0x86E25AAD76816A06,0x0000000000000110 },
    { 0xA0B1814536A88707,0xDD48D1F21F9A1284,0x48670DAD845E01BE,0xC13D5AA9FC7FE6A9,0x611969B964757542,0xA4529C72689BB1C7,0xD7C3F96A06F31F72,0x8B09A45A5418D15E,0x0000000000000121 }
  },
  { /* Point #10 */
    { 0x58170EB934FCD20D,0x8205AC09C669B90B,0x2DD08C383D1C1595,0xEA1217AC91DA182A,0x3C9275359D2CFF8A,0xE8223F7A2A4A396A,0xD206D341DB22C77F,0x6E03FE3227864348,0x0000000000000168 },
    { 0x3A717C4665D9BB06,0x234158EB1431D7AF,0x389290045A27A3B0,0xD745267181008744,0x7961F9C3055610E7,0xE260F8A1936A3625,0xC05DFBA284B88F57,0x930747E71F67FD22,0x000000000000002F }
  },
  { /* Point #11 */
    { 0x886C7F2258EF1600,0xD581F2BC4EB5BBA0,0xD6C7B858E64666B2,0x114250884E813BB2,0x428E86F000C98E08,0x3AC9B40376EB5C59,0x904F313961BD2DB8,0xA3144A05C71CFA5D,0x000000000000002A },
    { 0x002EE77CB69FA450,0xA1F5050C87240A19,0xD7DF65ABBE333836,0xB64362DCB8CD4A96,0x058D9BC3D814096B,0xAD04C7E39687901C,0x67AEF9E2F5527030,0x20DAE8096F375A8B,0x00000000000001DD }
  },
  { /* Point #12 */
    { 0x2124D45C3F9900D0,0x2452FE1DB6A32111,0xF12B476586F1F700,0xC04E44EC977316F6,0x582CA8509705FD58,0x51EF29493167CF6A,0xCA75486404F204C8,0x61DEC7F3A46FD945,0x00000000000000B9 },
    { 0x78114ED6AF6E04D1,0xE1EC56F601A4B6D2,0xC26F5416BA41C631,0x76B8204B7D9B9F82,0x665FE0FEC0565F61,0x7CCD8AA573C27925,0xCD6756D82F58E901,0x6E932418E8F75A4F,0x0000000000000019 }
  },
  { /* Point #13 */
    { 0x11113AFF28DBBEF1,0xAC6AC5329515632D,0x1E88244E42A245A7,0x30F28F4A9B0E20E2,0x8BC178722B15E0EC,0xC15E2549BA5A885A,0xB42F06201685CE7C,0xD80F13B9DF452E98,0x000000000000008B },
    { 0x39DF7724F9A80BBA,0xC734B0BB28DCF06D,0x6E09C92BB43A5CD4,0x175127DA8C0EE83E,0x50BDE213F88485B4,0xD9F6C90124A0EF83,0x66CE46BFC205D20E,0xD6F1C04FDE4968AD,0x00000000000001A2 }
  },
  { /* Point #14 */
    { 0x920E0CF981414E26,0xB45CF442498A580D,0xD424E9E24CBBFA67,0xE64390071DECF2E2,0xC7FAE004D9051A61,0x9FD02F2898E66BE9,0xCC4AFB0B419B7E92,0xFD421F03EF8AF4B3,0x0000000000000126 },
    { 0x7B45C797E0E5EACC,0x04A9B25F202041AE,0x27888AC85849C309,0x9325CE353F58628D,0x90E98C4A25EF6FDB,0xF4FF673CFD3DFDF2,0xE56AAD1A32CCFB2F,0xA6C6D2CAAB9D6F10,0x000000000000011B }
  },
  { /* Point #15 */
    { 0x13F45D45ED942A64,0xFCAFEE83705CBEC8,0xBC9A11D052186F58,0xB5EC924941EE3189,0x71D770CBC95C6C4F,0x7F348C27D610F241,0x9116747564AB476F,0x30396F906D8350AB,0x00000000000000B6 },
    { 0xB866CA72A9C8B74B,0x26AEABDB3D3DF97B,0xD4EA56A365CAE75A,0xC873FDE088FACF27,0x4D4211CEDB995516,0xA01CF05289799B04,0x55D85824D0F0C2A4,0x434682B0DD83DED2,0x000000000000011D }
  }
 },
 { /* Table #45 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xC03C182D851368EE,0xBB94A33D57C919F2,0x9CF0C767E333ACE3,0x037C7D47D974DE7F,0xE96E02CF8B18FA5C,0x6F1A3E9126CF35F7,0x47AFFDC033486C59,0x2C370BFEEC8C2A2B,0x00000000000000E1 },
    { 0xDCE5DE2C18A3F84B,0xC4BB672E2AD42CA2,0xB6581D7EDD0731B2,0xB6CA46CA2809AC7E,0xDE8EDBA2189B0FF8,0xA72EE3E81FF4631D,0xF44A8FC6F1004BCB,0x103DD1B9C8878531,0x00000000000001CA }
  },
  { /* Point #2 */
    { 0xCB35DF1C0A0EB364,0x6D0479606EFAA084,0x2AE2D2833735CE56,0xE0B9D7E8DF82FDFF,0xFF7A316C39CF5AB2,0x23254F4E26B6C05F,0x4751CB2DE5C125FD,0xFA059629894E9A61,0x0000000000000148 },
    { 0xE64CA47B49112ECC,0xF4F9F08CF5FD0DD6,0xAD1C8C7274BDC4B6,0x34660962BBA001E4,0x346D7A407E2AD36F,0x68C8B34BD27181B2,0x8AEB7EA43B424E34,0x257AB659D4498D11,0x00000000000001F2 }
  },
  { /* Point #3 */
    { 0x98A781D5DE024391,0xA4E752B1AE6A8131,0x8AD7E98088919924,0x5700178A57C8DEE7,0x531AD67228FA8EA8,0x625C088996B9FC60,0x9B13BB3DA848FF64,0xA9AD8CEFC12E0A98,0x0000000000000118 },
    { 0x0D4B05DA9E9AB68C,0x318DBB7394C26124,0x1F377147DF5F527C,0x14A59165AF077B4D,0xC8EE5181BB4AC96E,0x4C90381B8F13CFB7,0xE84349C8233547D1,0x75AA5EA458F7DA4F,0x000000000000003B }
  },
  { /* Point #4 */
    { 0xAD57280ABB5BE7E6,0xF102FF10066E97A7,0x5308CB8E61C86340,0x11B53155D02E15C2,0x50ED7916EF223374,0x8C48F8371EE821E2,0x0B3010CF7931B97C,0xB84CD0142062EC30,0x0000000000000007 },
    { 0x05A7A5A024B6E1EB,0xF8364D18B5A7402D,0x2B9EC6C5F9EB3538,0xF363DAC905915B41,0x2A567784A7909CB6,0x5B386EAD22FA3BAD,0x646554B91E873FBF,0x99F6AD72B88CA34C,0x0000000000000077 }
  },
  { /* Point #5 */
    { 0x26779CC419496A3E,0x1C474EECB93F9890,0x8528F2F4C70FCAE2,0xC9DDBB4CC43683B3,0xE33EE677F3B3593F,0xA3AE1C99714608BB,0x8A15A48BAB92D89E,0x1549D787C4C8344B,0x00000000000000E8 },
    { 0xFA337896D4B88B67,0xB092967F0B45613E,0x99266FAA1ED2840E,0x97385E818480FCAA,0xCFC9058BBF834C19,0xD4A622D5A89D1623,0xAA93E9DBA101CC1F,0x619A1E813DA3113F,0x00000000000000B3 }
  },
  { /* Point #6 */
    { 0xD788D6565CAB16FC,0xDD54608E04629E7C,0x4894360CE4DF5CAD,0x51B4F25DCDE428B9,0x3CFC990539F2D01D,0x664D9AE47964F228,0x1D1263B58A298C8B,0xA717BD7376767ABD,0x00000000000001F8 },
    { 0xC892809469CE9CC3,0xCB8AD7C3A9530906,0x5DCE307CBE8A003E,0x73DEEB54EC971C0C,0xBDE8A12025DAC8D4,0x4F0D4E8506FE1D7B,0x9599E1F1356B11F5,0xB4218AF523F1AE8E,0x0000000000000197 }
  },
  { /* Point #7 */
    { 0xA676BEE0D076683D,0x4F0C084321D6BEBD,0x53C8011EDC7657E6,0x5E0E0192234C59B6,0xFFEBC6D11EA313A8,0xA8CCEF85BCB84AFD,0xC8F930C3138327C5,0x6A9EB749B83994BB,0x00000000000001CC },
    { 0xAAB00795BB99594F,0x5F27CE0EF1BE2F9E,0xF76A4760524F18BF,0xDE00974EA8D81CF9,0x2AE521AA5A0A5A67,0xAABF5EA946986D91,0x26D97947C3713B98,0x6B040E0F32AB0EEE,0x0000000000000177 }
  },
  { /* Point #8 */
    { 0x8F37E861FC3D5A8E,0xD09D8E74901CE1A2,0x212E32A992F81574,0x38AC8BA60D96A933,0x3D990B98B84C99D4,0xB97F4E73DF58647B,0x95AE93CC7641888C,0xD7BDB083A0969DD3,0x0000000000000182 },
    { 0x6531530C17830426,0x9DB488F48A57B683,0x9452CA0F0D87ECA3,0x19B198F08B4BE2A7,0x17939AB22775F0FC,0x7F662A0625BC5C0C,0xDF04CBEF428884F3,0xA4D202209F9FF142,0x0000000000000090 }
  },
  { /* Point #9 */
    { 0xB1721BA5B2662A6A,0x99A85511EBC45FD9,0xE538FDB83ECC5D3D,0xCF31F88569B1B389,0x8D337BC90BE3489E,0x3CDFBCD8A4ACFE8D,0xA4698999DF97C1F0,0xF1568F6BE74EBB9A,0x000000000000003F },
    { 0xD5995519CD76A58E,0x494B70E8C101617B,0xAAA9461DDCAE3A68,0x5B6CE8978687BCF0,0xE7933088CA54B0D5,0xEDEFF8BFA150EA5F,0x1CF4DF75139F7F09,0x410E086ACD4005A1,0x00000000000000FE }
  },
  { /* Point #10 */
    { 0x0A8BCA7C5AC5A4A6,0x6D27A28EDB3CEDB4,0x0C8E830E93BB6F6A,0xF432C0CC476E2AF1,0x2D74D36313358EE6,0xB757920AFF10C5E4,0xF549A1965104E964,0x2982B34FB97C5124,0x00000000000000EE },
    { 0xF40C4FF4E1939FB3,0x72EA159B95544BFD,0x8AFD002B45E3159D,0x5B6C77748A647539,0xB901B3C7E3399A19,0x69BE223CA237614A,0x4E3A0C2C86B3B877,0xD460003E35D2007C,0x000000000000009B }
  },
  { /* Point #11 */
    { 0xD46AF7630DA09D54,0xF4742AEA11315FCA,0xFA2EFC9AC1832567,0xACA1C92CF3F4F180,0x5F916475A04969EE,0x3619DA17BB95EDF8,0xA4C3C0C09E7E68AB,0xC98B4036BF1D3B32,0x00000000000001B2 },
    { 0x5477C78B045007F6,0x07AF3389E4683020,0xAB505688DB89F24D,0x0D669305F6F7750F,0x965D090B3A80BF74,0x3E2B11EFFBDDA3B5,0x42F8B116CE26B74A,0x8CD56F7AB2CD8F84,0x00000000000000B9 }
  },
  { /* Point #12 */
    { 0xD36D95E98D20AF1D,0x042B6B721475A01D,0x90DE7DC34E5322D2,0xD7201C9C8085753B,0xB2467AFB2A41A80E,0xDE0B994DFCBEF3EA,0xAB46BEC5219735A2,0x5C6EFC5A9F068A58,0x0000000000000167 },
    { 0xAD80498FFBE3E605,0x0E49B878B58B1AF1,0x5A90B3D5F7467E30,0xB6FEEB53D872561E,0xD33CA82162456735,0x6262F717CDF5CB42,0xB7FE12752D9B039F,0x3D76868940AF9134,0x00000000000001EF }
  },
  { /* Point #13 */
    { 0x5783E5A50FB0D3ED,0xD45D144D61EE2AD5,0x35387B1C6783B97B,0x83FED918ADE06CD1,0x065EF0A4FD5DFB50,0x2BE01418333D2E20,0xC5EC15B0526084C4,0x18E131F696427204,0x0000000000000163 },
    { 0x799B4B41240FA002,0x5B0C4AEA93A45054,0x7074180907D9FACF,0xA7FA721DDD2CCE25,0xC2F224297E17EBCC,0xCB2912B73C204BBA,0xDFC7E9685F6294B1,0x12AC45AB3EC9E0D6,0x0000000000000017 }
  },
  { /* Point #14 */
    { 0xB661C3FC73807505,0x52906D435A4C74B2,0xCF1D79CB312DC198,0x917C25B56D9854AA,0x4B8C19E4F5FF3676,0x4CB584E5E44CAE2A,0xFB2EC5C2F3FB6B7F,0xE49CCCB78C43892A,0x00000000000001CA },
    { 0x49D7025CACF40955,0x7374AF9A1575FDF8,0x467004FD9CB6BE75,0x55B153F493E59328,0xE66E24F8D93CF632,0x1D805F2F8C5AB7B2,0x8DB74A76AE78DCC1,0x3776F8201D5F4F21,0x00000000000000EE }
  },
  { /* Point #15 */
    { 0xBC6603D4F696BA83,0x155348B2BF9C42D4,0x36664A86019255DD,0x463A6DF67A1BB9D6,0x0F61B9BA4051D5CE,0xEA3B77733A41B408,0xAE9405C831AB53E1,0x9AB3D5669F644A63,0x00000000000000A4 },
    { 0xB0C3477F5E8C01EF,0x9EEB3FE2CFBB47D1,0xA7C9E588DBF2A125,0xDA5F9F6F02BA3E65,0x0C9710DA84232123,0x311DA7F3BF9E7225,0x5744BAE94D4FE809,0x0E25AE34114E4089,0x00000000000001F5 }
  }
 },
 { /* Table #46 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x4585D3AA31FF6E80,0x8521AC35C19AE65B,0x983E0C6AF9F78334,0xC4131279435DB0F0,0x0F2D350B51BDB67F,0x1FEA5391D65D265F,0x7F0B55F7798E80AA,0xF322493AD549EAA9,0x00000000000000CE },
    { 0xDF7B80AAFE9E5DAB,0x5585F93A1861E785,0xB70FA9ABBBB5764C,0x23CE8AED3A39EF40,0xA719329A14920FF9,0xA74511124A00E5B9,0x48B0001BFF5C3588,0x8DCB5FE10E0551CE,0x00000000000000F1 }
  },
  { /* Point #2 */
    { 0xDAA72EBC797EE80D,0x5EE6DE5E13BDE073,0x8F21FD78A69B5019,0x5A8FCE8C89191DF9,0xCE39466D725F4F61,0xE1015721D258C98E,0x22A2F6A5BFB1ACC6,0x5DFEF1DA97265EAE,0x0000000000000164 },
    { 0x4697804882470CAD,0x5A62DE6C92E3DAEE,0x95CBC0199163A136,0xD1F51A60F0AD7FBE,0xD300B7C6F2380828,0x3FCE67F4B1246DF8,0x6AEC1313466EC418,0x95FFD2856063CE6F,0x0000000000000080 }
  },
  { /* Point #3 */
    { 0xD3107DC42EB6D453,0x3897A60BA3F6B312,0x5D8AE4B9A26EBD5E,0xF83E1EFA445F3EA9,0xCDF3F2D6E9C5AE62,0x43624A7FFE4A7F11,0x9169460F6634235D,0x642B8B112F75464E,0x0000000000000186 },
    { 0x7924B1CDC84496A4,0x0A5EB42C5F8F5F30,0x14068D49492CD04A,0xE0824856F2A5F227,0x6E146CDEAD328ED4,0xC63A68C19118FABD,0xA295B4127E56624B,0xC1D31ED187055125,0x000000000000001E }
  },
  { /* Point #4 */
    { 0x241872E36910D714,0xDFCD9DB5CF96F106,0xD32E27FACB3A51E7,0xA55ECAEAC4A051C2,0xFC54759AF8944204,0x569D9EFDF938B503,0x8882AB15C54BF05F,0x9A8869ED0CAB8124,0x0000000000000007 },
    { 0x1F5995BF361CE52A,0xDA53A556B51EE176,0x735BFCD6CB664A03,0x4D8E405D38486DE8,0xEECA6379A807C481,0x9A24AC8A4D456D2E,0x159B9F4C3B85AB21,0x77524D58F256C82E,0x0000000000000125 }
  },
  { /* Point #5 */
    { 0xD83376B06E0604E7,0xF3DA2540B9BDABCD,0x8A64129AB0069B9C,0xF98D8A694ED21F8A,0xCD7950FB17C1FDD1,0x988AC822A1B303F3,0x2D6DC22444468A4A,0xED780EB123F65549,0x00000000000000C2 },
    { 0x38E4F1E17C4F29CB,0x030F563663776AF6,0xEA357F378032B066,0xBC96AFA12141EBBA,0xE1396E9F7CACBE45,0xDC5E9F07C62172A2,0x00CA038FA26039A1,0x23796EDF96C93FA4,0x000000000000014B }
  },
  { /* Point #6 */
    { 0x20F7C6EE1BCF9917,0x1C7D940F8CBC7D2A,0xC2A1139ED592DEF0,0x0B6B644A936C827A,0x1B16BF59ABB4F3EB,0x1693FE7916B8B498,0x4B81CF5BADBF552E,0x620EF3BE7E0CB980,0x00000000000001A3 },
    { 0x6106878F2F6F9A16,0x15C2303E6CF02778,0x18C605CF7F7E7E27,0x6BD45DC798A8DE3F,0x5874172095869DDE,0x621D8A4B2DE20D0A,0x7632703CDCA67562,0x9374D05536957EEC,0x00000000000000F1 }
  },
  { /* Point #7 */
    { 0x2D0E0E8C3A12BE03,0xA4FEBEBA75AAA59D,0xE5AC02D67E8056D8,0xF3788C67BACD030C,0x4018AE3921FDA504,0x690259DCF16AA240,0xF51723B291AD5D2F,0x9CF893221F0AA525,0x0000000000000166 },
    { 0x0F4B0C2A09388E2C,0xB8308CEFF40B8763,0x2462458061A66221,0xB67A79E8165AAA95,0x94BC0B4708789BC2,0x8B234C8708114D2C,0x1EE26556BEC8D5EF,0x22E3055DF315D134,0x0000000000000118 }
  },
  { /* Point #8 */
    { 0xF43E7556BD385E53,0xBF8F9681875C0190,0xE3D90DEE555BD31F,0x3BAF65546EDFE5EC,0x3D6DF218960E906D,0x7B6635CB873D0635,0x98A44993DED25371,0x918B7555AD8E24B4,0x00000000000000D7 },
    { 0xB776F9146553287B,0x7075A0A36FA9FA1D,0x7BC1D77C11D5513D,0x789A19867993F668,0x6162A249612A7F5A,0x04348EB04EE7F938,0xF7102CEB56583274,0xAE423442E356E7BB,0x0000000000000002 }
  },
  { /* Point #9 */
    { 0x5D07A2964E588DF1,0x141993BB19B144A5,0xABC8B7F17AEF2CFC,0x6A447E47ADF5F260,0x3617BBF9413523AA,0xAE2DF3568658871B,0xB73A2681ECA0D3D9,0x9FAA02A845905049,0x00000000000001DA },
    { 0xCEA9672C9249E1F3,0xD6030DD792B80377,0x1731A9B6B430427A,0x707319A7DD23ECD8,0x7497F2D3137EAC72,0xFD455E149FC57ECD,0x1D5BE9F6F7A02326,0x58127F1635AC3188,0x00000000000001DA }
  },
  { /* Point #10 */
    { 0xA62ACAC89702711B,0xFA8AFDE1E5A60500,0x6D0B6EC9851D3077,0x2928A849DDB4D927,0x40731D2FEE9C5656,0xF53C199C78402E28,0x8D704153BF178D27,0x67BCCD2A3F735C1F,0x000000000000008F },
    { 0x1FB2240D935C8AA5,0x1FA6B65F794DAAA0,0x30AA4BD3C31A7ABC,0x7B571E77F50B1A73,0xE5105E178D05B874,0x224CE4AC6574A6A3,0x64F2C14BA2D9FBA5,0x30E0F151C304C3DF,0x00000000000000FE }
  },
  { /* Point #11 */
    { 0x3E157F2273EE88F7,0x1C0630464384BB96,0xFA8CCFF1163124AB,0xF2A63516E1C82E20,0x06F7A495ECC52CBD,0xD00255D7D546B8B3,0xA4E0EA97F2C1BD00,0xC279C9B9D8367846,0x000000000000018C },
    { 0x493CA0D2F4846640,0xF2F65176836101BB,0x9A2131507C4F5F62,0xE7A4D6CB33CA1654,0x6705565959E1757A,0xAE2233738BBDDA8E,0xE915BE3BE856975E,0xCD6117EDB40DB96E,0x00000000000001CF }
  },
  { /* Point #12 */
    { 0xB77B2273B687E9E4,0xD0C9629B158071BA,0x7B0D0576BD865783,0x47CA9A1B48334138,0x22C0B777990BEEFF,0x3DAE022D7E8DBE92,0xDECF568567233C8B,0x96EADD8A999E9C94,0x00000000000000D6 },
    { 0x8AEFEAF1B8755EEC,0xBFD2BC88789362FD,0xA2C3BC994E34479D,0x5025831148DF5301,0xD392CB00C0E07947,0xC8C4C6A5E4A0C2BA,0x315A9BE295C84FD7,0x12BE251D40CB144A,0x000000000000007D }
  },
  { /* Point #13 */
    { 0x9649B0C126BD0385,0xDF659955AC77DD42,0x512CAB0F5F1D946F,0x3365C06CB8E888CE,0xD5B139364003AD9B,0xB9DDF7422E777936,0xD882A2E7F0A2EA17,0xCA25477D329706F7,0x000000000000002C },
    { 0x109144281F14B985,0x8C6727485F7BCAFB,0x43DA81611A6B62B8,0xADEE9242FFC82ECC,0xB7DCDB418F391FA4,0x1FBBF2E0593ADD60,0xFB551A699EC74127,0x2AE9B20E7443A903,0x0000000000000116 }
  },
  { /* Point #14 */
    { 0x2698187D69D2A365,0xCEAC05A40B4636E7,0x508D87EFB39D959B,0x7DADB94AC08AC0CA,0xBB5161F9DF1DC5EA,0x9F9118E6EC7A8F47,0x5F7D5A7EE578D6BB,0xD2CF3964BEB0C4C3,0x0000000000000076 },
    { 0x312CCD712DD174E0,0x84BF3B4BF1B3CF22,0x4215BD31F0927EDB,0x062CFEEFC2AAFA52,0xDD22D90155EEC990,0x18E19734057E44E8,0xDFC288D25F2CD2DF,0xBFBE2CEE43C3CFCD,0x00000000000001B0 }
  },
  { /* Point #15 */
    { 0x3069B9D66E77AEF9,0xD042AC052EB93FB9,0x8335FE4212830002,0x293146E6E1B614FB,0x652317E76DDB3AE5,0xECF47236FEFBA037,0x24B51ADF58EB0B7B,0x5109F7DF4874FB35,0x00000000000000D6 },
    { 0xFF02AC885F1D5485,0x8A993DAF530607FE,0xC63139C93BA41F73,0x934A2F9445F411A8,0x2208220BC95AAE6B,0x96710A9C63292771,0xC1B102E35B2A77A3,0xC8177ECBA35D5E23,0x000000000000014C }
  }
 },
 { /* Table #47 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xDBEEB421CFD387AD,0xD208FE085BB4D523,0xFF2282DBED24EDF7,0x30556FF9C806B492,0xE7716C3CD5B5BF57,0x847E3A43153FB3B2,0xE9A8FB3C391809C5,0x52B4A72992596244,0x00000000000001C0 },
    { 0xE49B344E59D9AE12,0x5A5E32A1C925B6DA,0xE81D38D1F054A1C6,0x4AE4FE0CF15FB6D7,0x6EF46DCD5CF03296,0xBF46B97612DA300D,0xFB373FE835FA7FDD,0x0F78E5EE62BCAF82,0x000000000000003B }
  },
  { /* Point #2 */
    { 0x9F3034247A56433E,0xBBFA0FD960307947,0x21C78CD331DB3E3D,0xA837641C0A2A5F1F,0x28338EFB56B8BDF5,0xC0B66594F0600D27,0xC07399315CB9A3BC,0x95EAC1715267267A,0x00000000000001E3 },
    { 0xE9EE22D1897F04B2,0xB6002A034CDE7DFB,0xCBB7BE483C3B494C,0xBE6C1A98670F740C,0x9E9D0B911FC603E2,0x532AF80C351C0915,0x0BBF9EA379802339,0x96C16ECADD33D50B,0x000000000000002B }
  },
  { /* Point #3 */
    { 0x7E8AE915EC95BFBB,0x7B4BCC898CC39CC3,0xD7A389BF3F466A65,0x7620F5E1E8BA8813,0xEA27DE5B9100972C,0xD6CF9430D8D87E7A,0x78B6E5F8B4FDAE7E,0x921A7E329A216A4B,0x000000000000010A },
    { 0xBDB7E79BEC6C2D84,0xE77C3945DB16F282,0x6ECD2885411BE2D3,0xCB034559B4D40D53,0x9B27A5B5C6CAEF37,0xA4B12DD530EC1026,0xD7FC0E2CB3663660,0xE83E4D0C2E1B00F1,0x0000000000000023 }
  },
  { /* Point #4 */
    { 0xD7BA67B2DCA5C86F,0xA2AD0453E4C65E75,0x77CF1258E190BC9F,0xB3F630142C69BC9E,0xD962EAC71689858F,0xC1B865C669336A7C,0x3F97565D9B5A5216,0x93EA967C1A73A39E,0x0000000000000083 },
    { 0xA8E4AF6B6EA73EBA,0x3FF8E52DBE248173,0x28A4E2BD3F3D34AC,0x5D52213E1BE61ADB,0x8EBAA43D02968A4B,0x735958E06FADCE98,0x2F143CD6C15F7644,0x533BEC76A7FBFC74,0x0000000000000061 }
  },
  { /* Point #5 */
    { 0x921CDDF9B02DE9BD,0x5284E40354CB70BD,0x47CB75FE485DE511,0x844BB7F2E754A4F5,0xD8E646FB01C4C5C5,0x2F1055909A4D1688,0x38C08F8E00AD301A,0xEB1EAB1749211208,0x0000000000000017 },
    { 0xEF36CB1B055725CB,0xDCCE426CEA940F24,0x29921FCD665F5CB9,0x04BF0DA8666D7A07,0x43F45CFAAFD71003,0x03EEC44529E78F9A,0xE2A5F7EEE17694B7,0xCD841ABA4B7CB8F2,0x00000000000001D6 }
  },
  { /* Point #6 */
    { 0xFBD6E794814311EF,0x1751996B26CC272F,0xE6A2E157A4D9FFA3,0x10FC93529A7D88F4,0x02545D80395D7365,0x56B7EE84DC6C4D32,0xC3DEA31EA455538A,0x582E311BB82CD5F3,0x0000000000000151 },
    { 0x1EADF021B3BEC16D,0x3406D4109CE73860,0x6785BE85EADB4C7A,0x68ADFDC3E1E59A9E,0x131EAD3CAB13F561,0x0B2C0C4925936137,0x6C318EBC0F35B6F1,0x0ABE8C27F819E825,0x000000000000015D }
  },
  { /* Point #7 */
    { 0x3345300A8EF092B9,0x3824081F33A01AB2,0xE685D205EA5B5A09,0x44B7A967F455D169,0x2C9E91557442AED8,0x64DBF3A675A96917,0x49FAEC7B449F53AB,0x35BA7EBACBFE4F33,0x0000000000000198 },
    { 0x811C4BDD19FC3126,0xFCDA0AEC6C46CC5C,0xB51C467DD486C15A,0x704C37554BD4174C,0xFB5EA371BBC329A6,0x3148600755447586,0x5482E55156AA7225,0x942959898F51EA5A,0x000000000000005D }
  },
  { /* Point #8 */
    { 0x44B3F23919FEC274,0x1DC89875E3A66ECC,0xE36EC60985EAB4F3,0x3713BCD6840458E2,0xCCEA99D32BB88A8A,0xEBD3D4BAFD21E802,0x03437C286FFC588B,0x3A21EFBA413B06BF,0x00000000000001D8 },
    { 0xD9AFA45C16355E69,0xE9B28F5B2502ACC5,0xEF1999B91711DA7D,0x4657EFA14EAA0320,0x0729DAC2BADBE83D,0x45B0ACD9B9CFBC6E,0xA014EAB6BB296D4B,0x29F6BEF363B0D362,0x0000000000000101 }
  },
  { /* Point #9 */
    { 0x0181F2CD7342C5CF,0x2F7FFF6D61286BEE,0xA47D2598F75DF407,0x0571C708C00A1FB4,0x3ADDF5E79773DFA5,0x2996A03A06F201CF,0xAB51127C47D8EF84,0x0FAEE9400472B14E,0x00000000000001BF },
    { 0x60D0629671F8B12A,0xD0F88DA1C0AEDAB2,0x9835F2F370437E2B,0xD0E78781C86CF385,0xB5A2870F384225AA,0xF53D2C1A0191D4DC,0x3B44D4181C080B55,0x6C7B0FFA2C884241,0x0000000000000049 }
  },
  { /* Point #10 */
    { 0x30016EE322B152C0,0x70DE4BBF114BFEDC,0xCBDBEF831E26173A,0x7614A523370E3B92,0xD7D0C5F4D3E9E924,0x221AF66ABBEA4A57,0x2DA2BD107007E4F7,0x17D2A5BACD5B3B7E,0x000000000000012C },
    { 0x6E8482436639E4EC,0x9EEAB903EE4D0989,0x0BB3FB64DD0B4EFB,0x07089DF4CE8F6909,0x7EF71F65545A7C71,0xE91CDECC6884437F,0xE1D60E1401C4BA6F,0x398484DE2AB50390,0x000000000000011F }
  },
  { /* Point #11 */
    { 0xBA77CD4943EF45FD,0x5EAE5D8314ABBCE5,0x3DED22447BA79C20,0xA09310AD18978464,0x4D9A4F58ECAA75F6,0x2461CF62CEEBA7DD,0xAED1EEC69BAC333A,0xC6AB1B3C6F3D713E,0x000000000000015F },
    { 0xF39FAC2345FFF29A,0xCF878F407B611EFE,0xA5C2DC3CE3BD3BCC,0x0970D2595E0F88B4,0x40631B3287EAF4A9,0xAB30961553916DD2,0x10AEEB268A76FAE4,0xB9D4A7C061102A5B,0x000000000000012F }
  },
  { /* Point #12 */
    { 0xEBCE4A115A224092,0xFE887CC974E91AC0,0xED3BEFF1626717D8,0xD6915DC097F9E7D2,0x6C5AEB18A6DE7E4E,0xE18C932268E302A2,0x4EF08D0EE3A4FCE4,0x7524F6F1A36161AE,0x000000000000001C },
    { 0x096E3563FE82F5F0,0x54CECAFD13216B13,0x51D809421D3CDE0A,0xDBD61AD0C2608747,0xAF378B29DDC6C9F1,0x09A4057360507871,0x755FB6481251C43E,0x7EEAF993A14377DE,0x0000000000000035 }
  },
  { /* Point #13 */
    { 0x1EC43A8707CD9E9E,0x027026926EE1ACCD,0x1046EF63639E55E8,0xFB61349BEFA78E78,0xF4BADD33D1F04936,0xBA37EB11C6AC2AC1,0x615452DE11B98003,0x6186280BE5B61D26,0x0000000000000135 },
    { 0x5C4ADA158A9606A2,0xB67BE6F1FF81D9B7,0x6ECAB24FC248F000,0x83F4E3FB49413727,0x6D244519F00F2AAD,0x3F8778BE521D5032,0x0B34B167854BC501,0x9A989E719339C469,0x00000000000000A3 }
  },
  { /* Point #14 */
    { 0x354D6470CFF89FC1,0xD5880E0184C3F4A5,0xE8CB2497DBD934D9,0x80244F291DD7A63C,0x87C983B43117C661,0x72361DE291C17B69,0x2C94190B2EE78D13,0x995A4FF57D91FC16,0x00000000000000F9 },
    { 0x98B17D2525C080A5,0x3F2403B05B281B5A,0x30F4915AF7F4C45B,0x01310B2AB9189EC2,0x3DD5F6ADEF36C514,0x39C3A0E711FD5062,0xCB2063DC862BD28E,0xE1A75D8E90A76270,0x0000000000000037 }
  },
  { /* Point #15 */
    { 0x61E47833DD537F88,0xF8729B6342B97A97,0x292CA6CDAD19722E,0xFC44C2DE56B5494A,0xB26AD9152175A3B9,0x6A9A86CD267F1479,0xC79445B248771244,0x2C7C1DEBD1D9C112,0x00000000000000B4 },
    { 0x105668EBE8B487C9,0x3EFE20DF2CF039E0,0x07B40137E457AA37,0x8BF3258836A5D117,0x71D392B9D1CE7AFE,0x66D91FF0636D930B,0xD538DECB7E8CCA52,0xCF74FFFD7A538D2F,0x000000000000010A }
  }
 },
 { /* Table #48 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xFDF7681D6DEBBCF6,0xE21AEF25600EA3C3,0x181FB048BB30B75B,0xF9D8C43D8D8B7B4F,0x3D3BC6DECA68EC32,0x6D469252AF1641EB,0x1BE3C9BA10252291,0xB57F2C328FA4C10B,0x0000000000000155 },
    { 0x599E10E59EA96C94,0x4426DEB740593CE0,0x948D92862D48D29F,0xD3AD8E54C03F5CC5,0x53FE15E4219CD0D4,0x03B914210C8FC479,0xA023C978E5AA96E6,0xDEE00502EDB69F81,0x00000000000000B7 }
  },
  { /* Point #2 */
    { 0x28904911200AD609,0x6FB2B6633505C98B,0x1BF6E6B517AD4ABA,0x6D0E654FDBD8E9B0,0x8DB772C1F588FBB6,0x5C2B736FA292489E,0xEAC6E04AB902A7C9,0x249C84E7B2DBAFAD,0x000000000000010B },
    { 0x2CBC039029DE2306,0xAC01D1A5BFC36A57,0x89F1A059BACD8B95,0x2E1E095A3E92C99A,0xF172BAD607B4E976,0xDCE0B2E435885013,0x9A0C55567FA11B87,0x1DF0DFD67EAB7AD3,0x000000000000008C }
  },
  { /* Point #3 */
    { 0x3555F75C6A7E545F,0x1EA37A8E7A15BD6C,0x188207A366F5C712,0x0FC45BD94926901E,0xC55D2D8CD34B1E01,0xFC75E1AFD84F7268,0xDED24E68BEC74EE3,0x0F611682B82806BA,0x00000000000000E2 },
    { 0x5454065AF1943440,0x88291BFFD01B257E,0x6EACA283C6AE2502,0x88F29CE08A74CBE8,0x6DDB3AE9ADCE5E80,0x93DF4593BD911187,0x16BDC203A6B62E07,0x3A0AD818E8EAAC95,0x000000000000011F }
  },
  { /* Point #4 */
    { 0x1206EA28CD7BBB6A,0xEFF556D0C63062FA,0x8AD321FADEB86A3A,0x9EA9FBDAF78FCDC3,0x3EF406CB0E8C80A8,0xC168B5970F593D36,0xD6456267C352A3A0,0x303BD08332C5A9A8,0x0000000000000102 },
    { 0xBF911F73E680D0F9,0xB12FCCA8BC1A1B47,0xB8264577EF8024F6,0x9D17B8B7F66AE119,0xB135DFC275B33227,0x4CBF0D6D96E667C2,0xFFF742BEBA373B24,0x218E787E776CBD3B,0x00000000000000CC }
  },
  { /* Point #5 */
    { 0x1F8215F9EFB91DE7,0xF3ADD5D08A2F74D9,0x56433008A520D556,0xB6DF83C58628AC75,0xF3C38EA27390EEA0,0xB1AADF0F6078A673,0xA9E0832827B6B8FB,0x22E64291F3B7CE53,0x000000000000017F },
    { 0xB3E7AE4C6E69500A,0x740B9752C441E02C,0x3D04D6DCF503D4A0,0x22490A59862F3496,0x0F4A62AAB2472177,0x668475B979720C85,0xF6EBEB0BED9B4FD9,0x8A5A6926914E8BF4,0x00000000000000F2 }
  },
  { /* Point #6 */
    { 0x4231DA59E97EA880,0x5D4C048745262614,0x3718643736AEEAEE,0x17229D1DBBAA66CB,0x342DAF59A5D41097,0x5FC2CC015080F051,0x657C05A20E6527BE,0x3E61C315949E36EC,0x0000000000000008 },
    { 0x961BDC35D8A5319F,0x5B8F4DB874708CD1,0x901D28564726604C,0xE35AD211CCC10400,0x5A9B120594004A0F,0xDBF493BF5C8EAABD,0x6CCC828BBAFF6FD2,0x83003F1077E9A126,0x00000000000000B9 }
  },
  { /* Point #7 */
    { 0x3D91EA604C2A4CEF,0x8DE8F69C3DE838AD,0x9A725723538C37D7,0x3923FA077948B4EC,0xD1A25D23D23E67F0,0xA2D7B9D7396FBC50,0x8F8504E41D36F98C,0xAA9E585159191798,0x0000000000000147 },
    { 0x8EDBF0C2E3DB7296,0x677A299681FC8F30,0x05E27B8DB727E6AA,0x4F5A9A6903113B4E,0x9D4724E83ED42117,0x06C0B8A572FCB859,0xECDCF4D8AD040B87,0xE6BB9A0E8CDA9EB0,0x00000000000001D4 }
  },
  { /* Point #8 */
    { 0x6287BBCA1236BEC1,0xC16EABD8608E6B5C,0x253193EF15FCD3C6,0xD4EE71C7DA5FE623,0x62531449AC806CB8,0x9152CF1690D7E00D,0xA1E05703D20A1668,0x6480D486BBF588DA,0x000000000000014F },
    { 0x37F70AB3FE2753E3,0x562F4A46023EBDF8,0x97358D7D89CAF63A,0x387422A7AB4B1DFB,0x80D654962C8C3421,0x7D338B4BDB8E13CD,0xA535529DAC590192,0x39A28761A6760430,0x00000000000000C7 }
  },
  { /* Point #9 */
    { 0x10D99B8DD76B6346,0x480C9BEFA7920F0A,0x41953A21B706637A,0xB5ADDD60EF7A9469,0xB066808FBF845F04,0x2C8D2C45611F7050,0xC9CFEA7D79251581,0x000249D5D23D024D,0x0000000000000027 },
    { 0x9CA6F04F42E026E8,0xF09A7B4B4C9B2714,0xA6E3C1B0D79C4D23,0x5725F810BCB1CA2C,0x3D609E1724593118,0x73C465A374BD9A26,0xFA9EEEAFCA3FB6FA,0xE1976E9573CC366D,0x00000000000000AB }
  },
  { /* Point #10 */
    { 0x483AC18AD11514E3,0x57C3389A197BF06E,0x0A2775A7CE090B04,0x9B2209FA69490B3E,0xA2F0D0B4B5DAA19E,0x62D41E1D2446C655,0xB9489A816181CC94,0x068F47E2C1FEAFC1,0x00000000000001AA },
    { 0x84A92C5187A0B889,0x40D2608A31236151,0xB23EFDA4A2A9071F,0x2F9C0F2639BC97D1,0x1722E3F9BA4E90E0,0x87DF7926121C08B7,0xFD8FD6058F2D179D,0xDE7E55332A94EF1D,0x00000000000001B0 }
  },
  { /* Point #11 */
    { 0xC1776AD5315A71EA,0x1A923984874F2F9C,0x8467D0E91A632C4C,0xBAD29DE6DC5125BB,0x13DBC6BEBD99E730,0xB02BAE45E96EEF3E,0xB587375D9AC7A136,0xAC9B12799316B303,0x00000000000000F3 },
    { 0x824A435CC9E89959,0xDEA49D7AAA7F75BA,0x4C1400B089B273BA,0x14E0F3565B2AC1FB,0x4C10109B9DF3E52C,0x508D9DE43EF9028D,0x03919BA47E06E687,0x5FC75EF86A8AD120,0x000000000000012F }
  },
  { /* Point #12 */
    { 0x91154399A1225BD5,0x09F880D2839A9D76,0x2365B9A7F4751A04,0x43F74A7390D894DE,0xC6EE5A916C763FD2,0x7E0E99953BE6EFB1,0x4BD0BA4892017549,0x8EEC2154B3C56B9A,0x0000000000000034 },
    { 0x23596183E6DAE2D5,0xE36E5DA5BEA1AA97,0x03C3DA3FB48F0691,0x198CE5E8ADDC84EB,0xA17AEDDF392A42CA,0x55EFC910BB9359FA,0x23F115AA3CB13AAB,0xB8119F9A6C174F3C,0x00000000000001DF }
  },
  { /* Point #13 */
    { 0x66ACF9E0E2B42C89,0x0AC5D407DF96AB0C,0x160B12342A609BD4,0x175DD749018BF390,0xAA6279B8EF953C4B,0x7488E73996BB7BA0,0x248C673D5B3B0558,0x4C833A0DBCB7C973,0x00000000000001F8 },
    { 0x7BC20F684D2CF409,0xDF69707BEFE3FEA4,0xBB76FF2473698DDC,0xEA4EF14D35CDEF99,0x1B1E107A09A8855E,0xAB7C0F94C05F8207,0x41D7AC36E49C7AE6,0xC180FBDCA0FB9BB4,0x00000000000000C2 }
  },
  { /* Point #14 */
    { 0x90AC444B379BBB5D,0x2AA673BBA055A5E6,0xC953A7041A0943E4,0x019F5FCCDAA3864A,0x13AC9D74C7C35BA0,0x68132F09076E3BD7,0x3D74B7271BF5D6A9,0x48E4897B20DAAFE6,0x00000000000001BD },
    { 0x505E833AA8416DC2,0x36C6AA7B9F12BF8C,0x81B58E6DC334EACF,0x4BFF9FC979B0F5F0,0x96A02DCC0CD714CA,0x0F20B9B5A16B4F54,0x4AA64FC4C3363B15,0x77FB062EEF059ED6,0x00000000000001AA }
  },
  { /* Point #15 */
    { 0xB4CB74403A726E03,0xF5A2E570A8D459D2,0xBACA555FA183F45C,0xA66468C309DAF66F,0x0C775322A6457550,0xCDBF046F23AFC0E3,0x701B1D3C60D4B0B7,0x40C08564436899C0,0x00000000000001E3 },
    { 0xEA712788F0179FDB,0x1E4FA6B5C3E8C717,0x91635FF0EE1665F5,0x71A7955457FF8D6D,0xEF4486ACC9764B15,0xF7279A54407A9D72,0x297F5EFE083F4AF2,0x082D870E95C3D3D9,0x00000000000000CC }
  }
 },
 { /* Table #49 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x1E226A938F1EF579,0x8AEEBEC9138FEDD2,0xA7E39D7D1CA4C4E2,0x5E53F86D49724F86,0x9815987DEB759DB4,0x538C9F700E9CD47A,0xFFFC98C71A7FAC87,0x3195776E7CE980E1,0x000000000000019F },
    { 0xCCAB7B37E33CDCBD,0x561D18F2855619D0,0x56AA5963818F21D0,0x1413193B571C3C5E,0x9B30214CFD748C72,0xEF0BD8D48EADF936,0xEB6D831FD1964B92,0x4B37D5E09BC42BEB,0x00000000000001EF }
  },
  { /* Point #2 */
    { 0xB854567B979551EE,0xF97B8CAB3F3F499D,0x3E343ACA603FE8E0,0x2C4167F8813ABD6B,0x6B23EED8A74BFD77,0xF88B1CECD47DD491,0x9E613C3226B2FD87,0xC1B1AC19FE54BD69,0x00000000000000AF },
    { 0x12BCAFBB43B4DF17,0xBD0829247266CD9B,0x9D1E0EB35A197805,0xF44AC91276CAE6CB,0x7D4E90E630D68179,0x5407A9A02AD9609F,0x02CBCE1C921ECCA2,0x058AB973A246D665,0x00000000000000C9 }
  },
  { /* Point #3 */
    { 0xF31853C99A73EBA3,0x3FD889550E6E4613,0x0F685BB932A3D4AC,0xAEAB0CD88CCA35FA,0x8F65C0F7EF18D468,0xBD45DD2509F0F948,0xFC2EA6E46BA83339,0xF6F79E60AE6934CE,0x0000000000000158 },
    { 0x3D279791E60D9028,0xC2CA4234F0C3CF4F,0xF21EC8F085AC780A,0xC2D9B19EE6FDB32B,0x9E2811FE0827C781,0x42E1538749E61BDB,0x936B8E23414D6887,0x7FE54043D7EDC198,0x000000000000008A }
  },
  { /* Point #4 */
    { 0x61B51BB04BEE80D7,0x0E1F6A1F7692DE69,0x8379E46CA0EBC3BD,0x1C0BFFA7930644F0,0x97C67B87390DB077,0x095C33E1FADA1CE9,0x3C500ADDAC54B512,0xC231D360D3118656,0x00000000000000B0 },
    { 0x0628929839BCAB2F,0xC0C0678064DD220A,0x062F6084763DC2A0,0x88E9DA731938C3E3,0x69BE8F2D52E46EB9,0xE55C8D2D6A5DE0FD,0xF3A3FD63DB2C0E26,0x899C6D9F1E4BFF57,0x000000000000014A }
  },
  { /* Point #5 */
    { 0xEF850C0A886B7B20,0x8F635025BB9943C6,0xB81D4C7D73EA21AE,0xCB8F069F99D3A6EE,0x6CF775A6FA33EEB0,0x4E222F778F96805D,0x143517AAA6141EA6,0xE38A3C64167210C0,0x0000000000000116 },
    { 0x0FB62F621FC78DBB,0x2C6410236CAB326B,0xA72EA35AF1549E38,0x537F6EA3830F25CE,0x9E079CAE33EEFB84,0x38C173BAB87DDBF0,0x1B4373897184AF77,0xF978084CB1868BCC,0x00000000000000AE }
  },
  { /* Point #6 */
    { 0x37456B07D454E1CD,0xCA872026E651CA99,0x66D075726A03D9A8,0xE6E9BA231D31CBAE,0x2B720E01A80F7B13,0xB6D7F827615F6CA5,0xF88F8CD69012B0AF,0x5024D5DE7A8E112B,0x000000000000019F },
    { 0x24EA6D08A8749354,0x1143855E290612B8,0x64CFB996E2EDB77E,0xADDFBF4F77A5F775,0xDD57F915DD64FD57,0x89CE3192055A07D0,0x9323E3E13CD0549C,0x7CC109CDD89FC00C,0x00000000000000DF }
  },
  { /* Point #7 */
    { 0x09DAC9EDF4222533,0x241333A9FD65CF38,0xAA15ECBAAF69F2F4,0x680CC1A0E6AFA6E0,0x581099C95F6F8C82,0x32F948104DCAE40B,0x0FAD007D4FF8175C,0x5DFD36385450471E,0x00000000000000BB },
    { 0x57A1BD6B9BEDAD5E,0xB187EDE777139166,0x66AB56BBD66AB437,0x8D67305E0875CC7B,0xD1221E1D2130FBAB,0xED4482700A435B57,0xEA5DA47BF4089497,0x280B2CD4E8BFB1F6,0x0000000000000115 }
  },
  { /* Point #8 */
    { 0x8F33504DEDB74CB1,0x1EDD5D969D2A2437,0xB4A43AADBECED5E0,0x94FAEE53A6679DCE,0xDA5CA04FF6D1589D,0x4E55494935D8BE40,0x3DF8D236D5311F54,0x46F9C2D24988FE68,0x00000000000001F7 },
    { 0x4D0D9475FB2327CD,0x552291CEF0B8FAF0,0x3E3F4A98661E3C78,0x2C452F05BDA95549,0x53276D708BB411BD,0xFDE0440E539322F3,0x02D8D55B20961BF1,0x3C1E105518739DCC,0x000000000000017C }
  },
  { /* Point #9 */
    { 0xC03F25C3C4AA5646,0x86C63161F5058946,0x524D9F422C02DA6B,0xFFD709D2D08CFC8F,0x1E8214F8BD67D9AC,0xFDB0716EA4953705,0xCEE198F0637D647C,0x0EDA33411FC50C8F,0x000000000000014C },
    { 0x3771081BA26D80EC,0xF495AC4F7EE1F2E6,0x458ECDA5CC9F8790,0xA98F84AA11D6C1D8,0xE9D067997B694BD4,0x510A0F753EB0C3F8,0x9747F31B40F2693D,0xA08798275C3A8FDB,0x000000000000014D }
  },
  { /* Point #10 */
    { 0x2588C869678BE8EC,0x643C5BCD70A17049,0xFA8AC412627E6964,0xC9E2C5E1D12B30BB,0x6189DF6FD7F8B20C,0x7FD5DF1593B30B2B,0x30176ABAAA08DC30,0x12C058C36722406A,0x0000000000000166 },
    { 0xF11E3160E2A9CC34,0x839D94196B6DDFB8,0xAE2E884680035A3E,0x8BC4C61BD1F3C45B,0x128980AF18FD9AD6,0x4210B25EE59CC085,0xAB245EE01EF3A74B,0x256FAC53AF76D59E,0x00000000000000D9 }
  },
  { /* Point #11 */
    { 0x31509AFCA5F6CEDA,0x147406DD5010591C,0xBC35C5699341D9CE,0x7CE9ACE9BA35F50A,0x19928AC5EA9234BB,0xE036D3987FE039F4,0x920FFCA4004965E5,0xD18E5104051A7E12,0x0000000000000040 },
    { 0xF5630CF3A22366A1,0x52E3FF045CA6AB82,0x98B95576053A65E4,0x8E7F4A1B08B986A1,0x7E4F3C04E03A5DBC,0xCA92D084A3CC2E38,0x92EBFE5FEFCD06F6,0x88F060B35A709EAB,0x00000000000000D6 }
  },
  { /* Point #12 */
    { 0xAB2A1492A5CBA744,0x6A6A4317986C613B,0x9C8D1D01E872357E,0xE7C3D762A1A8701E,0xCA296C88937B667F,0xE5DDB632B105FFAB,0x602EFDA3DB9D7CFE,0xB72B8EE5075FA1AB,0x00000000000000F7 },
    { 0x420F01BF09297D3F,0xE6CDD604CE02895B,0x475DE3990EC6827F,0x2A44D697D96CD553,0x889200F98C9D9769,0x4FA1F222A7289C6B,0x5A45FF976D4D1B4C,0xDC9910A51E63AA2D,0x0000000000000098 }
  },
  { /* Point #13 */
    { 0xB6A85B1106456038,0xA422307CD48AF4A7,0x25C9835CE781207F,0x61E1A5AC67C18DCB,0xE294353581F948F2,0x427F9AC30F7FB178,0x2DC53C002E2BB161,0xDA0D1835B838B9F7,0x0000000000000122 },
    { 0x2E4D3E46DF6800CF,0x66910D0655D86505,0xAE5A0DD7F0D1ED6E,0x0F3F3D6A84643A02,0xE9D03F79EECF2E38,0x8A7C07D8EF3E2228,0xBA7786AF35A3F709,0xFF8997EAD43DA7C4,0x0000000000000044 }
  },
  { /* Point #14 */
    { 0x78FBE6ECFF0FDB4D,0x4625DB146786490E,0xD296291FDBA395E3,0xA6A1DF669878E3C8,0x0AA57C9655FE0AFA,0x9294F74589235066,0x6FB4692D1D24D786,0x7FDAAB78E13F2A4E,0x00000000000000EC },
    { 0xCED57ECBEEC9BDBD,0x5B935678813A87CB,0xEFED2811B9C45D4F,0x17B12BF552C52DD1,0xC8F5C7E0211123FA,0x387FA7DD245804D9,0x2A42349809BC76EE,0x5B95C590457DAA36,0x0000000000000089 }
  },
  { /* Point #15 */
    { 0xD2006FAD8A90D8C0,0xAE1A509AB872540B,0x774048A4EA281ECB,0xA53EFEAD7A84CFC0,0x5D970194332CB313,0x4B2736352866ED7E,0xB646A148A3D68D32,0xFACA3712CF8B5D7A,0x000000000000011F },
    { 0xC726FBC2C789ACF1,0xABF5095893F6D7F4,0x5C9B593F8791335A,0x83523E7DE5E84484,0x5DCCAB399F06EDAC,0xCB72C6D6BC2CD75E,0x5038AF212638469F,0xFA7EBA1954B0DBA0,0x0000000000000165 }
  }
 },
 { /* Table #50 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xFD0261287468E327,0x789E8DC4EE755906,0xEA0453E480218C94,0xE263FE27088D7C56,0x9219CEE630277200,0x293401D28CE5AD85,0x627036D3B960EBBA,0x8BE032FEF92DA0EA,0x0000000000000030 },
    { 0x7AB52E739DAF8D6D,0xD6D75D4C3F789F6C,0xC3B7560EBFC9A31E,0x87B7F183D7DB7AD5,0x0F60A2DB9C213425,0xC2E67C9452C58981,0x001CF3E81B6D0B43,0x31EFA39B78235B3F,0x00000000000000CE }
  },
  { /* Point #2 */
    { 0x04E8DC9FBCB97CCC,0x4652847E88086FBA,0xE5EC071965411266,0xAF72B4A169E1C843,0x48E75C318161E951,0xAB6457928A39806B,0x3FA10B38A2A97512,0xBA9E2EE7FC3A693A,0x00000000000000FF },
    { 0x3B96E7C33B70D15F,0x87C3F3DD4AE9E52C,0xA256E7E864ECC9F1,0x541D8B6D07C90736,0x2367141F6C2B4160,0xE32AA363CAB770F3,0x51E2C83261282E7E,0x194B06A2F3FA7817,0x00000000000001C1 }
  },
  { /* Point #3 */
    { 0x22D8C3C4D2A1F241,0xCB6055158ED2C14B,0xBD634A2E2939F855,0x30B2B6B91E9519B4,0x19911C0008A31D22,0x60B0713B979CD33C,0xF41A8ABDB94F9B61,0x3F2D8C91EF72CF1E,0x00000000000001B4 },
    { 0xF0ACF9B3D78B56EE,0x12112D24E915A265,0xA18C93ADC1D7025F,0x279A4DB82E652107,0xBCA73AD02BFFB5DA,0x2CDFEEE4E2D168EE,0x6D83A77F5A4ACA12,0xC203514B1D22E8F4,0x00000000000000F8 }
  },
  { /* Point #4 */
    { 0xAD8F0FE4C4E24C8D,0x81CF16FDD1EAA52D,0x710A08A7D68864CA,0x8E736C0E7539DE5F,0xCA6583377F67341C,0x63892B7D900B74B6,0x5D1D91DB6E9BE886,0xA4DA95649633A600,0x000000000000019B },
    { 0xCDAE7A975C319D97,0x873B4F53D0316874,0x7AC186845C213AB4,0x4F0B5AE2AE9109C5,0x1934B7ED7A661690,0x0F98ACD90707B518,0x12F07C5534017E00,0xE9B121A16CE4AD49,0x000000000000015E }
  },
  { /* Point #5 */
    { 0xD5B0D5A443F7453A,0xF96B7FFBBB43D3A8,0xB61C49F2D0C86229,0xB37D31608D18B4C1,0x7A18F0B92379514C,0x8A7BF63C0E440995,0xDEEF9EA1D77C09B2,0x3901E8B3364ED115,0x000000000000012A },
    { 0x66888CF0E5A32971,0xA1E4C1BB7A9C3886,0x19F7388464822F55,0x7C31E97AD925D4FB,0x131BAAD0ED044B10,0x2477A6B3589074E5,0xBC5CAFFFD8E1044B,0xB8D26D09B14C4291,0x00000000000000D8 }
  },
  { /* Point #6 */
    { 0x8694060F467A85EC,0x998DE1129145489A,0xEEB25D771F21B607,0xFE55D2D35E92D2DF,0xE829F9D8FF94790F,0x4AA821AD9D8DEAD0,0x3930473535D38D66,0x1FDE1E5B4E27D52C,0x0000000000000134 },
    { 0xD513588E5A046E85,0xAAA559AC794B4D0D,0x649571CC2C2868D9,0x1A6CEFB80FA20E5F,0x4B9181A3067EF910,0xF095CE2F8A0C6BA4,0x078CF183F1443257,0xEFE47DF93A64FE5D,0x0000000000000012 }
  },
  { /* Point #7 */
    { 0x007BFFC0EC5BA37E,0x8A9B51AC154F22FC,0xD54FDBF525F8E4C5,0x90DD4FFEDB848843,0x428E6E53F05ABCC5,0x37801AA6B8DBE8D0,0x9C4C029297B4D76D,0xA5970346F8F667E6,0x00000000000001FA },
    { 0xBB69FA25B42D2421,0xF2AB0C5F28B20798,0x1EDF762A02996989,0xD2CFC47B01C8F5EE,0x427D7D5B6913E414,0x12B1CD4012920CCB,0x04443F3F5F552D45,0xB3B0D58F6EB463B5,0x000000000000005B }
  },
  { /* Point #8 */
    { 0xF4D3BCB3E588A775,0x63161619365983C7,0xBA7334AD66782F6C,0x1F14DEDB8783D25A,0xFF6FE73C50C67FE1,0x711DDFE3F79A86A3,0x7CBD7F3A027D18EE,0x7F63D331C4ECD52A,0x00000000000000D7 },
    { 0xF463A32BCB49037B,0x66E4CE3DE7C35C02,0x1D175313116E0D6B,0x3BCFA6722D307EE9,0xC6F9BCDC7C79261D,0x79BB33DC994649CF,0xB491B05F6D4EE55C,0x4BD0668E1E6846BF,0x00000000000000FF }
  },
  { /* Point #9 */
    { 0x32A2AA64203D3B51,0xF0D8F978E4826DD9,0x5B2DDAE308B1E0A0,0xAE0573A968984128,0x1855BFE48BF3A344,0xA6B7EB6AFCF6160C,0xE83644FD8AC1B173,0x401AC6CDBBA4AC0D,0x000000000000003C },
    { 0xE55E7B7679EFA1CE,0xF2F329EB9010F35E,0xFF22DB9FE98A6C48,0x3620D337C1C134C1,0xE406000D38991F57,0x79FF983EDB34389B,0x38D6D3D1BB1431C4,0xCE14CC1142EB89F2,0x000000000000003C }
  },
  { /* Point #10 */
    { 0x8C2ECEEFFDDCE52B,0xF5D8451101F9FAB9,0x51AC8EA416868E6F,0x367D5C118FDF476A,0x6FEB10FE697C3FB1,0xA43A0E11CB5C3410,0xD09B99BAD68F1E37,0xA25B434BD56E385F,0x00000000000001EF },
    { 0x201239CA0BEF6906,0x09CB0ADC611BFE48,0xA1DBA9103964E192,0x3EC3276A21B4711C,0xA89349BA5DC30435,0xD245FA4FF7AFC213,0x598F7A133F438B15,0x9204E7F4ADEEA3A5,0x0000000000000128 }
  },
  { /* Point #11 */
    { 0x3A5F2C022D02DC14,0x4498562900F1CEB1,0x326BEC51E7A78555,0xA74B089104D9BA2E,0x44B8829C80314109,0xE62A0E41820BF675,0x3BE1084FFEAB4BF7,0xA1655365C9164C21,0x0000000000000082 },
    { 0xE699E9A56E327EEE,0x4B23BC7A4FD40F59,0xD65FBAAA2ECE5156,0xDF8AC059B2C1FE79,0xFB1ED16D307FDCE2,0x7627AD6B3531ED21,0x39010E8ED9E0F7C3,0x486FAFCE7E783223,0x00000000000000E7 }
  },
  { /* Point #12 */
    { 0x705E71993EFDE213,0xF146E31D4DF7DBE6,0x6A999526CA292011,0xFE01D54BAEF39B2E,0x26CCEC2FC5178DAD,0x1994A5E58F7C7797,0x366485CDF9EE629A,0xB156F6C990036FFC,0x00000000000000F2 },
    { 0xD569F8274C82A533,0x71E2D88F0F7DDCC2,0xB80AC31829C42C1E,0x8D6492A28864D627,0xABB38A9282F92B56,0x3CA83D0F7E0DBC1C,0x368A5780D03B2698,0x4370654E66C9D259,0x000000000000001E }
  },
  { /* Point #13 */
    { 0x68D61A80DC2A3114,0xF8D5F56A780B31CC,0xE63B8739486B4B7B,0x2B82BD3980E002A1,0x20B9403FA4FB662D,0xE85150355BEA3101,0x066C8724D2939D5A,0x5D3D400FDA98F9FE,0x00000000000001D9 },
    { 0x2E766A468B5C9489,0xE8289E7213B49FC0,0xE8803FC9DA57FAAD,0x4F67D0331E07512B,0x3D850293ADAA1224,0x4649CBC9B241DE49,0x82B14A1A642F0382,0x01D09209CAC20C01,0x000000000000017B }
  },
  { /* Point #14 */
    { 0x606F0A6CEFD683C0,0xDBBF0F38E532494F,0x74B1DB593321FE2C,0xB733105ED61E893D,0x949E285727EA6853,0xA2EF532561040EFE,0xCBCC0F83A9E4F8D2,0xD54D8B4FE97B7E3A,0x000000000000018C },
    { 0x91659184C4AF2A32,0x73D6EF6EC7A58B33,0x0CBCA54EBFE2029A,0xDA2D785C6248BBB1,0x057A7FF8C11A2EA3,0xA3F84A883AE065AF,0xE3AB048FF5650F1E,0x38D1FC906D90DDD0,0x000000000000000B }
  },
  { /* Point #15 */
    { 0x402F7DF76CA433D8,0x82B0C66B3CFE61A8,0x46E016B843062A7F,0x1B5A2DE5975E3563,0x47A8956D9A7FEC08,0x7DF651A08BE0557E,0xFEE8F682C0B33D07,0xD92B59BF13E03A8C,0x000000000000012C },
    { 0xA3A81FEE86483788,0x9C6052AED7507EC9,0xED2EE49B8C8290BD,0xEBFD06DA60AFF68E,0x0EBC9C1109CC9BA2,0x36EE290B3BF24667,0xEBEBC4CABF75C490,0x862F9F78D33489BD,0x000000000000002D }
  }
 },
 { /* Table #51 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xE7BFC99FBDEC6EFB,0x2BD3D26B67326C7B,0x23F041FF594C614E,0x5A778C67EC9B4420,0x75B5618B30EAA444,0xF8E2BB92AE6D50A4,0x7278C60B1FDEB6F0,0x5B8471DD97C654CC,0x0000000000000139 },
    { 0x115A81123E959CA8,0x13DC4AA38BED7EEE,0x02340F86EF94C5FD,0x519293A499A5D5CC,0x09573381294349A0,0xDEFE063FDA33B39F,0x6A18640AA382A806,0xB3E25FDBD227A86F,0x00000000000000D3 }
  },
  { /* Point #2 */
    { 0xE3169760D3A4D912,0x5568005C7BA3A1A6,0xB469884DD7E7B5D5,0x6BE70C098CECEC62,0x6300A32FC5D6363D,0xC2FD66E44DB63578,0xA131EA2135AE7BEB,0xA82FD7FBD31A6F2F,0x00000000000000DA },
    { 0x1280D69100DEB4B3,0x72865157A4EA0ABE,0xC87881678934A09B,0x5733CC11A70DD871,0x139E88760FFC8EB0,0x8E9436E30D958521,0x06D1A845B3059F58,0x3C220AB3A81354F6,0x000000000000000B }
  },
  { /* Point #3 */
    { 0x1499FF98AC49D960,0x98F7925A3940FF6F,0xF6C696DD743F2CCD,0xE7C6C272EF310A73,0x4029492D91AD1858,0xA2E65AF9483037CC,0x080C3FD0D3453348,0x4A1F9803068380C0,0x00000000000001BC },
    { 0xA39427DDD9DC2514,0xE0F733ECB2A91D48,0x0144D74F29219E28,0x25DDCC92E3FC6C5F,0xB90E371391F871E5,0x3F763ADB81A245CA,0x1FC6A1492F3E2323,0x92CC2090B41F0B93,0x00000000000000A7 }
  },
  { /* Point #4 */
    { 0x293385EDB0596774,0xCDF619F0DC09FB31,0xC4AF9E6A90F76D96,0x54B471B7CC8596FC,0x18FFEE0265BB2EF9,0x4942B53FCF9D919E,0xD6F9D2A9E553F316,0xD83946CC6A58EAA5,0x00000000000001B2 },
    { 0xA1D2DAECDF8AA88F,0x62CD7B320CAED19D,0x7C08BC5735B5B292,0xE1A60A4454118651,0xB1D83A9EAA8E4F5C,0xC47B05FDA30E7AC3,0x9167E33E388DAA83,0x27A10BE2B9685DE6,0x00000000000000BB }
  },
  { /* Point #5 */
    { 0xF5FE39ED1FE5F835,0xE17A6FB3164E9741,0xEB9A084A0F1180E9,0x95F55D56A1174F31,0xC33FA3D103850AC7,0x15A29BAC6E0DDD06,0xB80A0B7836F2F29E,0xE5D8DDF467CDE67A,0x0000000000000133 },
    { 0x1767C74CC5EE0DD4,0x1D61299BD7E4BDDB,0xF4D89A2FFA74FB11,0xE8A63C4A0037FB90,0x30FCDB047800EC4A,0x49A1E298D490DF3B,0x3D3510A2DA5ACAE7,0x2D4184AA78CE9832,0x0000000000000024 }
  },
  { /* Point #6 */
    { 0x7AF8EE911D17B705,0x8E4E597421098F55,0x0542A394D5CECACF,0x4D8EB8395094F357,0x8C86900C62D5A150,0x7AD4081BAFE653E7,0x387C8A7E677A5BBC,0x088120B9BE7886D1,0x0000000000000156 },
    { 0x986523706C398918,0x7C9C49714F6C44C4,0x443ABE7820A8FA98,0xF42A7FF4137F926F,0xFF4C7AA9F464B480,0xF88B491A277D4EB8,0x170A625FC3CAB7F6,0xF9BBA62BCDCAB435,0x0000000000000186 }
  },
  { /* Point #7 */
    { 0xDA963DC90741634E,0xC2B6B3CC6A62E31D,0x726FFDB0926A9817,0x2BC8A0C6A7A05347,0xB440BEF6DAD1F7A5,0x96AE7CB3666EBFB7,0xF3B41EA36955BBA1,0x2ED577FFB1869190,0x0000000000000025 },
    { 0xCD5DC527B188B5E5,0xA3FA5778CE6E943E,0x463B9AA822DAF81F,0x2A0544EFDFB44926,0x7C78F0E5C5F56C83,0x83A5552B87A0CACF,0x8A5A5CDBF491AFFE,0x419BA8841B8398D3,0x00000000000000BF }
  },
  { /* Point #8 */
    { 0x4AC7CF5E23E6C204,0x7B4459A48DEB8019,0x2FFD2583EBE4E27B,0xAB15FEB705E6AE2A,0x270A5D8FC902355C,0x8D3DF414FAF419FD,0x191B90B534AE3D01,0x497282C4BB5ABD9E,0x000000000000011B },
    { 0xD2232AE08C7267F4,0xE1FEC69B17B6532F,0x1C6A586EB1A2D82C,0xEB84318629128558,0xBF24D2F13A80EFD7,0x93763DDBB22228D1,0xF9DA00393CB37B92,0x780D8BA986CD2952,0x000000000000018A }
  },
  { /* Point #9 */
    { 0x11DA16733B2B4777,0x0DA01F6BEE05ECA4,0x4A39B2C1B5C102BF,0xB1C398F40180ECAF,0x0F34076588C87533,0x0C47914AC3C66289,0x3696A6FA0DD34C31,0x81E365A2A368C6D7,0x00000000000001F0 },
    { 0x840B207FBD408342,0x30261282FECE17E0,0x40257C9F3DA41FB8,0xA4CAE7603B1AC31A,0x5FBCFF5F594F704C,0xE351CEFE85314299,0xE22CB75C12B975CE,0xB1F453D9AA5CAC15,0x0000000000000004 }
  },
  { /* Point #10 */
    { 0x178D85D0416D2153,0x4C5E98AC3192F6B3,0xA2BF4A99F469BFB7,0x0CF96DCE79B1C827,0x1F0C1C1426BFEFE5,0xB311EB1D1EED9D89,0x740F6075A0E8EDFB,0xAF5AACCD20253B96,0x000000000000004A },
    { 0x383C53E0E2C5BCB2,0x2BD6968FDDF8BED4,0x3F7FDED26470A5AD,0x4262C3D7081745F0,0xDA4DD333CDF6DFD3,0x3198E00505D05D05,0xC90C1C96590157C9,0x2AB65D5B805804C4,0x000000000000018C }
  },
  { /* Point #11 */
    { 0x127344E29F66BF23,0xE5072714C3FF9B2A,0x9AA6B001571E9D32,0xE92E4AE6E6738A5D,0x4616E315433DEFAB,0xE1309A4A0B892330,0xDE5F54F81ACD85A9,0x6615D532A0013A39,0x00000000000000B2 },
    { 0xAE7FE9461948C112,0xABA4B1F25FC94EEF,0x622344602EEBEEDF,0xE9794E6C8C0C8AFE,0xA2DBAC68AA7D5990,0xF59D5A7AD07E966C,0xC301F1334490BB8B,0x05102377FAC91F14,0x0000000000000076 }
  },
  { /* Point #12 */
    { 0xFF3620B84BDBF53E,0x9A92F844CFB096A3,0x3B4C39D9D79176EF,0x5C23425D20C67BA8,0x2A3A36C2AA571818,0x131FBFF694D33BCE,0x8A647CE852FC474B,0x082F25D4708DEE34,0x00000000000001B7 },
    { 0x0B83C1F0799941FC,0x39EFDD8895537412,0x569503FDB5578A16,0x858772FF0AC52D85,0x1EB29EF86EEAED65,0x416B2A4900EFB022,0xC34726FB98E0E612,0x460F3C084EB7474B,0x00000000000000B9 }
  },
  { /* Point #13 */
    { 0x5D942F48EEA1B609,0x5B5928F55D45821E,0x4E902A63E4334D8C,0x9487288DFD9C133A,0x076583EC0562AFA4,0x15AC51CE847620A8,0x75614DCD6BB7DB20,0x61B4F0AC79817A3C,0x0000000000000135 },
    { 0xAFA3DB2917E1ADE5,0x34C874F1303A98A8,0x46A0324DB21AA653,0x6BBD6E145845D604,0xA08A64424C41DA8D,0xA86F0ECED381C0BF,0x680383DE6177267E,0xD8A8C02C2EB78F7A,0x0000000000000182 }
  },
  { /* Point #14 */
    { 0xA29EABE4613C2400,0x6DA11AD55FD4843B,0x6C479B3EA02471AD,0x36F15BC6FBB5C3AC,0x4FB2678CB1D9580F,0xFFE413FF946486C5,0x5907BFDFA12B55E6,0x32F96E37446DBB1C,0x00000000000000F6 },
    { 0xD371325A5F34ECBC,0x4381C3CD2296B634,0x059D9308E5FD27EC,0xF6CE8B258E757BBA,0xDDBF8E7ADE871B1E,0xE66728521ED3E5D9,0x6D20B61DA5D76131,0xB8902120ED8A464A,0x0000000000000029 }
  },
  { /* Point #15 */
    { 0xB22B6DF53FE8F109,0xE4AE50E7C00EDCD4,0xBF891CE36387044C,0x0716F49BD08FB385,0x0EFBE8C154934B45,0x08E66176982F659D,0x042CE73691962A9E,0x1F08748CA2974528,0x000000000000006E },
    { 0x8FA7ABDD6B9AF5D7,0xAA2FBF79978B04CC,0x4EA61BAE7F3136B7,0x406B670E150CAD9C,0x22BE2A1B08AA96F6,0xFFCC680D566C56D7,0xE65207819A111236,0x940AEF1C69D2E843,0x0000000000000062 }
  }
 },
 { /* Table #52 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x0FC6C549C4C762BC,0xC43915E34E5EB96F,0xAD88EE68D1BB0B5B,0x484A9FAD3F1F26A3,0x0D93055C2BC15E9D,0xA745ABBB06D26BB7,0xF60ED3B8464F0731,0x963D8D94EA9058BF,0x0000000000000039 },
    { 0x4608AC087B67B298,0x3BAF2AE6C85CF812,0xB30AEC550D25BEDF,0x581493507CE48459,0xFCB39F45D3C41E2D,0x48D241A0126E11A7,0x7B425421909A1621,0x9BB349DDE746BF4B,0x00000000000000AB }
  },
  { /* Point #2 */
    { 0x8F45148DA52D1421,0xE89923FD09DAF522,0x112CA311C8F15492,0x91B33CCB469E61FB,0x040DE443FB2AB91B,0xB9D124FD4F9B32E8,0x84DA47A9F07573BD,0x93B7EE6BAACDD14F,0x0000000000000064 },
    { 0xB3AF161F4BE64122,0x5946D2EC149C5475,0xDC04FCD0256A1ECB,0x4FC571B7327E7A8D,0x5206EA559580EDCB,0x7F41A742F20A94C0,0x1BFDDFF0F7FE1FBB,0x3860B232E2F1FDDC,0x00000000000001CA }
  },
  { /* Point #3 */
    { 0x9DE5C6D810392DB1,0xF58B3C587912DAE2,0xA367F217C559FD2E,0x78F2AABB466A352B,0xFF58D1A3E8271660,0x0D06FA5B8BD06035,0x026934B2FEA2895A,0x99899ABCB7E1A1FF,0x0000000000000187 },
    { 0xFD0BCBB355BB32EC,0xAC96A04D7F5D72D8,0x0D5626E3D939D606,0x145BBEF604504A8B,0x4D946B4EE4132C27,0x4E7887FB3EC1CFEB,0xEDEBCC5BE1D6E0E6,0xEB42BD232BF4379C,0x00000000000000FA }
  },
  { /* Point #4 */
    { 0x7EAEFE12155C337B,0x357F27CEC7186596,0x90C26C69654DBBEB,0x6BCCA278A1B63A6A,0x776B7A928EDD9123,0xB2BEF5076C6DA5E9,0x805ED3AA0E3C747B,0x298EF458659DF2EF,0x0000000000000098 },
    { 0xE3DD893935A79F8D,0x672B109CA1972C6B,0xAD41CBAE07953A4D,0xDE07527FD206DE77,0x1F55A4C0B61D9811,0x929D56D57A75360E,0x9F2BECFF5032EFE6,0x0DE654C760F0622C,0x0000000000000018 }
  },
  { /* Point #5 */
    { 0x971B8F03632B1ECF,0x4052AE98E4B06088,0x323C3E295AEE5313,0x7574C5DE635E62C0,0x2F53804CF0595C76,0x2ECD2BC5BF3BC3AF,0x5C7EFEC0FABA7271,0xDB04A6EE867C13BC,0x0000000000000155 },
    { 0xD971CB39CE3FF1E4,0x15D128CB7F56172F,0xA1DF4ABB4B6EE708,0x06A4BC6C3C9EBBEA,0x766544EBB3FA98D4,0x78399E61A2C44D89,0xA6EF214CA25D711D,0x643648C3DB54091B,0x00000000000000BD }
  },
  { /* Point #6 */
    { 0x5836D62A7E90D114,0x661E32F395A519C6,0x9C1082C869BACBAE,0x5A4BBB58F10CBFAD,0x04EE0B067C1BE909,0xC726F0528EA7768A,0xD82148C75B1B777E,0x0B9F20BF82E33686,0x0000000000000172 },
    { 0x2CB030B0CBE4B02C,0xBAEFED9F8382C749,0x8DF9D1D01DAFDDA6,0x9F4B2CC1FE045A44,0xDC1026099CEFB90C,0x577098DF9027BB0B,0xA13DEC95B6260AFF,0xD45A8C135011ACD4,0x000000000000016D }
  },
  { /* Point #7 */
    { 0x4DC3246F0F694063,0xED3DD53CAEBD3125,0x9B3BE97F0E985D76,0x37EB09EA9A5EC60C,0x14FD9893F0C7D07C,0xE085E6427FC04709,0xD56DB4A780FC7AA4,0x16ECF07A4398A2C4,0x00000000000000BA },
    { 0x672219F5F48054E8,0x116743EEC56E157F,0xE9B616ACFD5885C4,0xA9DBC3E31BBE92E4,0x0E3BC9011FB4DD56,0x51D3A59D590246F5,0x6B003576FDBADCE8,0xE8DDFD6B09A1973F,0x00000000000001E0 }
  },
  { /* Point #8 */
    { 0x50E39FD1EA8DC4AE,0xC68D8B0F5FD16C88,0xC95F46E90CED75AB,0x845EE3947375E952,0x5865161D3C14B1C2,0xE29AE3A6399431AC,0x02D1C6EAF0FECA0E,0x76059DAD24F35B02,0x0000000000000081 },
    { 0x29FEFCA13AC6A96E,0x260A7F7D5D01C1D8,0x63FA36033EF9812F,0xAB1A91C9F9404B6D,0x32555CFDA9406E88,0x666EAE1C5B63890D,0x22EC92AAFE9605E0,0xDE2A85103235E860,0x00000000000000C3 }
  },
  { /* Point #9 */
    { 0x5A24D834B256556D,0x6E39E6B9F63C1DF8,0x6DC4ED5BF481C4A9,0xDEF702A2387BB7A6,0xEDD61BBA2A3A8D3B,0x7727A94676598B94,0xCE2BB30C8C5DFE3C,0xDD17E4DA5CBB743F,0x00000000000000A9 },
    { 0xD333E98D7A2C22F6,0x94D666906F67D8AF,0xD7EDE2CD4466A868,0x3897004CE092C972,0x1003A6D130A617F5,0xD167F6E5FB55C4B4,0xBE82536422377313,0x4E1D6368BAB6EDE9,0x000000000000019E }
  },
  { /* Point #10 */
    { 0x3170AEA2FEE75A15,0x9E0E69039756A89A,0xABEF3A89C72A7A11,0x6A7C4C8C0856B5F1,0x2050C24837874284,0xEB61D86AD0B1F1B5,0xAF630E177990C87C,0x732BB871D149F7A9,0x000000000000010B },
    { 0xA206B1CB90B0FDB5,0xADDFBD666907905B,0x76FF73D5C7E0D4F5,0xFA16D711E922C8AD,0xFAA32DC1F3122B80,0x6EAEF627CE74F463,0x83DF81427D9B480F,0xBEF62DB90B1E25ED,0x000000000000019A }
  },
  { /* Point #11 */
    { 0xD6A82C9765841D0A,0xAB5206B00D7552A1,0xC998B6E623E31563,0xBA00726BE8866040,0x34572DC364648DE5,0x68D725CE6ED070FE,0xED54A1264C4E86EB,0xD124DC8E35D1B360,0x000000000000002D },
    { 0x35EC7CC165DD26DD,0x9C7C68FA5813D0AD,0x8CA6197D165C0DFE,0x830767900BE67F55,0xC81F6CCF86FAB7B8,0x11BCF8295EFF5E12,0x443EA51736E20E6D,0x35AF3228D762B952,0x0000000000000080 }
  },
  { /* Point #12 */
    { 0x6587C0B191979247,0xF06DC068CCF0762E,0xC3A2B88E277351E8,0x42E9494A2F607AF3,0xD1AECCC782B271DF,0x3AC627D494648A93,0xEB180B78BB62DFA0,0x7E34653033232D06,0x0000000000000183 },
    { 0x084E8C75E5C2357E,0xA380334756C91AC0,0x772E24A0015742F3,0x2610A9B247393C4A,0xB58CED0B436A641D,0xD55DBDC01850FB56,0x64C97FC5AECF40AF,0x6DE1DE5D00330087,0x000000000000009C }
  },
  { /* Point #13 */
    { 0x8117F853B1216CE4,0x98AB62235D41EF4F,0xC92A77A257C7E4C1,0xD8A5B415B54180F6,0xF0125978E06D316D,0x4FC9352276B2CD06,0x98DB80B124F61F6E,0x830572B917CB49B1,0x000000000000008A },
    { 0x4AD48B1B07419F5D,0x2262398C365D33D0,0xF3DE22D7DA9E2455,0x766B6119DC79026E,0x7A9ECAC3C35A7A0D,0x96918899689C9FD0,0x9C52D485B3B787EB,0x403259961DC27891,0x000000000000017D }
  },
  { /* Point #14 */
    { 0xCDA0C8E17B306C5B,0x5E0B3F6B0FCA48DE,0xD0D48CA4F0A0D8B7,0x1F39C7034CFC677E,0xC8F46FDBA6D42189,0x3F5BAAF97B193176,0x67E2E8108AD99C3A,0xEABA30C847087641,0x000000000000002A },
    { 0xEE23258C1FFE6E05,0xF52E20ED09EFDCBA,0x6C8BC2C5C3746FAD,0x9FCE34DDD647D025,0x309C147E87C326CF,0xE870F486A2AE9D4C,0xF5A54AFD96FAA0DA,0x00EDEC23DE8CBA2B,0x00000000000000BA }
  },
  { /* Point #15 */
    { 0x28CD57903B27C2E1,0xBD719855CB936251,0x41383EF175C25C6C,0x4D866B56AD562C40,0x58AB134BD8061011,0xF57D5AF2C2527684,0x27E7CD9BA9488268,0x501825D395FC6B3C,0x0000000000000040 },
    { 0x89926079EB68A11A,0x0F240BF5D201EF86,0x11F38E084FDB1E0E,0x551C189DD09F6682,0x1DFE94A3F4D489B5,0xE1631CE0052752CA,0x3B0629AA6FB98A0D,0x13AE4507EA475E6D,0x000000000000016F }
  }
 },
 { /* Table #53 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x2BAD7686D90119AE,0x8DCD64F0464B230C,0x1D1EEB94DAD19CB1,0x3B47038986F0EB48,0x42ABB37D2C50F380,0xFABBCEBBA7A99EB1,0xFEED69DD33FB0B08,0x8DE8B50E31DC2B1E,0x0000000000000057 },
    { 0xE10DC8A6054ED7A9,0x7094FC36CF39BEC8,0x487789A825848527,0x8786EAA339974124,0x47A0D6B0A6E3E5AB,0x54ED0B21E981E517,0x85CF17EAE768123B,0xD9A933B0636E78C6,0x0000000000000127 }
  },
  { /* Point #2 */
    { 0xD388E288CF34553B,0xD09B7877C6D36700,0xC3E51B059504C41B,0x0BBD1313D0EF31AB,0x455759080A3E2144,0x774BF584D4B738B8,0x3F4D85BAE9D97733,0xDFEA7F28F0E4A66B,0x0000000000000172 },
    { 0xA6B684558118AE5C,0x7A387B8B8E41C0E2,0x96193C31F2B2CD4F,0x54D8C8934C5C7414,0x397BA89F0AB2B85F,0x2AB9E8F773EEBEA5,0xF4B5ECA1E8D4C927,0x026A0B0842AC45BD,0x00000000000000AB }
  },
  { /* Point #3 */
    { 0x4B736D32DF234E4E,0x66237D17D14BED77,0x552BAA3E4DDE4942,0x947169DC23756FFC,0xE595F2646749EED0,0x2ED82E6EE3C8EC5F,0xD52DD4BC495B60A0,0xCCD7A2B340553CFC,0x00000000000001B7 },
    { 0x9DE7E73E889FBDA2,0xEB68C0D9C02A698B,0xC433363B1510C24B,0x329F6B4EE2AF686F,0x3BF95CB33CD6CBD5,0x2C9924B339E49B52,0x3A4322BB3E1AE491,0x3EFB3B85504F582E,0x0000000000000150 }
  },
  { /* Point #4 */
    { 0xA01F0A1936B984A3,0x46AD91732AE5AD96,0xBD7C413DDF12A570,0x24A748C0FBE510AE,0x27FF3748434D6671,0x96AD6F33E1D69BAA,0x4B89A84A7DAF1390,0x2E25577782E527CD,0x0000000000000129 },
    { 0x78B130D2615C0331,0xF5A9B025FA3CEF15,0x67B99DE5FEA12B29,0x5F5B07E21F56CACE,0x2AF1EE2FAEB8B26D,0x04E82314346279B3,0x0F1D88179AE70E2C,0x85F03C614C3EA88C,0x00000000000001FC }
  },
  { /* Point #5 */
    { 0x63C835437BADAA12,0x2929FBF993D1298F,0x22D8A8E5A6D3C271,0x4361A0966CC70FEA,0x4C1698920B060761,0x43B3A57B7B83B19A,0x8E4E16ED5D1E0382,0x1C4596C101FB83B1,0x00000000000000D2 },
    { 0x571E0F7A2D0878BB,0x28EFBF803BA6448B,0xC49EADD53F53EC10,0x5F67C5799B6B85B6,0x999676ED0F279676,0x62BA191B129E0870,0x5F0823B621475E41,0x8BC381ADF2C8B56B,0x0000000000000164 }
  },
  { /* Point #6 */
    { 0x86B14B1452E9A506,0x06F9F838ECD178C9,0x3D605EE53599039B,0xDD3AD5A22E3DF8F7,0xBD51AF94FDD6867F,0x707034F3D45CF3DA,0x54EDCF4A3F70A45C,0x7B6164392979902C,0x00000000000001AE },
    { 0x7D63EE2728389BCD,0x8B39BB03B8EBA714,0xFE5A3AAAA6E99D38,0xAF6074AC14A97BAF,0xA15AC327AFF2ED81,0xBA728133FE4FD2EF,0x9DB04DDAE93DB974,0xD50F26293A858D00,0x0000000000000119 }
  },
  { /* Point #7 */
    { 0xEA0D44C4E34E4C6A,0x6F50243DE8B02105,0xEDE2B16C796C212C,0x3F7169F242A087C6,0x33FA8470A4762CDC,0x05F65DB613FFC120,0x9BF29F3F4FB1C4F7,0xEF4CA47345433134,0x00000000000000F8 },
    { 0xE59DA628331968BC,0x3FBF6BC46946B696,0xEC6AB1D7F82EF2AF,0xD0423E4F260BB4A9,0x956FEF511D44CBF6,0x26F861228E5195C9,0xBE8B410C5DACA40A,0x3FAC01F29D08BDAD,0x0000000000000104 }
  },
  { /* Point #8 */
    { 0xBFECF64A8F358002,0xA9FA4A5E9179B6F0,0x8C1ECBEC5B44CF88,0xF443C158EB342A9C,0x0EEE17B6ADA473CD,0x4EB51B723AF99DF4,0xA524E6D1E0FE8DFC,0xEDC72C8EFE2A4F42,0x0000000000000073 },
    { 0x34EB386DE0CD65AF,0x387C3874CC80C3B0,0x75AC76B751883B25,0x0F6CCBFB6B514806,0xE85C5856867909E7,0x61A5BC9E5A9B263C,0x08B8491AC6228360,0x6835D3592850DBC7,0x000000000000005A }
  },
  { /* Point #9 */
    { 0xFBFA18BFA4B8ECDC,0xDB161F18FA7C7C3D,0x1EC53BAD24A21F6C,0x3E5343AAF4F6CE31,0x8AE86FCD1B669758,0x394B964B7BEFD9BE,0x84B25AF45C60A585,0x02AD7F6BA5888FFA,0x00000000000000D1 },
    { 0x0B86E101C83FB0AE,0x6E16E6E6D2B8E139,0x29425FB60333FAF0,0x8D0D9AD20CEB6480,0x9249E8D0B3E18AD7,0xAE3B935BC94D5491,0x06FE7F0744260B3A,0x1D8AF88339EC64D8,0x0000000000000158 }
  },
  { /* Point #10 */
    { 0x97330958B61D5315,0x9B1FED27813D91E0,0xFC2AAC10D0C63423,0x4A30AF61043B9728,0x0F62B5C1ED8502D8,0xD9575C7C3B16F0D1,0x03C27DB727B8C8D4,0x3244778E33BE7FAD,0x0000000000000106 },
    { 0x8537BD35641D5339,0x81BF82DDB3C40DC8,0x20172430409D603D,0xB5DA061CE2469826,0xED42F1F0959D0F5A,0x00DAD493913111F5,0x1CFDDF2BF851B239,0x9851D1E84275E8F9,0x0000000000000051 }
  },
  { /* Point #11 */
    { 0x7F7941D9888F4BFA,0xC4F99685476BC929,0x3F73018D8E853CE0,0x68A86F6134FDF8E9,0x7C88B0312A6FB200,0x3BAB6755F6911821,0x06B84C1788917FC6,0xA9F91561F5254039,0x00000000000000DB },
    { 0x76C522936DD119D8,0x6571DD2BEB1CB340,0xC66E8C823A33B42B,0xAF289EBEFC43DDFC,0x203BBA75ED2B085B,0xDB1D86048176F169,0xF762FBE0D91AFE68,0x7DD617AF2026CF1C,0x000000000000005C }
  },
  { /* Point #12 */
    { 0xF147F1A2E7E50E60,0x1309C8A5E30CAD85,0x565C5E69621ED64A,0xBE5A64757938C494,0xE56315E5D7792054,0x64855CFDD97F771C,0xE95A4B9E599E2F5D,0xEF1C8A857B06D720,0x0000000000000015 },
    { 0x2331C4282A92C2F1,0xE155A823F37E82A7,0xB47CFC2976020919,0x6131A11FFE98E8E0,0x965ADC12C0BE6BE5,0xF773D72C153CCCBD,0x10D64E59D8ED6127,0xFA7D60258B5EC467,0x0000000000000063 }
  },
  { /* Point #13 */
    { 0xFE4CD502F1B7C167,0x679FADC6DAB47F91,0x1BF2BB513037E209,0xD9EA6D92822E8A02,0x7A2A77D530CCB948,0x6FDE628029A7A46D,0x8B71CB731BD2BDC9,0xAF8D591CA3C0CA96,0x000000000000004A },
    { 0x63FCC569D852C164,0xCA7202764F07D6F0,0xA7E6E11EE7DC1581,0x325D3921440980CC,0x098BD53A148A56A4,0x4EEA0C37EBC5E005,0x89434AC1B9773A5C,0x97BD03A875CAE957,0x000000000000017E }
  },
  { /* Point #14 */
    { 0x442AFC6DDDF45A12,0x91E285345C5E6114,0x29813A938589FA9D,0xEB71194671A4AE9D,0x5DCD8ADC9044306A,0xAEDCB84BF9B52561,0xC21E290A402E75F2,0x70510BCAF6550A52,0x00000000000001D3 },
    { 0xDE9843E884F2532A,0xA14AF3A6F79D325F,0xF6906268BB1868BF,0x8AC9B2825FB4A6CA,0x6C5DEDCD4676CD53,0x149996604F339636,0xDE2A17658D7B427D,0xE8C56A66710567A7,0x00000000000001F1 }
  },
  { /* Point #15 */
    { 0xA10CDA065DC2AA4A,0x89D874E605AD6CBE,0x7D51BFD5D061DA12,0x457D656C376141D4,0x36CED50A1A715C73,0x252B0B021D27223A,0x053AEF6FE2D6E01E,0x8096C5E332716027,0x000000000000013F },
    { 0x1864A030CD3635DE,0x5AA25DA659CC5701,0x8AF63026FF2BCDD9,0xEBDB7F1717C277FF,0xF94D8299758B7979,0x38025E0009BD3EB9,0xF7C4C29E5BD5C30A,0x202201C752F90B3B,0x00000000000001D5 }
  }
 },
 { /* Table #54 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xEC9A8956F6D20ECA,0xEDA0A24D684E0169,0xA55AE258E583C40A,0xBE8C6286455D3CE1,0x05BF63132096AE62,0xF68E024920B48BDE,0x1B6595BC4D99CD14,0x0E740830774958BE,0x0000000000000030 },
    { 0x3241B0DF9FD73274,0x7B6532398FE5A5DD,0x2D4DD56E38412A8D,0xE2925F33CC58A62A,0xB859EA32F5CEE12B,0x5AF7C4027C25D1D2,0xE172CEC16F196E55,0x34815491DE00641C,0x000000000000010B }
  },
  { /* Point #2 */
    { 0x0869ED35FA226AEA,0xCBC7BD56645F4485,0x611101B13E6C3D97,0xA1550183F7A56F83,0xBE209B3C80A6FCD4,0x0E2C9DA9EA3BEAFF,0x0FC7A16F14D9F7CE,0xEB8A5E147A1E6DB1,0x0000000000000047 },
    { 0x55A78C253B0FB32C,0x449A7852A430D4C9,0x1383A88A412509F0,0xE895D858329AF78D,0x14AFC01CF8D65A07,0x89303BC5193D67E3,0x42B20C9716FBCDF5,0x79FE69660EE012AA,0x00000000000000D9 }
  },
  { /* Point #3 */
    { 0x80CA977C4E7E98F2,0x0A0BD3D8CD7A9AE3,0x122C33DA8EE369BA,0x340A8462DFE25A99,0x79FF5C18CBDBC904,0x0BC05B6CF1818B44,0xFE9F3C6577E9157E,0xCA1717C7A1064D23,0x0000000000000051 },
    { 0xCE8ECCB86A365B28,0x6208E87273819001,0xC774AB6F015365FC,0x223392239F9D80BC,0x1C00866452E59382,0x28D7846BEB747619,0x44AFB84456F1B541,0x161BD257CE7504C4,0x000000000000013B }
  },
  { /* Point #4 */
    { 0x7480912F507CE79E,0xF2251DA23A1EA21F,0xB925AADBFBC957F9,0x79A66979F4548E12,0x9200714B6DE9A9FE,0x779792BBEE62D344,0xEED3D08357501CCC,0x51ECEC8B0EF8C948,0x000000000000014C },
    { 0x734A634B05271E42,0x70E28C86643CDB88,0x849FC7DD0C24A7EE,0xCEC60426B20506A4,0x6EE05FCE35655C14,0x79CA2BE8C072D950,0x6C473203105C09EF,0xD9698B133DBF27B2,0x0000000000000010 }
  },
  { /* Point #5 */
    { 0x8A8100586E98D8D9,0xF61EB17AD4B641C6,0xAF5FF28048D88066,0xB74D5092525A6863,0x41F2166E90D44C03,0x40CFB825AC397C83,0x873F9A6067F050F0,0x5F7A12A33B290DD7,0x0000000000000170 },
    { 0xC4E73DE84CE77C04,0xD9EDE081D20DA7E5,0x049A706F61C3E3B1,0x2F9EB2CE1180CAB8,0x04128D8AF1041068,0x0D480B128542062E,0x1ACB604F2EA578E1,0x636A4F2DA2A8E97B,0x00000000000001A0 }
  },
  { /* Point #6 */
    { 0x15079B9D3A7DE86E,0x97E07C04354FAF62,0x045F48F34280E300,0x9A5FD235BD9EA013,0x3F75A31F8760C3D8,0x18AEC5FFD05D488F,0xCCFB484B617DAF6E,0xF33084DEBFFAB914,0x000000000000015E },
    { 0x1C034F37DD5BC9B0,0x8E2BEDAF882C69A5,0x6789F307A61AFC24,0x8540D05DC57B651C,0x7214914319F83EA8,0x57AF134D962C6ED0,0xCD059751D98B1089,0x08AD5D1D42E7077A,0x00000000000000DB }
  },
  { /* Point #7 */
    { 0x4AA444350D46AD1F,0x3E30D95266460711,0x49A9ABF1859419F8,0x7580495054D20A3E,0x1FC9C16CEC3E54EA,0xA40B0D69407F5314,0x973293970C5ABFA3,0xA5128890CE6D2457,0x000000000000010D },
    { 0xD6BF196232452B45,0x9FD7A4486DE3A847,0x3E4CDF085ED5C47E,0x29A693012364C81E,0x942DE3E8AC3E4BDD,0xDAFFF8DC6076A4DE,0x2AF8321177829D01,0x5D3D43691F3358DF,0x0000000000000015 }
  },
  { /* Point #8 */
    { 0x163CD52464D8C387,0x0CFE9416CB029390,0xCE6B5DAB9E9EC846,0x96A78639E9BA4592,0xA78E42968F174287,0xE5D09A7637763D66,0x9F47ACF6B54F368D,0x8E63481B6A0FA894,0x0000000000000026 },
    { 0xE1663CA805C8BAB5,0x99BF02AACA0AF033,0xFB1C0C7FAA1D7C42,0x05AC75B011BDCC7D,0xBFA1DC7399D86019,0x8F11D0A4937CFA73,0xF4795BD7D24E356D,0x7C1F3DC478B4E4FF,0x000000000000014C }
  },
  { /* Point #9 */
    { 0xE31D208E0043E22A,0x47862D4E1DB48D74,0x3BC86E99279B4F8D,0xB74345E7FC3AB597,0x0957320FD0D86BE7,0xDFAC850702F3862A,0x402A49A776D03825,0x736F0E04493E7D8B,0x0000000000000172 },
    { 0x1F6862A84680D6DE,0xBC31087346A27EED,0xD6694888A16D4660,0x75F91BC3931F0F65,0x04EC7B58686EBF65,0xF80D6FC3C3FCA400,0x7E0DD84C262CB38E,0xF41EA7DF8F222FB9,0x00000000000001AF }
  },
  { /* Point #10 */
    { 0x3DFEEF486FD25746,0x5940ADD47D758BD3,0x9F08C453D26DE538,0xBC7DD28B040D20E4,0x92CEBD97AAB4420F,0x79F4BB203337466E,0xA72FAE2ECB132A17,0xB394A9C29A59E4C7,0x00000000000001F8 },
    { 0x6146396EB48C979C,0x24B453DB99A310E3,0x7E3917A871967C56,0x3BE40E190E539ED0,0xC357BAC87206739F,0x8F8C1D8229B17828,0x06F0EA1F949DB344,0x922DAA8467EA4CE3,0x000000000000013B }
  },
  { /* Point #11 */
    { 0xAC180DC44A46138B,0xEC88269B7156CBE4,0x5FEA4E6E456688C1,0x11B90FB8AD2A8B83,0x5B087A3397CEAE59,0x1F5AE4004E5E4FDB,0xF5303955AF394C93,0xAD329CCA5EDC79EE,0x000000000000015D },
    { 0xB8CEEF2D257AE3FB,0x32DC201F90F39767,0x45114BEC49D8B173,0x729EA6CEE99E6516,0x3307D11CCECDB32E,0xC30F1BC2A83848B1,0x22873D0CDB265ACB,0xE816F4A4CCB90FFC,0x00000000000000A9 }
  },
  { /* Point #12 */
    { 0xE2473FE401D47863,0xDF01581BA1940FFC,0xA35005EF71F1311B,0x647D568CA5EB4E66,0xF1DFE4475DA1C32B,0x05D5C8B5BA555B7B,0x2584842719302166,0x5BAE9FDF71DCFA1A,0x0000000000000184 },
    { 0x531661B422BC00EA,0x3DB39E0CE55A5757,0x1CDAC297FCA4FBFC,0x1DD0012BB1D24A8F,0x52AE5759714BC921,0x016AEA1FE8481E89,0xF34842D1254D5D7E,0xEB75AC8AF21FE811,0x00000000000000F0 }
  },
  { /* Point #13 */
    { 0x1BCCCC5FB176719C,0x581464AD9C78FEE2,0x81EE8C3529C1F187,0x751D08ADBD76A8DA,0xA6D9557518F1E8CA,0xAF1B4D6EFAC80570,0x1EC245C07EF47FBB,0x27D20F06FED120FB,0x00000000000001BA },
    { 0x6A34E57EBA257F4B,0xD3B7E492D4E31FAC,0x0F1873B7AFA245B4,0xEE08DC4959453554,0xE51FAB0BEFC6CC7A,0x913E414EB29CD7F0,0xCFA27845AF773928,0xCDC157740C259DD8,0x000000000000018E }
  },
  { /* Point #14 */
    { 0x27A66DD1E4C74B72,0x9942ADA0C51B39C7,0xAA53C8461A3166BD,0xC987EFB7B9D48025,0x991F01BD361C98D0,0x5BFB025E3B09F9E1,0xAB478EB54514704B,0x784F1A8DE0C6DD62,0x0000000000000031 },
    { 0x42757F2CC630DFE5,0xEAD6FB443F3E6723,0xE8128BBE1A1C8B83,0xE35A9D2FAB681466,0xBF9BE668356C2595,0x0E3CF40F99E2B833,0xFEE57F088EA10A4B,0x207DA69ED45302C9,0x000000000000017B }
  },
  { /* Point #15 */
    { 0x232851324150918F,0x855B7B3541CDF564,0x35FEF624F0637183,0xB49D6851DEF871EF,0x94F2C39F80366D0C,0x221FCE35F0DC00A0,0xB4AF81F82249779B,0xF00275A819984EE4,0x0000000000000036 },
    { 0x3CF7B1A790C8D67B,0x4B86CF9725B36499,0x69A209D66AD68698,0x92E7442BF9E23536,0xFD2A386A5FBCBB9D,0x392CDD75F5F29B8E,0x265CC96CC318F122,0xB6CBCF9CC72DED64,0x0000000000000012 }
  }
 },
 { /* Table #55 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x36CDC3E624ACB1FA,0xF593D32D6C6D43AD,0x766C2FCD373C8E18,0x0A1518363D12B7F3,0x924427F4B4234A24,0xAAB877852335FF44,0x9E5811897C362011,0xD86F8FBA5EE724DB,0x0000000000000184 },
    { 0x25F04ED9C9558569,0x0A315324EF9562C5,0x65A02A289CCEFB92,0xB2429DD488115608,0xC1714C93641D646B,0xBA4D369148BB144A,0x48EC2D9D9EFA3A6F,0x5FF6A4FBF1A93AE3,0x00000000000001ED }
  },
  { /* Point #2 */
    { 0x8661728EB584AF4E,0x954BB8753A25E264,0xC839860915BE119D,0x06A54D7F989FB866,0x27B590EDE0375BC8,0xC394A6B7AFBF60DD,0x32CB71643A892981,0x61B46241CAE4336A,0x00000000000000D3 },
    { 0xA2E80EED970AF48D,0x087C2E6320F95E36,0x82956A6EEE080071,0x933A2568F9FC2967,0xAA2B21A31B5430B1,0xB1EFDF09B6502FA8,0x56B2B8B50A897789,0x3A6F9FDA663DC2EA,0x00000000000001E4 }
  },
  { /* Point #3 */
    { 0x8B2F31A02C825D50,0x5FA4A38E0B3DD67A,0xCC07EAFEDD220E0F,0x3A8496F853666CD5,0xF1E8B23E116DA23E,0xF48DE9F41631080D,0xCC3274454139C8DB,0x3270CE0A1DBE7C3D,0x00000000000001C6 },
    { 0x210895785054F6B3,0x8295EC2DD94BF609,0x1922BDBA854941F4,0xA95EB4DE357020E9,0xD15FE663DF0D7747,0x89CA6DB1FF86B9CE,0xC3BBAADC4F1A6D6D,0xDEAB3F658A0C471E,0x00000000000001BC }
  },
  { /* Point #4 */
    { 0x1874803FD759F021,0xE16E4F43F7CCDC14,0x33B15C686CA96E4A,0x16647507C0C8F6A5,0x0A69A27B0DDC1A2B,0xEFA1D7D28C4496EB,0x8BD873D347064396,0x13B07FA653DD5370,0x0000000000000008 },
    { 0x97373827DBF8A088,0x0F48A5DFDCD37018,0xF3BC5022172E6D9C,0x96A0D7020867BC4E,0x26130628D1A46E33,0xBA6C1F6A8C2BDDA5,0x273F3F4D4E5E6112,0xC9F3341ECF810455,0x0000000000000084 }
  },
  { /* Point #5 */
    { 0x677450828F3756C2,0xABF1E75D0A7BFCC9,0x047931DBB8BAD3AF,0xA380C9855E392278,0x5195E47D0237D6BC,0x8C7EF452FEE7427C,0x4F078DD2585B6365,0x4E82EB4B1E10D24E,0x00000000000000D8 },
    { 0xDA54DC52610B349B,0x96746E43904633F2,0xD2A58F332C50AA46,0xFFEA4D06987F9FC3,0x5505265ACC521553,0xAF2B7DA0C316DF83,0xA74F09B1EA362ECB,0xCF9F0AC3A2E1F4F5,0x0000000000000078 }
  },
  { /* Point #6 */
    { 0xCE7AE0B6075676DF,0x24DAA3AA29BE05BE,0x795B32D17B2F292F,0xF71DBF4F77AE64FE,0xE5F8B83BDCCA4F00,0x111A06DB71E2E120,0x6E7937F5A861E714,0x7B14D15817BF3BE6,0x00000000000000E6 },
    { 0xA8748D319D04DAAC,0x28E3FDAC9325722B,0x4384AC259E26FC1C,0xCBCE8C3320F8D023,0xA21E8ABB9FED4B2F,0x5F1D2DFCA075F969,0x43D3C57F5E8E705B,0xCAC9948FDEB0BCA3,0x00000000000000A4 }
  },
  { /* Point #7 */
    { 0x17100A613BB93EAF,0x7CCB5BF3D80AC200,0x585D17B6EAB320C3,0x8D53EFF1E7258F8D,0x9D671EE13F21F78A,0x76E7AB703DC4AD54,0x9EF2272419B3FFC7,0x67B54B1FAFD5A3CA,0x0000000000000122 },
    { 0x629DFAFB33A86EDF,0x237E33D97E4AE084,0xE1D102344CA49A1A,0x768D5901B6E2E180,0xFEBBD9DAD2EC4AD3,0x90AB63EBA9E332DC,0x5E2636C78DA3786B,0xCBABB3FAD3F6FF9F,0x0000000000000190 }
  },
  { /* Point #8 */
    { 0xCF8E03C512A09898,0x2090118438287AF8,0x8FD47E85371620A2,0x5A2B2EC87F16350A,0x45841B1C608C7488,0x627C632E01739426,0x3CB05AA78F8E8224,0xBE277FD79B643A85,0x00000000000001FE },
    { 0x950843E61538CB4D,0xE88383994F7AE0E6,0x6B90AC85D2E1D225,0x78C211321E5361B4,0xCE09F24034B950FF,0x3884016974B71400,0x58AE40A665E2BBAF,0x5D370978C823B954,0x000000000000017C }
  },
  { /* Point #9 */
    { 0x49C6886CDA03CB43,0xAF81240A631AEC16,0x15EFF9A996D20F3D,0xAAF0A5D2FA2379BF,0xCC91DE9CB279FF95,0x27D37BD6A453592C,0x8AF89B816D10FA0A,0xEA7C3D1CBCC25388,0x000000000000015F },
    { 0xDD9B3067213887CA,0x92DC7756C61E7CD6,0xF63490C086B3D4B1,0xA1351C984778834D,0xA7141AE6B6DFA602,0x20C4FF83CDF11CAA,0x17DEEA876FA13194,0xF1286846F9B356F4,0x00000000000001B8 }
  },
  { /* Point #10 */
    { 0xE40AFDAAFF53EE70,0x35B6D8B51FD3A073,0x92EC4BE9BA518903,0x0C95CD41B6F47C4D,0x6B921B17DD0E5ED9,0x718C86854BBC19FA,0x746B4341AD0ECDED,0x338C0265C2BC04C2,0x00000000000000B5 },
    { 0x00D52FD6A2B520E4,0x26C7A2526C814966,0x505DE29D13086BBE,0x72A313EBDD86B988,0xE8CB45F3B1D0FDEA,0x8D01B6C435132FD9,0x86BA2DFC32F0205A,0x4B5337B8633627E5,0x0000000000000007 }
  },
  { /* Point #11 */
    { 0xD468652EDFA2506B,0x9378773A8AB9749F,0x7A884B6F76E78929,0xF27C392185D87414,0x0EAF6752BB0F8D83,0xA4F32AC1ABA733CC,0x9101179C5909A3A7,0x1866FEEA1C8A4D03,0x000000000000011E },
    { 0x05A92EEC6C3C0A65,0xBE407A0E975953C4,0x2CA88431B392DBAF,0xA850EACEEF45D2C1,0x9F20AF9D522C5D9E,0x1087A41C10A81FAD,0xD00C30259C1C6423,0x247BB309C9D576C8,0x00000000000000DC }
  },
  { /* Point #12 */
    { 0x9A5B562C81E5767B,0x82A252CF493D1DC3,0xCCAB739C348312D0,0x4A3D3BF1CABA28BE,0x2179A25512D422B0,0x6A3C22BDC5E05253,0x364239CB22516D83,0x0C2D36EA7563C8FE,0x0000000000000193 },
    { 0xE08E1EEB5CF7941C,0xD0A3FFC4DF6D0E1F,0x34E5EAC6A75965BB,0x51112B40296890CC,0xB8F53841561F94DB,0x4FE4E52084199883,0x85BF45EE4DC0FD2F,0xC9C3B76878515C47,0x0000000000000130 }
  },
  { /* Point #13 */
    { 0xADE6F5897D504A33,0x28BB830D77515969,0x6EE92747A70C1A3C,0xCCF8AAA71A37553A,0x908C54A0F7EEED39,0x122660AC6AC78002,0xD6C961741CF08785,0xFA0E5A5FE999678E,0x0000000000000061 },
    { 0xC7A7FCC65A59CB95,0x24DD05D57D17E7CF,0x18C6C398D7B40D6E,0x3381A0D2900AE9EB,0xFBE294CC1CD20CD5,0x76876C8CAEF1E1A3,0xBFB25F7087A539BB,0x794EB14C7E1B9AAE,0x0000000000000022 }
  },
  { /* Point #14 */
    { 0x8E352C1D34E78E59,0xF99A6A9A748AAEA5,0xAEFD847C8257160C,0x01758F2A3C63B2F7,0x9960A6558C905682,0xCAA422C6C320D799,0xDF15604D34FFC0F2,0xF608C476DED1F6EA,0x0000000000000153 },
    { 0x534F6F97D9581919,0xD3740FEF745A7694,0x4D52965CD80E748F,0x4852EEE79EDE40B5,0x28A70CA100A86751,0xE0988AE958C5DBF3,0xFBC8BE29C975D591,0x8C2EB67C43E78BC6,0x0000000000000199 }
  },
  { /* Point #15 */
    { 0x86000CDFF2C104E7,0x26231065172B52B0,0x8196AB2D02058B05,0x17E40ACA28C29576,0xB28F21CBBC91AA6E,0xD0769EE782096967,0x52CEFDF72DF6354A,0xF5FA182EF13CA06D,0x00000000000001DD },
    { 0x6B09768B29EF4065,0xD763CF37C7C7827F,0x27F8E1DE95D9DD90,0xA771BD3BCBBFC5F5,0xF4AC71CECE052D7F,0x61A89C45198DB3C3,0xA98419EEF2EC89A4,0x60DC319FB3285905,0x00000000000000FF }
  }
 },
 { /* Table #56 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x7DDF47051733B3C3,0x7C7878A3F4A25D85,0x4D86F57C29AD09A6,0xA97D4AB6B26D5C69,0x71CC925004B07913,0x08A84131B4C0B7B2,0x388FC8AA5119F83E,0x23A3BD0B6BFDA0CB,0x000000000000007E },
    { 0xDFC7C8448E549373,0x439DC785B52AD215,0x9E157E18FB9DE6DC,0x9283C3318793D562,0x79F9EC9033DDC16C,0xED0DBB7FCEFF5086,0xFA4668078765145E,0xBA9411A9A3B387B7,0x0000000000000176 }
  },
  { /* Point #2 */
    { 0x319885D110E10587,0x2DA8979A609853A4,0xFE907FE389B08EF5,0xA3A338A61A97D9DC,0xA5AD1A9AD7E3FB92,0x77A3BFC07A0136E3,0x99634588AA6ED29A,0x41F148BEEF4787B6,0x00000000000000DC },
    { 0xB8671195EBF698BD,0x323B6965E2974EE2,0x1411C67084C20702,0x840B396EBA4BC1ED,0xD857A525EECFF9A6,0x0AFAD4F4D2D6829B,0x84EF6315BF6CE02C,0xC38FE857CCC6B333,0x000000000000001B }
  },
  { /* Point #3 */
    { 0x2D9BA7E36F07EEF9,0x46EF4CE6EB692362,0xA869EE262FA2CDC9,0x5B7D3A81642A2378,0xC024410AD4D6BCD4,0x88CC0F7121CEAFEF,0xEEE011EBE04AF152,0x9CF87D1D7829107F,0x000000000000002E },
    { 0x49260571E07147B1,0x632583460CA0C303,0xF1CDA5AE6602E056,0x418B618681A45861,0xCBF17FCDD1921FA5,0x355E5D1AE07A08F1,0x3F4F5BB0A26B6B2F,0x898CA884ADE69B50,0x000000000000008F }
  },
  { /* Point #4 */
    { 0x1A00FC111C417FAD,0x8816DD0B3FBA7366,0xB3A5499232C0E5A9,0xB6A634789EC0FA14,0x880B10B8A8D8615E,0xE3635BB83ABBE5FB,0x62A209F64DE9BE52,0xAC41CCE182B76CF9,0x00000000000001C5 },
    { 0x287C7BC77DD1E73F,0x072BB2AC1F8C7D2C,0x399011FB3AF5565C,0x787B94845E2A7E13,0x5858C3DF5761AE9C,0xF0F831AE6D2875DA,0xD5F5BF2DAE9C82F1,0x191B45FBB247A36E,0x00000000000001DD }
  },
  { /* Point #5 */
    { 0x1D2D4AB0FE772021,0xD6E75054041053D5,0xDB480D2E5705D868,0xF68A09F76AA63E89,0x0BCF4C31379A4D0C,0xCBC0C737B681873C,0xDB6931A6B886D407,0x0FBAA44BF84E033D,0x0000000000000056 },
    { 0x5339B4F34F90A0FC,0x2743F6818EBC0B28,0x37567E5BF7DB2715,0xF339C91AA5B1053A,0xDE65F7188125EBFB,0x32F7C06D6BF4ED15,0x8071D1AA40353DCF,0xB8FDDDD93C994068,0x0000000000000198 }
  },
  { /* Point #6 */
    { 0x1C081356B6965640,0x7A01B38990C7A0F0,0xF72FDBA4874007EE,0x6BD85D94DCDDEFA2,0x80FBDE7E48DB2FA6,0x60B2BE1C4A319DAD,0x996217FBEE51FB71,0x85F1B13BE0EDB983,0x000000000000012B },
    { 0xDF53AA14ECFB1D0D,0xDD77FC37760A217C,0x659BF31E99B56FBD,0xD0F042EBACA3E106,0x50C215BA1F907EA8,0xC6BB892CA4EF5F48,0xC3BEB73BFEB86870,0x04B740BD4123F812,0x000000000000007C }
  },
  { /* Point #7 */
    { 0xD50C9FCF6016E8F8,0x27F12C32B8C12F9A,0x2E13FD2B08E0E13C,0xE48A1BCE89E659EF,0x1BBE7F01F62A49D6,0x87E0CA4FD417E497,0x1CF55A48364EE9CF,0xF4FBC7EAF66635A7,0x00000000000001A6 },
    { 0xBE3E55113EB12A0B,0xAFFCAD4B462EBDCD,0xF6F097ACE8F4D182,0xDB1FE0F2404A92FE,0x9E2A51594FC084EB,0x6ACD3A8E7AF882B2,0x17654A579602FC6B,0x1307D12271DE39CF,0x00000000000000DE }
  },
  { /* Point #8 */
    { 0x470BFDD42540E5C8,0xC2C849A1057592EC,0xD8F4B30D2F886637,0xCE56D15025BA43E0,0xCACA4A05F200D2FB,0x38FDFB3595D80545,0xE274649F22418951,0x155BADB2CB7437BE,0x00000000000000A4 },
    { 0x09195792C828A666,0x3CEAF45353F59336,0x3982E19643850A1D,0x02F8077DF2D2AFBD,0x83197E1E6A6946FA,0xF158B0B4C4FFAD53,0x12559573853B51DA,0x8838409E8D35C9DE,0x000000000000019C }
  },
  { /* Point #9 */
    { 0xA844A48F37315BA1,0x2DB10DF96F401D40,0xB092031359508B56,0x4CCD40A51DF7356B,0xF6E6DE667CBA0994,0x8D052D22AFF1E407,0x6579F0AEE1AD5185,0x02A2654C2FE56FF9,0x0000000000000107 },
    { 0xFBE7245FC52E3A9A,0x5CF1F315767802EA,0xD1BC98865CFA064B,0x6FE2E272218C2D74,0xFBC0F239E105D3C2,0xE93040F86C2D5D8D,0x3564207844F0C1DD,0x526CAFB534A20E65,0x000000000000007B }
  },
  { /* Point #10 */
    { 0xA403B2CD3E0BF039,0x1F331CD769AE1607,0x5808812D9341E113,0x3BDC37F4ACAEF9C4,0xEEF79000A056CCF7,0x6E36E89079F26A8E,0x225A7216A5A165FF,0xB0F49EEA4A8D4E72,0x00000000000000C7 },
    { 0x7DF03CD678EAF6EB,0x4E96FCFC7A3EF5E3,0xB4578857FD3BFA43,0xAF079521906C3961,0xA8E06DEA1227FC18,0xF0F06E6808BE24BB,0x0AF15713B84B3FA1,0x6BB9BA45D30F7AAC,0x0000000000000111 }
  },
  { /* Point #11 */
    { 0x7055735E2734BC7C,0xDBBB0D7F2015DAFF,0xDE7F735AD048C6F7,0x1401C4FE3D025035,0x3017088AF09B1518,0x53BEAA128C919403,0xE623FF8D6E6F4894,0x1622621FA6C45B25,0x00000000000001A6 },
    { 0x3AACBD8120E1FD32,0x21963A49F0C52D67,0xB521F29DDA79F988,0x5CA6538AB632A340,0xFECCB403A1C38793,0x800A81E46C1993A7,0xBFE7989E08775F1F,0xA7C0BB935F6056CB,0x000000000000007B }
  },
  { /* Point #12 */
    { 0xBA1F3D04E155A234,0x83285CB7A2F5D3AF,0x120231908196DA46,0xC05F48389399A9B8,0xE1604051A097E0C1,0x3C48963B8F3CB46A,0x7EE7DEBEBC20857A,0x74C375ED8EF449DD,0x0000000000000148 },
    { 0x6086F7E549A22D3B,0xCF65FAA71FF513F7,0xE5F24AE161C6DB58,0x085CDC7708664D9A,0x8E2385AB1DF20E4C,0x58910A818006CD4A,0x1858BC67C143E34C,0xF88A9CA118F7D8EB,0x000000000000000B }
  },
  { /* Point #13 */
    { 0xAC6ED780D8DC7694,0x1517DB0F7F0CE3C9,0x14E574EFE2724276,0x06BF1C0AD420A1B9,0x092FCDC0ECB5BB09,0x00B1952DB3C22E3F,0x8486050D66DFEF5C,0x4162BAF5B4AA2363,0x0000000000000035 },
    { 0x5F188EF1CCD62E93,0x357224C0A78FC426,0x6A38A6A0F311D595,0x632D3B1D9363D024,0xDA7EDB5AEFD29098,0x1AE7E00046198910,0xD299EA6C8637F141,0xA33A21D96DCE1F27,0x0000000000000191 }
  },
  { /* Point #14 */
    { 0x33B557A9EDCBF5E2,0x8D42C77F4FB31E95,0x3F006DCE258E5A7E,0x07AB56329DC0F10D,0x6A79F1D388012825,0xBBC9F71D997F67E9,0x733AEE4FB0484D0C,0x0D7D26AF06B23588,0x000000000000007E },
    { 0xAE584763447D2B4B,0xE3C380900ABE0533,0x19DC9A0946A66DEB,0xC5E21596F7351889,0x67EFB3732E9062B0,0x38C539278DEF3D27,0x8F2AFE546EC1F561,0xA80F0C62159002BA,0x000000000000007A }
  },
  { /* Point #15 */
    { 0x0574B1C11FE4B65F,0x564BC4EB99FC3470,0x040CF7E88AD913EA,0x72F64FDE21E6DC7A,0xF061A2F945E43F1E,0xB30D7ACE4CF73CD7,0x4E67338FED5303F8,0xD1CA92F827FB18B4,0x0000000000000123 },
    { 0xEC92FF11B2FF61B9,0xA1196425DD3BD645,0xEAB1A0B3FFC4A720,0xBB01E20DCDE12819,0x222FCA782F6F9062,0x5343239FBF735E40,0x8E4C78EE7A1EFA11,0xBB68361CACEE5111,0x000000000000009B }
  }
 },
 { /* Table #57 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBCE0F1074175E7E0,0x51AC63D71965464D,0x429F6B9F52AAA9EB,0x6ED3C53B2A1846D7,0xFA87D5876DCDA98A,0x9858C801C72D6D0A,0x94A5BCF367681451,0xB7C46ECDD3DE0285,0x0000000000000183 },
    { 0xFD301B76D2DFD89C,0xAC9C2B0D0F38E6C1,0xCF9D3ACF2DA8E6D4,0x99DB13DCEB9024C5,0x4EBFC5BA9EE659A9,0xBDED80949B2FA547,0xFCF035F9C08D98C5,0xB50DD13656B8B217,0x000000000000014D }
  },
  { /* Point #2 */
    { 0xA198D04B1B9ED16A,0x2244536251340438,0x77078E91251DECA8,0x1D7B7BE1BE67E98E,0x106648BE2CC726D4,0x79DD8D7BF5877E13,0x42BBD30E37993843,0xE768F54DCA7796C9,0x0000000000000078 },
    { 0x91C5E19D1ACDF2FD,0x0A2EFF89E93C20D4,0x6A84E609CE41AC1A,0x186AB6E8DF08373C,0x44C2AEF6F6F9ABC1,0x9C7070B0DD735102,0x0E58B51807643871,0xBC9F2E800B15D805,0x00000000000001EC }
  },
  { /* Point #3 */
    { 0xE83DFBFB6987A9BC,0x311372DFE03B29B7,0x1B88AD50F4176BDC,0x5771946F37733CF5,0x4A020165D5C0CD18,0xB8E35A40C7603086,0x3D06B8D0DB55F57E,0x9CDB00CAB17B440A,0x00000000000000FB },
    { 0x840EC34134BD8619,0x40B0C10700AB86C3,0xF478205885C69C9F,0x22E8D92E10D63734,0x5B8E637420A53CDF,0xE80C3D14FEC8A052,0xB9C0834EEDE62895,0xB2AE0EB3DE2EF959,0x00000000000001AA }
  },
  { /* Point #4 */
    { 0x4B67FB4118D0A514,0x0A9FDB8E32AE28F3,0x786B00F8C238EBB0,0xF73D53D11CBB7EA0,0xE3928456988A4366,0xA108E52A1D62FCEB,0xB923F2471D9484F2,0x9C8DFC0CAF781F08,0x000000000000012D },
    { 0x6485C32F15C72D41,0xF7EF7E581A01F229,0x2DCA15D289C87F68,0x91A22920D86C6968,0x6015A068FE0747CF,0x429C4D4DD744A2CB,0xD707E9EA43D3B8A7,0xA03AA304040ED223,0x0000000000000107 }
  },
  { /* Point #5 */
    { 0x0691B415718BE467,0xBBFF71495722BF66,0xB544609488474C74,0x30609081BE02C6E2,0x746F70005052D780,0xCBF590A9EE805F64,0x9A7B080CDD7BD5E7,0x56B717BDDD80A8C7,0x00000000000000EE },
    { 0x64274157AC340691,0x9B309A8F804BE8D1,0xCE5420F1121AE0F1,0xADF456A85EC8A509,0x5E76792AC02EA242,0x8388B323E58AF730,0x72DB99B73136780B,0x1A3E920514E39CDD,0x0000000000000125 }
  },
  { /* Point #6 */
    { 0x2D803479571D6BFB,0x7BB434EA5D939FEF,0xE8DBEBB2A7F03A6F,0xF871AA25FAA1C258,0x009C479C127B3064,0x2EC9495BD66A8BE4,0x7D41DDC11599C1B6,0x1DB2468F618812FA,0x0000000000000103 },
    { 0xD31446B47EFC6A9A,0xC35B7886A8F41DDD,0xD8087EDE106280BD,0x9089563B4ECCD522,0x8C0E5198F6E94E3C,0x955B0E324A8969FB,0xBA5786073A83BD9A,0x22B3437D8BC92EC0,0x000000000000015F }
  },
  { /* Point #7 */
    { 0xDD0E59A1ED446A1B,0xA92EB8825307EF75,0xA85D2C29E13EF1A0,0xE558C1ACFD55AF75,0x60C45ACE3E133B0B,0x4F08A43E0F7DA3D0,0x0298BE5D028495DD,0x894E253B58FEEB24,0x0000000000000105 },
    { 0xFA9524D3A37DDD3C,0x8158B85C9DE4FBD7,0x0D5E4EE60D22ADF8,0x9547F86171FF6639,0x457FB0DEA01712BE,0xECDF193B997116D1,0xF74312BC76F06573,0x74FEED35E990A692,0x0000000000000186 }
  },
  { /* Point #8 */
    { 0xA9338E3D41B1CB9E,0xE9173C96C409BE61,0x2B8EA989BA7EA91E,0x5AD99388870EDD75,0x9D3C5A11C2112DAF,0x5A7C3D52851694A8,0x8ECC1D6DFCE31234,0x2ACA74EF790D720B,0x000000000000002C },
    { 0x66DC50EE20DF1F66,0xE8785C5B3B05EA85,0x0E28D55E569D94C6,0xACD3C1651A119F91,0x51910B8E7226E29D,0x849B5229DC3EADB4,0xC8C44E85A88F3B08,0x990504945E42BC66,0x000000000000019B }
  },
  { /* Point #9 */
    { 0x078D1AD67F9E71D9,0xECB551C2852895D1,0x5F1E2520D687B477,0xC19D6353457A77C5,0x7FB6A771ADCB06D5,0x29251295E4B2E297,0x71561F60E982C9C3,0x258B0FEEFCB514C5,0x0000000000000179 },
    { 0xDC337F17D4DE7F3D,0xD5EEAD5A8CA78841,0xE22BF810AF4DE8EA,0x7064A8FA3771C38E,0x7FF10AC826BB6EE5,0x908646C1C904508A,0xBCAEDC457F6DBBE2,0x33293382E86DB3BF,0x00000000000001D8 }
  },
  { /* Point #10 */
    { 0x55FDC7C38AEA0D52,0x2179D8DD816C4083,0xB314BB66E60B1AFD,0x4B54F9E1F1D3694E,0x6F2520795DAD68F8,0xD8F5B2B028D63035,0xFDFF1376562AB56A,0xA0CD4EE687C36682,0x00000000000001CD },
    { 0x0373B45C1EB10660,0xAC26523CAC97E870,0x5528B829BEA0C89B,0x4752340FD7B97127,0x33FEE6FD04DC5741,0x6C4D4465A8C1F7A6,0x6646500BA676E6C5,0xAADD9E548BF72FA7,0x00000000000001C9 }
  },
  { /* Point #11 */
    { 0x110349462CDC9B50,0x67E6BF5862DC4EF5,0x9E9DDF8BF6E38FA0,0x54EB8B69A416175D,0x072EF5A88E347A29,0x73937BA67BD889B1,0x668C11D6C8C7038A,0x7D5C4BB7C0F3A3B2,0x0000000000000042 },
    { 0xB414D8AE26696C3F,0x268CC5F782EB9EE4,0xB8992111389570F2,0xCA37C13F3C9EF0C7,0xA86E51316CF3BE04,0xF7E0DACDDEBE2E4D,0xAB04EBEBF60BAA9A,0xA0FBE1750EBECA18,0x0000000000000197 }
  },
  { /* Point #12 */
    { 0x6FCB043DD68FB025,0x0839E8B6E0528597,0xA7252AC9A89EB21E,0x16A374BA41E8F8A1,0x5CED142B40ED5415,0xC7176B44283746F3,0x4729ABC788FA6D9E,0x49948E66222734B0,0x00000000000001A2 },
    { 0x888AD6F7973F55BC,0x1E24F8FDB77C678A,0xD0AD4C2F1C25138B,0x19D112538E52859A,0x2B13EBB94B2EE4FA,0x019CC6D211DE7F2A,0x5128862215096A9E,0xC8BC78E506643183,0x00000000000001BD }
  },
  { /* Point #13 */
    { 0x2D5303228FC86DDB,0x05AB8E8CC6CE68A2,0x3BB25B18C2BAF433,0x5CE241455AB76FFB,0xBB4F95AF4B24B77E,0x06B0D172451B0C0E,0xED3E64C1EF058F82,0x2FAC77E0737295D3,0x00000000000000A6 },
    { 0xAFEB533ABB21DDA8,0xC116B648D42C427E,0x5D02B6489442BB65,0x55CB7ACB22C2D6A7,0x31427A5CFAADDE8D,0x56C2EBA1557B3840,0x578892D7E4F0353F,0x37813DA4F6C6055B,0x00000000000000D7 }
  },
  { /* Point #14 */
    { 0xFAEDC26B0B4B6535,0x2A7EA1C4CC00D1B8,0xA419B6701546C16A,0x896D128BE7FB3E44,0xB3B851256C913E23,0x88926F8C574C0C78,0xD8624A1980ADF829,0x0F41618A8A54A6CA,0x00000000000001C6 },
    { 0x7B26C1A242562882,0x2C71C8BB77582849,0x840B7EC640B0F186,0xFC1CDA5EC6B4824D,0x5D1FE3AB81481696,0x6AB2146499578784,0xE06365C2D05912C6,0x2A37860D335FEC73,0x0000000000000091 }
  },
  { /* Point #15 */
    { 0x0748D64B709EACCC,0x233A0CA99554FCAD,0xA00E09E430FEA281,0xDB39EF4F16D59F0F,0x2C80B5472633C3B6,0x97179ACC3A418480,0x85F1C624AA29CDD5,0xB48B5AE24819B5A3,0x000000000000017C },
    { 0x4242F52AA654EA3D,0x73169A2C7F1BBCAE,0xAD5788E936BDF131,0x5A151D1C21001931,0xA0D0EB0C33AD5EEE,0xE98FDF086ADCA012,0x41C992CF5034739B,0xB2C7C2BD4E494A95,0x0000000000000033 }
  }
 },
 { /* Table #58 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x27068F87578B7A3F,0x506446F1423A5346,0xE9D9C75B58DAC5E4,0x8EBC86E561B8F695,0x272AC14E611C51E3,0x67863A1D4E24FB32,0x270D4FDC02E5B539,0x96D7B7A9A4186D8D,0x00000000000000F4 },
    { 0x1A60EF0526627252,0x31682A839BDC0F5F,0x52A055ADA112BE82,0x9C3A88484ECF7367,0x5235087249E70680,0x61B6B478B881B9CF,0xBEC16C5A887D3C1E,0x8A8B2B82D598A671,0x00000000000000EF }
  },
  { /* Point #2 */
    { 0x3DAC1EB44CB7B72B,0xB027BCE2E0C7DEEE,0x69032DB2E994001B,0xDE2C253A4D22B49A,0x957977F9BF66A47B,0xC118EAE521AD303D,0x40C78CB818BA4889,0x09901C2CE69238CB,0x0000000000000162 },
    { 0x8099814B08BC1CEA,0x3E74578A38139921,0x899412A6D9D15FE2,0x973A21AC29446072,0xE6C4CE99EE7401CB,0x03A86C736A4C5223,0x6976124E6F3E93CD,0x074326DF34DD40EC,0x0000000000000065 }
  },
  { /* Point #3 */
    { 0x943DBC45CEDC41C5,0xA3889CFC075FBCDD,0xAB0A889DBEE1AC11,0x9A5319B1D8721711,0xC4228D8987ECEA8E,0x55CFCE64E8221D39,0xD3E9699D39E3E962,0x8ED1DD020549F4CF,0x00000000000000BA },
    { 0x1729967DFB5FEC20,0x16246AB37A6208F5,0x10904E4B5F5AF897,0x68C575BB273B4049,0x973F128B97335687,0xB696381ED6CB8CD4,0x3EF2EC73D2FBA17B,0xE4C62FDE5233AEB4,0x00000000000000BB }
  },
  { /* Point #4 */
    { 0xB685F627DD308AE0,0x78D327CB5A08F7CA,0x83E55DD1EE74108B,0x906408358D01FFDC,0x6D7694E81625F9A7,0x48B92A43D782C8BC,0x61F7B571BF98EE6B,0x02B2A743E511DF25,0x000000000000003B },
    { 0x020B09053AEA9B6B,0xC648D06D989114D9,0xD7861A73EC1E3D92,0x2C0EB0720A0581E5,0x5BE8C4DA3FDD93BD,0xD45049F2897946C7,0x0FA12B386EBB7FBD,0x7B5391783ACA1751,0x0000000000000001 }
  },
  { /* Point #5 */
    { 0xF61F56901631F481,0x31CD4A4460057252,0x11C6764A7F3683ED,0x813E617D855ABD6D,0x07DD6C6674BFFC99,0x4EFF77903D28A486,0xDA809B5A1236CC16,0xF3A0A984E1B1FA07,0x0000000000000015 },
    { 0xC1557C02FDBAA820,0x22F1B155490ACE41,0xAADDE80BBB30FE96,0x3ECB3B1E8005FCBC,0xBFEF06D968A1DB30,0xA8E0A6A1A6B85ED3,0xA602E5B52B82AE83,0x567EABD6FA699305,0x0000000000000177 }
  },
  { /* Point #6 */
    { 0x9D86D84FEAE13CFB,0x6D235A5F994991DF,0x0B5B3E99352CBF4A,0x9512101AA087EE0E,0x2AB9FEC1900FD50D,0x48129FE5C8FD91F5,0x69ED1F4D08C5117B,0x533E83C6E7007BAF,0x00000000000001E1 },
    { 0x10A0C08D2F0FAC2D,0x35A77D2AF3E1DAA4,0x447A8E905F5E78A5,0x0F5835B0D3ACDE30,0x5486F6B961B9AAD8,0x9BE0A9B8ECBFD6B2,0x95A5BD0409452928,0x4FC3182DEA830996,0x0000000000000125 }
  },
  { /* Point #7 */
    { 0x9E71F0BB8BFF6D2C,0xF35C6C1367B26058,0xB8791D9E9FB2CD17,0x834F77FB655344B7,0xF672749488C6106B,0x1D51D49A83BF0B92,0x2888CA81B2598CC2,0x454C00258377DCF4,0x000000000000000F },
    { 0x622AB6EBE9046DC1,0x3594E53E40D5F30E,0xAF4FD362632372BE,0x08601954AA276034,0xA2369D15A10A69EF,0x9C9FFCF525BF301B,0x7CD516D5DBAF10E3,0xC24AACC1F35E5F7C,0x00000000000001F9 }
  },
  { /* Point #8 */
    { 0xB5B80C0E82A8845F,0x6FDD0A0F42FA43CB,0xEBFA4307803CF184,0x1DD85B5B4935A211,0x2438607C6BEECB33,0xFBBB723E40EA88B4,0xAF5258A6E84DB1EB,0x2C2B8CD9B7AD5E3B,0x000000000000013E },
    { 0x313CE4450A092935,0x9FC84CEC8D0EFDA6,0x004929DC197593C0,0xEBD50BB3FBEF27F1,0x9E71F61938C08B52,0x590EF00571196231,0xAE3C0D2EAFC73D42,0x768BD9624DA4A91C,0x000000000000010C }
  },
  { /* Point #9 */
    { 0x716CAD1E90C8A719,0x631D6ACF882637E0,0x42FD6468B140D288,0xE8DFB49488B10F5E,0x5FD3394471D6849D,0x51459C14C0026192,0x4C72B94FD25C7D5B,0x157CF7E3C3A7ED7B,0x0000000000000123 },
    { 0x046419AB6BD8DBE9,0x4BE7F1C837EEE4D3,0x27F5A81AAC98AB3A,0x830A7200BF7071F0,0xA4DBA25C4EBD5B40,0xA8AF3ADDF94BAB5D,0xC5156C404FD3E972,0x1FE23347C1A472C5,0x0000000000000096 }
  },
  { /* Point #10 */
    { 0x96618BEC30BE228C,0xDC83AE086B84D4F4,0x260B2652348C399D,0x7C10AC42E6AC3A94,0xE3D44AEB367C5EDE,0xE0C1989639CE735E,0xA2BCCD0B708B357D,0x30D6969B489D30B3,0x0000000000000039 },
    { 0x3E9D894367D235DB,0xE6AB2B4427EA16DC,0xD5B60A504C54AFBE,0x48F39402C0C645F2,0x44FB14E9A03ED92A,0x8A66C28C8ECF7A8F,0xF5BA4CB58D9F6E44,0x8DD59588EDF7D7D3,0x00000000000000C8 }
  },
  { /* Point #11 */
    { 0x0D8A75E7972B1D30,0x9556F1EE4F05A10B,0xB0A90E0AFE233210,0x5899ED3FE8C3AB51,0xB3F56019411D224F,0x2FC2AD6F9A30B1B3,0x66B1A36860C33436,0xCB5310CDE3490548,0x000000000000011E },
    { 0x520FB4E711647BAB,0x2C5403554E4C5F55,0x3B4F3CBD58A8E072,0xAAC1CF335D4DBCAA,0xB5FF4B0426AC1C58,0x456D3FB2CF35E684,0x6C05AAC04B1EEBAA,0x3EB4E1447D0DEBB1,0x00000000000001FB }
  },
  { /* Point #12 */
    { 0xBB5261DBA4CC0FF1,0xF63383EB52D5233B,0x8AB1587033AA18A6,0x1779EE6ED6B62CE9,0x80EF23BE8EF0F8E7,0x9EC1CFB401C71A76,0xB18A364AC7C793F1,0xFFC4C25B753AB994,0x000000000000015B },
    { 0x80645523D4CA91F1,0x7E8594C5F895F3AF,0x5E0D810510B5A95D,0x9A087F09FB4356B9,0x7784383794C16770,0x5F6C04EF5837E54A,0xA0803997F3166DB1,0x797335E56B68A586,0x0000000000000075 }
  },
  { /* Point #13 */
    { 0x86BB6A2FCF51ACF8,0x8CFB578447A49E34,0xA931FC6BE3B6D1FA,0xD960CDE64A9D14A8,0xE4C4116245B21189,0xE4AEB21ABBBEB75E,0xE45DB020D9BE6508,0xA001AFB4789AD9E8,0x000000000000002B },
    { 0x5F754551C271C0D6,0x4926B87F0543B435,0x3157188AB3123BBE,0x2A77D4547B3ADDFC,0xB1C6000B0EE40AE4,0x6DE2CC2872F6A072,0x64FD97F7F1DD26B5,0xD43467C38F229A39,0x0000000000000041 }
  },
  { /* Point #14 */
    { 0x5717FD84A98F0156,0x968337919A823677,0xEBE83D77A05E6D66,0x39E669F95C1D28C5,0x0F577B1F0BF89425,0xB3C2F12C9DFB7D73,0xE9FFE3E1987F449F,0x14F8A1D9A57E7E4A,0x000000000000017D },
    { 0x4E980189DFE5B34C,0xA5561E4E202CD41B,0xF6DF35FBFB0D13D1,0x7F002E1707E1500C,0x9324D1D0CA1BF4B4,0xD3112B6A3E7ADFA3,0x65B4C876E04902B5,0x4EBBC331BB04398F,0x00000000000000E4 }
  },
  { /* Point #15 */
    { 0x7B5E2027B631AB3C,0xA4AB4559F2C42E69,0xD8A3ADC1B1670C20,0xA2240DB40ABC7C17,0x104AE5CFF054F41F,0x5C08B0BF128DF5F1,0x651F1BE1877D5D9E,0xAFB7992265E13F7F,0x000000000000015A },
    { 0x140370EE632AC61A,0x7CC393058A188E1E,0x21A228D9F6EAC7D0,0x8A6F15613FD21C04,0x64418721C35936A2,0xF9F06B28F3E01680,0x7EFE7361FDEACE5B,0x6A7264A96E30226A,0x0000000000000017 }
  }
 },
 { /* Table #59 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xE1F0C1AEFCFEFDB2,0xB5BC33D344930C59,0x253D5F4964D2C6E0,0x25EFDDEDE316BA1F,0xEB3AB21FE30C3A34,0x797A1AD6CFA52A9D,0x6A3CA2E0A81BA831,0x27BB664CE112DD07,0x000000000000007E },
    { 0x91FA1E121961AA16,0x381B2D7167DD7513,0xBAE8635144DB8A51,0x4CC1915FBC31C1CD,0xF79F40598EC6E9E1,0xB142B6ECA8929A72,0x4629C6488ED71FB2,0x9F79BCCFBD52FAA7,0x0000000000000029 }
  },
  { /* Point #2 */
    { 0x5A6DB3A8E35AB524,0x2E6954315117B9CD,0xD81F6F6417217CB3,0xB4296467910F3354,0x7249DCFB5A83E39D,0x7B6DF96F8C87A277,0xBC8CCD9FCFB09D4C,0xB644E4E35F67508D,0x0000000000000174 },
    { 0x1A228C95246BE9D7,0xD9B7805B669D44F0,0x7C240E63F5A7D167,0x863012F56BD7F19B,0x1CF3D77E3A9321BE,0x407DCFD2782B061F,0xDBCCC9DF881439F7,0x4A3A07A3116D1BEE,0x0000000000000198 }
  },
  { /* Point #3 */
    { 0x381C925424F3E2FE,0x71E5478EDEE535E2,0x191946A86E673D25,0x79802C83F2D629C0,0x46EABC893BBCAE3B,0xB8C8D4141BE23CBF,0x21A38CBA62EE0E85,0xFBAD16293AEDEA6C,0x0000000000000099 },
    { 0xEEA933933FD062ED,0x8434C033DDE340C3,0x5FBAFD98CFBD71A9,0x4A1DE5D86F9C6632,0x975FF1EDDB268826,0xCFAB8B1A3D2EEF58,0x6A50E2E30680FE1A,0xE02154F10E0F3FA3,0x0000000000000196 }
  },
  { /* Point #4 */
    { 0x9AB5FE51E870201B,0x181BE214428DCC9D,0xEA30361A335AB6FC,0x8F43702A3AF87ECE,0xA46B867147DF3E87,0x4B2FDC3FBB02E25B,0x72E3BC8E68E4D43E,0x854AE7242CF96610,0x0000000000000075 },
    { 0x56ECF90BFEB21BF5,0x75D38316E555D52A,0xFAEA840084CBCF08,0xBD4A0672B5126460,0x33C3DD8FEE751F85,0x4D658970D8FD6A67,0x49E1041A439F0C52,0x0480366FBD63268F,0x0000000000000101 }
  },
  { /* Point #5 */
    { 0x0D3598348F0FC596,0x3A7EF54AB20E73D4,0xD99446C037CE7F53,0xC198A75507CDCF9E,0xC170D6B241622E72,0x7DF33F4F593B7C41,0x58D8ADE8D176DED6,0xECE1335CA5EC80C1,0x000000000000013D },
    { 0x1F125D6FBB0543B8,0xB97E6E285F084A01,0x0907A203496482E0,0x0EB9FA4EB2A38099,0xB3E5054FB5C8B504,0x7E5204C7931D0353,0xEAB5BBDF86636261,0xB0627E5FBAD92B8B,0x0000000000000189 }
  },
  { /* Point #6 */
    { 0x7A11C13F68C39A09,0xDD0708F7944A3655,0x2A7E09EBB315B1F4,0x3ED8AF947B9810FD,0x91E2F2CF38B325FB,0x52C459939F279BF5,0x78CA140A1A34641C,0x6870DB8F090B00E0,0x00000000000000B2 },
    { 0xE52430C142C16B82,0x3223A77D347E84DA,0xF3D6350C9F0E8E62,0x7103BDC5FEBD6F14,0x09F90FDF0620F6CD,0x29CBDDA27332F50F,0x5E832F3501D09FB1,0x39634E5FF7075434,0x0000000000000062 }
  },
  { /* Point #7 */
    { 0xC0F92A02E25F8B1C,0x60474421C619DA00,0x14638CA768CBCCEF,0xD4C5CB6215E8CEC4,0xBBB32091A1194B51,0xD1133ACB5F0EF063,0xA714105653EB56B7,0xC1D582F54F250643,0x00000000000000C5 },
    { 0x6F5F71749789ABAA,0x29045949DE5C9651,0x5B34A35D3683EF86,0xD84501E5664F4510,0x3A32D2F9D2CB563C,0x68DB2EAE11B5C949,0x5A5F799FE22EBDD4,0xD08DE31B8E01D2AE,0x00000000000001AE }
  },
  { /* Point #8 */
    { 0xCC24E895E1756B7A,0x3874A79A3C09615B,0x30E2489D9014FFC4,0xEDFA2851E9070C97,0x69113AC763017E47,0x2DBD4D59EE9161C5,0xBD93ABE740C20E53,0x2EB660E491CCC0F9,0x00000000000001F5 },
    { 0x1363F45A719C9F85,0x32DFB30EA43CD38E,0x35933E9A0B75D1EB,0xAF1FC78775AEBC26,0xB444F393A27240C4,0xDB46C96DF7592075,0x59C26AD852510AD2,0x163890BF029BB7A0,0x00000000000000A6 }
  },
  { /* Point #9 */
    { 0xB2534B51B9E83A3F,0x3C07F9957648D40C,0x4898E16E580B4363,0xA5CB6B67155C966C,0xB3FC38BF807EBEB9,0x798544C1D68E0B88,0x02AA16363D7A48DF,0x7006B69ABB842157,0x0000000000000090 },
    { 0x7CFA15B7673B972D,0x4C04795914F2DD22,0xE30598540AB1E7D3,0xDD22FF425EDB0580,0xDAAE123E4E0FC90D,0xA60A9C8B9F2E7EC3,0x233F9668AC09B64E,0x96E3BCE80B826C49,0x00000000000001D4 }
  },
  { /* Point #10 */
    { 0x16F90AB573788E7C,0xF3764FED23C733CA,0x9F3F62988308922B,0x0296972668E8E3E9,0x3550A733199385BF,0xA1B2E9A0DE473ABB,0x514507FB0B294BA9,0x5B2D2A045A38EB38,0x0000000000000145 },
    { 0xA48B1D0FFAD2F8D8,0x3032DFAAFD0681D6,0xA666576A510F6858,0x88B783160A66F615,0x218E45211B549B61,0xF07BE61224081D37,0xDA4EBFBC49677BC3,0x6A59D4AF86B12DB3,0x0000000000000112 }
  },
  { /* Point #11 */
    { 0xCFB013C6C8EC13CA,0xFB9355F62ABA5EA7,0xFB2553A32CC82D38,0xD42F357182EC98BB,0x06FD8FC457BEE942,0xA30CD88DAE48A527,0xCA39F8CB22DC4557,0x77FCA5DE8B366836,0x00000000000000FF },
    { 0x6A78299E78D119FD,0xDF5F90CAA68E8856,0x112174F171A64327,0x4C183D3D3E28FB76,0x141DA13B7A59FC19,0x3DFF6EA665C4667A,0xDAC4F87F08E17049,0xAB313984D622CC83,0x000000000000016E }
  },
  { /* Point #12 */
    { 0x35E461C73F298075,0xDABCE92B476FD938,0x1A928E413E13910B,0xB2E8F656CC7DD6CD,0x8A8AEBFA4D4CD65A,0x23CC2419D684D87B,0x6E96B40BA93085C3,0x303B86411F9C3BAB,0x00000000000001F6 },
    { 0xE66619D05A55180B,0xAB397F7D3BE53831,0x103C38D48F88FDB7,0x7E6D67DFADF9520E,0xC93512456E517E33,0xD8596B94A69929B8,0x9611F83A43DD1FF0,0x46568571D30D5F6C,0x000000000000006D }
  },
  { /* Point #13 */
    { 0xC04052A06A7908EB,0xC0DD34FB3F7A61C9,0xA72BD10E8C383C8B,0x7A4A872C7516B2E6,0xF00570CCE25843DA,0xB6800F068A741583,0xBD1D38C1D2E1E3D7,0x6F3B6DA2BD51E6CA,0x0000000000000171 },
    { 0xD598A4AD4DA67565,0x3C8016A38FEC9378,0x586BDCC9AB7EC42D,0xFF90EE855F2E1FAC,0xF0A0E72A9C20D2D8,0x94EC863B3B7843A3,0x6329AD19B4160103,0xC1CEF8F543758F0E,0x0000000000000023 }
  },
  { /* Point #14 */
    { 0x29609FB984951CF0,0x4887CF10945733AF,0x526B90B2DD8D18D5,0x6BFC92CCA7E3B224,0x90B4F6EA2FB1CEDC,0x05966B6F9CF32E56,0x0E6AD1EF9BB9337A,0xB4FF8105DF27F7BC,0x000000000000010B },
    { 0x447A04A32940FBA2,0xA1FDCF5F0AA1556A,0xB8C46C99A26539C0,0x8A68BD26D3ACD372,0x17454EF09D0734AF,0x61E6E7F59EA02AB3,0x7AE93925F793E303,0x6D1FB9325300A621,0x00000000000001A8 }
  },
  { /* Point #15 */
    { 0x042404E29B46276E,0xE7206E434185728E,0x354289B66003F4D7,0xA7F5F27D8F2B9F5D,0xCC5E556B57DFC134,0xE7638D95FD212481,0xB140FD9A2C480FA8,0xF2D9D3907181F0C6,0x000000000000010F },
    { 0xFE512D05F53F6873,0x8036E7C8B3A8C31E,0xBC695160E71FE4AB,0x33DAC2EB17C10BCC,0x8A54DD5F29B01272,0x17BF47B10912F34E,0x0237A52EF872E732,0x6306591F47C624F4,0x00000000000001F9 }
  }
 },
 { /* Table #60 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x0F8341FE21DD6E7A,0x5C106F8EEA93E5C1,0x8E2AD8E9AD0114BC,0x277EF823F059D291,0xED4A28E5DC50FD78,0xA071965189CDF20D,0xE393B2641FDE162C,0xD383B86D30A5B16D,0x0000000000000041 },
    { 0x04B8115BAD6DBEAF,0x7D7F0BB9A996519B,0xAB54D4C89C397C91,0x1750B97D77A6A3E3,0x1637909B14554321,0x7311DA687A5AEEA3,0x1F91A0FD52130453,0x4338B3D686753F28,0x000000000000014C }
  },
  { /* Point #2 */
    { 0x99A1DAA94CF92B1F,0xB08A7BDECF013530,0xCBE6C7BC1576E51B,0x9F88C296E6C13E9F,0x13FDC9556370791C,0xADEFAC0DA42B1973,0xE69418A412CB2FFC,0xAF05CE9762EAE4E0,0x000000000000005B },
    { 0xADB36E6565E89A12,0xDE7FEE5853131BD7,0x7335C5CBABFFA9C1,0xABF94BC392947061,0x11D2E02B6109BC5B,0xFC1FC1D28A097CDA,0x4512FBB6F3D5DB21,0xD40E8637336A3D5F,0x000000000000013B }
  },
  { /* Point #3 */
    { 0x3671D520E411C88B,0xE56D2622AF747CAA,0x8C2D939F3F298A36,0xD09F955E38B36307,0x7AEF92FDACFE3A5F,0xAA1B543A3C3413E3,0xA68BCF7585E8EEA2,0x1C33B90957271AB1,0x0000000000000175 },
    { 0xE829B5480993374B,0x93ACE6B43758FA53,0x378932ADFB48D303,0xA0BE54CD7B9ACA58,0x6F020D2F07D56BFC,0x661CC6DF332D5724,0xE1C67B4C4702E14E,0x6D7E1534FE0CE1F4,0x0000000000000165 }
  },
  { /* Point #4 */
    { 0x70EAE5E2B7C097FD,0x690C65C6BECC7C65,0xF684CE2CBEB8A529,0xFB5BD6FA772826C5,0x12025C313B0D8680,0x8F20FAC7CBEF00AD,0xB810BF456FC66AC3,0xA960E1B3C7878181,0x00000000000001A1 },
    { 0x85A5E619F6103B53,0xCC4CF223FC14A4B5,0x68985B1F977A8C64,0x410EAF63FE82447C,0xE20381490453D341,0xE1D008AD719258DE,0x26C1B1773410D895,0x93CAD3DA45BAE984,0x000000000000012F }
  },
  { /* Point #5 */
    { 0xB83FDB669DE748B4,0xC46F81000C41F158,0xADE8932FB8F8F374,0x5728E8AAC7AB11FE,0xA3BE4365601535D1,0xF366F0D450C52B71,0x6E00860084DB7699,0x39C5934C32BD9061,0x0000000000000003 },
    { 0x4C5F3AB49C964A3F,0x30EE02C369A70BA7,0xE4F4E7721699B55B,0x957EFD09F2104682,0x7BE1BDB0298947D8,0x128BE588A6CE37DA,0x10F0ABBB5110D219,0xFE63DE4B6C433528,0x00000000000000A5 }
  },
  { /* Point #6 */
    { 0xEE8B94E0BCBCF019,0xA3965127952A5A75,0x5D306FFDBD99B8E6,0x9726ACFCF7F77F82,0x52A8C48F333E69A2,0x2561B47EE5310F8C,0x5C707992DDBA50AD,0xCA39FEC1D49F9302,0x0000000000000197 },
    { 0x773374E03330C1DE,0x3C186E5A12186692,0x7C50D77C2A07FE4F,0xB0387D01EC8CB87F,0x891A741524AF7E0D,0xACD3FC805DCE5454,0x2A92F9CB257238D4,0x25075CBC4415B2A6,0x000000000000006F }
  },
  { /* Point #7 */
    { 0x64F0AE6630AE5727,0xEB7FEE1CCCFE2F46,0xCB52D65CC17226F5,0x11BFDD3C4BDE2FF6,0x14593DBA22F56523,0x7549C2A8E5A07B06,0x27E857B0A259420C,0x5F2702CFD795BF2B,0x00000000000000CE },
    { 0x50247B7799EF6F42,0xC5D4D501A9496281,0xC2898FD0848EE90A,0x5916DF473B105EA7,0xC963D568A3FC2A93,0x4F5DBD88A71E69FF,0xB1DFB820ED98520A,0xF91D6E9E5BBB0779,0x000000000000010E }
  },
  { /* Point #8 */
    { 0x6BCE4008DB3002CE,0xE109980C03FE67EF,0x35F077201CD61540,0xB0ADFBA4723C0EF2,0x811B100860CA9A5B,0xEDD17F04C0D112C6,0x8CC7CC5F49688782,0x716F36BBD5F89C31,0x0000000000000031 },
    { 0x700CB92A1D19D891,0xB99918262DAA7A23,0x834CD1FDD9AD0C74,0xD74EE37682C919DA,0x6569353497696DEE,0xE2615C6E12E9AB53,0x4BE93A40090BBDF3,0xB811069663437098,0x0000000000000162 }
  },
  { /* Point #9 */
    { 0x2640B0474717DA49,0x6B303097F0A90682,0xE3FBB37BA4756B74,0x084581B1E3F7EA6A,0x942B168D67A536E8,0x4CECB7EF8E8E4DBD,0x48F4B7C0B17164D3,0x8A464B3A93BFCA74,0x00000000000001FF },
    { 0x21F4906F7268EC93,0xD61C24432ACBDE61,0xDE475D32D6FA2261,0xBAAE1526A02F45C5,0x16B2C6B30212C1FD,0xD6AFDFE9FDDEA6A2,0x1F8FB94D5DAF789D,0x2F89389B576846A0,0x00000000000000FF }
  },
  { /* Point #10 */
    { 0xFF9F5E5ED7C958A0,0x99585B2F434A426D,0x07B475A96DB1ED0E,0x1EA7F5D7A973929C,0xB4006A0B7BBC180B,0xA86F75D4925BFAA9,0xF986DE1075C8A7E3,0x43E74F08F25AE706,0x0000000000000088 },
    { 0x4FFD5C105068ACF5,0x6FFD7EB6063D53CC,0xE899D17938343CB5,0x9451A0150A3DF7BE,0x8A581525A24B1528,0xE5DFDB1B67A03545,0x715D2B87CAAA5064,0xAE4594CE0EA125BA,0x00000000000000C5 }
  },
  { /* Point #11 */
    { 0xAA0898403516E4D9,0xDFBB159AFBA094AB,0xDCB895E26BB49EBF,0x7A7B572756CF3C64,0x52861B3C38C7BC1D,0x7C34176C27352C7B,0x5B3CC2177D33AE38,0x4A2083698C494A63,0x000000000000002E },
    { 0xD32926625F514FAD,0x5DEE99706020B420,0x8AFF8C84FDAE8486,0xFDC0EE6551E60C42,0x564287BD236681DA,0x6DA3E12ECAA82AF6,0x6D17C67CE1EFBE58,0xA0334020CCC6C519,0x000000000000006A }
  },
  { /* Point #12 */
    { 0x0609A97B58033238,0x5B9678B1D40689E9,0x4ECD26C3986C40F7,0x7A6083DC2002E8FF,0x73FD1D708B769797,0x0FA7DF7924E06E55,0xFA7254F8D49B9EFD,0x742AD69DF862350F,0x00000000000000B1 },
    { 0x78E2366A314A07F3,0xD0ECAEBDAA487012,0xFB13A82507FD4B1B,0x6EE4483AEC0C854A,0x0E7D617E72FD006E,0x0CDFEC5B291B4018,0x2B9FA205F66CCA32,0x261F67F6149D20DE,0x0000000000000075 }
  },
  { /* Point #13 */
    { 0x46D6266D92756C0E,0x3164F6A8305E1611,0x65DFEA3D613B00C0,0x75EA9AB9571828A5,0x5184DC138BE872A9,0x8C59C14192347D22,0x96B331914BAA4678,0x0D34CC5A2AE17A1B,0x000000000000000D },
    { 0xC05C3C516FCB342D,0xB36A7EFB677D6EA3,0x016811B2A8067B2B,0xFFFF97F94822FA85,0xFC646B5145883BB0,0x56C40D49C28D61DB,0x91BE8847EADD1593,0xECF0A8F5128D8AD9,0x000000000000002B }
  },
  { /* Point #14 */
    { 0x436121DB4291D3C6,0xDB32E56791D00413,0x17E048DFD571849F,0xCADF80D09D174B7A,0x504FCD8CF3A16F6D,0x0BCA040B55A79E74,0xAE5E562A9DD8E72C,0xA2AD35266D83C58F,0x000000000000001C },
    { 0x68CC0E2F8BE48C08,0xA4CF89F3A957CC18,0x7EE580A6720E8F3A,0xD45347C5CE9222ED,0x2043BA4B964685A9,0x8A59C2FD1AD8ACB9,0xB2AB5A3FA3A1FB58,0x6F0D28C3E7A7BEFE,0x0000000000000060 }
  },
  { /* Point #15 */
    { 0x33CCF08DE10DB8F5,0xE481EA75D2B4CBA5,0x8DB73D5BEE9CDB6F,0x5D11D992B5C523BA,0xE9D79978D11B927B,0x61BE8FC17A355C88,0x5C31C7A65A062E74,0x2AFF5A1117A4A844,0x0000000000000061 },
    { 0x9F5386773C9F31B4,0x7F7681C7766DFCB0,0x1D759DD9CB41B746,0x1842CE5A3DF8B332,0xD6650A1D46CF5438,0x3AFAD154D8E57A31,0x72DF5ED3C779EC95,0xA9F04F62733F1F9A,0x0000000000000072 }
  }
 },
 { /* Table #61 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xDD9166282D3D7641,0x99029E9B39C02CEE,0xCE03FAC9B6DE7881,0xC2CD0F784F66EBBC,0xE391948364C83E37,0xFC853CB8FD7BB155,0xA5A99B24432314CC,0xEF0B7ED0133B2709,0x00000000000001D0 },
    { 0xE4C4D8A054DE3ECB,0xE2F88AC25F8CB5CE,0x17A4E60D68EB11A2,0x6D0E05FB3B79619A,0xA54874B7D5DA75EF,0x18C2B1B3C77F6AC1,0x5A2A6FDD829736C3,0x9CE62F22CD44843B,0x0000000000000059 }
  },
  { /* Point #2 */
    { 0xC3E525D2AFD7C4F7,0xC11FD457AE2B9475,0x6CF55E765D48EAD5,0xF9546FE48F93EB95,0x3E3712A75E124BA8,0xCB71CAAFCF7A3E81,0x512060172F3D629D,0xE226FE2DBAB1761C,0x0000000000000079 },
    { 0xBB618C7BF963A03A,0x2FD9211CD55E0AB2,0x25BE6C8A20DFE924,0x40F5FF09135B7156,0x7770BA4AF706B788,0x5A2146E0DC114357,0x48F25EDA54B6FAE3,0x5ADC7AA519EAD5C4,0x00000000000001E3 }
  },
  { /* Point #3 */
    { 0xE521DCE8D006477E,0xD566FC0BEA3F2B6D,0x472EA46918CCAD87,0xF15FE9D91FE4719C,0xD275B8CE8B7015F9,0x3F04FCAD86894ED7,0xC02D8386C023A915,0x6B29D94D5ABDA947,0x00000000000000A3 },
    { 0x707122C496135659,0xAE00DC93EDA8C2D4,0x0EA664C3164EBA39,0x0DCB1880F36B5B72,0x1EC8BC56337E6DEB,0x34237EED20DB8B04,0x026FA069ED7BAF4A,0x88B1EA03EC16CFBB,0x000000000000005B }
  },
  { /* Point #4 */
    { 0x21E292CB67355505,0x7CDF9C24E192A20D,0x07228775F6753EEC,0xCD83121B93217C7F,0xF6E99141AD41CE70,0x2214296A41A8EC10,0xCDF7237B0200DDB1,0xE2D943F5C7CA562D,0x0000000000000056 },
    { 0x9F743D7C9627A12E,0x33FF2E7E31099D8A,0x3C9E84D12A07248A,0x9CBC405A6136B3F7,0xB131C000970BE1E5,0xEA9C160B84162E6B,0x1C54FE695BA3F7A9,0xD5A98FDCD51B962F,0x000000000000015D }
  },
  { /* Point #5 */
    { 0x1C676BBC44EAC0B1,0x95E848106FEA6C20,0xF0AFB403E182DE39,0x180FD76BF6DAADB9,0x9F2D412DAC485527,0xCD59060AB8565861,0x993858754F05CABE,0xB21C7C70B829E025,0x00000000000000D3 },
    { 0xE9B60D5D554AD734,0xE70BAE12A30D86A2,0x34113E1D442CFEA6,0x586FB932CF199E84,0xC66AD7E674D28CC4,0x2CCD27D2FD5F8CDA,0x1F47FDCBC78032F6,0x8D4B66F18D5B2254,0x0000000000000141 }
  },
  { /* Point #6 */
    { 0xD01BFB1F891D513F,0xACF22E961375D0D4,0x6F5C76F9D43C24F1,0xA220F50707A66E1E,0xA0B91C2AF227B93E,0xEFE049868FC8F377,0x58482184FBF6C7CF,0xB224B543CAB58946,0x0000000000000094 },
    { 0xE07E7D7914855341,0x68881FB60A675863,0x4083D236B9736E0F,0xEC6CE43102DAC8A4,0xB0477CF188891340,0x67C0CC0512CD1F4F,0xF3101C296F7B5340,0x60F49D6D1E980837,0x0000000000000116 }
  },
  { /* Point #7 */
    { 0x8BE4DED5DB4265E1,0x9F65ABF22700418E,0x457AD4E255108266,0x43D48A67A6138CCE,0xC6C6C6478AFCCDAB,0x87F5811D64DE4D77,0xA02EFC05F48F36BB,0x21F8EB11BC51E05C,0x000000000000017D },
    { 0xE1EFE9AC215B4477,0x44D6AE20209CAACD,0x2CEBFA6449E9661D,0x5F1EA1945E169DFB,0xE6705A2EF5DF63A3,0x6339EA702A22E3DE,0xB56EF344668F1234,0xAD598D6A896E23B9,0x0000000000000124 }
  },
  { /* Point #8 */
    { 0x3CD54B988FFA8932,0x73A8C09947855C60,0x5272D16B3ECC6B44,0x7CF96927B4E83CE5,0x08AF41C8A3908EDE,0x98DE920A73495D2B,0x6DDC94E1BE247419,0x0936E34F5E3E7C96,0x00000000000000AC },
    { 0xF3B1A1AA9D269D4B,0xB20AFF071103E749,0x9A43C7A4632098AE,0x221C12CBF450A9EE,0xF04A8E7C7F773A12,0x427A8CCCB2AD0EE7,0x93F7EE9DC0B2A786,0x6592BB0089BBC18D,0x00000000000000FD }
  },
  { /* Point #9 */
    { 0x67AE2B8C6422383A,0xC2FFEC0E6B950051,0x8E2470A34DB885BB,0x2CCB0C4812D25CD3,0x745143BF47029173,0x0025FD4EA5E5D08E,0x11344FE703D6EEE5,0x99DA74827D956F6A,0x000000000000008B },
    { 0x7AFAF9B1E8A56D7E,0x37BCDBD39AB62EA4,0xD949B09A01DBEE6D,0x09928E327E8D04B4,0x4EBFC15B31681122,0x1400578204D32B62,0x42B2CB68CBF26F4C,0x57D17DC859034A08,0x00000000000001FE }
  },
  { /* Point #10 */
    { 0x8F1C77F7A9E8CDE3,0xEB057A9562FD5799,0x8428A885DBEE1BC1,0xAF8C03C38ACD2865,0xD5C2C0039061A6FE,0x4DAAD9CAD2016BD3,0xF698F86CD10CE994,0x5DA25E28B620FD65,0x000000000000007C },
    { 0xE3162C8FFF2198A7,0x60B05D1F9084AF55,0x64ECFF3C74CCC32D,0xADDE221A29F6E28A,0xD6D98DB85F2A1653,0xB661BB0B597A14A9,0xBAA4D0B80BF62EA4,0x60B8DA55E7FEEACF,0x0000000000000118 }
  },
  { /* Point #11 */
    { 0x0A57BD311983F79E,0x60CC9782E3160EBE,0xD8D39ACCAA372647,0x2BF8771CD56913D3,0xF8AEB63B1E54D54D,0xBBC42DCEB468D8CF,0x44D77C4308FBB9E7,0x5AA66DF2AEDA7D70,0x000000000000007A },
    { 0xB5EA1DFDB4E930D0,0xF364063E234A1AAE,0x808B959CB03003B2,0xC0479EE0C1A101FD,0x4E9DE14D6D550D43,0xC8EB9DD6398681F0,0xDD31E4F067C976AB,0xBB18A005D7124D48,0x000000000000012B }
  },
  { /* Point #12 */
    { 0xF760F828EBF01D55,0xD9E13BB2143C38D6,0xDD69A7832620BB25,0x6D16106459A570BF,0xDA4ED76759A7C1A7,0x5B07D2A0A22CE561,0x2D1614B0616BA6A2,0xC2C99B092013B7B5,0x00000000000000F6 },
    { 0x532F835B6606EB53,0x11E4EB8CD0FCA568,0x3D12BCB83ABD1C3B,0x293651B7EEEBAABB,0xE49CF58535DA243E,0xF0377E4414E175C4,0x12A1F99F39A28CFC,0x5B3C4C81C02ECDF6,0x00000000000000BB }
  },
  { /* Point #13 */
    { 0x4BD78A0A745853FC,0x5DC4E1A451743C37,0x7DD66926D8D6FD7E,0x9773396F7888E634,0x6BEFCCD47EFAE90B,0xC7670E2C725AA660,0xDDC5873CA658FCDC,0x1224E4BDE0F5F359,0x00000000000000E3 },
    { 0xCDFB21FDC6A2932A,0x46E351C7082412ED,0xEBE52FE1D78EFB2F,0x42024E5F4571C790,0x5243756202F62985,0x3DD58B6121AE1521,0x659AFBF6615262E0,0x71492809EA06F5AB,0x00000000000001FC }
  },
  { /* Point #14 */
    { 0x6670D91E241FCE4C,0xEFF7977950CEC570,0xCBDAFC5ECFA2EAFA,0xA40C09E53265B4A2,0xC4FB20C0FB68C280,0xDD0B12E9BB2E6910,0x31437BFF0F2BC13A,0xA92209D7493EAE11,0x0000000000000124 },
    { 0x0DFA947C893D23E1,0xED7F8F9C103E6B81,0x2DD62ED73002E4C1,0x6DDDA0871F9973E2,0xB79ED2773B014D60,0x12FBDA2FE51B686A,0xAC9C34B6911B0E3B,0x6FA28F425F117D64,0x0000000000000106 }
  },
  { /* Point #15 */
    { 0x1B4EAAFF932BBBBF,0x6D3C553E5047D29A,0xB7E633E7DE3ADE41,0xC4B782E4C480BDD4,0x59523DFA8B7274BB,0xD07D0308DF339D34,0xB289E9E086BFFAAB,0xEC8D2EBE84D0FF1C,0x000000000000016B },
    { 0x88FAA957758FC7C5,0x15EA30CC82F1CC7B,0x10D79D4E4E1A3BF2,0xF1C1B0CE4321A137,0x8EE3028FB54440C1,0x352F58A22CB330AB,0xC7BF6F4F5EE439B1,0x162D027EBE77C93F,0x000000000000003F }
  }
 },
 { /* Table #62 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x1EBC5309B6BF5EC4,0x29CA5BA73A92BA16,0xBDB1BCE470839C14,0x963FD369DE1F966C,0x208FDC754FABA5B7,0x2F1EA65A678FC163,0x792FA255A773BBC5,0x752A08FAB22A653B,0x000000000000008F },
    { 0x096AFF662E58F405,0xEE92B17DD6658910,0x65792CB3D33B5B5A,0xFA503F215678F269,0x4E2757C8EFDFFC67,0xBE46A6F1665347F5,0xD049A1586D9773E7,0x9555B002B0A28AC5,0x0000000000000145 }
  },
  { /* Point #2 */
    { 0xB09A3E8B160E37A4,0x8ED9AC0627DB36B6,0xECF1838A99CBFCBE,0xB12C94DA28B4EE00,0xD0841818C5F1FDC4,0xC43E50B2BEE0ADF4,0x19F3F05B122324C6,0x796BAC65988338BB,0x00000000000001E3 },
    { 0xF211AF1AB50F7626,0xDECF7989CA2F6779,0xCBBA6B74E1ECBBA1,0x73F60E835E5FB261,0x3EEBD6890629DD5D,0x8906A06E05FBA7EE,0x7A23D83A58152375,0x0F4B9B2DE9F1D23D,0x0000000000000009 }
  },
  { /* Point #3 */
    { 0x353AE6FD77B9ABA6,0xBAAB19AF013F3158,0x14D0564C7B9B7AAA,0xE591B96A2D9FF473,0x327E3FB873F46109,0x61C0191E6BE11242,0x9696F1BD6345CF6D,0x3DD87573684C060B,0x0000000000000058 },
    { 0xDAB49BA0285A6DDE,0x7D66E2C3075EA1C1,0x721973502D8CE1F9,0x5E64C366AE730C53,0x17154D6DD30475E5,0x14153F7A3341D88B,0x711DFAB66235304E,0x0E010897BD4533FC,0x0000000000000177 }
  },
  { /* Point #4 */
    { 0x75B620639659F9E9,0xA5568027C4B6DC18,0x1C5DBFFF1F499E7B,0x35B20FFDFFA60EEB,0x4368AC975E2237E6,0x502C0E789ED425D7,0xF8877B29F5AEAA27,0x137E015DCD2E9BCF,0x00000000000000FC },
    { 0x69BE3C6D3FFFEB71,0x5739D6C9E33B4CA6,0x94672002643A1EB8,0xD1359E0570FD238B,0x3B7EF87493916A8A,0x4EF08127EFDAF809,0xDE4174E74143AB1A,0x3BB964E042E7AEE4,0x0000000000000151 }
  },
  { /* Point #5 */
    { 0xAA4A212A2177C1C1,0xF08F1F5D4C8A2A83,0xEEB0A8940FE14C27,0x564A1C8F3F0C1F0B,0x6B73048C9297B55E,0x3DDCE9077A810E5B,0xD8F99EFC3DE8797F,0xD9B3FA2E37379157,0x00000000000001B0 },
    { 0x65A7DC22FE9275E2,0xBE8B93FB6960A690,0xC783DF8863F437EA,0x4FBCF1465A22F1EF,0xA1B86AB3CFDCF231,0x0B1309CF50CB90C7,0xA77F0BDEFC3CCE3C,0x86DEFF3CC30AC697,0x0000000000000170 }
  },
  { /* Point #6 */
    { 0x9584A837980C0F9B,0x4C2C21B4F234FF0F,0x584A18241068EEE2,0xB3C08003C5B71C77,0x98A59E372505132C,0xFEEB536724513321,0x83F623522C9AFA82,0x5A470AAD23D28BBE,0x0000000000000160 },
    { 0x2AA901FDCE4E21A9,0xC0FB45706C14573A,0xE0711B5E21C1A7AF,0xEE3BFBFA2A47A293,0x12830261FF0DE285,0xD334F3EE68D87D16,0x3FB8D74765C6B8BC,0x1C40F1ABA12A5638,0x0000000000000070 }
  },
  { /* Point #7 */
    { 0x1A4D19D6B580E3A2,0xCEE647C220834FCC,0x94066A7C2E9454E0,0x220B4993B1B480E6,0x0A89C3E330E72308,0xF22F323E6294E865,0x27DAD374645C364D,0x16B70ED4B47A7A2C,0x00000000000000CD },
    { 0x208A7F56CC79E99A,0xB844ED7D1991087E,0x6F19C1C07EE9FC8B,0x12A4140BB9208633,0x8F976B252C1A5947,0x083544DDA1BFC7C3,0xD432604B206DF951,0x0F3C03B57ECA93B3,0x0000000000000115 }
  },
  { /* Point #8 */
    { 0xC3246FC8BDDB33C7,0x68DC29BB81972F1F,0x7B5EDC9BEE7ED0FD,0xEE83430CE158DEAF,0x8A924B48DF7C5708,0xB421A505F2C65A04,0xB5DA215E5C289F82,0x752D5FF9B9D02B8A,0x0000000000000165 },
    { 0x55564B4A0D9D7788,0x70C744916CAB3607,0xF53BC98690091526,0x1E88044D9ABC41A6,0x38E9D3DD2BB6D384,0x4177105E84BC3DFE,0x2B95A432674DF1B0,0x38196726EB1DE0DF,0x0000000000000137 }
  },
  { /* Point #9 */
    { 0x04CEB99810BDDB29,0x9FAB2EE4442F2C74,0x4335614119667AE0,0xD5F83412FC81B56F,0x5E6ED8E99E856C30,0x78C996CFB4A7E832,0x8D4B42FB6FDF4883,0x2DB8FDDD44413470,0x0000000000000003 },
    { 0x924933623B6DB1CF,0x8E613F6F7188ED35,0xF0744604F3B826D5,0xABC6AB2DFF49C7D4,0x228F6AF4946A8711,0x39DDA5A2EE2C8214,0xD44BF8744F1FD467,0xD1B931AAEECF1105,0x00000000000001C4 }
  },
  { /* Point #10 */
    { 0x81AFD9DC25A94603,0x7E472FDB31C4A39D,0x18E2B134AB868547,0x8573554D35341BD7,0x9F0E654B102018D1,0xB58B0677666D20AD,0xA4FDA396F4C47E49,0xB9C5EAFBF77EAFAB,0x0000000000000058 },
    { 0x1EC9F439A5C5153A,0x4BD7D8FFC77E40EF,0x7D1BF1E6FA1DCDAA,0x5043E2BB30E3DF88,0xCCC542577D4CF37F,0x0A8F8EBBF009F098,0x1B02578939F34CEA,0x465C50425AF62584,0x00000000000000CC }
  },
  { /* Point #11 */
    { 0x1C0D7CBB986D7822,0x213BDA7C6BB648E9,0x51743E4BE29E68C1,0x74D1DDEE4CD28F08,0x4437989C8C3C3F8D,0xD403A60FAEFB33E2,0x4D61A73065B46A84,0x4CD324D76D94CC26,0x00000000000001D6 },
    { 0x9693319F036CF7C9,0xF5457F5512028A77,0xDEDC5573592AFD27,0xFBAB1069299FACAC,0xC4AF7F75CC2D88F6,0x94AAD39D3C873D6F,0xB0F9A767BE4C8438,0x4685419DD7FFECD3,0x000000000000001D }
  },
  { /* Point #12 */
    { 0x3DB9010FB61816DA,0x01BE4898BFDAA07C,0x5E0D581AF1062B19,0x68E30624AAD526B9,0xE299FEEDB0DB432B,0xE61F7B9D8869018A,0x97238C9C96556785,0xDE6A42752CCB7181,0x0000000000000100 },
    { 0x91B9C6EB64A5ED97,0x4A7A76A02A6F6F0F,0x1FA6E4D480F2B908,0x469C3B68B4119947,0x63241013231A9C44,0xECA43BD4E1B2F6EC,0x5B0E9617B96CF87D,0x6FC048B7E8FB1B5C,0x0000000000000104 }
  },
  { /* Point #13 */
    { 0x0F70C5E0C5521C2D,0x72DF660F0FC84AF1,0x07C566892F5F45A7,0xC3FC3B7C01B67FA4,0xB858952EA4F91F37,0xE39E37E252668222,0xA30B47F89DC7794F,0x83CEF63564EF0F8D,0x0000000000000170 },
    { 0x28BC223E51F3288A,0xF3E683F2B218B266,0x93157CE5408A15EF,0x22BCC030964E4AEF,0x7887CD2C9E6F911A,0x391B0CA659C34B65,0x3BFA6D84726F4AB3,0x2B0D81D083ECFC29,0x0000000000000106 }
  },
  { /* Point #14 */
    { 0x01DC6EE0CCE1BE45,0xD71907CD683A07F3,0x293799412B7FDAD0,0xFB04E1A14E79D801,0xC45FF2204B76C41D,0xDD704FBA7E24609A,0x16316658C2319DAB,0x08822BDD7BAB9D30,0x00000000000001AA },
    { 0x4AA4C2B1EF3A3B88,0xCE9B903F1060E53D,0x77C15F0E8A7DE1AD,0xF56ED11851CABE71,0xA4D9A408230FA1AA,0x72D25E8D7E95E65F,0x504BC76FF93B5F2D,0xD89797C6CA8581DD,0x00000000000000D7 }
  },
  { /* Point #15 */
    { 0x57E31F163C9A7FF9,0x44BCA9A6D24471A0,0x92C258665DF58BE0,0x09A27C8DDD84263B,0x1C276A353EB6554F,0xDDBFD7BB564BD80A,0x82469AB65798B89E,0xF3945D8CEDFF69B9,0x0000000000000105 },
    { 0x0C7A93852F2FF79D,0xC2389A90E5892D2E,0xC1790B921F36EAED,0xAA701EE7CF448875,0xD82EA4E119D6D0E4,0xE3F4853BA05DE67D,0xE77C6A38E8811C2D,0x03D5F231E83B79AC,0x00000000000001EA }
  }
 },
 { /* Table #63 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xA6D6B095DBBD171F,0xF0D3B95744F06181,0x46B9786578FAB381,0x7DA97845AE356E29,0x4A0C3E00D01B3C09,0xAED18677E106D5BE,0xD7309C761AFFDB67,0x9715875425F2B8C2,0x0000000000000193 },
    { 0x65D3657B24785079,0xB1D2B5F75E064334,0x0736BFDA2B7B61E1,0xB39C4DB1284E4FA6,0x66CEDF43BD934998,0x8F9F6243324D2DE1,0x92F2524E4C193171,0x75705ACD964A8383,0x0000000000000031 }
  },
  { /* Point #2 */
    { 0xFCE13E03D0739036,0x0AF573F2A4161596,0xF3DB4C750BDEDD89,0xB594CCA3E8EAE413,0xD9AD2EDCE2E66F2D,0xE99C048166F7F599,0xD141FF976886E453,0x087714A153E3221F,0x00000000000000BE },
    { 0x91EAB39E5DAEBD46,0x3F9DDEA494FB01F2,0xFAAA200B142AE67C,0x853DA6B0CA631C4B,0x4C9CA396FB3F4229,0xB00A8DE2E3690F95,0xE8000000C2C7704A,0x65C0AB7393AD0DBC,0x00000000000001E0 }
  },
  { /* Point #3 */
    { 0xEDEC6D350F810445,0x2EE468445FE4215A,0xDACE7F0E969ACDE4,0x3708F4F4C754DFF6,0xA510303F6C0370AB,0x9D5CAC3AB4ADC2FE,0xF33D4A2B395A765B,0x437BFDCA1856E0C8,0x00000000000000C5 },
    { 0x287DC7F70812A78C,0x30CB0CD905DC3FCD,0x80343B51008EC68B,0xBB3DA3A5CC404F65,0xD5276AF593D9F303,0x85A875D47DAA5950,0x5BAAE52F078E6556,0xDDD9E3EFE58A4E97,0x00000000000001C5 }
  },
  { /* Point #4 */
    { 0xA3FF48A37252EBA7,0xFE771FD391359DAE,0x9DDA3A45D05BE01F,0x5CFA713DE97A9A89,0x5FD23BD887CB6C64,0xBE45C0758D9AE4BB,0x90F9438478E27270,0x3E1B0D18F0DBDDD9,0x0000000000000018 },
    { 0x6E5283F7F2FB7FAC,0x232E9CD13593D0E4,0x97418D9CEE81F08C,0x339540F51F2E8DC0,0xEAACB20B619B5EE8,0xEFC8079A4AE00660,0xA968FB1C765802B5,0x60088783F20650FA,0x0000000000000145 }
  },
  { /* Point #5 */
    { 0x322EFE142A7CBE50,0xAF425A7DB2F85051,0xCC7C9D91812B26A2,0xD89FD04968066E44,0x79BA895FEC83B2F1,0x570C2DB410E90A64,0xE00F1AE889C59658,0xD94F065C78EDD742,0x0000000000000021 },
    { 0x3FA27BD8C5B5B0BD,0x432599D6A5121DE7,0x528925DA2E8294CF,0x28C15142CF0F9464,0x38498320A6FA7F3C,0x92CDE9B1BA93F4B8,0xEFE2455E4BB98CAC,0xE0CC0EF1D1B0E59C,0x00000000000000D6 }
  },
  { /* Point #6 */
    { 0xC538D35074A00EFD,0x4776AD9697BC3AC7,0x22041B531867F889,0x2AA3594319CBF055,0xF00A49D00C38F064,0xCF40E6177BD0991F,0xA59DF69B0155FFAF,0x1F2D50FEACE4AA07,0x00000000000001E4 },
    { 0xF1A777EE5CCE1B0D,0xFB8A0AB09C7AD9AA,0xC0D3B78058A6AFF6,0xA9F4B3A3370AF1D6,0x3A0731A53D39D147,0xF7AA9DF732C93FA5,0xD9A0599F9C938C2D,0x2702735D01B0C0D0,0x0000000000000152 }
  },
  { /* Point #7 */
    { 0x64F62DCBA1D24F4B,0x134DA7C1F5776EF9,0xB6699E3F534BF835,0xC9B93539EF275259,0xA9D68C870F7CF548,0x4EE54FF7FBD2D9A9,0xCAF81404465E7C2C,0xA02FCE30048CAD5D,0x00000000000000D4 },
    { 0x9CE2E24C6E76C091,0x8353D7C941EC4C75,0xE7F5BFBB43A019D0,0x74CF2BBE508E92C9,0x58F2E1B68DFCBACA,0xBE79DF8B98BDC65D,0xCEABFA1CC699DB7E,0xE237815E0E3F9421,0x0000000000000093 }
  },
  { /* Point #8 */
    { 0xCFE4F02E36E4A40D,0x3AF87A7DF2B51E5E,0x3B6BAA2683FBF682,0x9A7A9339063E5979,0x77214EBF41B680C9,0x1FBDEE591AE59F71,0x9A4DD12EE1530C0A,0xE113839691FE54B0,0x00000000000000BA },
    { 0xF84D66EBFC229914,0xFCC47954452DA1C3,0xE662B9C06F9743C5,0xD0DB646D087D7194,0x2ABC096B6E1BBF6F,0x24272840331F3A96,0x0DA86EA2A6B9F40D,0xEDB363317DCB4554,0x00000000000000D5 }
  },
  { /* Point #9 */
    { 0x35CA7B714DA6061A,0xA9BF19F0003E19C8,0x1298C7034C3C37F1,0xEF43FC92921F123D,0x065E9CB5CF8ACDBB,0xAF1392DF0A25165F,0x2174CEEA344D3FC5,0xEBFE81C529D22225,0x00000000000000D6 },
    { 0x0FD8FDF2BFF99BA3,0x7789D27D28498D5C,0xC5D731B872535985,0x4DAC761544E0EC8D,0x1997B34953628596,0xDA8F1B453DF08420,0x2CF56FDCE0DF23FD,0x3C9A7005F2C7864D,0x000000000000019D }
  },
  { /* Point #10 */
    { 0x5C1C16872C1E8DE6,0xD70EC472B1C70780,0xEB11585EC5B43635,0x943929D2FE1004B8,0xEFEC44E1735D06BE,0x22380D73C2F367DB,0xCF498E0D550F497B,0xB9D7707958DA0A67,0x00000000000001CB },
    { 0x4A86DA6A6139E58A,0x59828182EBA6EE4C,0x117EA761D5B978B9,0x6E5C95FB421C7B72,0xCB8AB1E8B9DA6233,0x8A99B06F696C2A02,0x128544479166802E,0x66C2C35CF1AA2CCC,0x0000000000000120 }
  },
  { /* Point #11 */
    { 0xD558D1C2D75DD2D2,0x835A529183C47104,0xBE1680CBD6A8D82E,0xF1ED775571B65F2D,0x375AC4137EDD4AA0,0xCA2BF9C9863979E3,0x8B2D261EB6A3F48C,0xE3FA313D74FD8349,0x000000000000001C },
    { 0x0B8664383E70DD66,0x6A5FB43B15CEF5DC,0x83A0FE8CF8871F0C,0xB879A0E6848F9812,0xF93CE978F35CA817,0x74643F68687D2A6D,0xB9E7BA00C6DF8A5F,0x151A645AFDD5D515,0x00000000000000C6 }
  },
  { /* Point #12 */
    { 0xAF39CF7917F8115E,0x538D81C5B1E2E5C2,0x6D3A29B22661D6E6,0xBF9AB97716F4F3D1,0x1FF2E621C84D4F92,0x985DFF6BDB14F203,0x24559C328F4F0E0B,0x960527201A1E7A96,0x00000000000000FE },
    { 0x398CC66A79786D47,0x009BC173B2B9653F,0x295B412ED23322BE,0xAA78B521FFE060A9,0x5FF5A5FEB808D2B8,0xE84AF56C3182E463,0x94972AB444022236,0xA17D7B55DE52F2BA,0x000000000000014F }
  },
  { /* Point #13 */
    { 0x8C90E71ABE54C3A6,0x449B10EAF71C5359,0xEEA87DFD829FA44E,0xD8353EF02CA80E90,0xAA71620CD1229447,0xB0445EF2D4344CAE,0x2792EBB0451CE474,0x3581DEEDC2907707,0x0000000000000199 },
    { 0x39EBEF0294ADEFA4,0xC44FB92C3AC01CA7,0x4DF141E2C456C3CA,0x20AED69B471DBF3C,0xB31DB16CE85B7CE0,0xC239E7166911A4FC,0x3D8C230321F7392E,0x98F6F7E6E19B03EB,0x0000000000000142 }
  },
  { /* Point #14 */
    { 0xF3D8F02C9371D8CC,0x034277222083BC29,0x1BC1A1A2E0A508D0,0x75402B4365386B1D,0x7832C7A2A81EA689,0x30FDF8D8D3C43E8D,0x11AF93DA8BDABE83,0x1FC117F8DF22B64F,0x0000000000000015 },
    { 0x266747CEAACA36F0,0xA3B4BACFB8EB0F62,0x60B72B71577519E7,0x689653954BDDED3A,0x0366164AAB2FF463,0x5615191444C3432B,0x2040ED772700D67B,0xF6B08AC8CFF9E250,0x00000000000001C8 }
  },
  { /* Point #15 */
    { 0xB8E81A2DDDB4EB9E,0x89F9C08F3947B43A,0x69D84B2BB0E758A3,0x862F559972BC3E5F,0xE9C567914AC68EAB,0x8D66059F8912BD54,0xA386E77FEE35A78C,0xA434E2E64303B216,0x0000000000000165 },
    { 0x545F743413593D90,0x745C910055BBCB3F,0x45E63824BB344485,0xC26C34DD38C0F16B,0x55C10ECDDF952E71,0x60C4A2E598FD979A,0x5FF003EFA6FF9EF9,0xDFB5FCE95E578209,0x0000000000000077 }
  }
 },
 { /* Table #64 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xA87650D1EAFFD713,0xEC781C97A797AD44,0x1E94ACCDB4BCAC17,0x2284F96FB3981CC9,0xB8B2EF57091634EB,0x4ACCF5E8CAD053D0,0x0ECA4F9B5D1EF480,0x1598EF27D6E76957,0x0000000000000131 },
    { 0x7CBC9061B72D8840,0xE611924D86A5BA36,0xE02E9CA8E066D292,0xDB092F52A68A0466,0xF5D97F5D0C0B18F8,0xB5E171465C99B95C,0x1BAFBE749D3D6ACF,0x606103FEF370BD5F,0x000000000000013B }
  },
  { /* Point #2 */
    { 0x272EC59646E69DAF,0x348D7ACD79B09A47,0x8731070BD806F931,0xE1191599011D80CA,0xD001CED01B8CD947,0x31DD3C9878A6654E,0xDE8DBD0CC6409599,0xB8939D44691B6141,0x000000000000017A },
    { 0x146FDD629C45660B,0xEB9A13D3A6283D26,0xB99E7E66C9E2A86B,0x926EE0ABE626A5EA,0xF01EC218E8A93DED,0x8562B91A040FB497,0x25FA595F6DDD2F63,0x9389FFFCA2612413,0x00000000000000D2 }
  },
  { /* Point #3 */
    { 0xC65023DB6599420C,0xD5F259932DE4F201,0xDF04EB7F325DB6DE,0xBA7A4C67088C5B7B,0x4288030314FFF349,0x5D8C5AC1CED29B1C,0xBA44893AA9D0FF4F,0xC94974BAED3F3117,0x000000000000010F },
    { 0xD804DAFCFFE235F6,0x1701E38D67C31EFD,0xD6B499096B9307C1,0xF33C74961FA96EBA,0xFAB4F9F892099D0B,0x3CC5ED866D5334F5,0x41745249C94E6D74,0x27EF9399DD4B2B7C,0x000000000000018F }
  },
  { /* Point #4 */
    { 0xD1A48C6847EDD0E3,0xFEFB60BE253C6BB5,0x7265EBB75AB3E95D,0xC8D1B679F058192C,0xCDC478D6FA21C3EB,0xDF6360DC10B2B221,0x824B28A71101D18E,0x4BC043F1E04269D1,0x0000000000000032 },
    { 0xA342984E5D49E112,0x981AC5544E80CD3B,0x489EDE322C45F14D,0xB97B3BA50671C724,0x3818C351BAE2CD87,0xF3719C9261521947,0xB9116ED9A8252D72,0x992761ED9C406F54,0x0000000000000141 }
  },
  { /* Point #5 */
    { 0x9B27FAE41FFEBCA8,0xE9F906D8C5C859D5,0xA3B727FF36E50ADE,0x95307CF6D7685714,0xDDC0DF1FB12746CD,0x4612849238D91211,0x09CB00C71D3EC9C2,0x45BCC736556AEC93,0x0000000000000147 },
    { 0x08CAAAF73B06B817,0x7664BB136F0EF309,0x6AE38711F9D1878D,0x30BE2E46F8BE5C1F,0x6158AE6F79E9064E,0x52E5CBE06FBEDEA7,0x0B8F64E76DEF5C69,0x6AEA5E7CD1F043ED,0x00000000000000B6 }
  },
  { /* Point #6 */
    { 0x8A651D57ECC0A759,0x3FB5FEA90C397ADB,0x9F04790AAB6247D5,0xB1269A13C823801D,0x19D61215D2F4034B,0x8814EB23B579382E,0x0C2023B1EEA3E4E7,0x5D6F03752B5E1EA5,0x0000000000000195 },
    { 0x26176EF3BC9FBC6A,0x88AF6C5D636333E0,0x90F1A752BC520078,0x9D7FDD8353B93FE0,0x54FA1A12F4CA8BC0,0xB899D0CE78F683EB,0xBA2E014CF129CC78,0x268CC1D73620B670,0x00000000000000AF }
  },
  { /* Point #7 */
    { 0x30FF765E6939F7CC,0x6B45FE45E29539FA,0x9BEE02F03DE8DEFF,0x5CFB4D5B422BB010,0x864E6A6F66C50B56,0x2B36BAEF3CB97C42,0x5A2FDF30F6376684,0x5FBF2F7AB8064230,0x000000000000011B },
    { 0x6394407D208CCE19,0x0FBE4793F4A37C9E,0x635DC6AA602CFFDB,0x914F6669ACE2DAF5,0xD66F7167F042C02D,0xFE264CEFDC027BE7,0xA345D34AF4742027,0x2E4E575706F4FDAF,0x000000000000005D }
  },
  { /* Point #8 */
    { 0xDFBFA8C0B9F59031,0x683DF70BA5E17023,0x07958FDC42CE28B7,0xB8965B5BC6D4DC78,0x78441B9A6E4B4290,0x3909E659EA4B4AA1,0x9C8F59C629B6CD62,0xF400A01919A026CC,0x00000000000000CF },
    { 0x09844EDEF77FA34F,0x9DA8CDC495B4ACFA,0x5BB762074D52835B,0xC39505E29C0584E1,0x4C9A0F296C4F318E,0xDD1A8F417D87F206,0x423805CD95EC312C,0x21639F519304343E,0x0000000000000092 }
  },
  { /* Point #9 */
    { 0xBCCB3642E63F4E7F,0x9F343A94869F7099,0xB8B3BC4C42EEE4DB,0x8E1D8586F998F8A2,0x3615405626725E25,0x26652CA7D81D7899,0xFDDC91CC67B9D205,0x2059B0D0CE8CFD5F,0x0000000000000047 },
    { 0x107BAE471440B4F2,0x378189E064D7607F,0x73CA91AE470A1059,0x6AB675EB4D456089,0x306DA7F0E0656F05,0x804F3BAA1C3A4646,0x80511053D00A652F,0x4F67841B9F4D092A,0x0000000000000026 }
  },
  { /* Point #10 */
    { 0xA90279B48FF8817F,0xAA8132CCA742B57B,0x622C4D269BD3A106,0x137FEC7B5AB20AB2,0x358C7F9B5803D2FB,0x5CBD86972C87EF25,0x8EDF00006B75C40D,0xFE5BAF32FDDF897C,0x0000000000000165 },
    { 0x28CA46E7474414C4,0x51B4D70F298A96C7,0xBA588C9835C2EAAA,0x2090074EE9028157,0x485F1A4A12406DF0,0xF20593D090116194,0x74B788727775A186,0x48D363CD1DAB24A5,0x00000000000000BF }
  },
  { /* Point #11 */
    { 0x5DBBFC3F28CE39C2,0xCE5D984AE41302BB,0x060CC0045F62ACAC,0x41AD7D60F7D432EC,0x4EB69079291D987A,0xFAA4D061EC28F5D4,0xDA420113AE9A0DDF,0xCB2031CBF74E0364,0x0000000000000026 },
    { 0x9B26F39ADB64B474,0x2B9AC46440E04631,0x7D2C268E37FFC8B9,0x6368B04B3C25399A,0xFBE401E47630B55A,0x984F0D31419BC5DF,0x37F4A02E83C0B5C8,0x25BE36E04EDFB554,0x00000000000000C0 }
  },
  { /* Point #12 */
    { 0x4FC2340E25A5AB18,0x7551875314FCD1EA,0x23DE1D53195FC964,0x5DAED4D333ED5A0F,0x4DF242D0BFDEDBDE,0x8BAF2E0BED20BF03,0xC3746A4EBCF8A937,0xB2647E888370DC80,0x00000000000001D9 },
    { 0xEAF2B26C2BEFD1FA,0xA49D4165175F9E61,0x27FCE4DED2DAE43E,0xCE810B6686666132,0x86E66075FBA0408A,0x4D3F305A1AE2C137,0x0FDF18A6290F4285,0x41B9A39C26C25A6B,0x00000000000000DF }
  },
  { /* Point #13 */
    { 0x539620B3E5DF1EE8,0x724BDDC498A4376D,0x6F6AE02933234887,0x26197D1403F46458,0x4465B0D8E404D18A,0x366E65B5611C982E,0x9A07F792660CD920,0x85AD08D64BF3E007,0x00000000000001EA },
    { 0xEACDD6BD8B2D1974,0xC37E48165879C25C,0x94009C614260BEB6,0x454401C78D22FBDE,0x97500E8974D28C0A,0xC8AC343A6510E13E,0x93A4EC07EF32B9AE,0x168AE283CD156E07,0x00000000000001B1 }
  },
  { /* Point #14 */
    { 0x9CCB4DC598AEF4A5,0x00247549FBBFD9DE,0x4A93DC3BAFD45136,0xE261A01BF3A8329F,0x056B375754199D00,0xD1765190B506667E,0x65EF05E7FD8AE2C2,0x3BDF830E4C891E54,0x000000000000008E },
    { 0x1CF81A240F6FC911,0xAECA18158587AA6A,0x192DDFB5D9082920,0xF92D07A1DBFE5910,0xAFBE7617ED639112,0x4ABC71FA54BBB81B,0xD3AE583F356FCEDC,0x0D80168A8FB77759,0x000000000000012D }
  },
  { /* Point #15 */
    { 0x4CD4406559E7D8E5,0xF4D237652FA7D08D,0x369B860B037E25D4,0xE3212A1383A2A990,0xBB1D231AE8FA5F22,0xF9F74C128A8FE4B7,0x161425D741880CC3,0xAD5CF8E526AA85A0,0x000000000000005A },
    { 0x7C5D9354DD38B2E7,0xEA7E6A9C4359B98B,0x76878D143A0549BE,0x36582001E0D25608,0xCDADE3905864C300,0x2B76E2DE64649600,0xF25C6C8773012F98,0x7B20050F2192AC32,0x00000000000001C6 }
  }
 },
 { /* Table #65 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x6D9B0C3C9185544D,0xAD21890E8DF2765F,0x47836EE3CBE030A2,0x606B9133F7651AED,0xB1A3158671C00932,0x9806A369CFE05F47,0xC2EBC613F57F3700,0x1022D6D2F065F07C,0x0000000000000109 },
    { 0xB292C583514C45ED,0x89AC5BF2947E68A1,0x633C4300AF507C14,0x943D7BA57DA4020A,0xD1E90C7AC0ED8274,0x9634868CE59426E6,0x24A6FFF2C26BC9DE,0x1A012168152416CD,0x000000000000000C }
  },
  { /* Point #2 */
    { 0xC2453D609102B570,0x70840E5C142C3E23,0x7294B1F1C30037D9,0xA2500F121DBF5AB6,0x03ECEB67C9C8EE6E,0xA19C319330820ABB,0x7AAD59E87DA6B820,0xE97823F8C38D842F,0x000000000000006D },
    { 0xCE5BB75EA7B6BB9E,0x9090358D569C9EDD,0xA8B5EC369CD0C065,0xB2B5AC1CF81C82B8,0x8FEB364C3FFCEB86,0x355ED9ECDF4F9F7E,0x6F2EFE425CE12FF4,0xB23168780155070D,0x0000000000000035 }
  },
  { /* Point #3 */
    { 0xD8BE53EB86660E96,0x72C2673C8BE7763D,0xA7C5462EC6B55BF0,0x9DEF337B574A104B,0xA8FE70AE9E9A1386,0x6070F210BD010CF1,0x5D3EDA3894AE907B,0xA69D86791BEA88CB,0x0000000000000000 },
    { 0xD1DDE97203C8DD6A,0x562332D1D8950C30,0x33BE213E5EA340F7,0xEBB49ED4EB40E91E,0xEFE4AAC270B2CA5A,0xF6AD3CC1900CEEB3,0x67E9A8816CC704D6,0xDD3F2BAF12FE8A0A,0x00000000000000BE }
  },
  { /* Point #4 */
    { 0x5F56B5A41BC0FA77,0x6CDD6BB564FD36F5,0xD0AC68B58A5B7C7F,0x4A92D9BF09919EF9,0xC305E12B71C3C520,0x554A9D1CDB699AEE,0x7FDE007761F54643,0x99C13124479115CE,0x0000000000000039 },
    { 0x25F890E1C271AC2D,0x1353CCD394B370AC,0xC7B5ADF6744D4011,0x9CCD7687BE378127,0xA8489B5C06C4E3CD,0x1945580A305505F9,0x07190A204AB3B12B,0x0FF53EB11534EA4D,0x0000000000000159 }
  },
  { /* Point #5 */
    { 0xE774EED9B1167003,0xECDE86E1932845B9,0x0381D17897A8A10D,0x995A4926AEB8BEF7,0x3EE19C812304BAE0,0x541449E3FE977E97,0xD7EF476BA517B358,0xE55330BCE0D847CB,0x0000000000000012 },
    { 0x1620A1D6F06A91D6,0x714B3502AC578BFA,0x2606EBDB6BED112D,0x8B7B271563F8E778,0x31833913651FD543,0x14929F1ADC9638FE,0x2637EC813EE709D3,0x39FAF7E705547EAA,0x000000000000009C }
  },
  { /* Point #6 */
    { 0x785E09FF6C6A364B,0xD00A50FE53E3C393,0xAD964C6E0D36FB23,0x353441FEEBADA914,0x4E16727EA5BA72FB,0x5114C6E07BDC78A4,0xCA3A8E27F38384CE,0xE48F64CC77307092,0x0000000000000089 },
    { 0xB3152778351AA439,0x0BBC970E6A2E6C8C,0xAE03DE8312CFDC8D,0x1622D6DB779C99E6,0x82D6078B59EF9E70,0x3539FFD07368486A,0xE61A3E2B083F7B1A,0xB214F0B74B874DC2,0x0000000000000155 }
  },
  { /* Point #7 */
    { 0xE77C03EED7ECB581,0xB0B4DE18CEF15BEA,0x318E5B24FA1EA3FF,0xFD1D902E710E95FD,0x8DAEDA0655CAFA30,0xCABA29BF2BD11001,0xAEC1861BD88085BD,0xFAA66562E591D19A,0x00000000000001F6 },
    { 0xEEE386F7B68C7429,0x0A876AEC502C0797,0xCB587DF8C6806FA9,0x4F7CB6DCA84DE772,0x407A1F0FF746CC93,0x7862E9BB6B953E5C,0x6C106CAA0A4C9357,0x04213043C0096E5D,0x00000000000001AB }
  },
  { /* Point #8 */
    { 0xC68052C94876BAB8,0x81F704BAF84C2E38,0x28BB9436F2CF9927,0xB89BBFA0D06C972C,0x00FE1DD8B7A78E76,0x3ADFB05AF7F1E1AA,0x45321E42B7278EEE,0x13D850E0A528EBE4,0x000000000000006F },
    { 0x6B724C681934143A,0x2F944AFDB657D809,0x38E501DFABA2FA08,0x9285ECE1BE66E568,0x7AF221F7F9DF3327,0x00B8A86FDE74AEFC,0x19D675189A992072,0x806D1C88D9DDBBB6,0x000000000000009B }
  },
  { /* Point #9 */
    { 0x2AAEA367BD35D8CB,0xF2A64BD7AE020E8F,0xD7F80264D6DC5572,0x890E23621F36C56F,0xB9DAF028A09342DD,0x6CEE1FB190BF076F,0xFAE167E70F0412CE,0x2A79D89A8A2FD483,0x00000000000000E0 },
    { 0xC222A2450849A624,0xED4033DD0082DEDA,0x11F78E31DF0DC525,0x34240B3EBB3EB85D,0x135D407DC287296A,0xC47FBFCE741FF1B3,0xE34DD021DA643502,0xF183174D65E3BA7A,0x0000000000000116 }
  },
  { /* Point #10 */
    { 0x83C6B9DED09B1B31,0xC2325238E3C06D55,0xEE4A352851DB1A32,0x69BBA3F21EDD1449,0xA445212E855C819A,0x00A83136B62B4FEF,0x1C51EB23E3EDD8BB,0xF5EBA0C09A238DCA,0x00000000000001DA },
    { 0x1223B0B5B2448058,0xB6E3AD9F699217E3,0xA7AE6434584DFE78,0xF7D3D93F5B407CBA,0x68B167AD39035117,0xB369219CFE239C88,0xF3D9BC4913BBA594,0x6123679D698E3BB5,0x0000000000000183 }
  },
  { /* Point #11 */
    { 0xFA37C4D089B3A5A0,0xA8ED9BD86065DECC,0xC5068ACFEF8CC1DF,0xEA2A71018C98A08E,0xDE77DD771B4BAEAE,0x855A8B672B794F71,0x1ACF5585CFC02477,0x1535D73CC30F94C2,0x0000000000000149 },
    { 0xC7F723EBA566C87B,0x88D22C712CD0A69D,0xD7F9318BF60C47C0,0x8D652ED79C239254,0x186AB5D6C46760CB,0xF83BB0D588E7879D,0x2976DAAC122A83B2,0xC7BC8602F240460A,0x000000000000010A }
  },
  { /* Point #12 */
    { 0x4A7ACA2F4DDE4B24,0xE56E7B54B4A15F13,0xECB9C748EB5705B0,0x675FFBC695977AA7,0xD200CC67501DCA3A,0x82B4152D3C43E1CE,0x64BE95945C124198,0xFC52E520389AA160,0x000000000000000C },
    { 0x157E8281F875201E,0xE98A64C03B179B49,0x8DF77EF0D4BCE1C6,0x8B6764909A9FD8E8,0x6D8879B8BB67721D,0x558091CC19E81BDD,0xEBACDE3FEC6E7394,0x987A87D51BC77288,0x000000000000010F }
  },
  { /* Point #13 */
    { 0x866FF3C908EA3335,0xFB58377C88D2EC52,0x5715D9E014A8829C,0x9376778B0595D929,0xC1CCD5D59B8ED6B5,0xD90D82DC00D1367F,0x15BCE4D84CD41C48,0x1144874144A2B97E,0x000000000000017F },
    { 0x0E3E35FE60AA94E0,0xAA1456964891E593,0x51EC590F402EAD1B,0x23C0996D7345D47D,0xD93E5A1A2CA244E6,0x80C00F6FDF85D7F8,0x1CA50525867D760E,0x29CF9FB20984377B,0x0000000000000196 }
  },
  { /* Point #14 */
    { 0xB95253361EA445C9,0xA8A0FE24C10DE158,0xABA4DA83211F91E9,0x307538CAF2390466,0x1E0313E0153D0062,0x8F5EE2C89FFB2A03,0x49F2777FF412EBC8,0x463F67093D268AE8,0x0000000000000057 },
    { 0x3856BEF0A32A201A,0xD240074B30514B6F,0x277C70D8A9C71D35,0xE35D68CF7AA435F7,0x8A3C9A0960681A98,0x4EF5A19A5D25E946,0xDB60E7FC4316CB53,0x2693E9A568601ECA,0x00000000000001A5 }
  },
  { /* Point #15 */
    { 0xD8BF062C1E073747,0x26C96D9FEE2E6D05,0x79D919D7890B4D75,0xB42E2BB900653FBB,0xF8987798E3CCC877,0xB47D6EB25033DE8D,0x39F94C596C5FD1A3,0xF3C0C3882FA0AB65,0x00000000000000C9 },
    { 0x9661D7F82B18B119,0x6FA045ECC4B5C3D0,0xC858DE883BCF37A2,0xD81D90FB3224D885,0xF251A9F77A8377E5,0xFEB83A50A3D8C771,0x853CFABCB5394FE7,0x950559BF67C9EBA6,0x0000000000000000 }
  }
 },
 { /* Table #66 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xEE31E71A286492AD,0x08F3DE4465F86AC4,0xE89700D4DA713CB4,0x7AD0F5E9A86B7104,0xD9A62E4F2572C161,0x77D223EF25CC1C99,0xEDFF69613B962E0C,0x818D28F381D8B205,0x000000000000008E },
    { 0x721231CF8CDF1F60,0x8B640F2B6717760F,0xBE726F8CE045A403,0x422285DC0370689F,0x7196BF8F72EA0DCB,0xA16F7855C8086623,0xD4E19FC7C326FE48,0xFDBC856E8F68BF44,0x000000000000013E }
  },
  { /* Point #2 */
    { 0x225256FDB79711E5,0xBDCF3433A6A843B7,0xBD3D4548414A71AB,0x2E13FD39E29E7606,0x194B6E92E07F29C4,0xD6F5E492B68FD0D2,0x3AC649985DE0AE9B,0x10E5AFE94E5BA961,0x00000000000001F7 },
    { 0x27DF3C4B8EC9CCFF,0xDB2913722A7B0A2B,0x1CA89222F045AFDE,0xA666763C69C99247,0xD8D9F6B199033177,0x10B696F690ECA082,0x41991D660D180F50,0x7CEE7F9B82D6F6BC,0x00000000000001DF }
  },
  { /* Point #3 */
    { 0x615D6F52B1773DFD,0x10247D0B4E0042A3,0xEBEA88D66D50EEA4,0x51FBDD41912C0AAA,0x2B4876369B0497AA,0x202D12DEAA18B8E6,0x719A9526A19B76CC,0xA91A45096A37386C,0x00000000000000BD },
    { 0xBB846181967C2E8A,0x1A547496796FED3B,0x3AE904FD34C152FA,0x185C46F821C58DAC,0x2D8F1B5CC999F2A9,0x9C99663C06C88BDD,0x417038F17DC27E48,0xFFB6343B0C025D84,0x00000000000000E6 }
  },
  { /* Point #4 */
    { 0x853233C2B24565F3,0x43478B915FBD38C5,0x962087FFD2A6992B,0x403427F45EC71EC0,0xC07276099B151A4F,0xA8BB2DC4DFA1844C,0xA20D339E101140E4,0x0DF52FBDA1C70E3B,0x000000000000002E },
    { 0xDC4129870447DE06,0x080B5DD16CD90FA6,0xCB6A6BC7C4ECDDC5,0x9462FBDA970FE140,0x4B0CDA7EA7581610,0x6437AF41DCAB0C19,0x3AB19E3F4E100705,0xF8E93A95ADC5E7FE,0x00000000000001F7 }
  },
  { /* Point #5 */
    { 0xC9E4ADA3D6057266,0xC6488350DCC7CEC8,0x2069C962BC4568E6,0x29DF0E10694DB690,0xD6985BFF5177E692,0x27983B3A08CD287F,0x4D22350E6345B7F1,0x28341DE99D0C2BF4,0x00000000000001D8 },
    { 0x70F6A7CBF30E2472,0xABADEB7B1C7EDB49,0x8A98566466CFBC6A,0x27B7657B1C912BD7,0x91BBDE9D2E9820A8,0xBD6CBBC11B43A2BE,0xC9865101D68FF203,0xDB44C847E1A9E48B,0x00000000000000BD }
  },
  { /* Point #6 */
    { 0x9FE25BDE27936D20,0x22BA274BD5EC1DA6,0xE090415A9DDA8A8C,0x89338C0EC3615980,0x7A275EBBAA3C8BE1,0xD8136F52F1CAA495,0x56FA754F3F023B63,0xB24E8E69A3EB201B,0x000000000000016C },
    { 0xC95381D47A76334E,0x3AD694D1BEBDBE06,0xC5B98168992792BC,0x1F8F7C0F06450667,0xC26A086F972A25D5,0xE0D18B92CB841FD3,0xE14A82C5A62ED510,0x8799241207A009D0,0x000000000000017C }
  },
  { /* Point #7 */
    { 0x8B24FFB53004860A,0xD400D90654D544F4,0x6B33DE80EAF7C7FD,0x830FDFEE80B37417,0xC465549DEC3016F3,0x5E944E56731EAB5F,0xBD4E24E398BBB88D,0x0EC84651EE3CC23A,0x0000000000000017 },
    { 0x1EC4CC3F41F46949,0x689A004BD1F65059,0x198E7CEE613B2A84,0x35A07118D6CABCE4,0xBD2F4B6BF0BE8230,0x6DD42C2E744E78BF,0x8EF14CB4024D8140,0x607695213126010B,0x0000000000000016 }
  },
  { /* Point #8 */
    { 0x38EE58F048E075E3,0xF285797E18D38B67,0x02E97C63A120348D,0xC64DEFA717BFF13C,0x0FD5B7237F983D56,0x70ACC4A830D1770F,0x0F0EC2D749151740,0xE99F0A612968C0DB,0x0000000000000174 },
    { 0x4A5D683A67AA8AD3,0xFA3A36CC56C69E37,0xA392130EDF8A093B,0xE80D7527C840B37C,0xA28EB4926AB73B96,0xEECE0912C7D4304C,0x0B900A1130B9DD79,0x43D757E3A20C5D55,0x000000000000018A }
  },
  { /* Point #9 */
    { 0x205EF08EB8F1A369,0xB3E91D228BE6F437,0xB52B53A7CDC36585,0xA972DDCF3A1E3DBC,0xE61A1AD41EBF3C19,0x409E4E39D97D3DD5,0x97FDE509896E267B,0xD291040DD121E069,0x000000000000015B },
    { 0xC2EF5FC558E89C28,0x2F1F738C8D9D25B1,0x5ABB99ACF8EC3234,0xDF1BD864CD690312,0x67BF5942BDB2220C,0x5890FC745614DD59,0x5846E4FAE569CF5C,0xD73F0FCF2C535C2B,0x0000000000000191 }
  },
  { /* Point #10 */
    { 0xC7155BD663561CD8,0x0D121379A87E5C03,0x6580E4FF321831B4,0xF7FF11505FE4413F,0x855FB10264F512EA,0x40F3683A74224C51,0xAFB6712AD0AEE618,0x5AECB1C314317752,0x0000000000000098 },
    { 0x9C6A7CA7FCCE068B,0x64A3817C4412DA85,0x5E2F8AC03A67DA94,0x96830BFC59197955,0x4651B848552B027A,0x7E888578F3AF1566,0xC510A7420791EA07,0x1CA929F36C2618C9,0x00000000000001D7 }
  },
  { /* Point #11 */
    { 0xEF66EDE3D6078A87,0x4D3351FE82DC8DB9,0x46D5CFEEA8F49720,0xF96768F76CF805FD,0x151386EC9CD89717,0x615C4E044C34698B,0xA8CA749B88BEA055,0x4AE7493DD3E29B1E,0x00000000000000FA },
    { 0x99534B360FEF8E10,0x9175AF31F2A5E723,0x64104C36CE01F193,0x8B4D3BE60C708522,0x025702FA91B8A738,0xF8FC91C95D20E200,0x7A88F4589981D22F,0xCE4F31DF319B3D09,0x000000000000018E }
  },
  { /* Point #12 */
    { 0xDBC8E45F29056168,0xB1789B8F8AA24063,0x8E394EC4E8AF7801,0x451958953E6DACB8,0x42E76886D8E18229,0xE9BE1E0238912E71,0xF4CC3BBBC793AF2D,0xA7DC4D1BB6EF26B0,0x000000000000011E },
    { 0x0255437C02ADBC28,0xAD007FD57F4098D0,0x5B827C408ECBF87D,0xB9ACB85CBF9B34EC,0x6D45AE094A85C2B6,0xEE94E87B95BD71AD,0xA7F0F61B420C1EAF,0x8F39C45C8F1291D2,0x00000000000000C0 }
  },
  { /* Point #13 */
    { 0xF047E88725735327,0x669672060DF0EBFF,0x007F523AC9697E6A,0x0714166C8218B455,0x70346F06CDA64495,0x2F04AE2828C121A4,0xD1AE7709DA6B6EB2,0x44754972EEB4F704,0x0000000000000107 },
    { 0xEA066B58116FF4B6,0xC530E8BA8F7258CD,0x95805AA0FE9CC8EE,0x1D171FAFAC4A044B,0x8D15C8329586171D,0x4BF3C652672E59D2,0xA28A3A259B4BA05C,0xD4BEDB84568FBF88,0x0000000000000170 }
  },
  { /* Point #14 */
    { 0xD73D58C7D1F0A864,0x289DF473E8C8666B,0xFE2C0D90D10E09E9,0x62CE11FD54E30D23,0x761E4B524C0B9932,0x0B318844A55FFC7F,0x9269E3976C955552,0x151BEC774FC48966,0x00000000000001B0 },
    { 0x2FCAE190296D60EC,0xF8E75ED30CDEFBCD,0x69E50763E1EF44C7,0x7B22162EA67C5F6C,0x9B111FC2F7B75A84,0x8DF1E8EF1B5825F7,0xA9AC4DF617DE1298,0x57B5629F9BF2FEE5,0x00000000000000E4 }
  },
  { /* Point #15 */
    { 0x82627C91B05AE955,0x7D170FE6826A1B43,0x0DA74DA23F32FCED,0x71A23910F683E531,0x8867FF76281A3B76,0x972F75E5ADC2BAD9,0x5634AE7771AA96F9,0x2EDD8B086C50328A,0x0000000000000011 },
    { 0x4DF0DCEA85353D21,0x666ACBF56BB6AF00,0xBACDFFA057B17928,0xD1216436A6A5A474,0xC4D05FDC9A3AFD1F,0xB9031B05631F8B1B,0x01721DFD59FC2D69,0xB6999C22EAFEE783,0x00000000000001F0 }
  }
 },
 { /* Table #67 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x56F74E6985EDC827,0xAFE2EF0A6A731640,0x61F8BCFDD51647D7,0xBEABBB8F41E33FA7,0x3E4C3AAEEC83C547,0x48A9D1E92CC8DD97,0x7B4D53B5E57D3822,0x92387AC8A45C0584,0x00000000000000D5 },
    { 0x802ECE3DFACDB1CB,0x9E4F5D209E537236,0xD10ACC25386A5610,0x53F55D464C6C0247,0x390FE9808C419FA4,0x8B0A8AA6BED2BD92,0x90E7F479F854424F,0xD714BFB59E7F4392,0x0000000000000074 }
  },
  { /* Point #2 */
    { 0x9ABF4318E7C8E1A2,0x89FD5C8D5EF038D0,0x20641C7C755BE1D6,0xFFF489FB38B2C08C,0x792104E1B3B3A7B1,0xD8A69114C507E7D7,0x4C07F5BAC1AC93F9,0x0A2E3D13315C3A89,0x000000000000012C },
    { 0x016026BED523D79C,0xD4E3D86F00EE5640,0x07627A1CA8E8F5CF,0xC07C67F8533AFEDE,0x081A516DD3BED1AC,0xDDC6F44086E8FF0C,0x4DF71BC8C112D075,0x2B8CC08F7CC49D32,0x00000000000001D0 }
  },
  { /* Point #3 */
    { 0x74AF3F63EDFCBEDE,0x6B0830B11356F827,0x060DB15A02536F8A,0x166F9099F7095358,0xD759EFB4E03B9601,0x05A4E29768484F67,0x469B4832DC631A7A,0x7C5406150BB2B1B6,0x00000000000001B2 },
    { 0x590174E012481C04,0x8D4EF6C7D7180A84,0xD134B543303674DD,0x60DBF72600C378B0,0xC60E026A93D8406C,0x57AF4A82082C527C,0xE3D038FE349A607F,0xA7CB9B475A3582E5,0x00000000000000C6 }
  },
  { /* Point #4 */
    { 0x69017ED5F1C86157,0x8AD717EB3AABCCA4,0xE14DD980E57AC297,0xC2F0DA4B931E307B,0xDE7FD5799080B37D,0x45BF6F6414134DE4,0x5CDE0727AC019CF3,0xB4E5C2E7863E739E,0x00000000000000E6 },
    { 0x094E085628E15F36,0xF92C44FB46276090,0x9219998521CB21CC,0xCEDCD4F2DE53957D,0x802C6F95B6C417EB,0x0EA41A2B6075E71D,0x194D6FB1B9EEC681,0x8E7CD41F2E0320D8,0x00000000000001CA }
  },
  { /* Point #5 */
    { 0x5466A9901FE423C0,0x59F6A48BA57E7875,0x09A9F84ACB7BD46A,0xB5AE0D9469E02DF0,0xAECC3392D9FEC11C,0xC94DE920A4BCD130,0xFB5B36F882C78F1B,0x32AD1CF22D4FC970,0x00000000000001FB },
    { 0x8CD894D5DF0A2534,0xCB83665C9735FC04,0xCBD9157635169F6F,0x2F3B64A72775C9D4,0x80C9608FDD6410D3,0x6503BADCBCAD20D5,0xBDB308571B2B1640,0x92338C7878FBC82A,0x00000000000000D6 }
  },
  { /* Point #6 */
    { 0x3F99E9B3EE05CAE4,0x32CC71107FA0E686,0xFEFE300A1EF8A5C1,0x232D446E86846634,0x250F4E801CE3E75D,0xCA3146F236BAE498,0x41B28B529339513F,0xF05D31B6623CACB0,0x0000000000000066 },
    { 0x12B4C656682F53C8,0xC865FA0EF72ED178,0x7D41FFBC55F68DBB,0xE4AA53B7C0AC64AA,0x66E397BBB7194380,0xBA629DB6834331F9,0x6D14E879EA0C0083,0xDF2E7EB0039343FC,0x00000000000000D6 }
  },
  { /* Point #7 */
    { 0x3EE61D53E8A300EC,0x65E529C7E0CD8617,0xB8C03CB0077B303B,0x05EBA936D5C88DD2,0xC1E54497D42BB4AF,0xAB477AAFB0589057,0x55ACDDC8E8F70A56,0x6579B78B4FC80182,0x0000000000000164 },
    { 0x535E7FF0BC97C72E,0x65E954C9809DC093,0x49EDC4B8CD182EE3,0x804874F9877D38AD,0x20104AB16DF1638D,0x78459A4B748EE6F2,0xB895205D3504AA35,0xBF26AC8AF8089E32,0x0000000000000041 }
  },
  { /* Point #8 */
    { 0x3DFF858061E5AA9E,0xA33AEF70955100C9,0x7A52DA3956AB4275,0xEFE16518102C4123,0x8FAEB0188D2E4D91,0x3516243081719F70,0x4EF1FB91FA78398B,0x95EB0D18C351721C,0x00000000000000DF },
    { 0x90C4D877E5F04C88,0xE108471ABF176E9F,0x8EFD42750EF8E8FB,0xADB1FC8E3B26BA83,0x35050FD319BCB6AA,0x00A7180D1E9A804F,0x23AE97B660B511C8,0x07D0BE62403CEF81,0x00000000000001B3 }
  },
  { /* Point #9 */
    { 0xD877404A6FC3E4D4,0x90F4424143959C60,0xB11BC0DFADD26AA4,0x45C833FE8773BDDE,0x26E39709CA264F8D,0xCC87592446314F2A,0xD9DEF19853DDF49A,0xCD60DE6495742A00,0x00000000000000BB },
    { 0x5CB1207487D742A0,0x41DDAA31655AFE45,0x69765BA5A54ECE2C,0x575D21810B4B57B8,0x8540DE4BFDEC936B,0x2D73CCBA13C17184,0xDEBA26F2A345FE93,0xF9A8115844FC190C,0x00000000000000E6 }
  },
  { /* Point #10 */
    { 0xDD8026EA8D40A41F,0xB0E2795C8F0752E0,0x6F120A8D5E6D1F7E,0x0AA99441ABAF2381,0xA60677641815FCF4,0xFA43027BFE2668E2,0x74557A4F87D678A7,0x5C068D13C6096024,0x0000000000000053 },
    { 0x0CE11532BFD0F624,0xCE62D3A67E476A2A,0x467AE9F11667B2B7,0xC418D77F4E4EA4BB,0xB96C33825132FF6D,0xCA75D16C5FDB9483,0x24CF4DF2D08F6F87,0x70388217EFF3B645,0x0000000000000106 }
  },
  { /* Point #11 */
    { 0xF04691638D0BC669,0x62B84488E939F5A9,0x0D3F495380FE63B5,0xE39A7AA158880C15,0x74DF281EE613F21D,0x908934DCFA016692,0x5B9CF6CC980904B0,0x0F3AA0F43A17DD3A,0x0000000000000105 },
    { 0x346BD219651D59E1,0x51024297C71B37BF,0xC634D031F0640F18,0xA657DA60FF003294,0x9CFC79FC15AABD29,0x56807DD77B4A869F,0xCD97CD8959D9033C,0x58640103A3233C39,0x0000000000000090 }
  },
  { /* Point #12 */
    { 0x79BA87BAF1C9C2EC,0x0E53555266AAB703,0x31D1D9712C990B59,0x1E0B5D0E12C6B29E,0x014D53FF563BCAB0,0x425986F2F64309D0,0x475FC9D5318B9D6C,0x02739C50FF59E392,0x00000000000001B2 },
    { 0x8BF58DFC16F1CACC,0x1C93BA4E6B08CE06,0x79B5E0399FE18430,0xC9F67BD47DE66325,0x5DEF2733713D0FEF,0x31BD8B37B9945412,0x8B2B69F3F3B99628,0xF08A7E5A3118CE62,0x00000000000000D4 }
  },
  { /* Point #13 */
    { 0xFEA0D82EC8A4656D,0x0FA181B503D94A84,0x3666BFD2F8B5C4F4,0x4E246013619D399C,0xEA46DFC9C11C1CE3,0xDFB408AA10AF3583,0x94FCE3F2785D7D61,0x3244F6181FEFF091,0x00000000000001B8 },
    { 0x939D98F4ADD4F84A,0x4C2E3D15E9D04356,0x08529C57C5D1729D,0x4966BF7709597836,0x03B9958CF4B32760,0x2E7213B46A9536D0,0x455CEB5984FAA490,0x7D83E2F5146ED682,0x0000000000000004 }
  },
  { /* Point #14 */
    { 0x984D21E6B92A02BE,0xF2BBA82C09F08A26,0x9C4259D1909FBA26,0xA36BCD437030F0A5,0xF6C218E468AE6F05,0x199A1EF30ED869F9,0x803860FF417E95FA,0xBD6BB9B4F29F7C84,0x0000000000000130 },
    { 0x5FD4E3B2D4E924D1,0x388D2E0A9B2814D5,0x8E4696653E9B1AEC,0xE24A5CFE9A8320A8,0xFFD986E2A83ED877,0x8499105D9C00FBC3,0xC6B2171F73F5DEAE,0xF1432D70F9D058F7,0x00000000000001E3 }
  },
  { /* Point #15 */
    { 0x8626CBA3CD27FF10,0x5F83C650DC15323D,0x370D973042CC94E3,0x06EBD6EFDB164003,0xCDA6F2D782850E4B,0x74E500EF17A82FCB,0xDDAB08DBB228248B,0x56E403D5870A453E,0x0000000000000083 },
    { 0x507272FC79DCFE50,0x25EE735DB3D2BA34,0x92386ED3FC3349EE,0xB0A88DE8F9EBDEB6,0xF1EF010CDD93ABF9,0xEAD25256A0838914,0xCE2ACBC0D54B6544,0xBC78CE9A7C94CE27,0x00000000000000D9 }
  }
 },
 { /* Table #68 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x0E13C1DDCECDF0DC,0xACD530B6EEB9AA6C,0xBE3C0FC80AF8D3A8,0xEE67F380CE44AE8B,0x9ADC56363854B528,0x527F7F90130F4497,0xEE085713E80C35CE,0x29BC4B3E190FAE23,0x0000000000000064 },
    { 0x17EA6FB5DBB3838A,0x192ECA92B425AF89,0x5FD3BFCF85A94659,0x8D75B3F5DAA4B4CC,0xBACC18B89BEE144F,0x57591774FF60EC49,0x319CBA952363AC43,0x6C0D079E472EE36C,0x00000000000000F0 }
  },
  { /* Point #2 */
    { 0x28CD16CE7333EEA3,0x601AB611845655FC,0xF18179D957ED4BF8,0xA704B004172167C2,0xE22EC70382E3FCF3,0x4CD9BD0DE64C4745,0xD1EB58DFEC9737E7,0x540C29E8E6658AAC,0x0000000000000124 },
    { 0x4F35D47D4B18BB58,0x3EE2A66AD4BE21BC,0x9D3D69A1052B60FD,0x556347EF8F07EB0D,0x66014006165AF89B,0x808EB84331E62CC0,0xFD119574309553A1,0x4945B9CD7656234D,0x0000000000000060 }
  },
  { /* Point #3 */
    { 0x580EC898A5D3A5D9,0x0E28A4109B2E3634,0x102192B601745208,0x4D825DC6F59C2C84,0xD2B9B7F67668CB0E,0xF05D43BB71E242ED,0x23F73DC24CCA8CB4,0x7234064EC7CB313D,0x00000000000000E9 },
    { 0xF4B4B5603A3635BC,0xFEC87A30D9802D9B,0x9C4D252A3E418320,0xC8C7B6932EB17033,0xC0AA375C2E742B43,0xB69BD932C02C9434,0x9D910EB8B6A13B4F,0x5B554917E6C4A9B3,0x0000000000000030 }
  },
  { /* Point #4 */
    { 0x05BFABADB30C227F,0x163A01129CA0D9F2,0x448F630B4A448FFA,0x7A304FDCF52D44F0,0x4CEB9902F50356E7,0xE7615AB1C43B436B,0x9FD56374D63F192D,0x38470C8F418BD616,0x00000000000000D1 },
    { 0x4B42C1459554D529,0x5556CF8B2BFE7BC9,0xE28B6F8994EB909C,0xC00748EE637DCAAB,0xF71E0FCFFC076BF8,0x57642F92B580D617,0x755FDF2E1D91F20C,0x9C3C9C86DD5AB14E,0x0000000000000187 }
  },
  { /* Point #5 */
    { 0x36E215CDC9C4F27A,0xC5D2E709651A2560,0xD4A5BD4FEF794A32,0xB1771BA6AA33F31C,0xF4C791A4057DA3E5,0x3547E13D90EC819A,0x2E6971EFD10059E2,0xF19C250C7804F13A,0x0000000000000048 },
    { 0x968A695D113453AA,0xB904A5B50CC6EE85,0x272F50FEABDC4582,0x7B14D09C556B5A9F,0x2ED5EF74C7FE5D92,0x3C32A9E1FCD4A5C5,0xAC5F1B7BDFFFF064,0xA28FA36167BA52AE,0x0000000000000056 }
  },
  { /* Point #6 */
    { 0x8DFA447387950112,0xD032940AE8D5C1AA,0xEB909E673379771D,0xE780D40DA336A4F3,0x318E1A69CE022106,0x36B6B1748702E3C8,0x327E8DB4F8E60CED,0x9C1A790B8380C97E,0x000000000000008F },
    { 0x8EEC3CAAC6534A9A,0x650FA0D556CFDCF4,0xFE45E2CE58C3798C,0x320FAC25A60E6872,0xB399EC98EF983104,0x133C9F01BE57C16E,0x9736E7543B73B0A7,0x12C0CE90B48F9618,0x0000000000000155 }
  },
  { /* Point #7 */
    { 0x32187B6A6F0C982D,0x811425B32106BDC5,0xF2636CA0878BF63A,0xA42B14363C1696BF,0x0BB7145853EE54C8,0x2C43B3AC37C638B3,0x9A404C2EF4464091,0x7CDB0CD27509002E,0x00000000000001FE },
    { 0xD333DB10EA37A696,0xAC1F2FE8D5914E15,0x91744924522FCB80,0x186A055117E64A4B,0x51DCD48B174E2689,0x84AE67EC0F429C85,0xACD5C1C5BA520A90,0x3065452220138359,0x00000000000000A5 }
  },
  { /* Point #8 */
    { 0x2FF940BFA7C8FC21,0x9B3CBEEEA6A86C6B,0x5CD96C7D171573A2,0x49BB08E812CB3013,0xDDBA493E34B92D91,0xA56F49A5EF35E196,0x7A454C1C2CDCA6C3,0xB9C038AE684D25FC,0x00000000000001B7 },
    { 0x15ADC72DAF46C7EE,0x21450DB25EAF9891,0x115517E153A32B0A,0x5BD9D862E26D8171,0x991737BF3F8E37E8,0xCBB33580531A836D,0x96AFF0213D976493,0x9BE26568CA69B662,0x00000000000000BE }
  },
  { /* Point #9 */
    { 0x29920BF927A6345F,0xAE5023A577EB6A61,0x8BBB5093D36668B6,0xC7A5AFE26A733464,0xF250D1B4E2C46522,0xAB651BB7C5179D99,0x9807A5E270F5DABF,0x6DF70B5DA7DAB4FA,0x0000000000000092 },
    { 0xD8EE9B9116CF86FD,0xB0B2A36B413B0347,0xD11626603785AF26,0x5251232FE4EF883A,0xA59FD0A5ABAC1CDB,0xD91DE87B5EC3D940,0x363280FDBA259322,0xA978D347F5B8DC29,0x000000000000007E }
  },
  { /* Point #10 */
    { 0x32D089EDECFA97E6,0x9BF82C96B9F080C2,0xF1798CD9AF6BF9AE,0xA111BD63CC9B8764,0x9D1AEBB4295A4931,0x37F6C9AC32442DC0,0x3785C17E6D6B2B32,0xAE63AEA3CCBAA5AD,0x00000000000000E9 },
    { 0xC2207AA55718E310,0x5AAEDE6C9004A15F,0x07E98D521A4B7F1B,0x351ECA4DF3F71723,0x0026164672A30C08,0x838F24ECF46357D8,0xA8278E1A05348650,0x402EE68E10EC3795,0x00000000000001E9 }
  },
  { /* Point #11 */
    { 0x427CB3882A1C55FE,0x32426A7074205929,0x356B11286A92AE9B,0x8E9DF66AF3BB8831,0x95343409CDE8F7E1,0x4DA5C2563869398E,0x545E620FBE3CD9C5,0x611D5000D031D95B,0x0000000000000015 },
    { 0x7476A724D0DB8A71,0x97D25FA19F662806,0x4AB9F2F279E1D45F,0xC001E37CC09EB8A4,0xF4A49CCF1CFE8D8C,0x447030FDEA24B1E1,0x595DA6BFE6BC349C,0x6B8FD85DA7FBD189,0x0000000000000076 }
  },
  { /* Point #12 */
    { 0x91955973E33296FC,0x83DC2CEA4212671B,0x59B7959A3EF3D3DD,0xAD706C14147B4051,0xFF0E938E46217BE6,0x3550F6BA963236AF,0x26A254A435DE4D64,0x829799EBD3FB0643,0x0000000000000194 },
    { 0x30DCBCCB348F4E93,0x1211C003AAA258AC,0x9D8500D9383698A3,0xC2C4310A530725FA,0x6F60E024D88235FE,0x1BCDBCA5715C563A,0x2100B4B2000501C5,0x9F483A0505C8BF39,0x00000000000001F5 }
  },
  { /* Point #13 */
    { 0x94A38EAC728923F7,0x5D1B8C067C3F0E36,0x6EE038B78D2127AB,0x8EF3ADED39933512,0x000A74D1F3C78C96,0x0D340BCD83F9CB7B,0x6E4E43B061488B29,0xA660C17BF6A0519D,0x0000000000000045 },
    { 0x85F9E1AB7775DA65,0xE07A43148256CD67,0x766950D1F8668846,0x296D0B2D92C04DA4,0x9E095B3017821662,0x4D561A204C925EA3,0x71F2C85EFD8D351C,0x56B110DB03134EBE,0x000000000000007A }
  },
  { /* Point #14 */
    { 0x618D04F0001B7109,0xC5CBEFA8A94E8A9C,0xD5F0E7B20AED80F2,0x9C876050CD2E2661,0x18A046BBE3F15E9B,0x3568D9E165664A6B,0x8EF9C3B4B0B7229E,0xA779B68D66DDE1EE,0x00000000000000DF },
    { 0x9997A707B3465741,0x28192AFA90F61124,0xEA06C8B89ACE2E5B,0x208F1AD1ACB7CF35,0x1AC49E4AE569EFA2,0x7DAFFA0F8368ECB8,0xC559483F40E4879B,0x8DE74638753B0B83,0x00000000000000E5 }
  },
  { /* Point #15 */
    { 0x5237A07C19703702,0x46C28A5C3AD0D053,0x1FBEEED71A518E3F,0xDC6358362A3D429B,0x39BCAC7995422D85,0xB72A31731CE505AF,0x4149416A9A506100,0x9DC7A2FEACB8F741,0x00000000000000DE },
    { 0x23C01A9855977BBA,0xC5C16AD7FA04A7B7,0x751CA1EE92FB109F,0x94E2FC37EF6D534C,0xF9A7BFC20B18FFAF,0x35B6BC9A41A1D0BC,0x2D76829FF2DA291F,0xF969C68E609D7B37,0x0000000000000098 }
  }
 },
 { /* Table #69 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x51DB2D9D07207165,0xC7D56A41C3D4C59C,0xA47FADDA4E278B0E,0x5C3964E204FFC588,0x52BC9F389719ECFD,0x2C9292C035A04049,0x885FF9BAFAE7580E,0x2319A2DCD5CC866E,0x000000000000015C },
    { 0x8B77DDB70AE9AF6E,0x0E21B050DD7FD36C,0x35D968ECDC8B9C19,0x6F3F0785A624AD4F,0x97778A681D42C97E,0x86103BF0A2A4342C,0x0AEF36FD3ABABC35,0x46C8FB212FE10364,0x00000000000001E1 }
  },
  { /* Point #2 */
    { 0x2FE08A10462E6862,0xA86DB08F35CA4ECE,0x4AF069A05960B9C7,0x9F0086014C7FBBE4,0xFE91AAAB59BCD54F,0xBB6CD66467A1BC8A,0xF3B3590354AB69BC,0x2D5B1227FF914C06,0x00000000000000F9 },
    { 0x22226588F7D5AC27,0x5BF4D921D14893E4,0xA0A5C850C384F172,0xC5DEFF764351441C,0x9CBA07B4539D45BA,0x324345620A80AE0D,0x0E144257BB44F664,0x1C5C19C163DA2750,0x00000000000001A4 }
  },
  { /* Point #3 */
    { 0x604B730EF1EBE533,0x336E362E0B4B9191,0x246E5C1AB711E872,0x652DC2C1F46E3F97,0xC3492E151398E328,0xD85F2669475CD2BF,0xB4B28424A3C972BB,0xF3D5711649A9AC4E,0x0000000000000148 },
    { 0x2A5E5F5425E365FE,0x9202DDFF6ABD415A,0x314E872ACB24F45A,0xCED1DCD9B7BCC7D1,0x0D39CF240377CE8F,0x75EB96C9D1065414,0x984B4A459FE0EE9A,0x8237616704703AB1,0x000000000000011F }
  },
  { /* Point #4 */
    { 0x2347E38373435EB6,0x75563E7858EA9F89,0x20CCB854EFA62CB9,0xDAC97AEC1CC86C06,0xBE99C357F432D1B4,0xCD89DA561C2E03F6,0x7E424AFDA789AF68,0xC386D1BF401F225D,0x000000000000009F },
    { 0x46F9BDBBA1A12CA1,0x489BDF59A6469919,0x94AD85A73974BF6E,0xA7FE1C85C9FDE759,0xA26931A072B3C209,0xBD5B56203DB247CC,0x9ECB8A741085C481,0x9134BBD1EA48E281,0x00000000000001DB }
  },
  { /* Point #5 */
    { 0xAD4F18816BB2C3B8,0xD45F9A0CD380CA18,0xFB839DAFACA25641,0xB89884F27E519019,0xDE295E5458CD6C25,0x1BC5070E25A1E8CB,0x66F1635747C21E93,0x379E8F32A4BDDFA8,0x0000000000000108 },
    { 0x9141EA4E87CC4A52,0x285CBAF972CFF2EB,0x27898F4DF492BE77,0xD49D035F223C8859,0x763866C2726065CB,0x0886E8D5B2EB9E8A,0x7DEB06B31F70BF7B,0x8CE6BCB7889D3E33,0x0000000000000060 }
  },
  { /* Point #6 */
    { 0x0A65FEBA78BB30F6,0x0235D91A50EABF36,0x0B8EC4A4CD2D934D,0xA122F10B8DFCCE34,0xC3C86B639B2E6536,0xB8002FAC84962539,0xA6893CFBF6D36BA4,0x280E9D60DCCB7F1F,0x0000000000000072 },
    { 0xCBB4609E279551B6,0xC6E893884B03A718,0xDF62F063744DC7E2,0x1799EA3E4146EA10,0x73D8CEF29ECD77CE,0x2B87C10EB2229D1F,0xE9D08175CABFDF74,0xED1D16A83F0D60C4,0x00000000000000EC }
  },
  { /* Point #7 */
    { 0xC466FD7B7514E752,0xC0C9A0AF8E1FD662,0xD4B0AE397F3083FC,0x9AF1C21F24CB5771,0x8C20329D469DCD1E,0xB115FDD26579990D,0xCCD93D2A3160B749,0x4AA17BB996F8FE36,0x000000000000004E },
    { 0xEA95C80A4118EBF1,0x267CE3A6E78B533B,0x54167EB7152EE4F3,0xDA581B52D6D5B4C9,0x285DDAA44F9408C6,0xA1E4D6DC1FF6C988,0x9D1464077540A223,0x127967A3F46C92D9,0x00000000000000FF }
  },
  { /* Point #8 */
    { 0xCCA33DB42A22B97F,0x808D2E981942F8F7,0xD972D1A737133C3C,0xFE4B5F5F5FF8D7AA,0x8BD08C189175512E,0x67BAD971BB95CE67,0x885DE1D49CF69B1B,0x00D0EBBE54BA8E61,0x0000000000000111 },
    { 0x50AEEC386C90B677,0xC765C4753DF368C1,0x3865A7395D423382,0x5F843ADF7E55F0D3,0xA8C20B65E6159793,0xBC3D7A4F05C2F2B9,0xB6663D297A052D8B,0x50CDB83A65A7EA81,0x000000000000017B }
  },
  { /* Point #9 */
    { 0xEFF85D2135FA7474,0x478BA48FA3B4B0A2,0x087CDF110EA2B802,0x48F897D3BA11FF51,0x623EB68608DDEF7F,0xA0AAB59FF0E7A51C,0xD57BF13D24CFC222,0x71F63064F3FF3D1F,0x0000000000000043 },
    { 0xFF76D75B29660CF3,0x723D7DD69DD9F504,0xBDA1A7DF93A1D16C,0xB2F3A649F13B9971,0xE0E394014287624B,0x7B9B95B9244274AF,0x4809FEDF64B5FC23,0xCAE69EDD8E597DC4,0x00000000000001B0 }
  },
  { /* Point #10 */
    { 0x08F67A19468A4D89,0x9F6F53794F30E23D,0x68F24A7755F5836D,0x090CFEE876ADBE8C,0xB21E53A01D845C6D,0xCACD82E3E5C9F699,0x7E699A9203A83F9D,0xE2D7E4CE9C3AED7A,0x0000000000000025 },
    { 0x500C17FED93595E9,0x06E176BCFC07C1EB,0x0005B83C1C933857,0x5EFAD63B4D91E1DC,0xEBB32C23A299BDE4,0x530E02C3FE4274CB,0x7DA066C08064808D,0xF3A923806E4CA7FE,0x00000000000000AA }
  },
  { /* Point #11 */
    { 0xB1C5EB86DB07A31C,0xC121E0F5CE9E977E,0xE3163D990AB570AE,0xD6DE926647FC4475,0x368DE13A23CC673C,0x9EF5398E8B441C52,0xE79A4360CDADACE5,0xFE282472395657A0,0x0000000000000148 },
    { 0x2DB98B556111BA3B,0xA7E28D4D3B72F8E5,0x0A223411C466D322,0xC1559B60DF81B171,0x6DD083A767859FC6,0x0A916F4E4BB1D85C,0xE6DC1F67DF0DA188,0x82DF65044A6A6842,0x00000000000000FA }
  },
  { /* Point #12 */
    { 0xC8D1DCC05F21C201,0x24B3552ADDA67D50,0x09D765846BDDE945,0xCA83670236290AF4,0x687FAB3BCD03B255,0x0E58F4748ABBBB20,0xE434743147056E94,0xFB5B56B7D2E8E4FE,0x00000000000001EC },
    { 0xD7133A86B1E2C5CA,0x4801A6716CF22974,0x6111DD347DA0F4AC,0x683FB4BFCC6CBD21,0x2E63154796881C12,0x198F4122CCF3F7ED,0x93C300F29F663DCC,0x22F99552EF37C598,0x000000000000001E }
  },
  { /* Point #13 */
    { 0xC4A5C4D01C878A90,0xC83400E56835CBD1,0x91DC0FD97203D0E5,0x4A3A88B9F952ECA6,0x997DCE7B8F9EB1E8,0x7411C37DABB34A2A,0x7BAD66F71B1B8216,0xDB4358AFAAA64441,0x000000000000011E },
    { 0xBB9C34F9536BCB88,0xD21D07545CA0BD3C,0x2A6593BE761DAAF0,0x454ECA231FC6592B,0x39B2FC3F17688CC7,0x72DB65C7BF5A5DF3,0x7979335F258F3461,0xE89702334BF1F6D1,0x00000000000000B9 }
  },
  { /* Point #14 */
    { 0x92364760A7514596,0xC6F1B7488C622A82,0x274BD612BA1BDF30,0x3599C184C5BCEEEB,0x618CE82FFD09694D,0x8180CA5F31CA736E,0xCC8520196BC36830,0x10B8F08292A3E590,0x00000000000000E7 },
    { 0x53C731F6E14B235F,0x7DD928E555CB729A,0x10450642793AC2A7,0xF86F0624CAB333DC,0xE54631BD6B8639B0,0x63A9353225722662,0x007C299C10EA9B9B,0x1350BF7B10425BC9,0x0000000000000026 }
  },
  { /* Point #15 */
    { 0xA6CBF9D21798AD85,0xCD0D0E046503FD07,0xB1CA63452A0328B7,0x8084E8DE38618354,0x9A2C7E8E8F63992B,0x40E91FCFA2FC8EC6,0x006B87633387D75B,0xF980C34E15C2A46E,0x0000000000000142 },
    { 0x09BE979B07343464,0x7C8447BD1609954C,0x16664F7BA8D43B5D,0xD7003AB86242E93D,0x8C8113BE9BC6A8B7,0x0464AFC31424B6F4,0xDF4EFA6FCF19C3F5,0xF371AEA597CD9CF2,0x0000000000000095 }
  }
 },
 { /* Table #70 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x4C740AE10AC4CB66,0xC8A66D9759C635FF,0x328B65AF2569DAC8,0xFDB6599B8838DBC9,0x702473F87FD83C9F,0x0D1F2AD8128683F6,0x00AE5B505030B76B,0xB1375D706D15B5ED,0x0000000000000159 },
    { 0x7A772A901F1E1F7F,0xA790DCB7C669AA61,0xDAD905AEC5E4F185,0x3BD91C29116AD6CE,0xF87C96EAC329D8A7,0x399C929CB5B14581,0x6FD2983C3A8253C0,0x616A8B61DA988B39,0x0000000000000181 }
  },
  { /* Point #2 */
    { 0x0D6E6EEDAE0E245D,0x5C37E80F26F68799,0x575626142AEEB588,0x9261CB14DE82ABC1,0xA4B446F5EBEEB914,0xE8B749EFFFB71DC9,0x3E1382391FCF5E8E,0xCBDC4C5315C8CFB4,0x0000000000000185 },
    { 0xE8ACD37DA80326B1,0x4AA2D80F6FFC9AE9,0x46DA631FDB069E01,0x1463768DE7ABE06B,0x932E528DC3BE779F,0x756BC3DE494FD10D,0x4A181A650B0C9870,0x0CEAE429AE34B70B,0x00000000000000AE }
  },
  { /* Point #3 */
    { 0x3A070E58524BC705,0x86404F01FBD0358F,0x88456D7874567144,0x91AABC494CB2BF46,0x829DF4FDB1E29372,0xF177CE20230CF9F5,0x404ECA037A3D29CA,0x6D9B609A231007DF,0x0000000000000159 },
    { 0x7FF3369EB1BF4593,0x94FF624F5E4049A7,0x5B7EF74134194BC1,0xF4BAC202131B06F0,0x70A46357B7549633,0x0B293380761AE1BB,0xB2D9C64D974C1977,0xE27E23B400E7751A,0x00000000000001DC }
  },
  { /* Point #4 */
    { 0xE15EF16CFAADEF15,0x0F2927A1BABE010B,0x252539DBCEFDEDA3,0x1E8FF8C4A98613A8,0xEC7026D9F76D425F,0x507C1214AC386095,0xFBA6C762C8024EE0,0x1088460C3F4DD18E,0x00000000000001B0 },
    { 0x6CCF1452202080CB,0x33B934D5B645D8E0,0xEBD4D772C0FD54B2,0x62A8045E207E1DFE,0x9E5D3B88601B9F43,0xC8F7E47D77E357FB,0x1C8764778EC21437,0xC08C5A27069DD1C9,0x000000000000005C }
  },
  { /* Point #5 */
    { 0x8B7BAD84AA505F62,0x8052B3CBECBD5F9E,0x0E985E1AB3660A2B,0xC17E62D3A69BDFAA,0x9BB1033189B5E1E8,0xC572485A6B55D39A,0xC322F39ADF1F6747,0x88881E7FC81CB6FD,0x00000000000000D9 },
    { 0x31D3F8493310A660,0xDD188984FDC9DB36,0x89A0AF2C3C61B203,0x508FAE9C8E454871,0x2EBD3D7A69879C4F,0x5AC4C93D83E6E3F8,0x71744332C59F4C51,0x0322F749AD204B19,0x0000000000000057 }
  },
  { /* Point #6 */
    { 0xD445E8962DAC6A90,0x6904DD238A6D208C,0x83ADFBBF4E016973,0x91630953A384D374,0xCD5E353435CAC47E,0xCEC42D1088BC5E3A,0x13D0E8AA5141DE2D,0x3BBD85D1BE1D414A,0x0000000000000105 },
    { 0x2B200480B911AC9A,0x0C681A4332BD4596,0x68E2718368EDEB24,0xF8A34CE78950FF7B,0xA58265B03AFB03E3,0xD0D866606BC58AD1,0xF9542BBA3303C185,0x13AFE747CC393E4B,0x000000000000005B }
  },
  { /* Point #7 */
    { 0x6871A6E155B6F895,0xB935913E9D7E2730,0xFE1EEBB1A9AC21A4,0xFDAB879429C16938,0xEB9AFE9ADEEB21B9,0x967A2FB2797F546D,0x2FE2023BB9CF34CB,0x9272977EE049697B,0x00000000000000CA },
    { 0x348928EF50B4A316,0x115E58ECE32C9A4F,0x6D858BE4E3A235FF,0x7464D70472B943B7,0x6E785131E862030B,0x4060A8C7B8A27819,0x831B7288D3E4F0D6,0x81C21F75B36C3F8B,0x0000000000000004 }
  },
  { /* Point #8 */
    { 0x640C489C80744C7B,0x76C2615A09C3BD56,0x0A0A64544B2E41B9,0x1F67EA463635ACDD,0x7A93C39AF36DC54C,0x4EFD6C2F386CDCCC,0x789FFBCD8DD41A02,0xB718D8187068E710,0x0000000000000002 },
    { 0x463B2B5D8E3ED0FC,0xEF348838C77BCB34,0xF3CD1BBD8E9BF495,0xC275C5432A4EC1FA,0xE606D611CC394E16,0x45C1E7C61A56A93C,0x828C42DB1F6707B2,0x59FF294843754051,0x0000000000000100 }
  },
  { /* Point #9 */
    { 0x23AC84CD9E107222,0x011F6752130ABB36,0x83D1979F5931A184,0x87880BE04349BEE2,0x785209566B06EBE2,0xA12C6E2F5C02EECF,0xCFB3B87D2C027B98,0xE399B69F59D49343,0x00000000000000DF },
    { 0x73F60492F763472A,0xD0630D7AA32C8E02,0x64FDA2740B7EB763,0xD2EBDD95C0295433,0xD3BF0C58F8650B05,0xC0C0A4ABDF491D11,0xFDD83464BEC2EFD6,0x42DBBF3363FEC348,0x00000000000001E4 }
  },
  { /* Point #10 */
    { 0xEAEFE760E7307475,0x660015223DE4536A,0xC0C1396D45928311,0xB972D84029EA65FC,0xCBF018AD83C0FAA0,0x0CE90359F5116096,0x33A6E9C82C9E2CDB,0x1E61A90C5F1AA2AB,0x000000000000001E },
    { 0xCDDF71F961709E18,0xAE43057240F72033,0xDE53F951B1B7D4A2,0x409F0A90CC853277,0x341FA0C03789A7E2,0x9CB4A809DAF6B61D,0x3B42585DF7BD34F3,0x7A624AC415D77B4C,0x0000000000000078 }
  },
  { /* Point #11 */
    { 0x02E9C325F196B6A1,0xCFC01DE1B0374324,0x289B25BE0121A620,0xEC188AF9F09B541F,0xAC954BC5FCB86A52,0xD883B21F87A757B9,0x1194E3A12741CD24,0x3D1914B61E3EF5EA,0x00000000000001FB },
    { 0xB13EA4836BFD085D,0x6E20B8D504A5DCD1,0xCF5FBA257F7AF4FE,0x58625751914D9C51,0x1005BCC9EB304193,0x7B54EF23579943F8,0x50EAD06CC7D1C9BA,0xCD9877673664CF97,0x000000000000010A }
  },
  { /* Point #12 */
    { 0xE78A2EEFD978BE2C,0x1958503C388B0164,0x63A5D6FB3D35EAF6,0xFF6E50D5DBFB3304,0x4B9C89E3931E2555,0x93D6C6E9E2A419D2,0xB2B26A9296F11B80,0x1BA661C44C413FB3,0x00000000000001FE },
    { 0xEA30821624FC3599,0x83000D9AE1823A76,0xB614483695D2AAC8,0x661640C0996C6B75,0x5212A79FA7B4F33E,0x40C6BFDE5A2FBEE7,0x8CE6E88E86CE3A36,0x4A9B0C5ECCB757A9,0x000000000000010B }
  },
  { /* Point #13 */
    { 0xC8B31578E40E993D,0xDD419459041D243F,0x0C47E4492FBAF7C6,0x10B731C47D71B295,0x41DCA681F36A08C0,0xEC3582403D924E38,0x891991A88593F600,0x8D684B374A984C9E,0x0000000000000109 },
    { 0x44787399A8A706DC,0x307E57CB53CAA9BA,0xEA0AD37576A3276E,0xB1B79DB12E025195,0x96703F51AA828A3F,0x174F1C27536E5266,0xC2D7DA86FBA650E5,0xE69208051BED53A0,0x000000000000010F }
  },
  { /* Point #14 */
    { 0x6076EBA5D73F6D54,0x2DC200DB4826039B,0x683C59A00761FBFF,0x525681DFFAEB001E,0x84175769D29CE601,0xB5301CFC04112E5E,0xA242021D3AED1274,0xC2F154CEB3CF3089,0x000000000000005F },
    { 0xC754A9E65799204C,0x186EC103D6251A86,0xAA3BC7933F06CC52,0x2512FB5391C10E49,0xE63F08C7DF01B044,0x4138D8974A7A5BC2,0xD23A1BE79258B0E3,0xDDB136202BB7743B,0x00000000000000C5 }
  },
  { /* Point #15 */
    { 0x409BEFF853938400,0x3593E4F9C460D38B,0x6D0B5D57F0673911,0x22C8DCAEC72C6491,0xE6E263F173E0EA62,0x14C1E16512ECE129,0x45B34F069A474FF0,0x36C07C4FB96851D9,0x00000000000001FC },
    { 0x250B8E258259BF92,0xFB6826A6866E22FE,0x1D0FB6D935566F47,0x6381018504537FAA,0xF8F10B30F1D6BCDC,0x6CE068C4ABBF20C8,0x3CEAA8C944FCF678,0x44C0EE4DAA121E6B,0x000000000000012C }
  }
 },
 { /* Table #71 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x3878C70ADF5EE186,0x62F4F54A6FFFEF9F,0x0A7664C380400FA0,0x99BE58C2D0EA21B9,0xFA70B9ADE311AA6D,0xAFADD452ABF43A4D,0xE6291C610F7B5DE5,0x388A421578D61E62,0x0000000000000024 },
    { 0xF188F980EE1BCDAF,0x9CCC1A6BC991F497,0x6F733D1221EC6F5D,0x59CE56B9DA9F5BDB,0xE03A9A1F40E88D50,0xA5E60328C0190A2A,0x382BDBE69FF9D482,0x26895085BB792DE6,0x0000000000000013 }
  },
  { /* Point #2 */
    { 0xBA3A04F75F8FA47E,0xB9C44AA1833DFB7C,0xE4F3A4A6AF4EA679,0x02B4BC288240AE75,0x390076AE282412EC,0x74E5BD6406709592,0xB87B1A57DBAD0025,0x71E0C6F732123B04,0x000000000000016C },
    { 0x266B71D5E4FFC2C8,0xB061CB88A73F6FDF,0xBCA068CD75B93FF4,0x4552D43B97712A14,0x1035134C5B941BA7,0xC14623ABF31B6915,0xDFDD91C4AA972A0D,0x54E8E7E0E17B9AD3,0x000000000000008D }
  },
  { /* Point #3 */
    { 0x521CB4E322B7448B,0xB51BCA884C726BEA,0x9391BDEA39C312EE,0xF9128EF72C8B9A0A,0x988F9F78A8E51D04,0xDD44418F96C8257E,0x3688FB242D7F2F00,0x2F92E5FF1B1FDD4C,0x00000000000000E3 },
    { 0xBA865459E98C49F5,0x3545CF759DFE9DD3,0xEB3EF7FFCE823A85,0x39BC813A9B39A2A8,0xB753463592A11C12,0xB16A5BD61EE6D123,0x3192E6DD82FEF180,0xEBFB81B4287687C4,0x000000000000008F }
  },
  { /* Point #4 */
    { 0xA99E0FA88B404760,0x5F6B7EAA28835BBA,0xEBE75466811F0BCC,0x3D69DA3E9D0FFFA4,0xD815E361185F1AE0,0x78623276B30FF597,0x3518246EA8466DE1,0x3C8E0D4A516B0E43,0x000000000000003D },
    { 0xF4BC4434D1614ABA,0x49D062B7BFEDF3AB,0x878C93290FC7E5B4,0x727EA9198A92C516,0xD159DD269AC43994,0xCC04BC19C25A36A5,0xCC7FFB96172789E1,0xC136B9C92F2EE22C,0x000000000000014B }
  },
  { /* Point #5 */
    { 0x7D858CBFDCEDC377,0xC3F3875CE1A5B46C,0x49C4664B79AD10F4,0xCDB2138C15564507,0x2EE0543B9947BA35,0x785A7271AD4638AA,0x7CCBAA927C03E2CF,0xFDC5E912558CEB2D,0x00000000000000D4 },
    { 0x982BBE215BE2E05C,0xCAD3F06C9EFC0A64,0x076D93BE6D27C70C,0x31267A2690A905C6,0x967AED2DCC9842A5,0x838121E8CA64408D,0x85CDED05D073CD0D,0xE29384CB2C36FF15,0x00000000000001E5 }
  },
  { /* Point #6 */
    { 0x0AE257EA870BB0BB,0xD6A912F769568F16,0x4DED40B534765998,0x79AA4677FDF1ECFF,0x398989EA0B5018EE,0xF5C66D47FD1830B9,0x81B8F4C4B3C221E6,0x589EDC218A4A9968,0x000000000000019C },
    { 0x154B40966F26663C,0x01BE02771A620695,0x04FDC393392BB592,0xB7C75D712343FAA4,0x5085E76D0AE84496,0x6C6EB5C01766FAB7,0xE87450274FE63E7E,0x262F1EC387B18608,0x0000000000000143 }
  },
  { /* Point #7 */
    { 0xD1D23EFC734512EF,0x8885C332BAFA887A,0x98438804B3E7242D,0x0AC89EEB2CF966ED,0x0EB25C772179440E,0xDD06CAD7C1DEC26A,0x7081375F2FE5EE8A,0x80EDEA9916A968C8,0x000000000000011F },
    { 0x8DB61568A8A00726,0x493B2898B22568ED,0xAFCE0D3AACB41A35,0x148056FDDDF0B39B,0x66507B6816451772,0x89020BB9BE584D0E,0xA35E06C0B485A6FA,0x877E17871B1701CB,0x0000000000000168 }
  },
  { /* Point #8 */
    { 0x758BE5677ED6EAD3,0x5AAB37984EA30F41,0x8A66701D724BDED8,0x3E1AD9A070544B4A,0xD0286777EE940423,0x3335377B329A995E,0x244D471A4EEE58A7,0x32D4DFA067275E49,0x0000000000000105 },
    { 0x7EF7DD10F91EEEF2,0x51C22E8BBA0C7D57,0x45C515D485233341,0xD9D7CEFCD353231A,0xBEF9D961DA5BD561,0xA5110C6F5531A41D,0x0F1F7A194328F21C,0x1AD6D24C49EC18E6,0x00000000000001A9 }
  },
  { /* Point #9 */
    { 0xD6A82AD3D28BB908,0xBD3F385679C31C9A,0x8ACFB60C6062D159,0x224606C72C3C1CBF,0xE60D8902C5209A99,0xB96E98A40B2855E1,0x1EE047152B75B008,0x71BB8ED5BFDC1020,0x0000000000000166 },
    { 0x1B30DD9610EFF42B,0xB3FE6F6844899CD3,0xBCAD31FFBB3874AE,0x836F763924660CEA,0xB92FE7F4AD4EFD57,0x627FA8AA23483D71,0x8FA4D9D617E4A8E2,0xDE728D20BE6C543C,0x000000000000016D }
  },
  { /* Point #10 */
    { 0x0C57C29978C5C030,0xC5B975D5D52AC0B8,0x21F5A40E681D9222,0xD8468EDEDE8AE79F,0x89EF8A83BE7A1716,0xCEF8BCD575299297,0xBA7A3E4A0ABFC539,0x25972A7F5C0B2773,0x0000000000000027 },
    { 0xDE5390634B7F36DC,0xA386AA9D42966663,0xA2E1DA7AF48EB228,0x827AAB86022432A2,0xED9CD166EBB6EA42,0x59656708DECC4F59,0x5A9F29BDCF733E5F,0x0483B730B2909E7D,0x000000000000010C }
  },
  { /* Point #11 */
    { 0xF498F852A8815D90,0x88A6ADDCA5922350,0x5CBA913905C4BBDF,0x9CD0FE212E8DF210,0xB36233D5F2359B53,0xD3B1510B54092738,0xCA2166DD3BD78B3B,0x80E13B626D9E7C90,0x0000000000000094 },
    { 0x0BA73A6320404151,0xDA5218CF506F5133,0xB1F1193E52FB10F5,0xAE735DE42E32BD18,0xBDC19089BCDAE71A,0x4CB7980E97C87ABC,0x018FECB4D696C4F9,0x04B4D8FC52361369,0x00000000000001BF }
  },
  { /* Point #12 */
    { 0x848293A45E30289E,0x65A5CD5AB9CDF5C6,0xD3A4D0E1C5D0EEB1,0x4A8A04DD65534EBB,0xF34C31BBDC0998DB,0x3883D9546FE12A60,0x8EBB1C1560E56FDF,0x5EBB32577E83049E,0x0000000000000004 },
    { 0x8E824E905CA52C27,0xD24A7B90FC543AAC,0x8AB7608EAFDF581F,0xB68FCB54CB480D7B,0x35AB61F4B7204FF6,0x86C7BC3ED5BF25B3,0x39E15EC672691C74,0xEE5EC2541433F4DB,0x0000000000000069 }
  },
  { /* Point #13 */
    { 0x6E5CE6BD43D18546,0x17781107CB768466,0x35087E8ACCD958AF,0x10BCEA85F1CEEEE7,0x149B815D3E4AB51A,0x9DDF701C7DF477C5,0x85A3184F37BDEFF9,0xE158FBFE9D5FC2C8,0x00000000000001A2 },
    { 0xF2670D58545F88EA,0xB805679DB26A23E7,0x3BA6FFCC243BFBB7,0x39EE5876C069053C,0xC39437C0C5CFFDA9,0xB5748FFF6E0DF697,0xD14FDBAB7D570B3B,0x9550ADFEE07D547C,0x0000000000000185 }
  },
  { /* Point #14 */
    { 0x03050AB17C08F924,0x81F1B49DBC86DE00,0x9C0B064CFA81A96F,0x6ABE39F0437994EA,0x21FA0A6AD071FE53,0x99A2C1A77731AFDE,0x7B0E319E40B2F57E,0x2294E841BAE073FC,0x00000000000001B0 },
    { 0x7BCE7C5564635B7C,0x22F50E642F587306,0xC1EDCFD0C08F8DBC,0x810D997EC35AC748,0xB7C8B820C8D1087C,0x23D21B2F7AAD1DDD,0xD8EE9046CAA30138,0x506B543C82899572,0x0000000000000069 }
  },
  { /* Point #15 */
    { 0xF81678D0E223B20B,0xCC2DD4698707BCBF,0x2DF9EADC55C70E55,0x33357401C85F129B,0x2A4B7C21C6829ADF,0xAC6C2861A7CDA777,0xBF10646258BEC9C0,0x3D51FDC902DA2CB9,0x0000000000000190 },
    { 0x589CC19B7B69C39E,0x8F67382363A4FC83,0xFCC6749DF96574FF,0x0A8BB69F7B356A59,0x0155C02C6E5656C4,0x42BE43A5E5A48C80,0x51C7FABDDB149179,0xAD41B7CEF28C73C9,0x0000000000000121 }
  }
 },
 { /* Table #72 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBF2FFCB76E640A8D,0x63479501A0B5A07E,0x55BB30015F36F2E7,0x9890F999058A676A,0xD9EE341B455C0D27,0x6C95780C18E08FC8,0xEB63A675442A075D,0xCE46A1A5FB69DA00,0x000000000000006B },
    { 0x8C618934F3ED6253,0xE00342446E9433B4,0x989B99214260B2C5,0x11699804D9DF4747,0x125FE61F763A7F63,0xA972786DC6EC395A,0x662F9FE7B7B7B8C6,0xFB644A615456556E,0x000000000000008A }
  },
  { /* Point #2 */
    { 0xED29C2FFB0BB44D8,0x0874C2A5FA00DDAB,0x9398E8A2065A4A5E,0xA6E1952691AAB917,0x20A816AC667898DE,0xDA4B97934B94A66C,0x6FEE1473B00E36E2,0xCD9958D793A46CE6,0x000000000000000F },
    { 0xEAB9FA64A362872F,0x87CC55B095457FB6,0xE3E3F13D3C702019,0xE025B3C8FF6208C0,0x8FCD5B2FD8B8F87C,0xCF9DED31789BC9ED,0x7474244818D40F49,0xBF14E1F046C33140,0x000000000000016D }
  },
  { /* Point #3 */
    { 0x0AA08334A3A5A2A2,0x7B1E2F91DCFC5939,0xE1C64158673E221A,0xA9CE2061CB3319D0,0xB359C34B977A9B41,0xC127AF82B7F9FC83,0x18ADA73481166C12,0x1C4C48FB092D64D4,0x00000000000000EE },
    { 0xFED1A8DA4C5015C4,0xEFD54478526E1897,0x0AC4F64075BBDC91,0xC0774CCE910661EC,0x699BB035C30CCC07,0x836B7B1780952CCF,0x03B8BFEF9788BDC1,0xB24604C5FD47A69D,0x00000000000000D6 }
  },
  { /* Point #4 */
    { 0x35E7AF927E198AEC,0x2937B845AD58220E,0x9C8C65CC625B0972,0x91991D8A1A9911C8,0xC9F134D90A4EF588,0x1CBE5C250E01D57F,0x4C31016E85251D47,0xC587777652DC527C,0x000000000000018E },
    { 0xA9232336D429C5F4,0x60454705BFABB412,0xF5F84846794CC5C2,0x1BD49EA0BFC8532D,0xD4B45B2C3042CD43,0x49590033374AB02B,0x78770266EE464C45,0x0A33044EDA262362,0x0000000000000144 }
  },
  { /* Point #5 */
    { 0xC17C5414720AEBB3,0xEAA1A7B97089E6BF,0x9EE50BA136DE9F22,0x4BEB00685B3BF8DD,0x330E8C045B3F6992,0xF477636D6E7A978C,0x5799678A9543861A,0xCEB7D074810077E6,0x0000000000000019 },
    { 0x0D20DB6DCAFEF71C,0xB1C02CBA35FA4E9F,0xEB6628684630EE0E,0xDA4BBE8C88265202,0x71B53DC3E1AA127C,0xF4E2E52F0ABCAA62,0xE4C4CC96F8F6C926,0xF9CF5BA414AAF997,0x00000000000001E0 }
  },
  { /* Point #6 */
    { 0xF946AB5188098F73,0xE98C6E73FFD8BC23,0x30D30A3C98758F69,0x302D5F8FBC8E359C,0xADAA2FF6FCD2F1FC,0x694DE81C4ADEC57A,0x69735A5A97698A60,0x15BBAE8C2D55531D,0x0000000000000164 },
    { 0x2398ABF08C6B2D9B,0x258BDC0E9EC5EE96,0x80ACA75CA9BF887E,0x3E3ADC8CD1495AD2,0x1A30F94862D2F571,0xEBDBF063989DDA10,0x86BDDEDE74D3EFAE,0xA42598AAC749C868,0x00000000000001F4 }
  },
  { /* Point #7 */
    { 0x6AF0B935C936A7E5,0xDE94D724D4A248AB,0x0491C733594E53B7,0x238EF5341CCD7088,0xAF0E791E4F5052C3,0x70CBEA8110C3411D,0x6B7C8574577D38BC,0x00E147AE4EA6A924,0x0000000000000085 },
    { 0xCAB57E2A497B793D,0x3F642966EDF47059,0xA276326D2EB66B98,0xEBA64255A76E1221,0x698FD276D23677B9,0xCBB4637445A0625D,0x5D92DDDC50B672EB,0xBEF8CCD00839333C,0x0000000000000091 }
  },
  { /* Point #8 */
    { 0x225420C396139042,0x90A38D5C5BCF13CB,0xB99A43AE99D999B0,0x5BBBE4D450A20372,0xAA92420245A7EDA6,0x49543E058BB2A5B6,0xBD11556497D32F2D,0xC57D1AF95D680F19,0x000000000000016F },
    { 0x93AF05115FF37259,0x89C88BEF9B9CC398,0x85526FF5A91987B5,0x8B7BB52ADFBF9615,0x25767D030839C531,0x6B15AA2E1CD9033E,0x47490261DFAE7D95,0x4EE02157E7E1E8ED,0x000000000000015D }
  },
  { /* Point #9 */
    { 0xFCE66781065C3B1C,0x2F28B538B5195F93,0x9294FA3ED5F99BA0,0x32EF709C66C624BD,0x4C555DF34F610D8C,0x90EE123F438E3D99,0x92D19B98919841E9,0x2E228D8AEAE83102,0x00000000000001E9 },
    { 0xB4566D09009CF7C8,0x60B0CA8338105C3A,0x9A4FA08AA8DA65BE,0x3208AD03B5FDE8EE,0x8462DAA4737B4EC8,0xBC182470A5C1B058,0xB1BF27CE7F0B478A,0xDEDE341E67045B89,0x0000000000000156 }
  },
  { /* Point #10 */
    { 0x8CC3ADC33883BEE0,0x306B08F63F15B848,0xBF4896FC2340F68D,0x19B1DE94B541AD34,0xF343C4602C320A09,0x1E5FA35FF581B0D7,0x34D600C7B3DB161A,0x54CD8526E9F8B6D9,0x000000000000015F },
    { 0x4AA6CCD6CEB32ADA,0x2C2C5E7E7497BC17,0x531EC78678791B13,0xA7F862C881596A68,0xEB04236972E7AD06,0x306DB5CE7EDAD2F1,0x5E7A162EA1CDBB31,0x06F0B4F3565F914E,0x000000000000006A }
  },
  { /* Point #11 */
    { 0x5F16528BA968ACCD,0xDCFD5DC1261063CF,0x99C6A790AD45C838,0x4B83B5DC811FF9D4,0xC3C067F23C3DEAB8,0x447ECCA83496C2CD,0x212E9948AD2663C3,0x080D13F5354FDC23,0x0000000000000074 },
    { 0x4E4A2FFAF202BAE2,0x12EE692F0B704EA5,0xDF48FE7D66A3E286,0x13228B5095BDF85F,0x65AB3FF9422DBE99,0xFD795432B376E1EE,0x7DCA34AC0DE9E917,0xF907AD9A8614521D,0x0000000000000159 }
  },
  { /* Point #12 */
    { 0x1BCB1D73C96D566C,0x0B51A27A1B6F4D02,0x773BE48B463D8FC1,0x267E606A6F19334F,0x67A49A30DB4A4BB1,0xE33033BB6F476620,0xA2E4076B92025915,0xB1845EE448F182AF,0x0000000000000070 },
    { 0xDAF44E82D2F77D9C,0x753F7F717CAFF6B8,0x7FDA258AC5D9943F,0x2F47F8379B012134,0x9CBBDAE94D2A9BEB,0xDB39F169221F799C,0xEE68DAF32048A54B,0x36939E9D7F5AEF38,0x00000000000000F3 }
  },
  { /* Point #13 */
    { 0xABF61A9EA3B3F8C3,0x90237370B62FC9DA,0xC1D3DE232C5128DB,0xF67097FB65AE3521,0x0016DEBD78D68D97,0x23EA15DDEEB9DF30,0x4A09E240431259F6,0xEB81173106FFDC4B,0x000000000000001C },
    { 0x3C709776A20611B6,0xD695948645D62433,0x86C9232CC8344819,0x636675F6A260C3B3,0xB927E00A2B6ADB42,0x9644F9E9F1C8C3F9,0xA0842190E01260EE,0x6EA161F8E2A15FA9,0x0000000000000127 }
  },
  { /* Point #14 */
    { 0x84450F4A2D3A1514,0x1CA1912DA211FA6D,0x18A4E99F487DF3DC,0xAE9DD13E6535495F,0x0EC3771FBA83EE44,0x3EF3B94359ED9F53,0x0BAE7D1FA163406C,0x387121A0B815B7AF,0x000000000000001C },
    { 0x2DEC1270F94FD988,0x21680D0E3D3B53E6,0xCC653CCA28C69753,0xC03803D715D406F8,0xAE4E927EE939BF4F,0x01DBF41D381933F7,0x602169E07EF8DBC9,0xE782930581026DD0,0x00000000000000AE }
  },
  { /* Point #15 */
    { 0xCCFC7051875E2133,0xFC3C0B55821F76A0,0x544E229FCD8EF672,0x3666479347494F15,0x22C05E5F109B2CE0,0xC294314C492BCBB1,0x15BEECDE16558D91,0x4518316761AE3008,0x00000000000000A6 },
    { 0x80BC2B2C26C28852,0x941F0224510B0086,0x0FCB9DE4ABFFEB4C,0x0B1E80A966F723B4,0x186FCC2BE5CD0627,0x8B1DF932CA71DCF8,0x789CB0A1EB01452C,0xB2E81E3681FFE1EA,0x000000000000009D }
  }
 },
 { /* Table #73 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x5EC6427B05487074,0x0B59FA1F80C426AD,0x0207D510C9946594,0xBA1FE985D38F83D0,0x113AEC98C96EB133,0x3424AD0182515193,0x3EB15AEFFB6F9B10,0xCCB719E8F15D8BE1,0x000000000000013C },
    { 0x63F898834C67518D,0xB5CA3508F85EB1D9,0x1EA1C74FAF652B25,0x4FBC5476BDDEDC4D,0x22DAA81AF4B33C74,0x9F7941A03F36AE29,0x90C2B8CEBCA5CA40,0x53E736A1B587B3D6,0x00000000000001B3 }
  },
  { /* Point #2 */
    { 0x8645EFEB9545BB61,0xF696AF86207181BB,0x94D3014CA2B2D411,0xB8F1515665C54DB3,0x6574F1CB011DD592,0x7D9C69EBF3247AB4,0x1708B24D5A391A77,0xAAA19D08312E131F,0x0000000000000167 },
    { 0x1D3F4510EBAEA62D,0x2186C9C26C118B52,0x81C0B0AFCAAADD5F,0xA0256B3C665BB598,0xEC461656ECED1F38,0x77BFE65265AA7914,0xD2600229333F7AAE,0xD916FBBDE1F081DD,0x0000000000000010 }
  },
  { /* Point #3 */
    { 0x6DF7CCCE9088C2CE,0x6A8048BEB88F81B6,0xA4B4F0E3E5F7673F,0x26EB7B7DBEC7C688,0xAA17B13E10BF71CE,0x5D486038B36DCC8F,0x0256CCAF0063F45E,0x88D8FDA4069B36B0,0x000000000000008D },
    { 0x2DD059FBC42A3A8E,0xD8765FC9B211932C,0xBF35A4094092EFA9,0xCCC83C7DD247EA27,0x9B3BE42EB76BB256,0x8AE4A99B6B87921F,0x3034C4FFBD1013F5,0x57F523B2A3730B8D,0x00000000000000C0 }
  },
  { /* Point #4 */
    { 0xB64361A93F7CAE04,0x23CFCF76AF64EFBC,0xB4539C3CD4965AE5,0xF16E3E884DF1182D,0x2BF7EED4DD75FED1,0x831A5956A215B733,0xC23E3F1A9732D4DD,0x3644961904677879,0x0000000000000068 },
    { 0x14675E68E07AF31C,0x82C3D1BAABCD16D6,0xAB1B388E6FE13962,0x3490B5218016A6AE,0x13B584A11CE7F93B,0x44265DA4A5CBEB76,0x17E4726763DF9697,0x10144C87CF2B278B,0x0000000000000013 }
  },
  { /* Point #5 */
    { 0xC470F96F4AC5EF8F,0xB06F3C09F41A1D41,0x3D019BDC180BC759,0x53FFAC7069ACDA2B,0xB2A01E7DCEEF6C20,0x144C2F6EB7C261AC,0x012B098C6EADBCED,0x85F2EA71B634A837,0x0000000000000144 },
    { 0x6D50B0AF6A8FA909,0x052B772A944AE8C0,0x6306369BD783103C,0x4E11FAA2E321A7A4,0x1963D2AE3024EE00,0xEA8CF87C4BBF4D91,0x293B0207F678AF53,0x5299C8125CA3A809,0x00000000000000BD }
  },
  { /* Point #6 */
    { 0x08FBCE3F4F5B0421,0x4E4F3FACF59FD9E2,0x74557874EBD8FD8A,0xD44B9CA9EFB2F20D,0xF43CFAAB1BBF688C,0x2DB8774EF799B23D,0xD1CA23ECA80A04EF,0x3EB47AAEEFCE5F35,0x000000000000008D },
    { 0x165AC19EE9370A9B,0x9C19C7582C654E43,0x4AC5195EB4F9C43E,0x6FB0991CD714AA06,0x6103B1CB7B348C2D,0xFEA4176F5FFB3AAE,0xC53AE7F7B94EEB5F,0xA933F30A9E4D4A5C,0x00000000000001FA }
  },
  { /* Point #7 */
    { 0x961AEDE70D593359,0x0EDBE79C46BE7455,0x63E8ABDF0C410034,0xDC91162C4F878C40,0xB31D78B7E7935F7A,0xE46FB88A2584A9D4,0x596B4BDB5770F79D,0xAE0A5FE89BB969B9,0x000000000000003D },
    { 0xE8E840F9EE19802B,0x33A36BD34CD021FA,0x13472C59BAD376F9,0x9C3A76A8304A8A88,0x1D17D867594B5FC2,0x1460F538BC95244D,0x3866C6EB7E5D2A0C,0xDC63BC6279F27451,0x0000000000000039 }
  },
  { /* Point #8 */
    { 0x4E75AEB08523AAB6,0xD32A993258144CDD,0xE7A2EA2D3C055E41,0xC25DC24E31C1949A,0x719E3BDAA124DBC2,0x331BF1820C1B238C,0x6FB91096FB86656B,0x6A12AE8DB484C49D,0x00000000000001E0 },
    { 0x4E4B8553E97E59AF,0x6A2B1F0D8E98D66E,0x9001ACE6D49BC96B,0x70B21C8A3E8D2774,0xBA4C7DA4473972A2,0xF159EA8B7B898ADE,0x7A0E87A0CCEDA981,0xB886AB7D2F280717,0x000000000000003A }
  },
  { /* Point #9 */
    { 0xC68C02728AB9A39E,0x59979CD32C1DFA97,0x84BEC5128D593633,0x117EC8B43AC7211E,0x9AF16A1AF89ED1BF,0x2609C6647142D497,0xCB8E038563354621,0x887FE86540A341BC,0x00000000000000D3 },
    { 0x3F3F3789F349587E,0xD4B003F71131BFA5,0x2F744B76192C9328,0xB6578EBCA1B280CA,0xB835095D5C585185,0x2FEC80849EE3D8CE,0x5BFD0DA0291A9486,0x38E71F4837EEAD8E,0x00000000000001F3 }
  },
  { /* Point #10 */
    { 0xC265E6C0BF676A07,0x59771953B2B23CB5,0x518AA0145DCEF219,0xA80E133AC85B93B3,0x60C1358BC8389049,0x161692570D4105EB,0x732B68901E4E82D2,0x07803A0009A4A4E8,0x0000000000000166 },
    { 0x7DCF13716C29C896,0x1BE89AEE50D2E17C,0x1D4E994F73188216,0x9A9F50E29AD45D80,0xE7819DCB353E6643,0xB22CECD54C6898C8,0xA49150D06C296DF9,0x96A7632680A45026,0x000000000000010F }
  },
  { /* Point #11 */
    { 0xE281E3F3A80D888F,0x600CA15D5B20E3B3,0xA784FF0C8EAAB831,0x2681B7F506E27ECE,0x72C5139E879C58EF,0x48B4340F8D25FD5E,0x0F6DB6309147666F,0xBD2A0FDFBA32490B,0x000000000000011C },
    { 0xC8A7331B4C4E1A3C,0xD03AFA763C6399D0,0x5398D7125482836A,0xF83E8FEBEE9C9CE2,0x26902CABA822D57C,0x7EDE71AC82F651D1,0xBB49EC321BF0E9CD,0xC3685D4B0529FAF1,0x000000000000014A }
  },
  { /* Point #12 */
    { 0xDDA29D3BE583A2C5,0xBC0632201B0C039A,0x31C58C6F602B6077,0xC8DDBB1BBB639A64,0xDEA19AEFEA3CF3D1,0xBCA9F001E9A2053A,0xF0EC77121930345D,0x4F2CDDD43B9B8ECC,0x000000000000015D },
    { 0xEB7851A8ABF98EAA,0x12D75A839DC39602,0x252365A4EBB5F975,0x1B9301BCB8EFB6A9,0x0B489A405E8DDD2A,0xD3629E5FCE3B1DAC,0x2064A36707A223FF,0xDC7E94D10080EE45,0x000000000000014A }
  },
  { /* Point #13 */
    { 0xD40081094CF43305,0x394AB620EE84D3CE,0xE529AA0C7FB9C73B,0xF790C1C7B605EB7C,0x9B534B11A9309198,0xBA70EFB568319410,0xD7F71B810C1AA638,0x1B45A27F76365A16,0x00000000000000D5 },
    { 0x7D3CC8F088129B90,0xCDA952C38EBE551B,0xE277619231479B5B,0x94FCCC895BF8C65A,0x599148B8440FC5CF,0x355EE50733CD0D4E,0x8467BC4E70D42A58,0x67CEA449F2B6D23A,0x00000000000000A5 }
  },
  { /* Point #14 */
    { 0x02375C08D590E3FC,0x3E3C8B18D82F35C4,0x509A15E5EFC3D8AF,0x431A4BBEDD53F9EC,0x9CC7A2388421D012,0xA6017FC16C4FDCFB,0x295FD92013D44599,0x256E0A57C4DD8A04,0x0000000000000137 },
    { 0xB80ABBE42EA9A8C5,0xA5F97F3AAD742607,0xA81EF589D3FCA56F,0xB714C901EBA522EC,0xA01102BFE215454D,0x0A36584AD85F0E59,0x34B7631552BF239E,0x19298B0C053FBBD7,0x000000000000016D }
  },
  { /* Point #15 */
    { 0x0842E1353711F6EC,0x3CE5FA4535110D60,0x8312A2785475710C,0x1CEFBA22C01A451B,0xECD7B59879553563,0x35DDBB368E238E67,0x5694AB176BF4CAF2,0xB25473326EF380FC,0x000000000000002D },
    { 0xED1861C5246BEBB2,0x4210FC3AA5C75331,0x02CDD68B93D0EC38,0x05F64D14D3F13B0C,0xB6DE6F5752CA18A3,0x9848DCF4A55B1D77,0x9A417CC349688962,0xF55A42910DC11D09,0x000000000000006D }
  }
 },
 { /* Table #74 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xE0828A5B448996E2,0xDD3F4D9B516E440D,0x223B4F87AB10E109,0x766BDE384CE7241C,0x0B1CC320DCAF88A7,0xB0470E7DD75440D5,0xE3894E41BA76B7E8,0xA0341305A762BB9E,0x000000000000013F },
    { 0x4F5581D30EADF722,0x6E4E31E050D8999B,0xC14BB14802F03368,0x41F1964326A263B5,0xC0642E4C3B5F480E,0x0A3280DF63191881,0x4EE1959A78FA9069,0x7376078A557A8DC0,0x0000000000000181 }
  },
  { /* Point #2 */
    { 0x5C6DCFE8FCB68CA5,0x499866E3902E03CD,0x28638635CFF1ADC7,0xD224BF5D6538CF65,0x59FAC5C2D7C55F70,0xC710492699CDA00A,0x043001C39AE92020,0xBAF959DBC325CC56,0x00000000000000C5 },
    { 0x76AEC243E69664A7,0x0885DBB386D69554,0xE4A288833647325C,0xDB1ADC9A6E8E47A4,0x3E2230DAB14E1019,0x49A16A19AC7DA236,0x12EAC3E98DF54DAF,0x78D48EA77964AB39,0x000000000000008E }
  },
  { /* Point #3 */
    { 0xCB52BFA5386C4E0C,0x9AD631CE173C0506,0x7779FD8D1F481A10,0x0CE5155CADBF3B01,0x946C3D6C4A66E714,0x82363B8EFC39257A,0x5BFF5F529F7DDFA7,0xF6019194C959F74A,0x0000000000000195 },
    { 0x97E049CCD1A7E5E3,0x20B70812BA5ABA47,0xAA1AE913EED6D2FE,0x3A742BCE668BB4B6,0x4527C1A564D51F79,0x70E8A3C89295BFAD,0xA30663031CC82FC0,0x2C7C0291FD3F6160,0x000000000000006B }
  },
  { /* Point #4 */
    { 0xEB4B23274247E72E,0x6660A1E5175CC2DD,0xB6CB2DB4FA58CACF,0x035B7AB3F93C9B5C,0xD2582C31BBC94809,0xB80863E54328D05F,0x61F99DD580B782B5,0xA17FB8FC59E27DB6,0x000000000000004D },
    { 0x4BDD2A99E6B71BDC,0x586B3CE9210C0D88,0x590B0C459295119B,0x1EE8B021A417F7DE,0xCE83AE394EFECB1A,0x06298F05EB3E3C84,0x0E13905295E6D8C8,0x5E8A4031BABC6BD8,0x000000000000011F }
  },
  { /* Point #5 */
    { 0xB9B6EBF9B1351AAB,0x3199F6E349A08F81,0x3CFDB7175DF347A9,0xAD627841B15D1ECD,0x994AC9A2D4918F31,0x3F3B84A1A482E07E,0x82F47118D01DF2A1,0x1CE7C2530612E165,0x0000000000000117 },
    { 0xA4D357D1B1A67846,0x0ED36337A5F6313B,0xF759ACC56224B03D,0x9F79550A43833ACA,0x71238A8D5B80BAB0,0x2F5D78D1F5A7E9D2,0x34844C10AF79CF0C,0x202250A1878E03C7,0x00000000000001DE }
  },
  { /* Point #6 */
    { 0xAA91D38BA207739F,0x8C5E7AE36CB4B052,0xA785648126932370,0xEC5F6683810F6A28,0x56D9B66FDD4A1A39,0x936D24F5B4AE3605,0x5B89ADB53CCEFA36,0x7D893E3AC6A0096A,0x000000000000015E },
    { 0x98CECB6D99DB465C,0x66DB3E132C1113B7,0x9DFAFBCA881D1C5C,0x78D6B56821503E69,0xB0197722F05AC1B1,0x2523D52BC45E608D,0x8E77C13CEEB9EF93,0xC5C6E0E756A50594,0x000000000000010B }
  },
  { /* Point #7 */
    { 0xF7ED6FFDF50A3D85,0x920B807525ECD014,0x9074D5D14EBBD57E,0x2C7656F08CE72DFE,0xD17C1313336DF7B8,0x342593894A6A7112,0xF9112C8171D23283,0x80EE8F87B19617B0,0x00000000000000DA },
    { 0xD411F8B2E36790D1,0xE0352D7AC03B68A7,0xE2B16D4E55DD2C1F,0x3282A3DE3B874068,0x26FBC96E1B3D4991,0x42F10B4520D08473,0xF17DCE35C84ED8E7,0x78DA06E791F15069,0x00000000000001DA }
  },
  { /* Point #8 */
    { 0x709AC1575B6E48AE,0x7EF27B0F95EB72EB,0xB1BCA839D987E330,0x16D0F9B110B85D29,0x08D6D9B2A5E559F2,0xDCB7602D980B6DAA,0xB38F08A5F2F9B64C,0xD9ADC282E2CF92B2,0x0000000000000164 },
    { 0xCC6A51913137F926,0x9E4CCF8488821C6C,0x0B3991794C8BABE2,0x4269EE3929C119F0,0x1374F63A3509D23A,0xB7563C4386B73069,0x2AD51F46077F8BBB,0xC383BF47D8D3310C,0x0000000000000079 }
  },
  { /* Point #9 */
    { 0x7BFEB9AF12391B95,0xD79181D83D2855D9,0xEB0CB5BA84BC3F73,0xC7AAEE27D4577568,0xBEBB1D976D62AAF2,0xDF7F87711C0D2C76,0x8E735DC01390EFE5,0x324A3FEF10B0342D,0x00000000000000DD },
    { 0x0F074D4BE5EF45E7,0x2AF56ABEE6C99CFB,0x55F70E37666B03E4,0xB1F0116AFED0A21E,0xF9FE9C995603998D,0x70507E45A43BFA71,0x68D2F7D4CE0E4A10,0x819FD53796D5A95F,0x000000000000006F }
  },
  { /* Point #10 */
    { 0xF2F55E6187055F7C,0x96C05BAD1C7B6AE2,0x24D4BA609B81CCC6,0xC4C666E9B704F1F6,0xC505D03FEC354E60,0x6EE24BEA512B62BE,0xE86BC686B5AD8726,0xDEA6279EC3FC6E18,0x0000000000000196 },
    { 0x2BB0ED8B4F92584B,0x4CDF258AA481AFFC,0xF067C8C665362EFF,0x0341567F73099E69,0xA42FA640487D6AFB,0x4856EB7E41D7455B,0x7DEAF1B1D3730D35,0x7158DFE5D247B629,0x0000000000000068 }
  },
  { /* Point #11 */
    { 0x23095FDF14C98670,0xA48C421E9DC0F253,0xBE07424B0E23FFA6,0x2D6B8AC86E8DC32E,0xE3D6E195AD8E1120,0x2F1EE8E1FFC71DAA,0x603908BE648BD635,0xFF134805E912C300,0x00000000000000DD },
    { 0x0FFCC425D4322E89,0xC809F5ED8F09F42A,0xC1114010EF2508A2,0x5C07DC01C51CB0C1,0xF3D650A11D946EB4,0xD907AD9A51E6B2B3,0xD588D588C945F2D0,0x7DAB07BFD1FAAB39,0x00000000000001E1 }
  },
  { /* Point #12 */
    { 0x29D8FAF43544CC95,0xCDDE285818E4E95E,0x0A01B08DFE9368CA,0x40512DD7C6DBBCDA,0xCEF252A068C1423C,0x98204E95AAE7650D,0xB922928B77E51A04,0x9A77021A72EB97A3,0x000000000000018D },
    { 0x5647C6F296C7C29C,0x6A17E12A870BA81B,0x42DF0E2E73C0EE75,0xA214B4098765EE48,0xC098D30234FAF6EA,0x0F5B59A79AA0E1A1,0xD73224F17C87855F,0xB78B168CD6D2A061,0x0000000000000050 }
  },
  { /* Point #13 */
    { 0xD185CFC3F5823BCA,0x94E833382D648A40,0x719DEF2C4D22D2DE,0xE23BE64F266E78A8,0x8830CB3E752AC9CD,0x2598BC00D0F2CC62,0x42513E2C62336ADA,0x7343DA72B35E9E9D,0x00000000000001A8 },
    { 0xA38D5D2219B56641,0xD7E2949E94A2E805,0x03F06FA6A850F355,0x744779E0DEA5393A,0xF6078B4C9CF8FF02,0x3A150184D43248FA,0xF2B064F88CCE580A,0x3894F51466EAF1AA,0x0000000000000049 }
  },
  { /* Point #14 */
    { 0x095C54694CADDFA0,0x7DB5B97D383C724E,0xB4698E9A92CA76E8,0xD964AC2001AE58EC,0xD743F813B822B97D,0xD8DE0D8520171BAC,0x549E8AE5EA164044,0x03C9D920F8426C21,0x00000000000000BB },
    { 0x794BE56D907E69AB,0xD3C037943ABE9F98,0x9A5EAE5C84E132D7,0x9A7AFB80BF979B72,0x624910C94BCBA819,0xFEF0DAF5ADB707C4,0x7C9D0680ECC8BF66,0x342FD8B9681D3792,0x00000000000000A5 }
  },
  { /* Point #15 */
    { 0x8CDF5496EA2D6F47,0xD16475CE1384A82D,0x443C6BBE79DCE016,0x520583EA11C229E7,0xC345965D32D1EE47,0x046C5C214EFF5930,0x9810075E19D48E5C,0x3E1425909CC794DD,0x0000000000000186 },
    { 0x254D003679CF471E,0x87A8C5ED0D5A2F06,0xBC16FD945516FBDF,0x2E7C1BF26FA2A909,0x28297856237BA960,0xCFB6B336091507FC,0x0CAB1EB283A9939D,0xE49BC8D8AEC9CB63,0x00000000000000B0 }
  }
 },
 { /* Table #75 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xCDB8A92C817221D9,0x7FF2643E780ED8A2,0x5EFCCEDA56FC9CAA,0x59B5AA12F823D2FC,0xFE97818B9DBFEB54,0x2BECCEAFA13DDE72,0x5D5B53CEE8692B1B,0xF5E5AC69CAE9DDC6,0x000000000000000F },
    { 0x6EE75741C692D9CC,0xD97EB6F262A91D4D,0x8858BA5DE2924E75,0xB8E1B22A517030B1,0x651A68382AF83DFB,0xC1FB14D21C21BE14,0x87689D46C9EBA60E,0xE16CFC1A0DA1A29D,0x0000000000000107 }
  },
  { /* Point #2 */
    { 0x4021A24DE3C91B63,0xF7CBD01A0B896F6C,0xB005E27E145743C1,0x170D30313D2C0449,0xB2369781715E87BC,0x7EF5D8E0D6E85650,0x1A5FA6C7B232C66D,0xC0455CAEDB20FFD8,0x000000000000001F },
    { 0x3ACF9BD305C7C488,0xBF769BB0294DF5B3,0x8D5F90958FA692FD,0x9B20F4C777AEF48D,0x312134317987AD09,0xC0B03AEAD6A327E1,0x5BE9A205E6F56BAD,0x2DB39C5E6C7FF60D,0x000000000000002C }
  },
  { /* Point #3 */
    { 0xC9A5E2D7B0A899D2,0x225E0A7CEC01AD8C,0x184D1C3D1B354803,0x28026887B9B5BA7C,0x59EB397F26DC425E,0x719DE97155D8724A,0x9823C8FDACA58401,0x5793D2C738A1558C,0x0000000000000010 },
    { 0xD14908B22ED1274F,0x087A1B8F8B51E15F,0x879FADC67D3336DE,0x9F78BC5492D80167,0xF5EBDDC4D21BCB96,0x7D24EE7A5B68A23B,0xCD432917FD9BA4E8,0x38B9E8B7F829E95B,0x0000000000000102 }
  },
  { /* Point #4 */
    { 0x06E672911FBE4B1A,0x2DF4C01C7328B43C,0x811847EA7350889A,0xEE53F7EFF19988A8,0xCC3FC6D371578D7D,0x20682A7B7B0F48EC,0x6979A4F21EC4CD51,0x58272B7C845BC78F,0x000000000000000E },
    { 0xCEEC799C35E8EF48,0xA01333EFF9EC8AE5,0x5B99B83EF9262E87,0x37C4DF170F427205,0xB20CEF3FF972DEA8,0xB63AC380C6C4C976,0x0B915C3290866381,0x8817B26A91EEDCAB,0x000000000000001B }
  },
  { /* Point #5 */
    { 0x489E62BFFF25C5D0,0x347D0F519EB33D69,0xBE69C42F45C99F94,0xD626C5C9E51E7E40,0x9CC390954F840BD3,0xAA0B0DF4ECA2B6D5,0xD0E1F1D9075946FC,0x66CDDF305706086B,0x0000000000000162 },
    { 0x9B2CAA63064FA85C,0xA3A5E2BB20720800,0x2485913A5295B6F9,0xE5428476B769D794,0xC6CDE727031D0495,0x4A7BCF346088822B,0x649B0492307659AD,0x80FB444F79E8F7FA,0x0000000000000008 }
  },
  { /* Point #6 */
    { 0x7ACE3143A092069A,0x0BC9CD595E70D5CA,0x1C26DF9860DAE8CC,0xF4358CEFB881888B,0xFEDDC9766632AB56,0x08206F72B870DDA8,0x46F76EA4CC81F687,0x865B6CB3CA702001,0x000000000000007B },
    { 0xC064A2E3B099AF17,0x88BEB2371D625DCF,0x507BE25AF7B18AC9,0x46C8C36077F8ED84,0xB019195FADF90251,0x386ED5CE56C4EB40,0x46427F9C870504A2,0x156E3C6F36D0F019,0x0000000000000033 }
  },
  { /* Point #7 */
    { 0x202AD82E2F39703C,0x9A3F515E281B6010,0x2A67B042E376BCC7,0xCED04EA898EF60E5,0x3DFC3602875EADEC,0x99FFA8B4EB3BE4B3,0x2643CAAB2C56B275,0x3DBCD4F2B6EF478C,0x00000000000000B0 },
    { 0x9FAE73769A85AACD,0x41DE8DCDDE6EC1C1,0x7C1F3CD009F66E0C,0xB918C9E9D39B844A,0x1A11B5D8DECCB196,0x2B37CA082A606F50,0x5550CA7A42B68F99,0x29AA94D6371C9CF5,0x0000000000000196 }
  },
  { /* Point #8 */
    { 0x06E0332E000535EA,0x5C58E86403BBBE55,0x4D9A6DB110B9B5A0,0x7EF09CFC6A24DB5D,0x61D105F4819D4D78,0xC5E243DD82D474A2,0x8742D427886E0D59,0x08CC598E079399E7,0x00000000000000AF },
    { 0xB1AF75D1C8E53592,0x74857A7FCA9DBFDD,0x2F7F11D8D49CF79F,0x82C78C0D7C4073D2,0xBE13602FAB4C74C0,0x4282184ED0D37AD7,0x719BB29728289FE0,0x08FE79E9B09427E0,0x0000000000000192 }
  },
  { /* Point #9 */
    { 0xBFE87EE49B6375D7,0x5F00F30A1E8564A8,0x318412B83FB999F9,0x12FBCEAE809B4FBC,0x0C02BA4CF085F106,0x5811BB5735127B0E,0xD7E6B1C5618F41CC,0xB493C269F66E84E6,0x0000000000000029 },
    { 0x5318648EF3BA9AA6,0xF7848B812A487C21,0x58D3BC79B05BF01C,0xE15E32B3DF942CBF,0x92244CD25C3BBB45,0x05C0993643F3A481,0x381CF34A395F854D,0xDD98953061989306,0x000000000000017D }
  },
  { /* Point #10 */
    { 0xFB9970015EAA1129,0xBEC9A530E84DA535,0x133710955D6AFC1E,0x7156B33510B368ED,0x86D22C634C902F9E,0x64EA7336EAF83F1B,0x700571F6D4313851,0xE6398407A8FB758C,0x0000000000000191 },
    { 0x004BCB3AD7673444,0xA0AD23FF6C5D7B10,0x86969ED559AA896F,0x80C4897508A9F27C,0x37A8337CBA7FC097,0x295B4ECE65A34328,0xB14ECEDDF56EFCCF,0xCF9265EA638D1620,0x000000000000017C }
  },
  { /* Point #11 */
    { 0x56213EBEE86173CB,0x440BFFDBED2D7173,0x48E92CCA2C77B64A,0xBE08B1FB1D940567,0x12DD16DAD61D8922,0x993CBDBBBBF13F60,0xD9F8D75738CD390E,0xAAB1F507AAB7342A,0x0000000000000035 },
    { 0x2CCA1F8207007518,0x2F9E1ACA7F62C203,0x20583B4423819FCB,0x886DB824D7919ACD,0x1DF13CA0591BE9FE,0x5784CC61B3826F9E,0xB54060A13D66935B,0x4BA603484D515D97,0x000000000000019D }
  },
  { /* Point #12 */
    { 0x91A6BA108D64773A,0x18E9F8C089AC1F66,0x49F08C886FF68E9C,0x57B6FB9131913442,0xDCE8F943D9BE3A61,0x03A6D0137C897A92,0xA3CF84D469451D27,0xF9D603B978585859,0x0000000000000019 },
    { 0x9B651EE0BBE619D9,0x6595951EDF219411,0xC4B2FFB73E53E02B,0xC32B5AA6F8BD17F1,0xE7788F4A97F05123,0x31D33ABEB624663D,0x9E736612D8B9FCD9,0x6B948711FA3EAA15,0x00000000000001A5 }
  },
  { /* Point #13 */
    { 0xC54B9F04F1A4F8BC,0x87CE476D63116228,0x956256F5BFC97DA3,0xF3C7329EE8CADD3E,0xF557C82BF3FADF0D,0x0BBEAC6ADE2ED8C8,0x192D0206FE73D1B8,0xAA7B9F81834956DF,0x0000000000000127 },
    { 0x0FBD989F36C5BBFA,0x9A8A380FA2CCB934,0xEBC3CF6D5E065762,0x5BF1D8F8E089985A,0x0DC41B95914D3F58,0x2CE8CC418E0B0412,0xC571823948E0A548,0x9595FEAED8C05CDF,0x0000000000000161 }
  },
  { /* Point #14 */
    { 0x7F209595588BA3F7,0xE2407C9A57EA6473,0x9BEAC14648C8914F,0xA76746DA7281653D,0xB98EDF137B9EAF4D,0x4AF237B992B8E681,0x9681674885D4493F,0xCF67088B2D55FB92,0x000000000000002F },
    { 0xFC9967792F89CD08,0x62BF8D1B54CBDDC2,0xD9395C418DFF283A,0xC384A2E9E7FFADD5,0x39F0E602BEDF1036,0x0FC173DCD28E10D4,0x574C346FB4A775A3,0x9F62FEF62B897266,0x00000000000001CF }
  },
  { /* Point #15 */
    { 0xC0D55E4F50AEBE81,0xED7B05D635FD0846,0xF9B004A8DD7588DB,0x871531A334D41DAE,0x380A08E0379F2535,0x75B4F5AC48F7835C,0x789356F480DC1121,0x4AD112EB47A35998,0x000000000000004A },
    { 0xCE9A32BEE6A57EBB,0x47CD1A1DC63A9C56,0x2A74BB2522D8AC6B,0xAABC0C37774648BC,0xEDCAA64FA6D23947,0x14E8E7522A7530E9,0xB59758DCE6F6D059,0xF9106A167DAA28A8,0x000000000000013D }
  }
 },
 { /* Table #76 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x163A9E62EEC6E312,0xD11432C1459162D8,0xDDE7D941A25D4934,0x9067028E8D868AAD,0xB71B17085B6E3D21,0xAED73637E95D3C7F,0x51BCC93C1DCE0D78,0x2F45D06A504A9D0B,0x00000000000000BE },
    { 0xEC12EA4B300B2478,0x91AC6EEDF2A48388,0xFBDC1BBA7A7631AD,0x5B2669CB79D5F4CE,0x219D64F948C8F025,0xADCAAB29AADB5873,0x3B07AF1C671BD673,0xE66E7C67B7F2D8F5,0x00000000000000C9 }
  },
  { /* Point #2 */
    { 0xF03E26842BC15CA5,0x0B130B09BF196674,0x3C27538756217F5F,0xB26D17D4349ACA89,0x3FAF18590269BF70,0x3CDEB74FB288736A,0xEBA8F6007E38EA96,0xD24052C851DA8C99,0x000000000000015E },
    { 0xA5582BACB2F51CDB,0xA325B5CBD0A7F7C7,0x065A27F009931317,0x1ABD17B6CDDC78EC,0xD8FD426937962CE7,0x5D8403C8002CF3C2,0xE62F5305E3EB09A4,0x1900F36CEEAF6FB3,0x000000000000010A }
  },
  { /* Point #3 */
    { 0xD142BFA992701A9A,0x0B59D01447539E92,0x7CEFEC6E8724475B,0x5C77D10DBCFD641F,0x4946DBABDD42EB47,0x4AE66C3A14F1C33B,0x05BA3E754C9F2C71,0xB618A5071FC0F7B7,0x0000000000000065 },
    { 0xDD94EE057C169A16,0xA29E26195A337E5E,0x30E106EB9AD816B6,0xB91E66F71A17810A,0x46ABF80D5B672E86,0x0F40F077F89626FF,0xA474DFBE8B67B224,0x9D3AF9248053AA79,0x00000000000001FF }
  },
  { /* Point #4 */
    { 0xCFDC285DF79421D8,0x263289988674686E,0xF991086E1ED73CD0,0x65046369A36BD06D,0x9712BB0B72ADCD0A,0x9B2D422F5FAF9C7C,0x7E3989F851491C47,0x9FC24BF809AEEAD9,0x0000000000000029 },
    { 0x8584EE840370ACB9,0xED56C569EA40417D,0x6443587557B4CB9A,0x752C5FA691D35C5F,0xBBCF8703ABD0EB6F,0x0DD72D15C233DB59,0xF2B7A1AB692BAAE3,0x6EE634377BAADFBE,0x0000000000000111 }
  },
  { /* Point #5 */
    { 0x97DEFE3D7938D98E,0xE2458FEAFD0BEC69,0x7DF8D2B58B42DDBB,0xA82AAB40FF39914C,0x78549B01D30F07E6,0x253F8C461331557E,0x771750D919648CCE,0x96AD6776D045BC36,0x00000000000000F2 },
    { 0x4A2EE334E08B83F8,0x3E9C4CB72E3086DE,0x913EAE4B9936BAB0,0x3CF83551D23CD36A,0x7C51D84ADFD27D4A,0x2595A90F4D006EDD,0xB2D5C68461CC7BE7,0xBB02BD59A4B310F9,0x000000000000018A }
  },
  { /* Point #6 */
    { 0xCAA727068EFB0157,0x713A7F37F08F035C,0xFF58C6A1AA4FD5E2,0x760B066000A48205,0x4A39E66655F07CB4,0x0F6BEDAC67558061,0x9EAA88C266A118FD,0x8D9EA75C97D29CA9,0x0000000000000190 },
    { 0x50A4BC7ABC6094F3,0x105120CE68F17D91,0x514FDECA4E559F9A,0x414F4C0EE8D688CA,0x1B91555424DE5AC2,0x5D983C0E298823DB,0xA537321243264448,0x4BAF77E986EEDE9B,0x00000000000001CD }
  },
  { /* Point #7 */
    { 0x47212CD83110EF21,0x351356CA7DAB31DA,0x5C31ADD7777A302F,0x44844EB4DC66A1C6,0x559F3FB428384807,0x95DAB974FF78DEE6,0x2FE12E92FB20857B,0x41436000EF499BBA,0x0000000000000106 },
    { 0x5E0E5F369DF7B969,0x2C96F308DC819D59,0x3258DB7411CF4119,0x6246DA5476676D2F,0x5BE278CFCA079F54,0x61AB6EB06E36452F,0xE7742741461FC9A3,0x252FB6386A926FE5,0x0000000000000171 }
  },
  { /* Point #8 */
    { 0x70C5ACDC38693D3A,0x9EDEE68238F054F9,0x16E053F22960CEEE,0x5926857C28BFE7B1,0xB9F7420E6145F8D1,0x9E0C42F59C0298EF,0x50B7210EDD7D9FC6,0xF9E4BD53D7BE096F,0x0000000000000078 },
    { 0x428C2455ED19FC57,0x9E8F777D56AA75DB,0x4CAEBA30A671D991,0x5F927D79EAE0F53E,0x00D6AD369E4C2A5B,0xC8811438A2E12D0A,0xA36D664EB2AEB4B1,0x74E76676929A8748,0x0000000000000191 }
  },
  { /* Point #9 */
    { 0x3E7F4206369BFE8B,0xF7C42274AF7CDBC3,0x8FA8ED40C0EDB213,0x5852ECD3E06D72A8,0xE52F1845D29F7845,0xB372FFC80AFE7FC2,0xF229E1D98EA3CC17,0x13A0E69155BBC4FD,0x0000000000000164 },
    { 0x6815798F090F7E0B,0x1C2011411BD0D868,0x5259AEEF50DFF2F7,0x25FB13C97A2313DF,0x06669F01C9E244B2,0x7B68A1C0BA79CF7D,0x9C4A4CB0B5DB0C4D,0x48BA264982A53630,0x000000000000018A }
  },
  { /* Point #10 */
    { 0x5CD1733F942E64C8,0x038A7785D8C04F3C,0x5339E19F1C75537A,0x5269B5863FEACC78,0x9877E6750D36FAD3,0xA7D5722FF6E235DC,0x0190A36B6FF80BC6,0x45A00C1DE9E3B5A6,0x0000000000000020 },
    { 0x2DD303F0D1C960E6,0x1633F7397D9064EC,0x09DEF006AB43701A,0xC853B5367B3EA0EA,0x1D9B2E1249BDE0EB,0x9ADF2C0E30EC0A26,0x43A74EF8295D3F08,0x1E0AD999FE343712,0x000000000000009B }
  },
  { /* Point #11 */
    { 0x0C0B5A850717E973,0x9365F99D54775273,0x7D9186D993AB23AC,0x7DE82D802647CE6A,0x7A93B7E86EFF4116,0xC319564AB906E7B4,0x34DB307BC89A5CC8,0xDE5986C143E6EEAF,0x0000000000000143 },
    { 0x0629EC0A101E9D25,0x0EAB815D298346DA,0x14B1F00F757AA114,0xD231D637244EFB91,0xD2F4B36C6C54EA71,0x9A10897BECBAD76F,0xA24A8C3FB3A99370,0x718A5671F92BC101,0x00000000000000FC }
  },
  { /* Point #12 */
    { 0xC02755BA642CC528,0x88EE0F5A4C35F2F7,0x840261DB84C7B28D,0x85EB6E5E4CB47357,0xB740C99FDD8285C2,0x1402EB410A6D4F21,0xE9040EDA832C6291,0x8331BBD082B87F9E,0x0000000000000057 },
    { 0xE6199EF9CCEE98DB,0xEF97661378E8D295,0x1B91CC248C9ED077,0x210B43278772DEC9,0x47CF9E2001A40F67,0xCC5E7B97274EC5C9,0x509EB6119BC17C73,0x427D670A8BB525AC,0x00000000000001BD }
  },
  { /* Point #13 */
    { 0x42341DE665DC789D,0x7949F29C0D2AFE09,0x3B788B0707105206,0x241A037185B015D2,0x6F1BAF76B3BFAEEB,0xC75913F5DB1C2C34,0x0C3B58BCC9846129,0x3F45E4DA04AAB509,0x00000000000000E9 },
    { 0xC93FE1FFA98D5406,0x5964E109F019AB2C,0x5BAA319092D60D46,0x616513DA21301CEC,0x09C67E93F3A41A0A,0xCBB75E264D11DF32,0x47A595838A3D3846,0x7413EC0A5E307C49,0x00000000000000E9 }
  },
  { /* Point #14 */
    { 0x23688C14909FF69F,0xCF0D66B8A241AC95,0x68F0C2A43444F59F,0xB5F5C969AA56363E,0xAC862C5141645600,0x1C3F372CACB5A15D,0x2F4FFA77A703199F,0xEC7F3BD46E0BAFAE,0x0000000000000167 },
    { 0x791EAA9AEBC5522E,0xF26FCF75F328F7F3,0x5D255797376EBF23,0x97F2C498391F2646,0xB9DC3D219A139B25,0x3CD01A0FB7FCABE5,0x00EAD18839A68171,0xB60FC14C4EBF66A2,0x000000000000004C }
  },
  { /* Point #15 */
    { 0xDAC5583B18F65BAB,0xB9166FE7B50FE6E5,0x5FD84EC130328982,0x473C09BAD8CB9EB7,0xC2941CF8CE1A2949,0x9605D42C0560D2B1,0xDAFAB1014DEE24E1,0x0F7EC492403E8242,0x0000000000000054 },
    { 0x89A718B2C3DAE982,0x0E40BE8A63E88A93,0x59013DDED8755A95,0x148827E5726FB0C6,0xA54E3F5A9973B383,0x4029C48DBEB80663,0xCD3301CDD7037616,0xF7B88FA7C5D387F2,0x0000000000000016 }
  }
 },
 { /* Table #77 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x358EB53667DB4570,0xAED3F999685FA5BA,0x4593C950CB571FCA,0xDFF7278C0411DC5D,0xD62A44643BFE7E51,0x53B87CA249F6F05A,0x72327899F2C3D2DC,0xBAA194AA9DF4DA5E,0x00000000000000C7 },
    { 0x3E73ACCFB50A3E06,0x0D8EBEE30754F2FD,0x3CD0AE954B3F3FD1,0xC4A4EEE0C08BB2DB,0x7955296319D71E5D,0xF91E1AB7872E35C9,0xC85090F6F6C102AF,0x8EDF8C5D1E42A1BA,0x0000000000000179 }
  },
  { /* Point #2 */
    { 0x56923E55F33C5A4A,0x1C5624EC829A3C22,0xED234E3870000295,0xA8467561EDF3FF42,0x717A939E9CEC9497,0xF80E28024E6BE199,0x5023BBEC06FA7B8F,0x16E26A9DDD95C07B,0x00000000000000FD },
    { 0x88091D673C3485E4,0x0377260FD40B6B47,0x6D9C6DF416F7B3AB,0x65376516F71B1FDD,0x89CC11F991956D40,0x58992A09807610B8,0xDEB47AA2B2799C7E,0x3EE5834C8A327765,0x000000000000012A }
  },
  { /* Point #3 */
    { 0x421B840E80905A7A,0x97C7F1D394B48CBC,0x421A23843B79F360,0x1121A2D8EAF59EF3,0xDDBE9D9959FB65D3,0x6AD2BE2371D9D306,0x36FA0077789AF534,0xB928A6E78013DC59,0x000000000000017B },
    { 0xB4C26798A38D78E5,0x8884DD394CF38545,0xB74DD46112A2023B,0x1B242F854133277D,0x401D32F2D29D7071,0xCD7C9AA43D2E2A0C,0x9DF2157E06BA6AD8,0x749BFC4C80E2C3C5,0x000000000000018B }
  },
  { /* Point #4 */
    { 0xCCF8B57AEFFB980A,0x82EA22F5D0108B23,0xCAB6A69F6C902061,0x7A3D74D843663F25,0xB12CA29A0AD5DF2D,0x9D3EBBEB2F9FB277,0x6F975E2189BC5273,0x75E8BF950929DECE,0x00000000000000A9 },
    { 0x14493740E1AF64E4,0x9CE3AE66109961DF,0x36651BB7E31F4FFD,0x18B7131CFF1FCFE2,0xDED3378B085A67B7,0x28EFB2896E283271,0xB66DEB9A73427AC3,0x3C5FD6D2A9BAA451,0x00000000000001B3 }
  },
  { /* Point #5 */
    { 0xEC1F6A5762EFD94D,0x1D80B5E87B95536C,0x01F8BA60AF47E2B4,0x6E8AE542A3B0E6D0,0x5ECB52D9E45FEFB7,0x2108032A327299A8,0xC49FC5C5044ED33F,0xD1FD083752CD0833,0x00000000000000E1 },
    { 0x3F6AE9B6CDAD11AC,0xAD3F0FA813BB828B,0x812626816FF056E1,0x2FD37492A73196CF,0x172BEB76DF90D5F4,0x63F2C6E466144036,0x3E1F497457F6D086,0x5E0D8E49FB6EB366,0x0000000000000095 }
  },
  { /* Point #6 */
    { 0x611F4A795E2D7653,0x966E843CCEEBB0A9,0x2E358CF506E8A15D,0x2CE41DC740A74FC7,0xA2FDEA4F5EB455B2,0xBBBD718F120FA4D4,0x210BFF82030FFF11,0x5A1B943AA68B00A0,0x000000000000002A },
    { 0xEB814A67FF037BE3,0x3B08220469F52C59,0x3F72143E74FF3224,0xE7E85CC436F89AED,0x2AFCBE04CAAF314B,0xF8C8BB32BF93FD35,0xE41F8328AC1DAE25,0x5318C6D7BDEB2001,0x00000000000000F5 }
  },
  { /* Point #7 */
    { 0x630190BB95989889,0xE041DA504E659DD2,0x5D88D99B5DF8E753,0xDBAC25445AC2E158,0x1FF6ECE7699EDA49,0x3D0860A21051BD60,0xD4D8685740C3A989,0x2BFCC26C4002D915,0x000000000000012A },
    { 0x0C43772C2F4ACC7F,0x54963F2FE3753D32,0xC699BE8765DC40E8,0x6DBC95AD81560A01,0xC805D7411DEDF025,0x46B049C177FA74C6,0x7C0F62FB288C1133,0xA8A2E1F9E6F066BA,0x00000000000001FE }
  },
  { /* Point #8 */
    { 0xCE24D42C1B72E95C,0x7FA4289BEAB74B64,0x42BA739E523FC1E5,0x9293167B814C4FC8,0x4418FBFD8623DB10,0xB079853F76A132B6,0xEC5BAD8ABF394947,0xC78E5748E7B0A665,0x0000000000000169 },
    { 0x6038AD95D7EBA9CE,0x421ECDC9572F3671,0xC6B7EFFC60BC3CFC,0x2C4B7B77A48FD001,0x80280EC9D57795E8,0x350815C93A7F6D67,0xCE30BCDD7DA13B86,0xE36DA7B123C894D8,0x00000000000000C9 }
  },
  { /* Point #9 */
    { 0x31105C7864EA99C5,0x513FAF09396E75E9,0x34A79931A04B75A5,0x3E026B0ED4C954F0,0x70D2AEEB235BF7E9,0xDD6C193BDF5682B4,0x7CF6E8F29B1D9704,0x41FC6B32026EAAC2,0x0000000000000132 },
    { 0xD09919EF5413AA96,0xDB06523A393FC9E6,0x8C6F8BCB74809CC3,0x7D2A5B46B27E50AB,0xC4F0D0792A507C1F,0x28C3944B4A751FE8,0xCD55D261BF88E984,0x56D48D0616DA21B0,0x000000000000008C }
  },
  { /* Point #10 */
    { 0x2CF7FA7761BFA954,0xB24BBEA98E5118A9,0xC5C77927689DB327,0x8D12557569C43762,0x41F4BB986C359329,0xF0715FBED02CAF97,0x3319662497538059,0xFC8AE58B5EA0263A,0x000000000000005E },
    { 0x7245131CE020630F,0x459C5721EE23BA9F,0xF25F9BE9AC36A41E,0xBED1A35049589C41,0xA72555B2C636E1CB,0x35398149C006B213,0x7761C08B6A446A84,0xED021D8673E41C6A,0x000000000000001D }
  },
  { /* Point #11 */
    { 0xF8D97141473E6D47,0xE73699D31E25F25E,0xBB3AA86000986563,0xD8158F88653B68E8,0x1C7D943EB586D23B,0x1074EE6888EE5191,0x6F60808B0B60C796,0xA7FA912D84DD4730,0x000000000000002A },
    { 0x589BCCF26B6FE852,0x902C7B946ABBB0E2,0x9145309822DB1367,0x6FEBDA2D555FF37D,0xB6FD9B3008771767,0x968892ECE5A8B409,0xFE1910A2E1233793,0x13FE7F04213D591E,0x0000000000000184 }
  },
  { /* Point #12 */
    { 0x59975B4FDFC4E7DD,0x35D9E63A3FA2A870,0x7D6653749901F064,0xE89CAA890E9DCA74,0x6EEB63913D92E7F8,0x19D9AF358A4CCBB0,0x405C35C2928E5CF9,0xED771157DDB633FF,0x000000000000008E },
    { 0x6AD1DCBC685B9A90,0x479AB5746EFB4E61,0x27A023B6E72992C3,0x3607DECAB94C54FC,0xFB2F50D0FBF16AA6,0xAF3F098398C7C140,0xD1A20E9EA3814586,0xF1BC43165412B23E,0x000000000000018E }
  },
  { /* Point #13 */
    { 0xA047B2E89A705668,0x2FB2A1B74CD0215D,0x90EF0BB734146DE2,0x340074458C103E1E,0x4803EE28D95E743A,0x574F1CA6BB762BDF,0x703FEC4E2ED0DC5F,0x3F19A069D27172CA,0x000000000000002E },
    { 0x3DD8F275C44BCF81,0xA32F84AC517A8AFB,0xC065BA2BF26384B8,0xB3FADB9619D14499,0x6258447D07523EB7,0x4C8C791AFD107696,0x041AB2E7D111B4D3,0xFD008507E28A3A07,0x0000000000000165 }
  },
  { /* Point #14 */
    { 0x75D00875FBDD51CA,0x8C2E5FF75D7AA834,0xEE4FBE0AA4A1A123,0xDF61CE6939EA5515,0x8A747DDAF3EE68BE,0x106C5C5D3CEDFF21,0x51ECF5362C3519FC,0x6581EC138CEFA861,0x0000000000000187 },
    { 0xA8668F9D0EECD8DC,0x4DC8FBE96BDD6803,0x5AFF8CDD339F6F89,0x7A39F0AB91D488AC,0x20E1DCC8D8FA0333,0x12E03A970FB08C2A,0x265C2724173AF27C,0x962FA034CC395512,0x00000000000001BD }
  },
  { /* Point #15 */
    { 0x5FA1AA9D9283F38A,0xE0DCEF924846CFA5,0xEA5D81E7E4C20234,0x5959DBCADF690B8C,0xB77391B0C6E466A6,0xDF6353C23982757A,0x6516E711B064D2C4,0x6A29F216DF8F77C9,0x00000000000000E5 },
    { 0xB5FD98187A2702B1,0xDC2A2E1D49291BCF,0xF18DB82A493DBB22,0xAAEF9AA431732B87,0x6CE115F70F27262F,0x4784C2ED93AFC24B,0x97DF3C8932540AD9,0xC01564C169F2A2C6,0x00000000000001DC }
  }
 },
 { /* Table #78 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x92401AB5853572E7,0x957D2CA6EDDEA020,0x7D54DD653F9FBD6F,0xAD0C7D092E05D05D,0x6656FBAB04183B30,0x543B50170B716D5B,0x2481449D9857D796,0x86173B6DE3A39722,0x000000000000005D },
    { 0x7130D0CAE71E511D,0x168EF9D935663592,0x63A9936EADBF816F,0xAF63EE57D4F7A44A,0x59F21032CD0EA152,0x2F552046A881056F,0x26EDA9A621BA6BF5,0xE75991C7D0A0CAF9,0x000000000000004C }
  },
  { /* Point #2 */
    { 0xED90E62B5E3CED2B,0x160214BB5A919213,0xDFB8AC078CB4FC2D,0xEA5AA6E7EA384DB0,0xC9492ED2F916FB11,0xF40CECCE1305BD78,0xB98AF5013F28555E,0x4E9F84B268417D62,0x000000000000014E },
    { 0xBE791FEAAC7DF2E2,0x15C9429CE745BA60,0xB02C1705198A2D50,0x0A67CDCE9B6E6A44,0x640506295AD00221,0x75620EA82B314076,0x64C89EAD87B02AEC,0x0E5FF515A92113EC,0x00000000000001CA }
  },
  { /* Point #3 */
    { 0x52A60DA401ECEA43,0x00E1AB1441BF6835,0x785545CADD97B88A,0xE2BC1326D2F2894E,0x3C730457E398BF19,0xA4C297531BDD3170,0x7F01A08492EC7E73,0x54D483B824BB9D11,0x000000000000005A },
    { 0xEDC13DD6BEEA4DD5,0xBCECC285125EC53A,0x8B7DE1BA5BCD72CC,0x1853DBCCDDBBC9B6,0x799B97B28F47FC1E,0xC01253B8176CCE73,0xAB6C5FDD5430BF2E,0xF9250653CF5B31E6,0x0000000000000042 }
  },
  { /* Point #4 */
    { 0xC071157213CC2875,0x422583136EC01830,0x32CFEF4101E95528,0xA8741CA0AF8116B4,0x3195F7F358F1FA26,0xF2E969281144142B,0x5A9C331F6B179BF4,0x45E363F236C6C42F,0x0000000000000057 },
    { 0xBE2E55F12C04C8AE,0xA522F7D53AF16430,0xEAE2B2C42904630C,0x58F5C76E8E151736,0xDFA21EA65AEE8E9E,0x103B7AD681717F92,0xA89E274A9B4464EE,0x316F580F2DAA3259,0x000000000000004E }
  },
  { /* Point #5 */
    { 0x7BD03EFEADA6FDE2,0xBBE77A6933D65185,0xA23A4C71DA2DB001,0x3ED58B4332A63515,0x3AE797B580DB0330,0x73B1113CBBE686E0,0x08F4630F01CAC265,0x2C06080D2471F057,0x0000000000000084 },
    { 0x575BFD8CD72ECD49,0x67E84670056FF098,0x01FA38E5255B8EAC,0x0B7B82DCE9233746,0x057D4FD9B8093F35,0x9C7551974FFA1D03,0xEFB21A914B535517,0xBED68EDE0BC11412,0x00000000000000B8 }
  },
  { /* Point #6 */
    { 0xDE9D3C54D19537DF,0xCDB1E152E0F7F823,0x86B981C015D22C6B,0xAD513642F73DBB0E,0xB98B75B428A57165,0xE7F67AC05BC5362E,0xE6C842667E87737A,0x441CB5C79500E486,0x00000000000001B9 },
    { 0x0318E774A90102C4,0xFF234D09FCFA8DF4,0x12EF1F675CC3D689,0x1B8B92C6F3D6891F,0x77E4DDC0B11B3D7A,0x950AB55FAC47EEA1,0x1C3D56A76DC155F6,0xF70100C400B560D8,0x00000000000000B0 }
  },
  { /* Point #7 */
    { 0xD4F24879D1C08EFE,0xA5E9BA059ADA24B4,0xD2CDF316084971F1,0x51B2C138DDA81C06,0x50DEA9BBD2115D16,0xD472424C272B0ECC,0x4A7B56443513E8EF,0x4A64F0FC3277134C,0x000000000000004A },
    { 0x7AE9BAA3507427FA,0x1AEA2A4996D38106,0x0209A4E995F53E5A,0x2A6D84AD9F87AA0D,0xC00B858B47769D56,0x42F17CD2B64A452F,0x58A23140CE95AA06,0xDB36A78A418F5F55,0x000000000000001D }
  },
  { /* Point #8 */
    { 0xD1CE126EEC3D1383,0x0C7F980A4805B18E,0x65945086FC1B1F4E,0xAC1703AE092E0CA0,0x834C77F98B5EE5C0,0x3E722F576D19FBB5,0xAE8A944AF6770BD1,0xE1D110502A7C7101,0x00000000000000D7 },
    { 0x62029FD2CA303000,0x366C72C9ACB52ECD,0xCF89C1AACC8DD8A2,0x95C235BF5D1B984D,0x3434D10DD1A80D52,0x094D0A8F77E95ADD,0x03890027D1203660,0x32FAF27329791AB3,0x0000000000000075 }
  },
  { /* Point #9 */
    { 0xEFB02E38DAC5A843,0xA721043CF82BF9FD,0x3486A36CF29EB485,0xF3DA92D24DF0EB86,0x92B7DC8F920151B5,0x4029BE6951AC7E31,0xF805C396CE306539,0x2915B7E3855DF2DB,0x0000000000000058 },
    { 0x144E4AD7105DA111,0xA29E58B6E8093234,0x289EBF17E6EAECD6,0x7A66164FE47686D8,0x9B777A6A0026506F,0x6B5B02A47AFE205F,0x3DFAA74ADD661E69,0xA22269CFBF55254B,0x0000000000000003 }
  },
  { /* Point #10 */
    { 0xDCCDC00A0FCAD662,0x7170F862F84039D2,0x166E3181EADF10E4,0xC7EF1AD6DCB8D8D2,0x82EA059D40DC6DCA,0x2F4128C7BD2A58AC,0x2BCFEA6B9A73AF8A,0xB5A656FB310BC675,0x000000000000016E },
    { 0xC50F488976695637,0x37C0B4D092E433D2,0x38B52FE4FA32B982,0x2B62D87905E20FEF,0x8FF01CA013AF38A5,0x9F244A0F13182548,0xFE550D74420B0E9F,0x1E251C0912AD3E76,0x00000000000001C6 }
  },
  { /* Point #11 */
    { 0xA32000D2A34B6386,0x9764CD9C6C95A6EF,0x450689665EA38139,0xE049CAFB6F5CF696,0xF1CA1D7C4D44868D,0xCBCD0B959051AF05,0x6E684A6CFED0B440,0x8A251E605EBE77DF,0x000000000000018F },
    { 0x4B0B108609C53D0C,0x9E6D1C53FE3CEE86,0x3C3E5F2A2AAE7587,0x282D3E85106E0E63,0x3DAE698BBF45050E,0x783C0D0752474646,0xC62E232756997ED5,0xB3868E7661D50D46,0x000000000000004E }
  },
  { /* Point #12 */
    { 0x414DCA048D7F283C,0xF6ABB3B96912D2E0,0x7A1ADC110FB60128,0x2929F83A69E910E6,0x838ABF9F887109EE,0xAA8E3C8A4ECB3442,0x82CE235E7A5F4630,0x0224C37FFC5BABC8,0x0000000000000071 },
    { 0x60E149A3B75A5E24,0x75A51CB3442323A6,0x04C67D5564414C01,0x50E192F0412D7CD4,0xDCE6E19182903D3D,0xD01AA14A768C2F73,0x7736762EE4934788,0x8DBC1328242304B6,0x00000000000001D4 }
  },
  { /* Point #13 */
    { 0x5CF90261D27D4C2E,0x6C3AA4E932D853DF,0xFE4C043DA24BE9F9,0x8D5F7BE8EF99892D,0x84852032088B2631,0xD6F625D38DFA11AC,0x0260BF61B0BE68DC,0x59A4CDFAA5BAE5E9,0x0000000000000124 },
    { 0xF9F239E53FBA397A,0xD46A5A0DB9F0D4DD,0x88ED975E1C8A385B,0xC1AE52CEDF279B89,0x76F10A46954C766D,0x11C766F174BBE6F8,0xF0AF009AE51FBD13,0xEEB7559A72CD8575,0x000000000000002D }
  },
  { /* Point #14 */
    { 0xB1E9117C3CD7A02D,0xC2A2F1B0549B53E4,0xCB430A206A82A4EC,0x2A411476E3D41B16,0x77DC5FC2E99AAB68,0x9280C482EDAF345C,0xC2CDBC55BDA06A8D,0x8ECE2F93832527D2,0x0000000000000116 },
    { 0x2A893C3282DDEB86,0xA3D246FB4ACFFC92,0xB91852CDE1D44865,0x05071FEFC54AFD69,0xB9233F5E55DA2FDD,0x6EF4E3728B9D9F46,0x3938F1BBF4BE48C4,0xA48A881FC67D2B70,0x00000000000000B3 }
  },
  { /* Point #15 */
    { 0x3B43B14CFC42B580,0xB9DE4C31321B6B60,0x901E3CD455596D23,0xEDB74DB709789B1D,0x66CE973254D55D69,0x3BE8AF9D5A63FAC8,0xAB95076AD84340B8,0xC5B0D10E8C79EA93,0x0000000000000009 },
    { 0xF8E10327D81928E3,0x0A7F7D10D425A250,0x145900CF90B3C4F5,0x41E5AE94F0A3B41E,0xB89EBFCA760D8E56,0x9B4A2F468C152CDF,0xB89C089794E7433F,0x4F1BA579AB140DA9,0x000000000000018D }
  }
 },
 { /* Table #79 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x18CADDDDA03EFD8C,0x9D59BB52AEB3A762,0x571D86BED1FD3F91,0x81642AA1D2F26D6D,0x7D1C3BC999877251,0x0518EFF8D7C2FD25,0x6A54F17037B6C641,0x8FFEDFC00D33A426,0x00000000000000C8 },
    { 0xACF67416BB54847B,0xA293A8D7F2B54B28,0x32F2B11A1F7F6B47,0xC11948BCC6D67A9D,0xC8B86B1F47623783,0x357326AA5C2362E6,0xC298BE1B6CF79126,0xF07B3EA784C5A79C,0x000000000000006C }
  },
  { /* Point #2 */
    { 0x4379897720210875,0x8E95AB32D58004C6,0x33058F96C68A6AA7,0x2DB1FDB8914082E8,0x7841A48993E12423,0x051A4E151F9D2FF5,0x618EEAC54DA88E65,0xC52113CD512C1795,0x00000000000001B5 },
    { 0xB6DACE96E93AF674,0x4EA1073BEDB5C3F6,0x4352509FA0B861D8,0x05451D6F7ADB5CFB,0x194E3ACD9A3375D9,0x6258A5AB33658D41,0x2BC60CB7F542A8D8,0x68E50E5A74AFE0CF,0x0000000000000187 }
  },
  { /* Point #3 */
    { 0x5EBBD7015A0C9415,0x7BCEF0E229572D13,0x539A78133F5A169B,0x6F3A84A4BAC0ABFA,0x822DA09BEA1D0B7A,0x9B2D6A6C05C00DBF,0x134FE65DCD8C7E6E,0xE4622A9F6301E4CA,0x00000000000001FF },
    { 0x5FBEB1F8073963DD,0xCCA648B0E595AAD8,0x5CC97E773D15C1D4,0xF2D7697062989B5E,0xF321C0C78AFE8351,0xBF361AA293A60C7B,0xD9938C1174C2503A,0xB05DAAA5E409747A,0x0000000000000008 }
  },
  { /* Point #4 */
    { 0xC43876449D2224B8,0x80C92AC5563094E8,0xEF919BDBF6D0542E,0xC71A882D5C40A787,0xDB3851BE0880C1B1,0x4F72FF0C287CAE73,0x0A628F172BF3EFE6,0x29DB69240150E4A7,0x0000000000000175 },
    { 0x7983F80ACC367287,0xFE2C8F3DC4633183,0x41B0E222AE89F8C9,0x93FDD59BEB58AC1E,0x5EE164C797538725,0xB8E3B75B7591FB4E,0xA2D0FA2E355A6A6C,0x391A05540405F33A,0x00000000000000E6 }
  },
  { /* Point #5 */
    { 0xFDE8D0ED0254D2D3,0xDC6868C5F24357A8,0x1806776F26106991,0xA3A1446D387D0F81,0xEB83F7B319591FDC,0x97678D46136E098C,0x89292AD342E7487F,0x53B24C0AB3C12865,0x00000000000000B3 },
    { 0x06FC68F37A74E056,0x10354BAE9D0DD6D1,0x713509D967092C45,0x5DDD0FBA52C97523,0x421E81604616EAF9,0xACAF5CF0A795B907,0x1CA067C8BEB5A28C,0xE07CBBCDB79CEA20,0x0000000000000179 }
  },
  { /* Point #6 */
    { 0xCC511EFE456925A5,0x4290A6E5F0A1B7E2,0x1705DCCE8756548B,0x4C139046B509C290,0x9D0BB0844CD17379,0x4643B4BADE17E05E,0x12BE04C35F7100F2,0x3CE4459479197058,0x0000000000000191 },
    { 0x065C3E87F32703CD,0x5AE023CC11390895,0xD2A40ECAC01552A3,0xFCD1382288EE5054,0xF61CA6F773498D40,0x2A4653BE0DD5E19A,0xA56016EEF88E9AF1,0xBD5C973AA73E0E21,0x00000000000000F0 }
  },
  { /* Point #7 */
    { 0x72E348491DF30301,0x71BA20A6A7AE2709,0x2AC2B9E7EAC84515,0x7DB23E2C684FDD3D,0xB7FF18F9B1B07C3B,0x296F805422F64D40,0xE7E74E51ACA26121,0x2382BAEBA4ABF51A,0x000000000000004F },
    { 0x076D34BBA03677F6,0x42BCC9C76484F153,0x7B5FD617D74DD1BB,0x1BA3E99C797CF9D5,0xA907800787403DC5,0x98278850D6D1E062,0x456314CA6CC37A89,0x3D3CFF1B0A6DAF4B,0x0000000000000117 }
  },
  { /* Point #8 */
    { 0x088B099E8CDFE07D,0x5A641CF1B905708E,0xC281AF16A221B96A,0x8BFA8DC0F622F5BF,0x432872735ECB0216,0x13EA7E4D6DAB8B7B,0xA478FB012212B506,0xCB4BE166A0C1A955,0x00000000000001D3 },
    { 0x38A2AA3DCF16C121,0xCD70EA8A7F8EED07,0x54532CD7E3A04C52,0x8939F904BA78E53C,0xC0132C268B563A91,0x6730A0FCC093E75A,0x1E6D961600FB49E3,0x0AF2A79F28587059,0x0000000000000176 }
  },
  { /* Point #9 */
    { 0xBD742BB58C8601DC,0x0D577D51BBD68FAA,0xB1BA3C3398B6E280,0x1BFC6C723E8A148E,0x59A16F766E41826E,0x3EE5C3E7161094F5,0xA98675BC24C86F2E,0xB94C47ABE2761752,0x00000000000000B9 },
    { 0x1824673056DC8149,0x846838C94FF82F9F,0x23C95268450AFB9A,0x40CC51AA14FB3828,0x28D1619711F0D733,0x0EFCCE77513057A2,0x9EDB17BEED0A7D9E,0x4D6ED1FAC7B17549,0x00000000000000D8 }
  },
  { /* Point #10 */
    { 0x15396E6B8C4141D3,0x3EC8A34EF7755D55,0xA9BDDF95F39FB433,0x79E71BEAED69B7D6,0x51C722CB9D0122DE,0x8DE4CB47E0E7B60C,0x726BA86DCBB17E78,0x2815C3BF5C037641,0x0000000000000032 },
    { 0x3366BD3547050A39,0xCF665BE239DE8FF8,0x0B1B2DC88B657CE8,0xAC1E0B80DB61F750,0x09F5EEB8971E2A24,0x92850350EE755FAC,0x3EA8358D3E97465D,0x755B7ED954CB917E,0x0000000000000188 }
  },
  { /* Point #11 */
    { 0x930CAD152D7A2680,0x6D7A0454C719CF5B,0x7478744EBBB88406,0x2598C4885883C3C3,0x466925014F5FAB3A,0xC803C49DDD8A471E,0x10CFA5B5831D5062,0x2BCE8E3C8CD03021,0x000000000000004D },
    { 0x8A75F6CD09A2CCA3,0x44598D59B03CFF30,0xF49EEFDC9B9D4AC1,0x6D759AEA116A7518,0x0F330EDC02B18830,0x52612307C41FC942,0xEA4652FB41B5E855,0x5DCE0D5C3AD0F9A9,0x0000000000000018 }
  },
  { /* Point #12 */
    { 0x87CD5F5B43522030,0x9B95D7CCA97925F2,0xA97D2673C4F3D98D,0xB760715AE3A33B1B,0x6848B7F36F47818F,0x19D3D312F4B35002,0x94FAF039B3F57798,0x62A72BFEB76AE400,0x0000000000000100 },
    { 0xDBBBAFDC31877679,0xA68C50A2945B79F0,0xD5B6B7C1A457A77E,0x1D5249E0E8EA38C6,0xEF61B6AB33B52300,0x864ACA06E3D8C9A1,0x852087916060F8D6,0x1827CAC1E1DD6BAB,0x00000000000000EC }
  },
  { /* Point #13 */
    { 0xF8F4C244D0A59FE9,0x0B34084B76402697,0xE4240B863E032519,0x7CF7B7AAC2065720,0x798134D64CB1FFE5,0x78E358F275F60549,0x4557430370582D54,0x452570D4828DFBFA,0x000000000000009E },
    { 0x1B0BCBC468D79237,0x8BCB0D804F5A6A6C,0xD108B4F099609CFA,0xE08DB1FF71BE7D63,0x7AD777DA27BD2D03,0xCE7FAE775749C830,0x1AD692F7C4565777,0x93798A2AFF8B8327,0x0000000000000010 }
  },
  { /* Point #14 */
    { 0xC50EFA15DACDA34C,0x159E94DBB6E96210,0x94B10231BD9319BE,0xA5914F55E2A461F6,0xB75FB2AB47BB66C7,0x4FFCFA6756B6E4CB,0x559918EFC40A2512,0xAD434761B66C07D4,0x00000000000001E4 },
    { 0x9885BE1BEBAE3F4F,0xBD84A8EE4302A9A7,0xBEA75F26C373E684,0x0DA8FDF6472F2C17,0x381A92BBB5DFFE57,0xC69646BAD24160CD,0x0577B8792ECAD05B,0xC59496C27FB62711,0x0000000000000068 }
  },
  { /* Point #15 */
    { 0x04CC8A0B9C2DE291,0xBDE190D41B774116,0x76FD915E0CEF5563,0x08980204A3AD15AB,0x8532BFF00047227E,0x93713303DF68231C,0xA4D4B863B1B0DE98,0x67686192E0CAD308,0x000000000000007D },
    { 0x6748CD2672CF3E2F,0xA342C5D7EB321523,0x0466141C5021D422,0x116BF2246A70D2D8,0x7129A3A4CE05F6FC,0x86600259D9185DA8,0x8A6DB564DD965C37,0xB073F80C79E8F792,0x0000000000000049 }
  }
 },
 { /* Table #80 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x5F47DDB9AB9923D7,0x839865D48E3FAC52,0x0214E93F647424B0,0x266C909C31D65C6B,0x956DECA451457FAC,0x8E8D240EA85CE8A5,0x736652C4A4D9B281,0x131A4191B77A526D,0x000000000000008A },
    { 0xA848319532D8542E,0x1F7A8E67C3F38387,0x162AC248D6797F2E,0xD26469E10A6A1118,0xB33AFF1FF203102D,0x63A52154AADF0AE9,0xF0431DBB4BB313A7,0xF93C18FBCA9DA156,0x000000000000015C }
  },
  { /* Point #2 */
    { 0x8A9E56659D53FF0E,0xE4C4FCD2C7CCBB62,0x95A2B7A2B60B6FAB,0xCF39FDE59242B4D1,0x43983F305B49D9F2,0x4B5FECE7220EC7BA,0x10B1639C221FB872,0xF5955C1DF594795A,0x000000000000008C },
    { 0x73DD1711EB1EEA2C,0xF027DAE274F9E73C,0x11C87D1589586CB5,0x16BC03CF1380814F,0xFBBBE67A19693D82,0x9CA4B47E5B37AE4D,0xAD59BEEEDC7860A0,0x46FF6DED599CA348,0x0000000000000031 }
  },
  { /* Point #3 */
    { 0xE5D80096DB0B7846,0x1EC79296907BAE46,0x6CB09D0D362B9307,0x76B5AC522C89BA81,0x12D37CD27D83920B,0x22A18F6B8C031B82,0x8C1BD00993822770,0xF5F699267528177A,0x00000000000001C1 },
    { 0x1C08DB46ACB136B5,0xD3BC1FE127D539F1,0xD87F107359AA9DDB,0xD8487FF97E8A3E33,0x3FA1A3F160581C89,0xE0379485A5980F30,0xE5D3C87E6C7687E8,0x6286E05D5F6FF261,0x0000000000000155 }
  },
  { /* Point #4 */
    { 0x47FE51518F87AE00,0xF49EBF83B2D64637,0x11ECA7B4A1E86582,0x58BB53F9CBDE2995,0xA620BBA204AF7663,0x2A01040D7221BC31,0x1734531DA243AC9F,0x1DCB67D6117D06E9,0x00000000000001AC },
    { 0x5BB6699B43275FFD,0x4B141BE73BFEA061,0x805D08B0DAE58347,0xBBBBBAE321EE35AF,0xFA863BAFEF02B56D,0x21460360B35E5127,0xB64A8AC4DACDD7B7,0x51582B4F92B58B6A,0x0000000000000172 }
  },
  { /* Point #5 */
    { 0x1C30F6C02E769805,0xF4BA830A741916E0,0x6D44914E9A7F97D7,0x873BE2FE2A5220CC,0x6C34908677F0CD9A,0xA11F9DAA5725527A,0xF691B79BBCBB7F2C,0x0C9D568B316C9811,0x000000000000009C },
    { 0xA03335450F75AE83,0x904E5959507B1783,0x92110DBDD4DBD664,0x767CFDAB061CC502,0x3771EA16AA2A0300,0x3D8CFDCC35C82065,0x1E0AFA55BA413636,0x5C1D5F581F73EF3B,0x000000000000019B }
  },
  { /* Point #6 */
    { 0x93D3BCE039741A2B,0xB01D4C3C4061AB7C,0x35414F123EB73F51,0x11E8D4503AB93C71,0x267B1285854D537E,0xB01F7B95CB8C4C60,0x88A4E72EDDADE44D,0x02B12BBAD3DCF9AE,0x0000000000000049 },
    { 0xE2AAAC37421E0A96,0x38E4380EDBC73078,0x27D85636C671400A,0x1A11C61631CC2FDB,0xB30DA04A8D500BC8,0xFC6D96512A8D7E73,0x94DB2D9653481B0F,0x44BBAF9685807051,0x0000000000000190 }
  },
  { /* Point #7 */
    { 0x964975D713714771,0xEFB11E278639C0A0,0xA83B403A6109122A,0xC3120D863DB62A02,0x479F1597114181F7,0x2FD71BC14A902962,0x6B5A2225A616219C,0x2AABC22D86E78CA8,0x0000000000000022 },
    { 0x9037A233197ADCF4,0x9C676F3FDFEC0430,0x42ABA69B92AB3514,0xB1B7B69364CB5C48,0x866D10CC0066EA08,0x13C190A6EA7DBC33,0x64EACE1D6D2D3558,0xC2075B82CBB4A44B,0x00000000000000F0 }
  },
  { /* Point #8 */
    { 0x74F71C976305B1FA,0x75C64449AAE6788B,0x072B8B0AFC132537,0xD66862F496FD8BC3,0x32CB2F3A5FF59F77,0x9667801B58FFE8E1,0x227B57A4558302C6,0x0C384F6E441664B4,0x0000000000000130 },
    { 0x0CFD7A96C16BC635,0xE8F67AF8D846D4C0,0x7A398E333637D199,0x2648CDD111D7443B,0xFE3BDC069843F169,0x8192BFF3B42D2C33,0x7CADDFDCFD2B8FC0,0x42D128611456B53B,0x00000000000001DB }
  },
  { /* Point #9 */
    { 0x1EDA11712B2DAC67,0x2A50CE6DC6FC4BBD,0x68ED65223B09D412,0xC1AA33753BDE989E,0xDF1860240CB2F289,0xB9E6792390FA51BF,0x912EBAD71BA20748,0x7CC7C8F823E76EB4,0x0000000000000090 },
    { 0xE639EA6DB4A1D3CE,0x760F5172FF19F1B8,0x829477245617CACF,0x22F0BDD397AA09F6,0x6CACE44C637133A7,0xC8A42AA1E63EF73D,0xC4B6481A9A0F309D,0x169CC506EE3C7247,0x00000000000000E2 }
  },
  { /* Point #10 */
    { 0x4732AB3D57878AC2,0x00C444A07AAF8B7F,0x2147AF1C8CB59DB4,0x4A3E926C794CE3C7,0x3935F9C06EDA4EF9,0x072A3E64BB7D6356,0x9809C85588C0F3E6,0xEB1493C4B7B5629F,0x00000000000001E2 },
    { 0x3CC9F8F43E29E03C,0x9CAD6493F6A2EC17,0xA1A67783FFEA3472,0xC9EAC7E26B789416,0x118751E0F223D083,0x8AA0CDFA30AB6400,0x9C217363F19BE3A0,0x49AE816E41ACD87C,0x000000000000007C }
  },
  { /* Point #11 */
    { 0x268872EBDE03108E,0xEA65ACD44357C102,0x4FEADB3C02EF5A7F,0x3125D1C509BE4878,0x185585F95E59ABB3,0x1D530AE5863A0ACD,0x70CC10C2FBEEE48A,0x1DCC0FFF6303F7A2,0x00000000000001A2 },
    { 0x8BC9AF6F9681CF50,0x81DE189CF32520CA,0x78D6EE2528296C91,0x79EC34EB958E33F3,0xCCE3B4E12141099E,0x84851CAE62CFFCBB,0x39FAED37CCD79AA7,0xF6269FEA832A0AB0,0x000000000000006E }
  },
  { /* Point #12 */
    { 0x4C7066DF84E9430D,0x77ABD2E8E1F59506,0x784CDE21534BDA51,0x84176C345BEA6125,0xC4F00C4C11104B82,0xDBB8EF7087F79ADB,0x1E47FFF55961812D,0x70326449202D45CB,0x000000000000002C },
    { 0x84ECF48DF169B460,0x972348061A19979B,0xDE2CAF4D9BDCF29D,0x90ACCA5E218CACA8,0x66480BB594715145,0x70D761509BA70365,0xAE45E69A924D4C52,0xAB48997CC321CA7D,0x000000000000013F }
  },
  { /* Point #13 */
    { 0x252E60E1857BBD62,0x542196076CF87A3D,0x7A3E5E40F6CAA907,0x8D437ECB12E825F1,0xE5C893A573C57EA5,0xE519B68AE6051480,0xF6569C11EA91E8A2,0x185D9CCAD389974B,0x0000000000000163 },
    { 0xF580AFEC9A0A8986,0x6805EBCD48995123,0x91EA17E6EB0F2F2F,0x1A0A5F3D938B3CF4,0xA04402FC187DB744,0xC07A2174D9E0E0A1,0x6F2E321FAF348188,0xC6E1FA0614348E08,0x000000000000002B }
  },
  { /* Point #14 */
    { 0xAA9B95E9CCC84467,0x20B23E7E341C1451,0x9256C706337ED237,0x2E47048BF19B8AA1,0x8ECA3B9121124656,0xE458E0505B46679C,0x427C40DB805085CD,0x7032A9E6AF40A4E7,0x0000000000000141 },
    { 0x041A985544F96937,0x3439D91E2719A7FE,0x0C7F266A026EA030,0x0500626E9022448F,0x38916A31EB18CBCC,0x412496ACBECCAFE0,0x730FDF4F61DA7F3E,0x47289C279E95D6C8,0x00000000000000E0 }
  },
  { /* Point #15 */
    { 0x17B8A03685892E2A,0x9C15440AA64BE1E6,0xCB472BF1D31FC228,0x5F4A465C1F36B542,0xDAC69679D5BE1A4B,0x4BF0AAABB77370E1,0xA8E119C5BB6C3E36,0x21949699C06C0114,0x000000000000007D },
    { 0x88AE2DF23BA74EE9,0xA3CD8BCE9BB49F24,0x7FACF9A5D7D3F5FC,0xE6ECFFD8CA309DC7,0x25A2C984DB9EBCA3,0x0A794AEAC5CE2AC1,0x4C96AD8682E8D490,0xFF2B5ED5419D91FC,0x0000000000000011 }
  }
 },
 { /* Table #81 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x5637CEAB569DFCD1,0x0D1CF091B2C13802,0x09115A1F731087B6,0xEDA479FEBDB45B2B,0xED883A7D8E6E5507,0xBC9206BA30BD8162,0xFF2AF28EC6294B24,0x2058521AC8947BC9,0x000000000000003C },
    { 0xFCFA87A55A82FBAA,0x988A9A6C1569F45B,0xE65849F65D3D6AA5,0xA3D0879F05446B48,0x45571CCF76F480D1,0xACD9A3230EFD5F79,0xF30E5EC4AE956132,0x325306D0EA93F245,0x00000000000000A7 }
  },
  { /* Point #2 */
    { 0x5F7D9850FB6F765B,0xAFE6DBCAD0CCFCE0,0x9E66A5E9D97D6F42,0x1B402928377F7E90,0x44B0D87ABFC71AAB,0x3CFFD5151DE366F6,0x845D7D74B292C4F5,0xE0822EF93F88E818,0x0000000000000017 },
    { 0xFFF7C1D7104D2069,0xE53E122DEC0FDB18,0xF07A43395646B614,0x3F2341D0B47765F6,0xFDE6DD5E2CB3DEF4,0x87D324787A97D20C,0x27235476BCB7B256,0xB03F98DC9303C7D0,0x000000000000010B }
  },
  { /* Point #3 */
    { 0xC1D74D05AC5FAB15,0x6EA132C49B102D52,0xD3ADA4CE0D890CD3,0xAB7248F092823F62,0x246C373023871113,0xEBBCA0B998424F07,0x0061EB2C2E62E741,0xAC1B03D25E90C5B4,0x0000000000000136 },
    { 0x0748C14A7EEFAE68,0x82525B3581F8A2CE,0x31A64097398363E1,0xCBF57E0257B6B33B,0x523F0584807217E6,0xD607EFE780B9700F,0x79AFCC9435596890,0x140ED6F46985A97E,0x0000000000000160 }
  },
  { /* Point #4 */
    { 0x116CA45B2E19E0B1,0xA49D8F1B730AC8C2,0xDA037586EB7A1238,0xEAE3ABD5E834391B,0x8675C82A277EEB94,0x975AC10634B19D06,0x6AB169A96B83A163,0x3ED9A40A967424FC,0x000000000000013D },
    { 0xA23D2B9B2082D8BF,0x853AE3F39A7D0A3F,0x04C7CE962879D8EE,0x17DA556D29C66703,0x1B3A760F1FDE40F6,0xB98726458C5B2120,0x59B18FEE260AFF65,0xF2A8908D5DF615DC,0x0000000000000116 }
  },
  { /* Point #5 */
    { 0xAFC75C178EC70A8D,0x32686EBF7B117380,0x16050CDA21E28C47,0x70C05654E731B083,0xAFA2E57571D1F6D2,0x0DF1A032C1982FD6,0xC0E7B1461E86F69B,0x0DF3C6BCDCE1864C,0x000000000000012A },
    { 0x46FA0FA600B0D0B1,0x1F0A42B21691A590,0xF5A6E4E8AC8C1189,0xA2CC987973A0AB49,0x721CA290CF17F795,0x4026F9C3ECF32B7B,0xBABD20C019CD7057,0x99378E8C5C30CBCC,0x00000000000000D2 }
  },
  { /* Point #6 */
    { 0x2229E06CCCD6D98D,0xAD78008C2BBC14EE,0x361FFA4FDA34A88C,0x6023FCF46CF499FC,0x72051F272A50F74F,0x56CC61C8E9A59A2A,0x2DEFB0A1BF0392CF,0xA5ED8B89D29013A8,0x000000000000008D },
    { 0x9D396C29D3D7339A,0x0D21B9DFCA0262D1,0x164B69E0A000D10F,0x2F7F7DFCE1147D4B,0x3CC2909978310E2D,0xDCA71FAC36AE5A21,0xE0C8579AA0F4CFD4,0xC05C548904582119,0x000000000000013F }
  },
  { /* Point #7 */
    { 0x161B9770B7DC0F64,0x42AD385A84F67076,0x6A94116C710D4992,0xDDFA30033EC54457,0xA17C61D12D520342,0x7E673638F36C6F21,0x7654E648EAA1A95A,0xC4B4A3C40DD8029D,0x00000000000001CD },
    { 0xD748525500C9033C,0xCF0D9C3551ACD2CD,0x02022DED596A8678,0x56FE8164D90B82EC,0xE376A376863801C8,0x559B0F3FAD337694,0x3C720B4F06E23E58,0xE02DCD8191914C96,0x000000000000003A }
  },
  { /* Point #8 */
    { 0x699F72E9E084EA4A,0xD1C4BC45DC721BCA,0x7EB43D78995DB3E6,0x76E84FAE02088E1A,0x1B061123E048084D,0x7CAF0D3279ABE6FE,0x9340583753B13E9D,0xA05D1313CC58F64A,0x000000000000013C },
    { 0x81D54E675FA5B0AE,0xEE551C40086B46C4,0xE7B98E209B7DAA1B,0x8082803EB868C9D3,0x036502F236731930,0x075455AEF9A93C2B,0x080E704652A61944,0x9F4BBCF0580494E0,0x0000000000000154 }
  },
  { /* Point #9 */
    { 0x0E4B463A886B2E59,0xA7091BDDE1730E93,0x53693DE2E485313C,0x32137CEC9D335D4B,0x30983F46E7B8F7B6,0xA8F5732C36785D2F,0xFC96DD6D27F2DB5A,0x649054E25A562614,0x0000000000000164 },
    { 0xA4B1B99714766D09,0x93AF1A132001ECEA,0x436FDF6A69BB5799,0xB0F3E655EAE264AD,0x1FF369C761838A92,0x3780D328A24DA60C,0xE126D99241CADE42,0x9CC0E1EA9EA7D1B4,0x0000000000000056 }
  },
  { /* Point #10 */
    { 0xB3E7EABF951C2D0E,0xBF9959209512C00C,0x0F1D97A8DBF1F0F9,0x6A52615C430981D0,0xFB0F0D2097073D82,0xD843BC6CC0430DE7,0x1BD02E5440061F87,0xCA4930B25DD88DC1,0x0000000000000056 },
    { 0x92C1350259A249AF,0x1597C507B2CA76B5,0x298751F3039592D2,0xC50BB3A4E8A71D91,0x4D3A058405F1E850,0xD16F70A3764AF248,0x5D508A243F2215CE,0x2CBCDAED889AB117,0x0000000000000193 }
  },
  { /* Point #11 */
    { 0x8ED9E22A9439311E,0xD3F46E41314B0141,0xBDB1570568382359,0x149ADEBFB65D3AAB,0x4F73E3254FB4C8C2,0xEF7883CCECDFB62C,0x7A0ECAA2123003B4,0x8DA68ECE15A2A7FB,0x00000000000000CE },
    { 0xAAC484E542250748,0x5E1020B2E43C22E1,0x755475A75F3C8E7B,0xBC1FD16E533061B7,0xD10D8530011D193C,0xB8D9C97E4AE8EFDD,0xF19DE2648F813FC8,0x3A0B5F66415DAF6D,0x000000000000009E }
  },
  { /* Point #12 */
    { 0x77B4759ECDC28BED,0x2C9485511067B654,0x97A30E9C1BE3D888,0x1B8EE1134D8A74EA,0xEC2A632C3B1697FF,0x60AC030FA8D72746,0xEE82EFEE20B60C63,0x6C7904A018C6AC9D,0x00000000000000A0 },
    { 0xEFABD68D11A97778,0x0C8E7905D29960D2,0xC58E496F0B58310E,0x8BBCB95CE092E4E6,0xCFEFAA5CD7B6D076,0xDDB0D933600C7C58,0x7EC76492D34B8F40,0x6AD971CAAD23F589,0x000000000000004C }
  },
  { /* Point #13 */
    { 0x42C6902D17001AB9,0x6BCD13B0E3C3BEF7,0xE61D8161A3B5A78C,0xA201774E05B85E95,0x9C0940ABD7E54543,0xD8C739A71066397F,0x2A086159A49687E8,0x6E5A1B2592222916,0x00000000000001D9 },
    { 0xC2FE70BE069126EE,0xD337FF0CDA37306A,0xD91E07F157F8EB8C,0x83EEF5E6C3E8974F,0xA0584968665F08CF,0x377CDCE9B5297C10,0x581D1C013D1F2799,0xA1B669D8BC2E1714,0x0000000000000096 }
  },
  { /* Point #14 */
    { 0xB42EF882816F7665,0xB3AFB61FB9084579,0x3127E9A54745395A,0x1FA6611F0126D538,0x798FA552070097CC,0x6F41901C704F16D6,0xF528B063BD6749F9,0x3CA460784B9FFF68,0x00000000000001DC },
    { 0x0096EB977D54EB8E,0x9DE669AFE24FACDE,0x1582B22AC6DF403A,0x8F4FBD44A91242EB,0x1696FCC0E0AD2760,0x334C9D4AD2D90E25,0xE57995440D5893E9,0x5074B63ED1077BE4,0x0000000000000029 }
  },
  { /* Point #15 */
    { 0x5F4BA23B78E658C5,0xA9463D66DD8F6428,0x2B6792E9FB241842,0x10DFA360934AA1F1,0x7769322AB7BF8A36,0x223C1474F127AA05,0xEBEE2760D048D6C5,0xF495B445E7B13526,0x0000000000000032 },
    { 0x7BAA637E8BB79C71,0x349709051681A7B2,0x12359173EDD0293A,0xBD9DEB854E888C4C,0x43F03F70563C6C2B,0x42D131B2F20FE520,0xB080E82CDCF32D61,0x7ACA6B8C0817EA86,0x00000000000001F4 }
  }
 },
 { /* Table #82 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x4D1BA365C000E4F4,0xCF34A1A87B2CAA8F,0x0E4A58D5783E3C39,0x1AD4B5CE2C1FCBD9,0x6B30BFB9E8B9556C,0x304AD2366301B3A4,0xDACF31B8C8D571F1,0x25B7A0FDEC93E088,0x000000000000012E },
    { 0x2863BCBF3B6CC6DD,0x70760671E9430F99,0x46CCE87B7586CDDE,0xC1F58398161A045F,0xA84CA0CF291636AE,0x11242D2726892BD1,0xB1D85DA78C971E9F,0xC66E0E1D61AA5039,0x00000000000001B1 }
  },
  { /* Point #2 */
    { 0xBD52D5127C1A3915,0x88B64D2E59D9DC08,0x142D5364A1DA166E,0x138ED011C8EF7E38,0x90E189904D6D06EA,0xB0081001147F3F6E,0xA8E9F89711A1EE9A,0xE7607F70E28C7A31,0x0000000000000011 },
    { 0xA73DC4E4DB957A5F,0xB3C023C02FA7966D,0x590CA0877AEFC5B1,0x63427F912CA0D266,0x7BC0F1EF4EEB8864,0xEF9125D279239E3C,0x12E924A1A90C09C1,0x0FEC85E3B3663A4E,0x0000000000000085 }
  },
  { /* Point #3 */
    { 0x1E55BD598A6AC4B8,0x4D2FF6417F9B3261,0x7357BA73AE650E54,0xFC787C61A534EAF1,0xDBB8C786292ABBDA,0x177FE5BC19E5429C,0x8EBA99F05C9E9AD6,0x28BC93698970847B,0x00000000000001BF },
    { 0xEA2FE5C6012A3B19,0xD1B5DD53120A832E,0xB6D7981F5511DB76,0x32DAE3F986DFDC2F,0x647143B5FD49509B,0xE975FF91AE5DED18,0x1DE3C3CB8D60F9F2,0x958C21AAF5365428,0x0000000000000171 }
  },
  { /* Point #4 */
    { 0x6C6119F6A1C88F3C,0x924E5FEC2EC6944A,0x4C8AAC605742FF2A,0x60ADDE1EDDB22C7C,0x9728938CFA5D25BB,0xFA5AC4F7EC117DE0,0x41F35AB7482929C1,0xD1C4E8F90AFD95F5,0x0000000000000180 },
    { 0x2FC4E73DA7CD8358,0x39361A57F2A1C920,0xF6F2F130AD94D288,0xE37E24662B6A78E2,0x0BABFF8B79C262CD,0x6CAE01EF61B597B9,0x9C1E33F0A60D4E64,0x52A42280DD01F845,0x000000000000000E }
  },
  { /* Point #5 */
    { 0x0806876878A26AD1,0x01D146684A4E0A00,0xF47A3F33DF68A10B,0x26C714DECB9B660F,0x177C6DB6FEB94C62,0x9D859DBC88FD6FD9,0xFAF924FE45CDDA91,0x9ABC26E3AB8F7635,0x000000000000009B },
    { 0x5B24D5D0023D360D,0x568BE9749F8FDC2A,0xCDA7AD210BD7C5B2,0x13CC6F4E8794C868,0x39574E32CC9C99D4,0xCFBA662C598DABC8,0x13A18B8EC19BE405,0x7E68CD3F71F860FA,0x0000000000000104 }
  },
  { /* Point #6 */
    { 0x9F19B3E18C730727,0xA2231248D5E33B72,0x0505B3DD5BDE07E8,0xAA30E5ACE8A2FC4F,0xB2D24A392F964EAB,0x2D9D22A460CA41F1,0xC7183625E0E8DD2D,0x87F3AB032653D84C,0x00000000000000D8 },
    { 0x52E505E3C7FB02D2,0xED5FCC2C7154E8B7,0xC0DF346F8E8397AD,0x1C9ABDE6F542CE97,0x158CD908E2A2205E,0xFBF550DFE60B9A18,0x66A4AA43BD817D90,0xECA35B6CC60DC534,0x00000000000001BE }
  },
  { /* Point #7 */
    { 0x584410B672DCBDA3,0x8BEA714229E3894E,0x1A155410AEA5190A,0xDCD905FD26192C76,0xCD398643323F0EC1,0x75ED17FAF3645C09,0xD7F031ABC809CA20,0x50A51D9345D35024,0x000000000000007A },
    { 0xF5F7D19E5AE92EB2,0x358CF7A0A68F24C0,0x48D8485E6E6E1059,0x42CEB50E650B703A,0x4F717CCB81E19069,0x88EC063E86CF55F1,0x7928166BDD6FFBA5,0x6315AE491716E36F,0x00000000000001BC }
  },
  { /* Point #8 */
    { 0x09BC56744C81DA95,0x9756C443F23B526D,0xAC041332ABBECE84,0xD933AAA327696AA1,0xFE78E91D3E4E9032,0xE491EC63CD67FCFC,0xB73746E7E8FE9C4A,0xD2CA6F6A199F1EAD,0x0000000000000191 },
    { 0x86A7466AAD125891,0x4817DD6E42499FF4,0xF5478E3B7C6A0ADD,0xB92D8E5D2A394366,0x5C5238E3BCDF955B,0xFA855FF10489D6B1,0xBB15D2FD134F7F2D,0xD5FAF13744BD6838,0x00000000000000F0 }
  },
  { /* Point #9 */
    { 0x0F90CD67B3C284EF,0x951C43EF0E5B9DE0,0x9CBDDA8F5038FA53,0x44F33E90472F23F6,0xC88B8EE0F8511A21,0x6FFBCECFF0FA173E,0xA10D66C2200A8DFC,0x4CAC6348C27F52D9,0x000000000000012A },
    { 0x6370A9482D67D1D5,0xCBDA158C143D8BC7,0x1063F74F3C8FBA5C,0x6B9993E95CE883A4,0xEE4BEF73CC003953,0x1C1E9119D5469935,0xB1744545ACD564BA,0x1F34EFF6F10398A5,0x00000000000000EC }
  },
  { /* Point #10 */
    { 0x0FC11E4C84B0F4EA,0x435C27D47D244A14,0x3996925DC6EB93CA,0x0B699C9F09F7E1E4,0x92D5807E1EB96A28,0x772A095B9C14E99A,0xDA362FD51BC8F956,0x157E3C0B9D4800B7,0x00000000000000A8 },
    { 0x5EFB3B8F90D9EC28,0x8CC8C25FFA2E2948,0x1EE212252668D00F,0x37102FB19651D783,0x341AB0E5A50AF73B,0x868464E967E0B7B5,0xE264F59D5BA120E4,0x661650AAE80385C3,0x0000000000000158 }
  },
  { /* Point #11 */
    { 0xBC580CE209A6CC56,0x7108762975C678EA,0x88287F0E6AEB6118,0xB20199F2F8F02141,0x682C00FF684714DE,0x144761521B0B2D2D,0x211E00009DB385AF,0xE5253108FE6CBD00,0x00000000000001C2 },
    { 0xD3E3667ED34D3D44,0x30265A171AD609BC,0xBF165EA2B76C964C,0xA090D0CD1E7175AD,0x8AC76FBAEE8E0C4D,0x0AA977B52F4E6388,0xC2F5F3FB8AFD305B,0x390D3CF1A4CCDCF2,0x000000000000003F }
  },
  { /* Point #12 */
    { 0xFAB2F74C3EF1EEB1,0x71AF5A9992007E36,0x384D6A18A0273729,0x03DF77A9AB5EAF13,0xBE0136FA0E0BDCB0,0x5F4BE468BEBAA588,0x2EBFCFB42840138A,0xF8E098F02594311A,0x0000000000000053 },
    { 0x84055186C73F0476,0x92DCDD0E729B0B1D,0x7C523B4806BE9764,0x95357B956A57BAF6,0x4B556882860CE9B4,0xDC08B8F831882647,0x11C9B3C738C3DEAF,0x50B6FEA8E68F20C0,0x0000000000000164 }
  },
  { /* Point #13 */
    { 0x90D6932FD4502C57,0x33A02504A118BA3F,0xF5F74804636F94B6,0xCE842ACEB9B9318F,0xA67CBBA24C794C80,0xB9A5244B6539B685,0x571321E68812E098,0x8A329A0598B10609,0x000000000000008B },
    { 0x33ECC643B8942609,0x7082B10CD9EFBFAF,0x5CE6F68F02B46ABB,0xF642692FF47929AA,0x29BB4A70DFCAF995,0xE8C69640BCEA2005,0x6AFEE11B92D13977,0xF3D44F870E1D1076,0x000000000000016D }
  },
  { /* Point #14 */
    { 0x76B2671FA4C28CA5,0x91A0D41BD0F62E23,0x3DB3924DB448F296,0x0925DC3FA60A9738,0xA37774B00371C080,0xFD182AC7B5167FE8,0xCE4795B714EB4895,0x7C993D229887590D,0x00000000000000B6 },
    { 0x6090F452A0FEB93A,0x032DE9C217E4F78F,0x29FFFF34A237D15C,0x81205285EFAD6015,0xCF90CF14AB143ECF,0x56D1CAAB0DBD215B,0x2648AF04284B4611,0x6DF91B71BC20A51C,0x000000000000013A }
  },
  { /* Point #15 */
    { 0x27F69A0E8ADBD3EB,0x63EB042A2D09F533,0xAAF6D2181A004ADF,0x9BD449E80DD53ED2,0xAF0DAF82480F8DFA,0x645307D5F5F79306,0x99DD7D6041E10D2D,0x090D034A6C70D16E,0x0000000000000066 },
    { 0x7CD684485FB42F7E,0xD359274ED74292C6,0x8949BBCA8D66B38C,0x6BE51B4E6F558F88,0x59725120C8227E9E,0xA0B375572AF08FA1,0x171E50E4BE8AA863,0x5306419DCD944FFB,0x0000000000000178 }
  }
 },
 { /* Table #83 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBF0B5EA3D34B138F,0xC49513813AC7CAD4,0x82CA5536CAB6A319,0xFF56913688BB4EA8,0xCEE2512A4761D3E9,0x4695E52155EF9647,0xBB83316B9378F132,0x1D447F048D43BB4C,0x000000000000002B },
    { 0x777AB201CE5889F5,0x635D968F4C6F0545,0xBB48A0CF872777EA,0x33F4DE62C616138F,0x93E74192BC8D65CE,0x532CA9BD5EBAE1F0,0xD783E104FBABA8D0,0xB32AF569BDF2D850,0x00000000000001BA }
  },
  { /* Point #2 */
    { 0xD552C9D248351408,0xA6D83A480EF56558,0xAD5E955A313B47C2,0xDF3CAFF7F6DC03BE,0x3D62FF1951CC488D,0xDB49F397966A34F9,0xE10E72130BF6A9E7,0x560E329ABC5852D2,0x000000000000004B },
    { 0xFDAD029AF3017C8C,0x6CA51ACBB78D4D1A,0xF984FA8679D7D7D3,0x75D9044B911A4D3B,0xC5B20C87EF955E4E,0x413D6838F064FD0C,0x37A5EC08EC7FB5C9,0x634CB97F74561D5B,0x000000000000015B }
  },
  { /* Point #3 */
    { 0x9FA30F39E43B6C21,0x4D3822AAB9FC57BB,0x0230ADCF69A8A55E,0xDC8AB2796F87F988,0x2D642A82B2AF81FC,0xB9E63A7730765913,0x5787400625F2A77C,0x0AA30A6F5BFEE0F1,0x000000000000003D },
    { 0x796F6508FCE49DAA,0xB586299FBF907285,0x21CCFC555838145B,0x20A0F8C0E6D43B4D,0x17170A2BE5E80FC6,0xBB8F840688FBA946,0x5C226B0E411FCBE7,0x35ACE6E02AE8E090,0x00000000000000B0 }
  },
  { /* Point #4 */
    { 0x446B17B0E695916F,0xB3B0DCEBF9BD8DA6,0x6C76C3CE5FF86AAD,0x0785D5A20CDE74D8,0x2CE9FAE12BB7AE7A,0x87CD05685F32E59A,0x8E229326E1598559,0xA0BAD54E34EDFB01,0x000000000000015D },
    { 0xA54529C20E1290B4,0xE7C719CAB795DBA1,0x68CAC3A5109B4740,0xB032BD2BA68E8E4A,0xCE03D9321658337D,0xB39D102ECC95D9DF,0x79838D96BE248C98,0x02562708D7DF0B44,0x0000000000000127 }
  },
  { /* Point #5 */
    { 0xA39D4AC8162DD91D,0x5704769322E67A01,0xDFE57F997C446028,0x0F49DF77D131A2C8,0xC8F26682F7F779BD,0x1696655818E884F1,0xC5D9D516F390907B,0x23356E77617F5F5C,0x00000000000001ED },
    { 0x5E6830B9679DEABA,0x18BCC37F9FD1A70E,0xFA84E86272225892,0x2E6CD938C610763C,0xC179376A671378EA,0xE3B844B5F502EA1F,0x74A390B75FB4DC36,0x51F019400ED8D535,0x000000000000018F }
  },
  { /* Point #6 */
    { 0xC9A88248CA91F6F4,0xA368FD8AC7D5ACC8,0x33D9FD5CCEA11E10,0x0AF2F470816DE633,0xE78E8101AC186F1F,0x0D97DE7D5E3C4857,0x9346AF7407946BB1,0x81C2BD5EC7044EA9,0x0000000000000003 },
    { 0x04C2EDA3696D947B,0xC3F988F301EFA843,0xE839587792F22674,0x376972A2C83396C7,0xAA679A3144F2AD2F,0x61A46EBC3112B6AF,0xBDA02CE0C6B3224F,0xB42AABA7DD4C7B77,0x0000000000000060 }
  },
  { /* Point #7 */
    { 0x8879637B3D70360C,0x053C278F72F41087,0xCC895E1FF07F009E,0x4C9B8C6468DB6690,0xB45473981B97DAC5,0x0399CAC8AF65FF38,0x295E09141FD0A6C0,0xAB605FCD871BDEFA,0x00000000000000D0 },
    { 0x3F2D42975AD63582,0x28FDA2BBDC7D3A40,0x7F14436765672D9E,0x9322AB082937E8C8,0xF351279FAF748929,0x63A624F5149D6F5D,0x3351F4FF989F5325,0x0456187BBC7DD8D9,0x00000000000001B1 }
  },
  { /* Point #8 */
    { 0xFAB6FA734E185EE5,0xEC85B9EDF15957D4,0xA978ADBD72BA04E7,0xC7E3107E7986FB14,0x0E97063DE37740B4,0xF26F51C225E29918,0x66B9445312E6F22F,0x6617DEAE68090E9A,0x00000000000000A3 },
    { 0x86595B1DD2DAFD33,0xCCA6CD7FF3C234FA,0xD24847EDAAC709CC,0xBE089DF8FC689536,0x4FDCC1DC367BBBEE,0xC2592739A01BEF50,0xFF4D427AA53D6B64,0xD3DDC2BC47D9AF89,0x000000000000000D }
  },
  { /* Point #9 */
    { 0x1777C43A52B7210D,0xD6496DC488CF1CEC,0x1AFC70A9D2326BAA,0xF3464F03EEFEE797,0x98FDA748C431A2BF,0x658E8ADDF6E2DD07,0xEA46C2648D4D40DD,0xD176AC8E1D5C0B95,0x0000000000000025 },
    { 0x5982AAD3D6068679,0x441CE56C10F248BF,0xEA69B563A1B42DC9,0x1852A88948CB7E86,0x5C15948C746D5378,0xF975AD39A96DABA3,0x8A24C559C24E4659,0x26B90DE1DAEC6FBA,0x0000000000000193 }
  },
  { /* Point #10 */
    { 0x1F3304739A4557C3,0x16553AC3F1CA2E32,0x3B41980601A4A968,0xF1238756F8865FDA,0xF021DF6B5184A85E,0x40D3D1B14574F3A2,0x78E88F8334E46487,0x37BB9F6CBD0C657E,0x000000000000019B },
    { 0x01DACEBDE26DE30E,0x759D79AAE9666820,0xFFFC28CB246775F5,0x48CB8E4B8340DDF9,0xA7B29A7C53CC3DC1,0xC6CDDA7B1970B865,0x51051B6D9C2B9B33,0x9B212BDF6216E8B6,0x0000000000000139 }
  },
  { /* Point #11 */
    { 0x3C447F12E1A64D88,0x227CD2A8DC716C2F,0xBB74F8CDDCD8DD11,0x8068EEF144470D08,0xAF26EE62BFF0B87F,0xD7E3C625F1D13FBF,0x5507A88DBB4FBDAA,0x222B1B385C90F896,0x00000000000001B9 },
    { 0xAED21D70FCBFFEDD,0x78F774A9CC7176AE,0xC41670E85935F39F,0x154026F147B1F321,0x8C96D0BB774A7B33,0xF1708F4EB6736839,0xAB7BDD94E104E052,0x847EA13D205C733B,0x000000000000006B }
  },
  { /* Point #12 */
    { 0x6692C09686E42AB7,0x6C6D706F0535EA48,0xDCA1F3387862C68D,0x7253F64667C3C544,0x9EC1FE163FDBE80C,0x8490243038622C1C,0x060336D0B2900C30,0x309FC896FE3D30E4,0x000000000000015E },
    { 0xD7849F5E7A119170,0x562A6B6C33E31671,0x8A0864E0515CA9CF,0x9C6D13A9395BC434,0xA1D4C055E3E75FF8,0x34A74DAF6C1C4D67,0x72DECB140943BBA3,0x309CA6934718C364,0x00000000000000D3 }
  },
  { /* Point #13 */
    { 0xCB69395738E43B1F,0x5C325EE2EF760C39,0x57685B1C2182C907,0x5152F4CD509C9158,0x849CF9348B118674,0xB49BD09147C03BF6,0x9404A4A17755FC2D,0xF8600FDBA95B8EA0,0x000000000000008F },
    { 0xA88E6CA5C919662E,0x95A8487BD85D30AD,0x9DFE50154E156FD8,0x52D346081D42EB21,0x80BD6FAA5197E727,0x63DD034E2295DF4C,0x808A306FF14D5BB2,0x58A8B76AFF5B4448,0x00000000000001C2 }
  },
  { /* Point #14 */
    { 0x3C4ADEA091760C95,0x815E0F36AEA5E49E,0xD8FF4E31A40B3251,0x698327AD1BF537C3,0xA319B77AEA6994AC,0x58FFB9F94B63F3DD,0xCD34DCEE9DA96DB0,0xA423DA3025AD9C8D,0x00000000000000E7 },
    { 0x2EF956089D31F21F,0x4DA77FCE17CA4F11,0x2A544996295F1588,0xC515C1393E58C86F,0xDADD5EC7EE6C51F6,0x64D603C70872EA7A,0x8BEBC9F4946C392C,0xE0A618D90CDECD67,0x0000000000000027 }
  },
  { /* Point #15 */
    { 0xF44C856344020170,0x90E45B1C7DDD6FA9,0xF13839A242C66254,0x99EA9656D7BE4F1D,0xA9823806ABAFCE56,0xB4BC02EF1DE1B35D,0x6958138C69841816,0xFFA23B56CFE8DF9E,0x0000000000000121 },
    { 0x309B979DC1B4C6CD,0xB074A81399BC27BF,0x70AC0E9FAF10538A,0x4EC3C71A822B6200,0xD8567EEFD0E1E740,0xDED8EBF0518E0EE9,0xAF01525473F304A9,0x12FE8D03E7946C63,0x000000000000009B }
  }
 },
 { /* Table #84 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xADF5E06EA79CB073,0xCB46ACA98BF180E6,0x5BF0D9EB835F8E22,0xD692CD207713F3AD,0xA33E9D7FF0D87F74,0x9F2B6950F602A362,0x27A4C70BDFA4F77C,0x99C699DD3C56080A,0x0000000000000105 },
    { 0xDFB1B25595338FA8,0xABADBA3AD59E754D,0x2338452B436E70FC,0x34CFB5B2E07A21B6,0x25DDB684F81EA5A2,0x98F463C0AA325FC8,0x963BBC8094AEB02E,0xA98FE976434AB9FA,0x0000000000000188 }
  },
  { /* Point #2 */
    { 0x9A7FC933204A966E,0x7C1C59150D9680EC,0x0643609730415E73,0x574B06528EA44E8B,0xD35D1340F4B8FE58,0x81DDD1F4DAA40CA5,0x5C908486AC09937B,0x467DFFA614C180DE,0x0000000000000034 },
    { 0xE6F97ACC8000602E,0x2650E9570F527147,0x3AF58DD97C3923E6,0x67F7102E69F5CAFD,0xF80E76C00ECB60FC,0xD3441285197F6BDB,0xDEED257A52050B0B,0x8C28AFEA0703C0EF,0x0000000000000052 }
  },
  { /* Point #3 */
    { 0x2EA6E18456500523,0x566CCDD0F44D63FB,0x8CC0208DB01114CC,0xDB7BF61311E5DD4E,0x65E4263EFF83D7B1,0x12D2924CD6DA83E9,0x093BD19078380401,0xD2835BDBFF97C4F9,0x000000000000013C },
    { 0xD3AE4C901D8E9521,0xE2C92A4C42DC5BBB,0x478E934B8C96057D,0x0E526187EC6155F7,0x3ACA950D2BBE77D5,0xE7EDF96A6E492364,0xFC039FD22FE76745,0x68DFCE9653928C27,0x00000000000000F3 }
  },
  { /* Point #4 */
    { 0xAB482B76E225FBD9,0xD561F4CDD3C33A7D,0x18813777CCB2F003,0xA163377524CEBCE8,0xDDBE587D16ADB540,0xBC0D225F79E133CD,0x8FA3D30032A4C54A,0xDED1ECE4243DC5E5,0x0000000000000024 },
    { 0x94CE92A3FFD4B7DD,0xEAC8E7A15A8EFBD5,0x0C842C3FA9DC648A,0x19172F460D286101,0xC8681E80BECA770A,0xFAAA1AB4A8795D3B,0xE8625D4663944868,0xE13004F94F3254EB,0x0000000000000104 }
  },
  { /* Point #5 */
    { 0xB0FECE2BB7F3D4B1,0x8B6168AA47B042FB,0x207D9B0F01658A57,0x52DEEBF25CF0BB71,0xC678DCC72FC808A8,0x8BEA9D0975A39999,0xF26B5D2B7042C5A7,0x58B1D1BBDBE12667,0x0000000000000120 },
    { 0x10CF0B69D821C3EA,0x045A9342C684E985,0x2245C17F56BABDCB,0x7859852AB40C5F7D,0xCBC11CAF35B36FE0,0xCBCE03BADDC4ABE5,0xFA4797269E11EE36,0xC70CF89A8B993B9A,0x000000000000013F }
  },
  { /* Point #6 */
    { 0x2E911BB30D9EA003,0x50503FD6DD7BBB56,0x23780725F43C710C,0xF3854BC2D236028A,0x0BB0CD7085F08816,0xAF2BA06878E34910,0xB0AB1008558B8BAB,0xE0676170E24955DB,0x0000000000000049 },
    { 0xE2B0161A87B571F5,0x1676B3346209D9AD,0x402122ECE2F86308,0xBD0E364487D6F082,0x587EF7C464747111,0xE8EDFEEC8F3386A7,0x2B70F9333A489DB5,0x819E1D7C442A278B,0x0000000000000025 }
  },
  { /* Point #7 */
    { 0x731BE59D6EE24007,0xE96884C4B97EFD86,0x9E4A2BBECF73D698,0x7820A2D72EF12084,0x1EBBF048C5692055,0x707194DAC1B300F9,0xF45FE3FEC0D5DC37,0x20CB9BF6DF061C3C,0x0000000000000000 },
    { 0xEF76E09349841247,0x7E963D5C5673EEE7,0x135D2CA7C5EAB79F,0xF0D3AC04CEEB60E6,0xDB33FC361D07B5F9,0x37EF4405F1443AE5,0xE4716FAE6EC33BD0,0x3A6E33A14FD6F657,0x000000000000003F }
  },
  { /* Point #8 */
    { 0x6F01C26104E188FF,0x0D9BF057C7FF2E86,0xF9CD2DD6C8E36163,0xBFC6200BEC1562E8,0x735836B48AFB5102,0xB7A29E92035E1ED7,0xB16B14CA5F2E5924,0xA77550A628630D59,0x0000000000000032 },
    { 0x7B4BC3EF7418D27C,0xDF5C38B623B67ADB,0x168D61E3EA3713C8,0x806F95491ABD92F8,0xE806AB7B98EB3239,0x47F49E50F09B81CB,0x4324DA1706FD5BA3,0xD54DC8613193DD6B,0x000000000000003C }
  },
  { /* Point #9 */
    { 0x9F88FF35A3D49D3D,0xE4284139FCE247F8,0x6C4D5C7AF9DCB985,0xFBCF4FA1161D138A,0x2704EF59A06A95F5,0x2A277E200D0E4D15,0x3105F965C5DE8F83,0x10FD313DEABD284E,0x0000000000000133 },
    { 0x308BBDEE0774AB51,0x3E273E4200F231BE,0x843C53D8F8392927,0xBBAE99A3C0007797,0x110B8E4CE1F84317,0x456790C6E26FC087,0x13144322BF6798E3,0x35D44ED5217A52CE,0x0000000000000020 }
  },
  { /* Point #10 */
    { 0xD7C148B3841F5E75,0x4FB757644B5442A4,0x95E65524DCDFB2DB,0x2265E0EDD3446C55,0x7D95F3B17A24CBDD,0x852BEAA10567103D,0x48C62A902808760F,0x5F872492FC689AEB,0x0000000000000065 },
    { 0x11FA99ECD6740DFB,0x0B028E97621F47F7,0x2A75276C3B2A21BC,0xBAD738BBB779B390,0xA178AC3072CF8732,0x4C515B788EF8EBC9,0x5A411714B745B0DE,0xB7C566FAF0341A62,0x000000000000008A }
  },
  { /* Point #11 */
    { 0xAD24D78C5774FC6E,0x0AE7E57B8DCCC508,0x92D4A44CE70F8E39,0x3915C8EB837DE2F6,0xF7FD688854DD047A,0x13BCAD45D1BBD515,0x86E766A1302BEE43,0x788EA08A0986A53A,0x0000000000000188 },
    { 0xE0117403716F966C,0xF2FF910991CBDB03,0xB30A2A3CF6368671,0x29D49766ADF90B6F,0xE7333E2338D741C7,0x11995AE97E584997,0x0F46AAD3BBC84668,0x98AD5A3F89992582,0x0000000000000197 }
  },
  { /* Point #12 */
    { 0x42814AC122FF19A0,0xDE569BC8B27C568E,0x1D08A1226ADA1DB1,0x3A3FDE2E6E513DC5,0x29C0813B1F856F5B,0x13D3BC840B6CB7DF,0xABBA0ABA2C40BC67,0x1FB6EDCC8A718CF5,0x0000000000000072 },
    { 0x806A0CA2B312563A,0xBB056C4891380B70,0x0C90364B0A157F24,0xF79016C3D9E3F68D,0x8D12EDF88944A622,0x333D61B31EC7ABDC,0x372A693D50BDED2D,0x08BAD7DC2DFEFCCA,0x0000000000000081 }
  },
  { /* Point #13 */
    { 0x95AECAD65C1C6DDC,0xDD32CD749AE10BD1,0x81882AB6A84C69DF,0x8A7D8CBE8838D94F,0x099AD520BCC1300B,0xD63BB039C30E4469,0xB3BEF31417356877,0x48FEA9063238C2D5,0x0000000000000047 },
    { 0x772AA8F68E8FBFBA,0xE852C8F15845A5FF,0xF1355EE5A907E9D5,0x18C0BA0E5BA624E3,0x32A3B125B72C700A,0xE4E19FE46AFD2A5E,0x08009BD907E95944,0x14A813F019294091,0x0000000000000106 }
  },
  { /* Point #14 */
    { 0xFD9946A699102917,0x62DF6A373C73B904,0x9998064F29C4664F,0x626C7D71A38AEB0F,0xEBB4BA2D9DDBE513,0xFB7B78301D72725C,0xC1314481E4C19372,0x90C5EC66ED09077D,0x000000000000003C },
    { 0x05BCCD2F92B2CA1E,0xFFB71E3F55D4157C,0xE4913C2EB5EDF4E2,0x185EB955A96247B1,0xD70FF9614D7924B3,0xE6EBCE13ED6C45F0,0xCBB30C53786C10D3,0x37B6A2F2137354E1,0x000000000000015D }
  },
  { /* Point #15 */
    { 0x4D82915996367153,0x60562A5910E88061,0x2B2C480B942BD412,0xC015240FEFBBE7B6,0x363DDB1DF084FBA3,0x21739DFFD1C2F9EA,0xBF972D6FEFE1AC54,0xDFC5FF12EDBEF772,0x00000000000001E7 },
    { 0x2F0A919A39250F37,0xCA4B3F9711CB4BDD,0x85909EBFC15252C3,0xEF2421D0F81D74C4,0x7F8A45D7FAA5D679,0xCC97E0CAAF2C27AC,0x11FA8448F0393356,0xD0727C3B091F3A2F,0x0000000000000098 }
  }
 },
 { /* Table #85 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xD17BC05981FE2FBD,0x8247A0C7CDFC711D,0x973EAB2F63CE74EE,0x270A6BDC4191B5F1,0xE21AFB51637F5917,0xA84E71C550326C7B,0x14CEF332F30C35CF,0xFF0E5F89B7407D5E,0x0000000000000011 },
    { 0x7B23A55DF8B6B176,0xBC660C66C679C536,0xAD82144A897FDE1A,0x5082037D545BAF12,0x4BF2B1174448059F,0x59C25C1BF1E8C52D,0xC01A4B8D8E030E69,0x45077803229951C1,0x0000000000000184 }
  },
  { /* Point #2 */
    { 0x6A55868F11C50119,0xB78ABB45C7912BBB,0x00EC6EDCF2598660,0x45B396BF3B330DDD,0xF1E1B15D430B461B,0xD7D7AD1DE8C572AD,0xC236B2601EC38412,0xB668A33699889CF7,0x0000000000000109 },
    { 0xE39AB64B0BF6EF3B,0x83496BAEB87B2F04,0xC9A9009DDD04F4B5,0xCD813E028FBED8DF,0x8766407ED49842FE,0xED08303DD72A0525,0xED117DD7B47E882E,0x62EC57F744CE2E25,0x00000000000001A9 }
  },
  { /* Point #3 */
    { 0x8EE76FB84B60E7D4,0xCDCF289366DF99E4,0xF0A8087980648B08,0x3C499205AE3ADE6D,0x73D8D03503D4984A,0x4FCD2C1CE21A233C,0x0B5C1E89BF51CA1C,0x1B7A009F237792D1,0x0000000000000116 },
    { 0xD2DCA97044961EF0,0xD5A6FBCBA97A7B6A,0x5E6DA5975A4F98C9,0x2421C548BCA536B6,0x7A591AF11F7EE8A4,0x320308818A8817C3,0xD98A21782AF67257,0x31FB8F953828BBDD,0x00000000000001CB }
  },
  { /* Point #4 */
    { 0xEE2F0D5E485DA448,0x1ED09705FF6F7AE7,0x14EECC17280081DD,0xA120EE797230161C,0xCC768683FF269A0A,0xF63E5DFC2A872FAF,0xBB5B1AE6ACC10CB2,0xD110650707A71C22,0x000000000000007C },
    { 0xA17256895A78B340,0xC8802D2A8D805B2B,0x4F1BD019E62FAC2E,0xA1DD8419806B6762,0xE6808F48A9223942,0x50A99D62A6A1E281,0xFA71344852FBACC9,0x09E7A5FBB5D82A8B,0x00000000000000C8 }
  },
  { /* Point #5 */
    { 0x92E34BA8C8856636,0x7C3FED1D72FBA792,0x1B6165C5BE6A4B3C,0x2D00EFC16D28920B,0xEC8ADC9D4DD93E8D,0x3066D308AEF2D574,0xC860DE4AA82598EE,0x1B50BD377AD8BD69,0x0000000000000153 },
    { 0x69BD34AFB5B8679D,0x1FC682A3EAD5BD72,0xE476BC935653A45D,0xCCD683F57EA41F0A,0xC0A4A77FFCCEC23D,0x928D18A0405EAA14,0xDD427FDEDA4A173C,0xA46FC8183703452A,0x00000000000001D2 }
  },
  { /* Point #6 */
    { 0xA938BD6A646481C6,0x8D256C105A678A7B,0x3AD2B42578BAD22F,0x06E5AC058FFA66FD,0x41DE530BD2422F6F,0x9D1C319D59D797DF,0xCA1DC27AD1987D36,0x025FA8AD491B67C7,0x0000000000000037 },
    { 0xDB5D55360C5EB0BF,0x3F005107DC76A207,0x25A53DC94C0AA69E,0x37451BF2BF1B5BA5,0x71A269F6AF0BEAFF,0xB050FE1FC2C5FCA9,0x39C342448FE12057,0x2FB034BD78DBC6ED,0x0000000000000060 }
  },
  { /* Point #7 */
    { 0x69DD6EE8683CE282,0xE8446D3CD644B745,0x7738CFA79049B9FE,0xC84EDBAA8E449ABC,0x003A5B9820BA8D8D,0x4A490725B4967514,0x6A2E96CFC5E72A76,0xF54E30CB2445FD97,0x00000000000001B8 },
    { 0xC5B7369C5D00E246,0x9CD08237ED622D2A,0xA64AE48BEDA55962,0x13583919BE8B197F,0xADDC927F129FA7C3,0x54191F4B397E156B,0x6F0EA7B08EDB1CCE,0x5C8142209ADDB3F7,0x0000000000000023 }
  },
  { /* Point #8 */
    { 0x56B1560AC1C7CE9C,0x619FDDF45FEDC58C,0xE8D35DC7B59AFA4B,0x0C5F5AC8EDA188AD,0x14D11E1B1A468155,0x9A5FD6C91529288D,0xF8B121D3E9DA413A,0xCD307365E231527C,0x00000000000000E4 },
    { 0xDA248CC0F086EC25,0x800EA7D4306B0D1A,0xA5011AB86B74D50A,0x68BAD0AF749BEFE4,0xC1AD06091BBBCE0F,0x363078EB2727C718,0x2E2E4AEC18C61D23,0x41F8FD81C84E4120,0x0000000000000137 }
  },
  { /* Point #9 */
    { 0x4D2513BFCAE13D8D,0x28EF46E8F266D036,0x9A7138785F762418,0x96C0B179C09754A8,0xA077D4A426EA8C9F,0x92B2EC60DD557CC4,0x4EEF80935FA4D160,0x44EF893AAF5EE34C,0x0000000000000164 },
    { 0x6CFE0A245DAA76B4,0x9EAC02D046BE4847,0xC79F950A14779816,0x750D55F6D30FA3F8,0xC72BE7D6E1ED28FE,0x107DD9C4C91FC0E4,0x2487EE09ED20D7F9,0x8C07636FF35344AA,0x00000000000000B0 }
  },
  { /* Point #10 */
    { 0x0D9852136A70BC26,0xCB1F2915ADFEBDC4,0x1B31D91F28DF3154,0x8D75EC5621BCDA85,0x304EA6FDF67EC27D,0x1CCB668F6FE2B643,0x7E3456C7C00B2EAF,0x63647A9ECE5216B6,0x00000000000000A7 },
    { 0xFFEA1562068A95D8,0x03294D813DDD477E,0xB2B67622F64BD0B7,0xC7DB4A8E32269B71,0x988263F68108EB31,0x79A97B55C94E0630,0x7EA611DC3913EA86,0x13EF21FF8944BFD8,0x0000000000000189 }
  },
  { /* Point #11 */
    { 0xBE86985587CB7C14,0x15616EE6CE85246B,0x3CF7F06EFD42EE43,0xF8D3672F32D3A12E,0x332029E0A3B50D4D,0xAEDE54A14B5EB81E,0xEE3DCCD02244CA17,0x2D805525F90392DD,0x00000000000001F2 },
    { 0x82A7F544E316E059,0xC6273DDF8E019117,0x435294237F5720FA,0xE0970C3903A150C7,0xED65A8A021023415,0xD73597A461EF72CB,0x35AAE325B6FFE468,0x474ADA846A73E8F2,0x000000000000004B }
  },
  { /* Point #12 */
    { 0x0D771A96433FF017,0x79FF9C69E1654BC3,0x5156A4E9C8EE3A97,0xB3542F515EA71E9F,0x7059B0AB71D84017,0x96FF5CAB43C58849,0x346CFA694059D3EA,0x5BF9CC7EC38CAC02,0x00000000000001EA },
    { 0x0C5107EB664B9968,0xCA234D5C1D4E8C90,0xF861974D7120647E,0x2ADC73D274DA200A,0xE3DD641811AF9800,0x20A0E6E27BD43CFD,0xC1DC0238D5779BD7,0x088D276474AF389C,0x0000000000000106 }
  },
  { /* Point #13 */
    { 0x7935F2473C21843B,0xB657FBBC9813E479,0x963035DAE56E9357,0xBA5523251ADAD7EC,0x530B6935E0D96590,0xED0650CED0B8F665,0x7B8F88C0FC766699,0x3D34094FC9B6C92D,0x00000000000000D2 },
    { 0xE7CCE7A676E5A786,0xF6C639A7D3DDCDF3,0xDB5D2A862C806685,0xC6C1D55563CED6DD,0xCC0A8D3CD835F530,0xF7BE37FFA2D27261,0xE120753135DA9E0D,0xCB491F20BEEA6AF0,0x000000000000006C }
  },
  { /* Point #14 */
    { 0x2D1EC8C5D9D52020,0x9F3AD291446ADF25,0x3785C98702C5F9CE,0x9E6FFA2132B14AF3,0x21E7558A238B7F85,0x84795774EE9C5B70,0x83DF8AFBECA3BA08,0xE6580BB05BC97DF4,0x0000000000000196 },
    { 0x003551945BBDF708,0xEF524A464BB8D60E,0x997EEC33D7B86FF6,0x52CD213224D35530,0x4ED8E4B533BEE41D,0xDA92584C3D4035EB,0x384BBDD844C35423,0xCFA71821A731BAA2,0x00000000000000EF }
  },
  { /* Point #15 */
    { 0x2F97D9BE64CBDEF3,0xDB014C24035805BB,0xDA56447C0EAA0F05,0x6282362D87AB765C,0xE1572F134A7CB936,0x6CBEE6BA5A69A68A,0x982709A6D5297AED,0xBB388821CCFC7076,0x000000000000015D },
    { 0xEB7C190A14C61123,0x6352C151D67C82B6,0xE94AC8A2EDCFC589,0xF4AD07E927D1ABDE,0x56DD26504946EFAE,0x180E5C7B208AD7B8,0xD15CB3FC935F83EA,0xF529E4E64C6C746E,0x0000000000000105 }
  }
 },
 { /* Table #86 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x9A579DEE796DE182,0x6F780AA7F6FD67C5,0x8E2E0D6D6C566337,0xD8D685B5E5314714,0xBC0BCB3A8099F308,0x7127691F585CE610,0xB1DD4F51FE15ED8A,0xAB542E06217BD3C7,0x0000000000000183 },
    { 0x67E189835F29DBD2,0xF0092C9F74D67113,0x3FAA747C847DC935,0x798604F27F5BE1B1,0xF766DB9A8C76C26A,0xA38D86F05C205CA3,0xFEC097778C6E65AD,0x1C2B356C156B3B92,0x00000000000000D1 }
  },
  { /* Point #2 */
    { 0x40E2E814378740BF,0x63A78984CBD2BD7B,0x372E13DB8A8DAC87,0xAF09F900F60984C2,0x5FCB7A8E79DD89C2,0x29B8A792FF667CB1,0x9F8DB873ADAA64F7,0xC52129F85DCC5522,0x000000000000016C },
    { 0xA7C053BF00C4F4CF,0x236A5B2399F2B4CF,0xAA4E794A7D8F5DFB,0x42752A2262AE7550,0xBF731493B6AA180E,0x4CFEB68E0C875FF4,0x0C30DCD7E0C5141F,0x3DCF620376DA59F2,0x000000000000012F }
  },
  { /* Point #3 */
    { 0xDFB64F02974D9B78,0x31F9A91B41CCE8D3,0x34DCB6E34999E143,0x01D57CA3739197EE,0xC0F2108C78B9F00A,0xADC6692C4A735404,0x8358671E3BCC3B72,0x3FC1EA7D6F09F3C5,0x00000000000000E7 },
    { 0x9C983854E86D270C,0x4D51AA04AE44B27E,0xFF192DB6D49C136C,0x8B4EB830E0F2963C,0x839723CC894608A5,0x39DF449CFD6315EC,0xA65F47EFF69010DB,0xDF70203694F69BAC,0x000000000000017C }
  },
  { /* Point #4 */
    { 0xB3EEE6FE2A5A58FE,0xE8FAC6485F1BD90C,0x8C76159758FB2B1B,0x58D5A7EC41103723,0x33335BB4A9800518,0xA2DED46025ED26E0,0xA8996E7829E98932,0x819F8F8BCDFB40D1,0x000000000000006F },
    { 0xB8B1D0EDB98E803A,0x29FD31264620CEA3,0xEA10DCB49EEBE49C,0x29B7B6999AD55911,0xC77D33DBF0CA87E5,0xB9A166ECFE915661,0xC2AD03B0ECCF8C45,0x7B16346D053AFFAC,0x0000000000000082 }
  },
  { /* Point #5 */
    { 0x5E6DAEB491BF9E59,0x9DC3D78928978A08,0x8BA213793CF5AB93,0x13E05A849F7F32D8,0xCA46A51D24D864CD,0x49DA1D0958F27AB1,0x3D44AC191DD5BB6B,0x14EB042F960BA63F,0x0000000000000031 },
    { 0x8C9A73C4857451B4,0x61A5F60D29E1992E,0x6B6CD67B1AFF692D,0x3B702F11B835AFC3,0x4270A9BABFC9D3C0,0x68C63F32CA0C7CC0,0x841CF2826EA38E95,0x85C69BAF0D60D28A,0x00000000000001EE }
  },
  { /* Point #6 */
    { 0x085D3A3CD827CC1A,0x66ADE8B0B0A2B341,0x4B810C4CB68DFC88,0x77FE410EE5230A76,0x8426DD8E389A3A1D,0x2DDA407D7D94BCF3,0x5C661465415E7675,0x442EDB73273F2602,0x000000000000016C },
    { 0xE079D5BCB074ACFA,0xA72D9C62D08169CA,0xE1D49019F8828607,0x6EC373632E99DAD2,0x00F11E7BC8707B4C,0x8B3275A0FACE4DC8,0xFD045D4660AD7B4A,0xB59F6B352D870BA7,0x000000000000005F }
  },
  { /* Point #7 */
    { 0x360E5A48A3D933EC,0x0AB120BDF7BBEA20,0x30B58F9ADB780CDC,0x30736D9595285853,0xD52795FB1B3839DE,0x61ABB62EF74F223A,0x7134F16B31F8EC5C,0x716089459BECED0D,0x00000000000000A1 },
    { 0xE346FC2D8D5E323D,0x56AA6EF5AE6C4AA1,0xDEA1E40D130796EE,0x7685EFDCD71960E8,0x07E19BB51040E1BB,0xB89E54E64709427D,0xB09E9978AB677CCF,0xD155E8CAE4E79E41,0x000000000000017F }
  },
  { /* Point #8 */
    { 0xC08891EF1F60C05E,0xF9407F855915D764,0xDE8E7A4F0C96F04E,0x6F2753D62CC9D658,0x59C566B1DDD346F9,0xF47B8329E3197938,0x279A225BEC0F1790,0xD2001390302C441D,0x000000000000001C },
    { 0x71F6E57C20EA5E7F,0x12786BA3C8ECCC18,0x31BFEEE7563ADB36,0x688BBE01C99E4DB1,0xC1A39C8458226D89,0x4A23DB6DD0436B3D,0x9009C835BCC4A5D0,0xB5765B5B4BC5E903,0x0000000000000147 }
  },
  { /* Point #9 */
    { 0x70F293F78D7A1A55,0x6D47AE698DBD1BCB,0xD972CE7E2A482890,0x565B5A69AE414647,0x1FF7F1F4FAC08052,0x6AC7E4F7A6B8EA59,0xB00046D54C758546,0x57FDA89278C94B54,0x00000000000001EF },
    { 0xC89C53D4AB9B1FD8,0x120412C01939D37F,0xACF8AB74178A657D,0xF02FF62E6277E2F9,0x6D388ADADEF2648F,0x0A21D194D18D7EC9,0x28A91FB9620AF185,0x9A4BE9C4CB7EBF4B,0x0000000000000025 }
  },
  { /* Point #10 */
    { 0xB6CC18EBDA4A348F,0x75EC91DEA1828B88,0x33D09001749D90E6,0x09157F665444D6A2,0x3D99E23EC900287C,0x5B7EA7F56E259AF4,0x23CF7C3D7F716C57,0xF3EB640FFE71BB94,0x00000000000001AE },
    { 0x8244FC846E9CDCF1,0x595BEB65E002DB4C,0x5CAFF71941A87D50,0x79B6AAB4E3CCF8AA,0x1C57658749D3EB51,0xE81912249671A8DC,0x64C41EC1651FC983,0x9F8680D37983F157,0x000000000000006B }
  },
  { /* Point #11 */
    { 0x185CB8E721E2E26E,0x1866DBBFF82C3492,0x5A5E2A8913FE27AB,0x2A97A225BA74BC51,0x9699342B754D7055,0x11CBB11A2395566F,0x7A1A2E8D98DED0A3,0x17986E2379B54681,0x0000000000000003 },
    { 0x646F4099DA8C44D5,0xB738986D451EEAEA,0x09DBB26B7A3B8625,0x5B427F68DB3935BD,0xD946C20DA7131AE5,0xAE04CA918A745C0D,0xA1B0EF3A3F2341A6,0x7B87FE01D6C790E1,0x0000000000000098 }
  },
  { /* Point #12 */
    { 0x78A6A00515CCB3F5,0x77707ACAD710F874,0xA9F60018DF76FAB6,0x7A05131EB0EF7585,0x73076403C0347BD4,0x5677F9B970F16928,0x71E01AFCACDB7C70,0x2801531DF2261BC4,0x00000000000001B3 },
    { 0x2E0884C087AB879E,0xCEF683AE5692F07F,0xE9378CA2ECB5108F,0xB259E58446581FB3,0xBF13BD74D9AB63E2,0xDBB1A8660488E2F7,0x308D1A9C791C614A,0xC064C4B74BAFECCE,0x0000000000000068 }
  },
  { /* Point #13 */
    { 0x2368670204035FBC,0x494B7BD0A09FFD39,0x24D81683D3D1A346,0xD8717302A15611ED,0x67D48150235FBE70,0x7056885B92733E93,0x7088DD8D149E63C7,0x9D1FA18C9FA2B660,0x0000000000000093 },
    { 0x05CCC95BAB42E341,0xF8DDAE598D84B663,0xECBABDFF710E5D05,0x6BF408EFE7D83FA7,0x01E9FBA9CC612F03,0xB11B149A4B68351F,0x2EB12CB1C441FDC5,0x1C5AA7073F1779F2,0x0000000000000079 }
  },
  { /* Point #14 */
    { 0x37097C79F3582E38,0x32FB2F72ACB94FD0,0xE9F248615BD8E99E,0x021BD377D89F261E,0xC27CCFBA354D698D,0xBD90006363D0D0D1,0x1A2FF3650FFE8C76,0x2E06E2AC0A5A912E,0x0000000000000056 },
    { 0x32D5F87321AC73F8,0x6071DF7F1CE57659,0x7B26CFE7F3D02F88,0x49889F71AC4B7CCE,0x6A8E756E4AA74667,0x68698EE6CB72BEC2,0xF10FC0E132A6E923,0x25D53885DDE3045C,0x00000000000000D2 }
  },
  { /* Point #15 */
    { 0x6261F11A490FCB56,0x80E1E5B92166A7FC,0x2156E7B7410CA8F1,0x6BA2949DCF083D43,0x6F8C280E85F7A658,0x86921A03C5362A6F,0x212C2960A82059EC,0xCD6E8BF65535B1FB,0x000000000000003E },
    { 0xDE0DEBF94FA231D9,0x3891EE50BB251008,0x4F2E882B1D3CF2F7,0x55AE8AB4A441EA5E,0x1A2FD89697F3D7D0,0xADDCEBB8240F6844,0x00C9E36A7C1AE8A1,0x017A9763B8C7C299,0x00000000000000BB }
  }
 },
 { /* Table #87 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x1E2DF23635210DF1,0x387B5C569AACE566,0xDD8152C9EE401323,0x56FE9EC99CAC0076,0x88ED7FC1E1A9F782,0x6551487D681F0428,0xEAACC10197689006,0x626BCAD13B7E7FE6,0x000000000000015E },
    { 0xE1B3574A7ACB23CA,0xADDA7C9E3636A1C2,0xFC998CF89F3D947C,0x38EE4DF41BA0511B,0x1F40CC1403E4694B,0xCCECF4E0800FB6D9,0x021F708AE1665D06,0x2BCD7975C492D329,0x0000000000000063 }
  },
  { /* Point #2 */
    { 0x2FB204FFC6AC25BF,0x04264D4A20B8FF3F,0x95B64338A430A774,0x573A4B367DA8BBA5,0x950AFFBB5B83D767,0x9254695BB560C0F6,0xFCD8A4FBFF22DF77,0x8625ED302D6E43DC,0x000000000000004A },
    { 0xED8010F61CAC9547,0x0612E17392C7BA4F,0xAF48AEED051D9478,0xF7067A1069A78479,0xB17C4BE898A1AA82,0x2B21D42A7A94D7E1,0x461B848FD38E3B49,0x76AF1BD6563A87E7,0x00000000000000E8 }
  },
  { /* Point #3 */
    { 0xC7DDD089AE0F18F7,0x95EAB6D82D964B17,0x009F85D7B46505F3,0xB67945A0A9A1C11A,0xD9FF12021BBBC573,0x6BD2CCC2B7362ADA,0x4CCE7E0801DD0F97,0x561695F007812CB0,0x000000000000006F },
    { 0xA077FDA2F3215E8A,0x6AF16D30500D446B,0xA41A906FC74FCC40,0x4134CE42522A4CF3,0xBC3D327CA915D9FF,0xB337C069CEEA5A67,0x887DB11718026771,0x5CF163938BEBAC88,0x0000000000000172 }
  },
  { /* Point #4 */
    { 0x5A4AB9C18D71EF32,0x08205F9BF4F4CF75,0xFE64565DB34A8C55,0xD12BE047169994BF,0xD3C3F84F43F91E62,0x1DAE2E732601B686,0x2A07FCBE2DEE30E1,0x25E562459A754926,0x0000000000000174 },
    { 0x288455F32CE4D340,0xA1F4E6B0E321170D,0x9A36BAC390039106,0x1682B04D98C7ED01,0x27166C68E9EBEF5E,0x41EFE4F001CA803D,0xF76898AC460A4C5E,0x6A787FC31ACBCDA4,0x0000000000000103 }
  },
  { /* Point #5 */
    { 0x5F68A1AC6978F0DB,0xB3329BA5005885E7,0xD266D61D5DEDCA85,0x51FCCA0B36D128CC,0x8BEE0599C3025CAD,0x0D3AA61C78E1C6B3,0xE030DAEB3FAB73E4,0xDC536F282FA127E7,0x000000000000016A },
    { 0x803482FC4549F784,0x0D6EC627741BD062,0xA16F16F85A834635,0x59E41E2AC99B1275,0x9B758008252F28F5,0x26784958D3B85B44,0xD1BF7AEB740E330F,0x438AD02162CE2EC0,0x00000000000001B4 }
  },
  { /* Point #6 */
    { 0x7F5335323E2DC0A7,0x8437FEB79EB1C84B,0x9AFD2F9ED63CDFDF,0xF277BB5DB598BB40,0xC466C261FE4E83E7,0x980A851E851A0675,0xCF2D8DD5731AB1E1,0xD3AD18041925037C,0x0000000000000122 },
    { 0x58589CCA50637C5C,0x426EE8FF09F80DE5,0x91D105EB960F1B39,0x303BF40463D1A564,0xBCBEFB9F57FACE6D,0x28A5BE6CB1EA2EB3,0x8093F327AD4D1BC8,0xB4F34986F18706B1,0x0000000000000158 }
  },
  { /* Point #7 */
    { 0x687BBDFD968B2D8F,0x1D28780808974650,0xBC35D66E5C7B12CB,0x0CA1ACB181E92ABE,0x0086135DADFEB821,0xE0E0E15B0EBEF769,0x9E38C06786A2ADCC,0x8DA847D1A2CCD0EB,0x000000000000016E },
    { 0xF195153407F500C3,0x7338419580A5D232,0x71E668C1F6C3D6D7,0x8C3510E7315DCA1F,0xE2E86FE8BC78C67D,0x690CDF9E98E98452,0x8FE94C968D2345B3,0xACA25C4DC152008C,0x00000000000000F3 }
  },
  { /* Point #8 */
    { 0xDCAED4E0EB86608E,0xFDFD21688D7BA967,0xD4793142866E3436,0x259B748BF9E22704,0x86914896AC039548,0x2236C40DD7C7EEC2,0xD76953AEA1C8873E,0xF3E9F9539CD08A3E,0x000000000000013C },
    { 0x2D653796535C50C7,0xCB8B6A753478F1C4,0xA2ABFB2ACF0AD848,0x9CD60FBF7FC08E6D,0x3706C38749F48743,0x3EA91A1D3E0781E3,0x8C19973BD007F364,0x566D7CB522E5F10A,0x0000000000000103 }
  },
  { /* Point #9 */
    { 0xB3BC60520009BCB3,0x8F2841D74D132953,0x41B183079BC2071D,0x6DE32A619EEFFC0D,0xD16B0C86F6258572,0x50EA76A39DC1BB50,0x3E33DF99EBCAB743,0xD5732B6B9A2108BD,0x000000000000004A },
    { 0xA81C904F0C863D23,0x6F6A54E5BE97CB6D,0x69F4C82235F8A8F9,0x8F1A0AE4E5A76F62,0xB4FC5C69DF72F008,0x0AFF97F08DE7170C,0xC66E24EFD6809BDC,0xF69634E069F09E52,0x000000000000019A }
  },
  { /* Point #10 */
    { 0x0E73575012CA66B5,0xFF2BC766AF312B6F,0x8066631386A7BD93,0xC007C3511A349EB2,0x8C8D9D2A6D0BD3DC,0x88A125E764950103,0xB9D4E64661CFBDAB,0xA21179ED7C8D2E66,0x00000000000001B5 },
    { 0x9540C959F25071D9,0xCF06452A0AAEB4DE,0x7578FCE6F134A4DF,0xECD201E9CE332F25,0xE5BAA790B6CD78B2,0xB402771A886EA9BD,0xFDDECD64A621D280,0x9A09457EE43CC2DE,0x00000000000000A9 }
  },
  { /* Point #11 */
    { 0x2A28A131BFDC59EE,0xF68072157DC5E016,0xA9259436DE1C8334,0x42992F1DE29F6E41,0x97E431F2C65B5CB4,0x833AB1AEC3826F03,0x2832BE35EC4E2982,0xB4D321F5077C72E2,0x000000000000002E },
    { 0xFEE0A81C35FAD0E5,0x57809E772CDA00F5,0x876378FE5D66AC96,0x576AC520F772A965,0x582AFDDFE82DEB0A,0xDBFCFCA68C178781,0x9942A3CFC3D3A4F6,0xB09D150538697B0E,0x000000000000016E }
  },
  { /* Point #12 */
    { 0xFF04036328FAA051,0xEFC95341172C6CE0,0xE4028C4A7D53A624,0x481FB2FCE3AA1E70,0x4671FAF3D2D92AC4,0x0D581A28CAD49733,0xCFAB195DA5E23867,0xF6784D62C8BD1EAD,0x0000000000000170 },
    { 0x2BA73D671694FFAE,0xBAF16D6D47D613B7,0x5748FB2FE24A2182,0x337D36AD8B9D5587,0x07B92CE38CFCF82F,0x99B04584FCA2CB04,0xE8FE5417A5DB355E,0xA29A83971E795369,0x00000000000001F6 }
  },
  { /* Point #13 */
    { 0xF327CE243E6B433F,0xCFCD5229F975CAA0,0xB302B4A36BC491D4,0x00C81DA9A9A67752,0xE806C66DA6EA2ED6,0xE36659CDB48A62C6,0x0AC9994CD632F848,0x61545A1B7EB6F4EF,0x0000000000000073 },
    { 0xEDAF476C978961F1,0xA304CF86303987F5,0x41E098CF88944AD6,0xBDB71BFBC8D574BF,0xA7AB014661BF991A,0x15C0243D244930D5,0xD5760047458429A7,0x2A014407A041EB75,0x00000000000000B1 }
  },
  { /* Point #14 */
    { 0xE1894C786429C5E5,0x747099BEBEB77736,0xC1C79BED4F1F29F7,0x8F5EE037FCD8551E,0xDA75CDA71519EE2E,0xC70420C94C314D32,0x3ED19A1EE69BAE1B,0x279FED63A51DC479,0x000000000000018E },
    { 0xA973C255B4FE6DCD,0xC347DB02068B6483,0xCA0BFCDC0CFCB88B,0x1EEB68AC622BD831,0xE94B590B5CD7EE13,0x2722337C019C7E19,0xB104DE2E82E1A211,0xE1B81B10DFA847AF,0x000000000000003C }
  },
  { /* Point #15 */
    { 0xED2E611F357C5F82,0x4CE09707EC201B42,0xEF11F1DBA0193F95,0xE0E7FC778FAF2BEB,0x4E5710BD36E14D0F,0xCDC2650EA32ADEE9,0x5A6C6BA93CBE7785,0xA2EA1512A9DEBF8C,0x00000000000001A6 },
    { 0x1867B652298CA459,0xA977FB5833835415,0xAE725C6B4D04BFB2,0x8FDD604234CA55D9,0x3C0F9214AC28E60F,0x717A241814F6483A,0x93EA1DAC6DB52622,0xB93AC4503534A876,0x0000000000000144 }
  }
 },
 { /* Table #88 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x674E392F0261ADA4,0x5AF762F55BB103A8,0x281AD6A5C9E8BF69,0xA88AD2E45C57AF63,0x7FBCE1F23B909CE5,0x37883DA84A8C86DA,0x94F7C5708FC8357A,0xA1F2FB59C7C21EA8,0x00000000000001AC },
    { 0x30C79E7B1CBA57C5,0xF71D84BE6062FA39,0x8FB70B03E2B9C131,0xBB0F27E7CD862B12,0x2FEA10874FFD6A0A,0x177871582A7A7B08,0xF79606CC8653CE49,0x9514C960629A5FF9,0x00000000000001A0 }
  },
  { /* Point #2 */
    { 0x1FB30B26534DE721,0x467328664123D0BC,0xE4E83C0D3A143F8E,0xE1F5F92A691180E2,0x5FB00E76081F7230,0x0E4E513D083C3776,0x5B81EA91EB042C2D,0x7A221CB200AF7F4E,0x00000000000000E4 },
    { 0x7BFD3F9131E75C9D,0x8545ADADA2C68D12,0x01C295B9F986AD9F,0x186952A541EB1F2F,0x6F7E3E3EE802FFC8,0x704E75D0B98FC92C,0xC233AFEE4800A8FB,0xD0111A57549D5FA9,0x000000000000010B }
  },
  { /* Point #3 */
    { 0x238D0F45E5375E53,0xB576C6CA60B1447C,0xA3A372A662216556,0xA36F6C4A8649C9D5,0x00E80B35AB50C2CB,0x11E5520E2556C5A2,0xAC58D6F1D3AA02DF,0xD56BF8228B95FDDF,0x0000000000000094 },
    { 0xD172331A2A513CC5,0x35EEE6975EF6A6BA,0x4F02B17FB0ACDC95,0x07EC621E1EB68058,0xF266346CDAC73D4C,0xBE978E8AECAB7DDA,0xDA0244E8968C2EB6,0x50B38345CEE91ED9,0x000000000000014B }
  },
  { /* Point #4 */
    { 0x01188022F8816103,0x64E1C614DB3855D8,0xCD4BD4C229A7C0D2,0xD7EC42894D5ECE84,0x947A8BDC722FC703,0xA4C09186BFEBACFF,0xF7FDA81EDCF3B746,0x3BF6DC1B435034FC,0x00000000000000C8 },
    { 0x319FC666878B4418,0xD600347CCFA14A68,0x5ABCF8FC912B3C2B,0xC82C5E12C5CD581D,0x022F767C50A27865,0x5C606862EAD1F5F7,0x2702E8192259D674,0xAE371A48E02204AB,0x000000000000001B }
  },
  { /* Point #5 */
    { 0x2AF67B2B1D6F6E88,0x02B012D358551562,0x6B82B1FECAFA5D8A,0x7F82B4E2E6FEFE9B,0xAC91D292E6B8BBDC,0x1E330708AEB0467D,0xE5723339D2226EC1,0xDCB1DFC411CE4198,0x000000000000017C },
    { 0x4C55853AA74E39FB,0xDEADB9343E55ADD6,0xBB7F6B234D9052CE,0xC39590032F3E7BAD,0x78636279AD990758,0xC476679E34BCB90B,0x9AB2BADCF9FE3F2A,0x414A32C01B69EF65,0x00000000000000C1 }
  },
  { /* Point #6 */
    { 0x114453E727F2F67E,0x7199960246EDB75A,0x481CFC650714F2EC,0x7A359E11BD48C221,0x6807F0B5BF80FBDC,0xDFE57FFF51B3A6FD,0xE58F3C47B6794229,0x7F22CF6ADEF683BA,0x00000000000001A6 },
    { 0x551BBAE28C39F9AF,0x5057C3A7B1E075DB,0xEEEDD6009E0D386A,0x8D60B730715B2507,0xD65F990B840BE62E,0x666437B2287CC361,0x11C2019C9CFE886B,0xBEEF8EB4EBF4CE61,0x0000000000000008 }
  },
  { /* Point #7 */
    { 0x422833D5E2CCE69E,0x3C1C8BDB69FF8B37,0x44D41DFBC9FB427F,0x15BEE2DDC54A1824,0x9C804025E8CE4AEE,0x5BCC7E5D9E5665B2,0xF38636A040B6270D,0x84CADA1A60B6778E,0x000000000000014B },
    { 0x28B4411B9B47CCBB,0xE4BC1E916C368197,0xC0F36E6B2562C900,0xC60D562888C55430,0x2E9613DFFB81C20F,0xFDD934ED56872B5C,0x6BACD3AD187BBDDD,0xF6F821D7D1E42D9B,0x000000000000012E }
  },
  { /* Point #8 */
    { 0x15581925DE0D59FD,0x861DBEF21E668987,0x000CA03681FDAEA7,0xEE45E5EDB5007BF9,0xD98680509485C5FB,0xD58CA541E2A800B9,0xA0D643DF05E1BF66,0x3DB52CBFBDCF7DA2,0x000000000000011C },
    { 0x0A1DB94387AF7109,0x33754C60FD35138C,0x2BDFF118FC19982A,0x2E8EB645D22CCC69,0xA7873CD2C73E39D4,0xD024363E1D04FF18,0x492503D60CC6ABDB,0xADE16418185AB722,0x000000000000015D }
  },
  { /* Point #9 */
    { 0x9C427EFD472A1C76,0xBB1ABFF22BB334B6,0xEC7C11468050C592,0x3795AB5851C77DFF,0x403FA93CD0A8565A,0x7EA1B2CA8560A630,0x644B40BFD92FF341,0xB83C8B3E25F2CBBA,0x0000000000000178 },
    { 0xE46C901A355D1A67,0x0C8AAB17077D71CC,0x7D04573304F187A4,0x3849DE53BD2DEF81,0xB0B7DD7BB334041B,0xB05F3B1D245DF6E6,0x561B16A93433E78C,0x25E1F0A1995C0111,0x00000000000001B1 }
  },
  { /* Point #10 */
    { 0x94DCB7602D3724F7,0x092D781E5FCDC7D4,0xC3FEDCA6DC823E29,0xC2C19E31AEBF4AC9,0x2AEAC69BEAEE6608,0x2C2E52376C85A59C,0x08949223A91D8CF7,0x9EF9B311F0811914,0x000000000000003B },
    { 0xBC09E4AD786D0A50,0x482BC9FD3B427AAC,0x614BDE569D2EF9B9,0xD9D846800763D7B6,0xE1C9849C7685856C,0x5761DE36532A8B13,0xAEE9AE018AB8534B,0x6297F7CDCFFE238E,0x0000000000000045 }
  },
  { /* Point #11 */
    { 0x354D7D39FF3579CE,0xD61A6C33687273DC,0x8E79F8BA0BF66EA7,0x0914B68CC532810F,0x86A1F3BE19D74CD1,0xF663A8D2EA1DE01A,0xE890D4E8F989647A,0x1C31BDC54C3460F6,0x00000000000000ED },
    { 0xC48F0B654D05C7C2,0x10F0830687586519,0x3A28A202B0B0B6ED,0xA1EBB5B9A5655D5D,0xBF19A5AB05790E30,0x1E4AD7B17D237AD6,0x829AE2DAA98C9125,0x5406F57A544704B3,0x0000000000000099 }
  },
  { /* Point #12 */
    { 0x6AF20098EDCC581F,0x744E603FB1D8EF85,0x77A155E23A4C70C4,0x7CFEC62980E719E5,0x6AD16816771ADB9A,0xAB2B9AE6917101B6,0xFA1C8FA122B8606C,0xC6ADE9B6912FC59A,0x0000000000000099 },
    { 0x5842A39A8BBC4442,0xF7CCACC0937825EE,0x8AF901AF76669DDD,0x4CF82E79E7CA6918,0x379DAB5022DF76D8,0x7070302AFCC877BD,0xA959A86B0DBBC81C,0x38C984CB78C2C637,0x000000000000008A }
  },
  { /* Point #13 */
    { 0xE05AD50282808E09,0x7B5DC16001E4F0B6,0x78D1CA1933A6EEA2,0x9AF18043509CB3CA,0x1E796CE5FF953005,0xCAC11CADA26B33F2,0xFB9DB0D67D84E525,0x1B66890A8BB37875,0x00000000000000AD },
    { 0x7BDCA42375D780EF,0x0AF21A0BD16D7858,0xB56371F7CF42AEE6,0x0ED2542214BC7AE3,0xAFAFD8948C5DE97E,0x340A2C54BB065E75,0x4ADB4195861C19D2,0x98C390DBA914DC62,0x000000000000001F }
  },
  { /* Point #14 */
    { 0xE8077E42ED76067A,0x7A4D661B5885CFC8,0xED03423D6E12C1EF,0x2AF0BD867D62B094,0x5D5C959DBCDE7990,0x91F3292361C8C493,0xD3A2D1371DDD8404,0x43CF907EE9416BDA,0x0000000000000179 },
    { 0xADD9D450F88AB3D4,0x26ABEFD97B3C1B2C,0x0EABDF60F0EC7168,0x48584461499D981E,0xE2024F8A65F1E952,0xB13926BDCC1FC913,0xE32E53C3BA02B960,0x44B16D28B114C958,0x000000000000003B }
  },
  { /* Point #15 */
    { 0xE769D8F767A1352D,0x49B1D2C3E9856974,0x9C15A1FC86E54AFE,0x2D2C7E68B0E5B119,0x3556AC15432CF4A2,0xE25EBE20F39D2D76,0x048843AE51E8C89E,0xCE4822E802531BE3,0x000000000000004D },
    { 0x4992A988C947B6D7,0x7EB5FE67EB717C00,0xD4F2215BE33B7F1F,0x32B9FCC2A4511D0A,0x4884419D4D1089C0,0xD7457E3E3DEAD6F2,0xF12C9F16C66123F8,0x2FF7BCCDA2831727,0x0000000000000025 }
  }
 },
 { /* Table #89 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x58E8CA2CEA2E4075,0x5307BA37F271D545,0x14DE3B6E7AE7AD07,0x6BF3DAC6169EFEB3,0x7BE665B6F0996AC4,0x3CBD076660A81EA5,0x93369D84B0876044,0x33CD68DC8A489412,0x0000000000000133 },
    { 0x44912D16DCA5B802,0x3C30F445808DB8C1,0xD59E92904D2B7D5C,0xC1E20A6B2697A600,0xFBBE023C3A028772,0x8873D0BBC6E3B099,0x5FE76AC9050828AD,0xCF2AC286C0AB0AB0,0x000000000000003E }
  },
  { /* Point #2 */
    { 0x5FC885130076C379,0x85E6F65CF31E63D1,0x5DEF4F28EBC87B34,0x74D28F51ED0BE6EF,0x1B83692D38771840,0xD791F738A859B7BE,0xED0CC1FEA02D058E,0x2B1BEFC5FECD2E54,0x00000000000001A5 },
    { 0x63864B8948CCA591,0x38195D6129335913,0x8DC688BCC799AAE4,0xB6D23959417331B4,0x3D08B4F2743F8E65,0xD46215B24FEC2809,0xB37D17000497E0F5,0x6BB17CC026EE48A6,0x00000000000001E7 }
  },
  { /* Point #3 */
    { 0x38F34463A1E93E26,0x536F9FE3A933AD7B,0x49AA8A6CEEAF58FD,0x590A90148548A60B,0xDA53DFA8C34B6A3E,0x92A83FCD2393CD71,0x802A7CC921D4394A,0xC565B327A00B1E13,0x0000000000000036 },
    { 0x155DB7828143ECFE,0x17CB85EB7DE2CD53,0x74B165A8AF4AB2EA,0x9B27A18BB2D9F719,0xDAE468E17F45F2A2,0x4F0B09ED6F20B170,0x5A15A831AB1E2351,0x7D64FE683B7FC656,0x0000000000000149 }
  },
  { /* Point #4 */
    { 0x59614F8580C55F68,0x9DCD662C60CED87B,0xE6DC932BF852F5AE,0x9DB84A914F45A31E,0x6062B2D6BABEA7AC,0x54A5881D28B65906,0x551E0B60B0F80DBF,0xDB468350B286F88C,0x000000000000005B },
    { 0x905656106BBB805F,0xE38F65A46668E10C,0xE619256657F2578F,0xC26D80922A72A1AB,0x904A9A525119D939,0x622F5869D6709295,0x0A6ED42974543616,0x8DAD3C361C388E75,0x0000000000000135 }
  },
  { /* Point #5 */
    { 0x457DB9FDE4DA7574,0x7A0A28975885E55E,0x9AB3CD5EA9B51665,0x321E2F08D9477C8E,0x41E7C2FCF8F37F58,0xF32D7426A87D975D,0xF4BEB557CE959A1F,0x858A6D9D4DD97BC4,0x00000000000000A9 },
    { 0x5F10563CE8C2F351,0x112B7D6336E2FAC5,0x32951764AA08B49C,0x3E39AA166E6CD71E,0x63E54AF67B47C211,0x8C05ED23C9ECE8D1,0xB315B2D312ED9538,0x1CFFFB33FC0BCA7D,0x0000000000000133 }
  },
  { /* Point #6 */
    { 0x8BF2FD7E6DAE890D,0x6B675C1FC9028F7E,0x627B27A810D1A8C4,0xD24C988BF522E753,0xAB18F36AE0BE9869,0x9FF0E1FA962CDFA1,0x14911EF55945DB5E,0x6FD48FB37652AB6D,0x00000000000001DE },
    { 0xF8184CE8FBB2E5EB,0x02056B25B09791ED,0x2E11264024ABEE11,0xCF22E0FEC5119309,0x64E4ED26136A9CD4,0x16BBCC713E9B4BAA,0xF2970B1F83D64789,0x82C66547EC9A3758,0x00000000000001CF }
  },
  { /* Point #7 */
    { 0x7D1CB4E119230651,0xD2B971373F601E3B,0x0B69955D5FD38F46,0xDE4097ADD816E924,0x3A34E753C04A98EA,0x522AC82A48839FAA,0x9BB3D26E1A571619,0x637F4B56A1E9BDC7,0x000000000000018B },
    { 0x7156BAA645AF1D3B,0x72FF3815B7F8AAF1,0xAAE7E5ABA19C4F45,0xDC47A5D29C736939,0x1AC3D44277A2B40D,0xE3EB3CAC373A68E1,0xD28A0E83F6AED8C4,0x4DD537B051A2CD35,0x00000000000000AC }
  },
  { /* Point #8 */
    { 0x9BF40D7110205C46,0x10F27886161DF55D,0xDDA5B7624763C7B1,0x4BCE55110FBE9F17,0x8FA954484BD30A7D,0x302E33B31D27E799,0x4DDDE60F9752FFD2,0x98DDB153CDED611D,0x0000000000000069 },
    { 0xDD9ABCBB3E817CAE,0x3C6B3FFD52C627C2,0x3209E7B3E28C3DFC,0x376F4071EDB287BD,0x9DDAAA58AF0FAB10,0x969074CFF859B34E,0xE16AEC58C87E6EF9,0xC5C7D470D113B6E0,0x0000000000000066 }
  },
  { /* Point #9 */
    { 0xB71E9DF2BB54E4A4,0x719E8B7E6A2A9ECB,0x949974C5B57129FC,0x40791DB3E95BB43D,0xF7172AC18C837114,0x9C35B2A6B0875175,0x4190FB4DAC6CB1A6,0xB85A8C2AE27A4496,0x0000000000000007 },
    { 0x0BF52A2A3EE3F76C,0xB4EA53FBC91B7B0C,0xDDB9FB323982DD27,0x342543F2564D8104,0x4697EE1C48E5D315,0x21C0DB99FAB5AAF6,0xD2D004233780A22C,0xAF1C84AF005695E0,0x00000000000000FE }
  },
  { /* Point #10 */
    { 0xF0007020C199EBCC,0x1B8570D6F910A2A2,0x35DAADB9B2F82126,0x49A1E3218CA81D3A,0x608ED9749A7AD74A,0x92AE9DECBB27FAF9,0xEA7DB297DEDCC552,0xB61E57FF65E726F1,0x00000000000001DE },
    { 0x8B30B706D4B6B7E1,0x9DCFEBDD75D5772C,0xA1E51C660B5F72FB,0xC594354756A7D61D,0x45520F75912E1F45,0x5C5DF563771562ED,0x8A2EE7850BC64D28,0xD2C21B1430D7B664,0x00000000000001B5 }
  },
  { /* Point #11 */
    { 0x76A8E54B9B162679,0xB30A4E549A0DB1F3,0x6FAD97B5E5B7D077,0x5BB0AE387747997E,0x14999F284F2CD7B1,0x8DF6E16BF0893CF6,0x3F24A3D2F81EA7BB,0x7E272EC4A51263E5,0x0000000000000072 },
    { 0x80259F3B7D62C5F6,0xB96E86C6188A2BAF,0x8A52D834DFC02EF1,0x5F8BEE077F2143F9,0x6115763F99C485EF,0x652E2D7C22BB03B5,0xE1215F81940EEC2C,0x75D050D49DBD6EB8,0x00000000000000F8 }
  },
  { /* Point #12 */
    { 0x845CD18ADEAEFDA9,0x0E694CA269B50E21,0x060BD03952E5334B,0x4AB963A525BAE929,0x7904F9FD2A8FCEB0,0x535DF726E889B7BE,0x1FE0C30DAB8D94F2,0xDDC0E7323F92E2A5,0x0000000000000106 },
    { 0xCC4C26E5404844FF,0x53C01A4D301AA56D,0xF7EFF6A4A13A9558,0x994253BCB771FC98,0x5B9323E8B1D9733C,0x29ED522B1CB7C6AC,0xE537003A3E4426A7,0xBD83F66C36F23BB7,0x00000000000001AF }
  },
  { /* Point #13 */
    { 0x12B4AB41ED7F60A6,0x82E070B5B0E733CB,0x8615568DA61F7F5E,0x93EEDA4AF33C7660,0xC159D74EA9454D5A,0x24D117E5E8206045,0xCB137EB249256D3C,0xFEFE9F2B69E4F9B6,0x0000000000000057 },
    { 0xD68D066E2002F86D,0x6298FF43D7036956,0x17D720C8C281122D,0xF78E58C677A4E8DB,0x975FD22BFA3CD180,0x4475849F830DCDCE,0xE296E0ECC52981B6,0x3316EAFD801B656B,0x00000000000001FB }
  },
  { /* Point #14 */
    { 0x732634970E7E5EE4,0x01E0819A4F8E43AF,0x04DC6911B2620D54,0x5908BDEAB166DD4B,0xC27F597530B81A6E,0x4F969894D47D8CE4,0x7D26B944A9B9B5FB,0x1C77D724F2E481A0,0x0000000000000007 },
    { 0x99EAFE7B9FEFC298,0xAFEAB30D35DFC4CE,0xD9868F02B3FD8794,0xE8470C347893A641,0xBDE8016F9A5F544C,0x5735714A2D93E0BA,0x72D7A1DC41D47E55,0xCED50D7A89FE1DC2,0x0000000000000137 }
  },
  { /* Point #15 */
    { 0xA628642648E2B9C0,0xE154691CE84E4678,0xF87040EB877DE67F,0x1181BC3EF97DB089,0xB3136FF0974CE68A,0xF56ED8EC19ACAE0A,0x48817E3F4B96E4B9,0xC3173CAA8955942D,0x0000000000000094 },
    { 0x47B82BFDE1002024,0xAC084D4FEF168C61,0x1DFA9EC38575609A,0xF13CC9AA3783C722,0xC4F9B8D79C9E4769,0xC3739D0A5E9B7CCD,0xD71AACF87046341C,0x03A68FD0F543DDC7,0x000000000000019E }
  }
 },
 { /* Table #90 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x9DAE6D7AF8ECE594,0x7AD12F48CCE0B041,0x9D97EFC7E7374970,0x7B8B1668311F5E2E,0x0D68A7B6BB741640,0xF9EA3DEA9BE65AA4,0xAA3E6811A11C78A5,0x155AD4E50AC6E65E,0x0000000000000062 },
    { 0x5936D4FEFEBBFAD7,0xC94F1262A30ED6C6,0x6013FAF4B2081A7D,0x684FFDBF85A4E883,0xAAFF243819DBDAD1,0x8F3484441F91E40F,0x145D06F61ECEA707,0xEB7A4980ECBADE82,0x000000000000004D }
  },
  { /* Point #2 */
    { 0x600C5B055BB88603,0x9E4B5B739BE3B3FB,0xD485D76B4844AB63,0xFFA20A3320CD3B55,0x6003AD11E40EC83B,0xEB5423B4EED37AC2,0xC25C87C09D4A0F44,0x2DE4BFE703C0E7D4,0x00000000000001EE },
    { 0xAA9EE44D14BC1043,0x9FC3875A24C86D4E,0x8F9BC8B6B7405EE2,0xAEDE13E5B46A336F,0xBF5DE69F6651C1F8,0xB8E7A34070DC1E30,0x437D3592F4D76655,0x2D2C90E1BEEE67B4,0x00000000000001C6 }
  },
  { /* Point #3 */
    { 0xEAA998A0008164D4,0x15D52DCD413F4FF0,0x3B180C19E4FF76A9,0x879FDC34C30ECBF4,0x7EC379CD518FD432,0x8A51BB32E6161641,0x92E85885D582E0E8,0x5503550AE00847A0,0x000000000000008F },
    { 0xDDF4C5CC039B003C,0x0C8D3F93C4814D97,0x213CA9B502075F02,0x347D87B988920F8E,0x96EF11C896DBF1B7,0xB092BA1CCF927DC6,0x6A12DCC7D068F694,0xE98DB68D16A6E447,0x00000000000000AE }
  },
  { /* Point #4 */
    { 0x46F9436C06C9837E,0xA4FEB9D508FEA5BB,0xC733EF31AA2FF650,0xA58F3FFE205E0F43,0x54D1150FBF567988,0x78C0AC9216052B8B,0xED2E587BA2F59A1B,0xF80D6E5C2D6B5969,0x0000000000000105 },
    { 0x5029C675207FF447,0xD8842988DEDC6A4C,0x5C3B90E4CF78D639,0xA008AE416E8E9794,0x098D2FE729023BD6,0xF4BC574A003E7A86,0xA7A024993D4FFA1E,0xD55641098D521BD5,0x00000000000001E8 }
  },
  { /* Point #5 */
    { 0x8B335FA8EB78796F,0x632A1E3598C921FE,0x8A81E3DC13EBB873,0x6EA0A1CA392AC9A2,0x12AC8F7D7A111FE3,0xE8019E481B74982F,0x970840AB372BD012,0xF08F46778030B6BA,0x0000000000000191 },
    { 0xF1DAFF85FF6CA70B,0x83A30831C4C98B48,0xB3D1402F4B44F090,0xEA42A852FFC5FC43,0x64FB5A0E5ADB2237,0xA3F97D5CEF91D510,0xAA8A0026F0D6D405,0xA9DB41BEFEDCD04A,0x0000000000000061 }
  },
  { /* Point #6 */
    { 0x56F46AEEA79FEC2F,0xAE7420E6CAA8072E,0xA8D82818E0909A51,0xB6FDE2A2D53B908D,0x2C291216AA4B288A,0x522C8BE8315BC370,0x27D342ED48CBE4C9,0xCC7E7D2282BDA6ED,0x0000000000000179 },
    { 0x28C243B826B789CB,0x0EE9307A736B8F95,0x6BB0026317C8D0AB,0xFB2563CB96C50F3F,0xDA495D9AFF006875,0x4FB2A94706B90869,0xF00CD1A64AEC98D5,0x0EFF72F28BD40482,0x0000000000000197 }
  },
  { /* Point #7 */
    { 0x4ADE586F26762E69,0xA4D590D75C5452E9,0x866D96D7A3D17B63,0x4820299B54373909,0x9C4970F071889F59,0xBE409EA4A47395C5,0xA1C14B17960A0EA2,0x4A33C8A0307327B7,0x0000000000000102 },
    { 0xE590FE7C2B54A6C6,0xB4A1AB5BC8F7ED0C,0x91F19A290051C927,0xD9F5D6078EAC2400,0x9BC268F6F0CF556B,0x823C77404112A75F,0x1A8168497D3647C4,0x46F70E49B3B45D09,0x0000000000000050 }
  },
  { /* Point #8 */
    { 0x768ED0F6F74FB22C,0xC967F6567E169C57,0xF6C74D22E59559C1,0x0A419045556961CD,0x97E83EF261C6F540,0x434D28D7F523B49B,0x0F83E17117AC09EA,0xFB02352B4A281F4E,0x0000000000000160 },
    { 0x78577044666031B0,0x2AA75F54D401794D,0xABF814BBDE68D202,0xC1D18B79FD8F841D,0xB68EDC5E8C8449BD,0x837B65B088A85D15,0x31A2C34E13249FA7,0x2E20348E54BE5F59,0x0000000000000148 }
  },
  { /* Point #9 */
    { 0xCD68F14947F5FEA0,0x0381DA7A66AE79B2,0x59C8132518C89E21,0xD443276DA0306A1A,0xEDF962A42ED6053C,0xE081D949174C3750,0x6B2FAB448F0944E2,0xC11DC57771951A0C,0x0000000000000152 },
    { 0x18241773802E1A49,0x4BE6EBDC0DE01FE1,0xEAADFD3C7A48FA49,0x5E5F4A479405C043,0xBF9FE38675485737,0xBABC982CBDDE6D0F,0x8029E0A95F412FF3,0x5BFCB1CE27F13FFC,0x0000000000000152 }
  },
  { /* Point #10 */
    { 0x13F80306DC0DC4D2,0x4234DEF649AE646A,0xCCC389F2E12A7B87,0x32AD2C32EE9D8B63,0xE68FBF40BCA28A35,0x1055C638784AA0EE,0xF7A0FAB4F25150EF,0x814948D232A30AEF,0x000000000000002C },
    { 0xB84B602C6D0A8A83,0x6FE1FFF52FF6E053,0x083D2DBD8B46EF6F,0x72187440B4BBE859,0x22D837CD1A0A7402,0x02B0A5064E8E4342,0x62F1D1D25C86C8C4,0x503027F5F6742CD4,0x000000000000018B }
  },
  { /* Point #11 */
    { 0x07E552EA093A81E5,0xD79A26CF5FA3B64A,0x45E0F42009AC81D0,0x599605EB4D1152A6,0xEEC960B5E2910F69,0x449C49ACBF61E7C0,0x867E18BB7227BC06,0xBFA6129C1E942370,0x00000000000001C5 },
    { 0xDA6A51D1748353E7,0x05E6051D4893015B,0x29ED0C626EAA8835,0xA684E89E7B8C9E0C,0xF35134FF20D8F515,0xE12C67CA130FE388,0x2454C35460EC122E,0x144C6B142C613A67,0x0000000000000021 }
  },
  { /* Point #12 */
    { 0x13DF75A0096188F7,0x8EBACA6836171FAC,0x2030B26E60019240,0x1AEA28B796B5CC00,0xA629E5F6790DE4A3,0x0F7C3C59159DD9EB,0x2D1B54EF141F4C46,0xF9EEFDD7F4923ABA,0x000000000000005E },
    { 0xF46DBB4E174E0148,0x7C1053DEDF8ACD48,0x013B931C52B0862F,0xF0F869462F785EC7,0x75AF2D79C4D53C34,0x21F2238CA3490F28,0x63C4AAC6D4DDF9C0,0xE68F5ECD731F119A,0x0000000000000102 }
  },
  { /* Point #13 */
    { 0x011D351AD93C77DA,0x9E2EA85427A91D1E,0x21C498659BD1EF48,0xA570D70CC171F355,0x489DF3AE74078260,0x8EA865C9F14C50F2,0x23A1A86BAA42C984,0x87D78B16B104B338,0x0000000000000173 },
    { 0x504AA27AD541016D,0x89E6092549B92139,0xF1A4EAB312423D00,0x76BD498675FC4690,0x3D2A8A56063682A1,0x9C8C7C949ED4E911,0x156190D5384795B9,0x0290F60CD7D0F84C,0x00000000000000AD }
  },
  { /* Point #14 */
    { 0x5B1BD3095681D846,0x7F19ED968ED287B5,0xC4D6EF2293976C5B,0xBAECB8926BE596E4,0xE97D08F3D6F46D5C,0x937468898A9F80CB,0x208C1197F497E040,0x84EF80AE23B50739,0x00000000000001C8 },
    { 0xAE7EDC60210A774B,0x6FC5319B827F43BE,0xEC97EE495BA3DF2E,0x6501C448638D314F,0x84546D7BFF343D65,0xE44F9BAE10ED5127,0x0E765B5E9066EC18,0x6BB0F6F169913C09,0x000000000000014A }
  },
  { /* Point #15 */
    { 0x192D2A436D526DD9,0x48573500B75B65E3,0xAD44CA58E861B88A,0x344950B55982D8F0,0xF0C11B7CAC661A50,0x0A42C0A1A1644BB1,0x706C5C88074386C5,0xE276190DAFE0EAE0,0x00000000000000C7 },
    { 0xA6C2EF02CE4F4EFB,0x9ACDB18A8A3BA394,0x1B4D47713DEA6660,0x4697D9CD6B192C6C,0x7F4B01830C33E87E,0x837DA7123AA2DB69,0xC1444E09E28A7681,0xBA5CB675B5C3D0E0,0x0000000000000100 }
  }
 },
 { /* Table #91 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x1D40359E91609A61,0x9ADF4E086890616D,0x89DD66358B14A62E,0xFAA34C0A49ADEB20,0x174689F7105A9BF0,0xBF727A3DA83A1154,0x4AFE90C10D6D5D50,0x9954D9D01F2FE4FF,0x0000000000000126 },
    { 0x027DF2555D2AC4B2,0xA61A555783078809,0x6F5D2CD40237C9BD,0x7CD9F911CEF7C441,0x0D5256EFABC19578,0xD86047AFF338DB58,0xAA2A1B5014D7C98E,0xBE9EDFFAF5E65A3A,0x00000000000001BD }
  },
  { /* Point #2 */
    { 0xFD4AC9A343D7F5D4,0xEFAF0979C99E0960,0x49F0CEE8309E568C,0x72B9D2770E83B629,0xC9462E6B6B2C1601,0x20FD87A59014EDF5,0xF153AE0A4589A246,0xDFC0C033D0AD9B0C,0x0000000000000034 },
    { 0xEA4CFB1187ABE460,0xDE9D0BF08E491E8B,0x8B4F7381E7B44C51,0x5B470FD4582FC6F2,0x351D31D09BD31114,0xAE86870521911E42,0x8C25EAD699C6CCEA,0x6372BB04F6408194,0x000000000000012D }
  },
  { /* Point #3 */
    { 0xF76D94EA2648A187,0x65CD1ED8841945B5,0xA8B8B52C6D3B41CC,0x729F4F50C03E31C3,0x2B315B9D4D930A40,0x32C503647C78DB5B,0x53B03B69E0CAB657,0x1CB16125D343324A,0x000000000000007A },
    { 0x0D0CC220CBBA148C,0x21E13A15066281E5,0x304904E6AE6BB049,0x9ED34CF1580464DA,0xB1C66D4684A6CDAE,0x6AD36012751E42A6,0xFEEED4DCC89EDBBE,0xD9897853A31A337D,0x0000000000000002 }
  },
  { /* Point #4 */
    { 0x9F89743C7DE96AD8,0xB36AF506B0E3C020,0x92BA9B369DA8C48E,0x3B06A6C914E3DDA7,0x4AD7DBD9D035A505,0xFD87C28A5825E565,0x1F117E6B5633716C,0xCEF5E5D6DCD99A7F,0x00000000000001E9 },
    { 0x839BA6957FED2CEC,0xBA25C337132C54CC,0xF032353E857C3815,0x9119F2E5B3B42940,0xCF21D2C0FECBF8F8,0x66B09AB9B5BAFB4F,0xDBE05A703946FF07,0xB83571FC2D9BA878,0x0000000000000018 }
  },
  { /* Point #5 */
    { 0xF62C03A397DE0E00,0xF48D1DE82611619D,0x15D1A317721BC870,0x6AC60D814ED06BF2,0xB8BC2CE0890CDBD6,0x7810822846F4B48F,0x04EF830C287C7697,0x32961E64A49838DA,0x00000000000000FE },
    { 0x97CD5E96D8551D19,0x68053374B2B1FD05,0xE3013CFCCCF9A8F2,0xCEFDD29F981FA6C1,0xEF3A4BA402683FFB,0x2E945F5855EDC412,0xA4A58E25BFD433F1,0x621EF049513F74F4,0x0000000000000120 }
  },
  { /* Point #6 */
    { 0x9E1FADFB16822E74,0x601A0218E2FDE79B,0xFAF91C0FCC11FB66,0x39B3D9CD38141AA4,0xAECEE4237B5E91A7,0xE78C36BAA418FF4A,0x97FFC63F7F084D25,0x8D9F7B524160AB02,0x0000000000000079 },
    { 0x4460A50327772A7B,0xCA164BAF7BB4B563,0x576F7498CF894432,0x62AF7B73B7C21EF1,0x6559CD67A1FF287D,0x366D49030189B834,0xCE4F2DD602496D3D,0x140A8383D27B4FFD,0x0000000000000125 }
  },
  { /* Point #7 */
    { 0x16A826340847C82E,0xB70042545F9A9912,0x798F9E628D0B4DFF,0x65342A6503C638D1,0x4F20EEBE5C54E53F,0xC14BBFC9F840E2CC,0xB7BDAEC4BF5122A8,0x36F7770447B6EE89,0x000000000000014C },
    { 0x1A055B39452878A4,0xEC912E63A4357006,0xFA8318C8FFC61CED,0x2B0D1441F05C5661,0x0B31A6B7F197AB70,0x69D91F5999BC8257,0x62CE77826B1FE057,0xCC37B64E8FBF4A9F,0x0000000000000160 }
  },
  { /* Point #8 */
    { 0x73C9CA8C32BF47DB,0x9914D5863827DF79,0x594400907E5D5D65,0x1FE4F4BDCC1F4322,0x8E14F73D38AD9FFE,0x4B47C892EEA079B5,0x753F974AC9BD577B,0x4231EF4EC3271DFC,0x00000000000000BB },
    { 0x871424AC14BCAEFD,0xB1B24D5C97355E9D,0xD38496396B934706,0xE90A821CA8C892F6,0x884DF6CC145AA180,0x0DC1730E4C7DCB49,0xDAD8A1EF67744185,0x444DE13BADD5CA97,0x0000000000000008 }
  },
  { /* Point #9 */
    { 0xFA51638C3342C8CF,0x0F68B9AF3860E485,0xEA4D914D06CD5F80,0xD5A9B6123D548A1A,0x19CF167328C71D7A,0xF88496F3E3EA941B,0xF7458D464CD8D096,0x40A7ECCDC3A72C66,0x000000000000009E },
    { 0x017E43B0F067B7EB,0x0E89BB59AE8610FE,0x0C2437F2B2BC6765,0x58C0A84449BF2EED,0x723B0A50C13A6053,0x3C2F581A1D1B46A0,0x2A930C3A68E9E875,0xF6144DD459874673,0x000000000000013C }
  },
  { /* Point #10 */
    { 0x501C908869C2C724,0x114CD1394D26E7E7,0x2C8E71896128092C,0xD379C77C98D95167,0xF4DC94F8C54FD3C2,0xCB5D6568D61F0A9D,0x57E935C0222D29C5,0x19707D68E5EBEAD7,0x000000000000018E },
    { 0x0CA3D650DF704C4B,0x3A11092F9E7FBD89,0x94ACCAF17B93A0DF,0x5E2EE6FC7A3CFA2D,0xFE64B185E29C1AB4,0x450622CC0DD624BC,0x19B6DACE885FE0EF,0xBCA6EE1159121790,0x0000000000000026 }
  },
  { /* Point #11 */
    { 0xC3561D8ABA77AE3D,0x9668544884E9A9FA,0xD02A219CFABB2BC7,0xF05419FF19500A0D,0xDDEC1E04FD9DB302,0xE8163EED27BB75E8,0x167A448CF55BEDAC,0x0674936FCF331BB5,0x0000000000000112 },
    { 0x6FDD6A8F05915D9E,0xD10ABA566BC230BC,0x3D08B2BE6495B1DE,0x1A677D3E25D490F3,0x5435CABFABBB4E9A,0xB1B88FE09DD066FA,0x4143D97F96AD240C,0x84D22C1A8105C161,0x00000000000000BB }
  },
  { /* Point #12 */
    { 0x50C7C1F5570B56DE,0xC4EC2D0E45E64231,0x30D743C79FC8812C,0xC156A390336A6837,0xED05F8E2AB56EC07,0x9F31CB93C6EA8F39,0xB4E6D426FE637C9E,0xA2940274A1068079,0x0000000000000131 },
    { 0xE90E065D0DE0A523,0x6A732029E7AA66E1,0x54D8E21335EFF2D8,0x316C567A8C25F616,0x4926A680D4D8B337,0x5AF43676371BABCC,0x3DE2803EEA35E392,0x1A31DC8D2569C1F0,0x000000000000015A }
  },
  { /* Point #13 */
    { 0xE37816DE9B725C0B,0xCC2A89C9166BB8FD,0x49CA0257D89FE85B,0x48FD498A9B83FCE1,0x6BA525640CF52C0E,0x1123FBDE28EF21FF,0x85F8991D4D0CDEBA,0xFE5797D8772B53B3,0x000000000000007B },
    { 0x3FDF5C44DD6B4D3F,0x5321B885E2DCD484,0x69CE5C11DFB203B2,0xE9A482386F8935BB,0x9FCD2C9C75CC99B6,0x251AC714E76DAEC2,0x772611564802F1C5,0xAF4E8D575D6E5D84,0x0000000000000170 }
  },
  { /* Point #14 */
    { 0x7FC39BB869546059,0x17A87451DC30034F,0x66BD74DADC7C93A3,0xF511104BF8E0B2A5,0xFFC0B9CECF5112F7,0x32DA477959194A90,0x37F686A5FC465013,0x4418DDC33C921BD0,0x0000000000000074 },
    { 0x60E891417CCA9624,0x924E88461D0C45A8,0x63575D9E03F81752,0x39FFB99931B565CF,0xD2F96BECA087029B,0xBF5C66A0DD1E6FD2,0x3A3BB584A7DA0587,0xEEAC3F724FC63A28,0x000000000000007C }
  },
  { /* Point #15 */
    { 0xC06EB52D95408D0A,0x617F37AAE6CD02BD,0x605C3D6C1493BE3C,0x74F50AEDF516ED28,0xE57889AF120F76FA,0xCAD1CD04A4BBDA56,0xFD346ECBFC158650,0xAEE419B5AE3C475A,0x00000000000001FA },
    { 0x53AB6494EBA5C579,0x89BAEAA366501244,0x76714C0A0E1DFCD7,0xC31B6AE005CE3982,0x38742418192BFB7E,0xB303FDC69FA107F8,0x50F6E46723401680,0xED7828E6032DB727,0x00000000000001EA }
  }
 },
 { /* Table #92 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x2A7E8AC175804DA9,0x0B41F6118D50BDC6,0xCFA0A757D8FAFB1C,0x75540D94D231A6B0,0x524440FB0C4FE03D,0xB8665FBFCE9738DD,0xBB74F6A88F1BD64F,0x063AFA3CBB8D6C67,0x0000000000000189 },
    { 0x259B9DA4A864385F,0xDBAFC55C17C2597B,0xDE890ACB56BF5D23,0xE51182C0F8455B59,0x75D51A03C456E1C7,0x9C7929C6B318E747,0xAF23A7F139B3ED84,0xEE136A2B910F4AB2,0x00000000000001AC }
  },
  { /* Point #2 */
    { 0x6E1B7D0B35E16743,0xCAD975B354D72C65,0x78F7434A453B8906,0x8D140CAE9690FA05,0x6C8E152A31FE6BFF,0x1721155E418E415A,0x73B115DC77693D9F,0x1274EA409BBECDF1,0x0000000000000134 },
    { 0x5953C5FEF3354B80,0x1E60A291BCDA146A,0x1E20C5C571EBE5D6,0x0BD949BFCE4DFD53,0xE489A64483280185,0x819082883743F2A4,0x6126ED3581EC227D,0xA4AAB2907FF6CFEF,0x000000000000012B }
  },
  { /* Point #3 */
    { 0x5D8C23C4EF873F3E,0x2A29D680CE7BAE33,0x5109E098BC00FC8E,0x9BF92EFC3CFAD961,0x272DFA3362036BCF,0x5ABB516CC2B13688,0xBFAD4CCCDDCB08AB,0x05945B934F260709,0x0000000000000043 },
    { 0x67FE093B08A5F87F,0x5F8E248A6C6FE1B1,0xF54F710BA3B887A2,0x12E1B68790F7E972,0x7002BD70429CD6C6,0x0F010D4AE896B58B,0x44FB054B1A7F5713,0xB9F3026865508714,0x0000000000000173 }
  },
  { /* Point #4 */
    { 0xD414309FA567339C,0x4EE5C7A8DFF5FBCA,0x33D8E6C3064CC887,0x15992EB4CA553CBD,0x3D733BB4459DA20D,0x98C2DE2EA682B305,0x68C13BED5602ED92,0x639B79F1C3BF7B46,0x00000000000000B5 },
    { 0x93DE5E06289407E1,0xA8F2B4E1B05A27BE,0x9D07927A9F5A6BE0,0x9A5D02E2F1B97F94,0x320DB20DF2DABBB9,0x991313330C14980B,0x44845E16F888E761,0x1BAEB18063A5538F,0x0000000000000196 }
  },
  { /* Point #5 */
    { 0xF41D38D49510D278,0xFA2C2B942C1AA285,0xDF7BB55CD512246E,0x980B046ACB15D14D,0x3FE4F4D4DBAF8AD4,0x6CBFCE0ED3D4F7AC,0x81FF0F46DEBBBC9C,0x2550BC946F1AADAB,0x00000000000000AC },
    { 0x2CC181037488849F,0x78DD9FB3C1DD8868,0xB433B8ED37790AF2,0xFF3689C4896219FB,0x0AAA321E0151C7D3,0x1F39B461CDE3D282,0x10B3783A5BE49EC6,0xB8B801D35462C805,0x000000000000013A }
  },
  { /* Point #6 */
    { 0x46EC5A842553A1AF,0xD41C63489B9F05BD,0x8FF28519B10D500C,0xFF4F8D03EBC991AB,0x57B6A954D997D9BC,0x9FACDD088588D18D,0x7FB43E8BD61A6BD6,0x62C8A561ACDD98C5,0x0000000000000047 },
    { 0x7CF6F1E152C911AA,0xF9270C1E8B0BDE06,0xEE6D0874999F3E7E,0x85530601A5F058AD,0xF1A1D2CA288B8E87,0x13FDCD5B2EE84682,0x031E745961AFA5FF,0xEED38B2D7D25B91E,0x000000000000010F }
  },
  { /* Point #7 */
    { 0x976B0EB751D8C679,0x5308C32CA55BEB39,0x43F46AE2B935189B,0xC29299EE18420B08,0xFE346CF494DC4570,0xC6207E3E53C6C99E,0x3E202EC25D708240,0xC790BEC75D608C48,0x0000000000000082 },
    { 0x6F30F944DB07B8AC,0x7B4F22136C090BC2,0xD03A60972D325DCA,0xD079042D3DAA7EC7,0x959BF843039AEFCB,0x956DA50C84ADD69C,0x2F47DAB7BA49D06D,0xA57F444F7F80AC00,0x00000000000000D4 }
  },
  { /* Point #8 */
    { 0x55417FFA525ABF32,0x1FF40E1678067DFC,0x431A0AE12795EA6A,0xC3DE691CEF54C597,0x60A0C51B95F9D2BB,0x30840CA982772F1A,0xDDAF460496EB0344,0x03A9F6F48615D783,0x0000000000000035 },
    { 0x74598CB233EDCFA4,0xBB866BC9DE9DCCDE,0x0C4831162A673BB2,0x3EDDD388FEE306A7,0x8785A002C80EB5B9,0xE2BD81F71937371F,0x501648595684A105,0xF0F3FDDE1F26E0DB,0x0000000000000119 }
  },
  { /* Point #9 */
    { 0x70476444ED9FF0CC,0x94A261004E61E48E,0x4FBCB840A4D28FDD,0x2631F2F2B68044D4,0x9241BA5277DCDCB5,0xAC209E88CBE53C16,0x40B7FE005B57FAC7,0x4F554E6E8AEDCD02,0x0000000000000053 },
    { 0xF188F96BACA8433E,0xCACE916CA6EAAF50,0x9386A1F76CAE425F,0x10BB0209E810FD9F,0x56471D16215BE739,0xDE76D87817E56C71,0xB2E819603FE6504F,0x713C17BE28C50C66,0x000000000000009D }
  },
  { /* Point #10 */
    { 0xF27A28DB74B5096C,0x03A2E654C127794A,0xAD5CCE80C39CBDFC,0x824DE4E0DFBD4AC0,0x138699BCC136358A,0x39EB335D907AFEFB,0x6F4A3849A4576223,0x6AE07264659F72FB,0x000000000000016A },
    { 0x43DE6FF7CC227C74,0x17A85B8DEEDA35E4,0x2794E72DFCEDA0D8,0xBD0C6D2E67DE04C1,0x7F8F8D030CFBDEFF,0xF09EDE8BBEC8C86A,0x4DF64C67FC91A432,0xDDD5B6A9CFB65373,0x00000000000001BD }
  },
  { /* Point #11 */
    { 0xB34C3B27FE8DF000,0xDF3396739CDC5700,0x1BB29F7111CB9AD2,0x3F6A26AB7BA7D395,0x4265DD167849C272,0xAD75E46F80036C34,0x7B68CB30AACD57DF,0xF9F95028F34031CA,0x0000000000000157 },
    { 0x2483A208A535BA39,0xD2A8C67F390CD035,0x6FD004776C091584,0xD75FEB1A5207BC4F,0xEA0293A22D916544,0x7C8EEFFA88105D3E,0x292666A99981E998,0xD32C0EAC15E4E8F1,0x000000000000012A }
  },
  { /* Point #12 */
    { 0x1D1DFB3CBCEF559C,0x66B7A8E92032F3B8,0xC762AB1A4B5D0F0E,0x84FBDE61629D66EC,0x9D3C8F3EF596C684,0x193DC11EF0FE06A0,0x5FDA3B3F65B1DB6D,0x404D1C2D15CD0E7F,0x00000000000001E6 },
    { 0x35ADFE360BEA4D09,0xD52D6D42F1F1506C,0x4A7E9015F40ECB74,0xA407C3DC05681DE3,0x15125250140A5C8A,0x2AD05B98237C5350,0xDBC6069023D706D0,0xDFF77B5CEE8D89AF,0x0000000000000120 }
  },
  { /* Point #13 */
    { 0x6D2F3E9ADD64B652,0xC753F944733C58C0,0x6C41946E11BF60FC,0xC0280FE51C36AEDE,0x2AD93FFE0564AA24,0x8FC163264FAAC555,0x1A6AD7E4EB7CF510,0x539C83831A12FF2D,0x00000000000001E4 },
    { 0x02A35B2FA63BFEFE,0x7062D0C039BA1701,0x6C34460DA6C0634D,0x060A3A79B8A1284E,0x051C13345FAFB702,0x65EB00A34827D95A,0xD6F1D69EDC2FAA66,0xD3BD821798D5F264,0x00000000000000DA }
  },
  { /* Point #14 */
    { 0x528930785153CFAB,0x298A7D4836C0BAA8,0xE787516DA7A45E3C,0x007B46E6F181F0FF,0x5CBDCF5EB377B064,0x65A468E004612D85,0x3668C7E46C37728C,0x84737F5BFBBD1ABB,0x000000000000000D },
    { 0x7583CB9E5B38488E,0xAF35F8A095D7FBA2,0x2FC11201EC2A9440,0xD8DF657EC50699FA,0x5264C8B5EC221D64,0xA3B21D747B5134B9,0x2A64E59A7CC4BA1E,0x856B2E317BB602DA,0x000000000000019C }
  },
  { /* Point #15 */
    { 0x4F0B54E933F75B15,0xA003B96336FA5B5A,0x13636B7434EF804E,0xF487359433A8DE33,0x6FCB70B968BF741C,0xF257C3034011AD6A,0xD8103CF128C9CFC3,0x40C10CF4F3C1C78A,0x000000000000002A },
    { 0xE595EAA875E483C8,0x6F1F33B145230209,0xCDE65C1E09E07A8F,0xD1DD3121EE74A952,0xF7F7CE1652243E2E,0xFD9412A975F7F1E8,0x418F8C8621AA60B0,0x39BA7C05F2A7648B,0x00000000000000AF }
  }
 },
 { /* Table #93 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xA8C68B9D76BCD267,0x95F78CA896362C64,0xBB8302F303603F09,0xF15B0D54272622B9,0x4CEBFCD197692826,0x4D29D2B119C758FC,0x4703BB56E11AC4FE,0x7152ABD536B53BDB,0x0000000000000060 },
    { 0x68AC983427BEDE63,0xD5C6C405E54A999B,0x3D763E32231E8EB0,0xE36CA2FF47C7EDB7,0xD9F185058D2B6016,0x4E576EB060D55105,0xE3E9F24976E3F591,0xD5BF8F0083EA6A2C,0x0000000000000157 }
  },
  { /* Point #2 */
    { 0x43164D3A02079397,0x2A3FD379490D948F,0x79AD8714635E0C5A,0x5BA9289871B5CF85,0x1BABC5A1956BEAD4,0x5408A355FF6D701D,0xD924D7A369570FE3,0x60D41A46831755AF,0x000000000000000C },
    { 0x7CCFE1A4EC2F26C2,0x549A32BE85EBC29B,0xE183FF35D46E8B7B,0x0E8DFC66D421604E,0x1AB4332CB30DDEE6,0xAD4B6B316C35CEA0,0x1D9C4DF7856F9258,0x65882C90850F81E4,0x0000000000000052 }
  },
  { /* Point #3 */
    { 0x14B97DA09278F093,0x77B62EB2AAF50774,0xC94C47E5595788EB,0x3F6FBF17E78A7ACB,0x8BEAED91D648CDAE,0x1402478DB0281EEA,0x06F48D3E057A9CC4,0x9A75CB7B56F972CF,0x000000000000001F },
    { 0x74749B84A7049117,0xEE6187DF275EFA96,0xC8A4DD7FA7DAEFB7,0xC2A5680FF26B4DEE,0xE64AE23802C8ED96,0x55D8E7BDC75AB457,0xC29F93F613DAAD11,0x7E485B3F10EF96B4,0x000000000000001C }
  },
  { /* Point #4 */
    { 0x27CDF0121F91A935,0xA3A2D0AB9B1DA866,0x62BC6AD520C6250C,0xE637B6B235233AAA,0x3921E6A2E5109B06,0xA24B99C558D73641,0x33073B25D3BD99F7,0x60FAD5FEC0498CFA,0x000000000000014A },
    { 0xB187185263080BDA,0x8270739112D3FCF0,0x770B113C7B3CD673,0x2CF6E741CA843432,0x77C74D8DD75AF1C0,0x979E1FD4A0C24279,0xBF05A641F335EF51,0xD7EC205D26B269B7,0x00000000000001E0 }
  },
  { /* Point #5 */
    { 0x12DF8924CDF52775,0xD89749666E3BC06F,0x7F3310CE3E68CF93,0x0A012C7F97117FE2,0x65288F5BA16ADBB8,0xB1E26BB892BC7054,0xA6833AC98A63D1C7,0x5F3B945A5DE7F156,0x0000000000000176 },
    { 0xEB8958990DD3A366,0xEF27B635958AA6F3,0x8EF1DF5F1DABEC19,0x871FEC8B0F53BDD9,0xFBB413BE9EFE0C6A,0x06E372B6AA16ADD4,0xDD08C66FA945E423,0x66C1B806F3B12FEB,0x0000000000000166 }
  },
  { /* Point #6 */
    { 0xA200E9EEFC3DE00D,0xE02A24D1D3A22751,0xC793C92EAD1898F2,0x46AB743BB70F915E,0x274FED3CD9A716C3,0x292A43535C0D17A2,0xE7619F937874C664,0xF21DBAB53E3C8169,0x000000000000019C },
    { 0x6D19C5DE10F6E0D1,0xC8D263FFDDFFA70C,0xAC7886E640A77AEF,0x22BD9CF6D4A9191F,0xC53A3301624532D3,0x8EDFA100FA74A13E,0x15F04D3357701DD1,0xD5CFD2ED793D4DA4,0x0000000000000170 }
  },
  { /* Point #7 */
    { 0x627F65FD51ED20EC,0x1C31D4A36DEC3A4E,0x8F222EC0EA76B32C,0x890E15C3BD5A76A5,0x236174697A3E2D67,0xBED29D6DD8178F45,0xD61F7707C90E2DF7,0x31C286DD91BE7739,0x000000000000008F },
    { 0x7EA9AE7CE3D9F5A5,0xCC26143E9DDA23C5,0xC231022EFD1EF741,0x66E91F63DC1FA1DC,0xE831781E364D03E9,0xF2247B2B629AF703,0x08F7EB82AE2B773B,0x7C543051A0A208B0,0x00000000000001D3 }
  },
  { /* Point #8 */
    { 0x55A64B0A30239552,0x447C6E084BFAB408,0x43CB43277063035C,0x68AFE121D293B9EE,0xA975707BED50A41C,0x15A6A8BE4488F96C,0xDBB6A3D81BF798E4,0x0DE2F103B5E600C9,0x00000000000001F0 },
    { 0xC070DAB445BB5352,0xD590D895AFDAC74C,0x679FD21D37BFADE9,0xE8DC87E7A0AEDD41,0x9E48F870B31DBD72,0x21AFACD8C7EA78B4,0x8AC51F26FBCF9D22,0xB52293AFDE2B01DB,0x00000000000001F8 }
  },
  { /* Point #9 */
    { 0x7F428DAC77331596,0xBF977F5FC255949F,0x3DA177D5C4D98BE0,0x7CB4B3B7A8527C4B,0x040683908032CA6B,0xFAB16224BB04C171,0x6660197A9C5610CB,0x8FE2AD3091C7C2FC,0x000000000000018F },
    { 0xC8DF54981BC9C007,0x9901A26B6AEEB5EC,0x0C6CD18F85B8D02B,0xCDDD3B72972A7EA2,0x603843318C6FEC2C,0xD4200454211F8358,0xC7F5670EE44CCACB,0x9FCB7D2D97A7417D,0x00000000000000BD }
  },
  { /* Point #10 */
    { 0x00C31D64181F278B,0x582351A85E31F839,0x825B8006A74EDFAB,0x3D9BCB438E3019C0,0xA05CC896415F4421,0xFA32C6F82E7C6507,0xBBABCD82D133935F,0xAE65B063CA469A57,0x00000000000001B7 },
    { 0x6C872DE99BA01391,0x2905A70571855CCF,0x9CD262192D4210D1,0x9DE7F89B7AA6AF53,0x8B4CF2B2BE39C3F0,0xC563FC954E4D215B,0x957FA0BCE34C2924,0xFA619E7A4AF69B61,0x000000000000013D }
  },
  { /* Point #11 */
    { 0xE86339BAFD804EF7,0x0167369276BBF53F,0x41236F2E3918EC65,0x1043B6B3C14159D2,0x732BCB46AB04BB98,0x88D1CB4C30D86216,0x3DCA271B85DDD190,0x927FBA7B58E758CA,0x0000000000000182 },
    { 0xCA047C60F46E0E28,0x915C93FC92B64674,0x8FD233C6794D425D,0x028132B544A3EC1F,0x975C8AA816509EFC,0x041EF627622584E8,0x1989A692938C99DF,0x7704D7C7BFBBC611,0x0000000000000192 }
  },
  { /* Point #12 */
    { 0x8013EB783899C832,0x463A9C46E6BA78BA,0x6D3A471AC9682AC6,0x599A9FB58DBD293E,0xFABFD28A1897913B,0x1DE9FE55B9A23B31,0xDD90ED9AD55D93C7,0x07581309290A5EAB,0x000000000000000E },
    { 0x54443BB9978F36B2,0xC2C254C99F6C65C6,0xAF9B5009F7B984BB,0xC5416EEC0B97FFD9,0x1107F9BB5EBB7853,0x0FF4C94C9D487FFC,0x7B4F0985507BA23B,0x0ACCF6DD5EB91F71,0x0000000000000044 }
  },
  { /* Point #13 */
    { 0x1A07BB1C0AC926C8,0xDBDAD1E77CDE114D,0xD677815BC1F3A574,0x5758E60628DFF5E7,0x95C76291A7501407,0x5CD2407FDCB4D1F6,0xEB6D28C4B9472593,0x0092A86B0B6FD187,0x00000000000000FB },
    { 0x961F53CB791DEC5C,0x77E3A3129A8CD9D7,0xCFC28C0775F8FC57,0x748AB16F531E8336,0x100E37FE05192627,0x9477FB71D0292D0C,0x924C1E0546A38BA8,0x2018A9DA4543F219,0x00000000000000C8 }
  },
  { /* Point #14 */
    { 0xDCA43EF744AD140D,0x18C95116F62A3BEE,0x766D5E214E144F65,0x1087AB025D99574C,0x3BAE4DDC4954DA34,0x673D2CAC0DDB3E23,0xFC2F18FF40CD4D2B,0xB67BBDBF2E578CDC,0x0000000000000142 },
    { 0xA3352AAC08191BE9,0x24523F454FCF86EA,0xCA79A37A6EB6B7EB,0x24B8DB952CE7F66A,0xB8BA67584E8F293E,0xF38B987A8BDE44AA,0x0F3F142659CBCB5D,0x647440675A6BC1FD,0x000000000000001A }
  },
  { /* Point #15 */
    { 0xD9D203C4598D6047,0xE1356B6104351A31,0x8657A9C458B1E12F,0xCC26F6378ED5AAF3,0x7272B2E03B6C0450,0x2AC17670212AAA79,0x354B375423E6ACBD,0x22B9DEAE2A4F7ADF,0x000000000000005E },
    { 0x20421426B405D02B,0x62F72A9F20ED4116,0xB93C24E0308D525D,0x5489564EDBC245EC,0xA904AB8F3B6D7C99,0xE4C11C4D99F5D096,0x1685220588930DAE,0xC2569FE5FAEF9B94,0x0000000000000079 }
  }
 },
 { /* Table #94 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x0079A845A2FDA60F,0x6DFDF102DA8DB63A,0x7D2759600148A559,0xE089C346684B9737,0x09F865B2820BDB1C,0x000DAEF6891AE57E,0x384F5EEEA4F64F15,0xDD68E4903DA7E79C,0x000000000000013A },
    { 0x20B7457D514AC5DB,0xA03028FB954721FD,0x6F20D5185C77CB17,0x28F92697AD74495A,0x630E01566B327DC8,0x6C5067D665832CA9,0x9C9305FBD3F6DB89,0x681013FA905FFFDF,0x0000000000000188 }
  },
  { /* Point #2 */
    { 0x9D590CA72A708597,0x5EA564A217C45D92,0xA7098CA409F8D031,0x231C716117A9A6D9,0x5919A777951ECC81,0x9FB5DF367AB0CD85,0x7F4D2D7A2B6B445C,0x73A2764668251F9D,0x0000000000000037 },
    { 0x7BC56153E9E14113,0x4747084F030AF56B,0x865ABBE91EFA69EC,0xAF6534B5DA5D565F,0x40549F0BB0001866,0xC451348F812351AF,0xE7323AE9190EB107,0xFB3FD76FBFC098F1,0x000000000000001A }
  },
  { /* Point #3 */
    { 0x7A10BE40318448E6,0xA09AB497CE412830,0xE31C434370D88770,0xA52FBA9FE8D30D6D,0x121E6D15228558D5,0xD2435C13FD0D7D5E,0x600DD27918AA5676,0xA6F5C318E5179D2A,0x00000000000001A4 },
    { 0xE822AF012AD8D75E,0x30E19389858BEFF4,0xF9F942FD83D74ABD,0xC92199821696C1EA,0xD3153B60C3198D4D,0xEA6C2263FCBE0073,0x85754D632E1B79E1,0xB1B80018C26E0148,0x00000000000001CA }
  },
  { /* Point #4 */
    { 0x7EF1F62CCF0F33CA,0x225317B7184DE5D6,0xBA7645C1260FC821,0x522C34F2D057844C,0x53282114C4A6DFF0,0x6D3D84005F6DBDBD,0x165E4194F3FB787A,0x210A607AC8C575EB,0x00000000000000FB },
    { 0x68C834C2832C8DEE,0xCC4FF8611602F932,0xDCFA537D456ED4BB,0x68F201750C079647,0x972D770B8F28ECD5,0xAA8FDBE82D099800,0x06285716ECADDB29,0x67FA9A61D5DC6040,0x000000000000015B }
  },
  { /* Point #5 */
    { 0x128BC3C68DF57790,0x43C56BC0EC53BC56,0x7910B88BCAE49EED,0x3EA6A0DF18A0D687,0xB28B1D89448F5D7A,0x3F03FDD189351D2E,0x139D03DF2C3E495B,0x7C088A9A6F18F00F,0x0000000000000173 },
    { 0x719FC61A241D777B,0x1F0CE6534539225E,0xEA96D5527A4FCA8E,0x37858C68F9CFEF0B,0x052382D038DD070D,0xF14D02BF12A26448,0xCAE30526A98265AE,0xE9694DB22B32266A,0x00000000000000B0 }
  },
  { /* Point #6 */
    { 0xF3FBCFF199548073,0x118F9094ACBD6713,0x1C416C448288B675,0x5B1B6008F3636371,0xFC6D212CD2B9B9C4,0x4D4CDA914E026405,0xD0D1C15FC6E27757,0x9C68F492B3536CB7,0x00000000000001E3 },
    { 0x4C27FC7C71718D8A,0x565B59DC2DA77A01,0xA1BBCEBEA34E7517,0x433ABABAB3163BD9,0xDA5EBB985DB1C3F3,0x06C8AF6CD8ED0CE9,0x29B3FA8AE2F6F034,0xC6298DD75C79ABD6,0x0000000000000061 }
  },
  { /* Point #7 */
    { 0x8D1A5A77DE58C7C3,0xD0A69124442B5CAF,0x941A596A8EC7DC07,0xFA46408703F666F4,0x517C887B2E2444E8,0x23336FB2CC4FED90,0x42E16757F6D6BEDA,0x31028CFC0334867A,0x0000000000000069 },
    { 0x23AF471928D45D76,0x32FBDF653F620742,0x049C2152C8FA6CEB,0x3ADA0B48BFBDFB05,0xB8A01F53729E6FE5,0xC0204462FC1183C6,0x5F9A9454DDB24298,0xCD9A5C6EDA7DC145,0x0000000000000074 }
  },
  { /* Point #8 */
    { 0xE12B714E622ED5C2,0xB1E036A7CB699185,0x3920A7371AB44645,0x9844C8D9F5A325E1,0xA91BEA02C02DE758,0xAAE624A018ADE985,0x3A700E40CC31937D,0x47C0B398BFDEA449,0x00000000000000CA },
    { 0x04213750A9E1B74E,0xA1D25057B3F7FF5B,0xF8C7FDCC259DC673,0xA837E675953CA2B9,0xE23E1E1FABF04630,0xAFE1F1B99889EA3B,0x40988791C4DB25CB,0xEC8592E4F18669B8,0x000000000000014A }
  },
  { /* Point #9 */
    { 0x93C72785CE65E46C,0xCC34BAAED036A395,0xE51D3BCC1FA7FB90,0xDD62CC37E6A685E0,0x440C287D9D6273D6,0x70CBB68F732E5788,0x1E711346B896A191,0xA2E89DFD81E94D1C,0x00000000000000F1 },
    { 0x6F5DCDF46CCCEF65,0x66935F9041CC5953,0xEC2D929D9CF67B27,0xCF8A5AE39D95D373,0x172B09FDDA0668D9,0x4C0F3FD45DB6710B,0x1020ACA40FD20F5A,0x2A126D105E0A0725,0x00000000000001C5 }
  },
  { /* Point #10 */
    { 0x80D7A535BD9F379A,0xBE8E0A99C370457A,0x463412100DF567B9,0x4AC01116535AFDC2,0xE64467346C4A1377,0x305382A2EBAABD8B,0x7E7D8AAEF446BF49,0x6FC59233F6537813,0x000000000000011E },
    { 0xA6BF62F6C86D8997,0xEDE03223FA0D68C3,0x55F36FC479F46A65,0x28E28900BA1A2F64,0x111258193610CC91,0x44AB3B8FEC581787,0x68DAC2F0D529CB21,0x68EF76CDB47A2C68,0x000000000000015C }
  },
  { /* Point #11 */
    { 0x6021EB67F323796B,0x2735E2E72AE978FB,0xAB0ACCEA243C976C,0x37140DD66DF235CE,0x285302153BE80263,0x8DC91DBDB485401B,0x998C84F80E48B4EF,0x3AF687863CF2FA95,0x00000000000001FA },
    { 0x58A0EED23B99884B,0xE044C6434B2F6436,0x593D85348BFBB9EF,0x3390291AB614C597,0xD45F59905E2DB165,0x34A30DE03225C405,0x398E3201B7154958,0x2A9E761996521007,0x00000000000001A2 }
  },
  { /* Point #12 */
    { 0x1FCF2222C7504DE2,0x7A048586B37C96D2,0x75A974FF2600255F,0xFD8EFFBEEA7922B7,0x871C04531C3AEB4A,0xE9445F23F167A3EA,0xE8B8F95431D66E47,0x3BA0FB51B46BC080,0x00000000000001DB },
    { 0xFA565B995EC9920D,0xFEEE4E89A25EC3E5,0x8428E8EA5FE155D8,0x31B55DB4CAADB703,0x1C66ACE9FAB8F8F9,0x9190E7BF0F688545,0x36695F2F7AD75316,0x6674F106C6D6A5C6,0x000000000000016B }
  },
  { /* Point #13 */
    { 0xC7164E8FF304C1BC,0x62D3811697440445,0x594D284F309BF2EC,0x39E8CEBCA1A3F419,0xC19A54512311A0A4,0x4B6A4C60A3E3FD96,0xA3F92664A28B1F78,0x559049A1A19E6A85,0x00000000000000D7 },
    { 0xA97411AE2CDBE432,0xBBA9055C1F727B22,0xF881F7887F0DA2DB,0xDBABEDA7D88AAEF9,0x3123E4A8340D85A3,0x415251C4B30E7BC7,0xB62437CB9CB7D2C7,0x6394C0E2A8F314B9,0x00000000000000EC }
  },
  { /* Point #14 */
    { 0xF95537492D9C5C3B,0x767D589969F5425D,0x0A7AB01CFDC194A7,0x1C28B605B097C6A7,0xCD61DA6552E4DA4A,0xEBE34A012484AF8E,0x133CBE0C62052CF7,0x92BA3F9580885457,0x000000000000005E },
    { 0xBCC2CC87C3F83D1E,0x961840F8ABC3E519,0xABBCB1B301574E1E,0xE440673C1FF2D74C,0xA6099DD313480C1D,0x13B72F881C3A4626,0xF32A02C881ABD235,0x99864D6852D51364,0x0000000000000002 }
  },
  { /* Point #15 */
    { 0xDE37A92E6B34F3DD,0x951E43F2E31DFA1C,0x5858153252E2EF0D,0x620012A07FEB1898,0x5A17627D67F4CC4F,0x2132318F07D8033A,0xF04939350B5EC702,0xD9F309ACF8BAA44F,0x00000000000001A7 },
    { 0x45585A808526C18F,0xE9AF212722628089,0x075752D8F40B3255,0x02C07AB8AC0F8F9E,0x72ED381F29D778F5,0xE2C67B7B3B1A48A8,0x983E3CA1C0CC19BB,0x038048AE7415AF20,0x0000000000000050 }
  }
 },
 { /* Table #95 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x18CAFF50EFBF6B21,0x0EEB65EC51F2BA1D,0x2CD8A43F296C458B,0x04D795B29747CEAB,0x52B0BCA6DC306C57,0x39FE8AD517EC9C28,0xA4A9E3FB81A0CB57,0xDD6933A9A638D6F5,0x000000000000017D },
    { 0x9893EB50D39AC021,0x3BF7087339BD296B,0xA10440A7792DEC05,0x96BE97E7A67AD18F,0xCF2175AE17AE5F6D,0x70FBB8BF0B6F0503,0xBB565FADF7A755AD,0x8904F9A093CCFD37,0x00000000000000F8 }
  },
  { /* Point #2 */
    { 0xC7C5D4242B72359F,0x9AEDFA4ED89718F9,0x74773E4F858B335C,0xCCCF6730B5020D9E,0x7F2B567BAAA8BEE0,0x929B3D35D1D4C7CB,0xBF1C55591D6602B4,0x58FD96154782966D,0x00000000000001C2 },
    { 0xF87AA9D87095C048,0x145AF97F67C5DC33,0x1541A34B5808379C,0xD5BE204572F16AFC,0x008A4AA0A10E4D9E,0xF75936EFADB03C27,0xCDA58468A6D93005,0x1817E5BAD0CFA2CC,0x0000000000000078 }
  },
  { /* Point #3 */
    { 0xF669C4582CFF741F,0x558296D0CB12D0F3,0x4CA064D770BE227A,0x02B8D5CACF89F9F2,0xB4E066608F1E5A13,0xA030D85A9C08B765,0xDFEB77D6922E04E8,0x65930C729603967A,0x000000000000015D },
    { 0x70CDEAFF4FF2E952,0xBAA81BA88B6332A9,0xE573D5B4798836FD,0x5B68B878605C5ECC,0x3F0A6ABD47BC37EB,0x823A54E1DFA7F440,0x2FC0AA7A5C500937,0xB97B588C35953C9B,0x00000000000001AB }
  },
  { /* Point #4 */
    { 0xD89DE8041BA719B6,0x9A84D6145B7139E2,0xC2F91C87D16E4F4B,0x7ADCB047BB8175EA,0x4C301C4B3C2FE568,0xEC7DEA0CE6E82790,0xCC2C78869CE824AB,0xAA0F82DC64E12C47,0x000000000000016A },
    { 0x3C6DCA8EA0B4332D,0xB161C4E9D82DC4DC,0xFDA8729063029487,0xACE5D0B634209806,0xB8C940B78968AC6E,0xB61329E9D0C0973F,0xBCB0A143B1AA99B6,0x96B831932211AE06,0x0000000000000057 }
  },
  { /* Point #5 */
    { 0x39A64D5D2FD93AD6,0x667FF12D2637E7F1,0xED31162E5151441B,0x9ABDF9168277E2BB,0x1B7630F0EC0A5F93,0x89A828CC5B002930,0x912428ADB246BEFA,0x632B0787765DBFE1,0x000000000000018D },
    { 0xEBF44BA86693BAFA,0x3AD447318A12BB84,0xC0E12ABB5D02D2FD,0xCCDCBC009AC44290,0xFCC3F910EA70A61B,0xCAED56197DBBD680,0xECA08D0B2D159763,0x4F51A9AF6D9DC6DB,0x0000000000000095 }
  },
  { /* Point #6 */
    { 0x6372245924FF803A,0x4C6743967C6401E9,0x322820A88EFB71AD,0x49A9BB7E18386499,0x809F13B4011BE153,0x21EA3BED1CAA0E61,0x062A8EB9CB8A3C34,0xDAD37CA0D371B482,0x000000000000004D },
    { 0x517E7E99425737BD,0xF0D5129C74652EA7,0x46E5F98B493390DD,0x889C952FACCD9071,0xC01D4483732246DD,0x6E3982CA191B7F2A,0xEF390898EC4FFA9D,0xAC0C56044DCF0CA9,0x000000000000011D }
  },
  { /* Point #7 */
    { 0xF0B9EDE34DD2D2D3,0xB06079398C4D1CEE,0x1CA4EC570611DF8F,0x7F32D19753B914D6,0x99B6F882DFA4DF49,0xFBE161CFB265F518,0xC6DB288E40C76BBC,0xC8970E3F281437B1,0x0000000000000139 },
    { 0x9D76D4A51A18DB0A,0x59E76809238445C6,0xA0F52E646A48DEAE,0x3692A8A8338904D4,0x3FE48D48BA28D02A,0x9F2130AAB958B23D,0x210A547ECF8CD8E9,0x46E7623E5179029A,0x00000000000000BC }
  },
  { /* Point #8 */
    { 0xBE58970D503CFE9A,0x72000A862DD620A9,0x5825B2836D0EF833,0xB88D53B7C706F2C7,0x5F7DF7CD0501F0F7,0xF1FD2E3B2FA3B809,0xF3AFD9FB557798C9,0x9254426AB970A87D,0x0000000000000135 },
    { 0x577560BEE8947E84,0xC60B998CB0F49A8C,0x81D18BEF9829431B,0xEAA5FA385F48ADA5,0xBA2CB72612DB61AF,0xFA9DE7DDF3D26BBE,0x97876D0626881C14,0xAEC866638C84185D,0x000000000000015B }
  },
  { /* Point #9 */
    { 0xC988F588852CD09D,0x67D21418AF218601,0xDA5F50EC0C10A857,0x504418A30E2B2960,0x9F44EA6BF4038971,0x6B5D406A2E458D2D,0xFC240795801E5FA5,0x0356185CF7584734,0x0000000000000102 },
    { 0x7A948FD177A57D4F,0x5DE3AFBA2FBB8782,0x1AE44706BCFFC674,0xB97083B5563F5C74,0xA91850575466EBD5,0xF9C3A26CEA623A4B,0xC917551994105039,0xA570C1C1819C3CDA,0x0000000000000075 }
  },
  { /* Point #10 */
    { 0x297E708E61FBDC72,0xF59C64FB4DCB9E90,0x4A61F848814F38E2,0x081DABDCED48623F,0x7CA592C953B0CFE1,0x1462CE03C049D136,0xB5642B78B47BD071,0x99E3ADBB87D24F68,0x00000000000001DC },
    { 0x643879618E44F3B7,0xC1910E8C3AA42510,0x45DE7844B07ADFC5,0xDB7910A633804208,0x77D0EC7574BE91E4,0x3E015CFCE842CAC5,0x11C32FA6554FEC82,0x7C43FC38829DC4CC,0x0000000000000062 }
  },
  { /* Point #11 */
    { 0x3C3814B8A3ACDB65,0x42CEA8683AC121C9,0x95CCDCA1554EDBD9,0xC8127847BADD4E7A,0x8249A372C95FE784,0x1E5998D520661224,0xF88A1A0815019264,0x501BA0A9619DE345,0x00000000000000BB },
    { 0x27BCE70EDABD6ECC,0xBDBF47AD41144962,0x949D92FD302C2F1F,0x7EE6077EDAC7D399,0x4B1CA3AB70CBD239,0xBE03CF169C08640C,0x67D91DDAE90BB15C,0x989110BF3584FE3F,0x0000000000000033 }
  },
  { /* Point #12 */
    { 0x77D57155881B7B9A,0x41639A4746101B26,0x06EDC878203C9899,0xE4AC1D9648D8EC5A,0x7CEC08752DB1051D,0xAF9FACF257C860A9,0x94AD13CCFA3DD49D,0x853273184E345924,0x00000000000000E9 },
    { 0x9956AD2C84311EC6,0x3D494579BFB208A2,0xAA60BB0ED8CCD0A5,0x6D3D4DF518418197,0x56386035884B2CB1,0x7A104900464EEBEC,0x0785D58B72EBADDC,0xF5AD930908356589,0x0000000000000191 }
  },
  { /* Point #13 */
    { 0xA58E52D8F7A4D317,0xAF23BF92DC6F7AEC,0x70121C821C520880,0xF68499F37BC182B5,0x0EDC4E6FB02B3E34,0x4378BADCE425564D,0x3B74B05FE75EB0BC,0x5A234BAE599D4D45,0x000000000000011B },
    { 0x3094E3C091572EFB,0xC370662F6F509233,0xC741EF37BEB6AF1E,0x5E1D62655BF3BBD6,0x39044BC61029591D,0x05FF006B7C1724F3,0xDE62A8FCA492BB41,0x9682C9EBD3F4A832,0x0000000000000159 }
  },
  { /* Point #14 */
    { 0xB32047F1686B8E76,0xC292C8960FEAD8FE,0xF552FE3F3D1BAB8C,0xDAA248AF483F96F7,0x2ADA20D3B898320A,0xC0E0325CE0EE1E67,0x4769DC2E72F55358,0x33CB916BBF19057B,0x00000000000000FF },
    { 0xC1673B3E8A2A8023,0x39484339B3D830BB,0x91F2B0F7FEE1A7E1,0x0E2DA8D5EEAC1C7F,0xAA77624C0292B469,0x0A57D873D551849D,0x6C78F50F595C052E,0x33BE2FC03744D368,0x0000000000000000 }
  },
  { /* Point #15 */
    { 0xBC3F4C479D702E02,0x6A06F96D86C216D1,0x9469CEF28C2DC6F3,0x753D64D2C98D9271,0x7C7EC13B051508C9,0x7B94098D95FD48E2,0x724358006BB4F8D3,0x01D3F3D188EEE18A,0x0000000000000039 },
    { 0x764BAACF1A6A057D,0x7D880282F7326213,0x37C2394043D2615B,0x7E09836A6EEF57DE,0x3F7E265CD790BBF6,0x10025E4549A4F757,0x515D51BBDCB5B373,0x05699BE5F534F5FB,0x000000000000005E }
  }
 },
 { /* Table #96 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x442EBF300BCF3B88,0x4B863857DC5BFD2B,0x632A1056C50960C2,0xDBF49444C9D74020,0x335F464B78287D19,0x0CF8D5C75C490A63,0x4F9D9BD7D7D2D2C6,0x1490FB61AD52D8A9,0x00000000000000EB },
    { 0x42AABE7434A088DB,0x871248C89E5B69EE,0x7D624D6E55A87EDB,0x81BC0BCFBAEE4473,0xF450C5AD9559A1B0,0xA604379CDF4C738C,0x36B304E210EC0574,0x948A50D38D8CF3D9,0x000000000000018E }
  },
  { /* Point #2 */
    { 0xC6ECF2F55565EB6E,0x05E894602B260A3D,0x459E260432C54616,0xFBF40AAB47DD43AC,0x54D5949F9AD0B934,0x992295A5CEA0EEF4,0x8A5AF63CD5520B7A,0x536AE69FA7F1FFDD,0x000000000000017B },
    { 0xDDD868A73F0BC9F5,0xB33A39D1BB82DC6D,0x878D8AA048953CE8,0xF2A35CE29802F566,0xA2B9188A07F25B60,0xD01FED060933CA89,0x89013FCE3114F728,0x8128FDBE87828FAD,0x0000000000000054 }
  },
  { /* Point #3 */
    { 0x005D8EA958FEAF6B,0x9D2B24C0F524807D,0x96AF717B21D9535D,0x5F9A6F424FBD0106,0xA9DAC62ABA7D83DC,0xE2E5FF3362347736,0x1621A6D5B6605428,0xFC96AE5EBC4BB252,0x000000000000019B },
    { 0x878EE5E421D079D5,0x403954492C46177F,0x334B26FA183F779D,0x8C07F237CA226599,0xE079FD96018C83CE,0x62391DF0664AB781,0xC3D390E30B9565EC,0x98227C5B8698FF98,0x00000000000001BB }
  },
  { /* Point #4 */
    { 0xF20E17F13F9FA837,0x0F66494807DB1380,0x5BCDC63187F0C342,0x56C64ECCBD3F369B,0x5E2DD96811C76666,0x77A37823DC4303EC,0xA88173A174B208CF,0x1C6268951AF41E96,0x00000000000001C5 },
    { 0x72DA351465467B39,0xA97A3735CE45ABDB,0xA1CB4A2CC98EEE0C,0x03DD02D494C63A07,0xD22B087A3B2689F6,0x5A50B83C3043678E,0x069ADF5F844A417C,0xA9EB7A19983FCFC1,0x00000000000000C6 }
  },
  { /* Point #5 */
    { 0x07AF0A7A0CC43FA1,0x577DCC1CAC346374,0x0430BA5ADC46A3EF,0x19623A3351D77F50,0xBB69E56EC47EC055,0xADDDDE29367B694A,0xBCC276347334CDC3,0x3605A214B6DBBDAF,0x000000000000008C },
    { 0xB9E26813333A23D4,0xB40840439DFD1C2E,0xB26958AA5948F69C,0x4E0E41CE836B04E9,0xE8781517AD2F0F9C,0x44411CEBF398EADE,0xE0394B527CCA9C3D,0x3692BB42184812F2,0x00000000000001A5 }
  },
  { /* Point #6 */
    { 0x4ABF6DE480E0C811,0xFB0DB238CF33E5AE,0x3F65131865638F5A,0x93E5D62E41078C4B,0x53EC3D90B4B44D9B,0x9FE564607DDCF3B9,0x4714385079848B05,0xBD3495A99E60315D,0x0000000000000144 },
    { 0x90409B61670BEDEF,0xF0B1BAF0B61F1014,0xED3CCB5CCC4AD55F,0x391B2125EBC6A449,0x9F49AB65C399DDD3,0xF7706CA403EDDC81,0xE42D1379579211FD,0x9452B0D11EDE88C3,0x00000000000001FB }
  },
  { /* Point #7 */
    { 0x96D64AF49B5E849C,0xF994BF477D8BC95A,0x75A4E5C0437F36AE,0xEE75C7107C7BCEC9,0x40F1BEBC437C8987,0xEA8288DCDB220F60,0xF9C197BA1353D1D9,0x8128EC86196C5B7E,0x00000000000001AE },
    { 0x608268BDF41CCE83,0xB061D94249DBD8B9,0x71A2710A846039D6,0xE2F432B4972580E9,0x34F1A7119BE7C986,0xEADEF54DC02E5EDE,0xE215A5E88E9FCB26,0x9A2A4F761D8C7C29,0x00000000000001B4 }
  },
  { /* Point #8 */
    { 0x984DA95DE0EA0BAE,0x7769CFFA3AB813BA,0x02FD64A784CC8B68,0x138655F25EA90ED5,0x71074C7C40B410C4,0xF3971B004A05F173,0x113D8242D36B4F4D,0x63BD460F4CDD1B0E,0x000000000000015B },
    { 0x26BFAF816DB9FE99,0x001943C40A3C3A72,0x258ECCEC8ADF321F,0x8BF97F30F50D775C,0xA7B60597E6899FBF,0x622BF2CB49EABD50,0x9FF457E9B19E9649,0x607570FDE2DBB651,0x000000000000010A }
  },
  { /* Point #9 */
    { 0x8DADD3B9B1A91A30,0x7C1A7B2BFDC8080D,0x636EC72597ADD67B,0x55EF3346B848586D,0xA2DDA1DB9FAB4DEB,0xF5902CA6D7F05281,0xB3B1C011C49D12E7,0x8667F01862710C83,0x00000000000000F9 },
    { 0x793CB015FEBB932B,0x728C1C984ADC729D,0x7CD284418065526C,0x8F505CEDA3DF7B43,0x5CA31F3AE9E7C0A4,0x41DE8FB6A1F2A5FF,0xA325B26B8E9682CF,0x76A2C09C34072ADC,0x000000000000002A }
  },
  { /* Point #10 */
    { 0xF878768DC39EBD2D,0xB1B035621B3A6B46,0xE72832D029C2B56D,0x218D6D25056BD4CA,0x612CA701AEC98FF1,0xE163CFB4087E18FA,0x87DE2193C2BEC7A0,0xD4021463B488AD62,0x0000000000000063 },
    { 0x0EDD28A4B8A8A68F,0xF1FFBBCA57379793,0x35148B571E59F460,0x05E012671C86CEFC,0x8A9BE0B60125BC67,0xE7E5A7B6BA39760C,0x6F2C362F681EEB77,0x6DA71B8A21896363,0x00000000000001F6 }
  },
  { /* Point #11 */
    { 0x208A4D40E3309DCA,0xD720DDC2ED752B10,0x05ECCAB3F4A522A0,0x190C361F0B0F5D2E,0x7B545BCAF944922B,0x7606513714B46CCD,0x9AC90BFC05F8ED90,0xD9662699E01262AA,0x0000000000000031 },
    { 0x2B52F35E5971B0FD,0x9608EC0AC785889C,0x0700B1CE3F63BA6D,0xFA7CBE2F4D414971,0x34432D63AAC0489B,0x3A0E756B15159B56,0xCFA5E9E5EE06AF09,0xF7868A00BDC35E7A,0x00000000000000D4 }
  },
  { /* Point #12 */
    { 0xEEF26AE3C25300F5,0x8BBFFBBFB5CD52D2,0xC6883FE52008AE5E,0xD9C9A0C8E2B01D57,0x9ACAE3B306C31AB5,0x7B2F19EB43B0C30B,0x95D3152AB1298985,0x4794F0EC5F12FF03,0x00000000000000A7 },
    { 0x3BDEFA96EF21BA62,0x3B32556422A57592,0x573F6BB2555FBA4F,0x732AD6B3BAE1A0FB,0xFC41BC29A2761EE0,0x621784F7ABA990F9,0xD4BA1AB2E48A868B,0x66312DB4D1399B20,0x00000000000001D9 }
  },
  { /* Point #13 */
    { 0xE1BDBA76E7577C4F,0x7C7A2BD01AEC855B,0xBBE209299D94D7EE,0x03514926D2163FD3,0x20F5705025D05B98,0x4D6EDD515B533C7D,0x95F75C804C5B6D3B,0xCB1E542B6240AB73,0x00000000000000BF },
    { 0xC325DA076E47C22C,0x128F86A385C3CC06,0xAD3E15121024230B,0x15EDB6AAF83654A7,0x889E306307C699D4,0x5D8A38B50D1796CA,0xAD38A634768889CA,0x61416EA7730723F7,0x00000000000001DA }
  },
  { /* Point #14 */
    { 0x8049507015FF7901,0x1478179A05613016,0x59EFD46CA8BE1593,0xBD1F8E76113933CC,0x09E6ABF36992ABB5,0xC95822ECA1D045E8,0x7436D5981F6C515C,0x8D7C824F1BBFBEB2,0x00000000000000E4 },
    { 0x7D026A123AA9274A,0x830BFCA50BD883D5,0xEA9B5934FBF1BCD7,0xBF8C71836B06D84B,0x4C0885BC205FEA9C,0x5FED94AD4CFF3B03,0xD9F7B8F98BE81D5D,0x64D908C6893FA1B5,0x000000000000007C }
  },
  { /* Point #15 */
    { 0x6090AF094DD5FA13,0x2692662F45FCC533,0xD5A50950996EB47D,0x282AA07E4E05F928,0xA36C37468AC85517,0xD1E15CFC3EFD2216,0x60BE70D641919F55,0x87B397406718805E,0x000000000000002E },
    { 0xF82842B22E5DE3D8,0x0C5EC9F1B94E5442,0x3C540E54F1564D79,0x5925A29096AD7E49,0x20B0D2626F3549E7,0xCB5F02E2918852E3,0x5DEADE8F86223552,0xB82D04906F078DC9,0x000000000000005E }
  }
 },
 { /* Table #97 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x51318AC974BA879A,0x23723B6DA68B584C,0xA7872BF002AC441E,0x1E0C8FD665C7B9F4,0xE8E3BC24B893449D,0x2E83C6B8F06E02A6,0xBA754C0178D50EF5,0x7C6C06EF2C547C38,0x0000000000000132 },
    { 0xABBFE4266DEE6431,0x2D51AAC612FD88EA,0xC6F215251C83591E,0x85C550E59EE42180,0xE1A4297DA8CD1C50,0x28F07CF6B55723CF,0xBEDE788E4113977B,0x8C7572FCBEDAEEAB,0x00000000000001AB }
  },
  { /* Point #2 */
    { 0x72916BE74E6DF03B,0xB14241ED090A7B6F,0xEC0532FBCF5E6F43,0x750CD95B680383C6,0x2892D449C7CD9543,0xF0550587D5D3AD9B,0x3B330694E9C29C0D,0x6FA03173BFE6860D,0x0000000000000111 },
    { 0x6D55B870AB75C854,0x156F9A4002F049F7,0x72E2093BFA48732A,0x4BA2D6CB9A3C272D,0x58102BE5D89BA292,0x4074F320B3C5C3B0,0xB478C05EE462C677,0xEBD4978F97182FE6,0x0000000000000182 }
  },
  { /* Point #3 */
    { 0x32C0CF8F2B1148CC,0x881D8C7CC2086AA9,0x6B25DAF57C9FD47B,0xBFBB7226CD5EC48B,0xF2B79DEB9F2307BA,0x03D30DE55FCFB278,0x4B2D3A4671EF137B,0x4E4A24B1CAD4495C,0x0000000000000173 },
    { 0x363160471ECFC10C,0x8A4AC3BD75C27AAD,0x6FD1ABEFCA6F6103,0x6AB15369B741C7CC,0xDB25D3CD86719621,0xE0D34A98EE85249B,0x25BEECEA370EFC6A,0x7D8A2FFCA2CEFBF6,0x0000000000000057 }
  },
  { /* Point #4 */
    { 0x70148A3A1B27F40B,0x4CE48C61B7C6CC7F,0xF6EE8026E7BEAAD3,0x37EAEC76D11AB074,0x060F2EDE99C1A334,0xE9CE92E469150184,0xF90E484852D73BB0,0x0436A9BF01B5AE4D,0x00000000000001AB },
    { 0x3F83381640D46948,0x318236B2FC39FCCC,0x8835B602122BCC3F,0xA430B37B965AC801,0xF448EA0FBD0585FD,0x49E52F74252BB5DF,0x810768AE1085ACE7,0xA8CEB3299242E43F,0x0000000000000189 }
  },
  { /* Point #5 */
    { 0xE929B729504F8B28,0xE706657CB887EF71,0xB4BD5CDA0B83DB33,0x465187F0E761913C,0xBD632BD6040B98AF,0xD82BF2AF91C37379,0xCC1058B15380AEC9,0x243967A1C506F0BD,0x00000000000000D1 },
    { 0xB298442687D73C34,0x5FFA94EA46CBE44A,0x5814A34F20DDB255,0x8EA5436889B68F69,0xE21603B0D26B66C6,0x4695DFF2320B6862,0xA5D5332742D53E67,0xF17DF48AA5931FD7,0x00000000000001BB }
  },
  { /* Point #6 */
    { 0xA63BBEC0976E030D,0x7A81CE08E65327EF,0x0AC6397FA7C90248,0x14EF2887488F9BA1,0xB2B47A2F497ADD24,0xA86A385740274DE2,0x25ACDB8C12374808,0x96F4EF892C57A8B1,0x0000000000000050 },
    { 0x3A8D6BFB85199966,0x78BF5C36FBF35493,0x8F1DB78B5BD8876B,0xB8EA47B6B2BECDA0,0x5DECD86D13992438,0xC0ABE6D250DC68C1,0x85B05DA73EACA155,0xF8095622B1BD9E0B,0x0000000000000104 }
  },
  { /* Point #7 */
    { 0x1B50FA628D00DA24,0x98C7AC500A0590BC,0xC33C9F7F6C101946,0x653848C30C4EAF7D,0x7AB38C79DC892656,0x2CE0AE53420316CE,0x9DF9A0087012D563,0x130CD5656D51BD57,0x00000000000000B7 },
    { 0x21A2C95078FFE5EF,0xBC330A097B991B38,0xC5151E1B2D4A375B,0x70A29D1080C0F67A,0x2E75A55F2247B284,0xC95A638058F332F1,0x0D7A5242A8FE1CC9,0xC0B1176CA712A8CE,0x0000000000000035 }
  },
  { /* Point #8 */
    { 0x7B0373E4FD998A0A,0x0BDDAC80C37E7937,0xB979FDCA8EECCC27,0x150C3141E82B945A,0xCF88A830CEBF1156,0x649C7C1ABBEF5C8F,0x3199E1C5F10104EA,0x31E4FD39898B7FD0,0x000000000000011D },
    { 0xC24063DE449BCD85,0xB0CC16E1B96FEF39,0xFA391388B2F631B2,0xD39C21B41F4A449B,0xD036CB3135F5045A,0x58A0729C367F428D,0x7DDE830655C42FB9,0xD14AB2FEF68C64FA,0x0000000000000163 }
  },
  { /* Point #9 */
    { 0x679BDF48C9BBD131,0xDBB2843C2A51D8EB,0x1BD3B522F24F8538,0xD94EF0E0194A77AF,0x01940A3F4CDCA642,0xA4BD46BF85E88692,0x35F15B557C3EBAB6,0xF9CA4DD99B15FBC4,0x0000000000000073 },
    { 0x05AAFD4187B3FB49,0x365D712B01CC6409,0x208968C34E12C979,0x3728B80E33E64621,0xE30FDD56E80B58CD,0x384AA6D14FEC8836,0xC24EFEB1AE461678,0xEA7BBBAE4A64F28A,0x0000000000000139 }
  },
  { /* Point #10 */
    { 0x41F27F175D8F1B7C,0xEE2DBD7F3A30520B,0xDA3D32E031DE2890,0xF32C83137185B2AB,0x824268AC177DEC5C,0xD947969FAEE2D709,0x05C7262C897D470B,0x4A5021361155DB81,0x00000000000001A5 },
    { 0x4198F8C76FA90BC1,0x47F196496FFE559E,0x05F2AFD4683D2726,0x3D104444CFDB666A,0x6105CCDF48287F3A,0xE6161969F7AD25AB,0xF4A197BC4F8764F1,0x5E2AB9307415C7B1,0x000000000000000D }
  },
  { /* Point #11 */
    { 0x1809B1B274443123,0xB3AF06F6A61477DD,0xCEAC98C2B6D81198,0x06DEE82EE603FEBB,0xD6D647DCBD75245E,0xF84D8DAAFA90D977,0x25FC59DAE563BD93,0xDE02D7057136202D,0x0000000000000139 },
    { 0x563A9DE3E3F1C7BA,0x82CC084F869C65CF,0xC4422C0CC128C5C2,0x77198BF28B151834,0xAEBCD566FB44CEAC,0xD5D14DC24A48B704,0x9037F90E96F68B39,0x1FD620562139ABD1,0x000000000000017B }
  },
  { /* Point #12 */
    { 0xE4C458A85305CEBB,0x20D17EB6FC658B31,0xAA01C4D263CA8741,0x72D5FD2113CF29D6,0x806685CBEE428454,0xD3F919EC4B724CD0,0xCBE338C2E3AC8E29,0x6E2656835314DFC7,0x00000000000000A8 },
    { 0x3AC3EB5E827B113B,0x1C477B6925090814,0x4F75C9C3828F9981,0x2512D616DC06B077,0x2BE11B509495DAF8,0x5338F8F79B0C9203,0x2764F0F33A3585D7,0x87ECE546BE251803,0x00000000000001FA }
  },
  { /* Point #13 */
    { 0x11C68D32FC270282,0xE86C1869CBB9ADCE,0x5D19FD458EC3E7B2,0xA97924C914E0C42E,0xCB26D9F5E614F642,0xE0281148F4E9664F,0x1A1FF74BA8323FD4,0x17D81B37F1FF01B9,0x0000000000000060 },
    { 0x7A7AA7196D49AD5B,0xEBD73076CF6CBDF1,0xE01E29E09A9A30C0,0xEFABAFE93D96FE1A,0x875902D2BC1A8C20,0x45842F5E017444FD,0x734DC417FDBB0C23,0xB8624F5249FB63C0,0x00000000000001BA }
  },
  { /* Point #14 */
    { 0x5FD30221CA693C02,0xF0D3DC9C4FADB34F,0x7DB094592B25B51D,0x5F8E88EAB2FE01AA,0x0D8307A8B1B8B649,0x8879D257216DB9C2,0xCBCF6FE33673F55A,0xD88CBC10ADE0529E,0x0000000000000130 },
    { 0x977927142D5BB89D,0x721262DD0CDBEABF,0x0DE4D4089E013BB1,0xB813AC6CD273376F,0x8B34A4458C8B5611,0xC41273DC663A778B,0xC94BA90704E8B3AE,0xA2E7E2E27CC1436A,0x00000000000000C6 }
  },
  { /* Point #15 */
    { 0x3B8065E5FA285859,0x9DABD85A017A52E5,0x7C1C2DAD615B37D2,0x180420DEA4197F77,0x87C7C86C4B42B112,0x1CD544C9AA6A7A6D,0xE1FC2FAAEA61DD31,0x990E475FEDE66B85,0x00000000000001F4 },
    { 0x5157EC25667C5DB8,0x85746DA2C5B2EF31,0x68C9C60A85160D33,0x877FCDD5ACFE5C9F,0x275952D93801DB0F,0xB5A2A4D29D529708,0x871C8D0C22CA71CA,0x06C61F4C91DA21D7,0x0000000000000008 }
  }
 },
 { /* Table #98 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x5663F565A308E123,0x91A48983157C2290,0x222F7F93C054408A,0xD8694963B839A520,0x864B491DD314DA50,0xA315D96ED675CC09,0x32964930390531B6,0x9387671921E11F6E,0x00000000000001D0 },
    { 0x20F4598E0C3477FA,0x14C758B4CCF7F114,0x0C83F642051B875E,0x14AB1B501B290E7D,0x99F812C7F1B18FA8,0xAA60F39988CA8E75,0x00DE2BD0B9C6C5F7,0x765DA97328703A2A,0x0000000000000015 }
  },
  { /* Point #2 */
    { 0x05A704CC2934ED82,0x647089FB989EDD8C,0xE0B239D40CE7C62D,0x4C892EA6105A5EFF,0xA519395FD5ED6B04,0x806C7003509ED794,0x882E9886E70CE5C4,0x50730CA1FF01F6A9,0x0000000000000088 },
    { 0x90A78A16DBCC5484,0xC1AB078CFD454B50,0x6F488252CB09E525,0xDD663F53E19B2ED7,0x16B10DA1A67BF59C,0xB47F6B9536BB770A,0x6BDC8428777B2BCE,0xCD02AE3D561553F8,0x0000000000000017 }
  },
  { /* Point #3 */
    { 0x06BA35C1EE2F1290,0xEC34093FD403D1E7,0xC1B8ED8FA659075E,0xEA322AD8BFE99020,0x3B7A95D8D5148B86,0x979D99BEC2CD9ADE,0x89A6A55285DBA94C,0xA5B7E51BE090E6A7,0x0000000000000120 },
    { 0x033B73CEAF82552A,0x8C98E0B55CA604C1,0x177A92E5533ADDF7,0x6EAB8277ED1AD360,0x05937E24BFB8E3E1,0x4193E5CFD061128A,0x4F781B5DFC1326FC,0x74403EB19D0056BF,0x00000000000001F1 }
  },
  { /* Point #4 */
    { 0x36DA34D11EDC1498,0x7BA9673C18D4C455,0x9ACD94FF724EB3FD,0x5DB71C7AD31CFBC2,0x64357011D49A2214,0x80B6101F0AAE0C21,0xEFFEC6209853D1F0,0xF928ED94EDA4FB5B,0x00000000000001BC },
    { 0x0031C5CCE3DB108E,0x2663B3AA5110EB67,0xC0432C4F3B2D50C5,0xE5B812AB3D94B4FC,0x031FCBE4E9828D03,0x048DEC907A08492D,0x7420A4EDEA50D639,0x0BD4BDD076EEF289,0x000000000000015F }
  },
  { /* Point #5 */
    { 0xE7718E9BDF3566EC,0x2ACD4C45D1D77E5E,0xC78694ADD9787985,0xC7C600C5F645C923,0xCD1E697AC393F54B,0x7928ED5B20054D6E,0xD3C839E03CAFEABF,0xBFAAFDCEC46A4425,0x0000000000000196 },
    { 0x6BAEECA1E1804D34,0x6996DB6C70AA5E48,0x24E11983B9577C2E,0x3966F9A104335832,0x5654CBDD50889C2A,0xEE86177F32DF0DEA,0x7E9C591DF8D76ECF,0x57DE93BFDDBAC362,0x0000000000000022 }
  },
  { /* Point #6 */
    { 0x78709A5CA92D6561,0x36B5D1F10880BC8E,0xF980CEBC0AF2078A,0x4B5E964A14EDAAB5,0xD526F78563AFD322,0xF5A9D4C668E17240,0x0C420E2819FC5026,0x3327540903459B12,0x0000000000000157 },
    { 0xAE433226C4D6BB5D,0x5E39057B13EA6565,0xEB7729AF7AAF08E1,0xA74C0ED7012567F2,0x65B64576B6E89ABE,0x6B025E87F2498699,0xBC92A03CC229C0F1,0xC54DA03B0F1F67C7,0x000000000000001D }
  },
  { /* Point #7 */
    { 0xEB525FBB07D2778E,0x4CD96634C965143E,0xB2EA802D742E1FCB,0xA2F1EC4C75BC3CD4,0xE778F1E1125EBAF8,0xC700E4E4650B81EB,0x66D593A59C841F1B,0x4DA417578D2984C9,0x00000000000000A1 },
    { 0x6E9ED77D57D4A16E,0xEFB8F94C1C1696AE,0xF2961D2C8ACBC2A6,0x8FC9352DE1D5DE1F,0x786158D1A7B8579C,0x3AB33268FDCBAC8A,0xF237B433D583ED20,0x3EDCC184E4C10D57,0x00000000000000CD }
  },
  { /* Point #8 */
    { 0x8EC9A4151E96A885,0xC95EC1EF7E63CB24,0x8A77BEF7C506A04D,0x4E4DD4100AD06B3F,0xC2EB62E4DC28FD42,0x7CB2239454040FAB,0x74A3429A64595D06,0x05983DFA26FD26D9,0x0000000000000151 },
    { 0x56ACB9C1291BA5B5,0x9967485F11C55994,0xFC8EEB0BB23CD929,0x0FE8DB6B39D78FB1,0x3D7281E846F04210,0xE7F29C805D9FE1F9,0x2EA28B7EF78B31A2,0x594D39EE4DFE2D5F,0x0000000000000087 }
  },
  { /* Point #9 */
    { 0x67F5679C7C9BEAC4,0x985A78336230B567,0xA250D8DE064E4738,0xB8BFBDD3B564700E,0x087BF9E82E14AD7D,0x4CF9220AA0317FAF,0x6614AE6EB05BC341,0x1DEFF5D59E41105F,0x00000000000000FE },
    { 0x8B47D53A03966619,0x72D5B26CBFF94109,0xDFC37D1510B76762,0x669E715664B09F94,0x16E999E2D3FB006B,0x3E5AA52B6AA4487F,0x8BFD7F5533C1350A,0x68FF6CD44E72EA36,0x0000000000000161 }
  },
  { /* Point #10 */
    { 0x450ECCBF95B7CF7A,0xDF3B7DA8B44AF149,0x373E6B4F40C25B44,0xF9DB1D32E6C86B87,0x02466D20439AF230,0x17BD88275830BBA4,0xF8F5E1805AEF36C3,0x6986AB02B7ED8E89,0x0000000000000173 },
    { 0x5C05151D51FE4224,0x824FBD0F5576CCB6,0xBE14D2F8E1751932,0xC608E4C367FA6561,0x4FA94021A856141F,0x752B95BDDA4AB1A8,0xF4D032C295439524,0x408521C03A8E1267,0x00000000000000FA }
  },
  { /* Point #11 */
    { 0x9B7D1F3BFC0F4A8B,0x7A8F0B0F5CCB978B,0x00D61C73D3415AE8,0xF46D7B22C6AEDE9D,0x1FC2937114822DF1,0xE3E1D4675F740F97,0x3A7E3BA3B9159596,0xF99CA1A803B5EC47,0x0000000000000029 },
    { 0x04243BDFBB5CCD4E,0x055A49F78802BD75,0x51F2D40A306EA61E,0xA70666ECDA558BDC,0x92AE69D13E523A23,0x98055B32C4EF7644,0x3748D45E0E228566,0x9C4991A170BAE7D8,0x0000000000000106 }
  },
  { /* Point #12 */
    { 0x6502B92CBB5C5C05,0x85D920E3BFBE8363,0x7A2ABA0D6E2B1EB1,0xC02768187C1E4E5F,0x8EED0E03E426684E,0x164E869178E5D42E,0x606A3A5498AA47A7,0x2350730D0B830942,0x0000000000000148 },
    { 0x5E1965A01D104B08,0x7E28DADD373E0F14,0x77B7C36FAC533CCE,0x8C2D1096E00217BE,0x016538A1AE057A93,0x2FB0BF1E5A58F3DF,0x0E6A5E9D9785D24C,0xB945866BD5A89BFA,0x00000000000000A7 }
  },
  { /* Point #13 */
    { 0x143510E9FE207454,0xB0FD9824BBF845F0,0x39C13279E8BF1A9E,0x75FA89A10FECA613,0x2C66A7EB825A3DD7,0x9C2B32C8B26368AE,0xF92E1AAAF619A005,0x4DE668FDAACCFCA3,0x000000000000012B },
    { 0xA92801B445CFCF06,0xFBD77F9CF74D70DD,0x1E47198C6340644D,0xFFBA0B1F6B4DAE22,0xE48CB9BBC7B899DF,0xA2F0ECE2C71B8B4A,0x5D9815E62A173EBE,0xB9B11BC50E9906DA,0x000000000000011A }
  },
  { /* Point #14 */
    { 0x55AC3726FE2A7478,0xE94F2031E30FF599,0x469519BD10936C6D,0x878D1FC50515A43D,0x187F4315806E0B6F,0xE03DC8BB2772FFA8,0x32B48A444A6B058B,0xEA5822F35164EC93,0x00000000000000A0 },
    { 0x5C617856737160E6,0xC9C64CD423C701EA,0xFBAEB50175437EB9,0x99422E75DE99481A,0x0F222393795537C5,0xF7A2094923A1C0C7,0x5E14E523F71EDDE9,0xE03BFB13C7EC1652,0x0000000000000099 }
  },
  { /* Point #15 */
    { 0x592528BCB0D0888A,0x32B7CA4DCABDE573,0xA25E1B62404F7268,0xA3DA442D16381BF7,0x62CAEAAF5D6ACDC7,0xC9F64CD37E764A4F,0x297687A84E48F5CD,0xB315F2345E2D02A9,0x0000000000000012 },
    { 0x4F91C00520ACAEBC,0x61CE683CDB8CBFE4,0x22A4EFD555EE34CE,0xF8D7D3CA64516080,0x38D087A027AF0007,0xDDA0DFB2E0DE0EF0,0x7E0601F0F4C91376,0x23D16E102EBD6270,0x0000000000000141 }
  }
 },
 { /* Table #99 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x1BD8CE7B5A53C22B,0x78733FCD7CAB446A,0xC44CA4E248ACB394,0xA9888B1EA38C790F,0x36AFB6EB15C34237,0xB913B8A8FB702063,0x34B77CC5917508FA,0xA931D7A7F9E4732B,0x0000000000000050 },
    { 0xA90A429056D21D18,0x8266630755B410A1,0xB4684A8B894A6B05,0x8A1ADE63828CF75C,0x4FB2F85A127702A3,0x83FF7D05ADF7B709,0x1D3F5A92A68D1DB6,0x243CE1DBC093CD5C,0x00000000000000F5 }
  },
  { /* Point #2 */
    { 0x8B3DC3D04AAE7354,0x9CCBF6CE4A8F62B0,0xB3713C0060C73A7E,0xF6F73585349EC6A0,0xA995A64CFC30467F,0x877334FEFAD776D0,0x84588E41B236DCF3,0xDCFDB088E9CCBD7D,0x0000000000000181 },
    { 0x188DB860FB36E7AE,0xE7A0DF8DF45EA4FF,0x110245AC5CA6F9F7,0xD4C3509D7A7031AF,0xF4AA648F34DF0623,0x462AA9497E664BD5,0x415012B4E2F0138F,0xEC3DAFA01C60732A,0x00000000000000BE }
  },
  { /* Point #3 */
    { 0xF77AFC9EC1F9124F,0x010AF17A5D958392,0xA9AA7D55EEB66CB6,0xB41570CA816DEA76,0xB2138D58A983B39C,0x0FD404CFCD6CBAA5,0x29C1F2FD40C224CC,0x1E263CAB99C23815,0x00000000000000E0 },
    { 0x371CD0937649D2FF,0x7C79D3CC02038FF9,0xEF3261855CA5E1B9,0x1BEB030BE02C0478,0x134D0C94F859FD4A,0xA767FAA5EE41B919,0x8D957AACD5D9E3C5,0x4B1C1DEB191FCA35,0x0000000000000175 }
  },
  { /* Point #4 */
    { 0x1379B176E80649C8,0xAA0C2DC8B7FDB132,0x3F3050EF1134FFD2,0x28D4E288D4A76F0C,0x22CA05F7CD9B7F91,0x9174BEE06E7B9EE5,0xC0DDC6356B341CB3,0x1CD07D05EEA9DA0E,0x00000000000000BD },
    { 0x423EC36BBBAA1DF4,0x33CCC8ADE74C741E,0x598D466249B5CD06,0xD8BFC7E58FA121CB,0x2CBE86B991BEC4BA,0xBF1FE841E8453F40,0xA35FF85D392592B5,0x8DE9F3DF9C5807B2,0x00000000000000FC }
  },
  { /* Point #5 */
    { 0x91B8719F690C9C13,0x1932A9536D91DE54,0xA4B86387CACBDC0E,0x706CA7DD8BAF648F,0xBE6702B5819C8BBA,0xD8E503A8006BE63E,0x7CA8DD6A2DFAEE90,0x15BC698C8DC428B7,0x000000000000003A },
    { 0x1FECF27E865E5E1B,0x20F26B4456BDA0E8,0x274CD07A88DCE3FF,0x89B8BFDDDC3EDDA0,0xADC93A6E22CF062D,0x2092780FF57D091D,0xC7D33C53B799B1AE,0x803E54D7D6272724,0x00000000000001E2 }
  },
  { /* Point #6 */
    { 0x1882193027C0B1D7,0x488BDF629D9B1A2E,0x64A37425955F6A87,0xB1DC88D258ECCD62,0x9F3E8326E69EE6D4,0x5C58741FE736DA3D,0x0E9C23BA93A2D8B0,0x8F42DF2BCA94A979,0x0000000000000044 },
    { 0x70B7CD7C2C37DB33,0x872563298233255B,0xABBA168E4FA0552E,0x2EF3FF3DF09FB826,0x431B83B779A38600,0x57FEAEC2A6C1EE12,0x568EE5439B219D9C,0x0508BC77AF9410B6,0x000000000000001B }
  },
  { /* Point #7 */
    { 0xEDC83F7D638F4BF3,0xA14F546576E89AE1,0x38C36854CC6EF43E,0xD26DE66494C010C2,0x79410987B8403839,0x3119056E1B6E018B,0xFC6CEBFDE195E68F,0x23FF26C72EE4BC5B,0x00000000000000EB },
    { 0xFE4D342CBB1A38ED,0xDC6B99B83F7C3D26,0xEBA992E8BB6301BF,0xDA145FDF8D9B6AA8,0x568ECE4D99A9D166,0xFE783E6F07CB01EF,0x3156339CBA0F3663,0x909FA7E5092139DA,0x00000000000001FB }
  },
  { /* Point #8 */
    { 0x40F66D1915B26E6A,0xFD654E8A64400D78,0xE408365366AD9DE7,0xA64CA69B686C1B2E,0x698749FFA80066E2,0x197528A4B76196C5,0x2BCFCF647BF835DF,0x1A83FE8460E478BF,0x0000000000000020 },
    { 0x948F3E0AC46D1075,0x3CCD3DC1E5C05FCF,0x11B825B26414EB04,0x2B7A9A5521E3F864,0x2A24F5706DABA159,0x51900D4ADE3EB61E,0xADDC9096A6A6766B,0x357EABF9E9DC3B6B,0x000000000000007C }
  },
  { /* Point #9 */
    { 0x132BBC26A6B7273A,0xCF61C187474A253C,0xD585FB0E28FA498C,0xF0FBCB10C16BD41D,0xB9E4985C7799A48F,0x6A3B3C2ACD6F7AE9,0xC222E36DD836427A,0xD4538A0C2F00213E,0x0000000000000014 },
    { 0x60616F1F0C9471C2,0x444401B096A7A73C,0x0D0D81D252E7491F,0x0187C2BE0E90BDAD,0x84A0B409AA941EF0,0xBDA20A5769915089,0xB5FA8BE81E71A5DF,0x2BF3042EE763A843,0x00000000000000BE }
  },
  { /* Point #10 */
    { 0x3FCDA9812AB0E1D3,0xF114E05E531498AD,0xEAC0E45B31404A59,0x523E38DDDE4FE26D,0xFC2E6859657B3BDC,0xDD3F310410E7621C,0x3984234CF2BA059B,0xB8CB445571BD7C13,0x0000000000000074 },
    { 0x143EFCFF241EB056,0xD2DFF14A71DE972C,0x773691079A144BF5,0xC1452607A2A8950B,0x6ACA33C0C8AD848C,0x80DF3732B4E2AA09,0x3032CBC6E4370FC7,0x9E3E6B932A595D99,0x000000000000014E }
  },
  { /* Point #11 */
    { 0x7AF8E1F434EBF7AD,0x6CBEB971A4D427DB,0xEB0CDEB41CE006AC,0xAD09E2C32BEFEF71,0xBAACC71D1C7602F6,0xF147ECCAB63E4D9E,0x64B59D3E907C7AC9,0x05981898A9A2C34E,0x0000000000000050 },
    { 0x980BEACE7467E7C2,0xD2AE8C4F970341D0,0x0880DDE95184213F,0x94BD710C3463CF73,0x4D49D328E15B70E9,0x8EBADAEBEB357560,0x763AD6C07E8C60C6,0xFA0C3F47F22707A7,0x000000000000017C }
  },
  { /* Point #12 */
    { 0xA8A711367034F904,0xD50AD5A49FA79AA6,0x369392004931B82A,0x3CD92D99A49C086E,0xD878492E7F1AE8F0,0xC9BECA4C521D0F23,0x6490735B2F5AC654,0x2416F8674F0522C6,0x0000000000000036 },
    { 0x4FA3A79C581BEA68,0x59FA637C7F1CD216,0x2AA3F5F458C3E7FA,0xF9A41BFFDD8A0561,0xFD5E59200A0C8949,0x3FA98D756CF835A7,0x8CA87E63DB43E536,0xECDA27697DCE61DE,0x00000000000001B2 }
  },
  { /* Point #13 */
    { 0x3151003BCA85BD53,0x654B930488BC7B2E,0x63F6B7431EAB1C79,0x301DD16A77C5862E,0x39107905E8578BB6,0x48CEB8D5F5F255D3,0x05EDCDACF8A85253,0xD803A8098DBF333E,0x00000000000001C2 },
    { 0x23036EBB08035533,0x0811521C7496D042,0x8F001571348739DF,0xA1E70BC9733A0E5C,0xCBD726132749D9A4,0xF9B28C13BBBF0566,0x0224F0E8F848D39F,0xE85C801416E65861,0x000000000000006D }
  },
  { /* Point #14 */
    { 0x504AF3470DD5C74C,0x5A94B455230FEA57,0xF26394DE2973C937,0x866A252C037FFD06,0x7DA7691A6692C191,0x4E11F3E9F2319FBB,0xDB33226242CCB61F,0x9188CDF3DC3430B5,0x000000000000011A },
    { 0x3868EBBF98FE7114,0x1EED5F24E7328C16,0x2CD9EBE78905AF38,0xB0EB4667A4301E86,0x587179D90D5E2660,0xB515DBDB0F2636BA,0x967C7A6C149EAB96,0x44DB7FA547571321,0x0000000000000193 }
  },
  { /* Point #15 */
    { 0xDA48F1C4DC90D667,0xD8C35A3FB0CE40AC,0xAFDAB1B70600DFCB,0x3F37FE8BB7BC8531,0xFE921F70B44A5E7E,0xF79DD8A4CA51866F,0xFD8995F9C43B4FA8,0x54508FA681DDB91A,0x00000000000000D7 },
    { 0x99621E3BE0ACB157,0xC9103EB2BFD8E94D,0xDEA2BB5F069B8D34,0x25DF19F0A496B9D9,0x5229DDFD8D49CB34,0xE90758341215DACC,0x3F8FC88C73A800D8,0xB36A97F0BDFCE376,0x0000000000000128 }
  }
 },
 { /* Table #100 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xF5C1A4C690185363,0x15F58FD920C04ED5,0xA7B46E0CE913A1B2,0x1E7167C636F1D8C5,0xF4FE6BFEBF5FCFB1,0xC46FAF10A6C2027B,0x45D593004E1F12F4,0x46BCC87312185485,0x00000000000000CA },
    { 0x7C5180716432C12B,0xB7E004AD90AE7556,0xDF847160D8532693,0x4D8C7B8AA18B3802,0x90E2504596872AF8,0xE69D4894AECB6FAD,0x6DDAA06C17D0FE85,0x49F1A466340C3528,0x00000000000000D9 }
  },
  { /* Point #2 */
    { 0x64782A476DA18F9E,0xB89E0B654A496E02,0x437A49F6501C3A88,0xAE9EA08748A19F6E,0xA787948B346D2069,0xA6B9A3F1532EED3D,0x728AB35E8AD26937,0x3CF24801041F4F43,0x00000000000001B0 },
    { 0x5E272327CBBAB58E,0xE4A3C5F9F8705FFB,0x2EDC1C8EEDD26EE4,0x1BD46FF5F26D033F,0xCC566431D87192FC,0x03C7E40611764C8A,0xEBB80E34882A69AB,0x7A7F694361A08D84,0x000000000000011E }
  },
  { /* Point #3 */
    { 0x68F4A4E058B77137,0xD8A34E67F12F5BBF,0x1781240F1E0619C2,0x44495373498328BD,0x98E9F61A545B7D41,0x767DB401602A0C48,0xE138E5E8806301DE,0x65A3883B4B21AA89,0x000000000000012D },
    { 0x647B00780423FE94,0x424F483FFD276310,0xACA222FBD6A06303,0x47162ACBFFA52C17,0x7AE0C5019DE267FE,0x998DC9BB667A30C8,0x988CF192AF48C727,0x0A270986DFA23A3F,0x00000000000001FC }
  },
  { /* Point #4 */
    { 0x5C9209C1C4646439,0xCEB6698586C5D6BD,0xA5F5225829E415B4,0x18FFF2C1E95D2A27,0x21D464F1BE40C8D9,0x11B4696E059828CF,0x5C1F73C570F76AEC,0x6019FADB273E3F5B,0x000000000000012C },
    { 0x6D1FF5913EEFAB44,0xF913524CBA2986B4,0x96FC0B7A290DCF2A,0xF9E7AB52061DF2A2,0x66401173D47330A6,0xFF2ACA188B9F749F,0x8D4AC80F1AB42AC3,0x10EC329EA1378039,0x00000000000001AA }
  },
  { /* Point #5 */
    { 0xA5FC51EF9C1D86CC,0x66A9B8980B3FAAD3,0x96C73C2521D124ED,0x392440DB050626CE,0x02BFB1AC50A4A12A,0xC70A30741742DDDD,0xF1F9DAA647FE811D,0xD4BAA6B1FB3CE6CC,0x000000000000016E },
    { 0x09042D7509D96CE7,0x4C92CE693315F77A,0x4992B1F9A9C0D9F6,0x7C0FFBACD18EC980,0x53D205DCA008AB38,0xF0A098F7C908481D,0x2BFFD3630BA397BE,0xCA36E99F49003F86,0x00000000000000A2 }
  },
  { /* Point #6 */
    { 0xA074FDB7BE4BADB6,0x97B054950DF5F046,0x5A3F64E4EAC3A8B1,0xAFC5E0132971FAA1,0xE6D4AE36568E4A3A,0xEB0324BB97479A2A,0x2DCAF3D866A2C69B,0x9F9B5551813F21EE,0x00000000000000FD },
    { 0xEA8F05C8A13D686C,0xF27EDB763BDBD1DE,0xB2E5FD405C65B0F4,0x5E959C016CBD964F,0x02CCB301DBC193A1,0x34CA7ED9013B972D,0x7191CD287EDE3F2F,0x1D07F45798BF4E0C,0x0000000000000057 }
  },
  { /* Point #7 */
    { 0x284E98F320F12986,0x3112BF24749EA8D5,0x5FC7A2C42782914D,0xB2F7C229D94786AF,0x4B17BCAEC7158280,0xA139D563E6189A46,0x9C72E9C583CC9173,0x5CD5A6A0BE56B6A8,0x00000000000001A5 },
    { 0x51F0E802235A8051,0x153DC987C4C5FB7C,0xB549E9C79868A706,0x717390089BDF5C1F,0x0D04F60CCCBEC99B,0xDE66C9617F4BD294,0xA787D95E51156724,0x7CE4B4A5AE12B9B3,0x0000000000000091 }
  },
  { /* Point #8 */
    { 0xE7F35808FB6618BD,0x6ABB67E1732EF576,0xACCABB44CD0BFD8A,0x176FFA9183459746,0xCC12958585B88B2A,0x28D94486FFF151CE,0xF55FCA164C84BB00,0x07CBC8419C3A42B6,0x00000000000000C6 },
    { 0x488400D078788C39,0x15EBB100D8EB1FDC,0x58DECAE3BDC05F72,0x3BFDA4A75D56A2CF,0x7EA3F8EC5AE6701E,0x652E7E0B3AAACAB3,0x267D275228609228,0x52DDC983912EFD7E,0x0000000000000029 }
  },
  { /* Point #9 */
    { 0x0CE0F89F0356EF50,0xD8CDF51E37F24A9A,0xD0720E9BD237FD55,0x20B75973AEB71292,0x0D6EFB23E42B2758,0x0FCBDD568721AECA,0x11658CE90FDA8AE5,0x23A4D576700782D9,0x00000000000001AC },
    { 0x77FC6F2F903BB623,0x36710BA75B2A0237,0x4EA518D1D55A12F4,0x0C0509E14C95DEE0,0x67E240784BF6C59F,0xA9BD12B5C925E26F,0x5865B6C38FABDBA8,0xC6E3433B33B34605,0x0000000000000101 }
  },
  { /* Point #10 */
    { 0x8287592E80C0E648,0x79CFE5B529CE1A05,0xBC2ED6C732859038,0x076334F7AF367139,0xE13E55593A592211,0x94D5548847F87368,0x15D99113A2F1B6F2,0x2BC0EBE9FF79885C,0x0000000000000171 },
    { 0x68EEDBB2AE127D70,0xADF3485597AE5D0B,0x02E40BA8D1F6DC0C,0x46CF4B8F3E7A23C4,0x111958025626C5CD,0xDE32666E1C728EE6,0x2C594C77BF2D8B70,0x3DCF58BB1469BBD0,0x00000000000001CB }
  },
  { /* Point #11 */
    { 0x548235D6DA309336,0xDC058555D0CE4B03,0x8103A260117D9FB1,0x7AAC6EA7962FBEAE,0xDF219BC75F9F7C6F,0xDB529BD239755A22,0x7B68E00472676F34,0x99590CAAC5011F75,0x0000000000000027 },
    { 0x8B591DDE80E9BFE7,0x510DAA29259B4046,0xA6F4C61F41CFDBD2,0x6934A20EF175B862,0x2A73244068CD3951,0xCF3CA559D119730A,0xB8AA2298DF77EBFA,0x8B85CD46F78ECE91,0x000000000000015C }
  },
  { /* Point #12 */
    { 0x5419ED9AE06FB3CF,0xB454C6FB8E703EA5,0x9670AF86AC4C2649,0x365E43F40DB43887,0x1ADA3D8F00C320B4,0x1D00CBE5AAFFE3D9,0x1E99987D211142B4,0xB98381F79CB8BB86,0x00000000000001BC },
    { 0xDD2388378B1718B2,0xA8CB957E532DAA33,0x20A55F673B041A83,0x973207121B075250,0x5A70AA65B7EF4B51,0xA33056613865F77F,0x96BD1A89BD8A4303,0x507D7779FDC197C0,0x0000000000000048 }
  },
  { /* Point #13 */
    { 0x16AAD8D873F397E2,0x8CDA09D440BB988B,0xE351CD2DA881CD6D,0xB92FDDA9C9A6FD41,0x2298EFAD3932267A,0x76546625A099BB25,0xDC48A34858230B71,0xD98ECACCC6ED085B,0x0000000000000107 },
    { 0xE3BD2DE5DC95F5D1,0xB890DA1F2E2C2366,0x7C6226A1C4F26CC0,0xFC1F77BF00356C62,0x0C8E11F7D87EE6F9,0x84CC68AA0AF9A4A1,0x70EB714ACE01EA76,0xDC9E3C696ECDBDC4,0x00000000000001FA }
  },
  { /* Point #14 */
    { 0xC7F26A2FD5434124,0x7629D62516380451,0x8513932307858144,0xFA1D44BD4627A0A0,0xEBD1BE26B90A996B,0x57BAF49237F94E07,0xABE9CF16D5EE67B3,0x5AB3CB065FCE9C53,0x00000000000000C0 },
    { 0x38A153713FAEE0A0,0xFC98C0DFA1142D0C,0x9320556353001436,0x73ACBB7DA63E615B,0x8204C993414DA94B,0x2FD26BC2E8622AEB,0x86A1EB1826467B86,0xCA554D782BD1A581,0x0000000000000044 }
  },
  { /* Point #15 */
    { 0x01FD929D48D5F1FB,0x5FB11462724AD844,0x29442573707ACE9E,0x38B790BCDEF7DBD1,0xB33EEF7DD77C1C89,0x952246E9F8B1403C,0x11AB7EC0E78D9EFE,0x538AF4C702C22634,0x00000000000000AA },
    { 0x3827660D04C6EB59,0x62A02DE83CD9597B,0x57FA76F246ECE58B,0x03B9FB533C21145E,0x9E04EC45FA60662D,0xC28CC184944A4A44,0xF26C1DF341FF380B,0x6D48B57C13C7F613,0x00000000000000D1 }
  }
 },
 { /* Table #101 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xFED9B067E2ECA03C,0x34FF6F2AEB3230B2,0xDA83B96A31BC82BE,0x3B138D2CCC89C862,0xF4A27AEEEBD59505,0x29DF153A8BB49DDA,0x2DFFEC4650A555BA,0xC899108D0FEC5D80,0x00000000000000BF },
    { 0xC834E65988DA1A0F,0xB9BFBA08EEBE47A8,0xF59D33937B3A2B73,0xFFC7CB5D8DECF4E4,0x72477DD583DC5F4E,0x0A59E11E43AC64EB,0xDA8AA16CCB10A6AB,0xE571EC8C3759C37C,0x0000000000000047 }
  },
  { /* Point #2 */
    { 0xB4C4AC143FFE4858,0x3D9C1B48BAAB1296,0xB28B5F0A5791E378,0x3AA34DE82A5D32CA,0x8E90308AE76FB3F0,0xB74A7ED3C85D002B,0x48A246AB65840CD3,0xC8494718771D3F2C,0x00000000000001B8 },
    { 0xB3F57D14A28DA023,0xDBC8B8D91D078F91,0xFA5F5A7ABA67F27F,0x4908ADC3FC60DF70,0x4FCDD3E0618486CF,0x2E725571EB3C5855,0xDAFD1EF5C5D9DD01,0x806554EE19B9CFB7,0x0000000000000125 }
  },
  { /* Point #3 */
    { 0x2B6C0EF31FD309B5,0x9CF760A0EF2D0448,0x9C5D587BB66BC99E,0xEBE5D8E7ABC086A2,0x52E78ABB589F8B4D,0xB7FA2135D3B36CD6,0x5286FA97CF0922AF,0xA703ACC19AF4A905,0x0000000000000061 },
    { 0xE82D9ECA44A79B6B,0x706ABBADD825AE14,0xAAF59C1E4AD3D59F,0x3DACB4E4CE6FDDB8,0x0B975484F253EF2F,0xAE33BF3EF625AD33,0x049256C1EC2ED026,0xA50EBA5544B5CB48,0x0000000000000113 }
  },
  { /* Point #4 */
    { 0xC5F56D18FDB2DD1D,0xCB31387972B373E7,0x2FBFA499D85C69FC,0x49EF4E5504211367,0x307A9A329F9F852B,0x00BE68013D586D9A,0x6AB9C6709BEA9584,0xBCB478E24B06F588,0x00000000000001FA },
    { 0xB6D095562B1E18C4,0x2AF8B9233A783993,0xAFCF8AE678CA9E44,0x9139A8376CFEC34B,0xCE8CD219583EF0DB,0x8BF49E56ABE307ED,0x89BA853BE83C9968,0xC5694A20008B52D3,0x0000000000000063 }
  },
  { /* Point #5 */
    { 0xAAFAE9016E626779,0xDE9BED6C0084ACC1,0xA585BA05B706FC75,0x3FC031607AB4BF6B,0xA78E264462E10B42,0x6068DA6E95A748A5,0x2E139CF749B03550,0x7D92002DBCE94653,0x00000000000001CF },
    { 0x73334D5E14423E00,0xB8E759DCAF33C5A1,0x6E3953C3C9FF5513,0x198EF7973182B2E8,0x2F8D699DD49664FC,0x7F629506117AD6EC,0x23E8B6F59149E5F5,0xDDBB61C06F8D2609,0x0000000000000059 }
  },
  { /* Point #6 */
    { 0x0D8E9A7BA994A7B1,0xD01AB035EFB1AA26,0x99417D38D705E07C,0xC5C6E41559B74F10,0x995B35AC67EB2AB8,0xC78AA1909A0CF438,0x7ECF6A9FC49DDCA9,0xF72F3DE51C633B7C,0x0000000000000166 },
    { 0x4EB78FAEB96F6D73,0x53E814BCD695514A,0x25A385CD62AD9BF5,0x3012502DCA3E9433,0x684F52019295FA16,0xDDF4A21F3A1F62D6,0x95C8C6131F316813,0xE0E7009AE7B55DA7,0x0000000000000066 }
  },
  { /* Point #7 */
    { 0xD96C3210508B6ADE,0xFBF4D8DDE6DEF561,0x452B0895FA051F03,0xB2DC63993D760C1B,0xB6611865D6F24232,0x6D21C3D52A2EA820,0x043DD2C810EA1E0C,0x57A65B7046F07714,0x0000000000000183 },
    { 0xAB35EF1D994F580D,0xAEB0EFB1D6A54985,0xA90CD1966CFA6133,0xEAA90355EAE0B601,0x78171BBA4EF4EA24,0x7ED15BA8AE78D9F4,0xC07D39C4EBD06C49,0x4F90FAF07CFDD13D,0x0000000000000160 }
  },
  { /* Point #8 */
    { 0xC3974B7675276D10,0xB6E1836C07BB3D19,0x2B1BA75DB1619E9E,0x1E89C2BD5C4A2EBF,0x4C2EF54B7285EB6E,0xBA22A605DF72938A,0x51152A2657474591,0x70C745FF997713F2,0x000000000000006B },
    { 0xA7AB63790835DB88,0x2A6D5526753370F0,0x157E790A4B2E4EDC,0x0B56220A911F4047,0xDEDAA43BD7C0FB09,0xC6FF25E35A31E2DA,0x6B0EE7BFA78AB4A8,0xCBAFB78836D00945,0x0000000000000165 }
  },
  { /* Point #9 */
    { 0xCB94FB66F3CAC96D,0xD6053CB98E997743,0x5CC84357CF0C6FF2,0xC1BD23AE0355A498,0x589CF79D8F093D09,0xEFD18442830CFDF3,0xF44A9EF6005A0C82,0xD16E877AD817C05B,0x0000000000000025 },
    { 0x6C5120014AFBC78C,0x3E564AABBEA9EA62,0x4D55443B37D83DB0,0xD48CC0062E9CBFD5,0x698208C3F7B185A0,0x62D689F326DFEF85,0x589252ED3E04AC62,0xCF0675C2156943F6,0x000000000000008F }
  },
  { /* Point #10 */
    { 0x7E1F2EE46CDE12CD,0x5370F4000104B334,0x0E966C67E761CB63,0xF26B87B068E353D0,0x6B3A5EB3B812F8D1,0x785488093A6652B5,0x3BC5CAA475A6C55C,0x1593B4702F1D61A7,0x0000000000000166 },
    { 0xED97935A2366B021,0xB8B72314FB327BB9,0xAD09EC636CFB825A,0x82F270BBB0391BA5,0x729855D8525F1453,0x913367D384CFD65F,0x5BAD4E63D0637ACF,0xA6A556F6EF14B1AE,0x0000000000000088 }
  },
  { /* Point #11 */
    { 0x7E4DB891CDB4FB3A,0x14A807EE856703BE,0xE10CA35995616FC7,0x4C10D47166B135B8,0x72382298F97A90D9,0xC29B75256CBC962B,0x850C864FE3C48D89,0xD33E8B27CEAEE7EC,0x0000000000000017 },
    { 0xF9DDD1739BF282AC,0xDE0405B56763052A,0xF605493EE9FF6EE0,0xD6CDED0EE766F21F,0x67D91A2642B22BA3,0xFC20399FA7CA99D7,0x55DB476DDDE567F2,0x8B29591CFDE01B88,0x000000000000019B }
  },
  { /* Point #12 */
    { 0x537B5F578E6EE46F,0xF204223120F5B371,0xAA0921A6B9156758,0x8E7AA4907AE36AAC,0xDBBFC95DA650C738,0x652CC382EB9C38F2,0x224F35E15F0D2472,0x7768C4358367E668,0x00000000000000A6 },
    { 0xE0D7B3CFDAEF3C5F,0x4DAD6270A0C5684A,0x24B2FCA0E9360710,0xFD91B89A3E763D1F,0x822B00BFF598FD98,0xDAB869207BCA6F89,0x34DB8325C7996505,0x6E88215523F32F05,0x0000000000000060 }
  },
  { /* Point #13 */
    { 0xF905820662E57A3B,0x58E415542EB5AADB,0xEA05642B95625DBE,0x4881044223966CA1,0xA2BC2827F5ACC58B,0x4464293B9B8DF8F5,0x90C9FD1586AF29A1,0x5086E57D8C63910E,0x0000000000000127 },
    { 0x1CF9468103DF3D73,0x6228A9E707FBEDE1,0x37A321CF613FB243,0x637D37955BE97BF5,0xE975ADA9AB023201,0xD16B226F580EE2FF,0x4099752B34D78E9A,0xD8D00C0435B75DF5,0x00000000000001F6 }
  },
  { /* Point #14 */
    { 0xDBAE1C8DCCD34315,0x07155EDB7D733D37,0x05CF2191AB191DCA,0x61533A625F3D1BC4,0x06758C56767320BD,0x32715F1BB6A76ADC,0xDD3E2995B29911BB,0xC70F08ACB68E071F,0x0000000000000009 },
    { 0xD872A1ED9356A25A,0x649555A5C29F57BB,0xE09BF50BEDB0F71D,0x1AF8F4FA8D59777F,0x2DD317293B29E08B,0x26F5AAC1DCC6E4AB,0xA9E74440463A4E6E,0x1FDFA318D2BCDBC1,0x0000000000000063 }
  },
  { /* Point #15 */
    { 0x19957452BB4C6D80,0x109B9606834D7102,0xADA3C5720FF0D9E4,0x1CF741E770ECFD2F,0xA65F82E67CFF6BD8,0xA33521AE0DC81838,0x161A1362A3A25FD5,0x48EBBB94C42F92B9,0x00000000000001D2 },
    { 0x600996E5DC225E60,0x5A389FAB8B002CFD,0x5E641FD111AA4637,0x2FADB94431F0A5B7,0xA487CA0BC8CAF19F,0x671255CEFB755123,0x17E9F0FF56D6D88C,0x215A53A1206820AF,0x000000000000008E }
  }
 },
 { /* Table #102 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBCA656EB512E743F,0xCD94FC24BA4F85EC,0xF4383AD0048BDF6F,0xDB10E381587F47A6,0x47F244E7DA3EC391,0x5F337E380C33624B,0x9259425F82A3C375,0x509E56C3F276BF73,0x0000000000000014 },
    { 0x2D65148DD94CB899,0xCAC386303B28185E,0xA36BB7BDE102ADB5,0xA1E7E0B5FF3FFFB6,0xC842CEACE628E1AF,0x8E6DFA7C8647613E,0xEAFD758584ADE38B,0x7C4C0B0A00188D5E,0x0000000000000151 }
  },
  { /* Point #2 */
    { 0xE5D4DEFB5B3E313B,0xA821692C272AC52D,0x63E8DB0D853D75EB,0xE135B25B774DA98D,0x5019813BC0EA0962,0xA03D6D8F93D92BDD,0x63AD9B320EC90C8F,0x674E973C21967233,0x000000000000002E },
    { 0x6CFDFEA798494014,0xB9F9C0CE4F03D4BC,0xB30273DB8A4CDE4E,0x81DFAA1B3C413325,0xF7BC31E7B3964D85,0xF73996C8FA47FCD0,0x1D5FE418A94E35B2,0x7CD3986E9FA4F44B,0x000000000000017E }
  },
  { /* Point #3 */
    { 0x72B023245E3F9A6F,0xC889374508DEFDB5,0xAB7235362ACD0AF4,0x7CE916A85D02BACE,0xB2ABE9DD96314AE6,0x6B664D88CC74749E,0x59F417BEA5595E97,0xE77F2E3B52EF341A,0x000000000000003C },
    { 0x1F57CEBBE3AA5B6D,0x870522A68901CD97,0x926CE7D957CF5E3A,0x2D8FC69331E15A34,0xC3A756AD009B6274,0x498748F3F82857A8,0x7B27D095B5531159,0xE2783284C7E359A7,0x0000000000000082 }
  },
  { /* Point #4 */
    { 0x78D9E7F446045461,0x841C793E7430D61E,0xF77B63B8DD245666,0x4B39BDD5844F837F,0xCE7BB287AB70F0F5,0xEF4B6AA274B7CBC6,0x9821F978981FDF5C,0xB63E67A8E506A31C,0x000000000000012E },
    { 0x1D2296041FC1DA54,0xA5B7E873D0C4B6BD,0xEB72B87BF59127B7,0x8DB0F3859FBC54B7,0x534EBF9461462A53,0x97099E7580B9D20B,0x0ED2D96A88AAA712,0x415CA08A6A1B85D7,0x0000000000000091 }
  },
  { /* Point #5 */
    { 0x039C81F5B6501DC3,0xBEAED737D507075B,0x080BA34A5C367A46,0x06A583C5ECD54633,0x2085119B20EFF4CB,0x26F27B7AA193A015,0xA2DD99C937B34FB1,0x99227938FFF66C7F,0x0000000000000107 },
    { 0xEE87C18E1CEC40F8,0x760E880D65532DA1,0x78D00F69BE9ED489,0xF61114948CC9BE51,0x79D826ABAAFD71E2,0x831BC3059F39CD9F,0xFFFEBC7EC214629C,0xAB14A5CDC0A202E7,0x0000000000000083 }
  },
  { /* Point #6 */
    { 0xC1B7A8F704DE7536,0x4B9E69438570DA46,0x7724C0C2337106BD,0x6F1367D3054B2F07,0xD7D30E2004200225,0xD722D2FF8573567C,0x3B1A8A31741D03AE,0x41474E1B878FF79A,0x0000000000000059 },
    { 0x3CE983C9FCF8A2FB,0xE3C71ED67940D19E,0x7347AF8B434DF786,0xA187AA1D08D0762A,0x618FC81D48CC16F9,0xFECC62573B0E7F5D,0xCB1F9E26FE7D47E5,0x9DDB1566CE3918A5,0x0000000000000047 }
  },
  { /* Point #7 */
    { 0x810305AB4F244783,0x99471C5A0E2C1A83,0xBB3BEEB39BD2BA8D,0xE7FE7B929C189A01,0x0F5A31C9667F8683,0x28EE1A59FB7BFBB0,0x4CB86E098E14240E,0x47039EC29BAB970C,0x0000000000000183 },
    { 0x09B761F8F4EA7190,0x5B109E93637F19C3,0xE40AA435EDD588D7,0x6B25737881A3B4AE,0xF5B5CC60591F5CAE,0x2E787D34811B80FE,0x28BE1DB7B0D84075,0x2579D623A4DB6982,0x00000000000000B8 }
  },
  { /* Point #8 */
    { 0x48A6060B5244ADF3,0x196C42F99F9C1646,0x1DEA9FAC3946D4DB,0x30563642183C46DA,0xE5C58915C9E4A634,0x3E71B542CCE36F63,0x4D91D55C39EAADA5,0xD3F5AF0F1C43907F,0x00000000000000C4 },
    { 0x1152F1413080DB73,0x3D5031A2B4BDA7AB,0x0DF9C2BCD0F0DAF0,0xAF4AA1F30D01895A,0xFE8281302B137ACD,0xFCDBFEFFF072EDA7,0x8F3E313911D578DF,0x37D9CE5B92662C8E,0x0000000000000086 }
  },
  { /* Point #9 */
    { 0x164A9E29D07B0D60,0x7D9325BC4A4CED37,0x389846410A22EA31,0xC33E1FC1659C12AE,0x7609475678CC3AD9,0x3C30033A4CF14874,0x6C7ED92D23F58493,0x0040C6D99A41B806,0x00000000000000C8 },
    { 0xE9652D66A4F89D26,0x97ACA7AE1E56DAA6,0xA1650F15B8B76045,0x2F2338B3FC159585,0x9AF48930F243CF7F,0xDD333C3D923DE549,0x415A035F3083991D,0x0257BCF5B8F179D8,0x00000000000001B8 }
  },
  { /* Point #10 */
    { 0xFE306CA855A073EB,0x35543D282DCAB16B,0xD66BC457A45D0B9C,0x3FDC1CC24BE414DA,0x781093DED7D9BB1A,0x6B5F2C375D2031A6,0x9B6B4BA38A23513F,0x6FE788858F5A91F0,0x0000000000000188 },
    { 0x0F952FDEAA340993,0x860AD393381382B9,0xF0F1878AA611333C,0x9D53E1F9FE29F16F,0xC371BA5FA0D105E9,0xEDF4ADF826128FD8,0x4F4E22FFDAEB10C8,0x0D27B149D9544E7A,0x000000000000009A }
  },
  { /* Point #11 */
    { 0xC0135E27BEB6745B,0x1FA3E9D57AC01E8B,0xA713CCD34EFAA6AD,0x6B82414232492FA1,0x1E3DC6B3C5A1550A,0xE3C7EA75429F42C3,0x93F0CADBD1D97ACA,0x7B23EE53F7091927,0x00000000000001AF },
    { 0x708DC83AECB37A50,0x802E69B38F9EDCAA,0x02ABCD3CC66D3A68,0x814EC38B1101AFAA,0x20E5D950A1B52623,0x0AC6EA5FD4DD624E,0xAB26008227A0C3B4,0x577F5CA09368736B,0x000000000000001F }
  },
  { /* Point #12 */
    { 0x57B087C3722F09B6,0x1702CCF501659998,0xF3E88554769FF3B4,0x0CEAA311B9B58B5F,0x3200928FAF05BE70,0xD7254305405C2F75,0xD48BC6C28CFF9A05,0xC951C65D71AAF653,0x00000000000001E0 },
    { 0xB1C60C62E06A762B,0x95D42294D121D094,0x16B88A5DD0A2EC1B,0xE5BAF8F2F27AB833,0x81982EB5A7742D30,0x0244C5595E8D4A52,0xAE2E0D639FF0933B,0xCAC9C143C0641FDC,0x00000000000000DF }
  },
  { /* Point #13 */
    { 0x66CB0DB47C4F8F4E,0x81AE6D75FC21F5F6,0x19E8FB8714951A87,0x52ECEE54602C5224,0x50A823A8E408B25E,0x32AAD7D9E372C922,0x80A117C8E03A5CE6,0x9B62059C2CA7F6B5,0x00000000000001B2 },
    { 0xC50397739D676975,0x6959C6B5BECFC0F0,0x7B73318A43D30B32,0x0C0AAC5B6048CAFD,0x77F3201DBA7D3C59,0xA5A05D3E09004FDD,0x711B1B17ADA3810B,0x0B9F7679A6EB6D1E,0x000000000000017B }
  },
  { /* Point #14 */
    { 0x3F28171BD3179895,0x91EC9BDD6470FBE0,0xD6713024AA1AB0A3,0xBDB9E60388393838,0x29C6D976170FFE51,0xB415CE2C20C85E4E,0xC816B042AA9A7F5A,0x0F7257DF41DCB044,0x0000000000000139 },
    { 0x16044C1463DBE97C,0xC36A41E8DCA02DE3,0x7C9403766849E580,0x77B372D1D1BF053B,0x539E249D175C2A6A,0xEBD056BBF0E17332,0xF7B71BF6E62C02A3,0x8E8636D754EE354C,0x000000000000014A }
  },
  { /* Point #15 */
    { 0xC543163D23D30FA4,0x45CC53A2B32B27C9,0x894B9CA07953C4B4,0xAABBA057BBA613A7,0xC50371AE6CCBB39D,0x610CDCF53FD4F3C3,0xAD08443A19A9D357,0xABF74787D519C9CD,0x0000000000000076 },
    { 0x4EE3A817E5502AE4,0x7AB2462D8B39A71D,0xD6736EABFCFE642B,0x77479BAE25C914E3,0x95FB92AF2A14E2C0,0xCD33464758BD112C,0x3165B9A35BC0ED8B,0x980F3176D89BF952,0x000000000000006F }
  }
 },
 { /* Table #103 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xF7593760E63885D6,0xCE5054BB86E546CA,0x5910AD526E9567B2,0xE812CF7BE420AFF3,0x266049FD904E9676,0x42D0E2AB2C8B34AD,0xF79F8F91A4382F29,0xF8CDE3ED41D531DE,0x0000000000000035 },
    { 0xE514497FB16CC1F3,0xBC044F39627DB2F6,0x76FA5148A1FA2BDC,0xCF7EB72E5FE3FD7A,0x83236C11EE3D45E6,0xA02D7E92C4EDDB54,0xCFB5BB894D4982A5,0xEE6AC2A27C217EA5,0x00000000000000BD }
  },
  { /* Point #2 */
    { 0x1E5E42932F3CDB19,0x9920316787214E3B,0xBA80FBFE93D885A3,0x58F3ECACB25A2700,0x2C4A14D369F5D172,0x478313D4816EBAF0,0x41018D31C93F7738,0x5DB7131E06AC6002,0x00000000000001B4 },
    { 0xA5D3687295B8EDBC,0x47931810945B9473,0xEA5B3FFEA82C5F49,0x5ED84F08F491BC9B,0x1492E5349B3B994D,0x4788372DDA6C1225,0xFDA4521440022D06,0xFB0BCF49FBCA3D03,0x00000000000000A5 }
  },
  { /* Point #3 */
    { 0x38FF6EA35751A4F4,0x0D3B2CB10F0EC448,0x5BC5BAA393A502C0,0x87D6A136C62E3061,0x1B970DF2130F3523,0x89787BDCFD691595,0x0C8E0A70517EF324,0x3BABDBF697924054,0x000000000000008F },
    { 0xD425EA77491F0B40,0x9C214D2B5C253856,0xF74A9B15DBB65488,0x87369E1D17BED5D9,0x67CC0214E589A38F,0x6A141AB9BFA1E6E7,0xA3253AA2D193C133,0xDFF0A10F7E63917D,0x0000000000000057 }
  },
  { /* Point #4 */
    { 0x8A4AF8AE25144121,0xD89467B7EC215026,0x3AB6CB7FE013FBA2,0xC15A056935F18F1E,0x8BD48A1D70933BEA,0x6A40474A5B8C61F6,0xAD967B15B5158AFC,0x119A0EE96D7F6E5F,0x000000000000010B },
    { 0x895E3E94A548551E,0xFCFE2882EB65FA7E,0xAFA1800F3582920B,0x5CDA388EBF58E02E,0xE7AAD6F7FB270F11,0x95A2636FB7E27667,0xDEC591D7A3BE4195,0xDE0E7440808C1315,0x00000000000001B5 }
  },
  { /* Point #5 */
    { 0x641FBE08517A4CD0,0x71973104890D5388,0x390AA2B5B3E7BD17,0xF9B38BD41F861153,0xD2617A1842796670,0x7D3C4EBEFBBE6DC1,0x418D3DA1161342D4,0x3009DDA825BFF257,0x0000000000000089 },
    { 0x04888A4D6369DA47,0x10975F89F9BC50E5,0xFD1BDA697415D98B,0x978021E9DEFA1DBE,0x4AF400C90B97FCD4,0x66EB174E062345E4,0x5A8E92D0643339AE,0x2E36B35E1EBDC132,0x0000000000000176 }
  },
  { /* Point #6 */
    { 0x57B9DA073A771403,0xDE6EE702AB21FE58,0x60D32DE6843AACAB,0xE522B9569064DFBB,0xB4B429207EA0DCAD,0x4222697AA3F46A45,0x1557D30B3BE7A95B,0x712CA7479FA83859,0x0000000000000153 },
    { 0x162516D415FB1AC0,0x44B19CB0EE7BE87A,0xCE8815EB3D9D86B1,0xCE8F13F957331615,0x78E8539EF71FAAC1,0x29154B098E5CA8BC,0x45B36262312E4C96,0x2E03EE8680940F73,0x00000000000001C2 }
  },
  { /* Point #7 */
    { 0x081FE748D6FF5A2D,0x52B184A6B93AFA57,0x83C0C66646E11AB9,0x274DF41F5350A841,0xED23080B4A3FEE0E,0x4BC1FB50BF0ABB4E,0x4CA11F49A37D4E7B,0x3A7284A1BB6C8307,0x00000000000001B7 },
    { 0x340E4AA02A535E97,0x6A0F970001A36DA4,0x140F467694F67DDC,0x81F3A13851D24551,0xF89307651F5481CA,0x23007EA9DB6865A1,0xB37376C99C46AD26,0x53C8F29CC2FA4CCE,0x000000000000000F }
  },
  { /* Point #8 */
    { 0xE95AB9E7EF05EF2D,0x29EC067FFD5CC417,0x67C10BC739402B0A,0x109F7D511E9CA8AC,0x0B10550BF8EFE529,0x0BF3624CF18C8DEC,0x42F686F33746474A,0x0F8A831140052446,0x00000000000001F4 },
    { 0x56303452329ED806,0x1D80C752654F22D9,0xF41FE1729F61F3EC,0x7D4AD71E0CD5FE42,0xFFDA94ADDD164DA0,0x260A2BDF7F19C583,0x8E8673245D6229DA,0x1D13D05C2FC87AE8,0x00000000000000BA }
  },
  { /* Point #9 */
    { 0xDB9FBE3028B6D103,0x86C8C5369836F57C,0x2B984966968479BB,0xCAE8E0FB6FCEE1A1,0x5ADAF93983921A02,0xB2334045C9B9E566,0xFE27488E7EF59B61,0x39B23FE7B5C12BFB,0x0000000000000001 },
    { 0x404D09A2DE3DCBAB,0x98C35151B96C7834,0x41C735E76ED3ABA8,0xF131563C2E085B3F,0x3FCDB43D4C57DC30,0x76BBF46B2B8C88F2,0x5B3FC2BC086605BB,0xDBED081B4AE0EEC5,0x000000000000012E }
  },
  { /* Point #10 */
    { 0x5750D281B1734753,0x0146BC94D4A13019,0x44C6F69714E0F6A7,0xBE893E5AED528E03,0x1E980B908750B50A,0x7EDAF7FCA9DE6CC1,0x093CD32FAEE636CF,0x293D801A61A0B0DE,0x00000000000000D6 },
    { 0x154F8D1810A54F0E,0x8A0E70EA4A976AFA,0xB2FE0D041D2E4D9A,0xC6C5AFBC6229B256,0x8D0CA0E734BC3BC8,0x93D5A4CF47A7A58F,0x5413EC8FAA6E0B8F,0x1DF389C48D831011,0x0000000000000099 }
  },
  { /* Point #11 */
    { 0x4877FE63E7F0E20B,0x7B15FE9F80797905,0xDE885B668ED95A20,0xAFDE40491D118489,0x160472C715D8E92E,0x411DB3FF41E49D5B,0x01001883B0E083F7,0x11AC87E430B9CC65,0x000000000000008A },
    { 0xCACF26480A716A17,0xC94CD8A6E7493E70,0x1DDF83FCFDB4F637,0xBA2EE5E3D36B3A34,0xFBC233155C706FD2,0xD9EACBDB6B20F13C,0x5551B49B2FCDD5C4,0xF490CADF0C6351B5,0x000000000000002C }
  },
  { /* Point #12 */
    { 0xE4F52EC5BA7DCF59,0x345C1385D5DBA9C9,0x67084813D49A6201,0x0C8C4FC84EE78000,0xBE78C6A4E17B9868,0x6698156608377738,0x1AFDBF526012A726,0xA884B8F7D2127133,0x00000000000001A0 },
    { 0xA4AA47B66590BDE1,0x32398FF9823EE7CD,0x3F1F7E49967C860F,0x0AC197D796A0E601,0xFC6A28C6E61A3207,0xBE5CB223FBE09F61,0xE83DB350D54BD1B9,0x44334C2BACA898F2,0x0000000000000024 }
  },
  { /* Point #13 */
    { 0x80C63FF253BEF9BE,0xA729D48AB39166FC,0xFC60D268B9D7B998,0x7C389CDE5BAB10F8,0x238CA02840EBD2E6,0x1D5D88AE177459C0,0x4D35EDF56A0EBA11,0x8BE1CABDF51702D8,0x00000000000000E8 },
    { 0x2E38FC9EAB511547,0x5CBF5B8587733483,0x721166A07B06B4F1,0xA80EC106AC421E3A,0x2ECDC59A1A32F6F1,0x74520FF46B144B54,0x41A1EBDB493F7D27,0xF2D3501AE95B5128,0x0000000000000065 }
  },
  { /* Point #14 */
    { 0xDC7ED009B224AF29,0xC73DE9D40E9ACB64,0x81FBA2D377629EC2,0x2F41756AA44AE9B4,0x7C839101311C713A,0x608EC3D486C4C015,0x6A8379C0EE544E59,0xECD19A437A67B442,0x0000000000000062 },
    { 0x05112F63CAD5BE69,0x9B97A7F150C4E5D0,0x8744E98AE7E2D407,0x9359564016AB7F96,0x87DCF03CDB24A32B,0x2F9216BBABF80AE0,0x38DC2B86701A21E2,0x60A15B35E64EC8DD,0x000000000000005C }
  },
  { /* Point #15 */
    { 0x3F285D1DC5F4DDE7,0x3C1FCD5600D79435,0x01BEF8FBF6570B80,0x33E600A630D58ED7,0xFA4CBED921E9882B,0x1B9EEAA7D7D39D84,0x9FCA4DBFD7B2D1FB,0xE13B1519CC4AAABD,0x00000000000001C2 },
    { 0x66A754AEE193D7D2,0xE3C882420E8C174F,0x28CC71CDDD625328,0x421380489BE78C6E,0x5C0BAA8B6B502185,0x39E22BEA069B22E8,0x6EC0D474885429CD,0xE7473034681C705E,0x0000000000000172 }
  }
 },
 { /* Table #104 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x141838BF8FE6F511,0x8E9FF343EE745E2E,0x71DA9FD502325306,0xA527B9BAF0D0D68E,0xCE19B22C31144649,0xCA9B778B0BFAA46C,0x66E689A76CE31145,0xED43460DD8D1DA21,0x00000000000000BF },
    { 0x241323F7C1669168,0x9934B3DE79B94B5A,0xD332C1A2D9F9A406,0xBE3EBE21E4A49EAC,0x4A00648E678BE3ED,0xC9F534EAFF09DB31,0x2DE774065EFDD859,0x2C218CD800F5C7A5,0x0000000000000152 }
  },
  { /* Point #2 */
    { 0xFE1B039AEFD5CF86,0xC7FBCA26C0945B5A,0x6B30E2E0887A27A1,0x0883A38BE7CC98D9,0xA646C35BFB2138F5,0x735769DF74F0C200,0x9FCDF60A2AB20E1D,0x4E0ACC801F2E11DC,0x000000000000013A },
    { 0x00CAF22515ABD8EA,0xE5F47384CB2E6E92,0xA9186F93BE14FF19,0x4620D2C916CA5BB6,0x22D4FC0EBDDDE27B,0xD6F04A09A1C81269,0x25D65811FAC277D4,0x803293DB322AB775,0x00000000000001E4 }
  },
  { /* Point #3 */
    { 0x323E1B7F0A823516,0x8F4E9152673254F7,0x5E5D719041599B9C,0x96BFBA24A1198ACC,0xB1B6E75BBBFCD72C,0xFD5955F2F4894626,0x109EDFEA898BBBFD,0xD36929041F468074,0x000000000000016A },
    { 0x089D12A99BB7D749,0x893EBF254FFC33D9,0x6ED72C609097FF49,0x9291E1EEB4E1D91D,0x0DBFE58272A07882,0xAC41065FBE0636EC,0x43D74F8BF4234BD5,0x01BFB0850A28FDEF,0x00000000000000B5 }
  },
  { /* Point #4 */
    { 0x9D0DBABB1EC238D2,0x3F6C4AF337E67E7E,0xF7A6B09464DEC6E9,0x1F53FD502C2724CC,0x5F333D4751BCAA0C,0x63CC89BAEBAE3589,0x2B90AF90F0632831,0x8F6AF6CD4D18CFD3,0x00000000000001CE },
    { 0x8B34E44576940E65,0x264A0D8FC1C34C11,0xD433303F4120AFC2,0x240A12D6F7E738B8,0x574FA7156E921883,0x6B2BB33C02D74E8C,0x7B193E240FE8E9B8,0xBE954BAD506CC6D4,0x000000000000011E }
  },
  { /* Point #5 */
    { 0x4054B365D1A4A65E,0xFA395E2AA04B2F59,0x1C6C3B41BF63D17A,0xA639FB26ABE2AAD0,0x008F81600C9A565D,0xF5EFA9E691061E61,0x7731C2F76E881F7F,0x3623CD7C9074B4AA,0x0000000000000016 },
    { 0x20BA924B1037873E,0x7B7107ACABCFD34E,0xB492EBB905E13406,0x6DCC3342F08FD2FA,0x08F3A1D364126080,0x8FB54869FB5BF009,0x5E66163282442DCD,0xBAB2D8DD5C21D62A,0x000000000000003D }
  },
  { /* Point #6 */
    { 0xC296B1F684C1985A,0x971547C5AA4F7132,0xE3705E1183E168CF,0x8D00E588C935A3DE,0x853154235262789B,0x46F2C2CA005F7C35,0xFBFBADD217EA733E,0xB32A38B6C9E496A6,0x00000000000000D8 },
    { 0xA82E95E5CEC8D3F9,0x8A1EFCA3E378BE9D,0x6E114D078080D874,0x514DC754FB9C056A,0x5781BE8966EF6C48,0x0586BD3834B1EBE3,0x0E31B44F8A8B161E,0x20C2B78AD4D62DD5,0x00000000000001DB }
  },
  { /* Point #7 */
    { 0xEA6E467AAEB0D0F0,0x9FA030D9EB5EE813,0x9BE99873515CDBF8,0xE608DB63A805D16A,0x5E6255DD9CE2F64B,0x2D88FB427418BB31,0x147C74FEE7AC60BF,0x34DF0171672B0F90,0x000000000000004D },
    { 0x6C1F267177F1F4FE,0xF64D4242138FA188,0x55AB5DDD4C0097CA,0x354BB5F3BDBDB465,0xAD6142D579060E68,0xD9ADC1101017B5FB,0x656FFC3A9F510299,0x568945BD741EBE49,0x000000000000009F }
  },
  { /* Point #8 */
    { 0x61D252DA63D7540B,0x5977687DBA87605E,0x53BE7D04F8F3558E,0x76C4C49C99F1AAF0,0x129E0BFFCE8BF731,0xCDDE32A166A1555B,0xEDB9E9E5D4BC5B6A,0x675B5D1252BC3C6F,0x0000000000000130 },
    { 0xFB3DABAE91B491F4,0xEF1967C39EA0B6D1,0xB68A0E75E6370D8E,0x6DD017FCE2FFB7B5,0x7E3DC82606D66169,0x802B269056271658,0x117A4EE3C3DA3C9F,0x80BB9FCF167D09AF,0x00000000000000D0 }
  },
  { /* Point #9 */
    { 0xBECFAFE5D08376ED,0x9D8FD1DFE8BBF04D,0x2C9227DD8273C85D,0xC6EC87E24B542089,0x37EA5B01D93A3086,0x46D6DEE3A030E39A,0x5418C1FB91F41864,0x97FD2D3B10F9C3A7,0x00000000000001F0 },
    { 0xC4A32D07BF623C8F,0x60D66908B7EFC74B,0xC835763B1101A44B,0x7E8D41DA2569F191,0x71F8A1492A8E1F58,0x1EB616ADBE62809A,0xBF834D7E3CEB0C07,0x16A16C9863B4593C,0x000000000000005D }
  },
  { /* Point #10 */
    { 0x57F6D51A3F9DFBBB,0xC6780A54F5B39374,0xB9E79BAD6D7B67BA,0xAA4176479FABFE2E,0xFF7A9CF51B27A448,0x7635359762DE5809,0x58F2C604CE188EFC,0x6776ACBDBE3E93BD,0x0000000000000077 },
    { 0xD80F5D880F48AEF4,0xED72B64304CFDE9D,0x52618BC126BE0C74,0xF4DA45819478B14E,0xD23B320E95B9326C,0xF5445D38D17A5A92,0x1738B5B2BBDDF55A,0x96C1705A8EA1ED83,0x0000000000000170 }
  },
  { /* Point #11 */
    { 0x6BE30296596537B3,0x2728CBB51493A353,0xDA2754F8D9C477D7,0x696B71533873A14F,0xE7CD0B952743C148,0x989A63BCAADE8ED5,0x68FB4ED906306D91,0x76AD939E45E756FB,0x0000000000000150 },
    { 0xF1B67D3EC9179F79,0x65908602C850A05E,0x39AE1AEB7E051E15,0xE20EB4DD3AD0FB2C,0xBBF80215105C48B3,0xE86607CB34FB1968,0x68148E18602F86B0,0x2499C3570B4E1323,0x00000000000000D2 }
  },
  { /* Point #12 */
    { 0xA588F38078840393,0x6A7324D2B077FD47,0x5873E0CA9AEADF69,0x4D88F98522539602,0xD45F2661C3687C3D,0x321A2F1B9B5B49F9,0x856F0BF4EAEAA532,0x3D464C0C860EA431,0x000000000000010A },
    { 0xD7E7D05A8915A01F,0xD1D4C7E03F592E9B,0x45C3CF11EE2FAC20,0x0ED2BA5AFDFF57A3,0x81F957DE85529D6D,0x444694162A7877AC,0xADA819A4CC653AFA,0x573B8999A40ACFA9,0x0000000000000117 }
  },
  { /* Point #13 */
    { 0x28865B78CF6F524F,0xCDE1470CF3ED59EA,0xFED6EF9B148F71A8,0xE395C472C75FB43C,0x634ED2BDB869F7FC,0x320F5116B44B76FF,0x4F2924687A90B7A6,0x787347DABD5CE154,0x00000000000001B5 },
    { 0xCB578E4029750F3A,0xE87F3E4C99873ADF,0xD62209FBD77FD99C,0x88F0E933F66AD010,0xD380CC9CCDBC9565,0x65F739F9D67C1A15,0x2F3BF773D1084088,0x5888BB178B89CEDF,0x0000000000000174 }
  },
  { /* Point #14 */
    { 0x56CA044FD1E8A048,0x702030BEA5A8DE4A,0x83B0357115EA4E25,0x1A4E5359B0C9B88D,0x9CB8AFDE0ACB1CBF,0x1A6C939914D01905,0x0D96D16E9F463DB4,0x2F3BFC9D79629F34,0x00000000000001B7 },
    { 0x69197055A4E9FB59,0xDD7BD8F41BE8C22D,0x88CBAB968C4BC336,0xFC37042F4E462760,0x11D8283CD36C4660,0x507CF609C1D3D85E,0x53D5E84A246F5A00,0xDCDC58730A067256,0x00000000000000C9 }
  },
  { /* Point #15 */
    { 0xA7C98EF52D68B61A,0x6897A00E0195DE0E,0xA64006D1CF3BDA7B,0xDA27E467BA7594F8,0x349AE42DC08DAF52,0xC7D94AC6EAA0103D,0xD46C2D605A8AE089,0x778292C5BF007687,0x000000000000000C },
    { 0xC7E7ABF9D8DB722D,0xE489A8EB852672F1,0x2DE40F86A436CE5E,0xC09FF7BD6D7B8223,0xFB65ECD934BBA02F,0x2DC839CD964D0137,0x1C0F119DC9E27EE7,0x21084DFA8F8B3C4D,0x000000000000019F }
  }
 },
 { /* Table #105 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x73A6BA3810A8C4FB,0x5153D959ECC93E5D,0x7CA58012B59E9871,0xEDC0DBEFAFD442F1,0xB9050A22B9CF7691,0x3D1E96FE464D017D,0x541781A482074DCA,0xEDCE0DB38B355413,0x000000000000006B },
    { 0x1A13E3EEAE2B39C2,0xC431081D3C218179,0x5CBC14C1AE68B7C6,0xCF2559BB9005A304,0x14D7C1E92EC7AED5,0x5C379BFE1E2E2F0D,0xFC33E4D2886F0CF9,0x2F14E7D0AC4E1D17,0x0000000000000071 }
  },
  { /* Point #2 */
    { 0x27E639C92C82D5C0,0x035527B8104B9D44,0xD0A7F3C88A17BE05,0x3C529B91813CB246,0x296074B2B8E54B08,0x660118578DCA703C,0xFA30E9DE41606A8D,0x2652C08C9AD1D94A,0x000000000000006E },
    { 0x09724BA6D42D26B2,0xC0A02C2E25EECAB7,0xB004174845E7FB83,0x24E80B604503354E,0x4F3045F9DA55516D,0x97D76335CC7B2627,0xC8BFD79BB380F10F,0x987396522BECBC27,0x0000000000000146 }
  },
  { /* Point #3 */
    { 0x9394910F0093FD88,0xFF7760D2547FC3E1,0x7B81FCF5A904C24E,0x120A558DFD80644C,0xFAD07009A715D6FC,0x24BD3AD8ABF6246F,0x7C5B04C779C968A7,0xC7DF9266108AD586,0x00000000000000D3 },
    { 0xE37DB2E0B655B6E1,0x0A029277568C6373,0x0BD0526F428A6B69,0x54BD7B9B3D4F3847,0x42CACA2FCB6BD60F,0x657B0F1F6D10BFA6,0x97F9F99D0FEF238D,0x93171B4DCC3795A8,0x000000000000009D }
  },
  { /* Point #4 */
    { 0x83FA275B0DDD2BA9,0x71F5B43DBADDBDEE,0xB67814112244290B,0x075580601244C56C,0xFDD85CCE2CE4FC6B,0x7FC52DACE53B1502,0x3243B95255A68467,0x06EF6A6540900CEF,0x000000000000009F },
    { 0x562D06AC65457F82,0x9DBD63519A9E8E58,0x0D218265496D9349,0x940BF3F4A218EC30,0x1E9C0AA3D605883D,0x2CB9BCC6427F8A5C,0xBA3119B23685376C,0xFC2C2F0DF0C5783F,0x00000000000000DC }
  },
  { /* Point #5 */
    { 0xB7B63D0FA73A1AA4,0xFADBA5955532EC0F,0x19A61405FF9E47D6,0xD9A44EF1AA210AFC,0xCAB8BD2C3C3E2B07,0xDD8F8D154E1428A8,0xA5EABCC591F63FF2,0x7DD9635666F368C9,0x000000000000018A },
    { 0xB35C9E17D84C056D,0x0F27CD01EDDFF5DE,0x855C10A92C0D1066,0xC7AEE7FEB4BFB648,0x9F9D978D5803338B,0xFCA5A25F4F4F2B95,0x9D5D5FBFADF37F8A,0x13482B1E5059C65C,0x00000000000001A4 }
  },
  { /* Point #6 */
    { 0x6E95A3AEFDA1FFDF,0xC4014EBCEA5AED3B,0x915719F862B64816,0x2EA08A71DE90B2F6,0xD2B45D301B4836DF,0x5647580021840212,0x169110F6FFCA7E1A,0xB32EE8A9F5F43DFD,0x00000000000001BB },
    { 0x7BA4DCD71962C792,0x539FABAC5FDDDA2D,0x48913D37CFC7B6C2,0xAA2E0FB009D93B9F,0xA625455B63F79F1E,0x0F26F80B7C45060A,0xDBA77C6793EE96FB,0x54BA37408711AFCB,0x00000000000001EE }
  },
  { /* Point #7 */
    { 0x95DA54447500F10A,0x6935CA2AA6B14D2A,0x58F4555C30DC9660,0x949EC82AAC954B30,0x94027576E7FA5C4D,0x035D525A21960C7F,0xE3ED1E66C2092C76,0xBD151AA3DF9779A1,0x000000000000012C },
    { 0xDA7D7C3DE59368FE,0xB4C240648DDCE4FC,0x05360BF847EB7A34,0xE0889804700D30FD,0x99E1ADD207F447F6,0x30E5B7574A4E8762,0xEE9F06953329B2FD,0xBB6FD0FC6894A597,0x00000000000001A6 }
  },
  { /* Point #8 */
    { 0xB70F255CEE12880E,0x0FCFF02402831C27,0xD92706FE87241978,0x75C7A550FB475DAA,0x128971BB889E3BE2,0x032C8D2651F95444,0xABE4D7DD7251B1C7,0x8C903FAE332E627C,0x00000000000001FA },
    { 0xD00F7BFC32B6FC85,0x33EBF5C256E1CD16,0x0CB224FD42B24457,0xFD0D2136A0EC189C,0x4718B1736CCE225D,0x403528F6E04D9E2D,0xC7312B00E6E6E81D,0x3D146F6002202A72,0x00000000000001B1 }
  },
  { /* Point #9 */
    { 0x1A20556E1034BEA2,0xD717D9172BE51DF5,0xE95F091286AC317D,0xF3923FBEC1304EE3,0x3F763629E240F768,0xCBF933BCC8C2AF96,0x0E7CBEF612C667F3,0x6F01599295D25E69,0x000000000000012F },
    { 0xF941627F4B56BDAF,0x06EE3B59EEC4ED47,0xB2C0882E4D951B00,0xF5304C7C8652DBCD,0xF59E2884A6245127,0x2F9752C14E4444A4,0x91D5FA7AF8DED8F5,0xE5BDE5985C3A5632,0x000000000000003D }
  },
  { /* Point #10 */
    { 0xD9E55A11A0D1BE9C,0x4C3BFAF24C1C1B10,0xB0D8BA7D2E8BDCA5,0xD67631C3E2B2F07E,0xA7BC810F085DC2AC,0x0DF53D51EA54ED35,0x09CF707235BA17F4,0xD6BD518EBE70853D,0x000000000000004A },
    { 0xA7CD3940B78C4776,0x9BA0F564E9BE7CA5,0xC40944C61C45432E,0x44FFF573472B1ABC,0x80EBAFA1C1EC6836,0xFF7EB86E0C55F71F,0x20C8E2695B805B7C,0xDF0E571B16AA5EEF,0x0000000000000199 }
  },
  { /* Point #11 */
    { 0xB765A24B2AF340D9,0x958178050B487CDE,0xF2B88C2CF47F322A,0x7FA33CE51EE6FA6C,0x98002C9A11A0096E,0x5507EB0BBB6E514D,0x7B3DD65C1A52BDCE,0x80A29CC867BDEB7F,0x0000000000000069 },
    { 0x0CDC241D6D7C8921,0xB1506BFC039A455F,0x14ECF2F7EE18C2BF,0x3317BA71027F00FE,0x2C12D6706662FD91,0xE9CEDBFD87D5376F,0x3E0F51B5B3BC972B,0x2450C347B2C1A068,0x00000000000001E7 }
  },
  { /* Point #12 */
    { 0x484732401F8815A7,0x46168826199E1B61,0xBB9A52BC07807F97,0x7B3824D9BA31351C,0x67CD58B460A2DA3C,0x0D99D6D621957903,0x7C3380D37B459B99,0xDD0A602353B07588,0x000000000000010C },
    { 0xEBC49BC0AB2213B8,0x540F6FC558615CCA,0xE873EE56D8BC64CF,0xAED30C80FFE085B5,0x03D39214D0DE645D,0xC6EC44B959F64E2B,0xFFAFEF87C7F37E31,0xEF7985A21EA39C70,0x0000000000000159 }
  },
  { /* Point #13 */
    { 0xCDDB65C37F55B79A,0x6E26C45F5D85B33E,0x111919CEB1470ACA,0x7AA294E0E6C06007,0x35207DE63C009509,0xCF119448DDD0C472,0xC01BF29C3C05546D,0xADF8465854126FE9,0x0000000000000054 },
    { 0x2C13D69DFEF83427,0xE539C2DA0960AF28,0xBE374A8297CCC699,0x8020D224523D7F91,0xDAB7F7D6531B6154,0x37AE51127CFAAF1B,0xB5E3E2036F69E8A9,0x4291B0454B708B58,0x00000000000000E9 }
  },
  { /* Point #14 */
    { 0x4C085162A78092BE,0xCF80206180D90634,0x95C122B69F81FF39,0x5C936CACAF784312,0x9F4796AE350BDE15,0x0FD2EACAD138A2F3,0x5764F1CEC825AE43,0xC9B9D5EC9B4F1332,0x00000000000001AD },
    { 0x3049E55456C15C19,0x61C0DD81E3FCAB36,0x2132D9B2376E573B,0x875184B1C05EE74C,0xC37F8E51A427B9E5,0x6A2FB427E6C5B9D5,0xCF13C1EF7B754328,0x146447F8D1749292,0x00000000000001E3 }
  },
  { /* Point #15 */
    { 0xEB3388479418CED8,0x68F55B32506ED21C,0xCCDB0BD335EC2DFD,0x63B075E8B65F515E,0xD3D07AF8F6905524,0xAD5A170AD1589131,0x97FFC56D61582A3C,0xF15ADD9A34C2D2E4,0x00000000000000E0 },
    { 0x79D0330EF5D91B62,0xF3E8F69CE46EB580,0x1B5EA4A8067E7599,0x425084336B335559,0x85863C2EB4AD41BD,0x9572CD16AA1DB8FD,0x55756BE84F205835,0x82ED485F53DE8F6A,0x0000000000000049 }
  }
 },
 { /* Table #106 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x7D6E42404E1080A4,0x5CF6C427E1ADB078,0xE74EC6033D594E28,0xC0185404BDF853F2,0x287D94DEC3335717,0xF735656AC3179807,0xD356F2BF604E93F7,0xB1FDC2F2CBE27815,0x0000000000000151 },
    { 0x7B17E356DA1D3EA1,0x0ED57D7EA7AF9610,0x4A6AC3E53AE89C0E,0xC8F722B85F82B4A3,0x453D5A4A7F0850FA,0xD6F79D237B3AC4A3,0xE1C9DFC20DBAE800,0x56E4F0F5C4B9258E,0x00000000000001CA }
  },
  { /* Point #2 */
    { 0xC3C84FD2B5F54682,0x3488244E32C3A3D6,0x08C89D9EC1F6E2A1,0x9A8AADAC957EF7DE,0x0A54F7FA07CCA3E8,0x42AD7295BA97BB36,0xD82CAE54871AE976,0x0EB9357204BF46D8,0x000000000000009C },
    { 0x2A3AA55F45AE741D,0x9B2168B79034B489,0x66C66F0921F91264,0x6823B0FB70703195,0x5E43EFAD96E215B9,0xE1940D5A4CA42901,0x792CDC63294CCDE6,0x5BE5AF8A4446EBB1,0x00000000000000B8 }
  },
  { /* Point #3 */
    { 0xC7D454186A52747D,0x034CB6D1523D74D6,0x073A404E0E2B859B,0x9A38E6D89345DA73,0x4C4771D5C7FDCCE3,0xAEE8C00C025C1423,0x10C94E72D7203E0C,0xEA9F58BB4547289C,0x000000000000000A },
    { 0x030C1DF531B952A7,0x8177A6E11D47E37E,0x9E2222B0DE6F3C0E,0x1ED75C871399560F,0x9B818C5D829AF1E8,0x75C7751945DB80A1,0xFAC13445D73C446A,0x91A2741362844292,0x0000000000000027 }
  },
  { /* Point #4 */
    { 0x3D239C6B6A81C377,0xBF4D092E7BCF552F,0x3D2AF909ABD2CAE8,0x3D5AE04CEBEF1533,0x9C57DDD8C7D656CE,0xA345AC44C552693E,0xC66E8710B604FF42,0x5743B43318CB68B4,0x0000000000000170 },
    { 0x2AE332C9427E80C7,0xC3C529D4DCAED647,0x1D1A183473F44043,0x4F5155D63B71F27D,0x4239074473EE7E4C,0xB23433B84E09E697,0x9A4264DAA60C57C2,0xA7F72FF8486992EB,0x00000000000000B7 }
  },
  { /* Point #5 */
    { 0x8CC7E786A421DED8,0xA5A125F9E860A431,0xB7A8D71248983574,0xC6002B7EE8B35B3B,0x8F665648CE6EEA34,0x752979DA1034CBA8,0xE2630CDA5C5CBEC8,0x3EC9799052E8924F,0x00000000000001AE },
    { 0x5273DC9CACC3A394,0xB909BF2049B36AE6,0x171849E582B3EBEA,0xBCD415DE02F14020,0xBF3CFDDB6FD2DFE5,0xB148440CFF83E32B,0x47B5DB0312FD66EF,0x1405294D649E2453,0x0000000000000119 }
  },
  { /* Point #6 */
    { 0x03F9DF37D6DF08C2,0xB12D3F4FD5DB8EA4,0x22C50890BA73BF57,0x28B68334531E84A4,0xA81E07731B30B785,0xB9052F7C525F3204,0x37F84B24FA3EB3F6,0x1F3CBD6586C05A6F,0x000000000000014A },
    { 0x8FFE4E482512657A,0xC88389240E33D293,0xAEF4F8F7BE309839,0xDAD04DA01D8123A9,0xCA24B672037D1A50,0xE38138DAFB4BFB1B,0x7B14401509E0B0F6,0xE6BC949C847D97A2,0x0000000000000045 }
  },
  { /* Point #7 */
    { 0x0ADB4AE01BE22FD8,0xBBE623DD983C07A7,0x7A3CCB047AD35FDE,0x940147B288139DA7,0x6CA7BC83CFD6AD33,0xDAF6805E2522E444,0x81EDD301B7A5DC1B,0x962222CC2775213E,0x00000000000000D0 },
    { 0xB66DA30EF3F1F2E9,0x1CECA8043DD69CFC,0x216FE23A8E011253,0x1FA58241A1BC0755,0xDDBBFB9E765CDF24,0x8ADC026852772AFC,0xB2F7C543AA6C3528,0x6571DB8BCE8978C5,0x000000000000000B }
  },
  { /* Point #8 */
    { 0x1352B764A2839E80,0x61A50D9716058B22,0xBD02C6879D6AE08D,0x1349EE8B6679516F,0x3D7E69C9BC4C2FA2,0x4C2E12A10D24E1FC,0xC69535A147436039,0xA477F86B0CA25C70,0x000000000000011D },
    { 0x756E379C2A4C1871,0x4D0B08B35943DF83,0xD8A9B302CD8F5ABB,0x53865D1E8C240617,0xD422A9B114A2E093,0xBDBC3D7D03014FDF,0xA4C8B35A11578DD8,0xE4427EF87A3AFBC1,0x00000000000001C1 }
  },
  { /* Point #9 */
    { 0xBB07FC7B5E359C52,0x4967A34362A14425,0xE443CD5B1512B682,0x86BD7C5F1711118A,0xF5249F590D8C03E1,0x18C0F23CBEAA26AB,0x062B83458C1D4324,0x59402ED3CBA76512,0x00000000000001DD },
    { 0x230DD9F853BD6B5A,0x45FE89D9F18348DD,0x6DA2FF897BD44D52,0x3D9ACAEE98D530EC,0xA0EC09B1C5171D06,0x15AE7AE8B7C074AA,0x346B16994BC528F9,0xB7B46789D87E05CA,0x0000000000000122 }
  },
  { /* Point #10 */
    { 0x57E5998DAAC138EB,0x629ED7C0A07B58F1,0x17253E5DBAE6420D,0x26A91BE43318C23B,0xB4FBCCA21956AB5C,0xB7018FAD03B906FB,0x13D98BEEAA518138,0x6BC1037EBE48246F,0x000000000000014D },
    { 0x11CF86875411292C,0x585426D621E44B82,0xBE07C2D508C120CC,0x03DD005DEDBA71FA,0xB78A7AB7CB01C4C9,0x48DE2352B19E12BF,0x9CCFA9805F952023,0xB653E507447B28CC,0x0000000000000025 }
  },
  { /* Point #11 */
    { 0x4103A4EB1E093788,0xF9245C34756C67D1,0x6896757A25DC2FA9,0xE73DD43D94EF7FDC,0x8FE8D0380C97A643,0xB06E366F31F618A5,0xB55B172DBB863CB6,0xDEEF1F49F0704C7A,0x00000000000000A5 },
    { 0xD0B0AFF181A45B89,0xD53C7590D9C57C48,0xC3A5233A93EBA327,0x6706F75B3552AB44,0x3B442BF54C71B9E3,0xAEC3C39D38D5A2E8,0xAE46666A0FFFE6F7,0x3D002A021D938D4B,0x000000000000008F }
  },
  { /* Point #12 */
    { 0x4FAC31A61BDFB45C,0xB8D09BD46894361F,0x6DCAE911E063D116,0x7BCCE8970490018A,0xA285135AD6C79879,0x679EBD2C2F56BAAC,0x8120B0FB87D86D0B,0x0A4A6B8F25136CFF,0x0000000000000141 },
    { 0xFE1D08D131F5D108,0x04BEB9B0503AB53C,0xB7B70A5AEBDC5821,0xE00296F8155FAA25,0xC04BC77E90470120,0x7032021F8755333D,0xA6BE02A11E5064C7,0x23755577BB69E508,0x0000000000000180 }
  },
  { /* Point #13 */
    { 0xF858317F6F744DE5,0xE1503766AE3291C8,0xAFE145C7E08453AE,0x3F2B248E6635BDD1,0xCBD53A8FBF8569E6,0x6FF1E4FAE4B333FE,0x8E5B24D8DD26E758,0x71DA7965952B75EE,0x00000000000001BD },
    { 0x806DC8FA110ED54B,0xAD77451245B3F399,0xF9FAB139178A7BEC,0x41E7601A6254D7E7,0x3EABF82FF8BBB5FF,0xF2BD2ABB7BBB68A0,0xE16727B77A9E20A0,0x4E51C8E6D1661502,0x000000000000000B }
  },
  { /* Point #14 */
    { 0xE911838118666736,0x4BFEC3568922E188,0xCBEE1F9EC9DE6B65,0xF9F94EF6A0588D73,0xEF7DB91197F2A082,0xB15565A95AE83839,0x490AC179E36D5BE1,0xC6C300433CCDFDEB,0x00000000000001A2 },
    { 0x9BB484598D9B96A0,0x3EB480129B4D5EB0,0x05B279A856E50C25,0xB64F18B82E6CE820,0xBF31FFDF4EEC66E4,0xA4E610F23263B1AE,0xA6ACBCA25C12D842,0xAE13E6DA2BB1BCA7,0x00000000000000AF }
  },
  { /* Point #15 */
    { 0x06AA71B76402E540,0x68DAFD79569940F2,0xA244F34787A54485,0x85F5EAAA486A4F54,0xE401DA5968DD806D,0x8392C5F32F005ED3,0xFFDF4749B42988F1,0x20745CAB49218465,0x0000000000000123 },
    { 0x8B88856A364B1F8D,0x912C8E40F72831C5,0xF62B14E7A492D445,0xBE4E9DFC4418F279,0x05BDC5D00D39A55D,0x67A7D31F83C27D23,0x2554B9748DA4D858,0xF31FA174F701DEF9,0x00000000000000EB }
  }
 },
 { /* Table #107 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x8AF346C57D874400,0xD9E98CB571098F45,0xDB40081079565740,0x0F7625EBED9A7DCF,0x5D1415D0C93D2542,0xF87F74B4688D0692,0x9FA2E31B9F648523,0x4E505024CB387129,0x0000000000000006 },
    { 0xE2087F9C446E7206,0x60F69447B48BB585,0xDA3658622020BBF2,0xC8A263673CD51256,0x8CC663B1C62F7C5E,0xC86D4165E72BBD20,0xFFCE9039AAC68BE3,0x6C6C747CC3C360A8,0x00000000000001D4 }
  },
  { /* Point #2 */
    { 0x290E4FF1781F48A0,0x020D9E3D66D6F7EB,0x1C0DA98E084D19D4,0x42C64660030DD190,0x996602DD29AA0EB8,0x7719FB105D0D86E5,0xE20032629145140A,0xD2DC210C97E687A2,0x00000000000001E3 },
    { 0xE704ECDB18C76449,0x30A4377044131380,0xAEC3CF4B372CF9A8,0x4033C8C03DF882A5,0xA5E23683969AF81F,0xF42C5B9580263B3A,0xBFF4ED559323C9C4,0xA1D992B800EF132E,0x0000000000000100 }
  },
  { /* Point #3 */
    { 0xAD854BDE1842EB75,0x52D44A39FD913403,0xDE2D5FDD964BF528,0x00FC48B0BE2D138F,0x497778287968E858,0x326F8A6379B5F778,0xB093B6D8026EE753,0x36BD9300067C336F,0x00000000000000B7 },
    { 0xF63D269D3D3B0373,0x7FD4555E8901CE7A,0xFEB8A5ABF0C00754,0x2B855524D1E4F38A,0xEB245C9A10593EA9,0x8D0428915303AE29,0xCC86C4617BE4EC45,0xD05D843BB1A35C03,0x00000000000001A0 }
  },
  { /* Point #4 */
    { 0x4A3BA7D35A80EEA6,0xAFABC45F138ED8A4,0x8500A36B08955EB2,0x3D6B2EC617A6C2AF,0x23470F5958D5E66D,0x5DB86555A1DF0EAC,0x3A2E16179974C9BC,0x08480D1EB4DFE2E6,0x00000000000001D8 },
    { 0x89EC8A91C3DCA584,0x6C06D419F2AAC2BE,0x427CEA3CA57E58C9,0x54AE1A697B0B1B12,0x40B5C77E3965CE2B,0x3223C7E53CE07598,0xC2DF893146948FF6,0xFD997C8655D12AF0,0x0000000000000155 }
  },
  { /* Point #5 */
    { 0x615A13D91BF64AAB,0xAD0C56A0EE125E48,0x5622DF0D2F1AB618,0x7331C9B97E465F36,0xE9F79F235E69238F,0xE71D8ADE22200715,0x0F2C7539C1111751,0x0A3E1894B9287B5E,0x0000000000000172 },
    { 0x20E9E6D2311C0623,0x2D2EA9D91CC824F0,0x4F188539344E1B73,0x468983B4A32CE555,0x5A610F7AB185EFC3,0xA65ED115DFF9F69B,0x61F20B69F79D8BE4,0xA496802121D50124,0x0000000000000036 }
  },
  { /* Point #6 */
    { 0xF393BDB41C4E903A,0x7C7BE529356E8B65,0x17CB86BB5B85085B,0xDA6493819224B373,0x53B88EB810832B05,0xFC02CB4798C0250A,0xF46C49940F0221EC,0x28376E37EAC2FFC9,0x000000000000002D },
    { 0x2F6C2FF9AFC8827C,0x12FF0F5917EF8723,0xAC1AA2D22455917D,0xAD3764B0F8910F17,0x5D4A355C3BDF893D,0x7387C7A3EEEE0B8F,0x9B3E2F884356038E,0xF4AFFAFDC75003B5,0x00000000000001AA }
  },
  { /* Point #7 */
    { 0xD7DE8CD0FC9BE442,0x0A52E40FC9DDE6A1,0x05A4FF641C7149BC,0xCC966D0D5F2F3AA5,0x5ECE6A196E2D25CD,0xCD0A1086F6441A77,0x1C27360085904D79,0x44A59F2ECF8C85AC,0x00000000000000AA },
    { 0x266FA397DB6BFCDE,0xF68D7A368BF6394F,0x0D19162214A079D4,0x3FC59BD33F93FDE7,0x9EDBB13E691C417F,0x50A5045A4B6D9AA9,0xF5F738D8A35B9642,0xD0FAB4F3471D4F3C,0x000000000000013A }
  },
  { /* Point #8 */
    { 0x85C4BD23AD5B7E60,0x9A21B0B0F41A63B8,0x368399F11991539D,0x67F2C9217B2B3B1A,0x7DC0513338B4A267,0x3EBEE98741104A8F,0xE73DA9A9F8687167,0x04B9F294155F4EB5,0x000000000000007F },
    { 0x1ADB7A1453DCBF7E,0xFBC526AE08B7789E,0x004FBF8FA1F9C5CD,0x7CA3FF9B48B46608,0x08A90D3083829A47,0x90A442ADFE3C66DA,0x36D2D6BD4C69B3FB,0xD5307E6B67675CC3,0x000000000000000A }
  },
  { /* Point #9 */
    { 0x38D50AE2B1340C26,0x98D9A11BBD6C48BD,0x71342C9D2A770FB2,0x641B25AAD42C16B6,0x9B9CAA6900A7B958,0xB2E0F3D21C6F21FA,0xCAA3C0854EBDFF9E,0x907443377FF33500,0x00000000000000A5 },
    { 0x680BFB3C9295497E,0xCD4C1CC25BE8F97D,0xFE7DEE3BCB911F56,0xABBDFD216980D877,0xC134EFD566109F84,0x83200BC03ADBCE88,0x1AE3359DDECBF40A,0x4F63ADBE2135D328,0x00000000000000AA }
  },
  { /* Point #10 */
    { 0xD35B9E3138CCDC36,0x193D19235B283364,0x3F11086716AC2730,0xC858771EF63F67B4,0xFA465BA5426AD999,0x2F23AEB634208C28,0x1804C3F488E3B573,0xD40ADABED5865046,0x000000000000018F },
    { 0x43F3FAB933B8A100,0x854D92B7B1BDAAE0,0x71B54F79564BDC47,0x45A21A1A1A5BA2B9,0x34E2636AB2F40276,0x30A97302E43C1E12,0x1C8B46C36422EED8,0x788D649283623652,0x0000000000000055 }
  },
  { /* Point #11 */
    { 0x13CC8A3798A740FA,0xC99AA3ED2632ECE5,0xEAAEECD6B9E1C72B,0x3AEC5C4956487374,0x89A403CC14674797,0xCA0EA19A6E0C69EC,0x86B528A68ED9F435,0x06BE957DBCE563B4,0x000000000000005D },
    { 0x35D9C838CA34ABFB,0x0DD8CB6D4F813C5E,0xAAC57A0356DFECFD,0x0F11909337223E93,0x5F8781C95B447B8E,0xAB2F96C0ED13B66B,0xD38636EBE3AF9074,0x296C578268DA2B8A,0x00000000000000E1 }
  },
  { /* Point #12 */
    { 0xDFD43EBDA9F23142,0x707183F61ACE42FE,0x2DB54733954F2170,0x1A10E785E3A33DA2,0xEF315020B848D1CD,0x179454CE5ECDC048,0x845369CF13E1AEE8,0xB924FAA0B536990D,0x0000000000000012 },
    { 0xECF9A0EF7D22A7B1,0xC8DC42E20E95F354,0x2DB31A2FF194A767,0x31063E42B67924EF,0xEBC3CA6C48537BA1,0xC59746EBA8363616,0x6C45F60203D2C783,0xEFC327471E59FD7E,0x00000000000001A0 }
  },
  { /* Point #13 */
    { 0x393A7DCBD3C3AA79,0x8A3A2240A23C9656,0xDBC3A5F8CF3EEFEE,0x128E5DF243801F53,0x2915BD679F3B1E81,0x9C317104741C8852,0xDAD2C02867107EB1,0x17C5C24994300EAC,0x00000000000000DD },
    { 0x8E33383090087C9C,0x3B477580533F2A2C,0xB6395D04A0B8FC27,0xE16F86D626AC5091,0x376968721370DD63,0x17277A7F0DBDA08B,0x7CC056E800825EC2,0xA37C952239724E7B,0x000000000000002D }
  },
  { /* Point #14 */
    { 0xA8D55BA1F6F83320,0xE7493496C4EE60D0,0x55A0E10FE16BB4E8,0x7DA768ACAF161711,0xEEA132C0BE96A3B5,0x4A09FFFF7FB41DCA,0xBD69C04713F6BF90,0x4AEB854A82509B35,0x0000000000000156 },
    { 0xCB9C060D70F0C260,0x91FAB0DBF52F971D,0xD2FAC4C89DBCD806,0x92F23FA3266B3438,0x01BB7D4B56AD0784,0x0216D0ACC864EA06,0x8C126BE50B55DF14,0x9541A18BAA2A1F85,0x00000000000000FB }
  },
  { /* Point #15 */
    { 0x3F8344D51426B278,0x8F7DDF8A9A9B479B,0x1A964EB3C669901C,0x6FA4CD8FCACCB2C3,0x65FACC3706E7AD1F,0xF29FFBB490A7F25A,0x3D1AD490E68A505E,0x5A5CD3FA88D6E4E6,0x00000000000000BA },
    { 0x9CA4B1FBB503A9C8,0x94938BF8AD8685F3,0xE9C8FB4AF178C339,0xBFC000D25ED5928F,0x7B8B0F6EE7298BF4,0x46C7096A7FBA0571,0xDE65DC553DD656A8,0xEE6B622341A31A9D,0x0000000000000196 }
  }
 },
 { /* Table #108 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xA66CCCC8D6E1BD72,0x1EA4E9214AE2FA5C,0x66775AF22D021FA7,0x6D711DFB2A4C4677,0xDDAAE8BB5AE380B3,0x53158994600F11FC,0xFEB122DBDA94D443,0x7CBF1AFADFFC21DD,0x0000000000000006 },
    { 0x03CFA731834BF891,0x4E016085630B8032,0x90CF9B5949DB4D96,0x96FD2614335C9DDD,0xC02145108E3B98FB,0x6DED06331DA2EA2F,0x2BDA6D769D0EAD76,0x4BA00E99F3E4FBF2,0x0000000000000169 }
  },
  { /* Point #2 */
    { 0x5FBF73ADEE70E781,0x29A81E4F67793CF9,0xD7E9CCDF80BF503E,0x6C06D49CD6EDDA9D,0xC33C7EE6D96E70F7,0x30D7D644EF6114B1,0x0615B576AB81AF49,0x56B8AF445A09A31F,0x0000000000000076 },
    { 0x32E0B33475CAC764,0x0B123DA0DC2D7E31,0x67D72E7AD11B58EA,0x93165A21961098ED,0x4AE95E5ADD1D2B8C,0xC26794A07EE3715F,0x6887F532CD333782,0x67E608D5AF37AEDE,0x0000000000000179 }
  },
  { /* Point #3 */
    { 0x20E1DBCB54203519,0x4731F4A66854FA65,0x79D73800F769FD0A,0x248F675286246CCE,0xB63DCA396D04D079,0xC90D6EB80FE5DE22,0x0BD86EE30760287E,0x1687F7CC035A202B,0x0000000000000073 },
    { 0x34FCAD345D18000D,0x8E27D9D29808E5C8,0x5A3199E55483836F,0xE786EC7C62C5CAE8,0x22D732EE82F509DB,0xDE5C5E2CB6898EAF,0x0F051A388BB31048,0x69536133B732B905,0x0000000000000003 }
  },
  { /* Point #4 */
    { 0xAC333E4AECFA8831,0x9D08F6EF8A6D6E93,0xF2EED835EA97FB6A,0xDDF44417070C46F2,0x1E3159BF37694EA3,0xB0C4319C8B7D6A05,0x0ABC757261F314FB,0x0057F6C701A6047E,0x00000000000001E7 },
    { 0x204CB3DD6AF8283B,0x4EEDFA1644AB9EA7,0x79F1569993B7D9E5,0xAAC8F0C7D29DCC8A,0xE293FD274800F5E5,0x6EC0A739E22DA004,0x8CBEE62FB903094C,0x86DCB1FDA88C3BCE,0x00000000000001CC }
  },
  { /* Point #5 */
    { 0x2373EAEB39E84CE3,0xBA04CA2E0B9EC7B3,0xE2B50DD2BD2194BD,0xC663BB29513F5EB8,0x46B010ACB8E768D2,0xC8DD69939514B2AE,0xF90F39CAAC22E17C,0xA1420DC6AC54AF6B,0x000000000000016B },
    { 0x60F5772F8AF82DBB,0x7E43A57CF75E8910,0xC53B8A3C233CEA7B,0xE43935A798AF58B7,0xBF5354E9F772327B,0xA022B423D8F71CCC,0x58E76A758037F9C6,0x502B6D110DD3213E,0x0000000000000001 }
  },
  { /* Point #6 */
    { 0xAE8B54D902ACD87A,0xB4FADA66621F7759,0xBBD2284420D45BAA,0xFFA8504603FA5B60,0x1319EE91365BD0A3,0x0AC098DE140575E6,0xF611098459D35E15,0x2AE56DC460C4C232,0x00000000000001D1 },
    { 0xF0B1A965E5CA8913,0x1332685CBBDCEBAA,0xD1E5D6E84BC1D2A7,0x5397B19777A5D9B2,0x531B98D70E3ABC64,0x408529218EB05CD1,0xB1FF6C739BC7332E,0x18369F7AE26BD5D8,0x000000000000018B }
  },
  { /* Point #7 */
    { 0x2600BAC3B04B2D70,0xA595B33F4CF3F9F9,0x21660D3ED99E871D,0xEB5E976DA9394803,0xE205F3CF8A1ED4EF,0xAA94C33281DFBB0C,0x00F0CD08055BB2D8,0xAD6552485AFC00FB,0x00000000000000A2 },
    { 0x9B28D5EBA2BF8AFB,0x2196D7704A8A5D19,0x0ABD9B8DE884658E,0xADA571E816799F11,0xBE86DC5787CA21A3,0xAA5680F63FE855DB,0x0B8308601DB10908,0x3ED53BC28DCEB82A,0x00000000000000B4 }
  },
  { /* Point #8 */
    { 0x3A44DDE085F45EDD,0xC543BB6498309156,0x82D1CE827597D0D0,0xB2DC0F228106CA3E,0x66F394472C3A313A,0xD8F6FCDAA6CF2E03,0xED6E0E279E6BF40B,0x7DCD3A305B9A41AF,0x0000000000000095 },
    { 0x0A870CEC12BE5B78,0x912C21C51406E140,0x977417FDD5E13CA1,0x9EDBAE8AB9E21E28,0x9FCE45EA13B2F069,0x25BD760B84F3CBF2,0x29E0C3CE2489FD01,0xE16D31C1EC62A766,0x0000000000000061 }
  },
  { /* Point #9 */
    { 0xABE58A0B3256A2A9,0xEFD4E17458EF9132,0x852B55AD1BD0239D,0xE13EAD719886893C,0x1F3D564A027DF6DA,0x380277D49DD69E26,0x2F10271EDAA13C20,0x05AD37F257F5E69D,0x000000000000003F },
    { 0x05202CEB084CF133,0x09C2AC4A9F275791,0x49F9FC484E0EAA44,0xD58A0B214F9AB612,0xDE7D9174F9AE85AD,0x98300CC9994E0EC3,0x29354FAB13D32ABD,0x5981C83FE712E586,0x0000000000000016 }
  },
  { /* Point #10 */
    { 0x0A2F28034778FA9D,0x62E99C7B4249BCD1,0xCF4B88085F555574,0x250C588F3BF9AB03,0xC9CACD72FFD5CDE3,0x5345160D74CC038A,0x4E528177BA5984DC,0x67AD58CFEBB65C8D,0x000000000000014F },
    { 0xFBF9A933E072163E,0xA953F8C4377AD3D6,0x5F9DFA5FBC85CE22,0x60FA641F70833E7F,0x4AA6E046C698B0FA,0xD28085E56ACD027D,0xCC2A9370A62401AD,0x0109B32F292C57E5,0x0000000000000076 }
  },
  { /* Point #11 */
    { 0x5A7577FE6A8A53AA,0x87AE224FB43AA587,0xB369D8311AE1EFC5,0x2E7FEC9AE6B83640,0xA88165DB854FDA1B,0x04FDEF49CD2E67AA,0x3DD3F68868D3C412,0x1E67649362B2EABB,0x00000000000000B8 },
    { 0x4D7B8A0B498E4198,0x8EE7B890C657CFA4,0xA67F6AED057171B3,0x366299D4849438C0,0x2F51668F01439A26,0x1F2E77034ACEF213,0x97D26BA8DA175413,0x5975516E13D9E1FC,0x000000000000016F }
  },
  { /* Point #12 */
    { 0x9BADC953AB98F2BF,0x867B5F5E6F45EC55,0x36C30111539AB291,0xC663FBE74FEEEF3C,0xB2DA1DE355213DD8,0x2C3E4A54A8F58884,0x2C2794C713F166AD,0x1B31C3A69BB7B65B,0x000000000000018E },
    { 0x1A866F47B06E4F37,0xBBE067A17A609C0D,0x83073920151F64FB,0x899421EEBBA549B1,0xA2145ADF91F21D16,0xBD5F420952C37C74,0xBF18214C7C7AFC51,0x917E6547B69BA831,0x000000000000013E }
  },
  { /* Point #13 */
    { 0xEB20640ACE891C09,0xEA93BE785F15E09A,0xCD71C1C0A0500353,0x69A5F49D9D421345,0x27B7CEC09586DD2D,0x2916A3EA35ED0F09,0xDB2356D286D0F9D7,0xE763D6E716035F2D,0x0000000000000150 },
    { 0xED0A70045626F5F5,0xA88A218A4DE0844B,0x49105B7AE99CB20F,0xB7948829CA883D1B,0xCB83FB3FF3C37155,0xD0DC7D0A47C71921,0x2B8025CEED260DDF,0x501C1989333621E1,0x0000000000000079 }
  },
  { /* Point #14 */
    { 0x7BF6662B2C5274BD,0x377243480DD95FF4,0x04D1A1E1310441DA,0x22DFF14F77E94DF3,0x16A66ABE41B726FA,0x3ADA51CC2503AA18,0x878EEB2C2DCCEF7E,0xB5B06741640C6B1F,0x00000000000001D3 },
    { 0xBB536C084AA90EEE,0x64DDFBD5E16D0037,0xD4887304B6F921F8,0x142C0E3AF9A6FD13,0xE7E170FC78715C86,0x5261B4922F90A2D2,0x06F7F85884D89D4A,0x64EEFEB251550058,0x000000000000003A }
  },
  { /* Point #15 */
    { 0x5C90859343D9EEFC,0x8155CF927AB85F26,0x1913352F38843B4E,0x8E41580486CE445D,0x713ACF5364C772C4,0x4F0B9D874A43FF4C,0x08447D950CA46DC0,0x3281D130177AD6B1,0x000000000000009B },
    { 0xA59598C0504173FF,0x33D4B7B70525B317,0xEBD813AEF87D01CD,0xCB7B0C0171DD6AA4,0x5E3AF075E3A9D734,0xC713D3B37149593A,0x3C08554A3934FA98,0x2DD58329A0EC8E99,0x000000000000014C }
  }
 },
 { /* Table #109 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x6985BBD6EE32E2FF,0xE69F0F223C35A00B,0xB1ABB4AE0EDE3C1B,0xA3D7ECDE93D96532,0x69EAE2594F693CAB,0x52E38B65FE3665F9,0x17664E93F2FA7A85,0xE1A2FEBFA5300907,0x0000000000000000 },
    { 0xBB35EF0CA538774A,0xAC9AA3CE2B28E6FB,0x57E02D060A801EDB,0x6977544394847324,0xB526BB1929DD0A3B,0xAED93900C468815F,0x3EB1B9B2221DF814,0xE421E27AD9472DAF,0x00000000000000B9 }
  },
  { /* Point #2 */
    { 0x823A3093DCC0C55D,0x48E4F42C8667BD82,0x6483B8ACDD036949,0x0D3F6E52154B38E9,0x713A6450CB96DB0A,0x791EFD97AC907250,0xE491A5192130C99C,0x333277E57DF593FD,0x00000000000000CE },
    { 0x4DEB4D72D7D90A84,0x7F39203EA13778C5,0x2308CD8A7BB79168,0x470CEF35A710BD28,0x6DB6B1A213BA5C45,0xE35B95DDE9E55EC1,0x68F023AB7819AF5B,0x50D449896770441F,0x0000000000000187 }
  },
  { /* Point #3 */
    { 0xFD2C6BA8C03C8A93,0x6287BAAE255A51A6,0x6CDE095EFC336858,0x668C6F54ACB5FB8C,0x26B65582568A5789,0xD51684EFFCFEB7BA,0xB5D91D3D8DFE63FD,0xD366CAE7560188B9,0x00000000000001C6 },
    { 0x587D06CC9844367E,0x527A075F589D9ACA,0xD581AD9F4F88CCDB,0x3499E8073A56CA59,0x50B8B14DD6328D96,0x9B06CE845936A744,0xAB46F398E693DA36,0x4C5E0D9ABC55F498,0x00000000000001E0 }
  },
  { /* Point #4 */
    { 0x6CDF7285E8CF496B,0xA27BECAEE1460283,0x0291E5E3A8331004,0x436D8DEA957E58FC,0x52ADE5768F6A37B3,0x4C31E9EB08CA0BF7,0xD918C8A0547BB960,0x85CEB1004394F6D3,0x000000000000007B },
    { 0xF796100862DB1E32,0x875FA000C20F8B1E,0xBD4BB865E621E53E,0x9346C7C57235CF42,0x8AE88A5692CD8C70,0x06B82E3AC68AB6D4,0xD0DEA99A736A6B71,0xA54CEAA48C6A1235,0x000000000000012D }
  },
  { /* Point #5 */
    { 0x14DE106989B694F7,0xFA202A91453ED74E,0x19344093B7C462B0,0xDDB9F1159D5F7733,0x6110F1CD6E71EFCB,0xE9DBC336D27D9F95,0xD9B29E011BA3BB66,0x7B218536A9677CF4,0x0000000000000178 },
    { 0x7FE687840EAFDB07,0xDE335A451C0D642F,0x11B4B98A208D5237,0x53F2C20236B0801D,0xF07F20935CDE08E1,0x5E0E5D3A0F34078D,0xF1FC7F3480286B22,0x4C305A8BC48E9216,0x00000000000000F4 }
  },
  { /* Point #6 */
    { 0xDB8A02D18294CC29,0x6ACA02EC9A9A5709,0xEE2B10E6D554C17C,0x29AA181881C661CC,0xBE522AF71FD10EAE,0x3C4BB5242B5589F7,0x5A5600B1681236A9,0xF7FFD0917F235A88,0x0000000000000007 },
    { 0xFDFB09268AD17511,0xC8964821BA2B0A60,0xA6EDC26433608D96,0xD98937DE18D1B857,0x0FEECAAD85A5A3B9,0x567BBB021F102192,0x89147837441B4A0A,0xAA4716104E0F3D86,0x00000000000001B9 }
  },
  { /* Point #7 */
    { 0xE030FEB9814ABC1C,0xAA7EF7427387FCFD,0x134E4EA847E5CE93,0xCE9F3CB52949FFB0,0xA83252A83E11A1C5,0x2B308229BA0F2644,0x1EB76FB7EA75A292,0x0D9BD36B73CF1481,0x0000000000000021 },
    { 0x45BDD68DC50E223B,0xC6A83635A6C0BE76,0xAA61EA3FC0E1F910,0x7AD38095E8FD27FB,0x2DEAA3B2796C8EFE,0x9AD0A578D099BCDA,0x5819856A2A953EA1,0x2B7B7793593D3E2D,0x00000000000000DD }
  },
  { /* Point #8 */
    { 0x88FBC549470D7E36,0xF091232AE079762F,0x8E84CE7E027A4477,0x21E570DFB704F424,0x51E89CA1D36FC205,0x52451D98CB04C0F3,0x4233A3569A256B13,0x42F33C2422636D07,0x0000000000000186 },
    { 0x88D6F4D60445345A,0x8B03B9F60C2FAA71,0xA45AB219C3BAF6D7,0x67C7EBA1B9BEB6D6,0x3EB7BEB99C8FCF22,0xB35DFC4371D9A1AE,0xC1204AF558436E2F,0x543E4F318DD710F6,0x0000000000000096 }
  },
  { /* Point #9 */
    { 0x8C0FBBD4799716A6,0xCC051818AA53A2AF,0xBCA333E86044B4D4,0x119F4FF585C795F0,0x4B480CB57EA3CADE,0xCED7FB1DC4C1C28F,0xCB53655DCCC703CE,0x1FE0B7538C5540D0,0x00000000000001CC },
    { 0xD937F3957C5BC459,0xB6756328AD67F0A0,0x3A5BC8D0FE7C0533,0x796AC0B0E4565F1E,0x8377D5884913C2C0,0x2FAA11AC7D65704A,0xE207FFD25E625BDE,0xBF3D689068BD440A,0x0000000000000147 }
  },
  { /* Point #10 */
    { 0x2F7B339B2B037A05,0xE42F3E95C499D10A,0x0160D72E07BE03B4,0x153548A37A4601D1,0xB0FC5C52EA960842,0x275739870FE92D67,0x4C0862B5DEA7EAC0,0xCD613CDE55B71EB2,0x0000000000000023 },
    { 0x28530ABF98A98D28,0x85A1AF53CB349226,0xDF816ADDEEA21F09,0xA9B60F768C0D127E,0x508A88E61A151E50,0x25AC746C3D750F33,0x5011A102A225271A,0x3B5029B548113215,0x0000000000000037 }
  },
  { /* Point #11 */
    { 0x32269C1BDC9FC49B,0xAD26E06E9FC27F50,0x40D2A97D6B4E84A9,0x736B98D4910EF791,0xC48559B078702918,0xB38B860861BE6975,0xCC86B5AC35B00E9C,0xF06C1FB5335D2DCF,0x0000000000000177 },
    { 0x24BFE015658A4588,0xBCF3AF27AB32678A,0x55E6B2E160ABC5B8,0x55FB213B917C8360,0x9E981ED52F427C30,0x43665885C4FAB94C,0xBF8864FAC0AFABE4,0xCABD2939CEE3A355,0x00000000000000FC }
  },
  { /* Point #12 */
    { 0x83FE2AC97051EA31,0xA76B3AC1B39476F3,0xEE45D2E03E2433ED,0x606DB8A30D999A0B,0x12BE94BA99C5C5B2,0xE2231745695B061F,0x0AFF87140392EF4C,0xBDC82DE6E03641B7,0x0000000000000172 },
    { 0xC9A067A61E4DDB23,0x924466E6C5FE49E1,0x56C25E66498A09A8,0x2FF93349603DD109,0x6173E4EF0CFE1653,0x486C08B8861E5694,0x675B2D4E4460CA71,0x9AC71CB2DD05403B,0x00000000000001F0 }
  },
  { /* Point #13 */
    { 0xEEFC28BAA0C707CB,0x610A0BF5B5E8A4B1,0xD74559F39B53D25E,0xB987896D504C5E8B,0xAE65DD137B25A6B9,0x967698FECF659983,0xA10CF8FC302CB07B,0xC116F1C94447F110,0x000000000000019A },
    { 0xCA833C3F74B590EE,0x6099AD10A90703DB,0x1B05EB478DC0A094,0x8E611A9FFD61F58B,0x220F8E3CB6376B63,0xD3EF40D06276C206,0xB496ED2C80BE240C,0xCC1E4FEE4C62D68F,0x00000000000001E9 }
  },
  { /* Point #14 */
    { 0xBAE333CEC37CC3EE,0xF3C270F736721328,0x42CA9E1C3E762919,0xE58208BDA33EA0C4,0x659C9E0588A736A2,0xE4AAFABFF2CE2FD5,0x6C42985D2FC82799,0xA83E18EA7BCACA5D,0x0000000000000074 },
    { 0xA94F77548E8FD835,0x2D730134BABC4DD1,0xDF79C84DD9FD0A30,0x642756577B1061CD,0xA8A2A2DCDFB545C5,0xBD5248E2B32E562C,0x09C33229DB76E132,0x70F63A074FF616FF,0x000000000000005F }
  },
  { /* Point #15 */
    { 0x6A2D32B0F3338F86,0x4A5C3DB2C9710433,0xD298F3B0A5F68F1A,0xAE78B804732D40D5,0x860D74D8DC109412,0x0F3D42CE2C898732,0x63E5CB193D321599,0x796C17CF1462A77E,0x000000000000003C },
    { 0xBB71E1B917837E4B,0x9711DFF889CF36DE,0xDF6C0A2AB1FD56B7,0x6F07FDD1D7E8E866,0xECFC1BA5B4F1BD81,0x4AC6B88A29DB023B,0x2BB7F22A6DE37B7C,0x86E37D902C35FA00,0x0000000000000113 }
  }
 },
 { /* Table #110 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xA0F946B34C7F31F1,0x122B97EC004B810D,0x98F876D1831A9CB2,0x6690030AAEBD922B,0x12A235D1A21B0412,0x5CED8104E097208F,0x049B33ED49D32FB6,0x2E88D76287B187EB,0x000000000000007F },
    { 0x08801D4EAEAAA0D2,0x3B052B0A6FC2830A,0x4E02318F6FEF40C1,0x5A24478A06F38ABB,0xC90C53926DEDD4F3,0x402E4A9EFF07397B,0xDE13D7BFF1BDEC37,0x8A363CCB727EB837,0x000000000000014D }
  },
  { /* Point #2 */
    { 0xA749F2661ACCB5D0,0x8EE12C7EBCC9460E,0xF3A52FDF3D25E73C,0x187BBE7100C5540F,0xCDCC3CC1561BEB89,0xE54DF2B48EACFCAB,0xBE6D1874CDA02530,0xBB717F8FD072A684,0x00000000000000BB },
    { 0x79DE2D6504BD7407,0xD8AE0921CCEA6B74,0x358CF798695DE295,0x004E73B2B81C02A2,0xD252441E9E6CAEA2,0x557F228CAAAF568B,0x6F92EC1D357D9E37,0x31EFD9BFE91FD306,0x00000000000000DF }
  },
  { /* Point #3 */
    { 0x9339BCD402073B42,0x464A00B7508C4450,0x682F569B46920E8E,0x8A375EA960F834A4,0xCAA2DE7F4FC9FFA6,0xA459885F7FE428F9,0x8E0219467E3615F8,0x5D474ACC96B9672B,0x0000000000000009 },
    { 0x2C82B7301CAD08CC,0x6946F74B436617AB,0x504929FDD7609D10,0x1B8D9D653A2F7D9E,0x1E950D1AA7334A68,0xF54624EC02579D4A,0xA140CA978ED35507,0x57D56BD4719B1CCA,0x000000000000017B }
  },
  { /* Point #4 */
    { 0x650E3A2694A7EFD8,0x0E18083DC739B54F,0x4EF3232E9367E306,0x2DE3D70CF0838EDB,0x1364E843CA8715D2,0x854DCA361C25B1C8,0x73C011BCBC117070,0xE83BD36F051286E9,0x000000000000019B },
    { 0xF1226611C0F59BFD,0xB910F5B64287520C,0xA408790BFFCDBB02,0x9D56F34D1A0BC553,0x1530C726CE9A67A7,0x96F5FA25DCE794F5,0xD5A224C8077377AA,0x2E9D8E98D016E05D,0x0000000000000093 }
  },
  { /* Point #5 */
    { 0xABBA86CF80C28BF4,0x9538A468871CF3FA,0x1E2585F5A1F3F1D1,0xD8B5E352F4E26D02,0x6B0AC27A1D575767,0x5BE4D5D967B4036F,0x9D395B7602A0F315,0x61FD5FE035500539,0x000000000000002E },
    { 0xC7BBD9A04BD2A24C,0xABD2E4B659228721,0xCC7DA00A70C8F092,0x4BBDB0C1851F19B5,0x983BB01F733CEE95,0x55C1E41E0F0A976E,0x3ED74ECD22B03859,0xCB950E0E581A900D,0x0000000000000169 }
  },
  { /* Point #6 */
    { 0x3E884116E71BEDEB,0xC43114F0D8E683D2,0xC65277B4709DB235,0x135E623363401611,0x5E6CC4CA4CECCD3C,0x9D481FA0F73E6E64,0xD52236235C253AEC,0xD60D849991F70B82,0x00000000000001C4 },
    { 0x5DB01DD6632F8EB2,0xC4695BBFA948669B,0x143AE7567FEF1AC0,0x3958CD3F21487FF3,0x00C79F337DA2EC59,0xCE54451E07F9A8BD,0xFC1017FB62F7EEA0,0x6BB256B462F0F204,0x0000000000000008 }
  },
  { /* Point #7 */
    { 0x103AE8BB5FC08E46,0xA91E278642569A60,0x0BC29EA3F28AF01E,0xDA61252820B341B1,0x84CA3C31388F1E0D,0xD6DDC0F44DD18EA0,0xBFBD80134296A5E6,0x91F3F3E388C34065,0x00000000000001A9 },
    { 0xD7D6DEA4FE14A17D,0xFFA3FB5B574EDC98,0x9201233213730FF8,0xADE8B73242AB408F,0x1BC6FC5B4D2FC00D,0x70CFE2347179A2E8,0x77D164A13727D19C,0x99CDE7AD60B6C0A0,0x0000000000000032 }
  },
  { /* Point #8 */
    { 0x3E9A969A777A2DD1,0xA928FCA6F0B88AA3,0x7282DE355F56EEC8,0x6FC69CD1076833B3,0xB082AE0411751566,0x09A31956CEEE94FC,0x6D3A6221158A2CB5,0xB29C6AE7788752EF,0x0000000000000105 },
    { 0x44EE879ABD125523,0x8297EAA04E8990B5,0x9DEEE7C4D7723740,0x3C6037179A8BF178,0xA851306B1207191F,0x13EEE334BEBCB461,0xC13D695EB8CCE34C,0xF3F594A50FF4755B,0x0000000000000196 }
  },
  { /* Point #9 */
    { 0xDD33C7F04DF980EE,0x0D9F6DF58EEB374C,0x76546027650994C0,0x56D220A7A3295A3F,0x3BA66FEA9D766C58,0x8F29308D4DDBD549,0x5B91281AD5FF0D1F,0x17B0A13AE129ED08,0x0000000000000152 },
    { 0x6EBD07699FA0A068,0x471CBD5F1887635F,0x90BE2C9FE70C32EF,0x9E48CDF4E8BCEBCE,0x3A946D9B86176CFC,0xC1396933298E8001,0x2263BACD94EDE84B,0x4916552B68473DEB,0x0000000000000048 }
  },
  { /* Point #10 */
    { 0xD370CA154611D4DD,0xDCA296E58F40E4EC,0xC2C0A54FBB7413E0,0x99064624C90F6194,0xFA357CE2798E03AC,0xF782D7099C6BA76F,0xC3718575129FBAF7,0x9275DDCF09AD3F74,0x000000000000016A },
    { 0x6EE77B4CC4919031,0xB09EEC783947C6C5,0xBD8F2EB86A83F5BC,0x2584DFCFFBFD128E,0x11F97BD08C68C3AD,0x157420D05F2133D1,0x8F3C1815D1DD4835,0x11E09E8F326D9859,0x000000000000015D }
  },
  { /* Point #11 */
    { 0x36E646DA00093320,0xF8AD0B6F44FD6890,0xD80F5894F579A2D3,0xEBF0959BC953588F,0xEFB4708AA8B7F6AD,0xBD864867CFD950DD,0x2127BDB148DBBE5D,0xCBFCBB6BFAEAABA5,0x000000000000005D },
    { 0xFE12CD7DD992462C,0xB35F2215E91274C6,0x5D4F3E3A71E12E2E,0xCA836FF3B02CA3C1,0x7A1C86A21A987915,0x234E79AE7F55D465,0xD5F60470C94D20D1,0xB14A537A60C432DF,0x00000000000000EE }
  },
  { /* Point #12 */
    { 0xBE0AE36CD038AF41,0xC3E663659074C082,0xF3A754972111B39F,0x853840556BE5E224,0xE6A841A8FDC29253,0x6F242DF76886082C,0x4DE2664606880770,0xA8D7AB3E57695441,0x0000000000000105 },
    { 0x452FA47042FB45C1,0xCD54E43102D65857,0xF6439594C6AA1FCA,0x910FF5BFCA2C8838,0x5DB4B1DF093DB021,0xC6C529725D06CE9F,0xED40A0482981DE06,0x394308E642E75708,0x00000000000000A5 }
  },
  { /* Point #13 */
    { 0x077B993EA7B24726,0x3A154BC61F52FC88,0x345D842C03D0D6D9,0x3ABE2832C2020B38,0x77B69CD980CC5686,0xD5941509DA81F16F,0x175C5437144FE24C,0x920FF5BDA2C06C33,0x0000000000000104 },
    { 0x475F74047DB14C67,0x97576406D5B5410A,0x7F3355EB9D75BB07,0xBE8D9E4113388958,0x09C5821D29267594,0x02A32D347FDC8CF4,0x2B4D266CF4034960,0x9792554279883A2E,0x00000000000000BE }
  },
  { /* Point #14 */
    { 0x1140D1B13F7E1B85,0xE5D9542E558F5A89,0xF01590081347E2EE,0xF4140ADAA83CD3EE,0x1388E29D1F9958DF,0x177F13DFF1D926EA,0x5AAC4C2037209003,0x46BED0A6CB9E0456,0x0000000000000165 },
    { 0x635535B494312D7A,0x662149BFA396A95D,0xB23C59DD4348AB81,0xA059D555CF24FB7D,0x3DC39DBFBE9011A6,0x7E11B9D98D1ED5A6,0xDE503B26A1FB4B12,0x04D12EC729AA2854,0x00000000000000CE }
  },
  { /* Point #15 */
    { 0x55E93ADCCA9B65AB,0x04050554EC608FC9,0x452525FD1545BA49,0xE1671F6FFEF175DE,0x94C7E1C1510AB002,0x490E7CCD4A4DA615,0x9116AD80D36BA72F,0x8B72D3E0CD7FE251,0x0000000000000140 },
    { 0xC4F0896AE30FA947,0x90BB6AB2EC42E041,0x30C427F1FCE3EDF0,0xBF4D15999D63E28E,0x0B4E93D3C3C6B47B,0x513A060901217870,0x2B2383A0861391DD,0x8DF6CE1CC813B08A,0x0000000000000178 }
  }
 },
 { /* Table #111 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xBF07E90D8114885D,0x76D513B29F39A562,0xD98AE4F77E5446A1,0x7E3314E96264B6C0,0xE634DEE76F3A7560,0x1DFA2392A08D539E,0x45764812BDAE3C53,0x858B836FD824E9AC,0x000000000000003E },
    { 0x9BDD0365E324EA11,0x9625D01B1117CDC2,0x491EA6427F6C259C,0x61B79486125826F0,0x573DEBC818A56486,0xE224DD3B0D31132A,0x075C3BF780BE8263,0x0ECED67AB84A07FA,0x000000000000010E }
  },
  { /* Point #2 */
    { 0x486D3C489C4CD8DD,0x2CEED6F8F7E8160B,0xFB38315DA76FC3C5,0x521AC7BB7863C459,0x17252331576F783D,0xF0FCAAF23E6D4BCA,0x8DB1CFFCE6F8E385,0x2E2EF7F478C49EEB,0x000000000000001A },
    { 0xA3C3C341F690D5AA,0xC14CFFB041E05923,0x2C7E4BCBA2C02F22,0x79352516C38AAFE2,0x67BF3709DAF3E5F9,0xFD7C30A974D2AAD4,0xB46886878B971591,0x7ADF565AB5F34FD8,0x0000000000000132 }
  },
  { /* Point #3 */
    { 0x82E9010DAFFBD971,0xAB6FEA0BC7AC3199,0x8D38894050383D27,0xC37AB3B3BE775398,0x8EF10AF154BF74AA,0xA1C39ED452AEAF9B,0xCD2B6EE670F42D7A,0xCB57643738A53A34,0x0000000000000087 },
    { 0x5A1416996F80E03F,0x0D7A7AB1408678E3,0x33DB44D87D279AA8,0x25E82C9032A33193,0xC68F43737FA96201,0x4E2FBE8A1C15C8C4,0x5B5CE8055429A403,0x1DC2F304F6543E19,0x00000000000000D0 }
  },
  { /* Point #4 */
    { 0x074092B0518C2B4E,0x4EFD0358226849EC,0x384EC468C8582D0F,0x6348E93A1B6530EC,0x752F051586723E53,0xC0124A0A18B6D228,0x8E61DB8AF16144B5,0xA3B3BCDBC57AD828,0x0000000000000096 },
    { 0x7B5EAAC0D5D72677,0xC6A4FD2FC826ACDC,0x06F1269583835C84,0x287EB11866C70474,0x824E4C576FB32F64,0x6AAB90483326B6D2,0xEFEF96E49DDDF339,0x8E113990DF13705D,0x00000000000000FE }
  },
  { /* Point #5 */
    { 0x75605B034319C263,0x887FDFBB9E4740E2,0xDE488A31D43F9B89,0xB0E691668E84F79C,0x8AD2CF6570A03015,0x20C0C8A49151CB55,0x9C4D58100538315F,0x18B7EB2712204FA8,0x00000000000001C0 },
    { 0x2701F40CCD3D6255,0xB6302374684DB0FB,0x1934BD385986C5A4,0x277CA623AC3EB927,0x1F8E83F33C9260CA,0x1D42B0B1CDD488C6,0x03DD506202069BED,0x1EDF5BE80713FB4C,0x000000000000012D }
  },
  { /* Point #6 */
    { 0x3FE0ADACA4C2A3F0,0xE8679478929E1F33,0x4779B883705B8214,0x00776735E23C0CFF,0xF663F8158F766BD9,0xAAB22B6BC30B548A,0x089032B0D56597DA,0xD72918F251D92E66,0x000000000000004C },
    { 0x152AF75D026CCD7F,0x9E12B11DDC3E849E,0x5D6F7B8664244B05,0xBC9C468B1D80629B,0xA14ED1A1F2F109C9,0x49E6D42CAB8403F8,0xBFE90229E34A6F68,0xECEC84484234D819,0x0000000000000101 }
  },
  { /* Point #7 */
    { 0x8C466EC6AFA6274E,0x935AC8E6E57D9338,0x3FFE008E7B5CA188,0xFFD8BA41DFBB530A,0x9504DBC067D0B3E8,0x95EBDE8C622F0B00,0x984BC63C209C6309,0xB2BDAF4A6B23D9DB,0x00000000000001F8 },
    { 0x248363240E2BB6E9,0xCEF90F5C65CC3116,0x4C71C80816BBF8DD,0x0D6CCBC38DE8D626,0x6E51FC2960C000D7,0x1E3116E3DFFF70D3,0xF3D91182DD570C6E,0xF02FBB1B6827D006,0x0000000000000191 }
  },
  { /* Point #8 */
    { 0x560ED5E263840645,0xAC6C9D02B99FFE18,0x0510A7B7BF7B7FE0,0xE1DC108356AEC190,0x29B4AD9527581115,0xA8021A6026A12461,0xFBBCCEE845144AA0,0x2C93CED8DED40B1C,0x00000000000001E3 },
    { 0x2C841A6EF3FB0D14,0xE8B8B8ECB1F67B7C,0xBD4C9A2219E26083,0xECE8DC33C1C6A093,0xFB47210F948AEAE7,0x98A8B0211569C5FC,0xC92CB9C7399C9D0E,0xDAA97144B0F6F23A,0x0000000000000145 }
  },
  { /* Point #9 */
    { 0x98E1B7CD45C1EC84,0x8DFD070F97C41E14,0x4F93F2D6CE5584AA,0x83CCC00CDAF1AAE8,0x03F86BFF5BD38070,0x30CB6C33054598DC,0xB1FED34868374E10,0x9C8978745CF277CA,0x0000000000000169 },
    { 0x93E3292BBA7202B8,0x9BF6BB8C5EFE5E0A,0x4E60A072A72BFB76,0xCF81DD11EAFBE064,0x78DD4B8E3CF22212,0xE7BCFC86E06102F8,0xBD9EA3D12216B8D3,0x3BAE1822BC4070B1,0x00000000000000A4 }
  },
  { /* Point #10 */
    { 0xAC1AFD008CBD05F4,0x9391FFE9FA07D470,0x7318942A16702B4C,0x47B51181CD75DAE4,0x862417F4F35B1637,0x65C5FD06A7F884DE,0x18A916FB7AF0ED7A,0x2C06DC26723BB229,0x00000000000001DB },
    { 0x90BE27394FB65431,0xB70B882C48173D00,0x8243B185B82BDDBF,0x2C66E399C7AB2F76,0xD3C50F5F66FB6E1D,0x1AA56DDA76BFB0F8,0x7E4708C11D5D4AD9,0xD46FA9527096CA0A,0x000000000000013C }
  },
  { /* Point #11 */
    { 0x877929F8FA3BC4E4,0xF80C68CFFAEF537C,0x46155660C3781055,0x8B8751DDD37E0555,0x3C7BD08CF4D36DD8,0x34F961E974E492CC,0xCCF30DE3F8A1A62E,0x1CE2AAB78E542B39,0x000000000000003F },
    { 0xA5FEA9FCE9045828,0xCC644992B6F8F8C5,0x27B0E110DF87C951,0x13F4085DF3DBE018,0x9302425B8CB0BB42,0x809DC4453F75C533,0x195079D0AD0CCA97,0x771600A6825A7BAD,0x0000000000000169 }
  },
  { /* Point #12 */
    { 0xD950023D58A87777,0x5EACC69C8BA60223,0x8E6D300A9960E2D0,0x14E29DE35A32A1D2,0xA72069514673910C,0x45613FC095719B2D,0xD8422C5508BC05BC,0xB11D897F8313CDBF,0x00000000000001D8 },
    { 0xF95D347CF9251DD5,0x3FB5DF95167C5F61,0x0872EF2A530C7788,0xFD074FAAD4C495C3,0xB7043A6870C0D5DC,0x41DD680D9B633103,0xAC0EA13624EEB675,0xED26AB4CCF63B5C1,0x0000000000000129 }
  },
  { /* Point #13 */
    { 0x4ACFFB1214008E42,0x57FF2025F91928BF,0x143EE04435D4BC10,0xF399BA615D88D031,0x001EBF89DA5B2FB4,0x87FA0C9879B208A7,0xE220C7F0FBBB3515,0xA164B1DD5F998E14,0x0000000000000174 },
    { 0xA7E6B624C6F7B10E,0x30689EAA016986B8,0x4CC8C5AC47900CE5,0xBDDE88F766015B32,0xFA448783537F1089,0x600DF0E66960D0DA,0x4862B361FB7FF390,0x3C49EB25DB599DF0,0x0000000000000162 }
  },
  { /* Point #14 */
    { 0x8BF9BB3614F3B17D,0xEB4426EFB27B4186,0x1F9832E051F39D65,0x3DFCB2260DE5FF00,0xFFC08C99AD17EC8D,0x020AEAC5607F278B,0x2C3E1EB5E9281AA6,0x7786C7D2DC3AE28D,0x0000000000000038 },
    { 0xE821B9208B6EA35A,0x23445842FD7AFA87,0x2EEB4EDBBDDFB41A,0xB80406872CB326DA,0x916E3DCE0C1EAE0A,0xBD6851513B43E06A,0x6F152EDF04634D00,0x4ACCD52EA221EFEF,0x00000000000001A5 }
  },
  { /* Point #15 */
    { 0x5F5321E7E13A4B52,0xDC01C122B8F57933,0x9C581932E4DDA5DC,0x17DC2A5B50EA66FC,0xFCFA39310972A65F,0x2F1D6E5E41574E43,0xACC1B35D3284800D,0x33A5A980F86EDBF1,0x00000000000001F0 },
    { 0x1E4B09CED6B8E0BF,0x8ED903E54D865022,0xAD77BEEC4B000CD4,0x702DE766E6F37BD0,0x941B9AFA1271DF67,0x70DCF9EA585028F5,0x0FB741183382BA86,0x1790C78D9754CE73,0x000000000000012E }
  }
 },
 { /* Table #112 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x6D7EEDC48F69079E,0xF02E8E404F03B92F,0xDF751116CB76B181,0xC255EB2C234C1925,0xAF997D5EA94AF9B2,0x797F3DF0D1374A41,0x357FD20B23986CDA,0xF1CACCDA1540ADB8,0x000000000000007D },
    { 0x2A04363CC01605A9,0x0D7CC0D87D7D1E54,0x0515EB70A0F9FD2B,0x725D12A9BB4EC5E8,0xD1B5B8A33A6EB09A,0xB6C836B187027D7B,0xF4773322AAF9CD03,0x2FB3354E2500C647,0x0000000000000081 }
  },
  { /* Point #2 */
    { 0x83DA529B41750B74,0x9E431A5C76E28BF5,0x225E2EB97FDE2491,0x951E2CEDE7C469BC,0x35F384CAF0E10C32,0xB8ED4A312B1AADBC,0xD39393BA7B797492,0xC82685F847597F4B,0x00000000000000C9 },
    { 0xB04E1261436E2563,0xDC3E83052DE3E4E7,0xA32102BDEE3DBBF4,0xDFB5378945F15EFB,0x34904B0B6246965E,0xCD645C46AAC06CA8,0xD4E3F322358398F3,0xAEBFE7C7A54F3311,0x00000000000001F3 }
  },
  { /* Point #3 */
    { 0xFF2FA49CF2AFAE47,0xA2C86068F9F2B257,0x73DD56A446CB76EE,0xBFFB9F017DC0A64C,0x0EE2B60D44B4A4EE,0x49939F0837C5959F,0xB302FCD178603DE3,0x03C2A2204017C122,0x00000000000000A7 },
    { 0x48ACDA9757413107,0xBD8F584D4C01CAF8,0x38F448A71AC29755,0xCC3884836D29BF3E,0x15C4BAF974401FED,0x7826E5CD9023BC05,0xC7A70D094F459413,0x1DE803C631896429,0x00000000000000B8 }
  },
  { /* Point #4 */
    { 0xABB0D91DCEF34144,0xBC5903FA42B2A8BB,0xE279EF5638E4C5FA,0xB3416E9E6D5B04EB,0x447819187BB923CE,0x58FEFA212914A3A4,0xB0456B2EE2C19F36,0x176361BBE92C1E50,0x00000000000000B3 },
    { 0xBC56A1AF824FDE34,0x33BFBFB3098A50FC,0x6E720F55AB9CFA73,0xF1E104B908E4DFA2,0xB96B8ABD77865B2F,0x69EB257AA36740D1,0xD73B946D26A50F43,0x588E4A1470CD91E7,0x000000000000007A }
  },
  { /* Point #5 */
    { 0xD1DA41A113DC8B45,0xF4886D248A639B8D,0xF3431CCEDEF9C5C3,0xAE07317D8C204A2F,0xCBBD49A1F3D6383A,0x43D3593229BBE61E,0x6BFA06099643A1A8,0x391499B22005A71F,0x0000000000000188 },
    { 0x40774A7E79D0771B,0x31987151595038A1,0xFF6DF557C48B5063,0x26C03269C3751769,0x660C36CED2D0CE99,0x71378E21D3D79EA0,0x7B2EC7EA30BE88EA,0x1B342D41EAED0F73,0x000000000000016D }
  },
  { /* Point #6 */
    { 0x0F1B2A0EE2C08642,0xC110227519FBFFF6,0x3E49142104574825,0x058232D599552FDF,0xA83F1A2F0E083797,0x7C387D90860ACBCD,0x7D8440D7D59D4FFE,0x45111FC778F12D73,0x00000000000000A5 },
    { 0x77ACF98E28E9B450,0x0823B735A8129A6E,0x1ABAA0F98D1F0EF3,0xC2FB1108DEC36172,0x4D486FD4855585E0,0x27D002549D440B52,0xC2B556135B964BAC,0x251AD413A29F6FDE,0x0000000000000142 }
  },
  { /* Point #7 */
    { 0x47DE9D47E138D37E,0x7387F3693E7E1C87,0x9C00813E0A48AF71,0x9DF47C63E8829FCD,0x7DC7C04819E24A68,0x3D1823E16942E130,0x2F4440FFA2CD6199,0xEBF60BE098168AA8,0x0000000000000049 },
    { 0x989690073B5F346C,0x00A0ECF9B79AE683,0x1B6F0DDBF8FB676F,0xD536D3717998C836,0xE1DBDA549C4BC7CD,0x2B752CA371E12239,0xD633D0EEC296C03D,0x548B37C59F6A0015,0x000000000000003F }
  },
  { /* Point #8 */
    { 0x6ED1BBB76ED0892B,0x4921306BB788BEF7,0x7200D473BF3CDBDB,0xF1CB448FEEFDCE6C,0x199B07A2836591B0,0x804FF00948FC6659,0x697600593B8F405A,0x14755BE59EF63732,0x0000000000000103 },
    { 0xD0A6D1B323383B1A,0x50C7E33BAE42CA1E,0x564B46552563BD12,0x48640D21FE7BAF1E,0x6A0B495EF7717825,0x9E4AD9AEC7DF9FC0,0x4CEEA6A6E038E19E,0xEA0E3BF8010887DE,0x00000000000001DD }
  },
  { /* Point #9 */
    { 0x4DA845A0A4851434,0x75176AA6EC7C655C,0xCB64F9E9F093C7DA,0xF80504E644BF8C6E,0x13958864001AC4A3,0x067E1167DE28FBB9,0x0EE319D6708782DD,0x90E661F3F0A8A799,0x00000000000001C5 },
    { 0xA161CAA15DB20757,0x2ADAF4E05350825A,0x5E2BD35ABCC582C0,0x9989C8FE71A3BC28,0x454827E228898A24,0xA7108D022FD729FE,0xEB2B76AD8C310F5C,0xEAFD847E634C3D7E,0x00000000000001AE }
  },
  { /* Point #10 */
    { 0x46E47ECFF0136B5C,0xF17AB7F6344965A0,0xF3FAF3B354E24A42,0xEE7C7B5B6E7035E7,0x78529226908AFE39,0x440AEFB22E64EEF4,0x08AC260A1849E45B,0x7203A8F76FC7BC4F,0x00000000000000A9 },
    { 0xF36D34EB171F3C98,0x4A2E2716E65BEA70,0xA7387FBBF8F31760,0x9E33161EB9CC24F3,0x808D8D2957715F35,0x5BCA0410150BA9FB,0xE8823A72D019F4A9,0x5E14ABE756165147,0x00000000000001D7 }
  },
  { /* Point #11 */
    { 0xD7F60F17D77089E3,0xB68B3C61A10CB23F,0x72A83575094E8BD2,0xD9A28D29915A575D,0xB30E811F211C2F4B,0x3A62FCF658119EBF,0xB692E3BB679EAA2A,0x2375E13C3FE29C8A,0x0000000000000069 },
    { 0xD613B9EA2B8B53C8,0x6AD8D6EEAEFE8D7C,0x25163969B1D6FB5B,0x6B37519E76A6F0D4,0x8FC9208359EAA8EA,0xD2A15A1D560539CF,0x35D7A7B70F7E555C,0x590426C042A30FBB,0x000000000000015A }
  },
  { /* Point #12 */
    { 0xDC6FD0B27FF5FDD9,0x663C5481FAB729BA,0xF70938531FDE9E82,0x293D27FA71F684C1,0xC05CB3D07FCF66FC,0x709D86BA11CD0445,0x1CD6D595497FA0B1,0x5EABD8A0D47408FF,0x00000000000000C6 },
    { 0x001EA477B6B64713,0x148F2B5049FA00DC,0x00106F97EFCE2EC6,0xACA11586E205CC9C,0x60D70881A6D874AC,0x37DD5C14D29F29C1,0x586AC6C8E11191B1,0x96470F229677B2D0,0x00000000000001EA }
  },
  { /* Point #13 */
    { 0x179058303A7F3608,0x172DE35E26F0FC61,0x323D2D7334D7C1A1,0x464CD498AEC45ADF,0xC4F38D5062AE054F,0x3F016202A66711E2,0xD105F907E8D33E40,0x3A102B6A75225100,0x00000000000000FD },
    { 0xC754A811DD02719A,0xE4A5EA1F4BCC6CEF,0x3D64CBA45FCC954D,0xEFE41B2C12CF1EC0,0xA8E5B613969C79CE,0x42E6FB9B288A3A37,0x1C9E65A6AAC4DCA8,0x160703B36BD7BC54,0x000000000000013F }
  },
  { /* Point #14 */
    { 0x4888C71DE2F66BCA,0x548A0A8F8ADE3531,0x0162233C6638686F,0x4D2C6AF83C30E52C,0x62124A0FC19A0DF8,0xFCE8188DCC7C56F3,0x6DA68920B8B77752,0x370DC630B622BF61,0x0000000000000044 },
    { 0xE3072DC65B51FB0D,0xA06BD9C232CC673B,0xE374DD3E991C7EB1,0x1052BBEE887D8D76,0x9B43D6DD897746D0,0xFB7797ED6CC50B4F,0x83D30A082BF11803,0x24D36DF97D78F93F,0x00000000000000EF }
  },
  { /* Point #15 */
    { 0x0158728662E9C602,0xE3F31AA9C7803839,0xECD16D810CEA9177,0xE203943E82B139B5,0xCDAE675DA59EA3AE,0xACAFC1FD79B0B7AF,0x1F3FF6B96D0E87EF,0x3C52993BD84B4B55,0x0000000000000172 },
    { 0xC8FCF451415E906C,0xF25CC44FCC223AFC,0xA0FB3F66F80C4A7D,0x6C936445EBEEC08E,0x35215495A50739C8,0x9C197B15D8322E65,0xE263F119ECC81FB0,0xEEEA2E6F37BD4D5A,0x0000000000000148 }
  }
 },
 { /* Table #113 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xD7C0EFA36EA09A93,0x95F69E09FB01C2B3,0x021B1721D43150E2,0x39FF07E05879BC51,0x0DD73C326CF50CE3,0x9D69D32A5758870F,0x5DF4CC8C1C0E91D9,0x0033508815DF54AB,0x0000000000000182 },
    { 0xBB656A89F2DC12F5,0x6C4A32BB5C46FCF4,0xF324462C70E7A152,0x4B1D509A1F7EAAD2,0x3DA87FA776E51583,0x9A435E2019FC86CC,0xB97D3F449EAB8DE3,0xC56C7C988F92304B,0x00000000000000A8 }
  },
  { /* Point #2 */
    { 0x30B495FF9B09AC83,0x7767E8A105D9C9EB,0xB15ECB0A1690A79E,0xA7B87CCE1B301763,0xC6849DEAF28B14D2,0x16D0B1585E5C94F2,0xBFDA45241AEE3CA8,0xE52961635D737C3E,0x00000000000001F1 },
    { 0x339F76CC589B8AE6,0xA133954AE02EA428,0xF11E77F7980481AC,0x890C3C2C87596275,0xE0CFDACE80B79BF7,0x0031DB26A3E3906B,0xEDF2E3DDA1C31197,0x888F12192BC3F1A4,0x000000000000006F }
  },
  { /* Point #3 */
    { 0xBA0A5D23DC831AC0,0xCF0FE6FCBD41CFA5,0x11D490D3ADEE7925,0xA8C359FC491D988A,0xB97A48A53FF98345,0x6C8AC5F21B8BB845,0xA9C9F2A85F157746,0x79125887CF6AD9A4,0x00000000000001AA },
    { 0x3DC5DB89E8469532,0xA9610220639DF36B,0x5806F730828BABAB,0x5AD5E58F60EF0FBE,0xBCDFE863AAD0A654,0x818CDC6134F936DA,0x3B6839B4D47DD376,0x80DB0098BE99035F,0x000000000000002A }
  },
  { /* Point #4 */
    { 0x394CDAF5AF579E74,0x892CB4839F0656A6,0x0ECD401F3E8E1495,0x655F01524CAF97C0,0x9712D15881912568,0xD16E997A89DBDB52,0xEEC17A551A8C4097,0xBC19E865322BBB31,0x000000000000003D },
    { 0x6B181FB67CFB9654,0x3AFDCA352D651201,0x19D26AF461453278,0xEBA73D693EBEAF7E,0x39F7171E1832E1E3,0x84B46C0E31A9F559,0xAEA096CDD89DB3C3,0x193C91E76C409761,0x00000000000001FD }
  },
  { /* Point #5 */
    { 0xE0D1A68443FD6EA9,0x3C7862854B132B1C,0xE70C8B50E1183223,0xAF7CE54667064358,0xF14E547320FB8E29,0xD26E97D6AEB37723,0x1B6CFAED357A9627,0x86CBFA6C7D572C73,0x0000000000000127 },
    { 0x41863BAA615A655A,0xA1E46018C0B8C8B5,0x91F9506A1848E283,0x8631171324F30ED9,0x0E29095F73FF5192,0x7D174A6DA154AE3E,0x6D82FCA256F418FF,0x169D74DE6758E6DE,0x0000000000000025 }
  },
  { /* Point #6 */
    { 0x327813857FE215DA,0x7375D6F03B7CAFE7,0xBB8B7A9672CB61C5,0xCB2EB8DC1F240B9E,0xBA8E3561F9E57F19,0x4598E545A8775D3E,0x766AF205795F431E,0x29EECA78392B223C,0x0000000000000186 },
    { 0x10F6A1B2AD908BFA,0x705580FE4237E6C3,0xA2FCFE9E136800F8,0x4ADBEBD20B7BDC9E,0x4DF50D526D1A3870,0xD4B714FBEADA6F88,0x39F59383DF56DD84,0x7C802A7F8EAB9BFD,0x000000000000015F }
  },
  { /* Point #7 */
    { 0x9F890CFD9421BA81,0x170442E3EB89C503,0xB9A7CCFF0F6BB510,0xE381C120CAC864BC,0x2DBE97ADDECBAF8C,0x635D5914D26D2BB5,0xE101D55EEDCF3B9B,0x80BE6609B30B7B2D,0x0000000000000008 },
    { 0x89D0182711095C14,0xC1A8BC5EFCABD0F0,0x3208EB5054AFA2FD,0xF8A273C7DF626743,0x5E12751A3F970409,0x4EA70FC5FBE47F1D,0xB03CEFDB5D85D582,0x31B9A79692740E84,0x0000000000000090 }
  },
  { /* Point #8 */
    { 0xFB24C5B4C56CAAE5,0x3855473B71A1A7F6,0x225A79370CF6FF1D,0x3CDB0634B5ACE9E5,0x46DE798D26B6384F,0xF1EDE134EBC11704,0xE80E4E37554519F9,0x812E76DB6349EEBF,0x0000000000000179 },
    { 0xB0B69F323B354956,0x27C782ECFC0D2A5D,0x2BB2EBEFA0DFF80F,0xAE8E58262C887AC2,0x2E4886170CA3BF38,0x77B1B7B434C9E517,0x5D42CA18DB708DE3,0xC1B0482A4305EAC5,0x0000000000000091 }
  },
  { /* Point #9 */
    { 0x7D41A45C2BC72AC0,0x3FEE89C1D4B22A6D,0x8C9E931B1A3E5166,0xE7A8208913C017DD,0xE13A4F368A94D77F,0xE560CEA3A2639DD5,0x0C0E75AF13998074,0x600F7E216F627382,0x0000000000000064 },
    { 0x71563E4620B92051,0x99B6CA381D59C764,0xF9BC832FA0876B4E,0x3929D722C0A27F20,0x4700D58714B56B70,0x40A3DEBF45CE0920,0xC0AB7289242D9004,0x17C1874D0192B6BB,0x0000000000000024 }
  },
  { /* Point #10 */
    { 0xDF3F021045DFA176,0xF2B8D470B82CDB48,0x85FC522E2A505BD0,0x530E9B2FA572D146,0x41DE8364D08B21C5,0x6BEAB3B9EA85A07E,0x6663CDA05098C25A,0x24877A419DEF7D1D,0x000000000000008B },
    { 0x31EBD06578A5B2F0,0x8F01DAD2F37BBC23,0x18DA4423A329FB62,0x54A3285DF5ECAA42,0x7406AE753E972124,0x4C4E37568CFC9ACD,0x724603515BB13AB3,0xD58105D5FB4202A7,0x0000000000000197 }
  },
  { /* Point #11 */
    { 0xDAEE97086C538825,0x9853E1FBAE5F9B86,0xA3C4A0444A134CAB,0xBE74A8739979280F,0x05C4C48C17C2F5F1,0x27646C213D5CC384,0x6ED0ADB6DA50F906,0x639DA5CF9DEF0584,0x00000000000000F0 },
    { 0x6598023E73B5196E,0xEC5EE4AD52880ED6,0x4ECE38075C8C0AF7,0x6A9C02EDC677D401,0x0DD4435C8AB476E1,0x6923634D2DA54119,0x10BEAF5929E6661B,0xEA400C7DF546FFB0,0x00000000000001AE }
  },
  { /* Point #12 */
    { 0xD74BE7C9D52AA426,0x44D1D8C64C6A4E27,0x3E723EF870A8E627,0xC6370FA3DB7B5ACA,0x26338D27E2060C35,0xD72D42B19198C02E,0x5229A753BA2F15E5,0xB27B26B3CB335009,0x00000000000000AF },
    { 0xA0BE1723E68FB52B,0x38A1D7E6C80555D4,0x1190A874AB9A12D9,0xB37E82A8E6BCB79B,0xFF4A6B257B9A6118,0xE816FA525E6E646F,0xD061C988EE994490,0x284FCF951F5770AC,0x0000000000000136 }
  },
  { /* Point #13 */
    { 0x7695A838ED5578F4,0x89EC15C83F9CAEC9,0xCEED49BABFDA0BC5,0x4B1216DD9B3C5ED3,0xE023E37F819C4425,0xAE0847BCFD42824D,0xB499263BA5D967FE,0x523E3456D9CF17D3,0x00000000000001BB },
    { 0x1088B82C6F4B631B,0x4660A76EFB092195,0x94400A1320D69B6C,0x74D5DBCFD962B3B2,0xD65A57086E7ADCC0,0xA61A9F5FCEEB56B0,0x2BB733268D35C057,0x8123773DBC726DDD,0x00000000000000A8 }
  },
  { /* Point #14 */
    { 0x09310E7E5BC9E551,0x9F9EA919F2DF4AFD,0x96382316A4D1662A,0x1DEF580F430F5E05,0xB6B45BA8CB9F8917,0x45409627F04AA556,0xDC64927648E1C505,0xE96E8A2F211E7FA3,0x0000000000000014 },
    { 0xF1CA16E5DEF006FB,0xBF6EFAABC2B283A4,0xE936EF62391E9644,0x7F9E24BAC3C88429,0x32DF9B6846EDE479,0xE1F61DEDC90EB639,0x60020BA3F4BEC3A8,0xCF30E68DA4248767,0x00000000000000AC }
  },
  { /* Point #15 */
    { 0x7B6DC760CDA7E4F5,0x10C1E9B4FAA5CC54,0x0AD30F5F8D94B3F7,0x255EF5C99EDA4C20,0x7D27117E93A43D50,0x46076CA007BFF0AE,0xEEAFD273E9C87544,0xBD487969AE4467B1,0x0000000000000186 },
    { 0xC987F3D47A4E46D7,0x827B5822E97EF62C,0x3B770F88B9A0DC98,0xA205366BF6EDA84F,0x5E3C7DC7465A39A5,0x7219AE7962F9B211,0x225B614B11252014,0x5542DD5838124FDC,0x000000000000014D }
  }
 },
 { /* Table #114 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x4331CDCDD6A37BAB,0x67B8913785C741C8,0xAEFFCBDB4FC72389,0xCC12E59A1C7AE6DD,0x4A35540BEE1E838B,0x6148FB60ECD3E84D,0x7319E868B2290730,0x4321BAAE4DE5208B,0x0000000000000160 },
    { 0x10C813E987717BB9,0xD9E1F5A8CFB9252A,0x0983C1F7D7BDE47C,0x7446023B5474E52D,0x1F189DE81941B518,0x1997C69BB425810A,0xE15B5F1E58BCA332,0x715DA4C949092985,0x0000000000000076 }
  },
  { /* Point #2 */
    { 0x3E5927537600C9F1,0x115DA68AE4653ACA,0xA83D3CDEA21C03B3,0x5821515780477C90,0x876E0150C43DF921,0x176767D6410801F2,0x95E1B6C9B0B638ED,0xCDA8E401979E84C6,0x000000000000001E },
    { 0x5500C69C85CB274F,0x5F2D975BDE004D59,0xCD545D2AA005B4DE,0x4D3D02AE4E3B1B94,0x53E64CCDB8EC522B,0xACC3386F12EFBB9E,0xC8F529C21CBD540F,0x8428942D2F854A91,0x0000000000000182 }
  },
  { /* Point #3 */
    { 0x2CDA398733430EDB,0x7F0593F8EE487EB9,0xE458E275D8765895,0x45C2E09311BE3DF5,0x32545B1E51450F54,0xF35BC1EE49D52CFA,0x59B8B719DA91CEC2,0x4426171BAB7FE631,0x0000000000000135 },
    { 0x17C4E11CE00A5618,0x7A6FF5B1FE8BE941,0x72E91C8C2C90C5D3,0x9F45087980CFDF98,0xB0D5D0D106CE62FB,0xD9DEB71557FA7188,0xF1D09702AC85D50B,0x65AB22B5A170E75E,0x000000000000018C }
  },
  { /* Point #4 */
    { 0x92C099D20BEC2201,0x364FA15AB67FF463,0xFB32FFD0B02F7E0B,0x5B57F9939D4C9F2A,0xBA5F437E4996B151,0x961BD5FC431462E9,0x1FDA019FDCD39411,0x8FF5288ECCDFBE62,0x00000000000000DD },
    { 0x43F49A318EF349AC,0xE4F5A626301BAE8F,0x945E6A62D2681847,0x8EF66B51857C09BE,0xDAFF64743F15435D,0x215793CD3DB84E5D,0xB2044D4BAB1BB6C2,0x4C7AC000580855CE,0x00000000000001B8 }
  },
  { /* Point #5 */
    { 0x52BEA9DBC2A1B7ED,0x7844CD85E0D786E2,0x17168D7A4D565A2E,0x1213C72B155AFFB4,0x26A4857D606A308E,0x6F0560D6B55B0018,0x7C8549E874E1B9CD,0x322BA0629DEEEC3D,0x00000000000001CF },
    { 0x0A7016B8F59FD1D3,0xA81CE2F8AEEBDF96,0x3AC89A8A0F7E145A,0x3FE8A38D70351907,0xA636FD48BF10697A,0x4C0F860D7F93878C,0x546E63F5957D25E3,0x1FD01E4A1DF8262A,0x00000000000001BA }
  },
  { /* Point #6 */
    { 0x37E766A6C64F9C9B,0x6CF5E0B616C4CE5A,0x31A2B1E27BBE708E,0xF784A55291E24F0F,0x1CDF807A1FD25709,0x2669D80270CED72F,0x79E4492DD49751DF,0x7FE014D87E7F3162,0x00000000000000B4 },
    { 0xE0A2BE33ADA43F51,0xBC88356945F6E16C,0xB3D2248EC5873251,0xD1118266E3F9B61F,0xC427E30BF6D1DD12,0x43F0925B0D8313A1,0x729DFE2A39EDF59D,0x7189F5A4FF4B7293,0x00000000000000B1 }
  },
  { /* Point #7 */
    { 0xE4EA02CF8F3110B8,0xFED60231DE50A1E9,0x62BDA5E80A8FE01A,0x882F5313ADE31339,0x30102CB926F12837,0xBBFCD761C1851E44,0x6E1C5D2B073B2AE5,0x1542324C357AD561,0x00000000000000FA },
    { 0xA8EAC464C37D1A01,0x8E5B465DAEEDD902,0x7F7B68F5FDAF7257,0xD88A2CF6B4BADB28,0xE0DFDE89E4102B12,0x9ED8DAB7AB851C47,0xBB44BD5DB4865D1E,0x0C6D69D57F2F666A,0x000000000000004B }
  },
  { /* Point #8 */
    { 0x9FB0A0D27A2AE93E,0x89C9DFA314D3224A,0xE70F39EF1EC1EA92,0x8C7C0024AD2DFD78,0xC285ED1C3C5B7C09,0xCE6436D11FB27511,0x65F427ADE3D07577,0x22AE30D26827554F,0x00000000000001DB },
    { 0x35AB2A33FE772F97,0xB26D3F9DB6B12767,0x0A55E68E6C9DA0FC,0xB481A8F865D2662B,0xA670CB04ED1FC69A,0x77E568A7F1C98C0C,0x85C30516952DB9E8,0x8A4EA765F15C664A,0x000000000000012A }
  },
  { /* Point #9 */
    { 0x3346C5DA3B8D5865,0xF9E603778F785CA1,0xCD7267D26D5DC885,0x96DDF769D69CCFAF,0x2D6DBB25D9594959,0xA04CB2836B6F3992,0x1A525509F70BA665,0xD92BB7DC62535572,0x0000000000000089 },
    { 0x11CED4D3D325263C,0x7722335F67A97800,0xC5A85F2DFFDB96CB,0x1F96D41972F44BE4,0xC1D49B3AB9261115,0x0E5855B52419B535,0xD30BC50E4BA83BE2,0xC32FC472BF33F0DC,0x00000000000001EA }
  },
  { /* Point #10 */
    { 0x5C720BE258AB3605,0x2820C97E11919F9A,0xA4BC44DBEBAE5562,0x8D6D08D350FB9167,0xDE7D84EC8006E434,0xB6E321BD9A42FFF2,0x70071B01DE4127FD,0xBB67A667F73C64A0,0x000000000000013F },
    { 0xFB25E553F31D98B8,0x70C787FBE10132D0,0xF28DE5CF258B7508,0x709924FBF8B95916,0x78EE0FEF73060A42,0x94EBA1441CA70596,0x1D9405604113AD0E,0x6EBAEB9D5EB59B5E,0x00000000000001DE }
  },
  { /* Point #11 */
    { 0xD55A28A7DC10EB96,0xAD0D50F0B772C881,0xE1574305F391A2CC,0x0406799BAF3C73F6,0xADB82A35B80D865D,0xC4AA10C63E74DDB2,0x0F9FA673A31C89B4,0x134B2949AB05EB58,0x0000000000000101 },
    { 0xD3718BCACD00F753,0xA01C7F4C5581CDC6,0x25E7432B8AE54A23,0x9F1F4BE4A8864359,0x2578E281BA8918F6,0x3DF9CA3B8527E2AD,0xCF13344198B23373,0x32AD0CE945D70A62,0x000000000000010B }
  },
  { /* Point #12 */
    { 0x4FB8B429F594DBFE,0xC57EC74F3702A306,0xA88664EB38A5E224,0x03BD2D507529C812,0xB4890478FEE034DE,0x77840108A3B354AE,0xFFB76CDC93F4EB36,0x0C211EF043C4667A,0x00000000000000EA },
    { 0xC3E39EE2336294AF,0xC13F4A278B47F0BD,0x90C93312FE8D9430,0x23E4F98C8899A8B5,0x4E623A41007C34A9,0x22F9E5D9BAD91217,0xDACE8FFFCC6F1916,0x49CDD45F2BE203B1,0x0000000000000166 }
  },
  { /* Point #13 */
    { 0xA8228EB3494EC6D4,0xF4C3F2DF66E6036D,0x4A0BCBE1987742CF,0xC95B99A8E26FC56A,0xC97D73EABC55AC05,0x4ED64770E346B78A,0x3BE208DFFF5BA2D8,0xDD2B3048D9DE7D1C,0x0000000000000134 },
    { 0xBA1C047088C3BBB7,0xEC2A0E1B7A3F7F2D,0x6714B1767A37C017,0xF37978EBFCA5DCD1,0xE12941486FE75A3D,0x563CB5467B5A6D85,0x730A871AE6255730,0x0526E4AA06B13C50,0x00000000000000B0 }
  },
  { /* Point #14 */
    { 0x71EB9485FB8547B3,0xAF1DA3442E086AB2,0x6DBD491639614D0C,0x612A6CA365E06D5D,0x2707F1B2E07C53FF,0x790F26D549783B98,0xA940F16E94BAD8E8,0x2E1A7BCADB6CA03A,0x00000000000000B6 },
    { 0x3546C7FFCCAFCA6B,0x63272D70E14CE7D3,0x27BF1E92DE8A95B7,0xA8F658B4E40923FF,0xE7E7D90319AAA4C2,0x31419704616938F0,0x60BADB4C73607BAF,0xF5A8C9F71A7F8968,0x000000000000009E }
  },
  { /* Point #15 */
    { 0xD958953F38053CFE,0xD0DCA4087982A66E,0xD1E7E8FFEDF296D7,0x89403F2546C71095,0xF9DD442A2197E27E,0x04C09109A1856828,0xE0F10851C30471FC,0x9845881CC5FBDDFD,0x0000000000000024 },
    { 0x296B2075DE6D1A79,0x31700B8125BAF333,0x7EACD4191E723113,0xE296B9124DD7B2F2,0xEC4A609C3284A3D7,0x20D5B58C0EDCD7DF,0x4AE17E8562A0A946,0x05DB3034ACD03E7B,0x0000000000000037 }
  }
 },
 { /* Table #115 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x6AD03106C4DD900C,0x8227FB5D7CA08923,0x2E3C1E7F863BA5D9,0x5F76D6BFB5BE20D0,0x841DC1D29492569A,0xFDA5B20E47E0DC0D,0x65ABA1062D720DC5,0x9EAB8FFB03E6765E,0x0000000000000046 },
    { 0x32D92252497DA0C6,0xA2D4C8B1BEB7B1F1,0xEDE29968F01C7409,0xAD902EB5DA06607F,0x2C60236C5C1E7D9E,0x51F51DDD17A3B1F0,0xB71B393F40AB7CB8,0x710FC9F9A16AC6BD,0x00000000000001CC }
  },
  { /* Point #2 */
    { 0x8A3E381CCDCD741B,0x2C5ACC0B14E8F964,0x209D040429621441,0xD27A65CB2995C3B4,0x3A776FF06EC13968,0xA2D95CA7DB4F8A0B,0xFDBC547D6C04EA3B,0x30BA75A8DB40F58C,0x00000000000001AD },
    { 0xF6406A6B84115D90,0x7D2E26AC0F228B65,0x1E17672B9029A8AB,0xEAA84D813ECF05FB,0x9E16E91DB5F5B798,0x7287DBD5E978749D,0x85880F457FE092AA,0x80B3126C514AFDCA,0x00000000000000E0 }
  },
  { /* Point #3 */
    { 0xB87CE5817748701A,0x78DA1F78A987513B,0x31ECC1E59BAC7437,0xCB7EBF5E5EC57E2A,0x2C8D057FCEE4F44F,0xD84AFB467BDFD6F6,0x565D12C2656BDE81,0x64CDDB9DF2D41D20,0x0000000000000160 },
    { 0x33049CD35104E3C7,0x6EC3C08A8A8F3D05,0x63EEA672E2434E6E,0xC75968155D7D27C7,0xDB96E435EE0FB5A8,0xCA501829C2A4663A,0x5A013B22CAAA6091,0x1A0E1D4938EC2555,0x00000000000000AD }
  },
  { /* Point #4 */
    { 0xADBF4F9FAF2ED12F,0xCE1D19E4F380FD8A,0x0957BDB5A39E81AE,0xF9833321626EF6BC,0x110AE5EA0CF5B28D,0xAB15945020392CD4,0x67C498876BC67855,0xCE7E5938A3FD61C6,0x000000000000004A },
    { 0x59C5B9EF28C7DEA9,0xD02F95BA0A6A7184,0x034DC2578202769C,0x213B0B0894DD6896,0x03730B7FB5DEA95A,0xFE243ED0617CA889,0x16CF4D17FB1BA052,0xD8691D6B226F96DA,0x00000000000001C0 }
  },
  { /* Point #5 */
    { 0x07C4D08BB979B88B,0x2D169E141639BBBB,0xCDCE5A6BC125D4C7,0xD8BDA07E3BB896E3,0x8EDDF8B42CD77F48,0x70F6F21BC16BED6F,0x468A156C88A26D82,0x97B788ECCE174F12,0x00000000000000E9 },
    { 0x95F380195C89D533,0x81B5D1CBC2F6C63C,0x797C11DD23901AA3,0x79008348126C2418,0x2B5B4E688D61DB44,0x27F6CC87A2804DE4,0x636D1764DF7586F0,0x406500179D1F8E00,0x00000000000000A1 }
  },
  { /* Point #6 */
    { 0x3E43CC8BDCFC1DC4,0x7A25626F60D46E73,0xAA1AB12C10092DD3,0x3C7E6E0B747E4D4B,0x724E943A940102F8,0x2F881A5A010CD49A,0x8E3D40C9E28D7E06,0xAE405982D0249C5D,0x00000000000001D6 },
    { 0x626C5C9EF1E2D126,0xB2CAB943295A547F,0x31F3B4BE810044A4,0xA7DBFFB14D8378B1,0xDBC4164F2788F2EA,0x7B26E83D4E6107C4,0xA4406B65452E34A6,0x667D71FD58C1CA9F,0x00000000000000F0 }
  },
  { /* Point #7 */
    { 0x2AC801BD76B30FF1,0x047ECDAA4DD813C6,0xAE2B98AAF17A07C0,0x1993806133E55DAF,0x4AA0D6882F94190B,0x41FF7A4769BEAE5D,0xCA57BFC18BB828E8,0x537A689D61465132,0x00000000000001E7 },
    { 0x77564B28C35AFA1A,0x54513990B3494FCD,0xC5227210E61C567A,0x2099E39EDC29D37C,0x659953B5608B4F87,0x873ED05487BC7D59,0x0F5CE1A9B05875F4,0x61F3E3A4523BD9A3,0x00000000000000C6 }
  },
  { /* Point #8 */
    { 0x15A257C527A668AB,0xA437F499C920D8DF,0x297B6764D4CD271A,0xCBEDD33B87CE8D52,0x4AB3B76110385C75,0xCA68612323436B58,0x44D5A94D8D52F4E5,0xD125E021605BBA0E,0x000000000000001E },
    { 0x578CD28335E40C74,0x898F4684244EA58E,0x158AE785154FC334,0x466C1C29D8D62231,0xEF781790C48B1013,0x7A902E83C3253275,0xD0AAB751B1AEAE85,0x89248D120ECD9B0E,0x00000000000000E7 }
  },
  { /* Point #9 */
    { 0x7C373B2AB22C49C7,0xBB599F461E4FDF5D,0x773BBBF129756598,0x30B9948AC88D98EA,0xA502B3FDA3C24F44,0x18D1A20673CCBA25,0x80DF2E35394506D3,0x7F956E6902150FD3,0x0000000000000091 },
    { 0x6F94FE0AE94A09F4,0x8CD27FB7D02E063E,0xD16522D40D164FD7,0x959758076F0D8D20,0xCC10F8E9A32FB87B,0x6069AB1BA60944AE,0x630AC28B9D5A48C1,0xEFC6DC99B32E141D,0x00000000000000F0 }
  },
  { /* Point #10 */
    { 0x177F6AA6F2483C48,0xE3A8A75B1C37E5C0,0x581177FFB5D31892,0x29EC3A878725749B,0x9059C66886BE8A21,0xBBAAE7806F32A24B,0x48E80B7C7F23910D,0xC3CDB89DE06AF949,0x00000000000001F7 },
    { 0x8DFA10FABFFA57A2,0xDE5553E2125D836B,0x0DB03963A7D8667F,0xA1B3108296BD0EA9,0xB1F348FF542FFE13,0x754EABDB39DFDFAB,0xA098F99D8436D353,0xC27C59D1A5996169,0x0000000000000100 }
  },
  { /* Point #11 */
    { 0x1BD81509ED7FB4E0,0xC0399AFC8F740759,0xFD77CD44E1917C22,0x5DF3F8DA28E9E6B8,0xEFEB37C094C4D3EC,0x0225A73C72790DF6,0xA3DEFABBF380982A,0xE27111B42BE4D6C9,0x0000000000000176 },
    { 0x941457F5FCB3B499,0x13853C55B32EC283,0x9FCB6C96083BE23D,0xD569B317158675FC,0xC3443DF08E72C7A6,0x86D562EA6C7876A7,0xB5874BC0B246C643,0xCA850C2FEB3E43C6,0x0000000000000011 }
  },
  { /* Point #12 */
    { 0x92E5BC5C8C7671DC,0x0EDA1A20215E6B5F,0x158462923104E97D,0xD0513D5868BFD00C,0x3439D9CDBD88796A,0xB3D0C7919EC37B3D,0x8E0AC88900C49D4F,0x3EE90CB4441E1F08,0x0000000000000079 },
    { 0x24C36D60FE7E66EE,0xFF0AAE245F990ABB,0x78308E0D041B19C4,0xECAA1B05C7ED7C0E,0xD1D45E1CD86C1272,0xFF74E3E91B7DDD34,0x17B6D9984948D333,0x1D2C2BAE12EAD07A,0x00000000000000C2 }
  },
  { /* Point #13 */
    { 0x0C3175F5ED359803,0x4FB91985EA16D5BD,0x789A7A4AB9239029,0x2011B47C83C7DA5E,0xEC45C8710BFD1367,0x486DAA0332D275CA,0xFD6DCD14D741009A,0xEB2E4429BAB847B5,0x0000000000000182 },
    { 0x400E170A33A84E4B,0xF92DF616CFADE552,0x8EE2D428ACDD9921,0xBAA0F461839F6A4B,0xEBB80BB16FEE4D71,0xE2A664494C1DBD42,0x494AD2F046D77533,0xA5CD7C6E0E82BEF9,0x0000000000000003 }
  },
  { /* Point #14 */
    { 0x38AB25BB09235A3C,0x9CAE659A532BEBAF,0x251266FF22C5C31D,0x21A9D5FEC9474AFF,0x2DC1E1054FCDB1BB,0x2FDEC51B903A61A5,0x8E552F4B77AD19E6,0xE73D2406E7BD7B87,0x00000000000000D1 },
    { 0xD6B98B75B1C6211B,0xC21FCF5CA86A6DC8,0xCBBF5160714A3077,0xA637D131F834E645,0x9AFA24872BF5B1B4,0xF71DDD03D362254C,0xF991B6D66E38BCB6,0x565D0EA74288E5F2,0x0000000000000196 }
  },
  { /* Point #15 */
    { 0x5FB4555891BB5BDB,0x9FC6FF6070CAE47F,0x5ADE5C952B5C3BC5,0x73F547E16E189A54,0xB5C56E3C4E71DAAA,0x49AE06D01AFBEB0A,0x2F33D608FEFAE4BF,0x7BB6B17FBDE74130,0x000000000000017E },
    { 0x11BCEC29C26C99DF,0x5314AC55E0892000,0x1DEC3749116656AC,0x605EC0F927B381C2,0x686B09CA15D946E8,0x5714A4F9F175F081,0x88978A53D2EED173,0xB53B27CA8B7161E1,0x00000000000000CC }
  }
 },
 { /* Table #116 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xE12D8922CD5F918F,0xEC7C176349F73F1B,0xCC5A3A14C744EB3D,0x2B96F342782DBDA1,0x87284905AB68DDE4,0x647354B9E720668A,0xE07DA694739C4393,0xBAE499BF2CC145F9,0x00000000000001AE },
    { 0x74EEEAA477C16DB0,0x297624E8EB22CE92,0x9D3944BC45098C91,0x6FF31FA0FA4DC50C,0x3C7FB6DACC40C211,0x74D95DEC96B4CD1C,0x829423DBA6388941,0xAA2B7D45FC3123B5,0x0000000000000119 }
  },
  { /* Point #2 */
    { 0x404216DB33849BA6,0x7979AB027B42813F,0xB0CABF29117E27AA,0x3E449CB65A0AB76D,0x34EFBA77460B6964,0x7553E0A66FEAD00B,0x8AC8857116963CF0,0x01716CBE017AD9D1,0x00000000000001F8 },
    { 0x30CFE5C1D21FBD36,0xC7A0E466DF1FE3B4,0xCA38FD1CC8EA2C29,0xDE2E20394E54630F,0x3B152EC3885B124F,0x704A1D76D39818C8,0x0E74A9825207D2C2,0x2B2DC7C8EC4D71A5,0x00000000000001F8 }
  },
  { /* Point #3 */
    { 0x01EF33CF16E0F612,0xBCCC51C3EEB7A33D,0xCC35C1E346A12C50,0xD2151223B915B370,0xB03030143AFF625F,0xB7E34E67B76ED5C4,0xD5B48E2210B988F7,0x5EDADA0557F1882F,0x00000000000001EE },
    { 0x70919A6126A93C88,0x2729BAF111491A74,0x895470B5541B2E39,0x88E52A03C85FEF39,0x605D48085B35AD5A,0x3203783C87561036,0xAC1C8568546E9DE2,0x61C5703C62D3BC75,0x0000000000000192 }
  },
  { /* Point #4 */
    { 0x493D8A3FCE43380A,0x27D1657B1511E823,0xF09125A7E6112ECE,0xAFD3F48218C2DDC1,0xC1207AC1602AB092,0x22FDFE83F80FE3F9,0x736AD27FF479C304,0xD1FC1905784CA960,0x000000000000008F },
    { 0xE87798D27FB35409,0x86B0257161CFFD40,0x12D991F963058303,0xEF9E933E033F10C9,0x8221774CB298A118,0x95DCFD1080DC2858,0x83747D7168BFAA1F,0x03567035A213129B,0x00000000000001DC }
  },
  { /* Point #5 */
    { 0x15AEA420D5AC5D48,0x6E11BF30178C5A77,0x01F1180D2651DEE6,0xD7602ED459E7A8F6,0x5D3EC901DE3746DE,0x314D1580E2400304,0x08F8259265F15588,0x22E8FF88D9FFE64C,0x00000000000001D2 },
    { 0xF3F23ABC99E0F136,0xEF5D94840F1AE78C,0x616E957FF6E34CA1,0xE2E237B080B7054A,0x7987761592BAA214,0xCD321299DD291296,0xF9B74ADB20D8BCF6,0xEFCF323631661404,0x00000000000000E6 }
  },
  { /* Point #6 */
    { 0xEAA89410F084380F,0x9491F70E458AB9E4,0x6B6772051D8EC684,0x1A9FC7951EF7E9ED,0xC47E84EFB05C41EF,0xEE377F78C6014E09,0x91D14A75521171EB,0x1B11FBBC32361217,0x0000000000000111 },
    { 0xF789CC6BA63BC7A1,0xBBD74F359393B5CB,0xB43FF6170BB024A4,0x73800410A844508C,0x93A28632C5468780,0xC96C62E52AEFA8C1,0xA500CE0B7DF9B61F,0xB59527F2369F304A,0x0000000000000172 }
  },
  { /* Point #7 */
    { 0x68B81BE9052D2EA5,0xEADFB53105294D6E,0xCD41F773A3258647,0xF6B1C867D70FD9D0,0x9A89CC017BE523E7,0x2499D793487EBF56,0xC82CEFE8C0D072A2,0x91C2BFBBE82CB4F8,0x0000000000000105 },
    { 0xD705CF5A6705DCE5,0xFCBE204E4462A67C,0x5E198BC3430D627F,0xE13DA562E765991F,0xB6CFCA287032C5F8,0x0868D9AB1783308A,0xC5B628C6C8050C8C,0x243E2EC13A93A8DE,0x0000000000000139 }
  },
  { /* Point #8 */
    { 0x461C1512910F4978,0x8CA7F0DD63D2EC28,0xDA9297D2607CE3C5,0x592BA13F81BB2DBB,0x157D4AC7F740C331,0x1D5311E782C49AE7,0x5C3046713BEC9A94,0xD81FA25B0A23AB8D,0x00000000000001EE },
    { 0x6D8C6EFAF51614FF,0x20CFD353868B4FBC,0x9B9DBA152201AAC2,0x6BBD8DED8D1900D7,0x6CA3E71AFA946925,0x7381E45AA0C3735A,0xCD9DB7A2B93D4FEE,0xAE40115145BDCE69,0x00000000000001BB }
  },
  { /* Point #9 */
    { 0xB20D7FEF01DD7411,0x9F9A104047AA41C0,0x37677F41AAEDBFB3,0xE3E23E4722350C64,0x93964E8A30FF0CEA,0x956A88124B5B4758,0x6BAD595E7552AFF2,0x0DE81B3D2B93308B,0x0000000000000199 },
    { 0x64899C662F0BD592,0x41616275F3969762,0x8CFC9DDAC434793A,0xEEEBA2D4CDF048F3,0x6F2D05B12B87E0C5,0x1ABF46121BF8117B,0x674DECA6B630A10A,0x061CCA5779ACDE0D,0x000000000000006E }
  },
  { /* Point #10 */
    { 0x19F565B51420DEBD,0x9A19AB6E5291FE77,0xD729FFF2B428AE74,0xE237994C6D8256BE,0xB74F543CD93D3E98,0xC460E7CFD599C9FF,0x6BD6D31F7924EBF9,0xAD07316CCEACB2B2,0x00000000000001E6 },
    { 0x1436F3231735FE0B,0x2E13910896A8983F,0xB18C48FC100CDB54,0xD777496C81E38CA4,0x9DBC2D4457BBA02E,0x0B5949A121C1D384,0xD1CDB9B170E6D68D,0xC6B803539621E4C9,0x0000000000000164 }
  },
  { /* Point #11 */
    { 0x8AA2FD3A0324BBAA,0xFB02DA2E28CB3EA1,0x938876146493B3FD,0x68C6A8A4DA6D66B5,0x31477D83222398FC,0x9498701A98DA59D1,0x73EAFD532BDD61A1,0x6DEA3D8CD8B1B1BC,0x000000000000005E },
    { 0x30D3C83A929E403E,0xFFD69CA5C2C1881E,0x36E2DD8F21383E3A,0xC0702450C42CD33B,0xDC2BA2AE01146955,0x74AE932A3060EFD3,0x1F01D81B1F96136C,0xED2A00CAA434D7D4,0x0000000000000121 }
  },
  { /* Point #12 */
    { 0x90D2DCF1251FE06A,0x4A9E61312213EDB2,0xA86CC889DB34C6BE,0xC7C9EF492FC20DA6,0x62831AA947AAD9D8,0xB8EF1F7F79AA0E99,0x4D8254A91E016254,0xAAEB6757C5CEA077,0x000000000000011D },
    { 0xA8F5E18502F4709B,0x3CC2096D28F8FD0C,0x6D384EE1BBABBCDB,0xAA16805EDC2FDC58,0xD5A61658A4D13408,0xAE9C4071255C1B61,0x1588A828A6436D33,0x0E07BAD24E74D1A7,0x00000000000000C5 }
  },
  { /* Point #13 */
    { 0x3AC08717B8501555,0x884C3347812FBEE3,0xA934580777363609,0xDB4DE6841AEDE158,0x6D3850EA6312D55A,0xD4247574A47C5A6E,0xB5CD31B2047C8EBF,0xCCA5ED851D8CEFE6,0x0000000000000124 },
    { 0x4AFE51372A51A7CD,0xD28B0D5DE510BA3B,0x1AC5ADE85D1C1D2B,0xDDECD8024D330DDD,0x7F03C6419259BC0F,0x9901F74BB3CC0E2A,0x997B76D0ADEE582F,0x4562419478DFF0F3,0x00000000000000AD }
  },
  { /* Point #14 */
    { 0x0261A6571304C934,0x86E5B425F4254D3D,0xD6B8C7293330A402,0x67EE96544281090D,0x3056A9113A1D5FBF,0x7DFC3E9E98494B38,0x12C53A18777CEA04,0x2CC4FFEC23165E61,0x0000000000000005 },
    { 0xF16C1E271D3C8DB7,0xC4954310AB46CA93,0x1A5A066B158CFE00,0x62B499A9F192E1FE,0x0C9A5E489A9BB573,0x2907B4FB630008C1,0x9C832DA019AE083A,0x6159DAA1C26961F7,0x00000000000001F5 }
  },
  { /* Point #15 */
    { 0xBF9C09D3E9B072D5,0x627E64871ACEAF57,0x21938240829175EE,0x781EA3F25BC4D226,0x996532ACA6726027,0x567DA8151177E922,0x9B3FEC8AEE0EA637,0x793F1038091EEEF4,0x00000000000000DE },
    { 0x30A23A7581D2A890,0x41F22A0C973E9BA3,0xDA3E78685C1A136B,0xBE524C93084420D6,0x53518E4026661908,0x7BD7C768FA169B4B,0x0477E8834709E45C,0x41B66D3827ED78A7,0x00000000000001A0 }
  }
 },
 { /* Table #117 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x2BF35F94AB7A841F,0xDCBDA33878E3FB0D,0xB913947AA0195F98,0xC8E30A9C4370E51D,0x8A403E1FF0E558EE,0x7DD167C4606DB1DC,0xAA343CBE5827EF91,0x1404F2D6AACE0F43,0x00000000000001AC },
    { 0xDFE19EA53DB1C500,0xDD04717148EF4A56,0x38AB939EB9A5EC76,0x8F2D56855648F852,0x7F81313F2726F67E,0x41CF3794F68F54BB,0x9D400E52DE14D6EC,0xC046FDA14C9EB1BA,0x000000000000008A }
  },
  { /* Point #2 */
    { 0x563F57FF87744684,0xD8F2F1476562CE2C,0xBF323B07CE7B4B70,0x67B2111A9098ED36,0x0C8A85C10B687259,0x23A569D745D51E50,0x6643F19B88D97057,0x1EAB273A875181D0,0x000000000000013E },
    { 0xBD33DE9418A1BFFB,0x3EDD0DF89700AC60,0x3757DBEB61839145,0xD31A9AAB1A59A97C,0xCAFFAFA2FAF790EB,0x9F36C13414676E8B,0xEF6EDA5B18545787,0x806A74C509AC46A4,0x000000000000005D }
  },
  { /* Point #3 */
    { 0xCAEA17BBFF4EA449,0x42EBAB1A91F114A1,0xE9489571EB7FFC78,0x6C12E907B86D5BDA,0xD483CA521FB55F3E,0xFE15CA3E1E51DCD5,0xAD186B4C0DAD4105,0x7ACE57781700D1C6,0x00000000000000B6 },
    { 0x41B4485011878A42,0x4DC4219DCE2799E7,0x44C093F5AFE8A462,0x279646F918CB2F21,0xD6722EA97058E005,0x837D0A0C02536EB9,0x6DAF4C155AF19397,0xC4DC5D395BC8A5F5,0x000000000000014A }
  },
  { /* Point #4 */
    { 0xE6B236300DE2A07C,0x64D219926E52BA0E,0xE5786EDA68D1E768,0xAD163F8ECB6A04F5,0x5A09908A101039E2,0x8708327611A5F49E,0x231D61FB5446A61A,0x39E98AD1E7DDBBA8,0x0000000000000185 },
    { 0x54CA5F0F3861F6E7,0x0E0F1667D20D86E6,0xCF229FD613D9ADAE,0xC8852AEDC488EC9F,0xFEE0C03DEE1061E2,0x7167271A35298521,0xF4FCF268FC0CFD1C,0x645A9D2FDF809AF6,0x0000000000000057 }
  },
  { /* Point #5 */
    { 0x26AD8924EB2A9463,0x0050762D65239D57,0xEED3D2E9455C9F95,0xFB1C74352D4455C7,0x830EB782FE101F88,0xE63914BD57709E8B,0xFE87CD37C5E4CC3B,0x762CF1BA1F4CC628,0x000000000000004B },
    { 0x4DD6AB0161622EA8,0x7A53FB7DBE0AD8A3,0xD58DAAEAC33A6AE5,0xE23B2139DAF8D9C8,0xC6AD81D822B6A3FA,0x0065CBD7D183D49A,0x323363CCBAEF9EF4,0x595C7048591BB7D9,0x000000000000009C }
  },
  { /* Point #6 */
    { 0x38C2B6BCA021CA92,0x715F2BF72D1C900F,0x79D4428F5DCE0826,0x7466180355B0F95A,0x59D9BA60059F6B0C,0xA3A157EB1CAD0687,0xCB4E3F7AEACFD2E4,0xDEA5CBCB1E36AD17,0x0000000000000090 },
    { 0x49B0C5BE4040F60E,0xD354D658CADC11BB,0xB17F1AA48B5AB35F,0x09956859856BDC09,0x4BDD06FFF18DA95B,0xBF66D16D235E890A,0x57D83D0076201868,0x0BB0291F91E1A0C3,0x00000000000000E6 }
  },
  { /* Point #7 */
    { 0xF6C5E153D962CB5F,0x02C33715008897A9,0x8334420A353A9BA0,0x0369DE7F27081621,0xDAEC433789AE3E70,0xD0D2FD4E320628A4,0xCEEED59FB527C311,0x3111DE80E4C12CF6,0x0000000000000127 },
    { 0xEEF5D0484D578154,0x2A752CC835E6A046,0x1DCC194AABB9ED8E,0x6E2E65BB98C92EFC,0x780C6AF3BAE89E78,0x6C0509E69892D5E9,0x4C2CF9EA01F3BE0A,0xC9C5FD50B1563854,0x00000000000001AA }
  },
  { /* Point #8 */
    { 0x7A6B3FCB3B407EFC,0x05F6D0A3063CED31,0x4A79C880F3F03BF3,0x94181FFF7A1438C8,0x47FA4E4956106ED0,0xAA97355DFAF7201F,0x1264069E02F7C119,0xF702C7F04D06B273,0x0000000000000187 },
    { 0x368DCB7AE7E258BF,0x5F8A64EAE8E4597B,0x98BBCF2B6F13BCCE,0xC00C8E627D099F3A,0x4803C4005E326891,0x229DEEC9342BADBB,0x3B810A6F49E0992C,0xFB55C6CD63758695,0x000000000000002F }
  },
  { /* Point #9 */
    { 0x18B17AF20D879EEF,0xDC4B92C480B21046,0xF35B838773E3FA24,0x6F9335943003B07E,0x25668F5E130AC323,0x73CCFE56381FAE74,0x805C30A50AF14E55,0x3C3F10C2E8970438,0x00000000000001AA },
    { 0x73E329E9818DFE39,0x5683D23C70D7A80C,0x33BA1770B52FD7BF,0x66E9618241CE28B3,0x695F2186A280CF2A,0x895B2AD2203C3255,0xA2549DEBAF31051C,0xD25E38BA2FA670BC,0x000000000000003A }
  },
  { /* Point #10 */
    { 0x07DA16EFBB07562B,0xB7F9C5DBDE14C8A6,0xE687783FB79D420B,0x14FEC271567CEEC8,0xD765D3336D608C4B,0x70E67E3A92960599,0x24060DE6D9A5A16B,0xADC2FCF91C6F83B5,0x000000000000014A },
    { 0xB78D9AD205AAECB1,0x8E984114BCDEEDC1,0x0BD480509394336B,0xFB533F263A0AEA2C,0x6308AA76B8C58B3C,0x80124D89F64D3A4F,0x58064B407BC9E04D,0x64E21D55ADBEB1B6,0x00000000000001BF }
  },
  { /* Point #11 */
    { 0xF2D5CFF6390AC5AC,0xD80AF0017840B7E1,0x6BB925F535695B5B,0x3AD3F6AFF0E76C66,0x33CE758B6C9BE77F,0xEAE5A7A75EF5858D,0x1FC3392B2AD757E3,0xFEB79DD4BA0183E0,0x0000000000000155 },
    { 0xAB1B92949C3D6752,0xADDD3402863482C5,0x2754CD5D064CD12D,0x3B009B7C37FAE585,0x692EA94842660C5B,0x238C05815D723DF6,0xE3F1D8CC7DC75771,0xC641DC205A049593,0x0000000000000186 }
  },
  { /* Point #12 */
    { 0xE0096D0F5C98771E,0x05C2327096228CE9,0xB38F45ACCBC9C99C,0xF44D39CBB7ABD830,0x583A57461600275B,0xE7911B696BD758E9,0x54545D59B691C578,0x0B03C85C8394C30E,0x000000000000002A },
    { 0x988AC22042C8FE20,0xDE56A00B7832FC78,0x8EA363BAE0CD6D15,0xFDCAEE21CF51CEA7,0x104BD64CCFEE6E76,0xD9A935A575E0CDDD,0x775CBDF5DA1BDC5C,0x019215C361758097,0x0000000000000113 }
  },
  { /* Point #13 */
    { 0xDCD82D6F60999369,0x4577BC41B4DB8651,0x6159A181F8F37926,0xA8A1AEAB64B29A3F,0x878F2C139E18AD91,0xAEE5BB74C0F2EBD0,0x90FF4496C8B9AF28,0xB1D535E88D9FE206,0x00000000000000BA },
    { 0xF4348881A8E16FF2,0xD0FA412EF9742336,0xAE8DDB3C29C5C38C,0x57463916A6F0F9C6,0x9FCBB7BE45AE6F72,0x12A18F6C7A47D8FD,0xA8C7263904E2ABA6,0x25F82852782DE3B4,0x000000000000007D }
  },
  { /* Point #14 */
    { 0x26AD960425B64FA7,0x65D59ABEA783EACD,0xA2C81FE86F55F993,0xDB6068B8FED6D301,0x52F76E9ADD95612B,0xCE2060F002858A68,0x369C2092FF3912CD,0xDC2D072AEAC4C085,0x0000000000000117 },
    { 0xF6142267DE8E4075,0x74FFA58005E07ABE,0x13331F5DBEC8999F,0x08C7046124188D1D,0x63A12765A9375CD0,0x5AFE946F3B9F95CA,0x2CED26B921E69960,0x614458D7512F10CF,0x00000000000000F4 }
  },
  { /* Point #15 */
    { 0x9EA3A8CACACEC3D8,0x4D4308439E29C71C,0x888B0EECC39958D3,0xFE7615FDE6CE67E6,0x75A05E9168C9D3C7,0xFFF7B4A04A321D9E,0x1E3D1334E04B9807,0x3B437C5CFCCDCCA6,0x000000000000002D },
    { 0xAB2788A29314CDBD,0x4B71B816B692A742,0xDDA402F1FE4D7AA7,0xA4F11BFC0F9E5453,0xDBFFC3A5188AE92B,0x99B924BB7025091D,0xE4638173284E2029,0xF8E93001ACBD2399,0x00000000000001EA }
  }
 },
 { /* Table #118 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x02FB84FD5F7ABAEA,0xA238AD04E991E445,0x0D9B2D417C972ADD,0xAC2439F9478C558A,0xC3C78A2C1EC86ED8,0x3735839B2D3B2F29,0x259728D450317454,0x7B53A9CBE2377ABA,0x0000000000000179 },
    { 0x95F44ADD5E4846CE,0x85D2A8E87211225E,0xCBF0ABD8091A6646,0x9D8B3475102DEEAA,0xE2A0A4AB602BA91C,0xA6276D7F131DE0D4,0xBB90D1175F215C70,0x49A60E3E07E3AA82,0x0000000000000019 }
  },
  { /* Point #2 */
    { 0xCB30076118E71DD8,0x01D2684604886B27,0x22871D7B7CC1D69E,0x1D138A47D0B3CAF9,0x53AEB97400A7C0B0,0x712AA1A2262F9366,0x58C84DA46BCAE07A,0x521B7DBCAE8708B5,0x0000000000000045 },
    { 0x03BD36438D3CD884,0x20A737EE1D62A335,0x37E1775F904F5C53,0xB76783DD3BAA91FD,0x7C5521189A84E971,0xD085796E4488EDE7,0xB418E7085068D6DC,0x4417E81AE5275A73,0x00000000000000D2 }
  },
  { /* Point #3 */
    { 0xEE2CA82B76F521D5,0x404C95B98D54184C,0x7EF78330D43E178E,0xED67F94305F36BD2,0xD734F6B845F09837,0x8760F0F7BD8F5A29,0x2E7CF02112059285,0x8D0BE801EC54D3AF,0x00000000000000A6 },
    { 0x51BA60C971042440,0xEA9C35AE614A4512,0x006BBCA51D410F81,0x3D31AC431170157D,0x69B0BE25FC7E723B,0x6DA152BA38276789,0xBE486C0593492808,0x3FD119D980AFA598,0x000000000000008C }
  },
  { /* Point #4 */
    { 0x099C2888D6C5B0B9,0xE35CE1381FFE8A3B,0x133C35CA74939411,0x13521B322FF27AE3,0xBDE73625F760A06E,0x199340715EE54408,0x69DB07E102F9B217,0x1389C23586A5E6A5,0x0000000000000112 },
    { 0xCF5B0E89CA1AA74F,0x0CFA76325D844CCF,0x04BE199C65C3286F,0x483E0FF9D204E249,0x9DF8CE9704C424B5,0xE35CDA3EC05C0793,0x8A595DF3F2798180,0x7522B808FBE7F5C9,0x000000000000009C }
  },
  { /* Point #5 */
    { 0x14596043E92E85B5,0xE3CAA4F1309BCC86,0x0946EECD6A004131,0xA8F39A0A5D559370,0x2907F0FB9DD39852,0xD26639C2B3624B6C,0xB45F0D32034709B8,0x0AE962D48065C9D8,0x0000000000000144 },
    { 0x3DE036A5D521ED0E,0x5CE0990022E88BED,0x2170357D527F6BE6,0x7CC9E9FF5B47A6C2,0x801FF33B9748EB94,0xCB3961D6372D1840,0xC3DB0B3BBDA53A97,0xFFF1A0789BD74F00,0x0000000000000127 }
  },
  { /* Point #6 */
    { 0xB758F2CD23509208,0xD4F7AF5088BA1557,0x8FF26BBDE472D9FE,0x071723868960AC4A,0xF63E404E9025DE52,0x05053C3FCACBCA10,0x55AD71F0E90CDFB2,0x25D5716580E65089,0x0000000000000125 },
    { 0x5DE6508419A94651,0x9AA2DBC01BF9C999,0xC97A237737D94752,0x9963D33CA4D21F9C,0x679F837FD92C494A,0x1876A9CC69FC4047,0x028E4EDFCA690225,0xA49474168359A44B,0x000000000000004B }
  },
  { /* Point #7 */
    { 0xCC51CB4B1AA88055,0x55C2DFC46DAC9C77,0x4E0019AFFB5E8DE9,0xD686F86DD0D60937,0xFE4BCB522F3AC7DB,0x102ADF661CBD8B5B,0xFE830C11F89AD228,0xB635E0E1969B169B,0x00000000000001A6 },
    { 0x6B51C9ABD5B1C229,0x1D2912BE9EE262CA,0x6208F3DD838C6D6E,0xC3B9A9E5D6E11544,0xB88E99336A2696E9,0x81B5B9C8EA9D3206,0xA7F2F30243123369,0xBB51E48673BC3A3B,0x0000000000000113 }
  },
  { /* Point #8 */
    { 0x5EA6D7EC70BE25D7,0x7123951418497519,0x86EC4211661279B0,0x3C673364D41DEB71,0xC7F5BF951884DB68,0x17EB082E77ECEC04,0xEC159BB14CCEF5A8,0x630D61DCEE69D948,0x0000000000000130 },
    { 0x0D0DB8B4C1A69DF7,0x28590B46CFC11ACF,0x5137B85BB19D5A7D,0x6069874DA376813A,0x871126092AB28149,0xDDC1900069E6D09C,0x7B3544C70114F9BB,0xAE2D081FE842291E,0x0000000000000110 }
  },
  { /* Point #9 */
    { 0xAD58DE78C2D5D1C9,0xE76999412663ECA5,0x13AE59907FA5676D,0x61D9B210353A23B9,0x9FA9CFFBE6A0555B,0x8E1DF27432E08907,0x02D035BCDF885E1E,0x8EFA75FD6B09E47A,0x00000000000000C1 },
    { 0x2746583EEF652E49,0x82BA2F66C93ABDF5,0x7A70DF37FCDE98F3,0x5D73F502142D6C0B,0x61370D1431834EAD,0x787D9608360F6136,0x26798865175282BD,0x017DEE66A21FC0BF,0x00000000000000A6 }
  },
  { /* Point #10 */
    { 0x7AFA2C3A9E92A5F6,0x75CD2C6789784CB8,0xDD01E1780A59E07C,0x86DC65D50E7528B4,0xB124EA2A4C554372,0xC6F1E5D2F95F09E3,0x7DE3424F073B2F7E,0xDCAC44003DB21EB9,0x00000000000000F0 },
    { 0x4CD11A8DAE8C024A,0x6351D5A263CA12C8,0x2DDFC5F173BC30B6,0xDCB939F25716FCAA,0xA1A23AEF83C86FEE,0x36578052FE2E7E82,0x8C0D6F3E7A4A796D,0x6F649F29FA3B1961,0x000000000000001A }
  },
  { /* Point #11 */
    { 0xC00C140E0DC53AB1,0x5961BC166E181EC8,0xF68BB1E268C64D48,0xCA74873DD29086EC,0x8016A81D9D7B635F,0x1F603DB286E7208B,0x31D02E4F9BECC143,0x82A33F2EAC5053E3,0x00000000000000EA },
    { 0x52526AC75CECEA10,0xD083A3046F766D5C,0xDB2B1C23502B8CC5,0xA9B74520B6505FAB,0xD8DC8455759D7E71,0x0D5F5B15E180F598,0x7B81EBE7B7AAE8AF,0x6EE1C6026B57D9BE,0x000000000000007F }
  },
  { /* Point #12 */
    { 0xBCE71629B3927594,0x6781C1731C5AFEAE,0xD57A86273384BB8D,0x02E7100E1FE96C0C,0x2C8D4F255028650E,0x63A4C14EBC9DAFEA,0xC5BB0CF8F48DAF40,0x9685A90699911D7A,0x0000000000000136 },
    { 0xA675E8B74D859439,0x24AE8C50A57FDCA8,0x5AF5EC7BF20B54CC,0x55DD9EE63B18459D,0x47C7E1974AB91FD7,0x088B18BEF3679FFB,0xB29972AB11EE8709,0xBA0449E58E1D2EE7,0x00000000000000E2 }
  },
  { /* Point #13 */
    { 0xB77EFCB9E07C115F,0xD5B6ED5FF24ACACB,0xC2205626022D39BA,0xB7218F28AB592008,0x996BD8275862B90A,0x36553C5759770258,0x20338783AB89BC30,0x696D72EE9C8D028B,0x0000000000000129 },
    { 0x6F57F9A7CFC61B7F,0x08EFE02355E3FC00,0x6CBC217A9CFD993A,0x4F4762E252BB03FD,0x7DE0323475021635,0x39EBAE49F2661CAC,0x1F7DCF8CC106E255,0x6B1984F219076020,0x0000000000000102 }
  },
  { /* Point #14 */
    { 0x4E4EED8BCE3EFBDC,0x2870B5AC354A428F,0x71080037A6FDCE69,0x11F023F7B7397180,0xE3B734512A27F226,0x9065957B322286AC,0xF3EBB8B1C2B9FCD7,0xD8718AA7A56F22B5,0x0000000000000008 },
    { 0x6202B39D61D7722A,0x05537A28883EF83E,0x72CEE9C1CC296EBF,0x047C1B4E160DFB62,0x61EFE8138C3F0D30,0x3E250E7D96EA0D23,0x31097A2E20ADF54A,0x16409D224C7501E3,0x00000000000001DF }
  },
  { /* Point #15 */
    { 0xA12853033F9534ED,0xC5A30DEA2C63280F,0x9015209C7ED8C1EA,0x68C490086CE665BA,0x8800B08E5D154A17,0xA8B5C31C54429C36,0xF394762525B60A15,0x123F51BDECD72450,0x000000000000004E },
    { 0x8D601C76B187B6A1,0xD04EF5F1B25AC6D8,0x1064FC7081995FF4,0x1ED6C2B56950CED5,0x7E32161A5A13A531,0x10459EACA573AA56,0x39A5653630AFD37E,0xECA0BEE8E11F4922,0x000000000000011A }
  }
 },
 { /* Table #119 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xC7CC50FB09B5947B,0xE166A9AFD5EAE02F,0x47C7953FDA349C90,0xC3D4BCAE21C0984D,0xCEE13C2F45FF2419,0x334CC1F147780DDC,0x21381FB6F1157180,0x28FF4F86EAEDE87B,0x000000000000017D },
    { 0x10C72B8260E096A3,0xC73306EC5FF796BA,0xB3F60666FECC17EC,0xB9E0D51F46F82C8D,0x6CBE5C7E296DA50C,0x87CB11044FA6C1CE,0x5D5E0F6D491F9B8B,0x187BAF6970EB3D18,0x0000000000000103 }
  },
  { /* Point #2 */
    { 0x2FAFC73F189A0360,0xE08428F1A68509E8,0x4700E3EB3A2AF597,0x143C0BF14B298188,0x9FB03775F0B9B8F6,0x7C9E5A3A2653D193,0x41109C62D1F8AB93,0x8AD7CB71434536B8,0x0000000000000073 },
    { 0x82C43B2DAA844EDD,0xAD5BE7AC3CAFB62D,0x8DD99C5B4A5B4B0C,0x2A11DC4131C113AA,0xE62332E93390E968,0xA912CDEA4B073B39,0xBB0B8141BC11CB2C,0x504272D1C9DCA239,0x000000000000007F }
  },
  { /* Point #3 */
    { 0xDE0324030689CA3F,0x4584FD9714FD0202,0xBEA63186C84BFE39,0x0E579AADABA48F51,0xCDA28545C1A4C309,0x33629507FD645C90,0x0C77CD5627B58E13,0x4D84313664DDA00F,0x000000000000016C },
    { 0x281CDDF1E91A439C,0xAEDC15D538BF386B,0xF2F22343F35EA657,0xF9FE82EA18A01F1F,0x04F9F4730B5A27BD,0xD296626D025DF338,0x45B950BA633DCA68,0xEEEF58AD19F73B2E,0x0000000000000008 }
  },
  { /* Point #4 */
    { 0xD92A04C26573F504,0xB69C2DBB85DE7CE9,0xB2B82853A2A36153,0x2899BD376AF7FEB5,0x301805E5433C9010,0x5BED8ACAB616D5DF,0xC8AFDA4270E4B63E,0x496EB13248CCE468,0x0000000000000103 },
    { 0x6EBCD0500973771C,0x6377D971474E651B,0x7D0A936B0F6DEA19,0xF7CF4FCE0AEAF504,0xCEE2076C170C2FBA,0x158448263AF78646,0x67737E06E27F2225,0xDFFF84AF4601BD5B,0x00000000000000C1 }
  },
  { /* Point #5 */
    { 0x035D0A019DF3894B,0xFCFB77C6C2F36A07,0x04957358C9319662,0x52FB2C650E0FBE5B,0x26D1FB01CF3EBED5,0x3A417DC06F338B83,0xFB234B48D11A9621,0xBBA96393DB3F5CBB,0x00000000000000D1 },
    { 0x78B95F1495129FF9,0x10504DE14D5F0ABE,0xE8C7250D3F4DDE14,0x20C04AB4EA00AC99,0xFAED11686EB2143B,0x23E32BF4544284B5,0x0512A28DBAD3ACB7,0xAA1926AA86D008A6,0x0000000000000192 }
  },
  { /* Point #6 */
    { 0x81F919BC75E0A1F7,0x89DE5DD7CD6A017D,0x14D88451C9A96FCF,0xF3F61D046C5B2967,0xD21B7E9C453A4189,0x18E9C74DC8B7BF46,0xF8903F4F63921EE6,0x1CABB3F025060DE5,0x000000000000006A },
    { 0xF15CD5C8C291F1CB,0x26C8A484D0311E2D,0x1E5D93B9D9E366C1,0xB037CBDD812FD505,0x8614127C0C567514,0x4125BC9B4256930A,0x84F62F976A0A82AC,0x5B12E21E8DBD5C67,0x0000000000000192 }
  },
  { /* Point #7 */
    { 0xBE5764C9CAF7FFF7,0x16CC873D6D606B04,0x6A6F20784268CDFB,0x06CD7CE627BD5738,0x532D5C4242E47936,0x704F0B2A7D0F8758,0x6046D9F36D2E977A,0x53FEB41A1327C874,0x00000000000000FB },
    { 0x9425B4D1013EF2BE,0x98B50C6E98A45194,0xBF181A2B9DF34265,0x39C40CE4C2DE575C,0x6757DAEB883B4DCC,0xCB224D4BF8B5EFBC,0x2DCF10AEED49A2A0,0x9C1FFF7A9FFDA898,0x00000000000000EC }
  },
  { /* Point #8 */
    { 0x7D2636053E0C991E,0xEE3ED571275DB80F,0xF20CF648561DD429,0xED7EA515F12BDDC2,0xB84130BD0A544F33,0xD56FB7297832D23A,0x728EBEEC0BBD7452,0x6006394D28216463,0x00000000000000D2 },
    { 0x43B5561B228B41F1,0x90EBA77819B17767,0xCA1AC49EA2533AC2,0x23B080F75EE9175A,0x98A9470773A70BB7,0x4CA74D0815CECBEB,0x5141DB56B4A97B7C,0x758FE34EF1450CAE,0x0000000000000111 }
  },
  { /* Point #9 */
    { 0xD2B17EFDC9BF0C9B,0x79352DF94A3175E0,0xDE19AF86841B5F46,0xD2BDEFC98317FE9F,0x4349C726A5AE3BC1,0x9991211E43CAD229,0x3245CE6EF16A1F19,0xB7A43C99F6B0A022,0x0000000000000027 },
    { 0xA0D43E88BFDD7FA5,0xB9FDB126A56AEF59,0xE36FEDB3EB1646B9,0xC2A5B17FB2D25B2A,0xD1DB0F0F7526EE70,0x526E46C6739FE3B6,0x5CFA3185A6320001,0x908282721717CEE8,0x0000000000000054 }
  },
  { /* Point #10 */
    { 0x61ED6A7F6E9E6E88,0x0456D4C464E89E5A,0xEA5FC9D8F9E17ED0,0x2DC7DFAFCB542D12,0xCA40F95C8C90F19D,0x347F0C9F375C2872,0x3A5E1FF600F96CD2,0xE3442888A9FB6359,0x00000000000000F9 },
    { 0x16E56AE6A6743465,0xC9E24ADA478DFE6F,0x298FF6DFE42D5813,0xFACB1CF51531C516,0x9B778FDE097BE036,0xAA17EA655155B221,0x8FAD7E57C8266064,0xCBB079A05536759F,0x000000000000013A }
  },
  { /* Point #11 */
    { 0xBC23AEB2D1FC50F7,0x5A63B2379B184C0C,0xBC43FF0EE6794086,0x64713B62031F0138,0x3DB4B0BD81DA7DAC,0x4D6A996B36D6FB58,0x6B064DF122B4E62A,0x0612931C7F6B9CBE,0x00000000000001C8 },
    { 0x55503228462BBC5C,0x5651EC3A244999CC,0x93B5B3D709872C80,0x8CF163AF070882C7,0x7A2923223B30AFE3,0x8D92B4AAEE45A4FA,0x94646BD3697A47B4,0x99BDE8F96423023B,0x00000000000001FE }
  },
  { /* Point #12 */
    { 0xB627FDFBC0062D02,0xA527C2DB7C3ECC6E,0xBD959F5D49FAA954,0x5E110744F6C6A3C9,0x40F10E096D3907EB,0xA94E585EE27341F6,0x8F0E11851CB56481,0x0F687B831CEC3022,0x00000000000001B3 },
    { 0x5F8C166D962A12D0,0x00B41EDAD2445D5F,0x2B259CCEE9690A54,0xE4BDAC1D6BFE61BD,0x30CF14BCF51DC15B,0x43E72573C600759B,0x0BEA781FF86F10C8,0x3259D6086A363F83,0x00000000000000C1 }
  },
  { /* Point #13 */
    { 0xC288EE74CDF30F6C,0xA8FA52B3D8B19859,0x1FF94A3023F725AC,0xF02BEF5B58B44EC1,0x0AF81BDFB862BEC6,0xCB19979D38D65BB7,0x4469BCF7C662ADF9,0x6F29E33195E8305F,0x00000000000000BC },
    { 0x72244E292093D379,0x590C16A0EC9D9897,0xC635439EE45D50C3,0x5B5562779B40B375,0x9C9C449643D0381E,0xD61C59C2378D8002,0xF0811D15AC014D42,0x37DA2DE58AFA297C,0x00000000000000F3 }
  },
  { /* Point #14 */
    { 0xDD15B8890006DA10,0x415306BF6643193F,0x79036F1F242D9D57,0x6C9D5588B36F9ECD,0x58305C8BF19D2F9E,0x383D6245F5C17B58,0x9C6AF8D8640CABED,0xE8D10E728ADB59DD,0x00000000000001D5 },
    { 0x5490F2F98E99708C,0x5373965EFDD3F754,0xADE0363389E6BFF2,0x59D82F758EA6E9DC,0x3DDB97148CA95FB3,0x25BC3B9A85713ED3,0x0B118E05090CF1B8,0xD95EA9CFC707CD92,0x0000000000000028 }
  },
  { /* Point #15 */
    { 0x73BBC51CEC9886F0,0x6D91832D76C9105A,0x3A4938FF7734DE0D,0x68613D279F71510F,0xECC8B09F9C201233,0x2B426B0D02F20792,0x917BAB5133F87AEB,0x21014269B921E7E8,0x0000000000000139 },
    { 0x366B3A8B91A3CEF2,0xBF63ED9910BBA815,0x98143AE944329E33,0x7BF47DB912C92E6F,0x3E298E35DE7BF2E6,0x517D6A51770DAA8D,0x80A04C0E85E292C7,0x252AAC413A6CE0A0,0x000000000000009D }
  }
 },
 { /* Table #120 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x62A1F73E3FBADC57,0xEABF4B68B1BA2D35,0x711D7F6376F3BDE7,0x162F5183B31C3FB3,0x0DCD66FED7D716F7,0x6E1DBB78E46816D9,0x532831B8F833A6F7,0x64191CCB4CFED0CF,0x0000000000000190 },
    { 0xDB3763396D7824AD,0x6B948AEFB16A391B,0x2D174FD64AE9013E,0x9B5C22EE16A57DE2,0x3BFED1DA9E857A25,0x635187A64D644BBD,0x94786E3A6FE288AC,0x827C8B03ECE25962,0x0000000000000092 }
  },
  { /* Point #2 */
    { 0x027F4FF2D35B5ACD,0x0E0FEC359EEE8CAF,0xA99AA6E2544C2A44,0x0548945FA9DE5EE3,0x02EE7FB3C4C5263F,0x3FAE05EEC75A400D,0x50ECFF533640DFC6,0xE57C180FC0CECB87,0x00000000000000C2 },
    { 0x22B3504387BA8E83,0x6C47F5D21C652199,0x2EC15D3D19F3260D,0xCF9E5050E95FAEA6,0x7ADC35CCA4F5D193,0xA7B0F1F33DDEE652,0xDFB751246E213C07,0xE33A115A7946DDC3,0x000000000000009F }
  },
  { /* Point #3 */
    { 0x6E965255EF4B1B98,0x3F63B6BD8BA97BF6,0xC6CACADB19BB0BA0,0x9F88F0C83C8EDCC4,0x3A2D4BC51A489ACE,0xAA3075B75529BB67,0xCDB0C4D6FFBBD2BF,0x4A3B41D33A568FD4,0x0000000000000146 },
    { 0x46442711EFFA56AE,0x941858D847ACC062,0x9480D79C7434D565,0xA92E885943322ECC,0x650CD6DE5F82931E,0x4EF5D48397876156,0x04CA704AAAF946F4,0x75258AAC0A95E02C,0x0000000000000132 }
  },
  { /* Point #4 */
    { 0x7AAA8F37D3CB8E9F,0x8F3B48A91A73D853,0x783EBBE7EF285A53,0x4F9D97291C3EF389,0x130F276C6453DA69,0x76683273834FACED,0x026A3722AF5AF17C,0xD588AA37F08A5E50,0x000000000000016D },
    { 0x81B6610BBBDC76B3,0x406785DD563A6902,0xE0755F6CED775283,0x08D6C84753B16D0A,0x48EBB570654F906A,0x3F0C62B7184B373C,0xD6BB91B6314D776A,0xAB9BFB3A224744A7,0x000000000000012F }
  },
  { /* Point #5 */
    { 0xA5566CAFE4DC6C47,0x17226EF0FD8F2789,0xF6F20C86C66FEEA4,0x19F5E45954F41B79,0x4288C4B4A05AEA83,0x107C800CD8D42617,0xA83D33A42425EA3A,0x8DEA172BEEC9D772,0x0000000000000132 },
    { 0xF75FEE0F9EF2A747,0x107D2B54BF360B7B,0x6A0B32F04C4DD036,0x4733A40DE843BDF6,0x5B17B282AE53A7D2,0xE15AF19E2070F209,0x800540ECDC178326,0x13D38AAC8A9691E5,0x000000000000004E }
  },
  { /* Point #6 */
    { 0x3B8CF734285F37AD,0x9C65B1F8A37C1F2F,0x6D946DF3996231F0,0x201EACBCF3574FEB,0x2C6287F9FA5BEC75,0x0BF3E245B736EA2A,0x8915EDB10C02BCBF,0xEE1762B6CFB7E1CF,0x00000000000000E2 },
    { 0x75DF9F827E9B5EBB,0x212082C275856008,0x6F396D2ACFA5D8C1,0x08311CAF6BCBDFE9,0x388B553BA0BB9F1C,0x8C674F9B020D8CEB,0x2C668AD29709618D,0x119B437B1FE83DCF,0x000000000000012F }
  },
  { /* Point #7 */
    { 0x28B3C1E7373055FD,0x8B5A5FDE066CC9BF,0xF1F386984C213824,0xD3F812F6E7069ACA,0x7AF66243410B8E51,0xB0B2C6CACCDBEB09,0x3C31D93AF5EB1DAA,0x487DA2D28FCFD3FA,0x000000000000003B },
    { 0x111B77E8D1091BCE,0x12FD3BAE8F9A76F9,0x737049CE100340A2,0xF514BE2E577FED17,0x40E9F3E8BAA6A384,0xCB4AF0174DF98480,0x3A5E3983A9C0A1AF,0x7CA6BDAF05B9D797,0x000000000000005F }
  },
  { /* Point #8 */
    { 0x5ABD70212D7E7BE5,0x5AE72DD6B01CCA76,0xBA2A179499FA6345,0xBD22D699B5D0CB9B,0xDE336ADFFCE9C6B9,0x602DC43CFB816436,0x9D86318F33B17E66,0x43F8EE75DCDD628D,0x00000000000000E6 },
    { 0x1BF13BBA3D223930,0xD77BBB123B6B0034,0xA4EA21C4BE34BAC8,0x95E5F221AAB61589,0xB4494EB79D411C28,0xA423C6F5CBE6FAA1,0xAB882EE7A6E4E735,0xB36EACDB546545B3,0x00000000000000C2 }
  },
  { /* Point #9 */
    { 0x7C87F3A4022E78F0,0xCA0498DF027926B9,0xBC8B9EA2E9EBB7F8,0xA8C83D315DABF797,0x7DFA95C2BFEA0853,0x64E8AB2542D0716D,0x1740F8E02FAA107F,0x1458AF64D857994F,0x0000000000000175 },
    { 0xC125A62DC8FAF75B,0x2521B0EBAE518B7F,0x1DA407174CA307B3,0xB61A9D35E5650F5D,0x915CF4867420F3D3,0x0D686243BB059DCD,0xEB9151F7861772A9,0xD7C0EBBD32AEA0EE,0x0000000000000068 }
  },
  { /* Point #10 */
    { 0xE9F4E555D2A38D24,0x86343E7BFB05A334,0x6DE4D40C02AD6297,0x1D01091648BE4935,0x189B8662EB2DC353,0xC420DC23ABCD0190,0x468AAB7DC551ADC4,0x661988D62713D4C0,0x000000000000004D },
    { 0x305287501AA0B317,0x083CFB4B09D0D364,0xC3CA70FCB39DDD51,0x4A33D8403A5610E9,0x422BF8EDAB98C4DA,0xE2A5CBBDB7F6DC83,0x1AA53CB831FD6F4D,0xDB3643B4630567B0,0x000000000000000A }
  },
  { /* Point #11 */
    { 0x42D861D23CA78A6D,0x1D19C466AB0258D9,0x975C0A31C0EDEAD7,0xA0CAFA8B450C9CEF,0xE808EC536449715C,0xAB3A9430A608BEB6,0xEE9E1C9FDE81C539,0xF3D7B348473524DC,0x000000000000000A },
    { 0x6A80D50FC738461E,0x308B8F73AB0495A9,0xCCA7368ACFFCE061,0xCBDC1793E74A7C81,0xAC31501AF32A0E92,0xF41400517D49C00D,0x79AAC5166AC4A403,0xF500CE393E76C568,0x000000000000019B }
  },
  { /* Point #12 */
    { 0x379FFF9EF1BC7433,0xD67580D263ACB751,0xDB681640997DE531,0x107DB5B7ACA58CF2,0xAB6EAB18F808F305,0xB137CC79984DF6C6,0xD34FD7B9A88B5D62,0x0B5760BC2F40C719,0x0000000000000028 },
    { 0xC9AB6D25CFD7AC69,0xF3FD984A5F321467,0xA67E7542D4F67AF5,0xB086E60FA4D56C32,0xB08B134834F455E0,0xD8DE2E65BBD9DF8E,0xE6EFD3E52AD9BDE6,0xBBC4FB445DF7DFC8,0x000000000000016B }
  },
  { /* Point #13 */
    { 0x9C34B7C5C3B7EED1,0xBB2BDA47E4596437,0xA1AE187AF719530C,0x39FEB40AB3AABD26,0xDF9B00C697CCD1E7,0xA4241B76E809223E,0xF8BC2EE40552E863,0x4287052A467BAE5D,0x00000000000001EC },
    { 0xDFF0E77B0510A2DF,0x729B372DB712464D,0x7B1E56D43960C11A,0x711FD058AD60867D,0x619FC32324BC1EE3,0xA7BA4BD451CB3A73,0x7E86C32674795B96,0x86BDFF87F52A251F,0x00000000000001CD }
  },
  { /* Point #14 */
    { 0x262A28ED304CDE27,0xAF9881A70B4308A3,0xFDB26AFFA3331EE0,0xF30B1ABA5C4C151F,0x7C2D5469FB92A4AB,0x35BDB47ADA3C2C6A,0x130F5F3D112BD9B2,0x57E8210CF48A0D4F,0x0000000000000192 },
    { 0xBB96410D34B946C5,0x7C6930EEF76D8393,0x2673249F2FD8381E,0x364E714FBBD95C30,0x03AB26501D4C2039,0x28BB9F92EE19095C,0x517030F89DA01A60,0x040DDFFE5D320F45,0x0000000000000190 }
  },
  { /* Point #15 */
    { 0xB9951CADD59EEBA9,0x05D083140B4E27E0,0x00F3E87E320EF447,0xD3E621DF04664C78,0x23F712E3A260860F,0x94631018DACB26C6,0xC24A7A18B25436C7,0x16D26A90634885F9,0x00000000000001C0 },
    { 0x8AB63B329C65AB21,0x8027F0C870E559B8,0xE18867585D74E122,0x64861CB50BCC706B,0x4B6EE54F0D9CF4B3,0x450E63240A8794A4,0xDE1B5E3C8FD7D2A2,0xA4D4DBF8565F1F8A,0x0000000000000027 }
  }
 },
 { /* Table #121 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x651B47C813B42E63,0xE705441316BEE2B6,0xDCF60CA386A71AC0,0xABDDB357E3BAF787,0x99D631D181A2DB2D,0x3F1E3C7FC8C9B834,0x3B30FA1861ADF4D7,0xD1D8D98014B9F46B,0x0000000000000139 },
    { 0xAE6F6B72F6AF1252,0x0FC583984FF8A00B,0x1B2C0CC5A81FD641,0xBDCAABE6E68B6FBA,0xD1AF82FE70B14E44,0xE9C35419E55CE735,0x3C83D9DC01DCEFB9,0x42604200FB5824C9,0x000000000000011F }
  },
  { /* Point #2 */
    { 0xC4C1D5064D245501,0xC7C62E341083602A,0xD5D6895961F152C7,0x3B142866906E6F00,0xFA4D7AEC3468335B,0x6C36DA5CF4687F7F,0x6643389B0DC658DA,0x99CB5866D8447DE8,0x0000000000000037 },
    { 0x0FECFBAB807A703E,0xECA0BD01EE68C875,0x375589C920D8BDD0,0xC0FBD62F14025692,0xBF5A0C1EE6B70D27,0xF9630AED9CBBB1AE,0x9776ABEBBA99B392,0x883C8B53C97978C6,0x0000000000000095 }
  },
  { /* Point #3 */
    { 0x753CE74AE22F1171,0xAE29377F15F959EE,0x90D8C9C5DACE4BDC,0x45F210F7AB4DCFFC,0x32135E10E1283166,0x23A0610932072197,0x4D3CCCB74D767572,0xCCDC43A3807A50D1,0x00000000000000E5 },
    { 0x6A5534206880D712,0x92B60F04DD80C4CB,0xF3538BA2DCC9D35D,0xD3166FAFD0787305,0xD2A1B177B7D68560,0x847AAF905E9F7915,0x210046E55B83CC7A,0xD26CE0BDB4964926,0x0000000000000179 }
  },
  { /* Point #4 */
    { 0xDCBFBB8BE5F5826E,0x31FBD1C02954969B,0x452C254D09536E44,0x6B733E3B36CD821C,0x8FDFE02F2D8260F9,0x26163D810E2A44E3,0x23E435A33E2E3A4F,0xCD8529B5777BAA61,0x00000000000001C0 },
    { 0x634DD97AA246D14E,0xDFED13A7D443A978,0x4668E97A8752BEC5,0x1F52F42826A0F8E7,0x0D69A760308DDFF1,0x54602BF7591ED51E,0x223E342B3BBAB1B8,0x1CF905CBD5003EF7,0x0000000000000132 }
  },
  { /* Point #5 */
    { 0xDEBD96ECDED7931A,0x409A230CDFDB9955,0x0EAE02D5B65C48E6,0x3AB3DFF83515EDC3,0x0440A0C53D119F82,0x7601D278F7B8048F,0x3E0DA58153655D73,0xA04162F342C66D32,0x00000000000000B9 },
    { 0xDC305022E0D030B2,0xB812C6A1AF7D339E,0xF845455F91973A30,0x3A40C4D454ADE939,0x7D5B0F691E0972BF,0x7EADF7A28839861A,0x87A2E7067D36E5A8,0xA25554C5D13C7670,0x0000000000000055 }
  },
  { /* Point #6 */
    { 0xFC6E3ABD7E791A5F,0x8B60A8B7394F9865,0xF07F164CB0F31984,0x3B0F7BE135FBCDD5,0xFA914A53C372E0EC,0x6142002A0392F749,0x8F7DDC3B952CCAB5,0xCEC17DDFA5E85E1D,0x00000000000001A1 },
    { 0x376E182E3BFB6450,0x34275E3B5874742E,0xC6C3BBC436FD4D5B,0xD5359A5F17024A3F,0x690901D1BE783D99,0xD98F0714BE92B949,0xD7FF8E0FFA44B971,0xAE0B1EA4A248A978,0x00000000000000A5 }
  },
  { /* Point #7 */
    { 0x8EC2BC822C79E1E7,0xEC5C692CFFB8B4D4,0xA0D4D5090846B9F3,0x41EACCAC33456629,0x43E23429D484F510,0x0BF959D35018896D,0xA817BFEDF257DAF3,0xCD04BC49A1FB8E26,0x00000000000000BC },
    { 0xDA060441D92BCED4,0x278C04C95D4EF4F0,0x8B6F0231396B753D,0xF68CAA504533E041,0x49D2F5F1D52BC9BC,0x83AC55150141E329,0x453951C6C866B038,0x09B032D479ACDC69,0x0000000000000196 }
  },
  { /* Point #8 */
    { 0x1AE0819BE9933309,0xDF8BDB84232A74BF,0xE0CD42AC756981F5,0x658128186734B942,0x6B63D0A2F4ACCF5F,0x4DC5D87A55294162,0x0BA927B230BC9A8A,0xCDAAE01ED8E36A78,0x000000000000013B },
    { 0xBB632BFE8E1F565F,0x29EBFDDA53E94443,0x1F98A0D3E10D165B,0x9F82830C637C795F,0x3B33128740E0C47B,0x8940D375F4BEE639,0x05CC4DC38B8AD839,0x3B4D9DBE10D505EA,0x0000000000000117 }
  },
  { /* Point #9 */
    { 0x5753BBB8A848CF13,0x82B32A43D90C938D,0x7F5770D7E6FAA6E2,0xC7CBCAF37D684CBC,0xCF943B1B2E7B48A1,0xD1A7EE6F8D5C5321,0x1AB34E2D15CC06DC,0x27D2CFBB74B5A5CD,0x000000000000006E },
    { 0x022C5255AD3C3BF9,0x3026A8B4F744D697,0x5CFB32D674B6A2CE,0x8DF70A0B5E50E51F,0x8C9156A9ACE784B5,0x2EFAD6CD487C3A9B,0xF5E804C0AA2CEC88,0x5780CC59F9BD480C,0x0000000000000035 }
  },
  { /* Point #10 */
    { 0xF240D36BE4AB3D55,0x7ACB5BF0593C4A6F,0xB7456194130FDFBC,0x3D3AF6220EC1BCA5,0x14A5CBD878B4F4DE,0xDE12E1CD6C32E96D,0x5063FF425B7BCE8F,0x37EFACA1003DC72A,0x00000000000001B0 },
    { 0x4274DE57CCDA7E54,0xFF66C962086C6D20,0xCA33121D4C9071D9,0x97B4200B3E732B5E,0xEC371B1543208BA0,0xF6AAEAECE25D09FF,0x226E14D2E18BAB6E,0xDA5464F9459A3DF6,0x0000000000000130 }
  },
  { /* Point #11 */
    { 0x9E96EBDE76178C94,0xB30646EB53081E92,0xB2541CF8F47B37CE,0xF5899B4A72CDFE16,0xE86F9BEBBC9855DF,0xCD97DE762A3C7176,0xE792C9CCAD4AF521,0xF4EFAD3DE059FCEC,0x0000000000000153 },
    { 0xAD541C6A53A88FBB,0x817CEAC1FB7C79B5,0xA4A04DAC7DAA33C6,0xFA09F56FF3D2D674,0x9F53EF31EEC7D069,0xAD1E5AF49211CD93,0x0FF0A6DC959D77D0,0xCB232DEF76ED9AFF,0x000000000000002E }
  },
  { /* Point #12 */
    { 0x9134DAC8966DD7C6,0xB53909CB72BFDE57,0xA06F7191D2A4FAE0,0xB22A5D860D8ADED5,0x9B0869337BA88547,0x6A027DA5CA1B3E75,0x55E8542182831DF6,0x52811CACCA4FD543,0x00000000000001D1 },
    { 0x9184B34252D1A260,0x046F70F2D4AE87F3,0x75F0132452052638,0x9476A1609A4E8CAD,0x1485632621396B03,0x381F263FF5AF85AE,0x8E77B921F7010305,0x7FAB4D8838F30A00,0x0000000000000072 }
  },
  { /* Point #13 */
    { 0x586A5A4F92F845FF,0x4181E8BF433B9969,0x8CA665031BB30E35,0xDDB8880029EF7C76,0x91EC943993A91394,0xA102438734ACF11F,0xB31BAB71E3A99420,0x46671DF0823803AC,0x0000000000000182 },
    { 0x4311612323967817,0x10BCC7E1D83ADD78,0x5CB65CE01B4D7EA3,0xC204E7395FC7AACF,0x138FD0EB0DF86632,0x5A7F3BF92920E7AE,0x323B55DA74FB04A2,0x87A1CD2DCF6B4579,0x0000000000000105 }
  },
  { /* Point #14 */
    { 0x7DF95A3C1B3F5CF1,0x3B30E0F2EA0077FC,0x733880B50AABCC34,0x2050BC2701193010,0x2DD36DEF5C80FE3E,0xF2E14B2BE8E228D6,0xF13A348574802EBD,0xF08BB1EF17F57CB1,0x0000000000000087 },
    { 0x4F81DAD0A662456A,0x8C645BB185F5B388,0xA39ACF0E19503F7A,0x214D1956D7530999,0x2DFB62DEC339D2AA,0x9C54F1A27A04264A,0xDE5E1FA9BB74E313,0x3FB024216DCDAC67,0x00000000000000B0 }
  },
  { /* Point #15 */
    { 0x28702DC496AB1D1B,0x2DBD79460DC11BA4,0x0956696B883FAF9F,0xCDB23F5F227932D1,0x34957D5E0DE851ED,0x40065B9ED930F741,0x1BE825122138D1E5,0xB9F0D75934C7C9B7,0x00000000000001E3 },
    { 0xBAF4143B567EAD92,0x5EEF3357FB9CC866,0x4095892CCB122A8B,0xA3E50AE814B8AA9F,0x72024C42376F6B0B,0x6C63EE2DDAE219E2,0xBBA101782069C115,0x3BA8834D7F96DEF1,0x000000000000015D }
  }
 },
 { /* Table #122 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x8DD33D1C66BC31A5,0x80A074959D19C1C0,0xDA13C485E03A1EE5,0x316D85F968ACFD38,0x8617C80D0D9D6273,0x6DDEBB71F94D5F22,0x1C3452038EFD0A44,0x7CA0B4067B3746E3,0x000000000000007B },
    { 0xBEC7B15087436D56,0x07CF1192A01F6C04,0x047B37F6F73971B0,0x7E7D8B9B5AE1F9D4,0x0E311B4FCA1A9900,0x5DC55F3D6A81FB38,0xE257401A2956AF04,0x90C2AD09F66AE95F,0x000000000000016B }
  },
  { /* Point #2 */
    { 0xA949016C027EFFAA,0xD4FB4288E691A213,0xD18A53B17FCDFD96,0x6808BF4C0CE4CAC9,0x7E7DC551BED1F520,0xB84F242F2DB78FFE,0x7E6D15D34261FDBD,0x836F8254A8FFC498,0x00000000000000F0 },
    { 0x029233DAABE4E4F2,0x9617F000D0327536,0x444FDC65DE62E889,0xF9170A9969512DC4,0xA37EDB8D4E765028,0x7C003AD00852DC5D,0x628756447CDF14EF,0x87AE7BB59B509913,0x00000000000000A5 }
  },
  { /* Point #3 */
    { 0x15C0760BA3FAA4B9,0xAC263E6F62D67946,0x3F5E1ECF0E0F2550,0xD6F9E25DFE856EC7,0xDB3156F489E42E60,0x944CCCE29D08DD80,0x241B875DD586A10E,0xE47CB5008556ADCB,0x0000000000000035 },
    { 0x9C259AA74F99CE2F,0x7419828217FE9E72,0x53B45886CE9D9617,0xBC7EE9C59541BD1F,0x0B98516291A3D63E,0x6E75F3F8358B75AB,0x34AFDC0E2440CCDF,0x0F8D214F47A18648,0x000000000000015C }
  },
  { /* Point #4 */
    { 0x51199E42088A01D8,0xA9C970190E6C6197,0xCC8BBA8AEC9F00DF,0xDB0E728AA3534E0A,0x4F130E04B74D62E5,0x3E26ABBA0368BF53,0xF97571A599D4743F,0x64863A87C7EB2500,0x000000000000003A },
    { 0x0CBB2434A3D02698,0x3C37545572EB32AE,0xF8555F578806B951,0x11215434CE2DBE0A,0xF0D7A7F00470FB38,0xC4E0AD472707CB8E,0x4CAEF200C03C9C3E,0x5BA3893846612DE4,0x00000000000001B2 }
  },
  { /* Point #5 */
    { 0x5940D1D32D86220C,0x0745F4C7F17EBB24,0x043B323D611DA884,0x3AA9CC05E09E3BE1,0x357E6B9A9DCF7703,0xF9AC02BE4C13C6E5,0x382125313D1CCB65,0xED41DBB99AE3BF3D,0x0000000000000074 },
    { 0xFB7FC6374139B92E,0x46D5B8DEA50A76AD,0x281AC30F07BE1EB9,0x059DEB0CCB7414A9,0xEA9DF76D1CCEC832,0x0BD186D00DC155E1,0xF39D6482329513CF,0xAB97B70C10911066,0x0000000000000163 }
  },
  { /* Point #6 */
    { 0xDB80EDC1CA6A97A2,0x863080300D490A50,0x66962687DA57ED02,0xD2115BA4B1645904,0x22E6F7E8F4BB7C96,0x2C2BAE6078A63416,0x5D403C207453ACA0,0x67DECD07B8D26275,0x0000000000000068 },
    { 0x1F8495A99C022066,0x1BCD937E484C73A5,0xDD61F1FB1F4739A7,0x415B3726701D4E57,0xBD90443F8F336F93,0x594A77CA222DB3B1,0x59358763420A4C80,0x8AE41A9C972EEF54,0x00000000000001EC }
  },
  { /* Point #7 */
    { 0x8943A18F8EEEF2D6,0x2E5273F68399362C,0x4DBB9BEF41DEB9C1,0x9E34C73E1088C6F4,0x66047479CC859471,0xEDE1B31EFB704F9B,0x7C8FCEC4A4F3DDCF,0xC8D156E368AACAA4,0x0000000000000069 },
    { 0x5C60E434C3D5F95F,0x4CDF7439D2BE9D81,0xCDE0DFDD27745B69,0x2F64DF961DE6CA4B,0x6604CBB6D1580DF0,0x7F10BEE9D0239649,0x5A5F9B06CAA1F385,0x6C0D20A35287281E,0x00000000000001F4 }
  },
  { /* Point #8 */
    { 0x4F3C3BC3A1E703A9,0x134EDAC80F4D9E8B,0x55DA5480FE4727CD,0xA8F98D584C37A7B2,0x06BC173CC5F9592A,0xD1F2103C5220EE93,0x956EFEF67ACF01BB,0x55746C426C878B89,0x00000000000001A2 },
    { 0x1927395435DD9B7B,0xB81EF6482A61252B,0x508F2CB818236F94,0x655EC86D31B04F92,0xDC06CE6A381743AE,0x46059E3637E92347,0x6DAC815FBE6A29D8,0x4B4FCF720B369888,0x0000000000000181 }
  },
  { /* Point #9 */
    { 0xE5163A2131DF70BB,0xDDFCCE47C9393D38,0x5BAF3EB802C23EBF,0x8C8999141C7BEE32,0x32587D380A259EAE,0x01C19DC2EC6355A1,0x6A0D12AE87EF1798,0x60D701BB29C3FBE1,0x00000000000000F9 },
    { 0xFB3B62BF0DB4C852,0x7F3CC59A1C300C74,0x70836E6071D74A7E,0xBD18BEA86DB4278C,0x93C68191A5EA467A,0x8DCD58BC9230D91F,0xA1335C10B56339AC,0x8D1127D742DE9EC4,0x0000000000000049 }
  },
  { /* Point #10 */
    { 0xA415042A95962309,0x9249DAE49577D149,0xB5DC1B89C449E28D,0xC8157EE236719253,0xB2DE8B32004489C1,0xD8F35E390611398A,0xE1B215A655766A4B,0xD34782D110886E9B,0x0000000000000142 },
    { 0x374B49A0217B0165,0x381DC0739797BB36,0xEA6F6EE6CCFE85D3,0xDF3E67E15E858C27,0x8CA37CAE36D465D7,0xA4BC946D6D3E2149,0xE85CF9B076B9DDE6,0xB28D42E385FE1977,0x000000000000007B }
  },
  { /* Point #11 */
    { 0x07C7D1CF85A4D17A,0xBB87ABD49DA9D4CD,0xDFD1E63C6D6D7B03,0xA031785143B978CD,0xA72B376C9E95A176,0xF79DAFF3395256C8,0xDA28EA45BF714C8B,0x1AA1D1F0A950D4C8,0x00000000000000EC },
    { 0x45C61E6C1414CADC,0x79E473A69CDC6C6D,0x63A401E2DE550EFC,0xA007F3D8A4A1B241,0x9FBE64FEEDA2C1A0,0x86890BDC2E840BE8,0xBBB490B92A76E98A,0x35B65CB43D103446,0x000000000000003F }
  },
  { /* Point #12 */
    { 0xF8106D6FDB1A83C1,0xC55816668A3B992F,0x30BE609761E65036,0xB7E260EDED1AD38F,0xE51EC351F98254FC,0xFD1E301827F9210F,0xC209AB2533522612,0xF68C7A487BAAA1D8,0x000000000000007C },
    { 0x6677DC5814FC9FF1,0xE57B02BB6A95A729,0xF520B6157618C694,0x61B4174F60B020AF,0xA0F2CB83185D0531,0x647A5DAA640F434C,0x1B1EA4352D853D74,0x222EA56CD31BCDCE,0x00000000000001BD }
  },
  { /* Point #13 */
    { 0x5B4FDEE36DB327A0,0x410BE5B39BEA9535,0xB54FE965E8755850,0x0FA3FE28E25FD1FF,0xD8BA2016F19E917B,0x5F98897B7F4DD845,0x9457A7C8A937CF44,0x0FDC895E5BA3EA47,0x00000000000000E5 },
    { 0xFE6DD2D94316C9F3,0x030F499D4915E45F,0xA4304A35F0F44149,0xE72BAC7A0B59FF89,0x89FEA32C5A17EE7E,0x7E0DB6D885F9C15A,0x9DBB9DA6CA989283,0x0CE924F988C77E7F,0x00000000000001AA }
  },
  { /* Point #14 */
    { 0xBEFAE1C603A2BABF,0xDF1BDB18989CE1F3,0x51DFAFB0D13C103B,0x3A5ABB39AB927F16,0xA6994828373363AA,0xD697B4D99BAA4DCA,0xF887D3778429295C,0x2002E78BD198A663,0x0000000000000070 },
    { 0x6011B0A6050D7BA0,0x39A4B2C9C9484AD3,0x1B765FAE2EFE1258,0xF411C77FEA584BA2,0xBF7A4D88FF766947,0x055B82156B27210A,0xCEB643361B0C09BF,0x9E77A21FE86F4239,0x00000000000001CD }
  },
  { /* Point #15 */
    { 0xD9F6083A6D69D68B,0x929F9C35748E0E5B,0x19E140A4B3AB3E11,0xCC32B60F7C0C3E5C,0x9EF0149660B3500A,0xC1781B622829F34E,0x3858EEB96D90546B,0x91746C6153EEEA6B,0x00000000000000B4 },
    { 0x1BDCB9A6488FB2C0,0xC01591A90FE2BFD6,0xEE71286B8BDC797F,0x76C384C87AB959D1,0xA5076F2D389C98BF,0x6B7B1656247CDD43,0xB269EADC2FB5E539,0xE80F0B914FB854EA,0x000000000000014C }
  }
 },
 { /* Table #123 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x6106402972E2518A,0xFACD33FA7B5FBFC1,0xD50F77717632AD67,0xBA8688071F0D2282,0xACACD91104D90803,0xF94B3E0F51496EE8,0xFB8A5406ECE3C365,0x96F5C5E7620400F2,0x0000000000000109 },
    { 0x7389F3DD36988CBA,0x4AB5C460762CA5F4,0x9B96CF82B5CF8989,0x2FFA0DB5158A4C79,0xB5821B1A3A3D24F4,0x17771CB7F8C464D0,0x9FFD764662C59A09,0x0EEFA35FDC162385,0x00000000000001E1 }
  },
  { /* Point #2 */
    { 0xFA050BBD035B25A2,0x2A14076E36EE92FB,0x3E95A7EB2F514218,0x8A67615DEA3B77D3,0xE2764F071DA9263E,0x47BBF1FF92B51D79,0x82CD065659DF9EAC,0xC80BB0F05E020E6F,0x00000000000000B2 },
    { 0x7DAC49E7A7560919,0x7238FA6EC82B9DA0,0x3FFCF645FF7CACEC,0x72087198BE9302CE,0x13094B5C513BA920,0x8CCA51F343EB77DE,0xEFFE0E7D60B89283,0x036368BFDF9075DE,0x000000000000019D }
  },
  { /* Point #3 */
    { 0x2FF0F1CBEA39D3BE,0xA756A96EC7F3195B,0x1DFBDEDFDEB42713,0x7CB9E1BE4A87567A,0x64541AA30D2CEC73,0x8EEC22690A0327B0,0x967B1BC10C157F20,0x2A6F1A402D8969E0,0x0000000000000181 },
    { 0x42547F4CC471C0CB,0xB990B1A2815EF0F1,0x672398CBFBC29AAB,0xFB7E649B104AC38F,0xF0BA1354E9CF1E5A,0xB0C191DA2CD48A07,0x1FC70FCDB41854F5,0xF11295462504091B,0x0000000000000195 }
  },
  { /* Point #4 */
    { 0xB8A3F6BDA1BD56CC,0x3B8F16BD2E598D13,0x304CD218DC92BF6D,0xEC30D12DAC0B947E,0xF7FA65ECCF12510B,0x9C45D10C7F2DF1DB,0xAF49AAC9CC89CBBD,0x7771C58AA3936FF0,0x0000000000000141 },
    { 0x486B202ACD4E00AA,0xD4CE59C3E9CC0CFF,0xDC299E6110DCC4F2,0x64F83481559569CB,0x005FDA65297AD136,0x929EB2207CAD3258,0xFD85773D62647BF0,0x776FBAFF177AF6A3,0x00000000000001A4 }
  },
  { /* Point #5 */
    { 0x49082B82F794BFED,0x090AD58DA7508BA4,0x016C6C61ABF36DE8,0x69744E76C17D97E8,0x64BA471F5087CCE7,0x45BAC2BBF3FD22DA,0x1BBC08F0E8F6671E,0x6E45905D268427BE,0x000000000000007C },
    { 0xFDC632D4D810AB70,0x2D68F73CF9546668,0xF506EF8B178148AB,0x95DB78DF162C23C7,0x4DF86CB933DBAE55,0xE47825B77D81EDC1,0xBE78419056E1496E,0xD707FA3A48F497EC,0x0000000000000008 }
  },
  { /* Point #6 */
    { 0xC2EC5AEE77528DA4,0x3C8C6F50B12E7DA5,0xE36D0B4775E8FD04,0x49AFFCE87E0189C5,0x2C23922DE166E234,0x44F5033A7E52C62F,0x1D3B1A480E1DD67D,0xC530693580FF9F3A,0x000000000000012F },
    { 0xFACFB18BF94695A9,0xDA2EA3903A8C9298,0xF8A29D06B18C310A,0x10BEE839046BD445,0xA78643A0094093BC,0x77CD1796A2C10FCA,0x5FCFED6A5AC6C799,0x8331B5B782907CAE,0x00000000000000A7 }
  },
  { /* Point #7 */
    { 0x9A9D1B1914198957,0x09272B36B8B27468,0xA8ADB29478D8695E,0xB2A77EF928E6B551,0xB92C59A171983BBD,0xAE27218037661116,0x8AEDB3DD9058858F,0x2EA5BEBD716B7A4D,0x0000000000000188 },
    { 0x43BCD03EB534AC3F,0x0A3A64298D025A80,0x3E6A0674DCAA5EA0,0xA0B446922A7BED53,0x962C45437D1D2FDC,0x4651CCF2E3EC4A2C,0xAA08F169A883B3F8,0xBCD939E4513A5D60,0x00000000000001B8 }
  },
  { /* Point #8 */
    { 0xAF9BF352B2648196,0x00A9569D042FE760,0x43854E69B9D94444,0xA01A26456E3392B7,0x43D8AE3686C0702C,0xB658EDEEDD0F9617,0x0676B0EF8B270AB3,0x71CEBA8F02072F7C,0x00000000000001DA },
    { 0xAF1B398D4D9BC7BB,0xE6F033C930E4A71E,0x38919B421C8D3FD5,0x4DCA8A1F31065BB9,0xBA5A637E0BD4BEA3,0x30F886EB9A42D432,0x1E7C0FA3000FCD13,0x9DFFAC1D7299786B,0x00000000000000DA }
  },
  { /* Point #9 */
    { 0x35900C17F31F03E4,0xD46AB57ECACB20D0,0x346E2E7D1F2EC957,0xCC002CEDED3E9556,0x34AF851DD2729AFC,0x38F4C7007EF8AD10,0x9383B41E2514F43A,0x41F5A0C43156A417,0x00000000000000C9 },
    { 0x0430EB170573CF6E,0x75CC52B227B7F3D0,0xA0306601A0C813BD,0x202894D4BF1A5BC9,0xAA87196D9CE7D613,0x23A3FB14644485AC,0x5D9B9F3AE9854099,0x76D3383791C4B3DA,0x000000000000007B }
  },
  { /* Point #10 */
    { 0x295B183393DC69C5,0x8EB4B6AB3C37E07A,0xA6E07D0F04408713,0x2CC845F2C69254D1,0x93F7AEE14396112E,0x44C963CC55C306DB,0x7E18CECDD5EAB009,0x4397A27FF9A2C2D3,0x00000000000001E2 },
    { 0xADB5AF020031C31D,0xE273ADE87AA7656B,0x3C97406A8CF07D6C,0x348D729E460E4AAF,0xAE24DAEEB2373A39,0xEF275CB1B3B2264A,0x947252CFED43148E,0x4237243E33C44033,0x0000000000000105 }
  },
  { /* Point #11 */
    { 0x3AEDEC9F37932307,0xC90BA7CC3C278C5C,0x2172D22004BE1C8A,0x9D9943B37CE8E3F3,0xBFEC2077211548BC,0x938E1D2F1D011EE4,0xAC9BB9D5F14F2246,0x44152B2DAD89A636,0x0000000000000182 },
    { 0xEE7DA6C1C7E6C8A8,0x3C6D8DBF61FD9A43,0xBF8DAAEC74A9C52F,0xF71E888E9BFAD08D,0xB16028E58AAD6006,0x203343CA89A9EF88,0xB218490DB9B624AD,0x8B7BA480D01F5FA5,0x00000000000000E0 }
  },
  { /* Point #12 */
    { 0x7078A5F8C793FC62,0x5ED9D1D57DFA971B,0xE1F701B4A25CDEE9,0x362B88524B57F87E,0x2448012320869233,0x025FF4771481F116,0x3CA9F2F68A6275DE,0x562666C7DA246190,0x0000000000000086 },
    { 0xB5CB110004D25DAF,0xC869F7B3748D3D45,0xA68F07320C847AB3,0xE03E1AE202C1D0A9,0xB4F46C5EC2A80EF6,0x79B46F90606E1371,0x0BC1F2A0A728979A,0x9E8F17833037FE72,0x00000000000001A1 }
  },
  { /* Point #13 */
    { 0x31DA39DBB68CF907,0xB02E9060D1E99729,0xADD55A9689BB1507,0xECC7856A4B5470A1,0x40A83460EAB8CB1F,0x1C1F3C112B2C9159,0x7B97B58F7883FF7A,0xE7E97A4ABDE1CAA7,0x0000000000000139 },
    { 0xFA1DA9D4B8ECC0D1,0xE6212DF16E7641B3,0x828C55C6EBB36F6A,0x5B7EAD1609D6A861,0xDB35A05FC2844248,0x3C5089B2776DD2CB,0x2B6595BFED9EB5B0,0xBDDFAF004D176CC9,0x000000000000008F }
  },
  { /* Point #14 */
    { 0x3E39683DCD351B10,0xE16197210A895F34,0x252E80DA411D3459,0x1CF1F5433456C4A8,0x7D561558FBE9379B,0xB851CCFA95445524,0x63047F7CD73AF554,0x9414829CCD036021,0x0000000000000138 },
    { 0x1A267C2A72C27112,0xA663014F7031C061,0x6C342632BDB60991,0xEABAB7CE0D230B20,0x0BB0E281C3BAE5DB,0xC46B86B7D63A462B,0x1964D38CB34AEAFD,0xC165169BB2548043,0x00000000000001E1 }
  },
  { /* Point #15 */
    { 0xD8A907F1495AF650,0xBCB3F6E27A3AC35D,0x1ACED00F606706AD,0x8CE32C00A2E1CF9D,0x1E0E979705F91CAC,0xAB21E96B9E98AF3A,0x92F4E6DBBBE3C415,0xFD9B407646C929AF,0x0000000000000097 },
    { 0x5DA0209DEEE8423F,0xA22AF5CF098EEB14,0x5E379BE216E722BE,0xE06CDA5B9680B5AC,0x832C5AEB311D0269,0x7471C5D7E4943D03,0x148E2EF20776D3EC,0x658A17B50C51EFC3,0x00000000000001F2 }
  }
 },
 { /* Table #124 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x0CE1F2D1945039AC,0x1D1E6504FDF94D41,0xF36EAFD58752D630,0x24477F7FEFBF0132,0xAE8FBA2CC02BF85B,0x53A24CA8EB510E61,0xEADBC7F79C2C453D,0xCFDBC9DC310EDA46,0x00000000000001A9 },
    { 0xFBF287C8D8F82B51,0xB7CA60967F0ECADA,0x1DC411B715242666,0xEBF82D6C3DC6ED96,0x8F82229DD0A92B49,0x75A6A4A79DAC585A,0x443AE75EC839248A,0x4DEFB89F1BA7C9C3,0x00000000000001B5 }
  },
  { /* Point #2 */
    { 0x20E2FE1972925756,0x4815AE3332CE7832,0x183D90C3EB8F4EB7,0x0E088AF52A8045D9,0xF8232956DA04790F,0xC24661B5EA0118C0,0xE4152695A72924A6,0xFFCB277840AB56B7,0x0000000000000120 },
    { 0x1C766208AAE9AF57,0x21769DDA239689E7,0x9DC2194A235ECF56,0x930E993FCF83A067,0xB6725AD332913E2A,0x09BD9FF9FC942B50,0xDFB47D67600D426D,0x4CC06C589DEF7175,0x000000000000003B }
  },
  { /* Point #3 */
    { 0x68205CA5065D6929,0x15F79567039168C3,0x055D11E374DD0EFE,0x13D65191980ED709,0xC819A8BF91CB9DAE,0xD1EF1626C7A39E18,0x1CFED493274C7AD7,0xB2FF9CC1AA0280F5,0x00000000000001A0 },
    { 0xAFEE116682BBE037,0xF54D3BF05DD65916,0xCF8D694E47DA6A80,0xC350309B787E892E,0x13A4BDBFF87D2CA5,0xE5C927D10ABC535B,0x5532B5658D2B5113,0xC0F0222FD904BB5C,0x00000000000001F5 }
  },
  { /* Point #4 */
    { 0x9C3F082939926493,0x6BF1089EE3D0F530,0x3E91285D7D7D5B4C,0xD8D70F1B02BB958A,0xE4B0E8C1BDBD2B6E,0xEA70F1079239F187,0xD30F4ADA27D37CA6,0x0358F6B3C88EDA99,0x000000000000010C },
    { 0x8957EA97E385AC45,0x707E7445B4FF3D17,0x4A6D4DC840A361CF,0xD086353B13AAE7DB,0xD856F4C9A478B479,0xF687400F4D7CF67D,0xFA3000B6CE52336B,0x805459D7D0B88A94,0x00000000000001EC }
  },
  { /* Point #5 */
    { 0x532BD21548237525,0xBB14742DF826B4E5,0xDDADBE444D9F4791,0xCDD681D76344CDDF,0x721F15A2B5AF617C,0x2740BC187433253C,0x727759A2A3C6809A,0x2128A7A5E802EB9E,0x000000000000007D },
    { 0x41B7109ED9C2052A,0xA0CB726271A26434,0x50F1DC72ACA51897,0x28CACA3567067A10,0xAB969C93CD61B985,0xD3986E20491A61D2,0xCFD5713CDC034A35,0x6FAD36260525F8AA,0x00000000000001B3 }
  },
  { /* Point #6 */
    { 0x96632B75ABE029FD,0x38280DBD57AAA853,0x2A49FF1956556BF7,0x76AF8029017AD9E7,0xE231979265EA6EDF,0x71B0793C9CBB4069,0x1F89D54DF62D86DD,0x48601CBD52809190,0x0000000000000116 },
    { 0x825A9EC295F5317C,0x9AF044995B568F34,0x0A74E92670C96172,0xA87FCC849CBE4CA2,0x409E58C017B5587B,0xAE221D81686599F1,0xDB87C25E9B04AE84,0x2A847873F9A49CB1,0x000000000000019A }
  },
  { /* Point #7 */
    { 0x8104E3710ADFEE2F,0x021A434F3A0AAF8B,0xD2A2E82CA2908065,0x770F059D1E0D4B4D,0x7B4DEFE2962BA072,0x8183594731DD59BE,0xDA69E9A5D6638F80,0x58F0BCA6114759D3,0x0000000000000154 },
    { 0x0DB1AA529EF7A0C7,0xB2450BD816F4ABF3,0x0670492CAD0D02AA,0x6CDB3460E2C5C42B,0x663BD232DDF42A06,0x23550ED5F76EBEF0,0x0FC632848D9CCB9C,0xEB0B313FD425EF44,0x000000000000001A }
  },
  { /* Point #8 */
    { 0xE862A17BBEB4F9F1,0x5E701369310C4B65,0x01EF66253377F678,0x56157709DA8BEB61,0x7CA21B049EF7DA41,0x9F776DAC88E486A6,0x53DD04CF8AED6F6C,0x4A7DF43E953C2D95,0x0000000000000158 },
    { 0xE5BC0DED1FCC4484,0xB337EB4EEF6D0E8A,0x02208B42DABF0D9E,0xE64C8529467BFC55,0x0CF409592E141810,0xA34AF9D656FA0BAD,0xF3471D5A5345141C,0x89A7A82C1FF7597E,0x000000000000014E }
  },
  { /* Point #9 */
    { 0x0D68D12F60BC6BDE,0x6001CA9F09BBF4B4,0xDFEF43ACA9D3F22B,0x07F36EC2268008BC,0x927D953E01E5CE02,0x986A398D316D404B,0xA5F0B888D6C69AF9,0x696EA4AB4E047A86,0x00000000000001B9 },
    { 0x01D936B15AEC8177,0xC9178F2829FF495E,0x85845A066875AD0A,0x2B65FDEA3EA3DBEA,0xBC535C638908096E,0x2A3AFC5AB549637A,0xF54CB6ED3A31B4AF,0xCD3FA4C14D19E739,0x0000000000000017 }
  },
  { /* Point #10 */
    { 0x3FE4077368245BB9,0x89A284BBA3626A8B,0x73C190915A9D7FF6,0x8E3BAF6FCEF0B5EB,0xE3D8006921AA008A,0xAA3F179932B686A5,0xD20CFB52EB1EA953,0xD62B692F360C2AC8,0x0000000000000050 },
    { 0xB1B8BF37F4C933E6,0x090D3BDD5AF935BC,0x8E4854D2AD9D74E0,0x5B38D8EBA00BF5F8,0x837582475F478824,0x5C7E2413F71A8D3A,0x955642770665C873,0x37D95026D1F7A638,0x000000000000013F }
  },
  { /* Point #11 */
    { 0xF32D5FAEF51788C3,0x8346895B815C16D0,0x27D4A43E2E426F50,0x77CDDD7B93FDB664,0x70FC0BB72F3EC9CA,0x6D04715B07957391,0xDF972FF1B2459241,0x664361603E9F78E1,0x000000000000004C },
    { 0x73EC8F9040DCB28A,0x044D454A673FC68A,0xC09F9EA3B3024805,0xF7BBE29C542FDC34,0xB44F9C3CE26DF556,0xAEA123078863C75F,0xA229FEAD9FDCF582,0xE84269B2B3F1E6C7,0x000000000000004E }
  },
  { /* Point #12 */
    { 0x10459ADC9FAE827D,0xB9C6D71D622DAE77,0x8D379015BED58A7E,0xE6B71390B90143C2,0x08EB29C40A8985F3,0x30C331FF08DB169E,0xBE336067077FCC98,0xAF6477724E16C914,0x00000000000000BC },
    { 0x1836D521E134601F,0x8365F5C7A58CEDA3,0xC4C114F6A6FE142F,0x4651388D461A4D3B,0x1B4CF10A639F7948,0x140F9EFD361665E3,0x436F20B0C743B8C7,0x4E1D732D710CC0A6,0x0000000000000186 }
  },
  { /* Point #13 */
    { 0x262448CDF88E473B,0x93ABD4773A95BBD7,0x6AB8F2B6E4DFD381,0x9C333DC5332001EC,0x10F8F684ED85F215,0x6302FB126824087B,0xFD09387CD8B56E13,0x9798EE3BE3D7FD78,0x0000000000000077 },
    { 0xA0C6DA08B27A72D8,0xE8A34850021A2C0D,0x7C61148E077CCBA2,0x690FE02D8E1E7E8E,0x5E80DBAAE95A3952,0xC9E270AF7319900A,0xBDD5715E6508E84B,0x31BAA323EA1D1CC8,0x0000000000000037 }
  },
  { /* Point #14 */
    { 0xBD6DB523C85A0848,0x987C70FDDACB2B06,0x3DBAA519B16E9914,0x14205AEF40B2923D,0x5D09323EC1D161DB,0xA68B68850E462298,0x0EECAB4FDB91CEB8,0x10FF0480339FB226,0x0000000000000099 },
    { 0x4BFE6F364DEF0C94,0x21B3CD30AE7C0CEE,0x2396BA6610B510CA,0x2C9B665184B52FBF,0x25E93BEF7A84E6AF,0x83846A6623F7A204,0xF5EB2E3E5DA84C02,0x73E65CC62C870984,0x00000000000000A3 }
  },
  { /* Point #15 */
    { 0x5D5E9512CE383299,0x8FD49641858FD0D2,0x48C282F5932EE52D,0x53A0FE9A980EB988,0x947C916F50D9BFA8,0xDE9B933A4396BBE9,0x0C56EFB425E64DEA,0x7BE792217FCE085D,0x0000000000000125 },
    { 0x281323014193D3A0,0xD5DC4679BF8DFECF,0x77513BAF6984C1D7,0xF46916F1389B5C34,0x2C271D08F4A1AFA9,0x6CAFB28C1653A5BD,0x931DB2696BE94DBC,0x1A2FE5F1A455620A,0x000000000000002D }
  }
 },
 { /* Table #125 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x4270A7973C80F820,0xE1455E1CD8E3DB55,0xFC7D04B5C31EEA36,0x86D4B43D8237619E,0xCA90FEAD5696AC8B,0xD1DF350DBE0A5D49,0x844E818FAEA06270,0xFA19B70BD89CC1DC,0x00000000000000FB },
    { 0xBAE72FF552FE816F,0x7B5D9E529A5A3747,0x7A7EADCCA689A68A,0x18DEC239330BA649,0xAFC49E4CEB30BD8F,0x2504271680C1A715,0x4D5AAFFFBF6E92D9,0x94AF51FB7577CC4F,0x00000000000001B9 }
  },
  { /* Point #2 */
    { 0x513A0C6260637AB1,0x4A25BEE092C5B308,0xCD3DDE9265D8B6A4,0xCE8ECE9B60EA70D4,0x289B7557AF5D779F,0x1DF029A4FF6459CF,0xD00AC6D5CE09288B,0x9A9F96859A9F5B92,0x000000000000006F },
    { 0x18CB0922B5B63CD8,0xD4753FF126FD1C21,0xA4D1F3571080DAC9,0x7FE4F3AC24DE88C3,0x4BA767DA3E60655C,0xAF4A647436C75E45,0x4854EB2195F2505F,0x831446CFFE3B33EF,0x000000000000016D }
  },
  { /* Point #3 */
    { 0x8E1A6C2F3E0BEF3F,0xB715403E14018B23,0xEFC99827613F0C37,0x92437B5613170A30,0xE84CBE8F9468E300,0xE69B08F14BAB3970,0xFCB78F771558E9D6,0xC0140529AF25ED50,0x000000000000017E },
    { 0xFF3FA668168134C6,0x46E8EDC72BCC2E99,0xBBEBB21C86BFBF06,0x6B7D6159F204DD32,0x75BB85EC1FC7E40A,0x0F3E1043AD14C187,0x44187117000A86BA,0x556420BB13D09DEF,0x0000000000000177 }
  },
  { /* Point #4 */
    { 0xEDBB59DCA9AFF80C,0xB32F9F1D305107CC,0x7A0DE3D199D4D1F8,0x701B04850637729E,0x13D85CC4B86C08AF,0xFE4B62A8CD43B0E7,0xBA8BA3F38A012627,0xA589240B2168BDF6,0x0000000000000073 },
    { 0x028C8C11D8F16B56,0xFF6F2AA753816648,0x677B98AB29BBD5AB,0x492513B8221F17F2,0x828FA4BAA5ECA5AA,0x15B65B2B560D8196,0x737CDF4377FE2F2D,0xCB1BC918C044CC80,0x0000000000000138 }
  },
  { /* Point #5 */
    { 0xF0FA90D83B50A230,0xDD15885FFD95910F,0x4105A4E148038A64,0x2F69D817AE07FCD1,0x0536353FD0484F76,0xB3BEB1EEB8D64BAA,0x2FF37FF558ADC510,0x5677B99149F78E1F,0x00000000000001B0 },
    { 0xE22BF1CE43B8275E,0x5EC18F04B7BC2931,0xCB53D3E0F01FA620,0x49DB793F9587E525,0x7F1E4CA35C884F2D,0x5AD4E4C459437624,0xA1E3329F4994207A,0xE4CB938F88594AEF,0x00000000000001CE }
  },
  { /* Point #6 */
    { 0x00A2AD7EAAFD5467,0xA8290D94F9741F30,0x6173F2E7A3D3ADC7,0x0AD6AB5468875A74,0x48E49F0324328133,0x2D2D704A19E27E19,0x3BD63D36DE1ED374,0xDEBC4384C0AC7774,0x0000000000000195 },
    { 0xEABAFCE86FD61140,0xEF8C38AF22938DF5,0x407C6D243C98D287,0x75BC698685564DD7,0x240A470C4C9D6C14,0x9CDC41FF8AECA79E,0xCF08ACAEE1DD8F22,0x2D99CBE50D69225A,0x00000000000000DF }
  },
  { /* Point #7 */
    { 0xCD2CDD2E734C5662,0x086508DD52FCD5A2,0xD1789E1F65545779,0xA3E5A37A3EBF0E2E,0xA648B51121F33614,0xC1B816D4000154BE,0x7D9C4292A8F82A71,0xF0F81CB86F43867B,0x000000000000001B },
    { 0x1FE1F9962B51C7D5,0x5C77E78006A54F1C,0x79DC60E2DCFA901B,0x2C548507BBD1244E,0x59CCE9C315CA7601,0x2EC825718F106B96,0xC1EBCF8DF5DC4E24,0xB785EE5F1448C529,0x00000000000000D5 }
  },
  { /* Point #8 */
    { 0xBF2B204CDB0E34F0,0x177EE402B55297CF,0x1008722A0905589D,0x92BE4754965EF825,0x4CE902BDEEEF76A6,0x55B910714F318009,0x96BEAE611484B98F,0x5D84B61535B88659,0x000000000000015A },
    { 0x43C74CE31D78D96A,0x131FBC58A17753BA,0x4E430AF6DC789AAC,0x31F38805E9AF4951,0x834DE4AAA61CBB24,0x8437617EF678C74A,0x411E5009E030372E,0xBE15903CA2047BCF,0x000000000000001A }
  },
  { /* Point #9 */
    { 0x2D097EB37EE7BD6F,0x69F628B2AE5F90E0,0xB66FDE22C085AB02,0xB92EA6938C37D985,0xDF48A816CBD2EDE0,0x72FECA7639A54F77,0x23C12AF21E010C59,0x70A9847106D1B180,0x00000000000000A2 },
    { 0x3D3D798DD1A5C22E,0x84A3B9CD2449ECC1,0x663D1F115C945B4E,0xDF6EF3EE776095EA,0x4ECEB1E84123E9F6,0x43A5FC47D51910F5,0x7ED8C1687F82C9F2,0xE85DF3ED24829770,0x000000000000003A }
  },
  { /* Point #10 */
    { 0x824E5A246A6A1965,0x28E49A510067007F,0x6DA0C6A4CF3CC799,0xA2BE3ABEB35F4943,0xA285063331F3D91F,0x3E0E3F0AD4B086CE,0x72DDB089C6BB2E16,0xCB6ABA2560F84948,0x00000000000001CC },
    { 0xE3E05A6DAEEAF241,0x44ABB4D20773987A,0xAEFD9C4ABD017248,0xCF519D193395321A,0xE9BC32DCCF66A399,0xA8DB3162F1387704,0xCB1AC56D1E2F49B3,0x44A07E8607D3217C,0x0000000000000075 }
  },
  { /* Point #11 */
    { 0xD43C6D81C860A565,0xE0A87EC933F30C31,0xFE006AD9036F96CF,0xCD4C100092D0D9FC,0xC7EF53A3B2CE5F90,0x61A9C4805BB8B35A,0x55F913214C749C08,0x4E12D6EC285E3E42,0x0000000000000144 },
    { 0x80DB0B68CD23314B,0xD6880D3B79DA65C7,0x77B6B6DB81BF1BA8,0xE5FD0C4DFC478427,0x114C21E7F05B693C,0xAF4FB843BCDF7332,0xDCD23F0842BD3159,0xC01352DF8376DF1A,0x0000000000000093 }
  },
  { /* Point #12 */
    { 0xF86CEE348A111ED4,0x4916DD27CAD36812,0x552160EC88468FEC,0x8D1636FB6CF0B3EB,0x9AE45C066B6F908E,0x26AF897B63257782,0x7DCE10C123C52D51,0xA3E96EC32D4F4D57,0x00000000000000A9 },
    { 0x83B225F503617B6F,0x874AC939315A1171,0x60B42A90FD1D0CDE,0x4A66E8D1AE162370,0xDC4CE9B414670E9E,0x3B9FE4252E010B87,0x771E8357F29F98FA,0x70D4975D6BF99475,0x0000000000000075 }
  },
  { /* Point #13 */
    { 0x7B2E5A5D9FD49E87,0xAD5BEC2E2FFEC17F,0xDC49ACA9E5A6A8A1,0xF2CF905C854B52D8,0x921C2E580539271D,0xA2A6CCE9614C09DE,0x19515706BB1F7E74,0xBD59E4624329F30F,0x00000000000000B9 },
    { 0x6875E814FF093B63,0xA5527D427C12C1CE,0xC959D9AFC732E727,0x9FD4E513685962B1,0x6FF5562503116D62,0xB3EFDDFD1876A15E,0x2FA73256243A14A3,0x798C96DC10E74AB3,0x000000000000007D }
  },
  { /* Point #14 */
    { 0xD6DF1E15C00680E1,0x51507B283F6AD258,0x7CA473FAEFCAD3A9,0x44D3CC520C52D9FC,0x5F5D94EF35B42ABA,0xAFFDBA8DF9C52CCB,0x78FD1E19D66DB283,0x3655031843682673,0x00000000000000A2 },
    { 0xC186700970E7A2BD,0xDFF4FC0C3A577167,0xCFD0AEB2DD2579A6,0x51652EB1934B577B,0xA80E3068F01736F1,0x7805D358C0A234D7,0x124D0F07CD58E45A,0x61E0E16D005624DA,0x00000000000000FB }
  },
  { /* Point #15 */
    { 0xFEA5C732F0626BFA,0x84F08F1B9227FACF,0xEF6255130DC94F56,0xFDF1F1151B3F90A6,0x13B8F36C37DA26AF,0xDA51EFA9762943E3,0x1CCAF39A7ADE265C,0xA6EE8CE9970F4DE0,0x00000000000001CB },
    { 0x76336D3F6D955E29,0xF620472A240BEB57,0xD1C32A881FA41EF0,0x97DA68DABEC2C892,0xED864144E45B9667,0x1741917BBE5B29EA,0x4B9DAC829FDDB570,0x905FD0B4113811D6,0x00000000000001BF }
  }
 },
 { /* Table #126 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0xFC5BA8D59DA7BB54,0x29F3E817A7C7FBCB,0x31A34412A40AD3FC,0xE17B93692D1711B0,0x41C7BC1716EE6505,0x5FEECFFD3D1DB8CA,0xCBB9337802F9E04E,0xAEB67B8B091DB41E,0x0000000000000187 },
    { 0x611FE09D4C695615,0x087334F6323B6DCC,0xF7BD51BBD53BCFDC,0x98AB5C925A8BCDB4,0xE7E9D273CCCD6F6A,0x2582B21924B4A3EA,0xF8FEA0E3F22C4405,0x42C0F700D3E5A701,0x000000000000006D }
  },
  { /* Point #2 */
    { 0xE9F67439CF6368A6,0xF570101A4C1C8628,0xF3CCE189C652A95D,0x85A1AF6B75CEDBF5,0x8B7F513D68D0FFBC,0xC71778FB136394BE,0xD0E7F981D99C9F74,0x6A4AE0F46471443B,0x000000000000018E },
    { 0x702BF6631F3F2C6D,0xC1233CDECEDAD859,0xA8EA4A8398C674EA,0x338B3334F3C423C5,0xBEA2BBF7DC103DC3,0xD49C4A620FBD8A4C,0xA73566DE57B93DA1,0x0AD24597F56838B4,0x0000000000000127 }
  },
  { /* Point #3 */
    { 0x38E5B06F76F468B8,0xEAB47690C79FA86D,0x990E59DE6EF8CD4A,0x826C78E86884D059,0x951732FE341B20F7,0xF249FAE4449DDAE6,0x32C4B1E5A30A08AF,0x79FB2CAB15BE777B,0x0000000000000027 },
    { 0x1C65411BC3F609D4,0x4A8EC1376194FA7E,0x025DD9CAA41C5F89,0x878F8D01E9D5AA4B,0x34C9E12E0F364D3B,0x5F4403D0344CF712,0xE66BB7825BEA60C3,0x4DC50E44D40E673A,0x0000000000000125 }
  },
  { /* Point #4 */
    { 0x104E0C37F8CB0CDF,0xBA344BC4B934F03F,0xF963FC250A5AA9D6,0x8BBF6E9E662E69CB,0x5B9945C916FCA9B1,0x6805ABD3682C739F,0x3D1EE371C3F18432,0x4708B55C05E69189,0x00000000000001E8 },
    { 0x9682D9D3143EC89C,0x519A8B7AB2B5914F,0x7FB197F1FA9D63C6,0x6C4D61EED19FD1D8,0x3A2A488ED637793D,0x1DBB1B1A1FFC620D,0x66EAB0524B551244,0x290E50FD434C6CC1,0x00000000000000CF }
  },
  { /* Point #5 */
    { 0x4515DA106221C6F8,0xBF5FD8E5BD34CAF6,0x9174AD19C7A869A1,0x3E327C1357152EF1,0x58656B31222CBBE4,0x111892141C4191EF,0xA5E5AD3EB7143EC8,0xE0646AFA4536E2FD,0x00000000000000E9 },
    { 0xB13D24486D16BAE5,0x42431B34AF57B380,0xCAFE41015E097FD6,0x5F794CD6E5B0937F,0x4DE1813D55270A50,0xCA0A5C09B660BC2B,0x08F20F6B76579886,0x21268E682ADA1C30,0x00000000000000B1 }
  },
  { /* Point #6 */
    { 0x9793778B98C439D0,0x79788F592AF8CE86,0xC1520A86146D0C4F,0x541063DA596B5B59,0x47823A1E9EBA6471,0x7F66A3891D23923F,0x4B23C930452ECBDB,0x40C7D3DDE30657BE,0x00000000000000F0 },
    { 0xB63D974A77D535C7,0x2E16AC32CA31932F,0x68DA3CD12B8664B1,0xC895A61FCEE5478D,0x34BBAC9042C0AC31,0x5CDBD70DA3267F5E,0x8B4D75BEB4A7AE31,0x1555CAF3F43C9C86,0x0000000000000039 }
  },
  { /* Point #7 */
    { 0x50714FB3C0D037F7,0x071BFA5B8C050618,0x7F1798269D15E2F1,0x2081039729E730FA,0x7948C181B45794D1,0xC8FBDEE3171227AC,0x1FAA467045DA4E9C,0x565405C00D3FE74B,0x000000000000007C },
    { 0x353FC94A3F42236A,0x684A11C27BC40D6C,0x182CA3AF52826E75,0x7B24ECCCD4058F7F,0x6CADB9BA82386F7B,0xEEBCDEB53567D0EA,0x904FD55C1E8C8CE2,0x43FD20DB6B578B37,0x00000000000000A5 }
  },
  { /* Point #8 */
    { 0x842E5742310BE81B,0x9CD6A5AC815531F2,0x1C8179B837F9F02F,0x009CFA294FAC713B,0x091F5101D2AA2C79,0x70360695EF9256C6,0xD8D52D11FAD0A22A,0xF395FEF240FF5EE7,0x00000000000001AB },
    { 0xFBD0E2D746CCCDE9,0x8E8A81F7F8D82FE8,0x63BB8CE1C0766BF2,0x917BA75AC70E96E5,0x2BAF9FA493D4D0FE,0xA203F382C28324D4,0x36385F59B1B2C7D3,0x746BCE122C80EE37,0x00000000000001E1 }
  },
  { /* Point #9 */
    { 0xEC99F07E8B313476,0x9856C5B352530DE1,0x08CA437CF2693956,0x990F6A868F4122AA,0xA36C9D84D76BB2AB,0x6004FBBF1E657EF9,0x6C64F52F4108D873,0xE3E589A670224F93,0x00000000000001A4 },
    { 0xAE219487D6132691,0xB26711505BB911E5,0xCDD0BC5F15177196,0xB093AAE02605FD89,0x26D1C416C319A26E,0xE8916E3D6EF59CB6,0xB05A13D56E79807D,0x8A178214C039CD95,0x00000000000000B6 }
  },
  { /* Point #10 */
    { 0x7282C91615FEAD87,0xBC1AAF596565472F,0x5A7BBFC458B387F5,0x665EB3B16DEFA8E5,0x1944CFC86DA1CA94,0x41AAFF4D2A2DE565,0x4497CDBAB7311F8C,0x129ECC29F2264D67,0x00000000000000E5 },
    { 0xA0E20DF230229EFB,0x7C4E6966BF174745,0xE96F0AB07C0177FC,0x221D8CB684FD2C4F,0xCCF21EC330689B70,0xD7DAA585F24CF84C,0xCCC2582B438B0F34,0x6940385ED02CCE0B,0x000000000000011F }
  },
  { /* Point #11 */
    { 0x6E985FDCF7286539,0xBF44AE0526699ADF,0xBFE83F9D751DA127,0x7DF2F5C0D22871D2,0x61A184DA09F210A7,0x69B4001A9E56E9BC,0x3F48DC50F5801782,0x114FB0A2E0BC2F08,0x000000000000002B },
    { 0x44EB8F92011D6DE8,0x3E0FE24320DF8124,0x494B83E071B8153A,0x6B50C1E31CBC91E6,0x260D1694B8F14373,0xF12E1B9298782CD5,0xB8BC2AFE7211A9DE,0x3604C2396EBBAD8B,0x0000000000000123 }
  },
  { /* Point #12 */
    { 0x5F9A4772E44F4DDB,0xFF089398A0479FEE,0xC7984A9A309C362D,0xC8858F6C2ECF134D,0xFC9C56401A56D029,0xD77E773207B47628,0x36BB84D6D5D61144,0x8D6E8E0DF628BB09,0x0000000000000171 },
    { 0xFD69C84A1B585B76,0x2FE3FC195BFE6558,0x9365C43C978729F7,0x3BEA9B49B368B24A,0xB6FEF7DB69A7B390,0xC85C1D51848BD710,0x7B3A49FA90BBC984,0xD65E2E2D651DF377,0x00000000000001BB }
  },
  { /* Point #13 */
    { 0xE8EAA2B093EE1688,0xAB51392F1BD7B754,0x70FAAF847F0113F0,0x0B68566CCCDFA903,0xBD54A08C9114D07D,0x4370AF4A2EB3D473,0x6F5596B430650B8E,0x1D9D998EBDAEEBBB,0x000000000000009B },
    { 0x1E07AAB3EB570CA0,0x6CC5717883D78D65,0x5C13B03927E07BA1,0x4A8DB7258593ACF1,0xF2FBBA8B4560970B,0xA7EE45FB79FE5510,0x8DEFA4EC7DF14EDA,0x664E0D14F6249CAC,0x000000000000005A }
  },
  { /* Point #14 */
    { 0xFE6BC737BA913D04,0x5356A7C0E8D667F3,0x71D72789C6A981FD,0x7B33CCCC1D45CEA8,0xEC69E42AD2F757C8,0x3E228959A5590D96,0xC04189AA63BE779E,0x2649054DC984B85A,0x0000000000000188 },
    { 0x332AF6F228FB3ABD,0xE8DE53E45031C4CF,0x881F78F7363BB9F8,0xFFD28EAA31D76D0F,0xF618633502723C25,0xCC4D0074E497DD32,0x7C24A1C114BE4804,0xFEFEEA3E5150CA3D,0x00000000000000B7 }
  },
  { /* Point #15 */
    { 0x93D8A6CC1CBA39AE,0xC09391F078B306EB,0xC50192796BBE7209,0xAE87581B69C4000F,0xAACA7F02E29CDE0C,0xF495236787D2F7B9,0x831F4D68D01D00D5,0x17C135ACBAE32D64,0x000000000000002A },
    { 0xE83E6BBEFA7A973E,0xAA3D68978ED040DA,0xB2915BB0B7726A22,0x84C84815C39A8A47,0x42FB407EB29908B3,0x9A5BE91841B90531,0xD534B5CE6025EC50,0x56F74C30BD08106D,0x00000000000000AC }
  }
 },
 { /* Table #127 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x312DC896A3A2BE76,0x9E77C0C361DA109B,0xB1C5379DBF0993BE,0x9272B9E8B7BCC4DD,0x5437F62509337D54,0x5C897A61CF735302,0x368E21CA002DB288,0x33197CC1184AEE4A,0x00000000000001AF },
    { 0x76EC7312E5C35F69,0x6832A65AC07874D4,0x398DAB5AC121E8C9,0xF88AA2C897B47C38,0xFC77E1C007678CF3,0x7327A90F345A9B89,0x267417A049240B3E,0x3AA3EA97E3912921,0x0000000000000116 }
  },
  { /* Point #2 */
    { 0x11771BFC92E6CD70,0xF5BD487F65C65A34,0x1B3CB720081B98D1,0x32485EC4026B378F,0xE3C71A99529C1313,0xC85BDE7D3526EF07,0xA85C138B84E3DBEB,0xE6E886AFA239B5A7,0x00000000000000F4 },
    { 0xF65240A56E2040FE,0x1596F10816AF1685,0x20B38D3EB90B3A9C,0x81A30FEB9C3FDF7A,0x04031BB33731C3BF,0xADFE3FB3AD2B6D6E,0x243B36230FEE06E0,0x2BC6DF9225D016E6,0x0000000000000053 }
  },
  { /* Point #3 */
    { 0x29D30CCFDBA3263A,0x3DDEC6F458F319D0,0x6859BE59AA8889DE,0xD21B5A3F37E57788,0x0BC2F50B8E56E5F0,0xB76D24E42B8C2B6D,0xD7B4C5575731D66F,0x59D33A6E8A0E50A1,0x00000000000001E3 },
    { 0x4DECDB8E57DC5E0B,0xE1FD10AED8E33978,0xBC70D10B17F26C32,0x15026720A9D2255D,0x68A1E644FB625FFA,0xDD3DCA9F0B24BB44,0x3A192D90F8932BC0,0x0F7120B476268713,0x00000000000000D5 }
  },
  { /* Point #4 */
    { 0xFA5944257D7D3912,0x208AF690F57DC595,0xA277E9808287E9A5,0xFE15C6E2D556FA0B,0x4B4612EE81A8260C,0x6E171BD7CDA05AB2,0xC417D3D1DE584E28,0xAFF5E9B98EFF9FF5,0x0000000000000188 },
    { 0xB0700568C6C3151A,0xCCD55DC01F049293,0x7C6E61AB443D10A0,0x9C2C964B0A4546A9,0xF470D97E7FA4474D,0x378D416F74B749FD,0xC821766F1D9FEA8F,0x71C9FAB02E3D8DD9,0x0000000000000027 }
  },
  { /* Point #5 */
    { 0x24B869A68CE85B23,0xCAEDAAFF63B5011F,0xC8B5D84E82987CA1,0xC6960DFEA44A8BBB,0x83D1EC6B9FDC95CE,0xF30C2D5E2D666E45,0xEB743DA76D92A25B,0x3F4AC0F3BAF0F20B,0x00000000000001EC },
    { 0x5DD9518310321910,0xFB9C06AD1DD9D170,0x020AC2DAD5F9DBC6,0x9A9E842B372D2ADE,0xD62D4C6409A85C7F,0xF12BFF21CCD72A88,0xDB1876D47FEE26FA,0x27913F5CC202BE11,0x00000000000001A1 }
  },
  { /* Point #6 */
    { 0x44CC7FB102E1C728,0xA957A60D34A729F4,0xED0B434ADFC2755F,0x4E195EA0959B558E,0x5162B567651796C4,0x4B5E7FE61BE4A6BA,0xB280A035B5A306D4,0x321DF371547F4D84,0x0000000000000020 },
    { 0xC86D01547641D9B6,0x4261B77D04BC36BF,0x054BD171CB4B8484,0x7ADA14DDA159E1B8,0x2EF6737AA575A44A,0x8C0B3BDF8F7DD923,0xA656A2A7B01C493C,0x83D77F410C530D3F,0x00000000000001CB }
  },
  { /* Point #7 */
    { 0x5438F933E6C5B553,0x6F01A8A41C80ACAC,0x5A25BD9B9EB0B0F8,0xDF47BE5C12959E24,0x10D9338FE5B854AC,0x8545EB47E7C3F1FD,0x18E1F37BD5A20D8A,0x222A70567A837AA9,0x0000000000000155 },
    { 0x213B368CA2862A80,0x67A67CFA668758C8,0xB262ABB10E3C7BAD,0xD310888EED814AA0,0x1F2584096BDE422B,0x7505C265D8D5E8DF,0xBC7CC14E12EB7885,0xA78E64169B41D8C0,0x0000000000000097 }
  },
  { /* Point #8 */
    { 0xBBA0D1F988468571,0x4B15325D14EDF415,0xBA40AD2E5B315437,0x4CCE24B45214DEB0,0x33CCC948F3217CA3,0xC9A387C88D2D7D56,0x19C908921569445E,0x6B925FF0C50A9417,0x00000000000001AF },
    { 0x55FCFC767FA33215,0x2B7B66383E2B25B5,0xB765A15B602D0860,0xEFDEBACE1A252B65,0x8117E367F315947E,0xBDD3A76A501FA6A2,0x0F224474F4B0CC16,0x694E2254515F0DCB,0x000000000000013E }
  },
  { /* Point #9 */
    { 0x2804CB227AA42326,0x68362B9A9687C2D6,0x1DCE11601E27C7C3,0x30D1AF19102F1275,0xF74A075F55DDEB94,0x4F84DE617A4E9F87,0x4D53A0350AC18472,0xDBA3E51A6E4290B4,0x00000000000000D3 },
    { 0xBCFC6CD332CFF069,0x5F20FA5E5BAF3F63,0xFEECB0FD778E7C9F,0xD12849A7CA4C764F,0xB35F55A315029ECA,0xE84AF54BB5B3C5C2,0xE50A70E3897D049A,0x7A0734D17BFAF1FD,0x0000000000000042 }
  },
  { /* Point #10 */
    { 0x3CB00D984C682037,0x38F444A323497628,0x42AF8E362D5AD6D8,0xBD6820008780A7F0,0x62F4A712189758BF,0x2DA6F47AC36576F7,0xA16488863CC36D07,0x2A90F94C81E28182,0x00000000000000BF },
    { 0xDCED00AC414628CE,0x319E703C20CB141E,0x81C148EEE25AAE97,0xA1929310C8E3A11F,0xF822612D87675EF9,0x4B01CBAF2FC4FDF9,0x57B06AAA01BFB145,0x06EC3954A23C15CA,0x00000000000001D8 }
  },
  { /* Point #11 */
    { 0x6A34DD81AF2EA01E,0x2491D8A0284D94B6,0x2634FB6D2ADA657B,0xCD2642E686772CE5,0xC46BEF4131A8D8D7,0x0EE6BD51CFA957FE,0x9FD414D5BF0E4FE1,0xCCB01FE1FBC62A8B,0x0000000000000123 },
    { 0x4B0E4F700F4B612F,0x00F585F2B0325F37,0x459596A7949C7280,0x23CA5A417814B24E,0x7B1CF9B506F7A62C,0xDDE0C67D1E554A00,0x4754E3EFDB2E0EAD,0x89AAB96C011E73BC,0x000000000000004C }
  },
  { /* Point #12 */
    { 0xCCEF10E33FB18C55,0x6219BFB16EAC2655,0xE2607AD23906F9A9,0x035E042D365616F0,0xAE6452D7043EE81A,0x570E5905D6708066,0x7B4D75DF02AC12F0,0xAE2D0F35ACA152C9,0x0000000000000093 },
    { 0x3E15452CCB51B6CA,0x58B633C6F48A62EC,0xDB8020B0DDEDB29D,0xBA1CF80298E30710,0x718776AA4C7E0C0E,0x07018AB716278714,0x1938899DFD87F7E3,0x8DF936C944B5D96A,0x000000000000013E }
  },
  { /* Point #13 */
    { 0x9C5FB9B7D9E35701,0x957DBBE43568E84F,0x0D0FFAEAD61E07D4,0x212FA45EA696866A,0x6164F6EB41BE8D09,0xC739900317F98FBB,0x832377EAE5CDA651,0x08E821224F233F7B,0x000000000000013A },
    { 0x2B50F00F23DA8433,0x4E6FA2789EEE9ABC,0xA291E2A84F692C3D,0x4CF55255C8DFC745,0x2A16F670BAFC291F,0xDEF081FE6B7E3721,0x28E10E5C154A678E,0x89BFC442440BD4AB,0x0000000000000024 }
  },
  { /* Point #14 */
    { 0xB7A582083CE06942,0x5DF560ECA8F60B07,0x2754F641A7BD66AB,0x9F6E49F8585596AA,0x997B22A0C51A7910,0x0DF36D9444822835,0xF2B82F5D29B50AEB,0xD13E6DD71EF8A0D8,0x000000000000014D },
    { 0x3D0C210C87801431,0x494AF652F5201BF3,0x679FB6B1CE4C5103,0x42ACD0AC3B662D59,0x0B91158B2B60E2C9,0x83CCD5CA6EDC4C3F,0x944A1340F517260C,0xB725A6B6276B5DF3,0x0000000000000189 }
  },
  { /* Point #15 */
    { 0xD0CCCB6F02DF43D8,0xF7BDD45A912DEC6D,0x88E703DF5D20DB42,0x8F724BCB5A544F82,0x92D6B55C5E6B60F8,0x077C460BD42D0C1A,0x3C38D9028B7F9DF9,0x81B7905312E92942,0x000000000000008B },
    { 0x7B57D763B8AFD25F,0x39865D45CA2315AA,0x8CCD18BED3664CA8,0x530B5E0385EC3085,0x5B714BE03C31FF8C,0x8CC0BA285434294B,0xB97649E78735E81A,0x474DE1AE8DAB1E80,0x000000000000006E }
  }
 },
 { /* Table #128 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x22B8ECCB56B092A2,0x0A47D70E736EA9AA,0x3EEFC772D64A7D08,0x85408CECBB2E0F14,0x73047AFD285CB70E,0x1732F01663297A2A,0x4DFE656A4CF37EAC,0x147D6D66C0EC357B,0x00000000000000C7 },
    { 0x1F3E59103C115125,0x0D2D18FCBFB07241,0x5D6AA860BA4B009D,0x8D0D9368806FF8ED,0xCC5CA3701A05C049,0x7BF21CAEE9AB4C41,0x6632C3E0001D5CCA,0x3A4F99B6B60E5593,0x0000000000000008 }
  },
  { /* Point #2 */
    { 0xAED7666AE6B2853F,0xA1FC0332BE96140B,0xB99A5DC81C1E38B1,0x56194675F38C5243,0x16C6F80E80D38681,0x1117841314205F46,0xD2DC67BC6EE03089,0x5E18245ED3DAD965,0x00000000000001E3 },
    { 0x389E59CAFDA7741E,0xF341D649259E4DCB,0xEC15D27A260B32B0,0xF3A1A08207640CEA,0x15AC31456E811313,0xB9027CE47CF68896,0xB43E4FD77008A356,0x541AA5B4640C2C60,0x00000000000001C3 }
  },
  { /* Point #3 */
    { 0x3C32F4E34CB99695,0x0DB56646C1241E0C,0xA4CEA13B28515D66,0x1C8F63975F3AB5DC,0xD466A1B34DEFD3EB,0xCDBB66B5E6D860D2,0x26FC2FD5FE87183E,0x02D81A03D18233A9,0x00000000000000D2 },
    { 0xDC570644CAA08959,0x7791CC35CF763C20,0x3C0DC132272A1068,0xD7AD702CC8A74578,0x7689C46EADA1D72C,0xBFC2E06F2B8B4369,0xDE85E36EC0BBD6C4,0xD879E086F9849084,0x0000000000000077 }
  },
  { /* Point #4 */
    { 0xEF192AEDDBA16581,0xFF1342112E8DB0FD,0x32551C61BDCA8D0D,0x96E1FF06C55B9AA3,0xA211B1107E4C635F,0x2708E5427C4B6B4A,0x70FF7C3FA6575526,0xD26E2DB636092EC8,0x00000000000001AE },
    { 0x1FAFD3C2533251D0,0x1602462D8A9A439D,0xC057595A1CC5AF27,0xA27197F3BE839C9A,0x03C1CC4BBFC1318A,0xB78C7B7F34D0A378,0x0F9D754E161B4257,0x8DCF43CBF355D916,0x0000000000000194 }
  },
  { /* Point #5 */
    { 0x51DF490DDC3577EC,0x6D8A70E97E28BE3E,0xD87A7ED31DE95E73,0xF97C968DA6C7086E,0xC47B64DC6B4AFE00,0x489F1D988B432676,0x9F2B7996F72C2153,0x4ACD5AE8F820AF70,0x00000000000001A9 },
    { 0xA5CC854BD7263FCF,0x7BD94B2F864FEBF7,0xB3DEF0FF9460C5D4,0x5F0766B5042D47B5,0x9E8484F28AE51B32,0x26EC4EA6F8C729E7,0xF279D7336C2AD315,0xB2D22E6EDAC3E8D0,0x00000000000000F6 }
  },
  { /* Point #6 */
    { 0xB2B4D4085967B43C,0xC660C6C1F35923D2,0x696D9140A27FDE01,0xFCD766EB259432A9,0x6831FDE1CAD2A4E0,0xA157BE88928838EA,0x4B31C1D6791D2740,0xF1958BBA850A1760,0x0000000000000085 },
    { 0x23A6800ED777E0D8,0x84D2780D71CB04D2,0x691076F7D7A8F688,0xCFF1A453E2237B7F,0xB1D9DD8F0A9037D4,0xFACE3A31D9199814,0xFF7BFC81DA563993,0xA0F655ABC61DD36E,0x0000000000000111 }
  },
  { /* Point #7 */
    { 0x43C5BDF15D73ED9A,0xE3766738E71C6E7F,0x625CB8C43947EA97,0xADF7CCC082241BA7,0x629F45B307329130,0x9CFAC1748D0C281A,0x92069E577D14CA06,0xCA121495DC9F83A5,0x00000000000000CF },
    { 0xF4E6DA377DE97FCC,0xD3A271B7025D39DF,0xBF2EBFE8389E12EA,0xF434F29932F184F2,0xFBC3CCB9366EF539,0x4E159CDACDEF4A8F,0xC311BD82B0F0BB8E,0x380B2EB1779669AD,0x00000000000000B8 }
  },
  { /* Point #8 */
    { 0x9A0062D31C2DF559,0xC130A85D2D4E9996,0xB226E6CF370A02F6,0x3FA94ADE7386B10F,0xDDEC1E75D4576547,0x0251109D1DBA7F8F,0x9A3F5313C3A003A9,0x4742778BAB26E65E,0x0000000000000094 },
    { 0x828CA5ADFB997E14,0x3826B0BE65001ED7,0x53FB9CD3CFEC55A5,0x53E96D2831A1B7E7,0xB5CBFDE924F2DFB5,0x3A26A665E944F4A4,0xD637639834E527B2,0x709E156DEDADF5B8,0x000000000000018A }
  },
  { /* Point #9 */
    { 0x412EB9D00D3825AE,0xED91E11C20B658EB,0x0DA403AEE6918918,0x8EC67EA3B084B920,0xA213AA3A1F3D3FF2,0x21DFB5519EFC3CAD,0x30EE2A8A19845C68,0x07B47D281835550A,0x00000000000000B6 },
    { 0xB3EF46192657BEC2,0x607D10122CC2C528,0xA86D31EDC07DB93E,0xC07B3DA980C25CF2,0x5C56CD075C83C1F7,0xF32A98B3A0D7EA59,0x5F1E6FE10CEF77C1,0xFAD8A85EC5B5A9B7,0x00000000000001D5 }
  },
  { /* Point #10 */
    { 0xAB146802BC0D4745,0xF767DF8FFE603917,0x2BBAE80C1988E88D,0x69E9C7E1CFDE1857,0x25A609F58A7C8C60,0x46BCBD1B57CF84D4,0x89AE0BE245C52763,0x13482D1D98558305,0x000000000000003A },
    { 0x66AC9EE936A3D944,0x6822CE1171EC895F,0x8C5F2551938D1792,0x7D5157BCDC481D3B,0x0AAB532D63FA5DEB,0xAD1FB55B99ADBFE7,0x5338D6CA9FCC46DE,0x84B2A63BAE3AA998,0x000000000000018E }
  },
  { /* Point #11 */
    { 0x220024890128270F,0x60DF1294574584F3,0x80DA07D1339AFAA1,0x49CB3FB54873BBE5,0x5E274CE99E32907E,0x2AB695C69C2BD23B,0x63A53145084084B6,0x881EA559B7C43B59,0x00000000000000FA },
    { 0x3D9DE6FFEC7F7938,0x1B40E323C53223BD,0x2B6F33785D3FCE2B,0x5A16083F94BF2FF0,0x4DA0AE8FC30458B5,0x743DFC12F0D0B1C2,0xFFE8B8591863D312,0x1FCBA995114DA460,0x0000000000000065 }
  },
  { /* Point #12 */
    { 0x119638AE44D87D78,0x8980CDDEFF77F891,0xB001AA0F2E3C9F32,0x8CC959D96C93B9A3,0x3889DDD42516F042,0x390FB5C1B2D34007,0xA39B106F093E4A57,0xCB1856652168BCA7,0x0000000000000015 },
    { 0x85ADB26D33E39FBF,0x68B6C5946ED3932C,0x320813886FF4FB12,0x24B50DDA14C7E9F7,0x3E84EDEE6EB8DB2C,0x0D0879A304222282,0xD091B141DB79827F,0x41C1EA1C63D30563,0x00000000000000C5 }
  },
  { /* Point #13 */
    { 0x394547B643684AD6,0x27C93A87A4EFC0B7,0x97914B633832C7EC,0x89291EDD995801B4,0x1B7E633B9ED8DFB4,0xA2A21E650CF5637C,0x4AFEBEF08428BE9A,0x527FC65F42269B08,0x000000000000011B },
    { 0x30099375278302BA,0x0B15CC9A6B1ADE38,0x6B6AD14EA4BB5288,0xC0DBBE3F6425657E,0xA611247F7BC91657,0x0FF0AA026BA54B82,0xA695A6941A44FA38,0x7FF5F88E2E491F15,0x000000000000005F }
  },
  { /* Point #14 */
    { 0x6994D68D7ACDB128,0xEA6C1BCAF3E42194,0x45B4E1E5C14A3782,0xC1D3FF5CA5089907,0xC7D8B8BAB2ECC0C8,0x5756897B8AF09517,0x54248BC42D37631B,0x4EC2B153748DC34D,0x0000000000000018 },
    { 0x0BE76102BCD4B8F5,0xF59B6D2FAE1FBC73,0x3A82D42614DE6312,0x603FD1BA99D221DE,0x31371C44349ADA8D,0xECB2CFAB22E3EEA0,0x5134413E744A9E46,0x1D91FE459E0DE97E,0x0000000000000042 }
  },
  { /* Point #15 */
    { 0xCA2A69328E4C1BB9,0x5406D95B89A810AD,0x181690A007059605,0xF6B80571DB36C201,0xCDB7CEEFC0DA0FB1,0x0E0F2C08382DD238,0x530C9A2E943FD3D9,0xC14D7C55A5F3E1F4,0x000000000000005F },
    { 0x38C5AFDFCCF6EBC7,0x9F2E2D25F0D0C1B8,0xCB96D5873AF9BF69,0x150F940C89391DAA,0x5D80C9765901C338,0xCA2C7C5F7134A0B6,0x615ABD199A37B224,0x03504959E2B8790A,0x0000000000000067 }
  }
 },
 { /* Table #129 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x1D45C5C8DD04AFCE,0xCE141A50BBD9C392,0x44CA5FA5C9E0FC05,0x4B9496FF60CCFB3C,0xBE260BC6DB5552A6,0xA0EABFDD7D3A7A09,0xE9CC06AE1C77C1F9,0xFA792D042AABEE9E,0x00000000000001DB },
    { 0xF2224E6F72765171,0x3F9EA54811B89E04,0x1E07C6EB138F1A43,0xD9B61817621F1F7E,0x08E851AA2F69AF1A,0x3E75DA6FC0D63F32,0x49A72D31F0F0D74D,0xFCCFC561C516A10C,0x000000000000009F }
  },
  { /* Point #2 */
    { 0x41B3EB86BC1BD2EE,0x71E8430C50368484,0xB214E9CBF2B93AD3,0x13F89335138E0EBF,0xEC96C9C25E690118,0xDE786D182C22CD4C,0x5B1554ABE819E310,0x399BFAB4D01892D1,0x00000000000000C5 },
    { 0x2EFAEE912005A9F2,0x9CB43E2EB39471D0,0x0B0D1B565CEB35C2,0x3BFF194056825120,0xAD49B05739A0DD54,0x35DEC8AF0E83D425,0x50B91634687D1AC8,0x2FB0D9E42F25A98D,0x000000000000007D }
  },
  { /* Point #3 */
    { 0x6DC021EF237051F4,0x5A76D8D37316F0B0,0x48521AA09F26CF74,0xBA0C42B0C106BD9D,0x17BCCC4558C48BE7,0x434AA5B02A7CE241,0xBEF8A59B239AEFA5,0xCD8E682CFC6FD78F,0x00000000000001F0 },
    { 0x54DA0BFBEC41E617,0x1D0EBCF19384DBD3,0x59EAFAB03FDE74FA,0xED3A369E5E7E3E8B,0xC3F1456A2DA9F712,0x62E6394A1C55F4E2,0xC54CF34AD3D53150,0x3849A2B213B480D3,0x00000000000001F9 }
  },
  { /* Point #4 */
    { 0x58333C8C9C13146E,0x213C8896D5D37A5D,0x18E2132D8FD07282,0x606E8133CD7D66C7,0x21C19A128743874B,0xE375D1F56DD96309,0xE0C48D6D3E1D629C,0xED6ADA6CDEE22453,0x000000000000015C },
    { 0xEA1C974547B194A6,0xDD549898850241E9,0x0E225368407CB796,0x17B59EDB427AD8D3,0x08D4629EC43F0A43,0x27F4063D5201D0A4,0xF6E1518FA5003274,0xB6196E3EA3286E2C,0x00000000000001B8 }
  },
  { /* Point #5 */
    { 0x247078383C9D1905,0x5548F7033A2217ED,0xC62BD196501C6819,0xCB2C0893EB4FC9ED,0x1A54E6DB67C77ED0,0xA985B16704675183,0x15EDCE42D572B956,0xF506A80A744F68CE,0x0000000000000191 },
    { 0x8DD93D2BF0E799EF,0x5919D9A95C4B3712,0xCEE768C70604D46A,0x4FDB86AE9E299096,0x5B300487F3C22CE6,0x6C1738B145D1A7F8,0x890F8E55CF13684C,0x634577CBC87097D5,0x0000000000000073 }
  },
  { /* Point #6 */
    { 0xE2F7D8E0C2C3A0EF,0xD5486F1A7E893C1A,0x412EB09864EAA79A,0x2065D3D9FDA0477F,0x03BCE6957FCCCC26,0xF9AF6B2E4A498C46,0xC97B3036D14415AC,0x135E84A3C663AFB1,0x0000000000000094 },
    { 0x43441426D7A1F341,0x22F40FD380DED50A,0xB985816282EE0268,0xE03926A69FD98CC4,0x4B79A6D31D2E85CD,0x6AA9AA8752E4959D,0xA99798EF0419DAA9,0x0475D7215820B4F2,0x0000000000000175 }
  },
  { /* Point #7 */
    { 0x5606F4CA4D4F6808,0x98877BEEA466BD01,0x313D57A2351ECBE2,0xED501E47F5249F37,0x8802E3E2DB5B0E12,0xC6B81A7755588A9C,0x3950C7E1E68E0972,0x9EBB46A2BECA361C,0x0000000000000182 },
    { 0x9EAFD084149CBE81,0x3130D39D908FC649,0xF11BDD641B65FC3E,0x782F4890E249304F,0x052AD0509CC68884,0x4D830021737F47FC,0x97E5B00EC4DDC5A8,0x01D91F255EAD892D,0x00000000000001F3 }
  },
  { /* Point #8 */
    { 0x593CF4108E41277F,0x3AE7DB6E925C9D91,0x68519CA7A37A388E,0xA93A2E815BD94E48,0x2B8CDBAC00EF816F,0x6FC3CAE6EB2796F5,0x253FE0D4F8DEDDE4,0x38405B3095ECC14F,0x0000000000000092 },
    { 0x27A7D0F67882DF12,0x14B3264246332549,0xB8D8C3E6EDA10498,0x6861E53C2AA1CC1A,0xF2BD03E3A37D7254,0x175C04F6D78B5623,0xB3D5202F0B18C14F,0x30B9B0F6967F2B7B,0x000000000000012F }
  },
  { /* Point #9 */
    { 0xEE492EDA438E192D,0x7C90CE48B6FB25B4,0x1D91347592A6F98B,0xE937729F3E303957,0x934AD41E68753BE7,0xC1055AD0388DBFEB,0x1EB07D1237C39B47,0x43D67B30044D46E1,0x00000000000000BE },
    { 0x99BD8D9FC100BBAB,0x83D18CFE0AB5FF5C,0x4A4F2B013C83E1B5,0x794B7080037B574E,0x5E0BEE697EF46528,0x6D1FAE53D231CDE9,0xCCC2E6DC2BDCC506,0x6EB73FAB386C5721,0x00000000000000EF }
  },
  { /* Point #10 */
    { 0x44FB1A0D16EBC9F6,0x6D436828A22D5A45,0x47EFDCBF86B18C9E,0x274E6B70DE3CCDA4,0x968DDD07F43D59DE,0xEA93A7981FEDD37E,0x6D4F4900A8812DCE,0xA55F9A3A604C2650,0x000000000000012C },
    { 0x21B7EC64E633CFD4,0xC1A9267911B0EFAA,0x2788AD11C98BBDF8,0x256F92BF208CD62D,0xAB8F1F7644236613,0xF412A302CCAAE183,0x2230AAA8D74AECC6,0x16C189DDA36B6F3D,0x000000000000003F }
  },
  { /* Point #11 */
    { 0x591991BF0BF28A44,0xA06E49DF791D957D,0xA609D69BF3C2D9BB,0x4F535568A9F2F046,0x811884E47069B621,0x18D0AE6EA7D706F6,0x9385FB8294D498BA,0x70687823DAD6DE10,0x000000000000018C },
    { 0x9357EFC6D67FFD7A,0xBA47F73EE117DC84,0xAC62159EB4F9C177,0x8E0A354E6DCEC707,0xC0DC49BFE86185BC,0x8C0952A3B4E357E3,0x73DA679D5A140719,0xF34D7B164495318D,0x000000000000004D }
  },
  { /* Point #12 */
    { 0x3B770280731E2B92,0xD8C7870C7EE974F8,0xD6FE928343DA91B3,0x563CAD012B7968B3,0x48333AC2D845B648,0xF1753BDBC02AF5D4,0x48CF506F04A647AF,0xAC9F1D5BDDCD3A9A,0x00000000000000FC },
    { 0xF9B4124BCB40D52D,0xC39A85654CB0AB5B,0xEEE9291114C56558,0xD5182186FF5602FB,0x32D3441623F351FF,0xDE81DE053E387E04,0x19B6666948AA0AC1,0x4CD3B987782C2CA2,0x000000000000018C }
  },
  { /* Point #13 */
    { 0x018D01F0A0C123CD,0x7142A556DD9AE750,0x1C29E867BA161BEA,0x18882BA32B0F1D22,0x26FA6AEC03656D3E,0x747B08EA34BB906D,0x8B6DE4AD5EA1E019,0x9200DA5A70538E44,0x00000000000000BF },
    { 0x7621EE5F0D81C672,0x4B3DE5FF481B5EDF,0x4B0D2E193A21F067,0x1AB1F0758B630F4B,0x853D0FF9E0AF48F1,0x1C51EF6F75183AFE,0x5C5852FB55DAF850,0x1667E2EA93C96D64,0x000000000000013B }
  },
  { /* Point #14 */
    { 0x4C5EF880278B149A,0xB82A6AD62B9178A1,0xE06A8E36EC1D25DE,0x2B6F3A5442C24ECA,0xAD51BFE47410D98C,0xB2EBDD8E48CFD981,0xC9FFBA67AC80AA23,0xC40216017BD19096,0x00000000000001BC },
    { 0x79EA0BE9B75F864B,0xDF3EB36555DF1DE6,0x991ED1B7994725A4,0x81433F595E93CC48,0xCD1D317A5B972CF5,0x0A2DD5A632AF71C9,0xABEFB310E8FA80E6,0x9BE8F6E3660C1AC7,0x0000000000000056 }
  },
  { /* Point #15 */
    { 0x14FD09FE0448854C,0xD722E82999AF6FC3,0x3E4323B5954C2490,0x5A59234A9E69AC28,0x1B3B9C1D73518F69,0x4F1DD2AE3A9E7A10,0x3D462EA2B5D10580,0x27E0453C6D5A6C1B,0x00000000000001CC },
    { 0xD179D903A7E19E26,0x71D352D9F00C2DE3,0x57786465682A4A93,0xE4CAA06F50F6966D,0xC5EB495E4B93F32F,0x00033C700E032094,0x016C4CC3ED7A4677,0x298138F4A0F4EA63,0x000000000000010B }
  }
 },
 { /* Table #130 */
  { /* Point #0 */
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 },
    { 0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000,0x0000000000000000 }
  },
  { /* Point #1 */
    { 0x61829972CE8F9A17,0x2D21913CE0FDA47E,0x84CB9DA252466C05,0xFCC4EAAB9FD85710,0xAB1EC5412F56FB90,0xBB435BEC6A231D4A,0xE1FFFEAEE16D3C47,0xA7DB02840F023A36,0x000000000000002D },
    { 0x7259E71938D77A9E,0xCD2278B1A3661199,0xCF7FDF77BF6DFC59,0x6265F9CB96A2B632,0x1365E44A4EB09C8A,0xC1AC30542B23BF87,0x3161A2C05AAEC208,0x1AF3A61455DB8AE9,0x0000000000000098 }
  },
  { /* Point #2 */
    { 0x82E051426B4C3F67,0x830492593FC34315,0x2B17027D972D1C60,0x650BD0DF06941699,0xC960BCA9BF06DEA4,0xC9B131EEF6BF6453,0xC7865C906E2A0BD0,0xFFB964E05D5F6799,0x0000000000000033 },
    { 0x32DB85F6E9FA9189,0x3F0DEB0EB5544031,0x848456BD704E30BD,0xADE1BB0E862032CC,0x8DEAE33AFCF305AD,0x918CEA68C089CD96,0xEA115FB805A4A146,0x978F3A2F3633D8A2,0x0000000000000083 }
  },
  { /* Point #3 */
    { 0x93012BBDB3F18230,0x69B59C81BE563374,0x0FCCC9418FBD8070,0xB2E3E5FDDD353C6D,0x290F2D4065DCE413,0xB79D87416598620E,0x855ECA8C0CFA916C,0x45029EA197EFEBB1,0x0000000000000051 },
    { 0x7C09EEF390438BAE,0x898440C59EC6217D,0x89F1331330D90670,0x1588728726AE644C,0x353E5BFAE83D85F0,0xE8F21860456B1253,0xEB0FEDEACC75E379,0x215AC25219348CEC,0x0000000000000057 }
  },
  { /* Point #4 */
    { 0xFD4ABDB4F6F04DE3,0x2D3399BB2708B32F,0xE3F7A82FAE7EA987,0x63F0093E11C3B0B2,0x4E771CCB50E1DC6C,0xED3655479B91C6A3,0x97C1FD0B332028A9,0xE8199FE24A65ACB3,0x0000000000000137 },
    { 0xFF2F102FED4F5410,0xE2EC543CBED8C3C0,0x7C79A798D4BBFF64,0x5BAA5D12BD61BEBA,0xA4766859ACCB68DD,0x79FE67260F18B724,0xFBAA1890C404245D,0xEBAE71DE1E4BE8EE,0x000000000000016F }
  },
  { /* Point #5 */
    { 0x895A36231BDD31FC,0x3FF4B814A499D99F,0x3B0B3BC1AE8418DA,0x3F6E8A895EAAA723,0xF4F87E1303ADBDF0,0x989FCECD01852F42,0x6DCAF5EDA4426BC1,0x36F55EFEA43A2BBC,0x00000000000000FF },
    { 0xC7180D5818832A17,0x47D76D9329C58F84,0xE54ECA936EB5288A,0x4E7A0AE6621C57B6,0x475C9919CDAD70AF,0x5E0D5C8613D73C3C,0xEE24C9F315DB8108,0x80FF5E2C286DDBDB,0x000000000000002B }
  },
  { /* Point #6 */
    { 0x2E6AD1A9871F197C,0x0AF63210B4A58092,0xCB9252C242A3B0FA,0x06DBC3149D528C5B,0xDC5216150601BB88,0x9DB07C32AA3178B4,0xBB13186BC4212F12,0x18BDFE06EEF4E9B1,0x000000000000011F },
    { 0xF7E64B81713BBFA1,0x26344818B932B514,0x3316DD2AE7CA294A,0x4B266D272F30F1CB,0xA2642AF20DE790F7,0xCB11421279D5ABFE,0x780790487785C36E,0x8B8A691D9DB40AB5,0x00000000000001BB }
  },
  { /* Point #7 */
    { 0x971696469A44620F,0x3523058DFCFA2EA4,0x8C3E30D1167C4C8D,0xF3DE3D61E93A3A6A,0x56E42C97642614F1,0x3C9C8D2480CC3DCE,0x68D62A528CE9A9D8,0x482041D2DF7BE32A,0x0000000000000127 },
    { 0xEB4439EA67C7FD4B,0x350117320A384DB6,0x19F9A3382046F5D4,0x5DBF9FCC72CACC46,0x732CAA319BB26921,0xCD7C2088CA05B118,0x6C815494DBC0CA1B,0x5334AFAB825890F6,0x0000000000000053 }
  },
  { /* Point #8 */
    { 0xDCD089E5C0F8ABEC,0x2D11032081F91EC5,0x244CEF5D8D76055E,0x7202652D1C9BDD43,0x396EBF25643F3CA7,0x811A3695C983AC57,0x7D1F29A41E6E64CA,0x7CB13CEC80827AE1,0x00000000000000C5 },
    { 0x16B59E9C2D5C560B,0x18B069A09DD105E4,0xB7FC826BB6BC0C3F,0xF6AB6C7485EA8193,0x9C768EA01C4CDC7E,0xA7A149B4D223CCA5,0xA54DAFDC8789B618,0x2656CB46B17328C0,0x0000000000000100 }
  },
  { /* Point #9 */
    { 0x7EA34B836DD01BEF,0xC36E2120EFFAB7A5,0x1357672FB8845894,0x7F462C580162AA61,0xB00958815BAE0512,0x55E27B8EF30BE373,0x3B0B6882A1A367BF,0x9177F7351F66D95F,0x00000000000001C0 },
    { 0xEEF0EBA1BFBE7524,0x0CF73ED68025AA0D,0xAE531A884D9267FC,0x29042EA6A78A045D,0xECEBF42ADB2582CF,0x041BABDC566D1BE1,0x55C1D466CFE83774,0x751C932B40E305AB,0x0000000000000162 }
  },
  { /* Point #10 */
    { 0xAD32E836A56A26EB,0xAD1E697D62485F0E,0x4CD629607CAA8694,0xDBAB5D8129E36B0D,0x6588F4FB48B7BD27,0x19C33F2C0923C25F,0x0A630F121DF8F0CF,0xFEEFCE53333C63E9,0x0000000000000045 },
    { 0x241237A74AE15886,0x5D11A892C355D430,0x67CEAB2FBA945FA6,0xDB2B516730EAA436,0x6F9CB6CD2CC960F3,0x3419806B09E68210,0x52059822C4CD6E7F,0xD0BDDA660229C0C9,0x000000000000018D }
  },
  { /* Point #11 */
    { 0x08A92760D317C60C,0x730D73839529B4B8,0xFCF81C9D1A050F05,0x6B2CB8059F9E8BF5,0xD7D7C79E30FF7124,0x572A3A7F7206C662,0xE2052B8C4915D988,0xA685A31E3D6CF04C,0x0000000000000183 },
    { 0x14408F423E71C584,0x8F24D13415998073,0x1EC3AD1995F62F3C,0xF2D8EA1803F06C8D,0x8DDC0FD6087730A5,0x7755ED4B280B7D59,0x26C885DBBA67938C,0x2559753627E81374,0x000000000000013C }
  },
  { /* Point #12 */
    { 0xA779463D63EA6586,0x055AC074F5DD2077,0x5E63875B2BE5D611,0x8261BE993B1C53BB,0x86137B7BA28E14B3,0xF706D3C77E729EF5,0xB30413DB74902555,0xED91B88C4E15D0FE,0x00000000000000ED },
    { 0x0CBBFB03CEE5F36B,0xB210122BB6BAB7F4,0xFFA46C283D0CF2FC,0xA42293E28C05FF89,0x014F499FA5642B7E,0x80DB63809C6E0D8A,0xA819787C51D901C9,0x17662FA8A3201327,0x0000000000000154 }
  },
  { /* Point #13 */
    { 0x525C70348E080AA6,0xFB65650B703A31D0,0xB3C9FC909708778B,0x712BABDD5C0DE950,0x2336B614CF922A9C,0xC9C01FDB2D1541CC,0x3B0B5ACDDA984124,0xC16EDB3E5CA5237E,0x0000000000000031 },
    { 0x16D195DCBA96A3B1,0xAEB795135B2D839E,0xFF7CA75C3F468379,0x195EBF452F7A4ECC,0x368BF1AC2CBA9FC8,0x282778C5AD79DA65,0x1AE709A382204582,0x60DA306180E162FC,0x00000000000000A7 }
  },
  { /* Point #14 */
    { 0xCAB77140311CC347,0xAB8125D2C64BB9EB,0x834317210E447719,0x1B072B94AD7F9BC5,0xDB70C295CCFF1AA9,0x174B731E8969D354,0x70C0A462F5761C43,0x14790895DFF9A408,0x000000000000006E },
    { 0xEFC566D58F909123,0x2775B7A810896CA6,0xFE6927CA0B71973B,0x40BABAC2B4C9929A,0x9610D5214BD6F041,0x82B6D9DA8F075949,0xCB2129E21E7A406C,0x85389F05106AF2AC,0x00000000000000CB }
  },
  { /* Point #15 */
    { 0x28B801584810CE1D,0xA18F01CF9CD2A530,0x3F882662BBACC56B,0x25A09082C8DE9031,0xEE333F92C75A3487,0xC3F231D78C93DC3C,0x6D53379AD94C4907,0x1176368211F2D227,0x00000000000001AC },
    { 0x137AE216AB84DE42,0xBC00A7C1E4EE4C73,0x8A42AEB8FC12B03C,0x9A717FF1CF6A0950,0x18CBEBE30158B96C,0x0184646550953719,0x2C73BD13194FDB1E,0xBD52A1CF3B0D2C34,0x0000000000000022 }
  }
 }
};
