/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.xml;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReportParser {
    public Artifact[] getArtifacts(ModuleId moduleId, String conf, File cache) throws ParseException, IOException {
        File report = new File(cache, XmlReportOutputter.getReportFileName(moduleId, conf));
        if (!report.exists()) {
            throw new IllegalStateException("no report file found for " + moduleId + " " + conf + " in " + cache + ": ivy was looking for " + report);
        }
        return this.getArtifacts(report);
    }

    private Artifact[] getArtifacts(File report) throws ParseException {
        try {
            SaxXmlReportParser parser = new SaxXmlReportParser(report);
            parser.parse();
            return parser.getArtifacts().toArray(new Artifact[parser.getArtifacts().size()]);
        }
        catch (Exception ex) {
            ParseException pe = new ParseException("failed to parse report: " + report + ": " + ex.getMessage(), 0);
            pe.initCause(ex);
            throw pe;
        }
    }

    public ModuleRevisionId[] getDependencyRevisionIds(ModuleId moduleId, String conf, File cache) throws ParseException, IOException {
        File report = new File(cache, XmlReportOutputter.getReportFileName(moduleId, conf));
        if (!report.exists()) {
            throw new IllegalStateException("no report file found for " + moduleId + " " + conf + " in " + cache + ": ivy was looking for " + report);
        }
        return this.getDependencyRevisionIds(report);
    }

    private ModuleRevisionId[] getDependencyRevisionIds(File report) throws ParseException {
        try {
            SaxXmlReportParser parser = new SaxXmlReportParser(report);
            parser.parse();
            return parser.getModuleRevisionIds().toArray(new ModuleRevisionId[parser.getModuleRevisionIds().size()]);
        }
        catch (Exception ex) {
            ParseException pe = new ParseException("failed to parse report: " + report + ": " + ex.getMessage(), 0);
            pe.initCause(ex);
            throw pe;
        }
    }

    public ModuleRevisionId[] getRealDependencyRevisionIds(ModuleId moduleId, String conf, File cache) throws ParseException, IOException {
        File report = new File(cache, XmlReportOutputter.getReportFileName(moduleId, conf));
        if (!report.exists()) {
            throw new IllegalStateException("no report file found for " + moduleId + " " + conf + " in " + cache + ": ivy was looking for " + report);
        }
        return this.getRealDependencyRevisionIds(report);
    }

    private ModuleRevisionId[] getRealDependencyRevisionIds(File report) throws ParseException {
        try {
            SaxXmlReportParser parser = new SaxXmlReportParser(report);
            parser.parse();
            return parser.getRealModuleRevisionIds().toArray(new ModuleRevisionId[parser.getRealModuleRevisionIds().size()]);
        }
        catch (Exception ex) {
            ParseException pe = new ParseException("failed to parse report: " + report + ": " + ex.getMessage(), 0);
            pe.initCause(ex);
            throw pe;
        }
    }

    private static class SaxXmlReportParser {
        private List _mrids;
        private List _defaultMrids;
        private List _realMrids;
        private List _artifacts = new ArrayList();
        private File _report;

        SaxXmlReportParser(File report) {
            this._mrids = new ArrayList();
            this._defaultMrids = new ArrayList();
            this._realMrids = new ArrayList();
            this._report = report;
        }

        public void parse() throws Exception {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(this._report, new DefaultHandler(this){
                private String _organisation;
                private String _module;
                private String _revision;
                private Date _pubdate;
                private boolean _skip;
                private ModuleRevisionId _mrid;
                private boolean _default;
                private final /* synthetic */ SaxXmlReportParser this$0;
                {
                    this.this$0 = this$0;
                }

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("module".equals(qName)) {
                        this._organisation = attributes.getValue("organisation");
                        this._module = attributes.getValue("name");
                    } else if ("revision".equals(qName)) {
                        this._revision = attributes.getValue("name");
                        this._default = Boolean.valueOf(attributes.getValue("default"));
                        if (attributes.getValue("error") != null || attributes.getValue("evicted") != null) {
                            this._skip = true;
                        } else {
                            this._mrid = ModuleRevisionId.newInstance(this._organisation, this._module, this._revision);
                            SaxXmlReportParser.access$000(this.this$0).add(this._mrid);
                            if (this._default) {
                                SaxXmlReportParser.access$100(this.this$0).add(this._mrid);
                            } else {
                                SaxXmlReportParser.access$200(this.this$0).add(this._mrid);
                            }
                            try {
                                this._pubdate = Ivy.DATE_FORMAT.parse(attributes.getValue("pubdate"));
                                this._skip = false;
                            }
                            catch (ParseException e) {
                                throw new IllegalArgumentException("invalid publication date for " + this._organisation + " " + this._module + " " + this._revision + ": " + attributes.getValue("pubdate"));
                            }
                        }
                    } else if ("artifact".equals(qName)) {
                        if (this._skip) {
                            return;
                        }
                        String status = attributes.getValue("status");
                        if (status != null && "failed".equals(status)) {
                            return;
                        }
                        String artifactName = attributes.getValue("name");
                        String type = attributes.getValue("type");
                        String ext = attributes.getValue("ext");
                        DefaultArtifact artifact = new DefaultArtifact(this._mrid, this._pubdate, artifactName, type, ext);
                        SaxXmlReportParser.access$300(this.this$0).add(artifact);
                    }
                }
            });
        }

        public List getArtifacts() {
            return this._artifacts;
        }

        public List getModuleRevisionIds() {
            return this._mrids;
        }

        public List getRealModuleRevisionIds() {
            return this._realMrids;
        }

        static /* synthetic */ List access$000(SaxXmlReportParser x0) {
            return x0._mrids;
        }

        static /* synthetic */ List access$100(SaxXmlReportParser x0) {
            return x0._defaultMrids;
        }

        static /* synthetic */ List access$200(SaxXmlReportParser x0) {
            return x0._realMrids;
        }

        static /* synthetic */ List access$300(SaxXmlReportParser x0) {
            return x0._artifacts;
        }
    }
}

