/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.interpreter;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.localization.Messages;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.api.session.Command;
import org.islandoftex.arara.cli.interpreter.InterpreterUtils$WhenMappings;
import org.islandoftex.arara.cli.ruleset.RuleFormat;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/islandoftex/arara/cli/interpreter/InterpreterUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "construct", "Ljava/nio/file/Path;", "path", "name", "", "format", "Lorg/islandoftex/arara/cli/ruleset/RuleFormat;", "workingDirectory", "construct$cli", "run", "", "command", "Lorg/islandoftex/arara/api/session/Command;", "run$cli", "runPriorEvaluation", "", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "runPriorEvaluation$cli", "cli"})
public final class InterpreterUtils {
    private static final Logger logger;
    @NotNull
    public static final InterpreterUtils INSTANCE;

    public final boolean runPriorEvaluation$cli(@NotNull DirectiveConditional conditional) {
        boolean bl;
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        if (LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode() == ExecutionMode.DRY_RUN) {
            bl = false;
        } else {
            switch (InterpreterUtils$WhenMappings.$EnumSwitchMapping$0[conditional.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int run$cli(@NotNull Command command) throws AraraException {
        void exitCode;
        Intrinsics.checkNotNullParameter(command, "command");
        Pair<Integer, String> pair2 = Environment.executeSystemCommand-SxA4cEA(command, !LinearExecutor.INSTANCE.getExecutionOptions().getVerbose(), LinearExecutor.INSTANCE.getExecutionOptions().getTimeoutValue-UwyO8pc());
        boolean bl = false;
        boolean bl2 = false;
        Pair<Integer, String> it = pair2;
        boolean bl3 = false;
        Object object = it;
        int n = ((Number)((Pair)object).component1()).intValue();
        String output = ((Pair)object).component2();
        if (exitCode == -99) {
            object = LanguageController.getMessages();
            boolean bl4 = false;
            boolean bl5 = false;
            Object $this$run = object;
            boolean bl6 = false;
            String string = StringsKt.substringBefore$default(output, ":", null, 2, null);
            String string2 = Intrinsics.areEqual(string, IOException.class.getName()) ? ((Messages)$this$run).getERROR_RUN_IO_EXCEPTION() : (Intrinsics.areEqual(string, TimeoutException.class.getName()) ? ((Messages)$this$run).getERROR_RUN_TIMEOUT_EXCEPTION() : (Intrinsics.areEqual(string, InterruptedException.class.getName()) ? ((Messages)$this$run).getERROR_RUN_INTERRUPTED_EXCEPTION() : (Intrinsics.areEqual(string, "org.zeroturnaround.exec.InvalidExitValueException") ? ((Messages)$this$run).getERROR_RUN_INVALID_EXIT_VALUE_EXCEPTION() : ((Messages)$this$run).getERROR_RUN_GENERIC_EXCEPTION())));
            Exception exception = new AraraException(output);
            String string3 = string2;
            throw (Throwable)new AraraException(string3, exception);
        }
        logger.info(DisplayUtils.INSTANCE.displayOutputSeparator(LanguageController.getMessages().getLOG_INFO_BEGIN_BUFFER()));
        logger.info(output);
        logger.info(DisplayUtils.INSTANCE.displayOutputSeparator(LanguageController.getMessages().getLOG_INFO_END_BUFFER()));
        return (int)exitCode;
    }

    @NotNull
    public final Path construct$cli(@NotNull Path path2, @NotNull String name, @NotNull RuleFormat format, @NotNull Path workingDirectory) throws AraraException {
        Path path3;
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        String fileName = name + '.' + format.getExtension();
        if (path2.isAbsolute()) {
            Path path4 = path2;
            boolean bl = false;
            Path path5 = path4.resolve(fileName);
            path3 = path5;
            Intrinsics.checkNotNullExpressionValue(path5, "this.resolve(other)");
        } else {
            Path path6 = workingDirectory;
            boolean bl = false;
            Path path7 = path6.resolve(path2);
            Intrinsics.checkNotNullExpressionValue(path7, "this.resolve(other)");
            path6 = path7;
            bl = false;
            Path path8 = path6.resolve(fileName);
            path3 = path8;
            Intrinsics.checkNotNullExpressionValue(path8, "this.resolve(other)");
        }
        return FileHandling.normalize(path3);
    }

    private InterpreterUtils() {
    }

    static {
        InterpreterUtils interpreterUtils;
        INSTANCE = interpreterUtils = new InterpreterUtils();
        logger = LoggerFactory.getLogger(InterpreterUtils.class);
    }
}

