/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/github/ajalt/colormath/XYZ;", "Lcom/github/ajalt/colormath/Color;", "x", "", "y", "z", "a", "", "(DDDF)V", "getA", "()F", "alpha", "getAlpha", "getX", "()D", "getY", "getZ", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toLAB", "Lcom/github/ajalt/colormath/LAB;", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colormath"})
public final class XYZ
implements Color {
    private final double x;
    private final double y;
    private final double z;
    private final float a;

    @Override
    public float getAlpha() {
        return this.a;
    }

    @Override
    @NotNull
    public RGB toRGB() {
        double x = this.x / (double)100;
        double y = this.y / (double)100;
        double z = this.z / (double)100;
        toRGB.1 $fun$adj$1 = toRGB.1.INSTANCE;
        double r = 3.2404542 * x - 1.5371385 * y - 0.4985314 * z;
        double g = -0.969266 * x + 1.8760108 * y + 0.041556 * z;
        double b = 0.0556434 * x - 0.2040259 * y + 1.0572252 * z;
        return new RGB($fun$adj$1.invoke(r), $fun$adj$1.invoke(g), $fun$adj$1.invoke(b), this.getAlpha());
    }

    @Override
    @NotNull
    public LAB toLAB() {
        toLAB.1 $fun$f$1 = toLAB.1.INSTANCE;
        double fx = $fun$f$1.invoke(this.x / 95.047);
        double fy = $fun$f$1.invoke(this.y / 100.0);
        double fz = $fun$f$1.invoke(this.z / 108.883);
        double l = (double)116 * fy - (double)16;
        double a = (double)500 * (fx - fy);
        double b = (double)200 * (fy - fz);
        return new LAB(RangesKt.coerceIn(l, 0.0, 100.0), a, b, this.getAlpha());
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final float getA() {
        return this.a;
    }

    public XYZ(double x, double y, double z, float a) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.a = a;
        boolean bl = this.x >= 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "x must be >= 0 in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.y >= 0.0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "y must be >= 0 in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.z >= 0.0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "z must be >= 0 in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        float f = this.a;
        boolean bl7 = f >= 0.0f && f <= 1.0f;
        bl2 = false;
        bl3 = false;
        if (!bl7) {
            boolean bl8 = false;
            String string = "a must be in range [0, 1] in " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ XYZ(double d, double d2, double d3, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        this(d, d2, d3, f);
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign, @NotNull RenderCondition renderAlpha) {
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        return Color.DefaultImpls.toHex(this, withNumberSign, renderAlpha);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final float component4() {
        return this.a;
    }

    @NotNull
    public final XYZ copy(double x, double y, double z, float a) {
        return new XYZ(x, y, z, a);
    }

    public static /* synthetic */ XYZ copy$default(XYZ xYZ, double d, double d2, double d3, float f, int n, Object object) {
        if ((n & 1) != 0) {
            d = xYZ.x;
        }
        if ((n & 2) != 0) {
            d2 = xYZ.y;
        }
        if ((n & 4) != 0) {
            d3 = xYZ.z;
        }
        if ((n & 8) != 0) {
            f = xYZ.a;
        }
        return xYZ.copy(d, d2, d3, f);
    }

    @NotNull
    public String toString() {
        return "XYZ(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", a=" + this.a + ")";
    }

    public int hashCode() {
        return ((Double.hashCode(this.x) * 31 + Double.hashCode(this.y)) * 31 + Double.hashCode(this.z)) * 31 + Float.hashCode(this.a);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof XYZ)) break block3;
                XYZ xYZ = (XYZ)object;
                if (Double.compare(this.x, xYZ.x) != 0 || Double.compare(this.y, xYZ.y) != 0 || Double.compare(this.z, xYZ.z) != 0 || Float.compare(this.a, xYZ.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

