/*
 *	VERY limited XML read/write implementation
 *	This basically parses tags, attributes and CDATA, and that's
 *	just about it.
 *
 *	Copyright (C) 2009, 2010  Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Olaf Kirch <okir@suse.de>
 *	         Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_XML_H
#define __NETCONTROL_XML_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <stdio.h>

#include <sutils.h>


typedef struct xml_document {
	char *			dtd;
	struct xml_node *	root;
} xml_document_t;

typedef struct xml_node {
	struct xml_node *	next;

	char *			name;
	struct xml_node *	parent;

	/* For now, we assume just a single blob of cdata */
	char *			cdata;

	nc_var_array_t		attrs;
	struct xml_node *	children;
} xml_node_t;

extern xml_document_t *	xml_document_read(const char *);
extern xml_document_t *	xml_document_scan(FILE *);
extern int		xml_document_write(const xml_document_t *, const char *);
extern int		xml_document_print(const xml_document_t *, FILE *fp);
extern const char *	xml_document_dtd(const xml_document_t *);

extern xml_document_t *	xml_document_new();
extern xml_node_t *	xml_document_root(xml_document_t *);
extern void		xml_document_set_root(xml_document_t *, xml_node_t *);
extern xml_node_t *	xml_document_take_root(xml_document_t *);
extern void		xml_document_free(xml_document_t *);

extern xml_node_t *	xml_node_new(const char *ident, xml_node_t *);
extern xml_node_t *	xml_node_new_element(const char *ident, xml_node_t *, const char *cdata);
extern xml_node_t *	xml_node_clone(const xml_node_t *src, xml_node_t *parent);
extern void		xml_node_free(xml_node_t *);
extern int		xml_node_print(const xml_node_t *, FILE *fp);
extern int		xml_node_print_fn(const xml_node_t *, void (*)(const char *, void *), void *);
extern xml_node_t *	xml_node_scan(FILE *fp);
extern void		xml_node_set_cdata(xml_node_t *, const char *);
extern void		xml_node_add_attr(xml_node_t *, const char *, const char *);
extern void		xml_node_add_attr_uint(xml_node_t *, const char *, unsigned int);
extern void		xml_node_add_attr_ulong(xml_node_t *, const char *, unsigned long);
extern void		xml_node_add_attr_double(xml_node_t *, const char *, double);

extern int		xml_node_has_attr(const xml_node_t *, const char *);
extern const char *	xml_node_get_attr(const xml_node_t *, const char *);
extern int		xml_node_get_attr_uint(const xml_node_t *, const char *, unsigned int *);
extern int		xml_node_get_attr_ulong(const xml_node_t *, const char *, unsigned long *);
extern int		xml_node_get_attr_double(const xml_node_t *, const char *, double *);
extern xml_node_t *	xml_node_get_child(const xml_node_t *, const char *);
extern xml_node_t *	xml_node_get_child_with_attrs(const xml_node_t *, const char *,
					const nc_var_array_t *);
extern int		xml_node_replace_child_node(xml_node_t *, xml_node_t *);
extern int		xml_node_append_child_node(xml_node_t *, xml_node_t *);
extern int		xml_node_delete_child_node(xml_node_t *, xml_node_t *);
extern int		xml_node_delete_child(xml_node_t *, const char *);

extern int		xml_node_match_attrs(const xml_node_t *, const nc_var_array_t *);

#endif /* __NETCONTROL_XML_H */
