<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" version="2.0">
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Sep 25, 2010</xd:p>
            <xd:p><xd:b>Author:</xd:b> Michael Kay, Saxonica</xd:p>
            <xd:p>Generates FeatureKeysDoc.xml from FeatureKeys.xml</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xsl:output method="xml"/>
    
    <xsl:template match="features">

        <xsl:comment> GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE&#xa;&#xa;</xsl:comment>
        <table>
            <tr>
                <td><p>Name and URI</p></td>
                <td><p>Description</p></td>
                <td><p>Command line option</p></td>
            </tr>
        <xsl:apply-templates/>
        </table>
    </xsl:template>
    
    <xsl:template match="feature">
        <tr>
            <td valign="top"><p><code java="net.sf.saxon.lib.FeatureKeys#{name}"><xsl:value-of select="name"/></code></p>
                <p><xsl:value-of select="uri"/></p>
            </td>
            <td valign="top">
                <xsl:apply-templates select="desc/node()"/>
            </td>
            <td valign="top">
                <p><xsl:value-of select="commandline"/></p>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="li[not(p)]">
        <li><p><xsl:apply-templates/></p></li>
    </xsl:template>
    
    <xsl:template match="*">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="link">
        <!--<a  class="bodylink" href="../javadoc/{.}"><xsl:value-of select="."/></a>-->
        <code java="{.}"><xsl:value-of select="."/></code>
    </xsl:template>

    
    
</xsl:stylesheet>
