[![Build Status](https://travis-ci.org/awslabs/serverless-application-model.svg?branch=develop)](https://travis-ci.org/awslabs/serverless-application-model)
[![PyPI version](https://badge.fury.io/py/aws-sam-translator.svg)](https://badge.fury.io/py/aws-sam-translator)
[![Codecov Test Coverage](https://codecov.io/gh/awslabs/serverless-application-model/branch/master/graphs/badge.svg?style=flat)](https://codecov.io/gh/awslabs/serverless-application-model)

![Logo](aws_sam_introduction.png)

# AWS Serverless Application Model (AWS SAM)
You can use SAM to define serverless applications in simple and clean syntax.

This GitHub project is the starting point for AWS SAM. It contains the SAM specification, the code that translates SAM templates into AWS CloudFormation stacks, general information about the model, and examples of common applications.

The SAM specification and implementation are open sourced under the Apache 2.0 license. The current version of the SAM specification is available at [AWS SAM 2016-10-31](versions/2016-10-31.md).

Documentation about using AWS SAM to define, test, and deploy serverless applications is available at [AWS Serverless Application Model Developer Guide](https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/what-is-sam.html).

## Contributing new features and enhancements to SAM
You can build serverless applications faster and further simplify your development of serverless applications by defining new event sources, new resource types, and new parameters within SAM. Additionally, you can modify SAM to integrate it with other frameworks and deployment providers from the community for building serverless applications.

[Read the Development Guide](DEVELOPMENT_GUIDE.rst) for in-depth information on how to start making changes.

[Join the SAM developers channel (#samdev) on Slack](https://join.slack.com/t/awsdevelopers/shared_invite/enQtMzg3NTc5OTM2MzcxLTdjYTdhYWE3OTQyYTU4Njk1ZWY4Y2ZjYjBhMTUxNGYzNDg5MWQ1ZTc5MTRlOGY0OTI4NTdlZTMwNmI5YTgwOGM/) to collaborate with fellow community members and the AWS SAM team.
