/* Copyright (C) 2004, 2006  Thorsten Kukuk
   This file is part of the nscd interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

#ifndef __LIBNSCD_H__
#define __LIBNSCD_H__

#ifdef __cplusplus
extern "C"
{
#endif

/* nscd_flush_cache: tell nscd to flush the cache for a specified service.
   service is passwd, group and hosts
   return value:
   -1: writev/readv failed or nscd reports an error, errno is set
    0: everything was ok

   This function is thread safe.
*/
extern int nscd_flush_cache (const char *service);

#ifdef __cplusplus
}
#endif

#endif /* __LIBNSCD_H__ */
