.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtCreate-Selection-Request XtSend-Selection-Request XtCancel-Selection-Request wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtCreateSelectionRequest __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtCreateSelectionRequest, XtSendSelectionRequest, XtCancelSelectionRequest \- bundle multiple selection conversion requests into a single request using MULTIPLE target
.SH SYNTAX
.HP
void XtCreateSelectionRequest(Widget \fIrequestor\fP, Atom \fIselection\fP):
.HP
void XtSendSelectionRequest(Widget \fIrequestor\fP, Atom \fIselection\fP, Time
\fItime\fP);
.HP
void XtCancelSelectionRequest(Widget \fIrequestor\fP, Atom \fIselection\fP);
.SH ARGUMENTS
.IP \fIrequestor\fP 1i
Specifies the widget making the request. Must be of class Core or a
subclass thereof.
.IP \fIselection\fP 1i
Specifies the particular selection desired.
.IP \fItime\fP 1i
Specifies the timestamp to be used in making the request.
.SH DESCRIPTION
When
.ZN XtCreateSelectionRequest
is called, subsequent calls to
.ZN XtGetSelectionValue
and
.ZN XtGetSelectionValueIncremental
with the requestor and selection as specified to
.ZN XtCreateSelectionRequest
will be bundled into a single selection conversion request with
multiple targets. The request is actually initiated by calling
.ZN XtSendSelectionRequest .
.LP
When
.ZN XtSendSelectionRequest
is called with a value of \fIrequestor\fP and \fIselection\fP matching
a previous call to
.ZN XtCreateSelectionRequest ,
a selection conversion request is actually sent to the selection owner.
If a single target request is queued, that request is made. If multiple
targets are queued they are bundled into a single request with the
target MULTIPLE using the specified timestamp. As the conversions are
made, the callbacks associated with each
.ZN XtGetSelectionValue
and
.ZN XtGetSelectionValueIncremental
are invoked in turn.
.LP
Multi-threaded applications should lock the application context before
calling
.ZN XtCreateSelectionRequest
and release the lock after calling
.ZN XtSendSelectionRequest
to ensure that the thread assembling the request is safe from interference
by another thread assembling a different request naming the same widget
and selection.
.LP
When
.ZN XtCancelSelectionRequest
is called, any requests queued since the last call to
.ZN XtCreateSelectionRequest
are cleaned up. Subsequent calls to
.ZN XtGetSelectionValue ,
.ZN XtGetSelectionValues ,
.ZN XtGetSelectionValueIncremental ,
and
.ZN XtGetSelectionValuesIncremental
will not be deferred.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
