/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;

public class TimedTest
extends TestDecorator {
    private final long maxElapsedTime;
    private final boolean waitForCompletion;
    private boolean maxElapsedTimeExceeded;
    private boolean isQuiet;

    public TimedTest(Test test, long maxElapsedTime) {
        this(test, maxElapsedTime, true);
    }

    public TimedTest(Test test, long maxElapsedTime, boolean waitForCompletion) {
        super(test);
        this.maxElapsedTime = maxElapsedTime;
        this.waitForCompletion = waitForCompletion;
        this.maxElapsedTimeExceeded = false;
        this.isQuiet = false;
    }

    public void setQuiet() {
        this.isQuiet = true;
    }

    public int countTestCases() {
        return super.countTestCases();
    }

    public boolean outOfTime() {
        return this.maxElapsedTimeExceeded;
    }

    public void run(TestResult result) {
        if (this.waitForCompletion) {
            this.runUntilTestCompletion(result);
        } else {
            this.runUntilTimeExpires(result);
        }
    }

    protected void runUntilTestCompletion(TestResult result) {
        long beginTime = System.currentTimeMillis();
        super.run(result);
        long elapsedTime = this.getElapsedTime(beginTime);
        this.printElapsedTime(elapsedTime);
        if (elapsedTime > this.maxElapsedTime) {
            this.maxElapsedTimeExceeded = true;
            result.addFailure(this.getTest(), new AssertionFailedError("Maximum elapsed time exceeded! Expected " + this.maxElapsedTime + "ms, but was " + elapsedTime + "ms."));
            result.endTest(this.getTest());
        }
    }

    protected void runUntilTimeExpires(final TestResult result) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                TimedTest.super.run(result);
            }
        });
        long beginTime = System.currentTimeMillis();
        t.start();
        try {
            t.join(this.maxElapsedTime);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        this.printElapsedTime(this.getElapsedTime(beginTime));
        if (t.isAlive()) {
            this.maxElapsedTimeExceeded = true;
            result.addFailure(this.getTest(), new AssertionFailedError("Maximum elapsed time (" + this.maxElapsedTime + " ms) exceeded!"));
            result.endTest(this.getTest());
        }
    }

    protected long getElapsedTime(long beginTime) {
        long endTime = System.currentTimeMillis();
        return endTime - beginTime;
    }

    protected void printElapsedTime(long elapsedTime) {
        if (!this.isQuiet) {
            System.out.println(this.toString() + ": " + elapsedTime + " ms");
            System.out.flush();
        }
    }

    public String toString() {
        if (this.waitForCompletion) {
            return "TimedTest (WAITING): " + super.toString();
        }
        return "TimedTest (NON-WAITING): " + super.toString();
    }
}

