# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdksas.endpoint import endpoint_data

class GetHoneypotEventTrendRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Sas', '2018-12-03', 'GetHoneypotEventTrend','sas')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_SrcIp(self): # String
		return self.get_query_params().get('SrcIp')

	def set_SrcIp(self, SrcIp):  # String
		self.add_query_param('SrcIp', SrcIp)
	def get_RiskLevelList(self): # Array
		return self.get_query_params().get('RiskLevelList')

	def set_RiskLevelList(self, RiskLevelList):  # Array
		for index1, value1 in enumerate(RiskLevelList):
			self.add_query_param('RiskLevelList.' + str(index1 + 1), value1)
	def get_StartTimeStamp(self): # Long
		return self.get_query_params().get('StartTimeStamp')

	def set_StartTimeStamp(self, StartTimeStamp):  # Long
		self.add_query_param('StartTimeStamp', StartTimeStamp)
	def get_EndTimeStamp(self): # Long
		return self.get_query_params().get('EndTimeStamp')

	def set_EndTimeStamp(self, EndTimeStamp):  # Long
		self.add_query_param('EndTimeStamp', EndTimeStamp)
	def get_Lang(self): # String
		return self.get_query_params().get('Lang')

	def set_Lang(self, Lang):  # String
		self.add_query_param('Lang', Lang)
