/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.latex.Label;
import com.dickimawbooks.texparserlib.latex.MathDeclaration;
import java.io.IOException;

public class L2HMathDeclaration
extends MathDeclaration {
    public L2HMathDeclaration() {
    }

    public L2HMathDeclaration(String string) {
        super(string);
    }

    public L2HMathDeclaration(String string, int n) {
        super(string, n);
    }

    public L2HMathDeclaration(String string, int n, boolean bl) {
        super(string, n, bl);
    }

    @Override
    public Object clone() {
        return new L2HMathDeclaration(this.getName(), this.getMode(), this.isNumbered());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        super.process(teXParser, teXObjectList);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (this.getMode() == 2) {
            l2HConverter.write("<div class=\"displaymath\">");
        }
        if (l2HConverter.useMathJax()) {
            if (this.isNumbered()) {
                TeXObjectList teXObjectList2 = new TeXObjectList();
                while (teXObjectList.size() > 0) {
                    TeXObject teXObject;
                    TeXObject teXObject2 = teXObjectList.popStack(teXParser);
                    if (teXObject2 instanceof TeXCsRef) {
                        teXObject2 = l2HConverter.getControlSequence(((TeXCsRef)teXObject2).getName());
                    }
                    if (teXObject2 instanceof Label) {
                        teXObject2.process(teXParser, teXObjectList);
                        break;
                    }
                    if (teXObject2 instanceof Expandable && (teXObject = ((Expandable)((Object)teXObject2)).expandonce(teXParser, teXObjectList)) != null) {
                        teXObject2 = teXObject;
                    }
                    if (teXObject2 instanceof TeXObjectList && !(teXObject2 instanceof Group)) {
                        teXObjectList.addAll(0, (TeXObjectList)teXObject2);
                        teXObject2 = teXObjectList.popStack(teXParser);
                    }
                    if (teXObject2 instanceof TeXCsRef) {
                        teXObject2 = l2HConverter.getControlSequence(((TeXCsRef)teXObject2).getName());
                    }
                    if (teXObject2 instanceof End) {
                        teXObject = teXObjectList.peekStack();
                        if (teXObject instanceof Group) {
                            teXObject = ((Group)teXObject).toList();
                        }
                        if (this.getName().equals(teXObject.toString(teXParser))) {
                            teXObjectList2.add(teXObject2);
                            break;
                        }
                    } else if (teXObject2 instanceof EndDeclaration) {
                        if (((EndDeclaration)teXObject2).getDeclarationName().equals(this.getName())) {
                            teXObjectList2.add(teXObject2);
                            break;
                        }
                    } else if (teXObject2 instanceof Label) {
                        teXObject2.process(teXParser, teXObjectList);
                        break;
                    }
                    teXObjectList2.add(teXObject2);
                }
                teXObjectList.addAll(0, teXObjectList2);
            }
            if (this.getMode() == 2) {
                l2HConverter.write(l2HConverter.mathJaxStartDisplay());
            } else {
                l2HConverter.write(l2HConverter.mathJaxStartInline());
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (this.getMode() == 2) {
            l2HConverter.write("<div class=\"displaymath\">");
        }
        if (l2HConverter.useMathJax()) {
            if (this.isNumbered()) {
                TeXObjectList teXObjectList = new TeXObjectList();
                while (true) {
                    TeXObject teXObject;
                    TeXObject teXObject2;
                    if ((teXObject2 = teXParser.popStack()) instanceof TeXCsRef) {
                        teXObject2 = l2HConverter.getControlSequence(((TeXCsRef)teXObject2).getName());
                    }
                    if (teXObject2 instanceof Label) {
                        teXObject2.process(teXParser);
                        break;
                    }
                    if (teXObject2 instanceof Expandable && (teXObject = ((Expandable)((Object)teXObject2)).expandonce(teXParser)) != null) {
                        teXObject2 = teXObject;
                    }
                    if (teXObject2 instanceof TeXObjectList && !(teXObject2 instanceof Group)) {
                        teXParser.addAll(0, (TeXObjectList)teXObject2);
                        teXObject2 = teXParser.popStack();
                    }
                    if (teXObject2 instanceof TeXCsRef) {
                        teXObject2 = l2HConverter.getControlSequence(((TeXCsRef)teXObject2).getName());
                    }
                    if (teXObject2 instanceof End) {
                        teXObject = teXParser.peekStack();
                        if (teXObject instanceof Group) {
                            teXObject = ((Group)teXObject).toList();
                        }
                        if (this.getName().equals(teXObject.toString(teXParser))) {
                            teXObjectList.add(teXObject2);
                            break;
                        }
                    } else if (teXObject2 instanceof EndDeclaration) {
                        if (((EndDeclaration)teXObject2).getDeclarationName().equals(this.getName())) {
                            teXObjectList.add(teXObject2);
                            break;
                        }
                    } else if (teXObject2 instanceof Label) {
                        teXObject2.process(teXParser);
                        break;
                    }
                    teXObjectList.add(teXObject2);
                }
                teXParser.addAll(0, teXObjectList);
                l2HConverter.write("<span class=\"eqno\">(");
                l2HConverter.getControlSequence("theequation").process(teXParser);
                l2HConverter.write(")</span>");
            }
            if (this.getMode() == 2) {
                l2HConverter.write(l2HConverter.mathJaxStartDisplay());
            } else {
                l2HConverter.write(l2HConverter.mathJaxStartInline());
            }
        }
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        super.end(teXParser);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (l2HConverter.useMathJax()) {
            if (this.getMode() == 2) {
                l2HConverter.write(l2HConverter.mathJaxEndDisplay());
            } else {
                l2HConverter.write(l2HConverter.mathJaxEndInline());
            }
        }
        if (this.getMode() == 2) {
            l2HConverter.write("</div>");
        }
    }
}

