/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.auxfile;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.AuxParser;
import java.io.IOException;

public class AuxCommand
extends ControlSequence {
    private int numArgs;

    public AuxCommand(String string, int n) {
        super(string);
        this.numArgs = n;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    @Override
    public AuxCommand clone() {
        return new AuxCommand(this.getName(), this.getNumArgs());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        AuxParser auxParser = (AuxParser)teXParser.getListener();
        TeXObject[] teXObjectArray = new TeXObject[this.numArgs];
        for (int i = 0; i < this.numArgs; ++i) {
            teXObjectArray[i] = teXObjectList.popArg(teXParser);
            if (teXObjectArray[i] != null) continue;
            throw new NullPointerException(String.format("null arg %d for %s", i, this.getName()));
        }
        auxParser.addAuxData(new AuxData(this.getName(), teXObjectArray));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        AuxParser auxParser = (AuxParser)teXParser.getListener();
        TeXObject[] teXObjectArray = new TeXObject[this.numArgs];
        for (int i = 0; i < this.numArgs; ++i) {
            teXObjectArray[i] = teXParser.popNextArg();
            if (teXObjectArray[i] != null) continue;
            throw new NullPointerException(String.format("null arg %d for %s", i, this.getName()));
        }
        auxParser.addAuxData(new AuxData(this.getName(), teXObjectArray));
    }
}

