// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListKeysOutput {
    /// <p>A list of KMS keys.</p>
    pub keys: ::std::option::Option<::std::vec::Vec<crate::types::KeyListEntry>>,
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub next_marker: ::std::option::Option<::std::string::String>,
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub truncated: bool,
    _request_id: Option<String>,
}
impl ListKeysOutput {
    /// <p>A list of KMS keys.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.keys.is_none()`.
    pub fn keys(&self) -> &[crate::types::KeyListEntry] {
        self.keys.as_deref().unwrap_or_default()
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(&self) -> ::std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn truncated(&self) -> bool {
        self.truncated
    }
}
impl ::aws_types::request_id::RequestId for ListKeysOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl ListKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListKeysOutput`](crate::operation::list_keys::ListKeysOutput).
    pub fn builder() -> crate::operation::list_keys::builders::ListKeysOutputBuilder {
        crate::operation::list_keys::builders::ListKeysOutputBuilder::default()
    }
}

/// A builder for [`ListKeysOutput`](crate::operation::list_keys::ListKeysOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ListKeysOutputBuilder {
    pub(crate) keys: ::std::option::Option<::std::vec::Vec<crate::types::KeyListEntry>>,
    pub(crate) next_marker: ::std::option::Option<::std::string::String>,
    pub(crate) truncated: ::std::option::Option<bool>,
    _request_id: Option<String>,
}
impl ListKeysOutputBuilder {
    /// Appends an item to `keys`.
    ///
    /// To override the contents of this collection use [`set_keys`](Self::set_keys).
    ///
    /// <p>A list of KMS keys.</p>
    pub fn keys(mut self, input: crate::types::KeyListEntry) -> Self {
        let mut v = self.keys.unwrap_or_default();
        v.push(input);
        self.keys = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of KMS keys.</p>
    pub fn set_keys(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::KeyListEntry>>) -> Self {
        self.keys = input;
        self
    }
    /// <p>A list of KMS keys.</p>
    pub fn get_keys(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::KeyListEntry>> {
        &self.keys
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn next_marker(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_marker = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn set_next_marker(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_marker = input;
        self
    }
    /// <p>When <code>Truncated</code> is true, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn get_next_marker(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_marker
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn truncated(mut self, input: bool) -> Self {
        self.truncated = ::std::option::Option::Some(input);
        self
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn set_truncated(mut self, input: ::std::option::Option<bool>) -> Self {
        self.truncated = input;
        self
    }
    /// <p>A flag that indicates whether there are more items in the list. When this value is true, the list in this response is truncated. To get more items, pass the value of the <code>NextMarker</code> element in thisresponse to the <code>Marker</code> parameter in a subsequent request.</p>
    pub fn get_truncated(&self) -> &::std::option::Option<bool> {
        &self.truncated
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`ListKeysOutput`](crate::operation::list_keys::ListKeysOutput).
    pub fn build(self) -> crate::operation::list_keys::ListKeysOutput {
        crate::operation::list_keys::ListKeysOutput {
            keys: self.keys,
            next_marker: self.next_marker,
            truncated: self.truncated.unwrap_or_default(),
            _request_id: self._request_id,
        }
    }
}
