# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._long_term_retention_managed_instance_backups_operations import build_delete_by_resource_group_request_initial, build_delete_request_initial, build_get_by_resource_group_request, build_get_request, build_list_by_database_request, build_list_by_instance_request, build_list_by_location_request, build_list_by_resource_group_database_request, build_list_by_resource_group_instance_request, build_list_by_resource_group_location_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class LongTermRetentionManagedInstanceBackupsOperations:
    """LongTermRetentionManagedInstanceBackupsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.sql.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def get(
        self,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> "_models.ManagedInstanceLongTermRetentionBackup":
        """Gets a long term retention backup for a managed database.

        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param database_name: The name of the managed database.
        :type database_name: str
        :param backup_name: The backup name.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagedInstanceLongTermRetentionBackup, or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_request(
            location_name=location_name,
            managed_instance_name=managed_instance_name,
            database_name=database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ManagedInstanceLongTermRetentionBackup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}'}  # type: ignore


    async def _delete_initial(
        self,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_request_initial(
            location_name=location_name,
            managed_instance_name=managed_instance_name,
            database_name=database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            template_url=self._delete_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_initial.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}'}  # type: ignore


    @distributed_trace_async
    async def begin_delete(
        self,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a long term retention backup.

        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param database_name: The name of the managed database.
        :type database_name: str
        :param backup_name: The backup name.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_initial(
                location_name=location_name,
                managed_instance_name=managed_instance_name,
                database_name=database_name,
                backup_name=backup_name,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}'}  # type: ignore

    @distributed_trace
    def list_by_database(
        self,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, "_models.DatabaseState"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ManagedInstanceLongTermRetentionBackupListResult"]:
        """Lists all long term retention backups for a managed database.

        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param database_name: The name of the managed database.
        :type database_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagedInstanceLongTermRetentionBackupListResult
         or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_database_request(
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    database_name=database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=self.list_by_database.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_database_request(
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    database_name=database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagedInstanceLongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_database.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups'}  # type: ignore

    @distributed_trace
    def list_by_instance(
        self,
        location_name: str,
        managed_instance_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, "_models.DatabaseState"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ManagedInstanceLongTermRetentionBackupListResult"]:
        """Lists the long term retention backups for a given managed instance.

        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagedInstanceLongTermRetentionBackupListResult
         or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_instance_request(
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=self.list_by_instance.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_instance_request(
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagedInstanceLongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_instance.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionManagedInstanceBackups'}  # type: ignore

    @distributed_trace
    def list_by_location(
        self,
        location_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, "_models.DatabaseState"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ManagedInstanceLongTermRetentionBackupListResult"]:
        """Lists the long term retention backups for managed databases in a given location.

        :param location_name: The location of the database.
        :type location_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagedInstanceLongTermRetentionBackupListResult
         or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_location_request(
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=self.list_by_location.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_location_request(
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagedInstanceLongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_location.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstanceBackups'}  # type: ignore

    @distributed_trace_async
    async def get_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> "_models.ManagedInstanceLongTermRetentionBackup":
        """Gets a long term retention backup for a managed database.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal.
        :type resource_group_name: str
        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param database_name: The name of the managed database.
        :type database_name: str
        :param backup_name: The backup name.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagedInstanceLongTermRetentionBackup, or the result of cls(response)
        :rtype: ~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_by_resource_group_request(
            resource_group_name=resource_group_name,
            location_name=location_name,
            managed_instance_name=managed_instance_name,
            database_name=database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            template_url=self.get_by_resource_group.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ManagedInstanceLongTermRetentionBackup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}'}  # type: ignore


    async def _delete_by_resource_group_initial(
        self,
        resource_group_name: str,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_by_resource_group_request_initial(
            resource_group_name=resource_group_name,
            location_name=location_name,
            managed_instance_name=managed_instance_name,
            database_name=database_name,
            backup_name=backup_name,
            subscription_id=self._config.subscription_id,
            template_url=self._delete_by_resource_group_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_by_resource_group_initial.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}'}  # type: ignore


    @distributed_trace_async
    async def begin_delete_by_resource_group(
        self,
        resource_group_name: str,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        backup_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a long term retention backup.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal.
        :type resource_group_name: str
        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param database_name: The name of the managed database.
        :type database_name: str
        :param backup_name: The backup name.
        :type backup_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_by_resource_group_initial(
                resource_group_name=resource_group_name,
                location_name=location_name,
                managed_instance_name=managed_instance_name,
                database_name=database_name,
                backup_name=backup_name,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete_by_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups/{backupName}'}  # type: ignore

    @distributed_trace
    def list_by_resource_group_database(
        self,
        resource_group_name: str,
        location_name: str,
        managed_instance_name: str,
        database_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, "_models.DatabaseState"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ManagedInstanceLongTermRetentionBackupListResult"]:
        """Lists all long term retention backups for a managed database.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal.
        :type resource_group_name: str
        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param database_name: The name of the managed database.
        :type database_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagedInstanceLongTermRetentionBackupListResult
         or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_resource_group_database_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    database_name=database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=self.list_by_resource_group_database.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_resource_group_database_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    database_name=database_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagedInstanceLongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_resource_group_database.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionDatabases/{databaseName}/longTermRetentionManagedInstanceBackups'}  # type: ignore

    @distributed_trace
    def list_by_resource_group_instance(
        self,
        resource_group_name: str,
        location_name: str,
        managed_instance_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, "_models.DatabaseState"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ManagedInstanceLongTermRetentionBackupListResult"]:
        """Lists the long term retention backups for a given managed instance.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal.
        :type resource_group_name: str
        :param location_name: The location of the database.
        :type location_name: str
        :param managed_instance_name: The name of the managed instance.
        :type managed_instance_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagedInstanceLongTermRetentionBackupListResult
         or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_resource_group_instance_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=self.list_by_resource_group_instance.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_resource_group_instance_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    managed_instance_name=managed_instance_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagedInstanceLongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_resource_group_instance.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstances/{managedInstanceName}/longTermRetentionManagedInstanceBackups'}  # type: ignore

    @distributed_trace
    def list_by_resource_group_location(
        self,
        resource_group_name: str,
        location_name: str,
        only_latest_per_database: Optional[bool] = None,
        database_state: Optional[Union[str, "_models.DatabaseState"]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ManagedInstanceLongTermRetentionBackupListResult"]:
        """Lists the long term retention backups for managed databases in a given location.

        :param resource_group_name: The name of the resource group that contains the resource. You can
         obtain this value from the Azure Resource Manager API or the portal.
        :type resource_group_name: str
        :param location_name: The location of the database.
        :type location_name: str
        :param only_latest_per_database: Whether or not to only get the latest backup for each
         database.
        :type only_latest_per_database: bool
        :param database_state: Whether to query against just live databases, just deleted databases, or
         all databases.
        :type database_state: str or ~azure.mgmt.sql.models.DatabaseState
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagedInstanceLongTermRetentionBackupListResult
         or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManagedInstanceLongTermRetentionBackupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_by_resource_group_location_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=self.list_by_resource_group_location.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_by_resource_group_location_request(
                    resource_group_name=resource_group_name,
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    only_latest_per_database=only_latest_per_database,
                    database_state=database_state,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagedInstanceLongTermRetentionBackupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_resource_group_location.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionManagedInstanceBackups'}  # type: ignore
