# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AddonProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the addon provisioning
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class AddonType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of private cloud addon
    """

    SRM = "SRM"
    VR = "VR"
    HCX = "HCX"

class AffinityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Placement policy affinity type
    """

    AFFINITY = "Affinity"
    ANTI_AFFINITY = "AntiAffinity"

class AvailabilityStrategy(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The availability strategy for the private cloud
    """

    SINGLE_ZONE = "SingleZone"
    DUAL_ZONE = "DualZone"

class CloudLinkStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the cloud link.
    """

    ACTIVE = "Active"
    BUILDING = "Building"
    DELETING = "Deleting"
    FAILED = "Failed"
    DISCONNECTED = "Disconnected"

class ClusterProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the cluster provisioning
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    DELETING = "Deleting"
    UPDATING = "Updating"

class DatastoreProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the datastore provisioning
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    PENDING = "Pending"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"

class DatastoreStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The operational status of the datastore
    """

    UNKNOWN = "Unknown"
    ACCESSIBLE = "Accessible"
    INACCESSIBLE = "Inaccessible"
    ATTACHED = "Attached"
    DETACHED = "Detached"
    LOST_COMMUNICATION = "LostCommunication"
    DEAD_OR_ERROR = "DeadOrError"

class DhcpTypeEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of DHCP: SERVER or RELAY.
    """

    SERVER = "SERVER"
    RELAY = "RELAY"

class DnsServiceLogLevelEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """DNS Service log level.
    """

    DEBUG = "DEBUG"
    INFO = "INFO"
    WARNING = "WARNING"
    ERROR = "ERROR"
    FATAL = "FATAL"

class DnsServiceStatusEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """DNS Service status.
    """

    SUCCESS = "SUCCESS"
    FAILURE = "FAILURE"

class EncryptionKeyStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of key provided
    """

    CONNECTED = "Connected"
    ACCESS_DENIED = "AccessDenied"

class EncryptionState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of customer managed encryption key
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EncryptionVersionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Property of the key if user provided or auto detected
    """

    FIXED = "Fixed"
    AUTO_DETECTED = "AutoDetected"

class ExpressRouteAuthorizationProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the  ExpressRoute Circuit Authorization provisioning
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"

class GlobalReachConnectionProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the  ExpressRoute Circuit Authorization provisioning
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"

class GlobalReachConnectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The connection status of the global reach connection
    """

    CONNECTED = "Connected"
    CONNECTING = "Connecting"
    DISCONNECTED = "Disconnected"

class HcxEnterpriseSiteStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the HCX Enterprise Site
    """

    AVAILABLE = "Available"
    CONSUMED = "Consumed"
    DEACTIVATED = "Deactivated"
    DELETED = "Deleted"

class InternetEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Connectivity to internet is enabled or disabled
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class MountOptionEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
    """

    MOUNT = "MOUNT"
    ATTACH = "ATTACH"

class OptionalParamEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Is this parameter required or optional
    """

    OPTIONAL = "Optional"
    REQUIRED = "Required"

class PlacementPolicyProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class PlacementPolicyState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether the placement policy is enabled or disabled
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class PlacementPolicyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """placement policy type
    """

    VM_VM = "VmVm"
    VM_HOST = "VmHost"

class PortMirroringDirectionEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Direction of port mirroring profile.
    """

    INGRESS = "INGRESS"
    EGRESS = "EGRESS"
    BIDIRECTIONAL = "BIDIRECTIONAL"

class PortMirroringStatusEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Port Mirroring Status.
    """

    SUCCESS = "SUCCESS"
    FAILURE = "FAILURE"

class PrivateCloudProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    PENDING = "Pending"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class QuotaEnabled(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Host quota is active for current subscription
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ResourceIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity used for the private cloud. The type 'SystemAssigned' refers to an
    implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    NONE = "None"

class ScriptExecutionParameterType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of execution parameter
    """

    VALUE = "Value"
    SECURE_VALUE = "SecureValue"
    CREDENTIAL = "Credential"

class ScriptExecutionProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the script execution resource
    """

    PENDING = "Pending"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLING = "Cancelling"
    CANCELLED = "Cancelled"
    DELETING = "Deleting"

class ScriptOutputStreamType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    INFORMATION = "Information"
    WARNING = "Warning"
    OUTPUT = "Output"
    ERROR = "Error"

class ScriptParameterTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of parameter the script is expecting. psCredential is a PSCredentialObject
    """

    STRING = "String"
    SECURE_STRING = "SecureString"
    CREDENTIAL = "Credential"
    INT = "Int"
    BOOL = "Bool"
    FLOAT = "Float"

class SegmentStatusEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Segment status.
    """

    SUCCESS = "SUCCESS"
    FAILURE = "FAILURE"

class SslEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protect LDAP communication using SSL certificate (LDAPS)
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class TrialStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Trial status
    """

    TRIAL_AVAILABLE = "TrialAvailable"
    TRIAL_USED = "TrialUsed"
    TRIAL_DISABLED = "TrialDisabled"

class VirtualMachineRestrictMovementState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether VM DRS-driven movement is restricted (enabled) or not (disabled)
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class VisibilityParameterEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Should this parameter be visible to arm and passed in the parameters argument when executing
    """

    VISIBLE = "Visible"
    HIDDEN = "Hidden"

class VMGroupStatusEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """VM Group status.
    """

    SUCCESS = "SUCCESS"
    FAILURE = "FAILURE"

class VMTypeEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Virtual machine type.
    """

    REGULAR = "REGULAR"
    EDGE = "EDGE"
    SERVICE = "SERVICE"

class WorkloadNetworkDhcpProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class WorkloadNetworkDnsServiceProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class WorkloadNetworkDnsZoneProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class WorkloadNetworkPortMirroringProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class WorkloadNetworkPublicIPProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class WorkloadNetworkSegmentProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"

class WorkloadNetworkVMGroupProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    BUILDING = "Building"
    DELETING = "Deleting"
    UPDATING = "Updating"
