// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssmmdsiface provides an interface to enable mocking the Amazon Simple Systems Management Message Delivery Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssmmdsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ssmmds"
)

// SSMMDSAPI provides an interface to enable mocking the
// ssmmds.SSMMDS service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Simple Systems Management Message Delivery Service.
//    func myFunc(svc ssmmdsiface.SSMMDSAPI) bool {
//        // Make svc.AcknowledgeMessage request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := ssmmds.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockSSMMDSClient struct {
//        ssmmdsiface.SSMMDSAPI
//    }
//    func (m *mockSSMMDSClient) AcknowledgeMessage(input *ssmmds.AcknowledgeMessageInput) (*ssmmds.AcknowledgeMessageOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockSSMMDSClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SSMMDSAPI interface {
	AcknowledgeMessage(*ssmmds.AcknowledgeMessageInput) (*ssmmds.AcknowledgeMessageOutput, error)
	AcknowledgeMessageWithContext(aws.Context, *ssmmds.AcknowledgeMessageInput, ...request.Option) (*ssmmds.AcknowledgeMessageOutput, error)
	AcknowledgeMessageRequest(*ssmmds.AcknowledgeMessageInput) (*request.Request, *ssmmds.AcknowledgeMessageOutput)

	DeleteMessage(*ssmmds.DeleteMessageInput) (*ssmmds.DeleteMessageOutput, error)
	DeleteMessageWithContext(aws.Context, *ssmmds.DeleteMessageInput, ...request.Option) (*ssmmds.DeleteMessageOutput, error)
	DeleteMessageRequest(*ssmmds.DeleteMessageInput) (*request.Request, *ssmmds.DeleteMessageOutput)

	FailMessage(*ssmmds.FailMessageInput) (*ssmmds.FailMessageOutput, error)
	FailMessageWithContext(aws.Context, *ssmmds.FailMessageInput, ...request.Option) (*ssmmds.FailMessageOutput, error)
	FailMessageRequest(*ssmmds.FailMessageInput) (*request.Request, *ssmmds.FailMessageOutput)

	GetEndpoint(*ssmmds.GetEndpointInput) (*ssmmds.GetEndpointOutput, error)
	GetEndpointWithContext(aws.Context, *ssmmds.GetEndpointInput, ...request.Option) (*ssmmds.GetEndpointOutput, error)
	GetEndpointRequest(*ssmmds.GetEndpointInput) (*request.Request, *ssmmds.GetEndpointOutput)

	GetMessages(*ssmmds.GetMessagesInput) (*ssmmds.GetMessagesOutput, error)
	GetMessagesWithContext(aws.Context, *ssmmds.GetMessagesInput, ...request.Option) (*ssmmds.GetMessagesOutput, error)
	GetMessagesRequest(*ssmmds.GetMessagesInput) (*request.Request, *ssmmds.GetMessagesOutput)

	SendReply(*ssmmds.SendReplyInput) (*ssmmds.SendReplyOutput, error)
	SendReplyWithContext(aws.Context, *ssmmds.SendReplyInput, ...request.Option) (*ssmmds.SendReplyOutput, error)
	SendReplyRequest(*ssmmds.SendReplyInput) (*request.Request, *ssmmds.SendReplyOutput)
}

var _ SSMMDSAPI = (*ssmmds.SSMMDS)(nil)
