// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssmmds

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcknowledgeMessage = "AcknowledgeMessage"

// AcknowledgeMessageRequest generates a "aws/request.Request" representing the
// client's request for the AcknowledgeMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcknowledgeMessage for more information on using the AcknowledgeMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcknowledgeMessageRequest method.
//    req, resp := client.AcknowledgeMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/AcknowledgeMessage
func (c *SSMMDS) AcknowledgeMessageRequest(input *AcknowledgeMessageInput) (req *request.Request, output *AcknowledgeMessageOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeMessageInput{}
	}

	output = &AcknowledgeMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcknowledgeMessage API operation for Amazon Simple Systems Management Message Delivery Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Message Delivery Service's
// API operation AcknowledgeMessage for usage and error information.
//
// Returned Error Types:
//   * InvalidMessageIdException
//
//   * UnsupportedMessageOperationException
//
//   * AuthorizationFailureException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/AcknowledgeMessage
func (c *SSMMDS) AcknowledgeMessage(input *AcknowledgeMessageInput) (*AcknowledgeMessageOutput, error) {
	req, out := c.AcknowledgeMessageRequest(input)
	return out, req.Send()
}

// AcknowledgeMessageWithContext is the same as AcknowledgeMessage with the addition of
// the ability to pass a context and additional request options.
//
// See AcknowledgeMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMMDS) AcknowledgeMessageWithContext(ctx aws.Context, input *AcknowledgeMessageInput, opts ...request.Option) (*AcknowledgeMessageOutput, error) {
	req, out := c.AcknowledgeMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMessage = "DeleteMessage"

// DeleteMessageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMessage for more information on using the DeleteMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMessageRequest method.
//    req, resp := client.DeleteMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/DeleteMessage
func (c *SSMMDS) DeleteMessageRequest(input *DeleteMessageInput) (req *request.Request, output *DeleteMessageOutput) {
	op := &request.Operation{
		Name:       opDeleteMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMessageInput{}
	}

	output = &DeleteMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMessage API operation for Amazon Simple Systems Management Message Delivery Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Message Delivery Service's
// API operation DeleteMessage for usage and error information.
//
// Returned Error Types:
//   * InvalidMessageIdException
//
//   * UnsupportedMessageOperationException
//
//   * AuthorizationFailureException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/DeleteMessage
func (c *SSMMDS) DeleteMessage(input *DeleteMessageInput) (*DeleteMessageOutput, error) {
	req, out := c.DeleteMessageRequest(input)
	return out, req.Send()
}

// DeleteMessageWithContext is the same as DeleteMessage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMMDS) DeleteMessageWithContext(ctx aws.Context, input *DeleteMessageInput, opts ...request.Option) (*DeleteMessageOutput, error) {
	req, out := c.DeleteMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFailMessage = "FailMessage"

// FailMessageRequest generates a "aws/request.Request" representing the
// client's request for the FailMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FailMessage for more information on using the FailMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FailMessageRequest method.
//    req, resp := client.FailMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/FailMessage
func (c *SSMMDS) FailMessageRequest(input *FailMessageInput) (req *request.Request, output *FailMessageOutput) {
	op := &request.Operation{
		Name:       opFailMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailMessageInput{}
	}

	output = &FailMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// FailMessage API operation for Amazon Simple Systems Management Message Delivery Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Message Delivery Service's
// API operation FailMessage for usage and error information.
//
// Returned Error Types:
//   * InvalidMessageIdException
//
//   * UnsupportedMessageOperationException
//
//   * AuthorizationFailureException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/FailMessage
func (c *SSMMDS) FailMessage(input *FailMessageInput) (*FailMessageOutput, error) {
	req, out := c.FailMessageRequest(input)
	return out, req.Send()
}

// FailMessageWithContext is the same as FailMessage with the addition of
// the ability to pass a context and additional request options.
//
// See FailMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMMDS) FailMessageWithContext(ctx aws.Context, input *FailMessageInput, opts ...request.Option) (*FailMessageOutput, error) {
	req, out := c.FailMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEndpoint = "GetEndpoint"

// GetEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEndpoint for more information on using the GetEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEndpointRequest method.
//    req, resp := client.GetEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/GetEndpoint
func (c *SSMMDS) GetEndpointRequest(input *GetEndpointInput) (req *request.Request, output *GetEndpointOutput) {
	op := &request.Operation{
		Name:       opGetEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEndpointInput{}
	}

	output = &GetEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEndpoint API operation for Amazon Simple Systems Management Message Delivery Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Message Delivery Service's
// API operation GetEndpoint for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//
//   * AuthorizationFailureException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/GetEndpoint
func (c *SSMMDS) GetEndpoint(input *GetEndpointInput) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	return out, req.Send()
}

// GetEndpointWithContext is the same as GetEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMMDS) GetEndpointWithContext(ctx aws.Context, input *GetEndpointInput, opts ...request.Option) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMessages = "GetMessages"

// GetMessagesRequest generates a "aws/request.Request" representing the
// client's request for the GetMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMessages for more information on using the GetMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMessagesRequest method.
//    req, resp := client.GetMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/GetMessages
func (c *SSMMDS) GetMessagesRequest(input *GetMessagesInput) (req *request.Request, output *GetMessagesOutput) {
	op := &request.Operation{
		Name:       opGetMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMessagesInput{}
	}

	output = &GetMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMessages API operation for Amazon Simple Systems Management Message Delivery Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Message Delivery Service's
// API operation GetMessages for usage and error information.
//
// Returned Error Types:
//   * InvalidDestinationException
//
//   * RequestTimeoutException
//
//   * InternalServerException
//
//   * TooManyRequestsException
//
//   * AuthorizationFailureException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/GetMessages
func (c *SSMMDS) GetMessages(input *GetMessagesInput) (*GetMessagesOutput, error) {
	req, out := c.GetMessagesRequest(input)
	return out, req.Send()
}

// GetMessagesWithContext is the same as GetMessages with the addition of
// the ability to pass a context and additional request options.
//
// See GetMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMMDS) GetMessagesWithContext(ctx aws.Context, input *GetMessagesInput, opts ...request.Option) (*GetMessagesOutput, error) {
	req, out := c.GetMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendReply = "SendReply"

// SendReplyRequest generates a "aws/request.Request" representing the
// client's request for the SendReply operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendReply for more information on using the SendReply
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendReplyRequest method.
//    req, resp := client.SendReplyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/SendReply
func (c *SSMMDS) SendReplyRequest(input *SendReplyInput) (req *request.Request, output *SendReplyOutput) {
	op := &request.Operation{
		Name:       opSendReply,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendReplyInput{}
	}

	output = &SendReplyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendReply API operation for Amazon Simple Systems Management Message Delivery Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Message Delivery Service's
// API operation SendReply for usage and error information.
//
// Returned Error Types:
//   * UnsupportedMessageOperationException
//
//   * InvalidMessageIdException
//
//   * TooManyRequestsException
//
//   * AuthorizationFailureException
//
//   * InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mds-2015-06-19/SendReply
func (c *SSMMDS) SendReply(input *SendReplyInput) (*SendReplyOutput, error) {
	req, out := c.SendReplyRequest(input)
	return out, req.Send()
}

// SendReplyWithContext is the same as SendReply with the addition of
// the ability to pass a context and additional request options.
//
// See SendReply for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSMMDS) SendReplyWithContext(ctx aws.Context, input *SendReplyInput, opts ...request.Option) (*SendReplyOutput, error) {
	req, out := c.SendReplyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcknowledgeMessageInput struct {
	_ struct{} `type:"structure"`

	// MessageId is a required field
	MessageId *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation
func (s AcknowledgeMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcknowledgeMessageInput"}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageId sets the MessageId field's value.
func (s *AcknowledgeMessageInput) SetMessageId(v string) *AcknowledgeMessageInput {
	s.MessageId = &v
	return s
}

type AcknowledgeMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcknowledgeMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeMessageOutput) GoString() string {
	return s.String()
}

type AuthorizationFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AuthorizationFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizationFailureException) GoString() string {
	return s.String()
}

func newErrorAuthorizationFailureException(v protocol.ResponseMetadata) error {
	return &AuthorizationFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AuthorizationFailureException) Code() string {
	return "AuthorizationFailureException"
}

// Message returns the exception's message.
func (s *AuthorizationFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AuthorizationFailureException) OrigErr() error {
	return nil
}

func (s *AuthorizationFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AuthorizationFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AuthorizationFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteMessageInput struct {
	_ struct{} `type:"structure"`

	// MessageId is a required field
	MessageId *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMessageInput"}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageId sets the MessageId field's value.
func (s *DeleteMessageInput) SetMessageId(v string) *DeleteMessageInput {
	s.MessageId = &v
	return s
}

type DeleteMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageOutput) GoString() string {
	return s.String()
}

type DeliveryOptions struct {
	_ struct{} `type:"structure"`

	ExpiresAfter *string `type:"string"`

	ReplacementKey *string `type:"string"`

	SchedulePush *string `type:"string" enum:"SchedulePush"`
}

// String returns the string representation
func (s DeliveryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryOptions) GoString() string {
	return s.String()
}

// SetExpiresAfter sets the ExpiresAfter field's value.
func (s *DeliveryOptions) SetExpiresAfter(v string) *DeliveryOptions {
	s.ExpiresAfter = &v
	return s
}

// SetReplacementKey sets the ReplacementKey field's value.
func (s *DeliveryOptions) SetReplacementKey(v string) *DeliveryOptions {
	s.ReplacementKey = &v
	return s
}

// SetSchedulePush sets the SchedulePush field's value.
func (s *DeliveryOptions) SetSchedulePush(v string) *DeliveryOptions {
	s.SchedulePush = &v
	return s
}

type FailMessageInput struct {
	_ struct{} `type:"structure"`

	// FailureType is a required field
	FailureType *string `type:"string" required:"true" enum:"FailureType"`

	// MessageId is a required field
	MessageId *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation
func (s FailMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailMessageInput"}
	if s.FailureType == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureType"))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureType sets the FailureType field's value.
func (s *FailMessageInput) SetFailureType(v string) *FailMessageInput {
	s.FailureType = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *FailMessageInput) SetMessageId(v string) *FailMessageInput {
	s.MessageId = &v
	return s
}

type FailMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s FailMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailMessageOutput) GoString() string {
	return s.String()
}

type GetEndpointInput struct {
	_ struct{} `type:"structure"`

	// Destination is a required field
	Destination *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEndpointInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil && len(*s.Destination) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *GetEndpointInput) SetDestination(v string) *GetEndpointInput {
	s.Destination = &v
	return s
}

type GetEndpointOutput struct {
	_ struct{} `type:"structure"`

	Endpoint *string `type:"string"`
}

// String returns the string representation
func (s GetEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *GetEndpointOutput) SetEndpoint(v string) *GetEndpointOutput {
	s.Endpoint = &v
	return s
}

type GetMessagesInput struct {
	_ struct{} `type:"structure"`

	// Destination is a required field
	Destination *string `min:"10" type:"string" required:"true"`

	// MessagesRequestId is a required field
	MessagesRequestId *string `min:"16" type:"string" required:"true"`

	NextToken *string `type:"string"`

	VisibilityTimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s GetMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMessagesInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil && len(*s.Destination) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 10))
	}
	if s.MessagesRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessagesRequestId"))
	}
	if s.MessagesRequestId != nil && len(*s.MessagesRequestId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("MessagesRequestId", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *GetMessagesInput) SetDestination(v string) *GetMessagesInput {
	s.Destination = &v
	return s
}

// SetMessagesRequestId sets the MessagesRequestId field's value.
func (s *GetMessagesInput) SetMessagesRequestId(v string) *GetMessagesInput {
	s.MessagesRequestId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMessagesInput) SetNextToken(v string) *GetMessagesInput {
	s.NextToken = &v
	return s
}

// SetVisibilityTimeoutInSeconds sets the VisibilityTimeoutInSeconds field's value.
func (s *GetMessagesInput) SetVisibilityTimeoutInSeconds(v int64) *GetMessagesInput {
	s.VisibilityTimeoutInSeconds = &v
	return s
}

type GetMessagesOutput struct {
	_ struct{} `type:"structure"`

	Destination *string `min:"10" type:"string"`

	Messages []*Message `type:"list"`

	MessagesRequestId *string `min:"16" type:"string"`
}

// String returns the string representation
func (s GetMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMessagesOutput) GoString() string {
	return s.String()
}

// SetDestination sets the Destination field's value.
func (s *GetMessagesOutput) SetDestination(v string) *GetMessagesOutput {
	s.Destination = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *GetMessagesOutput) SetMessages(v []*Message) *GetMessagesOutput {
	s.Messages = v
	return s
}

// SetMessagesRequestId sets the MessagesRequestId field's value.
func (s *GetMessagesOutput) SetMessagesRequestId(v string) *GetMessagesOutput {
	s.MessagesRequestId = &v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidDestinationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidDestinationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidDestinationException) GoString() string {
	return s.String()
}

func newErrorInvalidDestinationException(v protocol.ResponseMetadata) error {
	return &InvalidDestinationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidDestinationException) Code() string {
	return "InvalidDestinationException"
}

// Message returns the exception's message.
func (s *InvalidDestinationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidDestinationException) OrigErr() error {
	return nil
}

func (s *InvalidDestinationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidDestinationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidDestinationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidMessageIdException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidMessageIdException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidMessageIdException) GoString() string {
	return s.String()
}

func newErrorInvalidMessageIdException(v protocol.ResponseMetadata) error {
	return &InvalidMessageIdException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidMessageIdException) Code() string {
	return "InvalidMessageIdException"
}

// Message returns the exception's message.
func (s *InvalidMessageIdException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidMessageIdException) OrigErr() error {
	return nil
}

func (s *InvalidMessageIdException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidMessageIdException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidMessageIdException) RequestID() string {
	return s.RespMetadata.RequestID
}

type Message struct {
	_ struct{} `type:"structure"`

	CreatedDate *string `min:"24" type:"string"`

	Destination *string `min:"10" type:"string"`

	MessageId *string `min:"16" type:"string"`

	NextToken *string `type:"string"`

	Payload *string `type:"string"`

	PayloadDigest *string `type:"string"`

	Topic *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Message) SetCreatedDate(v string) *Message {
	s.CreatedDate = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *Message) SetDestination(v string) *Message {
	s.Destination = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *Message) SetMessageId(v string) *Message {
	s.MessageId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *Message) SetNextToken(v string) *Message {
	s.NextToken = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *Message) SetPayload(v string) *Message {
	s.Payload = &v
	return s
}

// SetPayloadDigest sets the PayloadDigest field's value.
func (s *Message) SetPayloadDigest(v string) *Message {
	s.PayloadDigest = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *Message) SetTopic(v string) *Message {
	s.Topic = &v
	return s
}

type RequestTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s RequestTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestTimeoutException) GoString() string {
	return s.String()
}

func newErrorRequestTimeoutException(v protocol.ResponseMetadata) error {
	return &RequestTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestTimeoutException) Code() string {
	return "RequestTimeoutException"
}

// Message returns the exception's message.
func (s *RequestTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestTimeoutException) OrigErr() error {
	return nil
}

func (s *RequestTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SendReplyInput struct {
	_ struct{} `type:"structure"`

	DeliveryOptions *DeliveryOptions `type:"structure"`

	// MessageId is a required field
	MessageId *string `min:"16" type:"string" required:"true"`

	// Payload is a required field
	Payload *string `type:"string" required:"true"`

	// ReplyId is a required field
	ReplyId *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation
func (s SendReplyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendReplyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendReplyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendReplyInput"}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 16))
	}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}
	if s.ReplyId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplyId"))
	}
	if s.ReplyId != nil && len(*s.ReplyId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("ReplyId", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryOptions sets the DeliveryOptions field's value.
func (s *SendReplyInput) SetDeliveryOptions(v *DeliveryOptions) *SendReplyInput {
	s.DeliveryOptions = v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *SendReplyInput) SetMessageId(v string) *SendReplyInput {
	s.MessageId = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *SendReplyInput) SetPayload(v string) *SendReplyInput {
	s.Payload = &v
	return s
}

// SetReplyId sets the ReplyId field's value.
func (s *SendReplyInput) SetReplyId(v string) *SendReplyInput {
	s.ReplyId = &v
	return s
}

type SendReplyOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	MessageId *string `min:"16" type:"string"`

	ReplyId *string `min:"16" type:"string"`

	ReplyStatus *string `type:"string" enum:"ReplyStatus"`
}

// String returns the string representation
func (s SendReplyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendReplyOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SendReplyOutput) SetDescription(v string) *SendReplyOutput {
	s.Description = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *SendReplyOutput) SetMessageId(v string) *SendReplyOutput {
	s.MessageId = &v
	return s
}

// SetReplyId sets the ReplyId field's value.
func (s *SendReplyOutput) SetReplyId(v string) *SendReplyOutput {
	s.ReplyId = &v
	return s
}

// SetReplyStatus sets the ReplyStatus field's value.
func (s *SendReplyOutput) SetReplyStatus(v string) *SendReplyOutput {
	s.ReplyStatus = &v
	return s
}

type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UnsupportedMessageOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnsupportedMessageOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedMessageOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedMessageOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedMessageOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedMessageOperationException) Code() string {
	return "UnsupportedMessageOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedMessageOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedMessageOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedMessageOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedMessageOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedMessageOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// FailureTypeNoHandlerExists is a FailureType enum value
	FailureTypeNoHandlerExists = "NoHandlerExists"

	// FailureTypeInternalHandlerException is a FailureType enum value
	FailureTypeInternalHandlerException = "InternalHandlerException"
)

// FailureType_Values returns all elements of the FailureType enum
func FailureType_Values() []string {
	return []string{
		FailureTypeNoHandlerExists,
		FailureTypeInternalHandlerException,
	}
}

const (
	// ReplyStatusCreated is a ReplyStatus enum value
	ReplyStatusCreated = "Created"

	// ReplyStatusQueued is a ReplyStatus enum value
	ReplyStatusQueued = "Queued"

	// ReplyStatusAcknowledged is a ReplyStatus enum value
	ReplyStatusAcknowledged = "Acknowledged"

	// ReplyStatusNoActionTaken is a ReplyStatus enum value
	ReplyStatusNoActionTaken = "NoActionTaken"
)

// ReplyStatus_Values returns all elements of the ReplyStatus enum
func ReplyStatus_Values() []string {
	return []string{
		ReplyStatusCreated,
		ReplyStatusQueued,
		ReplyStatusAcknowledged,
		ReplyStatusNoActionTaken,
	}
}

const (
	// SchedulePushEventually is a SchedulePush enum value
	SchedulePushEventually = "EVENTUALLY"

	// SchedulePushAsap is a SchedulePush enum value
	SchedulePushAsap = "ASAP"
)

// SchedulePush_Values returns all elements of the SchedulePush enum
func SchedulePush_Values() []string {
	return []string{
		SchedulePushEventually,
		SchedulePushAsap,
	}
}
