# -*- coding: utf-8 -*-
# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.compute_v1 import gapic_version as package_version

__version__ = package_version.__version__


from .services.accelerator_types import AcceleratorTypesClient
from .services.addresses import AddressesClient
from .services.autoscalers import AutoscalersClient
from .services.backend_buckets import BackendBucketsClient
from .services.backend_services import BackendServicesClient
from .services.disk_types import DiskTypesClient
from .services.disks import DisksClient
from .services.external_vpn_gateways import ExternalVpnGatewaysClient
from .services.firewall_policies import FirewallPoliciesClient
from .services.firewalls import FirewallsClient
from .services.forwarding_rules import ForwardingRulesClient
from .services.global_addresses import GlobalAddressesClient
from .services.global_forwarding_rules import GlobalForwardingRulesClient
from .services.global_network_endpoint_groups import GlobalNetworkEndpointGroupsClient
from .services.global_operations import GlobalOperationsClient
from .services.global_organization_operations import GlobalOrganizationOperationsClient
from .services.global_public_delegated_prefixes import (
    GlobalPublicDelegatedPrefixesClient,
)
from .services.health_checks import HealthChecksClient
from .services.image_family_views import ImageFamilyViewsClient
from .services.images import ImagesClient
from .services.instance_group_managers import InstanceGroupManagersClient
from .services.instance_groups import InstanceGroupsClient
from .services.instance_templates import InstanceTemplatesClient
from .services.instances import InstancesClient
from .services.interconnect_attachments import InterconnectAttachmentsClient
from .services.interconnect_locations import InterconnectLocationsClient
from .services.interconnect_remote_locations import InterconnectRemoteLocationsClient
from .services.interconnects import InterconnectsClient
from .services.license_codes import LicenseCodesClient
from .services.licenses import LicensesClient
from .services.machine_images import MachineImagesClient
from .services.machine_types import MachineTypesClient
from .services.network_attachments import NetworkAttachmentsClient
from .services.network_edge_security_services import NetworkEdgeSecurityServicesClient
from .services.network_endpoint_groups import NetworkEndpointGroupsClient
from .services.network_firewall_policies import NetworkFirewallPoliciesClient
from .services.networks import NetworksClient
from .services.node_groups import NodeGroupsClient
from .services.node_templates import NodeTemplatesClient
from .services.node_types import NodeTypesClient
from .services.packet_mirrorings import PacketMirroringsClient
from .services.projects import ProjectsClient
from .services.public_advertised_prefixes import PublicAdvertisedPrefixesClient
from .services.public_delegated_prefixes import PublicDelegatedPrefixesClient
from .services.region_autoscalers import RegionAutoscalersClient
from .services.region_backend_services import RegionBackendServicesClient
from .services.region_commitments import RegionCommitmentsClient
from .services.region_disk_types import RegionDiskTypesClient
from .services.region_disks import RegionDisksClient
from .services.region_health_check_services import RegionHealthCheckServicesClient
from .services.region_health_checks import RegionHealthChecksClient
from .services.region_instance_group_managers import RegionInstanceGroupManagersClient
from .services.region_instance_groups import RegionInstanceGroupsClient
from .services.region_instance_templates import RegionInstanceTemplatesClient
from .services.region_instances import RegionInstancesClient
from .services.region_network_endpoint_groups import RegionNetworkEndpointGroupsClient
from .services.region_network_firewall_policies import (
    RegionNetworkFirewallPoliciesClient,
)
from .services.region_notification_endpoints import RegionNotificationEndpointsClient
from .services.region_operations import RegionOperationsClient
from .services.region_security_policies import RegionSecurityPoliciesClient
from .services.region_ssl_certificates import RegionSslCertificatesClient
from .services.region_ssl_policies import RegionSslPoliciesClient
from .services.region_target_http_proxies import RegionTargetHttpProxiesClient
from .services.region_target_https_proxies import RegionTargetHttpsProxiesClient
from .services.region_target_tcp_proxies import RegionTargetTcpProxiesClient
from .services.region_url_maps import RegionUrlMapsClient
from .services.regions import RegionsClient
from .services.reservations import ReservationsClient
from .services.resource_policies import ResourcePoliciesClient
from .services.routers import RoutersClient
from .services.routes import RoutesClient
from .services.security_policies import SecurityPoliciesClient
from .services.service_attachments import ServiceAttachmentsClient
from .services.snapshot_settings_service import SnapshotSettingsServiceClient
from .services.snapshots import SnapshotsClient
from .services.ssl_certificates import SslCertificatesClient
from .services.ssl_policies import SslPoliciesClient
from .services.subnetworks import SubnetworksClient
from .services.target_grpc_proxies import TargetGrpcProxiesClient
from .services.target_http_proxies import TargetHttpProxiesClient
from .services.target_https_proxies import TargetHttpsProxiesClient
from .services.target_instances import TargetInstancesClient
from .services.target_pools import TargetPoolsClient
from .services.target_ssl_proxies import TargetSslProxiesClient
from .services.target_tcp_proxies import TargetTcpProxiesClient
from .services.target_vpn_gateways import TargetVpnGatewaysClient
from .services.url_maps import UrlMapsClient
from .services.vpn_gateways import VpnGatewaysClient
from .services.vpn_tunnels import VpnTunnelsClient
from .services.zone_operations import ZoneOperationsClient
from .services.zones import ZonesClient
from .types.compute import (
    AbandonInstancesInstanceGroupManagerRequest,
    AbandonInstancesRegionInstanceGroupManagerRequest,
    AcceleratorConfig,
    Accelerators,
    AcceleratorType,
    AcceleratorTypeAggregatedList,
    AcceleratorTypeList,
    AcceleratorTypesScopedList,
    AccessConfig,
    AddAccessConfigInstanceRequest,
    AddAssociationFirewallPolicyRequest,
    AddAssociationNetworkFirewallPolicyRequest,
    AddAssociationRegionNetworkFirewallPolicyRequest,
    AddHealthCheckTargetPoolRequest,
    AddInstancesInstanceGroupRequest,
    AddInstanceTargetPoolRequest,
    AddNodesNodeGroupRequest,
    AddPeeringNetworkRequest,
    AddResourcePoliciesDiskRequest,
    AddResourcePoliciesInstanceRequest,
    AddResourcePoliciesRegionDiskRequest,
    Address,
    AddressAggregatedList,
    AddressesScopedList,
    AddressList,
    AddRuleFirewallPolicyRequest,
    AddRuleNetworkFirewallPolicyRequest,
    AddRuleRegionNetworkFirewallPolicyRequest,
    AddRuleRegionSecurityPolicyRequest,
    AddRuleSecurityPolicyRequest,
    AddSignedUrlKeyBackendBucketRequest,
    AddSignedUrlKeyBackendServiceRequest,
    AdvancedMachineFeatures,
    AggregatedListAcceleratorTypesRequest,
    AggregatedListAddressesRequest,
    AggregatedListAutoscalersRequest,
    AggregatedListBackendServicesRequest,
    AggregatedListDisksRequest,
    AggregatedListDiskTypesRequest,
    AggregatedListForwardingRulesRequest,
    AggregatedListGlobalOperationsRequest,
    AggregatedListHealthChecksRequest,
    AggregatedListInstanceGroupManagersRequest,
    AggregatedListInstanceGroupsRequest,
    AggregatedListInstancesRequest,
    AggregatedListInstanceTemplatesRequest,
    AggregatedListInterconnectAttachmentsRequest,
    AggregatedListMachineTypesRequest,
    AggregatedListNetworkAttachmentsRequest,
    AggregatedListNetworkEdgeSecurityServicesRequest,
    AggregatedListNetworkEndpointGroupsRequest,
    AggregatedListNodeGroupsRequest,
    AggregatedListNodeTemplatesRequest,
    AggregatedListNodeTypesRequest,
    AggregatedListPacketMirroringsRequest,
    AggregatedListPublicDelegatedPrefixesRequest,
    AggregatedListRegionCommitmentsRequest,
    AggregatedListReservationsRequest,
    AggregatedListResourcePoliciesRequest,
    AggregatedListRoutersRequest,
    AggregatedListSecurityPoliciesRequest,
    AggregatedListServiceAttachmentsRequest,
    AggregatedListSslCertificatesRequest,
    AggregatedListSslPoliciesRequest,
    AggregatedListSubnetworksRequest,
    AggregatedListTargetHttpProxiesRequest,
    AggregatedListTargetHttpsProxiesRequest,
    AggregatedListTargetInstancesRequest,
    AggregatedListTargetPoolsRequest,
    AggregatedListTargetTcpProxiesRequest,
    AggregatedListTargetVpnGatewaysRequest,
    AggregatedListUrlMapsRequest,
    AggregatedListVpnGatewaysRequest,
    AggregatedListVpnTunnelsRequest,
    AliasIpRange,
    AllocationResourceStatus,
    AllocationResourceStatusSpecificSKUAllocation,
    AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
    AllocationSpecificSKUAllocationReservedInstanceProperties,
    AllocationSpecificSKUReservation,
    Allowed,
    AnnouncePublicAdvertisedPrefixeRequest,
    AnnouncePublicDelegatedPrefixeRequest,
    ApplyUpdatesToInstancesInstanceGroupManagerRequest,
    ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest,
    AttachDiskInstanceRequest,
    AttachedDisk,
    AttachedDiskInitializeParams,
    AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    AttachNetworkEndpointsNetworkEndpointGroupRequest,
    AttachNetworkEndpointsRegionNetworkEndpointGroupRequest,
    AuditConfig,
    AuditLogConfig,
    AuthorizationLoggingOptions,
    Autoscaler,
    AutoscalerAggregatedList,
    AutoscalerList,
    AutoscalersScopedList,
    AutoscalerStatusDetails,
    AutoscalingPolicy,
    AutoscalingPolicyCpuUtilization,
    AutoscalingPolicyCustomMetricUtilization,
    AutoscalingPolicyLoadBalancingUtilization,
    AutoscalingPolicyScaleInControl,
    AutoscalingPolicyScalingSchedule,
    AWSV4Signature,
    Backend,
    BackendBucket,
    BackendBucketCdnPolicy,
    BackendBucketCdnPolicyBypassCacheOnRequestHeader,
    BackendBucketCdnPolicyCacheKeyPolicy,
    BackendBucketCdnPolicyNegativeCachingPolicy,
    BackendBucketList,
    BackendService,
    BackendServiceAggregatedList,
    BackendServiceCdnPolicy,
    BackendServiceCdnPolicyBypassCacheOnRequestHeader,
    BackendServiceCdnPolicyNegativeCachingPolicy,
    BackendServiceConnectionTrackingPolicy,
    BackendServiceFailoverPolicy,
    BackendServiceGroupHealth,
    BackendServiceIAP,
    BackendServiceList,
    BackendServiceListUsable,
    BackendServiceLocalityLoadBalancingPolicyConfig,
    BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy,
    BackendServiceLocalityLoadBalancingPolicyConfigPolicy,
    BackendServiceLogConfig,
    BackendServiceReference,
    BackendServicesScopedList,
    BackendServiceUsedBy,
    BfdPacket,
    BfdStatus,
    BfdStatusPacketCounts,
    Binding,
    BulkInsertDiskRequest,
    BulkInsertDiskResource,
    BulkInsertInstanceRequest,
    BulkInsertInstanceResource,
    BulkInsertInstanceResourcePerInstanceProperties,
    BulkInsertOperationStatus,
    BulkInsertRegionDiskRequest,
    BulkInsertRegionInstanceRequest,
    CacheInvalidationRule,
    CacheKeyPolicy,
    CircuitBreakers,
    CloneRulesFirewallPolicyRequest,
    CloneRulesNetworkFirewallPolicyRequest,
    CloneRulesRegionNetworkFirewallPolicyRequest,
    Commitment,
    CommitmentAggregatedList,
    CommitmentList,
    CommitmentsScopedList,
    Condition,
    ConfidentialInstanceConfig,
    ConnectionDraining,
    ConsistentHashLoadBalancerSettings,
    ConsistentHashLoadBalancerSettingsHttpCookie,
    CorsPolicy,
    CreateInstancesInstanceGroupManagerRequest,
    CreateInstancesRegionInstanceGroupManagerRequest,
    CreateSnapshotDiskRequest,
    CreateSnapshotRegionDiskRequest,
    CustomerEncryptionKey,
    CustomerEncryptionKeyProtectedDisk,
    Data,
    DeleteAccessConfigInstanceRequest,
    DeleteAddressRequest,
    DeleteAutoscalerRequest,
    DeleteBackendBucketRequest,
    DeleteBackendServiceRequest,
    DeleteDiskRequest,
    DeleteExternalVpnGatewayRequest,
    DeleteFirewallPolicyRequest,
    DeleteFirewallRequest,
    DeleteForwardingRuleRequest,
    DeleteGlobalAddressRequest,
    DeleteGlobalForwardingRuleRequest,
    DeleteGlobalNetworkEndpointGroupRequest,
    DeleteGlobalOperationRequest,
    DeleteGlobalOperationResponse,
    DeleteGlobalOrganizationOperationRequest,
    DeleteGlobalOrganizationOperationResponse,
    DeleteGlobalPublicDelegatedPrefixeRequest,
    DeleteHealthCheckRequest,
    DeleteImageRequest,
    DeleteInstanceGroupManagerRequest,
    DeleteInstanceGroupRequest,
    DeleteInstanceRequest,
    DeleteInstancesInstanceGroupManagerRequest,
    DeleteInstancesRegionInstanceGroupManagerRequest,
    DeleteInstanceTemplateRequest,
    DeleteInterconnectAttachmentRequest,
    DeleteInterconnectRequest,
    DeleteLicenseRequest,
    DeleteMachineImageRequest,
    DeleteNetworkAttachmentRequest,
    DeleteNetworkEdgeSecurityServiceRequest,
    DeleteNetworkEndpointGroupRequest,
    DeleteNetworkFirewallPolicyRequest,
    DeleteNetworkRequest,
    DeleteNodeGroupRequest,
    DeleteNodesNodeGroupRequest,
    DeleteNodeTemplateRequest,
    DeletePacketMirroringRequest,
    DeletePerInstanceConfigsInstanceGroupManagerRequest,
    DeletePerInstanceConfigsRegionInstanceGroupManagerRequest,
    DeletePublicAdvertisedPrefixeRequest,
    DeletePublicDelegatedPrefixeRequest,
    DeleteRegionAutoscalerRequest,
    DeleteRegionBackendServiceRequest,
    DeleteRegionDiskRequest,
    DeleteRegionHealthCheckRequest,
    DeleteRegionHealthCheckServiceRequest,
    DeleteRegionInstanceGroupManagerRequest,
    DeleteRegionInstanceTemplateRequest,
    DeleteRegionNetworkEndpointGroupRequest,
    DeleteRegionNetworkFirewallPolicyRequest,
    DeleteRegionNotificationEndpointRequest,
    DeleteRegionOperationRequest,
    DeleteRegionOperationResponse,
    DeleteRegionSecurityPolicyRequest,
    DeleteRegionSslCertificateRequest,
    DeleteRegionSslPolicyRequest,
    DeleteRegionTargetHttpProxyRequest,
    DeleteRegionTargetHttpsProxyRequest,
    DeleteRegionTargetTcpProxyRequest,
    DeleteRegionUrlMapRequest,
    DeleteReservationRequest,
    DeleteResourcePolicyRequest,
    DeleteRouteRequest,
    DeleteRouterRequest,
    DeleteSecurityPolicyRequest,
    DeleteServiceAttachmentRequest,
    DeleteSignedUrlKeyBackendBucketRequest,
    DeleteSignedUrlKeyBackendServiceRequest,
    DeleteSnapshotRequest,
    DeleteSslCertificateRequest,
    DeleteSslPolicyRequest,
    DeleteSubnetworkRequest,
    DeleteTargetGrpcProxyRequest,
    DeleteTargetHttpProxyRequest,
    DeleteTargetHttpsProxyRequest,
    DeleteTargetInstanceRequest,
    DeleteTargetPoolRequest,
    DeleteTargetSslProxyRequest,
    DeleteTargetTcpProxyRequest,
    DeleteTargetVpnGatewayRequest,
    DeleteUrlMapRequest,
    DeleteVpnGatewayRequest,
    DeleteVpnTunnelRequest,
    DeleteZoneOperationRequest,
    DeleteZoneOperationResponse,
    Denied,
    DeprecateImageRequest,
    DeprecationStatus,
    DetachDiskInstanceRequest,
    DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    DetachNetworkEndpointsNetworkEndpointGroupRequest,
    DetachNetworkEndpointsRegionNetworkEndpointGroupRequest,
    DisableXpnHostProjectRequest,
    DisableXpnResourceProjectRequest,
    Disk,
    DiskAggregatedList,
    DiskAsyncReplication,
    DiskAsyncReplicationList,
    DiskInstantiationConfig,
    DiskList,
    DiskMoveRequest,
    DiskParams,
    DiskResourceStatus,
    DiskResourceStatusAsyncReplicationStatus,
    DisksAddResourcePoliciesRequest,
    DisksRemoveResourcePoliciesRequest,
    DisksResizeRequest,
    DisksScopedList,
    DisksStartAsyncReplicationRequest,
    DisksStopGroupAsyncReplicationResource,
    DiskType,
    DiskTypeAggregatedList,
    DiskTypeList,
    DiskTypesScopedList,
    DisplayDevice,
    DistributionPolicy,
    DistributionPolicyZoneConfiguration,
    Duration,
    EnableXpnHostProjectRequest,
    EnableXpnResourceProjectRequest,
    Error,
    ErrorDetails,
    ErrorInfo,
    Errors,
    ExchangedPeeringRoute,
    ExchangedPeeringRoutesList,
    ExpandIpCidrRangeSubnetworkRequest,
    Expr,
    ExternalVpnGateway,
    ExternalVpnGatewayInterface,
    ExternalVpnGatewayList,
    FileContentBuffer,
    Firewall,
    FirewallList,
    FirewallLogConfig,
    FirewallPoliciesListAssociationsResponse,
    FirewallPolicy,
    FirewallPolicyAssociation,
    FirewallPolicyList,
    FirewallPolicyRule,
    FirewallPolicyRuleMatcher,
    FirewallPolicyRuleMatcherLayer4Config,
    FirewallPolicyRuleSecureTag,
    FixedOrPercent,
    ForwardingRule,
    ForwardingRuleAggregatedList,
    ForwardingRuleList,
    ForwardingRuleReference,
    ForwardingRuleServiceDirectoryRegistration,
    ForwardingRulesScopedList,
    GetAcceleratorTypeRequest,
    GetAddressRequest,
    GetAssociationFirewallPolicyRequest,
    GetAssociationNetworkFirewallPolicyRequest,
    GetAssociationRegionNetworkFirewallPolicyRequest,
    GetAutoscalerRequest,
    GetBackendBucketRequest,
    GetBackendServiceRequest,
    GetDiagnosticsInterconnectRequest,
    GetDiskRequest,
    GetDiskTypeRequest,
    GetEffectiveFirewallsInstanceRequest,
    GetEffectiveFirewallsNetworkRequest,
    GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest,
    GetExternalVpnGatewayRequest,
    GetFirewallPolicyRequest,
    GetFirewallRequest,
    GetForwardingRuleRequest,
    GetFromFamilyImageRequest,
    GetGlobalAddressRequest,
    GetGlobalForwardingRuleRequest,
    GetGlobalNetworkEndpointGroupRequest,
    GetGlobalOperationRequest,
    GetGlobalOrganizationOperationRequest,
    GetGlobalPublicDelegatedPrefixeRequest,
    GetGuestAttributesInstanceRequest,
    GetHealthBackendServiceRequest,
    GetHealthCheckRequest,
    GetHealthRegionBackendServiceRequest,
    GetHealthTargetPoolRequest,
    GetIamPolicyBackendBucketRequest,
    GetIamPolicyBackendServiceRequest,
    GetIamPolicyDiskRequest,
    GetIamPolicyFirewallPolicyRequest,
    GetIamPolicyImageRequest,
    GetIamPolicyInstanceRequest,
    GetIamPolicyInstanceTemplateRequest,
    GetIamPolicyLicenseRequest,
    GetIamPolicyMachineImageRequest,
    GetIamPolicyNetworkAttachmentRequest,
    GetIamPolicyNetworkFirewallPolicyRequest,
    GetIamPolicyNodeGroupRequest,
    GetIamPolicyNodeTemplateRequest,
    GetIamPolicyRegionBackendServiceRequest,
    GetIamPolicyRegionDiskRequest,
    GetIamPolicyRegionNetworkFirewallPolicyRequest,
    GetIamPolicyReservationRequest,
    GetIamPolicyResourcePolicyRequest,
    GetIamPolicyServiceAttachmentRequest,
    GetIamPolicySnapshotRequest,
    GetIamPolicySubnetworkRequest,
    GetImageFamilyViewRequest,
    GetImageRequest,
    GetInstanceGroupManagerRequest,
    GetInstanceGroupRequest,
    GetInstanceRequest,
    GetInstanceTemplateRequest,
    GetInterconnectAttachmentRequest,
    GetInterconnectLocationRequest,
    GetInterconnectRemoteLocationRequest,
    GetInterconnectRequest,
    GetLicenseCodeRequest,
    GetLicenseRequest,
    GetMachineImageRequest,
    GetMachineTypeRequest,
    GetMacsecConfigInterconnectRequest,
    GetNatIpInfoRouterRequest,
    GetNatMappingInfoRoutersRequest,
    GetNetworkAttachmentRequest,
    GetNetworkEdgeSecurityServiceRequest,
    GetNetworkEndpointGroupRequest,
    GetNetworkFirewallPolicyRequest,
    GetNetworkRequest,
    GetNodeGroupRequest,
    GetNodeTemplateRequest,
    GetNodeTypeRequest,
    GetPacketMirroringRequest,
    GetProjectRequest,
    GetPublicAdvertisedPrefixeRequest,
    GetPublicDelegatedPrefixeRequest,
    GetRegionAutoscalerRequest,
    GetRegionBackendServiceRequest,
    GetRegionCommitmentRequest,
    GetRegionDiskRequest,
    GetRegionDiskTypeRequest,
    GetRegionHealthCheckRequest,
    GetRegionHealthCheckServiceRequest,
    GetRegionInstanceGroupManagerRequest,
    GetRegionInstanceGroupRequest,
    GetRegionInstanceTemplateRequest,
    GetRegionNetworkEndpointGroupRequest,
    GetRegionNetworkFirewallPolicyRequest,
    GetRegionNotificationEndpointRequest,
    GetRegionOperationRequest,
    GetRegionRequest,
    GetRegionSecurityPolicyRequest,
    GetRegionSslCertificateRequest,
    GetRegionSslPolicyRequest,
    GetRegionTargetHttpProxyRequest,
    GetRegionTargetHttpsProxyRequest,
    GetRegionTargetTcpProxyRequest,
    GetRegionUrlMapRequest,
    GetReservationRequest,
    GetResourcePolicyRequest,
    GetRouteRequest,
    GetRouterRequest,
    GetRouterStatusRouterRequest,
    GetRuleFirewallPolicyRequest,
    GetRuleNetworkFirewallPolicyRequest,
    GetRuleRegionNetworkFirewallPolicyRequest,
    GetRuleRegionSecurityPolicyRequest,
    GetRuleSecurityPolicyRequest,
    GetScreenshotInstanceRequest,
    GetSecurityPolicyRequest,
    GetSerialPortOutputInstanceRequest,
    GetServiceAttachmentRequest,
    GetShieldedInstanceIdentityInstanceRequest,
    GetSnapshotRequest,
    GetSnapshotSettingRequest,
    GetSslCertificateRequest,
    GetSslPolicyRequest,
    GetStatusVpnGatewayRequest,
    GetSubnetworkRequest,
    GetTargetGrpcProxyRequest,
    GetTargetHttpProxyRequest,
    GetTargetHttpsProxyRequest,
    GetTargetInstanceRequest,
    GetTargetPoolRequest,
    GetTargetSslProxyRequest,
    GetTargetTcpProxyRequest,
    GetTargetVpnGatewayRequest,
    GetUrlMapRequest,
    GetVpnGatewayRequest,
    GetVpnTunnelRequest,
    GetXpnHostProjectRequest,
    GetXpnResourcesProjectsRequest,
    GetZoneOperationRequest,
    GetZoneRequest,
    GlobalAddressesMoveRequest,
    GlobalNetworkEndpointGroupsAttachEndpointsRequest,
    GlobalNetworkEndpointGroupsDetachEndpointsRequest,
    GlobalOrganizationSetPolicyRequest,
    GlobalSetLabelsRequest,
    GlobalSetPolicyRequest,
    GRPCHealthCheck,
    GuestAttributes,
    GuestAttributesEntry,
    GuestAttributesValue,
    GuestOsFeature,
    HealthCheck,
    HealthCheckList,
    HealthCheckLogConfig,
    HealthCheckReference,
    HealthChecksAggregatedList,
    HealthCheckService,
    HealthCheckServiceReference,
    HealthCheckServicesList,
    HealthChecksScopedList,
    HealthStatus,
    HealthStatusForNetworkEndpoint,
    Help,
    HelpLink,
    HostRule,
    HTTP2HealthCheck,
    HttpFaultAbort,
    HttpFaultDelay,
    HttpFaultInjection,
    HttpHeaderAction,
    HttpHeaderMatch,
    HttpHeaderOption,
    HTTPHealthCheck,
    HttpQueryParameterMatch,
    HttpRedirectAction,
    HttpRetryPolicy,
    HttpRouteAction,
    HttpRouteRule,
    HttpRouteRuleMatch,
    HTTPSHealthCheck,
    Image,
    ImageFamilyView,
    ImageList,
    InitialStateConfig,
    InsertAddressRequest,
    InsertAutoscalerRequest,
    InsertBackendBucketRequest,
    InsertBackendServiceRequest,
    InsertDiskRequest,
    InsertExternalVpnGatewayRequest,
    InsertFirewallPolicyRequest,
    InsertFirewallRequest,
    InsertForwardingRuleRequest,
    InsertGlobalAddressRequest,
    InsertGlobalForwardingRuleRequest,
    InsertGlobalNetworkEndpointGroupRequest,
    InsertGlobalPublicDelegatedPrefixeRequest,
    InsertHealthCheckRequest,
    InsertImageRequest,
    InsertInstanceGroupManagerRequest,
    InsertInstanceGroupRequest,
    InsertInstanceRequest,
    InsertInstanceTemplateRequest,
    InsertInterconnectAttachmentRequest,
    InsertInterconnectRequest,
    InsertLicenseRequest,
    InsertMachineImageRequest,
    InsertNetworkAttachmentRequest,
    InsertNetworkEdgeSecurityServiceRequest,
    InsertNetworkEndpointGroupRequest,
    InsertNetworkFirewallPolicyRequest,
    InsertNetworkRequest,
    InsertNodeGroupRequest,
    InsertNodeTemplateRequest,
    InsertPacketMirroringRequest,
    InsertPublicAdvertisedPrefixeRequest,
    InsertPublicDelegatedPrefixeRequest,
    InsertRegionAutoscalerRequest,
    InsertRegionBackendServiceRequest,
    InsertRegionCommitmentRequest,
    InsertRegionDiskRequest,
    InsertRegionHealthCheckRequest,
    InsertRegionHealthCheckServiceRequest,
    InsertRegionInstanceGroupManagerRequest,
    InsertRegionInstanceTemplateRequest,
    InsertRegionNetworkEndpointGroupRequest,
    InsertRegionNetworkFirewallPolicyRequest,
    InsertRegionNotificationEndpointRequest,
    InsertRegionSecurityPolicyRequest,
    InsertRegionSslCertificateRequest,
    InsertRegionSslPolicyRequest,
    InsertRegionTargetHttpProxyRequest,
    InsertRegionTargetHttpsProxyRequest,
    InsertRegionTargetTcpProxyRequest,
    InsertRegionUrlMapRequest,
    InsertReservationRequest,
    InsertResourcePolicyRequest,
    InsertRouteRequest,
    InsertRouterRequest,
    InsertSecurityPolicyRequest,
    InsertServiceAttachmentRequest,
    InsertSnapshotRequest,
    InsertSslCertificateRequest,
    InsertSslPolicyRequest,
    InsertSubnetworkRequest,
    InsertTargetGrpcProxyRequest,
    InsertTargetHttpProxyRequest,
    InsertTargetHttpsProxyRequest,
    InsertTargetInstanceRequest,
    InsertTargetPoolRequest,
    InsertTargetSslProxyRequest,
    InsertTargetTcpProxyRequest,
    InsertTargetVpnGatewayRequest,
    InsertUrlMapRequest,
    InsertVpnGatewayRequest,
    InsertVpnTunnelRequest,
    Instance,
    InstanceAggregatedList,
    InstanceConsumptionData,
    InstanceConsumptionInfo,
    InstanceGroup,
    InstanceGroupAggregatedList,
    InstanceGroupList,
    InstanceGroupManager,
    InstanceGroupManagerActionsSummary,
    InstanceGroupManagerAggregatedList,
    InstanceGroupManagerAutoHealingPolicy,
    InstanceGroupManagerInstanceLifecyclePolicy,
    InstanceGroupManagerList,
    InstanceGroupManagersAbandonInstancesRequest,
    InstanceGroupManagersApplyUpdatesRequest,
    InstanceGroupManagersCreateInstancesRequest,
    InstanceGroupManagersDeleteInstancesRequest,
    InstanceGroupManagersDeletePerInstanceConfigsReq,
    InstanceGroupManagersListErrorsResponse,
    InstanceGroupManagersListManagedInstancesResponse,
    InstanceGroupManagersListPerInstanceConfigsResp,
    InstanceGroupManagersPatchPerInstanceConfigsReq,
    InstanceGroupManagersRecreateInstancesRequest,
    InstanceGroupManagersScopedList,
    InstanceGroupManagersSetInstanceTemplateRequest,
    InstanceGroupManagersSetTargetPoolsRequest,
    InstanceGroupManagerStatus,
    InstanceGroupManagerStatusStateful,
    InstanceGroupManagerStatusStatefulPerInstanceConfigs,
    InstanceGroupManagerStatusVersionTarget,
    InstanceGroupManagersUpdatePerInstanceConfigsReq,
    InstanceGroupManagerUpdatePolicy,
    InstanceGroupManagerVersion,
    InstanceGroupsAddInstancesRequest,
    InstanceGroupsListInstances,
    InstanceGroupsListInstancesRequest,
    InstanceGroupsRemoveInstancesRequest,
    InstanceGroupsScopedList,
    InstanceGroupsSetNamedPortsRequest,
    InstanceList,
    InstanceListReferrers,
    InstanceManagedByIgmError,
    InstanceManagedByIgmErrorInstanceActionDetails,
    InstanceManagedByIgmErrorManagedInstanceError,
    InstanceMoveRequest,
    InstanceParams,
    InstanceProperties,
    InstanceReference,
    InstancesAddResourcePoliciesRequest,
    InstancesBulkInsertOperationMetadata,
    InstancesGetEffectiveFirewallsResponse,
    InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    InstancesRemoveResourcePoliciesRequest,
    InstancesScopedList,
    InstancesSetLabelsRequest,
    InstancesSetMachineResourcesRequest,
    InstancesSetMachineTypeRequest,
    InstancesSetMinCpuPlatformRequest,
    InstancesSetNameRequest,
    InstancesSetSecurityPolicyRequest,
    InstancesSetServiceAccountRequest,
    InstancesStartWithEncryptionKeyRequest,
    InstanceTemplate,
    InstanceTemplateAggregatedList,
    InstanceTemplateList,
    InstanceTemplatesScopedList,
    InstanceWithNamedPorts,
    Int64RangeMatch,
    Interconnect,
    InterconnectAttachment,
    InterconnectAttachmentAggregatedList,
    InterconnectAttachmentConfigurationConstraints,
    InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange,
    InterconnectAttachmentList,
    InterconnectAttachmentPartnerMetadata,
    InterconnectAttachmentPrivateInfo,
    InterconnectAttachmentsScopedList,
    InterconnectCircuitInfo,
    InterconnectDiagnostics,
    InterconnectDiagnosticsARPEntry,
    InterconnectDiagnosticsLinkLACPStatus,
    InterconnectDiagnosticsLinkOpticalPower,
    InterconnectDiagnosticsLinkStatus,
    InterconnectDiagnosticsMacsecStatus,
    InterconnectList,
    InterconnectLocation,
    InterconnectLocationList,
    InterconnectLocationRegionInfo,
    InterconnectMacsec,
    InterconnectMacsecConfig,
    InterconnectMacsecConfigPreSharedKey,
    InterconnectMacsecPreSharedKey,
    InterconnectOutageNotification,
    InterconnectRemoteLocation,
    InterconnectRemoteLocationConstraints,
    InterconnectRemoteLocationConstraintsSubnetLengthRange,
    InterconnectRemoteLocationList,
    InterconnectRemoteLocationPermittedConnections,
    InterconnectsGetDiagnosticsResponse,
    InterconnectsGetMacsecConfigResponse,
    InvalidateCacheUrlMapRequest,
    Items,
    License,
    LicenseCode,
    LicenseCodeLicenseAlias,
    LicenseResourceCommitment,
    LicenseResourceRequirements,
    LicensesListResponse,
    ListAcceleratorTypesRequest,
    ListAddressesRequest,
    ListAssociationsFirewallPolicyRequest,
    ListAutoscalersRequest,
    ListAvailableFeaturesRegionSslPoliciesRequest,
    ListAvailableFeaturesSslPoliciesRequest,
    ListBackendBucketsRequest,
    ListBackendServicesRequest,
    ListDisksRequest,
    ListDiskTypesRequest,
    ListErrorsInstanceGroupManagersRequest,
    ListErrorsRegionInstanceGroupManagersRequest,
    ListExternalVpnGatewaysRequest,
    ListFirewallPoliciesRequest,
    ListFirewallsRequest,
    ListForwardingRulesRequest,
    ListGlobalAddressesRequest,
    ListGlobalForwardingRulesRequest,
    ListGlobalNetworkEndpointGroupsRequest,
    ListGlobalOperationsRequest,
    ListGlobalOrganizationOperationsRequest,
    ListGlobalPublicDelegatedPrefixesRequest,
    ListHealthChecksRequest,
    ListImagesRequest,
    ListInstanceGroupManagersRequest,
    ListInstanceGroupsRequest,
    ListInstancesInstanceGroupsRequest,
    ListInstancesRegionInstanceGroupsRequest,
    ListInstancesRequest,
    ListInstanceTemplatesRequest,
    ListInterconnectAttachmentsRequest,
    ListInterconnectLocationsRequest,
    ListInterconnectRemoteLocationsRequest,
    ListInterconnectsRequest,
    ListLicensesRequest,
    ListMachineImagesRequest,
    ListMachineTypesRequest,
    ListManagedInstancesInstanceGroupManagersRequest,
    ListManagedInstancesRegionInstanceGroupManagersRequest,
    ListNetworkAttachmentsRequest,
    ListNetworkEndpointGroupsRequest,
    ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest,
    ListNetworkEndpointsNetworkEndpointGroupsRequest,
    ListNetworkEndpointsRegionNetworkEndpointGroupsRequest,
    ListNetworkFirewallPoliciesRequest,
    ListNetworksRequest,
    ListNodeGroupsRequest,
    ListNodesNodeGroupsRequest,
    ListNodeTemplatesRequest,
    ListNodeTypesRequest,
    ListPacketMirroringsRequest,
    ListPeeringRoutesNetworksRequest,
    ListPerInstanceConfigsInstanceGroupManagersRequest,
    ListPerInstanceConfigsRegionInstanceGroupManagersRequest,
    ListPreconfiguredExpressionSetsSecurityPoliciesRequest,
    ListPublicAdvertisedPrefixesRequest,
    ListPublicDelegatedPrefixesRequest,
    ListReferrersInstancesRequest,
    ListRegionAutoscalersRequest,
    ListRegionBackendServicesRequest,
    ListRegionCommitmentsRequest,
    ListRegionDisksRequest,
    ListRegionDiskTypesRequest,
    ListRegionHealthCheckServicesRequest,
    ListRegionHealthChecksRequest,
    ListRegionInstanceGroupManagersRequest,
    ListRegionInstanceGroupsRequest,
    ListRegionInstanceTemplatesRequest,
    ListRegionNetworkEndpointGroupsRequest,
    ListRegionNetworkFirewallPoliciesRequest,
    ListRegionNotificationEndpointsRequest,
    ListRegionOperationsRequest,
    ListRegionSecurityPoliciesRequest,
    ListRegionsRequest,
    ListRegionSslCertificatesRequest,
    ListRegionSslPoliciesRequest,
    ListRegionTargetHttpProxiesRequest,
    ListRegionTargetHttpsProxiesRequest,
    ListRegionTargetTcpProxiesRequest,
    ListRegionUrlMapsRequest,
    ListReservationsRequest,
    ListResourcePoliciesRequest,
    ListRoutersRequest,
    ListRoutesRequest,
    ListSecurityPoliciesRequest,
    ListServiceAttachmentsRequest,
    ListSnapshotsRequest,
    ListSslCertificatesRequest,
    ListSslPoliciesRequest,
    ListSubnetworksRequest,
    ListTargetGrpcProxiesRequest,
    ListTargetHttpProxiesRequest,
    ListTargetHttpsProxiesRequest,
    ListTargetInstancesRequest,
    ListTargetPoolsRequest,
    ListTargetSslProxiesRequest,
    ListTargetTcpProxiesRequest,
    ListTargetVpnGatewaysRequest,
    ListUrlMapsRequest,
    ListUsableBackendServicesRequest,
    ListUsableRegionBackendServicesRequest,
    ListUsableSubnetworksRequest,
    ListVpnGatewaysRequest,
    ListVpnTunnelsRequest,
    ListXpnHostsProjectsRequest,
    ListZoneOperationsRequest,
    ListZonesRequest,
    LocalDisk,
    LocalizedMessage,
    LocationPolicy,
    LocationPolicyLocation,
    LocationPolicyLocationConstraints,
    LogConfig,
    LogConfigCloudAuditOptions,
    LogConfigCounterOptions,
    LogConfigCounterOptionsCustomField,
    LogConfigDataAccessOptions,
    MachineImage,
    MachineImageList,
    MachineType,
    MachineTypeAggregatedList,
    MachineTypeList,
    MachineTypesScopedList,
    ManagedInstance,
    ManagedInstanceInstanceHealth,
    ManagedInstanceLastAttempt,
    ManagedInstanceVersion,
    Metadata,
    MetadataFilter,
    MetadataFilterLabelMatch,
    MoveAddressRequest,
    MoveDiskProjectRequest,
    MoveFirewallPolicyRequest,
    MoveGlobalAddressRequest,
    MoveInstanceProjectRequest,
    NamedPort,
    NatIpInfo,
    NatIpInfoNatIpInfoMapping,
    NatIpInfoResponse,
    Network,
    NetworkAttachment,
    NetworkAttachmentAggregatedList,
    NetworkAttachmentConnectedEndpoint,
    NetworkAttachmentList,
    NetworkAttachmentsScopedList,
    NetworkEdgeSecurityService,
    NetworkEdgeSecurityServiceAggregatedList,
    NetworkEdgeSecurityServicesScopedList,
    NetworkEndpoint,
    NetworkEndpointGroup,
    NetworkEndpointGroupAggregatedList,
    NetworkEndpointGroupAppEngine,
    NetworkEndpointGroupCloudFunction,
    NetworkEndpointGroupCloudRun,
    NetworkEndpointGroupList,
    NetworkEndpointGroupPscData,
    NetworkEndpointGroupsAttachEndpointsRequest,
    NetworkEndpointGroupsDetachEndpointsRequest,
    NetworkEndpointGroupsListEndpointsRequest,
    NetworkEndpointGroupsListNetworkEndpoints,
    NetworkEndpointGroupsScopedList,
    NetworkEndpointWithHealthStatus,
    NetworkInterface,
    NetworkList,
    NetworkPeering,
    NetworkPerformanceConfig,
    NetworkRoutingConfig,
    NetworksAddPeeringRequest,
    NetworksGetEffectiveFirewallsResponse,
    NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    NetworksRemovePeeringRequest,
    NetworksUpdatePeeringRequest,
    NodeGroup,
    NodeGroupAggregatedList,
    NodeGroupAutoscalingPolicy,
    NodeGroupList,
    NodeGroupMaintenanceWindow,
    NodeGroupNode,
    NodeGroupsAddNodesRequest,
    NodeGroupsDeleteNodesRequest,
    NodeGroupsListNodes,
    NodeGroupsScopedList,
    NodeGroupsSetNodeTemplateRequest,
    NodeGroupsSimulateMaintenanceEventRequest,
    NodeTemplate,
    NodeTemplateAggregatedList,
    NodeTemplateList,
    NodeTemplateNodeTypeFlexibility,
    NodeTemplatesScopedList,
    NodeType,
    NodeTypeAggregatedList,
    NodeTypeList,
    NodeTypesScopedList,
    NotificationEndpoint,
    NotificationEndpointGrpcSettings,
    NotificationEndpointList,
    Operation,
    OperationAggregatedList,
    OperationList,
    OperationsScopedList,
    OutlierDetection,
    PacketIntervals,
    PacketMirroring,
    PacketMirroringAggregatedList,
    PacketMirroringFilter,
    PacketMirroringForwardingRuleInfo,
    PacketMirroringList,
    PacketMirroringMirroredResourceInfo,
    PacketMirroringMirroredResourceInfoInstanceInfo,
    PacketMirroringMirroredResourceInfoSubnetInfo,
    PacketMirroringNetworkInfo,
    PacketMirroringsScopedList,
    PatchAutoscalerRequest,
    PatchBackendBucketRequest,
    PatchBackendServiceRequest,
    PatchFirewallPolicyRequest,
    PatchFirewallRequest,
    PatchForwardingRuleRequest,
    PatchGlobalForwardingRuleRequest,
    PatchGlobalPublicDelegatedPrefixeRequest,
    PatchHealthCheckRequest,
    PatchImageRequest,
    PatchInstanceGroupManagerRequest,
    PatchInterconnectAttachmentRequest,
    PatchInterconnectRequest,
    PatchNetworkAttachmentRequest,
    PatchNetworkEdgeSecurityServiceRequest,
    PatchNetworkFirewallPolicyRequest,
    PatchNetworkRequest,
    PatchNodeGroupRequest,
    PatchPacketMirroringRequest,
    PatchPerInstanceConfigsInstanceGroupManagerRequest,
    PatchPerInstanceConfigsRegionInstanceGroupManagerRequest,
    PatchPublicAdvertisedPrefixeRequest,
    PatchPublicDelegatedPrefixeRequest,
    PatchRegionAutoscalerRequest,
    PatchRegionBackendServiceRequest,
    PatchRegionHealthCheckRequest,
    PatchRegionHealthCheckServiceRequest,
    PatchRegionInstanceGroupManagerRequest,
    PatchRegionNetworkFirewallPolicyRequest,
    PatchRegionSecurityPolicyRequest,
    PatchRegionSslPolicyRequest,
    PatchRegionTargetHttpsProxyRequest,
    PatchRegionUrlMapRequest,
    PatchResourcePolicyRequest,
    PatchRouterRequest,
    PatchRuleFirewallPolicyRequest,
    PatchRuleNetworkFirewallPolicyRequest,
    PatchRuleRegionNetworkFirewallPolicyRequest,
    PatchRuleRegionSecurityPolicyRequest,
    PatchRuleSecurityPolicyRequest,
    PatchSecurityPolicyRequest,
    PatchServiceAttachmentRequest,
    PatchSnapshotSettingRequest,
    PatchSslPolicyRequest,
    PatchSubnetworkRequest,
    PatchTargetGrpcProxyRequest,
    PatchTargetHttpProxyRequest,
    PatchTargetHttpsProxyRequest,
    PatchUrlMapRequest,
    PathMatcher,
    PathRule,
    PerInstanceConfig,
    Policy,
    PreconfiguredWafSet,
    PreservedState,
    PreservedStatePreservedDisk,
    PreservedStatePreservedNetworkIp,
    PreservedStatePreservedNetworkIpIpAddress,
    PreviewRouterRequest,
    Project,
    ProjectsDisableXpnResourceRequest,
    ProjectsEnableXpnResourceRequest,
    ProjectsGetXpnResources,
    ProjectsListXpnHostsRequest,
    ProjectsSetDefaultNetworkTierRequest,
    PublicAdvertisedPrefix,
    PublicAdvertisedPrefixList,
    PublicAdvertisedPrefixPublicDelegatedPrefix,
    PublicDelegatedPrefix,
    PublicDelegatedPrefixAggregatedList,
    PublicDelegatedPrefixesScopedList,
    PublicDelegatedPrefixList,
    PublicDelegatedPrefixPublicDelegatedSubPrefix,
    Quota,
    QuotaExceededInfo,
    RawDisk,
    RecreateInstancesInstanceGroupManagerRequest,
    RecreateInstancesRegionInstanceGroupManagerRequest,
    Reference,
    Region,
    RegionAddressesMoveRequest,
    RegionAutoscalerList,
    RegionDisksAddResourcePoliciesRequest,
    RegionDisksRemoveResourcePoliciesRequest,
    RegionDisksResizeRequest,
    RegionDisksStartAsyncReplicationRequest,
    RegionDiskTypeList,
    RegionInstanceGroupList,
    RegionInstanceGroupManagerDeleteInstanceConfigReq,
    RegionInstanceGroupManagerList,
    RegionInstanceGroupManagerPatchInstanceConfigReq,
    RegionInstanceGroupManagersAbandonInstancesRequest,
    RegionInstanceGroupManagersApplyUpdatesRequest,
    RegionInstanceGroupManagersCreateInstancesRequest,
    RegionInstanceGroupManagersDeleteInstancesRequest,
    RegionInstanceGroupManagersListErrorsResponse,
    RegionInstanceGroupManagersListInstanceConfigsResp,
    RegionInstanceGroupManagersListInstancesResponse,
    RegionInstanceGroupManagersRecreateRequest,
    RegionInstanceGroupManagersSetTargetPoolsRequest,
    RegionInstanceGroupManagersSetTemplateRequest,
    RegionInstanceGroupManagerUpdateInstanceConfigReq,
    RegionInstanceGroupsListInstances,
    RegionInstanceGroupsListInstancesRequest,
    RegionInstanceGroupsSetNamedPortsRequest,
    RegionList,
    RegionNetworkEndpointGroupsAttachEndpointsRequest,
    RegionNetworkEndpointGroupsDetachEndpointsRequest,
    RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse,
    RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    RegionSetLabelsRequest,
    RegionSetPolicyRequest,
    RegionTargetHttpsProxiesSetSslCertificatesRequest,
    RegionUrlMapsValidateRequest,
    RemoveAssociationFirewallPolicyRequest,
    RemoveAssociationNetworkFirewallPolicyRequest,
    RemoveAssociationRegionNetworkFirewallPolicyRequest,
    RemoveHealthCheckTargetPoolRequest,
    RemoveInstancesInstanceGroupRequest,
    RemoveInstanceTargetPoolRequest,
    RemovePeeringNetworkRequest,
    RemoveResourcePoliciesDiskRequest,
    RemoveResourcePoliciesInstanceRequest,
    RemoveResourcePoliciesRegionDiskRequest,
    RemoveRuleFirewallPolicyRequest,
    RemoveRuleNetworkFirewallPolicyRequest,
    RemoveRuleRegionNetworkFirewallPolicyRequest,
    RemoveRuleRegionSecurityPolicyRequest,
    RemoveRuleSecurityPolicyRequest,
    RequestMirrorPolicy,
    Reservation,
    ReservationAffinity,
    ReservationAggregatedList,
    ReservationList,
    ReservationsResizeRequest,
    ReservationsScopedList,
    ResetInstanceRequest,
    ResizeDiskRequest,
    ResizeInstanceGroupManagerRequest,
    ResizeRegionDiskRequest,
    ResizeRegionInstanceGroupManagerRequest,
    ResizeReservationRequest,
    ResourceCommitment,
    ResourceGroupReference,
    ResourcePoliciesScopedList,
    ResourcePolicy,
    ResourcePolicyAggregatedList,
    ResourcePolicyDailyCycle,
    ResourcePolicyDiskConsistencyGroupPolicy,
    ResourcePolicyGroupPlacementPolicy,
    ResourcePolicyHourlyCycle,
    ResourcePolicyInstanceSchedulePolicy,
    ResourcePolicyInstanceSchedulePolicySchedule,
    ResourcePolicyList,
    ResourcePolicyResourceStatus,
    ResourcePolicyResourceStatusInstanceSchedulePolicyStatus,
    ResourcePolicySnapshotSchedulePolicy,
    ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
    ResourcePolicySnapshotSchedulePolicySchedule,
    ResourcePolicySnapshotSchedulePolicySnapshotProperties,
    ResourcePolicyWeeklyCycle,
    ResourcePolicyWeeklyCycleDayOfWeek,
    ResourceStatus,
    ResumeInstanceRequest,
    Route,
    RouteAsPath,
    RouteList,
    Router,
    RouterAdvertisedIpRange,
    RouterAggregatedList,
    RouterBgp,
    RouterBgpPeer,
    RouterBgpPeerBfd,
    RouterBgpPeerCustomLearnedIpRange,
    RouterInterface,
    RouterList,
    RouterMd5AuthenticationKey,
    RouterNat,
    RouterNatLogConfig,
    RouterNatRule,
    RouterNatRuleAction,
    RouterNatSubnetworkToNat,
    RoutersPreviewResponse,
    RoutersScopedList,
    RouterStatus,
    RouterStatusBgpPeerStatus,
    RouterStatusNatStatus,
    RouterStatusNatStatusNatRuleStatus,
    RouterStatusResponse,
    Rule,
    SavedAttachedDisk,
    SavedDisk,
    ScalingScheduleStatus,
    Scheduling,
    SchedulingNodeAffinity,
    ScratchDisks,
    Screenshot,
    SecurityPoliciesAggregatedList,
    SecurityPoliciesListPreconfiguredExpressionSetsResponse,
    SecurityPoliciesScopedList,
    SecurityPoliciesWafConfig,
    SecurityPolicy,
    SecurityPolicyAdaptiveProtectionConfig,
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig,
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig,
    SecurityPolicyAdvancedOptionsConfig,
    SecurityPolicyAdvancedOptionsConfigJsonCustomConfig,
    SecurityPolicyDdosProtectionConfig,
    SecurityPolicyList,
    SecurityPolicyRecaptchaOptionsConfig,
    SecurityPolicyReference,
    SecurityPolicyRule,
    SecurityPolicyRuleHttpHeaderAction,
    SecurityPolicyRuleHttpHeaderActionHttpHeaderOption,
    SecurityPolicyRuleMatcher,
    SecurityPolicyRuleMatcherConfig,
    SecurityPolicyRuleNetworkMatcher,
    SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch,
    SecurityPolicyRulePreconfiguredWafConfig,
    SecurityPolicyRulePreconfiguredWafConfigExclusion,
    SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams,
    SecurityPolicyRuleRateLimitOptions,
    SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig,
    SecurityPolicyRuleRateLimitOptionsThreshold,
    SecurityPolicyRuleRedirectOptions,
    SecurityPolicyUserDefinedField,
    SecuritySettings,
    SendDiagnosticInterruptInstanceRequest,
    SendDiagnosticInterruptInstanceResponse,
    SerialPortOutput,
    ServerBinding,
    ServiceAccount,
    ServiceAttachment,
    ServiceAttachmentAggregatedList,
    ServiceAttachmentConnectedEndpoint,
    ServiceAttachmentConsumerProjectLimit,
    ServiceAttachmentList,
    ServiceAttachmentsScopedList,
    SetBackendServiceTargetSslProxyRequest,
    SetBackendServiceTargetTcpProxyRequest,
    SetBackupTargetPoolRequest,
    SetCertificateMapTargetHttpsProxyRequest,
    SetCertificateMapTargetSslProxyRequest,
    SetCommonInstanceMetadataOperationMetadata,
    SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo,
    SetCommonInstanceMetadataProjectRequest,
    SetDefaultNetworkTierProjectRequest,
    SetDeletionProtectionInstanceRequest,
    SetDiskAutoDeleteInstanceRequest,
    SetEdgeSecurityPolicyBackendBucketRequest,
    SetEdgeSecurityPolicyBackendServiceRequest,
    SetIamPolicyBackendBucketRequest,
    SetIamPolicyBackendServiceRequest,
    SetIamPolicyDiskRequest,
    SetIamPolicyFirewallPolicyRequest,
    SetIamPolicyImageRequest,
    SetIamPolicyInstanceRequest,
    SetIamPolicyInstanceTemplateRequest,
    SetIamPolicyLicenseRequest,
    SetIamPolicyMachineImageRequest,
    SetIamPolicyNetworkAttachmentRequest,
    SetIamPolicyNetworkFirewallPolicyRequest,
    SetIamPolicyNodeGroupRequest,
    SetIamPolicyNodeTemplateRequest,
    SetIamPolicyRegionBackendServiceRequest,
    SetIamPolicyRegionDiskRequest,
    SetIamPolicyRegionNetworkFirewallPolicyRequest,
    SetIamPolicyReservationRequest,
    SetIamPolicyResourcePolicyRequest,
    SetIamPolicyServiceAttachmentRequest,
    SetIamPolicySnapshotRequest,
    SetIamPolicySubnetworkRequest,
    SetInstanceTemplateInstanceGroupManagerRequest,
    SetInstanceTemplateRegionInstanceGroupManagerRequest,
    SetLabelsAddressRequest,
    SetLabelsDiskRequest,
    SetLabelsExternalVpnGatewayRequest,
    SetLabelsForwardingRuleRequest,
    SetLabelsGlobalAddressRequest,
    SetLabelsGlobalForwardingRuleRequest,
    SetLabelsImageRequest,
    SetLabelsInstanceRequest,
    SetLabelsInterconnectAttachmentRequest,
    SetLabelsInterconnectRequest,
    SetLabelsRegionDiskRequest,
    SetLabelsSecurityPolicyRequest,
    SetLabelsSnapshotRequest,
    SetLabelsTargetVpnGatewayRequest,
    SetLabelsVpnGatewayRequest,
    SetLabelsVpnTunnelRequest,
    SetMachineResourcesInstanceRequest,
    SetMachineTypeInstanceRequest,
    SetMetadataInstanceRequest,
    SetMinCpuPlatformInstanceRequest,
    SetNamedPortsInstanceGroupRequest,
    SetNamedPortsRegionInstanceGroupRequest,
    SetNameInstanceRequest,
    SetNodeTemplateNodeGroupRequest,
    SetPrivateIpGoogleAccessSubnetworkRequest,
    SetProxyHeaderTargetSslProxyRequest,
    SetProxyHeaderTargetTcpProxyRequest,
    SetQuicOverrideTargetHttpsProxyRequest,
    SetSchedulingInstanceRequest,
    SetSecurityPolicyBackendServiceRequest,
    SetSecurityPolicyInstanceRequest,
    SetSecurityPolicyRegionBackendServiceRequest,
    SetSecurityPolicyTargetInstanceRequest,
    SetSecurityPolicyTargetPoolRequest,
    SetServiceAccountInstanceRequest,
    SetShieldedInstanceIntegrityPolicyInstanceRequest,
    SetSslCertificatesRegionTargetHttpsProxyRequest,
    SetSslCertificatesTargetHttpsProxyRequest,
    SetSslCertificatesTargetSslProxyRequest,
    SetSslPolicyTargetHttpsProxyRequest,
    SetSslPolicyTargetSslProxyRequest,
    SetTagsInstanceRequest,
    SetTargetForwardingRuleRequest,
    SetTargetGlobalForwardingRuleRequest,
    SetTargetPoolsInstanceGroupManagerRequest,
    SetTargetPoolsRegionInstanceGroupManagerRequest,
    SetUrlMapRegionTargetHttpProxyRequest,
    SetUrlMapRegionTargetHttpsProxyRequest,
    SetUrlMapTargetHttpProxyRequest,
    SetUrlMapTargetHttpsProxyRequest,
    SetUsageExportBucketProjectRequest,
    ShareSettings,
    ShareSettingsProjectConfig,
    ShieldedInstanceConfig,
    ShieldedInstanceIdentity,
    ShieldedInstanceIdentityEntry,
    ShieldedInstanceIntegrityPolicy,
    SignedUrlKey,
    SimulateMaintenanceEventInstanceRequest,
    SimulateMaintenanceEventNodeGroupRequest,
    Snapshot,
    SnapshotList,
    SnapshotSettings,
    SnapshotSettingsStorageLocationSettings,
    SnapshotSettingsStorageLocationSettingsStorageLocationPreference,
    SourceDiskEncryptionKey,
    SourceInstanceParams,
    SourceInstanceProperties,
    SslCertificate,
    SslCertificateAggregatedList,
    SslCertificateList,
    SslCertificateManagedSslCertificate,
    SslCertificateSelfManagedSslCertificate,
    SslCertificatesScopedList,
    SSLHealthCheck,
    SslPoliciesAggregatedList,
    SslPoliciesList,
    SslPoliciesListAvailableFeaturesResponse,
    SslPoliciesScopedList,
    SslPolicy,
    SslPolicyReference,
    StartAsyncReplicationDiskRequest,
    StartAsyncReplicationRegionDiskRequest,
    StartInstanceRequest,
    StartWithEncryptionKeyInstanceRequest,
    StatefulPolicy,
    StatefulPolicyPreservedState,
    StatefulPolicyPreservedStateDiskDevice,
    StatefulPolicyPreservedStateNetworkIp,
    Status,
    StopAsyncReplicationDiskRequest,
    StopAsyncReplicationRegionDiskRequest,
    StopGroupAsyncReplicationDiskRequest,
    StopGroupAsyncReplicationRegionDiskRequest,
    StopInstanceRequest,
    Subnetwork,
    SubnetworkAggregatedList,
    SubnetworkList,
    SubnetworkLogConfig,
    SubnetworkSecondaryRange,
    SubnetworksExpandIpCidrRangeRequest,
    SubnetworksScopedList,
    SubnetworksSetPrivateIpGoogleAccessRequest,
    Subsetting,
    SuspendInstanceRequest,
    SwitchToCustomModeNetworkRequest,
    Tags,
    TargetGrpcProxy,
    TargetGrpcProxyList,
    TargetHttpProxiesScopedList,
    TargetHttpProxy,
    TargetHttpProxyAggregatedList,
    TargetHttpProxyList,
    TargetHttpsProxiesScopedList,
    TargetHttpsProxiesSetCertificateMapRequest,
    TargetHttpsProxiesSetQuicOverrideRequest,
    TargetHttpsProxiesSetSslCertificatesRequest,
    TargetHttpsProxy,
    TargetHttpsProxyAggregatedList,
    TargetHttpsProxyList,
    TargetInstance,
    TargetInstanceAggregatedList,
    TargetInstanceList,
    TargetInstancesScopedList,
    TargetPool,
    TargetPoolAggregatedList,
    TargetPoolInstanceHealth,
    TargetPoolList,
    TargetPoolsAddHealthCheckRequest,
    TargetPoolsAddInstanceRequest,
    TargetPoolsRemoveHealthCheckRequest,
    TargetPoolsRemoveInstanceRequest,
    TargetPoolsScopedList,
    TargetReference,
    TargetSslProxiesSetBackendServiceRequest,
    TargetSslProxiesSetCertificateMapRequest,
    TargetSslProxiesSetProxyHeaderRequest,
    TargetSslProxiesSetSslCertificatesRequest,
    TargetSslProxy,
    TargetSslProxyList,
    TargetTcpProxiesScopedList,
    TargetTcpProxiesSetBackendServiceRequest,
    TargetTcpProxiesSetProxyHeaderRequest,
    TargetTcpProxy,
    TargetTcpProxyAggregatedList,
    TargetTcpProxyList,
    TargetVpnGateway,
    TargetVpnGatewayAggregatedList,
    TargetVpnGatewayList,
    TargetVpnGatewaysScopedList,
    TCPHealthCheck,
    TestFailure,
    TestIamPermissionsBackendBucketRequest,
    TestIamPermissionsBackendServiceRequest,
    TestIamPermissionsDiskRequest,
    TestIamPermissionsExternalVpnGatewayRequest,
    TestIamPermissionsFirewallPolicyRequest,
    TestIamPermissionsImageRequest,
    TestIamPermissionsInstanceRequest,
    TestIamPermissionsInstanceTemplateRequest,
    TestIamPermissionsLicenseCodeRequest,
    TestIamPermissionsLicenseRequest,
    TestIamPermissionsMachineImageRequest,
    TestIamPermissionsNetworkAttachmentRequest,
    TestIamPermissionsNetworkEndpointGroupRequest,
    TestIamPermissionsNetworkFirewallPolicyRequest,
    TestIamPermissionsNodeGroupRequest,
    TestIamPermissionsNodeTemplateRequest,
    TestIamPermissionsPacketMirroringRequest,
    TestIamPermissionsRegionBackendServiceRequest,
    TestIamPermissionsRegionDiskRequest,
    TestIamPermissionsRegionNetworkFirewallPolicyRequest,
    TestIamPermissionsReservationRequest,
    TestIamPermissionsResourcePolicyRequest,
    TestIamPermissionsServiceAttachmentRequest,
    TestIamPermissionsSnapshotRequest,
    TestIamPermissionsSubnetworkRequest,
    TestIamPermissionsVpnGatewayRequest,
    TestPermissionsRequest,
    TestPermissionsResponse,
    Uint128,
    UpcomingMaintenance,
    UpdateAccessConfigInstanceRequest,
    UpdateAutoscalerRequest,
    UpdateBackendBucketRequest,
    UpdateBackendServiceRequest,
    UpdateDiskRequest,
    UpdateDisplayDeviceInstanceRequest,
    UpdateFirewallRequest,
    UpdateHealthCheckRequest,
    UpdateInstanceRequest,
    UpdateNetworkInterfaceInstanceRequest,
    UpdatePeeringNetworkRequest,
    UpdatePerInstanceConfigsInstanceGroupManagerRequest,
    UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest,
    UpdateRegionAutoscalerRequest,
    UpdateRegionBackendServiceRequest,
    UpdateRegionCommitmentRequest,
    UpdateRegionDiskRequest,
    UpdateRegionHealthCheckRequest,
    UpdateRegionUrlMapRequest,
    UpdateReservationRequest,
    UpdateRouterRequest,
    UpdateShieldedInstanceConfigInstanceRequest,
    UpdateUrlMapRequest,
    UrlMap,
    UrlMapList,
    UrlMapReference,
    UrlMapsAggregatedList,
    UrlMapsScopedList,
    UrlMapsValidateRequest,
    UrlMapsValidateResponse,
    UrlMapTest,
    UrlMapTestHeader,
    UrlMapValidationResult,
    UrlRewrite,
    UsableSubnetwork,
    UsableSubnetworksAggregatedList,
    UsableSubnetworkSecondaryRange,
    UsageExportLocation,
    ValidateRegionUrlMapRequest,
    ValidateUrlMapRequest,
    VmEndpointNatMappings,
    VmEndpointNatMappingsInterfaceNatMappings,
    VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings,
    VmEndpointNatMappingsList,
    VpnGateway,
    VpnGatewayAggregatedList,
    VpnGatewayList,
    VpnGatewaysGetStatusResponse,
    VpnGatewaysScopedList,
    VpnGatewayStatus,
    VpnGatewayStatusHighAvailabilityRequirementState,
    VpnGatewayStatusTunnel,
    VpnGatewayStatusVpnConnection,
    VpnGatewayVpnGatewayInterface,
    VpnTunnel,
    VpnTunnelAggregatedList,
    VpnTunnelList,
    VpnTunnelsScopedList,
    WafExpressionSet,
    WafExpressionSetExpression,
    WaitGlobalOperationRequest,
    WaitRegionOperationRequest,
    WaitZoneOperationRequest,
    Warning,
    Warnings,
    WeightedBackendService,
    WithdrawPublicAdvertisedPrefixeRequest,
    WithdrawPublicDelegatedPrefixeRequest,
    XpnHostList,
    XpnResourceId,
    Zone,
    ZoneList,
    ZoneSetLabelsRequest,
    ZoneSetPolicyRequest,
)

__all__ = (
    "AWSV4Signature",
    "AbandonInstancesInstanceGroupManagerRequest",
    "AbandonInstancesRegionInstanceGroupManagerRequest",
    "AcceleratorConfig",
    "AcceleratorType",
    "AcceleratorTypeAggregatedList",
    "AcceleratorTypeList",
    "AcceleratorTypesClient",
    "AcceleratorTypesScopedList",
    "Accelerators",
    "AccessConfig",
    "AddAccessConfigInstanceRequest",
    "AddAssociationFirewallPolicyRequest",
    "AddAssociationNetworkFirewallPolicyRequest",
    "AddAssociationRegionNetworkFirewallPolicyRequest",
    "AddHealthCheckTargetPoolRequest",
    "AddInstanceTargetPoolRequest",
    "AddInstancesInstanceGroupRequest",
    "AddNodesNodeGroupRequest",
    "AddPeeringNetworkRequest",
    "AddResourcePoliciesDiskRequest",
    "AddResourcePoliciesInstanceRequest",
    "AddResourcePoliciesRegionDiskRequest",
    "AddRuleFirewallPolicyRequest",
    "AddRuleNetworkFirewallPolicyRequest",
    "AddRuleRegionNetworkFirewallPolicyRequest",
    "AddRuleRegionSecurityPolicyRequest",
    "AddRuleSecurityPolicyRequest",
    "AddSignedUrlKeyBackendBucketRequest",
    "AddSignedUrlKeyBackendServiceRequest",
    "Address",
    "AddressAggregatedList",
    "AddressList",
    "AddressesClient",
    "AddressesScopedList",
    "AdvancedMachineFeatures",
    "AggregatedListAcceleratorTypesRequest",
    "AggregatedListAddressesRequest",
    "AggregatedListAutoscalersRequest",
    "AggregatedListBackendServicesRequest",
    "AggregatedListDiskTypesRequest",
    "AggregatedListDisksRequest",
    "AggregatedListForwardingRulesRequest",
    "AggregatedListGlobalOperationsRequest",
    "AggregatedListHealthChecksRequest",
    "AggregatedListInstanceGroupManagersRequest",
    "AggregatedListInstanceGroupsRequest",
    "AggregatedListInstanceTemplatesRequest",
    "AggregatedListInstancesRequest",
    "AggregatedListInterconnectAttachmentsRequest",
    "AggregatedListMachineTypesRequest",
    "AggregatedListNetworkAttachmentsRequest",
    "AggregatedListNetworkEdgeSecurityServicesRequest",
    "AggregatedListNetworkEndpointGroupsRequest",
    "AggregatedListNodeGroupsRequest",
    "AggregatedListNodeTemplatesRequest",
    "AggregatedListNodeTypesRequest",
    "AggregatedListPacketMirroringsRequest",
    "AggregatedListPublicDelegatedPrefixesRequest",
    "AggregatedListRegionCommitmentsRequest",
    "AggregatedListReservationsRequest",
    "AggregatedListResourcePoliciesRequest",
    "AggregatedListRoutersRequest",
    "AggregatedListSecurityPoliciesRequest",
    "AggregatedListServiceAttachmentsRequest",
    "AggregatedListSslCertificatesRequest",
    "AggregatedListSslPoliciesRequest",
    "AggregatedListSubnetworksRequest",
    "AggregatedListTargetHttpProxiesRequest",
    "AggregatedListTargetHttpsProxiesRequest",
    "AggregatedListTargetInstancesRequest",
    "AggregatedListTargetPoolsRequest",
    "AggregatedListTargetTcpProxiesRequest",
    "AggregatedListTargetVpnGatewaysRequest",
    "AggregatedListUrlMapsRequest",
    "AggregatedListVpnGatewaysRequest",
    "AggregatedListVpnTunnelsRequest",
    "AliasIpRange",
    "AllocationResourceStatus",
    "AllocationResourceStatusSpecificSKUAllocation",
    "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    "AllocationSpecificSKUAllocationReservedInstanceProperties",
    "AllocationSpecificSKUReservation",
    "Allowed",
    "AnnouncePublicAdvertisedPrefixeRequest",
    "AnnouncePublicDelegatedPrefixeRequest",
    "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
    "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
    "AttachDiskInstanceRequest",
    "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "AttachNetworkEndpointsNetworkEndpointGroupRequest",
    "AttachNetworkEndpointsRegionNetworkEndpointGroupRequest",
    "AttachedDisk",
    "AttachedDiskInitializeParams",
    "AuditConfig",
    "AuditLogConfig",
    "AuthorizationLoggingOptions",
    "Autoscaler",
    "AutoscalerAggregatedList",
    "AutoscalerList",
    "AutoscalerStatusDetails",
    "AutoscalersClient",
    "AutoscalersScopedList",
    "AutoscalingPolicy",
    "AutoscalingPolicyCpuUtilization",
    "AutoscalingPolicyCustomMetricUtilization",
    "AutoscalingPolicyLoadBalancingUtilization",
    "AutoscalingPolicyScaleInControl",
    "AutoscalingPolicyScalingSchedule",
    "Backend",
    "BackendBucket",
    "BackendBucketCdnPolicy",
    "BackendBucketCdnPolicyBypassCacheOnRequestHeader",
    "BackendBucketCdnPolicyCacheKeyPolicy",
    "BackendBucketCdnPolicyNegativeCachingPolicy",
    "BackendBucketList",
    "BackendBucketsClient",
    "BackendService",
    "BackendServiceAggregatedList",
    "BackendServiceCdnPolicy",
    "BackendServiceCdnPolicyBypassCacheOnRequestHeader",
    "BackendServiceCdnPolicyNegativeCachingPolicy",
    "BackendServiceConnectionTrackingPolicy",
    "BackendServiceFailoverPolicy",
    "BackendServiceGroupHealth",
    "BackendServiceIAP",
    "BackendServiceList",
    "BackendServiceListUsable",
    "BackendServiceLocalityLoadBalancingPolicyConfig",
    "BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy",
    "BackendServiceLocalityLoadBalancingPolicyConfigPolicy",
    "BackendServiceLogConfig",
    "BackendServiceReference",
    "BackendServiceUsedBy",
    "BackendServicesClient",
    "BackendServicesScopedList",
    "BfdPacket",
    "BfdStatus",
    "BfdStatusPacketCounts",
    "Binding",
    "BulkInsertDiskRequest",
    "BulkInsertDiskResource",
    "BulkInsertInstanceRequest",
    "BulkInsertInstanceResource",
    "BulkInsertInstanceResourcePerInstanceProperties",
    "BulkInsertOperationStatus",
    "BulkInsertRegionDiskRequest",
    "BulkInsertRegionInstanceRequest",
    "CacheInvalidationRule",
    "CacheKeyPolicy",
    "CircuitBreakers",
    "CloneRulesFirewallPolicyRequest",
    "CloneRulesNetworkFirewallPolicyRequest",
    "CloneRulesRegionNetworkFirewallPolicyRequest",
    "Commitment",
    "CommitmentAggregatedList",
    "CommitmentList",
    "CommitmentsScopedList",
    "Condition",
    "ConfidentialInstanceConfig",
    "ConnectionDraining",
    "ConsistentHashLoadBalancerSettings",
    "ConsistentHashLoadBalancerSettingsHttpCookie",
    "CorsPolicy",
    "CreateInstancesInstanceGroupManagerRequest",
    "CreateInstancesRegionInstanceGroupManagerRequest",
    "CreateSnapshotDiskRequest",
    "CreateSnapshotRegionDiskRequest",
    "CustomerEncryptionKey",
    "CustomerEncryptionKeyProtectedDisk",
    "Data",
    "DeleteAccessConfigInstanceRequest",
    "DeleteAddressRequest",
    "DeleteAutoscalerRequest",
    "DeleteBackendBucketRequest",
    "DeleteBackendServiceRequest",
    "DeleteDiskRequest",
    "DeleteExternalVpnGatewayRequest",
    "DeleteFirewallPolicyRequest",
    "DeleteFirewallRequest",
    "DeleteForwardingRuleRequest",
    "DeleteGlobalAddressRequest",
    "DeleteGlobalForwardingRuleRequest",
    "DeleteGlobalNetworkEndpointGroupRequest",
    "DeleteGlobalOperationRequest",
    "DeleteGlobalOperationResponse",
    "DeleteGlobalOrganizationOperationRequest",
    "DeleteGlobalOrganizationOperationResponse",
    "DeleteGlobalPublicDelegatedPrefixeRequest",
    "DeleteHealthCheckRequest",
    "DeleteImageRequest",
    "DeleteInstanceGroupManagerRequest",
    "DeleteInstanceGroupRequest",
    "DeleteInstanceRequest",
    "DeleteInstanceTemplateRequest",
    "DeleteInstancesInstanceGroupManagerRequest",
    "DeleteInstancesRegionInstanceGroupManagerRequest",
    "DeleteInterconnectAttachmentRequest",
    "DeleteInterconnectRequest",
    "DeleteLicenseRequest",
    "DeleteMachineImageRequest",
    "DeleteNetworkAttachmentRequest",
    "DeleteNetworkEdgeSecurityServiceRequest",
    "DeleteNetworkEndpointGroupRequest",
    "DeleteNetworkFirewallPolicyRequest",
    "DeleteNetworkRequest",
    "DeleteNodeGroupRequest",
    "DeleteNodeTemplateRequest",
    "DeleteNodesNodeGroupRequest",
    "DeletePacketMirroringRequest",
    "DeletePerInstanceConfigsInstanceGroupManagerRequest",
    "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "DeletePublicAdvertisedPrefixeRequest",
    "DeletePublicDelegatedPrefixeRequest",
    "DeleteRegionAutoscalerRequest",
    "DeleteRegionBackendServiceRequest",
    "DeleteRegionDiskRequest",
    "DeleteRegionHealthCheckRequest",
    "DeleteRegionHealthCheckServiceRequest",
    "DeleteRegionInstanceGroupManagerRequest",
    "DeleteRegionInstanceTemplateRequest",
    "DeleteRegionNetworkEndpointGroupRequest",
    "DeleteRegionNetworkFirewallPolicyRequest",
    "DeleteRegionNotificationEndpointRequest",
    "DeleteRegionOperationRequest",
    "DeleteRegionOperationResponse",
    "DeleteRegionSecurityPolicyRequest",
    "DeleteRegionSslCertificateRequest",
    "DeleteRegionSslPolicyRequest",
    "DeleteRegionTargetHttpProxyRequest",
    "DeleteRegionTargetHttpsProxyRequest",
    "DeleteRegionTargetTcpProxyRequest",
    "DeleteRegionUrlMapRequest",
    "DeleteReservationRequest",
    "DeleteResourcePolicyRequest",
    "DeleteRouteRequest",
    "DeleteRouterRequest",
    "DeleteSecurityPolicyRequest",
    "DeleteServiceAttachmentRequest",
    "DeleteSignedUrlKeyBackendBucketRequest",
    "DeleteSignedUrlKeyBackendServiceRequest",
    "DeleteSnapshotRequest",
    "DeleteSslCertificateRequest",
    "DeleteSslPolicyRequest",
    "DeleteSubnetworkRequest",
    "DeleteTargetGrpcProxyRequest",
    "DeleteTargetHttpProxyRequest",
    "DeleteTargetHttpsProxyRequest",
    "DeleteTargetInstanceRequest",
    "DeleteTargetPoolRequest",
    "DeleteTargetSslProxyRequest",
    "DeleteTargetTcpProxyRequest",
    "DeleteTargetVpnGatewayRequest",
    "DeleteUrlMapRequest",
    "DeleteVpnGatewayRequest",
    "DeleteVpnTunnelRequest",
    "DeleteZoneOperationRequest",
    "DeleteZoneOperationResponse",
    "Denied",
    "DeprecateImageRequest",
    "DeprecationStatus",
    "DetachDiskInstanceRequest",
    "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsRegionNetworkEndpointGroupRequest",
    "DisableXpnHostProjectRequest",
    "DisableXpnResourceProjectRequest",
    "Disk",
    "DiskAggregatedList",
    "DiskAsyncReplication",
    "DiskAsyncReplicationList",
    "DiskInstantiationConfig",
    "DiskList",
    "DiskMoveRequest",
    "DiskParams",
    "DiskResourceStatus",
    "DiskResourceStatusAsyncReplicationStatus",
    "DiskType",
    "DiskTypeAggregatedList",
    "DiskTypeList",
    "DiskTypesClient",
    "DiskTypesScopedList",
    "DisksAddResourcePoliciesRequest",
    "DisksClient",
    "DisksRemoveResourcePoliciesRequest",
    "DisksResizeRequest",
    "DisksScopedList",
    "DisksStartAsyncReplicationRequest",
    "DisksStopGroupAsyncReplicationResource",
    "DisplayDevice",
    "DistributionPolicy",
    "DistributionPolicyZoneConfiguration",
    "Duration",
    "EnableXpnHostProjectRequest",
    "EnableXpnResourceProjectRequest",
    "Error",
    "ErrorDetails",
    "ErrorInfo",
    "Errors",
    "ExchangedPeeringRoute",
    "ExchangedPeeringRoutesList",
    "ExpandIpCidrRangeSubnetworkRequest",
    "Expr",
    "ExternalVpnGateway",
    "ExternalVpnGatewayInterface",
    "ExternalVpnGatewayList",
    "ExternalVpnGatewaysClient",
    "FileContentBuffer",
    "Firewall",
    "FirewallList",
    "FirewallLogConfig",
    "FirewallPoliciesClient",
    "FirewallPoliciesListAssociationsResponse",
    "FirewallPolicy",
    "FirewallPolicyAssociation",
    "FirewallPolicyList",
    "FirewallPolicyRule",
    "FirewallPolicyRuleMatcher",
    "FirewallPolicyRuleMatcherLayer4Config",
    "FirewallPolicyRuleSecureTag",
    "FirewallsClient",
    "FixedOrPercent",
    "ForwardingRule",
    "ForwardingRuleAggregatedList",
    "ForwardingRuleList",
    "ForwardingRuleReference",
    "ForwardingRuleServiceDirectoryRegistration",
    "ForwardingRulesClient",
    "ForwardingRulesScopedList",
    "GRPCHealthCheck",
    "GetAcceleratorTypeRequest",
    "GetAddressRequest",
    "GetAssociationFirewallPolicyRequest",
    "GetAssociationNetworkFirewallPolicyRequest",
    "GetAssociationRegionNetworkFirewallPolicyRequest",
    "GetAutoscalerRequest",
    "GetBackendBucketRequest",
    "GetBackendServiceRequest",
    "GetDiagnosticsInterconnectRequest",
    "GetDiskRequest",
    "GetDiskTypeRequest",
    "GetEffectiveFirewallsInstanceRequest",
    "GetEffectiveFirewallsNetworkRequest",
    "GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest",
    "GetExternalVpnGatewayRequest",
    "GetFirewallPolicyRequest",
    "GetFirewallRequest",
    "GetForwardingRuleRequest",
    "GetFromFamilyImageRequest",
    "GetGlobalAddressRequest",
    "GetGlobalForwardingRuleRequest",
    "GetGlobalNetworkEndpointGroupRequest",
    "GetGlobalOperationRequest",
    "GetGlobalOrganizationOperationRequest",
    "GetGlobalPublicDelegatedPrefixeRequest",
    "GetGuestAttributesInstanceRequest",
    "GetHealthBackendServiceRequest",
    "GetHealthCheckRequest",
    "GetHealthRegionBackendServiceRequest",
    "GetHealthTargetPoolRequest",
    "GetIamPolicyBackendBucketRequest",
    "GetIamPolicyBackendServiceRequest",
    "GetIamPolicyDiskRequest",
    "GetIamPolicyFirewallPolicyRequest",
    "GetIamPolicyImageRequest",
    "GetIamPolicyInstanceRequest",
    "GetIamPolicyInstanceTemplateRequest",
    "GetIamPolicyLicenseRequest",
    "GetIamPolicyMachineImageRequest",
    "GetIamPolicyNetworkAttachmentRequest",
    "GetIamPolicyNetworkFirewallPolicyRequest",
    "GetIamPolicyNodeGroupRequest",
    "GetIamPolicyNodeTemplateRequest",
    "GetIamPolicyRegionBackendServiceRequest",
    "GetIamPolicyRegionDiskRequest",
    "GetIamPolicyRegionNetworkFirewallPolicyRequest",
    "GetIamPolicyReservationRequest",
    "GetIamPolicyResourcePolicyRequest",
    "GetIamPolicyServiceAttachmentRequest",
    "GetIamPolicySnapshotRequest",
    "GetIamPolicySubnetworkRequest",
    "GetImageFamilyViewRequest",
    "GetImageRequest",
    "GetInstanceGroupManagerRequest",
    "GetInstanceGroupRequest",
    "GetInstanceRequest",
    "GetInstanceTemplateRequest",
    "GetInterconnectAttachmentRequest",
    "GetInterconnectLocationRequest",
    "GetInterconnectRemoteLocationRequest",
    "GetInterconnectRequest",
    "GetLicenseCodeRequest",
    "GetLicenseRequest",
    "GetMachineImageRequest",
    "GetMachineTypeRequest",
    "GetMacsecConfigInterconnectRequest",
    "GetNatIpInfoRouterRequest",
    "GetNatMappingInfoRoutersRequest",
    "GetNetworkAttachmentRequest",
    "GetNetworkEdgeSecurityServiceRequest",
    "GetNetworkEndpointGroupRequest",
    "GetNetworkFirewallPolicyRequest",
    "GetNetworkRequest",
    "GetNodeGroupRequest",
    "GetNodeTemplateRequest",
    "GetNodeTypeRequest",
    "GetPacketMirroringRequest",
    "GetProjectRequest",
    "GetPublicAdvertisedPrefixeRequest",
    "GetPublicDelegatedPrefixeRequest",
    "GetRegionAutoscalerRequest",
    "GetRegionBackendServiceRequest",
    "GetRegionCommitmentRequest",
    "GetRegionDiskRequest",
    "GetRegionDiskTypeRequest",
    "GetRegionHealthCheckRequest",
    "GetRegionHealthCheckServiceRequest",
    "GetRegionInstanceGroupManagerRequest",
    "GetRegionInstanceGroupRequest",
    "GetRegionInstanceTemplateRequest",
    "GetRegionNetworkEndpointGroupRequest",
    "GetRegionNetworkFirewallPolicyRequest",
    "GetRegionNotificationEndpointRequest",
    "GetRegionOperationRequest",
    "GetRegionRequest",
    "GetRegionSecurityPolicyRequest",
    "GetRegionSslCertificateRequest",
    "GetRegionSslPolicyRequest",
    "GetRegionTargetHttpProxyRequest",
    "GetRegionTargetHttpsProxyRequest",
    "GetRegionTargetTcpProxyRequest",
    "GetRegionUrlMapRequest",
    "GetReservationRequest",
    "GetResourcePolicyRequest",
    "GetRouteRequest",
    "GetRouterRequest",
    "GetRouterStatusRouterRequest",
    "GetRuleFirewallPolicyRequest",
    "GetRuleNetworkFirewallPolicyRequest",
    "GetRuleRegionNetworkFirewallPolicyRequest",
    "GetRuleRegionSecurityPolicyRequest",
    "GetRuleSecurityPolicyRequest",
    "GetScreenshotInstanceRequest",
    "GetSecurityPolicyRequest",
    "GetSerialPortOutputInstanceRequest",
    "GetServiceAttachmentRequest",
    "GetShieldedInstanceIdentityInstanceRequest",
    "GetSnapshotRequest",
    "GetSnapshotSettingRequest",
    "GetSslCertificateRequest",
    "GetSslPolicyRequest",
    "GetStatusVpnGatewayRequest",
    "GetSubnetworkRequest",
    "GetTargetGrpcProxyRequest",
    "GetTargetHttpProxyRequest",
    "GetTargetHttpsProxyRequest",
    "GetTargetInstanceRequest",
    "GetTargetPoolRequest",
    "GetTargetSslProxyRequest",
    "GetTargetTcpProxyRequest",
    "GetTargetVpnGatewayRequest",
    "GetUrlMapRequest",
    "GetVpnGatewayRequest",
    "GetVpnTunnelRequest",
    "GetXpnHostProjectRequest",
    "GetXpnResourcesProjectsRequest",
    "GetZoneOperationRequest",
    "GetZoneRequest",
    "GlobalAddressesClient",
    "GlobalAddressesMoveRequest",
    "GlobalForwardingRulesClient",
    "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    "GlobalNetworkEndpointGroupsClient",
    "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
    "GlobalOperationsClient",
    "GlobalOrganizationOperationsClient",
    "GlobalOrganizationSetPolicyRequest",
    "GlobalPublicDelegatedPrefixesClient",
    "GlobalSetLabelsRequest",
    "GlobalSetPolicyRequest",
    "GuestAttributes",
    "GuestAttributesEntry",
    "GuestAttributesValue",
    "GuestOsFeature",
    "HTTP2HealthCheck",
    "HTTPHealthCheck",
    "HTTPSHealthCheck",
    "HealthCheck",
    "HealthCheckList",
    "HealthCheckLogConfig",
    "HealthCheckReference",
    "HealthCheckService",
    "HealthCheckServiceReference",
    "HealthCheckServicesList",
    "HealthChecksAggregatedList",
    "HealthChecksClient",
    "HealthChecksScopedList",
    "HealthStatus",
    "HealthStatusForNetworkEndpoint",
    "Help",
    "HelpLink",
    "HostRule",
    "HttpFaultAbort",
    "HttpFaultDelay",
    "HttpFaultInjection",
    "HttpHeaderAction",
    "HttpHeaderMatch",
    "HttpHeaderOption",
    "HttpQueryParameterMatch",
    "HttpRedirectAction",
    "HttpRetryPolicy",
    "HttpRouteAction",
    "HttpRouteRule",
    "HttpRouteRuleMatch",
    "Image",
    "ImageFamilyView",
    "ImageFamilyViewsClient",
    "ImageList",
    "ImagesClient",
    "InitialStateConfig",
    "InsertAddressRequest",
    "InsertAutoscalerRequest",
    "InsertBackendBucketRequest",
    "InsertBackendServiceRequest",
    "InsertDiskRequest",
    "InsertExternalVpnGatewayRequest",
    "InsertFirewallPolicyRequest",
    "InsertFirewallRequest",
    "InsertForwardingRuleRequest",
    "InsertGlobalAddressRequest",
    "InsertGlobalForwardingRuleRequest",
    "InsertGlobalNetworkEndpointGroupRequest",
    "InsertGlobalPublicDelegatedPrefixeRequest",
    "InsertHealthCheckRequest",
    "InsertImageRequest",
    "InsertInstanceGroupManagerRequest",
    "InsertInstanceGroupRequest",
    "InsertInstanceRequest",
    "InsertInstanceTemplateRequest",
    "InsertInterconnectAttachmentRequest",
    "InsertInterconnectRequest",
    "InsertLicenseRequest",
    "InsertMachineImageRequest",
    "InsertNetworkAttachmentRequest",
    "InsertNetworkEdgeSecurityServiceRequest",
    "InsertNetworkEndpointGroupRequest",
    "InsertNetworkFirewallPolicyRequest",
    "InsertNetworkRequest",
    "InsertNodeGroupRequest",
    "InsertNodeTemplateRequest",
    "InsertPacketMirroringRequest",
    "InsertPublicAdvertisedPrefixeRequest",
    "InsertPublicDelegatedPrefixeRequest",
    "InsertRegionAutoscalerRequest",
    "InsertRegionBackendServiceRequest",
    "InsertRegionCommitmentRequest",
    "InsertRegionDiskRequest",
    "InsertRegionHealthCheckRequest",
    "InsertRegionHealthCheckServiceRequest",
    "InsertRegionInstanceGroupManagerRequest",
    "InsertRegionInstanceTemplateRequest",
    "InsertRegionNetworkEndpointGroupRequest",
    "InsertRegionNetworkFirewallPolicyRequest",
    "InsertRegionNotificationEndpointRequest",
    "InsertRegionSecurityPolicyRequest",
    "InsertRegionSslCertificateRequest",
    "InsertRegionSslPolicyRequest",
    "InsertRegionTargetHttpProxyRequest",
    "InsertRegionTargetHttpsProxyRequest",
    "InsertRegionTargetTcpProxyRequest",
    "InsertRegionUrlMapRequest",
    "InsertReservationRequest",
    "InsertResourcePolicyRequest",
    "InsertRouteRequest",
    "InsertRouterRequest",
    "InsertSecurityPolicyRequest",
    "InsertServiceAttachmentRequest",
    "InsertSnapshotRequest",
    "InsertSslCertificateRequest",
    "InsertSslPolicyRequest",
    "InsertSubnetworkRequest",
    "InsertTargetGrpcProxyRequest",
    "InsertTargetHttpProxyRequest",
    "InsertTargetHttpsProxyRequest",
    "InsertTargetInstanceRequest",
    "InsertTargetPoolRequest",
    "InsertTargetSslProxyRequest",
    "InsertTargetTcpProxyRequest",
    "InsertTargetVpnGatewayRequest",
    "InsertUrlMapRequest",
    "InsertVpnGatewayRequest",
    "InsertVpnTunnelRequest",
    "Instance",
    "InstanceAggregatedList",
    "InstanceConsumptionData",
    "InstanceConsumptionInfo",
    "InstanceGroup",
    "InstanceGroupAggregatedList",
    "InstanceGroupList",
    "InstanceGroupManager",
    "InstanceGroupManagerActionsSummary",
    "InstanceGroupManagerAggregatedList",
    "InstanceGroupManagerAutoHealingPolicy",
    "InstanceGroupManagerInstanceLifecyclePolicy",
    "InstanceGroupManagerList",
    "InstanceGroupManagerStatus",
    "InstanceGroupManagerStatusStateful",
    "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
    "InstanceGroupManagerStatusVersionTarget",
    "InstanceGroupManagerUpdatePolicy",
    "InstanceGroupManagerVersion",
    "InstanceGroupManagersAbandonInstancesRequest",
    "InstanceGroupManagersApplyUpdatesRequest",
    "InstanceGroupManagersClient",
    "InstanceGroupManagersCreateInstancesRequest",
    "InstanceGroupManagersDeleteInstancesRequest",
    "InstanceGroupManagersDeletePerInstanceConfigsReq",
    "InstanceGroupManagersListErrorsResponse",
    "InstanceGroupManagersListManagedInstancesResponse",
    "InstanceGroupManagersListPerInstanceConfigsResp",
    "InstanceGroupManagersPatchPerInstanceConfigsReq",
    "InstanceGroupManagersRecreateInstancesRequest",
    "InstanceGroupManagersScopedList",
    "InstanceGroupManagersSetInstanceTemplateRequest",
    "InstanceGroupManagersSetTargetPoolsRequest",
    "InstanceGroupManagersUpdatePerInstanceConfigsReq",
    "InstanceGroupsAddInstancesRequest",
    "InstanceGroupsClient",
    "InstanceGroupsListInstances",
    "InstanceGroupsListInstancesRequest",
    "InstanceGroupsRemoveInstancesRequest",
    "InstanceGroupsScopedList",
    "InstanceGroupsSetNamedPortsRequest",
    "InstanceList",
    "InstanceListReferrers",
    "InstanceManagedByIgmError",
    "InstanceManagedByIgmErrorInstanceActionDetails",
    "InstanceManagedByIgmErrorManagedInstanceError",
    "InstanceMoveRequest",
    "InstanceParams",
    "InstanceProperties",
    "InstanceReference",
    "InstanceTemplate",
    "InstanceTemplateAggregatedList",
    "InstanceTemplateList",
    "InstanceTemplatesClient",
    "InstanceTemplatesScopedList",
    "InstanceWithNamedPorts",
    "InstancesAddResourcePoliciesRequest",
    "InstancesBulkInsertOperationMetadata",
    "InstancesClient",
    "InstancesGetEffectiveFirewallsResponse",
    "InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "InstancesRemoveResourcePoliciesRequest",
    "InstancesScopedList",
    "InstancesSetLabelsRequest",
    "InstancesSetMachineResourcesRequest",
    "InstancesSetMachineTypeRequest",
    "InstancesSetMinCpuPlatformRequest",
    "InstancesSetNameRequest",
    "InstancesSetSecurityPolicyRequest",
    "InstancesSetServiceAccountRequest",
    "InstancesStartWithEncryptionKeyRequest",
    "Int64RangeMatch",
    "Interconnect",
    "InterconnectAttachment",
    "InterconnectAttachmentAggregatedList",
    "InterconnectAttachmentConfigurationConstraints",
    "InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange",
    "InterconnectAttachmentList",
    "InterconnectAttachmentPartnerMetadata",
    "InterconnectAttachmentPrivateInfo",
    "InterconnectAttachmentsClient",
    "InterconnectAttachmentsScopedList",
    "InterconnectCircuitInfo",
    "InterconnectDiagnostics",
    "InterconnectDiagnosticsARPEntry",
    "InterconnectDiagnosticsLinkLACPStatus",
    "InterconnectDiagnosticsLinkOpticalPower",
    "InterconnectDiagnosticsLinkStatus",
    "InterconnectDiagnosticsMacsecStatus",
    "InterconnectList",
    "InterconnectLocation",
    "InterconnectLocationList",
    "InterconnectLocationRegionInfo",
    "InterconnectLocationsClient",
    "InterconnectMacsec",
    "InterconnectMacsecConfig",
    "InterconnectMacsecConfigPreSharedKey",
    "InterconnectMacsecPreSharedKey",
    "InterconnectOutageNotification",
    "InterconnectRemoteLocation",
    "InterconnectRemoteLocationConstraints",
    "InterconnectRemoteLocationConstraintsSubnetLengthRange",
    "InterconnectRemoteLocationList",
    "InterconnectRemoteLocationPermittedConnections",
    "InterconnectRemoteLocationsClient",
    "InterconnectsClient",
    "InterconnectsGetDiagnosticsResponse",
    "InterconnectsGetMacsecConfigResponse",
    "InvalidateCacheUrlMapRequest",
    "Items",
    "License",
    "LicenseCode",
    "LicenseCodeLicenseAlias",
    "LicenseCodesClient",
    "LicenseResourceCommitment",
    "LicenseResourceRequirements",
    "LicensesClient",
    "LicensesListResponse",
    "ListAcceleratorTypesRequest",
    "ListAddressesRequest",
    "ListAssociationsFirewallPolicyRequest",
    "ListAutoscalersRequest",
    "ListAvailableFeaturesRegionSslPoliciesRequest",
    "ListAvailableFeaturesSslPoliciesRequest",
    "ListBackendBucketsRequest",
    "ListBackendServicesRequest",
    "ListDiskTypesRequest",
    "ListDisksRequest",
    "ListErrorsInstanceGroupManagersRequest",
    "ListErrorsRegionInstanceGroupManagersRequest",
    "ListExternalVpnGatewaysRequest",
    "ListFirewallPoliciesRequest",
    "ListFirewallsRequest",
    "ListForwardingRulesRequest",
    "ListGlobalAddressesRequest",
    "ListGlobalForwardingRulesRequest",
    "ListGlobalNetworkEndpointGroupsRequest",
    "ListGlobalOperationsRequest",
    "ListGlobalOrganizationOperationsRequest",
    "ListGlobalPublicDelegatedPrefixesRequest",
    "ListHealthChecksRequest",
    "ListImagesRequest",
    "ListInstanceGroupManagersRequest",
    "ListInstanceGroupsRequest",
    "ListInstanceTemplatesRequest",
    "ListInstancesInstanceGroupsRequest",
    "ListInstancesRegionInstanceGroupsRequest",
    "ListInstancesRequest",
    "ListInterconnectAttachmentsRequest",
    "ListInterconnectLocationsRequest",
    "ListInterconnectRemoteLocationsRequest",
    "ListInterconnectsRequest",
    "ListLicensesRequest",
    "ListMachineImagesRequest",
    "ListMachineTypesRequest",
    "ListManagedInstancesInstanceGroupManagersRequest",
    "ListManagedInstancesRegionInstanceGroupManagersRequest",
    "ListNetworkAttachmentsRequest",
    "ListNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsRegionNetworkEndpointGroupsRequest",
    "ListNetworkFirewallPoliciesRequest",
    "ListNetworksRequest",
    "ListNodeGroupsRequest",
    "ListNodeTemplatesRequest",
    "ListNodeTypesRequest",
    "ListNodesNodeGroupsRequest",
    "ListPacketMirroringsRequest",
    "ListPeeringRoutesNetworksRequest",
    "ListPerInstanceConfigsInstanceGroupManagersRequest",
    "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
    "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
    "ListPublicAdvertisedPrefixesRequest",
    "ListPublicDelegatedPrefixesRequest",
    "ListReferrersInstancesRequest",
    "ListRegionAutoscalersRequest",
    "ListRegionBackendServicesRequest",
    "ListRegionCommitmentsRequest",
    "ListRegionDiskTypesRequest",
    "ListRegionDisksRequest",
    "ListRegionHealthCheckServicesRequest",
    "ListRegionHealthChecksRequest",
    "ListRegionInstanceGroupManagersRequest",
    "ListRegionInstanceGroupsRequest",
    "ListRegionInstanceTemplatesRequest",
    "ListRegionNetworkEndpointGroupsRequest",
    "ListRegionNetworkFirewallPoliciesRequest",
    "ListRegionNotificationEndpointsRequest",
    "ListRegionOperationsRequest",
    "ListRegionSecurityPoliciesRequest",
    "ListRegionSslCertificatesRequest",
    "ListRegionSslPoliciesRequest",
    "ListRegionTargetHttpProxiesRequest",
    "ListRegionTargetHttpsProxiesRequest",
    "ListRegionTargetTcpProxiesRequest",
    "ListRegionUrlMapsRequest",
    "ListRegionsRequest",
    "ListReservationsRequest",
    "ListResourcePoliciesRequest",
    "ListRoutersRequest",
    "ListRoutesRequest",
    "ListSecurityPoliciesRequest",
    "ListServiceAttachmentsRequest",
    "ListSnapshotsRequest",
    "ListSslCertificatesRequest",
    "ListSslPoliciesRequest",
    "ListSubnetworksRequest",
    "ListTargetGrpcProxiesRequest",
    "ListTargetHttpProxiesRequest",
    "ListTargetHttpsProxiesRequest",
    "ListTargetInstancesRequest",
    "ListTargetPoolsRequest",
    "ListTargetSslProxiesRequest",
    "ListTargetTcpProxiesRequest",
    "ListTargetVpnGatewaysRequest",
    "ListUrlMapsRequest",
    "ListUsableBackendServicesRequest",
    "ListUsableRegionBackendServicesRequest",
    "ListUsableSubnetworksRequest",
    "ListVpnGatewaysRequest",
    "ListVpnTunnelsRequest",
    "ListXpnHostsProjectsRequest",
    "ListZoneOperationsRequest",
    "ListZonesRequest",
    "LocalDisk",
    "LocalizedMessage",
    "LocationPolicy",
    "LocationPolicyLocation",
    "LocationPolicyLocationConstraints",
    "LogConfig",
    "LogConfigCloudAuditOptions",
    "LogConfigCounterOptions",
    "LogConfigCounterOptionsCustomField",
    "LogConfigDataAccessOptions",
    "MachineImage",
    "MachineImageList",
    "MachineImagesClient",
    "MachineType",
    "MachineTypeAggregatedList",
    "MachineTypeList",
    "MachineTypesClient",
    "MachineTypesScopedList",
    "ManagedInstance",
    "ManagedInstanceInstanceHealth",
    "ManagedInstanceLastAttempt",
    "ManagedInstanceVersion",
    "Metadata",
    "MetadataFilter",
    "MetadataFilterLabelMatch",
    "MoveAddressRequest",
    "MoveDiskProjectRequest",
    "MoveFirewallPolicyRequest",
    "MoveGlobalAddressRequest",
    "MoveInstanceProjectRequest",
    "NamedPort",
    "NatIpInfo",
    "NatIpInfoNatIpInfoMapping",
    "NatIpInfoResponse",
    "Network",
    "NetworkAttachment",
    "NetworkAttachmentAggregatedList",
    "NetworkAttachmentConnectedEndpoint",
    "NetworkAttachmentList",
    "NetworkAttachmentsClient",
    "NetworkAttachmentsScopedList",
    "NetworkEdgeSecurityService",
    "NetworkEdgeSecurityServiceAggregatedList",
    "NetworkEdgeSecurityServicesClient",
    "NetworkEdgeSecurityServicesScopedList",
    "NetworkEndpoint",
    "NetworkEndpointGroup",
    "NetworkEndpointGroupAggregatedList",
    "NetworkEndpointGroupAppEngine",
    "NetworkEndpointGroupCloudFunction",
    "NetworkEndpointGroupCloudRun",
    "NetworkEndpointGroupList",
    "NetworkEndpointGroupPscData",
    "NetworkEndpointGroupsAttachEndpointsRequest",
    "NetworkEndpointGroupsClient",
    "NetworkEndpointGroupsDetachEndpointsRequest",
    "NetworkEndpointGroupsListEndpointsRequest",
    "NetworkEndpointGroupsListNetworkEndpoints",
    "NetworkEndpointGroupsScopedList",
    "NetworkEndpointWithHealthStatus",
    "NetworkFirewallPoliciesClient",
    "NetworkInterface",
    "NetworkList",
    "NetworkPeering",
    "NetworkPerformanceConfig",
    "NetworkRoutingConfig",
    "NetworksAddPeeringRequest",
    "NetworksClient",
    "NetworksGetEffectiveFirewallsResponse",
    "NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "NetworksRemovePeeringRequest",
    "NetworksUpdatePeeringRequest",
    "NodeGroup",
    "NodeGroupAggregatedList",
    "NodeGroupAutoscalingPolicy",
    "NodeGroupList",
    "NodeGroupMaintenanceWindow",
    "NodeGroupNode",
    "NodeGroupsAddNodesRequest",
    "NodeGroupsClient",
    "NodeGroupsDeleteNodesRequest",
    "NodeGroupsListNodes",
    "NodeGroupsScopedList",
    "NodeGroupsSetNodeTemplateRequest",
    "NodeGroupsSimulateMaintenanceEventRequest",
    "NodeTemplate",
    "NodeTemplateAggregatedList",
    "NodeTemplateList",
    "NodeTemplateNodeTypeFlexibility",
    "NodeTemplatesClient",
    "NodeTemplatesScopedList",
    "NodeType",
    "NodeTypeAggregatedList",
    "NodeTypeList",
    "NodeTypesClient",
    "NodeTypesScopedList",
    "NotificationEndpoint",
    "NotificationEndpointGrpcSettings",
    "NotificationEndpointList",
    "Operation",
    "OperationAggregatedList",
    "OperationList",
    "OperationsScopedList",
    "OutlierDetection",
    "PacketIntervals",
    "PacketMirroring",
    "PacketMirroringAggregatedList",
    "PacketMirroringFilter",
    "PacketMirroringForwardingRuleInfo",
    "PacketMirroringList",
    "PacketMirroringMirroredResourceInfo",
    "PacketMirroringMirroredResourceInfoInstanceInfo",
    "PacketMirroringMirroredResourceInfoSubnetInfo",
    "PacketMirroringNetworkInfo",
    "PacketMirroringsClient",
    "PacketMirroringsScopedList",
    "PatchAutoscalerRequest",
    "PatchBackendBucketRequest",
    "PatchBackendServiceRequest",
    "PatchFirewallPolicyRequest",
    "PatchFirewallRequest",
    "PatchForwardingRuleRequest",
    "PatchGlobalForwardingRuleRequest",
    "PatchGlobalPublicDelegatedPrefixeRequest",
    "PatchHealthCheckRequest",
    "PatchImageRequest",
    "PatchInstanceGroupManagerRequest",
    "PatchInterconnectAttachmentRequest",
    "PatchInterconnectRequest",
    "PatchNetworkAttachmentRequest",
    "PatchNetworkEdgeSecurityServiceRequest",
    "PatchNetworkFirewallPolicyRequest",
    "PatchNetworkRequest",
    "PatchNodeGroupRequest",
    "PatchPacketMirroringRequest",
    "PatchPerInstanceConfigsInstanceGroupManagerRequest",
    "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
    "PatchPublicAdvertisedPrefixeRequest",
    "PatchPublicDelegatedPrefixeRequest",
    "PatchRegionAutoscalerRequest",
    "PatchRegionBackendServiceRequest",
    "PatchRegionHealthCheckRequest",
    "PatchRegionHealthCheckServiceRequest",
    "PatchRegionInstanceGroupManagerRequest",
    "PatchRegionNetworkFirewallPolicyRequest",
    "PatchRegionSecurityPolicyRequest",
    "PatchRegionSslPolicyRequest",
    "PatchRegionTargetHttpsProxyRequest",
    "PatchRegionUrlMapRequest",
    "PatchResourcePolicyRequest",
    "PatchRouterRequest",
    "PatchRuleFirewallPolicyRequest",
    "PatchRuleNetworkFirewallPolicyRequest",
    "PatchRuleRegionNetworkFirewallPolicyRequest",
    "PatchRuleRegionSecurityPolicyRequest",
    "PatchRuleSecurityPolicyRequest",
    "PatchSecurityPolicyRequest",
    "PatchServiceAttachmentRequest",
    "PatchSnapshotSettingRequest",
    "PatchSslPolicyRequest",
    "PatchSubnetworkRequest",
    "PatchTargetGrpcProxyRequest",
    "PatchTargetHttpProxyRequest",
    "PatchTargetHttpsProxyRequest",
    "PatchUrlMapRequest",
    "PathMatcher",
    "PathRule",
    "PerInstanceConfig",
    "Policy",
    "PreconfiguredWafSet",
    "PreservedState",
    "PreservedStatePreservedDisk",
    "PreservedStatePreservedNetworkIp",
    "PreservedStatePreservedNetworkIpIpAddress",
    "PreviewRouterRequest",
    "Project",
    "ProjectsClient",
    "ProjectsDisableXpnResourceRequest",
    "ProjectsEnableXpnResourceRequest",
    "ProjectsGetXpnResources",
    "ProjectsListXpnHostsRequest",
    "ProjectsSetDefaultNetworkTierRequest",
    "PublicAdvertisedPrefix",
    "PublicAdvertisedPrefixList",
    "PublicAdvertisedPrefixPublicDelegatedPrefix",
    "PublicAdvertisedPrefixesClient",
    "PublicDelegatedPrefix",
    "PublicDelegatedPrefixAggregatedList",
    "PublicDelegatedPrefixList",
    "PublicDelegatedPrefixPublicDelegatedSubPrefix",
    "PublicDelegatedPrefixesClient",
    "PublicDelegatedPrefixesScopedList",
    "Quota",
    "QuotaExceededInfo",
    "RawDisk",
    "RecreateInstancesInstanceGroupManagerRequest",
    "RecreateInstancesRegionInstanceGroupManagerRequest",
    "Reference",
    "Region",
    "RegionAddressesMoveRequest",
    "RegionAutoscalerList",
    "RegionAutoscalersClient",
    "RegionBackendServicesClient",
    "RegionCommitmentsClient",
    "RegionDiskTypeList",
    "RegionDiskTypesClient",
    "RegionDisksAddResourcePoliciesRequest",
    "RegionDisksClient",
    "RegionDisksRemoveResourcePoliciesRequest",
    "RegionDisksResizeRequest",
    "RegionDisksStartAsyncReplicationRequest",
    "RegionHealthCheckServicesClient",
    "RegionHealthChecksClient",
    "RegionInstanceGroupList",
    "RegionInstanceGroupManagerDeleteInstanceConfigReq",
    "RegionInstanceGroupManagerList",
    "RegionInstanceGroupManagerPatchInstanceConfigReq",
    "RegionInstanceGroupManagerUpdateInstanceConfigReq",
    "RegionInstanceGroupManagersAbandonInstancesRequest",
    "RegionInstanceGroupManagersApplyUpdatesRequest",
    "RegionInstanceGroupManagersClient",
    "RegionInstanceGroupManagersCreateInstancesRequest",
    "RegionInstanceGroupManagersDeleteInstancesRequest",
    "RegionInstanceGroupManagersListErrorsResponse",
    "RegionInstanceGroupManagersListInstanceConfigsResp",
    "RegionInstanceGroupManagersListInstancesResponse",
    "RegionInstanceGroupManagersRecreateRequest",
    "RegionInstanceGroupManagersSetTargetPoolsRequest",
    "RegionInstanceGroupManagersSetTemplateRequest",
    "RegionInstanceGroupsClient",
    "RegionInstanceGroupsListInstances",
    "RegionInstanceGroupsListInstancesRequest",
    "RegionInstanceGroupsSetNamedPortsRequest",
    "RegionInstanceTemplatesClient",
    "RegionInstancesClient",
    "RegionList",
    "RegionNetworkEndpointGroupsAttachEndpointsRequest",
    "RegionNetworkEndpointGroupsClient",
    "RegionNetworkEndpointGroupsDetachEndpointsRequest",
    "RegionNetworkFirewallPoliciesClient",
    "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse",
    "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "RegionNotificationEndpointsClient",
    "RegionOperationsClient",
    "RegionSecurityPoliciesClient",
    "RegionSetLabelsRequest",
    "RegionSetPolicyRequest",
    "RegionSslCertificatesClient",
    "RegionSslPoliciesClient",
    "RegionTargetHttpProxiesClient",
    "RegionTargetHttpsProxiesClient",
    "RegionTargetHttpsProxiesSetSslCertificatesRequest",
    "RegionTargetTcpProxiesClient",
    "RegionUrlMapsClient",
    "RegionUrlMapsValidateRequest",
    "RegionsClient",
    "RemoveAssociationFirewallPolicyRequest",
    "RemoveAssociationNetworkFirewallPolicyRequest",
    "RemoveAssociationRegionNetworkFirewallPolicyRequest",
    "RemoveHealthCheckTargetPoolRequest",
    "RemoveInstanceTargetPoolRequest",
    "RemoveInstancesInstanceGroupRequest",
    "RemovePeeringNetworkRequest",
    "RemoveResourcePoliciesDiskRequest",
    "RemoveResourcePoliciesInstanceRequest",
    "RemoveResourcePoliciesRegionDiskRequest",
    "RemoveRuleFirewallPolicyRequest",
    "RemoveRuleNetworkFirewallPolicyRequest",
    "RemoveRuleRegionNetworkFirewallPolicyRequest",
    "RemoveRuleRegionSecurityPolicyRequest",
    "RemoveRuleSecurityPolicyRequest",
    "RequestMirrorPolicy",
    "Reservation",
    "ReservationAffinity",
    "ReservationAggregatedList",
    "ReservationList",
    "ReservationsClient",
    "ReservationsResizeRequest",
    "ReservationsScopedList",
    "ResetInstanceRequest",
    "ResizeDiskRequest",
    "ResizeInstanceGroupManagerRequest",
    "ResizeRegionDiskRequest",
    "ResizeRegionInstanceGroupManagerRequest",
    "ResizeReservationRequest",
    "ResourceCommitment",
    "ResourceGroupReference",
    "ResourcePoliciesClient",
    "ResourcePoliciesScopedList",
    "ResourcePolicy",
    "ResourcePolicyAggregatedList",
    "ResourcePolicyDailyCycle",
    "ResourcePolicyDiskConsistencyGroupPolicy",
    "ResourcePolicyGroupPlacementPolicy",
    "ResourcePolicyHourlyCycle",
    "ResourcePolicyInstanceSchedulePolicy",
    "ResourcePolicyInstanceSchedulePolicySchedule",
    "ResourcePolicyList",
    "ResourcePolicyResourceStatus",
    "ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
    "ResourcePolicySnapshotSchedulePolicy",
    "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
    "ResourcePolicySnapshotSchedulePolicySchedule",
    "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
    "ResourcePolicyWeeklyCycle",
    "ResourcePolicyWeeklyCycleDayOfWeek",
    "ResourceStatus",
    "ResumeInstanceRequest",
    "Route",
    "RouteAsPath",
    "RouteList",
    "Router",
    "RouterAdvertisedIpRange",
    "RouterAggregatedList",
    "RouterBgp",
    "RouterBgpPeer",
    "RouterBgpPeerBfd",
    "RouterBgpPeerCustomLearnedIpRange",
    "RouterInterface",
    "RouterList",
    "RouterMd5AuthenticationKey",
    "RouterNat",
    "RouterNatLogConfig",
    "RouterNatRule",
    "RouterNatRuleAction",
    "RouterNatSubnetworkToNat",
    "RouterStatus",
    "RouterStatusBgpPeerStatus",
    "RouterStatusNatStatus",
    "RouterStatusNatStatusNatRuleStatus",
    "RouterStatusResponse",
    "RoutersClient",
    "RoutersPreviewResponse",
    "RoutersScopedList",
    "RoutesClient",
    "Rule",
    "SSLHealthCheck",
    "SavedAttachedDisk",
    "SavedDisk",
    "ScalingScheduleStatus",
    "Scheduling",
    "SchedulingNodeAffinity",
    "ScratchDisks",
    "Screenshot",
    "SecurityPoliciesAggregatedList",
    "SecurityPoliciesClient",
    "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
    "SecurityPoliciesScopedList",
    "SecurityPoliciesWafConfig",
    "SecurityPolicy",
    "SecurityPolicyAdaptiveProtectionConfig",
    "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig",
    "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig",
    "SecurityPolicyAdvancedOptionsConfig",
    "SecurityPolicyAdvancedOptionsConfigJsonCustomConfig",
    "SecurityPolicyDdosProtectionConfig",
    "SecurityPolicyList",
    "SecurityPolicyRecaptchaOptionsConfig",
    "SecurityPolicyReference",
    "SecurityPolicyRule",
    "SecurityPolicyRuleHttpHeaderAction",
    "SecurityPolicyRuleHttpHeaderActionHttpHeaderOption",
    "SecurityPolicyRuleMatcher",
    "SecurityPolicyRuleMatcherConfig",
    "SecurityPolicyRuleNetworkMatcher",
    "SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch",
    "SecurityPolicyRulePreconfiguredWafConfig",
    "SecurityPolicyRulePreconfiguredWafConfigExclusion",
    "SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams",
    "SecurityPolicyRuleRateLimitOptions",
    "SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig",
    "SecurityPolicyRuleRateLimitOptionsThreshold",
    "SecurityPolicyRuleRedirectOptions",
    "SecurityPolicyUserDefinedField",
    "SecuritySettings",
    "SendDiagnosticInterruptInstanceRequest",
    "SendDiagnosticInterruptInstanceResponse",
    "SerialPortOutput",
    "ServerBinding",
    "ServiceAccount",
    "ServiceAttachment",
    "ServiceAttachmentAggregatedList",
    "ServiceAttachmentConnectedEndpoint",
    "ServiceAttachmentConsumerProjectLimit",
    "ServiceAttachmentList",
    "ServiceAttachmentsClient",
    "ServiceAttachmentsScopedList",
    "SetBackendServiceTargetSslProxyRequest",
    "SetBackendServiceTargetTcpProxyRequest",
    "SetBackupTargetPoolRequest",
    "SetCertificateMapTargetHttpsProxyRequest",
    "SetCertificateMapTargetSslProxyRequest",
    "SetCommonInstanceMetadataOperationMetadata",
    "SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo",
    "SetCommonInstanceMetadataProjectRequest",
    "SetDefaultNetworkTierProjectRequest",
    "SetDeletionProtectionInstanceRequest",
    "SetDiskAutoDeleteInstanceRequest",
    "SetEdgeSecurityPolicyBackendBucketRequest",
    "SetEdgeSecurityPolicyBackendServiceRequest",
    "SetIamPolicyBackendBucketRequest",
    "SetIamPolicyBackendServiceRequest",
    "SetIamPolicyDiskRequest",
    "SetIamPolicyFirewallPolicyRequest",
    "SetIamPolicyImageRequest",
    "SetIamPolicyInstanceRequest",
    "SetIamPolicyInstanceTemplateRequest",
    "SetIamPolicyLicenseRequest",
    "SetIamPolicyMachineImageRequest",
    "SetIamPolicyNetworkAttachmentRequest",
    "SetIamPolicyNetworkFirewallPolicyRequest",
    "SetIamPolicyNodeGroupRequest",
    "SetIamPolicyNodeTemplateRequest",
    "SetIamPolicyRegionBackendServiceRequest",
    "SetIamPolicyRegionDiskRequest",
    "SetIamPolicyRegionNetworkFirewallPolicyRequest",
    "SetIamPolicyReservationRequest",
    "SetIamPolicyResourcePolicyRequest",
    "SetIamPolicyServiceAttachmentRequest",
    "SetIamPolicySnapshotRequest",
    "SetIamPolicySubnetworkRequest",
    "SetInstanceTemplateInstanceGroupManagerRequest",
    "SetInstanceTemplateRegionInstanceGroupManagerRequest",
    "SetLabelsAddressRequest",
    "SetLabelsDiskRequest",
    "SetLabelsExternalVpnGatewayRequest",
    "SetLabelsForwardingRuleRequest",
    "SetLabelsGlobalAddressRequest",
    "SetLabelsGlobalForwardingRuleRequest",
    "SetLabelsImageRequest",
    "SetLabelsInstanceRequest",
    "SetLabelsInterconnectAttachmentRequest",
    "SetLabelsInterconnectRequest",
    "SetLabelsRegionDiskRequest",
    "SetLabelsSecurityPolicyRequest",
    "SetLabelsSnapshotRequest",
    "SetLabelsTargetVpnGatewayRequest",
    "SetLabelsVpnGatewayRequest",
    "SetLabelsVpnTunnelRequest",
    "SetMachineResourcesInstanceRequest",
    "SetMachineTypeInstanceRequest",
    "SetMetadataInstanceRequest",
    "SetMinCpuPlatformInstanceRequest",
    "SetNameInstanceRequest",
    "SetNamedPortsInstanceGroupRequest",
    "SetNamedPortsRegionInstanceGroupRequest",
    "SetNodeTemplateNodeGroupRequest",
    "SetPrivateIpGoogleAccessSubnetworkRequest",
    "SetProxyHeaderTargetSslProxyRequest",
    "SetProxyHeaderTargetTcpProxyRequest",
    "SetQuicOverrideTargetHttpsProxyRequest",
    "SetSchedulingInstanceRequest",
    "SetSecurityPolicyBackendServiceRequest",
    "SetSecurityPolicyInstanceRequest",
    "SetSecurityPolicyRegionBackendServiceRequest",
    "SetSecurityPolicyTargetInstanceRequest",
    "SetSecurityPolicyTargetPoolRequest",
    "SetServiceAccountInstanceRequest",
    "SetShieldedInstanceIntegrityPolicyInstanceRequest",
    "SetSslCertificatesRegionTargetHttpsProxyRequest",
    "SetSslCertificatesTargetHttpsProxyRequest",
    "SetSslCertificatesTargetSslProxyRequest",
    "SetSslPolicyTargetHttpsProxyRequest",
    "SetSslPolicyTargetSslProxyRequest",
    "SetTagsInstanceRequest",
    "SetTargetForwardingRuleRequest",
    "SetTargetGlobalForwardingRuleRequest",
    "SetTargetPoolsInstanceGroupManagerRequest",
    "SetTargetPoolsRegionInstanceGroupManagerRequest",
    "SetUrlMapRegionTargetHttpProxyRequest",
    "SetUrlMapRegionTargetHttpsProxyRequest",
    "SetUrlMapTargetHttpProxyRequest",
    "SetUrlMapTargetHttpsProxyRequest",
    "SetUsageExportBucketProjectRequest",
    "ShareSettings",
    "ShareSettingsProjectConfig",
    "ShieldedInstanceConfig",
    "ShieldedInstanceIdentity",
    "ShieldedInstanceIdentityEntry",
    "ShieldedInstanceIntegrityPolicy",
    "SignedUrlKey",
    "SimulateMaintenanceEventInstanceRequest",
    "SimulateMaintenanceEventNodeGroupRequest",
    "Snapshot",
    "SnapshotList",
    "SnapshotSettings",
    "SnapshotSettingsServiceClient",
    "SnapshotSettingsStorageLocationSettings",
    "SnapshotSettingsStorageLocationSettingsStorageLocationPreference",
    "SnapshotsClient",
    "SourceDiskEncryptionKey",
    "SourceInstanceParams",
    "SourceInstanceProperties",
    "SslCertificate",
    "SslCertificateAggregatedList",
    "SslCertificateList",
    "SslCertificateManagedSslCertificate",
    "SslCertificateSelfManagedSslCertificate",
    "SslCertificatesClient",
    "SslCertificatesScopedList",
    "SslPoliciesAggregatedList",
    "SslPoliciesClient",
    "SslPoliciesList",
    "SslPoliciesListAvailableFeaturesResponse",
    "SslPoliciesScopedList",
    "SslPolicy",
    "SslPolicyReference",
    "StartAsyncReplicationDiskRequest",
    "StartAsyncReplicationRegionDiskRequest",
    "StartInstanceRequest",
    "StartWithEncryptionKeyInstanceRequest",
    "StatefulPolicy",
    "StatefulPolicyPreservedState",
    "StatefulPolicyPreservedStateDiskDevice",
    "StatefulPolicyPreservedStateNetworkIp",
    "Status",
    "StopAsyncReplicationDiskRequest",
    "StopAsyncReplicationRegionDiskRequest",
    "StopGroupAsyncReplicationDiskRequest",
    "StopGroupAsyncReplicationRegionDiskRequest",
    "StopInstanceRequest",
    "Subnetwork",
    "SubnetworkAggregatedList",
    "SubnetworkList",
    "SubnetworkLogConfig",
    "SubnetworkSecondaryRange",
    "SubnetworksClient",
    "SubnetworksExpandIpCidrRangeRequest",
    "SubnetworksScopedList",
    "SubnetworksSetPrivateIpGoogleAccessRequest",
    "Subsetting",
    "SuspendInstanceRequest",
    "SwitchToCustomModeNetworkRequest",
    "TCPHealthCheck",
    "Tags",
    "TargetGrpcProxiesClient",
    "TargetGrpcProxy",
    "TargetGrpcProxyList",
    "TargetHttpProxiesClient",
    "TargetHttpProxiesScopedList",
    "TargetHttpProxy",
    "TargetHttpProxyAggregatedList",
    "TargetHttpProxyList",
    "TargetHttpsProxiesClient",
    "TargetHttpsProxiesScopedList",
    "TargetHttpsProxiesSetCertificateMapRequest",
    "TargetHttpsProxiesSetQuicOverrideRequest",
    "TargetHttpsProxiesSetSslCertificatesRequest",
    "TargetHttpsProxy",
    "TargetHttpsProxyAggregatedList",
    "TargetHttpsProxyList",
    "TargetInstance",
    "TargetInstanceAggregatedList",
    "TargetInstanceList",
    "TargetInstancesClient",
    "TargetInstancesScopedList",
    "TargetPool",
    "TargetPoolAggregatedList",
    "TargetPoolInstanceHealth",
    "TargetPoolList",
    "TargetPoolsAddHealthCheckRequest",
    "TargetPoolsAddInstanceRequest",
    "TargetPoolsClient",
    "TargetPoolsRemoveHealthCheckRequest",
    "TargetPoolsRemoveInstanceRequest",
    "TargetPoolsScopedList",
    "TargetReference",
    "TargetSslProxiesClient",
    "TargetSslProxiesSetBackendServiceRequest",
    "TargetSslProxiesSetCertificateMapRequest",
    "TargetSslProxiesSetProxyHeaderRequest",
    "TargetSslProxiesSetSslCertificatesRequest",
    "TargetSslProxy",
    "TargetSslProxyList",
    "TargetTcpProxiesClient",
    "TargetTcpProxiesScopedList",
    "TargetTcpProxiesSetBackendServiceRequest",
    "TargetTcpProxiesSetProxyHeaderRequest",
    "TargetTcpProxy",
    "TargetTcpProxyAggregatedList",
    "TargetTcpProxyList",
    "TargetVpnGateway",
    "TargetVpnGatewayAggregatedList",
    "TargetVpnGatewayList",
    "TargetVpnGatewaysClient",
    "TargetVpnGatewaysScopedList",
    "TestFailure",
    "TestIamPermissionsBackendBucketRequest",
    "TestIamPermissionsBackendServiceRequest",
    "TestIamPermissionsDiskRequest",
    "TestIamPermissionsExternalVpnGatewayRequest",
    "TestIamPermissionsFirewallPolicyRequest",
    "TestIamPermissionsImageRequest",
    "TestIamPermissionsInstanceRequest",
    "TestIamPermissionsInstanceTemplateRequest",
    "TestIamPermissionsLicenseCodeRequest",
    "TestIamPermissionsLicenseRequest",
    "TestIamPermissionsMachineImageRequest",
    "TestIamPermissionsNetworkAttachmentRequest",
    "TestIamPermissionsNetworkEndpointGroupRequest",
    "TestIamPermissionsNetworkFirewallPolicyRequest",
    "TestIamPermissionsNodeGroupRequest",
    "TestIamPermissionsNodeTemplateRequest",
    "TestIamPermissionsPacketMirroringRequest",
    "TestIamPermissionsRegionBackendServiceRequest",
    "TestIamPermissionsRegionDiskRequest",
    "TestIamPermissionsRegionNetworkFirewallPolicyRequest",
    "TestIamPermissionsReservationRequest",
    "TestIamPermissionsResourcePolicyRequest",
    "TestIamPermissionsServiceAttachmentRequest",
    "TestIamPermissionsSnapshotRequest",
    "TestIamPermissionsSubnetworkRequest",
    "TestIamPermissionsVpnGatewayRequest",
    "TestPermissionsRequest",
    "TestPermissionsResponse",
    "Uint128",
    "UpcomingMaintenance",
    "UpdateAccessConfigInstanceRequest",
    "UpdateAutoscalerRequest",
    "UpdateBackendBucketRequest",
    "UpdateBackendServiceRequest",
    "UpdateDiskRequest",
    "UpdateDisplayDeviceInstanceRequest",
    "UpdateFirewallRequest",
    "UpdateHealthCheckRequest",
    "UpdateInstanceRequest",
    "UpdateNetworkInterfaceInstanceRequest",
    "UpdatePeeringNetworkRequest",
    "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
    "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "UpdateRegionAutoscalerRequest",
    "UpdateRegionBackendServiceRequest",
    "UpdateRegionCommitmentRequest",
    "UpdateRegionDiskRequest",
    "UpdateRegionHealthCheckRequest",
    "UpdateRegionUrlMapRequest",
    "UpdateReservationRequest",
    "UpdateRouterRequest",
    "UpdateShieldedInstanceConfigInstanceRequest",
    "UpdateUrlMapRequest",
    "UrlMap",
    "UrlMapList",
    "UrlMapReference",
    "UrlMapTest",
    "UrlMapTestHeader",
    "UrlMapValidationResult",
    "UrlMapsAggregatedList",
    "UrlMapsClient",
    "UrlMapsScopedList",
    "UrlMapsValidateRequest",
    "UrlMapsValidateResponse",
    "UrlRewrite",
    "UsableSubnetwork",
    "UsableSubnetworkSecondaryRange",
    "UsableSubnetworksAggregatedList",
    "UsageExportLocation",
    "ValidateRegionUrlMapRequest",
    "ValidateUrlMapRequest",
    "VmEndpointNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings",
    "VmEndpointNatMappingsList",
    "VpnGateway",
    "VpnGatewayAggregatedList",
    "VpnGatewayList",
    "VpnGatewayStatus",
    "VpnGatewayStatusHighAvailabilityRequirementState",
    "VpnGatewayStatusTunnel",
    "VpnGatewayStatusVpnConnection",
    "VpnGatewayVpnGatewayInterface",
    "VpnGatewaysClient",
    "VpnGatewaysGetStatusResponse",
    "VpnGatewaysScopedList",
    "VpnTunnel",
    "VpnTunnelAggregatedList",
    "VpnTunnelList",
    "VpnTunnelsClient",
    "VpnTunnelsScopedList",
    "WafExpressionSet",
    "WafExpressionSetExpression",
    "WaitGlobalOperationRequest",
    "WaitRegionOperationRequest",
    "WaitZoneOperationRequest",
    "Warning",
    "Warnings",
    "WeightedBackendService",
    "WithdrawPublicAdvertisedPrefixeRequest",
    "WithdrawPublicDelegatedPrefixeRequest",
    "XpnHostList",
    "XpnResourceId",
    "Zone",
    "ZoneList",
    "ZoneOperationsClient",
    "ZoneSetLabelsRequest",
    "ZoneSetPolicyRequest",
    "ZonesClient",
)
