// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	scheme "github.com/openshift/client-go/config/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ImageTagMirrorSetsGetter has a method to return a ImageTagMirrorSetInterface.
// A group's client should implement this interface.
type ImageTagMirrorSetsGetter interface {
	ImageTagMirrorSets() ImageTagMirrorSetInterface
}

// ImageTagMirrorSetInterface has methods to work with ImageTagMirrorSet resources.
type ImageTagMirrorSetInterface interface {
	Create(ctx context.Context, imageTagMirrorSet *v1.ImageTagMirrorSet, opts metav1.CreateOptions) (*v1.ImageTagMirrorSet, error)
	Update(ctx context.Context, imageTagMirrorSet *v1.ImageTagMirrorSet, opts metav1.UpdateOptions) (*v1.ImageTagMirrorSet, error)
	UpdateStatus(ctx context.Context, imageTagMirrorSet *v1.ImageTagMirrorSet, opts metav1.UpdateOptions) (*v1.ImageTagMirrorSet, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ImageTagMirrorSet, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ImageTagMirrorSetList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ImageTagMirrorSet, err error)
	Apply(ctx context.Context, imageTagMirrorSet *configv1.ImageTagMirrorSetApplyConfiguration, opts metav1.ApplyOptions) (result *v1.ImageTagMirrorSet, err error)
	ApplyStatus(ctx context.Context, imageTagMirrorSet *configv1.ImageTagMirrorSetApplyConfiguration, opts metav1.ApplyOptions) (result *v1.ImageTagMirrorSet, err error)
	ImageTagMirrorSetExpansion
}

// imageTagMirrorSets implements ImageTagMirrorSetInterface
type imageTagMirrorSets struct {
	client rest.Interface
}

// newImageTagMirrorSets returns a ImageTagMirrorSets
func newImageTagMirrorSets(c *ConfigV1Client) *imageTagMirrorSets {
	return &imageTagMirrorSets{
		client: c.RESTClient(),
	}
}

// Get takes name of the imageTagMirrorSet, and returns the corresponding imageTagMirrorSet object, and an error if there is any.
func (c *imageTagMirrorSets) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ImageTagMirrorSet, err error) {
	result = &v1.ImageTagMirrorSet{}
	err = c.client.Get().
		Resource("imagetagmirrorsets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ImageTagMirrorSets that match those selectors.
func (c *imageTagMirrorSets) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ImageTagMirrorSetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ImageTagMirrorSetList{}
	err = c.client.Get().
		Resource("imagetagmirrorsets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested imageTagMirrorSets.
func (c *imageTagMirrorSets) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("imagetagmirrorsets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a imageTagMirrorSet and creates it.  Returns the server's representation of the imageTagMirrorSet, and an error, if there is any.
func (c *imageTagMirrorSets) Create(ctx context.Context, imageTagMirrorSet *v1.ImageTagMirrorSet, opts metav1.CreateOptions) (result *v1.ImageTagMirrorSet, err error) {
	result = &v1.ImageTagMirrorSet{}
	err = c.client.Post().
		Resource("imagetagmirrorsets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(imageTagMirrorSet).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a imageTagMirrorSet and updates it. Returns the server's representation of the imageTagMirrorSet, and an error, if there is any.
func (c *imageTagMirrorSets) Update(ctx context.Context, imageTagMirrorSet *v1.ImageTagMirrorSet, opts metav1.UpdateOptions) (result *v1.ImageTagMirrorSet, err error) {
	result = &v1.ImageTagMirrorSet{}
	err = c.client.Put().
		Resource("imagetagmirrorsets").
		Name(imageTagMirrorSet.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(imageTagMirrorSet).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *imageTagMirrorSets) UpdateStatus(ctx context.Context, imageTagMirrorSet *v1.ImageTagMirrorSet, opts metav1.UpdateOptions) (result *v1.ImageTagMirrorSet, err error) {
	result = &v1.ImageTagMirrorSet{}
	err = c.client.Put().
		Resource("imagetagmirrorsets").
		Name(imageTagMirrorSet.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(imageTagMirrorSet).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the imageTagMirrorSet and deletes it. Returns an error if one occurs.
func (c *imageTagMirrorSets) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("imagetagmirrorsets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *imageTagMirrorSets) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("imagetagmirrorsets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched imageTagMirrorSet.
func (c *imageTagMirrorSets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ImageTagMirrorSet, err error) {
	result = &v1.ImageTagMirrorSet{}
	err = c.client.Patch(pt).
		Resource("imagetagmirrorsets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied imageTagMirrorSet.
func (c *imageTagMirrorSets) Apply(ctx context.Context, imageTagMirrorSet *configv1.ImageTagMirrorSetApplyConfiguration, opts metav1.ApplyOptions) (result *v1.ImageTagMirrorSet, err error) {
	if imageTagMirrorSet == nil {
		return nil, fmt.Errorf("imageTagMirrorSet provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(imageTagMirrorSet)
	if err != nil {
		return nil, err
	}
	name := imageTagMirrorSet.Name
	if name == nil {
		return nil, fmt.Errorf("imageTagMirrorSet.Name must be provided to Apply")
	}
	result = &v1.ImageTagMirrorSet{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("imagetagmirrorsets").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *imageTagMirrorSets) ApplyStatus(ctx context.Context, imageTagMirrorSet *configv1.ImageTagMirrorSetApplyConfiguration, opts metav1.ApplyOptions) (result *v1.ImageTagMirrorSet, err error) {
	if imageTagMirrorSet == nil {
		return nil, fmt.Errorf("imageTagMirrorSet provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(imageTagMirrorSet)
	if err != nil {
		return nil, err
	}

	name := imageTagMirrorSet.Name
	if name == nil {
		return nil, fmt.Errorf("imageTagMirrorSet.Name must be provided to Apply")
	}

	result = &v1.ImageTagMirrorSet{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("imagetagmirrorsets").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
