#ifndef __CONFIG_H
#define __CONFIG_H
#define HLPFILE "sbl.hlp"       /* filename of help screen */
#define VERSION "sbl version 3.5.1"
#define COPYRIGHT "copyright (c) 2000-2009 SuSE Linux Products gmbh, Nuernberg\ncopyright (c) 2010 Skammel Slutions, Marburg"
#define AUTHOR "Author: Marco Skambraks <marco@skammel.de>"
#define USAGE "\n \
  -c --config - config file (default /etc/sbl.conf) \n \
  -a --auth - authkey for brld (default default) \n \
  -p --port - brld port - if port is 0 use brld.sock (default 0) \n \
  -s --speech - speech synth (default none) \n \
  -d --spkdev - device for hardware speech-synths \n \
  -k --kbdport - kbdsniffd port - if 0 kbdsniffd.sock is used (default 0) \n \
  -i --kbdid - ID string for kbdsniffd (default default) \n \
  -l --log - enable debug and log to /tmp/sbl.log \n \
  -h --help - show help \n\n"

#define CONSOLE "/dev/tty0"     /* name of device for simulating keystrokes */
#define VCSADEV "/dev/vcsa"
#define DELAY_TIME 40           /* sleep time per cycle - overall speed */
#define DEVICE_DIRECTORY "/dev"
#define NBR_SCR 16              /* actual number of separate screens */
#define CSRJMP_NICENESS 10      /* niceness of cursor routing subprocess */
#define CSRJMP_TIMEOUT 2000     /* cursor routing idle timeout in ms */
#define CSRJMP_SETTLE_DELAY 400 /* delay to use in csrjmp_sub() loops (ms) */

#define UP_CSR "\033[A"         /* vt100 up-cursor */
#define DN_CSR "\033[B"         /* vt100 down-cursor */
#define LT_CSR "\033[D"         /* vt100 left-cursor */
#define RT_CSR "\033[C"         /* vt100 right-cursor */
#define KEY_RETURN "\r"
#endif
