# RUN: llvm-mc -triple x86_64 -show-encoding %s | FileCheck %s
# RUN: not llvm-mc -triple i386 -show-encoding %s 2>&1 | FileCheck %s --check-prefix=ERROR

# ERROR-COUNT-256: error:
# ERROR-NOT: error:
# CHECK: ctestbb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0xf6,0x44,0x80,0x7b,0x7b]
         ctestbb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestbw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestbw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestbl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestbl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestbq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestbq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestbb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x84,0x5c,0x80,0x7b]
         ctestbb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestbw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x02,0x85,0x54,0x80,0x7b]
         ctestbw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestbl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x02,0x85,0x4c,0x80,0x7b]
         ctestbl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestbq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x02,0x85,0x4c,0x80,0x7b]
         ctestbq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestbb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0xf6,0xc3,0x7b]
         ctestbb {dfv=of} $123, %bl
# CHECK: ctestbw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x02,0xf7,0xc2,0xd2,0x04]
         ctestbw {dfv=of} $1234, %dx
# CHECK: ctestbl {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestbl {dfv=of} $123456, %ecx
# CHECK: ctestbq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x02,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestbq {dfv=of} $123456, %r9
# CHECK: ctestbb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x84,0xda]
         ctestbb {dfv=of} %bl, %dl
# CHECK: ctestbw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x02,0x85,0xd0]
         ctestbw {dfv=of} %dx, %ax
# CHECK: ctestbl {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x02,0x85,0xca]
         ctestbl {dfv=of} %ecx, %edx
# CHECK: ctestbq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x02,0x85,0xcf]
         ctestbq {dfv=of} %r9, %r15
# CHECK: ctestbeb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0xf6,0x44,0x80,0x7b,0x7b]
         ctestbeb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestbew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x06,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestbew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestbel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestbel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestbeq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x06,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestbeq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestbeb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0x84,0x5c,0x80,0x7b]
         ctestbeb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestbew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x06,0x85,0x54,0x80,0x7b]
         ctestbew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestbel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x06,0x85,0x4c,0x80,0x7b]
         ctestbel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestbeq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x06,0x85,0x4c,0x80,0x7b]
         ctestbeq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestbeb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0xf6,0xc3,0x7b]
         ctestbeb {dfv=of} $123, %bl
# CHECK: ctestbew {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x06,0xf7,0xc2,0xd2,0x04]
         ctestbew {dfv=of} $1234, %dx
# CHECK: ctestbel {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestbel {dfv=of} $123456, %ecx
# CHECK: ctestbeq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x06,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestbeq {dfv=of} $123456, %r9
# CHECK: ctestbeb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0x84,0xda]
         ctestbeb {dfv=of} %bl, %dl
# CHECK: ctestbew {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x06,0x85,0xd0]
         ctestbew {dfv=of} %dx, %ax
# CHECK: ctestbel {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x06,0x85,0xca]
         ctestbel {dfv=of} %ecx, %edx
# CHECK: ctestbeq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x06,0x85,0xcf]
         ctestbeq {dfv=of} %r9, %r15
# CHECK: ctestfb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0xf6,0x44,0x80,0x7b,0x7b]
         ctestfb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestfw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestfw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestfl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestfl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestfq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestfq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestfb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x84,0x5c,0x80,0x7b]
         ctestfb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestfw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0b,0x85,0x54,0x80,0x7b]
         ctestfw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestfl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0b,0x85,0x4c,0x80,0x7b]
         ctestfl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestfq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x0b,0x85,0x4c,0x80,0x7b]
         ctestfq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestfb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0xf6,0xc3,0x7b]
         ctestfb {dfv=of} $123, %bl
# CHECK: ctestfw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0b,0xf7,0xc2,0xd2,0x04]
         ctestfw {dfv=of} $1234, %dx
# CHECK: ctestfl {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestfl {dfv=of} $123456, %ecx
# CHECK: ctestfq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x0b,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestfq {dfv=of} $123456, %r9
# CHECK: ctestfb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x84,0xda]
         ctestfb {dfv=of} %bl, %dl
# CHECK: ctestfw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x0b,0x85,0xd0]
         ctestfw {dfv=of} %dx, %ax
# CHECK: ctestfl {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x0b,0x85,0xca]
         ctestfl {dfv=of} %ecx, %edx
# CHECK: ctestfq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x0b,0x85,0xcf]
         ctestfq {dfv=of} %r9, %r15
# CHECK: ctestlb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0xf6,0x44,0x80,0x7b,0x7b]
         ctestlb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestlw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestlw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestll {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestll {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestlq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestlq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestlb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x84,0x5c,0x80,0x7b]
         ctestlb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestlw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0c,0x85,0x54,0x80,0x7b]
         ctestlw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestll {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0c,0x85,0x4c,0x80,0x7b]
         ctestll {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestlq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x0c,0x85,0x4c,0x80,0x7b]
         ctestlq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestlb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0xf6,0xc3,0x7b]
         ctestlb {dfv=of} $123, %bl
# CHECK: ctestlw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0c,0xf7,0xc2,0xd2,0x04]
         ctestlw {dfv=of} $1234, %dx
# CHECK: ctestll {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestll {dfv=of} $123456, %ecx
# CHECK: ctestlq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x0c,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestlq {dfv=of} $123456, %r9
# CHECK: ctestlb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x84,0xda]
         ctestlb {dfv=of} %bl, %dl
# CHECK: ctestlw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x0c,0x85,0xd0]
         ctestlw {dfv=of} %dx, %ax
# CHECK: ctestll {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x0c,0x85,0xca]
         ctestll {dfv=of} %ecx, %edx
# CHECK: ctestlq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x0c,0x85,0xcf]
         ctestlq {dfv=of} %r9, %r15
# CHECK: ctestleb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0xf6,0x44,0x80,0x7b,0x7b]
         ctestleb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestlew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestlew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestlel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestlel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestleq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestleq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestleb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x84,0x5c,0x80,0x7b]
         ctestleb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestlew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0e,0x85,0x54,0x80,0x7b]
         ctestlew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestlel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0e,0x85,0x4c,0x80,0x7b]
         ctestlel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestleq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x0e,0x85,0x4c,0x80,0x7b]
         ctestleq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestleb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0xf6,0xc3,0x7b]
         ctestleb {dfv=of} $123, %bl
# CHECK: ctestlew {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0e,0xf7,0xc2,0xd2,0x04]
         ctestlew {dfv=of} $1234, %dx
# CHECK: ctestlel {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestlel {dfv=of} $123456, %ecx
# CHECK: ctestleq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x0e,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestleq {dfv=of} $123456, %r9
# CHECK: ctestleb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x84,0xda]
         ctestleb {dfv=of} %bl, %dl
# CHECK: ctestlew {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x0e,0x85,0xd0]
         ctestlew {dfv=of} %dx, %ax
# CHECK: ctestlel {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x0e,0x85,0xca]
         ctestlel {dfv=of} %ecx, %edx
# CHECK: ctestleq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x0e,0x85,0xcf]
         ctestleq {dfv=of} %r9, %r15
# CHECK: ctestaeb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0xf6,0x44,0x80,0x7b,0x7b]
         ctestaeb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestaew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestaew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestael {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestael {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestaeq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestaeq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestaeb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x84,0x5c,0x80,0x7b]
         ctestaeb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestaew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x03,0x85,0x54,0x80,0x7b]
         ctestaew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestael {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x03,0x85,0x4c,0x80,0x7b]
         ctestael {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestaeq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x03,0x85,0x4c,0x80,0x7b]
         ctestaeq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestaeb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0xf6,0xc3,0x7b]
         ctestaeb {dfv=of} $123, %bl
# CHECK: ctestaew {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x03,0xf7,0xc2,0xd2,0x04]
         ctestaew {dfv=of} $1234, %dx
# CHECK: ctestael {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestael {dfv=of} $123456, %ecx
# CHECK: ctestaeq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x03,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestaeq {dfv=of} $123456, %r9
# CHECK: ctestaeb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x84,0xda]
         ctestaeb {dfv=of} %bl, %dl
# CHECK: ctestaew {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x03,0x85,0xd0]
         ctestaew {dfv=of} %dx, %ax
# CHECK: ctestael {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x03,0x85,0xca]
         ctestael {dfv=of} %ecx, %edx
# CHECK: ctestaeq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x03,0x85,0xcf]
         ctestaeq {dfv=of} %r9, %r15
# CHECK: ctestab {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0xf6,0x44,0x80,0x7b,0x7b]
         ctestab {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestaw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestaw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestal {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestal {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestaq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestaq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestab {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x84,0x5c,0x80,0x7b]
         ctestab {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestaw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x07,0x85,0x54,0x80,0x7b]
         ctestaw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestal {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x07,0x85,0x4c,0x80,0x7b]
         ctestal {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestaq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x07,0x85,0x4c,0x80,0x7b]
         ctestaq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestab {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0xf6,0xc3,0x7b]
         ctestab {dfv=of} $123, %bl
# CHECK: ctestaw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x07,0xf7,0xc2,0xd2,0x04]
         ctestaw {dfv=of} $1234, %dx
# CHECK: ctestal {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestal {dfv=of} $123456, %ecx
# CHECK: ctestaq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x07,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestaq {dfv=of} $123456, %r9
# CHECK: ctestab {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x84,0xda]
         ctestab {dfv=of} %bl, %dl
# CHECK: ctestaw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x07,0x85,0xd0]
         ctestaw {dfv=of} %dx, %ax
# CHECK: ctestal {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x07,0x85,0xca]
         ctestal {dfv=of} %ecx, %edx
# CHECK: ctestaq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x07,0x85,0xcf]
         ctestaq {dfv=of} %r9, %r15
# CHECK: ctestgeb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0xf6,0x44,0x80,0x7b,0x7b]
         ctestgeb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestgew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestgew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestgel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestgel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestgeq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestgeq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestgeb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x84,0x5c,0x80,0x7b]
         ctestgeb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestgew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0d,0x85,0x54,0x80,0x7b]
         ctestgew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestgel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0d,0x85,0x4c,0x80,0x7b]
         ctestgel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestgeq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x0d,0x85,0x4c,0x80,0x7b]
         ctestgeq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestgeb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0xf6,0xc3,0x7b]
         ctestgeb {dfv=of} $123, %bl
# CHECK: ctestgew {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0d,0xf7,0xc2,0xd2,0x04]
         ctestgew {dfv=of} $1234, %dx
# CHECK: ctestgel {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestgel {dfv=of} $123456, %ecx
# CHECK: ctestgeq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x0d,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestgeq {dfv=of} $123456, %r9
# CHECK: ctestgeb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x84,0xda]
         ctestgeb {dfv=of} %bl, %dl
# CHECK: ctestgew {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x0d,0x85,0xd0]
         ctestgew {dfv=of} %dx, %ax
# CHECK: ctestgel {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x0d,0x85,0xca]
         ctestgel {dfv=of} %ecx, %edx
# CHECK: ctestgeq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x0d,0x85,0xcf]
         ctestgeq {dfv=of} %r9, %r15
# CHECK: ctestgb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0xf6,0x44,0x80,0x7b,0x7b]
         ctestgb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestgw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestgw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestgl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestgl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestgq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestgq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestgb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x84,0x5c,0x80,0x7b]
         ctestgb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestgw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0f,0x85,0x54,0x80,0x7b]
         ctestgw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestgl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0f,0x85,0x4c,0x80,0x7b]
         ctestgl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestgq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x0f,0x85,0x4c,0x80,0x7b]
         ctestgq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestgb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0xf6,0xc3,0x7b]
         ctestgb {dfv=of} $123, %bl
# CHECK: ctestgw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0f,0xf7,0xc2,0xd2,0x04]
         ctestgw {dfv=of} $1234, %dx
# CHECK: ctestgl {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestgl {dfv=of} $123456, %ecx
# CHECK: ctestgq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x0f,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestgq {dfv=of} $123456, %r9
# CHECK: ctestgb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x84,0xda]
         ctestgb {dfv=of} %bl, %dl
# CHECK: ctestgw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x0f,0x85,0xd0]
         ctestgw {dfv=of} %dx, %ax
# CHECK: ctestgl {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x0f,0x85,0xca]
         ctestgl {dfv=of} %ecx, %edx
# CHECK: ctestgq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x0f,0x85,0xcf]
         ctestgq {dfv=of} %r9, %r15
# CHECK: ctestnob {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0xf6,0x44,0x80,0x7b,0x7b]
         ctestnob {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestnow {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestnow {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestnol {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestnol {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestnoq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestnoq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestnob {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x84,0x5c,0x80,0x7b]
         ctestnob {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestnow {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x01,0x85,0x54,0x80,0x7b]
         ctestnow {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestnol {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x01,0x85,0x4c,0x80,0x7b]
         ctestnol {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestnoq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x01,0x85,0x4c,0x80,0x7b]
         ctestnoq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestnob {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0xf6,0xc3,0x7b]
         ctestnob {dfv=of} $123, %bl
# CHECK: ctestnow {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x01,0xf7,0xc2,0xd2,0x04]
         ctestnow {dfv=of} $1234, %dx
# CHECK: ctestnol {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestnol {dfv=of} $123456, %ecx
# CHECK: ctestnoq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x01,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestnoq {dfv=of} $123456, %r9
# CHECK: ctestnob {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x84,0xda]
         ctestnob {dfv=of} %bl, %dl
# CHECK: ctestnow {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x01,0x85,0xd0]
         ctestnow {dfv=of} %dx, %ax
# CHECK: ctestnol {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x01,0x85,0xca]
         ctestnol {dfv=of} %ecx, %edx
# CHECK: ctestnoq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x01,0x85,0xcf]
         ctestnoq {dfv=of} %r9, %r15
# CHECK: ctestnsb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0xf6,0x44,0x80,0x7b,0x7b]
         ctestnsb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestnsw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestnsw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestnsl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestnsl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestnsq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestnsq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestnsb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x84,0x5c,0x80,0x7b]
         ctestnsb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestnsw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x09,0x85,0x54,0x80,0x7b]
         ctestnsw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestnsl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x09,0x85,0x4c,0x80,0x7b]
         ctestnsl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestnsq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x09,0x85,0x4c,0x80,0x7b]
         ctestnsq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestnsb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0xf6,0xc3,0x7b]
         ctestnsb {dfv=of} $123, %bl
# CHECK: ctestnsw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x09,0xf7,0xc2,0xd2,0x04]
         ctestnsw {dfv=of} $1234, %dx
# CHECK: ctestnsl {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestnsl {dfv=of} $123456, %ecx
# CHECK: ctestnsq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x09,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestnsq {dfv=of} $123456, %r9
# CHECK: ctestnsb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x84,0xda]
         ctestnsb {dfv=of} %bl, %dl
# CHECK: ctestnsw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x09,0x85,0xd0]
         ctestnsw {dfv=of} %dx, %ax
# CHECK: ctestnsl {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x09,0x85,0xca]
         ctestnsl {dfv=of} %ecx, %edx
# CHECK: ctestnsq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x09,0x85,0xcf]
         ctestnsq {dfv=of} %r9, %r15
# CHECK: ctestneb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0xf6,0x44,0x80,0x7b,0x7b]
         ctestneb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestnew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestnew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestnel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestnel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestneq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestneq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestneb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x84,0x5c,0x80,0x7b]
         ctestneb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestnew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x05,0x85,0x54,0x80,0x7b]
         ctestnew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestnel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x05,0x85,0x4c,0x80,0x7b]
         ctestnel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestneq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x05,0x85,0x4c,0x80,0x7b]
         ctestneq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestneb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0xf6,0xc3,0x7b]
         ctestneb {dfv=of} $123, %bl
# CHECK: ctestnew {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x05,0xf7,0xc2,0xd2,0x04]
         ctestnew {dfv=of} $1234, %dx
# CHECK: ctestnel {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestnel {dfv=of} $123456, %ecx
# CHECK: ctestneq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x05,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestneq {dfv=of} $123456, %r9
# CHECK: ctestneb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x84,0xda]
         ctestneb {dfv=of} %bl, %dl
# CHECK: ctestnew {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x05,0x85,0xd0]
         ctestnew {dfv=of} %dx, %ax
# CHECK: ctestnel {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x05,0x85,0xca]
         ctestnel {dfv=of} %ecx, %edx
# CHECK: ctestneq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x05,0x85,0xcf]
         ctestneq {dfv=of} %r9, %r15
# CHECK: ctestob {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0xf6,0x44,0x80,0x7b,0x7b]
         ctestob {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestow {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestow {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestol {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestol {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestoq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestoq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestob {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x84,0x5c,0x80,0x7b]
         ctestob {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestow {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x00,0x85,0x54,0x80,0x7b]
         ctestow {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestol {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x00,0x85,0x4c,0x80,0x7b]
         ctestol {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestoq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x00,0x85,0x4c,0x80,0x7b]
         ctestoq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestob {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0xf6,0xc3,0x7b]
         ctestob {dfv=of} $123, %bl
# CHECK: ctestow {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x00,0xf7,0xc2,0xd2,0x04]
         ctestow {dfv=of} $1234, %dx
# CHECK: ctestol {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestol {dfv=of} $123456, %ecx
# CHECK: ctestoq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x00,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestoq {dfv=of} $123456, %r9
# CHECK: ctestob {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x84,0xda]
         ctestob {dfv=of} %bl, %dl
# CHECK: ctestow {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x00,0x85,0xd0]
         ctestow {dfv=of} %dx, %ax
# CHECK: ctestol {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x00,0x85,0xca]
         ctestol {dfv=of} %ecx, %edx
# CHECK: ctestoq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x00,0x85,0xcf]
         ctestoq {dfv=of} %r9, %r15
# CHECK: ctestsb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0xf6,0x44,0x80,0x7b,0x7b]
         ctestsb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestsw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestsw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestsl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestsl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestsq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestsq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctestsb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x84,0x5c,0x80,0x7b]
         ctestsb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestsw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x08,0x85,0x54,0x80,0x7b]
         ctestsw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestsl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x08,0x85,0x4c,0x80,0x7b]
         ctestsl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctestsq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x08,0x85,0x4c,0x80,0x7b]
         ctestsq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctestsb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0xf6,0xc3,0x7b]
         ctestsb {dfv=of} $123, %bl
# CHECK: ctestsw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x08,0xf7,0xc2,0xd2,0x04]
         ctestsw {dfv=of} $1234, %dx
# CHECK: ctestsl {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestsl {dfv=of} $123456, %ecx
# CHECK: ctestsq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x08,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestsq {dfv=of} $123456, %r9
# CHECK: ctestsb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x84,0xda]
         ctestsb {dfv=of} %bl, %dl
# CHECK: ctestsw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x08,0x85,0xd0]
         ctestsw {dfv=of} %dx, %ax
# CHECK: ctestsl {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x08,0x85,0xca]
         ctestsl {dfv=of} %ecx, %edx
# CHECK: ctestsq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x08,0x85,0xcf]
         ctestsq {dfv=of} %r9, %r15
# CHECK: ctesttb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0xf6,0x44,0x80,0x7b,0x7b]
         ctesttb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctesttw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctesttw {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctesttl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctesttl {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctesttq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctesttq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctesttb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x84,0x5c,0x80,0x7b]
         ctesttb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctesttw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x0a,0x85,0x54,0x80,0x7b]
         ctesttw {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctesttl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x0a,0x85,0x4c,0x80,0x7b]
         ctesttl {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctesttq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x0a,0x85,0x4c,0x80,0x7b]
         ctesttq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctesttb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0xf6,0xc3,0x7b]
         ctesttb {dfv=of} $123, %bl
# CHECK: ctesttw {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x0a,0xf7,0xc2,0xd2,0x04]
         ctesttw {dfv=of} $1234, %dx
# CHECK: ctesttl {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctesttl {dfv=of} $123456, %ecx
# CHECK: ctesttq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x0a,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctesttq {dfv=of} $123456, %r9
# CHECK: ctesttb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x84,0xda]
         ctesttb {dfv=of} %bl, %dl
# CHECK: ctesttw {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x0a,0x85,0xd0]
         ctesttw {dfv=of} %dx, %ax
# CHECK: ctesttl {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x0a,0x85,0xca]
         ctesttl {dfv=of} %ecx, %edx
# CHECK: ctesttq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x0a,0x85,0xcf]
         ctesttq {dfv=of} %r9, %r15
# CHECK: ctesteb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0xf6,0x44,0x80,0x7b,0x7b]
         ctesteb {dfv=of} $123, 123(%r8,%rax,4)
# CHECK: ctestew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0xf7,0x44,0x80,0x7b,0xd2,0x04]
         ctestew {dfv=of} $1234, 123(%r8,%rax,4)
# CHECK: ctestel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctestel {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctesteq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0xf7,0x44,0x80,0x7b,0x40,0xe2,0x01,0x00]
         ctesteq {dfv=of} $123456, 123(%r8,%rax,4)
# CHECK: ctesteb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x84,0x5c,0x80,0x7b]
         ctesteb {dfv=of} %bl, 123(%r8,%rax,4)
# CHECK: ctestew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x45,0x04,0x85,0x54,0x80,0x7b]
         ctestew {dfv=of} %dx, 123(%r8,%rax,4)
# CHECK: ctestel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0xd4,0x44,0x04,0x85,0x4c,0x80,0x7b]
         ctestel {dfv=of} %ecx, 123(%r8,%rax,4)
# CHECK: ctesteq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: encoding: [0x62,0x54,0xc4,0x04,0x85,0x4c,0x80,0x7b]
         ctesteq {dfv=of} %r9, 123(%r8,%rax,4)
# CHECK: ctesteb {dfv=of} $123, %bl
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0xf6,0xc3,0x7b]
         ctesteb {dfv=of} $123, %bl
# CHECK: ctestew {dfv=of} $1234, %dx
# CHECK: encoding: [0x62,0xf4,0x45,0x04,0xf7,0xc2,0xd2,0x04]
         ctestew {dfv=of} $1234, %dx
# CHECK: ctestel {dfv=of} $123456, %ecx
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctestel {dfv=of} $123456, %ecx
# CHECK: ctesteq {dfv=of} $123456, %r9
# CHECK: encoding: [0x62,0xd4,0xc4,0x04,0xf7,0xc1,0x40,0xe2,0x01,0x00]
         ctesteq {dfv=of} $123456, %r9
# CHECK: ctesteb {dfv=of} %bl, %dl
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x84,0xda]
         ctesteb {dfv=of} %bl, %dl
# CHECK: ctestew {dfv=of} %dx, %ax
# CHECK: encoding: [0x62,0xf4,0x45,0x04,0x85,0xd0]
         ctestew {dfv=of} %dx, %ax
# CHECK: ctestel {dfv=of} %ecx, %edx
# CHECK: encoding: [0x62,0xf4,0x44,0x04,0x85,0xca]
         ctestel {dfv=of} %ecx, %edx
# CHECK: ctesteq {dfv=of} %r9, %r15
# CHECK: encoding: [0x62,0x54,0xc4,0x04,0x85,0xcf]
         ctesteq {dfv=of} %r9, %r15
