// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Orchestration and serialization glue logic for `UpdateCustomKeyStore`.
#[derive(::std::clone::Clone, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct UpdateCustomKeyStore;
impl UpdateCustomKeyStore {
    /// Creates a new `UpdateCustomKeyStore`
    pub fn new() -> Self {
        Self
    }
    pub(crate) async fn orchestrate(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput,
    ) -> ::std::result::Result<
        crate::operation::update_custom_key_store::UpdateCustomKeyStoreOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_custom_key_store::UpdateCustomKeyStoreError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let map_err = |err: ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >| {
            err.map_service_error(|err| {
                err.downcast::<crate::operation::update_custom_key_store::UpdateCustomKeyStoreError>()
                    .expect("correct error type")
            })
        };
        let context = Self::orchestrate_with_stop_point(runtime_plugins, input, ::aws_smithy_runtime::client::orchestrator::StopPoint::None)
            .await
            .map_err(map_err)?;
        let output = context.finalize().map_err(map_err)?;
        ::std::result::Result::Ok(
            output
                .downcast::<crate::operation::update_custom_key_store::UpdateCustomKeyStoreOutput>()
                .expect("correct output type"),
        )
    }

    pub(crate) async fn orchestrate_with_stop_point(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput,
        stop_point: ::aws_smithy_runtime::client::orchestrator::StopPoint,
    ) -> ::std::result::Result<
        ::aws_smithy_runtime_api::client::interceptors::context::InterceptorContext,
        ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = ::aws_smithy_runtime_api::client::interceptors::context::Input::erase(input);
        ::aws_smithy_runtime::client::orchestrator::invoke_with_stop_point("kms", "UpdateCustomKeyStore", input, runtime_plugins, stop_point).await
    }

    pub(crate) fn operation_runtime_plugins(
        client_runtime_plugins: ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        client_config: &crate::config::Config,
        config_override: ::std::option::Option<crate::config::Builder>,
    ) -> ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins {
        let mut runtime_plugins = client_runtime_plugins.with_operation_plugin(Self::new());
        runtime_plugins = runtime_plugins.with_client_plugin(crate::auth_plugin::DefaultAuthOptionsPlugin::new(vec![
            ::aws_runtime::auth::sigv4::SCHEME_ID,
        ]));
        if let ::std::option::Option::Some(config_override) = config_override {
            for plugin in config_override.runtime_plugins.iter().cloned() {
                runtime_plugins = runtime_plugins.with_operation_plugin(plugin);
            }
            runtime_plugins = runtime_plugins.with_operation_plugin(crate::config::ConfigOverrideRuntimePlugin::new(
                config_override,
                client_config.config.clone(),
                &client_config.runtime_components,
            ));
        }
        runtime_plugins
    }
}
impl ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugin for UpdateCustomKeyStore {
    fn config(&self) -> ::std::option::Option<::aws_smithy_types::config_bag::FrozenLayer> {
        let mut cfg = ::aws_smithy_types::config_bag::Layer::new("UpdateCustomKeyStore");

        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedRequestSerializer::new(
            UpdateCustomKeyStoreRequestSerializer,
        ));
        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedResponseDeserializer::new(
            UpdateCustomKeyStoreResponseDeserializer,
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::auth::AuthSchemeOptionResolverParams::new(
            ::aws_smithy_runtime_api::client::auth::static_resolver::StaticAuthSchemeOptionResolverParams::new(),
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::orchestrator::Metadata::new(
            "UpdateCustomKeyStore",
            "kms",
        ));
        let mut signing_options = ::aws_runtime::auth::SigningOptions::default();
        signing_options.double_uri_encode = true;
        signing_options.content_sha256_header = false;
        signing_options.normalize_uri_path = true;
        signing_options.payload_override = None;

        cfg.store_put(::aws_runtime::auth::SigV4OperationSigningConfig {
            signing_options,
            ..::std::default::Default::default()
        });

        ::std::option::Option::Some(cfg.freeze())
    }

    fn runtime_components(
        &self,
        _: &::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder,
    ) -> ::std::borrow::Cow<'_, ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder> {
        #[allow(unused_mut)]
        let mut rcb = ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder::new("UpdateCustomKeyStore")
            .with_interceptor(
                ::aws_smithy_runtime::client::stalled_stream_protection::StalledStreamProtectionInterceptor::new(
                    ::aws_smithy_runtime::client::stalled_stream_protection::StalledStreamProtectionInterceptorKind::ResponseBody,
                ),
            )
            .with_interceptor(UpdateCustomKeyStoreEndpointParamsInterceptor)
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::TransientErrorClassifier::<
                crate::operation::update_custom_key_store::UpdateCustomKeyStoreError,
            >::new())
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::ModeledAsRetryableClassifier::<
                crate::operation::update_custom_key_store::UpdateCustomKeyStoreError,
            >::new())
            .with_retry_classifier(::aws_runtime::retries::classifiers::AwsErrorCodeClassifier::<
                crate::operation::update_custom_key_store::UpdateCustomKeyStoreError,
            >::new());

        ::std::borrow::Cow::Owned(rcb)
    }
}

#[derive(Debug)]
struct UpdateCustomKeyStoreResponseDeserializer;
impl ::aws_smithy_runtime_api::client::ser_de::DeserializeResponse for UpdateCustomKeyStoreResponseDeserializer {
    fn deserialize_nonstreaming(
        &self,
        response: &::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
    ) -> ::aws_smithy_runtime_api::client::interceptors::context::OutputOrError {
        let (success, status) = (response.status().is_success(), response.status().as_u16());
        let headers = response.headers();
        let body = response.body().bytes().expect("body loaded");
        #[allow(unused_mut)]
        let mut force_error = false;
        ::tracing::debug!(request_id = ?::aws_types::request_id::RequestId::request_id(response));
        let parse_result = if !success && status != 200 || force_error {
            crate::protocol_serde::shape_update_custom_key_store::de_update_custom_key_store_http_error(status, headers, body)
        } else {
            crate::protocol_serde::shape_update_custom_key_store::de_update_custom_key_store_http_response(status, headers, body)
        };
        crate::protocol_serde::type_erase_result(parse_result)
    }
}
#[derive(Debug)]
struct UpdateCustomKeyStoreRequestSerializer;
impl ::aws_smithy_runtime_api::client::ser_de::SerializeRequest for UpdateCustomKeyStoreRequestSerializer {
    #[allow(unused_mut, clippy::let_and_return, clippy::needless_borrow, clippy::useless_conversion)]
    fn serialize_input(
        &self,
        input: ::aws_smithy_runtime_api::client::interceptors::context::Input,
        _cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<::aws_smithy_runtime_api::client::orchestrator::HttpRequest, ::aws_smithy_runtime_api::box_error::BoxError> {
        let input = input
            .downcast::<crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput>()
            .expect("correct type");
        let _header_serialization_settings = _cfg
            .load::<crate::serialization_settings::HeaderSerializationSettings>()
            .cloned()
            .unwrap_or_default();
        let mut request_builder = {
            fn uri_base(
                _input: &crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput,
                output: &mut ::std::string::String,
            ) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::BuildError> {
                use ::std::fmt::Write as _;
                ::std::write!(output, "/").expect("formatting should succeed");
                ::std::result::Result::Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput,
                builder: ::http::request::Builder,
            ) -> ::std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
                let mut uri = ::std::string::String::new();
                uri_base(input, &mut uri)?;
                ::std::result::Result::Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&input, ::http::request::Builder::new())?;
            builder = _header_serialization_settings.set_default_header(builder, ::http::header::CONTENT_TYPE, "application/x-amz-json-1.1");
            builder = _header_serialization_settings.set_default_header(
                builder,
                ::http::header::HeaderName::from_static("x-amz-target"),
                "TrentService.UpdateCustomKeyStore",
            );
            builder
        };
        let body = ::aws_smithy_types::body::SdkBody::from(crate::protocol_serde::shape_update_custom_key_store::ser_update_custom_key_store_input(
            &input,
        )?);
        if let Some(content_length) = body.content_length() {
            let content_length = content_length.to_string();
            request_builder = _header_serialization_settings.set_default_header(request_builder, ::http::header::CONTENT_LENGTH, &content_length);
        }
        ::std::result::Result::Ok(request_builder.body(body).expect("valid request").try_into().unwrap())
    }
}
#[derive(Debug)]
struct UpdateCustomKeyStoreEndpointParamsInterceptor;

impl ::aws_smithy_runtime_api::client::interceptors::Intercept for UpdateCustomKeyStoreEndpointParamsInterceptor {
    fn name(&self) -> &'static str {
        "UpdateCustomKeyStoreEndpointParamsInterceptor"
    }

    fn read_before_execution(
        &self,
        context: &::aws_smithy_runtime_api::client::interceptors::context::BeforeSerializationInterceptorContextRef<
            '_,
            ::aws_smithy_runtime_api::client::interceptors::context::Input,
            ::aws_smithy_runtime_api::client::interceptors::context::Output,
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
        >,
        cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<(), ::aws_smithy_runtime_api::box_error::BoxError> {
        let _input = context
            .input()
            .downcast_ref::<UpdateCustomKeyStoreInput>()
            .ok_or("failed to downcast to UpdateCustomKeyStoreInput")?;

        let params = crate::config::endpoint::Params::builder()
            .set_region(cfg.load::<::aws_types::region::Region>().map(|r| r.as_ref().to_owned()))
            .set_use_dual_stack(cfg.load::<::aws_types::endpoint_config::UseDualStack>().map(|ty| ty.0))
            .set_use_fips(cfg.load::<::aws_types::endpoint_config::UseFips>().map(|ty| ty.0))
            .set_endpoint(cfg.load::<::aws_types::endpoint_config::EndpointUrl>().map(|ty| ty.0.clone()))
            .build()
            .map_err(|err| {
                ::aws_smithy_runtime_api::client::interceptors::error::ContextAttachedError::new("endpoint params could not be built", err)
            })?;
        cfg.interceptor_state()
            .store_put(::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams::new(params));
        ::std::result::Result::Ok(())
    }
}

/// Error type for the `UpdateCustomKeyStoreError` operation.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum UpdateCustomKeyStoreError {
    /// <p>The request was rejected because the associated CloudHSM cluster did not meet the configuration requirements for an CloudHSM key store.</p>
    /// <ul>
    /// <li>
    /// <p>The CloudHSM cluster must be configured with private subnets in at least two different Availability Zones in the Region.</p></li>
    /// <li>
    /// <p>The <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">security group for the cluster</a> (cloudhsm-cluster-<i><cluster-id></cluster-id></i>-sg) must include inbound rules and outbound rules that allow TCP traffic on ports 2223-2225. The <b>Source</b> in the inbound rules and the <b>Destination</b> in the outbound rules must match the security group ID. These rules are set by default when you create the CloudHSM cluster. Do not delete or change them. To get information about a particular security group, use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html">DescribeSecurityGroups</a> operation.</p></li>
    /// <li>
    /// <p>The CloudHSM cluster must contain at least as many HSMs as the operation requires. To add HSMs, use the CloudHSM <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html">CreateHsm</a> operation.</p>
    /// <p>For the <code>CreateCustomKeyStore</code>, <code>UpdateCustomKeyStore</code>, and <code>CreateKey</code> operations, the CloudHSM cluster must have at least two active HSMs, each in a different Availability Zone. For the <code>ConnectCustomKeyStore</code> operation, the CloudHSM must contain at least one active HSM.</p></li>
    /// </ul>
    /// <p>For information about the requirements for an CloudHSM cluster that is associated with an CloudHSM key store, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">Assemble the Prerequisites</a> in the <i>Key Management Service Developer Guide</i>. For information about creating a private subnet for an CloudHSM cluster, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/create-subnets.html">Create a Private Subnet</a> in the <i>CloudHSM User Guide</i>. For information about cluster security groups, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/configure-sg.html">Configure a Default Security Group</a> in the <i> <i>CloudHSM User Guide</i> </i>.</p>
    CloudHsmClusterInvalidConfigurationException(crate::types::error::CloudHsmClusterInvalidConfigurationException),
    /// <p>The request was rejected because the CloudHSM cluster associated with the CloudHSM key store is not active. Initialize and activate the cluster and try the command again. For detailed instructions, see <a href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/getting-started.html">Getting Started</a> in the <i>CloudHSM User Guide</i>.</p>
    CloudHsmClusterNotActiveException(crate::types::error::CloudHsmClusterNotActiveException),
    /// <p>The request was rejected because KMS cannot find the CloudHSM cluster with the specified cluster ID. Retry the request with a different cluster ID.</p>
    CloudHsmClusterNotFoundException(crate::types::error::CloudHsmClusterNotFoundException),
    /// <p>The request was rejected because the specified CloudHSM cluster has a different cluster certificate than the original cluster. You cannot use the operation to specify an unrelated cluster for an CloudHSM key store.</p>
    /// <p>Specify an CloudHSM cluster that shares a backup history with the original cluster. This includes clusters that were created from a backup of the current cluster, and clusters that were created from the same backup that produced the current cluster.</p>
    /// <p>CloudHSM clusters that share a backup history have the same cluster certificate. To view the cluster certificate of an CloudHSM cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    CloudHsmClusterNotRelatedException(crate::types::error::CloudHsmClusterNotRelatedException),
    /// <p>The request was rejected because of the <code>ConnectionState</code> of the custom key store. To get the <code>ConnectionState</code> of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// <p>This exception is thrown under the following conditions:</p>
    /// <ul>
    /// <li>
    /// <p>You requested the <code>ConnectCustomKeyStore</code> operation on a custom key store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or <code>FAILED</code>. This operation is valid for all other <code>ConnectionState</code> values. To reconnect a custom key store in a <code>FAILED</code> state, disconnect it (<code>DisconnectCustomKeyStore</code>), then connect it (<code>ConnectCustomKeyStore</code>).</p></li>
    /// <li>
    /// <p>You requested the <code>CreateKey</code> operation in a custom key store that is not connected. This operations is valid only when the custom key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p></li>
    /// <li>
    /// <p>You requested the <code>DisconnectCustomKeyStore</code> operation on a custom key store with a <code>ConnectionState</code> of <code>DISCONNECTING</code> or <code>DISCONNECTED</code>. This operation is valid for all other <code>ConnectionState</code> values.</p></li>
    /// <li>
    /// <p>You requested the <code>UpdateCustomKeyStore</code> or <code>DeleteCustomKeyStore</code> operation on a custom key store that is not disconnected. This operation is valid only when the custom key store <code>ConnectionState</code> is <code>DISCONNECTED</code>.</p></li>
    /// <li>
    /// <p>You requested the <code>GenerateRandom</code> operation in an CloudHSM key store that is not connected. This operation is valid only when the CloudHSM key store <code>ConnectionState</code> is <code>CONNECTED</code>.</p></li>
    /// </ul>
    CustomKeyStoreInvalidStateException(crate::types::error::CustomKeyStoreInvalidStateException),
    /// <p>The request was rejected because the specified custom key store name is already assigned to another custom key store in the account. Try again with a custom key store name that is unique in the account.</p>
    CustomKeyStoreNameInUseException(crate::types::error::CustomKeyStoreNameInUseException),
    /// <p>The request was rejected because KMS cannot find a custom key store with the specified key store name or ID.</p>
    CustomKeyStoreNotFoundException(crate::types::error::CustomKeyStoreNotFoundException),
    /// <p>The request was rejected because an internal exception occurred. The request can be retried.</p>
    KmsInternalException(crate::types::error::KmsInternalException),
    /// <p>The request was rejected because the proxy credentials failed to authenticate to the specified external key store proxy. The specified external key store proxy rejected a status request from KMS due to invalid credentials. This can indicate an error in the credentials or in the identification of the external key store proxy.</p>
    XksProxyIncorrectAuthenticationCredentialException(crate::types::error::XksProxyIncorrectAuthenticationCredentialException),
    /// <p>The request was rejected because the external key store proxy is not configured correctly. To identify the cause, see the error message that accompanies the exception.</p>
    XksProxyInvalidConfigurationException(crate::types::error::XksProxyInvalidConfigurationException),
    /// <p></p>
    /// <p>KMS cannot interpret the response it received from the external key store proxy. The problem might be a poorly constructed response, but it could also be a transient network issue. If you see this error repeatedly, report it to the proxy vendor.</p>
    XksProxyInvalidResponseException(crate::types::error::XksProxyInvalidResponseException),
    /// <p>The request was rejected because the <code>XksProxyUriEndpoint</code> is already associated with another external key store in this Amazon Web Services Region. To identify the cause, see the error message that accompanies the exception.</p>
    XksProxyUriEndpointInUseException(crate::types::error::XksProxyUriEndpointInUseException),
    /// <p>The request was rejected because the concatenation of the <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> is already associated with another external key store in this Amazon Web Services Region. Each external key store in a Region must use a unique external key store proxy API address.</p>
    XksProxyUriInUseException(crate::types::error::XksProxyUriInUseException),
    /// <p>KMS was unable to reach the specified <code>XksProxyUriPath</code>. The path must be reachable before you create the external key store or update its settings.</p>
    /// <p>This exception is also thrown when the external key store proxy response to a <code>GetHealthStatus</code> request indicates that all external key manager instances are unavailable.</p>
    XksProxyUriUnreachableException(crate::types::error::XksProxyUriUnreachableException),
    /// <p>The request was rejected because the specified Amazon VPC endpoint service is already associated with another external key store in this Amazon Web Services Region. Each external key store in a Region must use a different Amazon VPC endpoint service.</p>
    XksProxyVpcEndpointServiceInUseException(crate::types::error::XksProxyVpcEndpointServiceInUseException),
    /// <p>The request was rejected because the Amazon VPC endpoint service configuration does not fulfill the requirements for an external key store. To identify the cause, see the error message that accompanies the exception and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/vpc-connectivity.html#xks-vpc-requirements">review the requirements</a> for Amazon VPC endpoint service connectivity for an external key store.</p>
    XksProxyVpcEndpointServiceInvalidConfigurationException(crate::types::error::XksProxyVpcEndpointServiceInvalidConfigurationException),
    /// <p>The request was rejected because KMS could not find the specified VPC endpoint service. Use <code>DescribeCustomKeyStores</code> to verify the VPC endpoint service name for the external key store. Also, confirm that the <code>Allow principals</code> list for the VPC endpoint service includes the KMS service principal for the Region, such as <code>cks.kms.us-east-1.amazonaws.com</code>.</p>
    XksProxyVpcEndpointServiceNotFoundException(crate::types::error::XksProxyVpcEndpointServiceNotFoundException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-UpdateCustomKeyStoreError) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl UpdateCustomKeyStoreError {
    /// Creates the `UpdateCustomKeyStoreError::Unhandled` variant from any error type.
    pub fn unhandled(
        err: impl ::std::convert::Into<::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.into(),
            meta: ::std::default::Default::default(),
        })
    }

    /// Creates the `UpdateCustomKeyStoreError::Unhandled` variant from an [`ErrorMetadata`](::aws_smithy_types::error::ErrorMetadata).
    pub fn generic(err: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.clone().into(),
            meta: err,
        })
    }
    ///
    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    ///
    pub fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::CloudHsmClusterInvalidConfigurationException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::CloudHsmClusterNotActiveException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::CloudHsmClusterNotFoundException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::CloudHsmClusterNotRelatedException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::CustomKeyStoreInvalidStateException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::CustomKeyStoreNameInUseException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::CustomKeyStoreNotFoundException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::KmsInternalException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyIncorrectAuthenticationCredentialException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyInvalidConfigurationException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyInvalidResponseException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyUriEndpointInUseException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyUriInUseException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyUriUnreachableException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyVpcEndpointServiceInUseException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyVpcEndpointServiceInvalidConfigurationException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::XksProxyVpcEndpointServiceNotFoundException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::Unhandled(e) => &e.meta,
        }
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::CloudHsmClusterInvalidConfigurationException`.
    pub fn is_cloud_hsm_cluster_invalid_configuration_exception(&self) -> bool {
        matches!(self, Self::CloudHsmClusterInvalidConfigurationException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::CloudHsmClusterNotActiveException`.
    pub fn is_cloud_hsm_cluster_not_active_exception(&self) -> bool {
        matches!(self, Self::CloudHsmClusterNotActiveException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::CloudHsmClusterNotFoundException`.
    pub fn is_cloud_hsm_cluster_not_found_exception(&self) -> bool {
        matches!(self, Self::CloudHsmClusterNotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::CloudHsmClusterNotRelatedException`.
    pub fn is_cloud_hsm_cluster_not_related_exception(&self) -> bool {
        matches!(self, Self::CloudHsmClusterNotRelatedException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::CustomKeyStoreInvalidStateException`.
    pub fn is_custom_key_store_invalid_state_exception(&self) -> bool {
        matches!(self, Self::CustomKeyStoreInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::CustomKeyStoreNameInUseException`.
    pub fn is_custom_key_store_name_in_use_exception(&self) -> bool {
        matches!(self, Self::CustomKeyStoreNameInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::CustomKeyStoreNotFoundException`.
    pub fn is_custom_key_store_not_found_exception(&self) -> bool {
        matches!(self, Self::CustomKeyStoreNotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::KmsInternalException`.
    pub fn is_kms_internal_exception(&self) -> bool {
        matches!(self, Self::KmsInternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyIncorrectAuthenticationCredentialException`.
    pub fn is_xks_proxy_incorrect_authentication_credential_exception(&self) -> bool {
        matches!(self, Self::XksProxyIncorrectAuthenticationCredentialException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyInvalidConfigurationException`.
    pub fn is_xks_proxy_invalid_configuration_exception(&self) -> bool {
        matches!(self, Self::XksProxyInvalidConfigurationException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyInvalidResponseException`.
    pub fn is_xks_proxy_invalid_response_exception(&self) -> bool {
        matches!(self, Self::XksProxyInvalidResponseException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyUriEndpointInUseException`.
    pub fn is_xks_proxy_uri_endpoint_in_use_exception(&self) -> bool {
        matches!(self, Self::XksProxyUriEndpointInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyUriInUseException`.
    pub fn is_xks_proxy_uri_in_use_exception(&self) -> bool {
        matches!(self, Self::XksProxyUriInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyUriUnreachableException`.
    pub fn is_xks_proxy_uri_unreachable_exception(&self) -> bool {
        matches!(self, Self::XksProxyUriUnreachableException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyVpcEndpointServiceInUseException`.
    pub fn is_xks_proxy_vpc_endpoint_service_in_use_exception(&self) -> bool {
        matches!(self, Self::XksProxyVpcEndpointServiceInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyVpcEndpointServiceInvalidConfigurationException`.
    pub fn is_xks_proxy_vpc_endpoint_service_invalid_configuration_exception(&self) -> bool {
        matches!(self, Self::XksProxyVpcEndpointServiceInvalidConfigurationException(_))
    }
    /// Returns `true` if the error kind is `UpdateCustomKeyStoreError::XksProxyVpcEndpointServiceNotFoundException`.
    pub fn is_xks_proxy_vpc_endpoint_service_not_found_exception(&self) -> bool {
        matches!(self, Self::XksProxyVpcEndpointServiceNotFoundException(_))
    }
}
impl ::std::error::Error for UpdateCustomKeyStoreError {
    fn source(&self) -> ::std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Self::CloudHsmClusterInvalidConfigurationException(_inner) => ::std::option::Option::Some(_inner),
            Self::CloudHsmClusterNotActiveException(_inner) => ::std::option::Option::Some(_inner),
            Self::CloudHsmClusterNotFoundException(_inner) => ::std::option::Option::Some(_inner),
            Self::CloudHsmClusterNotRelatedException(_inner) => ::std::option::Option::Some(_inner),
            Self::CustomKeyStoreInvalidStateException(_inner) => ::std::option::Option::Some(_inner),
            Self::CustomKeyStoreNameInUseException(_inner) => ::std::option::Option::Some(_inner),
            Self::CustomKeyStoreNotFoundException(_inner) => ::std::option::Option::Some(_inner),
            Self::KmsInternalException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyIncorrectAuthenticationCredentialException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyInvalidConfigurationException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyInvalidResponseException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyUriEndpointInUseException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyUriInUseException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyUriUnreachableException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyVpcEndpointServiceInUseException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyVpcEndpointServiceInvalidConfigurationException(_inner) => ::std::option::Option::Some(_inner),
            Self::XksProxyVpcEndpointServiceNotFoundException(_inner) => ::std::option::Option::Some(_inner),
            Self::Unhandled(_inner) => ::std::option::Option::Some(&*_inner.source),
        }
    }
}
impl ::std::fmt::Display for UpdateCustomKeyStoreError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            Self::CloudHsmClusterInvalidConfigurationException(_inner) => _inner.fmt(f),
            Self::CloudHsmClusterNotActiveException(_inner) => _inner.fmt(f),
            Self::CloudHsmClusterNotFoundException(_inner) => _inner.fmt(f),
            Self::CloudHsmClusterNotRelatedException(_inner) => _inner.fmt(f),
            Self::CustomKeyStoreInvalidStateException(_inner) => _inner.fmt(f),
            Self::CustomKeyStoreNameInUseException(_inner) => _inner.fmt(f),
            Self::CustomKeyStoreNotFoundException(_inner) => _inner.fmt(f),
            Self::KmsInternalException(_inner) => _inner.fmt(f),
            Self::XksProxyIncorrectAuthenticationCredentialException(_inner) => _inner.fmt(f),
            Self::XksProxyInvalidConfigurationException(_inner) => _inner.fmt(f),
            Self::XksProxyInvalidResponseException(_inner) => _inner.fmt(f),
            Self::XksProxyUriEndpointInUseException(_inner) => _inner.fmt(f),
            Self::XksProxyUriInUseException(_inner) => _inner.fmt(f),
            Self::XksProxyUriUnreachableException(_inner) => _inner.fmt(f),
            Self::XksProxyVpcEndpointServiceInUseException(_inner) => _inner.fmt(f),
            Self::XksProxyVpcEndpointServiceInvalidConfigurationException(_inner) => _inner.fmt(f),
            Self::XksProxyVpcEndpointServiceNotFoundException(_inner) => _inner.fmt(f),
            Self::Unhandled(_inner) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl ::aws_smithy_types::retry::ProvideErrorKind for UpdateCustomKeyStoreError {
    fn code(&self) -> ::std::option::Option<&str> {
        ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self)
    }
    fn retryable_error_kind(&self) -> ::std::option::Option<::aws_smithy_types::retry::ErrorKind> {
        ::std::option::Option::None
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for UpdateCustomKeyStoreError {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::CloudHsmClusterInvalidConfigurationException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::CloudHsmClusterNotActiveException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::CloudHsmClusterNotFoundException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::CloudHsmClusterNotRelatedException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::CustomKeyStoreInvalidStateException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::CustomKeyStoreNameInUseException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::CustomKeyStoreNotFoundException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::KmsInternalException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::XksProxyIncorrectAuthenticationCredentialException(_inner) => {
                ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner)
            }
            Self::XksProxyInvalidConfigurationException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::XksProxyInvalidResponseException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::XksProxyUriEndpointInUseException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::XksProxyUriInUseException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::XksProxyUriUnreachableException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::XksProxyVpcEndpointServiceInUseException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::XksProxyVpcEndpointServiceInvalidConfigurationException(_inner) => {
                ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner)
            }
            Self::XksProxyVpcEndpointServiceNotFoundException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::Unhandled(_inner) => &_inner.meta,
        }
    }
}
impl ::aws_smithy_runtime_api::client::result::CreateUnhandledError for UpdateCustomKeyStoreError {
    fn create_unhandled_error(
        source: ::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>,
        meta: ::std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source,
            meta: meta.unwrap_or_default(),
        })
    }
}
impl ::aws_types::request_id::RequestId for crate::operation::update_custom_key_store::UpdateCustomKeyStoreError {
    fn request_id(&self) -> Option<&str> {
        self.meta().request_id()
    }
}

pub use crate::operation::update_custom_key_store::_update_custom_key_store_output::UpdateCustomKeyStoreOutput;

pub use crate::operation::update_custom_key_store::_update_custom_key_store_input::UpdateCustomKeyStoreInput;

mod _update_custom_key_store_input;

mod _update_custom_key_store_output;

/// Builders
pub mod builders;
