// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutKeyPolicy`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_id(impl Into<String>)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::set_key_id):<br>required: **true**<br><p>Sets the key policy on the specified KMS key.</p> <p>Specify the key ID or key ARN of the KMS key.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p><br>
    ///   - [`policy_name(impl Into<String>)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::policy_name) / [`set_policy_name(Option<String>)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::set_policy_name):<br>required: **false**<br><p>The name of the key policy. If no policy name is specified, the default value is <code>default</code>. The only valid value is <code>default</code>.</p><br>
    ///   - [`policy(impl Into<String>)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::policy) / [`set_policy(Option<String>)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::set_policy):<br>required: **true**<br><p>The key policy to attach to the KMS key.</p> <p>The key policy must meet the following criteria:</p> <ul>  <li>   <p>The key policy must allow the calling principal to make a subsequent <code>PutKeyPolicy</code> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key">Default key policy</a> in the <i>Key Management Service Developer Guide</i>. (To omit this condition, set <code>BypassPolicyLockoutSafetyCheck</code> to true.)</p></li>  <li>   <p>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal, you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p></li> </ul> <p>A key policy document can include only the following characters:</p> <ul>  <li>   <p>Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII character range.</p></li>  <li>   <p>Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>).</p></li>  <li>   <p>The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) special characters</p></li> </ul> <p>For information about key policies, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in the <i>Key Management Service Developer Guide</i>.For help writing and formatting a JSON policy document, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.</p><br>
    ///   - [`bypass_policy_lockout_safety_check(bool)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::bypass_policy_lockout_safety_check) / [`set_bypass_policy_lockout_safety_check(Option<bool>)`](crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::set_bypass_policy_lockout_safety_check):<br>required: **false**<br><p>Skips ("bypasses") the key policy lockout safety check. The default value is false.</p><important>  <p>Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key">Default key policy</a> in the <i>Key Management Service Developer Guide</i>.</p> </important> <p>Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key.</p><br>
    /// - On success, responds with [`PutKeyPolicyOutput`](crate::operation::put_key_policy::PutKeyPolicyOutput)
    /// - On failure, responds with [`SdkError<PutKeyPolicyError>`](crate::operation::put_key_policy::PutKeyPolicyError)
    pub fn put_key_policy(&self) -> crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder {
        crate::operation::put_key_policy::builders::PutKeyPolicyFluentBuilder::new(self.handle.clone())
    }
}
