// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package savingsplans

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateSavingsPlan = "CreateSavingsPlan"

// CreateSavingsPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateSavingsPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSavingsPlan for more information on using the CreateSavingsPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSavingsPlanRequest method.
//	req, resp := client.CreateSavingsPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan
func (c *SavingsPlans) CreateSavingsPlanRequest(input *CreateSavingsPlanInput) (req *request.Request, output *CreateSavingsPlanOutput) {
	op := &request.Operation{
		Name:       opCreateSavingsPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateSavingsPlan",
	}

	if input == nil {
		input = &CreateSavingsPlanInput{}
	}

	output = &CreateSavingsPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSavingsPlan API operation for AWS Savings Plans.
//
// Creates a Savings Plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation CreateSavingsPlan for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - InternalServerException
//     An unexpected error occurred.
//
//   - ServiceQuotaExceededException
//     A service quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan
func (c *SavingsPlans) CreateSavingsPlan(input *CreateSavingsPlanInput) (*CreateSavingsPlanOutput, error) {
	req, out := c.CreateSavingsPlanRequest(input)
	return out, req.Send()
}

// CreateSavingsPlanWithContext is the same as CreateSavingsPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSavingsPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) CreateSavingsPlanWithContext(ctx aws.Context, input *CreateSavingsPlanInput, opts ...request.Option) (*CreateSavingsPlanOutput, error) {
	req, out := c.CreateSavingsPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQueuedSavingsPlan = "DeleteQueuedSavingsPlan"

// DeleteQueuedSavingsPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQueuedSavingsPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQueuedSavingsPlan for more information on using the DeleteQueuedSavingsPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteQueuedSavingsPlanRequest method.
//	req, resp := client.DeleteQueuedSavingsPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DeleteQueuedSavingsPlan
func (c *SavingsPlans) DeleteQueuedSavingsPlanRequest(input *DeleteQueuedSavingsPlanInput) (req *request.Request, output *DeleteQueuedSavingsPlanOutput) {
	op := &request.Operation{
		Name:       opDeleteQueuedSavingsPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteQueuedSavingsPlan",
	}

	if input == nil {
		input = &DeleteQueuedSavingsPlanInput{}
	}

	output = &DeleteQueuedSavingsPlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteQueuedSavingsPlan API operation for AWS Savings Plans.
//
// Deletes the queued purchase for the specified Savings Plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation DeleteQueuedSavingsPlan for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     An unexpected error occurred.
//
//   - ServiceQuotaExceededException
//     A service quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DeleteQueuedSavingsPlan
func (c *SavingsPlans) DeleteQueuedSavingsPlan(input *DeleteQueuedSavingsPlanInput) (*DeleteQueuedSavingsPlanOutput, error) {
	req, out := c.DeleteQueuedSavingsPlanRequest(input)
	return out, req.Send()
}

// DeleteQueuedSavingsPlanWithContext is the same as DeleteQueuedSavingsPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQueuedSavingsPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) DeleteQueuedSavingsPlanWithContext(ctx aws.Context, input *DeleteQueuedSavingsPlanInput, opts ...request.Option) (*DeleteQueuedSavingsPlanOutput, error) {
	req, out := c.DeleteQueuedSavingsPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSavingsPlanRates = "DescribeSavingsPlanRates"

// DescribeSavingsPlanRatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSavingsPlanRates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSavingsPlanRates for more information on using the DescribeSavingsPlanRates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSavingsPlanRatesRequest method.
//	req, resp := client.DescribeSavingsPlanRatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates
func (c *SavingsPlans) DescribeSavingsPlanRatesRequest(input *DescribeSavingsPlanRatesInput) (req *request.Request, output *DescribeSavingsPlanRatesOutput) {
	op := &request.Operation{
		Name:       opDescribeSavingsPlanRates,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSavingsPlanRates",
	}

	if input == nil {
		input = &DescribeSavingsPlanRatesInput{}
	}

	output = &DescribeSavingsPlanRatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSavingsPlanRates API operation for AWS Savings Plans.
//
// Describes the rates for the specified Savings Plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation DescribeSavingsPlanRates for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     One of the input parameters is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates
func (c *SavingsPlans) DescribeSavingsPlanRates(input *DescribeSavingsPlanRatesInput) (*DescribeSavingsPlanRatesOutput, error) {
	req, out := c.DescribeSavingsPlanRatesRequest(input)
	return out, req.Send()
}

// DescribeSavingsPlanRatesWithContext is the same as DescribeSavingsPlanRates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSavingsPlanRates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) DescribeSavingsPlanRatesWithContext(ctx aws.Context, input *DescribeSavingsPlanRatesInput, opts ...request.Option) (*DescribeSavingsPlanRatesOutput, error) {
	req, out := c.DescribeSavingsPlanRatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSavingsPlans = "DescribeSavingsPlans"

// DescribeSavingsPlansRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSavingsPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSavingsPlans for more information on using the DescribeSavingsPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSavingsPlansRequest method.
//	req, resp := client.DescribeSavingsPlansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlans
func (c *SavingsPlans) DescribeSavingsPlansRequest(input *DescribeSavingsPlansInput) (req *request.Request, output *DescribeSavingsPlansOutput) {
	op := &request.Operation{
		Name:       opDescribeSavingsPlans,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSavingsPlans",
	}

	if input == nil {
		input = &DescribeSavingsPlansInput{}
	}

	output = &DescribeSavingsPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSavingsPlans API operation for AWS Savings Plans.
//
// Describes the specified Savings Plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation DescribeSavingsPlans for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error occurred.
//
//   - ValidationException
//     One of the input parameters is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlans
func (c *SavingsPlans) DescribeSavingsPlans(input *DescribeSavingsPlansInput) (*DescribeSavingsPlansOutput, error) {
	req, out := c.DescribeSavingsPlansRequest(input)
	return out, req.Send()
}

// DescribeSavingsPlansWithContext is the same as DescribeSavingsPlans with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSavingsPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) DescribeSavingsPlansWithContext(ctx aws.Context, input *DescribeSavingsPlansInput, opts ...request.Option) (*DescribeSavingsPlansOutput, error) {
	req, out := c.DescribeSavingsPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSavingsPlansOfferingRates = "DescribeSavingsPlansOfferingRates"

// DescribeSavingsPlansOfferingRatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSavingsPlansOfferingRates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSavingsPlansOfferingRates for more information on using the DescribeSavingsPlansOfferingRates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSavingsPlansOfferingRatesRequest method.
//	req, resp := client.DescribeSavingsPlansOfferingRatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferingRates
func (c *SavingsPlans) DescribeSavingsPlansOfferingRatesRequest(input *DescribeSavingsPlansOfferingRatesInput) (req *request.Request, output *DescribeSavingsPlansOfferingRatesOutput) {
	op := &request.Operation{
		Name:       opDescribeSavingsPlansOfferingRates,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSavingsPlansOfferingRates",
	}

	if input == nil {
		input = &DescribeSavingsPlansOfferingRatesInput{}
	}

	output = &DescribeSavingsPlansOfferingRatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSavingsPlansOfferingRates API operation for AWS Savings Plans.
//
// Describes the offering rates for the specified Savings Plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation DescribeSavingsPlansOfferingRates for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - InternalServerException
//     An unexpected error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferingRates
func (c *SavingsPlans) DescribeSavingsPlansOfferingRates(input *DescribeSavingsPlansOfferingRatesInput) (*DescribeSavingsPlansOfferingRatesOutput, error) {
	req, out := c.DescribeSavingsPlansOfferingRatesRequest(input)
	return out, req.Send()
}

// DescribeSavingsPlansOfferingRatesWithContext is the same as DescribeSavingsPlansOfferingRates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSavingsPlansOfferingRates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) DescribeSavingsPlansOfferingRatesWithContext(ctx aws.Context, input *DescribeSavingsPlansOfferingRatesInput, opts ...request.Option) (*DescribeSavingsPlansOfferingRatesOutput, error) {
	req, out := c.DescribeSavingsPlansOfferingRatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSavingsPlansOfferings = "DescribeSavingsPlansOfferings"

// DescribeSavingsPlansOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSavingsPlansOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSavingsPlansOfferings for more information on using the DescribeSavingsPlansOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSavingsPlansOfferingsRequest method.
//	req, resp := client.DescribeSavingsPlansOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferings
func (c *SavingsPlans) DescribeSavingsPlansOfferingsRequest(input *DescribeSavingsPlansOfferingsInput) (req *request.Request, output *DescribeSavingsPlansOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeSavingsPlansOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSavingsPlansOfferings",
	}

	if input == nil {
		input = &DescribeSavingsPlansOfferingsInput{}
	}

	output = &DescribeSavingsPlansOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSavingsPlansOfferings API operation for AWS Savings Plans.
//
// Describes the offerings for the specified Savings Plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation DescribeSavingsPlansOfferings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - InternalServerException
//     An unexpected error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferings
func (c *SavingsPlans) DescribeSavingsPlansOfferings(input *DescribeSavingsPlansOfferingsInput) (*DescribeSavingsPlansOfferingsOutput, error) {
	req, out := c.DescribeSavingsPlansOfferingsRequest(input)
	return out, req.Send()
}

// DescribeSavingsPlansOfferingsWithContext is the same as DescribeSavingsPlansOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSavingsPlansOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) DescribeSavingsPlansOfferingsWithContext(ctx aws.Context, input *DescribeSavingsPlansOfferingsInput, opts ...request.Option) (*DescribeSavingsPlansOfferingsOutput, error) {
	req, out := c.DescribeSavingsPlansOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ListTagsForResource
func (c *SavingsPlans) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/ListTagsForResource",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Savings Plans.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - InternalServerException
//     An unexpected error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ListTagsForResource
func (c *SavingsPlans) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReturnSavingsPlan = "ReturnSavingsPlan"

// ReturnSavingsPlanRequest generates a "aws/request.Request" representing the
// client's request for the ReturnSavingsPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReturnSavingsPlan for more information on using the ReturnSavingsPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReturnSavingsPlanRequest method.
//	req, resp := client.ReturnSavingsPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ReturnSavingsPlan
func (c *SavingsPlans) ReturnSavingsPlanRequest(input *ReturnSavingsPlanInput) (req *request.Request, output *ReturnSavingsPlanOutput) {
	op := &request.Operation{
		Name:       opReturnSavingsPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/ReturnSavingsPlan",
	}

	if input == nil {
		input = &ReturnSavingsPlanInput{}
	}

	output = &ReturnSavingsPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReturnSavingsPlan API operation for AWS Savings Plans.
//
// Returns the specified Savings Plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation ReturnSavingsPlan for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServerException
//     An unexpected error occurred.
//
//   - ServiceQuotaExceededException
//     A service quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ReturnSavingsPlan
func (c *SavingsPlans) ReturnSavingsPlan(input *ReturnSavingsPlanInput) (*ReturnSavingsPlanOutput, error) {
	req, out := c.ReturnSavingsPlanRequest(input)
	return out, req.Send()
}

// ReturnSavingsPlanWithContext is the same as ReturnSavingsPlan with the addition of
// the ability to pass a context and additional request options.
//
// See ReturnSavingsPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) ReturnSavingsPlanWithContext(ctx aws.Context, input *ReturnSavingsPlanInput, opts ...request.Option) (*ReturnSavingsPlanOutput, error) {
	req, out := c.ReturnSavingsPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/TagResource
func (c *SavingsPlans) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/TagResource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Savings Plans.
//
// Adds the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ServiceQuotaExceededException
//     A service quota has been exceeded.
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - InternalServerException
//     An unexpected error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/TagResource
func (c *SavingsPlans) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/UntagResource
func (c *SavingsPlans) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/UntagResource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Savings Plans.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Savings Plans's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     One of the input parameters is not valid.
//
//   - InternalServerException
//     An unexpected error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/UntagResource
func (c *SavingsPlans) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SavingsPlans) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateSavingsPlanInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The hourly commitment, in the same currency of the savingsPlanOfferingId.
	// This is a value between 0.001 and 1 million. You cannot specify more than
	// five digits after the decimal point.
	//
	// Commitment is a required field
	Commitment *string `locationName:"commitment" type:"string" required:"true"`

	// The purchase time of the Savings Plan in UTC format (YYYY-MM-DDTHH:MM:SSZ).
	PurchaseTime *time.Time `locationName:"purchaseTime" type:"timestamp"`

	// The ID of the offering.
	//
	// SavingsPlanOfferingId is a required field
	SavingsPlanOfferingId *string `locationName:"savingsPlanOfferingId" type:"string" required:"true"`

	// One or more tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The up-front payment amount. This is a whole number between 50 and 99 percent
	// of the total value of the Savings Plan. This parameter is only supported
	// if the payment option is Partial Upfront.
	UpfrontPaymentAmount *string `locationName:"upfrontPaymentAmount" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSavingsPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSavingsPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSavingsPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSavingsPlanInput"}
	if s.Commitment == nil {
		invalidParams.Add(request.NewErrParamRequired("Commitment"))
	}
	if s.SavingsPlanOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("SavingsPlanOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSavingsPlanInput) SetClientToken(v string) *CreateSavingsPlanInput {
	s.ClientToken = &v
	return s
}

// SetCommitment sets the Commitment field's value.
func (s *CreateSavingsPlanInput) SetCommitment(v string) *CreateSavingsPlanInput {
	s.Commitment = &v
	return s
}

// SetPurchaseTime sets the PurchaseTime field's value.
func (s *CreateSavingsPlanInput) SetPurchaseTime(v time.Time) *CreateSavingsPlanInput {
	s.PurchaseTime = &v
	return s
}

// SetSavingsPlanOfferingId sets the SavingsPlanOfferingId field's value.
func (s *CreateSavingsPlanInput) SetSavingsPlanOfferingId(v string) *CreateSavingsPlanInput {
	s.SavingsPlanOfferingId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSavingsPlanInput) SetTags(v map[string]*string) *CreateSavingsPlanInput {
	s.Tags = v
	return s
}

// SetUpfrontPaymentAmount sets the UpfrontPaymentAmount field's value.
func (s *CreateSavingsPlanInput) SetUpfrontPaymentAmount(v string) *CreateSavingsPlanInput {
	s.UpfrontPaymentAmount = &v
	return s
}

type CreateSavingsPlanOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Savings Plan.
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSavingsPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSavingsPlanOutput) GoString() string {
	return s.String()
}

// SetSavingsPlanId sets the SavingsPlanId field's value.
func (s *CreateSavingsPlanOutput) SetSavingsPlanId(v string) *CreateSavingsPlanOutput {
	s.SavingsPlanId = &v
	return s
}

type DeleteQueuedSavingsPlanInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Savings Plan.
	//
	// SavingsPlanId is a required field
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueuedSavingsPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueuedSavingsPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQueuedSavingsPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQueuedSavingsPlanInput"}
	if s.SavingsPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("SavingsPlanId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSavingsPlanId sets the SavingsPlanId field's value.
func (s *DeleteQueuedSavingsPlanInput) SetSavingsPlanId(v string) *DeleteQueuedSavingsPlanInput {
	s.SavingsPlanId = &v
	return s
}

type DeleteQueuedSavingsPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueuedSavingsPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueuedSavingsPlanOutput) GoString() string {
	return s.String()
}

type DescribeSavingsPlanRatesInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	Filters []*SavingsPlanRateFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return with a single call. To retrieve additional
	// results, make another call with the returned token value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Savings Plan.
	//
	// SavingsPlanId is a required field
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlanRatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlanRatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSavingsPlanRatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSavingsPlanRatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SavingsPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("SavingsPlanId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSavingsPlanRatesInput) SetFilters(v []*SavingsPlanRateFilter) *DescribeSavingsPlanRatesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSavingsPlanRatesInput) SetMaxResults(v int64) *DescribeSavingsPlanRatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlanRatesInput) SetNextToken(v string) *DescribeSavingsPlanRatesInput {
	s.NextToken = &v
	return s
}

// SetSavingsPlanId sets the SavingsPlanId field's value.
func (s *DescribeSavingsPlanRatesInput) SetSavingsPlanId(v string) *DescribeSavingsPlanRatesInput {
	s.SavingsPlanId = &v
	return s
}

type DescribeSavingsPlanRatesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Savings Plan.
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string"`

	// Information about the Savings Plan rates.
	SearchResults []*SavingsPlanRate `locationName:"searchResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlanRatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlanRatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlanRatesOutput) SetNextToken(v string) *DescribeSavingsPlanRatesOutput {
	s.NextToken = &v
	return s
}

// SetSavingsPlanId sets the SavingsPlanId field's value.
func (s *DescribeSavingsPlanRatesOutput) SetSavingsPlanId(v string) *DescribeSavingsPlanRatesOutput {
	s.SavingsPlanId = &v
	return s
}

// SetSearchResults sets the SearchResults field's value.
func (s *DescribeSavingsPlanRatesOutput) SetSearchResults(v []*SavingsPlanRate) *DescribeSavingsPlanRatesOutput {
	s.SearchResults = v
	return s
}

type DescribeSavingsPlansInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	Filters []*SavingsPlanFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return with a single call. To retrieve additional
	// results, make another call with the returned token value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Names (ARN) of the Savings Plans.
	SavingsPlanArns []*string `locationName:"savingsPlanArns" type:"list"`

	// The IDs of the Savings Plans.
	SavingsPlanIds []*string `locationName:"savingsPlanIds" type:"list"`

	// The current states of the Savings Plans.
	States []*string `locationName:"states" type:"list" enum:"SavingsPlanState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSavingsPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSavingsPlansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSavingsPlansInput) SetFilters(v []*SavingsPlanFilter) *DescribeSavingsPlansInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSavingsPlansInput) SetMaxResults(v int64) *DescribeSavingsPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlansInput) SetNextToken(v string) *DescribeSavingsPlansInput {
	s.NextToken = &v
	return s
}

// SetSavingsPlanArns sets the SavingsPlanArns field's value.
func (s *DescribeSavingsPlansInput) SetSavingsPlanArns(v []*string) *DescribeSavingsPlansInput {
	s.SavingsPlanArns = v
	return s
}

// SetSavingsPlanIds sets the SavingsPlanIds field's value.
func (s *DescribeSavingsPlansInput) SetSavingsPlanIds(v []*string) *DescribeSavingsPlansInput {
	s.SavingsPlanIds = v
	return s
}

// SetStates sets the States field's value.
func (s *DescribeSavingsPlansInput) SetStates(v []*string) *DescribeSavingsPlansInput {
	s.States = v
	return s
}

type DescribeSavingsPlansOfferingRatesInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	Filters []*SavingsPlanOfferingRateFilterElement `locationName:"filters" type:"list"`

	// The maximum number of results to return with a single call. To retrieve additional
	// results, make another call with the returned token value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The specific Amazon Web Services operation for the line item in the billing
	// report.
	Operations []*string `locationName:"operations" type:"list"`

	// The Amazon Web Services products.
	Products []*string `locationName:"products" type:"list" enum:"SavingsPlanProductType"`

	// The IDs of the offerings.
	SavingsPlanOfferingIds []*string `locationName:"savingsPlanOfferingIds" type:"list"`

	// The payment options.
	SavingsPlanPaymentOptions []*string `locationName:"savingsPlanPaymentOptions" type:"list" enum:"SavingsPlanPaymentOption"`

	// The plan types.
	SavingsPlanTypes []*string `locationName:"savingsPlanTypes" type:"list" enum:"SavingsPlanType"`

	// The services.
	ServiceCodes []*string `locationName:"serviceCodes" type:"list" enum:"SavingsPlanRateServiceCode"`

	// The usage details of the line item in the billing report.
	UsageTypes []*string `locationName:"usageTypes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingRatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingRatesInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetFilters(v []*SavingsPlanOfferingRateFilterElement) *DescribeSavingsPlansOfferingRatesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetMaxResults(v int64) *DescribeSavingsPlansOfferingRatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetNextToken(v string) *DescribeSavingsPlansOfferingRatesInput {
	s.NextToken = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetOperations(v []*string) *DescribeSavingsPlansOfferingRatesInput {
	s.Operations = v
	return s
}

// SetProducts sets the Products field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetProducts(v []*string) *DescribeSavingsPlansOfferingRatesInput {
	s.Products = v
	return s
}

// SetSavingsPlanOfferingIds sets the SavingsPlanOfferingIds field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetSavingsPlanOfferingIds(v []*string) *DescribeSavingsPlansOfferingRatesInput {
	s.SavingsPlanOfferingIds = v
	return s
}

// SetSavingsPlanPaymentOptions sets the SavingsPlanPaymentOptions field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetSavingsPlanPaymentOptions(v []*string) *DescribeSavingsPlansOfferingRatesInput {
	s.SavingsPlanPaymentOptions = v
	return s
}

// SetSavingsPlanTypes sets the SavingsPlanTypes field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetSavingsPlanTypes(v []*string) *DescribeSavingsPlansOfferingRatesInput {
	s.SavingsPlanTypes = v
	return s
}

// SetServiceCodes sets the ServiceCodes field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetServiceCodes(v []*string) *DescribeSavingsPlansOfferingRatesInput {
	s.ServiceCodes = v
	return s
}

// SetUsageTypes sets the UsageTypes field's value.
func (s *DescribeSavingsPlansOfferingRatesInput) SetUsageTypes(v []*string) *DescribeSavingsPlansOfferingRatesInput {
	s.UsageTypes = v
	return s
}

type DescribeSavingsPlansOfferingRatesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the Savings Plans offering rates.
	SearchResults []*SavingsPlanOfferingRate `locationName:"searchResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingRatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingRatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlansOfferingRatesOutput) SetNextToken(v string) *DescribeSavingsPlansOfferingRatesOutput {
	s.NextToken = &v
	return s
}

// SetSearchResults sets the SearchResults field's value.
func (s *DescribeSavingsPlansOfferingRatesOutput) SetSearchResults(v []*SavingsPlanOfferingRate) *DescribeSavingsPlansOfferingRatesOutput {
	s.SearchResults = v
	return s
}

type DescribeSavingsPlansOfferingsInput struct {
	_ struct{} `type:"structure"`

	// The currencies.
	Currencies []*string `locationName:"currencies" type:"list" enum:"CurrencyCode"`

	// The descriptions.
	Descriptions []*string `locationName:"descriptions" type:"list"`

	// The duration, in seconds.
	Durations []*int64 `locationName:"durations" type:"list"`

	// The filters.
	Filters []*SavingsPlanOfferingFilterElement `locationName:"filters" type:"list"`

	// The maximum number of results to return with a single call. To retrieve additional
	// results, make another call with the returned token value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of the offerings.
	OfferingIds []*string `locationName:"offeringIds" type:"list"`

	// The specific Amazon Web Services operation for the line item in the billing
	// report.
	Operations []*string `locationName:"operations" type:"list"`

	// The payment options.
	PaymentOptions []*string `locationName:"paymentOptions" type:"list" enum:"SavingsPlanPaymentOption"`

	// The plan types.
	PlanTypes []*string `locationName:"planTypes" type:"list" enum:"SavingsPlanType"`

	// The product type.
	ProductType *string `locationName:"productType" type:"string" enum:"SavingsPlanProductType"`

	// The services.
	ServiceCodes []*string `locationName:"serviceCodes" type:"list"`

	// The usage details of the line item in the billing report.
	UsageTypes []*string `locationName:"usageTypes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingsInput) GoString() string {
	return s.String()
}

// SetCurrencies sets the Currencies field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetCurrencies(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.Currencies = v
	return s
}

// SetDescriptions sets the Descriptions field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetDescriptions(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.Descriptions = v
	return s
}

// SetDurations sets the Durations field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetDurations(v []*int64) *DescribeSavingsPlansOfferingsInput {
	s.Durations = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetFilters(v []*SavingsPlanOfferingFilterElement) *DescribeSavingsPlansOfferingsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetMaxResults(v int64) *DescribeSavingsPlansOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetNextToken(v string) *DescribeSavingsPlansOfferingsInput {
	s.NextToken = &v
	return s
}

// SetOfferingIds sets the OfferingIds field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetOfferingIds(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.OfferingIds = v
	return s
}

// SetOperations sets the Operations field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetOperations(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.Operations = v
	return s
}

// SetPaymentOptions sets the PaymentOptions field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetPaymentOptions(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.PaymentOptions = v
	return s
}

// SetPlanTypes sets the PlanTypes field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetPlanTypes(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.PlanTypes = v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetProductType(v string) *DescribeSavingsPlansOfferingsInput {
	s.ProductType = &v
	return s
}

// SetServiceCodes sets the ServiceCodes field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetServiceCodes(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.ServiceCodes = v
	return s
}

// SetUsageTypes sets the UsageTypes field's value.
func (s *DescribeSavingsPlansOfferingsInput) SetUsageTypes(v []*string) *DescribeSavingsPlansOfferingsInput {
	s.UsageTypes = v
	return s
}

type DescribeSavingsPlansOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the Savings Plans offerings.
	SearchResults []*SavingsPlanOffering `locationName:"searchResults" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlansOfferingsOutput) SetNextToken(v string) *DescribeSavingsPlansOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetSearchResults sets the SearchResults field's value.
func (s *DescribeSavingsPlansOfferingsOutput) SetSearchResults(v []*SavingsPlanOffering) *DescribeSavingsPlansOfferingsOutput {
	s.SearchResults = v
	return s
}

type DescribeSavingsPlansOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the Savings Plans.
	SavingsPlans []*SavingsPlan `locationName:"savingsPlans" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSavingsPlansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSavingsPlansOutput) SetNextToken(v string) *DescribeSavingsPlansOutput {
	s.NextToken = &v
	return s
}

// SetSavingsPlans sets the SavingsPlans field's value.
func (s *DescribeSavingsPlansOutput) SetSavingsPlans(v []*SavingsPlan) *DescribeSavingsPlansOutput {
	s.SavingsPlans = v
	return s
}

// An unexpected error occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about a Savings Plan offering.
type ParentSavingsPlanOffering struct {
	_ struct{} `type:"structure"`

	// The currency.
	Currency *string `locationName:"currency" type:"string" enum:"CurrencyCode"`

	// The duration, in seconds.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"long"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The payment option.
	PaymentOption *string `locationName:"paymentOption" type:"string" enum:"SavingsPlanPaymentOption"`

	// The description.
	PlanDescription *string `locationName:"planDescription" type:"string"`

	// The plan type.
	PlanType *string `locationName:"planType" type:"string" enum:"SavingsPlanType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParentSavingsPlanOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParentSavingsPlanOffering) GoString() string {
	return s.String()
}

// SetCurrency sets the Currency field's value.
func (s *ParentSavingsPlanOffering) SetCurrency(v string) *ParentSavingsPlanOffering {
	s.Currency = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *ParentSavingsPlanOffering) SetDurationSeconds(v int64) *ParentSavingsPlanOffering {
	s.DurationSeconds = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *ParentSavingsPlanOffering) SetOfferingId(v string) *ParentSavingsPlanOffering {
	s.OfferingId = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ParentSavingsPlanOffering) SetPaymentOption(v string) *ParentSavingsPlanOffering {
	s.PaymentOption = &v
	return s
}

// SetPlanDescription sets the PlanDescription field's value.
func (s *ParentSavingsPlanOffering) SetPlanDescription(v string) *ParentSavingsPlanOffering {
	s.PlanDescription = &v
	return s
}

// SetPlanType sets the PlanType field's value.
func (s *ParentSavingsPlanOffering) SetPlanType(v string) *ParentSavingsPlanOffering {
	s.PlanType = &v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ReturnSavingsPlanInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The ID of the Savings Plan.
	//
	// SavingsPlanId is a required field
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnSavingsPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnSavingsPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReturnSavingsPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReturnSavingsPlanInput"}
	if s.SavingsPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("SavingsPlanId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ReturnSavingsPlanInput) SetClientToken(v string) *ReturnSavingsPlanInput {
	s.ClientToken = &v
	return s
}

// SetSavingsPlanId sets the SavingsPlanId field's value.
func (s *ReturnSavingsPlanInput) SetSavingsPlanId(v string) *ReturnSavingsPlanInput {
	s.SavingsPlanId = &v
	return s
}

type ReturnSavingsPlanOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Savings Plan.
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnSavingsPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReturnSavingsPlanOutput) GoString() string {
	return s.String()
}

// SetSavingsPlanId sets the SavingsPlanId field's value.
func (s *ReturnSavingsPlanOutput) SetSavingsPlanId(v string) *ReturnSavingsPlanOutput {
	s.SavingsPlanId = &v
	return s
}

// Information about a Savings Plan.
type SavingsPlan struct {
	_ struct{} `type:"structure"`

	// The hourly commitment amount in the specified currency.
	Commitment *string `locationName:"commitment" type:"string"`

	// The currency.
	Currency *string `locationName:"currency" type:"string" enum:"CurrencyCode"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The EC2 instance family.
	Ec2InstanceFamily *string `locationName:"ec2InstanceFamily" type:"string"`

	// The end time.
	End *string `locationName:"end" type:"string"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The payment option.
	PaymentOption *string `locationName:"paymentOption" type:"string" enum:"SavingsPlanPaymentOption"`

	// The product types.
	ProductTypes []*string `locationName:"productTypes" type:"list" enum:"SavingsPlanProductType"`

	// The recurring payment amount.
	RecurringPaymentAmount *string `locationName:"recurringPaymentAmount" type:"string"`

	// The Amazon Web Services Region.
	Region *string `locationName:"region" type:"string"`

	// The time until when a return for the Savings Plan can be requested. If the
	// Savings Plan is not returnable, the field reflects the Savings Plan start
	// time.
	ReturnableUntil *string `locationName:"returnableUntil" type:"string"`

	// The Amazon Resource Name (ARN) of the Savings Plan.
	SavingsPlanArn *string `locationName:"savingsPlanArn" type:"string"`

	// The ID of the Savings Plan.
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string"`

	// The plan type.
	SavingsPlanType *string `locationName:"savingsPlanType" type:"string" enum:"SavingsPlanType"`

	// The start time.
	Start *string `locationName:"start" type:"string"`

	// The current state.
	State *string `locationName:"state" type:"string" enum:"SavingsPlanState"`

	// One or more tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The duration of the term, in seconds.
	TermDurationInSeconds *int64 `locationName:"termDurationInSeconds" type:"long"`

	// The up-front payment amount.
	UpfrontPaymentAmount *string `locationName:"upfrontPaymentAmount" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlan) GoString() string {
	return s.String()
}

// SetCommitment sets the Commitment field's value.
func (s *SavingsPlan) SetCommitment(v string) *SavingsPlan {
	s.Commitment = &v
	return s
}

// SetCurrency sets the Currency field's value.
func (s *SavingsPlan) SetCurrency(v string) *SavingsPlan {
	s.Currency = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SavingsPlan) SetDescription(v string) *SavingsPlan {
	s.Description = &v
	return s
}

// SetEc2InstanceFamily sets the Ec2InstanceFamily field's value.
func (s *SavingsPlan) SetEc2InstanceFamily(v string) *SavingsPlan {
	s.Ec2InstanceFamily = &v
	return s
}

// SetEnd sets the End field's value.
func (s *SavingsPlan) SetEnd(v string) *SavingsPlan {
	s.End = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *SavingsPlan) SetOfferingId(v string) *SavingsPlan {
	s.OfferingId = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *SavingsPlan) SetPaymentOption(v string) *SavingsPlan {
	s.PaymentOption = &v
	return s
}

// SetProductTypes sets the ProductTypes field's value.
func (s *SavingsPlan) SetProductTypes(v []*string) *SavingsPlan {
	s.ProductTypes = v
	return s
}

// SetRecurringPaymentAmount sets the RecurringPaymentAmount field's value.
func (s *SavingsPlan) SetRecurringPaymentAmount(v string) *SavingsPlan {
	s.RecurringPaymentAmount = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *SavingsPlan) SetRegion(v string) *SavingsPlan {
	s.Region = &v
	return s
}

// SetReturnableUntil sets the ReturnableUntil field's value.
func (s *SavingsPlan) SetReturnableUntil(v string) *SavingsPlan {
	s.ReturnableUntil = &v
	return s
}

// SetSavingsPlanArn sets the SavingsPlanArn field's value.
func (s *SavingsPlan) SetSavingsPlanArn(v string) *SavingsPlan {
	s.SavingsPlanArn = &v
	return s
}

// SetSavingsPlanId sets the SavingsPlanId field's value.
func (s *SavingsPlan) SetSavingsPlanId(v string) *SavingsPlan {
	s.SavingsPlanId = &v
	return s
}

// SetSavingsPlanType sets the SavingsPlanType field's value.
func (s *SavingsPlan) SetSavingsPlanType(v string) *SavingsPlan {
	s.SavingsPlanType = &v
	return s
}

// SetStart sets the Start field's value.
func (s *SavingsPlan) SetStart(v string) *SavingsPlan {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *SavingsPlan) SetState(v string) *SavingsPlan {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SavingsPlan) SetTags(v map[string]*string) *SavingsPlan {
	s.Tags = v
	return s
}

// SetTermDurationInSeconds sets the TermDurationInSeconds field's value.
func (s *SavingsPlan) SetTermDurationInSeconds(v int64) *SavingsPlan {
	s.TermDurationInSeconds = &v
	return s
}

// SetUpfrontPaymentAmount sets the UpfrontPaymentAmount field's value.
func (s *SavingsPlan) SetUpfrontPaymentAmount(v string) *SavingsPlan {
	s.UpfrontPaymentAmount = &v
	return s
}

// Information about a Savings Plan filter.
type SavingsPlanFilter struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name *string `locationName:"name" type:"string" enum:"SavingsPlansFilterName"`

	// The filter value.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SavingsPlanFilter) SetName(v string) *SavingsPlanFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SavingsPlanFilter) SetValues(v []*string) *SavingsPlanFilter {
	s.Values = v
	return s
}

// Information about a Savings Plan offering.
type SavingsPlanOffering struct {
	_ struct{} `type:"structure"`

	// The currency.
	Currency *string `locationName:"currency" type:"string" enum:"CurrencyCode"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The duration, in seconds.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"long"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The specific Amazon Web Services operation for the line item in the billing
	// report.
	Operation *string `locationName:"operation" type:"string"`

	// The payment option.
	PaymentOption *string `locationName:"paymentOption" type:"string" enum:"SavingsPlanPaymentOption"`

	// The plan type.
	PlanType *string `locationName:"planType" type:"string" enum:"SavingsPlanType"`

	// The product type.
	ProductTypes []*string `locationName:"productTypes" type:"list" enum:"SavingsPlanProductType"`

	// The properties.
	Properties []*SavingsPlanOfferingProperty `locationName:"properties" type:"list"`

	// The service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The usage details of the line item in the billing report.
	UsageType *string `locationName:"usageType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOffering) GoString() string {
	return s.String()
}

// SetCurrency sets the Currency field's value.
func (s *SavingsPlanOffering) SetCurrency(v string) *SavingsPlanOffering {
	s.Currency = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SavingsPlanOffering) SetDescription(v string) *SavingsPlanOffering {
	s.Description = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *SavingsPlanOffering) SetDurationSeconds(v int64) *SavingsPlanOffering {
	s.DurationSeconds = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *SavingsPlanOffering) SetOfferingId(v string) *SavingsPlanOffering {
	s.OfferingId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *SavingsPlanOffering) SetOperation(v string) *SavingsPlanOffering {
	s.Operation = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *SavingsPlanOffering) SetPaymentOption(v string) *SavingsPlanOffering {
	s.PaymentOption = &v
	return s
}

// SetPlanType sets the PlanType field's value.
func (s *SavingsPlanOffering) SetPlanType(v string) *SavingsPlanOffering {
	s.PlanType = &v
	return s
}

// SetProductTypes sets the ProductTypes field's value.
func (s *SavingsPlanOffering) SetProductTypes(v []*string) *SavingsPlanOffering {
	s.ProductTypes = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *SavingsPlanOffering) SetProperties(v []*SavingsPlanOfferingProperty) *SavingsPlanOffering {
	s.Properties = v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *SavingsPlanOffering) SetServiceCode(v string) *SavingsPlanOffering {
	s.ServiceCode = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *SavingsPlanOffering) SetUsageType(v string) *SavingsPlanOffering {
	s.UsageType = &v
	return s
}

// Information about a Savings Plan offering filter.
type SavingsPlanOfferingFilterElement struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name *string `locationName:"name" type:"string" enum:"SavingsPlanOfferingFilterAttribute"`

	// The filter values.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingFilterElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingFilterElement) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SavingsPlanOfferingFilterElement) SetName(v string) *SavingsPlanOfferingFilterElement {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SavingsPlanOfferingFilterElement) SetValues(v []*string) *SavingsPlanOfferingFilterElement {
	s.Values = v
	return s
}

// Information about a Savings Plan offering property.
type SavingsPlanOfferingProperty struct {
	_ struct{} `type:"structure"`

	// The property name.
	Name *string `locationName:"name" type:"string" enum:"SavingsPlanOfferingPropertyKey"`

	// The property value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingProperty) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SavingsPlanOfferingProperty) SetName(v string) *SavingsPlanOfferingProperty {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SavingsPlanOfferingProperty) SetValue(v string) *SavingsPlanOfferingProperty {
	s.Value = &v
	return s
}

// Information about a Savings Plan offering rate.
type SavingsPlanOfferingRate struct {
	_ struct{} `type:"structure"`

	// The specific Amazon Web Services operation for the line item in the billing
	// report.
	Operation *string `locationName:"operation" type:"string"`

	// The product type.
	ProductType *string `locationName:"productType" type:"string" enum:"SavingsPlanProductType"`

	// The properties.
	Properties []*SavingsPlanOfferingRateProperty `locationName:"properties" type:"list"`

	// The Savings Plan rate.
	Rate *string `locationName:"rate" type:"string"`

	// The Savings Plan offering.
	SavingsPlanOffering *ParentSavingsPlanOffering `locationName:"savingsPlanOffering" type:"structure"`

	// The service.
	ServiceCode *string `locationName:"serviceCode" type:"string" enum:"SavingsPlanRateServiceCode"`

	// The unit.
	Unit *string `locationName:"unit" type:"string" enum:"SavingsPlanRateUnit"`

	// The usage details of the line item in the billing report.
	UsageType *string `locationName:"usageType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingRate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingRate) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *SavingsPlanOfferingRate) SetOperation(v string) *SavingsPlanOfferingRate {
	s.Operation = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *SavingsPlanOfferingRate) SetProductType(v string) *SavingsPlanOfferingRate {
	s.ProductType = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *SavingsPlanOfferingRate) SetProperties(v []*SavingsPlanOfferingRateProperty) *SavingsPlanOfferingRate {
	s.Properties = v
	return s
}

// SetRate sets the Rate field's value.
func (s *SavingsPlanOfferingRate) SetRate(v string) *SavingsPlanOfferingRate {
	s.Rate = &v
	return s
}

// SetSavingsPlanOffering sets the SavingsPlanOffering field's value.
func (s *SavingsPlanOfferingRate) SetSavingsPlanOffering(v *ParentSavingsPlanOffering) *SavingsPlanOfferingRate {
	s.SavingsPlanOffering = v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *SavingsPlanOfferingRate) SetServiceCode(v string) *SavingsPlanOfferingRate {
	s.ServiceCode = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *SavingsPlanOfferingRate) SetUnit(v string) *SavingsPlanOfferingRate {
	s.Unit = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *SavingsPlanOfferingRate) SetUsageType(v string) *SavingsPlanOfferingRate {
	s.UsageType = &v
	return s
}

// Information about a Savings Plan offering rate filter.
type SavingsPlanOfferingRateFilterElement struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name *string `locationName:"name" type:"string" enum:"SavingsPlanRateFilterAttribute"`

	// The filter values.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingRateFilterElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingRateFilterElement) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SavingsPlanOfferingRateFilterElement) SetName(v string) *SavingsPlanOfferingRateFilterElement {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SavingsPlanOfferingRateFilterElement) SetValues(v []*string) *SavingsPlanOfferingRateFilterElement {
	s.Values = v
	return s
}

// Information about a Savings Plan offering rate property.
type SavingsPlanOfferingRateProperty struct {
	_ struct{} `type:"structure"`

	// The property name.
	Name *string `locationName:"name" type:"string"`

	// The property value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingRateProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanOfferingRateProperty) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SavingsPlanOfferingRateProperty) SetName(v string) *SavingsPlanOfferingRateProperty {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SavingsPlanOfferingRateProperty) SetValue(v string) *SavingsPlanOfferingRateProperty {
	s.Value = &v
	return s
}

// Information about a Savings Plan rate.
type SavingsPlanRate struct {
	_ struct{} `type:"structure"`

	// The currency.
	Currency *string `locationName:"currency" type:"string" enum:"CurrencyCode"`

	// The specific Amazon Web Services operation for the line item in the billing
	// report.
	Operation *string `locationName:"operation" type:"string"`

	// The product type.
	ProductType *string `locationName:"productType" type:"string" enum:"SavingsPlanProductType"`

	// The properties.
	Properties []*SavingsPlanRateProperty `locationName:"properties" type:"list"`

	// The rate.
	Rate *string `locationName:"rate" type:"string"`

	// The service.
	ServiceCode *string `locationName:"serviceCode" type:"string" enum:"SavingsPlanRateServiceCode"`

	// The unit.
	Unit *string `locationName:"unit" type:"string" enum:"SavingsPlanRateUnit"`

	// The usage details of the line item in the billing report.
	UsageType *string `locationName:"usageType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanRate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanRate) GoString() string {
	return s.String()
}

// SetCurrency sets the Currency field's value.
func (s *SavingsPlanRate) SetCurrency(v string) *SavingsPlanRate {
	s.Currency = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *SavingsPlanRate) SetOperation(v string) *SavingsPlanRate {
	s.Operation = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *SavingsPlanRate) SetProductType(v string) *SavingsPlanRate {
	s.ProductType = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *SavingsPlanRate) SetProperties(v []*SavingsPlanRateProperty) *SavingsPlanRate {
	s.Properties = v
	return s
}

// SetRate sets the Rate field's value.
func (s *SavingsPlanRate) SetRate(v string) *SavingsPlanRate {
	s.Rate = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *SavingsPlanRate) SetServiceCode(v string) *SavingsPlanRate {
	s.ServiceCode = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *SavingsPlanRate) SetUnit(v string) *SavingsPlanRate {
	s.Unit = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *SavingsPlanRate) SetUsageType(v string) *SavingsPlanRate {
	s.UsageType = &v
	return s
}

// Information about a Savings Plan rate filter.
type SavingsPlanRateFilter struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name *string `locationName:"name" type:"string" enum:"SavingsPlanRateFilterName"`

	// The filter values.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanRateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanRateFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SavingsPlanRateFilter) SetName(v string) *SavingsPlanRateFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SavingsPlanRateFilter) SetValues(v []*string) *SavingsPlanRateFilter {
	s.Values = v
	return s
}

// Information about a Savings Plan rate property.
type SavingsPlanRateProperty struct {
	_ struct{} `type:"structure"`

	// The property name.
	Name *string `locationName:"name" type:"string" enum:"SavingsPlanRatePropertyKey"`

	// The property value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanRateProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SavingsPlanRateProperty) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SavingsPlanRateProperty) SetName(v string) *SavingsPlanRateProperty {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SavingsPlanRateProperty) SetValue(v string) *SavingsPlanRateProperty {
	s.Value = &v
	return s
}

// A service quota has been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"}
	// }.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// One of the input parameters is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// CurrencyCodeCny is a CurrencyCode enum value
	CurrencyCodeCny = "CNY"

	// CurrencyCodeUsd is a CurrencyCode enum value
	CurrencyCodeUsd = "USD"
)

// CurrencyCode_Values returns all elements of the CurrencyCode enum
func CurrencyCode_Values() []string {
	return []string{
		CurrencyCodeCny,
		CurrencyCodeUsd,
	}
}

const (
	// SavingsPlanOfferingFilterAttributeRegion is a SavingsPlanOfferingFilterAttribute enum value
	SavingsPlanOfferingFilterAttributeRegion = "region"

	// SavingsPlanOfferingFilterAttributeInstanceFamily is a SavingsPlanOfferingFilterAttribute enum value
	SavingsPlanOfferingFilterAttributeInstanceFamily = "instanceFamily"
)

// SavingsPlanOfferingFilterAttribute_Values returns all elements of the SavingsPlanOfferingFilterAttribute enum
func SavingsPlanOfferingFilterAttribute_Values() []string {
	return []string{
		SavingsPlanOfferingFilterAttributeRegion,
		SavingsPlanOfferingFilterAttributeInstanceFamily,
	}
}

const (
	// SavingsPlanOfferingPropertyKeyRegion is a SavingsPlanOfferingPropertyKey enum value
	SavingsPlanOfferingPropertyKeyRegion = "region"

	// SavingsPlanOfferingPropertyKeyInstanceFamily is a SavingsPlanOfferingPropertyKey enum value
	SavingsPlanOfferingPropertyKeyInstanceFamily = "instanceFamily"
)

// SavingsPlanOfferingPropertyKey_Values returns all elements of the SavingsPlanOfferingPropertyKey enum
func SavingsPlanOfferingPropertyKey_Values() []string {
	return []string{
		SavingsPlanOfferingPropertyKeyRegion,
		SavingsPlanOfferingPropertyKeyInstanceFamily,
	}
}

const (
	// SavingsPlanPaymentOptionAllUpfront is a SavingsPlanPaymentOption enum value
	SavingsPlanPaymentOptionAllUpfront = "All Upfront"

	// SavingsPlanPaymentOptionPartialUpfront is a SavingsPlanPaymentOption enum value
	SavingsPlanPaymentOptionPartialUpfront = "Partial Upfront"

	// SavingsPlanPaymentOptionNoUpfront is a SavingsPlanPaymentOption enum value
	SavingsPlanPaymentOptionNoUpfront = "No Upfront"
)

// SavingsPlanPaymentOption_Values returns all elements of the SavingsPlanPaymentOption enum
func SavingsPlanPaymentOption_Values() []string {
	return []string{
		SavingsPlanPaymentOptionAllUpfront,
		SavingsPlanPaymentOptionPartialUpfront,
		SavingsPlanPaymentOptionNoUpfront,
	}
}

const (
	// SavingsPlanProductTypeEc2 is a SavingsPlanProductType enum value
	SavingsPlanProductTypeEc2 = "EC2"

	// SavingsPlanProductTypeFargate is a SavingsPlanProductType enum value
	SavingsPlanProductTypeFargate = "Fargate"

	// SavingsPlanProductTypeLambda is a SavingsPlanProductType enum value
	SavingsPlanProductTypeLambda = "Lambda"

	// SavingsPlanProductTypeSageMaker is a SavingsPlanProductType enum value
	SavingsPlanProductTypeSageMaker = "SageMaker"
)

// SavingsPlanProductType_Values returns all elements of the SavingsPlanProductType enum
func SavingsPlanProductType_Values() []string {
	return []string{
		SavingsPlanProductTypeEc2,
		SavingsPlanProductTypeFargate,
		SavingsPlanProductTypeLambda,
		SavingsPlanProductTypeSageMaker,
	}
}

const (
	// SavingsPlanRateFilterAttributeRegion is a SavingsPlanRateFilterAttribute enum value
	SavingsPlanRateFilterAttributeRegion = "region"

	// SavingsPlanRateFilterAttributeInstanceFamily is a SavingsPlanRateFilterAttribute enum value
	SavingsPlanRateFilterAttributeInstanceFamily = "instanceFamily"

	// SavingsPlanRateFilterAttributeInstanceType is a SavingsPlanRateFilterAttribute enum value
	SavingsPlanRateFilterAttributeInstanceType = "instanceType"

	// SavingsPlanRateFilterAttributeProductDescription is a SavingsPlanRateFilterAttribute enum value
	SavingsPlanRateFilterAttributeProductDescription = "productDescription"

	// SavingsPlanRateFilterAttributeTenancy is a SavingsPlanRateFilterAttribute enum value
	SavingsPlanRateFilterAttributeTenancy = "tenancy"

	// SavingsPlanRateFilterAttributeProductId is a SavingsPlanRateFilterAttribute enum value
	SavingsPlanRateFilterAttributeProductId = "productId"
)

// SavingsPlanRateFilterAttribute_Values returns all elements of the SavingsPlanRateFilterAttribute enum
func SavingsPlanRateFilterAttribute_Values() []string {
	return []string{
		SavingsPlanRateFilterAttributeRegion,
		SavingsPlanRateFilterAttributeInstanceFamily,
		SavingsPlanRateFilterAttributeInstanceType,
		SavingsPlanRateFilterAttributeProductDescription,
		SavingsPlanRateFilterAttributeTenancy,
		SavingsPlanRateFilterAttributeProductId,
	}
}

const (
	// SavingsPlanRateFilterNameRegion is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameRegion = "region"

	// SavingsPlanRateFilterNameInstanceType is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameInstanceType = "instanceType"

	// SavingsPlanRateFilterNameProductDescription is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameProductDescription = "productDescription"

	// SavingsPlanRateFilterNameTenancy is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameTenancy = "tenancy"

	// SavingsPlanRateFilterNameProductType is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameProductType = "productType"

	// SavingsPlanRateFilterNameServiceCode is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameServiceCode = "serviceCode"

	// SavingsPlanRateFilterNameUsageType is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameUsageType = "usageType"

	// SavingsPlanRateFilterNameOperation is a SavingsPlanRateFilterName enum value
	SavingsPlanRateFilterNameOperation = "operation"
)

// SavingsPlanRateFilterName_Values returns all elements of the SavingsPlanRateFilterName enum
func SavingsPlanRateFilterName_Values() []string {
	return []string{
		SavingsPlanRateFilterNameRegion,
		SavingsPlanRateFilterNameInstanceType,
		SavingsPlanRateFilterNameProductDescription,
		SavingsPlanRateFilterNameTenancy,
		SavingsPlanRateFilterNameProductType,
		SavingsPlanRateFilterNameServiceCode,
		SavingsPlanRateFilterNameUsageType,
		SavingsPlanRateFilterNameOperation,
	}
}

const (
	// SavingsPlanRatePropertyKeyRegion is a SavingsPlanRatePropertyKey enum value
	SavingsPlanRatePropertyKeyRegion = "region"

	// SavingsPlanRatePropertyKeyInstanceType is a SavingsPlanRatePropertyKey enum value
	SavingsPlanRatePropertyKeyInstanceType = "instanceType"

	// SavingsPlanRatePropertyKeyInstanceFamily is a SavingsPlanRatePropertyKey enum value
	SavingsPlanRatePropertyKeyInstanceFamily = "instanceFamily"

	// SavingsPlanRatePropertyKeyProductDescription is a SavingsPlanRatePropertyKey enum value
	SavingsPlanRatePropertyKeyProductDescription = "productDescription"

	// SavingsPlanRatePropertyKeyTenancy is a SavingsPlanRatePropertyKey enum value
	SavingsPlanRatePropertyKeyTenancy = "tenancy"
)

// SavingsPlanRatePropertyKey_Values returns all elements of the SavingsPlanRatePropertyKey enum
func SavingsPlanRatePropertyKey_Values() []string {
	return []string{
		SavingsPlanRatePropertyKeyRegion,
		SavingsPlanRatePropertyKeyInstanceType,
		SavingsPlanRatePropertyKeyInstanceFamily,
		SavingsPlanRatePropertyKeyProductDescription,
		SavingsPlanRatePropertyKeyTenancy,
	}
}

const (
	// SavingsPlanRateServiceCodeAmazonEc2 is a SavingsPlanRateServiceCode enum value
	SavingsPlanRateServiceCodeAmazonEc2 = "AmazonEC2"

	// SavingsPlanRateServiceCodeAmazonEcs is a SavingsPlanRateServiceCode enum value
	SavingsPlanRateServiceCodeAmazonEcs = "AmazonECS"

	// SavingsPlanRateServiceCodeAmazonEks is a SavingsPlanRateServiceCode enum value
	SavingsPlanRateServiceCodeAmazonEks = "AmazonEKS"

	// SavingsPlanRateServiceCodeAwslambda is a SavingsPlanRateServiceCode enum value
	SavingsPlanRateServiceCodeAwslambda = "AWSLambda"

	// SavingsPlanRateServiceCodeAmazonSageMaker is a SavingsPlanRateServiceCode enum value
	SavingsPlanRateServiceCodeAmazonSageMaker = "AmazonSageMaker"
)

// SavingsPlanRateServiceCode_Values returns all elements of the SavingsPlanRateServiceCode enum
func SavingsPlanRateServiceCode_Values() []string {
	return []string{
		SavingsPlanRateServiceCodeAmazonEc2,
		SavingsPlanRateServiceCodeAmazonEcs,
		SavingsPlanRateServiceCodeAmazonEks,
		SavingsPlanRateServiceCodeAwslambda,
		SavingsPlanRateServiceCodeAmazonSageMaker,
	}
}

const (
	// SavingsPlanRateUnitHrs is a SavingsPlanRateUnit enum value
	SavingsPlanRateUnitHrs = "Hrs"

	// SavingsPlanRateUnitLambdaGbSecond is a SavingsPlanRateUnit enum value
	SavingsPlanRateUnitLambdaGbSecond = "Lambda-GB-Second"

	// SavingsPlanRateUnitRequest is a SavingsPlanRateUnit enum value
	SavingsPlanRateUnitRequest = "Request"
)

// SavingsPlanRateUnit_Values returns all elements of the SavingsPlanRateUnit enum
func SavingsPlanRateUnit_Values() []string {
	return []string{
		SavingsPlanRateUnitHrs,
		SavingsPlanRateUnitLambdaGbSecond,
		SavingsPlanRateUnitRequest,
	}
}

const (
	// SavingsPlanStatePaymentPending is a SavingsPlanState enum value
	SavingsPlanStatePaymentPending = "payment-pending"

	// SavingsPlanStatePaymentFailed is a SavingsPlanState enum value
	SavingsPlanStatePaymentFailed = "payment-failed"

	// SavingsPlanStateActive is a SavingsPlanState enum value
	SavingsPlanStateActive = "active"

	// SavingsPlanStateRetired is a SavingsPlanState enum value
	SavingsPlanStateRetired = "retired"

	// SavingsPlanStateQueued is a SavingsPlanState enum value
	SavingsPlanStateQueued = "queued"

	// SavingsPlanStateQueuedDeleted is a SavingsPlanState enum value
	SavingsPlanStateQueuedDeleted = "queued-deleted"

	// SavingsPlanStatePendingReturn is a SavingsPlanState enum value
	SavingsPlanStatePendingReturn = "pending-return"

	// SavingsPlanStateReturned is a SavingsPlanState enum value
	SavingsPlanStateReturned = "returned"
)

// SavingsPlanState_Values returns all elements of the SavingsPlanState enum
func SavingsPlanState_Values() []string {
	return []string{
		SavingsPlanStatePaymentPending,
		SavingsPlanStatePaymentFailed,
		SavingsPlanStateActive,
		SavingsPlanStateRetired,
		SavingsPlanStateQueued,
		SavingsPlanStateQueuedDeleted,
		SavingsPlanStatePendingReturn,
		SavingsPlanStateReturned,
	}
}

const (
	// SavingsPlanTypeCompute is a SavingsPlanType enum value
	SavingsPlanTypeCompute = "Compute"

	// SavingsPlanTypeEc2instance is a SavingsPlanType enum value
	SavingsPlanTypeEc2instance = "EC2Instance"

	// SavingsPlanTypeSageMaker is a SavingsPlanType enum value
	SavingsPlanTypeSageMaker = "SageMaker"
)

// SavingsPlanType_Values returns all elements of the SavingsPlanType enum
func SavingsPlanType_Values() []string {
	return []string{
		SavingsPlanTypeCompute,
		SavingsPlanTypeEc2instance,
		SavingsPlanTypeSageMaker,
	}
}

const (
	// SavingsPlansFilterNameRegion is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameRegion = "region"

	// SavingsPlansFilterNameEc2InstanceFamily is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameEc2InstanceFamily = "ec2-instance-family"

	// SavingsPlansFilterNameCommitment is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameCommitment = "commitment"

	// SavingsPlansFilterNameUpfront is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameUpfront = "upfront"

	// SavingsPlansFilterNameTerm is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameTerm = "term"

	// SavingsPlansFilterNameSavingsPlanType is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameSavingsPlanType = "savings-plan-type"

	// SavingsPlansFilterNamePaymentOption is a SavingsPlansFilterName enum value
	SavingsPlansFilterNamePaymentOption = "payment-option"

	// SavingsPlansFilterNameStart is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameStart = "start"

	// SavingsPlansFilterNameEnd is a SavingsPlansFilterName enum value
	SavingsPlansFilterNameEnd = "end"
)

// SavingsPlansFilterName_Values returns all elements of the SavingsPlansFilterName enum
func SavingsPlansFilterName_Values() []string {
	return []string{
		SavingsPlansFilterNameRegion,
		SavingsPlansFilterNameEc2InstanceFamily,
		SavingsPlansFilterNameCommitment,
		SavingsPlansFilterNameUpfront,
		SavingsPlansFilterNameTerm,
		SavingsPlansFilterNameSavingsPlanType,
		SavingsPlansFilterNamePaymentOption,
		SavingsPlansFilterNameStart,
		SavingsPlansFilterNameEnd,
	}
}
