/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ThrowableInformation;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class LoggingEventExt
implements Externalizable {
    private static final long serialVersionUID = 3022264832697160750L;
    private static long startTime = System.currentTimeMillis();
    transient String fqnOfLoggerClass;
    private String threadName;
    private Level level;
    private String message;
    private String formattedMessage;
    private Object[] argumentArray;
    private Logger logger;
    private ThrowableInformation throwableInfo;
    private CallerData[] callerDataArray;
    private Marker marker;
    private long timeStamp;

    public LoggingEventExt() {
    }

    public LoggingEventExt(String fqcn, Logger logger, Level level, String message, Throwable throwable, Object[] argArray) {
        this.fqnOfLoggerClass = fqcn;
        this.logger = logger;
        this.level = level;
        this.message = message;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable);
        }
        this.formattedMessage = argArray != null ? MessageFormatter.arrayFormat((String)message, (Object[])argArray) : message;
        this.timeStamp = System.currentTimeMillis();
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public void setThreadName(String threadName) throws IllegalStateException {
        if (this.threadName != null) {
            throw new IllegalStateException("threadName has been already set");
        }
        this.threadName = threadName;
    }

    public ThrowableInformation getThrowableInformation() {
        return this.throwableInfo;
    }

    public void setThrowableInformation(ThrowableInformation ti) {
        if (this.throwableInfo != null) {
            throw new IllegalStateException("ThrowableInformation has been already set.");
        }
        this.throwableInfo = ti;
    }

    public void prepareForDeferredProcessing() {
        this.getThreadName();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (this.message != null) {
            throw new IllegalStateException("The message for this event has been set already.");
        }
        this.message = message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setLevel(Level level) {
        if (this.level != null) {
            throw new IllegalStateException("The level has been already set for this event.");
        }
        this.level = level;
    }

    public static final long getStartTime() {
        return startTime;
    }

    public CallerData[] getCallerData() {
        if (this.callerDataArray == null && this.fqnOfLoggerClass != null) {
            this.callerDataArray = CallerData.extract(new Throwable(), this.fqnOfLoggerClass);
        }
        return this.callerDataArray;
    }

    public void setCallerInformation(CallerData[] callerDataArray) {
        this.callerDataArray = callerDataArray;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        if (this.marker != null) {
            throw new IllegalStateException("The marker has been already set for this event.");
        }
        this.marker = marker;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.threadName = (String)in.readObject();
        this.message = (String)in.readObject();
        this.formattedMessage = (String)in.readObject();
        int levelInt = in.readInt();
        this.level = Level.toLevel(levelInt);
        String loggerName = (String)in.readObject();
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.threadName != null) {
            out.writeObject(this.threadName);
        } else {
            out.writeObject("noThreadName");
        }
        out.writeObject(this.message);
        out.writeObject(this.formattedMessage);
        out.writeInt(this.level.levelInt);
        out.writeObject(this.logger.getName());
    }
}

