Name:  powerman
Version: 2.3.26
Release: 1%{?dist}

Summary: PowerMan - centralized power control for clusters
License: GPL
Group: Applications/System
Url: http://github.com/chaos/powerman
Source0: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: tcp_wrappers-devel
BuildRequires: libgenders-devel
BuildRequires: curl-devel
BuildRequires: net-snmp-devel
BuildRequires: systemd

%package devel
Requires: %{name} = %{version}-%{release}
Summary: Headers and libraries for developing applications using PowerMan
Group: Development/Libraries

%package libs
Requires: %{name} = %{version}-%{release}
Summary: Libraries for applications using PowerMan
Group: System Environment/Libraries

%description
PowerMan is a tool for manipulating remote power control (RPC) devices from a 
central location. Several RPC varieties are supported natively by PowerMan and 
Expect-like configurability simplifies the addition of new devices.

%description devel
A header file and static library for developing applications using PowerMan.

%description libs
A shared library for applications using PowerMan.

%prep
%setup

%build
%configure \
  --with-genders \
  --with-httppower \
  --with-snmppower \
  --with-tcp-wrappers \
  --with-systemdsystemunitdir=%{_unitdir} \
  --program-prefix=%{?_program_prefix:%{_program_prefix}}
make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT 

%clean
rm -rf $RPM_BUILD_ROOT

%post
/bin/systemctl enable powerman > /dev/null 2>&1 ||:

%post libs
if [ -x /sbin/ldconfig ]; then /sbin/ldconfig %{_libdir}; fi

%preun
if [ "$1" = 0 ]; then
  systemctl stop powerman >/dev/null 2>&1 || :
  systemctl disable powerman > /dev/null 2>&1 || :
fi

%postun
if [ "$1" -ge 1 ]; then
  systemctl try-restart powerman >/dev/null 2>&1 || :
fi

%postun libs
if [ -x /sbin/ldconfig ]; then /sbin/ldconfig %{_libdir}; fi

%files
%defattr(-,root,root,0755)
%doc DISCLAIMER 
%doc COPYING
%doc NEWS
%doc TODO
%{_bindir}/powerman
%{_bindir}/pm
%{_sbindir}/powermand
%{_sbindir}/vpcd
%{_sbindir}/httppower
%{_sbindir}/snmppower
%{_sbindir}/plmpower
%dir %config %{_sysconfdir}/powerman
%{_sysconfdir}/powerman/*.dev
%{_sysconfdir}/powerman/powerman.conf.example
%{_mandir}/*1/*
%{_mandir}/*5/*
%{_mandir}/*8/*
%{_libdir}/stonith/plugins/external/powerman
%{_unitdir}/powerman.service
%{_tmpfilesdir}/powerman.conf

%files devel
%defattr(-,root,root,0755)
%{_includedir}/*
%{_libdir}/*.la
%{_mandir}/*3/*
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files libs
%defattr(-,root,root,0755)
%{_libdir}/*.so.*

%changelog

* Wed Mar 08 2017 Brian J. Murrell <brian.murrell@intel.com> 2.3.25-1
- Move the powerman.spec to the examples dir and rename it to
  powerman_el72.spec to indicate that this spec is just an example
  that works on EL7.2

* Fri Oct 23 2015 Jim Garlick <garlick.jim@gmail.com> 2.3.24-1
- Don't package /var/run/powerman; let systemd manage this directory.

* Fri May 29 2015 Jim Garlick <garlick.jim@gmail.com> 2.3.23-1
- Drop conditional builds as full build works everywhere now, more or less
- Drop AIX library handling conditionals (unused?)

* Fri May 29 2015 Jim Garlick <garlick.jim@gmail.com> 2.3.20-1
- Switch to systemd init

* Tue Feb 14 2006 Ben Woodard <woodard@redhat.com> 1.0.22-3
- Changed /usr/bin to bindir
- Changed /usr/sbin to sbindir
- Added COPYING to list of docs.
- Changed /etc/rc.d/init.d/ to initrddir
- Changed /usr/man to mandir
- Added a fully qualified path to the source file.
- Fixed buildroot
- Added a patch which should fix a fc4 build problem.

* Thu Feb 09 2006 Ben Woodard <woodard@redhat.com> 1.0.22-2
- changed the buildroot to match fedora guidlines
- changed permissions of spec and src files.
- added changelog to spec file
