# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._subscription_client_enums import *


class AcceptOwnershipRequest(msrest.serialization.Model):
    """The parameters required to accept subscription ownership.

    :param properties: Accept subscription ownership request properties.
    :type properties: ~azure.mgmt.subscription.models.AcceptOwnershipRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AcceptOwnershipRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AcceptOwnershipRequestProperties"] = None,
        **kwargs
    ):
        super(AcceptOwnershipRequest, self).__init__(**kwargs)
        self.properties = properties


class AcceptOwnershipRequestProperties(msrest.serialization.Model):
    """Accept subscription ownership request properties.

    All required parameters must be populated in order to send to Azure.

    :param display_name: Required. The friendly name of the subscription.
    :type display_name: str
    :param management_group_id: Management group Id for the subscription.
    :type management_group_id: str
    :param tags: A set of tags. Tags for the subscription.
    :type tags: dict[str, str]
    """

    _validation = {
        'display_name': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'management_group_id': {'key': 'managementGroupId', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        management_group_id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(AcceptOwnershipRequestProperties, self).__init__(**kwargs)
        self.display_name = display_name
        self.management_group_id = management_group_id
        self.tags = tags


class AcceptOwnershipStatusResponse(msrest.serialization.Model):
    """Subscription Accept Ownership Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: Newly created subscription Id.
    :vartype subscription_id: str
    :ivar accept_ownership_state: The accept ownership state of the resource. Possible values
     include: "Pending", "Completed", "Expired".
    :vartype accept_ownership_state: str or ~azure.mgmt.subscription.models.AcceptOwnership
    :ivar billing_owner: UPN of the billing owner.
    :vartype billing_owner: str
    :param subscription_tenant_id: Tenant Id of the subscription.
    :type subscription_tenant_id: str
    :param display_name: The display name of the subscription.
    :type display_name: str
    :param tags: A set of tags. Tags for the subscription.
    :type tags: dict[str, str]
    """

    _validation = {
        'subscription_id': {'readonly': True},
        'accept_ownership_state': {'readonly': True},
        'billing_owner': {'readonly': True},
    }

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'accept_ownership_state': {'key': 'acceptOwnershipState', 'type': 'str'},
        'billing_owner': {'key': 'billingOwner', 'type': 'str'},
        'subscription_tenant_id': {'key': 'subscriptionTenantId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        subscription_tenant_id: Optional[str] = None,
        display_name: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(AcceptOwnershipStatusResponse, self).__init__(**kwargs)
        self.subscription_id = None
        self.accept_ownership_state = None
        self.billing_owner = None
        self.subscription_tenant_id = subscription_tenant_id
        self.display_name = display_name
        self.tags = tags


class BillingAccountPoliciesResponse(msrest.serialization.Model):
    """Billing account policies information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified ID for the policy.
    :vartype id: str
    :ivar name: Policy name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Billing account policies response properties.
    :type properties: ~azure.mgmt.subscription.models.BillingAccountPoliciesResponseProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.subscription.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BillingAccountPoliciesResponseProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["BillingAccountPoliciesResponseProperties"] = None,
        **kwargs
    ):
        super(BillingAccountPoliciesResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class BillingAccountPoliciesResponseProperties(msrest.serialization.Model):
    """Put billing account policies response properties.

    :param service_tenants: Service tenant for the billing account.
    :type service_tenants: list[~azure.mgmt.subscription.models.ServiceTenantResponse]
    :param allow_transfers: Determine if the transfers are allowed for the billing account.
    :type allow_transfers: bool
    """

    _attribute_map = {
        'service_tenants': {'key': 'serviceTenants', 'type': '[ServiceTenantResponse]'},
        'allow_transfers': {'key': 'allowTransfers', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        service_tenants: Optional[List["ServiceTenantResponse"]] = None,
        allow_transfers: Optional[bool] = None,
        **kwargs
    ):
        super(BillingAccountPoliciesResponseProperties, self).__init__(**kwargs)
        self.service_tenants = service_tenants
        self.allow_transfers = allow_transfers


class CanceledSubscriptionId(msrest.serialization.Model):
    """The ID of the canceled subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The ID of the canceled subscription.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CanceledSubscriptionId, self).__init__(**kwargs)
        self.value = None


class EnabledSubscriptionId(msrest.serialization.Model):
    """The ID of the subscriptions that is being enabled.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The ID of the subscriptions that is being enabled.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnabledSubscriptionId, self).__init__(**kwargs)
        self.value = None


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseBody(msrest.serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message.

    :param error: The details of the error.
    :type error: ~azure.mgmt.subscription.models.ErrorResponse
    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorResponse"] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.error = error
        self.code = code
        self.message = message


class GetTenantPolicyListResponse(msrest.serialization.Model):
    """Tenant policy information list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of tenant policies.
    :vartype value: list[~azure.mgmt.subscription.models.GetTenantPolicyResponse]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GetTenantPolicyResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetTenantPolicyListResponse, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GetTenantPolicyResponse(msrest.serialization.Model):
    """Tenant policy Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Policy Id.
    :vartype id: str
    :ivar name: Policy name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Tenant policy properties.
    :type properties: ~azure.mgmt.subscription.models.TenantPolicy
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.subscription.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'TenantPolicy'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["TenantPolicy"] = None,
        **kwargs
    ):
        super(GetTenantPolicyResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class Operation(msrest.serialization.Model):
    """REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.subscription.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.Subscription.
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param description: Localized friendly description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of operations.
    :type value: list[~azure.mgmt.subscription.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PutAliasRequest(msrest.serialization.Model):
    """The parameters required to create a new subscription.

    :param properties: Put alias request properties.
    :type properties: ~azure.mgmt.subscription.models.PutAliasRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'PutAliasRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PutAliasRequestProperties"] = None,
        **kwargs
    ):
        super(PutAliasRequest, self).__init__(**kwargs)
        self.properties = properties


class PutAliasRequestAdditionalProperties(msrest.serialization.Model):
    """Put subscription additional properties.

    :param management_group_id: Management group Id for the subscription.
    :type management_group_id: str
    :param subscription_tenant_id: Tenant Id of the subscription.
    :type subscription_tenant_id: str
    :param subscription_owner_id: Owner Id of the subscription.
    :type subscription_owner_id: str
    :param tags: A set of tags. Tags for the subscription.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'management_group_id': {'key': 'managementGroupId', 'type': 'str'},
        'subscription_tenant_id': {'key': 'subscriptionTenantId', 'type': 'str'},
        'subscription_owner_id': {'key': 'subscriptionOwnerId', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        management_group_id: Optional[str] = None,
        subscription_tenant_id: Optional[str] = None,
        subscription_owner_id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PutAliasRequestAdditionalProperties, self).__init__(**kwargs)
        self.management_group_id = management_group_id
        self.subscription_tenant_id = subscription_tenant_id
        self.subscription_owner_id = subscription_owner_id
        self.tags = tags


class PutAliasRequestProperties(msrest.serialization.Model):
    """Put subscription properties.

    :param display_name: The friendly name of the subscription.
    :type display_name: str
    :param workload: The workload type of the subscription. It can be either Production or DevTest.
     Possible values include: "Production", "DevTest".
    :type workload: str or ~azure.mgmt.subscription.models.Workload
    :param billing_scope: Billing scope of the subscription.
     For CustomerLed and FieldLed -
     /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
     For PartnerLed - /billingAccounts/{billingAccountName}/customers/{customerName}
     For Legacy EA -
     /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}.
    :type billing_scope: str
    :param subscription_id: This parameter can be used to create alias for existing subscription
     Id.
    :type subscription_id: str
    :param reseller_id: Reseller Id.
    :type reseller_id: str
    :param additional_properties: Put alias request additional properties.
    :type additional_properties:
     ~azure.mgmt.subscription.models.PutAliasRequestAdditionalProperties
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'workload': {'key': 'workload', 'type': 'str'},
        'billing_scope': {'key': 'billingScope', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'reseller_id': {'key': 'resellerId', 'type': 'str'},
        'additional_properties': {'key': 'additionalProperties', 'type': 'PutAliasRequestAdditionalProperties'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        workload: Optional[Union[str, "Workload"]] = None,
        billing_scope: Optional[str] = None,
        subscription_id: Optional[str] = None,
        reseller_id: Optional[str] = None,
        additional_properties: Optional["PutAliasRequestAdditionalProperties"] = None,
        **kwargs
    ):
        super(PutAliasRequestProperties, self).__init__(**kwargs)
        self.display_name = display_name
        self.workload = workload
        self.billing_scope = billing_scope
        self.subscription_id = subscription_id
        self.reseller_id = reseller_id
        self.additional_properties = additional_properties


class PutTenantPolicyRequestProperties(msrest.serialization.Model):
    """Put tenant policy request properties.

    :param block_subscriptions_leaving_tenant: Blocks the leaving of subscriptions from user's
     tenant.
    :type block_subscriptions_leaving_tenant: bool
    :param block_subscriptions_into_tenant: Blocks the entering of subscriptions into user's
     tenant.
    :type block_subscriptions_into_tenant: bool
    :param exempted_principals: List of user objectIds that are exempted from the set subscription
     tenant policies for the user's tenant.
    :type exempted_principals: list[str]
    """

    _attribute_map = {
        'block_subscriptions_leaving_tenant': {'key': 'blockSubscriptionsLeavingTenant', 'type': 'bool'},
        'block_subscriptions_into_tenant': {'key': 'blockSubscriptionsIntoTenant', 'type': 'bool'},
        'exempted_principals': {'key': 'exemptedPrincipals', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        block_subscriptions_leaving_tenant: Optional[bool] = None,
        block_subscriptions_into_tenant: Optional[bool] = None,
        exempted_principals: Optional[List[str]] = None,
        **kwargs
    ):
        super(PutTenantPolicyRequestProperties, self).__init__(**kwargs)
        self.block_subscriptions_leaving_tenant = block_subscriptions_leaving_tenant
        self.block_subscriptions_into_tenant = block_subscriptions_into_tenant
        self.exempted_principals = exempted_principals


class RenamedSubscriptionId(msrest.serialization.Model):
    """The ID of the subscriptions that is being renamed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The ID of the subscriptions that is being renamed.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RenamedSubscriptionId, self).__init__(**kwargs)
        self.value = None


class ServiceTenantResponse(msrest.serialization.Model):
    """Billing account service tenant.

    :param tenant_id: Service tenant id.
    :type tenant_id: str
    :param tenant_name: Service tenant name.
    :type tenant_name: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'tenant_name': {'key': 'tenantName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        tenant_name: Optional[str] = None,
        **kwargs
    ):
        super(ServiceTenantResponse, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.tenant_name = tenant_name


class SubscriptionAliasListResult(msrest.serialization.Model):
    """The list of aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of alias.
    :vartype value: list[~azure.mgmt.subscription.models.SubscriptionAliasResponse]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionAliasResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionAliasListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SubscriptionAliasResponse(msrest.serialization.Model):
    """Subscription Information with the alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified ID for the alias resource.
    :vartype id: str
    :ivar name: Alias ID.
    :vartype name: str
    :ivar type: Resource type, Microsoft.Subscription/aliases.
    :vartype type: str
    :param properties: Subscription Alias response properties.
    :type properties: ~azure.mgmt.subscription.models.SubscriptionAliasResponseProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.subscription.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SubscriptionAliasResponseProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["SubscriptionAliasResponseProperties"] = None,
        **kwargs
    ):
        super(SubscriptionAliasResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class SubscriptionAliasResponseProperties(msrest.serialization.Model):
    """Put subscription creation result properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: Newly created subscription Id.
    :vartype subscription_id: str
    :param display_name: The display name of the subscription.
    :type display_name: str
    :param provisioning_state: The provisioning state of the resource. Possible values include:
     "Accepted", "Succeeded", "Failed".
    :type provisioning_state: str or ~azure.mgmt.subscription.models.ProvisioningState
    :ivar accept_ownership_url: Url to accept ownership of the subscription.
    :vartype accept_ownership_url: str
    :ivar accept_ownership_state: The accept ownership state of the resource. Possible values
     include: "Pending", "Completed", "Expired".
    :vartype accept_ownership_state: str or ~azure.mgmt.subscription.models.AcceptOwnership
    :param billing_scope: Billing scope of the subscription.
     For CustomerLed and FieldLed -
     /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
     For PartnerLed - /billingAccounts/{billingAccountName}/customers/{customerName}
     For Legacy EA -
     /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}.
    :type billing_scope: str
    :param workload: The workload type of the subscription. It can be either Production or DevTest.
     Possible values include: "Production", "DevTest".
    :type workload: str or ~azure.mgmt.subscription.models.Workload
    :param reseller_id: Reseller Id.
    :type reseller_id: str
    :param subscription_owner_id: Owner Id of the subscription.
    :type subscription_owner_id: str
    :param management_group_id: The Management Group Id.
    :type management_group_id: str
    :param tags: A set of tags. Tags for the subscription.
    :type tags: dict[str, str]
    """

    _validation = {
        'subscription_id': {'readonly': True},
        'accept_ownership_url': {'readonly': True},
        'accept_ownership_state': {'readonly': True},
    }

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'accept_ownership_url': {'key': 'acceptOwnershipUrl', 'type': 'str'},
        'accept_ownership_state': {'key': 'acceptOwnershipState', 'type': 'str'},
        'billing_scope': {'key': 'billingScope', 'type': 'str'},
        'workload': {'key': 'workload', 'type': 'str'},
        'reseller_id': {'key': 'resellerId', 'type': 'str'},
        'subscription_owner_id': {'key': 'subscriptionOwnerId', 'type': 'str'},
        'management_group_id': {'key': 'managementGroupId', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        provisioning_state: Optional[Union[str, "ProvisioningState"]] = None,
        billing_scope: Optional[str] = None,
        workload: Optional[Union[str, "Workload"]] = None,
        reseller_id: Optional[str] = None,
        subscription_owner_id: Optional[str] = None,
        management_group_id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(SubscriptionAliasResponseProperties, self).__init__(**kwargs)
        self.subscription_id = None
        self.display_name = display_name
        self.provisioning_state = provisioning_state
        self.accept_ownership_url = None
        self.accept_ownership_state = None
        self.billing_scope = billing_scope
        self.workload = workload
        self.reseller_id = reseller_id
        self.subscription_owner_id = subscription_owner_id
        self.management_group_id = management_group_id
        self.tags = tags


class SubscriptionName(msrest.serialization.Model):
    """The new name of the subscription.

    :param subscription_name: New subscription name.
    :type subscription_name: str
    """

    _attribute_map = {
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subscription_name: Optional[str] = None,
        **kwargs
    ):
        super(SubscriptionName, self).__init__(**kwargs)
        self.subscription_name = subscription_name


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.subscription.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.subscription.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TenantPolicy(msrest.serialization.Model):
    """Tenant policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_id: Policy Id.
    :vartype policy_id: str
    :param block_subscriptions_leaving_tenant: Blocks the leaving of subscriptions from user's
     tenant.
    :type block_subscriptions_leaving_tenant: bool
    :param block_subscriptions_into_tenant: Blocks the entering of subscriptions into user's
     tenant.
    :type block_subscriptions_into_tenant: bool
    :param exempted_principals: List of user objectIds that are exempted from the set subscription
     tenant policies for the user's tenant.
    :type exempted_principals: list[str]
    """

    _validation = {
        'policy_id': {'readonly': True},
    }

    _attribute_map = {
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'block_subscriptions_leaving_tenant': {'key': 'blockSubscriptionsLeavingTenant', 'type': 'bool'},
        'block_subscriptions_into_tenant': {'key': 'blockSubscriptionsIntoTenant', 'type': 'bool'},
        'exempted_principals': {'key': 'exemptedPrincipals', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        block_subscriptions_leaving_tenant: Optional[bool] = None,
        block_subscriptions_into_tenant: Optional[bool] = None,
        exempted_principals: Optional[List[str]] = None,
        **kwargs
    ):
        super(TenantPolicy, self).__init__(**kwargs)
        self.policy_id = None
        self.block_subscriptions_leaving_tenant = block_subscriptions_leaving_tenant
        self.block_subscriptions_into_tenant = block_subscriptions_into_tenant
        self.exempted_principals = exempted_principals
