/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.sunraster;

import com.sun.jimi.core.JimiException;
import java.io.DataInputStream;
import java.io.IOException;

class SunRasterHeader {
    public static final int MAGIC_NUMBER = 1504078485;
    public static final int OLD_TYPE = 0;
    public static final int STANDARD_TYPE = 1;
    public static final int BYTE_ENCODED_TYPE = 2;
    public static final int RGB_FORMAT_TYPE = 3;
    public static final int TIFF_FORMAT_TYPE = 4;
    public static final int IFF_FORMAT_TYPE = 5;
    public static final int EXPERIMENTAL_TYPE = 65535;
    public static final int NO_COLOR_MAP = 0;
    public static final int RGB_COLOR_MAP = 1;
    public static final int RAW_COLOR_MAP = 2;
    int MagicNumber;
    int Width;
    int Height;
    int Depth;
    int Length;
    int Type;
    int ColorMapType;
    int ColorMapLength;

    SunRasterHeader(DataInputStream dataInputStream) throws IOException, JimiException {
        this.MagicNumber = dataInputStream.readInt();
        if (this.MagicNumber != 1504078485) {
            throw new JimiException("Wrong Format");
        }
        this.Width = dataInputStream.readInt();
        this.Height = dataInputStream.readInt();
        this.Depth = dataInputStream.readInt();
        this.Length = dataInputStream.readInt();
        if (this.Length == 0) {
            this.Length = this.Width * this.Height * this.Depth;
        }
        this.Type = dataInputStream.readInt();
        if (this.Type == 65535) {
            throw new JimiException("Unsupported Format Subtype");
        }
        this.ColorMapType = dataInputStream.readInt();
        this.ColorMapLength = dataInputStream.readInt();
        if (this.ColorMapType == 0 && this.ColorMapLength != 0) {
            throw new IOException("Corrupted Stream");
        }
        if (this.Depth == 1 && this.ColorMapType != 0 && (this.ColorMapType != 1 || this.ColorMapLength != 6)) {
            throw new IOException("Corrupted Stream");
        }
    }
}

