/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.exolab.castor.gui.QueryHistory;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.JDO;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class QueryAnalyser {
    boolean packFrame = false;

    public QueryAnalyser(String databasename, String dbconfig) {
        MainFrame frame = new MainFrame(databasename, dbconfig);
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: org.exolab.castor.tools.QueryAnalyser <Databasename> <Databaseconfig>");
            System.out.println("Example: org.exolab.castor.tools.QueryAnalyser testdb database.xml");
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new QueryAnalyser(args[0], args[1]);
    }

    private class MainFrame
    extends JFrame {
        QueryHistory qhistory = new QueryHistory();
        Mapping mapping = new Mapping();
        JPanel contentPane;
        BorderLayout borderLayout1 = new BorderLayout();
        DefaultTableModel model;
        JDO jdo;
        String databasename;
        String dbconfig;
        JTabbedPane TabbedPane = new JTabbedPane();
        JToolBar toolbar = new JToolBar();
        JButton btnNext = new JButton();
        JButton btnExit = new JButton();
        JPanel sqlresult = new JPanel();
        JTextPane SQLPane = new JTextPane();
        BorderLayout borderLayout3 = new BorderLayout();
        JTextPane oqlquery = new JTextPane();
        JPanel QueryPanel = new JPanel();
        BorderLayout borderLayout2 = new BorderLayout();
        JScrollPane ResultScrollpane = new JScrollPane();
        JTable ResultTable = new JTable();
        JButton execute = new JButton();
        JScrollPane ErrorScrollPane = new JScrollPane();
        JPanel ErrorPanel = new JPanel();
        JTextPane oqlerror = new JTextPane();
        BorderLayout borderLayout4 = new BorderLayout();
        JButton btnPrevious = new JButton();
        JLabel statusBar = new JLabel();

        public MainFrame(String _databasename, String _dbconfig) {
            this.databasename = _databasename;
            this.dbconfig = _dbconfig;
            this.enableEvents(64L);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            this.contentPane = (JPanel)this.getContentPane();
            this.contentPane.setLayout(this.borderLayout1);
            this.setSize(new Dimension(600, 400));
            this.setTitle("Castor OQL-Ouery Analyser");
            this.sqlresult.setLayout(this.borderLayout3);
            this.oqlquery.setFont(new Font("Dialog", 0, 12));
            this.oqlquery.setToolTipText("create Query here");
            this.QueryPanel.setLayout(this.borderLayout2);
            this.ResultScrollpane.setToolTipText("");
            this.ResultTable.setAutoResizeMode(0);
            this.btnExit.setMaximumSize(new Dimension(50, 39));
            this.btnExit.setMinimumSize(new Dimension(50, 39));
            this.btnExit.setActionCommand("");
            this.btnExit.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/exit.gif")));
            this.btnExit.setMnemonic('0');
            this.btnExit.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.exit();
                }
            });
            this.execute.setMaximumSize(new Dimension(50, 39));
            this.execute.setMinimumSize(new Dimension(50, 39));
            this.execute.setActionCommand("");
            this.execute.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/fire.gif")));
            this.execute.setMnemonic('0');
            this.execute.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.execute_actionPerformed(e);
                }
            });
            this.ErrorPanel.setLayout(this.borderLayout4);
            this.btnPrevious.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.btnPrevious_actionPerformed(e);
                }
            });
            this.btnNext.setMaximumSize(new Dimension(50, 39));
            this.btnNext.setMinimumSize(new Dimension(50, 39));
            this.btnNext.setActionCommand("");
            this.btnNext.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/arrw04e.gif")));
            this.btnNext.setMnemonic('0');
            this.btnNext.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.btnNext_actionPerformed(e);
                }
            });
            this.btnPrevious.setMaximumSize(new Dimension(50, 39));
            this.btnPrevious.setMinimumSize(new Dimension(50, 39));
            this.btnPrevious.setToolTipText("Goto previous Query");
            this.btnPrevious.setIcon(new ImageIcon(cl.getResource("org/exolab/castor/gui/images/arrw04d.gif")));
            this.btnPrevious.setMnemonic('0');
            this.contentPane.add((Component)this.TabbedPane, "Center");
            this.contentPane.add((Component)this.toolbar, "North");
            this.toolbar.add((Component)this.btnExit, null);
            this.toolbar.add((Component)this.execute, null);
            this.toolbar.add((Component)this.btnPrevious, null);
            this.toolbar.add((Component)this.btnNext, null);
            this.contentPane.add((Component)this.statusBar, "South");
            this.TabbedPane.add((Component)this.QueryPanel, "OQL Query");
            this.QueryPanel.add((Component)this.oqlquery, "Center");
            this.TabbedPane.add((Component)this.ResultScrollpane, "Resultset");
            this.TabbedPane.add((Component)this.ErrorScrollPane, "Stacktrace");
            this.ErrorScrollPane.getViewport().add((Component)this.ErrorPanel, null);
            this.ErrorPanel.add((Component)this.oqlerror, "Center");
            this.TabbedPane.add((Component)this.sqlresult, "SQL");
            this.sqlresult.add((Component)this.SQLPane, "Center");
            this.ResultScrollpane.getViewport().add((Component)this.ResultTable, null);
            this.openDB();
            this.statusBar.setText("Database " + this.jdo.getDatabaseName() + " waiting for Queries");
            this.loadHistory();
            this.oqlquery.setText(this.qhistory.GetCurrentQuery());
        }

        protected void processWindowEvent(WindowEvent e) {
            super.processWindowEvent(e);
            if (e.getID() == 201) {
                this.exit();
            }
        }

        void execute_actionPerformed(ActionEvent e) {
            this.performQuery();
        }

        public void performQuery() {
            boolean firstObject = true;
            Vector properties = null;
            this.model = new DefaultTableModel();
            try {
                this.statusBar.setText("performing Query");
                this.clearTabs();
                Database db = this.jdo.getDatabase();
                db.begin();
                this.qhistory.addQuery(this.oqlquery.getText());
                OQLQuery oql = db.getOQLQuery(this.oqlquery.getText());
                Date starttime = new Date();
                QueryResults r = oql.execute((short)0);
                Date endtime = new Date();
                this.statusBar.setText("Query successful, Time: " + (endtime.getTime() - starttime.getTime()) + " ms");
                this.SQLPane.setText(((OQLQueryImpl)oql).getSQL());
                while (r.hasMore()) {
                    Object o = r.next();
                    if (firstObject) {
                        properties = this.getProperties(o);
                        this.FillTableHeader(properties, this.model);
                        firstObject = false;
                    }
                    this.model.addRow(this.fillRow(properties, o));
                }
                db.commit();
                this.ResultTable.setModel(this.model);
                this.ResultTable.repaint();
                this.TabbedPane.setSelectedComponent(this.ResultScrollpane);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.oqlerror.setText(sw.getBuffer().toString());
                this.statusBar.setText(e.getMessage());
            }
        }

        private Vector getProperties(Object o) {
            Vector<Method> properties = new Vector<Method>();
            Method[] ms = o.getClass().getMethods();
            for (int i = 0; i < ms.length; ++i) {
                Method m = ms[i];
                if (!m.getName().startsWith("get") || m.getParameterTypes().length != 0) continue;
                properties.add(m);
            }
            return properties;
        }

        private void FillTableHeader(Vector properties, DefaultTableModel model) {
            Iterator i = properties.iterator();
            boolean col = false;
            while (i.hasNext()) {
                Method m = (Method)i.next();
                model.addColumn(m.getName().substring(3));
            }
        }

        private Vector fillRow(Vector properties, Object o) {
            Vector<Object> results = new Vector<Object>();
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                Object temp = null;
                Method m = (Method)i.next();
                try {
                    temp = m.invoke(o, null);
                }
                catch (Exception ie) {
                    temp = null;
                }
                results.add(temp);
            }
            return results;
        }

        private void openDB() {
            try {
                this.jdo = new JDO();
                this.jdo.setDatabaseName(this.databasename);
                this.jdo.setConfiguration(this.dbconfig);
                this.jdo.setClassLoader(ClassLoader.getSystemClassLoader());
                Database db = this.jdo.getDatabase();
            }
            catch (PersistenceException pe) {
                pe.printStackTrace();
                System.exit(1);
            }
        }

        private void clearTabs() {
            this.oqlerror.setText("");
            this.SQLPane.setText("");
            this.ResultTable.setModel(new DefaultTableModel());
        }

        void btnPrevious_actionPerformed(ActionEvent e) {
            this.clearTabs();
            this.oqlquery.setText(this.qhistory.getPreviousQuery());
            this.TabbedPane.setSelectedComponent(this.QueryPanel);
        }

        void btnNext_actionPerformed(ActionEvent e) {
            this.clearTabs();
            this.oqlquery.setText(this.qhistory.getNextQuery());
            this.TabbedPane.setSelectedComponent(this.QueryPanel);
        }

        public void saveHistory() {
            try {
                FileWriter writer = new FileWriter("queryhistory.xml");
                Marshaller marshaller = new Marshaller(writer);
                marshaller.setMapping(this.mapping);
                marshaller.marshal(this.qhistory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void loadHistory() {
            try {
                Unmarshaller unmarshaller = new Unmarshaller(Class.forName("org.exolab.castor.gui.QueryHistory"));
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                this.mapping.loadMapping(cl.getResource("org/exolab/castor/gui/Queryanlyser.xml"));
                unmarshaller.setMapping(this.mapping);
                FileReader reader = new FileReader("queryhistory.xml");
                this.qhistory = (QueryHistory)unmarshaller.unmarshal(reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void exit() {
            this.saveHistory();
            System.exit(0);
        }
    }
}

